import{s as Oe,n as Pe,o as De}from"../chunks/scheduler.7b8d42e8.js";import{S as Ke,i as et,g as i,s as n,r as p,A as tt,h as o,f as l,c as s,j as Ae,u as r,x as m,k as Le,y as lt,a,v as c,d,t as u,w as M}from"../chunks/index.8a4d5423.js";import{C as A}from"../chunks/CodeBlock.3d203e50.js";import{H as f}from"../chunks/getInferenceSnippets.484b0f4e.js";function at(Ie){let h,P,L,D,b,K,y,Ce="This quick tour is intended for developers who are ready to dive into the code and see examples of how to integrate 🤗 Optimum into their model training and inference workflows.",ee,g,te,J,le,T,$e=`To load a model and run inference with OpenVINO Runtime, you can just replace your <code>AutoModelForXxx</code> class with the corresponding <code>OVModelForXxx</code> class.
If you want to load a PyTorch checkpoint, set <code>export=True</code> to convert your model to the OpenVINO IR (Intermediate Representation).`,ae,w,ne,U,Ge='You can find more examples in the <a href="https://huggingface.co/docs/optimum/intel/inference" rel="nofollow">documentation</a> and in the <a href="https://github.com/huggingface/optimum-intel/tree/main/examples/openvino" rel="nofollow">examples</a>.',se,j,ie,Z,Re="To accelerate inference with ONNX Runtime, 🤗 Optimum uses <em>configuration objects</em> to define parameters for graph optimization and quantization. These objects are then used to instantiate dedicated <em>optimizers</em> and <em>quantizers</em>.",oe,W,ke='Before applying quantization or optimization, first we need to load our model. To load a model and run inference with ONNX Runtime, you can just replace the canonical Transformers <a href="https://huggingface.co/docs/transformers/model_doc/auto#transformers.AutoModel" rel="nofollow"><code>AutoModelForXxx</code></a> class with the corresponding <a href="https://huggingface.co/docs/optimum/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel" rel="nofollow"><code>ORTModelForXxx</code></a> class. If you want to load from a PyTorch checkpoint, set <code>export=True</code> to export your model to the ONNX format.',me,X,pe,x,Ve="Let’s see now how we can apply dynamic quantization with ONNX Runtime:",re,B,ce,v,Ne="In this example, we’ve quantized a model from the Hugging Face Hub, in the same manner we can quantize a model hosted locally by providing the path to the directory containing the model weights. The result from applying the <code>quantize()</code> method is a <code>model_quantized.onnx</code> file that can be used to run inference. Here’s an example of how to load an ONNX Runtime model and generate predictions with it:",de,I,ue,C,He='You can find more examples in the <a href="https://huggingface.co/docs/optimum/onnxruntime/quickstart" rel="nofollow">documentation</a> and in the <a href="https://github.com/huggingface/optimum/tree/main/examples/onnxruntime" rel="nofollow">examples</a>.',Me,$,he,G,fe,R,_e='To train transformers on Habana’s Gaudi processors, 🤗 Optimum provides a <code>GaudiTrainer</code> that is very similar to the 🤗 Transformers <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">Trainer</a>. Here is a simple example:',be,k,ye,V,ze='You can find more examples in the <a href="https://huggingface.co/docs/optimum/habana/quickstart" rel="nofollow">documentation</a> and in the <a href="https://github.com/huggingface/optimum-habana/tree/main/examples" rel="nofollow">examples</a>.',ge,N,Je,H,Qe="The Optimum library handles out of the box the ONNX export of Transformers and Diffusers models!",Te,_,Fe="Exporting a model to ONNX is as simple as",we,z,Ue,Q,Ye="Check out the help for more options:",je,F,Ze,Y,Ee='Check out the <a href="https://huggingface.co/docs/optimum/exporters/onnx/usage_guides/export_a_model" rel="nofollow">documentation</a> for more.',We,E,Xe,S,Se='Optimum integrates with <code>torch.fx</code>, providing as a one-liner several graph transformations. We aim at supporting a better management of <a href="https://huggingface.co/docs/optimum/concept_guides/quantization" rel="nofollow">quantization</a> through <code>torch.fx</code>, both for quantization-aware training (QAT) and post-training quantization (PTQ).',xe,q,qe='Check out the <a href="https://huggingface.co/docs/optimum/torch_fx/usage_guides/optimization" rel="nofollow">documentation</a> and <a href="https://huggingface.co/docs/optimum/torch_fx/package_reference/optimization" rel="nofollow">reference</a> for more!',Be,O,ve;return b=new f({props:{title:"Quick tour",local:"quick-tour",headingTag:"h1"}}),g=new f({props:{title:"Accelerated inference",local:"accelerated-inference",headingTag:"h2"}}),J=new f({props:{title:"OpenVINO",local:"openvino",headingTag:"h4"}}),w=new A({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTJCJTIwZnJvbSUyMG9wdGltdW0uaW50ZWwub3BlbnZpbm8lMjBpbXBvcnQlMjBPVk1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUyMCUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwcGlwZWxpbmUlMEElMEElMjAlMjAlMjMlMjBEb3dubG9hZCUyMGElMjB0b2tlbml6ZXIlMjBhbmQlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBIdWIlMjBhbmQlMjBjb252ZXJ0JTIwdG8lMjBPcGVuVklOTyUyMGZvcm1hdCUwQSUyMCUyMHRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUyMCUyMG1vZGVsX2lkJTIwJTNEJTIwJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIlMEEtJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMkIlMjBtb2RlbCUyMCUzRCUyME9WTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBJTIwJTIwJTIzJTIwUnVuJTIwaW5mZXJlbmNlISUwQSUyMCUyMGNsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciklMEElMjAlMjByZXN1bHRzJTIwJTNEJTIwY2xhc3NpZmllciglMjJIZSdzJTIwYSUyMGRyZWFkZnVsJTIwbWFnaWNpYW4uJTIyKQ==",highlighted:`<span class="hljs-deletion">- from transformers import AutoModelForSequenceClassification</span>
<span class="hljs-addition">+ from optimum.intel.openvino import OVModelForSequenceClassification</span>
  from transformers import AutoTokenizer, pipeline

  # Download a tokenizer and model from the Hub and convert to OpenVINO format
  tokenizer = AutoTokenizer.from_pretrained(model_id)
  model_id = &quot;distilbert-base-uncased-finetuned-sst-2-english&quot;
<span class="hljs-deletion">- model = AutoModelForSequenceClassification.from_pretrained(model_id)</span>
<span class="hljs-addition">+ model = OVModelForSequenceClassification.from_pretrained(model_id, export=True)</span>

  # Run inference!
  classifier = pipeline(&quot;text-classification&quot;, model=model, tokenizer=tokenizer)
  results = classifier(&quot;He&#x27;s a dreadful magician.&quot;)`,wrap:!1}}),j=new f({props:{title:"ONNX Runtime",local:"onnx-runtime",headingTag:"h4"}}),X=new A({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX2NoZWNrcG9pbnQlMjAlM0QlMjAlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiUwQXNhdmVfZGlyZWN0b3J5JTIwJTNEJTIwJTIydG1wJTJGb25ueCUyRiUyMiUwQSUwQSUyMyUyMExvYWQlMjBhJTIwbW9kZWwlMjBmcm9tJTIwdHJhbnNmb3JtZXJzJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyME9OTlglMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50KSUwQW9ydF9tb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQobW9kZWxfY2hlY2twb2ludCUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBJTIzJTIwU2F2ZSUyMHRoZSUyME9OTlglMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW9ydF9tb2RlbC5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBdG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;tmp/onnx/&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load a model from transformers and export it to ONNX</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(model_checkpoint, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save the ONNX model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.save_pretrained(save_directory)`,wrap:!1}}),B=new A({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUuY29uZmlndXJhdGlvbiUyMGltcG9ydCUyMEF1dG9RdWFudGl6YXRpb25Db25maWclMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFF1YW50aXplciUwQSUwQSUyMyUyMERlZmluZSUyMHRoZSUyMHF1YW50aXphdGlvbiUyMG1ldGhvZG9sb2d5JTBBcWNvbmZpZyUyMCUzRCUyMEF1dG9RdWFudGl6YXRpb25Db25maWcuYXJtNjQoaXNfc3RhdGljJTNERmFsc2UlMkMlMjBwZXJfY2hhbm5lbCUzREZhbHNlKSUwQXF1YW50aXplciUyMCUzRCUyME9SVFF1YW50aXplci5mcm9tX3ByZXRyYWluZWQob3J0X21vZGVsKSUwQSUwQSUyMyUyMEFwcGx5JTIwZHluYW1pYyUyMHF1YW50aXphdGlvbiUyMG9uJTIwdGhlJTIwbW9kZWwlMEFxdWFudGl6ZXIucXVhbnRpemUoc2F2ZV9kaXIlM0RzYXZlX2RpcmVjdG9yeSUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> AutoQuantizationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTQuantizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Define the quantization methodology</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>qconfig = AutoQuantizationConfig.arm64(is_static=<span class="hljs-literal">False</span>, per_channel=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = ORTQuantizer.from_pretrained(ort_model)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Apply dynamic quantization on the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer.quantize(save_dir=save_directory, quantization_config=qconfig)`,wrap:!1}}),I=new A({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5JTJDJTIwZmlsZV9uYW1lJTNEJTIybW9kZWxfcXVhbnRpemVkLm9ubnglMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXJlc3VsdHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkklMjBsb3ZlJTIwYnVycml0b3MhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(save_directory, file_name=<span class="hljs-string">&quot;model_quantized.onnx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>results = classifier(<span class="hljs-string">&quot;I love burritos!&quot;</span>)`,wrap:!1}}),$=new f({props:{title:"Accelerated training",local:"accelerated-training",headingTag:"h2"}}),G=new f({props:{title:"Habana",local:"habana",headingTag:"h4"}}),k=new A({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUcmFpbmVyJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMEElMkIlMjBmcm9tJTIwb3B0aW11bS5oYWJhbmElMjBpbXBvcnQlMjBHYXVkaVRyYWluZXIlMkMlMjBHYXVkaVRyYWluaW5nQXJndW1lbnRzJTBBJTBBJTIwJTIwJTIzJTIwRG93bmxvYWQlMjBhJTIwcHJldHJhaW5lZCUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMEh1YiUwQSUyMCUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWHh4LmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEElMEElMjAlMjAlMjMlMjBEZWZpbmUlMjB0aGUlMjB0cmFpbmluZyUyMGFyZ3VtZW50cyUwQS0lMjB0cmFpbmluZ19hcmdzJTIwJTNEJTIwVHJhaW5pbmdBcmd1bWVudHMoJTBBJTJCJTIwdHJhaW5pbmdfYXJncyUyMCUzRCUyMEdhdWRpVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnBhdGglMkZ0byUyRnNhdmUlMkZmb2xkZXIlMkYlMjIlMkMlMEElMkIlMjAlMjAlMjAlMjAlMjB1c2VfaGFiYW5hJTNEVHJ1ZSUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMHVzZV9sYXp5X21vZGUlM0RUcnVlJTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIwZ2F1ZGlfY29uZmlnX25hbWUlM0QlMjJIYWJhbmElMkZiZXJ0LWJhc2UtdW5jYXNlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCklMEElMEElMjAlMjAlMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwdHJhaW5lciUwQS0lMjB0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMkIlMjB0cmFpbmVyJTIwJTNEJTIwR2F1ZGlUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwKSUwQSUwQSUyMCUyMCUyMyUyMFVzZSUyMEhhYmFuYSUyMEdhdWRpJTIwcHJvY2Vzc29yJTIwZm9yJTIwdHJhaW5pbmchJTBBJTIwJTIwdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-deletion">- from transformers import Trainer, TrainingArguments</span>
<span class="hljs-addition">+ from optimum.habana import GaudiTrainer, GaudiTrainingArguments</span>

  # Download a pretrained model from the Hub
  model = AutoModelForXxx.from_pretrained(&quot;bert-base-uncased&quot;)

  # Define the training arguments
<span class="hljs-deletion">- training_args = TrainingArguments(</span>
<span class="hljs-addition">+ training_args = GaudiTrainingArguments(</span>
      output_dir=&quot;path/to/save/folder/&quot;,
<span class="hljs-addition">+     use_habana=True,</span>
<span class="hljs-addition">+     use_lazy_mode=True,</span>
<span class="hljs-addition">+     gaudi_config_name=&quot;Habana/bert-base-uncased&quot;,</span>
      ...
  )

  # Initialize the trainer
<span class="hljs-deletion">- trainer = Trainer(</span>
<span class="hljs-addition">+ trainer = GaudiTrainer(</span>
      model=model,
      args=training_args,
      train_dataset=train_dataset,
      ...
  )

  # Use Habana Gaudi processor for training!
  trainer.train()`,wrap:!1}}),N=new f({props:{title:"Out of the box ONNX export",local:"out-of-the-box-onnx-export",headingTag:"h2"}}),z=new A({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBvbm54JTIwLS1tb2RlbCUyMGdwdDIlMjBncHQyX29ubnglMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> onnx --model gpt2 gpt2_onnx/',wrap:!1}}),F=new A({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBvbm54JTIwLS1oZWxw",highlighted:'optimum-cli <span class="hljs-built_in">export</span> onnx --<span class="hljs-built_in">help</span>',wrap:!1}}),E=new f({props:{title:"torch.fx integration",local:"torchfx-integration",headingTag:"h2"}}),{c(){h=i("meta"),P=n(),L=i("p"),D=n(),p(b.$$.fragment),K=n(),y=i("p"),y.textContent=Ce,ee=n(),p(g.$$.fragment),te=n(),p(J.$$.fragment),le=n(),T=i("p"),T.innerHTML=$e,ae=n(),p(w.$$.fragment),ne=n(),U=i("p"),U.innerHTML=Ge,se=n(),p(j.$$.fragment),ie=n(),Z=i("p"),Z.innerHTML=Re,oe=n(),W=i("p"),W.innerHTML=ke,me=n(),p(X.$$.fragment),pe=n(),x=i("p"),x.textContent=Ve,re=n(),p(B.$$.fragment),ce=n(),v=i("p"),v.innerHTML=Ne,de=n(),p(I.$$.fragment),ue=n(),C=i("p"),C.innerHTML=He,Me=n(),p($.$$.fragment),he=n(),p(G.$$.fragment),fe=n(),R=i("p"),R.innerHTML=_e,be=n(),p(k.$$.fragment),ye=n(),V=i("p"),V.innerHTML=ze,ge=n(),p(N.$$.fragment),Je=n(),H=i("p"),H.textContent=Qe,Te=n(),_=i("p"),_.textContent=Fe,we=n(),p(z.$$.fragment),Ue=n(),Q=i("p"),Q.textContent=Ye,je=n(),p(F.$$.fragment),Ze=n(),Y=i("p"),Y.innerHTML=Ee,We=n(),p(E.$$.fragment),Xe=n(),S=i("p"),S.innerHTML=Se,xe=n(),q=i("p"),q.innerHTML=qe,Be=n(),O=i("p"),this.h()},l(e){const t=tt("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),P=s(e),L=o(e,"P",{}),Ae(L).forEach(l),D=s(e),r(b.$$.fragment,e),K=s(e),y=o(e,"P",{"data-svelte-h":!0}),m(y)!=="svelte-3d25f3"&&(y.textContent=Ce),ee=s(e),r(g.$$.fragment,e),te=s(e),r(J.$$.fragment,e),le=s(e),T=o(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-6jviwr"&&(T.innerHTML=$e),ae=s(e),r(w.$$.fragment,e),ne=s(e),U=o(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1tmum2f"&&(U.innerHTML=Ge),se=s(e),r(j.$$.fragment,e),ie=s(e),Z=o(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-bjfa3x"&&(Z.innerHTML=Re),oe=s(e),W=o(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-a1kook"&&(W.innerHTML=ke),me=s(e),r(X.$$.fragment,e),pe=s(e),x=o(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-e7rpqh"&&(x.textContent=Ve),re=s(e),r(B.$$.fragment,e),ce=s(e),v=o(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-eh7tzg"&&(v.innerHTML=Ne),de=s(e),r(I.$$.fragment,e),ue=s(e),C=o(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-19cbrlu"&&(C.innerHTML=He),Me=s(e),r($.$$.fragment,e),he=s(e),r(G.$$.fragment,e),fe=s(e),R=o(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-8h57ng"&&(R.innerHTML=_e),be=s(e),r(k.$$.fragment,e),ye=s(e),V=o(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-nvdwz8"&&(V.innerHTML=ze),ge=s(e),r(N.$$.fragment,e),Je=s(e),H=o(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1qcigt9"&&(H.textContent=Qe),Te=s(e),_=o(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1oa09xy"&&(_.textContent=Fe),we=s(e),r(z.$$.fragment,e),Ue=s(e),Q=o(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-b35baa"&&(Q.textContent=Ye),je=s(e),r(F.$$.fragment,e),Ze=s(e),Y=o(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-q4y2mt"&&(Y.innerHTML=Ee),We=s(e),r(E.$$.fragment,e),Xe=s(e),S=o(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1psut32"&&(S.innerHTML=Se),xe=s(e),q=o(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-p7b5of"&&(q.innerHTML=qe),Be=s(e),O=o(e,"P",{}),Ae(O).forEach(l),this.h()},h(){Le(h,"name","hf:doc:metadata"),Le(h,"content",nt)},m(e,t){lt(document.head,h),a(e,P,t),a(e,L,t),a(e,D,t),c(b,e,t),a(e,K,t),a(e,y,t),a(e,ee,t),c(g,e,t),a(e,te,t),c(J,e,t),a(e,le,t),a(e,T,t),a(e,ae,t),c(w,e,t),a(e,ne,t),a(e,U,t),a(e,se,t),c(j,e,t),a(e,ie,t),a(e,Z,t),a(e,oe,t),a(e,W,t),a(e,me,t),c(X,e,t),a(e,pe,t),a(e,x,t),a(e,re,t),c(B,e,t),a(e,ce,t),a(e,v,t),a(e,de,t),c(I,e,t),a(e,ue,t),a(e,C,t),a(e,Me,t),c($,e,t),a(e,he,t),c(G,e,t),a(e,fe,t),a(e,R,t),a(e,be,t),c(k,e,t),a(e,ye,t),a(e,V,t),a(e,ge,t),c(N,e,t),a(e,Je,t),a(e,H,t),a(e,Te,t),a(e,_,t),a(e,we,t),c(z,e,t),a(e,Ue,t),a(e,Q,t),a(e,je,t),c(F,e,t),a(e,Ze,t),a(e,Y,t),a(e,We,t),c(E,e,t),a(e,Xe,t),a(e,S,t),a(e,xe,t),a(e,q,t),a(e,Be,t),a(e,O,t),ve=!0},p:Pe,i(e){ve||(d(b.$$.fragment,e),d(g.$$.fragment,e),d(J.$$.fragment,e),d(w.$$.fragment,e),d(j.$$.fragment,e),d(X.$$.fragment,e),d(B.$$.fragment,e),d(I.$$.fragment,e),d($.$$.fragment,e),d(G.$$.fragment,e),d(k.$$.fragment,e),d(N.$$.fragment,e),d(z.$$.fragment,e),d(F.$$.fragment,e),d(E.$$.fragment,e),ve=!0)},o(e){u(b.$$.fragment,e),u(g.$$.fragment,e),u(J.$$.fragment,e),u(w.$$.fragment,e),u(j.$$.fragment,e),u(X.$$.fragment,e),u(B.$$.fragment,e),u(I.$$.fragment,e),u($.$$.fragment,e),u(G.$$.fragment,e),u(k.$$.fragment,e),u(N.$$.fragment,e),u(z.$$.fragment,e),u(F.$$.fragment,e),u(E.$$.fragment,e),ve=!1},d(e){e&&(l(P),l(L),l(D),l(K),l(y),l(ee),l(te),l(le),l(T),l(ae),l(ne),l(U),l(se),l(ie),l(Z),l(oe),l(W),l(me),l(pe),l(x),l(re),l(ce),l(v),l(de),l(ue),l(C),l(Me),l(he),l(fe),l(R),l(be),l(ye),l(V),l(ge),l(Je),l(H),l(Te),l(_),l(we),l(Ue),l(Q),l(je),l(Ze),l(Y),l(We),l(Xe),l(S),l(xe),l(q),l(Be),l(O)),l(h),M(b,e),M(g,e),M(J,e),M(w,e),M(j,e),M(X,e),M(B,e),M(I,e),M($,e),M(G,e),M(k,e),M(N,e),M(z,e),M(F,e),M(E,e)}}}const nt='{"title":"Quick tour","local":"quick-tour","sections":[{"title":"Accelerated inference","local":"accelerated-inference","sections":[{"title":"OpenVINO","local":"openvino","sections":[],"depth":4},{"title":"ONNX Runtime","local":"onnx-runtime","sections":[],"depth":4}],"depth":2},{"title":"Accelerated training","local":"accelerated-training","sections":[{"title":"Habana","local":"habana","sections":[],"depth":4}],"depth":2},{"title":"Out of the box ONNX export","local":"out-of-the-box-onnx-export","sections":[],"depth":2},{"title":"torch.fx integration","local":"torchfx-integration","sections":[],"depth":2}],"depth":1}';function st(Ie){return De(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rt extends Ke{constructor(h){super(),et(this,h,st,at,Oe,{})}}export{rt as component};
