import{s as wt,n as mt,o as rt}from"../chunks/scheduler.85c25b89.js";import{S as jt,i as ct,g as a,s as t,r as U,A as dt,h as y,f as M,c as n,j as Jt,u as T,x as i,k as Ct,y as ut,a as s,v as p,d as o,t as J,w as C}from"../chunks/index.c9bcf812.js";import{C as m}from"../chunks/CodeBlock.c004bd26.js";import{H as w}from"../chunks/getInferenceSnippets.80b657e7.js";function It(ps){let r,Ce,oe,we,j,me,c,os="This guide explains how to add custom model implementations to the <code>optimum/neuron/models/training/</code> directory. Custom models are needed to support distributed training features like tensor parallelism, pipeline parallelism, and sequence parallelism on AWS Trainium devices.",re,d,je,u,ce,I,Js="The <code>NeuronModelMixin</code> class provides core functionality:",de,f,Cs="<li><code>from_pretrained()</code>: Loads regular Transformers weights into custom implementations</li> <li><code>save_pretrained()</code>: Saves sharded checkpoints with consolidation metadata</li> <li>Pipeline parallelism support through <code>PIPELINE_*</code> attributes</li>",ue,A,Ie,h,ws="Transformation specs handle converting weights between:",fe,b,ms="<li>Original Transformers format → Custom parallel format (during loading)</li> <li>Custom parallel format → Original Transformers format (during checkpoint consolidation)</li>",Ae,Z,rs="Key transformation spec types:",he,_,js="<li><code>FusedLinearsSpec</code>: Handles fused linear layers (e.g., <code>gate_up_proj</code>)</li> <li><code>GQAQKVColumnParallelLinearSpec</code>: Handles grouped query attention projections when the tensor parallel size is greater than the number of key-value heads</li>",be,W,cs='For complete API documentation of all transformation specs and utility functions, see the <a href="../training_api/transformations">Model Weight Transformation Specs API Reference</a>.',Ze,g,_e,V,ds="Use these parallel layers from <code>neuronx_distributed</code>:",We,B,us="<li><code>ColumnParallelLinear</code>: Splits weight matrix along output dimension</li> <li><code>RowParallelLinear</code>: Splits weight matrix along input dimension</li> <li><code>ParallelEmbedding</code>: Splits embedding table across ranks</li> <li><code>GQAQKVColumnParallelLinear</code>: Specialized for grouped query attention projections when the tensor parallel size is greater than the number of key-value heads</li>",ge,k,Ve,G,Be,X,Is="Create a new directory: <code>optimum/neuron/models/training/your_model/</code>",ke,v,fs="<strong><code>__init__.py</code></strong>",Ge,R,Xe,$,ve,Q,As="<strong><code>modeling_your_model.py</code></strong>",Re,N,$e,F,Qe,Y,Ne,x,Fe,E,Ye,z,hs="<strong>Important</strong>: Any module that has transformation specs must inherit from <code>CustomModule</code> to ensure proper handling of weight transformations, and the transformation specs must be defined in the <code>self.specs</code> attribute.",xe,S,Ee,L,ze,H,bs="The attention layer implementation depends on the model’s architecture and tensor parallel configuration. There are three main variants:",Se,q,Zs="<strong>1. Separate Q, K, V Projections (Default)</strong>",Le,P,He,K,_s="<strong>2. Fused QKV Projection (Multi-Head Attention)</strong>",qe,D,Pe,O,Ws="<strong>3. GQA QKV Projection (Required for Challenging TP Configurations)</strong>",Ke,ll,De,el,gs="<strong>When to Use Each Variant:</strong>",Oe,Ml,Vs="<li><strong>Separate Q, K, V</strong>: Default approach, works for all configurations but may be less efficient</li> <li><strong>Fused QKV</strong>: Use when <code>num_heads == num_key_value_heads</code> (no grouped query attention) and <code>fuse_qkv=True</code></li> <li><strong>GQA QKV</strong>: Required when using grouped query attention with challenging tensor parallel configurations where KV heads cannot be evenly distributed across TP ranks</li>",lM,sl,Bs="The choice is typically determined by:",eM,tl,MM,nl,sM,al,tM,yl,nM,il,aM,Ul,yM,Tl,iM,pl,ks="Update <code>optimum/neuron/models/training/__init__.py</code>:",UM,ol,TM,Jl,Gs="Update <code>optimum/neuron/models/training/auto_models.py</code>:",pM,Cl,oM,wl,Xs="Here <code>&quot;your_model&quot;</code> is the corresponding to the <code>model_type</code> attribute of your model’s configuration class.",JM,ml,CM,rl,wM,jl,vs="<li>Use <code>gather_output=False</code> for intermediate layers</li> <li>Set <code>input_is_parallel=True</code> for layers that receive parallel input</li> <li>Configure <code>sequence_parallel_enabled</code> consistently across layers</li> <li>Use appropriate <code>stride</code> values for proper weight sharding</li>",mM,cl,rM,dl,Rs="<li>Always define specs for modules that use fused or parallel layers</li> <li>Use <code>CustomModule</code> mixin for any module with transformation specs</li> <li>Ensure spec parameter names match the actual module structure</li> <li>Test both regular and LoRA weight transformations</li>",jM,ul,cM,Il,$s="<li>Set <code>SUPPORTS_PIPELINE_PARALLELISM = True</code> for supported models</li> <li>Define <code>PIPELINE_TRANSFORMER_LAYER_CLS</code> as your decoder layer class</li> <li>List all input names in <code>PIPELINE_INPUT_NAMES</code></li>",dM,fl,uM,Al,Qs="<li>Set <code>_supports_flash_attn_2 = True</code> if your model supports it</li> <li>Implement both eager and flash attention paths</li> <li>Use appropriate attention function dispatching</li>",IM,hl,fM,bl,Ns=`The training tests in <code>tests/training/</code> provide a comprehensive testing framework that validates numerical correctness, distributed training scenarios, and checkpoint compatibility.
Most of the tests are not designed to be run on every custom modeling implementation, but rather to validate the core functionality of the Optimum Neuron training infrastructure.
With that in mind, here’s what you need to implement for your custom modeling:`,AM,Zl,hM,_l,Fs="The <code>test_custom_modeling.py</code> file validates that your custom implementation produces identical outputs to the original Transformers model:",bM,Wl,Ys="Update <code>tests/training/test_custom_modeling.py</code>:",ZM,gl,_M,Vl,xs="<strong>Important</strong>: For custom modeling validation tests, use small/tiny models to ensure CI efficiency. The test models should have:",WM,Bl,Es="<li>Small vocabulary size (e.g., 1000-8000 tokens)</li> <li>Few layers (e.g., 2-4 layers)</li> <li>Small hidden dimensions (e.g., 128-512)</li> <li>Minimal attention heads (e.g., 4-8 heads)</li>",gM,kl,zs="Examples of good test models for custom modeling validation:",VM,Gl,Ss="<li><code>&quot;michaelbenayoun/llama-2-tiny-4kv-heads-4layers-random&quot;</code> - 4 layers, 4 KV heads</li> <li><code>&quot;michaelbenayoun/granite-tiny-4kv-heads-4layers-random&quot;</code> - Tiny Granite model</li> <li><code>&quot;michaelbenayoun/qwen3-tiny-4kv-heads-4layers-random&quot;</code> - Tiny Qwen3 model</li>",BM,Xl,Ls="Key test your model must pass:",kM,vl,GM,Rl,Hs="<li><strong>Numerical Correctness</strong>: Ensures custom models match Transformers outputs exactly</li> <li><strong>Parallelization Support</strong>: Tests various QKV implementations (regular, fused, GQA)</li>",XM,$l,vM,Ql,qs="The <code>test_overfit.py</code> file validates training convergence. To include your model in end-to-end training validation, you must add it to the parametrized test cases:",RM,Nl,Ps="Update <code>tests/training/test_overfit.py</code>:",$M,Fl,QM,Yl,Ks="This validates:",NM,xl,Ds="<li><strong>Convergence Validation</strong>: Ensures models can overfit simple datasets</li>",FM,El,Os="Your model will be tested in:",YM,zl,xM,Sl,EM,Ll,lt="The <code>test_modeling_auto.py</code> file validates that your model can be loaded using the <code>NeuronModel</code> and <code>NeuronModelForCausalLM</code> auto classes. To include your model in these tests, you must add it to the test cases:",zM,Hl,et="Update <code>tests/training/test_modeling_auto.py</code>:",SM,ql,LM,Pl,Mt="This validates:",HM,Kl,st="<li><strong>Auto Model Loading</strong>: Tests that <code>NeuronModel.from_pretrained()</code> and <code>NeuronModel.from_config()</code> work correctly</li> <li><strong>Auto CausalLM Loading</strong>: Tests that <code>NeuronModelForCausalLM.from_pretrained()</code> and <code>NeuronModelForCausalLM.from_config()</code> work correctly</li>",qM,Dl,PM,Ol,tt="Tests require AWS Trainium instances. Run specific test categories:",KM,le,DM,ee,OM,Me,nt="Your implementation must:",ls,se,at="<li><strong>Pass numerical correctness tests</strong> against original Transformers implementation</li> <li><strong>Support parallelization strategies</strong> (at minimum DP and TP; PP support recommended)</li> <li><strong>Handle various QKV implementations</strong> (regular, fused, GQA)</li> <li><strong>Support checkpoint consolidation</strong> for distributed training</li> <li><strong>Support LoRA training</strong> if applicable</li> <li><strong>Demonstrate convergence</strong> through overfitting tests</li>",es,te,yt="The testing framework ensures your custom model maintains compatibility with the existing Optimum Neuron training infrastructure while delivering expected performance and correctness guarantees.",Ms,ne,ss,ae,it="<li><strong>Weight Shape Mismatches</strong>: Ensure transformation specs handle tensor shapes correctly</li> <li><strong>Pipeline Parallelism Errors</strong>: Check that all required attributes are set</li> <li><strong>Memory Issues</strong>: Consider gradient checkpointing and activation recomputation</li> <li><strong>Attention Compatibility</strong>: Verify attention implementations work with your model architecture</li>",ts,ye,ns,ie,Ut="This guide provides the foundation for implementing custom models. For complete examples and advanced patterns, reference these existing implementations:",as,Ue,Tt="<li><strong>LLaMA</strong>: <code>optimum/neuron/models/training/llama/modeling_llama.py</code> - Complete implementation with (regular, fused and GQA attention), fused MLP</li> <li><strong>Qwen3</strong>: <code>optimum/neuron/models/training/qwen3/modeling_qwen3.py</code> - Demonstrates how to adapt the Llama implementation for Qwen3 with <code>q_norm</code> and <code>k_norm</code> layers</li>",ys,Te,pt="Key files to study:",is,pe,ot="<li><code>optimum/neuron/models/training/modeling_utils.py</code> - Base <code>NeuronModelMixin</code> class</li> <li><code>optimum/neuron/models/training/transformations_utils.py</code> - Weight transformation specifications</li> <li><code>optimum/neuron/models/training/config.py</code> - <code>TrainingNeuronConfig</code> for parallelism settings</li>",Us,Je,Ts;return j=new w({props:{title:"Contributing Custom Models for Training",local:"contributing-custom-models-for-training",headingTag:"h1"}}),d=new w({props:{title:"Architecture Components",local:"architecture-components",headingTag:"h2"}}),u=new w({props:{title:"1. NeuronModelMixin",local:"1-neuronmodelmixin",headingTag:"h3"}}),A=new w({props:{title:"2. Weight Transformation Specs",local:"2-weight-transformation-specs",headingTag:"h3"}}),g=new w({props:{title:"3. Parallel Layers",local:"3-parallel-layers",headingTag:"h3"}}),k=new w({props:{title:"Implementation Steps",local:"implementation-steps",headingTag:"h2"}}),G=new w({props:{title:"Step 1: Create Model Structure",local:"step-1-create-model-structure",headingTag:"h3"}}),R=new m({props:{code:"ZnJvbSUyMC5tb2RlbGluZ195b3VyX21vZGVsJTIwaW1wb3J0JTIwWW91ck1vZGVsRm9yQ2F1c2FsTE0lMkMlMjBZb3VyTW9kZWwlMEElMEFfX2FsbF9fJTIwJTNEJTIwJTVCJTIyWW91ck1vZGVsRm9yQ2F1c2FsTE0lMjIlMkMlMjAlMjJZb3VyTW9kZWwlMjIlNUQ=",highlighted:`<span class="hljs-keyword">from</span> .modeling_your_model <span class="hljs-keyword">import</span> YourModelForCausalLM, YourModel

__all__ = [<span class="hljs-string">&quot;YourModelForCausalLM&quot;</span>, <span class="hljs-string">&quot;YourModel&quot;</span>]`,wrap:!1}}),$=new w({props:{title:"Step 2: Implement the Model Building Blocks",local:"step-2-implement-the-model-building-blocks",headingTag:"h3"}}),N=new w({props:{title:"Imports and Dependencies",local:"imports-and-dependencies",headingTag:"h4"}}),F=new m({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2glMjBpbXBvcnQlMjBubiUwQWZyb20lMjBuZXVyb254X2Rpc3RyaWJ1dGVkLnBhcmFsbGVsX2xheWVycy5sYXllcnMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ29sdW1uUGFyYWxsZWxMaW5lYXIlMkMlMEElMjAlMjAlMjAlMjBSb3dQYXJhbGxlbExpbmVhciUyQyUwQSUyMCUyMCUyMCUyMFBhcmFsbGVsRW1iZWRkaW5nJTJDJTBBKSUwQWZyb20lMjBuZXVyb254X2Rpc3RyaWJ1dGVkLm1vZHVsZXMucWt2X2xpbmVhciUyMGltcG9ydCUyMEdRQVFLVkNvbHVtblBhcmFsbGVsTGluZWFyJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMubW9kZWxzLnlvdXJfbW9kZWwlMjBpbXBvcnQlMjBZb3VyTW9kZWxDb25maWclMEElMEFmcm9tJTIwLi5jb25maWclMjBpbXBvcnQlMjBUcmFpbmluZ05ldXJvbkNvbmZpZyUwQWZyb20lMjAuLm1vZGVsaW5nX3V0aWxzJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxNaXhpbiUwQWZyb20lMjAuLnRyYW5zZm9ybWF0aW9uc191dGlscyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBDdXN0b21Nb2R1bGUlMkMlMEElMjAlMjAlMjAlMjBGdXNlZExpbmVhcnNTcGVjJTJDJTBBJTIwJTIwJTIwJTIwR1FBUUtWQ29sdW1uUGFyYWxsZWxMaW5lYXJTcGVjJTJDJTBBJTIwJTIwJTIwJTIwTW9kZWxXZWlnaHRUcmFuc2Zvcm1hdGlvblNwZWNzJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> neuronx_distributed.parallel_layers.layers <span class="hljs-keyword">import</span> (
    ColumnParallelLinear,
    RowParallelLinear,
    ParallelEmbedding,
)
<span class="hljs-keyword">from</span> neuronx_distributed.modules.qkv_linear <span class="hljs-keyword">import</span> GQAQKVColumnParallelLinear
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> transformers.models.your_model <span class="hljs-keyword">import</span> YourModelConfig

<span class="hljs-keyword">from</span> ..config <span class="hljs-keyword">import</span> TrainingNeuronConfig
<span class="hljs-keyword">from</span> ..modeling_utils <span class="hljs-keyword">import</span> NeuronModelMixin
<span class="hljs-keyword">from</span> ..transformations_utils <span class="hljs-keyword">import</span> (
    CustomModule,
    FusedLinearsSpec,
    GQAQKVColumnParallelLinearSpec,
    ModelWeightTransformationSpecs,
)`,wrap:!1}}),Y=new w({props:{title:"Embedding Layer",local:"embedding-layer",headingTag:"h4"}}),x=new m({props:{code:"Y2xhc3MlMjBZb3VyTW9kZWxFbWJlZGRpbmdzKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnJTJDJTIwdHJuX2NvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmVtYmVkX3Rva2VucyUyMCUzRCUyMFBhcmFsbGVsRW1iZWRkaW5nKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy52b2NhYl9zaXplJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29uZmlnLmhpZGRlbl9zaXplJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHR5cGUlM0Rjb25maWcudG9yY2hfZHR5cGUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZXF1ZW5jZV9wYXJhbGxlbF9lbmFibGVkJTNEdHJuX2NvbmZpZy5zZXF1ZW5jZV9wYXJhbGxlbF9lbmFibGVkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">YourModelEmbeddings</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config, trn_config</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.embed_tokens = ParallelEmbedding(
            config.vocab_size,
            config.hidden_size,
            dtype=config.torch_dtype,
            sequence_parallel_enabled=trn_config.sequence_parallel_enabled,
        )`,wrap:!1}}),E=new w({props:{title:"MLP Layer with Fused Linears",local:"mlp-layer-with-fused-linears",headingTag:"h4"}}),S=new m({props:{code:"Y2xhc3MlMjBZb3VyTW9kZWxNTFAobm4uTW9kdWxlJTJDJTIwQ3VzdG9tTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBjb25maWclMkMlMjB0cm5fY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaGlkZGVuX3NpemUlMjAlM0QlMjBjb25maWcuaGlkZGVuX3NpemUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmludGVybWVkaWF0ZV9zaXplJTIwJTNEJTIwY29uZmlnLmludGVybWVkaWF0ZV9zaXplJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRnVzZWQlMjBnYXRlJTIwYW5kJTIwdXAlMjBwcm9qZWN0aW9ucyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZ2F0ZV91cF9wcm9qJTIwJTNEJTIwQ29sdW1uUGFyYWxsZWxMaW5lYXIoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5oaWRkZW5fc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIlMjAqJTIwc2VsZi5pbnRlcm1lZGlhdGVfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0cmlkZSUzRDIlMkMlMjAlMjAlMjMlMjBJbXBvcnRhbnQlMjBmb3IlMjBwcm9wZXIlMjBzaGFyZGluZyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJpYXMlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdhdGhlcl9vdXRwdXQlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlcXVlbmNlX3BhcmFsbGVsX2VuYWJsZWQlM0R0cm5fY29uZmlnLnNlcXVlbmNlX3BhcmFsbGVsX2VuYWJsZWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGNvbmZpZy50b3JjaF9kdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmRvd25fcHJvaiUyMCUzRCUyMFJvd1BhcmFsbGVsTGluZWFyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaW50ZXJtZWRpYXRlX3NpemUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmhpZGRlbl9zaXplJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmlhcyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfaXNfcGFyYWxsZWwlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VxdWVuY2VfcGFyYWxsZWxfZW5hYmxlZCUzRHRybl9jb25maWcuc2VxdWVuY2VfcGFyYWxsZWxfZW5hYmxlZCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGR0eXBlJTNEY29uZmlnLnRvcmNoX2R0eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMERlZmluZSUyMHRyYW5zZm9ybWF0aW9uJTIwc3BlY3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnNwZWNzJTIwJTNEJTIwTW9kZWxXZWlnaHRUcmFuc2Zvcm1hdGlvblNwZWNzKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnNwZWNzLmFkZF9zcGVjKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZ1c2VkTGluZWFyc1NwZWMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZnVzZWRfbGluZWFyX25hbWUlM0QlMjJnYXRlX3VwX3Byb2olMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsaW5lYXJfbmFtZXMlM0QlNUIlMjJnYXRlX3Byb2olMjIlMkMlMjAlMjJ1cF9wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmlhcyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZnVzZV9heGlzJTNEJTIyY29sdW1uJTIyJTJDJTIwJTIwJTIzJTIwRnVzZSUyMGFsb25nJTIwb3V0cHV0JTIwZGltZW5zaW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3JpZ2luYWxfZGltcyUzRCU1QnNlbGYuaW50ZXJtZWRpYXRlX3NpemUlMkMlMjBzZWxmLmludGVybWVkaWF0ZV9zaXplJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">YourModelMLP</span>(nn.Module, CustomModule):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config, trn_config</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.hidden_size = config.hidden_size
        self.intermediate_size = config.intermediate_size
        
        <span class="hljs-comment"># Fused gate and up projections</span>
        self.gate_up_proj = ColumnParallelLinear(
            self.hidden_size,
            <span class="hljs-number">2</span> * self.intermediate_size,
            stride=<span class="hljs-number">2</span>,  <span class="hljs-comment"># Important for proper sharding</span>
            bias=<span class="hljs-literal">False</span>,
            gather_output=<span class="hljs-literal">False</span>,
            sequence_parallel_enabled=trn_config.sequence_parallel_enabled,
            dtype=config.torch_dtype,
        )
        
        self.down_proj = RowParallelLinear(
            self.intermediate_size,
            self.hidden_size,
            bias=<span class="hljs-literal">False</span>,
            input_is_parallel=<span class="hljs-literal">True</span>,
            sequence_parallel_enabled=trn_config.sequence_parallel_enabled,
            dtype=config.torch_dtype,
        )
        
        <span class="hljs-comment"># Define transformation specs</span>
        self.specs = ModelWeightTransformationSpecs()
        self.specs.add_spec(
            FusedLinearsSpec(
                fused_linear_name=<span class="hljs-string">&quot;gate_up_proj&quot;</span>,
                linear_names=[<span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>],
                bias=<span class="hljs-literal">False</span>,
                fuse_axis=<span class="hljs-string">&quot;column&quot;</span>,  <span class="hljs-comment"># Fuse along output dimension</span>
                original_dims=[self.intermediate_size, self.intermediate_size],
            )
        )`,wrap:!1}}),L=new w({props:{title:"Attention Layer",local:"attention-layer",headingTag:"h4"}}),P=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">YourModelAttention</span>(nn.Module, CustomModule):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config, trn_config, layer_idx</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.config = config
        self.num_heads = config.num_attention_heads
        self.num_key_value_heads = config.num_key_value_heads
        self.head_dim = config.hidden_size // self.num_heads
        
        <span class="hljs-comment"># Separate projections for Q, K, V</span>
        self.q_proj = ColumnParallelLinear(
            config.hidden_size,
            self.num_heads * self.head_dim,
            bias=<span class="hljs-literal">False</span>,
            gather_output=<span class="hljs-literal">False</span>,
            sequence_parallel_enabled=trn_config.sequence_parallel_enabled,
            dtype=config.torch_dtype,
        )
        self.k_proj = ColumnParallelLinear(
            config.hidden_size,
            self.num_key_value_heads * self.head_dim,
            bias=<span class="hljs-literal">False</span>,
            gather_output=<span class="hljs-literal">False</span>,
            sequence_parallel_enabled=trn_config.sequence_parallel_enabled,
            dtype=config.torch_dtype,
        )
        self.v_proj = ColumnParallelLinear(
            config.hidden_size,
            self.num_key_value_heads * self.head_dim,
            bias=<span class="hljs-literal">False</span>,
            gather_output=<span class="hljs-literal">False</span>,
            sequence_parallel_enabled=trn_config.sequence_parallel_enabled,
            dtype=config.torch_dtype,
        )
        
        self.o_proj = RowParallelLinear(
            self.num_heads * self.head_dim,
            config.hidden_size,
            bias=<span class="hljs-literal">False</span>,
            input_is_parallel=<span class="hljs-literal">True</span>,
            sequence_parallel_enabled=trn_config.sequence_parallel_enabled,
            dtype=config.torch_dtype,
        )
        
        <span class="hljs-comment"># No transformation specs needed - regular parallel layers</span>
        self.specs = ModelWeightTransformationSpecs()`,wrap:!1}}),D=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">YourModelAttention</span>(nn.Module, CustomModule):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config, trn_config, layer_idx</span>):
        <span class="hljs-built_in">super</span>().__init__()
        <span class="hljs-comment"># ... (same setup as above)</span>
        
        tp_size = get_tensor_model_parallel_size()
        
        <span class="hljs-comment"># Only use fused QKV when num_heads == num_key_value_heads (no GQA)</span>
        <span class="hljs-keyword">if</span> trn_config.fuse_qkv <span class="hljs-keyword">and</span> self.num_heads == self.num_key_value_heads:
            self.qkv_proj = ColumnParallelLinear(
                config.hidden_size,
                <span class="hljs-number">3</span> * self.num_heads * self.head_dim,  <span class="hljs-comment"># Q + K + V</span>
                stride=<span class="hljs-number">3</span>,  <span class="hljs-comment"># Important for proper sharding</span>
                bias=<span class="hljs-literal">False</span>,
                gather_output=<span class="hljs-literal">False</span>,
                sequence_parallel_enabled=trn_config.sequence_parallel_enabled,
                dtype=config.torch_dtype,
            )
            
            <span class="hljs-comment"># Define transformation specs for fused QKV</span>
            self.specs = ModelWeightTransformationSpecs()
            self.specs.add_spec(
                FusedLinearsSpec(
                    fused_linear_name=<span class="hljs-string">&quot;qkv_proj&quot;</span>,
                    linear_names=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>],
                    bias=<span class="hljs-literal">False</span>,
                    fuse_axis=<span class="hljs-string">&quot;column&quot;</span>,
                    original_dims=[self.num_heads * self.head_dim] * <span class="hljs-number">3</span>,
                )
            )
            self.split_size = self.num_heads * self.head_dim // tp_size`,wrap:!1}}),ll=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">YourModelAttention</span>(nn.Module, CustomModule):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config, trn_config, layer_idx</span>):
        <span class="hljs-built_in">super</span>().__init__()
        <span class="hljs-comment"># ... (same setup as above)</span>
        
        tp_size = get_tensor_model_parallel_size()
        
        <span class="hljs-comment"># Use GQA QKV when KV heads can&#x27;t be evenly distributed across TP ranks</span>
        <span class="hljs-comment"># This happens when: num_key_value_heads &lt; tp_size or num_key_value_heads % tp_size != 0</span>
        self.qkv_linear = (self.num_key_value_heads &lt; tp_size) <span class="hljs-keyword">or</span> (self.num_key_value_heads % tp_size != <span class="hljs-number">0</span>)
        
        <span class="hljs-keyword">if</span> self.qkv_linear:
            <span class="hljs-comment"># Calculate KV size multiplier to ensure even distribution</span>
            <span class="hljs-keyword">if</span> trn_config.kv_size_multiplier <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
                self.kv_size_multiplier = trn_config.auto_kv_size_multiplier(self.num_key_value_heads)
            <span class="hljs-keyword">else</span>:
                self.kv_size_multiplier = trn_config.kv_size_multiplier
                
            self.qkv_proj = GQAQKVColumnParallelLinear(
                config.hidden_size,
                [self.num_heads * self.head_dim, self.num_key_value_heads * self.head_dim],
                bias=<span class="hljs-literal">False</span>,
                gather_output=<span class="hljs-literal">False</span>,
                sequence_parallel_enabled=trn_config.sequence_parallel_enabled,
                kv_size_multiplier=self.kv_size_multiplier,
                fuse_qkv=trn_config.fuse_qkv,
                dtype=config.torch_dtype,
            )
            
            <span class="hljs-comment"># Define transformation specs for GQA QKV</span>
            self.specs = ModelWeightTransformationSpecs()
            self.specs.add_spec(
                GQAQKVColumnParallelLinearSpec(
                    gqa_qkv_projection_name=<span class="hljs-string">&quot;qkv_proj&quot;</span>,
                    query_projection_name=<span class="hljs-string">&quot;q_proj&quot;</span>,
                    key_projection_name=<span class="hljs-string">&quot;k_proj&quot;</span>, 
                    value_projection_name=<span class="hljs-string">&quot;v_proj&quot;</span>,
                    output_projection_name=<span class="hljs-string">&quot;o_proj&quot;</span>,
                    num_attention_heads=self.num_heads,
                    num_key_value_heads=self.num_key_value_heads,
                    kv_size_multiplier=self.kv_size_multiplier,
                    q_output_size_per_partition=self.qkv_proj.q_output_size_per_partition,
                    kv_output_size_per_partition=self.qkv_proj.kv_output_size_per_partition,
                    fuse_qkv=trn_config.fuse_qkv,
                )
            )`,wrap:!1}}),tl=new m({props:{code:"dHBfc2l6ZSUyMCUzRCUyMGdldF90ZW5zb3JfbW9kZWxfcGFyYWxsZWxfc2l6ZSgpJTBBdXNlX2dxYV9xa3YlMjAlM0QlMjAobnVtX2tleV92YWx1ZV9oZWFkcyUyMCUzQyUyMHRwX3NpemUpJTIwb3IlMjAobnVtX2tleV92YWx1ZV9oZWFkcyUyMCUyNSUyMHRwX3NpemUlMjAhJTNEJTIwMCklMEF1c2VfZnVzZWRfcWt2JTIwJTNEJTIwdHJuX2NvbmZpZy5mdXNlX3FrdiUyMGFuZCUyMChudW1faGVhZHMlMjAlM0QlM0QlMjBudW1fa2V5X3ZhbHVlX2hlYWRzKSUyMGFuZCUyMG5vdCUyMHVzZV9ncWFfcWt2",highlighted:`tp_size = get_tensor_model_parallel_size()
use_gqa_qkv = (num_key_value_heads &lt; tp_size) <span class="hljs-keyword">or</span> (num_key_value_heads % tp_size != <span class="hljs-number">0</span>)
use_fused_qkv = trn_config.fuse_qkv <span class="hljs-keyword">and</span> (num_heads == num_key_value_heads) <span class="hljs-keyword">and</span> <span class="hljs-keyword">not</span> use_gqa_qkv`,wrap:!1}}),nl=new w({props:{title:"Step 3: Implement Main Model Classes",local:"step-3-implement-main-model-classes",headingTag:"h3"}}),al=new w({props:{title:"Base Model",local:"base-model",headingTag:"h4"}}),yl=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">YourPreTrainedModel</span>(PreTrainedModel, NeuronModelMixin):
    config_class = YourModelConfig
    base_model_prefix = <span class="hljs-string">&quot;model&quot;</span>
    supports_gradient_checkpointing = <span class="hljs-literal">True</span>
    _no_split_modules = [<span class="hljs-string">&quot;YourModelDecoderLayer&quot;</span>]
    _skip_keys_device_placement = <span class="hljs-string">&quot;past_key_values&quot;</span>
    _supports_flash_attn_2 = <span class="hljs-literal">True</span>
    _supports_cache_class = <span class="hljs-literal">True</span>
    _supports_quantized_cache = <span class="hljs-literal">True</span>
    _supports_static_cache = <span class="hljs-literal">True</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">YourModel</span>(NeuronModelMixin, YourPreTrainedModel):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: YourModelConfig, trn_config: TrainingNeuronConfig</span>):
        YourPreTrainedModel.__init__(self, config)
        self.padding_idx = config.pad_token_id
        self.vocab_size = config.vocab_size

        self.trn_config = trn_config
        
        self.embed_tokens = ParallelEmbedding(...)
        self.layers = nn.ModuleList([
            YourModelDecoderLayer(config, trn_config, layer_idx)
            <span class="hljs-keyword">for</span> layer_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(config.num_hidden_layers)
        ])
        self.norm = YourModelRMSNorm(...)
        
        self.post_init()`,wrap:!1}}),il=new w({props:{title:"CausalLM Model",local:"causallm-model",headingTag:"h4"}}),Ul=new m({props:{code:"Y2xhc3MlMjBZb3VyTW9kZWxGb3JDYXVzYWxMTShOZXVyb25Nb2RlbE1peGluJTJDJTIwWW91clByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBfdGllZF93ZWlnaHRzX2tleXMlMjAlM0QlMjAlNUIlMjJsbV9oZWFkLndlaWdodCUyMiU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFBpcGVsaW5lJTIwcGFyYWxsZWxpc20lMjBzdXBwb3J0JTBBJTIwJTIwJTIwJTIwU1VQUE9SVFNfUElQRUxJTkVfUEFSQUxMRUxJU00lMjAlM0QlMjBUcnVlJTBBJTIwJTIwJTIwJTIwUElQRUxJTkVfVFJBTlNGT1JNRVJfTEFZRVJfQ0xTJTIwJTNEJTIwWW91ck1vZGVsRGVjb2RlckxheWVyJTBBJTIwJTIwJTIwJTIwUElQRUxJTkVfSU5QVVRfTkFNRVMlMjAlM0QlMjAlNUIlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJhdHRlbnRpb25fbWFzayUyMiU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBjb25maWclMkMlMjB0cm5fY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYudHJuX2NvbmZpZyUyMCUzRCUyMHRybl9jb25maWclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm1vZGVsJTIwJTNEJTIwWW91ck1vZGVsKGNvbmZpZyUyQyUyMHRybl9jb25maWcpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi52b2NhYl9zaXplJTIwJTNEJTIwY29uZmlnLnZvY2FiX3NpemUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmxtX2hlYWQlMjAlM0QlMjBDb2x1bW5QYXJhbGxlbExpbmVhciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcuaGlkZGVuX3NpemUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcudm9jYWJfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJpYXMlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdhdGhlcl9vdXRwdXQlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGR0eXBlJTNEY29uZmlnLnRvcmNoX2R0eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYucG9zdF9pbml0KCk=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">YourModelForCausalLM</span>(NeuronModelMixin, YourPreTrainedModel):
    _tied_weights_keys = [<span class="hljs-string">&quot;lm_head.weight&quot;</span>]
    
    <span class="hljs-comment"># Pipeline parallelism support</span>
    SUPPORTS_PIPELINE_PARALLELISM = <span class="hljs-literal">True</span>
    PIPELINE_TRANSFORMER_LAYER_CLS = YourModelDecoderLayer
    PIPELINE_INPUT_NAMES = [<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>]
    
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config, trn_config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        self.trn_config = trn_config
        self.model = YourModel(config, trn_config)
        self.vocab_size = config.vocab_size
        
        self.lm_head = ColumnParallelLinear(
            config.hidden_size,
            config.vocab_size,
            bias=<span class="hljs-literal">False</span>,
            gather_output=<span class="hljs-literal">False</span>,
            dtype=config.torch_dtype,
        )
        
        self.post_init()`,wrap:!1}}),Tl=new w({props:{title:"Step 4: Register Model",local:"step-4-register-model",headingTag:"h3"}}),ol=new m({props:{code:"ZnJvbSUyMC55b3VyX21vZGVsJTIwaW1wb3J0JTIwWW91ck1vZGVsRm9yQ2F1c2FsTE0lMkMlMjBZb3VyTW9kZWwlMEElMEFfX2FsbF9fJTIwJTNEJTIwJTVCLi4uJTJDJTIwJTIyWW91ck1vZGVsRm9yQ2F1c2FsTE0lMjIlMkMlMjAlMjJZb3VyTW9kZWwlMjIlNUQ=",highlighted:`<span class="hljs-keyword">from</span> .your_model <span class="hljs-keyword">import</span> YourModelForCausalLM, YourModel

__all__ = [..., <span class="hljs-string">&quot;YourModelForCausalLM&quot;</span>, <span class="hljs-string">&quot;YourModel&quot;</span>]`,wrap:!1}}),Cl=new m({props:{code:"ZnJvbSUyMC55b3VyX21vZGVsLm1vZGVsaW5nX3lvdXJfbW9kZWwlMjBpbXBvcnQlMjBZb3VyTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFlvdXJNb2RlbCUwQSUwQSUyMyUyMFJlZ2lzdGVyJTIwdGhlJTIwYmFzZSUyMG1vZGVsJTIwKHdpdGhvdXQlMjBoZWFkKSUwQXJlZ2lzdGVyX25ldXJvbl9tb2RlbF9mb3JfdHJhaW5pbmcoJTIyeW91cl9tb2RlbCUyMiUyQyUyMCUyMm1vZGVsJTIyKShZb3VyTW9kZWwpJTBBJTBBJTIzJTIwUmVnaXN0ZXIlMjB0aGUlMjBDYXVzYWxMTSUyMG1vZGVsJTBBcmVnaXN0ZXJfbmV1cm9uX21vZGVsX2Zvcl90cmFpbmluZyglMjJ5b3VyX21vZGVsJTIyJTJDJTIwJTIydGV4dC1nZW5lcmF0aW9uJTIyKShZb3VyTW9kZWxGb3JDYXVzYWxMTSk=",highlighted:`<span class="hljs-keyword">from</span> .your_model.modeling_your_model <span class="hljs-keyword">import</span> YourModelForCausalLM, YourModel

<span class="hljs-comment"># Register the base model (without head)</span>
register_neuron_model_for_training(<span class="hljs-string">&quot;your_model&quot;</span>, <span class="hljs-string">&quot;model&quot;</span>)(YourModel)

<span class="hljs-comment"># Register the CausalLM model</span>
register_neuron_model_for_training(<span class="hljs-string">&quot;your_model&quot;</span>, <span class="hljs-string">&quot;text-generation&quot;</span>)(YourModelForCausalLM)`,wrap:!1}}),ml=new w({props:{title:"Best Practices",local:"best-practices",headingTag:"h2"}}),rl=new w({props:{title:"1. Parallel Layer Configuration",local:"1-parallel-layer-configuration",headingTag:"h3"}}),cl=new w({props:{title:"2. Weight Transformation Specs",local:"2-weight-transformation-specs",headingTag:"h3"}}),ul=new w({props:{title:"3. Pipeline Parallelism",local:"3-pipeline-parallelism",headingTag:"h3"}}),fl=new w({props:{title:"4. Flash Attention Support",local:"4-flash-attention-support",headingTag:"h3"}}),hl=new w({props:{title:"Testing Your Implementation",local:"testing-your-implementation",headingTag:"h2"}}),Zl=new w({props:{title:"1. Custom Modeling Validation",local:"1-custom-modeling-validation",headingTag:"h3"}}),gl=new m({props:{code:"Q1VTVE9NX01PREVMSU5HU19UT19URVNUJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTIwZXhpc3RpbmclMjBtb2RlbHMlMjAuLi4lMEElMjAlMjAlMjAlMjAoJTIyWW91ck1vZGVsRm9yQ2F1c2FsTE0lMjIlMkMlMjAlMjJ5b3VyLW9yZyUyRnlvdXItbW9kZWwtbmFtZSUyMiklMkMlMEElNUQ=",highlighted:`CUSTOM_MODELINGS_TO_TEST = [
    <span class="hljs-comment"># ... existing models ...</span>
    (<span class="hljs-string">&quot;YourModelForCausalLM&quot;</span>, <span class="hljs-string">&quot;your-org/your-model-name&quot;</span>),
]`,wrap:!1}}),vl=new m({props:{code:"ZGVmJTIwdGVzdF9jdXN0b21fbW9kZWxpbmdfbWF0Y2hlc19vcmlnaW5hbCgpJTIwJTIwJTIzJTIwT3V0cHV0JTIwbWF0Y2hpbmc=",highlighted:'<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_custom_modeling_matches_original</span>()  <span class="hljs-comment"># Output matching</span>',wrap:!1}}),$l=new w({props:{title:"2. End-to-End Training Validation",local:"2-end-to-end-training-validation",headingTag:"h3"}}),Fl=new m({props:{code:"JTQwcHl0ZXN0Lm1hcmsucGFyYW1ldHJpemUoJTBBJTIwJTIwJTIwJTIwJTIybW9kZWxfY2xhc3NfbmFtZSUyQ21vZGVsX25hbWVfb3JfcGF0aCUyQ2xlYXJuaW5nX3JhdGUlMkN3YXJtdXBfcmF0aW8lMkN0cmFpbmluZ19rd2FyZ3MlMkN1c2VfZmxhc2hfYXR0ZW50aW9uXzIlMkNtYXhfZXhwZWN0ZWRfbG9zcyUyQ21heF9sZW5ndGglMkNudW1fc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAuLi4lMjBleGlzdGluZyUyMG1vZGVscyUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMllvdXJNb2RlbEZvckNhdXNhbExNJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyeW91ci1vcmclMkZ5b3VyLW1vZGVsLW5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxZS00JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMC4wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwLjUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyMDQ4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwNTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBpZHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAuLi4lMjBleGlzdGluZyUyMG1vZGVsJTIwSURzJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyeW91ci1vcmclMkZ5b3VyLW1vZGVsLW5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEEp",highlighted:`<span class="hljs-meta">@pytest.mark.parametrize(<span class="hljs-params">
    <span class="hljs-string">&quot;model_class_name,model_name_or_path,learning_rate,warmup_ratio,training_kwargs,use_flash_attention_2,max_expected_loss,max_length,num_steps&quot;</span>,
    [
        <span class="hljs-comment"># ... existing models ...</span>
        [
            <span class="hljs-string">&quot;YourModelForCausalLM&quot;</span>,
            <span class="hljs-string">&quot;your-org/your-model-name&quot;</span>,
            <span class="hljs-number">1e-4</span>,
            <span class="hljs-number">0.03</span>,
            {},
            <span class="hljs-literal">True</span>,
            <span class="hljs-number">0.5</span>,
            <span class="hljs-number">2048</span>,
            <span class="hljs-number">50</span>,
        ],
    ],
    ids=[
        <span class="hljs-comment"># ... existing model IDs ...</span>
        <span class="hljs-string">&quot;your-org/your-model-name&quot;</span>,
    ],
</span>)</span>`,wrap:!1}}),zl=new m({props:{code:"ZGVmJTIwdGVzdF9vdmVyZml0X2N1c3RvbV9tb2RlbGluZ19jYXVzYWxfbG0oKSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEJhc2ljJTIwdHJhaW5pbmclMjAoeW91ciUyMG1vZGVsJTIwaW5jbHVkZWQp",highlighted:'<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_overfit_custom_modeling_causal_lm</span>()       <span class="hljs-comment"># Basic training (your model included)</span>',wrap:!1}}),Sl=new w({props:{title:"3. Auto Model Loading",local:"3-auto-model-loading",headingTag:"h3"}}),ql=new m({props:{code:"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",highlighted:`<span class="hljs-meta">@pytest.mark.parametrize(<span class="hljs-params"><span class="hljs-string">&quot;from_pretrained&quot;</span>, [<span class="hljs-literal">False</span>, <span class="hljs-literal">True</span>], ids=[<span class="hljs-string">&quot;from_config&quot;</span>, <span class="hljs-string">&quot;from_pretrained&quot;</span>]</span>)</span>
<span class="hljs-meta">@distributed_test(<span class="hljs-params">world_size=<span class="hljs-number">1</span></span>)</span>
<span class="hljs-meta">@is_trainium_test</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_auto_model_with_supported_architecture</span>(<span class="hljs-params">from_pretrained</span>):
    trn_config = TrainingNeuronConfig()
    kwargs = {<span class="hljs-string">&quot;torch_dtype&quot;</span>: torch.bfloat16}
    <span class="hljs-keyword">for</span> model_name_or_path <span class="hljs-keyword">in</span> [
        <span class="hljs-string">&quot;michaelbenayoun/llama-2-tiny-4kv-heads-4layers-random&quot;</span>,
        <span class="hljs-string">&quot;michaelbenayoun/granite-tiny-4kv-heads-4layers-random&quot;</span>, 
        <span class="hljs-string">&quot;michaelbenayoun/qwen3-tiny-4kv-heads-4layers-random&quot;</span>,
        <span class="hljs-string">&quot;your-org/your-model-name&quot;</span>,  <span class="hljs-comment"># Add your model here</span>
    ]:
        <span class="hljs-comment"># ... rest of test logic</span>

<span class="hljs-meta">@pytest.mark.parametrize(<span class="hljs-params"><span class="hljs-string">&quot;from_pretrained&quot;</span>, [<span class="hljs-literal">False</span>, <span class="hljs-literal">True</span>], ids=[<span class="hljs-string">&quot;from_config&quot;</span>, <span class="hljs-string">&quot;from_pretrained&quot;</span>]</span>)</span>
<span class="hljs-meta">@distributed_test(<span class="hljs-params">world_size=<span class="hljs-number">1</span></span>)</span>
<span class="hljs-meta">@is_trainium_test</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_auto_model_for_causal_lm_with_supported_architecture</span>(<span class="hljs-params">from_pretrained</span>):
    trn_config = TrainingNeuronConfig()
    kwargs = {<span class="hljs-string">&quot;torch_dtype&quot;</span>: torch.bfloat16}
    <span class="hljs-keyword">for</span> model_name_or_path <span class="hljs-keyword">in</span> [
        <span class="hljs-string">&quot;michaelbenayoun/llama-2-tiny-4kv-heads-4layers-random&quot;</span>,
        <span class="hljs-string">&quot;michaelbenayoun/granite-tiny-4kv-heads-4layers-random&quot;</span>,
        <span class="hljs-string">&quot;michaelbenayoun/qwen3-tiny-4kv-heads-4layers-random&quot;</span>, 
        <span class="hljs-string">&quot;your-org/your-model-name&quot;</span>,  <span class="hljs-comment"># Add your model here</span>
    ]:
        <span class="hljs-comment"># ... rest of test logic</span>`,wrap:!1}}),Dl=new w({props:{title:"4. Running Tests",local:"4-running-tests",headingTag:"h3"}}),le=new m({props:{code:"JTIzJTIwUnVuJTIwYWxsJTIwY3VzdG9tJTIwbW9kZWxpbmclMjB0ZXN0cyUwQXB5dGVzdCUyMHRlc3RzJTJGdHJhaW5pbmclMkZ0ZXN0X2N1c3RvbV9tb2RlbGluZy5weSUyMC12JTBBJTBBJTIzJTIwUnVuJTIwc3BlY2lmaWMlMjBtb2RlbCUyMHRlc3RzJTBBcHl0ZXN0JTIwdGVzdHMlMkZ0cmFpbmluZyUyRnRlc3RfY3VzdG9tX21vZGVsaW5nLnB5JTIwLXYlMjAtayUyMCUyMnlvdXJfbW9kZWwlMjIlMEElMEElMjMlMjBSdW4lMjBlbmQtdG8tZW5kJTIwdHJhaW5pbmclMjB2YWxpZGF0aW9uJTBBcHl0ZXN0JTIwdGVzdHMlMkZ0cmFpbmluZyUyRnRlc3Rfb3ZlcmZpdC5weSUyMC12",highlighted:`<span class="hljs-comment"># Run all custom modeling tests</span>
pytest tests/training/test_custom_modeling.py -v

<span class="hljs-comment"># Run specific model tests</span>
pytest tests/training/test_custom_modeling.py -v -k <span class="hljs-string">&quot;your_model&quot;</span>

<span class="hljs-comment"># Run end-to-end training validation</span>
pytest tests/training/test_overfit.py -v`,wrap:!1}}),ee=new w({props:{title:"5. Test Requirements",local:"5-test-requirements",headingTag:"h3"}}),ne=new w({props:{title:"Common Issues",local:"common-issues",headingTag:"h2"}}),ye=new w({props:{title:"Additional Resources",local:"additional-resources",headingTag:"h2"}}),{c(){r=a("meta"),Ce=t(),oe=a("p"),we=t(),U(j.$$.fragment),me=t(),c=a("p"),c.innerHTML=os,re=t(),U(d.$$.fragment),je=t(),U(u.$$.fragment),ce=t(),I=a("p"),I.innerHTML=Js,de=t(),f=a("ul"),f.innerHTML=Cs,ue=t(),U(A.$$.fragment),Ie=t(),h=a("p"),h.textContent=ws,fe=t(),b=a("ul"),b.innerHTML=ms,Ae=t(),Z=a("p"),Z.textContent=rs,he=t(),_=a("ul"),_.innerHTML=js,be=t(),W=a("p"),W.innerHTML=cs,Ze=t(),U(g.$$.fragment),_e=t(),V=a("p"),V.innerHTML=ds,We=t(),B=a("ul"),B.innerHTML=us,ge=t(),U(k.$$.fragment),Ve=t(),U(G.$$.fragment),Be=t(),X=a("p"),X.innerHTML=Is,ke=t(),v=a("p"),v.innerHTML=fs,Ge=t(),U(R.$$.fragment),Xe=t(),U($.$$.fragment),ve=t(),Q=a("p"),Q.innerHTML=As,Re=t(),U(N.$$.fragment),$e=t(),U(F.$$.fragment),Qe=t(),U(Y.$$.fragment),Ne=t(),U(x.$$.fragment),Fe=t(),U(E.$$.fragment),Ye=t(),z=a("p"),z.innerHTML=hs,xe=t(),U(S.$$.fragment),Ee=t(),U(L.$$.fragment),ze=t(),H=a("p"),H.textContent=bs,Se=t(),q=a("p"),q.innerHTML=Zs,Le=t(),U(P.$$.fragment),He=t(),K=a("p"),K.innerHTML=_s,qe=t(),U(D.$$.fragment),Pe=t(),O=a("p"),O.innerHTML=Ws,Ke=t(),U(ll.$$.fragment),De=t(),el=a("p"),el.innerHTML=gs,Oe=t(),Ml=a("ul"),Ml.innerHTML=Vs,lM=t(),sl=a("p"),sl.textContent=Bs,eM=t(),U(tl.$$.fragment),MM=t(),U(nl.$$.fragment),sM=t(),U(al.$$.fragment),tM=t(),U(yl.$$.fragment),nM=t(),U(il.$$.fragment),aM=t(),U(Ul.$$.fragment),yM=t(),U(Tl.$$.fragment),iM=t(),pl=a("p"),pl.innerHTML=ks,UM=t(),U(ol.$$.fragment),TM=t(),Jl=a("p"),Jl.innerHTML=Gs,pM=t(),U(Cl.$$.fragment),oM=t(),wl=a("p"),wl.innerHTML=Xs,JM=t(),U(ml.$$.fragment),CM=t(),U(rl.$$.fragment),wM=t(),jl=a("ul"),jl.innerHTML=vs,mM=t(),U(cl.$$.fragment),rM=t(),dl=a("ul"),dl.innerHTML=Rs,jM=t(),U(ul.$$.fragment),cM=t(),Il=a("ul"),Il.innerHTML=$s,dM=t(),U(fl.$$.fragment),uM=t(),Al=a("ul"),Al.innerHTML=Qs,IM=t(),U(hl.$$.fragment),fM=t(),bl=a("p"),bl.innerHTML=Ns,AM=t(),U(Zl.$$.fragment),hM=t(),_l=a("p"),_l.innerHTML=Fs,bM=t(),Wl=a("p"),Wl.innerHTML=Ys,ZM=t(),U(gl.$$.fragment),_M=t(),Vl=a("p"),Vl.innerHTML=xs,WM=t(),Bl=a("ul"),Bl.innerHTML=Es,gM=t(),kl=a("p"),kl.textContent=zs,VM=t(),Gl=a("ul"),Gl.innerHTML=Ss,BM=t(),Xl=a("p"),Xl.textContent=Ls,kM=t(),U(vl.$$.fragment),GM=t(),Rl=a("ul"),Rl.innerHTML=Hs,XM=t(),U($l.$$.fragment),vM=t(),Ql=a("p"),Ql.innerHTML=qs,RM=t(),Nl=a("p"),Nl.innerHTML=Ps,$M=t(),U(Fl.$$.fragment),QM=t(),Yl=a("p"),Yl.textContent=Ks,NM=t(),xl=a("ul"),xl.innerHTML=Ds,FM=t(),El=a("p"),El.textContent=Os,YM=t(),U(zl.$$.fragment),xM=t(),U(Sl.$$.fragment),EM=t(),Ll=a("p"),Ll.innerHTML=lt,zM=t(),Hl=a("p"),Hl.innerHTML=et,SM=t(),U(ql.$$.fragment),LM=t(),Pl=a("p"),Pl.textContent=Mt,HM=t(),Kl=a("ul"),Kl.innerHTML=st,qM=t(),U(Dl.$$.fragment),PM=t(),Ol=a("p"),Ol.textContent=tt,KM=t(),U(le.$$.fragment),DM=t(),U(ee.$$.fragment),OM=t(),Me=a("p"),Me.textContent=nt,ls=t(),se=a("ol"),se.innerHTML=at,es=t(),te=a("p"),te.textContent=yt,Ms=t(),U(ne.$$.fragment),ss=t(),ae=a("ul"),ae.innerHTML=it,ts=t(),U(ye.$$.fragment),ns=t(),ie=a("p"),ie.textContent=Ut,as=t(),Ue=a("ul"),Ue.innerHTML=Tt,ys=t(),Te=a("p"),Te.textContent=pt,is=t(),pe=a("ul"),pe.innerHTML=ot,Us=t(),Je=a("p"),this.h()},l(l){const e=dt("svelte-u9bgzb",document.head);r=y(e,"META",{name:!0,content:!0}),e.forEach(M),Ce=n(l),oe=y(l,"P",{}),Jt(oe).forEach(M),we=n(l),T(j.$$.fragment,l),me=n(l),c=y(l,"P",{"data-svelte-h":!0}),i(c)!=="svelte-o1icnh"&&(c.innerHTML=os),re=n(l),T(d.$$.fragment,l),je=n(l),T(u.$$.fragment,l),ce=n(l),I=y(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-o8lxl9"&&(I.innerHTML=Js),de=n(l),f=y(l,"UL",{"data-svelte-h":!0}),i(f)!=="svelte-17o51ne"&&(f.innerHTML=Cs),ue=n(l),T(A.$$.fragment,l),Ie=n(l),h=y(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-1cxti7r"&&(h.textContent=ws),fe=n(l),b=y(l,"UL",{"data-svelte-h":!0}),i(b)!=="svelte-egt1g"&&(b.innerHTML=ms),Ae=n(l),Z=y(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1sw314o"&&(Z.textContent=rs),he=n(l),_=y(l,"UL",{"data-svelte-h":!0}),i(_)!=="svelte-1813bw9"&&(_.innerHTML=js),be=n(l),W=y(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1xgxhwy"&&(W.innerHTML=cs),Ze=n(l),T(g.$$.fragment,l),_e=n(l),V=y(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1xa5nbr"&&(V.innerHTML=ds),We=n(l),B=y(l,"UL",{"data-svelte-h":!0}),i(B)!=="svelte-1p13ho0"&&(B.innerHTML=us),ge=n(l),T(k.$$.fragment,l),Ve=n(l),T(G.$$.fragment,l),Be=n(l),X=y(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1brmy4r"&&(X.innerHTML=Is),ke=n(l),v=y(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1bum30f"&&(v.innerHTML=fs),Ge=n(l),T(R.$$.fragment,l),Xe=n(l),T($.$$.fragment,l),ve=n(l),Q=y(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1a3kcfq"&&(Q.innerHTML=As),Re=n(l),T(N.$$.fragment,l),$e=n(l),T(F.$$.fragment,l),Qe=n(l),T(Y.$$.fragment,l),Ne=n(l),T(x.$$.fragment,l),Fe=n(l),T(E.$$.fragment,l),Ye=n(l),z=y(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1kxohx9"&&(z.innerHTML=hs),xe=n(l),T(S.$$.fragment,l),Ee=n(l),T(L.$$.fragment,l),ze=n(l),H=y(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-67vg61"&&(H.textContent=bs),Se=n(l),q=y(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-b4subx"&&(q.innerHTML=Zs),Le=n(l),T(P.$$.fragment,l),He=n(l),K=y(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-f9hwk6"&&(K.innerHTML=_s),qe=n(l),T(D.$$.fragment,l),Pe=n(l),O=y(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-lyz81m"&&(O.innerHTML=Ws),Ke=n(l),T(ll.$$.fragment,l),De=n(l),el=y(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-163bvl5"&&(el.innerHTML=gs),Oe=n(l),Ml=y(l,"UL",{"data-svelte-h":!0}),i(Ml)!=="svelte-3el8k"&&(Ml.innerHTML=Vs),lM=n(l),sl=y(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-10ra3tv"&&(sl.textContent=Bs),eM=n(l),T(tl.$$.fragment,l),MM=n(l),T(nl.$$.fragment,l),sM=n(l),T(al.$$.fragment,l),tM=n(l),T(yl.$$.fragment,l),nM=n(l),T(il.$$.fragment,l),aM=n(l),T(Ul.$$.fragment,l),yM=n(l),T(Tl.$$.fragment,l),iM=n(l),pl=y(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-1r6d489"&&(pl.innerHTML=ks),UM=n(l),T(ol.$$.fragment,l),TM=n(l),Jl=y(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-hs3no7"&&(Jl.innerHTML=Gs),pM=n(l),T(Cl.$$.fragment,l),oM=n(l),wl=y(l,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-12q3gxe"&&(wl.innerHTML=Xs),JM=n(l),T(ml.$$.fragment,l),CM=n(l),T(rl.$$.fragment,l),wM=n(l),jl=y(l,"UL",{"data-svelte-h":!0}),i(jl)!=="svelte-n3fz09"&&(jl.innerHTML=vs),mM=n(l),T(cl.$$.fragment,l),rM=n(l),dl=y(l,"UL",{"data-svelte-h":!0}),i(dl)!=="svelte-zppzms"&&(dl.innerHTML=Rs),jM=n(l),T(ul.$$.fragment,l),cM=n(l),Il=y(l,"UL",{"data-svelte-h":!0}),i(Il)!=="svelte-h3sif8"&&(Il.innerHTML=$s),dM=n(l),T(fl.$$.fragment,l),uM=n(l),Al=y(l,"UL",{"data-svelte-h":!0}),i(Al)!=="svelte-18wpz97"&&(Al.innerHTML=Qs),IM=n(l),T(hl.$$.fragment,l),fM=n(l),bl=y(l,"P",{"data-svelte-h":!0}),i(bl)!=="svelte-1gtlfnj"&&(bl.innerHTML=Ns),AM=n(l),T(Zl.$$.fragment,l),hM=n(l),_l=y(l,"P",{"data-svelte-h":!0}),i(_l)!=="svelte-oqrl65"&&(_l.innerHTML=Fs),bM=n(l),Wl=y(l,"P",{"data-svelte-h":!0}),i(Wl)!=="svelte-f0o4jc"&&(Wl.innerHTML=Ys),ZM=n(l),T(gl.$$.fragment,l),_M=n(l),Vl=y(l,"P",{"data-svelte-h":!0}),i(Vl)!=="svelte-cj2f57"&&(Vl.innerHTML=xs),WM=n(l),Bl=y(l,"UL",{"data-svelte-h":!0}),i(Bl)!=="svelte-is5pbj"&&(Bl.innerHTML=Es),gM=n(l),kl=y(l,"P",{"data-svelte-h":!0}),i(kl)!=="svelte-1p913uj"&&(kl.textContent=zs),VM=n(l),Gl=y(l,"UL",{"data-svelte-h":!0}),i(Gl)!=="svelte-13v9552"&&(Gl.innerHTML=Ss),BM=n(l),Xl=y(l,"P",{"data-svelte-h":!0}),i(Xl)!=="svelte-1psu9rx"&&(Xl.textContent=Ls),kM=n(l),T(vl.$$.fragment,l),GM=n(l),Rl=y(l,"UL",{"data-svelte-h":!0}),i(Rl)!=="svelte-grvokw"&&(Rl.innerHTML=Hs),XM=n(l),T($l.$$.fragment,l),vM=n(l),Ql=y(l,"P",{"data-svelte-h":!0}),i(Ql)!=="svelte-1xgz07a"&&(Ql.innerHTML=qs),RM=n(l),Nl=y(l,"P",{"data-svelte-h":!0}),i(Nl)!=="svelte-skk8sm"&&(Nl.innerHTML=Ps),$M=n(l),T(Fl.$$.fragment,l),QM=n(l),Yl=y(l,"P",{"data-svelte-h":!0}),i(Yl)!=="svelte-1c9b85z"&&(Yl.textContent=Ks),NM=n(l),xl=y(l,"UL",{"data-svelte-h":!0}),i(xl)!=="svelte-15o1gbp"&&(xl.innerHTML=Ds),FM=n(l),El=y(l,"P",{"data-svelte-h":!0}),i(El)!=="svelte-1l6upaz"&&(El.textContent=Os),YM=n(l),T(zl.$$.fragment,l),xM=n(l),T(Sl.$$.fragment,l),EM=n(l),Ll=y(l,"P",{"data-svelte-h":!0}),i(Ll)!=="svelte-1p3hpdo"&&(Ll.innerHTML=lt),zM=n(l),Hl=y(l,"P",{"data-svelte-h":!0}),i(Hl)!=="svelte-i621bo"&&(Hl.innerHTML=et),SM=n(l),T(ql.$$.fragment,l),LM=n(l),Pl=y(l,"P",{"data-svelte-h":!0}),i(Pl)!=="svelte-1c9b85z"&&(Pl.textContent=Mt),HM=n(l),Kl=y(l,"UL",{"data-svelte-h":!0}),i(Kl)!=="svelte-1pogip"&&(Kl.innerHTML=st),qM=n(l),T(Dl.$$.fragment,l),PM=n(l),Ol=y(l,"P",{"data-svelte-h":!0}),i(Ol)!=="svelte-6i8ef"&&(Ol.textContent=tt),KM=n(l),T(le.$$.fragment,l),DM=n(l),T(ee.$$.fragment,l),OM=n(l),Me=y(l,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-1lc4hka"&&(Me.textContent=nt),ls=n(l),se=y(l,"OL",{"data-svelte-h":!0}),i(se)!=="svelte-12pvc9t"&&(se.innerHTML=at),es=n(l),te=y(l,"P",{"data-svelte-h":!0}),i(te)!=="svelte-ixzgc9"&&(te.textContent=yt),Ms=n(l),T(ne.$$.fragment,l),ss=n(l),ae=y(l,"UL",{"data-svelte-h":!0}),i(ae)!=="svelte-1g0k1y8"&&(ae.innerHTML=it),ts=n(l),T(ye.$$.fragment,l),ns=n(l),ie=y(l,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-1brs14g"&&(ie.textContent=Ut),as=n(l),Ue=y(l,"UL",{"data-svelte-h":!0}),i(Ue)!=="svelte-1ep1va0"&&(Ue.innerHTML=Tt),ys=n(l),Te=y(l,"P",{"data-svelte-h":!0}),i(Te)!=="svelte-1q4t712"&&(Te.textContent=pt),is=n(l),pe=y(l,"UL",{"data-svelte-h":!0}),i(pe)!=="svelte-jpnk8d"&&(pe.innerHTML=ot),Us=n(l),Je=y(l,"P",{}),Jt(Je).forEach(M),this.h()},h(){Ct(r,"name","hf:doc:metadata"),Ct(r,"content",ft)},m(l,e){ut(document.head,r),s(l,Ce,e),s(l,oe,e),s(l,we,e),p(j,l,e),s(l,me,e),s(l,c,e),s(l,re,e),p(d,l,e),s(l,je,e),p(u,l,e),s(l,ce,e),s(l,I,e),s(l,de,e),s(l,f,e),s(l,ue,e),p(A,l,e),s(l,Ie,e),s(l,h,e),s(l,fe,e),s(l,b,e),s(l,Ae,e),s(l,Z,e),s(l,he,e),s(l,_,e),s(l,be,e),s(l,W,e),s(l,Ze,e),p(g,l,e),s(l,_e,e),s(l,V,e),s(l,We,e),s(l,B,e),s(l,ge,e),p(k,l,e),s(l,Ve,e),p(G,l,e),s(l,Be,e),s(l,X,e),s(l,ke,e),s(l,v,e),s(l,Ge,e),p(R,l,e),s(l,Xe,e),p($,l,e),s(l,ve,e),s(l,Q,e),s(l,Re,e),p(N,l,e),s(l,$e,e),p(F,l,e),s(l,Qe,e),p(Y,l,e),s(l,Ne,e),p(x,l,e),s(l,Fe,e),p(E,l,e),s(l,Ye,e),s(l,z,e),s(l,xe,e),p(S,l,e),s(l,Ee,e),p(L,l,e),s(l,ze,e),s(l,H,e),s(l,Se,e),s(l,q,e),s(l,Le,e),p(P,l,e),s(l,He,e),s(l,K,e),s(l,qe,e),p(D,l,e),s(l,Pe,e),s(l,O,e),s(l,Ke,e),p(ll,l,e),s(l,De,e),s(l,el,e),s(l,Oe,e),s(l,Ml,e),s(l,lM,e),s(l,sl,e),s(l,eM,e),p(tl,l,e),s(l,MM,e),p(nl,l,e),s(l,sM,e),p(al,l,e),s(l,tM,e),p(yl,l,e),s(l,nM,e),p(il,l,e),s(l,aM,e),p(Ul,l,e),s(l,yM,e),p(Tl,l,e),s(l,iM,e),s(l,pl,e),s(l,UM,e),p(ol,l,e),s(l,TM,e),s(l,Jl,e),s(l,pM,e),p(Cl,l,e),s(l,oM,e),s(l,wl,e),s(l,JM,e),p(ml,l,e),s(l,CM,e),p(rl,l,e),s(l,wM,e),s(l,jl,e),s(l,mM,e),p(cl,l,e),s(l,rM,e),s(l,dl,e),s(l,jM,e),p(ul,l,e),s(l,cM,e),s(l,Il,e),s(l,dM,e),p(fl,l,e),s(l,uM,e),s(l,Al,e),s(l,IM,e),p(hl,l,e),s(l,fM,e),s(l,bl,e),s(l,AM,e),p(Zl,l,e),s(l,hM,e),s(l,_l,e),s(l,bM,e),s(l,Wl,e),s(l,ZM,e),p(gl,l,e),s(l,_M,e),s(l,Vl,e),s(l,WM,e),s(l,Bl,e),s(l,gM,e),s(l,kl,e),s(l,VM,e),s(l,Gl,e),s(l,BM,e),s(l,Xl,e),s(l,kM,e),p(vl,l,e),s(l,GM,e),s(l,Rl,e),s(l,XM,e),p($l,l,e),s(l,vM,e),s(l,Ql,e),s(l,RM,e),s(l,Nl,e),s(l,$M,e),p(Fl,l,e),s(l,QM,e),s(l,Yl,e),s(l,NM,e),s(l,xl,e),s(l,FM,e),s(l,El,e),s(l,YM,e),p(zl,l,e),s(l,xM,e),p(Sl,l,e),s(l,EM,e),s(l,Ll,e),s(l,zM,e),s(l,Hl,e),s(l,SM,e),p(ql,l,e),s(l,LM,e),s(l,Pl,e),s(l,HM,e),s(l,Kl,e),s(l,qM,e),p(Dl,l,e),s(l,PM,e),s(l,Ol,e),s(l,KM,e),p(le,l,e),s(l,DM,e),p(ee,l,e),s(l,OM,e),s(l,Me,e),s(l,ls,e),s(l,se,e),s(l,es,e),s(l,te,e),s(l,Ms,e),p(ne,l,e),s(l,ss,e),s(l,ae,e),s(l,ts,e),p(ye,l,e),s(l,ns,e),s(l,ie,e),s(l,as,e),s(l,Ue,e),s(l,ys,e),s(l,Te,e),s(l,is,e),s(l,pe,e),s(l,Us,e),s(l,Je,e),Ts=!0},p:mt,i(l){Ts||(o(j.$$.fragment,l),o(d.$$.fragment,l),o(u.$$.fragment,l),o(A.$$.fragment,l),o(g.$$.fragment,l),o(k.$$.fragment,l),o(G.$$.fragment,l),o(R.$$.fragment,l),o($.$$.fragment,l),o(N.$$.fragment,l),o(F.$$.fragment,l),o(Y.$$.fragment,l),o(x.$$.fragment,l),o(E.$$.fragment,l),o(S.$$.fragment,l),o(L.$$.fragment,l),o(P.$$.fragment,l),o(D.$$.fragment,l),o(ll.$$.fragment,l),o(tl.$$.fragment,l),o(nl.$$.fragment,l),o(al.$$.fragment,l),o(yl.$$.fragment,l),o(il.$$.fragment,l),o(Ul.$$.fragment,l),o(Tl.$$.fragment,l),o(ol.$$.fragment,l),o(Cl.$$.fragment,l),o(ml.$$.fragment,l),o(rl.$$.fragment,l),o(cl.$$.fragment,l),o(ul.$$.fragment,l),o(fl.$$.fragment,l),o(hl.$$.fragment,l),o(Zl.$$.fragment,l),o(gl.$$.fragment,l),o(vl.$$.fragment,l),o($l.$$.fragment,l),o(Fl.$$.fragment,l),o(zl.$$.fragment,l),o(Sl.$$.fragment,l),o(ql.$$.fragment,l),o(Dl.$$.fragment,l),o(le.$$.fragment,l),o(ee.$$.fragment,l),o(ne.$$.fragment,l),o(ye.$$.fragment,l),Ts=!0)},o(l){J(j.$$.fragment,l),J(d.$$.fragment,l),J(u.$$.fragment,l),J(A.$$.fragment,l),J(g.$$.fragment,l),J(k.$$.fragment,l),J(G.$$.fragment,l),J(R.$$.fragment,l),J($.$$.fragment,l),J(N.$$.fragment,l),J(F.$$.fragment,l),J(Y.$$.fragment,l),J(x.$$.fragment,l),J(E.$$.fragment,l),J(S.$$.fragment,l),J(L.$$.fragment,l),J(P.$$.fragment,l),J(D.$$.fragment,l),J(ll.$$.fragment,l),J(tl.$$.fragment,l),J(nl.$$.fragment,l),J(al.$$.fragment,l),J(yl.$$.fragment,l),J(il.$$.fragment,l),J(Ul.$$.fragment,l),J(Tl.$$.fragment,l),J(ol.$$.fragment,l),J(Cl.$$.fragment,l),J(ml.$$.fragment,l),J(rl.$$.fragment,l),J(cl.$$.fragment,l),J(ul.$$.fragment,l),J(fl.$$.fragment,l),J(hl.$$.fragment,l),J(Zl.$$.fragment,l),J(gl.$$.fragment,l),J(vl.$$.fragment,l),J($l.$$.fragment,l),J(Fl.$$.fragment,l),J(zl.$$.fragment,l),J(Sl.$$.fragment,l),J(ql.$$.fragment,l),J(Dl.$$.fragment,l),J(le.$$.fragment,l),J(ee.$$.fragment,l),J(ne.$$.fragment,l),J(ye.$$.fragment,l),Ts=!1},d(l){l&&(M(Ce),M(oe),M(we),M(me),M(c),M(re),M(je),M(ce),M(I),M(de),M(f),M(ue),M(Ie),M(h),M(fe),M(b),M(Ae),M(Z),M(he),M(_),M(be),M(W),M(Ze),M(_e),M(V),M(We),M(B),M(ge),M(Ve),M(Be),M(X),M(ke),M(v),M(Ge),M(Xe),M(ve),M(Q),M(Re),M($e),M(Qe),M(Ne),M(Fe),M(Ye),M(z),M(xe),M(Ee),M(ze),M(H),M(Se),M(q),M(Le),M(He),M(K),M(qe),M(Pe),M(O),M(Ke),M(De),M(el),M(Oe),M(Ml),M(lM),M(sl),M(eM),M(MM),M(sM),M(tM),M(nM),M(aM),M(yM),M(iM),M(pl),M(UM),M(TM),M(Jl),M(pM),M(oM),M(wl),M(JM),M(CM),M(wM),M(jl),M(mM),M(rM),M(dl),M(jM),M(cM),M(Il),M(dM),M(uM),M(Al),M(IM),M(fM),M(bl),M(AM),M(hM),M(_l),M(bM),M(Wl),M(ZM),M(_M),M(Vl),M(WM),M(Bl),M(gM),M(kl),M(VM),M(Gl),M(BM),M(Xl),M(kM),M(GM),M(Rl),M(XM),M(vM),M(Ql),M(RM),M(Nl),M($M),M(QM),M(Yl),M(NM),M(xl),M(FM),M(El),M(YM),M(xM),M(EM),M(Ll),M(zM),M(Hl),M(SM),M(LM),M(Pl),M(HM),M(Kl),M(qM),M(PM),M(Ol),M(KM),M(DM),M(OM),M(Me),M(ls),M(se),M(es),M(te),M(Ms),M(ss),M(ae),M(ts),M(ns),M(ie),M(as),M(Ue),M(ys),M(Te),M(is),M(pe),M(Us),M(Je)),M(r),C(j,l),C(d,l),C(u,l),C(A,l),C(g,l),C(k,l),C(G,l),C(R,l),C($,l),C(N,l),C(F,l),C(Y,l),C(x,l),C(E,l),C(S,l),C(L,l),C(P,l),C(D,l),C(ll,l),C(tl,l),C(nl,l),C(al,l),C(yl,l),C(il,l),C(Ul,l),C(Tl,l),C(ol,l),C(Cl,l),C(ml,l),C(rl,l),C(cl,l),C(ul,l),C(fl,l),C(hl,l),C(Zl,l),C(gl,l),C(vl,l),C($l,l),C(Fl,l),C(zl,l),C(Sl,l),C(ql,l),C(Dl,l),C(le,l),C(ee,l),C(ne,l),C(ye,l)}}}const ft='{"title":"Contributing Custom Models for Training","local":"contributing-custom-models-for-training","sections":[{"title":"Architecture Components","local":"architecture-components","sections":[{"title":"1. NeuronModelMixin","local":"1-neuronmodelmixin","sections":[],"depth":3},{"title":"2. Weight Transformation Specs","local":"2-weight-transformation-specs","sections":[],"depth":3},{"title":"3. Parallel Layers","local":"3-parallel-layers","sections":[],"depth":3}],"depth":2},{"title":"Implementation Steps","local":"implementation-steps","sections":[{"title":"Step 1: Create Model Structure","local":"step-1-create-model-structure","sections":[],"depth":3},{"title":"Step 2: Implement the Model Building Blocks","local":"step-2-implement-the-model-building-blocks","sections":[{"title":"Imports and Dependencies","local":"imports-and-dependencies","sections":[],"depth":4},{"title":"Embedding Layer","local":"embedding-layer","sections":[],"depth":4},{"title":"MLP Layer with Fused Linears","local":"mlp-layer-with-fused-linears","sections":[],"depth":4},{"title":"Attention Layer","local":"attention-layer","sections":[],"depth":4}],"depth":3},{"title":"Step 3: Implement Main Model Classes","local":"step-3-implement-main-model-classes","sections":[{"title":"Base Model","local":"base-model","sections":[],"depth":4},{"title":"CausalLM Model","local":"causallm-model","sections":[],"depth":4}],"depth":3},{"title":"Step 4: Register Model","local":"step-4-register-model","sections":[],"depth":3}],"depth":2},{"title":"Best Practices","local":"best-practices","sections":[{"title":"1. Parallel Layer Configuration","local":"1-parallel-layer-configuration","sections":[],"depth":3},{"title":"2. Weight Transformation Specs","local":"2-weight-transformation-specs","sections":[],"depth":3},{"title":"3. Pipeline Parallelism","local":"3-pipeline-parallelism","sections":[],"depth":3},{"title":"4. Flash Attention Support","local":"4-flash-attention-support","sections":[],"depth":3}],"depth":2},{"title":"Testing Your Implementation","local":"testing-your-implementation","sections":[{"title":"1. Custom Modeling Validation","local":"1-custom-modeling-validation","sections":[],"depth":3},{"title":"2. End-to-End Training Validation","local":"2-end-to-end-training-validation","sections":[],"depth":3},{"title":"3. Auto Model Loading","local":"3-auto-model-loading","sections":[],"depth":3},{"title":"4. Running Tests","local":"4-running-tests","sections":[],"depth":3},{"title":"5. Test Requirements","local":"5-test-requirements","sections":[],"depth":3}],"depth":2},{"title":"Common Issues","local":"common-issues","sections":[],"depth":2},{"title":"Additional Resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function At(ps){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wt extends jt{constructor(r){super(),ct(this,r,At,It,wt,{})}}export{Wt as component};
