import{s as Ye,o as Oe,n as De}from"../chunks/scheduler.85c25b89.js";import{S as Ke,i as et,g as i,s,r as m,A as tt,h as a,f as n,c as o,j as Qe,u as c,x as r,k as Pe,y as nt,a as l,v as d,d as f,t as h,w as y}from"../chunks/index.c9bcf812.js";import{T as lt}from"../chunks/Tip.d8f753fa.js";import{C as Ue}from"../chunks/CodeBlock.c004bd26.js";import{H as P}from"../chunks/getInferenceSnippets.80b657e7.js";function st(Y){let p,g='We usually test smaller checkpoints to accelerate the CIs, you could find tiny models for testing under the <a href="https://huggingface.co/hf-internal-testing" rel="nofollow"><code>Hugging Face Internal Testing Organization</code></a>.';return{c(){p=i("p"),p.innerHTML=g},l(u){p=a(u,"P",{"data-svelte-h":!0}),r(p)!=="svelte-r7v6p2"&&(p.innerHTML=g)},m(u,A){l(u,p,A)},p:De,d(u){u&&n(p)}}}function ot(Y){let p,g,u,A,b,O,T,Je="<p><strong><em>NOTE:</em></strong> ❗This section does not apply to the decoder model’s inference with autoregressive sampling integrated through <code>transformers-neuronx</code>. If you want to add support for these models, please open an issue on the Optimum Neuron GitHub repo, and ping maintainers for help.</p>",D,w,je='You want to export and run a new model on AWS Inferentia or Trainium? Check the guideline, and submit a pull request to <a href="https://github.com/huggingface/optimum-neuron/" rel="nofollow">🤗 Optimum Neuron’s GitHub repo</a>!',K,v,Ne="To support a new model architecture in the Optimum Neuron library here are some steps to follow:",ee,C,ke="<li>Implement a custom Neuron configuration.</li> <li>Export and validate the model.</li> <li>Contribute to the GitHub repo.</li>",te,_,ne,$,He="To support the export of a new model to a Neuron compatible format, the first thing to do is to define a Neuron configuration, describing how to export the PyTorch model by specifying:",le,x,Xe="<li>The input names.</li> <li>The output names.</li> <li>The dummy inputs used to trace the model: the Neuron Compiler records the computational graph via tracing and works on the resulting <code>TorchScript</code> module.</li> <li>The compilation arguments used to control the trade-off between hardware efficiency (latency, throughput) and accuracy.</li>",se,U,Ze=`Depending on the choice of model and task, we represent the data above with configuration classes. Each configuration class is associated with
a specific model architecture, and follows the naming convention <code>ArchitectureNameNeuronConfig</code>. For instance, the configuration that specifies the Neuron
export of BERT models is <code>BertNeuronConfig</code>.`,oe,J,Ve="Since many architectures share similar properties for their Neuron configuration, 🤗 Optimum adopts a 3-level class hierarchy:",ie,j,Ie="<li>Abstract and generic base classes. These handle all the fundamental features, while being agnostic to the modality (text, image, audio, etc).</li> <li>Middle-end classes. These are aware of the modality. Multiple config classes could exist for the same modality, depending on the inputs they support. They specify which input generators should be used for generating the dummy inputs, but remain model-agnostic.</li> <li>Model-specific classes like the <code>BertNeuronConfig</code> mentioned above. These are the ones actually used to export models.</li>",ae,N,re,k,Ge='Here we take the support of <a href="https://huggingface.co/docs/transformers/model_doc/esm#esm" rel="nofollow">ESM models</a> as an example. Let’s create an <code>EsmNeuronConfig</code> class in the <code>optimum/exporters/neuron/model_configs.py</code>.',pe,H,Le=`When an Esm model interprets as a text encoder, we are able to inherit from the middle-end class <a href="https://github.com/huggingface/optimum-neuron/blob/v0.0.18/optimum/exporters/neuron/config.py#L36" rel="nofollow"><code>TextEncoderNeuronConfig</code></a>.
Since the modeling and configuration of Esm is almost the same as BERT when it is interpreted as an encoder, we can use the <code>NormalizedConfigManager</code> with <code>model_type=bert</code> to normalize the configuration to generate dummy inputs for tracing the model.`,ue,X,Ee='And one last step, since <code>optimum-neuron</code> is an extension of <code>optimum</code>, we need to register the Neuron config that we create to the <a href="https://huggingface.co/docs/optimum/main/en/exporters/task_manager#optimum.exporters.TasksManager" rel="nofollow">TasksManager</a> with the <code>register_in_tasks_manager</code> decorator by specifying the model type and supported tasks.',me,Z,ce,V,de,I,Re="With the Neuron configuration class that you implemented, now do a quick test if it works as expected:",fe,G,Be="<li>Export</li>",he,L,ye,E,qe='During the export <a href="https://github.com/huggingface/optimum-neuron/blob/7b18de9ddfa5c664c94051304c651eaf855c3e0b/optimum/exporters/neuron/convert.py#L136" rel="nofollow"><code>validate_model_outputs</code></a> will be called to validate the outputs of your exported Neuron model by comparing them to the results of PyTorch on the CPU. You could also validate the model manually with:',Me,R,ge,B,We="<li>Inference (optional)</li>",be,q,Te,W,we,F,Fe="We are almost all set. Now submit a pull request to make your work accessible to all community members!",ve,S,Se='<li>Open an issue in the <a href="https://github.com/huggingface/optimum-neuron/issues" rel="nofollow">Optimum Neuron GitHub repo</a> to describe the new feature and make it visible to Optimum Neuron’s maintainers.</li> <li>Add the model to the exporter test in <a href="https://github.com/huggingface/optimum-neuron/blob/v0.0.18/tests/exporters/exporters_utils.py" rel="nofollow"><code>optimum-neuron/tests/exporters/exporters_utils.py</code></a> and the inference test in <a href="https://github.com/huggingface/optimum-neuron/blob/v0.0.18/tests/inference/inference_utils.py" rel="nofollow"><code>optimum-neuron/tests/inference/inference_utils.py</code></a>.</li> <li>Open a pull request! (Don’t forget to link it to the issue you opened, so that the maintainers could better track it and provide help when needed.)</li>',Ce,M,_e,z,ze="You have made a new model accessible on Neuron for the community! Thanks for joining us in the endeavor of democratizing good machine learning 🤗.",$e,Q,xe;return b=new P({props:{title:"Adding support for new architectures",local:"adding-support-for-new-architectures",headingTag:"h1"}}),_=new P({props:{title:"Implement a custom Neuron configuration",local:"implement-a-custom-neuron-configuration",headingTag:"h2"}}),N=new P({props:{title:"Example: Adding support for ESM models",local:"example-adding-support-for-esm-models",headingTag:"h3"}}),Z=new Ue({props:{code:"JTBBJTQwcmVnaXN0ZXJfaW5fdGFza3NfbWFuYWdlciglMjJlc20lMjIlMkMlMjAqJTVCJTIyZmVhdHVyZS1leHRyYWN0aW9uJTIyJTJDJTIwJTIyZmlsbC1tYXNrJTIyJTJDJTIwJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMCUyMnRva2VuLWNsYXNzaWZpY2F0aW9uJTIyJTVEKSUwQWNsYXNzJTIwRXNtTmV1cm9uQ29uZmlnKFRleHRFbmNvZGVyTmV1cm9uQ29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyME5PUk1BTElaRURfQ09ORklHX0NMQVNTJTIwJTNEJTIwTm9ybWFsaXplZENvbmZpZ01hbmFnZXIuZ2V0X25vcm1hbGl6ZWRfY29uZmlnX2NsYXNzKCUyMmJlcnQlMjIpJTBBJTIwJTIwJTIwJTIwQVRPTF9GT1JfVkFMSURBVElPTiUyMCUzRCUyMDFlLTMlMjAlMjAlMjMlMjBhYnNvbHV0ZSUyMHRvbGVyYW5jZSUyMHRvJTIwY29tcGFyZSUyMGZvciUyMGNvbXBhcmluZyUyMG1vZGVsJTIwb24lMjBDUFVzJTBBJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjBpbnB1dHMoc2VsZiklMjAtJTNFJTIwTGlzdCU1QnN0ciU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU1QiUyMmlucHV0X2lkcyUyMiUyQyUyMCUyMmF0dGVudGlvbl9tYXNrJTIyJTVEJTBB",highlighted:`
<span class="hljs-meta">@register_in_tasks_manager(<span class="hljs-params"><span class="hljs-string">&quot;esm&quot;</span>, *[<span class="hljs-string">&quot;feature-extraction&quot;</span>, <span class="hljs-string">&quot;fill-mask&quot;</span>, <span class="hljs-string">&quot;text-classification&quot;</span>, <span class="hljs-string">&quot;token-classification&quot;</span>]</span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">EsmNeuronConfig</span>(<span class="hljs-title class_ inherited__">TextEncoderNeuronConfig</span>):
    NORMALIZED_CONFIG_CLASS = NormalizedConfigManager.get_normalized_config_class(<span class="hljs-string">&quot;bert&quot;</span>)
    ATOL_FOR_VALIDATION = <span class="hljs-number">1e-3</span>  <span class="hljs-comment"># absolute tolerance to compare for comparing model on CPUs</span>

<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">inputs</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>]
`,wrap:!1}}),V=new P({props:{title:"Export and validate the model",local:"export-and-validate-the-model",headingTag:"h2"}}),L=new Ue({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwZmFjZWJvb2slMkZlc20yX3QzM182NTBNX1VSNTBEJTIwLS10YXNrJTIwdGV4dC1jbGFzc2lmaWNhdGlvbiUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAtLXNlcXVlbmNlX2xlbmd0aCUyMDE2JTIwZXNtX25ldXJvbiUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model facebook/esm2_t33_650M_UR50D --task text-classification --batch_size 1 --sequence_length 16 esm_neuron/',wrap:!1}}),R=new Ue({props:{code:"ZnJvbSUyMG9wdGltdW0uZXhwb3J0ZXJzLm5ldXJvbiUyMGltcG9ydCUyMHZhbGlkYXRlX21vZGVsX291dHB1dHMlMEElMEF2YWxpZGF0ZV9tb2RlbF9vdXRwdXRzKCUwQSUyMCUyMCUyMCUyMG5ldXJvbl9jb25maWclMkMlMjBiYXNlX21vZGVsJTJDJTIwbmV1cm9uX21vZGVsX3BhdGglMkMlMjBuZXVyb25fbmFtZWRfb3V0cHV0cyUyQyUyMG5ldXJvbl9jb25maWcuQVRPTF9GT1JfVkFMSURBVElPTiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> optimum.exporters.neuron <span class="hljs-keyword">import</span> validate_model_outputs

validate_model_outputs(
    neuron_config, base_model, neuron_model_path, neuron_named_outputs, neuron_config.ATOL_FOR_VALIDATION
)`,wrap:!1}}),q=new Ue({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZXNtX25ldXJvbiUyRiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJlc21fbmV1cm9uJTJGJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSequenceClassification

model = NeuronModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;esm_neuron/&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;esm_neuron/&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
logits = model(**inputs).logits`,wrap:!1}}),W=new P({props:{title:"Contribute to the GitHub repo",local:"contribute-to-the-github-repo",headingTag:"h2"}}),M=new lt({props:{$$slots:{default:[st]},$$scope:{ctx:Y}}}),{c(){p=i("meta"),g=s(),u=i("p"),A=s(),m(b.$$.fragment),O=s(),T=i("blockquote"),T.innerHTML=Je,D=s(),w=i("p"),w.innerHTML=je,K=s(),v=i("p"),v.textContent=Ne,ee=s(),C=i("ol"),C.innerHTML=ke,te=s(),m(_.$$.fragment),ne=s(),$=i("p"),$.textContent=He,le=s(),x=i("ol"),x.innerHTML=Xe,se=s(),U=i("p"),U.innerHTML=Ze,oe=s(),J=i("p"),J.textContent=Ve,ie=s(),j=i("ol"),j.innerHTML=Ie,ae=s(),m(N.$$.fragment),re=s(),k=i("p"),k.innerHTML=Ge,pe=s(),H=i("p"),H.innerHTML=Le,ue=s(),X=i("p"),X.innerHTML=Ee,me=s(),m(Z.$$.fragment),ce=s(),m(V.$$.fragment),de=s(),I=i("p"),I.textContent=Re,fe=s(),G=i("ul"),G.innerHTML=Be,he=s(),m(L.$$.fragment),ye=s(),E=i("p"),E.innerHTML=qe,Me=s(),m(R.$$.fragment),ge=s(),B=i("ul"),B.innerHTML=We,be=s(),m(q.$$.fragment),Te=s(),m(W.$$.fragment),we=s(),F=i("p"),F.textContent=Fe,ve=s(),S=i("ul"),S.innerHTML=Se,Ce=s(),m(M.$$.fragment),_e=s(),z=i("p"),z.textContent=ze,$e=s(),Q=i("p"),this.h()},l(e){const t=tt("svelte-u9bgzb",document.head);p=a(t,"META",{name:!0,content:!0}),t.forEach(n),g=o(e),u=a(e,"P",{}),Qe(u).forEach(n),A=o(e),c(b.$$.fragment,e),O=o(e),T=a(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(T)!=="svelte-1iqy6mr"&&(T.innerHTML=Je),D=o(e),w=a(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-d0p6r1"&&(w.innerHTML=je),K=o(e),v=a(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1awdjch"&&(v.textContent=Ne),ee=o(e),C=a(e,"OL",{"data-svelte-h":!0}),r(C)!=="svelte-1x19lno"&&(C.innerHTML=ke),te=o(e),c(_.$$.fragment,e),ne=o(e),$=a(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-12rzy01"&&($.textContent=He),le=o(e),x=a(e,"OL",{"data-svelte-h":!0}),r(x)!=="svelte-1bbfvek"&&(x.innerHTML=Xe),se=o(e),U=a(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1ez6yaq"&&(U.innerHTML=Ze),oe=o(e),J=a(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-tqmfwt"&&(J.textContent=Ve),ie=o(e),j=a(e,"OL",{"data-svelte-h":!0}),r(j)!=="svelte-wqsfdl"&&(j.innerHTML=Ie),ae=o(e),c(N.$$.fragment,e),re=o(e),k=a(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-krly5h"&&(k.innerHTML=Ge),pe=o(e),H=a(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-3w7mfw"&&(H.innerHTML=Le),ue=o(e),X=a(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-11pzsso"&&(X.innerHTML=Ee),me=o(e),c(Z.$$.fragment,e),ce=o(e),c(V.$$.fragment,e),de=o(e),I=a(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1ca0k65"&&(I.textContent=Re),fe=o(e),G=a(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-1j7x565"&&(G.innerHTML=Be),he=o(e),c(L.$$.fragment,e),ye=o(e),E=a(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1hlus0h"&&(E.innerHTML=qe),Me=o(e),c(R.$$.fragment,e),ge=o(e),B=a(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-7woav9"&&(B.innerHTML=We),be=o(e),c(q.$$.fragment,e),Te=o(e),c(W.$$.fragment,e),we=o(e),F=a(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-bmbrzm"&&(F.textContent=Fe),ve=o(e),S=a(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-1tee105"&&(S.innerHTML=Se),Ce=o(e),c(M.$$.fragment,e),_e=o(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-bydw52"&&(z.textContent=ze),$e=o(e),Q=a(e,"P",{}),Qe(Q).forEach(n),this.h()},h(){Pe(p,"name","hf:doc:metadata"),Pe(p,"content",it)},m(e,t){nt(document.head,p),l(e,g,t),l(e,u,t),l(e,A,t),d(b,e,t),l(e,O,t),l(e,T,t),l(e,D,t),l(e,w,t),l(e,K,t),l(e,v,t),l(e,ee,t),l(e,C,t),l(e,te,t),d(_,e,t),l(e,ne,t),l(e,$,t),l(e,le,t),l(e,x,t),l(e,se,t),l(e,U,t),l(e,oe,t),l(e,J,t),l(e,ie,t),l(e,j,t),l(e,ae,t),d(N,e,t),l(e,re,t),l(e,k,t),l(e,pe,t),l(e,H,t),l(e,ue,t),l(e,X,t),l(e,me,t),d(Z,e,t),l(e,ce,t),d(V,e,t),l(e,de,t),l(e,I,t),l(e,fe,t),l(e,G,t),l(e,he,t),d(L,e,t),l(e,ye,t),l(e,E,t),l(e,Me,t),d(R,e,t),l(e,ge,t),l(e,B,t),l(e,be,t),d(q,e,t),l(e,Te,t),d(W,e,t),l(e,we,t),l(e,F,t),l(e,ve,t),l(e,S,t),l(e,Ce,t),d(M,e,t),l(e,_e,t),l(e,z,t),l(e,$e,t),l(e,Q,t),xe=!0},p(e,[t]){const Ae={};t&2&&(Ae.$$scope={dirty:t,ctx:e}),M.$set(Ae)},i(e){xe||(f(b.$$.fragment,e),f(_.$$.fragment,e),f(N.$$.fragment,e),f(Z.$$.fragment,e),f(V.$$.fragment,e),f(L.$$.fragment,e),f(R.$$.fragment,e),f(q.$$.fragment,e),f(W.$$.fragment,e),f(M.$$.fragment,e),xe=!0)},o(e){h(b.$$.fragment,e),h(_.$$.fragment,e),h(N.$$.fragment,e),h(Z.$$.fragment,e),h(V.$$.fragment,e),h(L.$$.fragment,e),h(R.$$.fragment,e),h(q.$$.fragment,e),h(W.$$.fragment,e),h(M.$$.fragment,e),xe=!1},d(e){e&&(n(g),n(u),n(A),n(O),n(T),n(D),n(w),n(K),n(v),n(ee),n(C),n(te),n(ne),n($),n(le),n(x),n(se),n(U),n(oe),n(J),n(ie),n(j),n(ae),n(re),n(k),n(pe),n(H),n(ue),n(X),n(me),n(ce),n(de),n(I),n(fe),n(G),n(he),n(ye),n(E),n(Me),n(ge),n(B),n(be),n(Te),n(we),n(F),n(ve),n(S),n(Ce),n(_e),n(z),n($e),n(Q)),n(p),y(b,e),y(_,e),y(N,e),y(Z,e),y(V,e),y(L,e),y(R,e),y(q,e),y(W,e),y(M,e)}}}const it='{"title":"Adding support for new architectures","local":"adding-support-for-new-architectures","sections":[{"title":"Implement a custom Neuron configuration","local":"implement-a-custom-neuron-configuration","sections":[{"title":"Example: Adding support for ESM models","local":"example-adding-support-for-esm-models","sections":[],"depth":3}],"depth":2},{"title":"Export and validate the model","local":"export-and-validate-the-model","sections":[],"depth":2},{"title":"Contribute to the GitHub repo","local":"contribute-to-the-github-repo","sections":[],"depth":2}],"depth":1}';function at(Y){return Oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dt extends Ke{constructor(p){super(),et(this,p,at,ot,Ye,{})}}export{dt as component};
