import{s as We,o as Be,n as fe}from"../chunks/scheduler.8c3d61f6.js";import{S as Ie,i as Ve,g as f,s as u,r as w,A as ke,h,f as n,c as m,j as _e,u as g,x as b,k as ve,y as Re,a as l,v as $,d as J,t as T,w as Z}from"../chunks/index.da70eac4.js";import{T as ye}from"../chunks/Tip.1d9b8c37.js";import{C as q}from"../chunks/CodeBlock.a9c4becf.js";import{H as he,E as Xe}from"../chunks/getInferenceSnippets.725ed3d4.js";import{H as Pe,a as Ce}from"../chunks/HfOption.6c3b4e77.js";function xe(j){let t,c='We strongly recommend reading PyTorch’s <a href="https://pytorch.org/docs/stable/notes/randomness.html" rel="nofollow">statement about reproducibility</a>:',r,o,p="“Completely reproducible results are not guaranteed across PyTorch releases, individual commits, or different platforms. Furthermore, results may not be reproducible between CPU and GPU executions, even when using identical seeds.”";return{c(){t=f("p"),t.innerHTML=c,r=u(),o=f("p"),o.textContent=p},l(a){t=h(a,"P",{"data-svelte-h":!0}),b(t)!=="svelte-ccpr3c"&&(t.innerHTML=c),r=m(a),o=h(a,"P",{"data-svelte-h":!0}),b(o)!=="svelte-1ci17z2"&&(o.textContent=p)},m(a,y){l(a,t,y),l(a,r,y),l(a,o,y)},p:fe,d(a){a&&(n(t),n(r),n(o))}}}function Ee(j){let t,c="It might seem unintuitive to pass <code>Generator</code> objects to a pipeline instead of the integer value representing the seed. However, this is the recommended design when working with probabilistic models in PyTorch because a <code>Generator</code> is a <em>random state</em> that can be passed to multiple pipelines in a sequence. As soon as the <code>Generator</code> is consumed, the <em>state</em> is changed in place which means even if you passed the same <code>Generator</code> to a different pipeline, it won’t produce the same result because the state is already changed.";return{c(){t=f("p"),t.innerHTML=c},l(r){t=h(r,"P",{"data-svelte-h":!0}),b(t)!=="svelte-1jpg0yb"&&(t.innerHTML=c)},m(r,o){l(r,t,o)},p:fe,d(r){r&&n(t)}}}function ze(j){let t,c='To generate reproducible results on a CPU, you’ll need to use a PyTorch <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">Generator</a> and set a seed. Now when you run the code, it always prints a value of <code>1491.1711</code> because the <code>Generator</code> object with the seed is passed to all the random functions in the pipeline. You should get a similar, if not the same, result on whatever hardware and PyTorch version you’re using.',r,o,p;return o=new q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVBpcGVsaW5lJTBBJTBBZGRpbSUyMCUzRCUyMERESU1QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwZGRpbShudW1faW5mZXJlbmNlX3N0ZXBzJTNEMiUyQyUyMG91dHB1dF90eXBlJTNEJTIybnAlMjIlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyUwQXByaW50KG5wLmFicyhpbWFnZSkuc3VtKCkp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline

ddim = DDIMPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>, generator=generator).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`,wrap:!1}}),{c(){t=f("p"),t.innerHTML=c,r=u(),w(o.$$.fragment)},l(a){t=h(a,"P",{"data-svelte-h":!0}),b(t)!=="svelte-mi9bj0"&&(t.innerHTML=c),r=m(a),g(o.$$.fragment,a)},m(a,y){l(a,t,y),l(a,r,y),$(o,a,y),p=!0},p:fe,i(a){p||(J(o.$$.fragment,a),p=!0)},o(a){T(o.$$.fragment,a),p=!1},d(a){a&&(n(t),n(r)),Z(o,a)}}}function Se(j){let t,c="If reproducibility is important to your use case, we recommend always passing a CPU <code>Generator</code>. The performance loss is often negligible and you’ll generate more similar values than if the pipeline had been run on a GPU.";return{c(){t=f("p"),t.innerHTML=c},l(r){t=h(r,"P",{"data-svelte-h":!0}),b(t)!=="svelte-jred1k"&&(t.innerHTML=c)},m(r,o){l(r,t,o)},p:fe,d(r){r&&n(t)}}}function He(j){let t,c="Writing a reproducible pipeline on a GPU is a bit trickier, and full reproducibility across different hardware is not guaranteed because matrix multiplication - which diffusion pipelines require a lot of - is less deterministic on a GPU than a CPU. For example, if you run the same code example from the CPU example, you’ll get a different result even though the seed is identical. This is because the GPU uses a different random number generator than the CPU.",r,o,p,a,y='To avoid this issue, Diffusers has a <a href="/docs/diffusers/main/en/api/utilities#diffusers.utils.torch_utils.randn_tensor">randn_tensor()</a> function for creating random noise on the CPU, and then moving the tensor to a GPU if necessary. The <a href="/docs/diffusers/main/en/api/utilities#diffusers.utils.torch_utils.randn_tensor">randn_tensor()</a> function is used everywhere inside the pipeline. Now you can call <a href="https://pytorch.org/docs/stable/generated/torch.manual_seed.html" rel="nofollow">torch.manual_seed</a> which automatically creates a CPU <code>Generator</code> that can be passed to the pipeline even if it is being run on a GPU.',C,U,G,v,W,M,V=`Finally, more complex pipelines such as <a href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.UnCLIPPipeline">UnCLIPPipeline</a>, are often extremely
susceptible to precision error propagation. You’ll need to use
exactly the same hardware and PyTorch version for full reproducibility.`,_;return o=new q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVBpcGVsaW5lJTBBJTBBZGRpbSUyMCUzRCUyMERESU1QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFkZGltLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBkZGltKG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJucCUyMiUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuaW1hZ2VzJTBBcHJpbnQobnAuYWJzKGltYWdlKS5zdW0oKSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline

ddim = DDIMPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
ddim.to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>, generator=generator).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`,wrap:!1}}),U=new q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVBpcGVsaW5lJTBBJTBBZGRpbSUyMCUzRCUyMERESU1QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFkZGltLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2gubWFudWFsX3NlZWQoMCklMEFpbWFnZSUyMCUzRCUyMGRkaW0obnVtX2luZmVyZW5jZV9zdGVwcyUzRDIlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMm5wJTIyJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlMEFwcmludChucC5hYnMoaW1hZ2UpLnN1bSgpKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline

ddim = DDIMPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
ddim.to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>, generator=generator).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`,wrap:!1}}),v=new ye({props:{warning:!1,$$slots:{default:[Se]},$$scope:{ctx:j}}}),{c(){t=f("p"),t.textContent=c,r=u(),w(o.$$.fragment),p=u(),a=f("p"),a.innerHTML=y,C=u(),w(U.$$.fragment),G=u(),w(v.$$.fragment),W=u(),M=f("p"),M.innerHTML=V},l(i){t=h(i,"P",{"data-svelte-h":!0}),b(t)!=="svelte-1v52ack"&&(t.textContent=c),r=m(i),g(o.$$.fragment,i),p=m(i),a=h(i,"P",{"data-svelte-h":!0}),b(a)!=="svelte-x5gl1n"&&(a.innerHTML=y),C=m(i),g(U.$$.fragment,i),G=m(i),g(v.$$.fragment,i),W=m(i),M=h(i,"P",{"data-svelte-h":!0}),b(M)!=="svelte-1199c3s"&&(M.innerHTML=V)},m(i,d){l(i,t,d),l(i,r,d),$(o,i,d),l(i,p,d),l(i,a,d),l(i,C,d),$(U,i,d),l(i,G,d),$(v,i,d),l(i,W,d),l(i,M,d),_=!0},p(i,d){const Q={};d&2&&(Q.$$scope={dirty:d,ctx:i}),v.$set(Q)},i(i){_||(J(o.$$.fragment,i),J(U.$$.fragment,i),J(v.$$.fragment,i),_=!0)},o(i){T(o.$$.fragment,i),T(U.$$.fragment,i),T(v.$$.fragment,i),_=!1},d(i){i&&(n(t),n(r),n(p),n(a),n(C),n(G),n(W),n(M)),Z(o,i),Z(U,i),Z(v,i)}}}function Fe(j){let t,c,r,o;return t=new Ce({props:{id:"hardware",option:"CPU",$$slots:{default:[ze]},$$scope:{ctx:j}}}),r=new Ce({props:{id:"hardware",option:"GPU",$$slots:{default:[He]},$$scope:{ctx:j}}}),{c(){w(t.$$.fragment),c=u(),w(r.$$.fragment)},l(p){g(t.$$.fragment,p),c=m(p),g(r.$$.fragment,p)},m(p,a){$(t,p,a),l(p,c,a),$(r,p,a),o=!0},p(p,a){const y={};a&2&&(y.$$scope={dirty:a,ctx:p}),t.$set(y);const C={};a&2&&(C.$$scope={dirty:a,ctx:p}),r.$set(C)},i(p){o||(J(t.$$.fragment,p),J(r.$$.fragment,p),o=!0)},o(p){T(t.$$.fragment,p),T(r.$$.fragment,p),o=!1},d(p){p&&n(c),Z(t,p),Z(r,p)}}}function De(j){let t,c,r,o,p,a,y,C='Diffusion models are inherently random which is what allows it to generate different outputs every time it is run. But there are certain times when you want to generate the same output every time, like when you’re testing, replicating results, and even <a href="#deterministic-batch-generation">improving image quality</a>. While you can’t expect to get identical results across platforms, you can expect reproducible results across releases and platforms within a certain tolerance range (though even this may vary).',U,G,v="This guide will show you how to control randomness for deterministic generation on a CPU and GPU.",W,M,V,_,i,d,Q=`During inference, pipelines rely heavily on random sampling operations which include creating the
Gaussian noise tensors to denoise and adding noise to the scheduling step.`,K,k,be='Take a look at the tensor values in the <a href="/docs/diffusers/main/en/api/pipelines/ddim#diffusers.DDIMPipeline">DDIMPipeline</a> after two inference steps.',A,R,O,X,Me="Running the code above prints one value, but if you run it again you get a different value.",ee,P,we='Each time the pipeline is run, <a href="https://pytorch.org/docs/stable/generated/torch.randn.html" rel="nofollow">torch.randn</a> uses a different random seed to create the Gaussian noise tensors. This leads to a different result each time it is run and enables the diffusion pipeline to generate a different random image each time.',te,x,ge="But if you need to reliably generate the same image, that depends on whether you’re running the pipeline on a CPU or GPU.",se,B,ne,I,le,E,ae,z,$e="You can also configure PyTorch to use deterministic algorithms to create a reproducible pipeline. The downside is that deterministic algorithms may be slower than non-deterministic ones and you may observe a decrease in performance.",ie,S,Je='Non-deterministic behavior occurs when operations are launched in more than one CUDA stream. To avoid this, set the environment variable <a href="https://docs.nvidia.com/cuda/cublas/index.html#results-reproducibility" rel="nofollow">CUBLAS_WORKSPACE_CONFIG</a> to <code>:16:8</code> to only use one buffer size during runtime.',re,H,Te='PyTorch typically benchmarks multiple algorithms to select the fastest one, but if you want reproducibility, you should disable this feature because the benchmark may select different algorithms each time. Set Diffusers <a href="https://github.com/huggingface/diffusers/blob/142f353e1c638ff1d20bd798402b68f72c1ebbdd/src/diffusers/utils/testing_utils.py#L861" rel="nofollow">enable_full_determinism</a> to enable deterministic algorithms.',pe,F,oe,D,Ze="Now when you run the same pipeline twice, you’ll get identical results.",ue,L,me,N,ce,Y,de;return p=new he({props:{title:"Reproducible pipelines",local:"reproducible-pipelines",headingTag:"h1"}}),M=new ye({props:{warning:!1,$$slots:{default:[xe]},$$scope:{ctx:j}}}),_=new he({props:{title:"Control randomness",local:"control-randomness",headingTag:"h2"}}),R=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERESU1QaXBlbGluZSUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQSUwQWRkaW0lMjAlM0QlMjBERElNUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMCUyMmdvb2dsZSUyRmRkcG0tY2lmYXIxMC0zMiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBaW1hZ2UlMjAlM0QlMjBkZGltKG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJucCUyMikuaW1hZ2VzJTBBcHJpbnQobnAuYWJzKGltYWdlKS5zdW0oKSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

ddim = DDIMPipeline.from_pretrained( <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`,wrap:!1}}),B=new ye({props:{warning:!1,$$slots:{default:[Ee]},$$scope:{ctx:j}}}),I=new Pe({props:{id:"hardware",options:["CPU","GPU"],$$slots:{default:[Fe]},$$scope:{ctx:j}}}),E=new he({props:{title:"Deterministic algorithms",local:"deterministic-algorithms",headingTag:"h2"}}),F=new q({props:{code:"ZW5hYmxlX2Z1bGxfZGV0ZXJtaW5pc20oKQ==",highlighted:"enable_full_determinism()",wrap:!1}}),L=new q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVNjaGVkdWxlciUyQyUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBZyUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBiZWFyJTIwaXMlMjBwbGF5aW5nJTIwYSUyMGd1aXRhciUyMG9uJTIwVGltZXMlMjBTcXVhcmUlMjIlMEElMEFnLm1hbnVhbF9zZWVkKDApJTBBcmVzdWx0MSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTIwZ2VuZXJhdG9yJTNEZyUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlMEElMEFnLm1hbnVhbF9zZWVkKDApJTBBcmVzdWx0MiUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTIwZ2VuZXJhdG9yJTNEZyUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlMEElMEFwcmludCglMjJMX2luZiUyMGRpc3QlMjAlM0QlMjIlMkMlMjBhYnMocmVzdWx0MSUyMC0lMjByZXN1bHQyKS5tYXgoKSklMEElMjJMX2luZiUyMGRpc3QlMjAlM0QlMjB0ZW5zb3IoMC4lMkMlMjBkZXZpY2UlM0QnY3VkYSUzQTAnKSUyMg==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler, StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = DDIMScheduler.from_config(pipe.scheduler.config)
g = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A bear is playing a guitar on Times Square&quot;</span>

g.manual_seed(<span class="hljs-number">0</span>)
result1 = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">50</span>, generator=g, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images

g.manual_seed(<span class="hljs-number">0</span>)
result2 = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">50</span>, generator=g, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;L_inf dist =&quot;</span>, <span class="hljs-built_in">abs</span>(result1 - result2).<span class="hljs-built_in">max</span>())
<span class="hljs-string">&quot;L_inf dist = tensor(0., device=&#x27;cuda:0&#x27;)&quot;</span>`,wrap:!1}}),N=new Xe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/reusing_seeds.md"}}),{c(){t=f("meta"),c=u(),r=f("p"),o=u(),w(p.$$.fragment),a=u(),y=f("p"),y.innerHTML=C,U=u(),G=f("p"),G.textContent=v,W=u(),w(M.$$.fragment),V=u(),w(_.$$.fragment),i=u(),d=f("p"),d.textContent=Q,K=u(),k=f("p"),k.innerHTML=be,A=u(),w(R.$$.fragment),O=u(),X=f("p"),X.textContent=Me,ee=u(),P=f("p"),P.innerHTML=we,te=u(),x=f("p"),x.textContent=ge,se=u(),w(B.$$.fragment),ne=u(),w(I.$$.fragment),le=u(),w(E.$$.fragment),ae=u(),z=f("p"),z.textContent=$e,ie=u(),S=f("p"),S.innerHTML=Je,re=u(),H=f("p"),H.innerHTML=Te,pe=u(),w(F.$$.fragment),oe=u(),D=f("p"),D.textContent=Ze,ue=u(),w(L.$$.fragment),me=u(),w(N.$$.fragment),ce=u(),Y=f("p"),this.h()},l(e){const s=ke("svelte-u9bgzb",document.head);t=h(s,"META",{name:!0,content:!0}),s.forEach(n),c=m(e),r=h(e,"P",{}),_e(r).forEach(n),o=m(e),g(p.$$.fragment,e),a=m(e),y=h(e,"P",{"data-svelte-h":!0}),b(y)!=="svelte-13kjkmn"&&(y.innerHTML=C),U=m(e),G=h(e,"P",{"data-svelte-h":!0}),b(G)!=="svelte-117kc42"&&(G.textContent=v),W=m(e),g(M.$$.fragment,e),V=m(e),g(_.$$.fragment,e),i=m(e),d=h(e,"P",{"data-svelte-h":!0}),b(d)!=="svelte-1tn5oba"&&(d.textContent=Q),K=m(e),k=h(e,"P",{"data-svelte-h":!0}),b(k)!=="svelte-wj8lkp"&&(k.innerHTML=be),A=m(e),g(R.$$.fragment,e),O=m(e),X=h(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-1oqpaak"&&(X.textContent=Me),ee=m(e),P=h(e,"P",{"data-svelte-h":!0}),b(P)!=="svelte-ppvtm"&&(P.innerHTML=we),te=m(e),x=h(e,"P",{"data-svelte-h":!0}),b(x)!=="svelte-uamouh"&&(x.textContent=ge),se=m(e),g(B.$$.fragment,e),ne=m(e),g(I.$$.fragment,e),le=m(e),g(E.$$.fragment,e),ae=m(e),z=h(e,"P",{"data-svelte-h":!0}),b(z)!=="svelte-gypex5"&&(z.textContent=$e),ie=m(e),S=h(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-dxdx5v"&&(S.innerHTML=Je),re=m(e),H=h(e,"P",{"data-svelte-h":!0}),b(H)!=="svelte-180x72j"&&(H.innerHTML=Te),pe=m(e),g(F.$$.fragment,e),oe=m(e),D=h(e,"P",{"data-svelte-h":!0}),b(D)!=="svelte-b9yuf0"&&(D.textContent=Ze),ue=m(e),g(L.$$.fragment,e),me=m(e),g(N.$$.fragment,e),ce=m(e),Y=h(e,"P",{}),_e(Y).forEach(n),this.h()},h(){ve(t,"name","hf:doc:metadata"),ve(t,"content",Le)},m(e,s){Re(document.head,t),l(e,c,s),l(e,r,s),l(e,o,s),$(p,e,s),l(e,a,s),l(e,y,s),l(e,U,s),l(e,G,s),l(e,W,s),$(M,e,s),l(e,V,s),$(_,e,s),l(e,i,s),l(e,d,s),l(e,K,s),l(e,k,s),l(e,A,s),$(R,e,s),l(e,O,s),l(e,X,s),l(e,ee,s),l(e,P,s),l(e,te,s),l(e,x,s),l(e,se,s),$(B,e,s),l(e,ne,s),$(I,e,s),l(e,le,s),$(E,e,s),l(e,ae,s),l(e,z,s),l(e,ie,s),l(e,S,s),l(e,re,s),l(e,H,s),l(e,pe,s),$(F,e,s),l(e,oe,s),l(e,D,s),l(e,ue,s),$(L,e,s),l(e,me,s),$(N,e,s),l(e,ce,s),l(e,Y,s),de=!0},p(e,[s]){const je={};s&2&&(je.$$scope={dirty:s,ctx:e}),M.$set(je);const Ue={};s&2&&(Ue.$$scope={dirty:s,ctx:e}),B.$set(Ue);const Ge={};s&2&&(Ge.$$scope={dirty:s,ctx:e}),I.$set(Ge)},i(e){de||(J(p.$$.fragment,e),J(M.$$.fragment,e),J(_.$$.fragment,e),J(R.$$.fragment,e),J(B.$$.fragment,e),J(I.$$.fragment,e),J(E.$$.fragment,e),J(F.$$.fragment,e),J(L.$$.fragment,e),J(N.$$.fragment,e),de=!0)},o(e){T(p.$$.fragment,e),T(M.$$.fragment,e),T(_.$$.fragment,e),T(R.$$.fragment,e),T(B.$$.fragment,e),T(I.$$.fragment,e),T(E.$$.fragment,e),T(F.$$.fragment,e),T(L.$$.fragment,e),T(N.$$.fragment,e),de=!1},d(e){e&&(n(c),n(r),n(o),n(a),n(y),n(U),n(G),n(W),n(V),n(i),n(d),n(K),n(k),n(A),n(O),n(X),n(ee),n(P),n(te),n(x),n(se),n(ne),n(le),n(ae),n(z),n(ie),n(S),n(re),n(H),n(pe),n(oe),n(D),n(ue),n(me),n(ce),n(Y)),n(t),Z(p,e),Z(M,e),Z(_,e),Z(R,e),Z(B,e),Z(I,e),Z(E,e),Z(F,e),Z(L,e),Z(N,e)}}}const Le='{"title":"Reproducible pipelines","local":"reproducible-pipelines","sections":[{"title":"Control randomness","local":"control-randomness","sections":[],"depth":2},{"title":"Deterministic algorithms","local":"deterministic-algorithms","sections":[],"depth":2}],"depth":1}';function Ne(j){return Be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class et extends Ie{constructor(t){super(),Ve(this,t,Ne,De,We,{})}}export{et as component};
