import{s as ls,o as ds,n as qn}from"../chunks/scheduler.8c3d61f6.js";import{S as ps,i as cs,g as i,s as t,r as p,A as ms,h as o,f as s,c as a,j as y,u as c,x as w,k as I,y as n,a as h,v as m,d as g,t as u,w as f}from"../chunks/index.da70eac4.js";import{T as rs}from"../chunks/Tip.1d9b8c37.js";import{D as v}from"../chunks/Docstring.c021b19a.js";import{C as Gn}from"../chunks/CodeBlock.a9c4becf.js";import{E as Tt}from"../chunks/ExampleCodeBlock.56b4589c.js";import{H as pe,E as gs}from"../chunks/getInferenceSnippets.725ed3d4.js";function us(E){let d,x='<a href="../../optimization/cache">Caching</a> may also speed up inference by storing and reusing intermediate outputs.';return{c(){d=i("p"),d.innerHTML=x},l(b){d=o(b,"P",{"data-svelte-h":!0}),w(d)!=="svelte-yvhnlz"&&(d.innerHTML=x)},m(b,_){h(b,d,_)},p:qn,d(b){b&&s(d)}}}function fs(E){let d,x="The <code>guidance_scale</code> parameter in the pipeline is there to support future guidance-distilled models when they come up. Note that passing <code>guidance_scale</code> to the pipeline is ineffective. To enable classifier-free guidance, please pass <code>true_cfg_scale</code> and <code>negative_prompt</code> (even an empty negative prompt like ” ”) should enable classifier-free guidance computations.";return{c(){d=i("p"),d.innerHTML=x},l(b){d=o(b,"P",{"data-svelte-h":!0}),w(d)!=="svelte-1ftpam8"&&(d.innerHTML=x)},m(b,_){h(b,d,_)},p:qn,d(b){b&&s(d)}}}function hs(E){let d,x="Examples:",b,_,M;return _=new Gn({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwUXdlbkltYWdlUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuLUltYWdlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUwQSUyMyUyMERlcGVuZGluZyUyMG9uJTIwdGhlJTIwdmFyaWFudCUyMGJlaW5nJTIwdXNlZCUyQyUyMHRoZSUyMHBpcGVsaW5lJTIwY2FsbCUyMHdpbGwlMjBzbGlnaHRseSUyMHZhcnkuJTBBJTIzJTIwUmVmZXIlMjB0byUyMHRoZSUyMHBpcGVsaW5lJTIwZG9jdW1lbnRhdGlvbiUyMGZvciUyMG1vcmUlMjBkZXRhaWxzLiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnF3ZW5pbWFnZS5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImagePipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Depending on the variant being used, the pipeline call will slightly vary.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Refer to the pipeline documentation for more details.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;qwenimage.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,b=t(),p(_.$$.fragment)},l(l){d=o(l,"P",{"data-svelte-h":!0}),w(d)!=="svelte-kvfsh7"&&(d.textContent=x),b=a(l),c(_.$$.fragment,l)},m(l,T){h(l,d,T),h(l,b,T),m(_,l,T),M=!0},p:qn,i(l){M||(g(_.$$.fragment,l),M=!0)},o(l){u(_.$$.fragment,l),M=!1},d(l){l&&(s(d),s(b)),f(_,l)}}}function _s(E){let d,x="Examples:",b,_,M;return _=new Gn({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlSW1nMkltZ1BpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwUXdlbkltYWdlSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCkucmVzaXplKCgxMDI0JTJDJTIwMTAyNCkpJTBBcHJvbXB0JTIwJTNEJTIwJTIyY2F0JTIwd2l6YXJkJTJDJTIwZ2FuZGFsZiUyQyUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwZGV0YWlsZWQlMkMlMjBmYW50YXN5JTJDJTIwY3V0ZSUyQyUyMGFkb3JhYmxlJTJDJTIwUGl4YXIlMkMlMjBEaXNuZXklMjIlMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMCUyMiUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC45NSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlcy5zYXZlKCUyMnF3ZW5pbWFnZV9pbWcyaW1nLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImageImg2ImgPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImageImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(url).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt, negative_prompt=<span class="hljs-string">&quot; &quot;</span>, image=init_image, strength=<span class="hljs-number">0.95</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>images.save(<span class="hljs-string">&quot;qwenimage_img2img.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,b=t(),p(_.$$.fragment)},l(l){d=o(l,"P",{"data-svelte-h":!0}),w(d)!=="svelte-kvfsh7"&&(d.textContent=x),b=a(l),c(_.$$.fragment,l)},m(l,T){h(l,d,T),h(l,b,T),m(_,l,T),M=!0},p:qn,i(l){M||(g(_.$$.fragment,l),M=!0)},o(l){u(_.$$.fragment,l),M=!1},d(l){l&&(s(d),s(b)),f(_,l)}}}function ws(E){let d,x="Examples:",b,_,M;return _=new Gn({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlSW5wYWludFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwUXdlbkltYWdlSW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkZhY2UlMjBvZiUyMGElMjB5ZWxsb3clMjBjYXQlMkMlMjBoaWdoJTIwcmVzb2x1dGlvbiUyQyUyMHNpdHRpbmclMjBvbiUyMGElMjBwYXJrJTIwYmVuY2glMjIlMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW8ucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1b19tYXNrLnBuZyUyMiUwQXNvdXJjZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCklMEFtYXNrJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyJTIwJTIyJTJDJTIwaW1hZ2UlM0Rzb3VyY2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFzayUyQyUyMHN0cmVuZ3RoJTNEMC44NSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIycXdlbmltYWdlX2lucGFpbnRpbmcucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImageInpaintPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImageInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>source = load_image(img_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = load_image(mask_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, negative_prompt=<span class="hljs-string">&quot; &quot;</span>, image=source, mask_image=mask, strength=<span class="hljs-number">0.85</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;qwenimage_inpainting.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,b=t(),p(_.$$.fragment)},l(l){d=o(l,"P",{"data-svelte-h":!0}),w(d)!=="svelte-kvfsh7"&&(d.textContent=x),b=a(l),c(_.$$.fragment,l)},m(l,T){h(l,d,T),h(l,b,T),m(_,l,T),M=!0},p:qn,i(l){M||(g(_.$$.fragment,l),M=!0)},o(l){u(_.$$.fragment,l),M=!1},d(l){l&&(s(d),s(b)),f(_,l)}}}function bs(E){let d,x="Examples:",b,_,M;return _=new Gn({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlRWRpdFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwUXdlbkltYWdlRWRpdFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbi1JbWFnZS1FZGl0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnlhcm4tYXJ0LXBpa2FjaHUucG5nJTIyJTBBKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFwcm9tcHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyTWFrZSUyMFBpa2FjaHUlMjBob2xkJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMCdRd2VuJTIwRWRpdCUyMGlzJTIwYXdlc29tZSclMkMlMjB5YXJuJTIwYXJ0JTIwc3R5bGUlMkMlMjBkZXRhaWxlZCUyQyUyMHZpYnJhbnQlMjBjb2xvcnMlMjIlMEEpJTBBJTIzJTIwRGVwZW5kaW5nJTIwb24lMjB0aGUlMjB2YXJpYW50JTIwYmVpbmclMjB1c2VkJTJDJTIwdGhlJTIwcGlwZWxpbmUlMjBjYWxsJTIwd2lsbCUyMHNsaWdodGx5JTIwdmFyeS4lMEElMjMlMjBSZWZlciUyMHRvJTIwdGhlJTIwcGlwZWxpbmUlMjBkb2N1bWVudGF0aW9uJTIwZm9yJTIwbW9yZSUyMGRldGFpbHMuJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJxd2VuaW1hZ2VfZWRpdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImageEditPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImageEditPipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image-Edit&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/yarn-art-pikachu.png&quot;</span>
<span class="hljs-meta">... </span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Make Pikachu hold a sign that says &#x27;Qwen Edit is awesome&#x27;, yarn art style, detailed, vibrant colors&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Depending on the variant being used, the pipeline call will slightly vary.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Refer to the pipeline documentation for more details.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(image, prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;qwenimage_edit.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,b=t(),p(_.$$.fragment)},l(l){d=o(l,"P",{"data-svelte-h":!0}),w(d)!=="svelte-kvfsh7"&&(d.textContent=x),b=a(l),c(_.$$.fragment,l)},m(l,T){h(l,d,T),h(l,b,T),m(_,l,T),M=!0},p:qn,i(l){M||(g(_.$$.fragment,l),M=!0)},o(l){u(_.$$.fragment,l),M=!1},d(l){l&&(s(d),s(b)),f(_,l)}}}function ys(E){let d,x,b,_,M,l,T,xa='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/>',Nn,ce,$a="Qwen-Image from the Qwen team is an image generation foundation model in the Qwen series that achieves significant advances in complex text rendering and precise image editing. Experiments show strong general capabilities in both image generation and editing, with exceptional performance in text rendering, especially for Chinese.",Bn,me,Qa="Qwen-Image comes in the following variants:",Dn,ge,Ja='<thead><tr><th align="center">model type</th> <th align="center">model id</th></tr></thead> <tbody><tr><td align="center">Qwen-Image</td> <td align="center"><a href="https://huggingface.co/Qwen/Qwen-Image" rel="nofollow"><code>Qwen/Qwen-Image</code></a></td></tr> <tr><td align="center">Qwen-Image-Edit</td> <td align="center"><a href="https://huggingface.co/Qwen/Qwen-Image-Edit" rel="nofollow"><code>Qwen/Qwen-Image-Edit</code></a></td></tr></tbody>',Xn,N,Rn,ue,An,fe,ka=`Use a LoRA from <code>lightx2v/Qwen-Image-Lightning</code> to speed up inference by reducing the
number of steps. Refer to the code snippet below:`,zn,B,sn,Ua="Code",xt,he,Hn,D,Fn,_e,Yn,$,we,$t,on,ja="The QwenImage pipeline for text-to-image generation.",Qt,Z,be,Jt,rn,Pa="Function invoked when calling the pipeline for generation.",kt,X,Ut,R,ye,jt,ln,Ca=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Pt,A,Ie,Ct,dn,Ea=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Et,z,ve,Zt,pn,Za=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Lt,H,Me,Wt,cn,La=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,qt,mn,Te,Sn,xe,On,Q,$e,Vt,gn,Wa="The QwenImage pipeline for text-to-image generation.",Gt,L,Qe,Nt,un,qa="Function invoked when calling the pipeline for generation.",Bt,F,Dt,Y,Je,Xt,fn,Va=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Rt,S,ke,At,hn,Ga=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,zt,O,Ue,Ht,_n,Na=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Ft,K,je,Yt,wn,Ba=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,St,bn,Pe,Kn,Ce,et,J,Ee,Ot,yn,Da="The QwenImage pipeline for text-to-image generation.",Kt,W,Ze,ea,In,Xa="Function invoked when calling the pipeline for generation.",na,ee,ta,ne,Le,aa,vn,Ra=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,sa,te,We,ia,Mn,Aa=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,oa,ae,qe,ra,Tn,za=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,la,se,Ve,da,xn,Ha=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,pa,$n,Ge,nt,Ne,tt,k,Be,ca,Qn,Fa="The Qwen-Image-Edit pipeline for image editing.",ma,q,De,ga,Jn,Ya="Function invoked when calling the pipeline for generation.",ua,ie,fa,oe,Xe,ha,kn,Sa=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,_a,re,Re,wa,Un,Oa=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,ba,le,Ae,ya,jn,Ka=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Ia,de,ze,va,Pn,es=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Ma,Cn,He,at,Fe,st,Ye,ns="<li>all</li> <li><strong>call</strong></li>",it,Se,ot,V,Oe,Ta,En,ts="Output class for Stable Diffusion pipelines.",rt,Ke,lt,Vn,dt;return M=new pe({props:{title:"QwenImage",local:"qwenimage",headingTag:"h1"}}),N=new rs({props:{$$slots:{default:[us]},$$scope:{ctx:E}}}),ue=new pe({props:{title:"LoRA for faster inference",local:"lora-for-faster-inference",headingTag:"h2"}}),he=new Gn({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, FlowMatchEulerDiscreteScheduler
<span class="hljs-keyword">import</span> torch 
<span class="hljs-keyword">import</span> math

ckpt_id = <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>

<span class="hljs-comment"># From</span>
<span class="hljs-comment"># https://github.com/ModelTC/Qwen-Image-Lightning/blob/342260e8f5468d2f24d084ce04f55e101007118b/generate_with_diffusers.py#L82C9-L97C10</span>
scheduler_config = {
    <span class="hljs-string">&quot;base_image_seq_len&quot;</span>: <span class="hljs-number">256</span>,
    <span class="hljs-string">&quot;base_shift&quot;</span>: math.log(<span class="hljs-number">3</span>),  <span class="hljs-comment"># We use shift=3 in distillation</span>
    <span class="hljs-string">&quot;invert_sigmas&quot;</span>: <span class="hljs-literal">False</span>,
    <span class="hljs-string">&quot;max_image_seq_len&quot;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&quot;max_shift&quot;</span>: math.log(<span class="hljs-number">3</span>),  <span class="hljs-comment"># We use shift=3 in distillation</span>
    <span class="hljs-string">&quot;num_train_timesteps&quot;</span>: <span class="hljs-number">1000</span>,
    <span class="hljs-string">&quot;shift&quot;</span>: <span class="hljs-number">1.0</span>,
    <span class="hljs-string">&quot;shift_terminal&quot;</span>: <span class="hljs-literal">None</span>,  <span class="hljs-comment"># set shift_terminal to None</span>
    <span class="hljs-string">&quot;stochastic_sampling&quot;</span>: <span class="hljs-literal">False</span>,
    <span class="hljs-string">&quot;time_shift_type&quot;</span>: <span class="hljs-string">&quot;exponential&quot;</span>,
    <span class="hljs-string">&quot;use_beta_sigmas&quot;</span>: <span class="hljs-literal">False</span>,
    <span class="hljs-string">&quot;use_dynamic_shifting&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;use_exponential_sigmas&quot;</span>: <span class="hljs-literal">False</span>,
    <span class="hljs-string">&quot;use_karras_sigmas&quot;</span>: <span class="hljs-literal">False</span>,
}
scheduler = FlowMatchEulerDiscreteScheduler.from_config(scheduler_config)
pipe = DiffusionPipeline.from_pretrained(
    ckpt_id, scheduler=scheduler, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.load_lora_weights(
    <span class="hljs-string">&quot;lightx2v/Qwen-Image-Lightning&quot;</span>, weight_name=<span class="hljs-string">&quot;Qwen-Image-Lightning-8steps-V1.0.safetensors&quot;</span>
)

prompt = <span class="hljs-string">&quot;a tiny astronaut hatching from an egg on the moon, Ultra HD, 4K, cinematic composition.&quot;</span>
negative_prompt = <span class="hljs-string">&quot; &quot;</span>
image = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    width=<span class="hljs-number">1024</span>,
    height=<span class="hljs-number">1024</span>,
    num_inference_steps=<span class="hljs-number">8</span>,
    true_cfg_scale=<span class="hljs-number">1.0</span>,
    generator=torch.manual_seed(<span class="hljs-number">0</span>),
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;qwen_fewsteps.png&quot;</span>)`,wrap:!1}}),D=new rs({props:{$$slots:{default:[fs]},$$scope:{ctx:E}}}),_e=new pe({props:{title:"QwenImagePipeline",local:"diffusers.QwenImagePipeline",headingTag:"h2"}}),we=new v({props:{name:"class diffusers.QwenImagePipeline",anchor:"diffusers.QwenImagePipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImagePipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImagePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImagePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImagePipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImagePipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L132"}}),be=new v({props:{name:"__call__",anchor:"diffusers.QwenImagePipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImagePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImagePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImagePipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>true_cfg_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Classifier-free guidance is enabled by
setting <code>true_cfg_scale &gt; 1</code> and a provided <code>negative_prompt</code>. Higher guidance scale encourages to
generate images that are closely linked to the text <code>prompt</code>, usually at the expense of lower image
quality.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImagePipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImagePipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImagePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImagePipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImagePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
A guidance scale value for guidance distilled models. Unlike the traditional classifier-free guidance
where the guidance scale is applied during inference through noise prediction rescaling, guidance
distilled models take the guidance scale directly as an input parameter during forward pass. Guidance
scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images
that are closely linked to the text <code>prompt</code>, usually at the expense of lower image quality. This
parameter in the pipeline is there to support future guidance-distilled models when they come up. It is
ignored when not using guidance distilled models. To enable traditional classifier-free guidance,
please pass <code>true_cfg_scale &gt; 1.0</code> and <code>negative_prompt</code> (even an empty negative prompt like &#x201D; &#x201D; should
enable classifier-free guidance computations).`,name:"guidance_scale"},{anchor:"diffusers.QwenImagePipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImagePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImagePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImagePipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImagePipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImagePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImagePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImagePipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImagePipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImagePipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImagePipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L427",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),X=new Tt({props:{anchor:"diffusers.QwenImagePipeline.__call__.example",$$slots:{default:[hs]},$$scope:{ctx:E}}}),ye=new v({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImagePipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L353"}}),Ie=new v({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImagePipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L368"}}),ve=new v({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImagePipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L346"}}),Me=new v({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImagePipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L360"}}),Te=new v({props:{name:"encode_prompt",anchor:"diffusers.QwenImagePipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImagePipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImagePipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImagePipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImagePipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L226"}}),xe=new pe({props:{title:"QwenImageImg2ImgPipeline",local:"diffusers.QwenImageImg2ImgPipeline",headingTag:"h2"}}),$e=new v({props:{name:"class diffusers.QwenImageImg2ImgPipeline",anchor:"diffusers.QwenImageImg2ImgPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImageImg2ImgPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImageImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImageImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImageImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImageImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L134"}}),Qe=new v({props:{name:"__call__",anchor:"diffusers.QwenImageImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>true_cfg_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Classifier-free guidance is enabled by
setting <code>true_cfg_scale &gt; 1</code> and a provided <code>negative_prompt</code>. Higher guidance scale encourages to
generate images that are closely linked to the text <code>prompt</code>, usually at the expense of lower image
quality.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
A guidance scale value for guidance distilled models. Unlike the traditional classifier-free guidance
where the guidance scale is applied during inference through noise prediction rescaling, guidance
distilled models take the guidance scale directly as an input parameter during forward pass. Guidance
scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images
that are closely linked to the text <code>prompt</code>, usually at the expense of lower image quality. This
parameter in the pipeline is there to support future guidance-distilled models when they come up. It is
ignored when not using guidance distilled models. To enable traditional classifier-free guidance,
please pass <code>true_cfg_scale &gt; 1.0</code> and <code>negative_prompt</code> (even an empty negative prompt like &#x201D; &#x201D; should
enable classifier-free guidance computations).`,name:"guidance_scale"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L501",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),F=new Tt({props:{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.example",$$slots:{default:[_s]},$$scope:{ctx:E}}}),Je=new v({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImageImg2ImgPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L402"}}),ke=new v({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImageImg2ImgPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L417"}}),Ue=new v({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImageImg2ImgPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L395"}}),je=new v({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImageImg2ImgPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L409"}}),Pe=new v({props:{name:"encode_prompt",anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L269"}}),Ce=new pe({props:{title:"QwenImageInpaintPipeline",local:"diffusers.QwenImageInpaintPipeline",headingTag:"h2"}}),Ee=new v({props:{name:"class diffusers.QwenImageInpaintPipeline",anchor:"diffusers.QwenImageInpaintPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImageInpaintPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImageInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImageInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImageInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImageInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L137"}}),Ze=new v({props:{name:"__call__",anchor:"diffusers.QwenImageInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"masked_image_latents",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImageInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>true_cfg_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Classifier-free guidance is enabled by
setting <code>true_cfg_scale &gt; 1</code> and a provided <code>negative_prompt</code>. Higher guidance scale encourages to
generate images that are closely linked to the text <code>prompt</code>, usually at the expense of lower image
quality.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.mask_image_latent",description:`<strong>mask_image_latent</strong> (<code>torch.Tensor</code>, <code>List[torch.Tensor]</code>) &#x2014;
<code>Tensor</code> representing an image batch to mask <code>image</code> generated by VAE. If not provided, the mask
latents tensor will be generated by <code>mask_image</code>.`,name:"mask_image_latent"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
A guidance scale value for guidance distilled models. Unlike the traditional classifier-free guidance
where the guidance scale is applied during inference through noise prediction rescaling, guidance
distilled models take the guidance scale directly as an input parameter during forward pass. Guidance
scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images
that are closely linked to the text <code>prompt</code>, usually at the expense of lower image quality. This
parameter in the pipeline is there to support future guidance-distilled models when they come up. It is
ignored when not using guidance distilled models. To enable traditional classifier-free guidance,
please pass <code>true_cfg_scale &gt; 1.0</code> and <code>negative_prompt</code> (even an empty negative prompt like &#x201D; &#x201D; should
enable classifier-free guidance computations).`,name:"guidance_scale"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L611",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),ee=new Tt({props:{anchor:"diffusers.QwenImageInpaintPipeline.__call__.example",$$slots:{default:[ws]},$$scope:{ctx:E}}}),Le=new v({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImageInpaintPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L429"}}),We=new v({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImageInpaintPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L444"}}),qe=new v({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImageInpaintPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L422"}}),Ve=new v({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImageInpaintPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L436"}}),Ge=new v({props:{name:"encode_prompt",anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L280"}}),Ne=new pe({props:{title:"QwenImageEditPipeline",local:"diffusers.QwenImageEditPipeline",headingTag:"h2"}}),Be=new v({props:{name:"class diffusers.QwenImageEditPipeline",anchor:"diffusers.QwenImageEditPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"processor",val:": Qwen2VLProcessor"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImageEditPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImageEditPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImageEditPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImageEditPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImageEditPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L165"}}),De=new v({props:{name:"__call__",anchor:"diffusers.QwenImageEditPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImageEditPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImageEditPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImageEditPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
true_cfg_scale (<code>float</code>, <em>optional</em>, defaults to 1.0): Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free
Diffusion Guidance</a>. <code>true_cfg_scale</code> is defined as <code>w</code> of
equation 2. of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Classifier-free guidance is
enabled by setting <code>true_cfg_scale &gt; 1</code> and a provided <code>negative_prompt</code>. Higher guidance scale
encourages to generate images that are closely linked to the text <code>prompt</code>, usually at the expense of
lower image quality.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImageEditPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImageEditPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImageEditPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImageEditPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImageEditPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
A guidance scale value for guidance distilled models. Unlike the traditional classifier-free guidance
where the guidance scale is applied during inference through noise prediction rescaling, guidance
distilled models take the guidance scale directly as an input parameter during forward pass. Guidance
scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images
that are closely linked to the text <code>prompt</code>, usually at the expense of lower image quality. This
parameter in the pipeline is there to support future guidance-distilled models when they come up. It is
ignored when not using guidance distilled models. To enable traditional classifier-free guidance,
please pass <code>true_cfg_scale &gt; 1.0</code> and <code>negative_prompt</code> (even an empty negative prompt like &#x201D; &#x201D; should
enable classifier-free guidance computations).`,name:"guidance_scale"},{anchor:"diffusers.QwenImageEditPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageEditPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImageEditPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImageEditPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImageEditPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImageEditPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImageEditPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImageEditPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImageEditPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImageEditPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImageEditPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L523",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),ie=new Tt({props:{anchor:"diffusers.QwenImageEditPipeline.__call__.example",$$slots:{default:[bs]},$$scope:{ctx:E}}}),Xe=new v({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImageEditPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L426"}}),Re=new v({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImageEditPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L441"}}),Ae=new v({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImageEditPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L419"}}),ze=new v({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImageEditPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L433"}}),He=new v({props:{name:"encode_prompt",anchor:"diffusers.QwenImageEditPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"image",val:": typing.Optional[torch.Tensor] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImageEditPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImageEditPipeline.encode_prompt.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
image to be encoded`,name:"image"},{anchor:"diffusers.QwenImageEditPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImageEditPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageEditPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L274"}}),Fe=new pe({props:{title:"QwenImaggeControlNetPipeline",local:"qwenimaggecontrolnetpipeline",headingTag:"h2"}}),Se=new pe({props:{title:"QwenImagePipelineOutput",local:"diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput",headingTag:"h2"}}),Oe=new v({props:{name:"class diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput",anchor:"diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or numpy array of shape <code>(batch_size, height, width, num_channels)</code>. PIL images or numpy array present the denoised images of the diffusion pipeline.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_output.py#L11"}}),Ke=new gs({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/qwenimage.md"}}),{c(){d=i("meta"),x=t(),b=i("p"),_=t(),p(M.$$.fragment),l=t(),T=i("div"),T.innerHTML=xa,Nn=t(),ce=i("p"),ce.textContent=$a,Bn=t(),me=i("p"),me.textContent=Qa,Dn=t(),ge=i("table"),ge.innerHTML=Ja,Xn=t(),p(N.$$.fragment),Rn=t(),p(ue.$$.fragment),An=t(),fe=i("p"),fe.innerHTML=ka,zn=t(),B=i("details"),sn=i("summary"),sn.textContent=Ua,xt=t(),p(he.$$.fragment),Hn=t(),p(D.$$.fragment),Fn=t(),p(_e.$$.fragment),Yn=t(),$=i("div"),p(we.$$.fragment),$t=t(),on=i("p"),on.textContent=ja,Qt=t(),Z=i("div"),p(be.$$.fragment),Jt=t(),rn=i("p"),rn.textContent=Pa,kt=t(),p(X.$$.fragment),Ut=t(),R=i("div"),p(ye.$$.fragment),jt=t(),ln=i("p"),ln.innerHTML=Ca,Pt=t(),A=i("div"),p(Ie.$$.fragment),Ct=t(),dn=i("p"),dn.innerHTML=Ea,Et=t(),z=i("div"),p(ve.$$.fragment),Zt=t(),pn=i("p"),pn.textContent=Za,Lt=t(),H=i("div"),p(Me.$$.fragment),Wt=t(),cn=i("p"),cn.textContent=La,qt=t(),mn=i("div"),p(Te.$$.fragment),Sn=t(),p(xe.$$.fragment),On=t(),Q=i("div"),p($e.$$.fragment),Vt=t(),gn=i("p"),gn.textContent=Wa,Gt=t(),L=i("div"),p(Qe.$$.fragment),Nt=t(),un=i("p"),un.textContent=qa,Bt=t(),p(F.$$.fragment),Dt=t(),Y=i("div"),p(Je.$$.fragment),Xt=t(),fn=i("p"),fn.innerHTML=Va,Rt=t(),S=i("div"),p(ke.$$.fragment),At=t(),hn=i("p"),hn.innerHTML=Ga,zt=t(),O=i("div"),p(Ue.$$.fragment),Ht=t(),_n=i("p"),_n.textContent=Na,Ft=t(),K=i("div"),p(je.$$.fragment),Yt=t(),wn=i("p"),wn.textContent=Ba,St=t(),bn=i("div"),p(Pe.$$.fragment),Kn=t(),p(Ce.$$.fragment),et=t(),J=i("div"),p(Ee.$$.fragment),Ot=t(),yn=i("p"),yn.textContent=Da,Kt=t(),W=i("div"),p(Ze.$$.fragment),ea=t(),In=i("p"),In.textContent=Xa,na=t(),p(ee.$$.fragment),ta=t(),ne=i("div"),p(Le.$$.fragment),aa=t(),vn=i("p"),vn.innerHTML=Ra,sa=t(),te=i("div"),p(We.$$.fragment),ia=t(),Mn=i("p"),Mn.innerHTML=Aa,oa=t(),ae=i("div"),p(qe.$$.fragment),ra=t(),Tn=i("p"),Tn.textContent=za,la=t(),se=i("div"),p(Ve.$$.fragment),da=t(),xn=i("p"),xn.textContent=Ha,pa=t(),$n=i("div"),p(Ge.$$.fragment),nt=t(),p(Ne.$$.fragment),tt=t(),k=i("div"),p(Be.$$.fragment),ca=t(),Qn=i("p"),Qn.textContent=Fa,ma=t(),q=i("div"),p(De.$$.fragment),ga=t(),Jn=i("p"),Jn.textContent=Ya,ua=t(),p(ie.$$.fragment),fa=t(),oe=i("div"),p(Xe.$$.fragment),ha=t(),kn=i("p"),kn.innerHTML=Sa,_a=t(),re=i("div"),p(Re.$$.fragment),wa=t(),Un=i("p"),Un.innerHTML=Oa,ba=t(),le=i("div"),p(Ae.$$.fragment),ya=t(),jn=i("p"),jn.textContent=Ka,Ia=t(),de=i("div"),p(ze.$$.fragment),va=t(),Pn=i("p"),Pn.textContent=es,Ma=t(),Cn=i("div"),p(He.$$.fragment),at=t(),p(Fe.$$.fragment),st=t(),Ye=i("ul"),Ye.innerHTML=ns,it=t(),p(Se.$$.fragment),ot=t(),V=i("div"),p(Oe.$$.fragment),Ta=t(),En=i("p"),En.textContent=ts,rt=t(),p(Ke.$$.fragment),lt=t(),Vn=i("p"),this.h()},l(e){const r=ms("svelte-u9bgzb",document.head);d=o(r,"META",{name:!0,content:!0}),r.forEach(s),x=a(e),b=o(e,"P",{}),y(b).forEach(s),_=a(e),c(M.$$.fragment,e),l=a(e),T=o(e,"DIV",{class:!0,"data-svelte-h":!0}),w(T)!=="svelte-si9ct8"&&(T.innerHTML=xa),Nn=a(e),ce=o(e,"P",{"data-svelte-h":!0}),w(ce)!=="svelte-f9n2hx"&&(ce.textContent=$a),Bn=a(e),me=o(e,"P",{"data-svelte-h":!0}),w(me)!=="svelte-1t9xj8p"&&(me.textContent=Qa),Dn=a(e),ge=o(e,"TABLE",{"data-svelte-h":!0}),w(ge)!=="svelte-h5rfp5"&&(ge.innerHTML=Ja),Xn=a(e),c(N.$$.fragment,e),Rn=a(e),c(ue.$$.fragment,e),An=a(e),fe=o(e,"P",{"data-svelte-h":!0}),w(fe)!=="svelte-upho6n"&&(fe.innerHTML=ka),zn=a(e),B=o(e,"DETAILS",{});var en=y(B);sn=o(en,"SUMMARY",{"data-svelte-h":!0}),w(sn)!=="svelte-14caxiv"&&(sn.textContent=Ua),xt=a(en),c(he.$$.fragment,en),en.forEach(s),Hn=a(e),c(D.$$.fragment,e),Fn=a(e),c(_e.$$.fragment,e),Yn=a(e),$=o(e,"DIV",{class:!0});var U=y($);c(we.$$.fragment,U),$t=a(U),on=o(U,"P",{"data-svelte-h":!0}),w(on)!=="svelte-1b1rx25"&&(on.textContent=ja),Qt=a(U),Z=o(U,"DIV",{class:!0});var G=y(Z);c(be.$$.fragment,G),Jt=a(G),rn=o(G,"P",{"data-svelte-h":!0}),w(rn)!=="svelte-v78lg8"&&(rn.textContent=Pa),kt=a(G),c(X.$$.fragment,G),G.forEach(s),Ut=a(U),R=o(U,"DIV",{class:!0});var nn=y(R);c(ye.$$.fragment,nn),jt=a(nn),ln=o(nn,"P",{"data-svelte-h":!0}),w(ln)!=="svelte-1s3c06i"&&(ln.innerHTML=Ca),nn.forEach(s),Pt=a(U),A=o(U,"DIV",{class:!0});var tn=y(A);c(Ie.$$.fragment,tn),Ct=a(tn),dn=o(tn,"P",{"data-svelte-h":!0}),w(dn)!=="svelte-pkn4ui"&&(dn.innerHTML=Ea),tn.forEach(s),Et=a(U),z=o(U,"DIV",{class:!0});var an=y(z);c(ve.$$.fragment,an),Zt=a(an),pn=o(an,"P",{"data-svelte-h":!0}),w(pn)!=="svelte-14bnrb6"&&(pn.textContent=Za),an.forEach(s),Lt=a(U),H=o(U,"DIV",{class:!0});var pt=y(H);c(Me.$$.fragment,pt),Wt=a(pt),cn=o(pt,"P",{"data-svelte-h":!0}),w(cn)!=="svelte-1xwrf7t"&&(cn.textContent=La),pt.forEach(s),qt=a(U),mn=o(U,"DIV",{class:!0});var as=y(mn);c(Te.$$.fragment,as),as.forEach(s),U.forEach(s),Sn=a(e),c(xe.$$.fragment,e),On=a(e),Q=o(e,"DIV",{class:!0});var j=y(Q);c($e.$$.fragment,j),Vt=a(j),gn=o(j,"P",{"data-svelte-h":!0}),w(gn)!=="svelte-1b1rx25"&&(gn.textContent=Wa),Gt=a(j),L=o(j,"DIV",{class:!0});var Zn=y(L);c(Qe.$$.fragment,Zn),Nt=a(Zn),un=o(Zn,"P",{"data-svelte-h":!0}),w(un)!=="svelte-v78lg8"&&(un.textContent=qa),Bt=a(Zn),c(F.$$.fragment,Zn),Zn.forEach(s),Dt=a(j),Y=o(j,"DIV",{class:!0});var ct=y(Y);c(Je.$$.fragment,ct),Xt=a(ct),fn=o(ct,"P",{"data-svelte-h":!0}),w(fn)!=="svelte-1s3c06i"&&(fn.innerHTML=Va),ct.forEach(s),Rt=a(j),S=o(j,"DIV",{class:!0});var mt=y(S);c(ke.$$.fragment,mt),At=a(mt),hn=o(mt,"P",{"data-svelte-h":!0}),w(hn)!=="svelte-pkn4ui"&&(hn.innerHTML=Ga),mt.forEach(s),zt=a(j),O=o(j,"DIV",{class:!0});var gt=y(O);c(Ue.$$.fragment,gt),Ht=a(gt),_n=o(gt,"P",{"data-svelte-h":!0}),w(_n)!=="svelte-14bnrb6"&&(_n.textContent=Na),gt.forEach(s),Ft=a(j),K=o(j,"DIV",{class:!0});var ut=y(K);c(je.$$.fragment,ut),Yt=a(ut),wn=o(ut,"P",{"data-svelte-h":!0}),w(wn)!=="svelte-1xwrf7t"&&(wn.textContent=Ba),ut.forEach(s),St=a(j),bn=o(j,"DIV",{class:!0});var ss=y(bn);c(Pe.$$.fragment,ss),ss.forEach(s),j.forEach(s),Kn=a(e),c(Ce.$$.fragment,e),et=a(e),J=o(e,"DIV",{class:!0});var P=y(J);c(Ee.$$.fragment,P),Ot=a(P),yn=o(P,"P",{"data-svelte-h":!0}),w(yn)!=="svelte-1b1rx25"&&(yn.textContent=Da),Kt=a(P),W=o(P,"DIV",{class:!0});var Ln=y(W);c(Ze.$$.fragment,Ln),ea=a(Ln),In=o(Ln,"P",{"data-svelte-h":!0}),w(In)!=="svelte-v78lg8"&&(In.textContent=Xa),na=a(Ln),c(ee.$$.fragment,Ln),Ln.forEach(s),ta=a(P),ne=o(P,"DIV",{class:!0});var ft=y(ne);c(Le.$$.fragment,ft),aa=a(ft),vn=o(ft,"P",{"data-svelte-h":!0}),w(vn)!=="svelte-1s3c06i"&&(vn.innerHTML=Ra),ft.forEach(s),sa=a(P),te=o(P,"DIV",{class:!0});var ht=y(te);c(We.$$.fragment,ht),ia=a(ht),Mn=o(ht,"P",{"data-svelte-h":!0}),w(Mn)!=="svelte-pkn4ui"&&(Mn.innerHTML=Aa),ht.forEach(s),oa=a(P),ae=o(P,"DIV",{class:!0});var _t=y(ae);c(qe.$$.fragment,_t),ra=a(_t),Tn=o(_t,"P",{"data-svelte-h":!0}),w(Tn)!=="svelte-14bnrb6"&&(Tn.textContent=za),_t.forEach(s),la=a(P),se=o(P,"DIV",{class:!0});var wt=y(se);c(Ve.$$.fragment,wt),da=a(wt),xn=o(wt,"P",{"data-svelte-h":!0}),w(xn)!=="svelte-1xwrf7t"&&(xn.textContent=Ha),wt.forEach(s),pa=a(P),$n=o(P,"DIV",{class:!0});var is=y($n);c(Ge.$$.fragment,is),is.forEach(s),P.forEach(s),nt=a(e),c(Ne.$$.fragment,e),tt=a(e),k=o(e,"DIV",{class:!0});var C=y(k);c(Be.$$.fragment,C),ca=a(C),Qn=o(C,"P",{"data-svelte-h":!0}),w(Qn)!=="svelte-cjiar3"&&(Qn.textContent=Fa),ma=a(C),q=o(C,"DIV",{class:!0});var Wn=y(q);c(De.$$.fragment,Wn),ga=a(Wn),Jn=o(Wn,"P",{"data-svelte-h":!0}),w(Jn)!=="svelte-v78lg8"&&(Jn.textContent=Ya),ua=a(Wn),c(ie.$$.fragment,Wn),Wn.forEach(s),fa=a(C),oe=o(C,"DIV",{class:!0});var bt=y(oe);c(Xe.$$.fragment,bt),ha=a(bt),kn=o(bt,"P",{"data-svelte-h":!0}),w(kn)!=="svelte-1s3c06i"&&(kn.innerHTML=Sa),bt.forEach(s),_a=a(C),re=o(C,"DIV",{class:!0});var yt=y(re);c(Re.$$.fragment,yt),wa=a(yt),Un=o(yt,"P",{"data-svelte-h":!0}),w(Un)!=="svelte-pkn4ui"&&(Un.innerHTML=Oa),yt.forEach(s),ba=a(C),le=o(C,"DIV",{class:!0});var It=y(le);c(Ae.$$.fragment,It),ya=a(It),jn=o(It,"P",{"data-svelte-h":!0}),w(jn)!=="svelte-14bnrb6"&&(jn.textContent=Ka),It.forEach(s),Ia=a(C),de=o(C,"DIV",{class:!0});var vt=y(de);c(ze.$$.fragment,vt),va=a(vt),Pn=o(vt,"P",{"data-svelte-h":!0}),w(Pn)!=="svelte-1xwrf7t"&&(Pn.textContent=es),vt.forEach(s),Ma=a(C),Cn=o(C,"DIV",{class:!0});var os=y(Cn);c(He.$$.fragment,os),os.forEach(s),C.forEach(s),at=a(e),c(Fe.$$.fragment,e),st=a(e),Ye=o(e,"UL",{"data-svelte-h":!0}),w(Ye)!=="svelte-1p6h59i"&&(Ye.innerHTML=ns),it=a(e),c(Se.$$.fragment,e),ot=a(e),V=o(e,"DIV",{class:!0});var Mt=y(V);c(Oe.$$.fragment,Mt),Ta=a(Mt),En=o(Mt,"P",{"data-svelte-h":!0}),w(En)!=="svelte-1qpjiuf"&&(En.textContent=ts),Mt.forEach(s),rt=a(e),c(Ke.$$.fragment,e),lt=a(e),Vn=o(e,"P",{}),y(Vn).forEach(s),this.h()},h(){I(d,"name","hf:doc:metadata"),I(d,"content",Is),I(T,"class","flex flex-wrap space-x-1"),I(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I($n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){n(document.head,d),h(e,x,r),h(e,b,r),h(e,_,r),m(M,e,r),h(e,l,r),h(e,T,r),h(e,Nn,r),h(e,ce,r),h(e,Bn,r),h(e,me,r),h(e,Dn,r),h(e,ge,r),h(e,Xn,r),m(N,e,r),h(e,Rn,r),m(ue,e,r),h(e,An,r),h(e,fe,r),h(e,zn,r),h(e,B,r),n(B,sn),n(B,xt),m(he,B,null),h(e,Hn,r),m(D,e,r),h(e,Fn,r),m(_e,e,r),h(e,Yn,r),h(e,$,r),m(we,$,null),n($,$t),n($,on),n($,Qt),n($,Z),m(be,Z,null),n(Z,Jt),n(Z,rn),n(Z,kt),m(X,Z,null),n($,Ut),n($,R),m(ye,R,null),n(R,jt),n(R,ln),n($,Pt),n($,A),m(Ie,A,null),n(A,Ct),n(A,dn),n($,Et),n($,z),m(ve,z,null),n(z,Zt),n(z,pn),n($,Lt),n($,H),m(Me,H,null),n(H,Wt),n(H,cn),n($,qt),n($,mn),m(Te,mn,null),h(e,Sn,r),m(xe,e,r),h(e,On,r),h(e,Q,r),m($e,Q,null),n(Q,Vt),n(Q,gn),n(Q,Gt),n(Q,L),m(Qe,L,null),n(L,Nt),n(L,un),n(L,Bt),m(F,L,null),n(Q,Dt),n(Q,Y),m(Je,Y,null),n(Y,Xt),n(Y,fn),n(Q,Rt),n(Q,S),m(ke,S,null),n(S,At),n(S,hn),n(Q,zt),n(Q,O),m(Ue,O,null),n(O,Ht),n(O,_n),n(Q,Ft),n(Q,K),m(je,K,null),n(K,Yt),n(K,wn),n(Q,St),n(Q,bn),m(Pe,bn,null),h(e,Kn,r),m(Ce,e,r),h(e,et,r),h(e,J,r),m(Ee,J,null),n(J,Ot),n(J,yn),n(J,Kt),n(J,W),m(Ze,W,null),n(W,ea),n(W,In),n(W,na),m(ee,W,null),n(J,ta),n(J,ne),m(Le,ne,null),n(ne,aa),n(ne,vn),n(J,sa),n(J,te),m(We,te,null),n(te,ia),n(te,Mn),n(J,oa),n(J,ae),m(qe,ae,null),n(ae,ra),n(ae,Tn),n(J,la),n(J,se),m(Ve,se,null),n(se,da),n(se,xn),n(J,pa),n(J,$n),m(Ge,$n,null),h(e,nt,r),m(Ne,e,r),h(e,tt,r),h(e,k,r),m(Be,k,null),n(k,ca),n(k,Qn),n(k,ma),n(k,q),m(De,q,null),n(q,ga),n(q,Jn),n(q,ua),m(ie,q,null),n(k,fa),n(k,oe),m(Xe,oe,null),n(oe,ha),n(oe,kn),n(k,_a),n(k,re),m(Re,re,null),n(re,wa),n(re,Un),n(k,ba),n(k,le),m(Ae,le,null),n(le,ya),n(le,jn),n(k,Ia),n(k,de),m(ze,de,null),n(de,va),n(de,Pn),n(k,Ma),n(k,Cn),m(He,Cn,null),h(e,at,r),m(Fe,e,r),h(e,st,r),h(e,Ye,r),h(e,it,r),m(Se,e,r),h(e,ot,r),h(e,V,r),m(Oe,V,null),n(V,Ta),n(V,En),h(e,rt,r),m(Ke,e,r),h(e,lt,r),h(e,Vn,r),dt=!0},p(e,[r]){const en={};r&2&&(en.$$scope={dirty:r,ctx:e}),N.$set(en);const U={};r&2&&(U.$$scope={dirty:r,ctx:e}),D.$set(U);const G={};r&2&&(G.$$scope={dirty:r,ctx:e}),X.$set(G);const nn={};r&2&&(nn.$$scope={dirty:r,ctx:e}),F.$set(nn);const tn={};r&2&&(tn.$$scope={dirty:r,ctx:e}),ee.$set(tn);const an={};r&2&&(an.$$scope={dirty:r,ctx:e}),ie.$set(an)},i(e){dt||(g(M.$$.fragment,e),g(N.$$.fragment,e),g(ue.$$.fragment,e),g(he.$$.fragment,e),g(D.$$.fragment,e),g(_e.$$.fragment,e),g(we.$$.fragment,e),g(be.$$.fragment,e),g(X.$$.fragment,e),g(ye.$$.fragment,e),g(Ie.$$.fragment,e),g(ve.$$.fragment,e),g(Me.$$.fragment,e),g(Te.$$.fragment,e),g(xe.$$.fragment,e),g($e.$$.fragment,e),g(Qe.$$.fragment,e),g(F.$$.fragment,e),g(Je.$$.fragment,e),g(ke.$$.fragment,e),g(Ue.$$.fragment,e),g(je.$$.fragment,e),g(Pe.$$.fragment,e),g(Ce.$$.fragment,e),g(Ee.$$.fragment,e),g(Ze.$$.fragment,e),g(ee.$$.fragment,e),g(Le.$$.fragment,e),g(We.$$.fragment,e),g(qe.$$.fragment,e),g(Ve.$$.fragment,e),g(Ge.$$.fragment,e),g(Ne.$$.fragment,e),g(Be.$$.fragment,e),g(De.$$.fragment,e),g(ie.$$.fragment,e),g(Xe.$$.fragment,e),g(Re.$$.fragment,e),g(Ae.$$.fragment,e),g(ze.$$.fragment,e),g(He.$$.fragment,e),g(Fe.$$.fragment,e),g(Se.$$.fragment,e),g(Oe.$$.fragment,e),g(Ke.$$.fragment,e),dt=!0)},o(e){u(M.$$.fragment,e),u(N.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(D.$$.fragment,e),u(_e.$$.fragment,e),u(we.$$.fragment,e),u(be.$$.fragment,e),u(X.$$.fragment,e),u(ye.$$.fragment,e),u(Ie.$$.fragment,e),u(ve.$$.fragment,e),u(Me.$$.fragment,e),u(Te.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(Qe.$$.fragment,e),u(F.$$.fragment,e),u(Je.$$.fragment,e),u(ke.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),u(Pe.$$.fragment,e),u(Ce.$$.fragment,e),u(Ee.$$.fragment,e),u(Ze.$$.fragment,e),u(ee.$$.fragment,e),u(Le.$$.fragment,e),u(We.$$.fragment,e),u(qe.$$.fragment,e),u(Ve.$$.fragment,e),u(Ge.$$.fragment,e),u(Ne.$$.fragment,e),u(Be.$$.fragment,e),u(De.$$.fragment,e),u(ie.$$.fragment,e),u(Xe.$$.fragment,e),u(Re.$$.fragment,e),u(Ae.$$.fragment,e),u(ze.$$.fragment,e),u(He.$$.fragment,e),u(Fe.$$.fragment,e),u(Se.$$.fragment,e),u(Oe.$$.fragment,e),u(Ke.$$.fragment,e),dt=!1},d(e){e&&(s(x),s(b),s(_),s(l),s(T),s(Nn),s(ce),s(Bn),s(me),s(Dn),s(ge),s(Xn),s(Rn),s(An),s(fe),s(zn),s(B),s(Hn),s(Fn),s(Yn),s($),s(Sn),s(On),s(Q),s(Kn),s(et),s(J),s(nt),s(tt),s(k),s(at),s(st),s(Ye),s(it),s(ot),s(V),s(rt),s(lt),s(Vn)),s(d),f(M,e),f(N,e),f(ue,e),f(he),f(D,e),f(_e,e),f(we),f(be),f(X),f(ye),f(Ie),f(ve),f(Me),f(Te),f(xe,e),f($e),f(Qe),f(F),f(Je),f(ke),f(Ue),f(je),f(Pe),f(Ce,e),f(Ee),f(Ze),f(ee),f(Le),f(We),f(qe),f(Ve),f(Ge),f(Ne,e),f(Be),f(De),f(ie),f(Xe),f(Re),f(Ae),f(ze),f(He),f(Fe,e),f(Se,e),f(Oe),f(Ke,e)}}}const Is='{"title":"QwenImage","local":"qwenimage","sections":[{"title":"LoRA for faster inference","local":"lora-for-faster-inference","sections":[],"depth":2},{"title":"QwenImagePipeline","local":"diffusers.QwenImagePipeline","sections":[],"depth":2},{"title":"QwenImageImg2ImgPipeline","local":"diffusers.QwenImageImg2ImgPipeline","sections":[],"depth":2},{"title":"QwenImageInpaintPipeline","local":"diffusers.QwenImageInpaintPipeline","sections":[],"depth":2},{"title":"QwenImageEditPipeline","local":"diffusers.QwenImageEditPipeline","sections":[],"depth":2},{"title":"QwenImaggeControlNetPipeline","local":"qwenimaggecontrolnetpipeline","sections":[],"depth":2},{"title":"QwenImagePipelineOutput","local":"diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput","sections":[],"depth":2}],"depth":1}';function vs(E){return ds(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Us extends ps{constructor(d){super(),cs(this,d,vs,ys,ls,{})}}export{Us as component};
