import{s as $n,o as xn,n as Ie}from"../chunks/scheduler.8c3d61f6.js";import{S as In,i as Pn,g as c,s as i,r as g,A as qn,h as p,f as n,c as s,j as $,u as h,x as u,k as x,y as d,a,v as f,d as _,t as b,w as v}from"../chunks/index.da70eac4.js";import{T as Ot}from"../chunks/Tip.1d9b8c37.js";import{D as N}from"../chunks/Docstring.c021b19a.js";import{C as $t}from"../chunks/CodeBlock.a9c4becf.js";import{E as Tt}from"../chunks/ExampleCodeBlock.56b4589c.js";import{H as Xe,E as Ln}from"../chunks/getInferenceSnippets.725ed3d4.js";function Nn(T){let o,y=`The early Marigold models (<code>v1-0</code> and earlier) were optimized for best results with at least 10 inference steps.
LCM models were later developed to enable high-quality inference in just 1 to 4 steps.
Marigold models <code>v1-1</code> and later use the DDIM scheduler to achieve optimal
results in as few as 1 to 4 steps.`;return{c(){o=c("p"),o.innerHTML=y},l(l){o=p(l,"P",{"data-svelte-h":!0}),u(o)!=="svelte-mlhdsh"&&(o.innerHTML=y)},m(l,m){a(l,o,m)},p:Ie,d(l){l&&n(o)}}}function Jn(T){let o,y=`Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff
between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to
efficiently load the same components into multiple pipelines.
Also, to know more about reducing the memory usage of this pipeline, refer to the [“Reduce memory usage”] section
<a href="../../using-diffusers/svd#reduce-memory-usage">here</a>.`;return{c(){o=c("p"),o.innerHTML=y},l(l){o=p(l,"P",{"data-svelte-h":!0}),u(o)!=="svelte-f2sd4m"&&(o.innerHTML=y)},m(l,m){a(l,o,m)},p:Ie,d(l){l&&n(o)}}}function zn(T){let o,y=`Marigold pipelines were designed and tested with the scheduler embedded in the model checkpoint.
The optimal number of inference steps varies by scheduler, with no universal value that works best across all cases.
To accommodate this, the <code>num_inference_steps</code> parameter in the pipeline’s <code>__call__</code> method defaults to <code>None</code> (see the
API reference).
Unless set explicitly, it inherits the value from the <code>default_denoising_steps</code> field in the checkpoint configuration
file (<code>model_index.json</code>).
This ensures high-quality predictions when invoking the pipeline with only the <code>image</code> argument.`;return{c(){o=c("p"),o.innerHTML=y},l(l){o=p(l,"P",{"data-svelte-h":!0}),u(o)!=="svelte-1leqq59"&&(o.innerHTML=y)},m(l,m){a(l,o,m)},p:Ie,d(l){l&&n(o)}}}function kn(T){let o,y="Examples:",l,m,M;return m=new $t({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkRGVwdGhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycHJzLWV0aCUyRm1hcmlnb2xkLWRlcHRoLXYxLTElMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMGRpZmZ1c2Vycy51dGlscy5sb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGbWFyaWdvbGRtb25vZGVwdGguZ2l0aHViLmlvJTJGaW1hZ2VzJTJGZWluc3RlaW4uanBnJTIyKSUwQWRlcHRoJTIwJTNEJTIwcGlwZShpbWFnZSklMEElMEF2aXMlMjAlM0QlMjBwaXBlLmltYWdlX3Byb2Nlc3Nvci52aXN1YWxpemVfZGVwdGgoZGVwdGgucHJlZGljdGlvbiklMEF2aXMlNUIwJTVELnNhdmUoJTIyZWluc3RlaW5fZGVwdGgucG5nJTIyKSUwQSUwQWRlcHRoXzE2Yml0JTIwJTNEJTIwcGlwZS5pbWFnZV9wcm9jZXNzb3IuZXhwb3J0X2RlcHRoX3RvXzE2Yml0X3BuZyhkZXB0aC5wcmVkaWN0aW9uKSUwQWRlcHRoXzE2Yml0JTVCMCU1RC5zYXZlKCUyMmVpbnN0ZWluX2RlcHRoXzE2Yml0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> diffusers
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;prs-eth/marigold-depth-v1-1&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = pipe(image)

<span class="hljs-meta">&gt;&gt;&gt; </span>vis = pipe.image_processor.visualize_depth(depth.prediction)
<span class="hljs-meta">&gt;&gt;&gt; </span>vis[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_depth.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>depth_16bit = pipe.image_processor.export_depth_to_16bit_png(depth.prediction)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth_16bit[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_depth_16bit.png&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=y,l=i(),g(m.$$.fragment)},l(r){o=p(r,"P",{"data-svelte-h":!0}),u(o)!=="svelte-kvfsh7"&&(o.textContent=y),l=s(r),h(m.$$.fragment,r)},m(r,w){a(r,o,w),a(r,l,w),f(m,r,w),M=!0},p:Ie,i(r){M||(_(m.$$.fragment,r),M=!0)},o(r){b(m.$$.fragment,r),M=!1},d(r){r&&(n(o),n(l)),v(m,r)}}}function jn(T){let o,y="Examples:",l,m,M;return m=new $t({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkTm9ybWFsc1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJwcnMtZXRoJTJGbWFyaWdvbGQtbm9ybWFscy12MS0xJTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBkaWZmdXNlcnMudXRpbHMubG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRm1hcmlnb2xkbW9ub2RlcHRoLmdpdGh1Yi5pbyUyRmltYWdlcyUyRmVpbnN0ZWluLmpwZyUyMiklMEFub3JtYWxzJTIwJTNEJTIwcGlwZShpbWFnZSklMEElMEF2aXMlMjAlM0QlMjBwaXBlLmltYWdlX3Byb2Nlc3Nvci52aXN1YWxpemVfbm9ybWFscyhub3JtYWxzLnByZWRpY3Rpb24pJTBBdmlzJTVCMCU1RC5zYXZlKCUyMmVpbnN0ZWluX25vcm1hbHMucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> diffusers
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = diffusers.MarigoldNormalsPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;prs-eth/marigold-normals-v1-1&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>normals = pipe(image)

<span class="hljs-meta">&gt;&gt;&gt; </span>vis = pipe.image_processor.visualize_normals(normals.prediction)
<span class="hljs-meta">&gt;&gt;&gt; </span>vis[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_normals.png&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=y,l=i(),g(m.$$.fragment)},l(r){o=p(r,"P",{"data-svelte-h":!0}),u(o)!=="svelte-kvfsh7"&&(o.textContent=y),l=s(r),h(m.$$.fragment,r)},m(r,w){a(r,o,w),a(r,l,w),f(m,r,w),M=!0},p:Ie,i(r){M||(_(m.$$.fragment,r),M=!0)},o(r){b(m.$$.fragment,r),M=!1},d(r){r&&(n(o),n(l)),v(m,r)}}}function Dn(T){let o,y="Examples:",l,m,M;return m=new $t({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkSW50cmluc2ljc1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJwcnMtZXRoJTJGbWFyaWdvbGQtaWlkLWFwcGVhcmFuY2UtdjEtMSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwZGlmZnVzZXJzLnV0aWxzLmxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZtYXJpZ29sZG1vbm9kZXB0aC5naXRodWIuaW8lMkZpbWFnZXMlMkZlaW5zdGVpbi5qcGclMjIpJTBBaW50cmluc2ljcyUyMCUzRCUyMHBpcGUoaW1hZ2UpJTBBJTBBdmlzJTIwJTNEJTIwcGlwZS5pbWFnZV9wcm9jZXNzb3IudmlzdWFsaXplX2ludHJpbnNpY3MoaW50cmluc2ljcy5wcmVkaWN0aW9uJTJDJTIwcGlwZS50YXJnZXRfcHJvcGVydGllcyklMEF2aXMlNUIwJTVEJTVCJTIyYWxiZWRvJTIyJTVELnNhdmUoJTIyZWluc3RlaW5fYWxiZWRvLnBuZyUyMiklMEF2aXMlNUIwJTVEJTVCJTIycm91Z2huZXNzJTIyJTVELnNhdmUoJTIyZWluc3RlaW5fcm91Z2huZXNzLnBuZyUyMiklMEF2aXMlNUIwJTVEJTVCJTIybWV0YWxsaWNpdHklMjIlNUQuc2F2ZSglMjJlaW5zdGVpbl9tZXRhbGxpY2l0eS5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> diffusers
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = diffusers.MarigoldIntrinsicsPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;prs-eth/marigold-iid-appearance-v1-1&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>intrinsics = pipe(image)

<span class="hljs-meta">&gt;&gt;&gt; </span>vis = pipe.image_processor.visualize_intrinsics(intrinsics.prediction, pipe.target_properties)
<span class="hljs-meta">&gt;&gt;&gt; </span>vis[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;albedo&quot;</span>].save(<span class="hljs-string">&quot;einstein_albedo.png&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vis[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;roughness&quot;</span>].save(<span class="hljs-string">&quot;einstein_roughness.png&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vis[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;metallicity&quot;</span>].save(<span class="hljs-string">&quot;einstein_metallicity.png&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=y,l=i(),g(m.$$.fragment)},l(r){o=p(r,"P",{"data-svelte-h":!0}),u(o)!=="svelte-kvfsh7"&&(o.textContent=y),l=s(r),h(m.$$.fragment,r)},m(r,w){a(r,o,w),a(r,l,w),f(m,r,w),M=!0},p:Ie,i(r){M||(_(m.$$.fragment,r),M=!0)},o(r){b(m.$$.fragment,r),M=!1},d(r){r&&(n(o),n(l)),v(m,r)}}}function Cn(T){let o,y;return o=new $t({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkSW50cmluc2ljc1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJwcnMtZXRoJTJGbWFyaWdvbGQtaWlkLWxpZ2h0aW5nLXYxLTElMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMGRpZmZ1c2Vycy51dGlscy5sb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGbWFyaWdvbGRtb25vZGVwdGguZ2l0aHViLmlvJTJGaW1hZ2VzJTJGZWluc3RlaW4uanBnJTIyKSUwQWludHJpbnNpY3MlMjAlM0QlMjBwaXBlKGltYWdlKSUwQSUwQXZpcyUyMCUzRCUyMHBpcGUuaW1hZ2VfcHJvY2Vzc29yLnZpc3VhbGl6ZV9pbnRyaW5zaWNzKGludHJpbnNpY3MucHJlZGljdGlvbiUyQyUyMHBpcGUudGFyZ2V0X3Byb3BlcnRpZXMpJTBBdmlzJTVCMCU1RCU1QiUyMmFsYmVkbyUyMiU1RC5zYXZlKCUyMmVpbnN0ZWluX2FsYmVkby5wbmclMjIpJTBBdmlzJTVCMCU1RCU1QiUyMnNoYWRpbmclMjIlNUQuc2F2ZSglMjJlaW5zdGVpbl9zaGFkaW5nLnBuZyUyMiklMEF2aXMlNUIwJTVEJTVCJTIycmVzaWR1YWwlMjIlNUQuc2F2ZSglMjJlaW5zdGVpbl9yZXNpZHVhbC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> diffusers
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = diffusers.MarigoldIntrinsicsPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;prs-eth/marigold-iid-lighting-v1-1&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>intrinsics = pipe(image)

<span class="hljs-meta">&gt;&gt;&gt; </span>vis = pipe.image_processor.visualize_intrinsics(intrinsics.prediction, pipe.target_properties)
<span class="hljs-meta">&gt;&gt;&gt; </span>vis[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;albedo&quot;</span>].save(<span class="hljs-string">&quot;einstein_albedo.png&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vis[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;shading&quot;</span>].save(<span class="hljs-string">&quot;einstein_shading.png&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vis[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;residual&quot;</span>].save(<span class="hljs-string">&quot;einstein_residual.png&quot;</span>)`,wrap:!1}}),{c(){g(o.$$.fragment)},l(l){h(o.$$.fragment,l)},m(l,m){f(o,l,m),y=!0},p:Ie,i(l){y||(_(o.$$.fragment,l),y=!0)},o(l){b(o.$$.fragment,l),y=!1},d(l){v(o,l)}}}function Wn(T){let o,y,l,m,M,r,w,Yt='<img src="https://marigoldmonodepth.github.io/images/teaser_collage_compressed.jpg" alt="marigold"/>',Se,K,Qt=`Marigold was proposed in
<a href="https://huggingface.co/papers/2312.02145" rel="nofollow">Repurposing Diffusion-Based Image Generators for Monocular Depth Estimation</a>,
a CVPR 2024 Oral paper by
<a href="http://www.kebingxin.com/" rel="nofollow">Bingxin Ke</a>,
<a href="https://www.obukhov.ai/" rel="nofollow">Anton Obukhov</a>,
<a href="https://shengyuh.github.io/" rel="nofollow">Shengyu Huang</a>,
<a href="https://nandometzger.github.io/" rel="nofollow">Nando Metzger</a>,
<a href="https://rcdaudt.github.io/" rel="nofollow">Rodrigo Caye Daudt</a>, and
<a href="https://scholar.google.com/citations?user=FZuNgqIAAAAJ&amp;hl=en" rel="nofollow">Konrad Schindler</a>.
The core idea is to <strong>repurpose the generative prior of Text-to-Image Latent Diffusion Models (LDMs) for traditional
computer vision tasks</strong>.
This approach was explored by fine-tuning Stable Diffusion for <strong>Monocular Depth Estimation</strong>, as demonstrated in the
teaser above.`,Oe,ee,Kt=`Marigold was later extended in the follow-up paper,
<a href="https://huggingface.co/papers/2312.02145" rel="nofollow">Marigold: Affordable Adaptation of Diffusion-Based Image Generators for Image Analysis</a>,
authored by
<a href="http://www.kebingxin.com/" rel="nofollow">Bingxin Ke</a>,
<a href="https://www.linkedin.com/in/kevin-qu-b3417621b/?locale=en_US" rel="nofollow">Kevin Qu</a>,
<a href="https://tianfwang.github.io/" rel="nofollow">Tianfu Wang</a>,
<a href="https://nandometzger.github.io/" rel="nofollow">Nando Metzger</a>,
<a href="https://shengyuh.github.io/" rel="nofollow">Shengyu Huang</a>,
<a href="https://www.linkedin.com/in/bobboli0202/" rel="nofollow">Bo Li</a>,
<a href="https://www.obukhov.ai/" rel="nofollow">Anton Obukhov</a>, and
<a href="https://scholar.google.com/citations?user=FZuNgqIAAAAJ&amp;hl=en" rel="nofollow">Konrad Schindler</a>.
This work expanded Marigold to support new modalities such as <strong>Surface Normals</strong> and <strong>Intrinsic Image Decomposition</strong>
(IID), introduced a training protocol for <strong>Latent Consistency Models</strong> (LCM), and demonstrated <strong>High-Resolution</strong> (HR)
processing capability.`,Ye,V,Qe,te,Ke,ne,en=`Each pipeline is tailored for a specific computer vision task, processing an input RGB image and generating a
corresponding prediction.
Currently, the following computer vision tasks are implemented:`,et,oe,tn='<thead><tr><th>Pipeline</th> <th>Recommended Model Checkpoints</th> <th align="center">Spaces (Interactive Apps)</th> <th>Predicted Modalities</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_depth.py" rel="nofollow">MarigoldDepthPipeline</a></td> <td><a href="https://huggingface.co/prs-eth/marigold-depth-v1-1" rel="nofollow">prs-eth/marigold-depth-v1-1</a></td> <td align="center"><a href="https://huggingface.co/spaces/prs-eth/marigold" rel="nofollow">Depth Estimation</a></td> <td><a href="https://en.wikipedia.org/wiki/Depth_map" rel="nofollow">Depth</a>, <a href="https://en.wikipedia.org/wiki/Binocular_disparity" rel="nofollow">Disparity</a></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_normals.py" rel="nofollow">MarigoldNormalsPipeline</a></td> <td><a href="https://huggingface.co/prs-eth/marigold-normals-v1-1" rel="nofollow">prs-eth/marigold-normals-v1-1</a></td> <td align="center"><a href="https://huggingface.co/spaces/prs-eth/marigold-normals" rel="nofollow">Surface Normals Estimation</a></td> <td><a href="https://en.wikipedia.org/wiki/Normal_mapping" rel="nofollow">Surface normals</a></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_intrinsics.py" rel="nofollow">MarigoldIntrinsicsPipeline</a></td> <td><a href="https://huggingface.co/prs-eth/marigold-iid-appearance-v1-1" rel="nofollow">prs-eth/marigold-iid-appearance-v1-1</a>,<br/><a href="https://huggingface.co/prs-eth/marigold-iid-lighting-v1-1" rel="nofollow">prs-eth/marigold-iid-lighting-v1-1</a></td> <td align="center"><a href="https://huggingface.co/spaces/prs-eth/marigold-iid" rel="nofollow">Intrinsic Image Decomposition</a></td> <td><a href="https://en.wikipedia.org/wiki/Albedo" rel="nofollow">Albedo</a>, <a href="https://www.n.aiq3d.com/wiki/roughnessmetalnessao-map" rel="nofollow">Materials</a>, <a href="https://en.wikipedia.org/wiki/Diffuse_reflection" rel="nofollow">Lighting</a></td></tr></tbody>',tt,ie,nt,se,nn=`All original checkpoints are available under the <a href="https://huggingface.co/prs-eth/" rel="nofollow">PRS-ETH</a> organization on Hugging Face.
They are designed for use with diffusers pipelines and the <a href="https://github.com/prs-eth/marigold" rel="nofollow">original codebase</a>, which can also be used to train
new model checkpoints.
The following is a summary of the recommended checkpoints, all of which produce reliable results with 1 to 4 steps.`,ot,ae,on='<thead><tr><th>Checkpoint</th> <th>Modality</th> <th>Comment</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/prs-eth/marigold-depth-v1-1" rel="nofollow">prs-eth/marigold-depth-v1-1</a></td> <td>Depth</td> <td>Affine-invariant depth prediction assigns each pixel a value between 0 (near plane) and 1 (far plane), with both planes determined by the model during inference.</td></tr> <tr><td><a href="https://huggingface.co/prs-eth/marigold-normals-v0-1" rel="nofollow">prs-eth/marigold-normals-v0-1</a></td> <td>Normals</td> <td>The surface normals predictions are unit-length 3D vectors in the screen space camera, with values in the range from -1 to 1.</td></tr> <tr><td><a href="https://huggingface.co/prs-eth/marigold-iid-appearance-v1-1" rel="nofollow">prs-eth/marigold-iid-appearance-v1-1</a></td> <td>Intrinsics</td> <td>InteriorVerse decomposition is comprised of Albedo and two BRDF material properties: Roughness and Metallicity.</td></tr> <tr><td><a href="https://huggingface.co/prs-eth/marigold-iid-lighting-v1-1" rel="nofollow">prs-eth/marigold-iid-lighting-v1-1</a></td> <td>Intrinsics</td> <td>HyperSim decomposition of an image  \\(I\\)  is comprised of Albedo  \\(A\\), Diffuse shading  \\(S\\), and Non-diffuse residual  \\(R\\):  \\(I = A*S+R\\).</td></tr></tbody>',it,A,st,B,at,re,sn='See also Marigold <a href="../../using-diffusers/marigold_usage">usage examples</a>.',rt,le,lt,I,de,xt,Pe,an='Pipeline for monocular depth estimation using the Marigold method: <a href="https://marigoldmonodepth.github.io" rel="nofollow">https://marigoldmonodepth.github.io</a>.',It,qe,rn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Pt,C,ce,qt,Le,ln="Function invoked when calling the pipeline.",Lt,X,dt,Z,pe,Nt,Ne,dn="Output class for Marigold monocular depth prediction pipeline.",ct,J,me,Jt,Je,cn="Visualizes depth maps, such as predictions of the <code>MarigoldDepthPipeline</code>.",zt,ze,pn="Returns: <code>List[PIL.Image.Image]</code> with depth maps visualization.",pt,ue,mt,P,ge,kt,ke,mn='Pipeline for monocular normals estimation using the Marigold method: <a href="https://marigoldmonodepth.github.io" rel="nofollow">https://marigoldmonodepth.github.io</a>.',jt,je,un=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Dt,W,he,Ct,De,gn="Function invoked when calling the pipeline.",Wt,F,ut,U,fe,Zt,Ce,hn="Output class for Marigold monocular normals prediction pipeline.",gt,z,_e,Ut,We,fn="Visualizes surface normals, such as predictions of the <code>MarigoldNormalsPipeline</code>.",Et,Ze,_n="Returns: <code>List[PIL.Image.Image]</code> with surface normals visualization.",ht,be,ft,q,ve,Gt,Ue,bn=`Pipeline for Intrinsic Image Decomposition (IID) using the Marigold method:
<a href="https://marigoldcomputervision.github.io" rel="nofollow">https://marigoldcomputervision.github.io</a>.`,Ht,Ee,vn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Rt,L,ye,Vt,Ge,yn="Function invoked when calling the pipeline.",At,S,Bt,O,_t,E,Me,Xt,He,Mn="Output class for Marigold Intrinsic Image Decomposition pipeline.",bt,k,we,Ft,Re,wn="Visualizes intrinsic image decomposition, such as predictions of the <code>MarigoldIntrinsicsPipeline</code>.",St,Ve,Tn="Returns: <code>List[Dict[str, PIL.Image.Image]]</code> with intrinsic image decomposition visualization.",vt,Te,yt,Fe,Mt;return M=new Xe({props:{title:"Marigold Computer Vision",local:"marigold-computer-vision",headingTag:"h1"}}),V=new Ot({props:{$$slots:{default:[Nn]},$$scope:{ctx:T}}}),te=new Xe({props:{title:"Available Pipelines",local:"available-pipelines",headingTag:"h2"}}),ie=new Xe({props:{title:"Available Checkpoints",local:"available-checkpoints",headingTag:"h2"}}),A=new Ot({props:{$$slots:{default:[Jn]},$$scope:{ctx:T}}}),B=new Ot({props:{warning:!0,$$slots:{default:[zn]},$$scope:{ctx:T}}}),le=new Xe({props:{title:"Marigold Depth Prediction API",local:"diffusers.MarigoldDepthPipeline",headingTag:"h2"}}),de=new N({props:{name:"class diffusers.MarigoldDepthPipeline",anchor:"diffusers.MarigoldDepthPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"vae",val:": AutoencoderKL"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_lcm.LCMScheduler]"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"prediction_type",val:": typing.Optional[str] = None"},{name:"scale_invariant",val:": typing.Optional[bool] = True"},{name:"shift_invariant",val:": typing.Optional[bool] = True"},{name:"default_denoising_steps",val:": typing.Optional[int] = None"},{name:"default_processing_resolution",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.MarigoldDepthPipeline.unet",description:`<strong>unet</strong> (<code>UNet2DConditionModel</code>) &#x2014;
Conditional U-Net to denoise the depth latent, conditioned on image latent.`,name:"unet"},{anchor:"diffusers.MarigoldDepthPipeline.vae",description:`<strong>vae</strong> (<code>AutoencoderKL</code>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images and predictions to and from latent
representations.`,name:"vae"},{anchor:"diffusers.MarigoldDepthPipeline.scheduler",description:`<strong>scheduler</strong> (<code>DDIMScheduler</code> or <code>LCMScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.MarigoldDepthPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Text-encoder, for empty text embedding.`,name:"text_encoder"},{anchor:"diffusers.MarigoldDepthPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
CLIP tokenizer.`,name:"tokenizer"},{anchor:"diffusers.MarigoldDepthPipeline.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of predictions made by the model.`,name:"prediction_type"},{anchor:"diffusers.MarigoldDepthPipeline.scale_invariant",description:`<strong>scale_invariant</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
A model property specifying whether the predicted depth maps are scale-invariant. This value must be set in
the model config. When used together with the <code>shift_invariant=True</code> flag, the model is also called
&#x201C;affine-invariant&#x201D;. NB: overriding this value is not supported.`,name:"scale_invariant"},{anchor:"diffusers.MarigoldDepthPipeline.shift_invariant",description:`<strong>shift_invariant</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
A model property specifying whether the predicted depth maps are shift-invariant. This value must be set in
the model config. When used together with the <code>scale_invariant=True</code> flag, the model is also called
&#x201C;affine-invariant&#x201D;. NB: overriding this value is not supported.`,name:"shift_invariant"},{anchor:"diffusers.MarigoldDepthPipeline.default_denoising_steps",description:`<strong>default_denoising_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of denoising diffusion steps that are required to produce a prediction of reasonable
quality with the given model. This value must be set in the model config. When the pipeline is called
without explicitly setting <code>num_inference_steps</code>, the default value is used. This is required to ensure
reasonable results with various model flavors compatible with the pipeline, such as those relying on very
short denoising schedules (<code>LCMScheduler</code>) and those with full diffusion schedules (<code>DDIMScheduler</code>).`,name:"default_denoising_steps"},{anchor:"diffusers.MarigoldDepthPipeline.default_processing_resolution",description:`<strong>default_processing_resolution</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The recommended value of the <code>processing_resolution</code> parameter of the pipeline. This value must be set in
the model config. When the pipeline is called without explicitly setting <code>processing_resolution</code>, the
default value is used. This is required to ensure reasonable results with various model flavors trained
with varying optimal processing resolution values.`,name:"default_processing_resolution"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_depth.py#L105"}}),ce=new N({props:{name:"__call__",anchor:"diffusers.MarigoldDepthPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"ensemble_size",val:": int = 1"},{name:"processing_resolution",val:": typing.Optional[int] = None"},{name:"match_input_resolution",val:": bool = True"},{name:"resample_method_input",val:": str = 'bilinear'"},{name:"resample_method_output",val:": str = 'bilinear'"},{name:"batch_size",val:": int = 1"},{name:"ensembling_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"latents",val:": typing.Union[torch.Tensor, typing.List[torch.Tensor], NoneType] = None"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"output_type",val:": str = 'np'"},{name:"output_uncertainty",val:": bool = False"},{name:"output_latent",val:": bool = False"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.MarigoldDepthPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>), &#x2014;
<code>List[torch.Tensor]</code>: An input image or images used as an input for the depth estimation task. For
arrays and tensors, the expected value range is between <code>[0, 1]</code>. Passing a batch of images is possible
by providing a four-dimensional array or a tensor. Additionally, a list of images of two- or
three-dimensional arrays or tensors can be passed. In the latter case, all list elements must have the
same width and height.`,name:"image"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of denoising diffusion steps during inference. The default value <code>None</code> results in automatic
selection.`,name:"num_inference_steps"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.ensemble_size",description:`<strong>ensemble_size</strong> (<code>int</code>, defaults to <code>1</code>) &#x2014;
Number of ensemble predictions. Higher values result in measurable improvements and visual degradation.`,name:"ensemble_size"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.processing_resolution",description:`<strong>processing_resolution</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Effective processing resolution. When set to <code>0</code>, matches the larger input image dimension. This
produces crisper predictions, but may also lead to the overall loss of global context. The default
value <code>None</code> resolves to the optimal value from the model config.`,name:"processing_resolution"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.match_input_resolution",description:`<strong>match_input_resolution</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
When enabled, the output prediction is resized to match the input dimensions. When disabled, the longer
side of the output will equal to <code>processing_resolution</code>.`,name:"match_input_resolution"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.resample_method_input",description:`<strong>resample_method_input</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;bilinear&quot;</code>) &#x2014;
Resampling method used to resize input images to <code>processing_resolution</code>. The accepted values are:
<code>&quot;nearest&quot;</code>, <code>&quot;nearest-exact&quot;</code>, <code>&quot;bilinear&quot;</code>, <code>&quot;bicubic&quot;</code>, or <code>&quot;area&quot;</code>.`,name:"resample_method_input"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.resample_method_output",description:`<strong>resample_method_output</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;bilinear&quot;</code>) &#x2014;
Resampling method used to resize output predictions to match the input resolution. The accepted values
are <code>&quot;nearest&quot;</code>, <code>&quot;nearest-exact&quot;</code>, <code>&quot;bilinear&quot;</code>, <code>&quot;bicubic&quot;</code>, or <code>&quot;area&quot;</code>.`,name:"resample_method_output"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Batch size; only matters when setting <code>ensemble_size</code> or passing a tensor of images.`,name:"batch_size"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.ensembling_kwargs",description:`<strong>ensembling_kwargs</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Extra dictionary with arguments for precise ensembling control. The following options are available:<ul>
<li>reduction (<code>str</code>, <em>optional</em>, defaults to <code>&quot;median&quot;</code>): Defines the ensembling function applied in
every pixel location, can be either <code>&quot;median&quot;</code> or <code>&quot;mean&quot;</code>.</li>
<li>regularizer_strength (<code>float</code>, <em>optional</em>, defaults to <code>0.02</code>): Strength of the regularizer that
pulls the aligned predictions to the unit range from 0 to 1.</li>
<li>max_iter (<code>int</code>, <em>optional</em>, defaults to <code>2</code>): Maximum number of the alignment solver steps. Refer to
<code>scipy.optimize.minimize</code> function, <code>options</code> argument.</li>
<li>tol (<code>float</code>, <em>optional</em>, defaults to <code>1e-3</code>): Alignment solver tolerance. The solver stops when the
tolerance is reached.</li>
<li>max_res (<code>int</code>, <em>optional</em>, defaults to <code>None</code>): Resolution at which the alignment is performed;
<code>None</code> matches the <code>processing_resolution</code>.</li>
</ul>`,name:"ensembling_kwargs"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, or <code>List[torch.Tensor]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Latent noise tensors to replace the random initialization. These can be taken from the previous
function call&#x2019;s output.`,name:"latents"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, or <code>List[torch.Generator]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Random number generator object to ensure reproducibility.`,name:"generator"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
Preferred format of the output&#x2019;s <code>prediction</code> and the optional <code>uncertainty</code> fields. The accepted
values are: <code>&quot;np&quot;</code> (numpy array) or <code>&quot;pt&quot;</code> (torch tensor).`,name:"output_type"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.output_uncertainty",description:`<strong>output_uncertainty</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
When enabled, the output&#x2019;s <code>uncertainty</code> field contains the predictive uncertainty map, provided that
the <code>ensemble_size</code> argument is set to a value above 2.`,name:"output_uncertainty"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.output_latent",description:`<strong>output_latent</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
When enabled, the output&#x2019;s <code>latent</code> field contains the latent codes corresponding to the predictions
within the ensemble. These codes can be saved, modified, and used for subsequent calls with the
<code>latents</code> argument.`,name:"output_latent"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldDepthOutput">MarigoldDepthOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_depth.py#L348",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldDepthOutput"
>MarigoldDepthOutput</a> is returned, otherwise a
<code>tuple</code> is returned where the first element is the prediction, the second element is the uncertainty
(or <code>None</code>), and the third is the latent (or <code>None</code>).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldDepthOutput"
>MarigoldDepthOutput</a> or <code>tuple</code></p>
`}}),X=new Tt({props:{anchor:"diffusers.MarigoldDepthPipeline.__call__.example",$$slots:{default:[kn]},$$scope:{ctx:T}}}),pe=new N({props:{name:"class diffusers.pipelines.marigold.MarigoldDepthOutput",anchor:"diffusers.pipelines.marigold.MarigoldDepthOutput",parameters:[{name:"prediction",val:": typing.Union[numpy.ndarray, torch.Tensor]"},{name:"uncertainty",val:": typing.Union[NoneType, numpy.ndarray, torch.Tensor]"},{name:"latent",val:": typing.Optional[torch.Tensor]"}],parametersDescription:[{anchor:"diffusers.pipelines.marigold.MarigoldDepthOutput.prediction",description:`<strong>prediction</strong> (<code>np.ndarray</code>, <code>torch.Tensor</code>) &#x2014;
Predicted depth maps with values in the range [0, 1]. The shape is $numimages 	imes 1 	imes height 	imes
width$ for <code>torch.Tensor</code> or $numimages 	imes height 	imes width 	imes 1$ for <code>np.ndarray</code>.`,name:"prediction"},{anchor:"diffusers.pipelines.marigold.MarigoldDepthOutput.uncertainty",description:`<strong>uncertainty</strong> (<code>None</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>) &#x2014;
Uncertainty maps computed from the ensemble, with values in the range [0, 1]. The shape is $numimages
imes 1 	imes height 	imes width$ for <code>torch.Tensor</code> or $numimages 	imes height 	imes width 	imes 1$
for <code>np.ndarray</code>.`,name:"uncertainty"},{anchor:"diffusers.pipelines.marigold.MarigoldDepthOutput.latent",description:`<strong>latent</strong> (<code>None</code>, <code>torch.Tensor</code>) &#x2014;
Latent features corresponding to the predictions, compatible with the <code>latents</code> argument of the pipeline.
The shape is $numimages * numensemble 	imes 4 	imes latentheight 	imes latentwidth$.`,name:"latent"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_depth.py#L83"}}),me=new N({props:{name:"diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_depth",anchor:"diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_depth",parameters:[{name:"depth",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"val_min",val:": float = 0.0"},{name:"val_max",val:": float = 1.0"},{name:"color_map",val:": str = 'Spectral'"}],parametersDescription:[{anchor:"diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_depth.depth",description:"<strong>depth</strong> (<code>Union[PIL.Image.Image, np.ndarray, torch.Tensor, List[PIL.Image.Image], List[np.ndarray], -- List[torch.Tensor]]</code>): Depth maps.",name:"depth"},{anchor:"diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_depth.val_min",description:"<strong>val_min</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.0</code>) &#x2014; Minimum value of the visualized depth range.",name:"val_min"},{anchor:"diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_depth.val_max",description:"<strong>val_max</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014; Maximum value of the visualized depth range.",name:"val_max"},{anchor:"diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_depth.color_map",description:`<strong>color_map</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;Spectral&quot;</code>) &#x2014; Color map used to convert a single-channel
depth prediction into colored representation.`,name:"color_map"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/marigold_image_processing.py#L387"}}),ue=new Xe({props:{title:"Marigold Normals Estimation API",local:"diffusers.MarigoldNormalsPipeline",headingTag:"h2"}}),ge=new N({props:{name:"class diffusers.MarigoldNormalsPipeline",anchor:"diffusers.MarigoldNormalsPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"vae",val:": AutoencoderKL"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_lcm.LCMScheduler]"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"prediction_type",val:": typing.Optional[str] = None"},{name:"use_full_z_range",val:": typing.Optional[bool] = True"},{name:"default_denoising_steps",val:": typing.Optional[int] = None"},{name:"default_processing_resolution",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.MarigoldNormalsPipeline.unet",description:`<strong>unet</strong> (<code>UNet2DConditionModel</code>) &#x2014;
Conditional U-Net to denoise the normals latent, conditioned on image latent.`,name:"unet"},{anchor:"diffusers.MarigoldNormalsPipeline.vae",description:`<strong>vae</strong> (<code>AutoencoderKL</code>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images and predictions to and from latent
representations.`,name:"vae"},{anchor:"diffusers.MarigoldNormalsPipeline.scheduler",description:`<strong>scheduler</strong> (<code>DDIMScheduler</code> or <code>LCMScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.MarigoldNormalsPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Text-encoder, for empty text embedding.`,name:"text_encoder"},{anchor:"diffusers.MarigoldNormalsPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
CLIP tokenizer.`,name:"tokenizer"},{anchor:"diffusers.MarigoldNormalsPipeline.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of predictions made by the model.`,name:"prediction_type"},{anchor:"diffusers.MarigoldNormalsPipeline.use_full_z_range",description:`<strong>use_full_z_range</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the normals predicted by this model utilize the full range of the Z dimension, or only its positive
half.`,name:"use_full_z_range"},{anchor:"diffusers.MarigoldNormalsPipeline.default_denoising_steps",description:`<strong>default_denoising_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of denoising diffusion steps that are required to produce a prediction of reasonable
quality with the given model. This value must be set in the model config. When the pipeline is called
without explicitly setting <code>num_inference_steps</code>, the default value is used. This is required to ensure
reasonable results with various model flavors compatible with the pipeline, such as those relying on very
short denoising schedules (<code>LCMScheduler</code>) and those with full diffusion schedules (<code>DDIMScheduler</code>).`,name:"default_denoising_steps"},{anchor:"diffusers.MarigoldNormalsPipeline.default_processing_resolution",description:`<strong>default_processing_resolution</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The recommended value of the <code>processing_resolution</code> parameter of the pipeline. This value must be set in
the model config. When the pipeline is called without explicitly setting <code>processing_resolution</code>, the
default value is used. This is required to ensure reasonable results with various model flavors trained
with varying optimal processing resolution values.`,name:"default_processing_resolution"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_normals.py#L100"}}),he=new N({props:{name:"__call__",anchor:"diffusers.MarigoldNormalsPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"ensemble_size",val:": int = 1"},{name:"processing_resolution",val:": typing.Optional[int] = None"},{name:"match_input_resolution",val:": bool = True"},{name:"resample_method_input",val:": str = 'bilinear'"},{name:"resample_method_output",val:": str = 'bilinear'"},{name:"batch_size",val:": int = 1"},{name:"ensembling_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"latents",val:": typing.Union[torch.Tensor, typing.List[torch.Tensor], NoneType] = None"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"output_type",val:": str = 'np'"},{name:"output_uncertainty",val:": bool = False"},{name:"output_latent",val:": bool = False"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.MarigoldNormalsPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>), &#x2014;
<code>List[torch.Tensor]</code>: An input image or images used as an input for the normals estimation task. For
arrays and tensors, the expected value range is between <code>[0, 1]</code>. Passing a batch of images is possible
by providing a four-dimensional array or a tensor. Additionally, a list of images of two- or
three-dimensional arrays or tensors can be passed. In the latter case, all list elements must have the
same width and height.`,name:"image"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of denoising diffusion steps during inference. The default value <code>None</code> results in automatic
selection.`,name:"num_inference_steps"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.ensemble_size",description:`<strong>ensemble_size</strong> (<code>int</code>, defaults to <code>1</code>) &#x2014;
Number of ensemble predictions. Higher values result in measurable improvements and visual degradation.`,name:"ensemble_size"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.processing_resolution",description:`<strong>processing_resolution</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Effective processing resolution. When set to <code>0</code>, matches the larger input image dimension. This
produces crisper predictions, but may also lead to the overall loss of global context. The default
value <code>None</code> resolves to the optimal value from the model config.`,name:"processing_resolution"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.match_input_resolution",description:`<strong>match_input_resolution</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
When enabled, the output prediction is resized to match the input dimensions. When disabled, the longer
side of the output will equal to <code>processing_resolution</code>.`,name:"match_input_resolution"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.resample_method_input",description:`<strong>resample_method_input</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;bilinear&quot;</code>) &#x2014;
Resampling method used to resize input images to <code>processing_resolution</code>. The accepted values are:
<code>&quot;nearest&quot;</code>, <code>&quot;nearest-exact&quot;</code>, <code>&quot;bilinear&quot;</code>, <code>&quot;bicubic&quot;</code>, or <code>&quot;area&quot;</code>.`,name:"resample_method_input"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.resample_method_output",description:`<strong>resample_method_output</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;bilinear&quot;</code>) &#x2014;
Resampling method used to resize output predictions to match the input resolution. The accepted values
are <code>&quot;nearest&quot;</code>, <code>&quot;nearest-exact&quot;</code>, <code>&quot;bilinear&quot;</code>, <code>&quot;bicubic&quot;</code>, or <code>&quot;area&quot;</code>.`,name:"resample_method_output"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Batch size; only matters when setting <code>ensemble_size</code> or passing a tensor of images.`,name:"batch_size"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.ensembling_kwargs",description:`<strong>ensembling_kwargs</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Extra dictionary with arguments for precise ensembling control. The following options are available:<ul>
<li>reduction (<code>str</code>, <em>optional</em>, defaults to <code>&quot;closest&quot;</code>): Defines the ensembling function applied in
every pixel location, can be either <code>&quot;closest&quot;</code> or <code>&quot;mean&quot;</code>.</li>
</ul>`,name:"ensembling_kwargs"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Latent noise tensors to replace the random initialization. These can be taken from the previous
function call&#x2019;s output.`,name:"latents"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, or <code>List[torch.Generator]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Random number generator object to ensure reproducibility.`,name:"generator"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
Preferred format of the output&#x2019;s <code>prediction</code> and the optional <code>uncertainty</code> fields. The accepted
values are: <code>&quot;np&quot;</code> (numpy array) or <code>&quot;pt&quot;</code> (torch tensor).`,name:"output_type"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.output_uncertainty",description:`<strong>output_uncertainty</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
When enabled, the output&#x2019;s <code>uncertainty</code> field contains the predictive uncertainty map, provided that
the <code>ensemble_size</code> argument is set to a value above 2.`,name:"output_uncertainty"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.output_latent",description:`<strong>output_latent</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
When enabled, the output&#x2019;s <code>latent</code> field contains the latent codes corresponding to the predictions
within the ensemble. These codes can be saved, modified, and used for subsequent calls with the
<code>latents</code> argument.`,name:"output_latent"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldNormalsOutput">MarigoldNormalsOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_normals.py#L333",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldNormalsOutput"
>MarigoldNormalsOutput</a> is returned, otherwise a
<code>tuple</code> is returned where the first element is the prediction, the second element is the uncertainty
(or <code>None</code>), and the third is the latent (or <code>None</code>).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldNormalsOutput"
>MarigoldNormalsOutput</a> or <code>tuple</code></p>
`}}),F=new Tt({props:{anchor:"diffusers.MarigoldNormalsPipeline.__call__.example",$$slots:{default:[jn]},$$scope:{ctx:T}}}),fe=new N({props:{name:"class diffusers.pipelines.marigold.MarigoldNormalsOutput",anchor:"diffusers.pipelines.marigold.MarigoldNormalsOutput",parameters:[{name:"prediction",val:": typing.Union[numpy.ndarray, torch.Tensor]"},{name:"uncertainty",val:": typing.Union[NoneType, numpy.ndarray, torch.Tensor]"},{name:"latent",val:": typing.Optional[torch.Tensor]"}],parametersDescription:[{anchor:"diffusers.pipelines.marigold.MarigoldNormalsOutput.prediction",description:`<strong>prediction</strong> (<code>np.ndarray</code>, <code>torch.Tensor</code>) &#x2014;
Predicted normals with values in the range [-1, 1]. The shape is $numimages 	imes 3 	imes height 	imes
width$ for <code>torch.Tensor</code> or $numimages 	imes height 	imes width 	imes 3$ for <code>np.ndarray</code>.`,name:"prediction"},{anchor:"diffusers.pipelines.marigold.MarigoldNormalsOutput.uncertainty",description:`<strong>uncertainty</strong> (<code>None</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>) &#x2014;
Uncertainty maps computed from the ensemble, with values in the range [0, 1]. The shape is $numimages
imes 1 	imes height 	imes width$ for <code>torch.Tensor</code> or $numimages 	imes height 	imes width 	imes 1$
for <code>np.ndarray</code>.`,name:"uncertainty"},{anchor:"diffusers.pipelines.marigold.MarigoldNormalsOutput.latent",description:`<strong>latent</strong> (<code>None</code>, <code>torch.Tensor</code>) &#x2014;
Latent features corresponding to the predictions, compatible with the <code>latents</code> argument of the pipeline.
The shape is $numimages * numensemble 	imes 4 	imes latentheight 	imes latentwidth$.`,name:"latent"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_normals.py#L78"}}),_e=new N({props:{name:"diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_normals",anchor:"diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_normals",parameters:[{name:"normals",val:": typing.Union[numpy.ndarray, torch.Tensor, typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"flip_x",val:": bool = False"},{name:"flip_y",val:": bool = False"},{name:"flip_z",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_normals.normals",description:`<strong>normals</strong> (<code>Union[np.ndarray, torch.Tensor, List[np.ndarray], List[torch.Tensor]]</code>) &#x2014;
Surface normals.`,name:"normals"},{anchor:"diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_normals.flip_x",description:`<strong>flip_x</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Flips the X axis of the normals frame of reference.
Default direction is right.`,name:"flip_x"},{anchor:"diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_normals.flip_y",description:`<strong>flip_y</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;  Flips the Y axis of the normals frame of reference.
Default direction is top.`,name:"flip_y"},{anchor:"diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_normals.flip_z",description:`<strong>flip_z</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Flips the Z axis of the normals frame of reference.
Default direction is facing the observer.`,name:"flip_z"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/marigold_image_processing.py#L488"}}),be=new Xe({props:{title:"Marigold Intrinsic Image Decomposition API",local:"diffusers.MarigoldIntrinsicsPipeline",headingTag:"h2"}}),ve=new N({props:{name:"class diffusers.MarigoldIntrinsicsPipeline",anchor:"diffusers.MarigoldIntrinsicsPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"vae",val:": AutoencoderKL"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_lcm.LCMScheduler]"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"prediction_type",val:": typing.Optional[str] = None"},{name:"target_properties",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"default_denoising_steps",val:": typing.Optional[int] = None"},{name:"default_processing_resolution",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.MarigoldIntrinsicsPipeline.unet",description:`<strong>unet</strong> (<code>UNet2DConditionModel</code>) &#x2014;
Conditional U-Net to denoise the targets latent, conditioned on image latent.`,name:"unet"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.vae",description:`<strong>vae</strong> (<code>AutoencoderKL</code>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images and predictions to and from latent
representations.`,name:"vae"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.scheduler",description:`<strong>scheduler</strong> (<code>DDIMScheduler</code> or <code>LCMScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Text-encoder, for empty text embedding.`,name:"text_encoder"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
CLIP tokenizer.`,name:"tokenizer"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of predictions made by the model.`,name:"prediction_type"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.target_properties",description:`<strong>target_properties</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Properties of the predicted modalities, such as <code>target_names</code>, a <code>List[str]</code> used to define the number,
order and names of the predicted modalities, and any other metadata that may be required to interpret the
predictions.`,name:"target_properties"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.default_denoising_steps",description:`<strong>default_denoising_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of denoising diffusion steps that are required to produce a prediction of reasonable
quality with the given model. This value must be set in the model config. When the pipeline is called
without explicitly setting <code>num_inference_steps</code>, the default value is used. This is required to ensure
reasonable results with various model flavors compatible with the pipeline, such as those relying on very
short denoising schedules (<code>LCMScheduler</code>) and those with full diffusion schedules (<code>DDIMScheduler</code>).`,name:"default_denoising_steps"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.default_processing_resolution",description:`<strong>default_processing_resolution</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The recommended value of the <code>processing_resolution</code> parameter of the pipeline. This value must be set in
the model config. When the pipeline is called without explicitly setting <code>processing_resolution</code>, the
default value is used. This is required to ensure reasonable results with various model flavors trained
with varying optimal processing resolution values.`,name:"default_processing_resolution"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_intrinsics.py#L120"}}),ye=new N({props:{name:"__call__",anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"ensemble_size",val:": int = 1"},{name:"processing_resolution",val:": typing.Optional[int] = None"},{name:"match_input_resolution",val:": bool = True"},{name:"resample_method_input",val:": str = 'bilinear'"},{name:"resample_method_output",val:": str = 'bilinear'"},{name:"batch_size",val:": int = 1"},{name:"ensembling_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"latents",val:": typing.Union[torch.Tensor, typing.List[torch.Tensor], NoneType] = None"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"output_type",val:": str = 'np'"},{name:"output_uncertainty",val:": bool = False"},{name:"output_latent",val:": bool = False"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>), &#x2014;
<code>List[torch.Tensor]</code>: An input image or images used as an input for the intrinsic decomposition task.
For arrays and tensors, the expected value range is between <code>[0, 1]</code>. Passing a batch of images is
possible by providing a four-dimensional array or a tensor. Additionally, a list of images of two- or
three-dimensional arrays or tensors can be passed. In the latter case, all list elements must have the
same width and height.`,name:"image"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of denoising diffusion steps during inference. The default value <code>None</code> results in automatic
selection.`,name:"num_inference_steps"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__.ensemble_size",description:`<strong>ensemble_size</strong> (<code>int</code>, defaults to <code>1</code>) &#x2014;
Number of ensemble predictions. Higher values result in measurable improvements and visual degradation.`,name:"ensemble_size"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__.processing_resolution",description:`<strong>processing_resolution</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Effective processing resolution. When set to <code>0</code>, matches the larger input image dimension. This
produces crisper predictions, but may also lead to the overall loss of global context. The default
value <code>None</code> resolves to the optimal value from the model config.`,name:"processing_resolution"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__.match_input_resolution",description:`<strong>match_input_resolution</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
When enabled, the output prediction is resized to match the input dimensions. When disabled, the longer
side of the output will equal to <code>processing_resolution</code>.`,name:"match_input_resolution"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__.resample_method_input",description:`<strong>resample_method_input</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;bilinear&quot;</code>) &#x2014;
Resampling method used to resize input images to <code>processing_resolution</code>. The accepted values are:
<code>&quot;nearest&quot;</code>, <code>&quot;nearest-exact&quot;</code>, <code>&quot;bilinear&quot;</code>, <code>&quot;bicubic&quot;</code>, or <code>&quot;area&quot;</code>.`,name:"resample_method_input"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__.resample_method_output",description:`<strong>resample_method_output</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;bilinear&quot;</code>) &#x2014;
Resampling method used to resize output predictions to match the input resolution. The accepted values
are <code>&quot;nearest&quot;</code>, <code>&quot;nearest-exact&quot;</code>, <code>&quot;bilinear&quot;</code>, <code>&quot;bicubic&quot;</code>, or <code>&quot;area&quot;</code>.`,name:"resample_method_output"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Batch size; only matters when setting <code>ensemble_size</code> or passing a tensor of images.`,name:"batch_size"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__.ensembling_kwargs",description:`<strong>ensembling_kwargs</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Extra dictionary with arguments for precise ensembling control. The following options are available:<ul>
<li>reduction (<code>str</code>, <em>optional</em>, defaults to <code>&quot;median&quot;</code>): Defines the ensembling function applied in
every pixel location, can be either <code>&quot;median&quot;</code> or <code>&quot;mean&quot;</code>.</li>
</ul>`,name:"ensembling_kwargs"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Latent noise tensors to replace the random initialization. These can be taken from the previous
function call&#x2019;s output.`,name:"latents"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, or <code>List[torch.Generator]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Random number generator object to ensure reproducibility.`,name:"generator"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
Preferred format of the output&#x2019;s <code>prediction</code> and the optional <code>uncertainty</code> fields. The accepted
values are: <code>&quot;np&quot;</code> (numpy array) or <code>&quot;pt&quot;</code> (torch tensor).`,name:"output_type"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__.output_uncertainty",description:`<strong>output_uncertainty</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
When enabled, the output&#x2019;s <code>uncertainty</code> field contains the predictive uncertainty map, provided that
the <code>ensemble_size</code> argument is set to a value above 2.`,name:"output_uncertainty"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__.output_latent",description:`<strong>output_latent</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
When enabled, the output&#x2019;s <code>latent</code> field contains the latent codes corresponding to the predictions
within the ensemble. These codes can be saved, modified, and used for subsequent calls with the
<code>latents</code> argument.`,name:"output_latent"},{anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldIntrinsicsOutput">MarigoldIntrinsicsOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_intrinsics.py#L359",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldIntrinsicsOutput"
>MarigoldIntrinsicsOutput</a> is returned, otherwise a
<code>tuple</code> is returned where the first element is the prediction, the second element is the uncertainty
(or <code>None</code>), and the third is the latent (or <code>None</code>).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldIntrinsicsOutput"
>MarigoldIntrinsicsOutput</a> or <code>tuple</code></p>
`}}),S=new Tt({props:{anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__.example",$$slots:{default:[Dn]},$$scope:{ctx:T}}}),O=new Tt({props:{anchor:"diffusers.MarigoldIntrinsicsPipeline.__call__.example-2",$$slots:{default:[Cn]},$$scope:{ctx:T}}}),Me=new N({props:{name:"class diffusers.pipelines.marigold.MarigoldIntrinsicsOutput",anchor:"diffusers.pipelines.marigold.MarigoldIntrinsicsOutput",parameters:[{name:"prediction",val:": typing.Union[numpy.ndarray, torch.Tensor]"},{name:"uncertainty",val:": typing.Union[NoneType, numpy.ndarray, torch.Tensor]"},{name:"latent",val:": typing.Optional[torch.Tensor]"}],parametersDescription:[{anchor:"diffusers.pipelines.marigold.MarigoldIntrinsicsOutput.prediction",description:`<strong>prediction</strong> (<code>np.ndarray</code>, <code>torch.Tensor</code>) &#x2014;
Predicted image intrinsics with values in the range [0, 1]. The shape is $(numimages <em> numtargets) 	imes 3
imes height 	imes width$ for <code>torch.Tensor</code> or $(numimages </em> numtargets) 	imes height 	imes width
imes 3$ for <code>np.ndarray</code>, where <code>numtargets</code> corresponds to the number of predicted target modalities of
the intrinsic image decomposition.`,name:"prediction"},{anchor:"diffusers.pipelines.marigold.MarigoldIntrinsicsOutput.uncertainty",description:`<strong>uncertainty</strong> (<code>None</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>) &#x2014;
Uncertainty maps computed from the ensemble, with values in the range [0, 1]. The shape is $(numimages <em>
numtargets) 	imes 3 	imes height 	imes width$ for <code>torch.Tensor</code> or $(numimages </em> numtargets) 	imes
height 	imes width 	imes 3$ for <code>np.ndarray</code>.`,name:"uncertainty"},{anchor:"diffusers.pipelines.marigold.MarigoldIntrinsicsOutput.latent",description:`<strong>latent</strong> (<code>None</code>, <code>torch.Tensor</code>) &#x2014;
Latent features corresponding to the predictions, compatible with the <code>latents</code> argument of the pipeline.
The shape is $(numimages <em> numensemble) 	imes (numtargets </em> 4) 	imes latentheight 	imes latentwidth$.`,name:"latent"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_intrinsics.py#L96"}}),we=new N({props:{name:"diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_intrinsics",anchor:"diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_intrinsics",parameters:[{name:"prediction",val:": typing.Union[numpy.ndarray, torch.Tensor, typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"target_properties",val:": typing.Dict[str, typing.Any]"},{name:"color_map",val:": typing.Union[str, typing.Dict[str, str]] = 'binary'"}],parametersDescription:[{anchor:"diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_intrinsics.prediction",description:`<strong>prediction</strong> (<code>Union[np.ndarray, torch.Tensor, List[np.ndarray], List[torch.Tensor]]</code>) &#x2014;
Intrinsic image decomposition.`,name:"prediction"},{anchor:"diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_intrinsics.target_properties",description:`<strong>target_properties</strong> (<code>Dict[str, Any]</code>) &#x2014;
Decomposition properties. Expected entries: <code>target_names: List[str]</code> and a dictionary with keys
<code>prediction_space: str</code>, <code>sub_target_names: List[Union[str, Null]]</code> (must have 3 entries, null for
missing modalities), <code>up_to_scale: bool</code>, one for each target and sub-target.`,name:"target_properties"},{anchor:"diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_intrinsics.color_map",description:`<strong>color_map</strong> (<code>Union[str, Dict[str, str]]</code>, <em>optional</em>, defaults to <code>&quot;Spectral&quot;</code>) &#x2014;
Color map used to convert a single-channel predictions into colored representations. When a dictionary
is passed, each modality can be colored with its own color map.`,name:"color_map"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/marigold_image_processing.py#L549"}}),Te=new Ln({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/marigold.md"}}),{c(){o=c("meta"),y=i(),l=c("p"),m=i(),g(M.$$.fragment),r=i(),w=c("p"),w.innerHTML=Yt,Se=i(),K=c("p"),K.innerHTML=Qt,Oe=i(),ee=c("p"),ee.innerHTML=Kt,Ye=i(),g(V.$$.fragment),Qe=i(),g(te.$$.fragment),Ke=i(),ne=c("p"),ne.textContent=en,et=i(),oe=c("table"),oe.innerHTML=tn,tt=i(),g(ie.$$.fragment),nt=i(),se=c("p"),se.innerHTML=nn,ot=i(),ae=c("table"),ae.innerHTML=on,it=i(),g(A.$$.fragment),st=i(),g(B.$$.fragment),at=i(),re=c("p"),re.innerHTML=sn,rt=i(),g(le.$$.fragment),lt=i(),I=c("div"),g(de.$$.fragment),xt=i(),Pe=c("p"),Pe.innerHTML=an,It=i(),qe=c("p"),qe.innerHTML=rn,Pt=i(),C=c("div"),g(ce.$$.fragment),qt=i(),Le=c("p"),Le.textContent=ln,Lt=i(),g(X.$$.fragment),dt=i(),Z=c("div"),g(pe.$$.fragment),Nt=i(),Ne=c("p"),Ne.textContent=dn,ct=i(),J=c("div"),g(me.$$.fragment),Jt=i(),Je=c("p"),Je.innerHTML=cn,zt=i(),ze=c("p"),ze.innerHTML=pn,pt=i(),g(ue.$$.fragment),mt=i(),P=c("div"),g(ge.$$.fragment),kt=i(),ke=c("p"),ke.innerHTML=mn,jt=i(),je=c("p"),je.innerHTML=un,Dt=i(),W=c("div"),g(he.$$.fragment),Ct=i(),De=c("p"),De.textContent=gn,Wt=i(),g(F.$$.fragment),ut=i(),U=c("div"),g(fe.$$.fragment),Zt=i(),Ce=c("p"),Ce.textContent=hn,gt=i(),z=c("div"),g(_e.$$.fragment),Ut=i(),We=c("p"),We.innerHTML=fn,Et=i(),Ze=c("p"),Ze.innerHTML=_n,ht=i(),g(be.$$.fragment),ft=i(),q=c("div"),g(ve.$$.fragment),Gt=i(),Ue=c("p"),Ue.innerHTML=bn,Ht=i(),Ee=c("p"),Ee.innerHTML=vn,Rt=i(),L=c("div"),g(ye.$$.fragment),Vt=i(),Ge=c("p"),Ge.textContent=yn,At=i(),g(S.$$.fragment),Bt=i(),g(O.$$.fragment),_t=i(),E=c("div"),g(Me.$$.fragment),Xt=i(),He=c("p"),He.textContent=Mn,bt=i(),k=c("div"),g(we.$$.fragment),Ft=i(),Re=c("p"),Re.innerHTML=wn,St=i(),Ve=c("p"),Ve.innerHTML=Tn,vt=i(),g(Te.$$.fragment),yt=i(),Fe=c("p"),this.h()},l(e){const t=qn("svelte-u9bgzb",document.head);o=p(t,"META",{name:!0,content:!0}),t.forEach(n),y=s(e),l=p(e,"P",{}),$(l).forEach(n),m=s(e),h(M.$$.fragment,e),r=s(e),w=p(e,"P",{"data-svelte-h":!0}),u(w)!=="svelte-1musivh"&&(w.innerHTML=Yt),Se=s(e),K=p(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-z53d30"&&(K.innerHTML=Qt),Oe=s(e),ee=p(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-pdh9wl"&&(ee.innerHTML=Kt),Ye=s(e),h(V.$$.fragment,e),Qe=s(e),h(te.$$.fragment,e),Ke=s(e),ne=p(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-d9hh6k"&&(ne.textContent=en),et=s(e),oe=p(e,"TABLE",{"data-svelte-h":!0}),u(oe)!=="svelte-1puk2lq"&&(oe.innerHTML=tn),tt=s(e),h(ie.$$.fragment,e),nt=s(e),se=p(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-1w30tm5"&&(se.innerHTML=nn),ot=s(e),ae=p(e,"TABLE",{"data-svelte-h":!0}),u(ae)!=="svelte-nrfm0e"&&(ae.innerHTML=on),it=s(e),h(A.$$.fragment,e),st=s(e),h(B.$$.fragment,e),at=s(e),re=p(e,"P",{"data-svelte-h":!0}),u(re)!=="svelte-t30fxk"&&(re.innerHTML=sn),rt=s(e),h(le.$$.fragment,e),lt=s(e),I=p(e,"DIV",{class:!0});var j=$(I);h(de.$$.fragment,j),xt=s(j),Pe=p(j,"P",{"data-svelte-h":!0}),u(Pe)!=="svelte-41emwn"&&(Pe.innerHTML=an),It=s(j),qe=p(j,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-wu1jmh"&&(qe.innerHTML=rn),Pt=s(j),C=p(j,"DIV",{class:!0});var G=$(C);h(ce.$$.fragment,G),qt=s(G),Le=p(G,"P",{"data-svelte-h":!0}),u(Le)!=="svelte-typ793"&&(Le.textContent=ln),Lt=s(G),h(X.$$.fragment,G),G.forEach(n),j.forEach(n),dt=s(e),Z=p(e,"DIV",{class:!0});var $e=$(Z);h(pe.$$.fragment,$e),Nt=s($e),Ne=p($e,"P",{"data-svelte-h":!0}),u(Ne)!=="svelte-zmov3r"&&(Ne.textContent=dn),$e.forEach(n),ct=s(e),J=p(e,"DIV",{class:!0});var H=$(J);h(me.$$.fragment,H),Jt=s(H),Je=p(H,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-2rqpmx"&&(Je.innerHTML=cn),zt=s(H),ze=p(H,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-1q69fq7"&&(ze.innerHTML=pn),H.forEach(n),pt=s(e),h(ue.$$.fragment,e),mt=s(e),P=p(e,"DIV",{class:!0});var D=$(P);h(ge.$$.fragment,D),kt=s(D),ke=p(D,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-13lumts"&&(ke.innerHTML=mn),jt=s(D),je=p(D,"P",{"data-svelte-h":!0}),u(je)!=="svelte-wu1jmh"&&(je.innerHTML=un),Dt=s(D),W=p(D,"DIV",{class:!0});var R=$(W);h(he.$$.fragment,R),Ct=s(R),De=p(R,"P",{"data-svelte-h":!0}),u(De)!=="svelte-typ793"&&(De.textContent=gn),Wt=s(R),h(F.$$.fragment,R),R.forEach(n),D.forEach(n),ut=s(e),U=p(e,"DIV",{class:!0});var xe=$(U);h(fe.$$.fragment,xe),Zt=s(xe),Ce=p(xe,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-1msg7gm"&&(Ce.textContent=hn),xe.forEach(n),gt=s(e),z=p(e,"DIV",{class:!0});var Ae=$(z);h(_e.$$.fragment,Ae),Ut=s(Ae),We=p(Ae,"P",{"data-svelte-h":!0}),u(We)!=="svelte-qt3ymb"&&(We.innerHTML=fn),Et=s(Ae),Ze=p(Ae,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-f9p2sy"&&(Ze.innerHTML=_n),Ae.forEach(n),ht=s(e),h(be.$$.fragment,e),ft=s(e),q=p(e,"DIV",{class:!0});var Y=$(q);h(ve.$$.fragment,Y),Gt=s(Y),Ue=p(Y,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-15yl9op"&&(Ue.innerHTML=bn),Ht=s(Y),Ee=p(Y,"P",{"data-svelte-h":!0}),u(Ee)!=="svelte-wu1jmh"&&(Ee.innerHTML=vn),Rt=s(Y),L=p(Y,"DIV",{class:!0});var Q=$(L);h(ye.$$.fragment,Q),Vt=s(Q),Ge=p(Q,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-typ793"&&(Ge.textContent=yn),At=s(Q),h(S.$$.fragment,Q),Bt=s(Q),h(O.$$.fragment,Q),Q.forEach(n),Y.forEach(n),_t=s(e),E=p(e,"DIV",{class:!0});var wt=$(E);h(Me.$$.fragment,wt),Xt=s(wt),He=p(wt,"P",{"data-svelte-h":!0}),u(He)!=="svelte-1caxwky"&&(He.textContent=Mn),wt.forEach(n),bt=s(e),k=p(e,"DIV",{class:!0});var Be=$(k);h(we.$$.fragment,Be),Ft=s(Be),Re=p(Be,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-gpcvn9"&&(Re.innerHTML=wn),St=s(Be),Ve=p(Be,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-s6awtx"&&(Ve.innerHTML=Tn),Be.forEach(n),vt=s(e),h(Te.$$.fragment,e),yt=s(e),Fe=p(e,"P",{}),$(Fe).forEach(n),this.h()},h(){x(o,"name","hf:doc:metadata"),x(o,"content",Zn),x(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,o),a(e,y,t),a(e,l,t),a(e,m,t),f(M,e,t),a(e,r,t),a(e,w,t),a(e,Se,t),a(e,K,t),a(e,Oe,t),a(e,ee,t),a(e,Ye,t),f(V,e,t),a(e,Qe,t),f(te,e,t),a(e,Ke,t),a(e,ne,t),a(e,et,t),a(e,oe,t),a(e,tt,t),f(ie,e,t),a(e,nt,t),a(e,se,t),a(e,ot,t),a(e,ae,t),a(e,it,t),f(A,e,t),a(e,st,t),f(B,e,t),a(e,at,t),a(e,re,t),a(e,rt,t),f(le,e,t),a(e,lt,t),a(e,I,t),f(de,I,null),d(I,xt),d(I,Pe),d(I,It),d(I,qe),d(I,Pt),d(I,C),f(ce,C,null),d(C,qt),d(C,Le),d(C,Lt),f(X,C,null),a(e,dt,t),a(e,Z,t),f(pe,Z,null),d(Z,Nt),d(Z,Ne),a(e,ct,t),a(e,J,t),f(me,J,null),d(J,Jt),d(J,Je),d(J,zt),d(J,ze),a(e,pt,t),f(ue,e,t),a(e,mt,t),a(e,P,t),f(ge,P,null),d(P,kt),d(P,ke),d(P,jt),d(P,je),d(P,Dt),d(P,W),f(he,W,null),d(W,Ct),d(W,De),d(W,Wt),f(F,W,null),a(e,ut,t),a(e,U,t),f(fe,U,null),d(U,Zt),d(U,Ce),a(e,gt,t),a(e,z,t),f(_e,z,null),d(z,Ut),d(z,We),d(z,Et),d(z,Ze),a(e,ht,t),f(be,e,t),a(e,ft,t),a(e,q,t),f(ve,q,null),d(q,Gt),d(q,Ue),d(q,Ht),d(q,Ee),d(q,Rt),d(q,L),f(ye,L,null),d(L,Vt),d(L,Ge),d(L,At),f(S,L,null),d(L,Bt),f(O,L,null),a(e,_t,t),a(e,E,t),f(Me,E,null),d(E,Xt),d(E,He),a(e,bt,t),a(e,k,t),f(we,k,null),d(k,Ft),d(k,Re),d(k,St),d(k,Ve),a(e,vt,t),f(Te,e,t),a(e,yt,t),a(e,Fe,t),Mt=!0},p(e,[t]){const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),V.$set(j);const G={};t&2&&(G.$$scope={dirty:t,ctx:e}),A.$set(G);const $e={};t&2&&($e.$$scope={dirty:t,ctx:e}),B.$set($e);const H={};t&2&&(H.$$scope={dirty:t,ctx:e}),X.$set(H);const D={};t&2&&(D.$$scope={dirty:t,ctx:e}),F.$set(D);const R={};t&2&&(R.$$scope={dirty:t,ctx:e}),S.$set(R);const xe={};t&2&&(xe.$$scope={dirty:t,ctx:e}),O.$set(xe)},i(e){Mt||(_(M.$$.fragment,e),_(V.$$.fragment,e),_(te.$$.fragment,e),_(ie.$$.fragment,e),_(A.$$.fragment,e),_(B.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(X.$$.fragment,e),_(pe.$$.fragment,e),_(me.$$.fragment,e),_(ue.$$.fragment,e),_(ge.$$.fragment,e),_(he.$$.fragment,e),_(F.$$.fragment,e),_(fe.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(ve.$$.fragment,e),_(ye.$$.fragment,e),_(S.$$.fragment,e),_(O.$$.fragment,e),_(Me.$$.fragment,e),_(we.$$.fragment,e),_(Te.$$.fragment,e),Mt=!0)},o(e){b(M.$$.fragment,e),b(V.$$.fragment,e),b(te.$$.fragment,e),b(ie.$$.fragment,e),b(A.$$.fragment,e),b(B.$$.fragment,e),b(le.$$.fragment,e),b(de.$$.fragment,e),b(ce.$$.fragment,e),b(X.$$.fragment,e),b(pe.$$.fragment,e),b(me.$$.fragment,e),b(ue.$$.fragment,e),b(ge.$$.fragment,e),b(he.$$.fragment,e),b(F.$$.fragment,e),b(fe.$$.fragment,e),b(_e.$$.fragment,e),b(be.$$.fragment,e),b(ve.$$.fragment,e),b(ye.$$.fragment,e),b(S.$$.fragment,e),b(O.$$.fragment,e),b(Me.$$.fragment,e),b(we.$$.fragment,e),b(Te.$$.fragment,e),Mt=!1},d(e){e&&(n(y),n(l),n(m),n(r),n(w),n(Se),n(K),n(Oe),n(ee),n(Ye),n(Qe),n(Ke),n(ne),n(et),n(oe),n(tt),n(nt),n(se),n(ot),n(ae),n(it),n(st),n(at),n(re),n(rt),n(lt),n(I),n(dt),n(Z),n(ct),n(J),n(pt),n(mt),n(P),n(ut),n(U),n(gt),n(z),n(ht),n(ft),n(q),n(_t),n(E),n(bt),n(k),n(vt),n(yt),n(Fe)),n(o),v(M,e),v(V,e),v(te,e),v(ie,e),v(A,e),v(B,e),v(le,e),v(de),v(ce),v(X),v(pe),v(me),v(ue,e),v(ge),v(he),v(F),v(fe),v(_e),v(be,e),v(ve),v(ye),v(S),v(O),v(Me),v(we),v(Te,e)}}}const Zn='{"title":"Marigold Computer Vision","local":"marigold-computer-vision","sections":[{"title":"Available Pipelines","local":"available-pipelines","sections":[],"depth":2},{"title":"Available Checkpoints","local":"available-checkpoints","sections":[],"depth":2},{"title":"Marigold Depth Prediction API","local":"diffusers.MarigoldDepthPipeline","sections":[],"depth":2},{"title":"Marigold Normals Estimation API","local":"diffusers.MarigoldNormalsPipeline","sections":[],"depth":2},{"title":"Marigold Intrinsic Image Decomposition API","local":"diffusers.MarigoldIntrinsicsPipeline","sections":[],"depth":2}],"depth":1}';function Un(T){return xn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xn extends In{constructor(o){super(),Pn(this,o,Un,Wn,$n,{})}}export{Xn as component};
