import{s as _s,n as Bs,o as Es}from"../chunks/scheduler.7bc62968.js";import{S as Ws,i as Ss,g as i,s as a,r as m,A as As,h as p,f as l,c as n,j as Ns,u as M,x as r,k as Fs,y as Gs,a as s,v as o,d as h,t as c,w as y}from"../chunks/index.2f8492b0.js";import{C as u}from"../chunks/CodeBlock.4e96d6f7.js";import{H as _l}from"../chunks/Heading.14fb2476.js";function Ls(Bl){let f,qe,Ke,Oe,w,et,T,El="How can we match detected features from one image to another? Feature matching involves comparing key attributes in different images to find similarities. Feature matching is useful in many computer vision applications, including scene understanding, image stitching, object tracking, and pattern recognition.",tt,U,lt,J,Wl="Imagine you have a giant box of puzzle pieces, and you’re trying to find a specific piece that fits into your puzzle. This is similar to searching for matching features in images. Instead of having any special strategy, you decide to check every piece, one by one until you find the right one. This straightforward method is a brute-force search. The advantage of brute force is its simplicity. You don’t need any special tricks – just patience. However, it can be time-consuming, especially if there are a lot of pieces to check. In the context of feature matching, this brute force approach is akin to comparing every pixel in one image to every pixel in another to see if they match. It’s exhaustive and it might take a lot of time, especially for large images.",st,d,Sl="Now that we have an intuitive idea of how brute-force matches are found, let’s dive into the algorithms. We are going to use the descriptors that we learned about in the previous chapter to find the matching features in two images.",at,b,Al="First install and load libraries",nt,g,it,j,pt,C,Gl="<strong>Brute Force with SIFT</strong>",rt,k,Ll="We will now load our images to have their features matched.",mt,$,Mt,I,Yl="Initialize SIFT detector",ot,v,ht,R,Zl="<strong>Find the keypoints and descriptors with SIFT</strong>",ct,x,yt,N,Ql="Find matches using k nearest neighbors",ut,F,ft,_,zl="Apply ratio test to threshold the best matches",wt,B,Tt,E,Xl="Draw the matches",Ut,W,Jt,S,Vl='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/feature-extraction-feature-matching/SIFT.png" alt="SIFT"/>',dt,A,Dl="<strong>Brute Force with ORB (binary) descriptors</strong>",bt,G,Hl="Load images",gt,L,jt,Y,Kl="Initialize the ORB descriptor",Ct,Z,kt,Q,Pl="Find keypoints and descriptors",$t,z,It,X,ql=`Because ORB is a binary descriptor, we find matches using <a href="https://www.geeksforgeeks.org/hamming-distance-two-strings/" rel="nofollow">Hamming Distance</a>,
which is a measure of the difference between two strings of equal length.`,vt,V,Rt,D,Ol="Find the matches",xt,H,Nt,K,es="Sort them in the order of their distance",Ft,P,_t,q,ts="Draw first n matches",Bt,O,Et,ee,ls="<strong>Fast Library for Approximate Nearest Neighbors (FLANN)</strong>",Wt,te,ss=`FLANN was proposed in <a href="https://www.cs.ubc.ca/research/flann/uploads/FLANN/flann_visapp09.pdf" rel="nofollow">Fast Approximate Nearest Neighbors With Automatic Algorithm Configuration</a> by Muja and Lowe. To explain FLANN, we will continue with our puzzle solving example. Visualize a giant puzzle with hundreds of pieces scattered around. Your goal is to organize these pieces based on how well they fit together. Instead of randomly trying to match pieces,
FLANN uses some clever tricks to quickly figure out which pieces are most likely to go together. Instead of trying every piece against every other piece, FLANN streamlines the process by finding pieces that are approximately similar. This means it can make educated guesses about which pieces might fit well together, even if they’re not an exact match. Under the hood, FLANN is uses something called k-D trees. Think of it as organizing the puzzle pieces in a special way. Instead of checking every piece against every other piece, FLANN arranges them in a tree-like structure that makes finding matches faster. In each node of the k-D tree, FLANN puts pieces with similar features together. It’s like sorting puzzle pieces with similar shapes or colors into piles. This way, when you’re looking for a match, you can quickly check the pile that’s most likely to have similar pieces. Let’s say you’re looking for a “sky” piece. Instead of searching through all the pieces, FLANN guides you to the right spot in the k-D tree where the sky-colored pieces are sorted. FLANN also adjusts its strategy based on the features of the puzzle pieces. If you have a puzzle with lots of colors, it will focus on color features. Alternately, if it’s a puzzle with intricate shapes, it pays attention to those shapes. By balancing speed and accuracy when finding matching features, FLANN substantially improves query time.`,St,le,as="<strong>First we create a dictionary to specify the algorithm we will use</strong>",At,se,ns="<em>For SIFT or SURF</em>",Gt,ae,Lt,ne,is="<em>For ORB</em>",Yt,ie,ps="We will use the parameters from the paper.",Zt,pe,Qt,re,rs="We also create a dictionary to specify the maximum leafs to visit:",zt,me,Xt,Me,ms="Load images",Vt,oe,Dt,he,Ms="Initiate SIFT detector",Ht,ce,Kt,ye,os="Find the keypoints and descriptors with SIFT",Pt,ue,qt,fe,hs="Define the FLANN parameters",Ot,we,cs="<li>Trees is the numbers of bins you want.</li>",el,Te,tl,Ue,ys="We will only draw good matches, so create a mask",ll,Je,sl,de,us="We perform a ratio test to determine good matches",al,be,nl,ge,fs="Now we visualize the matches",il,je,pl,Ce,ws='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/feature-extraction-feature-matching/FLANN.png" alt="FLANN"/>',rl,ke,ml,$e,Ts=`LoFTR was proposed in <a href="https://arxiv.org/pdf/2104.00680.pdf" rel="nofollow">LoFTR: Detector-Free Local Feature Matching with Transformers</a> by Sun, et. al.
Instead of using feature detectors, LoFTR uses a learning-based approach to feature matching.`,Ml,Ie,Us=`Let’s keep it simple and use our puzzle example once again. Instead of simply comparing images pixel by pixel, LoFTR looks for specific key points, or features, in each image. It’s like identifying the corners and edges of each puzzle piece. And just as someone really good a putting together a puzzle might focus on distinctive marks, LoFTR identifies these unique points in one image. These could be key landmarks or structures that stand out. As we have already learned, it is important that the matching algorithm handles changes in rotation or scale. If a feature is turned or resized, LoFTR would still recognize it. It’s like solving puzzles where pieces may be flipped or adjusted. As LoFTR matches features, it assigns a similarity score to indicate how well the features align. Higher scores mean better matches. It’s like giving a grade to how well one puzzle piece fits with another.
LoFTR is also invariant to certain transformations, meaning it can handle variations in lighting, angle, or perspective. This is crucial when dealing with images that might be photographed under different conditions. LoFTR’s ability to robustly match features makes it valuable for tasks like image stitching, where you combine multiple images seamlessly by identifying and connecting common features.`,ol,ve,Js='We can use <a href="https://github.com/kornia/kornia" rel="nofollow">Kornia</a> to find matching features in two images using LoFTR.',hl,Re,cl,xe,ds="Import the libraries",yl,Ne,ul,Fe,bs="Load and resize the images",fl,_e,wl,Be,gs="Indicate whether the image is an “indoor” or “outdoor” image",Tl,Ee,Ul,We,js="<strong>LoFTR only works on grayscale images, so convert to images to grayscale</strong>",Jl,Se,dl,Ae,Cs="Perform Inference",bl,Ge,gl,Le,ks='Clean up the correspondences using Random Sample Consensus (<a href="https://en.wikipedia.org/wiki/Random_sample_consensus" rel="nofollow">RANSAC</a>)',jl,Ye,$s="<li>This helps to deal with noise or outliers in the data.</li>",Cl,Ze,kl,Qe,Is="Finally, we can visualize the matches",$l,ze,Il,Xe,vs="The best matches are visualized in green, while less certain matches are in blue.",vl,Ve,Rs='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/feature-extraction-feature-matching/LoFTR.png" alt="LoFTR"/>',Rl,De,xl,He,xs='<li><a href="https://github.com/flann-lib/flann" rel="nofollow">FLANN Github</a></li> <li><a href="https://arxiv.org/pdf/1710.02726.pdf" rel="nofollow">Image Matching Using SIFT, SURF, BRIEF and ORB: Performance Comparison for Distorted Images</a></li> <li><a href="https://docs.opencv.org/4.x/d1/d89/tutorial_py_orb.html" rel="nofollow">ORB (Oriented FAST and Rotated BRIEF) tutorial</a></li> <li><a href="https://kornia.github.io/tutorials/nbs/image_matching.html" rel="nofollow">Kornia tutorial on Image Matching</a></li> <li><a href="https://github.com/zju3dv/LoFTR" rel="nofollow">LoFTR Github</a></li> <li><a href="https://github.com/opencv/opencv-python" rel="nofollow">OpenCV Github</a></li> <li><a href="https://docs.opencv.org/4.x/dc/dc3/tutorial_py_matcher.html" rel="nofollow">OpenCV Feature Matching Tutorial</a></li> <li><a href="https://arxiv.org/abs/2204.08870" rel="nofollow">OpenGlue: Open Source Graph Neural Net Based Pipeline for Image Matching</a></li>',Nl,Pe,Fl;return w=new _l({props:{title:"Feature Matching",local:"feature-matching",headingTag:"h1"}}),U=new _l({props:{title:"Brute-Force Search",local:"brute-force-search",headingTag:"h2"}}),g=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjBvcGVuY3YtcHl0aG9u",highlighted:"!pip install opencv-python",wrap:!1}}),j=new u({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5w",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np`,wrap:!1}}),$=new u({props:{code:"aW1hZ2UxJTIwJTNEJTIwJTIycGF0aF90b19pbWFnZTElMjIlMEFpbWFnZTIlMjAlM0QlMjAlMjJwYXRoX3RvX2ltYWdlMiUyMiUwQWltZzElMjAlM0QlMjBjdi5pbXJlYWQoJTIyaW1hZ2UxJTIyJTJDJTIwY3YuSU1SRUFEX0dSQVlTQ0FMRSklMEFpbWcyJTIwJTNEJTIwY3YuaW1yZWFkKCUyMmltYWdlMiUyMiUyQyUyMGN2LklNUkVBRF9HUkFZU0NBTEUp",highlighted:`image1 = <span class="hljs-string">&quot;path_to_image1&quot;</span>
image2 = <span class="hljs-string">&quot;path_to_image2&quot;</span>
img1 = cv.imread(<span class="hljs-string">&quot;image1&quot;</span>, cv.IMREAD_GRAYSCALE)
img2 = cv.imread(<span class="hljs-string">&quot;image2&quot;</span>, cv.IMREAD_GRAYSCALE)`,wrap:!1}}),v=new u({props:{code:"c2lmdCUyMCUzRCUyMGN2LlNJRlRfY3JlYXRlKCk=",highlighted:"sift = cv.SIFT_create()",wrap:!1}}),x=new u({props:{code:"a3AxJTJDJTIwZGVzMSUyMCUzRCUyMHNpZnQuZGV0ZWN0QW5kQ29tcHV0ZShpbWcxJTJDJTIwTm9uZSklMEFrcDIlMkMlMjBkZXMyJTIwJTNEJTIwc2lmdC5kZXRlY3RBbmRDb21wdXRlKGltZzIlMkMlMjBOb25lKQ==",highlighted:`kp1, des1 = sift.detectAndCompute(img1, <span class="hljs-literal">None</span>)
kp2, des2 = sift.detectAndCompute(img2, <span class="hljs-literal">None</span>)`,wrap:!1}}),F=new u({props:{code:"YmYlMjAlM0QlMjBjdi5CRk1hdGNoZXIoKSUwQW1hdGNoZXMlMjAlM0QlMjBiZi5rbm5NYXRjaChkZXMxJTJDJTIwZGVzMiUyQyUyMGslM0QyKQ==",highlighted:`bf = cv.BFMatcher()
matches = bf.knnMatch(des1, des2, k=<span class="hljs-number">2</span>)`,wrap:!1}}),B=new u({props:{code:"Z29vZCUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMG0lMkMlMjBuJTIwaW4lMjBtYXRjaGVzJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBtLmRpc3RhbmNlJTIwJTNDJTIwMC43NSUyMColMjBuLmRpc3RhbmNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ29vZC5hcHBlbmQoJTVCbSU1RCk=",highlighted:`good = []
<span class="hljs-keyword">for</span> m, n <span class="hljs-keyword">in</span> matches:
    <span class="hljs-keyword">if</span> m.distance &lt; <span class="hljs-number">0.75</span> * n.distance:
        good.append([m])`,wrap:!1}}),W=new u({props:{code:"aW1nMyUyMCUzRCUyMGN2LmRyYXdNYXRjaGVzS25uKCUwQSUyMCUyMCUyMCUyMGltZzElMkMlMjBrcDElMkMlMjBpbWcyJTJDJTIwa3AyJTJDJTIwZ29vZCUyQyUyME5vbmUlMkMlMjBmbGFncyUzRGN2LkRyYXdNYXRjaGVzRmxhZ3NfTk9UX0RSQVdfU0lOR0xFX1BPSU5UUyUwQSk=",highlighted:`img3 = cv.drawMatchesKnn(
    img1, kp1, img2, kp2, good, <span class="hljs-literal">None</span>, flags=cv.DrawMatchesFlags_NOT_DRAW_SINGLE_POINTS
)`,wrap:!1}}),L=new u({props:{code:"aW1hZ2UxJTIwJTNEJTIwJTIycGF0aF90b19pbWFnZTElMjIlMEFpbWFnZTIlMjAlM0QlMjAlMjJwYXRoX3RvX2ltYWdlMiUyMiUwQWltZzElMjAlM0QlMjBjdi5pbXJlYWQoaW1hZ2UxJTJDJTIwY3YuSU1SRUFEX0dSQVlTQ0FMRSklMEFpbWcyJTIwJTNEJTIwY3YuaW1yZWFkKGltYWdlMiUyQyUyMGN2LklNUkVBRF9HUkFZU0NBTEUp",highlighted:`image1 = <span class="hljs-string">&quot;path_to_image1&quot;</span>
image2 = <span class="hljs-string">&quot;path_to_image2&quot;</span>
img1 = cv.imread(image1, cv.IMREAD_GRAYSCALE)
img2 = cv.imread(image2, cv.IMREAD_GRAYSCALE)`,wrap:!1}}),Z=new u({props:{code:"b3JiJTIwJTNEJTIwY3YuT1JCX2NyZWF0ZSgp",highlighted:"orb = cv.ORB_create()",wrap:!1}}),z=new u({props:{code:"a3AxJTJDJTIwZGVzMSUyMCUzRCUyMG9yYi5kZXRlY3RBbmRDb21wdXRlKGltZzElMkMlMjBOb25lKSUwQWtwMiUyQyUyMGRlczIlMjAlM0QlMjBvcmIuZGV0ZWN0QW5kQ29tcHV0ZShpbWcyJTJDJTIwTm9uZSk=",highlighted:`kp1, des1 = orb.detectAndCompute(img1, <span class="hljs-literal">None</span>)
kp2, des2 = orb.detectAndCompute(img2, <span class="hljs-literal">None</span>)`,wrap:!1}}),V=new u({props:{code:"YmYlMjAlM0QlMjBjdi5CRk1hdGNoZXIoY3YuTk9STV9IQU1NSU5HJTJDJTIwY3Jvc3NDaGVjayUzRFRydWUp",highlighted:'bf = cv.BFMatcher(cv.NORM_HAMMING, crossCheck=<span class="hljs-literal">True</span>)',wrap:!1}}),H=new u({props:{code:"bWF0Y2hlcyUyMCUzRCUyMGJmLm1hdGNoKGRlczElMkMlMjBkZXMyKQ==",highlighted:'matches = bf.<span class="hljs-keyword">match</span>(des1, des2)',wrap:!1}}),P=new u({props:{code:"bWF0Y2hlcyUyMCUzRCUyMHNvcnRlZChtYXRjaGVzJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMHguZGlzdGFuY2Up",highlighted:'matches = <span class="hljs-built_in">sorted</span>(matches, key=<span class="hljs-keyword">lambda</span> x: x.distance)',wrap:!1}}),O=new u({props:{code:"aW1nMyUyMCUzRCUyMGN2LmRyYXdNYXRjaGVzKCUwQSUyMCUyMCUyMCUyMGltZzElMkMlMEElMjAlMjAlMjAlMjBrcDElMkMlMEElMjAlMjAlMjAlMjBpbWcyJTJDJTBBJTIwJTIwJTIwJTIwa3AyJTJDJTBBJTIwJTIwJTIwJTIwbWF0Y2hlcyU1QiUzQW4lNUQlMkMlMEElMjAlMjAlMjAlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwZmxhZ3MlM0Rjdi5EcmF3TWF0Y2hlc0ZsYWdzX05PVF9EUkFXX1NJTkdMRV9QT0lOVFMlMkMlMEEp",highlighted:`img3 = cv.drawMatches(
    img1,
    kp1,
    img2,
    kp2,
    matches[:n],
    <span class="hljs-literal">None</span>,
    flags=cv.DrawMatchesFlags_NOT_DRAW_SINGLE_POINTS,
)`,wrap:!1}}),ae=new u({props:{code:"RkxBTk5fSU5ERVhfS0RUUkVFJTIwJTNEJTIwMSUwQWluZGV4X3BhcmFtcyUyMCUzRCUyMGRpY3QoYWxnb3JpdGhtJTNERkxBTk5fSU5ERVhfS0RUUkVFJTJDJTIwdHJlZXMlM0Q1KQ==",highlighted:`FLANN_INDEX_KDTREE = <span class="hljs-number">1</span>
index_params = <span class="hljs-built_in">dict</span>(algorithm=FLANN_INDEX_KDTREE, trees=<span class="hljs-number">5</span>)`,wrap:!1}}),pe=new u({props:{code:"RkxBTk5fSU5ERVhfTFNIJTIwJTNEJTIwNiUwQWluZGV4X3BhcmFtcyUyMCUzRCUyMGRpY3QoJTBBJTIwJTIwJTIwJTIwYWxnb3JpdGhtJTNERkxBTk5fSU5ERVhfTFNIJTJDJTIwdGFibGVfbnVtYmVyJTNEMTIlMkMlMjBrZXlfc2l6ZSUzRDIwJTJDJTIwbXVsdGlfcHJvYmVfbGV2ZWwlM0QyJTBBKQ==",highlighted:`FLANN_INDEX_LSH = <span class="hljs-number">6</span>
index_params = <span class="hljs-built_in">dict</span>(
    algorithm=FLANN_INDEX_LSH, table_number=<span class="hljs-number">12</span>, key_size=<span class="hljs-number">20</span>, multi_probe_level=<span class="hljs-number">2</span>
)`,wrap:!1}}),me=new u({props:{code:"c2VhcmNoX3BhcmFtcyUyMCUzRCUyMGRpY3QoY2hlY2tzJTNENTAp",highlighted:'search_params = <span class="hljs-built_in">dict</span>(checks=<span class="hljs-number">50</span>)',wrap:!1}}),oe=new u({props:{code:"aW1hZ2UxJTIwJTNEJTIwJTIycGF0aF90b19pbWFnZTElMjIlMEFpbWFnZTIlMjAlM0QlMjAlMjJwYXRoX3RvX2ltYWdlMiUyMiUwQWltZzElMjAlM0QlMjBjdi5pbXJlYWQoaW1hZ2UxJTJDJTIwY3YuSU1SRUFEX0dSQVlTQ0FMRSklMEFpbWcyJTIwJTNEJTIwY3YuaW1yZWFkKGltYWdlMiUyQyUyMGN2LklNUkVBRF9HUkFZU0NBTEUp",highlighted:`image1 = <span class="hljs-string">&quot;path_to_image1&quot;</span>
image2 = <span class="hljs-string">&quot;path_to_image2&quot;</span>
img1 = cv.imread(image1, cv.IMREAD_GRAYSCALE)
img2 = cv.imread(image2, cv.IMREAD_GRAYSCALE)`,wrap:!1}}),ce=new u({props:{code:"c2lmdCUyMCUzRCUyMGN2LlNJRlRfY3JlYXRlKCk=",highlighted:"sift = cv.SIFT_create()",wrap:!1}}),ue=new u({props:{code:"a3AxJTJDJTIwZGVzMSUyMCUzRCUyMHNpZnQuZGV0ZWN0QW5kQ29tcHV0ZShpbWcxJTJDJTIwTm9uZSklMEFrcDIlMkMlMjBkZXMyJTIwJTNEJTIwc2lmdC5kZXRlY3RBbmRDb21wdXRlKGltZzIlMkMlMjBOb25lKQ==",highlighted:`kp1, des1 = sift.detectAndCompute(img1, <span class="hljs-literal">None</span>)
kp2, des2 = sift.detectAndCompute(img2, <span class="hljs-literal">None</span>)`,wrap:!1}}),Te=new u({props:{code:"RkxBTk5fSU5ERVhfS0RUUkVFJTIwJTNEJTIwMSUwQWluZGV4X3BhcmFtcyUyMCUzRCUyMGRpY3QoYWxnb3JpdGhtJTNERkxBTk5fSU5ERVhfS0RUUkVFJTJDJTIwdHJlZXMlM0Q1KSUwQXNlYXJjaF9wYXJhbXMlMjAlM0QlMjBkaWN0KGNoZWNrcyUzRDUwKSUwQWZsYW5uJTIwJTNEJTIwY3YuRmxhbm5CYXNlZE1hdGNoZXIoaW5kZXhfcGFyYW1zJTJDJTIwc2VhcmNoX3BhcmFtcyklMEElMEFtYXRjaGVzJTIwJTNEJTIwZmxhbm4ua25uTWF0Y2goZGVzMSUyQyUyMGRlczIlMkMlMjBrJTNEMik=",highlighted:`FLANN_INDEX_KDTREE = <span class="hljs-number">1</span>
index_params = <span class="hljs-built_in">dict</span>(algorithm=FLANN_INDEX_KDTREE, trees=<span class="hljs-number">5</span>)
search_params = <span class="hljs-built_in">dict</span>(checks=<span class="hljs-number">50</span>)
flann = cv.FlannBasedMatcher(index_params, search_params)

matches = flann.knnMatch(des1, des2, k=<span class="hljs-number">2</span>)`,wrap:!1}}),Je=new u({props:{code:"bWF0Y2hlc01hc2slMjAlM0QlMjAlNUIlNUIwJTJDJTIwMCU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihtYXRjaGVzKSklNUQ=",highlighted:'matchesMask = [[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(matches))]',wrap:!1}}),be=new u({props:{code:"Zm9yJTIwaSUyQyUyMChtJTJDJTIwbiklMjBpbiUyMGVudW1lcmF0ZShtYXRjaGVzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbS5kaXN0YW5jZSUyMCUzQyUyMDAuNyUyMColMjBuLmRpc3RhbmNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF0Y2hlc01hc2slNUJpJTVEJTIwJTNEJTIwJTVCMSUyQyUyMDAlNUQ=",highlighted:`<span class="hljs-keyword">for</span> i, (m, n) <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(matches):
    <span class="hljs-keyword">if</span> m.distance &lt; <span class="hljs-number">0.7</span> * n.distance:
        matchesMask[i] = [<span class="hljs-number">1</span>, <span class="hljs-number">0</span>]`,wrap:!1}}),je=new u({props:{code:"ZHJhd19wYXJhbXMlMjAlM0QlMjBkaWN0KCUwQSUyMCUyMCUyMCUyMG1hdGNoQ29sb3IlM0QoMCUyQyUyMDI1NSUyQyUyMDApJTJDJTBBJTIwJTIwJTIwJTIwc2luZ2xlUG9pbnRDb2xvciUzRCgyNTUlMkMlMjAwJTJDJTIwMCklMkMlMEElMjAlMjAlMjAlMjBtYXRjaGVzTWFzayUzRG1hdGNoZXNNYXNrJTJDJTBBJTIwJTIwJTIwJTIwZmxhZ3MlM0Rjdi5EcmF3TWF0Y2hlc0ZsYWdzX0RFRkFVTFQlMkMlMEEpJTBBJTBBaW1nMyUyMCUzRCUyMGN2LmRyYXdNYXRjaGVzS25uKGltZzElMkMlMjBrcDElMkMlMjBpbWcyJTJDJTIwa3AyJTJDJTIwbWF0Y2hlcyUyQyUyME5vbmUlMkMlMjAqKmRyYXdfcGFyYW1zKQ==",highlighted:`draw_params = <span class="hljs-built_in">dict</span>(
    matchColor=(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>),
    singlePointColor=(<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>),
    matchesMask=matchesMask,
    flags=cv.DrawMatchesFlags_DEFAULT,
)

img3 = cv.drawMatchesKnn(img1, kp1, img2, kp2, matches, <span class="hljs-literal">None</span>, **draw_params)`,wrap:!1}}),ke=new _l({props:{title:"Local Feature Matching with Transformers (LoFTR)",local:"local-feature-matching-with-transformers-loftr",headingTag:"h2"}}),Re=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjBrb3JuaWElMjAlMjBrb3JuaWEtcnMlMjAlMjBrb3JuaWFfbW9vbnMlMjBvcGVuY3YtcHl0aG9uJTIwLS11cGdyYWRl",highlighted:"!pip install kornia  kornia-rs  kornia_moons opencv-python --upgrade",wrap:!1}}),Ne=new u({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwa29ybmlhJTIwYXMlMjBLJTBBaW1wb3J0JTIwa29ybmlhLmZlYXR1cmUlMjBhcyUyMEtGJTBBaW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGtvcm5pYV9tb29ucy52aXolMjBpbXBvcnQlMjBkcmF3X0xBRl9tYXRjaGVz",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> kornia <span class="hljs-keyword">as</span> K
<span class="hljs-keyword">import</span> kornia.feature <span class="hljs-keyword">as</span> KF
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> kornia_moons.viz <span class="hljs-keyword">import</span> draw_LAF_matches`,wrap:!1}}),_e=new u({props:{code:"ZnJvbSUyMGtvcm5pYS5mZWF0dXJlJTIwaW1wb3J0JTIwTG9GVFIlMEElMEFpbWcxJTIwJTNEJTIwSy5pby5sb2FkX2ltYWdlKGltYWdlMS5qcGclMkMlMjBLLmlvLkltYWdlTG9hZFR5cGUuUkdCMzIpJTVCTm9uZSUyQyUyMC4uLiU1RCUwQWltZzIlMjAlM0QlMjBLLmlvLmxvYWRfaW1hZ2UoaW1hZ2UyLmpwZyUyQyUyMEsuaW8uSW1hZ2VMb2FkVHlwZS5SR0IzMiklNUJOb25lJTJDJTIwLi4uJTVEJTBBJTBBaW1nMSUyMCUzRCUyMEsuZ2VvbWV0cnkucmVzaXplKGltZzElMkMlMjAoNTEyJTJDJTIwNTEyKSUyQyUyMGFudGlhbGlhcyUzRFRydWUpJTBBaW1nMiUyMCUzRCUyMEsuZ2VvbWV0cnkucmVzaXplKGltZzIlMkMlMjAoNTEyJTJDJTIwNTEyKSUyQyUyMGFudGlhbGlhcyUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> kornia.feature <span class="hljs-keyword">import</span> LoFTR

img1 = K.io.load_image(image1.jpg, K.io.ImageLoadType.RGB32)[<span class="hljs-literal">None</span>, ...]
img2 = K.io.load_image(image2.jpg, K.io.ImageLoadType.RGB32)[<span class="hljs-literal">None</span>, ...]

img1 = K.geometry.resize(img1, (<span class="hljs-number">512</span>, <span class="hljs-number">512</span>), antialias=<span class="hljs-literal">True</span>)
img2 = K.geometry.resize(img2, (<span class="hljs-number">512</span>, <span class="hljs-number">512</span>), antialias=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ee=new u({props:{code:"bWF0Y2hlciUyMCUzRCUyMExvRlRSKHByZXRyYWluZWQlM0QlMjJvdXRkb29yJTIyKQ==",highlighted:'matcher = LoFTR(pretrained=<span class="hljs-string">&quot;outdoor&quot;</span>)',wrap:!1}}),Se=new u({props:{code:"aW5wdXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmltYWdlMCUyMiUzQSUyMEsuY29sb3IucmdiX3RvX2dyYXlzY2FsZShpbWcxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMmltYWdlMSUyMiUzQSUyMEsuY29sb3IucmdiX3RvX2dyYXlzY2FsZShpbWcyKSUyQyUwQSU3RA==",highlighted:`input_dict = {
    <span class="hljs-string">&quot;image0&quot;</span>: K.color.rgb_to_grayscale(img1),
    <span class="hljs-string">&quot;image1&quot;</span>: K.color.rgb_to_grayscale(img2),
}`,wrap:!1}}),Ge=new u({props:{code:"d2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBjb3JyZXNwb25kZW5jZXMlMjAlM0QlMjBtYXRjaGVyKGlucHV0X2RpY3Qp",highlighted:`<span class="hljs-keyword">with</span> torch.inference_mode():
    correspondences = matcher(input_dict)`,wrap:!1}}),Ze=new u({props:{code:"bWtwdHMwJTIwJTNEJTIwY29ycmVzcG9uZGVuY2VzJTVCJTIya2V5cG9pbnRzMCUyMiU1RC5jcHUoKS5udW1weSgpJTBBbWtwdHMxJTIwJTNEJTIwY29ycmVzcG9uZGVuY2VzJTVCJTIya2V5cG9pbnRzMSUyMiU1RC5jcHUoKS5udW1weSgpJTBBRm0lMkMlMjBpbmxpZXJzJTIwJTNEJTIwY3YyLmZpbmRGdW5kYW1lbnRhbE1hdChta3B0czAlMkMlMjBta3B0czElMkMlMjBjdjIuVVNBQ19NQUdTQUMlMkMlMjAwLjUlMkMlMjAwLjk5OSUyQyUyMDEwMDAwMCklMEFpbmxpZXJzJTIwJTNEJTIwaW5saWVycyUyMCUzRSUyMDA=",highlighted:`mkpts0 = correspondences[<span class="hljs-string">&quot;keypoints0&quot;</span>].cpu().numpy()
mkpts1 = correspondences[<span class="hljs-string">&quot;keypoints1&quot;</span>].cpu().numpy()
Fm, inliers = cv2.findFundamentalMat(mkpts0, mkpts1, cv2.USAC_MAGSAC, <span class="hljs-number">0.5</span>, <span class="hljs-number">0.999</span>, <span class="hljs-number">100000</span>)
inliers = inliers &gt; <span class="hljs-number">0</span>`,wrap:!1}}),ze=new u({props:{code:"ZHJhd19MQUZfbWF0Y2hlcyglMEElMjAlMjAlMjAlMjBLRi5sYWZfZnJvbV9jZW50ZXJfc2NhbGVfb3JpKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLmZyb21fbnVtcHkobWtwdHMwKS52aWV3KDElMkMlMjAtMSUyQyUyMDIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2gub25lcyhta3B0czAuc2hhcGUlNUIwJTVEKS52aWV3KDElMkMlMjAtMSUyQyUyMDElMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLm9uZXMobWtwdHMwLnNoYXBlJTVCMCU1RCkudmlldygxJTJDJTIwLTElMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjBLRi5sYWZfZnJvbV9jZW50ZXJfc2NhbGVfb3JpKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLmZyb21fbnVtcHkobWtwdHMxKS52aWV3KDElMkMlMjAtMSUyQyUyMDIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2gub25lcyhta3B0czEuc2hhcGUlNUIwJTVEKS52aWV3KDElMkMlMjAtMSUyQyUyMDElMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLm9uZXMobWtwdHMxLnNoYXBlJTVCMCU1RCkudmlldygxJTJDJTIwLTElMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjB0b3JjaC5hcmFuZ2UobWtwdHMwLnNoYXBlJTVCMCU1RCkudmlldygtMSUyQyUyMDEpLnJlcGVhdCgxJTJDJTIwMiklMkMlMEElMjAlMjAlMjAlMjBLLnRlbnNvcl90b19pbWFnZShpbWcxKSUyQyUwQSUyMCUyMCUyMCUyMEsudGVuc29yX3RvX2ltYWdlKGltZzIpJTJDJTBBJTIwJTIwJTIwJTIwaW5saWVycyUyQyUwQSUyMCUyMCUyMCUyMGRyYXdfZGljdCUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlubGllcl9jb2xvciUyMiUzQSUyMCgwLjElMkMlMjAxJTJDJTIwMC4xJTJDJTIwMC41KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRlbnRhdGl2ZV9jb2xvciUyMiUzQSUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlX2NvbG9yJTIyJTNBJTIwKDAuMiUyQyUyMDAuMiUyQyUyMDElMkMlMjAwLjUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmVydGljYWwlMjIlM0ElMjBGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSk=",highlighted:`draw_LAF_matches(
    KF.laf_from_center_scale_ori(
        torch.from_numpy(mkpts0).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">2</span>),
        torch.ones(mkpts0.shape[<span class="hljs-number">0</span>]).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
        torch.ones(mkpts0.shape[<span class="hljs-number">0</span>]).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
    ),
    KF.laf_from_center_scale_ori(
        torch.from_numpy(mkpts1).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">2</span>),
        torch.ones(mkpts1.shape[<span class="hljs-number">0</span>]).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
        torch.ones(mkpts1.shape[<span class="hljs-number">0</span>]).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
    ),
    torch.arange(mkpts0.shape[<span class="hljs-number">0</span>]).view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>).repeat(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>),
    K.tensor_to_image(img1),
    K.tensor_to_image(img2),
    inliers,
    draw_dict={
        <span class="hljs-string">&quot;inlier_color&quot;</span>: (<span class="hljs-number">0.1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0.1</span>, <span class="hljs-number">0.5</span>),
        <span class="hljs-string">&quot;tentative_color&quot;</span>: <span class="hljs-literal">None</span>,
        <span class="hljs-string">&quot;feature_color&quot;</span>: (<span class="hljs-number">0.2</span>, <span class="hljs-number">0.2</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0.5</span>),
        <span class="hljs-string">&quot;vertical&quot;</span>: <span class="hljs-literal">False</span>,
    },
)`,wrap:!1}}),De=new _l({props:{title:"Resources and Further Reading",local:"resources-and-further-reading",headingTag:"h2"}}),{c(){f=i("meta"),qe=a(),Ke=i("p"),Oe=a(),m(w.$$.fragment),et=a(),T=i("p"),T.textContent=El,tt=a(),m(U.$$.fragment),lt=a(),J=i("p"),J.textContent=Wl,st=a(),d=i("p"),d.textContent=Sl,at=a(),b=i("p"),b.textContent=Al,nt=a(),m(g.$$.fragment),it=a(),m(j.$$.fragment),pt=a(),C=i("p"),C.innerHTML=Gl,rt=a(),k=i("p"),k.textContent=Ll,mt=a(),m($.$$.fragment),Mt=a(),I=i("p"),I.textContent=Yl,ot=a(),m(v.$$.fragment),ht=a(),R=i("p"),R.innerHTML=Zl,ct=a(),m(x.$$.fragment),yt=a(),N=i("p"),N.textContent=Ql,ut=a(),m(F.$$.fragment),ft=a(),_=i("p"),_.textContent=zl,wt=a(),m(B.$$.fragment),Tt=a(),E=i("p"),E.textContent=Xl,Ut=a(),m(W.$$.fragment),Jt=a(),S=i("p"),S.innerHTML=Vl,dt=a(),A=i("p"),A.innerHTML=Dl,bt=a(),G=i("p"),G.textContent=Hl,gt=a(),m(L.$$.fragment),jt=a(),Y=i("p"),Y.textContent=Kl,Ct=a(),m(Z.$$.fragment),kt=a(),Q=i("p"),Q.textContent=Pl,$t=a(),m(z.$$.fragment),It=a(),X=i("p"),X.innerHTML=ql,vt=a(),m(V.$$.fragment),Rt=a(),D=i("p"),D.textContent=Ol,xt=a(),m(H.$$.fragment),Nt=a(),K=i("p"),K.textContent=es,Ft=a(),m(P.$$.fragment),_t=a(),q=i("p"),q.textContent=ts,Bt=a(),m(O.$$.fragment),Et=a(),ee=i("p"),ee.innerHTML=ls,Wt=a(),te=i("p"),te.innerHTML=ss,St=a(),le=i("p"),le.innerHTML=as,At=a(),se=i("p"),se.innerHTML=ns,Gt=a(),m(ae.$$.fragment),Lt=a(),ne=i("p"),ne.innerHTML=is,Yt=a(),ie=i("p"),ie.textContent=ps,Zt=a(),m(pe.$$.fragment),Qt=a(),re=i("p"),re.textContent=rs,zt=a(),m(me.$$.fragment),Xt=a(),Me=i("p"),Me.textContent=ms,Vt=a(),m(oe.$$.fragment),Dt=a(),he=i("p"),he.textContent=Ms,Ht=a(),m(ce.$$.fragment),Kt=a(),ye=i("p"),ye.textContent=os,Pt=a(),m(ue.$$.fragment),qt=a(),fe=i("p"),fe.textContent=hs,Ot=a(),we=i("ul"),we.innerHTML=cs,el=a(),m(Te.$$.fragment),tl=a(),Ue=i("p"),Ue.textContent=ys,ll=a(),m(Je.$$.fragment),sl=a(),de=i("p"),de.textContent=us,al=a(),m(be.$$.fragment),nl=a(),ge=i("p"),ge.textContent=fs,il=a(),m(je.$$.fragment),pl=a(),Ce=i("p"),Ce.innerHTML=ws,rl=a(),m(ke.$$.fragment),ml=a(),$e=i("p"),$e.innerHTML=Ts,Ml=a(),Ie=i("p"),Ie.textContent=Us,ol=a(),ve=i("p"),ve.innerHTML=Js,hl=a(),m(Re.$$.fragment),cl=a(),xe=i("p"),xe.textContent=ds,yl=a(),m(Ne.$$.fragment),ul=a(),Fe=i("p"),Fe.textContent=bs,fl=a(),m(_e.$$.fragment),wl=a(),Be=i("p"),Be.textContent=gs,Tl=a(),m(Ee.$$.fragment),Ul=a(),We=i("p"),We.innerHTML=js,Jl=a(),m(Se.$$.fragment),dl=a(),Ae=i("p"),Ae.textContent=Cs,bl=a(),m(Ge.$$.fragment),gl=a(),Le=i("p"),Le.innerHTML=ks,jl=a(),Ye=i("ul"),Ye.innerHTML=$s,Cl=a(),m(Ze.$$.fragment),kl=a(),Qe=i("p"),Qe.textContent=Is,$l=a(),m(ze.$$.fragment),Il=a(),Xe=i("p"),Xe.textContent=vs,vl=a(),Ve=i("p"),Ve.innerHTML=Rs,Rl=a(),m(De.$$.fragment),xl=a(),He=i("ul"),He.innerHTML=xs,Nl=a(),Pe=i("p"),this.h()},l(e){const t=As("svelte-u9bgzb",document.head);f=p(t,"META",{name:!0,content:!0}),t.forEach(l),qe=n(e),Ke=p(e,"P",{}),Ns(Ke).forEach(l),Oe=n(e),M(w.$$.fragment,e),et=n(e),T=p(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-15xns04"&&(T.textContent=El),tt=n(e),M(U.$$.fragment,e),lt=n(e),J=p(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-on1oww"&&(J.textContent=Wl),st=n(e),d=p(e,"P",{"data-svelte-h":!0}),r(d)!=="svelte-18ol5uq"&&(d.textContent=Sl),at=n(e),b=p(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-wejofh"&&(b.textContent=Al),nt=n(e),M(g.$$.fragment,e),it=n(e),M(j.$$.fragment,e),pt=n(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-9u0yio"&&(C.innerHTML=Gl),rt=n(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-xhtjvy"&&(k.textContent=Ll),mt=n(e),M($.$$.fragment,e),Mt=n(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-al0kvu"&&(I.textContent=Yl),ot=n(e),M(v.$$.fragment,e),ht=n(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-7bnksi"&&(R.innerHTML=Zl),ct=n(e),M(x.$$.fragment,e),yt=n(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1ukq6tm"&&(N.textContent=Ql),ut=n(e),M(F.$$.fragment,e),ft=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1tvlz3f"&&(_.textContent=zl),wt=n(e),M(B.$$.fragment,e),Tt=n(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1pmjdb4"&&(E.textContent=Xl),Ut=n(e),M(W.$$.fragment,e),Jt=n(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1q91c10"&&(S.innerHTML=Vl),dt=n(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-ugbzmf"&&(A.innerHTML=Dl),bt=n(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-kyr7ry"&&(G.textContent=Hl),gt=n(e),M(L.$$.fragment,e),jt=n(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-77rodt"&&(Y.textContent=Kl),Ct=n(e),M(Z.$$.fragment,e),kt=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1qtt5gg"&&(Q.textContent=Pl),$t=n(e),M(z.$$.fragment,e),It=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-16ya51f"&&(X.innerHTML=ql),vt=n(e),M(V.$$.fragment,e),Rt=n(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1v5oeu7"&&(D.textContent=Ol),xt=n(e),M(H.$$.fragment,e),Nt=n(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1h33ao6"&&(K.textContent=es),Ft=n(e),M(P.$$.fragment,e),_t=n(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-7ltwd"&&(q.textContent=ts),Bt=n(e),M(O.$$.fragment,e),Et=n(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1br77qa"&&(ee.innerHTML=ls),Wt=n(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1bts3l5"&&(te.innerHTML=ss),St=n(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-7xmq23"&&(le.innerHTML=as),At=n(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1mldkaf"&&(se.innerHTML=ns),Gt=n(e),M(ae.$$.fragment,e),Lt=n(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1m9tubv"&&(ne.innerHTML=is),Yt=n(e),ie=p(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-h7p197"&&(ie.textContent=ps),Zt=n(e),M(pe.$$.fragment,e),Qt=n(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-11v6c0c"&&(re.textContent=rs),zt=n(e),M(me.$$.fragment,e),Xt=n(e),Me=p(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-kyr7ry"&&(Me.textContent=ms),Vt=n(e),M(oe.$$.fragment,e),Dt=n(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-nee6yp"&&(he.textContent=Ms),Ht=n(e),M(ce.$$.fragment,e),Kt=n(e),ye=p(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-j9xg9v"&&(ye.textContent=os),Pt=n(e),M(ue.$$.fragment,e),qt=n(e),fe=p(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-urviwb"&&(fe.textContent=hs),Ot=n(e),we=p(e,"UL",{"data-svelte-h":!0}),r(we)!=="svelte-1jmifrz"&&(we.innerHTML=cs),el=n(e),M(Te.$$.fragment,e),tl=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-199xp39"&&(Ue.textContent=ys),ll=n(e),M(Je.$$.fragment,e),sl=n(e),de=p(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-fecykb"&&(de.textContent=us),al=n(e),M(be.$$.fragment,e),nl=n(e),ge=p(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-f3wkj0"&&(ge.textContent=fs),il=n(e),M(je.$$.fragment,e),pl=n(e),Ce=p(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1wrykwq"&&(Ce.innerHTML=ws),rl=n(e),M(ke.$$.fragment,e),ml=n(e),$e=p(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-lacwgz"&&($e.innerHTML=Ts),Ml=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-9siw9c"&&(Ie.textContent=Us),ol=n(e),ve=p(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1e39a5t"&&(ve.innerHTML=Js),hl=n(e),M(Re.$$.fragment,e),cl=n(e),xe=p(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-vha9bb"&&(xe.textContent=ds),yl=n(e),M(Ne.$$.fragment,e),ul=n(e),Fe=p(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-aki0ny"&&(Fe.textContent=bs),fl=n(e),M(_e.$$.fragment,e),wl=n(e),Be=p(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-bfbt3u"&&(Be.textContent=gs),Tl=n(e),M(Ee.$$.fragment,e),Ul=n(e),We=p(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-b5645s"&&(We.innerHTML=js),Jl=n(e),M(Se.$$.fragment,e),dl=n(e),Ae=p(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1j2l3za"&&(Ae.textContent=Cs),bl=n(e),M(Ge.$$.fragment,e),gl=n(e),Le=p(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1kls2jh"&&(Le.innerHTML=ks),jl=n(e),Ye=p(e,"UL",{"data-svelte-h":!0}),r(Ye)!=="svelte-1exojfa"&&(Ye.innerHTML=$s),Cl=n(e),M(Ze.$$.fragment,e),kl=n(e),Qe=p(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-162adi5"&&(Qe.textContent=Is),$l=n(e),M(ze.$$.fragment,e),Il=n(e),Xe=p(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-19n2hbq"&&(Xe.textContent=vs),vl=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1p8df1m"&&(Ve.innerHTML=Rs),Rl=n(e),M(De.$$.fragment,e),xl=n(e),He=p(e,"UL",{"data-svelte-h":!0}),r(He)!=="svelte-5o0z5y"&&(He.innerHTML=xs),Nl=n(e),Pe=p(e,"P",{}),Ns(Pe).forEach(l),this.h()},h(){Fs(f,"name","hf:doc:metadata"),Fs(f,"content",Ys)},m(e,t){Gs(document.head,f),s(e,qe,t),s(e,Ke,t),s(e,Oe,t),o(w,e,t),s(e,et,t),s(e,T,t),s(e,tt,t),o(U,e,t),s(e,lt,t),s(e,J,t),s(e,st,t),s(e,d,t),s(e,at,t),s(e,b,t),s(e,nt,t),o(g,e,t),s(e,it,t),o(j,e,t),s(e,pt,t),s(e,C,t),s(e,rt,t),s(e,k,t),s(e,mt,t),o($,e,t),s(e,Mt,t),s(e,I,t),s(e,ot,t),o(v,e,t),s(e,ht,t),s(e,R,t),s(e,ct,t),o(x,e,t),s(e,yt,t),s(e,N,t),s(e,ut,t),o(F,e,t),s(e,ft,t),s(e,_,t),s(e,wt,t),o(B,e,t),s(e,Tt,t),s(e,E,t),s(e,Ut,t),o(W,e,t),s(e,Jt,t),s(e,S,t),s(e,dt,t),s(e,A,t),s(e,bt,t),s(e,G,t),s(e,gt,t),o(L,e,t),s(e,jt,t),s(e,Y,t),s(e,Ct,t),o(Z,e,t),s(e,kt,t),s(e,Q,t),s(e,$t,t),o(z,e,t),s(e,It,t),s(e,X,t),s(e,vt,t),o(V,e,t),s(e,Rt,t),s(e,D,t),s(e,xt,t),o(H,e,t),s(e,Nt,t),s(e,K,t),s(e,Ft,t),o(P,e,t),s(e,_t,t),s(e,q,t),s(e,Bt,t),o(O,e,t),s(e,Et,t),s(e,ee,t),s(e,Wt,t),s(e,te,t),s(e,St,t),s(e,le,t),s(e,At,t),s(e,se,t),s(e,Gt,t),o(ae,e,t),s(e,Lt,t),s(e,ne,t),s(e,Yt,t),s(e,ie,t),s(e,Zt,t),o(pe,e,t),s(e,Qt,t),s(e,re,t),s(e,zt,t),o(me,e,t),s(e,Xt,t),s(e,Me,t),s(e,Vt,t),o(oe,e,t),s(e,Dt,t),s(e,he,t),s(e,Ht,t),o(ce,e,t),s(e,Kt,t),s(e,ye,t),s(e,Pt,t),o(ue,e,t),s(e,qt,t),s(e,fe,t),s(e,Ot,t),s(e,we,t),s(e,el,t),o(Te,e,t),s(e,tl,t),s(e,Ue,t),s(e,ll,t),o(Je,e,t),s(e,sl,t),s(e,de,t),s(e,al,t),o(be,e,t),s(e,nl,t),s(e,ge,t),s(e,il,t),o(je,e,t),s(e,pl,t),s(e,Ce,t),s(e,rl,t),o(ke,e,t),s(e,ml,t),s(e,$e,t),s(e,Ml,t),s(e,Ie,t),s(e,ol,t),s(e,ve,t),s(e,hl,t),o(Re,e,t),s(e,cl,t),s(e,xe,t),s(e,yl,t),o(Ne,e,t),s(e,ul,t),s(e,Fe,t),s(e,fl,t),o(_e,e,t),s(e,wl,t),s(e,Be,t),s(e,Tl,t),o(Ee,e,t),s(e,Ul,t),s(e,We,t),s(e,Jl,t),o(Se,e,t),s(e,dl,t),s(e,Ae,t),s(e,bl,t),o(Ge,e,t),s(e,gl,t),s(e,Le,t),s(e,jl,t),s(e,Ye,t),s(e,Cl,t),o(Ze,e,t),s(e,kl,t),s(e,Qe,t),s(e,$l,t),o(ze,e,t),s(e,Il,t),s(e,Xe,t),s(e,vl,t),s(e,Ve,t),s(e,Rl,t),o(De,e,t),s(e,xl,t),s(e,He,t),s(e,Nl,t),s(e,Pe,t),Fl=!0},p:Bs,i(e){Fl||(h(w.$$.fragment,e),h(U.$$.fragment,e),h(g.$$.fragment,e),h(j.$$.fragment,e),h($.$$.fragment,e),h(v.$$.fragment,e),h(x.$$.fragment,e),h(F.$$.fragment,e),h(B.$$.fragment,e),h(W.$$.fragment,e),h(L.$$.fragment,e),h(Z.$$.fragment,e),h(z.$$.fragment,e),h(V.$$.fragment,e),h(H.$$.fragment,e),h(P.$$.fragment,e),h(O.$$.fragment,e),h(ae.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(oe.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(Te.$$.fragment,e),h(Je.$$.fragment,e),h(be.$$.fragment,e),h(je.$$.fragment,e),h(ke.$$.fragment,e),h(Re.$$.fragment,e),h(Ne.$$.fragment,e),h(_e.$$.fragment,e),h(Ee.$$.fragment,e),h(Se.$$.fragment,e),h(Ge.$$.fragment,e),h(Ze.$$.fragment,e),h(ze.$$.fragment,e),h(De.$$.fragment,e),Fl=!0)},o(e){c(w.$$.fragment,e),c(U.$$.fragment,e),c(g.$$.fragment,e),c(j.$$.fragment,e),c($.$$.fragment,e),c(v.$$.fragment,e),c(x.$$.fragment,e),c(F.$$.fragment,e),c(B.$$.fragment,e),c(W.$$.fragment,e),c(L.$$.fragment,e),c(Z.$$.fragment,e),c(z.$$.fragment,e),c(V.$$.fragment,e),c(H.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(ae.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(oe.$$.fragment,e),c(ce.$$.fragment,e),c(ue.$$.fragment,e),c(Te.$$.fragment,e),c(Je.$$.fragment,e),c(be.$$.fragment,e),c(je.$$.fragment,e),c(ke.$$.fragment,e),c(Re.$$.fragment,e),c(Ne.$$.fragment,e),c(_e.$$.fragment,e),c(Ee.$$.fragment,e),c(Se.$$.fragment,e),c(Ge.$$.fragment,e),c(Ze.$$.fragment,e),c(ze.$$.fragment,e),c(De.$$.fragment,e),Fl=!1},d(e){e&&(l(qe),l(Ke),l(Oe),l(et),l(T),l(tt),l(lt),l(J),l(st),l(d),l(at),l(b),l(nt),l(it),l(pt),l(C),l(rt),l(k),l(mt),l(Mt),l(I),l(ot),l(ht),l(R),l(ct),l(yt),l(N),l(ut),l(ft),l(_),l(wt),l(Tt),l(E),l(Ut),l(Jt),l(S),l(dt),l(A),l(bt),l(G),l(gt),l(jt),l(Y),l(Ct),l(kt),l(Q),l($t),l(It),l(X),l(vt),l(Rt),l(D),l(xt),l(Nt),l(K),l(Ft),l(_t),l(q),l(Bt),l(Et),l(ee),l(Wt),l(te),l(St),l(le),l(At),l(se),l(Gt),l(Lt),l(ne),l(Yt),l(ie),l(Zt),l(Qt),l(re),l(zt),l(Xt),l(Me),l(Vt),l(Dt),l(he),l(Ht),l(Kt),l(ye),l(Pt),l(qt),l(fe),l(Ot),l(we),l(el),l(tl),l(Ue),l(ll),l(sl),l(de),l(al),l(nl),l(ge),l(il),l(pl),l(Ce),l(rl),l(ml),l($e),l(Ml),l(Ie),l(ol),l(ve),l(hl),l(cl),l(xe),l(yl),l(ul),l(Fe),l(fl),l(wl),l(Be),l(Tl),l(Ul),l(We),l(Jl),l(dl),l(Ae),l(bl),l(gl),l(Le),l(jl),l(Ye),l(Cl),l(kl),l(Qe),l($l),l(Il),l(Xe),l(vl),l(Ve),l(Rl),l(xl),l(He),l(Nl),l(Pe)),l(f),y(w,e),y(U,e),y(g,e),y(j,e),y($,e),y(v,e),y(x,e),y(F,e),y(B,e),y(W,e),y(L,e),y(Z,e),y(z,e),y(V,e),y(H,e),y(P,e),y(O,e),y(ae,e),y(pe,e),y(me,e),y(oe,e),y(ce,e),y(ue,e),y(Te,e),y(Je,e),y(be,e),y(je,e),y(ke,e),y(Re,e),y(Ne,e),y(_e,e),y(Ee,e),y(Se,e),y(Ge,e),y(Ze,e),y(ze,e),y(De,e)}}}const Ys='{"title":"Feature Matching","local":"feature-matching","sections":[{"title":"Brute-Force Search","local":"brute-force-search","sections":[],"depth":2},{"title":"Local Feature Matching with Transformers (LoFTR)","local":"local-feature-matching-with-transformers-loftr","sections":[],"depth":2},{"title":"Resources and Further Reading","local":"resources-and-further-reading","sections":[],"depth":2}],"depth":1}';function Zs(Bl){return Es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ds extends Ws{constructor(f){super(),Ss(this,f,Zs,Ls,_s,{})}}export{Ds as component};
