import{s as Fo,n as Uo,o as Po}from"../chunks/scheduler.182ea377.js";import{S as jo,i as qo,g as i,s as n,r as f,A as Lo,h as l,f as t,c as s,j as y,u as p,x as c,k as v,y as o,a as d,v as u,d as _,t as h,w as g}from"../chunks/index.abf12888.js";import{D as w}from"../chunks/Docstring.93f6f462.js";import{C as Oo}from"../chunks/CodeBlock.57fe6e13.js";import{H as he}from"../chunks/Heading.16916d63.js";function zo(mo){let T,xe,ge,ye,U,ve,P,fo='The ControlNet model was introduced in <a href="https://huggingface.co/papers/2302.05543" rel="nofollow">Adding Conditional Control to Text-to-Image Diffusion Models</a> by Lvmin Zhang, Anyi Rao, Maneesh Agrawala. It provides a greater degree of control over text-to-image generation by conditioning the model on additional inputs such as edge maps, depth maps, segmentation maps, and keypoints for pose detection.',Ce,j,po="The abstract from the paper is:",Ne,q,uo="<em>We present ControlNet, a neural network architecture to add spatial conditioning controls to large, pretrained text-to-image diffusion models. ControlNet locks the production-ready large diffusion models, and reuses their deep and robust encoding layers pretrained with billions of images as a strong backbone to learn a diverse set of conditional controls. The neural architecture is connected with “zero convolutions” (zero-initialized convolution layers) that progressively grow the parameters from zero and ensure that no harmful noise could affect the finetuning. We test various conditioning controls, eg, edges, depth, segmentation, human pose, etc, with Stable Diffusion, using single or multiple conditions, with or without prompts. We show that the training of ControlNets is robust with small (&lt;50k) and large (&gt;1m) datasets. Extensive results show that ControlNet may facilitate wider applications to control image diffusion models.</em>",we,L,Te,O,_o=`By default the <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> should be loaded with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a>, but it can also be loaded
from the original format using <code>FromOriginalControlnetMixin.from_single_file</code> as follows:`,Me,z,$e,I,ke,a,B,Re,Q,ho="A ControlNet model.",He,$,J,Ze,ee,go='The <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> forward method.',Ee,k,V,Ge,oe,bo='Instantiate a <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> from <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>.',We,N,R,Se,te,xo="Enable sliced attention computation.",Xe,ne,yo=`When this option is enabled, the attention module splits the input tensor in slices to compute attention in
several steps. This is useful for saving some memory in exchange for a small decrease in speed.`,Ye,A,H,Ke,se,vo="Sets the attention processor to use to compute attention.",Qe,D,Z,eo,re,Co="Disables custom attention processors and sets the default attention implementation.",Ae,E,De,M,G,oo,ie,No='The output of <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a>.',Fe,W,Ue,m,S,to,le,wo="A ControlNet model.",no,de,To=`This model inherits from <a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin">FlaxModelMixin</a>. Check the superclass documentation for it’s generic methods
implemented for all models (such as downloading or saving).`,so,ae,Mo=`This model is also a Flax Linen <a href="https://flax.readthedocs.io/en/latest/flax.linen.html#module" rel="nofollow"><code>flax.linen.Module</code></a>
subclass. Use it as a regular Flax Linen module and refer to the Flax documentation for all matters related to its
general usage and behavior.`,ro,ce,$o="Inherent JAX features such as the following are supported:",io,me,ko='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Pe,X,je,C,Y,lo,fe,Ao='The output of <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.FlaxControlNetModel">FlaxControlNetModel</a>.',ao,F,K,co,pe,Do="“Returns a new object replacing the specified fields with new values.",qe,be,Le;return U=new he({props:{title:"ControlNet",local:"controlnet",headingTag:"h1"}}),L=new he({props:{title:"Loading from the original format",local:"loading-from-the-original-format",headingTag:"h2"}}),z=new Oo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZsbGx5YXN2aWVsJTJGQ29udHJvbE5ldC12MS0xJTJGYmxvYiUyRm1haW4lMkZjb250cm9sX3YxMXBfc2QxNV9jYW5ueS5wdGglMjIlMjAlMjAlMjMlMjBjYW4lMjBhbHNvJTIwYmUlMjBhJTIwbG9jYWwlMjBwYXRoJTBBY29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3NpbmdsZV9maWxlKHVybCklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZibG9iJTJGbWFpbiUyRnYxLTUtcHJ1bmVkLnNhZmV0ZW5zb3JzJTIyJTIwJTIwJTIzJTIwY2FuJTIwYWxzbyUyMGJlJTIwYSUyMGxvY2FsJTIwcGF0aCUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Db250cm9sTmV0UGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSh1cmwlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel

url = <span class="hljs-string">&quot;https://huggingface.co/lllyasviel/ControlNet-v1-1/blob/main/control_v11p_sd15_canny.pth&quot;</span>  <span class="hljs-comment"># can also be a local path</span>
controlnet = ControlNetModel.from_single_file(url)

url = <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned.safetensors&quot;</span>  <span class="hljs-comment"># can also be a local path</span>
pipe = StableDiffusionControlNetPipeline.from_single_file(url, controlnet=controlnet)`,wrap:!1}}),I=new he({props:{title:"ControlNetModel",local:"diffusers.ControlNetModel",headingTag:"h2"}}),B=new w({props:{name:"class diffusers.ControlNetModel",anchor:"diffusers.ControlNetModel",parameters:[{name:"in_channels",val:": int = 4"},{name:"conditioning_channels",val:": int = 3"},{name:"flip_sin_to_cos",val:": bool = True"},{name:"freq_shift",val:": int = 0"},{name:"down_block_types",val:": typing.Tuple[str, ...] = ('CrossAttnDownBlock2D', 'CrossAttnDownBlock2D', 'CrossAttnDownBlock2D', 'DownBlock2D')"},{name:"mid_block_type",val:": typing.Optional[str] = 'UNetMidBlock2DCrossAttn'"},{name:"only_cross_attention",val:": typing.Union[bool, typing.Tuple[bool]] = False"},{name:"block_out_channels",val:": typing.Tuple[int, ...] = (320, 640, 1280, 1280)"},{name:"layers_per_block",val:": int = 2"},{name:"downsample_padding",val:": int = 1"},{name:"mid_block_scale_factor",val:": float = 1"},{name:"act_fn",val:": str = 'silu'"},{name:"norm_num_groups",val:": typing.Optional[int] = 32"},{name:"norm_eps",val:": float = 1e-05"},{name:"cross_attention_dim",val:": int = 1280"},{name:"transformer_layers_per_block",val:": typing.Union[int, typing.Tuple[int, ...]] = 1"},{name:"encoder_hid_dim",val:": typing.Optional[int] = None"},{name:"encoder_hid_dim_type",val:": typing.Optional[str] = None"},{name:"attention_head_dim",val:": typing.Union[int, typing.Tuple[int, ...]] = 8"},{name:"num_attention_heads",val:": typing.Union[int, typing.Tuple[int, ...], NoneType] = None"},{name:"use_linear_projection",val:": bool = False"},{name:"class_embed_type",val:": typing.Optional[str] = None"},{name:"addition_embed_type",val:": typing.Optional[str] = None"},{name:"addition_time_embed_dim",val:": typing.Optional[int] = None"},{name:"num_class_embeds",val:": typing.Optional[int] = None"},{name:"upcast_attention",val:": bool = False"},{name:"resnet_time_scale_shift",val:": str = 'default'"},{name:"projection_class_embeddings_input_dim",val:": typing.Optional[int] = None"},{name:"controlnet_conditioning_channel_order",val:": str = 'rgb'"},{name:"conditioning_embedding_out_channels",val:": typing.Union[typing.Tuple[int, ...], NoneType] = (16, 32, 96, 256)"},{name:"global_pool_conditions",val:": bool = False"},{name:"addition_embed_type_num_heads",val:": int = 64"}],parametersDescription:[{anchor:"diffusers.ControlNetModel.in_channels",description:`<strong>in_channels</strong> (<code>int</code>, defaults to 4) &#x2014;
The number of channels in the input sample.`,name:"in_channels"},{anchor:"diffusers.ControlNetModel.flip_sin_to_cos",description:`<strong>flip_sin_to_cos</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to flip the sin to cos in the time embedding.`,name:"flip_sin_to_cos"},{anchor:"diffusers.ControlNetModel.freq_shift",description:`<strong>freq_shift</strong> (<code>int</code>, defaults to 0) &#x2014;
The frequency shift to apply to the time embedding.`,name:"freq_shift"},{anchor:"diffusers.ControlNetModel.down_block_types",description:`<strong>down_block_types</strong> (<code>tuple[str]</code>, defaults to <code>(&quot;CrossAttnDownBlock2D&quot;, &quot;CrossAttnDownBlock2D&quot;, &quot;CrossAttnDownBlock2D&quot;, &quot;DownBlock2D&quot;)</code>) &#x2014;
The tuple of downsample blocks to use.`,name:"down_block_types"},{anchor:"diffusers.ControlNetModel.only_cross_attention",description:"<strong>only_cross_attention</strong> (<code>Union[bool, Tuple[bool]]</code>, defaults to <code>False</code>) &#x2014;",name:"only_cross_attention"},{anchor:"diffusers.ControlNetModel.block_out_channels",description:`<strong>block_out_channels</strong> (<code>tuple[int]</code>, defaults to <code>(320, 640, 1280, 1280)</code>) &#x2014;
The tuple of output channels for each block.`,name:"block_out_channels"},{anchor:"diffusers.ControlNetModel.layers_per_block",description:`<strong>layers_per_block</strong> (<code>int</code>, defaults to 2) &#x2014;
The number of layers per block.`,name:"layers_per_block"},{anchor:"diffusers.ControlNetModel.downsample_padding",description:`<strong>downsample_padding</strong> (<code>int</code>, defaults to 1) &#x2014;
The padding to use for the downsampling convolution.`,name:"downsample_padding"},{anchor:"diffusers.ControlNetModel.mid_block_scale_factor",description:`<strong>mid_block_scale_factor</strong> (<code>float</code>, defaults to 1) &#x2014;
The scale factor to use for the mid block.`,name:"mid_block_scale_factor"},{anchor:"diffusers.ControlNetModel.act_fn",description:`<strong>act_fn</strong> (<code>str</code>, defaults to &#x201C;silu&#x201D;) &#x2014;
The activation function to use.`,name:"act_fn"},{anchor:"diffusers.ControlNetModel.norm_num_groups",description:`<strong>norm_num_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of groups to use for the normalization. If None, normalization and activation layers is skipped
in post-processing.`,name:"norm_num_groups"},{anchor:"diffusers.ControlNetModel.norm_eps",description:`<strong>norm_eps</strong> (<code>float</code>, defaults to 1e-5) &#x2014;
The epsilon to use for the normalization.`,name:"norm_eps"},{anchor:"diffusers.ControlNetModel.cross_attention_dim",description:`<strong>cross_attention_dim</strong> (<code>int</code>, defaults to 1280) &#x2014;
The dimension of the cross attention features.`,name:"cross_attention_dim"},{anchor:"diffusers.ControlNetModel.transformer_layers_per_block",description:`<strong>transformer_layers_per_block</strong> (<code>int</code> or <code>Tuple[int]</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of transformer blocks of type <code>BasicTransformerBlock</code>. Only relevant for
<code>CrossAttnDownBlock2D</code>, <code>CrossAttnUpBlock2D</code>,
<code>UNetMidBlock2DCrossAttn</code>.`,name:"transformer_layers_per_block"},{anchor:"diffusers.ControlNetModel.encoder_hid_dim",description:`<strong>encoder_hid_dim</strong> (<code>int</code>, <em>optional</em>, defaults to None) &#x2014;
If <code>encoder_hid_dim_type</code> is defined, <code>encoder_hidden_states</code> will be projected from <code>encoder_hid_dim</code>
dimension to <code>cross_attention_dim</code>.`,name:"encoder_hid_dim"},{anchor:"diffusers.ControlNetModel.encoder_hid_dim_type",description:`<strong>encoder_hid_dim_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If given, the <code>encoder_hidden_states</code> and potentially other embeddings are down-projected to text
embeddings of dimension <code>cross_attention</code> according to <code>encoder_hid_dim_type</code>.`,name:"encoder_hid_dim_type"},{anchor:"diffusers.ControlNetModel.attention_head_dim",description:`<strong>attention_head_dim</strong> (<code>Union[int, Tuple[int]]</code>, defaults to 8) &#x2014;
The dimension of the attention heads.`,name:"attention_head_dim"},{anchor:"diffusers.ControlNetModel.use_linear_projection",description:"<strong>use_linear_projection</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;",name:"use_linear_projection"},{anchor:"diffusers.ControlNetModel.class_embed_type",description:`<strong>class_embed_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The type of class embedding to use which is ultimately summed with the time embeddings. Choose from None,
<code>&quot;timestep&quot;</code>, <code>&quot;identity&quot;</code>, <code>&quot;projection&quot;</code>, or <code>&quot;simple_projection&quot;</code>.`,name:"class_embed_type"},{anchor:"diffusers.ControlNetModel.addition_embed_type",description:`<strong>addition_embed_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Configures an optional embedding which will be summed with the time embeddings. Choose from <code>None</code> or
&#x201C;text&#x201D;. &#x201C;text&#x201D; will use the <code>TextTimeEmbedding</code> layer.`,name:"addition_embed_type"},{anchor:"diffusers.ControlNetModel.num_class_embeds",description:`<strong>num_class_embeds</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Input dimension of the learnable embedding matrix to be projected to <code>time_embed_dim</code>, when performing
class conditioning with <code>class_embed_type</code> equal to <code>None</code>.`,name:"num_class_embeds"},{anchor:"diffusers.ControlNetModel.upcast_attention",description:"<strong>upcast_attention</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;",name:"upcast_attention"},{anchor:"diffusers.ControlNetModel.resnet_time_scale_shift",description:`<strong>resnet_time_scale_shift</strong> (<code>str</code>, defaults to <code>&quot;default&quot;</code>) &#x2014;
Time scale shift config for ResNet blocks (see <code>ResnetBlock2D</code>). Choose from <code>default</code> or <code>scale_shift</code>.`,name:"resnet_time_scale_shift"},{anchor:"diffusers.ControlNetModel.projection_class_embeddings_input_dim",description:`<strong>projection_class_embeddings_input_dim</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The dimension of the <code>class_labels</code> input when <code>class_embed_type=&quot;projection&quot;</code>. Required when
<code>class_embed_type=&quot;projection&quot;</code>.`,name:"projection_class_embeddings_input_dim"},{anchor:"diffusers.ControlNetModel.controlnet_conditioning_channel_order",description:`<strong>controlnet_conditioning_channel_order</strong> (<code>str</code>, defaults to <code>&quot;rgb&quot;</code>) &#x2014;
The channel order of conditional image. Will convert to <code>rgb</code> if it&#x2019;s <code>bgr</code>.`,name:"controlnet_conditioning_channel_order"},{anchor:"diffusers.ControlNetModel.conditioning_embedding_out_channels",description:`<strong>conditioning_embedding_out_channels</strong> (<code>tuple[int]</code>, <em>optional</em>, defaults to <code>(16, 32, 96, 256)</code>) &#x2014;
The tuple of output channel for each block in the <code>conditioning_embedding</code> layer.`,name:"conditioning_embedding_out_channels"},{anchor:"diffusers.ControlNetModel.global_pool_conditions",description:`<strong>global_pool_conditions</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
TODO(Patrick) - unused parameter.`,name:"global_pool_conditions"},{anchor:"diffusers.ControlNetModel.addition_embed_type_num_heads",description:`<strong>addition_embed_type_num_heads</strong> (<code>int</code>, defaults to 64) &#x2014;
The number of heads to use for the <code>TextTimeEmbedding</code> layer.`,name:"addition_embed_type_num_heads"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/controlnet.py#L105"}}),J=new w({props:{name:"forward",anchor:"diffusers.ControlNetModel.forward",parameters:[{name:"sample",val:": FloatTensor"},{name:"timestep",val:": typing.Union[torch.Tensor, float, int]"},{name:"encoder_hidden_states",val:": Tensor"},{name:"controlnet_cond",val:": FloatTensor"},{name:"conditioning_scale",val:": float = 1.0"},{name:"class_labels",val:": typing.Optional[torch.Tensor] = None"},{name:"timestep_cond",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"added_cond_kwargs",val:": typing.Union[typing.Dict[str, torch.Tensor], NoneType] = None"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"guess_mode",val:": bool = False"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.ControlNetModel.forward.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
The noisy input tensor.`,name:"sample"},{anchor:"diffusers.ControlNetModel.forward.timestep",description:`<strong>timestep</strong> (<code>Union[torch.Tensor, float, int]</code>) &#x2014;
The number of timesteps to denoise an input.`,name:"timestep"},{anchor:"diffusers.ControlNetModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.Tensor</code>) &#x2014;
The encoder hidden states.`,name:"encoder_hidden_states"},{anchor:"diffusers.ControlNetModel.forward.controlnet_cond",description:`<strong>controlnet_cond</strong> (<code>torch.FloatTensor</code>) &#x2014;
The conditional input tensor of shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"controlnet_cond"},{anchor:"diffusers.ControlNetModel.forward.conditioning_scale",description:`<strong>conditioning_scale</strong> (<code>float</code>, defaults to <code>1.0</code>) &#x2014;
The scale factor for ControlNet outputs.`,name:"conditioning_scale"},{anchor:"diffusers.ControlNetModel.forward.class_labels",description:`<strong>class_labels</strong> (<code>torch.Tensor</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Optional class labels for conditioning. Their embeddings will be summed with the timestep embeddings.`,name:"class_labels"},{anchor:"diffusers.ControlNetModel.forward.timestep_cond",description:`<strong>timestep_cond</strong> (<code>torch.Tensor</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Additional conditional embeddings for timestep. If provided, the embeddings will be summed with the
timestep_embedding passed through the <code>self.time_embedding</code> layer to obtain the final timestep
embeddings.`,name:"timestep_cond"},{anchor:"diffusers.ControlNetModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An attention mask of shape <code>(batch, key_tokens)</code> is applied to <code>encoder_hidden_states</code>. If <code>1</code> the mask
is kept, otherwise if <code>0</code> it is discarded. Mask will be converted into a bias, which adds large
negative values to the attention scores corresponding to &#x201C;discard&#x201D; tokens.`,name:"attention_mask"},{anchor:"diffusers.ControlNetModel.forward.added_cond_kwargs",description:`<strong>added_cond_kwargs</strong> (<code>dict</code>) &#x2014;
Additional conditions for the Stable Diffusion XL UNet.`,name:"added_cond_kwargs"},{anchor:"diffusers.ControlNetModel.forward.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttnProcessor</code>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.ControlNetModel.forward.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
In this mode, the ControlNet encoder tries its best to recognize the input content of the input even if
you remove all prompts. A <code>guidance_scale</code> between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"diffusers.ControlNetModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.models.controlnet.ControlNetOutput">ControlNetOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/controlnet.py#L659",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, a <a
  href="/docs/diffusers/main/en/api/models/controlnet#diffusers.models.controlnet.ControlNetOutput"
>ControlNetOutput</a> is returned, otherwise a tuple is
returned where the first element is the sample tensor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/models/controlnet#diffusers.models.controlnet.ControlNetOutput"
>ControlNetOutput</a> <strong>or</strong> <code>tuple</code></p>
`}}),V=new w({props:{name:"from_unet",anchor:"diffusers.ControlNetModel.from_unet",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet_conditioning_channel_order",val:": str = 'rgb'"},{name:"conditioning_embedding_out_channels",val:": typing.Union[typing.Tuple[int, ...], NoneType] = (16, 32, 96, 256)"},{name:"load_weights_from_unet",val:": bool = True"},{name:"conditioning_channels",val:": int = 3"}],parametersDescription:[{anchor:"diffusers.ControlNetModel.from_unet.unet",description:`<strong>unet</strong> (<code>UNet2DConditionModel</code>) &#x2014;
The UNet model weights to copy to the <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a>. All configuration options are also copied
where applicable.`,name:"unet"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/controlnet.py#L438"}}),R=new w({props:{name:"set_attention_slice",anchor:"diffusers.ControlNetModel.set_attention_slice",parameters:[{name:"slice_size",val:": typing.Union[str, int, typing.List[int]]"}],parametersDescription:[{anchor:"diffusers.ControlNetModel.set_attention_slice.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code> or <code>list(int)</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, input to the attention heads is halved, so attention is computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory is saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/controlnet.py#L590"}}),H=new w({props:{name:"set_attn_processor",anchor:"diffusers.ControlNetModel.set_attn_processor",parameters:[{name:"processor",val:": typing.Union[diffusers.models.attention_processor.AttnProcessor, diffusers.models.attention_processor.AttnProcessor2_0, diffusers.models.attention_processor.XFormersAttnProcessor, diffusers.models.attention_processor.SlicedAttnProcessor, diffusers.models.attention_processor.AttnAddedKVProcessor, diffusers.models.attention_processor.SlicedAttnAddedKVProcessor, diffusers.models.attention_processor.AttnAddedKVProcessor2_0, diffusers.models.attention_processor.XFormersAttnAddedKVProcessor, diffusers.models.attention_processor.CustomDiffusionAttnProcessor, diffusers.models.attention_processor.CustomDiffusionXFormersAttnProcessor, diffusers.models.attention_processor.CustomDiffusionAttnProcessor2_0, diffusers.models.attention_processor.LoRAAttnProcessor, diffusers.models.attention_processor.LoRAAttnProcessor2_0, diffusers.models.attention_processor.LoRAXFormersAttnProcessor, diffusers.models.attention_processor.LoRAAttnAddedKVProcessor, typing.Dict[str, typing.Union[diffusers.models.attention_processor.AttnProcessor, diffusers.models.attention_processor.AttnProcessor2_0, diffusers.models.attention_processor.XFormersAttnProcessor, diffusers.models.attention_processor.SlicedAttnProcessor, diffusers.models.attention_processor.AttnAddedKVProcessor, diffusers.models.attention_processor.SlicedAttnAddedKVProcessor, diffusers.models.attention_processor.AttnAddedKVProcessor2_0, diffusers.models.attention_processor.XFormersAttnAddedKVProcessor, diffusers.models.attention_processor.CustomDiffusionAttnProcessor, diffusers.models.attention_processor.CustomDiffusionXFormersAttnProcessor, diffusers.models.attention_processor.CustomDiffusionAttnProcessor2_0, diffusers.models.attention_processor.LoRAAttnProcessor, diffusers.models.attention_processor.LoRAAttnProcessor2_0, diffusers.models.attention_processor.LoRAXFormersAttnProcessor, diffusers.models.attention_processor.LoRAAttnAddedKVProcessor]]]"},{name:"_remove_lora",val:" = False"}],parametersDescription:[{anchor:"diffusers.ControlNetModel.set_attn_processor.processor",description:`<strong>processor</strong> (<code>dict</code> of <code>AttentionProcessor</code> or only <code>AttentionProcessor</code>) &#x2014;
The instantiated processor class or a dictionary of processor classes that will be set as the processor
for <strong>all</strong> <code>Attention</code> layers.</p>
<p>If <code>processor</code> is a dict, the key needs to define the path to the corresponding cross attention
processor. This is strongly recommended when setting trainable attention processors.`,name:"processor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/controlnet.py#L537"}}),Z=new w({props:{name:"set_default_attn_processor",anchor:"diffusers.ControlNetModel.set_default_attn_processor",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/controlnet.py#L574"}}),E=new he({props:{title:"ControlNetOutput",local:"diffusers.models.controlnet.ControlNetOutput",headingTag:"h2"}}),G=new w({props:{name:"class diffusers.models.controlnet.ControlNetOutput",anchor:"diffusers.models.controlnet.ControlNetOutput",parameters:[{name:"down_block_res_samples",val:": typing.Tuple[torch.Tensor]"},{name:"mid_block_res_sample",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.models.controlnet.ControlNetOutput.down_block_res_samples",description:`<strong>down_block_res_samples</strong> (<code>tuple[torch.Tensor]</code>) &#x2014;
A tuple of downsample activations at different resolutions for each downsampling block. Each tensor should
be of shape <code>(batch_size, channel * resolution, height //resolution, width // resolution)</code>. Output can be
used to condition the original UNet&#x2019;s downsampling activations.`,name:"down_block_res_samples"},{anchor:"diffusers.models.controlnet.ControlNetOutput.mid_down_block_re_sample",description:`<strong>mid_down_block_re_sample</strong> (<code>torch.Tensor</code>) &#x2014;
The activation of the midde block (the lowest sample resolution). Each tensor should be of shape
<code>(batch_size, channel * lowest_resolution, height // lowest_resolution, width // lowest_resolution)</code>.
Output can be used to condition the original UNet&#x2019;s middle block activation.`,name:"mid_down_block_re_sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/controlnet.py#L41"}}),W=new he({props:{title:"FlaxControlNetModel",local:"diffusers.FlaxControlNetModel",headingTag:"h2"}}),S=new w({props:{name:"class diffusers.FlaxControlNetModel",anchor:"diffusers.FlaxControlNetModel",parameters:[{name:"sample_size",val:": int = 32"},{name:"in_channels",val:": int = 4"},{name:"down_block_types",val:": typing.Tuple[str, ...] = ('CrossAttnDownBlock2D', 'CrossAttnDownBlock2D', 'CrossAttnDownBlock2D', 'DownBlock2D')"},{name:"only_cross_attention",val:": typing.Union[bool, typing.Tuple[bool, ...]] = False"},{name:"block_out_channels",val:": typing.Tuple[int, ...] = (320, 640, 1280, 1280)"},{name:"layers_per_block",val:": int = 2"},{name:"attention_head_dim",val:": typing.Union[int, typing.Tuple[int, ...]] = 8"},{name:"num_attention_heads",val:": typing.Union[int, typing.Tuple[int, ...], NoneType] = None"},{name:"cross_attention_dim",val:": int = 1280"},{name:"dropout",val:": float = 0.0"},{name:"use_linear_projection",val:": bool = False"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"flip_sin_to_cos",val:": bool = True"},{name:"freq_shift",val:": int = 0"},{name:"controlnet_conditioning_channel_order",val:": str = 'rgb'"},{name:"conditioning_embedding_out_channels",val:": typing.Tuple[int, ...] = (16, 32, 96, 256)"},{name:"parent",val:": typing.Union[typing.Type[flax.linen.module.Module], typing.Type[flax.core.scope.Scope], typing.Type[flax.linen.module._Sentinel], NoneType] = <flax.linen.module._Sentinel object at 0x7fb130e3b8b0>"},{name:"name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"diffusers.FlaxControlNetModel.sample_size",description:`<strong>sample_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The size of the input sample.`,name:"sample_size"},{anchor:"diffusers.FlaxControlNetModel.in_channels",description:`<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of channels in the input sample.`,name:"in_channels"},{anchor:"diffusers.FlaxControlNetModel.down_block_types",description:`<strong>down_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;FlaxCrossAttnDownBlock2D&quot;, &quot;FlaxCrossAttnDownBlock2D&quot;, &quot;FlaxCrossAttnDownBlock2D&quot;, &quot;FlaxDownBlock2D&quot;)</code>) &#x2014;
The tuple of downsample blocks to use.`,name:"down_block_types"},{anchor:"diffusers.FlaxControlNetModel.block_out_channels",description:`<strong>block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(320, 640, 1280, 1280)</code>) &#x2014;
The tuple of output channels for each block.`,name:"block_out_channels"},{anchor:"diffusers.FlaxControlNetModel.layers_per_block",description:`<strong>layers_per_block</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The number of layers per block.`,name:"layers_per_block"},{anchor:"diffusers.FlaxControlNetModel.attention_head_dim",description:`<strong>attention_head_dim</strong> (<code>int</code> or <code>Tuple[int]</code>, <em>optional</em>, defaults to 8) &#x2014;
The dimension of the attention heads.`,name:"attention_head_dim"},{anchor:"diffusers.FlaxControlNetModel.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code> or <code>Tuple[int]</code>, <em>optional</em>) &#x2014;
The number of attention heads.`,name:"num_attention_heads"},{anchor:"diffusers.FlaxControlNetModel.cross_attention_dim",description:`<strong>cross_attention_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
The dimension of the cross attention features.`,name:"cross_attention_dim"},{anchor:"diffusers.FlaxControlNetModel.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0) &#x2014;
Dropout probability for down, up and bottleneck blocks.`,name:"dropout"},{anchor:"diffusers.FlaxControlNetModel.flip_sin_to_cos",description:`<strong>flip_sin_to_cos</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to flip the sin to cos in the time embedding.`,name:"flip_sin_to_cos"},{anchor:"diffusers.FlaxControlNetModel.freq_shift",description:"<strong>freq_shift</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014; The frequency shift to apply to the time embedding.",name:"freq_shift"},{anchor:"diffusers.FlaxControlNetModel.controlnet_conditioning_channel_order",description:`<strong>controlnet_conditioning_channel_order</strong> (<code>str</code>, <em>optional</em>, defaults to <code>rgb</code>) &#x2014;
The channel order of conditional image. Will convert to <code>rgb</code> if it&#x2019;s <code>bgr</code>.`,name:"controlnet_conditioning_channel_order"},{anchor:"diffusers.FlaxControlNetModel.conditioning_embedding_out_channels",description:`<strong>conditioning_embedding_out_channels</strong> (<code>tuple</code>, <em>optional</em>, defaults to <code>(16, 32, 96, 256)</code>) &#x2014;
The tuple of output channel for each block in the <code>conditioning_embedding</code> layer.`,name:"conditioning_embedding_out_channels"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/controlnet_flax.py#L104"}}),X=new he({props:{title:"FlaxControlNetOutput",local:"diffusers.models.controlnet_flax.FlaxControlNetOutput",headingTag:"h2"}}),Y=new w({props:{name:"class diffusers.models.controlnet_flax.FlaxControlNetOutput",anchor:"diffusers.models.controlnet_flax.FlaxControlNetOutput",parameters:[{name:"down_block_res_samples",val:": Array"},{name:"mid_block_res_sample",val:": Array"}],parametersDescription:[{anchor:"diffusers.models.controlnet_flax.FlaxControlNetOutput.down_block_res_samples",description:"<strong>down_block_res_samples</strong> (<code>jnp.ndarray</code>) &#x2014;",name:"down_block_res_samples"},{anchor:"diffusers.models.controlnet_flax.FlaxControlNetOutput.mid_block_res_sample",description:"<strong>mid_block_res_sample</strong> (<code>jnp.ndarray</code>) &#x2014;",name:"mid_block_res_sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/controlnet_flax.py#L34"}}),K=new w({props:{name:"replace",anchor:"diffusers.models.controlnet_flax.FlaxControlNetOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/flax/struct.py#L111"}}),{c(){T=i("meta"),xe=n(),ge=i("p"),ye=n(),f(U.$$.fragment),ve=n(),P=i("p"),P.innerHTML=fo,Ce=n(),j=i("p"),j.textContent=po,Ne=n(),q=i("p"),q.innerHTML=uo,we=n(),f(L.$$.fragment),Te=n(),O=i("p"),O.innerHTML=_o,Me=n(),f(z.$$.fragment),$e=n(),f(I.$$.fragment),ke=n(),a=i("div"),f(B.$$.fragment),Re=n(),Q=i("p"),Q.textContent=ho,He=n(),$=i("div"),f(J.$$.fragment),Ze=n(),ee=i("p"),ee.innerHTML=go,Ee=n(),k=i("div"),f(V.$$.fragment),Ge=n(),oe=i("p"),oe.innerHTML=bo,We=n(),N=i("div"),f(R.$$.fragment),Se=n(),te=i("p"),te.textContent=xo,Xe=n(),ne=i("p"),ne.textContent=yo,Ye=n(),A=i("div"),f(H.$$.fragment),Ke=n(),se=i("p"),se.textContent=vo,Qe=n(),D=i("div"),f(Z.$$.fragment),eo=n(),re=i("p"),re.textContent=Co,Ae=n(),f(E.$$.fragment),De=n(),M=i("div"),f(G.$$.fragment),oo=n(),ie=i("p"),ie.innerHTML=No,Fe=n(),f(W.$$.fragment),Ue=n(),m=i("div"),f(S.$$.fragment),to=n(),le=i("p"),le.textContent=wo,no=n(),de=i("p"),de.innerHTML=To,so=n(),ae=i("p"),ae.innerHTML=Mo,ro=n(),ce=i("p"),ce.textContent=$o,io=n(),me=i("ul"),me.innerHTML=ko,Pe=n(),f(X.$$.fragment),je=n(),C=i("div"),f(Y.$$.fragment),lo=n(),fe=i("p"),fe.innerHTML=Ao,ao=n(),F=i("div"),f(K.$$.fragment),co=n(),pe=i("p"),pe.textContent=Do,qe=n(),be=i("p"),this.h()},l(e){const r=Lo("svelte-u9bgzb",document.head);T=l(r,"META",{name:!0,content:!0}),r.forEach(t),xe=s(e),ge=l(e,"P",{}),y(ge).forEach(t),ye=s(e),p(U.$$.fragment,e),ve=s(e),P=l(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-1s65p96"&&(P.innerHTML=fo),Ce=s(e),j=l(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-1cwsb16"&&(j.textContent=po),Ne=s(e),q=l(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-fbiw6t"&&(q.innerHTML=uo),we=s(e),p(L.$$.fragment,e),Te=s(e),O=l(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-4ln7hx"&&(O.innerHTML=_o),Me=s(e),p(z.$$.fragment,e),$e=s(e),p(I.$$.fragment,e),ke=s(e),a=l(e,"DIV",{class:!0});var b=y(a);p(B.$$.fragment,b),Re=s(b),Q=l(b,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-1cnm7fm"&&(Q.textContent=ho),He=s(b),$=l(b,"DIV",{class:!0});var Oe=y($);p(J.$$.fragment,Oe),Ze=s(Oe),ee=l(Oe,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-796i8l"&&(ee.innerHTML=go),Oe.forEach(t),Ee=s(b),k=l(b,"DIV",{class:!0});var ze=y(k);p(V.$$.fragment,ze),Ge=s(ze),oe=l(ze,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-zjwdt6"&&(oe.innerHTML=bo),ze.forEach(t),We=s(b),N=l(b,"DIV",{class:!0});var ue=y(N);p(R.$$.fragment,ue),Se=s(ue),te=l(ue,"P",{"data-svelte-h":!0}),c(te)!=="svelte-7fahc0"&&(te.textContent=xo),Xe=s(ue),ne=l(ue,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1yjwkav"&&(ne.textContent=yo),ue.forEach(t),Ye=s(b),A=l(b,"DIV",{class:!0});var Ie=y(A);p(H.$$.fragment,Ie),Ke=s(Ie),se=l(Ie,"P",{"data-svelte-h":!0}),c(se)!=="svelte-1o77hl2"&&(se.textContent=vo),Ie.forEach(t),Qe=s(b),D=l(b,"DIV",{class:!0});var Be=y(D);p(Z.$$.fragment,Be),eo=s(Be),re=l(Be,"P",{"data-svelte-h":!0}),c(re)!=="svelte-1lxcwhv"&&(re.textContent=Co),Be.forEach(t),b.forEach(t),Ae=s(e),p(E.$$.fragment,e),De=s(e),M=l(e,"DIV",{class:!0});var Je=y(M);p(G.$$.fragment,Je),oo=s(Je),ie=l(Je,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-1r4jaih"&&(ie.innerHTML=No),Je.forEach(t),Fe=s(e),p(W.$$.fragment,e),Ue=s(e),m=l(e,"DIV",{class:!0});var x=y(m);p(S.$$.fragment,x),to=s(x),le=l(x,"P",{"data-svelte-h":!0}),c(le)!=="svelte-1cnm7fm"&&(le.textContent=wo),no=s(x),de=l(x,"P",{"data-svelte-h":!0}),c(de)!=="svelte-sibkts"&&(de.innerHTML=To),so=s(x),ae=l(x,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-3yoxzz"&&(ae.innerHTML=Mo),ro=s(x),ce=l(x,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-ngiliw"&&(ce.textContent=$o),io=s(x),me=l(x,"UL",{"data-svelte-h":!0}),c(me)!=="svelte-1w7z84m"&&(me.innerHTML=ko),x.forEach(t),Pe=s(e),p(X.$$.fragment,e),je=s(e),C=l(e,"DIV",{class:!0});var _e=y(C);p(Y.$$.fragment,_e),lo=s(_e),fe=l(_e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-1cmtlt5"&&(fe.innerHTML=Ao),ao=s(_e),F=l(_e,"DIV",{class:!0});var Ve=y(F);p(K.$$.fragment,Ve),co=s(Ve),pe=l(Ve,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-5ihtpa"&&(pe.textContent=Do),Ve.forEach(t),_e.forEach(t),qe=s(e),be=l(e,"P",{}),y(be).forEach(t),this.h()},h(){v(T,"name","hf:doc:metadata"),v(T,"content",Io),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(a,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){o(document.head,T),d(e,xe,r),d(e,ge,r),d(e,ye,r),u(U,e,r),d(e,ve,r),d(e,P,r),d(e,Ce,r),d(e,j,r),d(e,Ne,r),d(e,q,r),d(e,we,r),u(L,e,r),d(e,Te,r),d(e,O,r),d(e,Me,r),u(z,e,r),d(e,$e,r),u(I,e,r),d(e,ke,r),d(e,a,r),u(B,a,null),o(a,Re),o(a,Q),o(a,He),o(a,$),u(J,$,null),o($,Ze),o($,ee),o(a,Ee),o(a,k),u(V,k,null),o(k,Ge),o(k,oe),o(a,We),o(a,N),u(R,N,null),o(N,Se),o(N,te),o(N,Xe),o(N,ne),o(a,Ye),o(a,A),u(H,A,null),o(A,Ke),o(A,se),o(a,Qe),o(a,D),u(Z,D,null),o(D,eo),o(D,re),d(e,Ae,r),u(E,e,r),d(e,De,r),d(e,M,r),u(G,M,null),o(M,oo),o(M,ie),d(e,Fe,r),u(W,e,r),d(e,Ue,r),d(e,m,r),u(S,m,null),o(m,to),o(m,le),o(m,no),o(m,de),o(m,so),o(m,ae),o(m,ro),o(m,ce),o(m,io),o(m,me),d(e,Pe,r),u(X,e,r),d(e,je,r),d(e,C,r),u(Y,C,null),o(C,lo),o(C,fe),o(C,ao),o(C,F),u(K,F,null),o(F,co),o(F,pe),d(e,qe,r),d(e,be,r),Le=!0},p:Uo,i(e){Le||(_(U.$$.fragment,e),_(L.$$.fragment,e),_(z.$$.fragment,e),_(I.$$.fragment,e),_(B.$$.fragment,e),_(J.$$.fragment,e),_(V.$$.fragment,e),_(R.$$.fragment,e),_(H.$$.fragment,e),_(Z.$$.fragment,e),_(E.$$.fragment,e),_(G.$$.fragment,e),_(W.$$.fragment,e),_(S.$$.fragment,e),_(X.$$.fragment,e),_(Y.$$.fragment,e),_(K.$$.fragment,e),Le=!0)},o(e){h(U.$$.fragment,e),h(L.$$.fragment,e),h(z.$$.fragment,e),h(I.$$.fragment,e),h(B.$$.fragment,e),h(J.$$.fragment,e),h(V.$$.fragment,e),h(R.$$.fragment,e),h(H.$$.fragment,e),h(Z.$$.fragment,e),h(E.$$.fragment,e),h(G.$$.fragment,e),h(W.$$.fragment,e),h(S.$$.fragment,e),h(X.$$.fragment,e),h(Y.$$.fragment,e),h(K.$$.fragment,e),Le=!1},d(e){e&&(t(xe),t(ge),t(ye),t(ve),t(P),t(Ce),t(j),t(Ne),t(q),t(we),t(Te),t(O),t(Me),t($e),t(ke),t(a),t(Ae),t(De),t(M),t(Fe),t(Ue),t(m),t(Pe),t(je),t(C),t(qe),t(be)),t(T),g(U,e),g(L,e),g(z,e),g(I,e),g(B),g(J),g(V),g(R),g(H),g(Z),g(E,e),g(G),g(W,e),g(S),g(X,e),g(Y),g(K)}}}const Io='{"title":"ControlNet","local":"controlnet","sections":[{"title":"Loading from the original format","local":"loading-from-the-original-format","sections":[],"depth":2},{"title":"ControlNetModel","local":"diffusers.ControlNetModel","sections":[],"depth":2},{"title":"ControlNetOutput","local":"diffusers.models.controlnet.ControlNetOutput","sections":[],"depth":2},{"title":"FlaxControlNetModel","local":"diffusers.FlaxControlNetModel","sections":[],"depth":2},{"title":"FlaxControlNetOutput","local":"diffusers.models.controlnet_flax.FlaxControlNetOutput","sections":[],"depth":2}],"depth":1}';function Bo(mo){return Po(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Eo extends jo{constructor(T){super(),qo(this,T,Bo,zo,Fo,{})}}export{Eo as component};
