import{s as Oe,o as et,n as tt}from"../chunks/scheduler.8c3d61f6.js";import{S as lt,i as st,g as a,s as n,r as c,A as nt,h as o,f as l,c as i,j as le,u,x as d,k as Ke,y as p,a as s,v as f,d as m,t as M,w as h}from"../chunks/index.da70eac4.js";import{T as it}from"../chunks/Tip.1d9b8c37.js";import{C as se}from"../chunks/CodeBlock.a9c4becf.js";import{H as ge,E as at}from"../chunks/getInferenceSnippets.725ed3d4.js";function ot(ie){let r,J='Refer to the <a href="./modular_diffusers_states">States</a> guide if you aren’t familiar with how state works in Modular Diffusers.';return{c(){r=a("p"),r.innerHTML=J},l(y){r=o(y,"P",{"data-svelte-h":!0}),d(r)!=="svelte-17l5ale"&&(r.innerHTML=J)},m(y,N){s(y,r,N)},p:tt,d(y){y&&l(r)}}}function pt(ie){let r,J,y,N,$,ae,k,Se='<a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> is the basic block for building a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a>. It defines what components, inputs/outputs, and computation a block should perform for a specific step in a pipeline. A <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> connects with other blocks, using <a href="./modular_diffusers_states">state</a>, to enable the modular construction of workflows.',oe,g,Re='A <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> on it’s own can’t be executed. It is a blueprint for what a step should do in a pipeline. To actually run and execute a pipeline, the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> needs to be converted into a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a>.',pe,v,Pe='This guide will show you how to create a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a>.',re,B,de,U,ce,C,Xe='A <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> requires <code>inputs</code>, and <code>intermediate_outputs</code>.',ue,b,_,Q,Ye='<code>inputs</code> are values provided by a user and retrieved from the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a>. This is useful because some workflows resize an image, but the original image is still required. The <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a> maintains the original image.',ve,A,We="Use <code>InputParam</code> to define <code>inputs</code>.",Be,I,Ce,w,q,Ee="<code>intermediate_inputs</code> are values typically created from a previous block but it can also be directly provided if no preceding block generates them. Unlike <code>inputs</code>, <code>intermediate_inputs</code> can be modified.",Ie,F,xe="Use <code>InputParam</code> to define <code>intermediate_inputs</code>.",Ge,G,Ve,T,D,Le='<code>intermediate_outputs</code> are new values created by a block and added to the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a>. The <code>intermediate_outputs</code> are available as <code>intermediate_inputs</code> for subsequent blocks or available as the final output from running the pipeline.',Ze,K,ze="Use <code>OutputParam</code> to define <code>intermediate_outputs</code>.",He,V,fe,Z,Ne="The intermediate inputs and outputs share data to connect blocks. They are accessible at any point, allowing you to track the workflow’s progress.",me,H,Me,S,Qe="The computation a block performs is defined in the <code>__call__</code> method and it follows a specific structure.",he,R,Ae='<li>Retrieve the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.BlockState">BlockState</a> to get a local view of the <code>inputs</code> and <code>intermediate_inputs</code>.</li> <li>Implement the computation logic on the <code>inputs</code> and <code>intermediate_inputs</code>.</li> <li>Update <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a> to push changes from the local <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.BlockState">BlockState</a> back to the global <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a>.</li> <li>Return the components and state which becomes available to the next block.</li>',ye,P,be,X,_e,Y,qe='The components and pipeline-level configs a block needs are specified in <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_components#diffusers.ComponentSpec">ComponentSpec</a> and <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_components#diffusers.modular_pipelines.ConfigSpec">ConfigSpec</a>.',we,W,Fe='<li><a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_components#diffusers.ComponentSpec">ComponentSpec</a> contains the expected components used by a block. You need the <code>name</code> of the component and ideally a <code>type_hint</code> that specifies exactly what the component is.</li> <li><a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_components#diffusers.modular_pipelines.ConfigSpec">ConfigSpec</a> contains pipeline-level settings that control behavior across all blocks.</li>',Te,E,je,x,De="When the blocks are converted into a pipeline, the components become available to the block as the first argument in <code>__call__</code>.",Ue,L,Je,z,$e,ne,ke;return $=new ge({props:{title:"ModularPipelineBlocks",local:"modularpipelineblocks",headingTag:"h1"}}),B=new ge({props:{title:"Inputs and outputs",local:"inputs-and-outputs",headingTag:"h2"}}),U=new it({props:{warning:!1,$$slots:{default:[ot]},$$scope:{ctx:ie}}}),I=new se({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcyUyMGltcG9ydCUyMElucHV0UGFyYW0lMEElMEF1c2VyX2lucHV0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMElucHV0UGFyYW0obmFtZSUzRCUyMmltYWdlJTIyJTJDJTIwdHlwZV9oaW50JTNEJTIyUElMLkltYWdlJTIyJTJDJTIwZGVzY3JpcHRpb24lM0QlMjJyYXclMjBpbnB1dCUyMGltYWdlJTIwdG8lMjBwcm9jZXNzJTIyKSUwQSU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> InputParam

user_inputs = [
    InputParam(name=<span class="hljs-string">&quot;image&quot;</span>, type_hint=<span class="hljs-string">&quot;PIL.Image&quot;</span>, description=<span class="hljs-string">&quot;raw input image to process&quot;</span>)
]`,wrap:!1}}),G=new se({props:{code:"dXNlcl9pbnRlcm1lZGlhdGVfaW5wdXRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwSW5wdXRQYXJhbShuYW1lJTNEJTIycHJvY2Vzc2VkX2ltYWdlJTIyJTJDJTIwdHlwZV9oaW50JTNEJTIydG9yY2guVGVuc29yJTIyJTJDJTIwZGVzY3JpcHRpb24lM0QlMjJpbWFnZSUyMHRoYXQlMjBoYXMlMjBiZWVuJTIwcHJlcHJvY2Vzc2VkJTIwYW5kJTIwbm9ybWFsaXplZCUyMiklMkMlMEElNUQ=",highlighted:`user_intermediate_inputs = [
    InputParam(name=<span class="hljs-string">&quot;processed_image&quot;</span>, type_hint=<span class="hljs-string">&quot;torch.Tensor&quot;</span>, description=<span class="hljs-string">&quot;image that has been preprocessed and normalized&quot;</span>),
]`,wrap:!1}}),V=new se({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcyUyMGltcG9ydCUyME91dHB1dFBhcmFtJTBBJTBBJTIwJTIwJTIwJTIwdXNlcl9pbnRlcm1lZGlhdGVfb3V0cHV0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyME91dHB1dFBhcmFtKG5hbWUlM0QlMjJpbWFnZV9sYXRlbnRzJTIyJTJDJTIwZGVzY3JpcHRpb24lM0QlMjJsYXRlbnRzJTIwcmVwcmVzZW50aW5nJTIwdGhlJTIwaW1hZ2UlMjIpJTBBJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> OutputParam

    user_intermediate_outputs = [
    OutputParam(name=<span class="hljs-string">&quot;image_latents&quot;</span>, description=<span class="hljs-string">&quot;latents representing the image&quot;</span>)
]`,wrap:!1}}),H=new ge({props:{title:"Computation logic",local:"computation-logic",headingTag:"h2"}}),P=new se({props:{code:"ZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMGNvbXBvbmVudHMlMkMlMjBzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBHZXQlMjBhJTIwbG9jYWwlMjB2aWV3JTIwb2YlMjB0aGUlMjBzdGF0ZSUyMHZhcmlhYmxlcyUyMHRoaXMlMjBibG9jayUyMG5lZWRzJTBBJTIwJTIwJTIwJTIwYmxvY2tfc3RhdGUlMjAlM0QlMjBzZWxmLmdldF9ibG9ja19zdGF0ZShzdGF0ZSklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBZb3VyJTIwY29tcHV0YXRpb24lMjBsb2dpYyUyMGhlcmUlMEElMjAlMjAlMjAlMjAlMjMlMjBibG9ja19zdGF0ZSUyMGNvbnRhaW5zJTIwYWxsJTIweW91ciUyMGlucHV0cyUyMGFuZCUyMGludGVybWVkaWF0ZV9pbnB1dHMlMEElMjAlMjAlMjAlMjAlMjMlMjBBY2Nlc3MlMjB0aGVtJTIwbGlrZSUzQSUyMGJsb2NrX3N0YXRlLmltYWdlJTJDJTIwYmxvY2tfc3RhdGUucHJvY2Vzc2VkX2ltYWdlJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXBkYXRlJTIwdGhlJTIwcGlwZWxpbmUlMjBzdGF0ZSUyMHdpdGglMjB5b3VyJTIwdXBkYXRlZCUyMGJsb2NrX3N0YXRlcyUwQSUyMCUyMCUyMCUyMHNlbGYuc2V0X2Jsb2NrX3N0YXRlKHN0YXRlJTJDJTIwYmxvY2tfc3RhdGUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwY29tcG9uZW50cyUyQyUyMHN0YXRl",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, state</span>):
    <span class="hljs-comment"># Get a local view of the state variables this block needs</span>
    block_state = self.get_block_state(state)

    <span class="hljs-comment"># Your computation logic here</span>
    <span class="hljs-comment"># block_state contains all your inputs and intermediate_inputs</span>
    <span class="hljs-comment"># Access them like: block_state.image, block_state.processed_image</span>

    <span class="hljs-comment"># Update the pipeline state with your updated block_states</span>
    self.set_block_state(state, block_state)
    <span class="hljs-keyword">return</span> components, state`,wrap:!1}}),X=new ge({props:{title:"Components and configs",local:"components-and-configs",headingTag:"h3"}}),E=new se({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbXBvbmVudFNwZWMlMkMlMjBDb25maWdTcGVjJTBBJTBBZXhwZWN0ZWRfY29tcG9uZW50cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMENvbXBvbmVudFNwZWMobmFtZSUzRCUyMnVuZXQlMjIlMkMlMjB0eXBlX2hpbnQlM0RVTmV0MkRDb25kaXRpb25Nb2RlbCklMkMlMEElMjAlMjAlMjAlMjBDb21wb25lbnRTcGVjKG5hbWUlM0QlMjJzY2hlZHVsZXIlMjIlMkMlMjB0eXBlX2hpbnQlM0RFdWxlckRpc2NyZXRlU2NoZWR1bGVyKSUwQSU1RCUwQSUwQWV4cGVjdGVkX2NvbmZpZyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMENvbmZpZ1NwZWMoJTIyZm9yY2VfemVyb3NfZm9yX2VtcHR5X3Byb21wdCUyMiUyQyUyMFRydWUpJTBBJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ComponentSpec, ConfigSpec

expected_components = [
    ComponentSpec(name=<span class="hljs-string">&quot;unet&quot;</span>, type_hint=UNet2DConditionModel),
    ComponentSpec(name=<span class="hljs-string">&quot;scheduler&quot;</span>, type_hint=EulerDiscreteScheduler)
]

expected_config = [
    ConfigSpec(<span class="hljs-string">&quot;force_zeros_for_empty_prompt&quot;</span>, <span class="hljs-literal">True</span>)
]`,wrap:!1}}),L=new se({props:{code:"ZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMGNvbXBvbmVudHMlMkMlMjBzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBY2Nlc3MlMjBjb21wb25lbnRzJTIwdXNpbmclMjBkb3QlMjBub3RhdGlvbiUwQSUyMCUyMCUyMCUyMHVuZXQlMjAlM0QlMjBjb21wb25lbnRzLnVuZXQlMEElMjAlMjAlMjAlMjB2YWUlMjAlM0QlMjBjb21wb25lbnRzLnZhZSUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUyMCUzRCUyMGNvbXBvbmVudHMuc2NoZWR1bGVy",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, state</span>):
    <span class="hljs-comment"># Access components using dot notation</span>
    unet = components.unet
    vae = components.vae
    scheduler = components.scheduler`,wrap:!1}}),z=new at({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/modular_diffusers/pipeline_block.md"}}),{c(){r=a("meta"),J=n(),y=a("p"),N=n(),c($.$$.fragment),ae=n(),k=a("p"),k.innerHTML=Se,oe=n(),g=a("p"),g.innerHTML=Re,pe=n(),v=a("p"),v.innerHTML=Pe,re=n(),c(B.$$.fragment),de=n(),c(U.$$.fragment),ce=n(),C=a("p"),C.innerHTML=Xe,ue=n(),b=a("ul"),_=a("li"),Q=a("p"),Q.innerHTML=Ye,ve=n(),A=a("p"),A.innerHTML=We,Be=n(),c(I.$$.fragment),Ce=n(),w=a("li"),q=a("p"),q.innerHTML=Ee,Ie=n(),F=a("p"),F.innerHTML=xe,Ge=n(),c(G.$$.fragment),Ve=n(),T=a("li"),D=a("p"),D.innerHTML=Le,Ze=n(),K=a("p"),K.innerHTML=ze,He=n(),c(V.$$.fragment),fe=n(),Z=a("p"),Z.textContent=Ne,me=n(),c(H.$$.fragment),Me=n(),S=a("p"),S.innerHTML=Qe,he=n(),R=a("ol"),R.innerHTML=Ae,ye=n(),c(P.$$.fragment),be=n(),c(X.$$.fragment),_e=n(),Y=a("p"),Y.innerHTML=qe,we=n(),W=a("ul"),W.innerHTML=Fe,Te=n(),c(E.$$.fragment),je=n(),x=a("p"),x.innerHTML=De,Ue=n(),c(L.$$.fragment),Je=n(),c(z.$$.fragment),$e=n(),ne=a("p"),this.h()},l(e){const t=nt("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(l),J=i(e),y=o(e,"P",{}),le(y).forEach(l),N=i(e),u($.$$.fragment,e),ae=i(e),k=o(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-cj8g0i"&&(k.innerHTML=Se),oe=i(e),g=o(e,"P",{"data-svelte-h":!0}),d(g)!=="svelte-19agiu"&&(g.innerHTML=Re),pe=i(e),v=o(e,"P",{"data-svelte-h":!0}),d(v)!=="svelte-8fu0w1"&&(v.innerHTML=Pe),re=i(e),u(B.$$.fragment,e),de=i(e),u(U.$$.fragment,e),ce=i(e),C=o(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-nui63e"&&(C.innerHTML=Xe),ue=i(e),b=o(e,"UL",{});var j=le(b);_=o(j,"LI",{});var O=le(_);Q=o(O,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-wdjc3v"&&(Q.innerHTML=Ye),ve=i(O),A=o(O,"P",{"data-svelte-h":!0}),d(A)!=="svelte-yx83i9"&&(A.innerHTML=We),Be=i(O),u(I.$$.fragment,O),O.forEach(l),Ce=i(j),w=o(j,"LI",{});var ee=le(w);q=o(ee,"P",{"data-svelte-h":!0}),d(q)!=="svelte-sf9h63"&&(q.innerHTML=Ee),Ie=i(ee),F=o(ee,"P",{"data-svelte-h":!0}),d(F)!=="svelte-hw2ewp"&&(F.innerHTML=xe),Ge=i(ee),u(G.$$.fragment,ee),ee.forEach(l),Ve=i(j),T=o(j,"LI",{});var te=le(T);D=o(te,"P",{"data-svelte-h":!0}),d(D)!=="svelte-smzm5j"&&(D.innerHTML=Le),Ze=i(te),K=o(te,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1wredql"&&(K.innerHTML=ze),He=i(te),u(V.$$.fragment,te),te.forEach(l),j.forEach(l),fe=i(e),Z=o(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-85xvms"&&(Z.textContent=Ne),me=i(e),u(H.$$.fragment,e),Me=i(e),S=o(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-ymvhyd"&&(S.innerHTML=Qe),he=i(e),R=o(e,"OL",{"data-svelte-h":!0}),d(R)!=="svelte-15hxcx2"&&(R.innerHTML=Ae),ye=i(e),u(P.$$.fragment,e),be=i(e),u(X.$$.fragment,e),_e=i(e),Y=o(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1vve7vj"&&(Y.innerHTML=qe),we=i(e),W=o(e,"UL",{"data-svelte-h":!0}),d(W)!=="svelte-1aq4suh"&&(W.innerHTML=Fe),Te=i(e),u(E.$$.fragment,e),je=i(e),x=o(e,"P",{"data-svelte-h":!0}),d(x)!=="svelte-1cled56"&&(x.innerHTML=De),Ue=i(e),u(L.$$.fragment,e),Je=i(e),u(z.$$.fragment,e),$e=i(e),ne=o(e,"P",{}),le(ne).forEach(l),this.h()},h(){Ke(r,"name","hf:doc:metadata"),Ke(r,"content",rt)},m(e,t){p(document.head,r),s(e,J,t),s(e,y,t),s(e,N,t),f($,e,t),s(e,ae,t),s(e,k,t),s(e,oe,t),s(e,g,t),s(e,pe,t),s(e,v,t),s(e,re,t),f(B,e,t),s(e,de,t),f(U,e,t),s(e,ce,t),s(e,C,t),s(e,ue,t),s(e,b,t),p(b,_),p(_,Q),p(_,ve),p(_,A),p(_,Be),f(I,_,null),p(b,Ce),p(b,w),p(w,q),p(w,Ie),p(w,F),p(w,Ge),f(G,w,null),p(b,Ve),p(b,T),p(T,D),p(T,Ze),p(T,K),p(T,He),f(V,T,null),s(e,fe,t),s(e,Z,t),s(e,me,t),f(H,e,t),s(e,Me,t),s(e,S,t),s(e,he,t),s(e,R,t),s(e,ye,t),f(P,e,t),s(e,be,t),f(X,e,t),s(e,_e,t),s(e,Y,t),s(e,we,t),s(e,W,t),s(e,Te,t),f(E,e,t),s(e,je,t),s(e,x,t),s(e,Ue,t),f(L,e,t),s(e,Je,t),f(z,e,t),s(e,$e,t),s(e,ne,t),ke=!0},p(e,[t]){const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),U.$set(j)},i(e){ke||(m($.$$.fragment,e),m(B.$$.fragment,e),m(U.$$.fragment,e),m(I.$$.fragment,e),m(G.$$.fragment,e),m(V.$$.fragment,e),m(H.$$.fragment,e),m(P.$$.fragment,e),m(X.$$.fragment,e),m(E.$$.fragment,e),m(L.$$.fragment,e),m(z.$$.fragment,e),ke=!0)},o(e){M($.$$.fragment,e),M(B.$$.fragment,e),M(U.$$.fragment,e),M(I.$$.fragment,e),M(G.$$.fragment,e),M(V.$$.fragment,e),M(H.$$.fragment,e),M(P.$$.fragment,e),M(X.$$.fragment,e),M(E.$$.fragment,e),M(L.$$.fragment,e),M(z.$$.fragment,e),ke=!1},d(e){e&&(l(J),l(y),l(N),l(ae),l(k),l(oe),l(g),l(pe),l(v),l(re),l(de),l(ce),l(C),l(ue),l(b),l(fe),l(Z),l(me),l(Me),l(S),l(he),l(R),l(ye),l(be),l(_e),l(Y),l(we),l(W),l(Te),l(je),l(x),l(Ue),l(Je),l($e),l(ne)),l(r),h($,e),h(B,e),h(U,e),h(I),h(G),h(V),h(H,e),h(P,e),h(X,e),h(E,e),h(L,e),h(z,e)}}}const rt='{"title":"ModularPipelineBlocks","local":"modularpipelineblocks","sections":[{"title":"Inputs and outputs","local":"inputs-and-outputs","sections":[],"depth":2},{"title":"Computation logic","local":"computation-logic","sections":[{"title":"Components and configs","local":"components-and-configs","sections":[],"depth":3}],"depth":2}],"depth":1}';function dt(ie){return et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ht extends lt{constructor(r){super(),st(this,r,dt,pt,Oe,{})}}export{ht as component};
