import{s as Dt,o as yt,n as xt}from"../chunks/scheduler.182ea377.js";import{S as $t,i as Tt,g as r,s as a,r as h,A as St,h as l,f as t,c as i,j as k,u as _,x as f,k as C,y as o,a as s,v as b,d as v,t as w,w as P}from"../chunks/index.abf12888.js";import{T as Mt}from"../chunks/Tip.230e2334.js";import{D as te}from"../chunks/Docstring.93f6f462.js";import{C as kt}from"../chunks/CodeBlock.57fe6e13.js";import{E as Ct}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as je}from"../chunks/Heading.16916d63.js";function Lt(ne){let d,$='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){d=r("p"),d.innerHTML=$},l(u){d=l(u,"P",{"data-svelte-h":!0}),f(d)!=="svelte-1wmc0l4"&&(d.innerHTML=$)},m(u,g){s(u,d,g)},p:xt,d(u){u&&t(d)}}}function It(ne){let d,$="Examples:",u,g,x;return g=new kt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGFub3JhbWFQaXBlbGluZSUyQyUyMERESU1TY2hlZHVsZXIlMEElMEFtb2RlbF9ja3B0JTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItYmFzZSUyMiUwQXNjaGVkdWxlciUyMCUzRCUyMERESU1TY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NrcHQlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBhbm9yYW1hUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2NrcHQlMkMlMjBzY2hlZHVsZXIlM0RzY2hlZHVsZXIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMHRoZSUyMGRvbG9taXRlcyUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPanoramaPipeline, DDIMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>model_ckpt = <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = DDIMScheduler.from_pretrained(model_ckpt, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPanoramaPipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_ckpt, scheduler=scheduler, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of the dolomites&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){d=r("p"),d.textContent=$,u=a(),h(g.$$.fragment)},l(m){d=l(m,"P",{"data-svelte-h":!0}),f(d)!=="svelte-kvfsh7"&&(d.textContent=$),u=i(m),_(g.$$.fragment,m)},m(m,y){s(m,d,y),s(m,u,y),b(g,m,y),x=!0},p:xt,i(m){x||(v(g.$$.fragment,m),x=!0)},o(m){w(g.$$.fragment,m),x=!1},d(m){m&&(t(d),t(u)),P(g,m)}}}function Ut(ne){let d,$,u,g,x,m,y,tt='<a href="https://huggingface.co/papers/2302.08113" rel="nofollow">MultiDiffusion: Fusing Diffusion Paths for Controlled Image Generation</a> is by Omer Bar-Tal, Lior Yariv, Yaron Lipman, and Tali Dekel.',he,A,nt="The abstract from the paper is:",_e,N,at="<em>Recent advances in text-to-image generation with diffusion models present transformative capabilities in image quality. However, user controllability of the generated image, and fast adaptation to new tasks still remains an open challenge, currently mostly addressed by costly and long re-training and fine-tuning or ad-hoc adaptations to specific image generation tasks. In this work, we present MultiDiffusion, a unified framework that enables versatile and controllable image generation, using a pre-trained text-to-image diffusion model, without any further training or finetuning. At the center of our approach is a new generation process, based on an optimization task that binds together multiple diffusion generation processes with a shared set of parameters or constraints. We show that MultiDiffusion can be readily applied to generate high quality and diverse images that adhere to user-provided controls, such as desired aspect ratio (e.g., panorama), and spatial guiding signals, ranging from tight segmentation masks to bounding boxes.</em>",be,E,it='You can find additional information about MultiDiffusion on the <a href="https://multidiffusion.github.io/" rel="nofollow">project page</a>, <a href="https://github.com/omerbt/MultiDiffusion" rel="nofollow">original codebase</a>, and try it out in a <a href="https://huggingface.co/spaces/weizmannscience/MultiDiffusion" rel="nofollow">demo</a>.',ve,G,we,O,ot=`While calling <a href="/docs/diffusers/main/en/api/pipelines/panorama#diffusers.StableDiffusionPanoramaPipeline">StableDiffusionPanoramaPipeline</a>, it’s possible to specify the <code>view_batch_size</code> parameter to be &gt; 1.
For some GPUs with high performance, this can speedup the generation process and increase VRAM usage.`,Pe,Z,st="To generate panorama-like images make sure you pass the width parameter accordingly. We recommend a width value of 2048 which is the default.",xe,F,rt="Circular padding is applied to ensure there are no stitching artifacts when working with panoramas to ensure a seamless transition from the rightmost part to the leftmost part. By enabling circular padding (set <code>circular_padding=True</code>), the operation applies additional crops after the rightmost point of the image, allowing the model to “see” the transition from the rightmost part to the leftmost part. This helps maintain visual consistency in a 360-degree sense and creates a proper “panorama” that can be viewed using 360-degree panorama viewers. When decoding latents in Stable Diffusion, circular padding is applied to ensure that the decoded latents match in the RGB space.",De,V,lt=`For example, without circular padding, there is a stitching artifact (default):
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/indoor_%20no_circular_padding.png" alt="img"/>`,ye,J,dt=`But with circular padding, the right and the left parts are matching (<code>circular_padding=True</code>):
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/indoor_%20circular_padding.png" alt="img"/>`,$e,L,Te,R,Se,p,q,Ae,ae,pt="Pipeline for text-to-image generation using MultiDiffusion.",Ne,ie,ct=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ee,oe,ft="The pipeline also inherits the following loading methods:",Ge,se,mt='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Oe,T,B,Ze,re,ut="The call function to the pipeline for generation.",Fe,I,Ve,D,Y,Je,le,gt="Decode the given latents with padding for circular inference.",Re,de,ht="Notes:",qe,pe,_t="<li>The padding is added to remove boundary artifacts and improve the output quality.</li> <li>This would slightly increase the memory usage.</li> <li>The padding pixels are then removed from the decoded image.</li>",Be,U,W,Ye,ce,bt="Encodes the prompt into text encoder hidden states.",We,z,Q,Qe,fe,vt='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Xe,H,X,Ke,me,wt=`Generates a list of views based on the given parameters. Here, we define the mappings F_i (see Eq. 7 in the
MultiDiffusion paper <a href="https://arxiv.org/abs/2302.08113" rel="nofollow">https://arxiv.org/abs/2302.08113</a>). If panorama’s height/width &lt; window_size, num_blocks of
height/width should return 1.`,Me,K,ke,S,ee,et,ue,Pt="Output class for Stable Diffusion pipelines.",Ce,ge,Le;return x=new je({props:{title:"MultiDiffusion",local:"multidiffusion",headingTag:"h1"}}),G=new je({props:{title:"Tips",local:"tips",headingTag:"h2"}}),L=new Mt({props:{$$slots:{default:[Lt]},$$scope:{ctx:ne}}}),R=new je({props:{title:"StableDiffusionPanoramaPipeline",local:"diffusers.StableDiffusionPanoramaPipeline",headingTag:"h2"}}),q=new te({props:{name:"class diffusers.StableDiffusionPanoramaPipeline",anchor:"diffusers.StableDiffusionPanoramaPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDIMScheduler"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": Optional = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPanoramaPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_panorama/pipeline_stable_diffusion_panorama.py#L122"}}),B=new te({props:{name:"__call__",anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = 512"},{name:"width",val:": Optional = 2048"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"view_batch_size",val:": int = 1"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"circular_padding",val:": bool = False"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:": Any"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The width in pixels of the generated image. The width is kept high because the pipeline is supposed
generate panorama-like images.`,name:"width"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
The timesteps at which to generate the images. If not specified, then the default timestep spacing
strategy of the scheduler is used.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.view_batch_size",description:`<strong>view_batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The batch size to denoise split views. For some GPUs with high performance, higher view batch size can
speedup the generation and increase the VRAM usage.`,name:"view_batch_size"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
A rescaling factor for the guidance embeddings. A value of 0.0 means no rescaling is applied.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.circular_padding",description:`<strong>circular_padding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, circular padding is applied to ensure there are no stitching artifacts. Circular
padding allows the model to seamlessly generate a transition from the rightmost part of the image to
the leftmost part, maintaining consistency in a 360-degree sense.`,name:"circular_padding"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_panorama/pipeline_stable_diffusion_panorama.py#L758",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),I=new Ct({props:{anchor:"diffusers.StableDiffusionPanoramaPipeline.__call__.example",$$slots:{default:[It]},$$scope:{ctx:ne}}}),Y=new te({props:{name:"decode_latents_with_padding",anchor:"diffusers.StableDiffusionPanoramaPipeline.decode_latents_with_padding",parameters:[{name:"latents",val:": Tensor"},{name:"padding",val:": int = 8"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPanoramaPipeline.decode_latents_with_padding.latents",description:"<strong>latents</strong> (torch.Tensor) &#x2014; The input latents to decode.",name:"latents"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.decode_latents_with_padding.padding",description:"<strong>padding</strong> (int, optional) &#x2014; The number of latents to add on each side for padding. Defaults to 8.",name:"padding"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_panorama/pipeline_stable_diffusion_panorama.py#L525",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The decoded image with padding removed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>torch.Tensor</p>
`}}),W=new te({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionPanoramaPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPanoramaPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_panorama/pipeline_stable_diffusion_panorama.py#L240"}}),Q=new te({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionPanoramaPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:": Tensor"},{name:"embedding_dim",val:": int = 512"},{name:"dtype",val:": dtype = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPanoramaPipeline.get_guidance_scale_embedding.w",description:`<strong>w</strong> (<code>torch.Tensor</code>) &#x2014;
Generate embedding vectors with a specified guidance scale to subsequently enrich timestep embeddings.`,name:"w"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the embeddings to generate.`,name:"embedding_dim"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.get_guidance_scale_embedding.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
Data type of the generated embeddings.`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_panorama/pipeline_stable_diffusion_panorama.py#L658",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(w), embedding_dim)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),X=new te({props:{name:"get_views",anchor:"diffusers.StableDiffusionPanoramaPipeline.get_views",parameters:[{name:"panorama_height",val:": int"},{name:"panorama_width",val:": int"},{name:"window_size",val:": int = 64"},{name:"stride",val:": int = 8"},{name:"circular_padding",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPanoramaPipeline.get_views.panorama_height",description:"<strong>panorama_height</strong> (int) &#x2014; The height of the panorama.",name:"panorama_height"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.get_views.panorama_width",description:"<strong>panorama_width</strong> (int) &#x2014; The width of the panorama.",name:"panorama_width"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.get_views.window_size",description:"<strong>window_size</strong> (int, optional) &#x2014; The size of the window. Defaults to 64.",name:"window_size"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.get_views.stride",description:"<strong>stride</strong> (int, optional) &#x2014; The stride value. Defaults to 8.",name:"stride"},{anchor:"diffusers.StableDiffusionPanoramaPipeline.get_views.circular_padding",description:"<strong>circular_padding</strong> (bool, optional) &#x2014; Whether to apply circular padding. Defaults to False.",name:"circular_padding"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_panorama/pipeline_stable_diffusion_panorama.py#L688",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of tuples representing the views. Each tuple contains four integers
representing the start and end coordinates of the window in the panorama.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List[Tuple[int, int, int, int]]</p>
`}}),K=new je({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),ee=new te({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),{c(){d=r("meta"),$=a(),u=r("p"),g=a(),h(x.$$.fragment),m=a(),y=r("p"),y.innerHTML=tt,he=a(),A=r("p"),A.textContent=nt,_e=a(),N=r("p"),N.innerHTML=at,be=a(),E=r("p"),E.innerHTML=it,ve=a(),h(G.$$.fragment),we=a(),O=r("p"),O.innerHTML=ot,Pe=a(),Z=r("p"),Z.textContent=st,xe=a(),F=r("p"),F.innerHTML=rt,De=a(),V=r("p"),V.innerHTML=lt,ye=a(),J=r("p"),J.innerHTML=dt,$e=a(),h(L.$$.fragment),Te=a(),h(R.$$.fragment),Se=a(),p=r("div"),h(q.$$.fragment),Ae=a(),ae=r("p"),ae.textContent=pt,Ne=a(),ie=r("p"),ie.innerHTML=ct,Ee=a(),oe=r("p"),oe.textContent=ft,Ge=a(),se=r("ul"),se.innerHTML=mt,Oe=a(),T=r("div"),h(B.$$.fragment),Ze=a(),re=r("p"),re.textContent=ut,Fe=a(),h(I.$$.fragment),Ve=a(),D=r("div"),h(Y.$$.fragment),Je=a(),le=r("p"),le.textContent=gt,Re=a(),de=r("p"),de.textContent=ht,qe=a(),pe=r("ul"),pe.innerHTML=_t,Be=a(),U=r("div"),h(W.$$.fragment),Ye=a(),ce=r("p"),ce.textContent=bt,We=a(),z=r("div"),h(Q.$$.fragment),Qe=a(),fe=r("p"),fe.innerHTML=vt,Xe=a(),H=r("div"),h(X.$$.fragment),Ke=a(),me=r("p"),me.innerHTML=wt,Me=a(),h(K.$$.fragment),ke=a(),S=r("div"),h(ee.$$.fragment),et=a(),ue=r("p"),ue.textContent=Pt,Ce=a(),ge=r("p"),this.h()},l(e){const n=St("svelte-u9bgzb",document.head);d=l(n,"META",{name:!0,content:!0}),n.forEach(t),$=i(e),u=l(e,"P",{}),k(u).forEach(t),g=i(e),_(x.$$.fragment,e),m=i(e),y=l(e,"P",{"data-svelte-h":!0}),f(y)!=="svelte-iubh1u"&&(y.innerHTML=tt),he=i(e),A=l(e,"P",{"data-svelte-h":!0}),f(A)!=="svelte-1cwsb16"&&(A.textContent=nt),_e=i(e),N=l(e,"P",{"data-svelte-h":!0}),f(N)!=="svelte-muikgy"&&(N.innerHTML=at),be=i(e),E=l(e,"P",{"data-svelte-h":!0}),f(E)!=="svelte-nmxwil"&&(E.innerHTML=it),ve=i(e),_(G.$$.fragment,e),we=i(e),O=l(e,"P",{"data-svelte-h":!0}),f(O)!=="svelte-a1zb81"&&(O.innerHTML=ot),Pe=i(e),Z=l(e,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-10nxbu3"&&(Z.textContent=st),xe=i(e),F=l(e,"P",{"data-svelte-h":!0}),f(F)!=="svelte-1mn2x9s"&&(F.innerHTML=rt),De=i(e),V=l(e,"P",{"data-svelte-h":!0}),f(V)!=="svelte-1etj7av"&&(V.innerHTML=lt),ye=i(e),J=l(e,"P",{"data-svelte-h":!0}),f(J)!=="svelte-qdh84m"&&(J.innerHTML=dt),$e=i(e),_(L.$$.fragment,e),Te=i(e),_(R.$$.fragment,e),Se=i(e),p=l(e,"DIV",{class:!0});var c=k(p);_(q.$$.fragment,c),Ae=i(c),ae=l(c,"P",{"data-svelte-h":!0}),f(ae)!=="svelte-1katl0i"&&(ae.textContent=pt),Ne=i(c),ie=l(c,"P",{"data-svelte-h":!0}),f(ie)!=="svelte-496sm0"&&(ie.innerHTML=ct),Ee=i(c),oe=l(c,"P",{"data-svelte-h":!0}),f(oe)!=="svelte-14s6m4u"&&(oe.textContent=ft),Ge=i(c),se=l(c,"UL",{"data-svelte-h":!0}),f(se)!=="svelte-jjuyoc"&&(se.innerHTML=mt),Oe=i(c),T=l(c,"DIV",{class:!0});var M=k(T);_(B.$$.fragment,M),Ze=i(M),re=l(M,"P",{"data-svelte-h":!0}),f(re)!=="svelte-50j04k"&&(re.textContent=ut),Fe=i(M),_(I.$$.fragment,M),M.forEach(t),Ve=i(c),D=l(c,"DIV",{class:!0});var j=k(D);_(Y.$$.fragment,j),Je=i(j),le=l(j,"P",{"data-svelte-h":!0}),f(le)!=="svelte-11enoo7"&&(le.textContent=gt),Re=i(j),de=l(j,"P",{"data-svelte-h":!0}),f(de)!=="svelte-1biq3pv"&&(de.textContent=ht),qe=i(j),pe=l(j,"UL",{"data-svelte-h":!0}),f(pe)!=="svelte-mb20u9"&&(pe.innerHTML=_t),j.forEach(t),Be=i(c),U=l(c,"DIV",{class:!0});var Ie=k(U);_(W.$$.fragment,Ie),Ye=i(Ie),ce=l(Ie,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-16q0ax1"&&(ce.textContent=bt),Ie.forEach(t),We=i(c),z=l(c,"DIV",{class:!0});var Ue=k(z);_(Q.$$.fragment,Ue),Qe=i(Ue),fe=l(Ue,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-vo59ec"&&(fe.innerHTML=vt),Ue.forEach(t),Xe=i(c),H=l(c,"DIV",{class:!0});var ze=k(H);_(X.$$.fragment,ze),Ke=i(ze),me=l(ze,"P",{"data-svelte-h":!0}),f(me)!=="svelte-1rqbhq5"&&(me.innerHTML=wt),ze.forEach(t),c.forEach(t),Me=i(e),_(K.$$.fragment,e),ke=i(e),S=l(e,"DIV",{class:!0});var He=k(S);_(ee.$$.fragment,He),et=i(He),ue=l(He,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-1qpjiuf"&&(ue.textContent=Pt),He.forEach(t),Ce=i(e),ge=l(e,"P",{}),k(ge).forEach(t),this.h()},h(){C(d,"name","hf:doc:metadata"),C(d,"content",zt),C(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){o(document.head,d),s(e,$,n),s(e,u,n),s(e,g,n),b(x,e,n),s(e,m,n),s(e,y,n),s(e,he,n),s(e,A,n),s(e,_e,n),s(e,N,n),s(e,be,n),s(e,E,n),s(e,ve,n),b(G,e,n),s(e,we,n),s(e,O,n),s(e,Pe,n),s(e,Z,n),s(e,xe,n),s(e,F,n),s(e,De,n),s(e,V,n),s(e,ye,n),s(e,J,n),s(e,$e,n),b(L,e,n),s(e,Te,n),b(R,e,n),s(e,Se,n),s(e,p,n),b(q,p,null),o(p,Ae),o(p,ae),o(p,Ne),o(p,ie),o(p,Ee),o(p,oe),o(p,Ge),o(p,se),o(p,Oe),o(p,T),b(B,T,null),o(T,Ze),o(T,re),o(T,Fe),b(I,T,null),o(p,Ve),o(p,D),b(Y,D,null),o(D,Je),o(D,le),o(D,Re),o(D,de),o(D,qe),o(D,pe),o(p,Be),o(p,U),b(W,U,null),o(U,Ye),o(U,ce),o(p,We),o(p,z),b(Q,z,null),o(z,Qe),o(z,fe),o(p,Xe),o(p,H),b(X,H,null),o(H,Ke),o(H,me),s(e,Me,n),b(K,e,n),s(e,ke,n),s(e,S,n),b(ee,S,null),o(S,et),o(S,ue),s(e,Ce,n),s(e,ge,n),Le=!0},p(e,[n]){const c={};n&2&&(c.$$scope={dirty:n,ctx:e}),L.$set(c);const M={};n&2&&(M.$$scope={dirty:n,ctx:e}),I.$set(M)},i(e){Le||(v(x.$$.fragment,e),v(G.$$.fragment,e),v(L.$$.fragment,e),v(R.$$.fragment,e),v(q.$$.fragment,e),v(B.$$.fragment,e),v(I.$$.fragment,e),v(Y.$$.fragment,e),v(W.$$.fragment,e),v(Q.$$.fragment,e),v(X.$$.fragment,e),v(K.$$.fragment,e),v(ee.$$.fragment,e),Le=!0)},o(e){w(x.$$.fragment,e),w(G.$$.fragment,e),w(L.$$.fragment,e),w(R.$$.fragment,e),w(q.$$.fragment,e),w(B.$$.fragment,e),w(I.$$.fragment,e),w(Y.$$.fragment,e),w(W.$$.fragment,e),w(Q.$$.fragment,e),w(X.$$.fragment,e),w(K.$$.fragment,e),w(ee.$$.fragment,e),Le=!1},d(e){e&&(t($),t(u),t(g),t(m),t(y),t(he),t(A),t(_e),t(N),t(be),t(E),t(ve),t(we),t(O),t(Pe),t(Z),t(xe),t(F),t(De),t(V),t(ye),t(J),t($e),t(Te),t(Se),t(p),t(Me),t(ke),t(S),t(Ce),t(ge)),t(d),P(x,e),P(G,e),P(L,e),P(R,e),P(q),P(B),P(I),P(Y),P(W),P(Q),P(X),P(K,e),P(ee)}}}const zt='{"title":"MultiDiffusion","local":"multidiffusion","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"StableDiffusionPanoramaPipeline","local":"diffusers.StableDiffusionPanoramaPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function Ht(ne){return yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends $t{constructor(d){super(),Tt(this,d,Ht,Ut,Dt,{})}}export{Ft as component};
