import{s as ze,o as Fe,n as We}from"../chunks/scheduler.182ea377.js";import{S as Se,i as He,g as r,s as o,r as b,A as Ne,h as l,f as n,c as s,j as Y,u as I,x as f,k as K,y as d,a as i,v as w,d as x,t as y,w as T}from"../chunks/index.abf12888.js";import{T as Ee}from"../chunks/Tip.230e2334.js";import{D as he}from"../chunks/Docstring.93f6f462.js";import{C as Re}from"../chunks/CodeBlock.57fe6e13.js";import{E as Oe}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as _e}from"../chunks/Heading.16916d63.js";function qe(H){let a,L='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines. Also, to know more about reducing the memory usage of this pipeline, refer to the [“Reduce memory usage”] section <a href="../../using-diffusers/svd#reduce-memory-usage">here</a>.';return{c(){a=r("p"),a.innerHTML=L},l(c){a=l(c,"P",{"data-svelte-h":!0}),f(a)!=="svelte-12x7hfk"&&(a.innerHTML=L)},m(c,u){i(c,a,u)},p:We,d(c){c&&n(a)}}}function Ae(H){let a,L="Examples:",c,u,h;return u=new Re({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwSTJWR2VuWExQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fZ2lmJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwSTJWR2VuWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYWxpLXZpbGFiJTJGaTJ2Z2VuLXhsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFpbWFnZV91cmwlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGZGlmZnVzZXJzJTJGZG9jcy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmkydmdlbl94bF9pbWFnZXMlMkZpbWdfMDAwOS5wbmclMjIlMEEpJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltYWdlX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyUGFwZXJzJTIwd2VyZSUyMGZsb2F0aW5nJTIwaW4lMjB0aGUlMjBhaXIlMjBvbiUyMGElMjB0YWJsZSUyMGluJTIwdGhlJTIwbGlicmFyeSUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMkRpc3RvcnRlZCUyQyUyMGRpc2NvbnRpbnVvdXMlMkMlMjBVZ2x5JTJDJTIwYmx1cnJ5JTJDJTIwbG93JTIwcmVzb2x1dGlvbiUyQyUyMG1vdGlvbmxlc3MlMkMlMjBzdGF0aWMlMkMlMjBkaXNmaWd1cmVkJTJDJTIwZGlzY29ubmVjdGVkJTIwbGltYnMlMkMlMjBVZ2x5JTIwZmFjZXMlMkMlMjBpbmNvbXBsZXRlJTIwYXJtcyUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKDg4ODgpJTBBJTBBZnJhbWVzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOS4wJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5mcmFtZXMlNUIwJTVEJTBBdmlkZW9fcGF0aCUyMCUzRCUyMGV4cG9ydF90b19naWYoZnJhbWVzJTJDJTIwJTIyaTJ2LmdpZiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> I2VGenXLPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = I2VGenXLPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;ali-vilab/i2vgen-xl&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/docs-images/resolve/main/i2vgen_xl_images/img_0009.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(image_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Papers were floating in the air on a table in the library&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;Distorted, discontinuous, Ugly, blurry, low resolution, motionless, static, disfigured, disconnected limbs, Ugly faces, incomplete arms&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">8888</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>frames = pipeline(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">9.0</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_gif(frames, <span class="hljs-string">&quot;i2v.gif&quot;</span>)`,wrap:!1}}),{c(){a=r("p"),a.textContent=L,c=o(),b(u.$$.fragment)},l(p){a=l(p,"P",{"data-svelte-h":!0}),f(a)!=="svelte-kvfsh7"&&(a.textContent=L),c=s(p),I(u.$$.fragment,p)},m(p,_){i(p,a,_),i(p,c,_),w(u,p,_),h=!0},p:We,i(p){h||(x(u.$$.fragment,p),h=!0)},o(p){y(u.$$.fragment,p),h=!1},d(p){p&&(n(a),n(c)),T(u,p)}}}function Qe(H){let a,L,c,u,h,p,_,Ge='<a href="https://hf.co/papers/2311.04145.pdf" rel="nofollow">I2VGen-XL: High-Quality Image-to-Video Synthesis via Cascaded Diffusion Models</a> by Shiwei Zhang, Jiayu Wang, Yingya Zhang, Kang Zhao, Hangjie Yuan, Zhiwu Qin, Xiang Wang, Deli Zhao, and Jingren Zhou.',te,P,Je="The abstract from the paper is:",ne,$,Ve='<em>Video synthesis has recently made remarkable strides benefiting from the rapid development of diffusion models. However, it still encounters challenges in terms of semantic accuracy, clarity and spatio-temporal continuity. They primarily arise from the scarcity of well-aligned text-video data and the complex inherent structure of videos, making it difficult for the model to simultaneously ensure semantic and qualitative excellence. In this report, we propose a cascaded I2VGen-XL approach that enhances model performance by decoupling these two factors and ensures the alignment of the input data by utilizing static images as a form of crucial guidance. I2VGen-XL consists of two stages: i) the base stage guarantees coherent semantics and preserves content from input images by using two hierarchical encoders, and ii) the refinement stage enhances the video’s details by incorporating an additional brief text and improves the resolution to 1280×720. To improve the diversity, we collect around 35 million single-shot text-video pairs and 6 billion text-image pairs to optimize the model. By this means, I2VGen-XL can simultaneously enhance the semantic accuracy, continuity of details and clarity of generated videos. Through extensive experiments, we have investigated the underlying principles of I2VGen-XL and compared it with current top methods, which can demonstrate its effectiveness on diverse data. The source code and models will be publicly available at <a href="https://i2vgen-xl.github.io/" rel="nofollow">this https URL</a>.</em>',ie,k,Xe='The original codebase can be found <a href="https://github.com/ali-vilab/i2vgen-xl/" rel="nofollow">here</a>. The model checkpoints can be found <a href="https://huggingface.co/ali-vilab/" rel="nofollow">here</a>.',oe,J,se,C,Pe="Sample output with I2VGenXL:",ae,Z,$e=`<tbody><tr><td><center>library.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/i2vgen-xl-example.gif" alt="library" style="width: 300px;"/></center></td></tr></tbody>`,re,j,le,U,ke='<li>I2VGenXL always uses a <code>clip_skip</code> value of 1. This means it leverages the penultimate layer representations from the text encoder of CLIP.</li> <li>It can generate videos of quality that is often on par with <a href="../../using-diffusers/svd">Stable Video Diffusion</a> (SVD).</li> <li>Unlike SVD, it additionally accepts text prompts as inputs.</li> <li>It can generate higher resolution videos.</li> <li>When using the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> (which is default for this pipeline), less than 50 steps for inference leads to bad results.</li>',pe,B,de,m,D,ve,N,Ce='Pipeline for image-to-video generation as proposed in <a href="https://i2vgen-xl.github.io/" rel="nofollow">I2VGenXL</a>.',be,E,Ze=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ie,M,W,we,R,je='The call function to the pipeline for image-to-video generation with <a href="/docs/diffusers/main/en/api/pipelines/i2vgenxl#diffusers.I2VGenXLPipeline">I2VGenXLPipeline</a>.',xe,V,ye,X,z,Te,O,Ue="Encodes the prompt into text encoder hidden states.",ce,F,me,v,S,Le,q,Be="Output class for image-to-video pipeline.",Me,A,De=`PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>`,fe,ee,ue;return h=new _e({props:{title:"I2VGen-XL",local:"i2vgen-xl",headingTag:"h1"}}),J=new Ee({props:{$$slots:{default:[qe]},$$scope:{ctx:H}}}),j=new _e({props:{title:"Notes",local:"notes",headingTag:"h2"}}),B=new _e({props:{title:"I2VGenXLPipeline",local:"diffusers.I2VGenXLPipeline",headingTag:"h2"}}),D=new he({props:{name:"class diffusers.I2VGenXLPipeline",anchor:"diffusers.I2VGenXLPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"unet",val:": I2VGenXLUNet"},{name:"scheduler",val:": DDIMScheduler"}],parametersDescription:[{anchor:"diffusers.I2VGenXLPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.I2VGenXLPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.I2VGenXLPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.I2VGenXLPipeline.unet",description:`<strong>unet</strong> (<code>I2VGenXLUNet</code>) &#x2014;
A <code>I2VGenXLUNet</code> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.I2VGenXLPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L111"}}),W=new he({props:{name:"__call__",anchor:"diffusers.I2VGenXLPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"height",val:": Optional = 704"},{name:"width",val:": Optional = 1280"},{name:"target_fps",val:": Optional = 16"},{name:"num_frames",val:": int = 16"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 9.0"},{name:"negative_prompt",val:": Union = None"},{name:"eta",val:": float = 0.0"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"decode_chunk_size",val:": Optional = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = 1"}],parametersDescription:[{anchor:"diffusers.I2VGenXLPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.I2VGenXLPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code> or <code>List[PIL.Image.Image]</code> or <code>torch.FloatTensor</code>) &#x2014;
Image or images to guide image generation. If you provide a tensor, it needs to be compatible with
<a href="https://huggingface.co/lambdalabs/sd-image-variations-diffusers/blob/main/feature_extractor/preprocessor_config.json" rel="nofollow"><code>CLIPImageProcessor</code></a>.`,name:"image"},{anchor:"diffusers.I2VGenXLPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.I2VGenXLPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.I2VGenXLPipeline.__call__.target_fps",description:`<strong>target_fps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Frames per second. The rate at which the generated images shall be exported to a video after
generation. This is also used as a &#x201C;micro-condition&#x201D; while generation.`,name:"target_fps"},{anchor:"diffusers.I2VGenXLPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of video frames to generate.`,name:"num_frames"},{anchor:"diffusers.I2VGenXLPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps.`,name:"num_inference_steps"},{anchor:"diffusers.I2VGenXLPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.I2VGenXLPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.I2VGenXLPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.I2VGenXLPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.I2VGenXLPipeline.__call__.decode_chunk_size",description:`<strong>decode_chunk_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of frames to decode at a time. The higher the chunk size, the higher the temporal
consistency between frames, but also the higher the memory consumption. By default, the decoder will
decode all frames at once for maximal quality. Reduce <code>decode_chunk_size</code> to reduce memory usage.`,name:"decode_chunk_size"},{anchor:"diffusers.I2VGenXLPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.I2VGenXLPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.I2VGenXLPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.I2VGenXLPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.I2VGenXLPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.I2VGenXLPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.I2VGenXLPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.I2VGenXLPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L520",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/i2vgenxl#diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput"
>pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/i2vgenxl#diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput"
>pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput</a> or <code>tuple</code></p>
`}}),V=new Oe({props:{anchor:"diffusers.I2VGenXLPipeline.__call__.example",$$slots:{default:[Ae]},$$scope:{ctx:H}}}),z=new he({props:{name:"encode_prompt",anchor:"diffusers.I2VGenXLPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_videos_per_prompt",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_videos_per_prompt"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L172"}}),F=new _e({props:{title:"I2VGenXLPipelineOutput",local:"diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput",headingTag:"h2"}}),S=new he({props:{name:"class diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput",anchor:"diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput",parameters:[{name:"frames",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L95"}}),{c(){a=r("meta"),L=o(),c=r("p"),u=o(),b(h.$$.fragment),p=o(),_=r("p"),_.innerHTML=Ge,te=o(),P=r("p"),P.textContent=Je,ne=o(),$=r("p"),$.innerHTML=Ve,ie=o(),k=r("p"),k.innerHTML=Xe,oe=o(),b(J.$$.fragment),se=o(),C=r("p"),C.textContent=Pe,ae=o(),Z=r("table"),Z.innerHTML=$e,re=o(),b(j.$$.fragment),le=o(),U=r("ul"),U.innerHTML=ke,pe=o(),b(B.$$.fragment),de=o(),m=r("div"),b(D.$$.fragment),ve=o(),N=r("p"),N.innerHTML=Ce,be=o(),E=r("p"),E.innerHTML=Ze,Ie=o(),M=r("div"),b(W.$$.fragment),we=o(),R=r("p"),R.innerHTML=je,xe=o(),b(V.$$.fragment),ye=o(),X=r("div"),b(z.$$.fragment),Te=o(),O=r("p"),O.textContent=Ue,ce=o(),b(F.$$.fragment),me=o(),v=r("div"),b(S.$$.fragment),Le=o(),q=r("p"),q.textContent=Be,Me=o(),A=r("p"),A.innerHTML=De,fe=o(),ee=r("p"),this.h()},l(e){const t=Ne("svelte-u9bgzb",document.head);a=l(t,"META",{name:!0,content:!0}),t.forEach(n),L=s(e),c=l(e,"P",{}),Y(c).forEach(n),u=s(e),I(h.$$.fragment,e),p=s(e),_=l(e,"P",{"data-svelte-h":!0}),f(_)!=="svelte-1wrjkyv"&&(_.innerHTML=Ge),te=s(e),P=l(e,"P",{"data-svelte-h":!0}),f(P)!=="svelte-1cwsb16"&&(P.textContent=Je),ne=s(e),$=l(e,"P",{"data-svelte-h":!0}),f($)!=="svelte-uj6rwn"&&($.innerHTML=Ve),ie=s(e),k=l(e,"P",{"data-svelte-h":!0}),f(k)!=="svelte-1okzf4k"&&(k.innerHTML=Xe),oe=s(e),I(J.$$.fragment,e),se=s(e),C=l(e,"P",{"data-svelte-h":!0}),f(C)!=="svelte-e24chm"&&(C.textContent=Pe),ae=s(e),Z=l(e,"TABLE",{"data-svelte-h":!0}),f(Z)!=="svelte-1d0ljr7"&&(Z.innerHTML=$e),re=s(e),I(j.$$.fragment,e),le=s(e),U=l(e,"UL",{"data-svelte-h":!0}),f(U)!=="svelte-1h7r1o4"&&(U.innerHTML=ke),pe=s(e),I(B.$$.fragment,e),de=s(e),m=l(e,"DIV",{class:!0});var g=Y(m);I(D.$$.fragment,g),ve=s(g),N=l(g,"P",{"data-svelte-h":!0}),f(N)!=="svelte-va7c9e"&&(N.innerHTML=Ce),be=s(g),E=l(g,"P",{"data-svelte-h":!0}),f(E)!=="svelte-496sm0"&&(E.innerHTML=Ze),Ie=s(g),M=l(g,"DIV",{class:!0});var G=Y(M);I(W.$$.fragment,G),we=s(G),R=l(G,"P",{"data-svelte-h":!0}),f(R)!=="svelte-wf4rrn"&&(R.innerHTML=je),xe=s(G),I(V.$$.fragment,G),G.forEach(n),ye=s(g),X=l(g,"DIV",{class:!0});var ge=Y(X);I(z.$$.fragment,ge),Te=s(ge),O=l(ge,"P",{"data-svelte-h":!0}),f(O)!=="svelte-16q0ax1"&&(O.textContent=Ue),ge.forEach(n),g.forEach(n),ce=s(e),I(F.$$.fragment,e),me=s(e),v=l(e,"DIV",{class:!0});var Q=Y(v);I(S.$$.fragment,Q),Le=s(Q),q=l(Q,"P",{"data-svelte-h":!0}),f(q)!=="svelte-ulnuw9"&&(q.textContent=Be),Me=s(Q),A=l(Q,"P",{"data-svelte-h":!0}),f(A)!=="svelte-gk6g69"&&(A.innerHTML=De),Q.forEach(n),fe=s(e),ee=l(e,"P",{}),Y(ee).forEach(n),this.h()},h(){K(a,"name","hf:doc:metadata"),K(a,"content",Ye),K(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),K(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),K(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),K(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,a),i(e,L,t),i(e,c,t),i(e,u,t),w(h,e,t),i(e,p,t),i(e,_,t),i(e,te,t),i(e,P,t),i(e,ne,t),i(e,$,t),i(e,ie,t),i(e,k,t),i(e,oe,t),w(J,e,t),i(e,se,t),i(e,C,t),i(e,ae,t),i(e,Z,t),i(e,re,t),w(j,e,t),i(e,le,t),i(e,U,t),i(e,pe,t),w(B,e,t),i(e,de,t),i(e,m,t),w(D,m,null),d(m,ve),d(m,N),d(m,be),d(m,E),d(m,Ie),d(m,M),w(W,M,null),d(M,we),d(M,R),d(M,xe),w(V,M,null),d(m,ye),d(m,X),w(z,X,null),d(X,Te),d(X,O),i(e,ce,t),w(F,e,t),i(e,me,t),i(e,v,t),w(S,v,null),d(v,Le),d(v,q),d(v,Me),d(v,A),i(e,fe,t),i(e,ee,t),ue=!0},p(e,[t]){const g={};t&2&&(g.$$scope={dirty:t,ctx:e}),J.$set(g);const G={};t&2&&(G.$$scope={dirty:t,ctx:e}),V.$set(G)},i(e){ue||(x(h.$$.fragment,e),x(J.$$.fragment,e),x(j.$$.fragment,e),x(B.$$.fragment,e),x(D.$$.fragment,e),x(W.$$.fragment,e),x(V.$$.fragment,e),x(z.$$.fragment,e),x(F.$$.fragment,e),x(S.$$.fragment,e),ue=!0)},o(e){y(h.$$.fragment,e),y(J.$$.fragment,e),y(j.$$.fragment,e),y(B.$$.fragment,e),y(D.$$.fragment,e),y(W.$$.fragment,e),y(V.$$.fragment,e),y(z.$$.fragment,e),y(F.$$.fragment,e),y(S.$$.fragment,e),ue=!1},d(e){e&&(n(L),n(c),n(u),n(p),n(_),n(te),n(P),n(ne),n($),n(ie),n(k),n(oe),n(se),n(C),n(ae),n(Z),n(re),n(le),n(U),n(pe),n(de),n(m),n(ce),n(me),n(v),n(fe),n(ee)),n(a),T(h,e),T(J,e),T(j,e),T(B,e),T(D),T(W),T(V),T(z),T(F,e),T(S)}}}const Ye='{"title":"I2VGen-XL","local":"i2vgen-xl","sections":[{"title":"Notes","local":"notes","sections":[],"depth":2},{"title":"I2VGenXLPipeline","local":"diffusers.I2VGenXLPipeline","sections":[],"depth":2},{"title":"I2VGenXLPipelineOutput","local":"diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput","sections":[],"depth":2}],"depth":1}';function Ke(H){return Fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rt extends Se{constructor(a){super(),He(this,a,Ke,Qe,ze,{})}}export{rt as component};
