import{s as $t,n as Tt,o as Zt}from"../chunks/scheduler.182ea377.js";import{S as Wt,i as Lt,g as o,s as l,p,A as Ct,h as n,f as t,c,j as d,q as h,m as u,k as r,v as a,a as i,r as f,d as g,t as v,u as _}from"../chunks/index.008d68e4.js";import{D as Ke}from"../chunks/Docstring.7aec8b85.js";import{C as Ut}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as le}from"../chunks/IconCopyLink.96bbb92b.js";function Jt(Pe){let y,fe,b,Z,ce,D,Se,P,Oe="AsymmetricAutoencoderKL",ge,E,qe='Improved larger variational autoencoder (VAE) model with KL loss for inpainting task: <a href="https://arxiv.org/abs/2306.04632" rel="nofollow">Designing a Better Asymmetric VQGAN for StableDiffusion</a> by Zixin Zhu, Xuelu Feng, Dongdong Chen, Jianmin Bao, Le Wang, Yinpeng Chen, Lu Yuan, Gang Hua.',ve,j,et="The abstract from the paper is:",_e,N,tt='<em>StableDiffusion is a revolutionary text-to-image generator that is causing a stir in the world of image generation and editing. Unlike traditional methods that learn a diffusion model in pixel space, StableDiffusion learns a diffusion model in the latent space via a VQGAN, ensuring both efficiency and quality. It not only supports image generation tasks, but also enables image editing for real images, such as image inpainting and local editing. However, we have observed that the vanilla VQGAN used in StableDiffusion leads to significant information loss, causing distortion artifacts even in non-edited image regions. To this end, we propose a new asymmetric VQGAN with two simple designs. Firstly, in addition to the input from the encoder, the decoder contains a conditional branch that incorporates information from task-specific priors, such as the unmasked image region in inpainting. Secondly, the decoder is much heavier than the encoder, allowing for more detailed recovery while only slightly increasing the total inference cost. The training cost of our asymmetric VQGAN is cheap, and we only need to retrain a new asymmetric decoder while keeping the vanilla VQGAN encoder and StableDiffusion unchanged. Our asymmetric VQGAN can be widely used in StableDiffusion-based inpainting and local editing methods. Extensive experiments demonstrate that it can significantly improve the inpainting and editing performance, while maintaining the original text-to-image capability. The code is available at <a href="https://github.com/buxiangzhiren/Asymmetric_VQGAN" rel="nofollow">https://github.com/buxiangzhiren/Asymmetric_VQGAN</a></em>',ye,K,ot="Evaluation results can be found in section 4.1 of the original paper.",be,w,W,de,S,Re,O,nt="Available checkpoints",we,R,at='<li><a href="https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-1-5" rel="nofollow">https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-1-5</a></li> <li><a href="https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-2" rel="nofollow">https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-2</a></li>',ke,k,L,ue,F,Fe,q,st="Example Usage",Ae,B,Me,A,C,me,z,Be,ee,rt="AsymmetricAutoencoderKL",xe,m,X,ze,te,it=`Designing a Better Asymmetric VQGAN for StableDiffusion <a href="https://arxiv.org/abs/2306.04632" rel="nofollow">https://arxiv.org/abs/2306.04632</a> . A VAE model with KL loss
for encoding images into latents and decoding latent representations into images.`,Xe,oe,lt=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>. Check the superclass documentation for it’s generic methods implemented
for all models (such as downloading or saving).`,Ve,ne,V,$e,M,U,pe,Y,Ye,ae,ct="AutoencoderKLOutput",Te,x,H,He,se,dt="Output of AutoencoderKL encoding method.",Ze,$,J,he,I,Ie,re,ut="DecoderOutput",We,T,Q,Qe,ie,mt="Output of decoding method.",Le;return D=new le({}),S=new le({}),F=new le({}),B=new Ut({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEFzeW1tZXRyaWNBdXRvZW5jb2RlcktMJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBwZXJzb24lMjB3aXRoJTIwYmVhcmQlMjIlMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnJlcGFpbnQlMkZjZWxlYmFfaHFfMjU2LnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnJlcGFpbnQlMkZtYXNrXzI1Ni5wbmclMjIlMEElMEFvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCkucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKG1hc2tfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLWlucGFpbnRpbmclMjIpJTBBcGlwZS52YWUlMjAlM0QlMjBBc3ltbWV0cmljQXV0b2VuY29kZXJLTC5mcm9tX3ByZXRyYWluZWQoJTIyY3Jvc3MtYXR0ZW50aW9uJTJGYXN5bW1ldHJpYy1hdXRvZW5jb2Rlci1rbC14LTEtNSUyMiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEb3JpZ2luYWxfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJvcmlnaW5hbF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AsymmetricAutoencoderKL, StableDiffusionInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid


prompt = <span class="hljs-string">&quot;a photo of a person with beard&quot;</span>
img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/repaint/celeba_hq_256.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/repaint/mask_256.png&quot;</span>

original_image = load_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = load_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

pipe = StableDiffusionInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>)
pipe.vae = AsymmetricAutoencoderKL.from_pretrained(<span class="hljs-string">&quot;cross-attention/asymmetric-autoencoder-kl-x-1-5&quot;</span>)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(prompt=prompt, image=original_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
make_image_grid([original_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`}}),z=new le({}),X=new Ke({props:{name:"class diffusers.AsymmetricAutoencoderKL",anchor:"diffusers.AsymmetricAutoencoderKL",parameters:[{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 3"},{name:"down_block_types",val:": Tuple = ('DownEncoderBlock2D',)"},{name:"down_block_out_channels",val:": Tuple = (64,)"},{name:"layers_per_down_block",val:": int = 1"},{name:"up_block_types",val:": Tuple = ('UpDecoderBlock2D',)"},{name:"up_block_out_channels",val:": Tuple = (64,)"},{name:"layers_per_up_block",val:": int = 1"},{name:"act_fn",val:": str = 'silu'"},{name:"latent_channels",val:": int = 4"},{name:"norm_num_groups",val:": int = 32"},{name:"sample_size",val:": int = 32"},{name:"scaling_factor",val:": float = 0.18215"}],parametersDescription:[{anchor:"diffusers.AsymmetricAutoencoderKL.in_channels",description:"<strong>in_channels</strong> (int, <em>optional</em>, defaults to 3) &#x2014; Number of channels in the input image.",name:"in_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.out_channels",description:"<strong>out_channels</strong> (int,  <em>optional</em>, defaults to 3) &#x2014; Number of channels in the output.",name:"out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.down_block_types",description:`<strong>down_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;DownEncoderBlock2D&quot;,)</code>) &#x2014;
Tuple of downsample block types.`,name:"down_block_types"},{anchor:"diffusers.AsymmetricAutoencoderKL.down_block_out_channels",description:`<strong>down_block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(64,)</code>) &#x2014;
Tuple of down block output channels.`,name:"down_block_out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.layers_per_down_block",description:`<strong>layers_per_down_block</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number layers for down block.`,name:"layers_per_down_block"},{anchor:"diffusers.AsymmetricAutoencoderKL.up_block_types",description:`<strong>up_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;UpDecoderBlock2D&quot;,)</code>) &#x2014;
Tuple of upsample block types.`,name:"up_block_types"},{anchor:"diffusers.AsymmetricAutoencoderKL.up_block_out_channels",description:`<strong>up_block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(64,)</code>) &#x2014;
Tuple of up block output channels.`,name:"up_block_out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.layers_per_up_block",description:`<strong>layers_per_up_block</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number layers for up block.`,name:"layers_per_up_block"},{anchor:"diffusers.AsymmetricAutoencoderKL.act_fn",description:"<strong>act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014; The activation function to use.",name:"act_fn"},{anchor:"diffusers.AsymmetricAutoencoderKL.latent_channels",description:"<strong>latent_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014; Number of channels in the latent space.",name:"latent_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.sample_size",description:"<strong>sample_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>32</code>) &#x2014; Sample input size.",name:"sample_size"},{anchor:"diffusers.AsymmetricAutoencoderKL.norm_num_groups",description:`<strong>norm_num_groups</strong> (<code>int</code>, <em>optional</em>, defaults to <code>32</code>) &#x2014;
Number of groups to use for the first normalization layer in ResNet blocks.`,name:"norm_num_groups"},{anchor:"diffusers.AsymmetricAutoencoderKL.scaling_factor",description:`<strong>scaling_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.18215) &#x2014;
The component-wise standard deviation of the trained latent space computed using the first batch of the
training set. This is used to scale the latent space to have unit variance when training the diffusion
model. The latents are scaled with the formula <code>z = z * scaling_factor</code> before being passed to the
diffusion model. When decoding, the latents are scaled back to the original scale with the formula: <code>z = 1 / scaling_factor * z</code>. For more details, refer to sections 4.3.2 and D.1 of the <a href="https://arxiv.org/abs/2112.10752" rel="nofollow">High-Resolution Image
Synthesis with Latent Diffusion Models</a> paper.`,name:"scaling_factor"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/models/autoencoders/autoencoder_asym_kl.py#L26"}}),V=new Ke({props:{name:"forward",anchor:"diffusers.AsymmetricAutoencoderKL.forward",parameters:[{name:"sample",val:": FloatTensor"},{name:"mask",val:": Optional = None"},{name:"sample_posterior",val:": bool = False"},{name:"return_dict",val:": bool = True"},{name:"generator",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AsymmetricAutoencoderKL.forward.sample",description:"<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014; Input sample.",name:"sample"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.mask",description:"<strong>mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014; Optional inpainting mask.",name:"mask"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.sample_posterior",description:`<strong>sample_posterior</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to sample from the posterior.`,name:"sample_posterior"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>DecoderOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/models/autoencoders/autoencoder_asym_kl.py#L158"}}),Y=new le({}),H=new Ke({props:{name:"class diffusers.models.modeling_outputs.AutoencoderKLOutput",anchor:"diffusers.models.modeling_outputs.AutoencoderKLOutput",parameters:[{name:"latent_dist",val:": DiagonalGaussianDistribution"}],parametersDescription:[{anchor:"diffusers.models.modeling_outputs.AutoencoderKLOutput.latent_dist",description:`<strong>latent_dist</strong> (<code>DiagonalGaussianDistribution</code>) &#x2014;
Encoded outputs of <code>Encoder</code> represented as the mean and logvar of <code>DiagonalGaussianDistribution</code>.
<code>DiagonalGaussianDistribution</code> allows for sampling latents from the distribution.`,name:"latent_dist"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/models/modeling_outputs.py#L6"}}),I=new le({}),Q=new Ke({props:{name:"class diffusers.models.autoencoders.vae.DecoderOutput",anchor:"diffusers.models.autoencoders.vae.DecoderOutput",parameters:[{name:"sample",val:": FloatTensor"}],parametersDescription:[{anchor:"diffusers.models.autoencoders.vae.DecoderOutput.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
The decoded output sample from the last layer of the model.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/models/autoencoders/vae.py#L33"}}),{c(){y=o("meta"),fe=l(),b=o("h1"),Z=o("a"),ce=o("span"),p(D.$$.fragment),Se=l(),P=o("span"),P.textContent=Oe,ge=l(),E=o("p"),E.innerHTML=qe,ve=l(),j=o("p"),j.textContent=et,_e=l(),N=o("p"),N.innerHTML=tt,ye=l(),K=o("p"),K.textContent=ot,be=l(),w=o("h2"),W=o("a"),de=o("span"),p(S.$$.fragment),Re=l(),O=o("span"),O.textContent=nt,we=l(),R=o("ul"),R.innerHTML=at,ke=l(),k=o("h2"),L=o("a"),ue=o("span"),p(F.$$.fragment),Fe=l(),q=o("span"),q.textContent=st,Ae=l(),p(B.$$.fragment),Me=l(),A=o("h2"),C=o("a"),me=o("span"),p(z.$$.fragment),Be=l(),ee=o("span"),ee.textContent=rt,xe=l(),m=o("div"),p(X.$$.fragment),ze=l(),te=o("p"),te.innerHTML=it,Xe=l(),oe=o("p"),oe.innerHTML=lt,Ve=l(),ne=o("div"),p(V.$$.fragment),$e=l(),M=o("h2"),U=o("a"),pe=o("span"),p(Y.$$.fragment),Ye=l(),ae=o("span"),ae.textContent=ct,Te=l(),x=o("div"),p(H.$$.fragment),He=l(),se=o("p"),se.textContent=dt,Ze=l(),$=o("h2"),J=o("a"),he=o("span"),p(I.$$.fragment),Ie=l(),re=o("span"),re.textContent=ut,We=l(),T=o("div"),p(Q.$$.fragment),Qe=l(),ie=o("p"),ie.textContent=mt,this.h()},l(e){const s=Ct("svelte-1phssyn",document.head);y=n(s,"META",{name:!0,content:!0}),s.forEach(t),fe=c(e),b=n(e,"H1",{class:!0});var Ce=d(b);Z=n(Ce,"A",{id:!0,class:!0,href:!0});var pt=d(Z);ce=n(pt,"SPAN",{});var ht=d(ce);h(D.$$.fragment,ht),ht.forEach(t),pt.forEach(t),Se=c(Ce),P=n(Ce,"SPAN",{"data-svelte-h":!0}),u(P)!=="svelte-yn0bon"&&(P.textContent=Oe),Ce.forEach(t),ge=c(e),E=n(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-8mpj0"&&(E.innerHTML=qe),ve=c(e),j=n(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-1cwsb16"&&(j.textContent=et),_e=c(e),N=n(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-ggnlwl"&&(N.innerHTML=tt),ye=c(e),K=n(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-1dzj46z"&&(K.textContent=ot),be=c(e),w=n(e,"H2",{class:!0});var Ue=d(w);W=n(Ue,"A",{id:!0,class:!0,href:!0});var ft=d(W);de=n(ft,"SPAN",{});var gt=d(de);h(S.$$.fragment,gt),gt.forEach(t),ft.forEach(t),Re=c(Ue),O=n(Ue,"SPAN",{"data-svelte-h":!0}),u(O)!=="svelte-1bwe2sz"&&(O.textContent=nt),Ue.forEach(t),we=c(e),R=n(e,"UL",{"data-svelte-h":!0}),u(R)!=="svelte-1m6ravg"&&(R.innerHTML=at),ke=c(e),k=n(e,"H2",{class:!0});var Je=d(k);L=n(Je,"A",{id:!0,class:!0,href:!0});var vt=d(L);ue=n(vt,"SPAN",{});var _t=d(ue);h(F.$$.fragment,_t),_t.forEach(t),vt.forEach(t),Fe=c(Je),q=n(Je,"SPAN",{"data-svelte-h":!0}),u(q)!=="svelte-17fwr0q"&&(q.textContent=st),Je.forEach(t),Ae=c(e),h(B.$$.fragment,e),Me=c(e),A=n(e,"H2",{class:!0});var Ge=d(A);C=n(Ge,"A",{id:!0,class:!0,href:!0});var yt=d(C);me=n(yt,"SPAN",{});var bt=d(me);h(z.$$.fragment,bt),bt.forEach(t),yt.forEach(t),Be=c(Ge),ee=n(Ge,"SPAN",{"data-svelte-h":!0}),u(ee)!=="svelte-yn0bon"&&(ee.textContent=rt),Ge.forEach(t),xe=c(e),m=n(e,"DIV",{class:!0});var G=d(m);h(X.$$.fragment,G),ze=c(G),te=n(G,"P",{"data-svelte-h":!0}),u(te)!=="svelte-4v08r1"&&(te.innerHTML=it),Xe=c(G),oe=n(G,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-zhna7y"&&(oe.innerHTML=lt),Ve=c(G),ne=n(G,"DIV",{class:!0});var wt=d(ne);h(V.$$.fragment,wt),wt.forEach(t),G.forEach(t),$e=c(e),M=n(e,"H2",{class:!0});var De=d(M);U=n(De,"A",{id:!0,class:!0,href:!0});var kt=d(U);pe=n(kt,"SPAN",{});var At=d(pe);h(Y.$$.fragment,At),At.forEach(t),kt.forEach(t),Ye=c(De),ae=n(De,"SPAN",{"data-svelte-h":!0}),u(ae)!=="svelte-pi6cmw"&&(ae.textContent=ct),De.forEach(t),Te=c(e),x=n(e,"DIV",{class:!0});var Ee=d(x);h(H.$$.fragment,Ee),He=c(Ee),se=n(Ee,"P",{"data-svelte-h":!0}),u(se)!=="svelte-1vsc7ag"&&(se.textContent=dt),Ee.forEach(t),Ze=c(e),$=n(e,"H2",{class:!0});var je=d($);J=n(je,"A",{id:!0,class:!0,href:!0});var Mt=d(J);he=n(Mt,"SPAN",{});var xt=d(he);h(I.$$.fragment,xt),xt.forEach(t),Mt.forEach(t),Ie=c(je),re=n(je,"SPAN",{"data-svelte-h":!0}),u(re)!=="svelte-1mjdpzm"&&(re.textContent=ut),je.forEach(t),We=c(e),T=n(e,"DIV",{class:!0});var Ne=d(T);h(Q.$$.fragment,Ne),Qe=c(Ne),ie=n(Ne,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-18u8upa"&&(ie.textContent=mt),Ne.forEach(t),this.h()},h(){r(y,"name","hf:doc:metadata"),r(y,"content",JSON.stringify(Gt)),r(Z,"id","asymmetricautoencoderkl"),r(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Z,"href","#asymmetricautoencoderkl"),r(b,"class","relative group"),r(W,"id","available-checkpoints"),r(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(W,"href","#available-checkpoints"),r(w,"class","relative group"),r(L,"id","example-usage"),r(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(L,"href","#example-usage"),r(k,"class","relative group"),r(C,"id","diffusers.AsymmetricAutoencoderKL"),r(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(C,"href","#diffusers.AsymmetricAutoencoderKL"),r(A,"class","relative group"),r(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(U,"id","diffusers.models.modeling_outputs.AutoencoderKLOutput"),r(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(U,"href","#diffusers.models.modeling_outputs.AutoencoderKLOutput"),r(M,"class","relative group"),r(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(J,"id","diffusers.models.autoencoders.vae.DecoderOutput"),r(J,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(J,"href","#diffusers.models.autoencoders.vae.DecoderOutput"),r($,"class","relative group"),r(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){a(document.head,y),i(e,fe,s),i(e,b,s),a(b,Z),a(Z,ce),f(D,ce,null),a(b,Se),a(b,P),i(e,ge,s),i(e,E,s),i(e,ve,s),i(e,j,s),i(e,_e,s),i(e,N,s),i(e,ye,s),i(e,K,s),i(e,be,s),i(e,w,s),a(w,W),a(W,de),f(S,de,null),a(w,Re),a(w,O),i(e,we,s),i(e,R,s),i(e,ke,s),i(e,k,s),a(k,L),a(L,ue),f(F,ue,null),a(k,Fe),a(k,q),i(e,Ae,s),f(B,e,s),i(e,Me,s),i(e,A,s),a(A,C),a(C,me),f(z,me,null),a(A,Be),a(A,ee),i(e,xe,s),i(e,m,s),f(X,m,null),a(m,ze),a(m,te),a(m,Xe),a(m,oe),a(m,Ve),a(m,ne),f(V,ne,null),i(e,$e,s),i(e,M,s),a(M,U),a(U,pe),f(Y,pe,null),a(M,Ye),a(M,ae),i(e,Te,s),i(e,x,s),f(H,x,null),a(x,He),a(x,se),i(e,Ze,s),i(e,$,s),a($,J),a(J,he),f(I,he,null),a($,Ie),a($,re),i(e,We,s),i(e,T,s),f(Q,T,null),a(T,Qe),a(T,ie),Le=!0},p:Tt,i(e){Le||(g(D.$$.fragment,e),g(S.$$.fragment,e),g(F.$$.fragment,e),g(B.$$.fragment,e),g(z.$$.fragment,e),g(X.$$.fragment,e),g(V.$$.fragment,e),g(Y.$$.fragment,e),g(H.$$.fragment,e),g(I.$$.fragment,e),g(Q.$$.fragment,e),Le=!0)},o(e){v(D.$$.fragment,e),v(S.$$.fragment,e),v(F.$$.fragment,e),v(B.$$.fragment,e),v(z.$$.fragment,e),v(X.$$.fragment,e),v(V.$$.fragment,e),v(Y.$$.fragment,e),v(H.$$.fragment,e),v(I.$$.fragment,e),v(Q.$$.fragment,e),Le=!1},d(e){e&&(t(fe),t(b),t(ge),t(E),t(ve),t(j),t(_e),t(N),t(ye),t(K),t(be),t(w),t(we),t(R),t(ke),t(k),t(Ae),t(Me),t(A),t(xe),t(m),t($e),t(M),t(Te),t(x),t(Ze),t($),t(We),t(T)),t(y),_(D),_(S),_(F),_(B,e),_(z),_(X),_(V),_(Y),_(H),_(I),_(Q)}}}const Gt={local:"asymmetricautoencoderkl",sections:[{local:"available-checkpoints",title:"Available checkpoints"},{local:"example-usage",title:"Example Usage"},{local:"diffusers.AsymmetricAutoencoderKL",title:"AsymmetricAutoencoderKL"},{local:"diffusers.models.modeling_outputs.AutoencoderKLOutput",title:"AutoencoderKLOutput"},{local:"diffusers.models.autoencoders.vae.DecoderOutput",title:"DecoderOutput"}],title:"AsymmetricAutoencoderKL"};function Dt(Pe){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends Wt{constructor(y){super(),Lt(this,y,Dt,Jt,$t,{})}}export{Rt as component};
