import{s as ct,n as ht,o as ut}from"../chunks/scheduler.182ea377.js";import{S as Mt,i as Tt,g as s,s as n,r as N,A as gt,h as o,f as d,c as i,j as pt,u as q,x as l,k as X,y as bt,a as r,v as Q,d as R,t as Y,w as A}from"../chunks/index.abf12888.js";import{C as ft}from"../chunks/CodeBlock.57fe6e13.js";import{H as mt}from"../chunks/Heading.16916d63.js";function wt(D){let a,H,U,x,f,Z,m,K='<a href="https://huggingface.co/papers/2303.17604" rel="nofollow">Token merging</a> (ToMe) merges redundant tokens/patches progressively in the forward pass of a Transformer-based network which can speed-up the inference latency of <a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>.',_,c,tt='You can use ToMe from the <a href="https://github.com/dbolya/tomesd" rel="nofollow"><code>tomesd</code></a> library with the <a href="https://github.com/dbolya/tomesd?tab=readme-ov-file#usage" rel="nofollow"><code>apply_patch</code></a> function:',k,h,S,u,et='The <code>apply_patch</code> function exposes a number of <a href="https://github.com/dbolya/tomesd#usage" rel="nofollow">arguments</a> to help strike a balance between pipeline inference speed and the quality of the generated tokens. The most important argument is <code>ratio</code> which controls the number of tokens that are merged during the forward pass.',$,M,dt='As reported in the <a href="https://huggingface.co/papers/2303.17604" rel="nofollow">paper</a>, ToMe can greatly preserve the quality of the generated images while boosting inference speed. By increasing the <code>ratio</code>, you can speed-up inference even further, but at the cost of some degraded image quality.',L,T,rt='To test the quality of the generated images, we sampled a few prompts from <a href="https://parti.research.google/" rel="nofollow">Parti Prompts</a> and performed inference with the <a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> with the following settings:',C,p,nt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/tome/tome_samples.png"/>',P,g,it='We didn’t notice any significant decrease in the quality of the generated samples, and you can check out the generated samples in this <a href="https://wandb.ai/sayakpaul/tomesd-results/runs/23j4bj3i?workspace=" rel="nofollow">WandB report</a>. If you’re interested in reproducing this experiment, use this <a href="https://gist.github.com/sayakpaul/8cac98d7f22399085a060992f411ecbd" rel="nofollow">script</a>.',I,b,j,w,st='We also benchmarked the impact of <code>tomesd</code> on the <a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> with <a href="https://huggingface.co/docs/diffusers/optimization/xformers" rel="nofollow">xFormers</a> enabled across several image resolutions. The results are obtained from A100 and V100 GPUs in the following development environment:',G,y,V,v,ot='To reproduce this benchmark, feel free to use this <a href="https://gist.github.com/sayakpaul/27aec6bca7eb7b0e0aa4112205850335" rel="nofollow">script</a>. The results are reported in seconds, and where applicable we report the speed-up percentage over the vanilla pipeline when using ToMe and ToMe + xFormers.',W,O,lt="<thead><tr><th><strong>GPU</strong></th> <th><strong>Resolution</strong></th> <th><strong>Batch size</strong></th> <th><strong>Vanilla</strong></th> <th><strong>ToMe</strong></th> <th><strong>ToMe + xFormers</strong></th></tr></thead> <tbody><tr><td><strong>A100</strong></td> <td>512</td> <td>10</td> <td>6.88</td> <td>5.26 (+23.55%)</td> <td>4.69 (+31.83%)</td></tr> <tr><td></td> <td>768</td> <td>10</td> <td>OOM</td> <td>14.71</td> <td>11</td></tr> <tr><td></td> <td></td> <td>8</td> <td>OOM</td> <td>11.56</td> <td>8.84</td></tr> <tr><td></td> <td></td> <td>4</td> <td>OOM</td> <td>5.98</td> <td>4.66</td></tr> <tr><td></td> <td></td> <td>2</td> <td>4.99</td> <td>3.24 (+35.07%)</td> <td>2.1 (+37.88%)</td></tr> <tr><td></td> <td></td> <td>1</td> <td>3.29</td> <td>2.24 (+31.91%)</td> <td>2.03 (+38.3%)</td></tr> <tr><td></td> <td>1024</td> <td>10</td> <td>OOM</td> <td>OOM</td> <td>OOM</td></tr> <tr><td></td> <td></td> <td>8</td> <td>OOM</td> <td>OOM</td> <td>OOM</td></tr> <tr><td></td> <td></td> <td>4</td> <td>OOM</td> <td>12.51</td> <td>9.09</td></tr> <tr><td></td> <td></td> <td>2</td> <td>OOM</td> <td>6.52</td> <td>4.96</td></tr> <tr><td></td> <td></td> <td>1</td> <td>6.4</td> <td>3.61 (+43.59%)</td> <td>2.81 (+56.09%)</td></tr> <tr><td><strong>V100</strong></td> <td>512</td> <td>10</td> <td>OOM</td> <td>10.03</td> <td>9.29</td></tr> <tr><td></td> <td></td> <td>8</td> <td>OOM</td> <td>8.05</td> <td>7.47</td></tr> <tr><td></td> <td></td> <td>4</td> <td>5.7</td> <td>4.3 (+24.56%)</td> <td>3.98 (+30.18%)</td></tr> <tr><td></td> <td></td> <td>2</td> <td>3.14</td> <td>2.43 (+22.61%)</td> <td>2.27 (+27.71%)</td></tr> <tr><td></td> <td></td> <td>1</td> <td>1.88</td> <td>1.57 (+16.49%)</td> <td>1.57 (+16.49%)</td></tr> <tr><td></td> <td>768</td> <td>10</td> <td>OOM</td> <td>OOM</td> <td>23.67</td></tr> <tr><td></td> <td></td> <td>8</td> <td>OOM</td> <td>OOM</td> <td>18.81</td></tr> <tr><td></td> <td></td> <td>4</td> <td>OOM</td> <td>11.81</td> <td>9.7</td></tr> <tr><td></td> <td></td> <td>2</td> <td>OOM</td> <td>6.27</td> <td>5.2</td></tr> <tr><td></td> <td></td> <td>1</td> <td>5.43</td> <td>3.38 (+37.75%)</td> <td>2.82 (+48.07%)</td></tr> <tr><td></td> <td>1024</td> <td>10</td> <td>OOM</td> <td>OOM</td> <td>OOM</td></tr> <tr><td></td> <td></td> <td>8</td> <td>OOM</td> <td>OOM</td> <td>OOM</td></tr> <tr><td></td> <td></td> <td>4</td> <td>OOM</td> <td>OOM</td> <td>19.35</td></tr> <tr><td></td> <td></td> <td>2</td> <td>OOM</td> <td>13</td> <td>10.78</td></tr> <tr><td></td> <td></td> <td>1</td> <td>OOM</td> <td>6.66</td> <td>5.54</td></tr></tbody>",z,J,at='As seen in the tables above, the speed-up from <code>tomesd</code> becomes more pronounced for larger image resolutions. It is also interesting to note that with <code>tomesd</code>, it is possible to run the pipeline on a higher resolution like 1024x1024. You may be able to speed-up inference even more with <a href="torch2.0"><code>torch.compile</code></a>.',E,B,F;return f=new mt({props:{title:"Token merging",local:"token-merging",headingTag:"h1"}}),h=new ft({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9tZXNkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUyQiUyMHRvbWVzZC5hcHBseV9wYXRjaChwaXBlbGluZSUyQyUyMHJhdGlvJTNEMC41KSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMikuaW1hZ2VzJTVCMCU1RA==",highlighted:`from diffusers import StableDiffusionPipeline
import tomesd

pipeline = StableDiffusionPipeline.from_pretrained(
      &quot;runwayml/stable-diffusion-v1-5&quot;, torch_dtype=torch.float16, use_safetensors=True,
).to(&quot;cuda&quot;)
<span class="hljs-addition">+ tomesd.apply_patch(pipeline, ratio=0.5)</span>

image = pipeline(&quot;a photo of an astronaut riding a horse on mars&quot;).images[0]`,wrap:!1}}),b=new mt({props:{title:"Benchmarks",local:"benchmarks",headingTag:"h2"}}),y=new ft({props:{code:"LSUyMCU2MGRpZmZ1c2VycyU2MCUyMHZlcnNpb24lM0ElMjAwLjE1LjElMEEtJTIwUHl0aG9uJTIwdmVyc2lvbiUzQSUyMDMuOC4xNiUwQS0lMjBQeVRvcmNoJTIwdmVyc2lvbiUyMChHUFUlM0YpJTNBJTIwMS4xMy4xJTJCY3UxMTYlMjAoVHJ1ZSklMEEtJTIwSHVnZ2luZ2ZhY2VfaHViJTIwdmVyc2lvbiUzQSUyMDAuMTMuMiUwQS0lMjBUcmFuc2Zvcm1lcnMlMjB2ZXJzaW9uJTNBJTIwNC4yNy4yJTBBLSUyMEFjY2VsZXJhdGUlMjB2ZXJzaW9uJTNBJTIwMC4xOC4wJTBBLSUyMHhGb3JtZXJzJTIwdmVyc2lvbiUzQSUyMDAuMC4xNiUwQS0lMjB0b21lc2QlMjB2ZXJzaW9uJTNBJTIwMC4xLjI=",highlighted:`- \`diffusers\` version: 0.15.1
- Python version: 3.8.16
- PyTorch version (GPU?): 1.13.1+cu116 (True)
- Huggingface_hub version: 0.13.2
- Transformers version: 4.27.2
- Accelerate version: 0.18.0
- xFormers version: 0.0.16
- tomesd version: 0.1.2`,wrap:!1}}),{c(){a=s("meta"),H=n(),U=s("p"),x=n(),N(f.$$.fragment),Z=n(),m=s("p"),m.innerHTML=K,_=n(),c=s("p"),c.innerHTML=tt,k=n(),N(h.$$.fragment),S=n(),u=s("p"),u.innerHTML=et,$=n(),M=s("p"),M.innerHTML=dt,L=n(),T=s("p"),T.innerHTML=rt,C=n(),p=s("div"),p.innerHTML=nt,P=n(),g=s("p"),g.innerHTML=it,I=n(),N(b.$$.fragment),j=n(),w=s("p"),w.innerHTML=st,G=n(),N(y.$$.fragment),V=n(),v=s("p"),v.innerHTML=ot,W=n(),O=s("table"),O.innerHTML=lt,z=n(),J=s("p"),J.innerHTML=at,E=n(),B=s("p"),this.h()},l(t){const e=gt("svelte-u9bgzb",document.head);a=o(e,"META",{name:!0,content:!0}),e.forEach(d),H=i(t),U=o(t,"P",{}),pt(U).forEach(d),x=i(t),q(f.$$.fragment,t),Z=i(t),m=o(t,"P",{"data-svelte-h":!0}),l(m)!=="svelte-bzoc3"&&(m.innerHTML=K),_=i(t),c=o(t,"P",{"data-svelte-h":!0}),l(c)!=="svelte-1q1myt5"&&(c.innerHTML=tt),k=i(t),q(h.$$.fragment,t),S=i(t),u=o(t,"P",{"data-svelte-h":!0}),l(u)!=="svelte-dcsdl5"&&(u.innerHTML=et),$=i(t),M=o(t,"P",{"data-svelte-h":!0}),l(M)!=="svelte-rxgnrl"&&(M.innerHTML=dt),L=i(t),T=o(t,"P",{"data-svelte-h":!0}),l(T)!=="svelte-quozw1"&&(T.innerHTML=rt),C=i(t),p=o(t,"DIV",{class:!0,"data-svelte-h":!0}),l(p)!=="svelte-ng3g1s"&&(p.innerHTML=nt),P=i(t),g=o(t,"P",{"data-svelte-h":!0}),l(g)!=="svelte-1skh0rp"&&(g.innerHTML=it),I=i(t),q(b.$$.fragment,t),j=i(t),w=o(t,"P",{"data-svelte-h":!0}),l(w)!=="svelte-13mdl1p"&&(w.innerHTML=st),G=i(t),q(y.$$.fragment,t),V=i(t),v=o(t,"P",{"data-svelte-h":!0}),l(v)!=="svelte-5yzaqq"&&(v.innerHTML=ot),W=i(t),O=o(t,"TABLE",{"data-svelte-h":!0}),l(O)!=="svelte-1dvc6a"&&(O.innerHTML=lt),z=i(t),J=o(t,"P",{"data-svelte-h":!0}),l(J)!=="svelte-v0a950"&&(J.innerHTML=at),E=i(t),B=o(t,"P",{}),pt(B).forEach(d),this.h()},h(){X(a,"name","hf:doc:metadata"),X(a,"content",yt),X(p,"class","flex justify-center")},m(t,e){bt(document.head,a),r(t,H,e),r(t,U,e),r(t,x,e),Q(f,t,e),r(t,Z,e),r(t,m,e),r(t,_,e),r(t,c,e),r(t,k,e),Q(h,t,e),r(t,S,e),r(t,u,e),r(t,$,e),r(t,M,e),r(t,L,e),r(t,T,e),r(t,C,e),r(t,p,e),r(t,P,e),r(t,g,e),r(t,I,e),Q(b,t,e),r(t,j,e),r(t,w,e),r(t,G,e),Q(y,t,e),r(t,V,e),r(t,v,e),r(t,W,e),r(t,O,e),r(t,z,e),r(t,J,e),r(t,E,e),r(t,B,e),F=!0},p:ht,i(t){F||(R(f.$$.fragment,t),R(h.$$.fragment,t),R(b.$$.fragment,t),R(y.$$.fragment,t),F=!0)},o(t){Y(f.$$.fragment,t),Y(h.$$.fragment,t),Y(b.$$.fragment,t),Y(y.$$.fragment,t),F=!1},d(t){t&&(d(H),d(U),d(x),d(Z),d(m),d(_),d(c),d(k),d(S),d(u),d($),d(M),d(L),d(T),d(C),d(p),d(P),d(g),d(I),d(j),d(w),d(G),d(V),d(v),d(W),d(O),d(z),d(J),d(E),d(B)),d(a),A(f,t),A(h,t),A(b,t),A(y,t)}}}const yt='{"title":"Token merging","local":"token-merging","sections":[{"title":"Benchmarks","local":"benchmarks","sections":[],"depth":2}],"depth":1}';function vt(D){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends Mt{constructor(a){super(),Tt(this,a,vt,wt,ct,{})}}export{Ht as component};
