import{s as to,o as no,n as yn}from"../chunks/scheduler.182ea377.js";import{S as oo,i as so,g as r,s as o,r as m,A as io,h as l,f as t,c as s,j as V,u as f,x as d,k as Z,y as i,a,v as u,d as g,t as h,w as _}from"../chunks/index.abf12888.js";import{T as ao}from"../chunks/Tip.230e2334.js";import{D as $}from"../chunks/Docstring.93f6f462.js";import{C as Pe}from"../chunks/CodeBlock.57fe6e13.js";import{E as eo}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Se}from"../chunks/Heading.16916d63.js";function ro(G){let c,j="🧪 This pipeline is for research purposes only.";return{c(){c=r("p"),c.textContent=j},l(y){c=l(y,"P",{"data-svelte-h":!0}),d(c)!=="svelte-1r9f87h"&&(c.textContent=j)},m(y,T){a(y,c,T)},p:yn,d(y){y&&t(c)}}}function lo(G){let c,j="Examples:",y,T,x;return T=new Pe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9TRFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b192aWRlbyUwQSUwQXBpcGUlMjAlM0QlMjBUZXh0VG9WaWRlb1NEUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRhbW8tdmlsYWIlMkZ0ZXh0LXRvLXZpZGVvLW1zLTEuN2IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyU3BpZGVybWFuJTIwaXMlMjBzdXJmaW5nJTIyJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQpLmZyYW1lcyUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzKSUwQXZpZGVvX3BhdGg=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> TextToVideoSDPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = TextToVideoSDPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt).frames
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path`,wrap:!1}}),{c(){c=r("p"),c.textContent=j,y=o(),m(T.$$.fragment)},l(p){c=l(p,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=j),y=s(p),f(T.$$.fragment,p)},m(p,J){a(p,c,J),a(p,y,J),u(T,p,J),x=!0},p:yn,i(p){x||(g(T.$$.fragment,p),x=!0)},o(p){h(T.$$.fragment,p),x=!1},d(p){p&&(t(c),t(y)),_(T,p)}}}function po(G){let c,j="Examples:",y,T,x;return T=new Pe({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_576w&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;spiderman running in the desert&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt, num_inference_steps=<span class="hljs-number">40</span>, height=<span class="hljs-number">320</span>, width=<span class="hljs-number">576</span>, num_frames=<span class="hljs-number">24</span>).frames
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># safe low-res video</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames, output_video_path=<span class="hljs-string">&quot;./video_576_spiderman.mp4&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s offload the text-to-image model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cpu&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and load the image-to-image model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;cerspense/zeroscope_v2_XL&quot;</span>, torch_dtype=torch.float16, revision=<span class="hljs-string">&quot;refs/pr/15&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The VAE consumes A LOT of memory, let&#x27;s make sure we run it in sliced mode</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_slicing()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now let&#x27;s upscale it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video = [Image.fromarray(frame).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>)) <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> video_frames]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and denoise it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt, video=video, strength=<span class="hljs-number">0.6</span>).frames
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames, output_video_path=<span class="hljs-string">&quot;./video_1024_spiderman.mp4&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path`,wrap:!1}}),{c(){c=r("p"),c.textContent=j,y=o(),m(T.$$.fragment)},l(p){c=l(p,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=j),y=s(p),f(T.$$.fragment,p)},m(p,J){a(p,c,J),a(p,y,J),u(T,p,J),x=!0},p:yn,i(p){x||(g(T.$$.fragment,p),x=!0)},o(p){h(T.$$.fragment,p),x=!1},d(p){p&&(t(c),t(y)),_(T,p)}}}function co(G){let c,j,y,T,x,p,J,nt,H,wn='<a href="https://huggingface.co/papers/2303.08320" rel="nofollow">VideoFusion: Decomposed Diffusion Models for High-Quality Video Generation</a> is by Zhengxiong Luo, Dayou Chen, Yingya Zhang, Yan Huang, Liang Wang, Yujun Shen, Deli Zhao, Jingren Zhou, Tieniu Tan.',ot,Y,xn="The abstract from the paper is:",st,A,Mn="<em>A diffusion probabilistic model (DPM), which constructs a forward diffusion process by gradually adding noise to data points and learns the reverse denoising process to generate new samples, has been shown to handle complex data distribution. Despite its recent success in image synthesis, applying DPMs to video generation is still challenging due to high-dimensional data spaces. Previous methods usually adopt a standard diffusion process, where frames in the same video clip are destroyed with independent noises, ignoring the content redundancy and temporal correlation. This work presents a decomposed diffusion process via resolving the per-frame noise into a base noise that is shared among all frames and a residual noise that varies along the time axis. The denoising pipeline employs two jointly-learned networks to match the noise decomposition accordingly. Experiments on various datasets confirm that our approach, termed as VideoFusion, surpasses both GAN-based and diffusion-based alternatives in high-quality video generation. We further show that our decomposed formulation can benefit from pre-trained image diffusion models and well-support text-conditioned video creation.</em>",it,Q,Vn='You can find additional information about Text-to-Video on the <a href="https://modelscope.cn/models/damo/text-to-video-synthesis/summary" rel="nofollow">project page</a>, <a href="https://github.com/modelscope/modelscope/" rel="nofollow">original codebase</a>, and try it out in a <a href="https://huggingface.co/spaces/damo-vilab/modelscope-text-to-video-synthesis" rel="nofollow">demo</a>. Official checkpoints can be found at <a href="https://huggingface.co/damo-vilab" rel="nofollow">damo-vilab</a> and <a href="https://huggingface.co/cerspense" rel="nofollow">cerspense</a>.',at,q,rt,O,lt,K,Zn="Let’s start by generating a short video with the default length of 16 frames (2s at 8 fps):",dt,ee,pt,te,Jn=`Diffusers supports different optimization techniques to improve the latency
and memory footprint of a pipeline. Since videos are often more memory-heavy than images,
we can enable CPU offloading and VAE slicing to keep the memory footprint at bay.`,ct,ne,$n="Let’s generate a video of 8 seconds (64 frames) on the same GPU using CPU offloading and VAE slicing:",mt,oe,ft,se,jn="It just takes <strong>7 GBs of GPU memory</strong> to generate the 64 video frames using PyTorch 2.0, “fp16” precision and the techniques mentioned above.",ut,ie,kn="We can also use a different scheduler easily, using the same method we’d use for Stable Diffusion:",gt,ae,ht,re,Dn="Here are some sample outputs:",_t,le,Un=`<tbody><tr><td><center>An astronaut riding a horse.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/astr.gif" alt="An astronaut riding a horse." style="width: 300px;"/></center></td> <td><center>Darth vader surfing in waves.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/vader.gif" alt="Darth vader surfing in waves." style="width: 300px;"/></center></td></tr></tbody>`,vt,de,bt,pe,Cn=`Zeroscope are watermark-free model and have been trained on specific sizes such as <code>576x320</code> and <code>1024x576</code>.
One should first generate a video using the lower resolution checkpoint <a href="https://huggingface.co/cerspense/zeroscope_v2_576w" rel="nofollow"><code>cerspense/zeroscope_v2_576w</code></a> with <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.TextToVideoSDPipeline">TextToVideoSDPipeline</a>,
which can then be upscaled using <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.VideoToVideoSDPipeline">VideoToVideoSDPipeline</a> and <a href="https://huggingface.co/cerspense/zeroscope_v2_XL" rel="nofollow"><code>cerspense/zeroscope_v2_XL</code></a>.`,Tt,ce,yt,me,Gn="Now the video can be upscaled:",wt,fe,xt,ue,Sn="Here are some sample outputs:",Mt,ge,Pn=`<tbody><tr><td><center>Darth vader surfing in waves.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/darthvader_cerpense.gif" alt="Darth vader surfing in waves." style="width: 576px;"/></center></td></tr></tbody>`,Vt,he,Zt,v,_e,Et,We,Wn="Pipeline for text-to-video generation.",Nt,Ie,In=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Rt,k,ve,Ft,Be,Bn="The call function to the pipeline for generation.",Ht,S,Yt,P,be,At,Xe,Xn=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Qt,W,Te,qt,Le,Ln=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ot,I,ye,Kt,ze,zn=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,en,B,we,tn,Ee,En=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,nn,X,xe,on,Ne,Nn="Encodes the prompt into text encoder hidden states.",Jt,Me,$t,b,Ve,sn,Re,Rn="Pipeline for text-guided video-to-video generation.",an,Fe,Fn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,rn,D,Ze,ln,He,Hn="The call function to the pipeline for generation.",dn,L,pn,z,Je,cn,Ye,Yn=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,mn,E,$e,fn,Ae,An=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,un,N,je,gn,Qe,Qn=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,hn,R,ke,_n,qe,qn=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,vn,F,De,bn,Oe,On="Encodes the prompt into text encoder hidden states.",jt,Ue,kt,U,Ce,Tn,Ke,Kn="Output class for text-to-video pipelines.",Dt,tt,Ut;return x=new ao({props:{warning:!0,$$slots:{default:[ro]},$$scope:{ctx:G}}}),J=new Se({props:{title:"Text-to-video",local:"text-to-video",headingTag:"h1"}}),q=new Se({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),O=new Se({props:{title:"text-to-video-ms-1.7b",local:"text-to-video-ms-17b",headingTag:"h3"}}),ee=new Pe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJTcGlkZXJtYW4lMjBpcyUyMHN1cmZpbmclMjIlMEF2aWRlb19mcmFtZXMlMjAlM0QlMjBwaXBlKHByb21wdCkuZnJhbWVzJTBBdmlkZW9fcGF0aCUyMCUzRCUyMGV4cG9ydF90b192aWRlbyh2aWRlb19mcmFtZXMpJTBBdmlkZW9fcGF0aA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
video_frames = pipe(prompt).frames
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),oe=new Pe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMG1lbW9yeSUyMG9wdGltaXphdGlvbiUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJEYXJ0aCUyMFZhZGVyJTIwc3VyZmluZyUyMGElMjB3YXZlJTIyJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1fZnJhbWVzJTNENjQpLmZyYW1lcyUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzKSUwQXZpZGVvX3BhdGg=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.enable_vae_slicing()

prompt = <span class="hljs-string">&quot;Darth Vader surfing a wave&quot;</span>
video_frames = pipe(prompt, num_frames=<span class="hljs-number">64</span>).frames
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),ae=new Pe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJTcGlkZXJtYW4lMjBpcyUyMHN1cmZpbmclMjIlMEF2aWRlb19mcmFtZXMlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuZnJhbWVzJTBBdmlkZW9fcGF0aCUyMCUzRCUyMGV4cG9ydF90b192aWRlbyh2aWRlb19mcmFtZXMpJTBBdmlkZW9fcGF0aA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
video_frames = pipe(prompt, num_inference_steps=<span class="hljs-number">25</span>).frames
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),de=new Se({props:{title:"cerspense/zeroscope_v2_576w & cerspense/zeroscope_v2_XL",local:"cerspensezeroscopev2576w--cerspensezeroscopev2xl",headingTag:"h3"}}),ce=new Pe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJjZXJzcGVuc2UlMkZ6ZXJvc2NvcGVfdjJfNTc2dyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBJTIzJTIwbWVtb3J5JTIwb3B0aW1pemF0aW9uJTBBcGlwZS51bmV0LmVuYWJsZV9mb3J3YXJkX2NodW5raW5nKGNodW5rX3NpemUlM0QxJTJDJTIwZGltJTNEMSklMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyRGFydGglMjBWYWRlciUyMHN1cmZpbmclMjBhJTIwd2F2ZSUyMiUwQXZpZGVvX2ZyYW1lcyUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2ZyYW1lcyUzRDI0KS5mcmFtZXMlMEF2aWRlb19wYXRoJTIwJTNEJTIwZXhwb3J0X3RvX3ZpZGVvKHZpZGVvX2ZyYW1lcyklMEF2aWRlb19wYXRo",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_576w&quot;</span>, torch_dtype=torch.float16)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.unet.enable_forward_chunking(chunk_size=<span class="hljs-number">1</span>, dim=<span class="hljs-number">1</span>)
pipe.enable_vae_slicing()

prompt = <span class="hljs-string">&quot;Darth Vader surfing a wave&quot;</span>
video_frames = pipe(prompt, num_frames=<span class="hljs-number">24</span>).frames
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),fe=new Pe({props:{code:"cGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJjZXJzcGVuc2UlMkZ6ZXJvc2NvcGVfdjJfWEwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEElMjMlMjBtZW1vcnklMjBvcHRpbWl6YXRpb24lMEFwaXBlLnVuZXQuZW5hYmxlX2ZvcndhcmRfY2h1bmtpbmcoY2h1bmtfc2l6ZSUzRDElMkMlMjBkaW0lM0QxKSUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEElMEF2aWRlbyUyMCUzRCUyMCU1QkltYWdlLmZyb21hcnJheShmcmFtZSkucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMjBmb3IlMjBmcmFtZSUyMGluJTIwdmlkZW9fZnJhbWVzJTVEJTBBJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjB2aWRlbyUzRHZpZGVvJTJDJTIwc3RyZW5ndGglM0QwLjYpLmZyYW1lcyUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzKSUwQXZpZGVvX3BhdGg=",highlighted:`pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_XL&quot;</span>, torch_dtype=torch.float16)
pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.unet.enable_forward_chunking(chunk_size=<span class="hljs-number">1</span>, dim=<span class="hljs-number">1</span>)
pipe.enable_vae_slicing()

video = [Image.fromarray(frame).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>)) <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> video_frames]

video_frames = pipe(prompt, video=video, strength=<span class="hljs-number">0.6</span>).frames
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),he=new Se({props:{title:"TextToVideoSDPipeline",local:"diffusers.TextToVideoSDPipeline",headingTag:"h2"}}),_e=new $({props:{name:"class diffusers.TextToVideoSDPipeline",anchor:"diffusers.TextToVideoSDPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet3DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.TextToVideoSDPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.TextToVideoSDPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.TextToVideoSDPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.TextToVideoSDPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L72"}}),ve=new $({props:{name:"__call__",anchor:"diffusers.TextToVideoSDPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_frames",val:": int = 16"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 9.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L475",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),S=new eo({props:{anchor:"diffusers.TextToVideoSDPipeline.__call__.example",$$slots:{default:[lo]},$$scope:{ctx:G}}}),be=new $({props:{name:"disable_vae_slicing",anchor:"diffusers.TextToVideoSDPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L122"}}),Te=new $({props:{name:"disable_vae_tiling",anchor:"diffusers.TextToVideoSDPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L139"}}),ye=new $({props:{name:"enable_vae_slicing",anchor:"diffusers.TextToVideoSDPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L114"}}),we=new $({props:{name:"enable_vae_tiling",anchor:"diffusers.TextToVideoSDPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L130"}}),xe=new $({props:{name:"encode_prompt",anchor:"diffusers.TextToVideoSDPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L180"}}),Me=new Se({props:{title:"VideoToVideoSDPipeline",local:"diffusers.VideoToVideoSDPipeline",headingTag:"h2"}}),Ve=new $({props:{name:"class diffusers.VideoToVideoSDPipeline",anchor:"diffusers.VideoToVideoSDPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet3DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.VideoToVideoSDPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.VideoToVideoSDPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.VideoToVideoSDPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.VideoToVideoSDPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L134"}}),Ze=new $({props:{name:"__call__",anchor:"diffusers.VideoToVideoSDPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"video",val:": typing.Union[typing.List[numpy.ndarray], torch.FloatTensor] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 15.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.video",description:`<strong>video</strong> (<code>List[np.ndarray]</code> or <code>torch.FloatTensor</code>) &#x2014;
<code>video</code> frames or tensor representing a video batch to be used as the starting point for the process.
Can also accept video latents as <code>image</code>, if passing latents directly, it will not be encoded again.`,name:"video"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>video</code>. Must be between 0 and 1. <code>video</code> is used as a
starting point, adding more noise to it the larger the <code>strength</code>. The number of denoising steps
depends on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the
denoising process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of
1 essentially ignores <code>video</code>.`,name:"strength"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in video generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L560",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),L=new eo({props:{anchor:"diffusers.VideoToVideoSDPipeline.__call__.example",$$slots:{default:[po]},$$scope:{ctx:G}}}),Je=new $({props:{name:"disable_vae_slicing",anchor:"diffusers.VideoToVideoSDPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L184"}}),$e=new $({props:{name:"disable_vae_tiling",anchor:"diffusers.VideoToVideoSDPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L201"}}),je=new $({props:{name:"enable_vae_slicing",anchor:"diffusers.VideoToVideoSDPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L176"}}),ke=new $({props:{name:"enable_vae_tiling",anchor:"diffusers.VideoToVideoSDPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L192"}}),De=new $({props:{name:"encode_prompt",anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L242"}}),Ue=new Se({props:{title:"TextToVideoSDPipelineOutput",local:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",headingTag:"h2"}}),Ce=new $({props:{name:"class diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",anchor:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",parameters:[{name:"frames",val:": typing.Union[typing.List[numpy.ndarray], torch.FloatTensor]"}],parametersDescription:[{anchor:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput.frames",description:`<strong>frames</strong> (<code>List[np.ndarray]</code> or <code>torch.FloatTensor</code>) &#x2014;
List of denoised frames (essentially images) as NumPy arrays of shape <code>(height, width, num_channels)</code> or as
a <code>torch</code> tensor. The length of the list denotes the video length (the number of frames).`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_output.py#L13"}}),{c(){c=r("meta"),j=o(),y=r("p"),T=o(),m(x.$$.fragment),p=o(),m(J.$$.fragment),nt=o(),H=r("p"),H.innerHTML=wn,ot=o(),Y=r("p"),Y.textContent=xn,st=o(),A=r("p"),A.innerHTML=Mn,it=o(),Q=r("p"),Q.innerHTML=Vn,at=o(),m(q.$$.fragment),rt=o(),m(O.$$.fragment),lt=o(),K=r("p"),K.textContent=Zn,dt=o(),m(ee.$$.fragment),pt=o(),te=r("p"),te.textContent=Jn,ct=o(),ne=r("p"),ne.textContent=$n,mt=o(),m(oe.$$.fragment),ft=o(),se=r("p"),se.innerHTML=jn,ut=o(),ie=r("p"),ie.textContent=kn,gt=o(),m(ae.$$.fragment),ht=o(),re=r("p"),re.textContent=Dn,_t=o(),le=r("table"),le.innerHTML=Un,vt=o(),m(de.$$.fragment),bt=o(),pe=r("p"),pe.innerHTML=Cn,Tt=o(),m(ce.$$.fragment),yt=o(),me=r("p"),me.textContent=Gn,wt=o(),m(fe.$$.fragment),xt=o(),ue=r("p"),ue.textContent=Sn,Mt=o(),ge=r("table"),ge.innerHTML=Pn,Vt=o(),m(he.$$.fragment),Zt=o(),v=r("div"),m(_e.$$.fragment),Et=o(),We=r("p"),We.textContent=Wn,Nt=o(),Ie=r("p"),Ie.innerHTML=In,Rt=o(),k=r("div"),m(ve.$$.fragment),Ft=o(),Be=r("p"),Be.textContent=Bn,Ht=o(),m(S.$$.fragment),Yt=o(),P=r("div"),m(be.$$.fragment),At=o(),Xe=r("p"),Xe.innerHTML=Xn,Qt=o(),W=r("div"),m(Te.$$.fragment),qt=o(),Le=r("p"),Le.innerHTML=Ln,Ot=o(),I=r("div"),m(ye.$$.fragment),Kt=o(),ze=r("p"),ze.textContent=zn,en=o(),B=r("div"),m(we.$$.fragment),tn=o(),Ee=r("p"),Ee.textContent=En,nn=o(),X=r("div"),m(xe.$$.fragment),on=o(),Ne=r("p"),Ne.textContent=Nn,Jt=o(),m(Me.$$.fragment),$t=o(),b=r("div"),m(Ve.$$.fragment),sn=o(),Re=r("p"),Re.textContent=Rn,an=o(),Fe=r("p"),Fe.innerHTML=Fn,rn=o(),D=r("div"),m(Ze.$$.fragment),ln=o(),He=r("p"),He.textContent=Hn,dn=o(),m(L.$$.fragment),pn=o(),z=r("div"),m(Je.$$.fragment),cn=o(),Ye=r("p"),Ye.innerHTML=Yn,mn=o(),E=r("div"),m($e.$$.fragment),fn=o(),Ae=r("p"),Ae.innerHTML=An,un=o(),N=r("div"),m(je.$$.fragment),gn=o(),Qe=r("p"),Qe.textContent=Qn,hn=o(),R=r("div"),m(ke.$$.fragment),_n=o(),qe=r("p"),qe.textContent=qn,vn=o(),F=r("div"),m(De.$$.fragment),bn=o(),Oe=r("p"),Oe.textContent=On,jt=o(),m(Ue.$$.fragment),kt=o(),U=r("div"),m(Ce.$$.fragment),Tn=o(),Ke=r("p"),Ke.textContent=Kn,Dt=o(),tt=r("p"),this.h()},l(e){const n=io("svelte-u9bgzb",document.head);c=l(n,"META",{name:!0,content:!0}),n.forEach(t),j=s(e),y=l(e,"P",{}),V(y).forEach(t),T=s(e),f(x.$$.fragment,e),p=s(e),f(J.$$.fragment,e),nt=s(e),H=l(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-1gxmldy"&&(H.innerHTML=wn),ot=s(e),Y=l(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1cwsb16"&&(Y.textContent=xn),st=s(e),A=l(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-1t7ua5b"&&(A.innerHTML=Mn),it=s(e),Q=l(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-9292p9"&&(Q.innerHTML=Vn),at=s(e),f(q.$$.fragment,e),rt=s(e),f(O.$$.fragment,e),lt=s(e),K=l(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-a4ktac"&&(K.textContent=Zn),dt=s(e),f(ee.$$.fragment,e),pt=s(e),te=l(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1gwbshq"&&(te.textContent=Jn),ct=s(e),ne=l(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-yoc5w4"&&(ne.textContent=$n),mt=s(e),f(oe.$$.fragment,e),ft=s(e),se=l(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-m9rmsr"&&(se.innerHTML=jn),ut=s(e),ie=l(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1yxs7ur"&&(ie.textContent=kn),gt=s(e),f(ae.$$.fragment,e),ht=s(e),re=l(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1g617uu"&&(re.textContent=Dn),_t=s(e),le=l(e,"TABLE",{"data-svelte-h":!0}),d(le)!=="svelte-5s26g4"&&(le.innerHTML=Un),vt=s(e),f(de.$$.fragment,e),bt=s(e),pe=l(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-iil1ky"&&(pe.innerHTML=Cn),Tt=s(e),f(ce.$$.fragment,e),yt=s(e),me=l(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-4ywac8"&&(me.textContent=Gn),wt=s(e),f(fe.$$.fragment,e),xt=s(e),ue=l(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1g617uu"&&(ue.textContent=Sn),Mt=s(e),ge=l(e,"TABLE",{"data-svelte-h":!0}),d(ge)!=="svelte-9iw63g"&&(ge.innerHTML=Pn),Vt=s(e),f(he.$$.fragment,e),Zt=s(e),v=l(e,"DIV",{class:!0});var w=V(v);f(_e.$$.fragment,w),Et=s(w),We=l(w,"P",{"data-svelte-h":!0}),d(We)!=="svelte-19ipoo4"&&(We.textContent=Wn),Nt=s(w),Ie=l(w,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-496sm0"&&(Ie.innerHTML=In),Rt=s(w),k=l(w,"DIV",{class:!0});var C=V(k);f(ve.$$.fragment,C),Ft=s(C),Be=l(C,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-50j04k"&&(Be.textContent=Bn),Ht=s(C),f(S.$$.fragment,C),C.forEach(t),Yt=s(w),P=l(w,"DIV",{class:!0});var Ge=V(P);f(be.$$.fragment,Ge),At=s(Ge),Xe=l(Ge,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-1s3c06i"&&(Xe.innerHTML=Xn),Ge.forEach(t),Qt=s(w),W=l(w,"DIV",{class:!0});var Ct=V(W);f(Te.$$.fragment,Ct),qt=s(Ct),Le=l(Ct,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-pkn4ui"&&(Le.innerHTML=Ln),Ct.forEach(t),Ot=s(w),I=l(w,"DIV",{class:!0});var Gt=V(I);f(ye.$$.fragment,Gt),Kt=s(Gt),ze=l(Gt,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-14bnrb6"&&(ze.textContent=zn),Gt.forEach(t),en=s(w),B=l(w,"DIV",{class:!0});var St=V(B);f(we.$$.fragment,St),tn=s(St),Ee=l(St,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-1xwrf7t"&&(Ee.textContent=En),St.forEach(t),nn=s(w),X=l(w,"DIV",{class:!0});var Pt=V(X);f(xe.$$.fragment,Pt),on=s(Pt),Ne=l(Pt,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-16q0ax1"&&(Ne.textContent=Nn),Pt.forEach(t),w.forEach(t),Jt=s(e),f(Me.$$.fragment,e),$t=s(e),b=l(e,"DIV",{class:!0});var M=V(b);f(Ve.$$.fragment,M),sn=s(M),Re=l(M,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-1oyadpc"&&(Re.textContent=Rn),an=s(M),Fe=l(M,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-496sm0"&&(Fe.innerHTML=Fn),rn=s(M),D=l(M,"DIV",{class:!0});var et=V(D);f(Ze.$$.fragment,et),ln=s(et),He=l(et,"P",{"data-svelte-h":!0}),d(He)!=="svelte-50j04k"&&(He.textContent=Hn),dn=s(et),f(L.$$.fragment,et),et.forEach(t),pn=s(M),z=l(M,"DIV",{class:!0});var Wt=V(z);f(Je.$$.fragment,Wt),cn=s(Wt),Ye=l(Wt,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-1s3c06i"&&(Ye.innerHTML=Yn),Wt.forEach(t),mn=s(M),E=l(M,"DIV",{class:!0});var It=V(E);f($e.$$.fragment,It),fn=s(It),Ae=l(It,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-pkn4ui"&&(Ae.innerHTML=An),It.forEach(t),un=s(M),N=l(M,"DIV",{class:!0});var Bt=V(N);f(je.$$.fragment,Bt),gn=s(Bt),Qe=l(Bt,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-14bnrb6"&&(Qe.textContent=Qn),Bt.forEach(t),hn=s(M),R=l(M,"DIV",{class:!0});var Xt=V(R);f(ke.$$.fragment,Xt),_n=s(Xt),qe=l(Xt,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1xwrf7t"&&(qe.textContent=qn),Xt.forEach(t),vn=s(M),F=l(M,"DIV",{class:!0});var Lt=V(F);f(De.$$.fragment,Lt),bn=s(Lt),Oe=l(Lt,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-16q0ax1"&&(Oe.textContent=On),Lt.forEach(t),M.forEach(t),jt=s(e),f(Ue.$$.fragment,e),kt=s(e),U=l(e,"DIV",{class:!0});var zt=V(U);f(Ce.$$.fragment,zt),Tn=s(zt),Ke=l(zt,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-1uuckb2"&&(Ke.textContent=Kn),zt.forEach(t),Dt=s(e),tt=l(e,"P",{}),V(tt).forEach(t),this.h()},h(){Z(c,"name","hf:doc:metadata"),Z(c,"content",mo),Z(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){i(document.head,c),a(e,j,n),a(e,y,n),a(e,T,n),u(x,e,n),a(e,p,n),u(J,e,n),a(e,nt,n),a(e,H,n),a(e,ot,n),a(e,Y,n),a(e,st,n),a(e,A,n),a(e,it,n),a(e,Q,n),a(e,at,n),u(q,e,n),a(e,rt,n),u(O,e,n),a(e,lt,n),a(e,K,n),a(e,dt,n),u(ee,e,n),a(e,pt,n),a(e,te,n),a(e,ct,n),a(e,ne,n),a(e,mt,n),u(oe,e,n),a(e,ft,n),a(e,se,n),a(e,ut,n),a(e,ie,n),a(e,gt,n),u(ae,e,n),a(e,ht,n),a(e,re,n),a(e,_t,n),a(e,le,n),a(e,vt,n),u(de,e,n),a(e,bt,n),a(e,pe,n),a(e,Tt,n),u(ce,e,n),a(e,yt,n),a(e,me,n),a(e,wt,n),u(fe,e,n),a(e,xt,n),a(e,ue,n),a(e,Mt,n),a(e,ge,n),a(e,Vt,n),u(he,e,n),a(e,Zt,n),a(e,v,n),u(_e,v,null),i(v,Et),i(v,We),i(v,Nt),i(v,Ie),i(v,Rt),i(v,k),u(ve,k,null),i(k,Ft),i(k,Be),i(k,Ht),u(S,k,null),i(v,Yt),i(v,P),u(be,P,null),i(P,At),i(P,Xe),i(v,Qt),i(v,W),u(Te,W,null),i(W,qt),i(W,Le),i(v,Ot),i(v,I),u(ye,I,null),i(I,Kt),i(I,ze),i(v,en),i(v,B),u(we,B,null),i(B,tn),i(B,Ee),i(v,nn),i(v,X),u(xe,X,null),i(X,on),i(X,Ne),a(e,Jt,n),u(Me,e,n),a(e,$t,n),a(e,b,n),u(Ve,b,null),i(b,sn),i(b,Re),i(b,an),i(b,Fe),i(b,rn),i(b,D),u(Ze,D,null),i(D,ln),i(D,He),i(D,dn),u(L,D,null),i(b,pn),i(b,z),u(Je,z,null),i(z,cn),i(z,Ye),i(b,mn),i(b,E),u($e,E,null),i(E,fn),i(E,Ae),i(b,un),i(b,N),u(je,N,null),i(N,gn),i(N,Qe),i(b,hn),i(b,R),u(ke,R,null),i(R,_n),i(R,qe),i(b,vn),i(b,F),u(De,F,null),i(F,bn),i(F,Oe),a(e,jt,n),u(Ue,e,n),a(e,kt,n),a(e,U,n),u(Ce,U,null),i(U,Tn),i(U,Ke),a(e,Dt,n),a(e,tt,n),Ut=!0},p(e,[n]){const w={};n&2&&(w.$$scope={dirty:n,ctx:e}),x.$set(w);const C={};n&2&&(C.$$scope={dirty:n,ctx:e}),S.$set(C);const Ge={};n&2&&(Ge.$$scope={dirty:n,ctx:e}),L.$set(Ge)},i(e){Ut||(g(x.$$.fragment,e),g(J.$$.fragment,e),g(q.$$.fragment,e),g(O.$$.fragment,e),g(ee.$$.fragment,e),g(oe.$$.fragment,e),g(ae.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(fe.$$.fragment,e),g(he.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(S.$$.fragment,e),g(be.$$.fragment,e),g(Te.$$.fragment,e),g(ye.$$.fragment,e),g(we.$$.fragment,e),g(xe.$$.fragment,e),g(Me.$$.fragment,e),g(Ve.$$.fragment,e),g(Ze.$$.fragment,e),g(L.$$.fragment,e),g(Je.$$.fragment,e),g($e.$$.fragment,e),g(je.$$.fragment,e),g(ke.$$.fragment,e),g(De.$$.fragment,e),g(Ue.$$.fragment,e),g(Ce.$$.fragment,e),Ut=!0)},o(e){h(x.$$.fragment,e),h(J.$$.fragment,e),h(q.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(oe.$$.fragment,e),h(ae.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(fe.$$.fragment,e),h(he.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(S.$$.fragment,e),h(be.$$.fragment,e),h(Te.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(xe.$$.fragment,e),h(Me.$$.fragment,e),h(Ve.$$.fragment,e),h(Ze.$$.fragment,e),h(L.$$.fragment,e),h(Je.$$.fragment,e),h($e.$$.fragment,e),h(je.$$.fragment,e),h(ke.$$.fragment,e),h(De.$$.fragment,e),h(Ue.$$.fragment,e),h(Ce.$$.fragment,e),Ut=!1},d(e){e&&(t(j),t(y),t(T),t(p),t(nt),t(H),t(ot),t(Y),t(st),t(A),t(it),t(Q),t(at),t(rt),t(lt),t(K),t(dt),t(pt),t(te),t(ct),t(ne),t(mt),t(ft),t(se),t(ut),t(ie),t(gt),t(ht),t(re),t(_t),t(le),t(vt),t(bt),t(pe),t(Tt),t(yt),t(me),t(wt),t(xt),t(ue),t(Mt),t(ge),t(Vt),t(Zt),t(v),t(Jt),t($t),t(b),t(jt),t(kt),t(U),t(Dt),t(tt)),t(c),_(x,e),_(J,e),_(q,e),_(O,e),_(ee,e),_(oe,e),_(ae,e),_(de,e),_(ce,e),_(fe,e),_(he,e),_(_e),_(ve),_(S),_(be),_(Te),_(ye),_(we),_(xe),_(Me,e),_(Ve),_(Ze),_(L),_(Je),_($e),_(je),_(ke),_(De),_(Ue,e),_(Ce)}}}const mo='{"title":"Text-to-video","local":"text-to-video","sections":[{"title":"Usage example","local":"usage-example","sections":[{"title":"text-to-video-ms-1.7b","local":"text-to-video-ms-17b","sections":[],"depth":3},{"title":"cerspense/zeroscope_v2_576w & cerspense/zeroscope_v2_XL","local":"cerspensezeroscopev2576w--cerspensezeroscopev2xl","sections":[],"depth":3}],"depth":2},{"title":"TextToVideoSDPipeline","local":"diffusers.TextToVideoSDPipeline","sections":[],"depth":2},{"title":"VideoToVideoSDPipeline","local":"diffusers.VideoToVideoSDPipeline","sections":[],"depth":2},{"title":"TextToVideoSDPipelineOutput","local":"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput","sections":[],"depth":2}],"depth":1}';function fo(G){return no(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yo extends oo{constructor(c){super(),so(this,c,fo,co,to,{})}}export{yo as component};
