import{s as Po,o as Do,n as V}from"../chunks/scheduler.182ea377.js";import{S as So,i as Jo,g as r,s as i,r as h,A as ko,h as l,f as d,c as s,j as P,u as _,x as m,k as D,y as n,a as g,v as b,d as y,t as w,w as x}from"../chunks/index.abf12888.js";import{T as Rn}from"../chunks/Tip.230e2334.js";import{D as S}from"../chunks/Docstring.93f6f462.js";import{C as Ee}from"../chunks/CodeBlock.57fe6e13.js";import{E as ze}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Mt}from"../chunks/Heading.16916d63.js";function Io(M){let o,T='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',c,a,f='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){o=r("p"),o.innerHTML=T,c=i(),a=r("p"),a.innerHTML=f},l(t){o=l(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-1ue9xpl"&&(o.innerHTML=T),c=s(t),a=l(t,"P",{"data-svelte-h":!0}),m(a)!=="svelte-z4pn9c"&&(a.innerHTML=f)},m(t,$){g(t,o,$),g(t,c,$),g(t,a,$)},p:V,d(t){t&&(d(o),d(c),d(a))}}}function Uo(M){let o,T="Examples:",c,a,f;return a=new Ee({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=r("p"),o.textContent=T,c=i(),h(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=s(t),_(a.$$.fragment,t)},m(t,$){g(t,o,$),g(t,c,$),b(a,t,$),f=!0},p:V,i(t){f||(y(a.$$.fragment,t),f=!0)},o(t){w(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),x(a,t)}}}function Co(M){let o,T=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=r("p"),o.innerHTML=T},l(c){o=l(c,"P",{"data-svelte-h":!0}),m(o)!=="svelte-ackzsn"&&(o.innerHTML=T)},m(c,a){g(c,o,a)},p:V,d(c){c&&d(o)}}}function jo(M){let o,T="Examples:",c,a,f;return a=new Ee({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=r("p"),o.textContent=T,c=i(),h(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=s(t),_(a.$$.fragment,t)},m(t,$){g(t,o,$),g(t,c,$),b(a,t,$),f=!0},p:V,i(t){f||(y(a.$$.fragment,t),f=!0)},o(t){w(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),x(a,t)}}}function Zo(M){let o,T=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=r("p"),o.textContent=T},l(c){o=l(c,"P",{"data-svelte-h":!0}),m(o)!=="svelte-17p1lpg"&&(o.textContent=T)},m(c,a){g(c,o,a)},p:V,d(c){c&&d(o)}}}function Lo(M){let o,T="Examples:",c,a,f;return a=new Ee({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=T,c=i(),h(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=s(t),_(a.$$.fragment,t)},m(t,$){g(t,o,$),g(t,c,$),b(a,t,$),f=!0},p:V,i(t){f||(y(a.$$.fragment,t),f=!0)},o(t){w(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),x(a,t)}}}function Wo(M){let o,T="To load a textual inversion embedding vector in 🤗 Diffusers format:",c,a,f;return a=new Ee({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=T,c=i(),h(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-1y13ww6"&&(o.textContent=T),c=s(t),_(a.$$.fragment,t)},m(t,$){g(t,o,$),g(t,c,$),b(a,t,$),f=!0},p:V,i(t){f||(y(a.$$.fragment,t),f=!0)},o(t){w(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),x(a,t)}}}function Go(M){let o,T="locally:",c,a,f;return a=new Ee({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=T,c=i(),h(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-4c75kq"&&(o.textContent=T),c=s(t),_(a.$$.fragment,t)},m(t,$){g(t,o,$),g(t,c,$),b(a,t,$),f=!0},p:V,i(t){f||(y(a.$$.fragment,t),f=!0)},o(t){w(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),x(a,t)}}}function Fo(M){let o,T="Examples:",c,a,f;return a=new Ee({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGV2Fycmlvck1hbWE3NzclMkZPcmFuZ2VNaXhzJTJGYmxvYiUyRm1haW4lMkZNb2RlbHMlMkZBYnlzc09yYW5nZU1peCUyRkFieXNzT3JhbmdlTWl4LnNhZmV0ZW5zb3JzJTIyJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwbG9jYWwlMjBmaWxlJTBBJTIzJTIwZmlsZSUyMGlzJTIwZG93bmxvYWRlZCUyMHVuZGVyJTIwLiUyRnYxLTUtcHJ1bmVkLWVtYW9ubHkuY2twdCUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMjIuJTJGdjEtNS1wcnVuZWQtZW1hb25seSUyMiklMEElMEElMjMlMjBFbmFibGUlMjBmbG9hdDE2JTIwYW5kJTIwbW92ZSUyMHRvJTIwR1BVJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRmJsb2IlMkZtYWluJTJGdjEtNS1wcnVuZWQtZW1hb25seS5ja3B0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/WarriorMama777/OrangeMixs/blob/main/Models/AbyssOrangeMix/AbyssOrangeMix.safetensors&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from local file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># file is downloaded under ./v1-5-pruned-emaonly.ckpt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(<span class="hljs-string">&quot;./v1-5-pruned-emaonly&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable float16 and move to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned-emaonly.ckpt&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=T,c=i(),h(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=s(t),_(a.$$.fragment,t)},m(t,$){g(t,o,$),g(t,c,$),b(a,t,$),f=!0},p:V,i(t){f||(y(a.$$.fragment,t),f=!0)},o(t){w(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),x(a,t)}}}function No(M){let o,T="Examples:",c,a,f;return a=new Ee({props:{code:"aW1wb3J0JTIwamF4JTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGZsYXguamF4X3V0aWxzJTIwaW1wb3J0JTIwcmVwbGljYXRlJTBBZnJvbSUyMGZsYXgudHJhaW5pbmcuY29tbW9uX3V0aWxzJTIwaW1wb3J0JTIwc2hhcmQlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmxheFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwcmV2aXNpb24lM0QlMjJiZjE2JTIyJTJDJTIwZHR5cGUlM0RqYXgubnVtcHkuYmZsb2F0MTYlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQSUwQXBybmdfc2VlZCUyMCUzRCUyMGpheC5yYW5kb20uUFJOR0tleSgwKSUwQW51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjA1MCUwQSUwQW51bV9zYW1wbGVzJTIwJTNEJTIwamF4LmRldmljZV9jb3VudCgpJTBBcHJvbXB0JTIwJTNEJTIwbnVtX3NhbXBsZXMlMjAqJTIwJTVCcHJvbXB0JTVEJTBBcHJvbXB0X2lkcyUyMCUzRCUyMHBpcGVsaW5lLnByZXBhcmVfaW5wdXRzKHByb21wdCklMEElMEFwYXJhbXMlMjAlM0QlMjByZXBsaWNhdGUocGFyYW1zKSUwQXBybmdfc2VlZCUyMCUzRCUyMGpheC5yYW5kb20uc3BsaXQocHJuZ19zZWVkJTJDJTIwamF4LmRldmljZV9jb3VudCgpKSUwQXByb21wdF9pZHMlMjAlM0QlMjBzaGFyZChwcm9tcHRfaWRzKSUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKHByb21wdF9pZHMlMkMlMjBwYXJhbXMlMkMlMjBwcm5nX3NlZWQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTIwaml0JTNEVHJ1ZSkuaW1hZ2VzJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUubnVtcHlfdG9fcGlsKG5wLmFzYXJyYXkoaW1hZ2VzLnJlc2hhcGUoKG51bV9zYW1wbGVzJTJDKSUyMCUyQiUyMGltYWdlcy5zaGFwZSU1Qi0zJTNBJTVEKSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxStableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, revision=<span class="hljs-string">&quot;bf16&quot;</span>, dtype=jax.numpy.bfloat16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prng_seed = jax.random.PRNGKey(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">50</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>num_samples = jax.device_count()
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = num_samples * [prompt]
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = pipeline.prepare_inputs(prompt)
<span class="hljs-comment"># shard inputs and rng</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>params = replicate(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>prng_seed = jax.random.split(prng_seed, jax.device_count())
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = shard(prompt_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipeline(prompt_ids, params, prng_seed, num_inference_steps, jit=<span class="hljs-literal">True</span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipeline.numpy_to_pil(np.asarray(images.reshape((num_samples,) + images.shape[-<span class="hljs-number">3</span>:])))`,wrap:!1}}),{c(){o=r("p"),o.textContent=T,c=i(),h(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=s(t),_(a.$$.fragment,t)},m(t,$){g(t,o,$),g(t,c,$),b(a,t,$),f=!0},p:V,i(t){f||(y(a.$$.fragment,t),f=!0)},o(t){w(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),x(a,t)}}}function Bo(M){let o,T,c,a,f,t,$,Hn='The Stable Diffusion model was created by researchers and engineers from <a href="https://github.com/CompVis" rel="nofollow">CompVis</a>, <a href="https://stability.ai/" rel="nofollow">Stability AI</a>, <a href="https://github.com/runwayml" rel="nofollow">Runway</a>, and <a href="https://laion.ai/" rel="nofollow">LAION</a>. The <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> is capable of generating photorealistic images given any text input. It’s trained on 512x512 images from a subset of the LAION-5B dataset. This model uses a frozen CLIP ViT-L/14 text encoder to condition the model on text prompts. With its 860M UNet and 123M text encoder, the model is relatively lightweight and can run on consumer GPUs. Latent diffusion is the research on top of which Stable Diffusion was built. It was proposed in <a href="https://huggingface.co/papers/2112.10752" rel="nofollow">High-Resolution Image Synthesis with Latent Diffusion Models</a> by Robin Rombach, Andreas Blattmann, Dominik Lorenz, Patrick Esser, Björn Ommer.',Pt,pe,Yn="The abstract from the paper is:",Dt,fe,qn='<em>By decomposing the image formation process into a sequential application of denoising autoencoders, diffusion models (DMs) achieve state-of-the-art synthesis results on image data and beyond. Additionally, their formulation allows for a guiding mechanism to control the image generation process without retraining. However, since these models typically operate directly in pixel space, optimization of powerful DMs often consumes hundreds of GPU days and inference is expensive due to sequential evaluations. To enable DM training on limited computational resources while retaining their quality and flexibility, we apply them in the latent space of powerful pretrained autoencoders. In contrast to previous work, training diffusion models on such a representation allows for the first time to reach a near-optimal point between complexity reduction and detail preservation, greatly boosting visual fidelity. By introducing cross-attention layers into the model architecture, we turn diffusion models into powerful and flexible generators for general conditioning inputs such as text or bounding boxes and high-resolution synthesis becomes possible in a convolutional manner. Our latent diffusion models (LDMs) achieve a new state of the art for image inpainting and highly competitive performance on various tasks, including unconditional image generation, semantic scene synthesis, and super-resolution, while significantly reducing computational requirements compared to pixel-based DMs. Code is available at <a href="https://github.com/CompVis/latent-diffusion" rel="nofollow">https://github.com/CompVis/latent-diffusion</a>.</em>',St,R,Jt,me,kt,u,ue,zt,Re,Xn="Pipeline for text-to-image generation using Stable Diffusion.",Et,He,An=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Rt,Ye,Qn="The pipeline also inherits the following loading methods:",Ht,qe,On='<li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li>',Yt,F,ge,qt,Xe,Kn="The call function to the pipeline for generation.",Xt,H,At,U,he,Qt,Ae,eo=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Ot,Y,Kt,q,en,X,_e,tn,Qe,to=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,nn,A,be,on,Oe,no=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,sn,Q,ye,an,Ke,oo=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,rn,C,we,ln,et,io=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,dn,O,cn,K,pn,ee,xe,fn,tt,so='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',mn,te,ve,un,nt,ao=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,gn,ne,$e,hn,ot,ro=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,_n,J,Te,bn,it,lo=`Load textual inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,yn,st,co="Example:",wn,oe,xn,at,po=`To load a textual inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,vn,ie,$n,N,Me,Tn,rt,fo=`Instantiate a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> from pretrained pipeline weights saved in the <code>.ckpt</code> or <code>.safetensors</code>
format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.`,Mn,se,Pn,k,Pe,Dn,lt,mo=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,Sn,dt,uo="All kwargs are forwarded to <code>self.lora_state_dict</code>.",Jn,ct,go='See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',kn,pt,ho=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,In,ft,_o=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,Un,ae,De,Cn,mt,bo="Save the LoRA parameters corresponding to the UNet and text encoder.",jn,re,Se,Zn,ut,yo="Encodes the prompt into text encoder hidden states.",It,Je,Ut,z,ke,Ln,gt,wo="Output class for Stable Diffusion pipelines.",Ct,Ie,jt,I,Ue,Wn,ht,xo="Flax-based pipeline for text-to-image generation using Stable Diffusion.",Gn,_t,vo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Fn,B,Ce,Nn,bt,$o="The call function to the pipeline for generation.",Bn,le,Zt,je,Lt,L,Ze,Vn,yt,To="Output class for Flax-based Stable Diffusion pipelines.",zn,de,Le,En,wt,Mo="“Returns a new object replacing the specified fields with new values.",Wt,Tt,Gt;return f=new Mt({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h1"}}),R=new Rn({props:{$$slots:{default:[Io]},$$scope:{ctx:M}}}),me=new Mt({props:{title:"StableDiffusionPipeline",local:"diffusers.StableDiffusionPipeline",headingTag:"h2"}}),ue=new S({props:{name:"class diffusers.StableDiffusionPipeline",anchor:"diffusers.StableDiffusionPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L66"}}),ge=new S({props:{name:"__call__",anchor:"diffusers.StableDiffusionPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor from <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L540",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),H=new ze({props:{anchor:"diffusers.StableDiffusionPipeline.__call__.example",$$slots:{default:[Uo]},$$scope:{ctx:M}}}),he=new S({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[str, int, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1925"}}),Y=new Rn({props:{warning:!0,$$slots:{default:[Co]},$$scope:{ctx:M}}}),q=new ze({props:{anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[jo]},$$scope:{ctx:M}}}),_e=new S({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1965"}}),be=new S({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L192"}}),ye=new S({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L199"}}),we=new S({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1864"}}),O=new Rn({props:{warning:!0,$$slots:{default:[Zo]},$$scope:{ctx:M}}}),K=new ze({props:{anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Lo]},$$scope:{ctx:M}}}),xe=new S({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1899"}}),ve=new S({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L206"}}),$e=new S({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L214"}}),Te=new S({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, typing.List[str], typing.Dict[str, torch.Tensor], typing.List[typing.Dict[str, torch.Tensor]]]"},{name:"token",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[ForwardRef('PreTrainedTokenizer')] = None"},{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L919"}}),oe=new ze({props:{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.example",$$slots:{default:[Wo]},$$scope:{ctx:M}}}),ie=new ze({props:{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.example-2",$$slots:{default:[Go]},$$scope:{ctx:M}}}),Me=new S({props:{name:"from_single_file",anchor:"diffusers.StableDiffusionPipeline.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.extract_ema",description:`<strong>extract_ema</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to extract the EMA weights or not. Pass <code>True</code> to extract the EMA weights which usually yield
higher quality images for inference. Non-EMA weights are usually better for continuing finetuning.`,name:"extract_ema"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.upcast_attention",description:`<strong>upcast_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether the attention computation should always be upcasted.`,name:"upcast_attention"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The image size the model was trained on. Use 512 for all Stable Diffusion v1 models and the Stable
Diffusion v2 base model. Use 768 for Stable Diffusion v2.`,name:"image_size"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prediction type the model was trained on. Use <code>&apos;epsilon&apos;</code> for all Stable Diffusion v1 models and
the Stable Diffusion v2 base model. Use <code>&apos;v_prediction&apos;</code> for Stable Diffusion v2.`,name:"prediction_type"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.num_in_channels",description:`<strong>num_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The number of input channels. If <code>None</code>, it is automatically inferred.`,name:"num_in_channels"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.scheduler_type",description:`<strong>scheduler_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pndm&quot;</code>) &#x2014;
Type of scheduler to use. Should be one of <code>[&quot;pndm&quot;, &quot;lms&quot;, &quot;heun&quot;, &quot;euler&quot;, &quot;euler-ancestral&quot;, &quot;dpm&quot;, &quot;ddim&quot;]</code>.`,name:"scheduler_type"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.load_safety_checker",description:`<strong>load_safety_checker</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to load the safety checker or not.`,name:"load_safety_checker"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An instance of <code>CLIPTextModel</code> to use, specifically the
<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant. If this
parameter is <code>None</code>, the function loads a new instance of <code>CLIPTextModel</code> by itself if needed.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.vae",description:`<strong>vae</strong> (<code>AutoencoderKL</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations. If
this parameter is <code>None</code>, the function will load a new instance of [CLIP] by itself, if needed.`,name:"vae"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An instance of <code>CLIPTokenizer</code> to use. If this parameter is <code>None</code>, the function loads a new instance
of <code>CLIPTokenizer</code> by itself if needed.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.original_config_file",description:`<strong>original_config_file</strong> (<code>str</code>) &#x2014;
Path to <code>.yaml</code> config file corresponding to the original architecture. If <code>None</code>, will be
automatically inferred by looking for a key that only exists in SD2.0 models.`,name:"original_config_file"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (for example the pipeline components of the
specific pipeline class). The overwritten components are directly passed to the pipelines <code>__init__</code>
method. See example below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L2291"}}),se=new ze({props:{anchor:"diffusers.StableDiffusionPipeline.from_single_file.example",$$slots:{default:[Fo]},$$scope:{ctx:M}}}),Pe=new S({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L1109"}}),De=new S({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"unet_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"text_encoder_lora_layers",val:": typing.Dict[str, torch.nn.modules.module.Module] = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L1806"}}),Se=new S({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L253"}}),Je=new Mt({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),ke=new S({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L11"}}),Ie=new Mt({props:{title:"FlaxStableDiffusionPipeline",local:"diffusers.FlaxStableDiffusionPipeline",headingTag:"h2"}}),Ue=new S({props:{name:"class diffusers.FlaxStableDiffusionPipeline",anchor:"diffusers.FlaxStableDiffusionPipeline",parameters:[{name:"vae",val:": FlaxAutoencoderKL"},{name:"text_encoder",val:": FlaxCLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": FlaxUNet2DConditionModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim_flax.FlaxDDIMScheduler, diffusers.schedulers.scheduling_pndm_flax.FlaxPNDMScheduler, diffusers.schedulers.scheduling_lms_discrete_flax.FlaxLMSDiscreteScheduler, diffusers.schedulers.scheduling_dpmsolver_multistep_flax.FlaxDPMSolverMultistepScheduler]"},{name:"safety_checker",val:": FlaxStableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.FlaxAutoencoderKL">FlaxAutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FlaxStableDiffusionPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.FlaxCLIPTextModel" rel="nofollow">FlaxCLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.FlaxStableDiffusionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.FlaxStableDiffusionPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.FlaxUNet2DConditionModel">FlaxUNet2DConditionModel</a>) &#x2014;
A <code>FlaxUNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.FlaxStableDiffusionPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<code>FlaxDDIMScheduler</code>, <code>FlaxLMSDiscreteScheduler</code>, <code>FlaxPNDMScheduler</code>, or
<code>FlaxDPMSolverMultistepScheduler</code>.`,name:"scheduler"},{anchor:"diffusers.FlaxStableDiffusionPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>FlaxStableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.FlaxStableDiffusionPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion.py#L81"}}),Ce=new S({props:{name:"__call__",anchor:"diffusers.FlaxStableDiffusionPipeline.__call__",parameters:[{name:"prompt_ids",val:": array"},{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"prng_seed",val:": PRNGKeyArray"},{name:"num_inference_steps",val:": int = 50"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Union[float, array] = 7.5"},{name:"latents",val:": array = None"},{name:"neg_prompt_ids",val:": array = None"},{name:"return_dict",val:": bool = True"},{name:"jit",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation.`,name:"prompt"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>jnp.array</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
array is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.jit",description:`<strong>jit</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to run <code>pmap</code> versions of the generation and safety scoring functions.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>This argument exists because <code>__call__</code> is not yet end-to-end pmap-able. It will be removed in a
future release.</p>

					</div>`,name:"jit"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput">FlaxStableDiffusionPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion.py#L310",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated images
and the second element is a list of <code>bool</code>s indicating whether the corresponding generated image
contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),le=new ze({props:{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.example",$$slots:{default:[No]},$$scope:{ctx:M}}}),je=new Mt({props:{title:"FlaxStableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",headingTag:"h2"}}),Ze=new S({props:{name:"class diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",parameters:[{name:"images",val:": ndarray"},{name:"nsfw_content_detected",val:": typing.List[bool]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
Denoised images of array shape of <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content
or <code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L32"}}),Le=new S({props:{name:"replace",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/flax/struct.py#L111"}}),{c(){o=r("meta"),T=i(),c=r("p"),a=i(),h(f.$$.fragment),t=i(),$=r("p"),$.innerHTML=Hn,Pt=i(),pe=r("p"),pe.textContent=Yn,Dt=i(),fe=r("p"),fe.innerHTML=qn,St=i(),h(R.$$.fragment),Jt=i(),h(me.$$.fragment),kt=i(),u=r("div"),h(ue.$$.fragment),zt=i(),Re=r("p"),Re.textContent=Xn,Et=i(),He=r("p"),He.innerHTML=An,Rt=i(),Ye=r("p"),Ye.textContent=Qn,Ht=i(),qe=r("ul"),qe.innerHTML=On,Yt=i(),F=r("div"),h(ge.$$.fragment),qt=i(),Xe=r("p"),Xe.textContent=Kn,Xt=i(),h(H.$$.fragment),At=i(),U=r("div"),h(he.$$.fragment),Qt=i(),Ae=r("p"),Ae.textContent=eo,Ot=i(),h(Y.$$.fragment),Kt=i(),h(q.$$.fragment),en=i(),X=r("div"),h(_e.$$.fragment),tn=i(),Qe=r("p"),Qe.innerHTML=to,nn=i(),A=r("div"),h(be.$$.fragment),on=i(),Oe=r("p"),Oe.textContent=no,sn=i(),Q=r("div"),h(ye.$$.fragment),an=i(),Ke=r("p"),Ke.innerHTML=oo,rn=i(),C=r("div"),h(we.$$.fragment),ln=i(),et=r("p"),et.innerHTML=io,dn=i(),h(O.$$.fragment),cn=i(),h(K.$$.fragment),pn=i(),ee=r("div"),h(xe.$$.fragment),fn=i(),tt=r("p"),tt.innerHTML=so,mn=i(),te=r("div"),h(ve.$$.fragment),un=i(),nt=r("p"),nt.textContent=ao,gn=i(),ne=r("div"),h($e.$$.fragment),hn=i(),ot=r("p"),ot.innerHTML=ro,_n=i(),J=r("div"),h(Te.$$.fragment),bn=i(),it=r("p"),it.innerHTML=lo,yn=i(),st=r("p"),st.textContent=co,wn=i(),h(oe.$$.fragment),xn=i(),at=r("p"),at.innerHTML=po,vn=i(),h(ie.$$.fragment),$n=i(),N=r("div"),h(Me.$$.fragment),Tn=i(),rt=r("p"),rt.innerHTML=fo,Mn=i(),h(se.$$.fragment),Pn=i(),k=r("div"),h(Pe.$$.fragment),Dn=i(),lt=r("p"),lt.innerHTML=mo,Sn=i(),dt=r("p"),dt.innerHTML=uo,Jn=i(),ct=r("p"),ct.innerHTML=go,kn=i(),pt=r("p"),pt.innerHTML=ho,In=i(),ft=r("p"),ft.innerHTML=_o,Un=i(),ae=r("div"),h(De.$$.fragment),Cn=i(),mt=r("p"),mt.textContent=bo,jn=i(),re=r("div"),h(Se.$$.fragment),Zn=i(),ut=r("p"),ut.textContent=yo,It=i(),h(Je.$$.fragment),Ut=i(),z=r("div"),h(ke.$$.fragment),Ln=i(),gt=r("p"),gt.textContent=wo,Ct=i(),h(Ie.$$.fragment),jt=i(),I=r("div"),h(Ue.$$.fragment),Wn=i(),ht=r("p"),ht.textContent=xo,Gn=i(),_t=r("p"),_t.innerHTML=vo,Fn=i(),B=r("div"),h(Ce.$$.fragment),Nn=i(),bt=r("p"),bt.textContent=$o,Bn=i(),h(le.$$.fragment),Zt=i(),h(je.$$.fragment),Lt=i(),L=r("div"),h(Ze.$$.fragment),Vn=i(),yt=r("p"),yt.textContent=To,zn=i(),de=r("div"),h(Le.$$.fragment),En=i(),wt=r("p"),wt.textContent=Mo,Wt=i(),Tt=r("p"),this.h()},l(e){const p=ko("svelte-u9bgzb",document.head);o=l(p,"META",{name:!0,content:!0}),p.forEach(d),T=s(e),c=l(e,"P",{}),P(c).forEach(d),a=s(e),_(f.$$.fragment,e),t=s(e),$=l(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1p4bu1q"&&($.innerHTML=Hn),Pt=s(e),pe=l(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-1cwsb16"&&(pe.textContent=Yn),Dt=s(e),fe=l(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-1xoozhu"&&(fe.innerHTML=qn),St=s(e),_(R.$$.fragment,e),Jt=s(e),_(me.$$.fragment,e),kt=s(e),u=l(e,"DIV",{class:!0});var v=P(u);_(ue.$$.fragment,v),zt=s(v),Re=l(v,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-35p306"&&(Re.textContent=Xn),Et=s(v),He=l(v,"P",{"data-svelte-h":!0}),m(He)!=="svelte-496sm0"&&(He.innerHTML=An),Rt=s(v),Ye=l(v,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-14s6m4u"&&(Ye.textContent=Qn),Ht=s(v),qe=l(v,"UL",{"data-svelte-h":!0}),m(qe)!=="svelte-1cjsv3k"&&(qe.innerHTML=On),Yt=s(v),F=l(v,"DIV",{class:!0});var E=P(F);_(ge.$$.fragment,E),qt=s(E),Xe=l(E,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-50j04k"&&(Xe.textContent=Kn),Xt=s(E),_(H.$$.fragment,E),E.forEach(d),At=s(v),U=l(v,"DIV",{class:!0});var W=P(U);_(he.$$.fragment,W),Qt=s(W),Ae=l(W,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-10jaql7"&&(Ae.textContent=eo),Ot=s(W),_(Y.$$.fragment,W),Kt=s(W),_(q.$$.fragment,W),W.forEach(d),en=s(v),X=l(v,"DIV",{class:!0});var We=P(X);_(_e.$$.fragment,We),tn=s(We),Qe=l(We,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-1lh0nh5"&&(Qe.innerHTML=to),We.forEach(d),nn=s(v),A=l(v,"DIV",{class:!0});var Ge=P(A);_(be.$$.fragment,Ge),on=s(Ge),Oe=l(Ge,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-14bnrb6"&&(Oe.textContent=no),Ge.forEach(d),sn=s(v),Q=l(v,"DIV",{class:!0});var Fe=P(Q);_(ye.$$.fragment,Fe),an=s(Fe),Ke=l(Fe,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-1s3c06i"&&(Ke.innerHTML=oo),Fe.forEach(d),rn=s(v),C=l(v,"DIV",{class:!0});var G=P(C);_(we.$$.fragment,G),ln=s(G),et=l(G,"P",{"data-svelte-h":!0}),m(et)!=="svelte-e03q3e"&&(et.innerHTML=io),dn=s(G),_(O.$$.fragment,G),cn=s(G),_(K.$$.fragment,G),G.forEach(d),pn=s(v),ee=l(v,"DIV",{class:!0});var Ne=P(ee);_(xe.$$.fragment,Ne),fn=s(Ne),tt=l(Ne,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-1vfte1e"&&(tt.innerHTML=so),Ne.forEach(d),mn=s(v),te=l(v,"DIV",{class:!0});var Be=P(te);_(ve.$$.fragment,Be),un=s(Be),nt=l(Be,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-1xwrf7t"&&(nt.textContent=ao),Be.forEach(d),gn=s(v),ne=l(v,"DIV",{class:!0});var Ve=P(ne);_($e.$$.fragment,Ve),hn=s(Ve),ot=l(Ve,"P",{"data-svelte-h":!0}),m(ot)!=="svelte-pkn4ui"&&(ot.innerHTML=ro),Ve.forEach(d),_n=s(v),J=l(v,"DIV",{class:!0});var j=P(J);_(Te.$$.fragment,j),bn=s(j),it=l(j,"P",{"data-svelte-h":!0}),m(it)!=="svelte-617c7s"&&(it.innerHTML=lo),yn=s(j),st=l(j,"P",{"data-svelte-h":!0}),m(st)!=="svelte-11lpom8"&&(st.textContent=co),wn=s(j),_(oe.$$.fragment,j),xn=s(j),at=l(j,"P",{"data-svelte-h":!0}),m(at)!=="svelte-2gddoh"&&(at.innerHTML=po),vn=s(j),_(ie.$$.fragment,j),j.forEach(d),$n=s(v),N=l(v,"DIV",{class:!0});var xt=P(N);_(Me.$$.fragment,xt),Tn=s(xt),rt=l(xt,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-pmqrln"&&(rt.innerHTML=fo),Mn=s(xt),_(se.$$.fragment,xt),xt.forEach(d),Pn=s(v),k=l(v,"DIV",{class:!0});var Z=P(k);_(Pe.$$.fragment,Z),Dn=s(Z),lt=l(Z,"P",{"data-svelte-h":!0}),m(lt)!=="svelte-vs7s0z"&&(lt.innerHTML=mo),Sn=s(Z),dt=l(Z,"P",{"data-svelte-h":!0}),m(dt)!=="svelte-15b960v"&&(dt.innerHTML=uo),Jn=s(Z),ct=l(Z,"P",{"data-svelte-h":!0}),m(ct)!=="svelte-qj05o3"&&(ct.innerHTML=go),kn=s(Z),pt=l(Z,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-ot29jq"&&(pt.innerHTML=ho),In=s(Z),ft=l(Z,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-1ah097o"&&(ft.innerHTML=_o),Z.forEach(d),Un=s(v),ae=l(v,"DIV",{class:!0});var Ft=P(ae);_(De.$$.fragment,Ft),Cn=s(Ft),mt=l(Ft,"P",{"data-svelte-h":!0}),m(mt)!=="svelte-1ufq5ot"&&(mt.textContent=bo),Ft.forEach(d),jn=s(v),re=l(v,"DIV",{class:!0});var Nt=P(re);_(Se.$$.fragment,Nt),Zn=s(Nt),ut=l(Nt,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-16q0ax1"&&(ut.textContent=yo),Nt.forEach(d),v.forEach(d),It=s(e),_(Je.$$.fragment,e),Ut=s(e),z=l(e,"DIV",{class:!0});var Bt=P(z);_(ke.$$.fragment,Bt),Ln=s(Bt),gt=l(Bt,"P",{"data-svelte-h":!0}),m(gt)!=="svelte-1qpjiuf"&&(gt.textContent=wo),Bt.forEach(d),Ct=s(e),_(Ie.$$.fragment,e),jt=s(e),I=l(e,"DIV",{class:!0});var ce=P(I);_(Ue.$$.fragment,ce),Wn=s(ce),ht=l(ce,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-d05p75"&&(ht.textContent=xo),Gn=s(ce),_t=l(ce,"P",{"data-svelte-h":!0}),m(_t)!=="svelte-knddhk"&&(_t.innerHTML=vo),Fn=s(ce),B=l(ce,"DIV",{class:!0});var vt=P(B);_(Ce.$$.fragment,vt),Nn=s(vt),bt=l(vt,"P",{"data-svelte-h":!0}),m(bt)!=="svelte-50j04k"&&(bt.textContent=$o),Bn=s(vt),_(le.$$.fragment,vt),vt.forEach(d),ce.forEach(d),Zt=s(e),_(je.$$.fragment,e),Lt=s(e),L=l(e,"DIV",{class:!0});var $t=P(L);_(Ze.$$.fragment,$t),Vn=s($t),yt=l($t,"P",{"data-svelte-h":!0}),m(yt)!=="svelte-wzv2jc"&&(yt.textContent=To),zn=s($t),de=l($t,"DIV",{class:!0});var Vt=P(de);_(Le.$$.fragment,Vt),En=s(Vt),wt=l(Vt,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-5ihtpa"&&(wt.textContent=Mo),Vt.forEach(d),$t.forEach(d),Wt=s(e),Tt=l(e,"P",{}),P(Tt).forEach(d),this.h()},h(){D(o,"name","hf:doc:metadata"),D(o,"content",Vo),D(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){n(document.head,o),g(e,T,p),g(e,c,p),g(e,a,p),b(f,e,p),g(e,t,p),g(e,$,p),g(e,Pt,p),g(e,pe,p),g(e,Dt,p),g(e,fe,p),g(e,St,p),b(R,e,p),g(e,Jt,p),b(me,e,p),g(e,kt,p),g(e,u,p),b(ue,u,null),n(u,zt),n(u,Re),n(u,Et),n(u,He),n(u,Rt),n(u,Ye),n(u,Ht),n(u,qe),n(u,Yt),n(u,F),b(ge,F,null),n(F,qt),n(F,Xe),n(F,Xt),b(H,F,null),n(u,At),n(u,U),b(he,U,null),n(U,Qt),n(U,Ae),n(U,Ot),b(Y,U,null),n(U,Kt),b(q,U,null),n(u,en),n(u,X),b(_e,X,null),n(X,tn),n(X,Qe),n(u,nn),n(u,A),b(be,A,null),n(A,on),n(A,Oe),n(u,sn),n(u,Q),b(ye,Q,null),n(Q,an),n(Q,Ke),n(u,rn),n(u,C),b(we,C,null),n(C,ln),n(C,et),n(C,dn),b(O,C,null),n(C,cn),b(K,C,null),n(u,pn),n(u,ee),b(xe,ee,null),n(ee,fn),n(ee,tt),n(u,mn),n(u,te),b(ve,te,null),n(te,un),n(te,nt),n(u,gn),n(u,ne),b($e,ne,null),n(ne,hn),n(ne,ot),n(u,_n),n(u,J),b(Te,J,null),n(J,bn),n(J,it),n(J,yn),n(J,st),n(J,wn),b(oe,J,null),n(J,xn),n(J,at),n(J,vn),b(ie,J,null),n(u,$n),n(u,N),b(Me,N,null),n(N,Tn),n(N,rt),n(N,Mn),b(se,N,null),n(u,Pn),n(u,k),b(Pe,k,null),n(k,Dn),n(k,lt),n(k,Sn),n(k,dt),n(k,Jn),n(k,ct),n(k,kn),n(k,pt),n(k,In),n(k,ft),n(u,Un),n(u,ae),b(De,ae,null),n(ae,Cn),n(ae,mt),n(u,jn),n(u,re),b(Se,re,null),n(re,Zn),n(re,ut),g(e,It,p),b(Je,e,p),g(e,Ut,p),g(e,z,p),b(ke,z,null),n(z,Ln),n(z,gt),g(e,Ct,p),b(Ie,e,p),g(e,jt,p),g(e,I,p),b(Ue,I,null),n(I,Wn),n(I,ht),n(I,Gn),n(I,_t),n(I,Fn),n(I,B),b(Ce,B,null),n(B,Nn),n(B,bt),n(B,Bn),b(le,B,null),g(e,Zt,p),b(je,e,p),g(e,Lt,p),g(e,L,p),b(Ze,L,null),n(L,Vn),n(L,yt),n(L,zn),n(L,de),b(Le,de,null),n(de,En),n(de,wt),g(e,Wt,p),g(e,Tt,p),Gt=!0},p(e,[p]){const v={};p&2&&(v.$$scope={dirty:p,ctx:e}),R.$set(v);const E={};p&2&&(E.$$scope={dirty:p,ctx:e}),H.$set(E);const W={};p&2&&(W.$$scope={dirty:p,ctx:e}),Y.$set(W);const We={};p&2&&(We.$$scope={dirty:p,ctx:e}),q.$set(We);const Ge={};p&2&&(Ge.$$scope={dirty:p,ctx:e}),O.$set(Ge);const Fe={};p&2&&(Fe.$$scope={dirty:p,ctx:e}),K.$set(Fe);const G={};p&2&&(G.$$scope={dirty:p,ctx:e}),oe.$set(G);const Ne={};p&2&&(Ne.$$scope={dirty:p,ctx:e}),ie.$set(Ne);const Be={};p&2&&(Be.$$scope={dirty:p,ctx:e}),se.$set(Be);const Ve={};p&2&&(Ve.$$scope={dirty:p,ctx:e}),le.$set(Ve)},i(e){Gt||(y(f.$$.fragment,e),y(R.$$.fragment,e),y(me.$$.fragment,e),y(ue.$$.fragment,e),y(ge.$$.fragment,e),y(H.$$.fragment,e),y(he.$$.fragment,e),y(Y.$$.fragment,e),y(q.$$.fragment,e),y(_e.$$.fragment,e),y(be.$$.fragment,e),y(ye.$$.fragment,e),y(we.$$.fragment,e),y(O.$$.fragment,e),y(K.$$.fragment,e),y(xe.$$.fragment,e),y(ve.$$.fragment,e),y($e.$$.fragment,e),y(Te.$$.fragment,e),y(oe.$$.fragment,e),y(ie.$$.fragment,e),y(Me.$$.fragment,e),y(se.$$.fragment,e),y(Pe.$$.fragment,e),y(De.$$.fragment,e),y(Se.$$.fragment,e),y(Je.$$.fragment,e),y(ke.$$.fragment,e),y(Ie.$$.fragment,e),y(Ue.$$.fragment,e),y(Ce.$$.fragment,e),y(le.$$.fragment,e),y(je.$$.fragment,e),y(Ze.$$.fragment,e),y(Le.$$.fragment,e),Gt=!0)},o(e){w(f.$$.fragment,e),w(R.$$.fragment,e),w(me.$$.fragment,e),w(ue.$$.fragment,e),w(ge.$$.fragment,e),w(H.$$.fragment,e),w(he.$$.fragment,e),w(Y.$$.fragment,e),w(q.$$.fragment,e),w(_e.$$.fragment,e),w(be.$$.fragment,e),w(ye.$$.fragment,e),w(we.$$.fragment,e),w(O.$$.fragment,e),w(K.$$.fragment,e),w(xe.$$.fragment,e),w(ve.$$.fragment,e),w($e.$$.fragment,e),w(Te.$$.fragment,e),w(oe.$$.fragment,e),w(ie.$$.fragment,e),w(Me.$$.fragment,e),w(se.$$.fragment,e),w(Pe.$$.fragment,e),w(De.$$.fragment,e),w(Se.$$.fragment,e),w(Je.$$.fragment,e),w(ke.$$.fragment,e),w(Ie.$$.fragment,e),w(Ue.$$.fragment,e),w(Ce.$$.fragment,e),w(le.$$.fragment,e),w(je.$$.fragment,e),w(Ze.$$.fragment,e),w(Le.$$.fragment,e),Gt=!1},d(e){e&&(d(T),d(c),d(a),d(t),d($),d(Pt),d(pe),d(Dt),d(fe),d(St),d(Jt),d(kt),d(u),d(It),d(Ut),d(z),d(Ct),d(jt),d(I),d(Zt),d(Lt),d(L),d(Wt),d(Tt)),d(o),x(f,e),x(R,e),x(me,e),x(ue),x(ge),x(H),x(he),x(Y),x(q),x(_e),x(be),x(ye),x(we),x(O),x(K),x(xe),x(ve),x($e),x(Te),x(oe),x(ie),x(Me),x(se),x(Pe),x(De),x(Se),x(Je,e),x(ke),x(Ie,e),x(Ue),x(Ce),x(le),x(je,e),x(Ze),x(Le)}}}const Vo='{"title":"Text-to-image","local":"text-to-image","sections":[{"title":"StableDiffusionPipeline","local":"diffusers.StableDiffusionPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2},{"title":"FlaxStableDiffusionPipeline","local":"diffusers.FlaxStableDiffusionPipeline","sections":[],"depth":2},{"title":"FlaxStableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function zo(M){return Do(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qo extends So{constructor(o){super(),Jo(this,o,zo,Bo,Po,{})}}export{Qo as component};
