import{s as st,o as at,n as fe}from"../chunks/scheduler.182ea377.js";import{S as it,i as ot,g as c,s as r,r as _,A as lt,h as d,f as i,c as p,j as D,u as y,x as U,k as Z,y as o,a as u,v as w,d as $,t as T,w as v}from"../chunks/index.abf12888.js";import{T as Ne}from"../chunks/Tip.230e2334.js";import{D as X}from"../chunks/Docstring.93f6f462.js";import{C as ze}from"../chunks/CodeBlock.57fe6e13.js";import{E as Xe}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Fe}from"../chunks/Heading.16916d63.js";function rt(J){let n,h='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',a,s,f='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){n=c("p"),n.innerHTML=h,a=r(),s=c("p"),s.innerHTML=f},l(t){n=d(t,"P",{"data-svelte-h":!0}),U(n)!=="svelte-1ue9xpl"&&(n.innerHTML=h),a=p(t),s=d(t,"P",{"data-svelte-h":!0}),U(s)!=="svelte-z4pn9c"&&(s.innerHTML=f)},m(t,m){u(t,n,m),u(t,a,m),u(t,s,m)},p:fe,d(t){t&&(i(n),i(a),i(s))}}}function pt(J){let n,h="Examples:",a,s,f;return s=new ze({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkxhdGVudFVwc2NhbGVQaXBlbGluZSUyQyUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnNkLXgyLWxhdGVudC11cHNjYWxlciUyMiUwQXVwc2NhbGVyJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uTGF0ZW50VXBzY2FsZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEF1cHNjYWxlci50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjBoaWdoJTIwcmVzb2x1dGlvbiUyQyUyMHVucmVhbCUyMGVuZ2luZSUyQyUyMHVsdHJhJTIwcmVhbGlzdGljJTIyJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2gubWFudWFsX3NlZWQoMzMpJTBBJTBBbG93X3Jlc19sYXRlbnRzJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJsYXRlbnQlMjIpLmltYWdlcyUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGVsaW5lLmRlY29kZV9sYXRlbnRzKGxvd19yZXNfbGF0ZW50cyklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lLm51bXB5X3RvX3BpbChpbWFnZSklNUIwJTVEJTBBJTBBaW1hZ2Uuc2F2ZSglMjIuLiUyRmltYWdlcyUyRmExLnBuZyUyMiklMEElMEF1cHNjYWxlZF9pbWFnZSUyMCUzRCUyMHVwc2NhbGVyKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEbG93X3Jlc19sYXRlbnRzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QwJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBdXBzY2FsZWRfaW1hZ2Uuc2F2ZSglMjIuLiUyRmltYWdlcyUyRmEyLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionLatentUpscalePipeline, StableDiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch


<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/sd-x2-latent-upscaler&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upscaler = StableDiffusionLatentUpscalePipeline.from_pretrained(model_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>upscaler.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut high resolution, unreal engine, ultra realistic&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">33</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>low_res_latents = pipeline(prompt, generator=generator, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    image = pipeline.decode_latents(low_res_latents)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipeline.numpy_to_pil(image)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;../images/a1.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image = upscaler(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    image=low_res_latents,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image.save(<span class="hljs-string">&quot;../images/a2.png&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=h,a=r(),_(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),U(n)!=="svelte-kvfsh7"&&(n.textContent=h),a=p(t),y(s.$$.fragment,t)},m(t,m){u(t,n,m),u(t,a,m),w(s,t,m),f=!0},p:fe,i(t){f||($(s.$$.fragment,t),f=!0)},o(t){T(s.$$.fragment,t),f=!1},d(t){t&&(i(n),i(a)),v(s,t)}}}function ct(J){let n,h=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=c("p"),n.innerHTML=h},l(a){n=d(a,"P",{"data-svelte-h":!0}),U(n)!=="svelte-ackzsn"&&(n.innerHTML=h)},m(a,s){u(a,n,s)},p:fe,d(a){a&&i(n)}}}function dt(J){let n,h="Examples:",a,s,f;return s=new ze({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=c("p"),n.textContent=h,a=r(),_(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),U(n)!=="svelte-kvfsh7"&&(n.textContent=h),a=p(t),y(s.$$.fragment,t)},m(t,m){u(t,n,m),u(t,a,m),w(s,t,m),f=!0},p:fe,i(t){f||($(s.$$.fragment,t),f=!0)},o(t){T(s.$$.fragment,t),f=!1},d(t){t&&(i(n),i(a)),v(s,t)}}}function ft(J){let n,h=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=c("p"),n.textContent=h},l(a){n=d(a,"P",{"data-svelte-h":!0}),U(n)!=="svelte-17p1lpg"&&(n.textContent=h)},m(a,s){u(a,n,s)},p:fe,d(a){a&&i(n)}}}function ut(J){let n,h="Examples:",a,s,f;return s=new ze({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=h,a=r(),_(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),U(n)!=="svelte-kvfsh7"&&(n.textContent=h),a=p(t),y(s.$$.fragment,t)},m(t,m){u(t,n,m),u(t,a,m),w(s,t,m),f=!0},p:fe,i(t){f||($(s.$$.fragment,t),f=!0)},o(t){T(s.$$.fragment,t),f=!1},d(t){t&&(i(n),i(a)),v(s,t)}}}function mt(J){let n,h,a,s,f,t,m,Ye='The Stable Diffusion latent upscaler model was created by <a href="https://github.com/crowsonkb/k-diffusion" rel="nofollow">Katherine Crowson</a> in collaboration with <a href="https://stability.ai/" rel="nofollow">Stability AI</a>. It is used to enhance the output image resolution by a factor of 2 (see this demo <a href="https://colab.research.google.com/drive/1o1qYJcFeywzCIdkfKJy7cTpgZTCM2EI4" rel="nofollow">notebook</a> for a demonstration of the original implementation).',me,G,ge,F,he,g,z,ve,se,He="Pipeline for upscaling Stable Diffusion output image resolution by a factor of 2.",Ue,ae,qe=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Je,L,Y,xe,ie,Qe="The call function to the pipeline for generation.",Me,S,Ie,W,H,je,oe,Ae=`Offloads all models to CPU using 🤗 Accelerate, significantly reducing memory usage. When called, the state
dicts of all <code>torch.nn.Module</code> components (except those in <code>self._exclude_from_cpu_offload</code>) are saved to CPU
and then moved to <code>torch.device(&#39;meta&#39;)</code> and loaded to GPU only when their specific submodule has its <code>forward</code>
method called. Offloading happens on a submodule basis. Memory savings are higher than with
<code>enable_model_cpu_offload</code>, but performance is lower.`,Le,x,q,De,le,Oe=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Ze,k,Ce,V,Pe,B,Q,Ge,re,Ke=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Se,M,A,We,pe,et=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,ke,E,Ve,R,Be,N,O,Ee,ce,tt='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',be,K,_e,C,ee,Re,de,nt="Output class for Stable Diffusion pipelines.",ye,ue,we;return f=new Fe({props:{title:"Latent upscaler",local:"latent-upscaler",headingTag:"h1"}}),G=new Ne({props:{$$slots:{default:[rt]},$$scope:{ctx:J}}}),F=new Fe({props:{title:"StableDiffusionLatentUpscalePipeline",local:"diffusers.StableDiffusionLatentUpscalePipeline",headingTag:"h2"}}),z=new X({props:{name:"class diffusers.StableDiffusionLatentUpscalePipeline",anchor:"diffusers.StableDiffusionLatentUpscalePipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": EulerDiscreteScheduler"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_latent_upscale.py#L62"}}),Y=new X({props:{name:"__call__",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"num_inference_steps",val:": int = 75"},{name:"guidance_scale",val:": float = 9.0"},{name:"negative_prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide image upscaling.`,name:"prompt"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code> or tensor representing an image batch to be upscaled. If it&#x2019;s a tensor, it can be either a
latent output from a Stable Diffusion model or an image tensor in the range <code>[-1, 1]</code>. It is considered
a <code>latent</code> if <code>image.shape[1]</code> is <code>4</code>; otherwise, it is considered to be an image representation and
encoded using this pipeline&#x2019;s <code>vae</code> encoder.`,name:"image"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_latent_upscale.py#L256",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),S=new Xe({props:{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.example",$$slots:{default:[pt]},$$scope:{ctx:J}}}),H=new X({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = 'cuda'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1418"}}),q=new X({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[str, int, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1925"}}),k=new Ne({props:{warning:!0,$$slots:{default:[ct]},$$scope:{ctx:J}}}),V=new Xe({props:{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_attention_slicing.example",$$slots:{default:[dt]},$$scope:{ctx:J}}}),Q=new X({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1965"}}),A=new X({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1864"}}),E=new Ne({props:{warning:!0,$$slots:{default:[ft]},$$scope:{ctx:J}}}),R=new Xe({props:{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[ut]},$$scope:{ctx:J}}}),O=new X({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1899"}}),K=new Fe({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),ee=new X({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L11"}}),{c(){n=c("meta"),h=r(),a=c("p"),s=r(),_(f.$$.fragment),t=r(),m=c("p"),m.innerHTML=Ye,me=r(),_(G.$$.fragment),ge=r(),_(F.$$.fragment),he=r(),g=c("div"),_(z.$$.fragment),ve=r(),se=c("p"),se.textContent=He,Ue=r(),ae=c("p"),ae.innerHTML=qe,Je=r(),L=c("div"),_(Y.$$.fragment),xe=r(),ie=c("p"),ie.textContent=Qe,Me=r(),_(S.$$.fragment),Ie=r(),W=c("div"),_(H.$$.fragment),je=r(),oe=c("p"),oe.innerHTML=Ae,Le=r(),x=c("div"),_(q.$$.fragment),De=r(),le=c("p"),le.textContent=Oe,Ze=r(),_(k.$$.fragment),Ce=r(),_(V.$$.fragment),Pe=r(),B=c("div"),_(Q.$$.fragment),Ge=r(),re=c("p"),re.innerHTML=Ke,Se=r(),M=c("div"),_(A.$$.fragment),We=r(),pe=c("p"),pe.innerHTML=et,ke=r(),_(E.$$.fragment),Ve=r(),_(R.$$.fragment),Be=r(),N=c("div"),_(O.$$.fragment),Ee=r(),ce=c("p"),ce.innerHTML=tt,be=r(),_(K.$$.fragment),_e=r(),C=c("div"),_(ee.$$.fragment),Re=r(),de=c("p"),de.textContent=nt,ye=r(),ue=c("p"),this.h()},l(e){const l=lt("svelte-u9bgzb",document.head);n=d(l,"META",{name:!0,content:!0}),l.forEach(i),h=p(e),a=d(e,"P",{}),D(a).forEach(i),s=p(e),y(f.$$.fragment,e),t=p(e),m=d(e,"P",{"data-svelte-h":!0}),U(m)!=="svelte-1gpdp46"&&(m.innerHTML=Ye),me=p(e),y(G.$$.fragment,e),ge=p(e),y(F.$$.fragment,e),he=p(e),g=d(e,"DIV",{class:!0});var b=D(g);y(z.$$.fragment,b),ve=p(b),se=d(b,"P",{"data-svelte-h":!0}),U(se)!=="svelte-s74qtl"&&(se.textContent=He),Ue=p(b),ae=d(b,"P",{"data-svelte-h":!0}),U(ae)!=="svelte-496sm0"&&(ae.innerHTML=qe),Je=p(b),L=d(b,"DIV",{class:!0});var P=D(L);y(Y.$$.fragment,P),xe=p(P),ie=d(P,"P",{"data-svelte-h":!0}),U(ie)!=="svelte-50j04k"&&(ie.textContent=Qe),Me=p(P),y(S.$$.fragment,P),P.forEach(i),Ie=p(b),W=d(b,"DIV",{class:!0});var te=D(W);y(H.$$.fragment,te),je=p(te),oe=d(te,"P",{"data-svelte-h":!0}),U(oe)!=="svelte-n1oyuv"&&(oe.innerHTML=Ae),te.forEach(i),Le=p(b),x=d(b,"DIV",{class:!0});var I=D(x);y(q.$$.fragment,I),De=p(I),le=d(I,"P",{"data-svelte-h":!0}),U(le)!=="svelte-10jaql7"&&(le.textContent=Oe),Ze=p(I),y(k.$$.fragment,I),Ce=p(I),y(V.$$.fragment,I),I.forEach(i),Pe=p(b),B=d(b,"DIV",{class:!0});var ne=D(B);y(Q.$$.fragment,ne),Ge=p(ne),re=d(ne,"P",{"data-svelte-h":!0}),U(re)!=="svelte-1lh0nh5"&&(re.innerHTML=Ke),ne.forEach(i),Se=p(b),M=d(b,"DIV",{class:!0});var j=D(M);y(A.$$.fragment,j),We=p(j),pe=d(j,"P",{"data-svelte-h":!0}),U(pe)!=="svelte-e03q3e"&&(pe.innerHTML=et),ke=p(j),y(E.$$.fragment,j),Ve=p(j),y(R.$$.fragment,j),j.forEach(i),Be=p(b),N=d(b,"DIV",{class:!0});var $e=D(N);y(O.$$.fragment,$e),Ee=p($e),ce=d($e,"P",{"data-svelte-h":!0}),U(ce)!=="svelte-1vfte1e"&&(ce.innerHTML=tt),$e.forEach(i),b.forEach(i),be=p(e),y(K.$$.fragment,e),_e=p(e),C=d(e,"DIV",{class:!0});var Te=D(C);y(ee.$$.fragment,Te),Re=p(Te),de=d(Te,"P",{"data-svelte-h":!0}),U(de)!=="svelte-1qpjiuf"&&(de.textContent=nt),Te.forEach(i),ye=p(e),ue=d(e,"P",{}),D(ue).forEach(i),this.h()},h(){Z(n,"name","hf:doc:metadata"),Z(n,"content",gt),Z(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){o(document.head,n),u(e,h,l),u(e,a,l),u(e,s,l),w(f,e,l),u(e,t,l),u(e,m,l),u(e,me,l),w(G,e,l),u(e,ge,l),w(F,e,l),u(e,he,l),u(e,g,l),w(z,g,null),o(g,ve),o(g,se),o(g,Ue),o(g,ae),o(g,Je),o(g,L),w(Y,L,null),o(L,xe),o(L,ie),o(L,Me),w(S,L,null),o(g,Ie),o(g,W),w(H,W,null),o(W,je),o(W,oe),o(g,Le),o(g,x),w(q,x,null),o(x,De),o(x,le),o(x,Ze),w(k,x,null),o(x,Ce),w(V,x,null),o(g,Pe),o(g,B),w(Q,B,null),o(B,Ge),o(B,re),o(g,Se),o(g,M),w(A,M,null),o(M,We),o(M,pe),o(M,ke),w(E,M,null),o(M,Ve),w(R,M,null),o(g,Be),o(g,N),w(O,N,null),o(N,Ee),o(N,ce),u(e,be,l),w(K,e,l),u(e,_e,l),u(e,C,l),w(ee,C,null),o(C,Re),o(C,de),u(e,ye,l),u(e,ue,l),we=!0},p(e,[l]){const b={};l&2&&(b.$$scope={dirty:l,ctx:e}),G.$set(b);const P={};l&2&&(P.$$scope={dirty:l,ctx:e}),S.$set(P);const te={};l&2&&(te.$$scope={dirty:l,ctx:e}),k.$set(te);const I={};l&2&&(I.$$scope={dirty:l,ctx:e}),V.$set(I);const ne={};l&2&&(ne.$$scope={dirty:l,ctx:e}),E.$set(ne);const j={};l&2&&(j.$$scope={dirty:l,ctx:e}),R.$set(j)},i(e){we||($(f.$$.fragment,e),$(G.$$.fragment,e),$(F.$$.fragment,e),$(z.$$.fragment,e),$(Y.$$.fragment,e),$(S.$$.fragment,e),$(H.$$.fragment,e),$(q.$$.fragment,e),$(k.$$.fragment,e),$(V.$$.fragment,e),$(Q.$$.fragment,e),$(A.$$.fragment,e),$(E.$$.fragment,e),$(R.$$.fragment,e),$(O.$$.fragment,e),$(K.$$.fragment,e),$(ee.$$.fragment,e),we=!0)},o(e){T(f.$$.fragment,e),T(G.$$.fragment,e),T(F.$$.fragment,e),T(z.$$.fragment,e),T(Y.$$.fragment,e),T(S.$$.fragment,e),T(H.$$.fragment,e),T(q.$$.fragment,e),T(k.$$.fragment,e),T(V.$$.fragment,e),T(Q.$$.fragment,e),T(A.$$.fragment,e),T(E.$$.fragment,e),T(R.$$.fragment,e),T(O.$$.fragment,e),T(K.$$.fragment,e),T(ee.$$.fragment,e),we=!1},d(e){e&&(i(h),i(a),i(s),i(t),i(m),i(me),i(ge),i(he),i(g),i(be),i(_e),i(C),i(ye),i(ue)),i(n),v(f,e),v(G,e),v(F,e),v(z),v(Y),v(S),v(H),v(q),v(k),v(V),v(Q),v(A),v(E),v(R),v(O),v(K,e),v(ee)}}}const gt='{"title":"Latent upscaler","local":"latent-upscaler","sections":[{"title":"StableDiffusionLatentUpscalePipeline","local":"diffusers.StableDiffusionLatentUpscalePipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function ht(J){return at(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ut extends it{constructor(n){super(),ot(this,n,ht,mt,st,{})}}export{Ut as component};
