import{s as ir,o as dr,n as E}from"../chunks/scheduler.182ea377.js";import{S as lr,i as cr,g as i,s as r,r as m,A as fr,h as d,f as s,c as a,j as L,u as p,x as b,k as T,y as o,a as x,v as u,d as h,t as g,w as _}from"../chunks/index.abf12888.js";import{T as Bo}from"../chunks/Tip.230e2334.js";import{D as k}from"../chunks/Docstring.93f6f462.js";import{C as zo}from"../chunks/CodeBlock.57fe6e13.js";import{E as Vo}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as be}from"../chunks/Heading.16916d63.js";function mr(C){let n,y='🧪 The <code>LoaderMixins</code> are highly experimental and prone to future changes. To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated</a> models, log-in with <code>huggingface-cli login</code>.';return{c(){n=i("p"),n.innerHTML=y},l(c){n=d(c,"P",{"data-svelte-h":!0}),b(n)!=="svelte-vucowe"&&(n.innerHTML=y)},m(c,l){x(c,n,l)},p:E,d(c){c&&s(n)}}}function pr(C){let n,y="To load a textual inversion embedding vector in 🤗 Diffusers format:",c,l,v;return l=new zo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=y,c=r(),m(l.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),b(n)!=="svelte-1y13ww6"&&(n.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){x(t,n,w),x(t,c,w),u(l,t,w),v=!0},p:E,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(s(n),s(c)),_(l,t)}}}function ur(C){let n,y="locally:",c,l,v;return l=new zo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=y,c=r(),m(l.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),b(n)!=="svelte-4c75kq"&&(n.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){x(t,n,w),x(t,c,w),u(l,t,w),v=!0},p:E,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(s(n),s(c)),_(l,t)}}}function hr(C){let n,y="This is an experimental API.";return{c(){n=i("p"),n.textContent=y},l(c){n=d(c,"P",{"data-svelte-h":!0}),b(n)!=="svelte-8w79b9"&&(n.textContent=y)},m(c,l){x(c,n,l)},p:E,d(c){c&&s(n)}}}function gr(C){let n,y="We support loading A1111 formatted LoRA checkpoints in a limited capacity.",c,l,v="This function is experimental and might change in the future.";return{c(){n=i("p"),n.textContent=y,c=r(),l=i("p"),l.textContent=v},l(t){n=d(t,"P",{"data-svelte-h":!0}),b(n)!=="svelte-15l1sdn"&&(n.textContent=y),c=a(t),l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-3fufvn"&&(l.textContent=v)},m(t,w){x(t,n,w),x(t,c,w),x(t,l,w)},p:E,d(t){t&&(s(n),s(c),s(l))}}}function _r(C){let n,y="This is an experimental API.";return{c(){n=i("p"),n.textContent=y},l(c){n=d(c,"P",{"data-svelte-h":!0}),b(n)!=="svelte-8w79b9"&&(n.textContent=y)},m(c,l){x(c,n,l)},p:E,d(c){c&&s(n)}}}function xr(C){let n,y="Examples:",c,l,v;return l=new zo({props:{code:"JTIzJTIwQXNzdW1pbmclMjAlNjBwaXBlbGluZSU2MCUyMGlzJTIwYWxyZWFkeSUyMGxvYWRlZCUyMHdpdGglMjB0aGUlMjBMb1JBJTIwcGFyYW1ldGVycy4lMEFwaXBlbGluZS51bmxvYWRfbG9yYV93ZWlnaHRzKCklMEEuLi4=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assuming `pipeline` is already loaded with the LoRA parameters.</span>\n<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.unload_lora_weights()\n<span class="hljs-meta">&gt;&gt;&gt; </span>...',wrap:!1}}),{c(){n=i("p"),n.textContent=y,c=r(),m(l.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),b(n)!=="svelte-kvfsh7"&&(n.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){x(t,n,w),x(t,c,w),u(l,t,w),v=!0},p:E,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(s(n),s(c)),_(l,t)}}}function br(C){let n,y="Examples:",c,l,v;return l=new zo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGV2Fycmlvck1hbWE3NzclMkZPcmFuZ2VNaXhzJTJGYmxvYiUyRm1haW4lMkZNb2RlbHMlMkZBYnlzc09yYW5nZU1peCUyRkFieXNzT3JhbmdlTWl4LnNhZmV0ZW5zb3JzJTIyJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwbG9jYWwlMjBmaWxlJTBBJTIzJTIwZmlsZSUyMGlzJTIwZG93bmxvYWRlZCUyMHVuZGVyJTIwLiUyRnYxLTUtcHJ1bmVkLWVtYW9ubHkuY2twdCUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMjIuJTJGdjEtNS1wcnVuZWQtZW1hb25seSUyMiklMEElMEElMjMlMjBFbmFibGUlMjBmbG9hdDE2JTIwYW5kJTIwbW92ZSUyMHRvJTIwR1BVJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRmJsb2IlMkZtYWluJTJGdjEtNS1wcnVuZWQtZW1hb25seS5ja3B0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/WarriorMama777/OrangeMixs/blob/main/Models/AbyssOrangeMix/AbyssOrangeMix.safetensors&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from local file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># file is downloaded under ./v1-5-pruned-emaonly.ckpt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(<span class="hljs-string">&quot;./v1-5-pruned-emaonly&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable float16 and move to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned-emaonly.ckpt&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=y,c=r(),m(l.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),b(n)!=="svelte-kvfsh7"&&(n.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){x(t,n,w),x(t,c,w),u(l,t,w),v=!0},p:E,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(s(n),s(c)),_(l,t)}}}function vr(C){let n,y="Examples:",c,l,v;return l=new zo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xuZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZsbGx5YXN2aWVsJTJGQ29udHJvbE5ldC12MS0xJTJGYmxvYiUyRm1haW4lMkZjb250cm9sX3YxMXBfc2QxNV9jYW5ueS5wdGglMjIlMjAlMjAlMjMlMjBjYW4lMjBhbHNvJTIwYmUlMjBhJTIwbG9jYWwlMjBwYXRoJTBBbW9kZWwlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9zaW5nbGVfZmlsZSh1cmwpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGYmxvYiUyRm1haW4lMkZ2MS01LXBydW5lZC5zYWZldGVuc29ycyUyMiUyMCUyMCUyMyUyMGNhbiUyMGFsc28lMjBiZSUyMGElMjBsb2NhbCUyMHBhdGglMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbG5ldFBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUodXJsJTJDJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlnetPipeline, ControlNetModel

url = <span class="hljs-string">&quot;https://huggingface.co/lllyasviel/ControlNet-v1-1/blob/main/control_v11p_sd15_canny.pth&quot;</span>  <span class="hljs-comment"># can also be a local path</span>
model = ControlNetModel.from_single_file(url)

url = <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned.safetensors&quot;</span>  <span class="hljs-comment"># can also be a local path</span>
pipe = StableDiffusionControlnetPipeline.from_single_file(url, controlnet=controlnet)`,wrap:!1}}),{c(){n=i("p"),n.textContent=y,c=r(),m(l.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),b(n)!=="svelte-kvfsh7"&&(n.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){x(t,n,w),x(t,c,w),u(l,t,w),v=!0},p:E,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(s(n),s(c)),_(l,t)}}}function yr(C){let n,y=`Make sure to pass both <code>image_size</code> and <code>scaling_factor</code> to <code>from_single_file()</code> if you want to load
a VAE that does accompany a stable diffusion model of v2 or higher or SDXL.`;return{c(){n=i("p"),n.innerHTML=y},l(c){n=d(c,"P",{"data-svelte-h":!0}),b(n)!=="svelte-1u4e4ei"&&(n.innerHTML=y)},m(c,l){x(c,n,l)},p:E,d(c){c&&s(n)}}}function wr(C){let n,y="Examples:",c,l,v;return l=new zo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9lbmNvZGVyS0wlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmlsaXR5YWklMkZzZC12YWUtZnQtbXNlLW9yaWdpbmFsJTJGYmxvYiUyRm1haW4lMkZ2YWUtZnQtbXNlLTg0MDAwMC1lbWEtcHJ1bmVkLnNhZmV0ZW5zb3JzJTIyJTIwJTIwJTIzJTIwY2FuJTIwYWxzbyUyMGJlJTIwbG9jYWwlMjBmaWxlJTBBbW9kZWwlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fc2luZ2xlX2ZpbGUodXJsKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL

url = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/sd-vae-ft-mse-original/blob/main/vae-ft-mse-840000-ema-pruned.safetensors&quot;</span>  <span class="hljs-comment"># can also be local file</span>
model = AutoencoderKL.from_single_file(url)`,wrap:!1}}),{c(){n=i("p"),n.textContent=y,c=r(),m(l.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),b(n)!=="svelte-kvfsh7"&&(n.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){x(t,n,w),x(t,c,w),u(l,t,w),v=!0},p:E,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(s(n),s(c)),_(l,t)}}}function Mr(C){let n,y,c,l,v,t,w,kn="Adapters (textual inversion, LoRA, hypernetworks) allow you to modify a diffusion model to generate images in a specific style without training or finetuning the entire model. The adapter weights are typically only a tiny fraction of the pretrained model’s which making them very portable. 🤗 Diffusers provides an easy-to-use <code>LoaderMixin</code> API to load adapter weights.",Yo,Q,Xo,ve,Oo,S,ye,xt,K,we,bt,ro,Cn=`Load pretrained attention processor layers into <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>. Attention processor layers have to be
defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>attention_processor.py</code></a>
and be a <code>torch.nn.Module</code> class.`,vt,ee,Me,yt,ao,Un=`Save an attention processor to a directory so that it can be reloaded using the
<a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs">load_attn_procs()</a> method.`,Qo,$e,Ko,N,Le,wt,so,In="Load textual inversion tokens and embeddings to the tokenizer and text encoder.",Mt,U,Te,$t,io,Fn=`Load textual inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,Lt,lo,Jn="Example:",Tt,oe,kt,co,Zn=`To load a textual inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,Ct,te,Ut,ne,ke,It,fo,Nn=`Processes prompts that include a special token corresponding to a multi-vector textual inversion embedding to
be replaced with multiple special tokens each corresponding to one of the vectors. If the prompt has no textual
inversion token or if the textual inversion token is a single vector, the input prompt is returned.`,et,Ce,ot,j,Ue,Ft,mo,Dn="This class overrides <code>LoraLoaderMixin</code> with LoRA loading/saving code that’s specific to SDXL",Jt,I,Ie,Zt,po,Wn=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,Nt,uo,Sn="All kwargs are forwarded to <code>self.lora_state_dict</code>.",Dt,ho,jn='See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',Wt,go,Pn=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,St,_o,An=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,tt,Fe,nt,M,Je,jt,xo,En=`Load LoRA layers into <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> and
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow"><code>CLIPTextModel</code></a>.`,Pt,re,Ze,At,bo,Rn="Disables the LoRA layers for the text encoder.",Et,ae,Ne,Rt,vo,Gn="Enables the LoRA layers for the text encoder.",Gt,R,De,Ht,yo,Hn="Fuses the LoRA parameters into the original parameters of the corresponding blocks.",Vt,se,zt,ie,We,qt,wo,Vn="This will load the LoRA layers specified in <code>state_dict</code> into <code>text_encoder</code>",Bt,de,Se,Yt,Mo,zn="This will load the LoRA layers specified in <code>state_dict</code> into <code>unet</code>.",Xt,F,je,Ot,$o,qn=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,Qt,Lo,Bn="All kwargs are forwarded to <code>self.lora_state_dict</code>.",Kt,To,Yn='See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',en,ko,Xn=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,on,Co,On=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,tn,G,Pe,nn,Uo,Qn="Return state dict for lora weights and the network alphas.",rn,le,an,ce,Ae,sn,Io,Kn="Save the LoRA parameters corresponding to the UNet and text encoder.",dn,fe,Ee,ln,Fo,er="Sets the adapter layers for the text encoder.",cn,H,Re,fn,Jo,or=`Reverses the effect of
<a href="https://huggingface.co/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.fuse_lora" rel="nofollow"><code>pipe.fuse_lora()</code></a>.`,mn,me,pn,V,Ge,un,Zo,tr="Unloads the LoRA parameters.",hn,pe,rt,He,at,P,Ve,gn,No,nr='Load model weights saved in the <code>.ckpt</code> format into a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>.',_n,z,ze,xn,Do,rr=`Instantiate a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> from pretrained pipeline weights saved in the <code>.ckpt</code> or <code>.safetensors</code>
format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.`,bn,ue,st,qe,it,B,Be,vn,q,Ye,yn,Wo,ar=`Instantiate a <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> from pretrained controlnet weights saved in the original <code>.ckpt</code> or
<code>.safetensors</code> format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.`,wn,he,dt,Xe,lt,Y,Oe,Mn,D,Qe,$n,So,sr=`Instantiate a <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> from pretrained controlnet weights saved in the original <code>.ckpt</code> or
<code>.safetensors</code> format. The pipeline is format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by
default.`,Ln,ge,Tn,_e,ct,qo,ft;return v=new be({props:{title:"Loaders",local:"loaders",headingTag:"h1"}}),Q=new Bo({props:{warning:!0,$$slots:{default:[mr]},$$scope:{ctx:C}}}),ve=new be({props:{title:"UNet2DConditionLoadersMixin",local:"diffusers.loaders.UNet2DConditionLoadersMixin",headingTag:"h2"}}),ye=new k({props:{name:"class diffusers.loaders.UNet2DConditionLoadersMixin",anchor:"diffusers.loaders.UNet2DConditionLoadersMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L261"}}),we=new k({props:{name:"load_attn_procs",anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the model id (for example <code>google/ddpm-celebahq-256</code>) of a pretrained model hosted on
the Hub.</li>
<li>A path to a directory (for example <code>./my_model_directory</code>) containing the model weights saved
with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">ModelMixin.save_pretrained()</a>.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L265"}}),Me=new k({props:{name:"save_attn_procs",anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.save_attn_procs",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.save_attn_procs.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save an attention processor to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.save_attn_procs.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.save_attn_procs.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.save_attn_procs.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L587"}}),$e=new be({props:{title:"TextualInversionLoaderMixin",local:"diffusers.loaders.TextualInversionLoaderMixin",headingTag:"h2"}}),Le=new k({props:{name:"class diffusers.loaders.TextualInversionLoaderMixin",anchor:"diffusers.loaders.TextualInversionLoaderMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L766"}}),Te=new k({props:{name:"load_textual_inversion",anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, typing.List[str], typing.Dict[str, torch.Tensor], typing.List[typing.Dict[str, torch.Tensor]]]"},{name:"token",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[ForwardRef('PreTrainedTokenizer')] = None"},{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L919"}}),oe=new Vo({props:{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.example",$$slots:{default:[pr]},$$scope:{ctx:C}}}),te=new Vo({props:{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.example-2",$$slots:{default:[ur]},$$scope:{ctx:C}}}),ke=new k({props:{name:"maybe_convert_prompt",anchor:"diffusers.loaders.TextualInversionLoaderMixin.maybe_convert_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"tokenizer",val:": PreTrainedTokenizer"}],parametersDescription:[{anchor:"diffusers.loaders.TextualInversionLoaderMixin.maybe_convert_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or list of <code>str</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.maybe_convert_prompt.tokenizer",description:`<strong>tokenizer</strong> (<code>PreTrainedTokenizer</code>) &#x2014;
The tokenizer responsible for encoding the prompt into input tokens.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L771",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The converted prompt</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code> or list of <code>str</code></p>
`}}),Ce=new be({props:{title:"StableDiffusionXLLoraLoaderMixin",local:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin",headingTag:"h2"}}),Ue=new k({props:{name:"class diffusers.loaders.StableDiffusionXLLoraLoaderMixin",anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L2859"}}),Ie=new k({props:{name:"load_lora_weights",anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L2863"}}),Fe=new be({props:{title:"LoraLoaderMixin",local:"diffusers.loaders.LoraLoaderMixin",headingTag:"h2"}}),Je=new k({props:{name:"class diffusers.loaders.LoraLoaderMixin",anchor:"diffusers.loaders.LoraLoaderMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L1099"}}),Ze=new k({props:{name:"disable_lora_for_text_encoder",anchor:"diffusers.loaders.LoraLoaderMixin.disable_lora_for_text_encoder",parameters:[{name:"text_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.disable_lora_for_text_encoder.text_encoder",description:`<strong>text_encoder</strong> (<code>torch.nn.Module</code>, <em>optional</em>) &#x2014;
The text encoder module to disable the LoRA layers for. If <code>None</code>, it will try to get the
<code>text_encoder</code> attribute.`,name:"text_encoder"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L2246"}}),Ne=new k({props:{name:"enable_lora_for_text_encoder",anchor:"diffusers.loaders.LoraLoaderMixin.enable_lora_for_text_encoder",parameters:[{name:"text_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.enable_lora_for_text_encoder.text_encoder",description:`<strong>text_encoder</strong> (<code>torch.nn.Module</code>, <em>optional</em>) &#x2014;
The text encoder module to enable the LoRA layers for. If <code>None</code>, it will try to get the <code>text_encoder</code>
attribute.`,name:"text_encoder"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L2263"}}),De=new k({props:{name:"fuse_lora",anchor:"diffusers.loaders.LoraLoaderMixin.fuse_lora",parameters:[{name:"fuse_unet",val:": bool = True"},{name:"fuse_text_encoder",val:": bool = True"},{name:"lora_scale",val:": float = 1.0"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.fuse_lora.fuse_unet",description:"<strong>fuse_unet</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; Whether to fuse the UNet LoRA parameters.",name:"fuse_unet"},{anchor:"diffusers.loaders.LoraLoaderMixin.fuse_lora.fuse_text_encoder",description:`<strong>fuse_text_encoder</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to fuse the text encoder LoRA parameters. If the text encoder wasn&#x2019;t monkey-patched with the
LoRA parameters then it won&#x2019;t have any effect.`,name:"fuse_text_encoder"},{anchor:"diffusers.loaders.LoraLoaderMixin.fuse_lora.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, defaults to 1.0) &#x2014;
Controls how much to influence the outputs with the LoRA parameters.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L2089"}}),se=new Bo({props:{warning:!0,$$slots:{default:[hr]},$$scope:{ctx:C}}}),We=new k({props:{name:"load_lora_into_text_encoder",anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder",parameters:[{name:"state_dict",val:""},{name:"network_alphas",val:""},{name:"text_encoder",val:""},{name:"prefix",val:" = None"},{name:"lora_scale",val:" = 1.0"},{name:"low_cpu_mem_usage",val:" = None"},{name:"adapter_name",val:" = None"},{name:"_pipeline",val:" = None"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.state_dict",description:`<strong>state_dict</strong> (<code>dict</code>) &#x2014;
A standard state dict containing the lora layer parameters. The key should be prefixed with an
additional <code>text_encoder</code> to distinguish between unet lora layers.`,name:"state_dict"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.network_alphas",description:`<strong>network_alphas</strong> (<code>Dict[str, float]</code>) &#x2014;
See <code>LoRALinearLayer</code> for more details.`,name:"network_alphas"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
The text encoder model to load the LoRA layers into.`,name:"text_encoder"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.prefix",description:`<strong>prefix</strong> (<code>str</code>) &#x2014;
Expected prefix of the <code>text_encoder</code> in the <code>state_dict</code>.`,name:"prefix"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>) &#x2014;
How much to scale the output of the lora linear layer before it is added with the output of the regular
lora layer.`,name:"lora_scale"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L1506"}}),Se=new k({props:{name:"load_lora_into_unet",anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_unet",parameters:[{name:"state_dict",val:""},{name:"network_alphas",val:""},{name:"unet",val:""},{name:"low_cpu_mem_usage",val:" = None"},{name:"_pipeline",val:" = None"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_unet.state_dict",description:`<strong>state_dict</strong> (<code>dict</code>) &#x2014;
A standard state dict containing the lora layer parameters. The keys can either be indexed directly
into the unet or prefixed with an additional <code>unet</code> which can be used to distinguish between text
encoder lora layers.`,name:"state_dict"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_unet.network_alphas",description:`<strong>network_alphas</strong> (<code>Dict[str, float]</code>) &#x2014;
See <code>LoRALinearLayer</code> for more details.`,name:"network_alphas"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_unet.unet",description:`<strong>unet</strong> (<code>UNet2DConditionModel</code>) &#x2014;
The UNet model to load the LoRA layers into.`,name:"unet"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_unet.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L1457"}}),je=new k({props:{name:"load_lora_weights",anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L1109"}}),Pe=new k({props:{name:"lora_state_dict",anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>google/ddpm-celebahq-256</code>) of a pretrained model hosted on
the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">ModelMixin.save_pretrained()</a>.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L1161"}}),le=new Bo({props:{warning:!0,$$slots:{default:[gr]},$$scope:{ctx:C}}}),Ae=new k({props:{name:"save_lora_weights",anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"unet_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"text_encoder_lora_layers",val:": typing.Dict[str, torch.nn.modules.module.Module] = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L1806"}}),Ee=new k({props:{name:"set_adapter_for_text_encoder",anchor:"diffusers.loaders.LoraLoaderMixin.set_adapter_for_text_encoder",parameters:[{name:"adapter_names",val:": typing.Union[typing.List[str], str]"},{name:"text_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"},{name:"text_encoder_weights",val:": typing.List[float] = None"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.set_adapter_for_text_encoder.adapter_names",description:`<strong>adapter_names</strong> (<code>List[str]</code> or <code>str</code>) &#x2014;
The names of the adapters to use.`,name:"adapter_names"},{anchor:"diffusers.loaders.LoraLoaderMixin.set_adapter_for_text_encoder.text_encoder",description:`<strong>text_encoder</strong> (<code>torch.nn.Module</code>, <em>optional</em>) &#x2014;
The text encoder module to set the adapter layers for. If <code>None</code>, it will try to get the <code>text_encoder</code>
attribute.`,name:"text_encoder"},{anchor:"diffusers.loaders.LoraLoaderMixin.set_adapter_for_text_encoder.text_encoder_weights",description:`<strong>text_encoder_weights</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
The weights to use for the text encoder. If <code>None</code>, the weights are set to <code>1.0</code> for all the adapters.`,name:"text_encoder_weights"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L2204"}}),Re=new k({props:{name:"unfuse_lora",anchor:"diffusers.loaders.LoraLoaderMixin.unfuse_lora",parameters:[{name:"unfuse_unet",val:": bool = True"},{name:"unfuse_text_encoder",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.unfuse_lora.unfuse_unet",description:"<strong>unfuse_unet</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; Whether to unfuse the UNet LoRA parameters.",name:"unfuse_unet"},{anchor:"diffusers.loaders.LoraLoaderMixin.unfuse_lora.unfuse_text_encoder",description:`<strong>unfuse_text_encoder</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to unfuse the text encoder LoRA parameters. If the text encoder wasn&#x2019;t monkey-patched with the
LoRA parameters then it won&#x2019;t have any effect.`,name:"unfuse_text_encoder"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L2151"}}),me=new Bo({props:{warning:!0,$$slots:{default:[_r]},$$scope:{ctx:C}}}),Ge=new k({props:{name:"unload_lora_weights",anchor:"diffusers.loaders.LoraLoaderMixin.unload_lora_weights",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L2070"}}),pe=new Vo({props:{anchor:"diffusers.loaders.LoraLoaderMixin.unload_lora_weights.example",$$slots:{default:[xr]},$$scope:{ctx:C}}}),He=new be({props:{title:"FromSingleFileMixin",local:"diffusers.loaders.FromSingleFileMixin",headingTag:"h2"}}),Ve=new k({props:{name:"class diffusers.loaders.FromSingleFileMixin",anchor:"diffusers.loaders.FromSingleFileMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L2280"}}),ze=new k({props:{name:"from_single_file",anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.extract_ema",description:`<strong>extract_ema</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to extract the EMA weights or not. Pass <code>True</code> to extract the EMA weights which usually yield
higher quality images for inference. Non-EMA weights are usually better for continuing finetuning.`,name:"extract_ema"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.upcast_attention",description:`<strong>upcast_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether the attention computation should always be upcasted.`,name:"upcast_attention"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The image size the model was trained on. Use 512 for all Stable Diffusion v1 models and the Stable
Diffusion v2 base model. Use 768 for Stable Diffusion v2.`,name:"image_size"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prediction type the model was trained on. Use <code>&apos;epsilon&apos;</code> for all Stable Diffusion v1 models and
the Stable Diffusion v2 base model. Use <code>&apos;v_prediction&apos;</code> for Stable Diffusion v2.`,name:"prediction_type"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.num_in_channels",description:`<strong>num_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The number of input channels. If <code>None</code>, it is automatically inferred.`,name:"num_in_channels"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.scheduler_type",description:`<strong>scheduler_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pndm&quot;</code>) &#x2014;
Type of scheduler to use. Should be one of <code>[&quot;pndm&quot;, &quot;lms&quot;, &quot;heun&quot;, &quot;euler&quot;, &quot;euler-ancestral&quot;, &quot;dpm&quot;, &quot;ddim&quot;]</code>.`,name:"scheduler_type"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.load_safety_checker",description:`<strong>load_safety_checker</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to load the safety checker or not.`,name:"load_safety_checker"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An instance of <code>CLIPTextModel</code> to use, specifically the
<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant. If this
parameter is <code>None</code>, the function loads a new instance of <code>CLIPTextModel</code> by itself if needed.`,name:"text_encoder"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.vae",description:`<strong>vae</strong> (<code>AutoencoderKL</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations. If
this parameter is <code>None</code>, the function will load a new instance of [CLIP] by itself, if needed.`,name:"vae"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An instance of <code>CLIPTokenizer</code> to use. If this parameter is <code>None</code>, the function loads a new instance
of <code>CLIPTokenizer</code> by itself if needed.`,name:"tokenizer"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.original_config_file",description:`<strong>original_config_file</strong> (<code>str</code>) &#x2014;
Path to <code>.yaml</code> config file corresponding to the original architecture. If <code>None</code>, will be
automatically inferred by looking for a key that only exists in SD2.0 models.`,name:"original_config_file"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (for example the pipeline components of the
specific pipeline class). The overwritten components are directly passed to the pipelines <code>__init__</code>
method. See example below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L2291"}}),ue=new Vo({props:{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.example",$$slots:{default:[br]},$$scope:{ctx:C}}}),qe=new be({props:{title:"FromOriginalControlnetMixin",local:"diffusers.loaders.FromOriginalControlnetMixin",headingTag:"h2"}}),Be=new k({props:{name:"class diffusers.loaders.FromOriginalControlnetMixin",anchor:"diffusers.loaders.FromOriginalControlnetMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L2716"}}),Ye=new k({props:{name:"from_single_file",anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to True, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The image size the model was trained on. Use 512 for all Stable Diffusion v1 models and the Stable
Diffusion v2 base model. Use 768 for Stable Diffusion v2.`,name:"image_size"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.upcast_attention",description:`<strong>upcast_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether the attention computation should always be upcasted.`,name:"upcast_attention"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (for example the pipeline components of the
specific pipeline class). The overwritten components are directly passed to the pipelines <code>__init__</code>
method. See example below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L2717"}}),he=new Vo({props:{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.example",$$slots:{default:[vr]},$$scope:{ctx:C}}}),Xe=new be({props:{title:"FromOriginalVAEMixin",local:"diffusers.loaders.FromOriginalVAEMixin",headingTag:"h2"}}),Oe=new k({props:{name:"class diffusers.loaders.FromOriginalVAEMixin",anchor:"diffusers.loaders.FromOriginalVAEMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L2524"}}),Qe=new k({props:{name:"from_single_file",anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to True, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The image size the model was trained on. Use 512 for all Stable Diffusion v1 models and the Stable
Diffusion v2 base model. Use 768 for Stable Diffusion v2.`,name:"image_size"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.upcast_attention",description:`<strong>upcast_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether the attention computation should always be upcasted.`,name:"upcast_attention"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.scaling_factor",description:`<strong>scaling_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.18215) &#x2014;
The component-wise standard deviation of the trained latent space computed using the first batch of the
training set. This is used to scale the latent space to have unit variance when training the diffusion
model. The latents are scaled with the formula <code>z = z * scaling_factor</code> before being passed to the
diffusion model. When decoding, the latents are scaled back to the original scale with the formula: <code>z = 1 / scaling_factor * z</code>. For more details, refer to sections 4.3.2 and D.1 of the <a href="https://arxiv.org/abs/2112.10752" rel="nofollow">High-Resolution
Image Synthesis with Latent Diffusion Models</a> paper.`,name:"scaling_factor"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (for example the pipeline components of the
specific pipeline class). The overwritten components are directly passed to the pipelines <code>__init__</code>
method. See example below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L2525"}}),ge=new Bo({props:{warning:!0,$$slots:{default:[yr]},$$scope:{ctx:C}}}),_e=new Vo({props:{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.example",$$slots:{default:[wr]},$$scope:{ctx:C}}}),{c(){n=i("meta"),y=r(),c=i("p"),l=r(),m(v.$$.fragment),t=r(),w=i("p"),w.innerHTML=kn,Yo=r(),m(Q.$$.fragment),Xo=r(),m(ve.$$.fragment),Oo=r(),S=i("div"),m(ye.$$.fragment),xt=r(),K=i("div"),m(we.$$.fragment),bt=r(),ro=i("p"),ro.innerHTML=Cn,vt=r(),ee=i("div"),m(Me.$$.fragment),yt=r(),ao=i("p"),ao.innerHTML=Un,Qo=r(),m($e.$$.fragment),Ko=r(),N=i("div"),m(Le.$$.fragment),wt=r(),so=i("p"),so.textContent=In,Mt=r(),U=i("div"),m(Te.$$.fragment),$t=r(),io=i("p"),io.innerHTML=Fn,Lt=r(),lo=i("p"),lo.textContent=Jn,Tt=r(),m(oe.$$.fragment),kt=r(),co=i("p"),co.innerHTML=Zn,Ct=r(),m(te.$$.fragment),Ut=r(),ne=i("div"),m(ke.$$.fragment),It=r(),fo=i("p"),fo.textContent=Nn,et=r(),m(Ce.$$.fragment),ot=r(),j=i("div"),m(Ue.$$.fragment),Ft=r(),mo=i("p"),mo.innerHTML=Dn,Jt=r(),I=i("div"),m(Ie.$$.fragment),Zt=r(),po=i("p"),po.innerHTML=Wn,Nt=r(),uo=i("p"),uo.innerHTML=Sn,Dt=r(),ho=i("p"),ho.innerHTML=jn,Wt=r(),go=i("p"),go.innerHTML=Pn,St=r(),_o=i("p"),_o.innerHTML=An,tt=r(),m(Fe.$$.fragment),nt=r(),M=i("div"),m(Je.$$.fragment),jt=r(),xo=i("p"),xo.innerHTML=En,Pt=r(),re=i("div"),m(Ze.$$.fragment),At=r(),bo=i("p"),bo.textContent=Rn,Et=r(),ae=i("div"),m(Ne.$$.fragment),Rt=r(),vo=i("p"),vo.textContent=Gn,Gt=r(),R=i("div"),m(De.$$.fragment),Ht=r(),yo=i("p"),yo.textContent=Hn,Vt=r(),m(se.$$.fragment),zt=r(),ie=i("div"),m(We.$$.fragment),qt=r(),wo=i("p"),wo.innerHTML=Vn,Bt=r(),de=i("div"),m(Se.$$.fragment),Yt=r(),Mo=i("p"),Mo.innerHTML=zn,Xt=r(),F=i("div"),m(je.$$.fragment),Ot=r(),$o=i("p"),$o.innerHTML=qn,Qt=r(),Lo=i("p"),Lo.innerHTML=Bn,Kt=r(),To=i("p"),To.innerHTML=Yn,en=r(),ko=i("p"),ko.innerHTML=Xn,on=r(),Co=i("p"),Co.innerHTML=On,tn=r(),G=i("div"),m(Pe.$$.fragment),nn=r(),Uo=i("p"),Uo.textContent=Qn,rn=r(),m(le.$$.fragment),an=r(),ce=i("div"),m(Ae.$$.fragment),sn=r(),Io=i("p"),Io.textContent=Kn,dn=r(),fe=i("div"),m(Ee.$$.fragment),ln=r(),Fo=i("p"),Fo.textContent=er,cn=r(),H=i("div"),m(Re.$$.fragment),fn=r(),Jo=i("p"),Jo.innerHTML=or,mn=r(),m(me.$$.fragment),pn=r(),V=i("div"),m(Ge.$$.fragment),un=r(),Zo=i("p"),Zo.textContent=tr,hn=r(),m(pe.$$.fragment),rt=r(),m(He.$$.fragment),at=r(),P=i("div"),m(Ve.$$.fragment),gn=r(),No=i("p"),No.innerHTML=nr,_n=r(),z=i("div"),m(ze.$$.fragment),xn=r(),Do=i("p"),Do.innerHTML=rr,bn=r(),m(ue.$$.fragment),st=r(),m(qe.$$.fragment),it=r(),B=i("div"),m(Be.$$.fragment),vn=r(),q=i("div"),m(Ye.$$.fragment),yn=r(),Wo=i("p"),Wo.innerHTML=ar,wn=r(),m(he.$$.fragment),dt=r(),m(Xe.$$.fragment),lt=r(),Y=i("div"),m(Oe.$$.fragment),Mn=r(),D=i("div"),m(Qe.$$.fragment),$n=r(),So=i("p"),So.innerHTML=sr,Ln=r(),m(ge.$$.fragment),Tn=r(),m(_e.$$.fragment),ct=r(),qo=i("p"),this.h()},l(e){const f=fr("svelte-u9bgzb",document.head);n=d(f,"META",{name:!0,content:!0}),f.forEach(s),y=a(e),c=d(e,"P",{}),L(c).forEach(s),l=a(e),p(v.$$.fragment,e),t=a(e),w=d(e,"P",{"data-svelte-h":!0}),b(w)!=="svelte-dvj0a"&&(w.innerHTML=kn),Yo=a(e),p(Q.$$.fragment,e),Xo=a(e),p(ve.$$.fragment,e),Oo=a(e),S=d(e,"DIV",{class:!0});var X=L(S);p(ye.$$.fragment,X),xt=a(X),K=d(X,"DIV",{class:!0});var Ke=L(K);p(we.$$.fragment,Ke),bt=a(Ke),ro=d(Ke,"P",{"data-svelte-h":!0}),b(ro)!=="svelte-u9tliy"&&(ro.innerHTML=Cn),Ke.forEach(s),vt=a(X),ee=d(X,"DIV",{class:!0});var eo=L(ee);p(Me.$$.fragment,eo),yt=a(eo),ao=d(eo,"P",{"data-svelte-h":!0}),b(ao)!=="svelte-1j7rcpo"&&(ao.innerHTML=Un),eo.forEach(s),X.forEach(s),Qo=a(e),p($e.$$.fragment,e),Ko=a(e),N=d(e,"DIV",{class:!0});var A=L(N);p(Le.$$.fragment,A),wt=a(A),so=d(A,"P",{"data-svelte-h":!0}),b(so)!=="svelte-100hk3u"&&(so.textContent=In),Mt=a(A),U=d(A,"DIV",{class:!0});var J=L(U);p(Te.$$.fragment,J),$t=a(J),io=d(J,"P",{"data-svelte-h":!0}),b(io)!=="svelte-617c7s"&&(io.innerHTML=Fn),Lt=a(J),lo=d(J,"P",{"data-svelte-h":!0}),b(lo)!=="svelte-11lpom8"&&(lo.textContent=Jn),Tt=a(J),p(oe.$$.fragment,J),kt=a(J),co=d(J,"P",{"data-svelte-h":!0}),b(co)!=="svelte-2gddoh"&&(co.innerHTML=Zn),Ct=a(J),p(te.$$.fragment,J),J.forEach(s),Ut=a(A),ne=d(A,"DIV",{class:!0});var oo=L(ne);p(ke.$$.fragment,oo),It=a(oo),fo=d(oo,"P",{"data-svelte-h":!0}),b(fo)!=="svelte-gjjmbb"&&(fo.textContent=Nn),oo.forEach(s),A.forEach(s),et=a(e),p(Ce.$$.fragment,e),ot=a(e),j=d(e,"DIV",{class:!0});var O=L(j);p(Ue.$$.fragment,O),Ft=a(O),mo=d(O,"P",{"data-svelte-h":!0}),b(mo)!=="svelte-1powver"&&(mo.innerHTML=Dn),Jt=a(O),I=d(O,"DIV",{class:!0});var Z=L(I);p(Ie.$$.fragment,Z),Zt=a(Z),po=d(Z,"P",{"data-svelte-h":!0}),b(po)!=="svelte-vs7s0z"&&(po.innerHTML=Wn),Nt=a(Z),uo=d(Z,"P",{"data-svelte-h":!0}),b(uo)!=="svelte-15b960v"&&(uo.innerHTML=Sn),Dt=a(Z),ho=d(Z,"P",{"data-svelte-h":!0}),b(ho)!=="svelte-qj05o3"&&(ho.innerHTML=jn),Wt=a(Z),go=d(Z,"P",{"data-svelte-h":!0}),b(go)!=="svelte-ot29jq"&&(go.innerHTML=Pn),St=a(Z),_o=d(Z,"P",{"data-svelte-h":!0}),b(_o)!=="svelte-1ah097o"&&(_o.innerHTML=An),Z.forEach(s),O.forEach(s),tt=a(e),p(Fe.$$.fragment,e),nt=a(e),M=d(e,"DIV",{class:!0});var $=L(M);p(Je.$$.fragment,$),jt=a($),xo=d($,"P",{"data-svelte-h":!0}),b(xo)!=="svelte-1pb3n03"&&(xo.innerHTML=En),Pt=a($),re=d($,"DIV",{class:!0});var to=L(re);p(Ze.$$.fragment,to),At=a(to),bo=d(to,"P",{"data-svelte-h":!0}),b(bo)!=="svelte-tbr0r9"&&(bo.textContent=Rn),to.forEach(s),Et=a($),ae=d($,"DIV",{class:!0});var no=L(ae);p(Ne.$$.fragment,no),Rt=a(no),vo=d(no,"P",{"data-svelte-h":!0}),b(vo)!=="svelte-ujvdgi"&&(vo.textContent=Gn),no.forEach(s),Gt=a($),R=d($,"DIV",{class:!0});var jo=L(R);p(De.$$.fragment,jo),Ht=a(jo),yo=d(jo,"P",{"data-svelte-h":!0}),b(yo)!=="svelte-1nr2dy0"&&(yo.textContent=Hn),Vt=a(jo),p(se.$$.fragment,jo),jo.forEach(s),zt=a($),ie=d($,"DIV",{class:!0});var mt=L(ie);p(We.$$.fragment,mt),qt=a(mt),wo=d(mt,"P",{"data-svelte-h":!0}),b(wo)!=="svelte-1062ci4"&&(wo.innerHTML=Vn),mt.forEach(s),Bt=a($),de=d($,"DIV",{class:!0});var pt=L(de);p(Se.$$.fragment,pt),Yt=a(pt),Mo=d(pt,"P",{"data-svelte-h":!0}),b(Mo)!=="svelte-u3q4so"&&(Mo.innerHTML=zn),pt.forEach(s),Xt=a($),F=d($,"DIV",{class:!0});var W=L(F);p(je.$$.fragment,W),Ot=a(W),$o=d(W,"P",{"data-svelte-h":!0}),b($o)!=="svelte-vs7s0z"&&($o.innerHTML=qn),Qt=a(W),Lo=d(W,"P",{"data-svelte-h":!0}),b(Lo)!=="svelte-15b960v"&&(Lo.innerHTML=Bn),Kt=a(W),To=d(W,"P",{"data-svelte-h":!0}),b(To)!=="svelte-qj05o3"&&(To.innerHTML=Yn),en=a(W),ko=d(W,"P",{"data-svelte-h":!0}),b(ko)!=="svelte-ot29jq"&&(ko.innerHTML=Xn),on=a(W),Co=d(W,"P",{"data-svelte-h":!0}),b(Co)!=="svelte-1ah097o"&&(Co.innerHTML=On),W.forEach(s),tn=a($),G=d($,"DIV",{class:!0});var Po=L(G);p(Pe.$$.fragment,Po),nn=a(Po),Uo=d(Po,"P",{"data-svelte-h":!0}),b(Uo)!=="svelte-flusvq"&&(Uo.textContent=Qn),rn=a(Po),p(le.$$.fragment,Po),Po.forEach(s),an=a($),ce=d($,"DIV",{class:!0});var ut=L(ce);p(Ae.$$.fragment,ut),sn=a(ut),Io=d(ut,"P",{"data-svelte-h":!0}),b(Io)!=="svelte-1ufq5ot"&&(Io.textContent=Kn),ut.forEach(s),dn=a($),fe=d($,"DIV",{class:!0});var ht=L(fe);p(Ee.$$.fragment,ht),ln=a(ht),Fo=d(ht,"P",{"data-svelte-h":!0}),b(Fo)!=="svelte-kmejci"&&(Fo.textContent=er),ht.forEach(s),cn=a($),H=d($,"DIV",{class:!0});var Ao=L(H);p(Re.$$.fragment,Ao),fn=a(Ao),Jo=d(Ao,"P",{"data-svelte-h":!0}),b(Jo)!=="svelte-56a0bo"&&(Jo.innerHTML=or),mn=a(Ao),p(me.$$.fragment,Ao),Ao.forEach(s),pn=a($),V=d($,"DIV",{class:!0});var Eo=L(V);p(Ge.$$.fragment,Eo),un=a(Eo),Zo=d(Eo,"P",{"data-svelte-h":!0}),b(Zo)!=="svelte-119cgd9"&&(Zo.textContent=tr),hn=a(Eo),p(pe.$$.fragment,Eo),Eo.forEach(s),$.forEach(s),rt=a(e),p(He.$$.fragment,e),at=a(e),P=d(e,"DIV",{class:!0});var Ro=L(P);p(Ve.$$.fragment,Ro),gn=a(Ro),No=d(Ro,"P",{"data-svelte-h":!0}),b(No)!=="svelte-11v9qjy"&&(No.innerHTML=nr),_n=a(Ro),z=d(Ro,"DIV",{class:!0});var Go=L(z);p(ze.$$.fragment,Go),xn=a(Go),Do=d(Go,"P",{"data-svelte-h":!0}),b(Do)!=="svelte-pmqrln"&&(Do.innerHTML=rr),bn=a(Go),p(ue.$$.fragment,Go),Go.forEach(s),Ro.forEach(s),st=a(e),p(qe.$$.fragment,e),it=a(e),B=d(e,"DIV",{class:!0});var gt=L(B);p(Be.$$.fragment,gt),vn=a(gt),q=d(gt,"DIV",{class:!0});var Ho=L(q);p(Ye.$$.fragment,Ho),yn=a(Ho),Wo=d(Ho,"P",{"data-svelte-h":!0}),b(Wo)!=="svelte-1keh2nw"&&(Wo.innerHTML=ar),wn=a(Ho),p(he.$$.fragment,Ho),Ho.forEach(s),gt.forEach(s),dt=a(e),p(Xe.$$.fragment,e),lt=a(e),Y=d(e,"DIV",{class:!0});var _t=L(Y);p(Oe.$$.fragment,_t),Mn=a(_t),D=d(_t,"DIV",{class:!0});var xe=L(D);p(Qe.$$.fragment,xe),$n=a(xe),So=d(xe,"P",{"data-svelte-h":!0}),b(So)!=="svelte-12bf65c"&&(So.innerHTML=sr),Ln=a(xe),p(ge.$$.fragment,xe),Tn=a(xe),p(_e.$$.fragment,xe),xe.forEach(s),_t.forEach(s),ct=a(e),qo=d(e,"P",{}),L(qo).forEach(s),this.h()},h(){T(n,"name","hf:doc:metadata"),T(n,"content",$r),T(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,f){o(document.head,n),x(e,y,f),x(e,c,f),x(e,l,f),u(v,e,f),x(e,t,f),x(e,w,f),x(e,Yo,f),u(Q,e,f),x(e,Xo,f),u(ve,e,f),x(e,Oo,f),x(e,S,f),u(ye,S,null),o(S,xt),o(S,K),u(we,K,null),o(K,bt),o(K,ro),o(S,vt),o(S,ee),u(Me,ee,null),o(ee,yt),o(ee,ao),x(e,Qo,f),u($e,e,f),x(e,Ko,f),x(e,N,f),u(Le,N,null),o(N,wt),o(N,so),o(N,Mt),o(N,U),u(Te,U,null),o(U,$t),o(U,io),o(U,Lt),o(U,lo),o(U,Tt),u(oe,U,null),o(U,kt),o(U,co),o(U,Ct),u(te,U,null),o(N,Ut),o(N,ne),u(ke,ne,null),o(ne,It),o(ne,fo),x(e,et,f),u(Ce,e,f),x(e,ot,f),x(e,j,f),u(Ue,j,null),o(j,Ft),o(j,mo),o(j,Jt),o(j,I),u(Ie,I,null),o(I,Zt),o(I,po),o(I,Nt),o(I,uo),o(I,Dt),o(I,ho),o(I,Wt),o(I,go),o(I,St),o(I,_o),x(e,tt,f),u(Fe,e,f),x(e,nt,f),x(e,M,f),u(Je,M,null),o(M,jt),o(M,xo),o(M,Pt),o(M,re),u(Ze,re,null),o(re,At),o(re,bo),o(M,Et),o(M,ae),u(Ne,ae,null),o(ae,Rt),o(ae,vo),o(M,Gt),o(M,R),u(De,R,null),o(R,Ht),o(R,yo),o(R,Vt),u(se,R,null),o(M,zt),o(M,ie),u(We,ie,null),o(ie,qt),o(ie,wo),o(M,Bt),o(M,de),u(Se,de,null),o(de,Yt),o(de,Mo),o(M,Xt),o(M,F),u(je,F,null),o(F,Ot),o(F,$o),o(F,Qt),o(F,Lo),o(F,Kt),o(F,To),o(F,en),o(F,ko),o(F,on),o(F,Co),o(M,tn),o(M,G),u(Pe,G,null),o(G,nn),o(G,Uo),o(G,rn),u(le,G,null),o(M,an),o(M,ce),u(Ae,ce,null),o(ce,sn),o(ce,Io),o(M,dn),o(M,fe),u(Ee,fe,null),o(fe,ln),o(fe,Fo),o(M,cn),o(M,H),u(Re,H,null),o(H,fn),o(H,Jo),o(H,mn),u(me,H,null),o(M,pn),o(M,V),u(Ge,V,null),o(V,un),o(V,Zo),o(V,hn),u(pe,V,null),x(e,rt,f),u(He,e,f),x(e,at,f),x(e,P,f),u(Ve,P,null),o(P,gn),o(P,No),o(P,_n),o(P,z),u(ze,z,null),o(z,xn),o(z,Do),o(z,bn),u(ue,z,null),x(e,st,f),u(qe,e,f),x(e,it,f),x(e,B,f),u(Be,B,null),o(B,vn),o(B,q),u(Ye,q,null),o(q,yn),o(q,Wo),o(q,wn),u(he,q,null),x(e,dt,f),u(Xe,e,f),x(e,lt,f),x(e,Y,f),u(Oe,Y,null),o(Y,Mn),o(Y,D),u(Qe,D,null),o(D,$n),o(D,So),o(D,Ln),u(ge,D,null),o(D,Tn),u(_e,D,null),x(e,ct,f),x(e,qo,f),ft=!0},p(e,[f]){const X={};f&2&&(X.$$scope={dirty:f,ctx:e}),Q.$set(X);const Ke={};f&2&&(Ke.$$scope={dirty:f,ctx:e}),oe.$set(Ke);const eo={};f&2&&(eo.$$scope={dirty:f,ctx:e}),te.$set(eo);const A={};f&2&&(A.$$scope={dirty:f,ctx:e}),se.$set(A);const J={};f&2&&(J.$$scope={dirty:f,ctx:e}),le.$set(J);const oo={};f&2&&(oo.$$scope={dirty:f,ctx:e}),me.$set(oo);const O={};f&2&&(O.$$scope={dirty:f,ctx:e}),pe.$set(O);const Z={};f&2&&(Z.$$scope={dirty:f,ctx:e}),ue.$set(Z);const $={};f&2&&($.$$scope={dirty:f,ctx:e}),he.$set($);const to={};f&2&&(to.$$scope={dirty:f,ctx:e}),ge.$set(to);const no={};f&2&&(no.$$scope={dirty:f,ctx:e}),_e.$set(no)},i(e){ft||(h(v.$$.fragment,e),h(Q.$$.fragment,e),h(ve.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(Me.$$.fragment,e),h($e.$$.fragment,e),h(Le.$$.fragment,e),h(Te.$$.fragment,e),h(oe.$$.fragment,e),h(te.$$.fragment,e),h(ke.$$.fragment,e),h(Ce.$$.fragment,e),h(Ue.$$.fragment,e),h(Ie.$$.fragment,e),h(Fe.$$.fragment,e),h(Je.$$.fragment,e),h(Ze.$$.fragment,e),h(Ne.$$.fragment,e),h(De.$$.fragment,e),h(se.$$.fragment,e),h(We.$$.fragment,e),h(Se.$$.fragment,e),h(je.$$.fragment,e),h(Pe.$$.fragment,e),h(le.$$.fragment,e),h(Ae.$$.fragment,e),h(Ee.$$.fragment,e),h(Re.$$.fragment,e),h(me.$$.fragment,e),h(Ge.$$.fragment,e),h(pe.$$.fragment,e),h(He.$$.fragment,e),h(Ve.$$.fragment,e),h(ze.$$.fragment,e),h(ue.$$.fragment,e),h(qe.$$.fragment,e),h(Be.$$.fragment,e),h(Ye.$$.fragment,e),h(he.$$.fragment,e),h(Xe.$$.fragment,e),h(Oe.$$.fragment,e),h(Qe.$$.fragment,e),h(ge.$$.fragment,e),h(_e.$$.fragment,e),ft=!0)},o(e){g(v.$$.fragment,e),g(Q.$$.fragment,e),g(ve.$$.fragment,e),g(ye.$$.fragment,e),g(we.$$.fragment,e),g(Me.$$.fragment,e),g($e.$$.fragment,e),g(Le.$$.fragment,e),g(Te.$$.fragment,e),g(oe.$$.fragment,e),g(te.$$.fragment,e),g(ke.$$.fragment,e),g(Ce.$$.fragment,e),g(Ue.$$.fragment,e),g(Ie.$$.fragment,e),g(Fe.$$.fragment,e),g(Je.$$.fragment,e),g(Ze.$$.fragment,e),g(Ne.$$.fragment,e),g(De.$$.fragment,e),g(se.$$.fragment,e),g(We.$$.fragment,e),g(Se.$$.fragment,e),g(je.$$.fragment,e),g(Pe.$$.fragment,e),g(le.$$.fragment,e),g(Ae.$$.fragment,e),g(Ee.$$.fragment,e),g(Re.$$.fragment,e),g(me.$$.fragment,e),g(Ge.$$.fragment,e),g(pe.$$.fragment,e),g(He.$$.fragment,e),g(Ve.$$.fragment,e),g(ze.$$.fragment,e),g(ue.$$.fragment,e),g(qe.$$.fragment,e),g(Be.$$.fragment,e),g(Ye.$$.fragment,e),g(he.$$.fragment,e),g(Xe.$$.fragment,e),g(Oe.$$.fragment,e),g(Qe.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),ft=!1},d(e){e&&(s(y),s(c),s(l),s(t),s(w),s(Yo),s(Xo),s(Oo),s(S),s(Qo),s(Ko),s(N),s(et),s(ot),s(j),s(tt),s(nt),s(M),s(rt),s(at),s(P),s(st),s(it),s(B),s(dt),s(lt),s(Y),s(ct),s(qo)),s(n),_(v,e),_(Q,e),_(ve,e),_(ye),_(we),_(Me),_($e,e),_(Le),_(Te),_(oe),_(te),_(ke),_(Ce,e),_(Ue),_(Ie),_(Fe,e),_(Je),_(Ze),_(Ne),_(De),_(se),_(We),_(Se),_(je),_(Pe),_(le),_(Ae),_(Ee),_(Re),_(me),_(Ge),_(pe),_(He,e),_(Ve),_(ze),_(ue),_(qe,e),_(Be),_(Ye),_(he),_(Xe,e),_(Oe),_(Qe),_(ge),_(_e)}}}const $r='{"title":"Loaders","local":"loaders","sections":[{"title":"UNet2DConditionLoadersMixin","local":"diffusers.loaders.UNet2DConditionLoadersMixin","sections":[],"depth":2},{"title":"TextualInversionLoaderMixin","local":"diffusers.loaders.TextualInversionLoaderMixin","sections":[],"depth":2},{"title":"StableDiffusionXLLoraLoaderMixin","local":"diffusers.loaders.StableDiffusionXLLoraLoaderMixin","sections":[],"depth":2},{"title":"LoraLoaderMixin","local":"diffusers.loaders.LoraLoaderMixin","sections":[],"depth":2},{"title":"FromSingleFileMixin","local":"diffusers.loaders.FromSingleFileMixin","sections":[],"depth":2},{"title":"FromOriginalControlnetMixin","local":"diffusers.loaders.FromOriginalControlnetMixin","sections":[],"depth":2},{"title":"FromOriginalVAEMixin","local":"diffusers.loaders.FromOriginalVAEMixin","sections":[],"depth":2}],"depth":1}';function Lr(C){return dr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zr extends lr{constructor(n){super(),cr(this,n,Lr,Mr,ir,{})}}export{Zr as component};
