import{s as Dn,o as kn,n as Re}from"../chunks/scheduler.182ea377.js";import{S as Cn,i as $n,g as s,s as o,r as _,A as Un,h as a,f as l,c as i,j as C,u as x,x as p,k as $,y as t,a as u,v as b,d as P,t as v,w as y}from"../chunks/index.abf12888.js";import{T as jn}from"../chunks/Tip.230e2334.js";import{D as j}from"../chunks/Docstring.93f6f462.js";import{C as at}from"../chunks/CodeBlock.57fe6e13.js";import{E as st}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Vt}from"../chunks/Heading.16916d63.js";function Jn(U){let r,T='Make sure to check out the Schedulers <a href="/using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="/using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){r=s("p"),r.innerHTML=T},l(f){r=a(f,"P",{"data-svelte-h":!0}),p(r)!=="svelte-5fcsv6"&&(r.innerHTML=T)},m(f,d){u(f,r,d)},p:Re,d(f){f&&l(r)}}}function Xn(U){let r,T="Examples:",f,d,g;return d=new at({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEElMEElMEFkZWYlMjBkb3dubG9hZF9pbWFnZSh1cmwpJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFBJTC5JbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkaWZmdXNlcnMtaW1hZ2VzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRm1vdW50YWluLnBuZyUyMiUwQSUwQWltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UoaW1nX3VybCkucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIydGltYnJvb2tzJTJGaW5zdHJ1Y3QtcGl4MnBpeCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMm1ha2UlMjB0aGUlMjBtb3VudGFpbnMlMjBzbm93eSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
<span class="hljs-meta">... </span>    response = requests.get(url)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionInstructPix2PixPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;make the mountains snowy&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){r=s("p"),r.textContent=T,f=o(),_(d.$$.fragment)},l(n){r=a(n,"P",{"data-svelte-h":!0}),p(r)!=="svelte-kvfsh7"&&(r.textContent=T),f=i(n),x(d.$$.fragment,n)},m(n,w){u(n,r,w),u(n,f,w),b(d,n,w),g=!0},p:Re,i(n){g||(P(d.$$.fragment,n),g=!0)},o(n){v(d.$$.fragment,n),g=!1},d(n){n&&(l(r),l(f)),y(d,n)}}}function Nn(U){let r,T="To load a textual inversion embedding vector in 🤗 Diffusers format:",f,d,g;return d=new at({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){r=s("p"),r.textContent=T,f=o(),_(d.$$.fragment)},l(n){r=a(n,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1y13ww6"&&(r.textContent=T),f=i(n),x(d.$$.fragment,n)},m(n,w){u(n,r,w),u(n,f,w),b(d,n,w),g=!0},p:Re,i(n){g||(P(d.$$.fragment,n),g=!0)},o(n){v(d.$$.fragment,n),g=!1},d(n){n&&(l(r),l(f)),y(d,n)}}}function Wn(U){let r,T="locally:",f,d,g;return d=new at({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){r=s("p"),r.textContent=T,f=o(),_(d.$$.fragment)},l(n){r=a(n,"P",{"data-svelte-h":!0}),p(r)!=="svelte-4c75kq"&&(r.textContent=T),f=i(n),x(d.$$.fragment,n)},m(n,w){u(n,r,w),u(n,f,w),b(d,n,w),g=!0},p:Re,i(n){g||(P(d.$$.fragment,n),g=!0)},o(n){v(d.$$.fragment,n),g=!1},d(n){n&&(l(r),l(f)),y(d,n)}}}function Zn(U){let r,T="Examples:",f,d,g;return d=new at({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExJbnN0cnVjdFBpeDJQaXhQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcmVzb2x1dGlvbiUyMCUzRCUyMDc2OCUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmhmLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkaWZmdXNlcnMtaW1hZ2VzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRm1vdW50YWluLnBuZyUyMiUwQSkucmVzaXplKChyZXNvbHV0aW9uJTJDJTIwcmVzb2x1dGlvbikpJTBBZWRpdF9pbnN0cnVjdGlvbiUyMCUzRCUyMCUyMlR1cm4lMjBza3klMjBpbnRvJTIwYSUyMGNsb3VkeSUyMG9uZSUyMiUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEluc3RydWN0UGl4MlBpeFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMkZzZHhsLWluc3RydWN0cGl4MnBpeC03NjglMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBZWRpdGVkX2ltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0RlZGl0X2luc3RydWN0aW9uJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRHJlc29sdXRpb24lMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRHJlc29sdXRpb24lMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDMuMCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX2d1aWRhbmNlX3NjYWxlJTNEMS41JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBZWRpdGVkX2ltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLInstructPix2PixPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>resolution = <span class="hljs-number">768</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png&quot;</span>
<span class="hljs-meta">... </span>).resize((resolution, resolution))
<span class="hljs-meta">&gt;&gt;&gt; </span>edit_instruction = <span class="hljs-string">&quot;Turn sky into a cloudy one&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLInstructPix2PixPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;diffusers/sdxl-instructpix2pix-768&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>edited_image = pipe(
<span class="hljs-meta">... </span>    prompt=edit_instruction,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    height=resolution,
<span class="hljs-meta">... </span>    width=resolution,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">3.0</span>,
<span class="hljs-meta">... </span>    image_guidance_scale=<span class="hljs-number">1.5</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>edited_image`,wrap:!1}}),{c(){r=s("p"),r.textContent=T,f=o(),_(d.$$.fragment)},l(n){r=a(n,"P",{"data-svelte-h":!0}),p(r)!=="svelte-kvfsh7"&&(r.textContent=T),f=i(n),x(d.$$.fragment,n)},m(n,w){u(n,r,w),u(n,f,w),b(d,n,w),g=!0},p:Re,i(n){g||(P(d.$$.fragment,n),g=!0)},o(n){v(d.$$.fragment,n),g=!1},d(n){n&&(l(r),l(f)),y(d,n)}}}function zn(U){let r,T,f,d,g,n,w,Yt='<a href="https://huggingface.co/papers/2211.09800" rel="nofollow">InstructPix2Pix: Learning to Follow Image Editing Instructions</a> is by Tim Brooks, Aleksander Holynski and Alexei A. Efros.',He,V,Qt="The abstract from the paper is:",qe,Y,Ot="<em>We propose a method for editing images from human instructions: given an input image and a written instruction that tells the model what to do, our model follows these instructions to edit the image. To obtain training data for this problem, we combine the knowledge of two large pretrained models — a language model (GPT-3) and a text-to-image model (Stable Diffusion) — to generate a large dataset of image editing examples. Our conditional diffusion model, InstructPix2Pix, is trained on our generated data, and generalizes to real images and user-written instructions at inference time. Since it performs edits in the forward pass and does not require per example fine-tuning or inversion, our model edits images quickly, in a matter of seconds. We show compelling editing results for a diverse collection of input images and written instructions.</em>",Ae,Q,Kt='You can find additional information about InstructPix2Pix on the <a href="https://www.timothybrooks.com/instruct-pix2pix" rel="nofollow">project page</a>, <a href="https://github.com/timothybrooks/instruct-pix2pix" rel="nofollow">original codebase</a>, and try it out in a <a href="https://huggingface.co/spaces/timbrooks/instruct-pix2pix" rel="nofollow">demo</a>.',Ve,z,Ye,O,Qe,I,K,rt,me,en="Pipeline for pixel-level image editing by following text instructions (based on Stable Diffusion).",lt,ue,tn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,dt,ge,nn="The pipeline also inherits the following loading methods:",ct,he,on='<li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',pt,J,ee,ft,_e,sn="The call function to the pipeline for generation.",mt,G,ut,L,te,gt,xe,an=`Load textual inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,ht,be,rn="Example:",_t,F,xt,Pe,ln=`To load a textual inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,bt,B,Pt,S,ne,vt,ve,dn=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,yt,ye,cn="All kwargs are forwarded to <code>self.lora_state_dict</code>.",wt,we,pn='See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',It,Ie,fn=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,Mt,Me,mn=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,Tt,E,oe,Lt,Te,un="Save the LoRA parameters corresponding to the UNet and text encoder.",Oe,ie,Ke,m,se,St,Le,gn="Pipeline for pixel-level image editing by following text instructions. Based on Stable Diffusion XL.",Dt,Se,hn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,kt,De,_n="In addition the pipeline inherits the following loading methods:",Ct,ke,xn='<li><em>LoRA</em>: <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights()</a></li>',$t,Ce,bn="as well as the following saving methods:",Ut,$e,Pn="<li><em>LoRA</em>: <code>loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights()</code></li>",jt,X,ae,Jt,Ue,vn="Function invoked when calling the pipeline for generation.",Xt,R,Nt,H,re,Wt,je,yn=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously invoked, this method will go back to
computing decoding in one step.`,Zt,q,le,zt,Je,wn=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously invoked, this method will go back to
computing decoding in one step.`,Gt,N,de,Ft,Xe,In="Enable sliced VAE decoding.",Bt,Ne,Mn=`When this option is enabled, the VAE will split the input tensor in slices to compute decoding in several
steps. This is useful to save some memory and allow larger batch sizes.`,Et,W,ce,Rt,We,Tn="Enable tiled VAE decoding.",Ht,Ze,Ln=`When this option is enabled, the VAE will split the input tensor into tiles to compute decoding and encoding in
several steps. This is useful to save a large amount of memory and to allow the processing of larger images.`,qt,A,pe,At,ze,Sn="Encodes the prompt into text encoder hidden states.",et,Ee,tt;return g=new Vt({props:{title:"InstructPix2Pix",local:"instructpix2pix",headingTag:"h1"}}),z=new jn({props:{$$slots:{default:[Jn]},$$scope:{ctx:U}}}),O=new Vt({props:{title:"StableDiffusionInstructPix2PixPipeline",local:"diffusers.StableDiffusionInstructPix2PixPipeline",headingTag:"h2"}}),K=new j({props:{name:"class diffusers.StableDiffusionInstructPix2PixPipeline",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L61"}}),ee=new j({props:{name:"__call__",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 7.5"},{name:"image_guidance_scale",val:": float = 1.5"},{name:"negative_prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code> <code>np.ndarray</code>, <code>PIL.Image.Image</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code> or tensor representing an image batch to be repainted according to <code>prompt</code>. Can also accept
image latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.image_guidance_scale",description:`<strong>image_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.5) &#x2014;
Push the generated image towards the inital <code>image</code>. Image guidance scale is enabled by setting
<code>image_guidance_scale &gt; 1</code>. Higher image guidance scale encourages generated images that are closely
linked to the source <code>image</code>, usually at the expense of lower image quality. This pipeline requires a
value of at least <code>1</code>.`,name:"image_guidance_scale"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L138",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),G=new st({props:{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.example",$$slots:{default:[Xn]},$$scope:{ctx:U}}}),te=new j({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, typing.List[str], typing.Dict[str, torch.Tensor], typing.List[typing.Dict[str, torch.Tensor]]]"},{name:"token",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[ForwardRef('PreTrainedTokenizer')] = None"},{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L919"}}),F=new st({props:{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.example",$$slots:{default:[Nn]},$$scope:{ctx:U}}}),B=new st({props:{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.example-2",$$slots:{default:[Wn]},$$scope:{ctx:U}}}),ne=new j({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L1109"}}),oe=new j({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"unet_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"text_encoder_lora_layers",val:": typing.Dict[str, torch.nn.modules.module.Module] = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L1806"}}),ie=new Vt({props:{title:"StableDiffusionXLInstructPix2PixPipeline",local:"diffusers.StableDiffusionXLInstructPix2PixPipeline",headingTag:"h2"}}),se=new j({props:{name:"class diffusers.StableDiffusionXLInstructPix2PixPipeline",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion XL uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code> CLIPTextModelWithProjection</code>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.requires_aesthetics_score",description:`<strong>requires_aesthetics_score</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;False&quot;</code>) &#x2014;
Whether the <code>unet</code> requires a aesthetic_score condition to be passed during inference. Also see the config
of <code>stabilityai/stable-diffusion-xl-refiner-1-0</code>.`,name:"requires_aesthetics_score"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings shall be forced to always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark library</a> to
watermark output images. If not defined, it will default to True if the package is installed, otherwise no
watermarker will be used.`,name:"add_watermarker"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L95"}}),ae=new j({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 100"},{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"image_guidance_scale",val:": float = 1.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Tuple[int, int] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Tuple[int, int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code> or <code>PIL.Image.Image</code> or <code>np.ndarray</code> or <code>List[torch.FloatTensor]</code> or <code>List[PIL.Image.Image]</code> or <code>List[np.ndarray]</code>) &#x2014;
The image(s) to modify with the pipeline.`,name:"image"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.image_guidance_scale",description:`<strong>image_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.5) &#x2014;
Image guidance scale is to push the generated image towards the inital image <code>image</code>. Image guidance
scale is enabled by setting <code>image_guidance_scale &gt; 1</code>. Higher image guidance scale encourages to
generate images that are closely linked to the source image <code>image</code>, usually at the expense of lower
image quality. This pipeline requires a value of at least <code>1</code>.`,name:"image_guidance_scale"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L583",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),R=new st({props:{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.example",$$slots:{default:[Zn]},$$scope:{ctx:U}}}),re=new j({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L190"}}),le=new j({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L206"}}),de=new j({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L181"}}),ce=new j({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L197"}}),pe=new j({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": typing.Optional[str] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt_2",val:": typing.Optional[str] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L213"}}),{c(){r=s("meta"),T=o(),f=s("p"),d=o(),_(g.$$.fragment),n=o(),w=s("p"),w.innerHTML=Yt,He=o(),V=s("p"),V.textContent=Qt,qe=o(),Y=s("p"),Y.innerHTML=Ot,Ae=o(),Q=s("p"),Q.innerHTML=Kt,Ve=o(),_(z.$$.fragment),Ye=o(),_(O.$$.fragment),Qe=o(),I=s("div"),_(K.$$.fragment),rt=o(),me=s("p"),me.textContent=en,lt=o(),ue=s("p"),ue.innerHTML=tn,dt=o(),ge=s("p"),ge.textContent=nn,ct=o(),he=s("ul"),he.innerHTML=on,pt=o(),J=s("div"),_(ee.$$.fragment),ft=o(),_e=s("p"),_e.textContent=sn,mt=o(),_(G.$$.fragment),ut=o(),L=s("div"),_(te.$$.fragment),gt=o(),xe=s("p"),xe.innerHTML=an,ht=o(),be=s("p"),be.textContent=rn,_t=o(),_(F.$$.fragment),xt=o(),Pe=s("p"),Pe.innerHTML=ln,bt=o(),_(B.$$.fragment),Pt=o(),S=s("div"),_(ne.$$.fragment),vt=o(),ve=s("p"),ve.innerHTML=dn,yt=o(),ye=s("p"),ye.innerHTML=cn,wt=o(),we=s("p"),we.innerHTML=pn,It=o(),Ie=s("p"),Ie.innerHTML=fn,Mt=o(),Me=s("p"),Me.innerHTML=mn,Tt=o(),E=s("div"),_(oe.$$.fragment),Lt=o(),Te=s("p"),Te.textContent=un,Oe=o(),_(ie.$$.fragment),Ke=o(),m=s("div"),_(se.$$.fragment),St=o(),Le=s("p"),Le.textContent=gn,Dt=o(),Se=s("p"),Se.innerHTML=hn,kt=o(),De=s("p"),De.textContent=_n,Ct=o(),ke=s("ul"),ke.innerHTML=xn,$t=o(),Ce=s("p"),Ce.textContent=bn,Ut=o(),$e=s("ul"),$e.innerHTML=Pn,jt=o(),X=s("div"),_(ae.$$.fragment),Jt=o(),Ue=s("p"),Ue.textContent=vn,Xt=o(),_(R.$$.fragment),Nt=o(),H=s("div"),_(re.$$.fragment),Wt=o(),je=s("p"),je.innerHTML=yn,Zt=o(),q=s("div"),_(le.$$.fragment),zt=o(),Je=s("p"),Je.innerHTML=wn,Gt=o(),N=s("div"),_(de.$$.fragment),Ft=o(),Xe=s("p"),Xe.textContent=In,Bt=o(),Ne=s("p"),Ne.textContent=Mn,Et=o(),W=s("div"),_(ce.$$.fragment),Rt=o(),We=s("p"),We.textContent=Tn,Ht=o(),Ze=s("p"),Ze.textContent=Ln,qt=o(),A=s("div"),_(pe.$$.fragment),At=o(),ze=s("p"),ze.textContent=Sn,et=o(),Ee=s("p"),this.h()},l(e){const c=Un("svelte-u9bgzb",document.head);r=a(c,"META",{name:!0,content:!0}),c.forEach(l),T=i(e),f=a(e,"P",{}),C(f).forEach(l),d=i(e),x(g.$$.fragment,e),n=i(e),w=a(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1tl4gnd"&&(w.innerHTML=Yt),He=i(e),V=a(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1cwsb16"&&(V.textContent=Qt),qe=i(e),Y=a(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1gbgk0u"&&(Y.innerHTML=Ot),Ae=i(e),Q=a(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-18wh1q7"&&(Q.innerHTML=Kt),Ve=i(e),x(z.$$.fragment,e),Ye=i(e),x(O.$$.fragment,e),Qe=i(e),I=a(e,"DIV",{class:!0});var M=C(I);x(K.$$.fragment,M),rt=i(M),me=a(M,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1gz00nq"&&(me.textContent=en),lt=i(M),ue=a(M,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-496sm0"&&(ue.innerHTML=tn),dt=i(M),ge=a(M,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-14s6m4u"&&(ge.textContent=nn),ct=i(M),he=a(M,"UL",{"data-svelte-h":!0}),p(he)!=="svelte-omhkhg"&&(he.innerHTML=on),pt=i(M),J=a(M,"DIV",{class:!0});var Z=C(J);x(ee.$$.fragment,Z),ft=i(Z),_e=a(Z,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-50j04k"&&(_e.textContent=sn),mt=i(Z),x(G.$$.fragment,Z),Z.forEach(l),ut=i(M),L=a(M,"DIV",{class:!0});var D=C(L);x(te.$$.fragment,D),gt=i(D),xe=a(D,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-617c7s"&&(xe.innerHTML=an),ht=i(D),be=a(D,"P",{"data-svelte-h":!0}),p(be)!=="svelte-11lpom8"&&(be.textContent=rn),_t=i(D),x(F.$$.fragment,D),xt=i(D),Pe=a(D,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-2gddoh"&&(Pe.innerHTML=ln),bt=i(D),x(B.$$.fragment,D),D.forEach(l),Pt=i(M),S=a(M,"DIV",{class:!0});var k=C(S);x(ne.$$.fragment,k),vt=i(k),ve=a(k,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-vs7s0z"&&(ve.innerHTML=dn),yt=i(k),ye=a(k,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-15b960v"&&(ye.innerHTML=cn),wt=i(k),we=a(k,"P",{"data-svelte-h":!0}),p(we)!=="svelte-qj05o3"&&(we.innerHTML=pn),It=i(k),Ie=a(k,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-ot29jq"&&(Ie.innerHTML=fn),Mt=i(k),Me=a(k,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1ah097o"&&(Me.innerHTML=mn),k.forEach(l),Tt=i(M),E=a(M,"DIV",{class:!0});var fe=C(E);x(oe.$$.fragment,fe),Lt=i(fe),Te=a(fe,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1ufq5ot"&&(Te.textContent=un),fe.forEach(l),M.forEach(l),Oe=i(e),x(ie.$$.fragment,e),Ke=i(e),m=a(e,"DIV",{class:!0});var h=C(m);x(se.$$.fragment,h),St=i(h),Le=a(h,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1n3req3"&&(Le.textContent=gn),Dt=i(h),Se=a(h,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-wu1jmh"&&(Se.innerHTML=hn),kt=i(h),De=a(h,"P",{"data-svelte-h":!0}),p(De)!=="svelte-984r3o"&&(De.textContent=_n),Ct=i(h),ke=a(h,"UL",{"data-svelte-h":!0}),p(ke)!=="svelte-wacfqw"&&(ke.innerHTML=xn),$t=i(h),Ce=a(h,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-19qtqre"&&(Ce.textContent=bn),Ut=i(h),$e=a(h,"UL",{"data-svelte-h":!0}),p($e)!=="svelte-1lnbtw8"&&($e.innerHTML=Pn),jt=i(h),X=a(h,"DIV",{class:!0});var Ge=C(X);x(ae.$$.fragment,Ge),Jt=i(Ge),Ue=a(Ge,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-v78lg8"&&(Ue.textContent=vn),Xt=i(Ge),x(R.$$.fragment,Ge),Ge.forEach(l),Nt=i(h),H=a(h,"DIV",{class:!0});var nt=C(H);x(re.$$.fragment,nt),Wt=i(nt),je=a(nt,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1lk12qh"&&(je.innerHTML=yn),nt.forEach(l),Zt=i(h),q=a(h,"DIV",{class:!0});var ot=C(q);x(le.$$.fragment,ot),zt=i(ot),Je=a(ot,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-elsxjh"&&(Je.innerHTML=wn),ot.forEach(l),Gt=i(h),N=a(h,"DIV",{class:!0});var Fe=C(N);x(de.$$.fragment,Fe),Ft=i(Fe),Xe=a(Fe,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-ssd5ny"&&(Xe.textContent=In),Bt=i(Fe),Ne=a(Fe,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-62zig4"&&(Ne.textContent=Mn),Fe.forEach(l),Et=i(h),W=a(h,"DIV",{class:!0});var Be=C(W);x(ce.$$.fragment,Be),Rt=i(Be),We=a(Be,"P",{"data-svelte-h":!0}),p(We)!=="svelte-4j2l7q"&&(We.textContent=Tn),Ht=i(Be),Ze=a(Be,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1biw85q"&&(Ze.textContent=Ln),Be.forEach(l),qt=i(h),A=a(h,"DIV",{class:!0});var it=C(A);x(pe.$$.fragment,it),At=i(it),ze=a(it,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-16q0ax1"&&(ze.textContent=Sn),it.forEach(l),h.forEach(l),et=i(e),Ee=a(e,"P",{}),C(Ee).forEach(l),this.h()},h(){$(r,"name","hf:doc:metadata"),$(r,"content",Gn),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,r),u(e,T,c),u(e,f,c),u(e,d,c),b(g,e,c),u(e,n,c),u(e,w,c),u(e,He,c),u(e,V,c),u(e,qe,c),u(e,Y,c),u(e,Ae,c),u(e,Q,c),u(e,Ve,c),b(z,e,c),u(e,Ye,c),b(O,e,c),u(e,Qe,c),u(e,I,c),b(K,I,null),t(I,rt),t(I,me),t(I,lt),t(I,ue),t(I,dt),t(I,ge),t(I,ct),t(I,he),t(I,pt),t(I,J),b(ee,J,null),t(J,ft),t(J,_e),t(J,mt),b(G,J,null),t(I,ut),t(I,L),b(te,L,null),t(L,gt),t(L,xe),t(L,ht),t(L,be),t(L,_t),b(F,L,null),t(L,xt),t(L,Pe),t(L,bt),b(B,L,null),t(I,Pt),t(I,S),b(ne,S,null),t(S,vt),t(S,ve),t(S,yt),t(S,ye),t(S,wt),t(S,we),t(S,It),t(S,Ie),t(S,Mt),t(S,Me),t(I,Tt),t(I,E),b(oe,E,null),t(E,Lt),t(E,Te),u(e,Oe,c),b(ie,e,c),u(e,Ke,c),u(e,m,c),b(se,m,null),t(m,St),t(m,Le),t(m,Dt),t(m,Se),t(m,kt),t(m,De),t(m,Ct),t(m,ke),t(m,$t),t(m,Ce),t(m,Ut),t(m,$e),t(m,jt),t(m,X),b(ae,X,null),t(X,Jt),t(X,Ue),t(X,Xt),b(R,X,null),t(m,Nt),t(m,H),b(re,H,null),t(H,Wt),t(H,je),t(m,Zt),t(m,q),b(le,q,null),t(q,zt),t(q,Je),t(m,Gt),t(m,N),b(de,N,null),t(N,Ft),t(N,Xe),t(N,Bt),t(N,Ne),t(m,Et),t(m,W),b(ce,W,null),t(W,Rt),t(W,We),t(W,Ht),t(W,Ze),t(m,qt),t(m,A),b(pe,A,null),t(A,At),t(A,ze),u(e,et,c),u(e,Ee,c),tt=!0},p(e,[c]){const M={};c&2&&(M.$$scope={dirty:c,ctx:e}),z.$set(M);const Z={};c&2&&(Z.$$scope={dirty:c,ctx:e}),G.$set(Z);const D={};c&2&&(D.$$scope={dirty:c,ctx:e}),F.$set(D);const k={};c&2&&(k.$$scope={dirty:c,ctx:e}),B.$set(k);const fe={};c&2&&(fe.$$scope={dirty:c,ctx:e}),R.$set(fe)},i(e){tt||(P(g.$$.fragment,e),P(z.$$.fragment,e),P(O.$$.fragment,e),P(K.$$.fragment,e),P(ee.$$.fragment,e),P(G.$$.fragment,e),P(te.$$.fragment,e),P(F.$$.fragment,e),P(B.$$.fragment,e),P(ne.$$.fragment,e),P(oe.$$.fragment,e),P(ie.$$.fragment,e),P(se.$$.fragment,e),P(ae.$$.fragment,e),P(R.$$.fragment,e),P(re.$$.fragment,e),P(le.$$.fragment,e),P(de.$$.fragment,e),P(ce.$$.fragment,e),P(pe.$$.fragment,e),tt=!0)},o(e){v(g.$$.fragment,e),v(z.$$.fragment,e),v(O.$$.fragment,e),v(K.$$.fragment,e),v(ee.$$.fragment,e),v(G.$$.fragment,e),v(te.$$.fragment,e),v(F.$$.fragment,e),v(B.$$.fragment,e),v(ne.$$.fragment,e),v(oe.$$.fragment,e),v(ie.$$.fragment,e),v(se.$$.fragment,e),v(ae.$$.fragment,e),v(R.$$.fragment,e),v(re.$$.fragment,e),v(le.$$.fragment,e),v(de.$$.fragment,e),v(ce.$$.fragment,e),v(pe.$$.fragment,e),tt=!1},d(e){e&&(l(T),l(f),l(d),l(n),l(w),l(He),l(V),l(qe),l(Y),l(Ae),l(Q),l(Ve),l(Ye),l(Qe),l(I),l(Oe),l(Ke),l(m),l(et),l(Ee)),l(r),y(g,e),y(z,e),y(O,e),y(K),y(ee),y(G),y(te),y(F),y(B),y(ne),y(oe),y(ie,e),y(se),y(ae),y(R),y(re),y(le),y(de),y(ce),y(pe)}}}const Gn='{"title":"InstructPix2Pix","local":"instructpix2pix","sections":[{"title":"StableDiffusionInstructPix2PixPipeline","local":"diffusers.StableDiffusionInstructPix2PixPipeline","sections":[],"depth":2},{"title":"StableDiffusionXLInstructPix2PixPipeline","local":"diffusers.StableDiffusionXLInstructPix2PixPipeline","sections":[],"depth":2}],"depth":1}';function Fn(U){return kn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yn extends Cn{constructor(r){super(),$n(this,r,Fn,zn,Dn,{})}}export{Yn as component};
