import{s as be,z as fe,o as Je,n as ge}from"../chunks/scheduler.182ea377.js";import{S as Me,i as we,g as p,s,r as h,A as Ue,h as m,f as t,c as l,j as se,u as d,x as c,k as V,y as Te,a as n,v as y,d as b,t as f,w as J}from"../chunks/index.abf12888.js";import{T as We}from"../chunks/Tip.230e2334.js";import{C as ne}from"../chunks/CodeBlock.57fe6e13.js";import{D as Ze}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as ye}from"../chunks/Heading.16916d63.js";function ke(S){let i,g="A previous experimental implementation of inpainting used a different, lower-quality process. To ensure backwards compatibility, loading a pretrained pipeline that doesn’t contain the new model will still apply the old inpainting method.";return{c(){i=p("p"),i.textContent=g},l(o){i=m(o,"P",{"data-svelte-h":!0}),c(i)!=="svelte-bjwqv6"&&(i.textContent=g)},m(o,F){n(o,i,F)},p:ge,d(o){o&&t(i)}}}function je(S){let i,g,o,F,M,R,w,$,U,le='The <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline">StableDiffusionInpaintPipeline</a> allows you to edit specific parts of an image by providing a mask and a text prompt. It uses a version of Stable Diffusion, like <a href="https://huggingface.co/runwayml/stable-diffusion-inpainting" rel="nofollow"><code>runwayml/stable-diffusion-inpainting</code></a> specifically trained for inpainting tasks.',x,T,ie='Get started by loading an instance of the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline">StableDiffusionInpaintPipeline</a>:',N,W,Q,Z,pe="Download an image and a mask of a dog which you’ll eventually replace:",E,k,z,j,me="Now you can create a prompt to replace the mask with something else:",H,I,D,_,oe='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>Face of a yellow cat, high resolution, sitting on a park bench</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/in_paint/yellow_cat_sitting_on_a_park_bench.png" alt="drawing" width="250"/></td></tr></tbody>',q,u,P,G,re="Check out the Spaces below to try out image inpainting yourself!",K,r,ce,L,B,A,X,ue='Generally speaking, <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline">StableDiffusionInpaintPipeline</a> (and other inpainting pipelines) will change the unmasked part of the image as well. If this behavior is undesirable, you can force the unmasked area to remain the same as follows:',O,C,ee,v,he="Forcing the unmasked portion of the image to remain the same might result in some weird transitions between the unmasked and masked areas, since the model will typically change the masked and unmasked areas to make the transition more natural.",ae,Y,te;return M=new ye({props:{title:"Text-guided image-inpainting",local:"text-guided-image-inpainting",headingTag:"h1"}}),w=new Ze({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/inpaint.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/inpaint.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/inpaint.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/inpaint.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/inpaint.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/inpaint.ipynb"}]}}),W=new ne({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnBhaW50UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi1pbnBhaW50aW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBKSUwQXBpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInpaintPipeline

pipeline = StableDiffusionInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),k=new ne({props:{code:"ZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBQSUwuSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW8ucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1b19tYXNrLnBuZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZShpbWdfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBbWFza19pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKG1hc2tfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))`,wrap:!1}}),I=new ne({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyRmFjZSUyMG9mJTIwYSUyMHllbGxvdyUyMGNhdCUyQyUyMGhpZ2glMjByZXNvbHV0aW9uJTJDJTIwc2l0dGluZyUyMG9uJTIwYSUyMHBhcmslMjBiZW5jaCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UpLmltYWdlcyU1QjAlNUQ=",highlighted:`prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),u=new We({props:{warning:!0,$$slots:{default:[ke]},$$scope:{ctx:S}}}),B=new ye({props:{title:"Preserving the Unmasked Area of the Image",local:"preserving-the-unmasked-area-of-the-image",headingTag:"h2"}}),C=new ne({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

device = <span class="hljs-string">&quot;cuda&quot;</span>
pipeline = StableDiffusionInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>,
    torch_dtype=torch.float16,
)
pipeline = pipeline.to(device)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = load_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = load_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
repainted_image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
repainted_image.save(<span class="hljs-string">&quot;repainted_image.png&quot;</span>)

<span class="hljs-comment"># Convert mask to grayscale NumPy array</span>
mask_image_arr = np.array(mask_image.convert(<span class="hljs-string">&quot;L&quot;</span>))
<span class="hljs-comment"># Add a channel dimension to the end of the grayscale mask</span>
mask_image_arr = mask_image_arr[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-comment"># Binarize the mask: 1s correspond to the pixels which are repainted</span>
mask_image_arr = mask_image_arr.astype(np.float32) / <span class="hljs-number">255.0</span>
mask_image_arr[mask_image_arr &lt; <span class="hljs-number">0.5</span>] = <span class="hljs-number">0</span>
mask_image_arr[mask_image_arr &gt;= <span class="hljs-number">0.5</span>] = <span class="hljs-number">1</span>

<span class="hljs-comment"># Take the masked pixels from the repainted image and the unmasked pixels from the initial image</span>
unmasked_unchanged_image_arr = (<span class="hljs-number">1</span> - mask_image_arr) * init_image + mask_image_arr * repainted_image
unmasked_unchanged_image = PIL.Image.fromarray(unmasked_unchanged_image_arr.<span class="hljs-built_in">round</span>().astype(<span class="hljs-string">&quot;uint8&quot;</span>))
unmasked_unchanged_image.save(<span class="hljs-string">&quot;force_unmasked_unchanged.png&quot;</span>)`,wrap:!1}}),{c(){i=p("meta"),g=s(),o=p("p"),F=s(),h(M.$$.fragment),R=s(),h(w.$$.fragment),$=s(),U=p("p"),U.innerHTML=le,x=s(),T=p("p"),T.innerHTML=ie,N=s(),h(W.$$.fragment),Q=s(),Z=p("p"),Z.textContent=pe,E=s(),h(k.$$.fragment),z=s(),j=p("p"),j.textContent=me,H=s(),h(I.$$.fragment),D=s(),_=p("table"),_.innerHTML=oe,q=s(),h(u.$$.fragment),P=s(),G=p("p"),G.textContent=re,K=s(),r=p("iframe"),L=s(),h(B.$$.fragment),A=s(),X=p("p"),X.innerHTML=ue,O=s(),h(C.$$.fragment),ee=s(),v=p("p"),v.textContent=he,ae=s(),Y=p("p"),this.h()},l(e){const a=Ue("svelte-u9bgzb",document.head);i=m(a,"META",{name:!0,content:!0}),a.forEach(t),g=l(e),o=m(e,"P",{}),se(o).forEach(t),F=l(e),d(M.$$.fragment,e),R=l(e),d(w.$$.fragment,e),$=l(e),U=m(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-tqqrfq"&&(U.innerHTML=le),x=l(e),T=m(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-1n84occ"&&(T.innerHTML=ie),N=l(e),d(W.$$.fragment,e),Q=l(e),Z=m(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-o2idc"&&(Z.textContent=pe),E=l(e),d(k.$$.fragment,e),z=l(e),j=m(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-y19iwn"&&(j.textContent=me),H=l(e),d(I.$$.fragment,e),D=l(e),_=m(e,"TABLE",{"data-svelte-h":!0}),c(_)!=="svelte-1ysshya"&&(_.innerHTML=oe),q=l(e),d(u.$$.fragment,e),P=l(e),G=m(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-jbyrv1"&&(G.textContent=re),K=l(e),r=m(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),se(r).forEach(t),L=l(e),d(B.$$.fragment,e),A=l(e),X=m(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-170unqf"&&(X.innerHTML=ue),O=l(e),d(C.$$.fragment,e),ee=l(e),v=m(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-19icbpd"&&(v.textContent=he),ae=l(e),Y=m(e,"P",{}),se(Y).forEach(t),this.h()},h(){V(i,"name","hf:doc:metadata"),V(i,"content",Ie),fe(r.src,ce="https://runwayml-stable-diffusion-inpainting.hf.space")||V(r,"src",ce),V(r,"frameborder","0"),V(r,"width","850"),V(r,"height","500")},m(e,a){Te(document.head,i),n(e,g,a),n(e,o,a),n(e,F,a),y(M,e,a),n(e,R,a),y(w,e,a),n(e,$,a),n(e,U,a),n(e,x,a),n(e,T,a),n(e,N,a),y(W,e,a),n(e,Q,a),n(e,Z,a),n(e,E,a),y(k,e,a),n(e,z,a),n(e,j,a),n(e,H,a),y(I,e,a),n(e,D,a),n(e,_,a),n(e,q,a),y(u,e,a),n(e,P,a),n(e,G,a),n(e,K,a),n(e,r,a),n(e,L,a),y(B,e,a),n(e,A,a),n(e,X,a),n(e,O,a),y(C,e,a),n(e,ee,a),n(e,v,a),n(e,ae,a),n(e,Y,a),te=!0},p(e,[a]){const de={};a&2&&(de.$$scope={dirty:a,ctx:e}),u.$set(de)},i(e){te||(b(M.$$.fragment,e),b(w.$$.fragment,e),b(W.$$.fragment,e),b(k.$$.fragment,e),b(I.$$.fragment,e),b(u.$$.fragment,e),b(B.$$.fragment,e),b(C.$$.fragment,e),te=!0)},o(e){f(M.$$.fragment,e),f(w.$$.fragment,e),f(W.$$.fragment,e),f(k.$$.fragment,e),f(I.$$.fragment,e),f(u.$$.fragment,e),f(B.$$.fragment,e),f(C.$$.fragment,e),te=!1},d(e){e&&(t(g),t(o),t(F),t(R),t($),t(U),t(x),t(T),t(N),t(Q),t(Z),t(E),t(z),t(j),t(H),t(D),t(_),t(q),t(P),t(G),t(K),t(r),t(L),t(A),t(X),t(O),t(ee),t(v),t(ae),t(Y)),t(i),J(M,e),J(w,e),J(W,e),J(k,e),J(I,e),J(u,e),J(B,e),J(C,e)}}}const Ie='{"title":"Text-guided image-inpainting","local":"text-guided-image-inpainting","sections":[{"title":"Preserving the Unmasked Area of the Image","local":"preserving-the-unmasked-area-of-the-image","sections":[],"depth":2}],"depth":1}';function _e(S){return Je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ve extends Me{constructor(i){super(),we(this,i,_e,je,be,{})}}export{Ve as component};
