import{s as A,o as K,n as O}from"../chunks/scheduler.182ea377.js";import{S as ee,i as te,g as p,s as l,r as v,A as ie,h as r,f as i,c as s,j as Y,u as Z,x as T,k as D,y as oe,a as o,v as U,d as $,t as C,w as W}from"../chunks/index.abf12888.js";import{T as ne}from"../chunks/Tip.230e2334.js";import{C as q}from"../chunks/CodeBlock.57fe6e13.js";import{D as le}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as se}from"../chunks/Heading.16916d63.js";function ae(x){let n,f="🔒 By loading a community pipeline from the Hugging Face Hub, you are trusting that the code you are loading is safe. Make sure to inspect the code online before loading and running it automatically!";return{c(){n=p("p"),n.textContent=f},l(a){n=r(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-154jbq5"&&(n.textContent=f)},m(a,_){o(a,n,_)},p:O,d(a){a&&i(n)}}}function pe(x){let n,f,a,_,c,G,u,V,d,E='Community pipelines are any <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class that are different from the original implementation as specified in their paper (for example, the <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> corresponds to the <a href="https://arxiv.org/abs/2302.05543" rel="nofollow">Text-to-Image Generation with ControlNet Conditioning</a> paper). They provide additional functionality or extend the original implementation of a pipeline.',k,y,N='There are many cool community pipelines like <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#speech-to-image" rel="nofollow">Speech to Image</a> or <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#composable-stable-diffusion" rel="nofollow">Composable Stable Diffusion</a>, and you can find all the official community pipelines <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">here</a>.',I,h,X='To load any community pipeline on the Hub, pass the repository id of the community pipeline to the <code>custom_pipeline</code> argument and the model repository where you’d like to load the pipeline weights and components from. For example, the example below loads a dummy pipeline from <a href="https://huggingface.co/hf-internal-testing/diffusers-dummy-pipeline/blob/main/pipeline.py" rel="nofollow"><code>hf-internal-testing/diffusers-dummy-pipeline</code></a> and the pipeline weights and components from <a href="https://huggingface.co/google/ddpm-cifar10-32" rel="nofollow"><code>google/ddpm-cifar10-32</code></a>:',B,m,P,b,R,g,Q='Loading an official community pipeline is similar, but you can mix loading weights from an official repository id and pass pipeline components directly. The example below loads the community <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#clip-guided-stable-diffusion" rel="nofollow">CLIP Guided Stable Diffusion</a> pipeline, and you can pass the CLIP model components directly to it:',j,w,L,M,z='For more information about community pipelines, take a look at the <a href="custom_pipeline_examples">Community pipelines</a> guide for how to use them and if you’re interested in adding a community pipeline check out the <a href="contribute_pipeline">How to contribute a community pipeline</a> guide!',S,J,H;return c=new se({props:{title:"Load community pipelines",local:"load-community-pipelines",headingTag:"h1"}}),u=new le({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"}]}}),m=new ne({props:{warning:!0,$$slots:{default:[ae]},$$scope:{ctx:x}}}),b=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1kdW1teS1waXBlbGluZSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;hf-internal-testing/diffusers-dummy-pipeline&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),w=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBJbWFnZVByb2Nlc3NvciUyQyUyMENMSVBNb2RlbCUwQSUwQWNsaXBfbW9kZWxfaWQlMjAlM0QlMjAlMjJsYWlvbiUyRkNMSVAtVmlULUItMzItbGFpb24yQi1zMzRCLWI3OUslMjIlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMENMSVBJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2xpcF9tb2RlbF9pZCklMEFjbGlwX21vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZChjbGlwX21vZGVsX2lkKSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyY2xpcF9ndWlkZWRfc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPImageProcessor, CLIPModel

clip_model_id = <span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>

feature_extractor = CLIPImageProcessor.from_pretrained(clip_model_id)
clip_model = CLIPModel.from_pretrained(clip_model_id)

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){n=p("meta"),f=l(),a=p("p"),_=l(),v(c.$$.fragment),G=l(),v(u.$$.fragment),V=l(),d=p("p"),d.innerHTML=E,k=l(),y=p("p"),y.innerHTML=N,I=l(),h=p("p"),h.innerHTML=X,B=l(),v(m.$$.fragment),P=l(),v(b.$$.fragment),R=l(),g=p("p"),g.innerHTML=Q,j=l(),v(w.$$.fragment),L=l(),M=p("p"),M.innerHTML=z,S=l(),J=p("p"),this.h()},l(e){const t=ie("svelte-u9bgzb",document.head);n=r(t,"META",{name:!0,content:!0}),t.forEach(i),f=s(e),a=r(e,"P",{}),Y(a).forEach(i),_=s(e),Z(c.$$.fragment,e),G=s(e),Z(u.$$.fragment,e),V=s(e),d=r(e,"P",{"data-svelte-h":!0}),T(d)!=="svelte-1yn8qeb"&&(d.innerHTML=E),k=s(e),y=r(e,"P",{"data-svelte-h":!0}),T(y)!=="svelte-10en0rk"&&(y.innerHTML=N),I=s(e),h=r(e,"P",{"data-svelte-h":!0}),T(h)!=="svelte-1mmnk2f"&&(h.innerHTML=X),B=s(e),Z(m.$$.fragment,e),P=s(e),Z(b.$$.fragment,e),R=s(e),g=r(e,"P",{"data-svelte-h":!0}),T(g)!=="svelte-1yyre8w"&&(g.innerHTML=Q),j=s(e),Z(w.$$.fragment,e),L=s(e),M=r(e,"P",{"data-svelte-h":!0}),T(M)!=="svelte-1ho2g1z"&&(M.innerHTML=z),S=s(e),J=r(e,"P",{}),Y(J).forEach(i),this.h()},h(){D(n,"name","hf:doc:metadata"),D(n,"content",re)},m(e,t){oe(document.head,n),o(e,f,t),o(e,a,t),o(e,_,t),U(c,e,t),o(e,G,t),U(u,e,t),o(e,V,t),o(e,d,t),o(e,k,t),o(e,y,t),o(e,I,t),o(e,h,t),o(e,B,t),U(m,e,t),o(e,P,t),U(b,e,t),o(e,R,t),o(e,g,t),o(e,j,t),U(w,e,t),o(e,L,t),o(e,M,t),o(e,S,t),o(e,J,t),H=!0},p(e,[t]){const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),m.$set(F)},i(e){H||($(c.$$.fragment,e),$(u.$$.fragment,e),$(m.$$.fragment,e),$(b.$$.fragment,e),$(w.$$.fragment,e),H=!0)},o(e){C(c.$$.fragment,e),C(u.$$.fragment,e),C(m.$$.fragment,e),C(b.$$.fragment,e),C(w.$$.fragment,e),H=!1},d(e){e&&(i(f),i(a),i(_),i(G),i(V),i(d),i(k),i(y),i(I),i(h),i(B),i(P),i(R),i(g),i(j),i(L),i(M),i(S),i(J)),i(n),W(c,e),W(u,e),W(m,e),W(b,e),W(w,e)}}}const re='{"title":"Load community pipelines","local":"load-community-pipelines","sections":[],"depth":1}';function me(x){return K(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class be extends ee{constructor(n){super(),te(this,n,me,pe,A,{})}}export{be as component};
