import{s as Ua,o as da,n as $l}from"../chunks/scheduler.182ea377.js";import{S as ua,i as ba,g as p,s as t,r as c,A as ga,h as M,f as a,c as n,j as Ta,u as m,x as o,k as Gs,y as Ia,a as e,v as j,d as h,t as y,w as r}from"../chunks/index.abf12888.js";import{T as Nl}from"../chunks/Tip.230e2334.js";import{C as J}from"../chunks/CodeBlock.57fe6e13.js";import{D as fa}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as Bs}from"../chunks/Heading.16916d63.js";function Ca(d){let i,T='💡 This training tutorial is based on the <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/training_example.ipynb" rel="nofollow">Training with 🧨 Diffusers</a> notebook. For additional details and context about diffusion models like how they work, check out the notebook!';return{c(){i=p("p"),i.innerHTML=T},l(w){i=M(w,"P",{"data-svelte-h":!0}),o(i)!=="svelte-mrih6e"&&(i.innerHTML=T)},m(w,U){e(w,i,U)},p:$l,d(w){w&&a(i)}}}function Ba(d){let i,T='💡 You can find additional datasets from the <a href="https://huggingface.co/huggan" rel="nofollow">HugGan Community Event</a> or you can use your own dataset by creating a local <a href="https://huggingface.co/docs/datasets/image_dataset#imagefolder" rel="nofollow"><code>ImageFolder</code></a>. Set <code>config.dataset_name</code> to the repository id of the dataset if it is from the HugGan Community Event, or <code>imagefolder</code> if you’re using your own images.';return{c(){i=p("p"),i.innerHTML=T},l(w){i=M(w,"P",{"data-svelte-h":!0}),o(i)!=="svelte-1617s30"&&(i.innerHTML=T)},m(w,U){e(w,i,U)},p:$l,d(w){w&&a(i)}}}function Za(d){let i,T="💡 The training loop below may look intimidating and long, but it’ll be worth it later when you launch your training in just one line of code! If you can’t wait and want to start generating images, feel free to copy and run the code below. You can always come back and examine the training loop more closely later, like when you’re waiting for your model to finish training. 🤗";return{c(){i=p("p"),i.textContent=T},l(w){i=M(w,"P",{"data-svelte-h":!0}),o(i)!=="svelte-dstut0"&&(i.textContent=T)},m(w,U){e(w,i,U)},p:$l,d(w){w&&a(i)}}}function Ga(d){let i,T,w,U,B,As,Z,ks,G,Rl='Unconditional image generation is a popular application of diffusion models that generates images that look like those in the dataset used for training. Typically, the best results are obtained from finetuning a pretrained model on a specific dataset. You can find many of these checkpoints on the <a href="https://huggingface.co/search/full-text?q=unconditional-image-generation&amp;type=model" rel="nofollow">Hub</a>, but if you can’t find one you like, you can always train your own!',Ws,A,Yl='This tutorial will teach you how to train a <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> from scratch on a subset of the <a href="https://huggingface.co/datasets/huggan/smithsonian_butterflies_subset" rel="nofollow">Smithsonian Butterflies</a> dataset to generate your own 🦋 butterflies 🦋.',Xs,u,_s,k,zl='Before you begin, make sure you have 🤗 Datasets installed to load and preprocess image datasets, and 🤗 Accelerate, to simplify training on any number of GPUs. The following command will also install <a href="https://www.tensorflow.org/tensorboard" rel="nofollow">TensorBoard</a> to visualize training metrics (you can also use <a href="https://docs.wandb.ai/" rel="nofollow">Weights &amp; Biases</a> to track your training).',vs,W,Vs,X,El='We encourage you to share your model with the community, and in order to do that, you’ll need to login to your Hugging Face account (create one <a href="https://hf.co/join" rel="nofollow">here</a> if you don’t already have one!). You can login from a notebook and enter your token when prompted:',Ns,_,$s,v,Ql="Or login in from the terminal:",Rs,V,Ys,N,Fl='Since the model checkpoints are quite large, install <a href="https://git-lfs.com/" rel="nofollow">Git-LFS</a> to version these large files:',zs,$,Es,R,Qs,Y,Hl="For convenience, create a <code>TrainingConfig</code> class containing the training hyperparameters (feel free to adjust them):",Fs,z,Hs,E,Ss,Q,Sl='You can easily load the <a href="https://huggingface.co/datasets/huggan/smithsonian_butterflies_subset" rel="nofollow">Smithsonian Butterflies</a> dataset with the 🤗 Datasets library:',xs,F,Ds,b,Ls,H,xl='🤗 Datasets uses the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Image" rel="nofollow">Image</a> feature to automatically decode the image data and load it as a <a href="https://pillow.readthedocs.io/en/stable/reference/Image.html" rel="nofollow"><code>PIL.Image</code></a> which we can visualize:',qs,S,Ks,g,Dl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/butterflies_ds.png"/>',Ps,x,Ll="The images are all different sizes though, so you’ll need to preprocess them first:",Os,D,ql="<li><code>Resize</code> changes the image size to the one defined in <code>config.image_size</code>.</li> <li><code>RandomHorizontalFlip</code> augments the dataset by randomly mirroring the images.</li> <li><code>Normalize</code> is important to rescale the pixel values into a [-1, 1] range, which is what the model expects.</li>",sl,L,ll,q,Kl='Use 🤗 Datasets’ <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.set_transform" rel="nofollow">set_transform</a> method to apply the <code>preprocess</code> function on the fly during training:',al,K,el,P,Pl='Feel free to visualize the images again to confirm that they’ve been resized. Now you’re ready to wrap the dataset in a <a href="https://pytorch.org/docs/stable/data#torch.utils.data.DataLoader" rel="nofollow">DataLoader</a> for training!',tl,O,nl,ss,pl,ls,Ol='Pretrained models in 🧨 Diffusers are easily created from their model class with the parameters you want. For example, to create a <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a>:',Ml,as,il,es,sa="It is often a good idea to quickly check the sample image shape matches the model output shape:",ol,ts,cl,ns,la="Great! Next, you’ll need a scheduler to add some noise to the image.",ml,ps,jl,Ms,aa="The scheduler behaves differently depending on whether you’re using the model for training or inference. During inference, the scheduler generates image from the noise. During training, the scheduler takes a model output - or a sample - from a specific point in the diffusion process and applies noise to the image according to a <em>noise schedule</em> and an <em>update rule</em>.",hl,is,ea='Let’s take a look at the <a href="/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a> and use the <code>add_noise</code> method to add some random noise to the <code>sample_image</code> from before:',yl,os,rl,I,ta='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/noisy_butterfly.png"/>',wl,cs,na="The training objective of the model is to predict the noise added to the image. The loss at this step can be calculated by:",Jl,ms,Tl,js,Ul,hs,pa="By now, you have most of the pieces to start training the model and all that’s left is putting everything together.",dl,ys,Ma="First, you’ll need an optimizer and a learning rate scheduler:",ul,rs,bl,ws,ia='Then, you’ll need a way to evaluate the model. For evaluation, you can use the <a href="/docs/diffusers/main/en/api/pipelines/ddpm#diffusers.DDPMPipeline">DDPMPipeline</a> to generate a batch of sample images and save it as a grid:',gl,Js,Il,Ts,oa="Now you can wrap all these components together in a training loop with 🤗 Accelerate for easy TensorBoard logging, gradient accumulation, and mixed precision training. To upload the model to the Hub, write a function to get your repository name and information and then push it to the Hub.",fl,f,Cl,Us,Bl,ds,ca='Phew, that was quite a bit of code! But you’re finally ready to launch the training with 🤗 Accelerate’s <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/launchers#accelerate.notebook_launcher" rel="nofollow">notebook_launcher</a> function. Pass the function the training loop, all the training arguments, and the number of processes (you can change this value to the number of GPUs available to you) to use for training:',Zl,us,Gl,bs,ma="Once training is complete, take a look at the final 🦋 images 🦋 generated by your diffusion model!",Al,gs,kl,C,ja='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/butterflies_final.png"/>',Wl,Is,Xl,fs,ha='Unconditional image generation is one example of a task that can be trained. You can explore other tasks and training techniques by visiting the <a href="../training/overview">🧨 Diffusers Training Examples</a> page. Here are some examples of what you can learn:',_l,Cs,ya='<li><a href="../training/text_inversion">Textual Inversion</a>, an algorithm that teaches a model a specific visual concept and integrates it into the generated image.</li> <li><a href="../training/dreambooth">DreamBooth</a>, a technique for generating personalized images of a subject given several input images of the subject.</li> <li><a href="../training/text2image">Guide</a> to finetuning a Stable Diffusion model on your own dataset.</li> <li><a href="../training/lora">Guide</a> to using LoRA, a memory-efficient technique for finetuning really large models faster.</li>',vl,Zs,Vl;return B=new fa({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/basic_training.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/basic_training.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/basic_training.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/basic_training.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/basic_training.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/basic_training.ipynb"}]}}),Z=new Bs({props:{title:"Train a diffusion model",local:"train-a-diffusion-model",headingTag:"h1"}}),u=new Nl({props:{$$slots:{default:[Ca]},$$scope:{ctx:d}}}),W=new J({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwZGlmZnVzZXJzJTVCdHJhaW5pbmclNUQ=",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install diffusers[training]</span>`,wrap:!1}}),_=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),V=new J({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),$=new J({props:{code:"IXN1ZG8lMjBhcHQlMjAtcXElMjBpbnN0YWxsJTIwZ2l0LWxmcyUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmU=",highlighted:`!sudo apt -qq install git-lfs
!git config --global credential.helper store`,wrap:!1}}),R=new Bs({props:{title:"Training configuration",local:"training-configuration",headingTag:"h2"}}),z=new J({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBJTBBJTBBJTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBUcmFpbmluZ0NvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMGltYWdlX3NpemUlMjAlM0QlMjAxMjglMjAlMjAlMjMlMjB0aGUlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyMHJlc29sdXRpb24lMEElMjAlMjAlMjAlMjB0cmFpbl9iYXRjaF9zaXplJTIwJTNEJTIwMTYlMEElMjAlMjAlMjAlMjBldmFsX2JhdGNoX3NpemUlMjAlM0QlMjAxNiUyMCUyMCUyMyUyMGhvdyUyMG1hbnklMjBpbWFnZXMlMjB0byUyMHNhbXBsZSUyMGR1cmluZyUyMGV2YWx1YXRpb24lMEElMjAlMjAlMjAlMjBudW1fZXBvY2hzJTIwJTNEJTIwNTAlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlM0QlMjAxJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUyMCUzRCUyMDFlLTQlMEElMjAlMjAlMjAlMjBscl93YXJtdXBfc3RlcHMlMjAlM0QlMjA1MDAlMEElMjAlMjAlMjAlMjBzYXZlX2ltYWdlX2Vwb2NocyUyMCUzRCUyMDEwJTBBJTIwJTIwJTIwJTIwc2F2ZV9tb2RlbF9lcG9jaHMlMjAlM0QlMjAzMCUwQSUyMCUyMCUyMCUyMG1peGVkX3ByZWNpc2lvbiUyMCUzRCUyMCUyMmZwMTYlMjIlMjAlMjAlMjMlMjAlNjBubyU2MCUyMGZvciUyMGZsb2F0MzIlMkMlMjAlNjBmcDE2JTYwJTIwZm9yJTIwYXV0b21hdGljJTIwbWl4ZWQlMjBwcmVjaXNpb24lMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTIwJTNEJTIwJTIyZGRwbS1idXR0ZXJmbGllcy0xMjglMjIlMjAlMjAlMjMlMjB0aGUlMjBtb2RlbCUyMG5hbWUlMjBsb2NhbGx5JTIwYW5kJTIwb24lMjB0aGUlMjBIRiUyMEh1YiUwQSUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTIwJTNEJTIwVHJ1ZSUyMCUyMCUyMyUyMHdoZXRoZXIlMjB0byUyMHVwbG9hZCUyMHRoZSUyMHNhdmVkJTIwbW9kZWwlMjB0byUyMHRoZSUyMEhGJTIwSHViJTBBJTIwJTIwJTIwJTIwaHViX3ByaXZhdGVfcmVwbyUyMCUzRCUyMEZhbHNlJTBBJTIwJTIwJTIwJTIwb3ZlcndyaXRlX291dHB1dF9kaXIlMjAlM0QlMjBUcnVlJTIwJTIwJTIzJTIwb3ZlcndyaXRlJTIwdGhlJTIwb2xkJTIwbW9kZWwlMjB3aGVuJTIwcmUtcnVubmluZyUyMHRoZSUyMG5vdGVib29rJTBBJTIwJTIwJTIwJTIwc2VlZCUyMCUzRCUyMDAlMEElMEElMEFjb25maWclMjAlM0QlMjBUcmFpbmluZ0NvbmZpZygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass


<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TrainingConfig</span>:
<span class="hljs-meta">... </span>    image_size = <span class="hljs-number">128</span>  <span class="hljs-comment"># the generated image resolution</span>
<span class="hljs-meta">... </span>    train_batch_size = <span class="hljs-number">16</span>
<span class="hljs-meta">... </span>    eval_batch_size = <span class="hljs-number">16</span>  <span class="hljs-comment"># how many images to sample during evaluation</span>
<span class="hljs-meta">... </span>    num_epochs = <span class="hljs-number">50</span>
<span class="hljs-meta">... </span>    gradient_accumulation_steps = <span class="hljs-number">1</span>
<span class="hljs-meta">... </span>    learning_rate = <span class="hljs-number">1e-4</span>
<span class="hljs-meta">... </span>    lr_warmup_steps = <span class="hljs-number">500</span>
<span class="hljs-meta">... </span>    save_image_epochs = <span class="hljs-number">10</span>
<span class="hljs-meta">... </span>    save_model_epochs = <span class="hljs-number">30</span>
<span class="hljs-meta">... </span>    mixed_precision = <span class="hljs-string">&quot;fp16&quot;</span>  <span class="hljs-comment"># \`no\` for float32, \`fp16\` for automatic mixed precision</span>
<span class="hljs-meta">... </span>    output_dir = <span class="hljs-string">&quot;ddpm-butterflies-128&quot;</span>  <span class="hljs-comment"># the model name locally and on the HF Hub</span>

<span class="hljs-meta">... </span>    push_to_hub = <span class="hljs-literal">True</span>  <span class="hljs-comment"># whether to upload the saved model to the HF Hub</span>
<span class="hljs-meta">... </span>    hub_private_repo = <span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>    overwrite_output_dir = <span class="hljs-literal">True</span>  <span class="hljs-comment"># overwrite the old model when re-running the notebook</span>
<span class="hljs-meta">... </span>    seed = <span class="hljs-number">0</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>config = TrainingConfig()`,wrap:!1}}),E=new Bs({props:{title:"Load the dataset",local:"load-the-dataset",headingTag:"h2"}}),F=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBY29uZmlnLmRhdGFzZXRfbmFtZSUyMCUzRCUyMCUyMmh1Z2dhbiUyRnNtaXRoc29uaWFuX2J1dHRlcmZsaWVzX3N1YnNldCUyMiUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoY29uZmlnLmRhdGFzZXRfbmFtZSUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>config.dataset_name = <span class="hljs-string">&quot;huggan/smithsonian_butterflies_subset&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(config.dataset_name, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),b=new Nl({props:{$$slots:{default:[Ba]},$$scope:{ctx:d}}}),S=new J({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWZpZyUyQyUyMGF4cyUyMCUzRCUyMHBsdC5zdWJwbG90cygxJTJDJTIwNCUyQyUyMGZpZ3NpemUlM0QoMTYlMkMlMjA0KSklMEFmb3IlMjBpJTJDJTIwaW1hZ2UlMjBpbiUyMGVudW1lcmF0ZShkYXRhc2V0JTVCJTNBNCU1RCU1QiUyMmltYWdlJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMGF4cyU1QmklNUQuaW1zaG93KGltYWdlKSUwQSUyMCUyMCUyMCUyMGF4cyU1QmklNUQuc2V0X2F4aXNfb2ZmKCklMEFmaWcuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, figsize=(<span class="hljs-number">16</span>, <span class="hljs-number">4</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, image <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataset[:<span class="hljs-number">4</span>][<span class="hljs-string">&quot;image&quot;</span>]):
<span class="hljs-meta">... </span>    axs[i].imshow(image)
<span class="hljs-meta">... </span>    axs[i].set_axis_off()
<span class="hljs-meta">&gt;&gt;&gt; </span>fig.show()`,wrap:!1}}),L=new J({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uJTIwaW1wb3J0JTIwdHJhbnNmb3JtcyUwQSUwQXByZXByb2Nlc3MlMjAlM0QlMjB0cmFuc2Zvcm1zLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3Jtcy5SZXNpemUoKGNvbmZpZy5pbWFnZV9zaXplJTJDJTIwY29uZmlnLmltYWdlX3NpemUpKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuUmFuZG9tSG9yaXpvbnRhbEZsaXAoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuVG9UZW5zb3IoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuTm9ybWFsaXplKCU1QjAuNSU1RCUyQyUyMCU1QjAuNSU1RCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocess = transforms.Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        transforms.Resize((config.image_size, config.image_size)),
<span class="hljs-meta">... </span>        transforms.RandomHorizontalFlip(),
<span class="hljs-meta">... </span>        transforms.ToTensor(),
<span class="hljs-meta">... </span>        transforms.Normalize([<span class="hljs-number">0.5</span>], [<span class="hljs-number">0.5</span>]),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`,wrap:!1}}),K=new J({props:{code:"ZGVmJTIwdHJhbnNmb3JtKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QnByZXByb2Nlc3MoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMGltYWdlJTIwaW4lMjBleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyaW1hZ2VzJTIyJTNBJTIwaW1hZ2VzJTdEJTBBJTBBJTBBZGF0YXNldC5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    images = [preprocess(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;images&quot;</span>: images}


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_transform(transform)`,wrap:!1}}),O=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF0cmFpbl9kYXRhbG9hZGVyJTIwJTNEJTIwdG9yY2gudXRpbHMuZGF0YS5EYXRhTG9hZGVyKGRhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEY29uZmlnLnRyYWluX2JhdGNoX3NpemUlMkMlMjBzaHVmZmxlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = torch.utils.data.DataLoader(dataset, batch_size=config.train_batch_size, shuffle=<span class="hljs-literal">True</span>)`,wrap:!1}}),ss=new Bs({props:{title:"Create a UNet2DModel",local:"create-a-unet2dmodel",headingTag:"h2"}}),as=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel(
<span class="hljs-meta">... </span>    sample_size=config.image_size,  <span class="hljs-comment"># the target image resolution</span>
<span class="hljs-meta">... </span>    in_channels=<span class="hljs-number">3</span>,  <span class="hljs-comment"># the number of input channels, 3 for RGB images</span>
<span class="hljs-meta">... </span>    out_channels=<span class="hljs-number">3</span>,  <span class="hljs-comment"># the number of output channels</span>
<span class="hljs-meta">... </span>    layers_per_block=<span class="hljs-number">2</span>,  <span class="hljs-comment"># how many ResNet layers to use per UNet block</span>
<span class="hljs-meta">... </span>    block_out_channels=(<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>),  <span class="hljs-comment"># the number of output channels for each UNet block</span>
<span class="hljs-meta">... </span>    down_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet downsampling block</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnDownBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet downsampling block with spatial self-attention</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>    up_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet upsampling block</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnUpBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet upsampling block with spatial self-attention</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)`,wrap:!1}}),ts=new J({props:{code:"c2FtcGxlX2ltYWdlJTIwJTNEJTIwZGF0YXNldCU1QjAlNUQlNUIlMjJpbWFnZXMlMjIlNUQudW5zcXVlZXplKDApJTBBcHJpbnQoJTIySW5wdXQlMjBzaGFwZSUzQSUyMiUyQyUyMHNhbXBsZV9pbWFnZS5zaGFwZSklMEElMEFwcmludCglMjJPdXRwdXQlMjBzaGFwZSUzQSUyMiUyQyUyMG1vZGVsKHNhbXBsZV9pbWFnZSUyQyUyMHRpbWVzdGVwJTNEMCkuc2FtcGxlLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>sample_image = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;images&quot;</span>].unsqueeze(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input shape:&quot;</span>, sample_image.shape)
Input shape: torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Output shape:&quot;</span>, model(sample_image, timestep=<span class="hljs-number">0</span>).sample.shape)
Output shape: torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>])`,wrap:!1}}),ps=new Bs({props:{title:"Create a scheduler",local:"create-a-scheduler",headingTag:"h2"}}),os=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERQTVNjaGVkdWxlciUwQSUwQW5vaXNlX3NjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIobnVtX3RyYWluX3RpbWVzdGVwcyUzRDEwMDApJTBBbm9pc2UlMjAlM0QlMjB0b3JjaC5yYW5kbihzYW1wbGVfaW1hZ2Uuc2hhcGUpJTBBdGltZXN0ZXBzJTIwJTNEJTIwdG9yY2guTG9uZ1RlbnNvciglNUI1MCU1RCklMEFub2lzeV9pbWFnZSUyMCUzRCUyMG5vaXNlX3NjaGVkdWxlci5hZGRfbm9pc2Uoc2FtcGxlX2ltYWdlJTJDJTIwbm9pc2UlMkMlMjB0aW1lc3RlcHMpJTBBJTBBSW1hZ2UuZnJvbWFycmF5KCgobm9pc3lfaW1hZ2UucGVybXV0ZSgwJTJDJTIwMiUyQyUyMDMlMkMlMjAxKSUyMCUyQiUyMDEuMCklMjAqJTIwMTI3LjUpLnR5cGUodG9yY2gudWludDgpLm51bXB5KCklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>noise_scheduler = DDPMScheduler(num_train_timesteps=<span class="hljs-number">1000</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn(sample_image.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span>timesteps = torch.LongTensor([<span class="hljs-number">50</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_image = noise_scheduler.add_noise(sample_image, noise, timesteps)

<span class="hljs-meta">&gt;&gt;&gt; </span>Image.fromarray(((noisy_image.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>) + <span class="hljs-number">1.0</span>) * <span class="hljs-number">127.5</span>).<span class="hljs-built_in">type</span>(torch.uint8).numpy()[<span class="hljs-number">0</span>])`,wrap:!1}}),ms=new J({props:{code:"aW1wb3J0JTIwdG9yY2gubm4uZnVuY3Rpb25hbCUyMGFzJTIwRiUwQSUwQW5vaXNlX3ByZWQlMjAlM0QlMjBtb2RlbChub2lzeV9pbWFnZSUyQyUyMHRpbWVzdGVwcykuc2FtcGxlJTBBbG9zcyUyMCUzRCUyMEYubXNlX2xvc3Mobm9pc2VfcHJlZCUyQyUyMG5vaXNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F

<span class="hljs-meta">&gt;&gt;&gt; </span>noise_pred = model(noisy_image, timesteps).sample
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = F.mse_loss(noise_pred, noise)`,wrap:!1}}),js=new Bs({props:{title:"Train the model",local:"train-the-model",headingTag:"h2"}}),rs=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5vcHRpbWl6YXRpb24lMjBpbXBvcnQlMjBnZXRfY29zaW5lX3NjaGVkdWxlX3dpdGhfd2FybXVwJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0Rjb25maWcubGVhcm5pbmdfcmF0ZSklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfY29zaW5lX3NjaGVkdWxlX3dpdGhfd2FybXVwKCUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0Rjb25maWcubHJfd2FybXVwX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEKGxlbih0cmFpbl9kYXRhbG9hZGVyKSUyMColMjBjb25maWcubnVtX2Vwb2NocyklMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.optimization <span class="hljs-keyword">import</span> get_cosine_schedule_with_warmup

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = torch.optim.AdamW(model.parameters(), lr=config.learning_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span>lr_scheduler = get_cosine_schedule_with_warmup(
<span class="hljs-meta">... </span>    optimizer=optimizer,
<span class="hljs-meta">... </span>    num_warmup_steps=config.lr_warmup_steps,
<span class="hljs-meta">... </span>    num_training_steps=(<span class="hljs-built_in">len</span>(train_dataloader) * config.num_epochs),
<span class="hljs-meta">... </span>)`,wrap:!1}}),Js=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBtYWtlX2ltYWdlX2dyaWQlMEFpbXBvcnQlMjBtYXRoJTBBaW1wb3J0JTIwb3MlMEElMEElMEFkZWYlMjBldmFsdWF0ZShjb25maWclMkMlMjBlcG9jaCUyQyUyMHBpcGVsaW5lKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFNhbXBsZSUyMHNvbWUlMjBpbWFnZXMlMjBmcm9tJTIwcmFuZG9tJTIwbm9pc2UlMjAodGhpcyUyMGlzJTIwdGhlJTIwYmFja3dhcmQlMjBkaWZmdXNpb24lMjBwcm9jZXNzKS4lMEElMjAlMjAlMjAlMjAlMjMlMjBUaGUlMjBkZWZhdWx0JTIwcGlwZWxpbmUlMjBvdXRwdXQlMjB0eXBlJTIwaXMlMjAlNjBMaXN0JTVCUElMLkltYWdlJTVEJTYwJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRGNvbmZpZy5ldmFsX2JhdGNoX3NpemUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5tYW51YWxfc2VlZChjb25maWcuc2VlZCklMkMlMEElMjAlMjAlMjAlMjApLmltYWdlcyUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyME1ha2UlMjBhJTIwZ3JpZCUyMG91dCUyMG9mJTIwdGhlJTIwaW1hZ2VzJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZ3JpZCUyMCUzRCUyMG1ha2VfaW1hZ2VfZ3JpZChpbWFnZXMlMkMlMjByb3dzJTNENCUyQyUyMGNvbHMlM0Q0KSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFNhdmUlMjB0aGUlMjBpbWFnZXMlMEElMjAlMjAlMjAlMjB0ZXN0X2RpciUyMCUzRCUyMG9zLnBhdGguam9pbihjb25maWcub3V0cHV0X2RpciUyQyUyMCUyMnNhbXBsZXMlMjIpJTBBJTIwJTIwJTIwJTIwb3MubWFrZWRpcnModGVzdF9kaXIlMkMlMjBleGlzdF9vayUzRFRydWUpJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZ3JpZC5zYXZlKGYlMjIlN0J0ZXN0X2RpciU3RCUyRiU3QmVwb2NoJTNBMDRkJTdELnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> math
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">evaluate</span>(<span class="hljs-params">config, epoch, pipeline</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Sample some images from random noise (this is the backward diffusion process).</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># The default pipeline output type is \`List[PIL.Image]\`</span>
<span class="hljs-meta">... </span>    images = pipeline(
<span class="hljs-meta">... </span>        batch_size=config.eval_batch_size,
<span class="hljs-meta">... </span>        generator=torch.manual_seed(config.seed),
<span class="hljs-meta">... </span>    ).images

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Make a grid out of the images</span>
<span class="hljs-meta">... </span>    image_grid = make_image_grid(images, rows=<span class="hljs-number">4</span>, cols=<span class="hljs-number">4</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Save the images</span>
<span class="hljs-meta">... </span>    test_dir = os.path.join(config.output_dir, <span class="hljs-string">&quot;samples&quot;</span>)
<span class="hljs-meta">... </span>    os.makedirs(test_dir, exist_ok=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    image_grid.save(<span class="hljs-string">f&quot;<span class="hljs-subst">{test_dir}</span>/<span class="hljs-subst">{epoch:04d}</span>.png&quot;</span>)`,wrap:!1}}),f=new Nl({props:{$$slots:{default:[Za]},$$scope:{ctx:d}}}),Us=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFolder, Repository, whoami
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_full_repo_name</span>(<span class="hljs-params">model_id: <span class="hljs-built_in">str</span>, organization: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span>, token: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> token <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>        token = HfFolder.get_token()
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> organization <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>        username = whoami(token)[<span class="hljs-string">&quot;name&quot;</span>]
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;<span class="hljs-subst">{username}</span>/<span class="hljs-subst">{model_id}</span>&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;<span class="hljs-subst">{organization}</span>/<span class="hljs-subst">{model_id}</span>&quot;</span>


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">train_loop</span>(<span class="hljs-params">config, model, noise_scheduler, optimizer, train_dataloader, lr_scheduler</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Initialize accelerator and tensorboard logging</span>
<span class="hljs-meta">... </span>    accelerator = Accelerator(
<span class="hljs-meta">... </span>        mixed_precision=config.mixed_precision,
<span class="hljs-meta">... </span>        gradient_accumulation_steps=config.gradient_accumulation_steps,
<span class="hljs-meta">... </span>        log_with=<span class="hljs-string">&quot;tensorboard&quot;</span>,
<span class="hljs-meta">... </span>        project_dir=os.path.join(config.output_dir, <span class="hljs-string">&quot;logs&quot;</span>),
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> accelerator.is_main_process:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> config.push_to_hub:
<span class="hljs-meta">... </span>            repo_name = get_full_repo_name(Path(config.output_dir).name)
<span class="hljs-meta">... </span>            repo = Repository(config.output_dir, clone_from=repo_name)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">elif</span> config.output_dir <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>            os.makedirs(config.output_dir, exist_ok=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>        accelerator.init_trackers(<span class="hljs-string">&quot;train_example&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Prepare everything</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># There is no specific order to remember, you just need to unpack the</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># objects in the same order you gave them to the prepare method.</span>
<span class="hljs-meta">... </span>    model, optimizer, train_dataloader, lr_scheduler = accelerator.prepare(
<span class="hljs-meta">... </span>        model, optimizer, train_dataloader, lr_scheduler
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    global_step = <span class="hljs-number">0</span>

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Now you train the model</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(config.num_epochs):
<span class="hljs-meta">... </span>        progress_bar = tqdm(total=<span class="hljs-built_in">len</span>(train_dataloader), disable=<span class="hljs-keyword">not</span> accelerator.is_local_main_process)
<span class="hljs-meta">... </span>        progress_bar.set_description(<span class="hljs-string">f&quot;Epoch <span class="hljs-subst">{epoch}</span>&quot;</span>)

<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(train_dataloader):
<span class="hljs-meta">... </span>            clean_images = batch[<span class="hljs-string">&quot;images&quot;</span>]
<span class="hljs-meta">... </span>            <span class="hljs-comment"># Sample noise to add to the images</span>
<span class="hljs-meta">... </span>            noise = torch.randn(clean_images.shape).to(clean_images.device)
<span class="hljs-meta">... </span>            bs = clean_images.shape[<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>            <span class="hljs-comment"># Sample a random timestep for each image</span>
<span class="hljs-meta">... </span>            timesteps = torch.randint(
<span class="hljs-meta">... </span>                <span class="hljs-number">0</span>, noise_scheduler.config.num_train_timesteps, (bs,), device=clean_images.device
<span class="hljs-meta">... </span>            ).long()

<span class="hljs-meta">... </span>            <span class="hljs-comment"># Add noise to the clean images according to the noise magnitude at each timestep</span>
<span class="hljs-meta">... </span>            <span class="hljs-comment"># (this is the forward diffusion process)</span>
<span class="hljs-meta">... </span>            noisy_images = noise_scheduler.add_noise(clean_images, noise, timesteps)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">with</span> accelerator.accumulate(model):
<span class="hljs-meta">... </span>                <span class="hljs-comment"># Predict the noise residual</span>
<span class="hljs-meta">... </span>                noise_pred = model(noisy_images, timesteps, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>                loss = F.mse_loss(noise_pred, noise)
<span class="hljs-meta">... </span>                accelerator.backward(loss)

<span class="hljs-meta">... </span>                accelerator.clip_grad_norm_(model.parameters(), <span class="hljs-number">1.0</span>)
<span class="hljs-meta">... </span>                optimizer.step()
<span class="hljs-meta">... </span>                lr_scheduler.step()
<span class="hljs-meta">... </span>                optimizer.zero_grad()

<span class="hljs-meta">... </span>            progress_bar.update(<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>            logs = {<span class="hljs-string">&quot;loss&quot;</span>: loss.detach().item(), <span class="hljs-string">&quot;lr&quot;</span>: lr_scheduler.get_last_lr()[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;step&quot;</span>: global_step}
<span class="hljs-meta">... </span>            progress_bar.set_postfix(**logs)
<span class="hljs-meta">... </span>            accelerator.log(logs, step=global_step)
<span class="hljs-meta">... </span>            global_step += <span class="hljs-number">1</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># After each epoch you optionally sample some demo images with evaluate() and save the model</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> accelerator.is_main_process:
<span class="hljs-meta">... </span>            pipeline = DDPMPipeline(unet=accelerator.unwrap_model(model), scheduler=noise_scheduler)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> (epoch + <span class="hljs-number">1</span>) % config.save_image_epochs == <span class="hljs-number">0</span> <span class="hljs-keyword">or</span> epoch == config.num_epochs - <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                evaluate(config, epoch, pipeline)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> (epoch + <span class="hljs-number">1</span>) % config.save_model_epochs == <span class="hljs-number">0</span> <span class="hljs-keyword">or</span> epoch == config.num_epochs - <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                <span class="hljs-keyword">if</span> config.push_to_hub:
<span class="hljs-meta">... </span>                    repo.push_to_hub(commit_message=<span class="hljs-string">f&quot;Epoch <span class="hljs-subst">{epoch}</span>&quot;</span>, blocking=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>                <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>                    pipeline.save_pretrained(config.output_dir)`,wrap:!1}}),us=new J({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQWFyZ3MlMjAlM0QlMjAoY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBub2lzZV9zY2hlZHVsZXIlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyKSUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluX2xvb3AlMkMlMjBhcmdzJTJDJTIwbnVtX3Byb2Nlc3NlcyUzRDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

<span class="hljs-meta">&gt;&gt;&gt; </span>args = (config, model, noise_scheduler, optimizer, train_dataloader, lr_scheduler)

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_launcher(train_loop, args, num_processes=<span class="hljs-number">1</span>)`,wrap:!1}}),gs=new J({props:{code:"aW1wb3J0JTIwZ2xvYiUwQSUwQXNhbXBsZV9pbWFnZXMlMjAlM0QlMjBzb3J0ZWQoZ2xvYi5nbG9iKGYlMjIlN0Jjb25maWcub3V0cHV0X2RpciU3RCUyRnNhbXBsZXMlMkYqLnBuZyUyMikpJTBBSW1hZ2Uub3BlbihzYW1wbGVfaW1hZ2VzJTVCLTElNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> glob

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_images = <span class="hljs-built_in">sorted</span>(glob.glob(<span class="hljs-string">f&quot;<span class="hljs-subst">{config.output_dir}</span>/samples/*.png&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>Image.<span class="hljs-built_in">open</span>(sample_images[-<span class="hljs-number">1</span>])`,wrap:!1}}),Is=new Bs({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){i=p("meta"),T=t(),w=p("p"),U=t(),c(B.$$.fragment),As=t(),c(Z.$$.fragment),ks=t(),G=p("p"),G.innerHTML=Rl,Ws=t(),A=p("p"),A.innerHTML=Yl,Xs=t(),c(u.$$.fragment),_s=t(),k=p("p"),k.innerHTML=zl,vs=t(),c(W.$$.fragment),Vs=t(),X=p("p"),X.innerHTML=El,Ns=t(),c(_.$$.fragment),$s=t(),v=p("p"),v.textContent=Ql,Rs=t(),c(V.$$.fragment),Ys=t(),N=p("p"),N.innerHTML=Fl,zs=t(),c($.$$.fragment),Es=t(),c(R.$$.fragment),Qs=t(),Y=p("p"),Y.innerHTML=Hl,Fs=t(),c(z.$$.fragment),Hs=t(),c(E.$$.fragment),Ss=t(),Q=p("p"),Q.innerHTML=Sl,xs=t(),c(F.$$.fragment),Ds=t(),c(b.$$.fragment),Ls=t(),H=p("p"),H.innerHTML=xl,qs=t(),c(S.$$.fragment),Ks=t(),g=p("div"),g.innerHTML=Dl,Ps=t(),x=p("p"),x.textContent=Ll,Os=t(),D=p("ul"),D.innerHTML=ql,sl=t(),c(L.$$.fragment),ll=t(),q=p("p"),q.innerHTML=Kl,al=t(),c(K.$$.fragment),el=t(),P=p("p"),P.innerHTML=Pl,tl=t(),c(O.$$.fragment),nl=t(),c(ss.$$.fragment),pl=t(),ls=p("p"),ls.innerHTML=Ol,Ml=t(),c(as.$$.fragment),il=t(),es=p("p"),es.textContent=sa,ol=t(),c(ts.$$.fragment),cl=t(),ns=p("p"),ns.textContent=la,ml=t(),c(ps.$$.fragment),jl=t(),Ms=p("p"),Ms.innerHTML=aa,hl=t(),is=p("p"),is.innerHTML=ea,yl=t(),c(os.$$.fragment),rl=t(),I=p("div"),I.innerHTML=ta,wl=t(),cs=p("p"),cs.textContent=na,Jl=t(),c(ms.$$.fragment),Tl=t(),c(js.$$.fragment),Ul=t(),hs=p("p"),hs.textContent=pa,dl=t(),ys=p("p"),ys.textContent=Ma,ul=t(),c(rs.$$.fragment),bl=t(),ws=p("p"),ws.innerHTML=ia,gl=t(),c(Js.$$.fragment),Il=t(),Ts=p("p"),Ts.textContent=oa,fl=t(),c(f.$$.fragment),Cl=t(),c(Us.$$.fragment),Bl=t(),ds=p("p"),ds.innerHTML=ca,Zl=t(),c(us.$$.fragment),Gl=t(),bs=p("p"),bs.textContent=ma,Al=t(),c(gs.$$.fragment),kl=t(),C=p("div"),C.innerHTML=ja,Wl=t(),c(Is.$$.fragment),Xl=t(),fs=p("p"),fs.innerHTML=ha,_l=t(),Cs=p("ul"),Cs.innerHTML=ya,vl=t(),Zs=p("p"),this.h()},l(s){const l=ga("svelte-u9bgzb",document.head);i=M(l,"META",{name:!0,content:!0}),l.forEach(a),T=n(s),w=M(s,"P",{}),Ta(w).forEach(a),U=n(s),m(B.$$.fragment,s),As=n(s),m(Z.$$.fragment,s),ks=n(s),G=M(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-tdss46"&&(G.innerHTML=Rl),Ws=n(s),A=M(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-ex8ldy"&&(A.innerHTML=Yl),Xs=n(s),m(u.$$.fragment,s),_s=n(s),k=M(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-x3q6hl"&&(k.innerHTML=zl),vs=n(s),m(W.$$.fragment,s),Vs=n(s),X=M(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-3k6ay9"&&(X.innerHTML=El),Ns=n(s),m(_.$$.fragment,s),$s=n(s),v=M(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-17henro"&&(v.textContent=Ql),Rs=n(s),m(V.$$.fragment,s),Ys=n(s),N=M(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-sz5qnh"&&(N.innerHTML=Fl),zs=n(s),m($.$$.fragment,s),Es=n(s),m(R.$$.fragment,s),Qs=n(s),Y=M(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1otxl74"&&(Y.innerHTML=Hl),Fs=n(s),m(z.$$.fragment,s),Hs=n(s),m(E.$$.fragment,s),Ss=n(s),Q=M(s,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1wj8hyv"&&(Q.innerHTML=Sl),xs=n(s),m(F.$$.fragment,s),Ds=n(s),m(b.$$.fragment,s),Ls=n(s),H=M(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1bh16eq"&&(H.innerHTML=xl),qs=n(s),m(S.$$.fragment,s),Ks=n(s),g=M(s,"DIV",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-1wjbouq"&&(g.innerHTML=Dl),Ps=n(s),x=M(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-19lli6v"&&(x.textContent=Ll),Os=n(s),D=M(s,"UL",{"data-svelte-h":!0}),o(D)!=="svelte-8oirkq"&&(D.innerHTML=ql),sl=n(s),m(L.$$.fragment,s),ll=n(s),q=M(s,"P",{"data-svelte-h":!0}),o(q)!=="svelte-a1cdro"&&(q.innerHTML=Kl),al=n(s),m(K.$$.fragment,s),el=n(s),P=M(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1abv18u"&&(P.innerHTML=Pl),tl=n(s),m(O.$$.fragment,s),nl=n(s),m(ss.$$.fragment,s),pl=n(s),ls=M(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-mlq3qn"&&(ls.innerHTML=Ol),Ml=n(s),m(as.$$.fragment,s),il=n(s),es=M(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-ahjyed"&&(es.textContent=sa),ol=n(s),m(ts.$$.fragment,s),cl=n(s),ns=M(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-1hkhok8"&&(ns.textContent=la),ml=n(s),m(ps.$$.fragment,s),jl=n(s),Ms=M(s,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-31qoa1"&&(Ms.innerHTML=aa),hl=n(s),is=M(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-1mnclmh"&&(is.innerHTML=ea),yl=n(s),m(os.$$.fragment,s),rl=n(s),I=M(s,"DIV",{class:!0,"data-svelte-h":!0}),o(I)!=="svelte-qcxk5"&&(I.innerHTML=ta),wl=n(s),cs=M(s,"P",{"data-svelte-h":!0}),o(cs)!=="svelte-1pekxga"&&(cs.textContent=na),Jl=n(s),m(ms.$$.fragment,s),Tl=n(s),m(js.$$.fragment,s),Ul=n(s),hs=M(s,"P",{"data-svelte-h":!0}),o(hs)!=="svelte-rpu9md"&&(hs.textContent=pa),dl=n(s),ys=M(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-11y5cd5"&&(ys.textContent=Ma),ul=n(s),m(rs.$$.fragment,s),bl=n(s),ws=M(s,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-1iidvjh"&&(ws.innerHTML=ia),gl=n(s),m(Js.$$.fragment,s),Il=n(s),Ts=M(s,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-13pvon6"&&(Ts.textContent=oa),fl=n(s),m(f.$$.fragment,s),Cl=n(s),m(Us.$$.fragment,s),Bl=n(s),ds=M(s,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-1f597mr"&&(ds.innerHTML=ca),Zl=n(s),m(us.$$.fragment,s),Gl=n(s),bs=M(s,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-nz3dg5"&&(bs.textContent=ma),Al=n(s),m(gs.$$.fragment,s),kl=n(s),C=M(s,"DIV",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-tzqtub"&&(C.innerHTML=ja),Wl=n(s),m(Is.$$.fragment,s),Xl=n(s),fs=M(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-zg9981"&&(fs.innerHTML=ha),_l=n(s),Cs=M(s,"UL",{"data-svelte-h":!0}),o(Cs)!=="svelte-cndhdw"&&(Cs.innerHTML=ya),vl=n(s),Zs=M(s,"P",{}),Ta(Zs).forEach(a),this.h()},h(){Gs(i,"name","hf:doc:metadata"),Gs(i,"content",Aa),Gs(g,"class","flex justify-center"),Gs(I,"class","flex justify-center"),Gs(C,"class","flex justify-center")},m(s,l){Ia(document.head,i),e(s,T,l),e(s,w,l),e(s,U,l),j(B,s,l),e(s,As,l),j(Z,s,l),e(s,ks,l),e(s,G,l),e(s,Ws,l),e(s,A,l),e(s,Xs,l),j(u,s,l),e(s,_s,l),e(s,k,l),e(s,vs,l),j(W,s,l),e(s,Vs,l),e(s,X,l),e(s,Ns,l),j(_,s,l),e(s,$s,l),e(s,v,l),e(s,Rs,l),j(V,s,l),e(s,Ys,l),e(s,N,l),e(s,zs,l),j($,s,l),e(s,Es,l),j(R,s,l),e(s,Qs,l),e(s,Y,l),e(s,Fs,l),j(z,s,l),e(s,Hs,l),j(E,s,l),e(s,Ss,l),e(s,Q,l),e(s,xs,l),j(F,s,l),e(s,Ds,l),j(b,s,l),e(s,Ls,l),e(s,H,l),e(s,qs,l),j(S,s,l),e(s,Ks,l),e(s,g,l),e(s,Ps,l),e(s,x,l),e(s,Os,l),e(s,D,l),e(s,sl,l),j(L,s,l),e(s,ll,l),e(s,q,l),e(s,al,l),j(K,s,l),e(s,el,l),e(s,P,l),e(s,tl,l),j(O,s,l),e(s,nl,l),j(ss,s,l),e(s,pl,l),e(s,ls,l),e(s,Ml,l),j(as,s,l),e(s,il,l),e(s,es,l),e(s,ol,l),j(ts,s,l),e(s,cl,l),e(s,ns,l),e(s,ml,l),j(ps,s,l),e(s,jl,l),e(s,Ms,l),e(s,hl,l),e(s,is,l),e(s,yl,l),j(os,s,l),e(s,rl,l),e(s,I,l),e(s,wl,l),e(s,cs,l),e(s,Jl,l),j(ms,s,l),e(s,Tl,l),j(js,s,l),e(s,Ul,l),e(s,hs,l),e(s,dl,l),e(s,ys,l),e(s,ul,l),j(rs,s,l),e(s,bl,l),e(s,ws,l),e(s,gl,l),j(Js,s,l),e(s,Il,l),e(s,Ts,l),e(s,fl,l),j(f,s,l),e(s,Cl,l),j(Us,s,l),e(s,Bl,l),e(s,ds,l),e(s,Zl,l),j(us,s,l),e(s,Gl,l),e(s,bs,l),e(s,Al,l),j(gs,s,l),e(s,kl,l),e(s,C,l),e(s,Wl,l),j(Is,s,l),e(s,Xl,l),e(s,fs,l),e(s,_l,l),e(s,Cs,l),e(s,vl,l),e(s,Zs,l),Vl=!0},p(s,[l]){const ra={};l&2&&(ra.$$scope={dirty:l,ctx:s}),u.$set(ra);const wa={};l&2&&(wa.$$scope={dirty:l,ctx:s}),b.$set(wa);const Ja={};l&2&&(Ja.$$scope={dirty:l,ctx:s}),f.$set(Ja)},i(s){Vl||(h(B.$$.fragment,s),h(Z.$$.fragment,s),h(u.$$.fragment,s),h(W.$$.fragment,s),h(_.$$.fragment,s),h(V.$$.fragment,s),h($.$$.fragment,s),h(R.$$.fragment,s),h(z.$$.fragment,s),h(E.$$.fragment,s),h(F.$$.fragment,s),h(b.$$.fragment,s),h(S.$$.fragment,s),h(L.$$.fragment,s),h(K.$$.fragment,s),h(O.$$.fragment,s),h(ss.$$.fragment,s),h(as.$$.fragment,s),h(ts.$$.fragment,s),h(ps.$$.fragment,s),h(os.$$.fragment,s),h(ms.$$.fragment,s),h(js.$$.fragment,s),h(rs.$$.fragment,s),h(Js.$$.fragment,s),h(f.$$.fragment,s),h(Us.$$.fragment,s),h(us.$$.fragment,s),h(gs.$$.fragment,s),h(Is.$$.fragment,s),Vl=!0)},o(s){y(B.$$.fragment,s),y(Z.$$.fragment,s),y(u.$$.fragment,s),y(W.$$.fragment,s),y(_.$$.fragment,s),y(V.$$.fragment,s),y($.$$.fragment,s),y(R.$$.fragment,s),y(z.$$.fragment,s),y(E.$$.fragment,s),y(F.$$.fragment,s),y(b.$$.fragment,s),y(S.$$.fragment,s),y(L.$$.fragment,s),y(K.$$.fragment,s),y(O.$$.fragment,s),y(ss.$$.fragment,s),y(as.$$.fragment,s),y(ts.$$.fragment,s),y(ps.$$.fragment,s),y(os.$$.fragment,s),y(ms.$$.fragment,s),y(js.$$.fragment,s),y(rs.$$.fragment,s),y(Js.$$.fragment,s),y(f.$$.fragment,s),y(Us.$$.fragment,s),y(us.$$.fragment,s),y(gs.$$.fragment,s),y(Is.$$.fragment,s),Vl=!1},d(s){s&&(a(T),a(w),a(U),a(As),a(ks),a(G),a(Ws),a(A),a(Xs),a(_s),a(k),a(vs),a(Vs),a(X),a(Ns),a($s),a(v),a(Rs),a(Ys),a(N),a(zs),a(Es),a(Qs),a(Y),a(Fs),a(Hs),a(Ss),a(Q),a(xs),a(Ds),a(Ls),a(H),a(qs),a(Ks),a(g),a(Ps),a(x),a(Os),a(D),a(sl),a(ll),a(q),a(al),a(el),a(P),a(tl),a(nl),a(pl),a(ls),a(Ml),a(il),a(es),a(ol),a(cl),a(ns),a(ml),a(jl),a(Ms),a(hl),a(is),a(yl),a(rl),a(I),a(wl),a(cs),a(Jl),a(Tl),a(Ul),a(hs),a(dl),a(ys),a(ul),a(bl),a(ws),a(gl),a(Il),a(Ts),a(fl),a(Cl),a(Bl),a(ds),a(Zl),a(Gl),a(bs),a(Al),a(kl),a(C),a(Wl),a(Xl),a(fs),a(_l),a(Cs),a(vl),a(Zs)),a(i),r(B,s),r(Z,s),r(u,s),r(W,s),r(_,s),r(V,s),r($,s),r(R,s),r(z,s),r(E,s),r(F,s),r(b,s),r(S,s),r(L,s),r(K,s),r(O,s),r(ss,s),r(as,s),r(ts,s),r(ps,s),r(os,s),r(ms,s),r(js,s),r(rs,s),r(Js,s),r(f,s),r(Us,s),r(us,s),r(gs,s),r(Is,s)}}}const Aa='{"title":"Train a diffusion model","local":"train-a-diffusion-model","sections":[{"title":"Training configuration","local":"training-configuration","sections":[],"depth":2},{"title":"Load the dataset","local":"load-the-dataset","sections":[],"depth":2},{"title":"Create a UNet2DModel","local":"create-a-unet2dmodel","sections":[],"depth":2},{"title":"Create a scheduler","local":"create-a-scheduler","sections":[],"depth":2},{"title":"Train the model","local":"train-the-model","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function ka(d){return da(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $a extends ua{constructor(i){super(),ba(this,i,ka,Ga,Ua,{})}}export{$a as component};
