import{s as da,n as ma,o as ca}from"../chunks/scheduler.182ea377.js";import{S as ga,i as ya,g as l,s as o,r as u,A as wa,h as a,f as i,c as n,j as li,u as f,x as r,k as ai,y,a as s,v as h,d as p,t as d,w as m}from"../chunks/index.abf12888.js";import{C as g}from"../chunks/CodeBlock.57fe6e13.js";import{H as c}from"../chunks/Heading.16916d63.js";function ba(un){let b,ci,di,gi,k,yi,M,fn="We ❤️ contributions from the open-source community! Everyone is welcome, and all types of participation –not just code– are valued and appreciated. Answering questions, helping others, reaching out, and improving the documentation are all immensely valuable to the community, so don’t be afraid and get involved if you’re up for it!",wi,C,hn='Everyone is encouraged to start by saying 👋 in our public Discord channel. We discuss the latest trends in diffusion models, ask questions, show off personal projects, help each other with contributions, or just hang out ☕. <a href="https://Discord.gg/G7tWnz98XR"><img alt="Join us on Discord" src="https://img.shields.io/discord/823813159592001537?color=5865F2&amp;logo=discord&amp;logoColor=white"/></a>',bi,H,pn='Whichever way you choose to contribute, we strive to be part of an open, welcoming, and kind community. Please, read our <a href="https://github.com/huggingface/diffusers/blob/main/CODE_OF_CONDUCT.md" rel="nofollow">code of conduct</a> and be mindful to respect it during your interactions. We also recommend you become familiar with the <a href="https://huggingface.co/docs/diffusers/conceptual/ethical_guidelines" rel="nofollow">ethical guidelines</a> that guide our project and ask you to adhere to the same principles of transparency and responsibility.',vi,L,dn="We enormously value feedback from the community, so please do not be afraid to speak up if you believe you have valuable feedback that can help improve the library - every message, comment, issue, and pull request (PR) is read and considered.",xi,P,$i,_,mn=`You can contribute in many ways ranging from answering questions on issues to adding new diffusion models to
the core library.`,Ti,I,cn="In the following, we give an overview of different ways to contribute, ranked by difficulty in ascending order. All of them are valuable to the community.",ki,q,gn='<li><ol><li>Asking and answering questions on <a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers" rel="nofollow">the Diffusers discussion forum</a> or on <a href="https://discord.gg/G7tWnz98XR" rel="nofollow">Discord</a>.</li></ol></li> <li><ol start="2"><li>Opening new issues on <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">the GitHub Issues tab</a></li></ol></li> <li><ol start="3"><li>Answering issues on <a href="https://github.com/huggingface/diffusers/issues" rel="nofollow">the GitHub Issues tab</a></li></ol></li> <li><ol start="4"><li>Fix a simple issue, marked by the “Good first issue” label, see <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22" rel="nofollow">here</a>.</li></ol></li> <li><ol start="5"><li>Contribute to the <a href="https://github.com/huggingface/diffusers/tree/main/docs/source" rel="nofollow">documentation</a>.</li></ol></li> <li><ol start="6"><li>Contribute a <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3Acommunity-examples" rel="nofollow">Community Pipeline</a></li></ol></li> <li><ol start="7"><li>Contribute to the <a href="https://github.com/huggingface/diffusers/tree/main/examples" rel="nofollow">examples</a>.</li></ol></li> <li><ol start="8"><li>Fix a more difficult issue, marked by the “Good second issue” label, see <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22Good+second+issue%22" rel="nofollow">here</a>.</li></ol></li> <li><ol start="9"><li>Add a new pipeline, model, or scheduler, see <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22New+pipeline%2Fmodel%22" rel="nofollow">“New Pipeline/Model”</a> and <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22New+scheduler%22" rel="nofollow">“New scheduler”</a> issues. For this contribution, please have a look at <a href="https://github.com/huggingface/diffusers/blob/main/PHILOSOPHY.md" rel="nofollow">Design Philosophy</a>.</li></ol></li>',Mi,R,yn=`As said before, <strong>all contributions are valuable to the community</strong>.
In the following, we will explain each contribution a bit more in detail.`,Ci,A,wn='For all contributions 4.-9. you will need to open a PR. It is explained in detail how to do so in <a href="#how-to-open-a-pr">Opening a pull requst</a>',Hi,j,Li,U,bn='Any question or comment related to the Diffusers library can be asked on the <a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers/" rel="nofollow">discussion forum</a> or on <a href="https://discord.gg/G7tWnz98XR" rel="nofollow">Discord</a>. Such questions and comments include (but are not limited to):',Pi,G,vn="<li>Reports of training or inference experiments in an attempt to share knowledge</li> <li>Presentation of personal projects</li> <li>Questions to non-official training examples</li> <li>Project proposals</li> <li>General feedback</li> <li>Paper summaries</li> <li>Asking for help on personal projects that build on top of the Diffusers library</li> <li>General questions</li> <li>Ethical questions regarding diffusion models</li> <li>…</li>",_i,J,xn=`Every question that is asked on the forum or on Discord actively encourages the community to publicly
share knowledge and might very well help a beginner in the future that has the same question you’re
having. Please do pose any questions you might have.
In the same spirit, you are of immense help to the community by answering such questions because this way you are publicly documenting knowledge for everybody to learn from.`,Ii,D,$n=`<strong>Please</strong> keep in mind that the more effort you put into asking or answering a question, the higher
the quality of the publicly documented knowledge. In the same way, well-posed and well-answered questions create a high-quality knowledge database accessible to everybody, while badly posed questions or answers reduce the overall quality of the public knowledge database.
In short, a high quality question or answer is <em>precise</em>, <em>concise</em>, <em>relevant</em>, <em>easy-to-understand</em>, <em>accesible</em>, and <em>well-formated/well-posed</em>. For more information, please have a look through the <a href="#how-to-write-a-good-issue">How to write a good issue</a> section.`,qi,W,Tn=`<strong>NOTE about channels</strong>:
<a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers/63" rel="nofollow"><em>The forum</em></a> is much better indexed by search engines, such as Google. Posts are ranked by popularity rather than chronologically. Hence, it’s easier to look up questions and answers that we posted some time ago.
In addition, questions and answers posted in the forum can easily be linked to.
In contrast, <em>Discord</em> has a chat-like format that invites fast back-and-forth communication.
While it will most likely take less time for you to get an answer to your question on Discord, your
question won’t be visible anymore over time. Also, it’s much harder to find information that was posted a while back on Discord. We therefore strongly recommend using the forum for high-quality questions and answers in an attempt to create long-lasting knowledge for the community. If discussions on Discord lead to very interesting answers and conclusions, we recommend posting the results on the forum to make the information more available for future readers.`,Ri,Z,Ai,F,kn=`The 🧨 Diffusers library is robust and reliable thanks to the users who notify us of
the problems they encounter. So thank you for reporting an issue.`,ji,S,Mn="Remember, GitHub issues are reserved for technical questions directly related to the Diffusers library, bug reports, feature requests, or feedback on the library design.",Ui,N,Cn='In a nutshell, this means that everything that is <strong>not</strong> related to the <strong>code of the Diffusers library</strong> (including the documentation) should <strong>not</strong> be asked on GitHub, but rather on either the <a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers/63" rel="nofollow">forum</a> or <a href="https://discord.gg/G7tWnz98XR" rel="nofollow">Discord</a>.',Gi,Y,Hn="<strong>Please consider the following guidelines when opening a new issue</strong>:",Ji,X,Ln=`<li>Make sure you have searched whether your issue has already been asked before (use the search bar on GitHub under Issues).</li> <li>Please never report a new issue on another (related) issue. If another issue is highly related, please
open a new issue nevertheless and link to the related issue.</li> <li>Make sure your issue is written in English. Please use one of the great, free online translation services, such as <a href="https://www.deepl.com/translator" rel="nofollow">DeepL</a> to translate from your native language to English if you are not comfortable in English.</li> <li>Check whether your issue might be solved by updating to the newest Diffusers version. Before posting your issue, please make sure that <code>python -c &quot;import diffusers; print(diffusers.__version__)&quot;</code> is higher or matches the latest Diffusers version.</li> <li>Remember that the more effort you put into opening a new issue, the higher the quality of your answer will be and the better the overall quality of the Diffusers issues.</li>`,Di,z,Pn="New issues usually include the following.",Wi,E,Zi,B,_n=`A bug report should always have a reproducible code snippet and be as minimal and concise as possible.
This means in more detail:`,Fi,O,In='<li>Narrow the bug down as much as you can, <strong>do not just dump your whole code file</strong></li> <li>Format your code</li> <li>Do not include any external libraries except for Diffusers depending on them.</li> <li><strong>Always</strong> provide all necessary information about your environment; for this, you can run: <code>diffusers-cli env</code> in your shell and copy-paste the displayed information to the issue.</li> <li>Explain the issue. If the reader doesn’t know what the issue is and why it is an issue, she cannot solve it.</li> <li><strong>Always</strong> make sure the reader can reproduce your issue with as little effort as possible. If your code snippet cannot be run because of missing libraries or undefined variables, the reader cannot help you. Make sure your reproducible code snippet is as minimal as possible and can be copy-pasted into a simple Python shell.</li> <li>If in order to reproduce your issue a model and/or dataset is required, make sure the reader has access to that model or dataset. You can always upload your model or dataset to the <a href="https://huggingface.co" rel="nofollow">Hub</a> to make it easily downloadable. Try to keep your model and dataset as small as possible, to make the reproduction of your issue as effortless as possible.</li>',Si,V,qn='For more information, please have a look through the <a href="#how-to-write-a-good-issue">How to write a good issue</a> section.',Ni,Q,Rn='You can open a bug report <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">here</a>.',Yi,K,Xi,ee,An="A world-class feature request addresses the following points:",zi,te,jn="<li>Motivation first:</li>",Ei,ie,Un=`<li>Is it related to a problem/frustration with the library? If so, please explain
why. Providing a code snippet that demonstrates the problem is best.</li> <li>Is it related to something you would need for a project? We’d love to hear
about it!</li> <li>Is it something you worked on and think could benefit the community?
Awesome! Tell us what problem it solved for you.</li>`,Bi,v,Gn="<li>Write a <em>full paragraph</em> describing the feature;</li> <li>Provide a <strong>code snippet</strong> that demonstrates its future use;</li> <li>In case this is related to a paper, please attach a link;</li> <li>Attach any additional information (drawings, screenshots, etc.) you think may help.</li>",Oi,se,Jn='You can open a feature request <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=&amp;template=feature_request.md&amp;title=" rel="nofollow">here</a>.',Vi,oe,Qi,ne,Dn=`Feedback about the library design and why it is good or not good helps the core maintainers immensely to build a user-friendly library. To understand the philosophy behind the current design philosophy, please have a look <a href="https://huggingface.co/docs/diffusers/conceptual/philosophy" rel="nofollow">here</a>. If you feel like a certain design choice does not fit with the current design philosophy, please explain why and how it should be changed. If a certain design choice follows the design philosophy too much, hence restricting use cases, explain why and how it should be changed.
If a certain design choice is very useful for you, please also leave a note as this is great feedback for future design decisions.`,Ki,le,Wn='You can open an issue about feedback <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=&amp;template=feedback.md&amp;title=" rel="nofollow">here</a>.',es,ae,ts,re,Zn=`Technical questions are mainly about why certain code of the library was written in a certain way, or what a certain part of the code does. Please make sure to link to the code in question and please provide detail on
why this part of the code is difficult to understand.`,is,ue,Fn='You can open an issue about a technical question <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=bug&amp;template=bug-report.yml" rel="nofollow">here</a>.',ss,fe,os,he,Sn="If the diffusion model community released a new model, pipeline, or scheduler that you would like to see in the Diffusers library, please provide the following information:",ns,pe,Nn="<li>Short description of the diffusion pipeline, model, or scheduler and link to the paper or public release.</li> <li>Link to any of its open-source implementation.</li> <li>Link to the model weights if they are available.</li>",ls,de,Yn=`If you are willing to contribute to the model yourself, let us know so we can best guide you. Also, don’t forget
to tag the original author of the component (model, scheduler, pipeline, etc.) by GitHub handle if you can find it.`,as,me,Xn='You can open a request for a model/pipeline/scheduler <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=New+model%2Fpipeline%2Fscheduler&amp;template=new-model-addition.yml" rel="nofollow">here</a>.',rs,ce,us,ge,zn=`Answering issues on GitHub might require some technical knowledge of Diffusers, but we encourage everybody to give it a try even if you are not 100% certain that your answer is correct.
Some tips to give a high-quality answer to an issue:`,fs,ye,En="<li>Be as concise and minimal as possible</li> <li>Stay on topic. An answer to the issue should concern the issue and only the issue.</li> <li>Provide links to code, papers, or other sources that prove or encourage your point.</li> <li>Answer in code. If a simple code snippet is the answer to the issue or shows how the issue can be solved, please provide a fully reproducible code snippet.</li>",hs,we,Bn=`Also, many issues tend to be simply off-topic, duplicates of other issues, or irrelevant. It is of great
help to the maintainers if you can answer such issues, encouraging the author of the issue to be
more precise, provide the link to a duplicated issue or redirect them to <a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers/63" rel="nofollow">the forum</a> or <a href="https://discord.gg/G7tWnz98XR" rel="nofollow">Discord</a>`,ps,be,On=`If you have verified that the issued bug report is correct and requires a correction in the source code,
please have a look at the next sections.`,ds,ve,Vn='For all of the following contributions, you will need to open a PR. It is explained in detail how to do so in the <a href="#how-to-open-a-pr">Opening a pull requst</a> section.',ms,xe,cs,$e,Qn=`<em>Good first issues</em> are marked by the <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22" rel="nofollow">Good first issue</a> label. Usually, the issue already
explains how a potential solution should look so that it is easier to fix.
If the issue hasn’t been closed and you would like to try to fix this issue, you can just leave a message “I would like to try this issue.”. There are usually three scenarios:`,gs,Te,Kn="<li>a.) The issue description already proposes a fix. In this case and if the solution makes sense to you, you can open a PR or draft PR to fix it.</li> <li>b.) The issue description does not propose a fix. In this case, you can ask what a proposed fix could look like and someone from the Diffusers team should answer shortly. If you have a good idea of how to fix it, feel free to directly open a PR.</li> <li>c.) There is already an open PR to fix the issue, but the issue hasn’t been closed yet. If the PR has gone stale, you can simply open a new PR and link to the stale PR. PRs often go stale if the original contributor who wanted to fix the issue suddenly cannot find the time anymore to proceed. This often happens in open-source and is very normal. In this case, the community will be very happy if you give it a new try and leverage the knowledge of the existing PR. If there is already a PR and it is active, you can help the author by giving suggestions, reviewing the PR or even asking whether you can contribute to the PR.</li>",ys,ke,ws,Me,el=`A good library <strong>always</strong> has good documentation! The official documentation is often one of the first points of contact for new users of the library, and therefore contributing to the documentation is a <strong>highly
valuable contribution</strong>.`,bs,Ce,tl="Contributing to the library can have many forms:",vs,He,il="<li>Correcting spelling or grammatical errors.</li> <li>Correct incorrect formatting of the docstring. If you see that the official documentation is weirdly displayed or a link is broken, we are very happy if you take some time to correct it.</li> <li>Correct the shape or dimensions of a docstring input or output tensor.</li> <li>Clarify documentation that is hard to understand or incorrect.</li> <li>Update outdated code examples.</li> <li>Translating the documentation to another language.</li>",xs,Le,sl='Anything displayed on <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">the official Diffusers doc page</a> is part of the official documentation and can be corrected, adjusted in the respective <a href="https://github.com/huggingface/diffusers/tree/main/docs/source" rel="nofollow">documentation source</a>.',$s,Pe,ol='Please have a look at <a href="https://github.com/huggingface/diffusers/tree/main/docs" rel="nofollow">this page</a> on how to verify changes made to the documentation locally.',Ts,_e,ks,Ie,nl=`<a href="https://huggingface.co/docs/diffusers/api/pipelines/overview" rel="nofollow">Pipelines</a> are usually the first point of contact between the Diffusers library and the user.
Pipelines are examples of how to use Diffusers <a href="https://huggingface.co/docs/diffusers/api/models" rel="nofollow">models</a> and <a href="https://huggingface.co/docs/diffusers/api/schedulers/overview" rel="nofollow">schedulers</a>.
We support two types of pipelines:`,Ms,qe,ll="<li>Official Pipelines</li> <li>Community Pipelines</li>",Cs,Re,al="Both official and community pipelines follow the same design and consist of the same type of components.",Hs,Ae,rl=`Official pipelines are tested and maintained by the core maintainers of Diffusers. Their code
resides in <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/pipelines" rel="nofollow">src/diffusers/pipelines</a>.
In contrast, community pipelines are contributed and maintained purely by the <strong>community</strong> and are <strong>not</strong> tested.
They reside in <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">examples/community</a> and while they can be accessed via the <a href="https://pypi.org/project/diffusers/" rel="nofollow">PyPI diffusers package</a>, their code is not part of the PyPI distribution.`,Ls,je,ul=`The reason for the distinction is that the core maintainers of the Diffusers library cannot maintain and test all
possible ways diffusion models can be used for inference, but some of them may be of interest to the community.
Officially released diffusion pipelines,
such as Stable Diffusion are added to the core src/diffusers/pipelines package which ensures
high quality of maintenance, no backward-breaking code changes, and testing.
More bleeding edge pipelines should be added as community pipelines. If usage for a community pipeline is high, the pipeline can be moved to the official pipelines upon request from the community. This is one of the ways we strive to be a community-driven library.`,Ps,Ue,fl='To add a community pipeline, one should add a &lt;name-of-the-community&gt;.py file to <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">examples/community</a> and adapt the <a href="https://github.com/huggingface/diffusers/tree/main/examples/community/README.md" rel="nofollow">examples/community/README.md</a> to include an example of the new pipeline.',_s,Ge,hl='An example can be seen <a href="https://github.com/huggingface/diffusers/pull/2400" rel="nofollow">here</a>.',Is,Je,pl="Community pipeline PRs are only checked at a superficial level and ideally they should be maintained by their original authors.",qs,De,dl=`Contributing a community pipeline is a great way to understand how Diffusers models and schedulers work. Having contributed a community pipeline is usually the first stepping stone to contributing an official pipeline to the
core package.`,Rs,We,As,Ze,ml='Diffusers examples are a collection of training scripts that reside in <a href="https://github.com/huggingface/diffusers/tree/main/examples" rel="nofollow">examples</a>.',js,Fe,cl="We support two types of training examples:",Us,Se,gl="<li>Official training examples</li> <li>Research training examples</li>",Gs,Ne,yl=`Research training examples are located in <a href="https://github.com/huggingface/diffusers/tree/main/examples/research_projects" rel="nofollow">examples/research_projects</a> whereas official training examples include all folders under <a href="https://github.com/huggingface/diffusers/tree/main/examples" rel="nofollow">examples</a> except the <code>research_projects</code> and <code>community</code> folders.
The official training examples are maintained by the Diffusers’ core maintainers whereas the research training examples are maintained by the community.
This is because of the same reasons put forward in <a href="#contribute-a-community-pipeline">6. Contribute a community pipeline</a> for official pipelines vs. community pipelines: It is not feasible for the core maintainers to maintain all possible training methods for diffusion models.
If the Diffusers core maintainers and the community consider a certain training paradigm to be too experimental or not popular enough, the corresponding training code should be put in the <code>research_projects</code> folder and maintained by the author.`,Js,Ye,wl=`Both official training and research examples consist of a directory that contains one or more training scripts, a requirements.txt file, and a README.md file. In order for the user to make use of the
training examples, it is required to clone the repository:`,Ds,Xe,Ws,ze,bl="as well as to install all additional dependencies required for training:",Zs,Ee,Fs,Be,vl='Therefore when adding an example, the <code>requirements.txt</code> file shall define all pip dependencies required for your training example so that once all those are installed, the user can run the example’s training script. See, for example, the <a href="https://github.com/huggingface/diffusers/blob/main/examples/dreambooth/requirements.txt" rel="nofollow">DreamBooth <code>requirements.txt</code> file</a>.',Ss,Oe,xl="Training examples of the Diffusers library should adhere to the following philosophy:",Ns,Ve,$l="<li>All the code necessary to run the examples should be found in a single Python file</li> <li>One should be able to run the example from the command line with <code>python &lt;your-example&gt;.py --args</code></li> <li>Examples should be kept simple and serve as <strong>an example</strong> on how to use Diffusers for training. The purpose of example scripts is <strong>not</strong> to create state-of-the-art diffusion models, but rather to reproduce known training schemes without adding too much custom logic. As a byproduct of this point, our examples also strive to serve as good educational materials.</li>",Ys,Qe,Tl=`To contribute an example, it is highly recommended to look at already existing examples such as <a href="https://github.com/huggingface/diffusers/blob/main/examples/dreambooth/train_dreambooth.py" rel="nofollow">dreambooth</a> to get an idea of how they should look like.
We strongly advise contributors to make use of the <a href="https://github.com/huggingface/accelerate" rel="nofollow">Accelerate library</a> as it’s tightly integrated
with Diffusers.
Once an example script works, please make sure to add a comprehensive <code>README.md</code> that states how to use the example exactly. This README should include:`,Xs,Ke,kl='<li>An example command on how to run the example script as shown <a href="https://github.com/huggingface/diffusers/tree/main/examples/dreambooth#running-locally-with-pytorch" rel="nofollow">here e.g.</a>.</li> <li>A link to some training results (logs, models, …) that show what the user can expect as shown <a href="https://api.wandb.ai/report/patrickvonplaten/xm6cd5q5" rel="nofollow">here e.g.</a>.</li> <li>If you are adding a non-official/research training example, <strong>please don’t forget</strong> to add a sentence that you are maintaining this training example which includes your git handle as shown <a href="https://github.com/huggingface/diffusers/tree/main/examples/research_projects/intel_opts#diffusers-examples-with-intel-optimizations" rel="nofollow">here</a>.</li>',zs,et,Ml='If you are contributing to the official training examples, please also make sure to add a test to <a href="https://github.com/huggingface/diffusers/blob/main/examples/test_examples.py" rel="nofollow">examples/test_examples.py</a>. This is not necessary for non-official training examples.',Es,tt,Bs,it,Cl=`<em>Good second issues</em> are marked by the <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22Good+second+issue%22" rel="nofollow">Good second issue</a> label. Good second issues are
usually more complicated to solve than <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22" rel="nofollow">Good first issues</a>.
The issue description usually gives less guidance on how to fix the issue and requires
a decent understanding of the library by the interested contributor.
If you are interested in tackling a second good issue, feel free to open a PR to fix it and link the PR to the issue. If you see that a PR has already been opened for this issue but did not get merged, have a look to understand why it wasn’t merged and try to open an improved PR.
Good second issues are usually more difficult to get merged compared to good first issues, so don’t hesitate to ask for help from the core maintainers. If your PR is almost finished the core maintainers can also jump into your PR and commit to it in order to get it merged.`,Os,st,Vs,ot,Hl=`Pipelines, models, and schedulers are the most important pieces of the Diffusers library.
They provide easy access to state-of-the-art diffusion technologies and thus allow the community to
build powerful generative AI applications.`,Qs,nt,Ll="By adding a new model, pipeline, or scheduler you might enable a new powerful use case for any of the user interfaces relying on Diffusers which can be of immense value for the whole generative AI ecosystem.",Ks,lt,Pl=`Diffusers has a couple of open feature requests for all three components - feel free to gloss over them
if you don’t know yet what specific component you would like to add:`,eo,at,_l='<li><a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22New+pipeline%2Fmodel%22" rel="nofollow">Model or pipeline</a></li> <li><a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22New+scheduler%22" rel="nofollow">Scheduler</a></li>',to,rt,Il=`Before adding any of the three components, it is strongly recommended that you give the <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22Good+second+issue%22" rel="nofollow">Philosophy guide</a> a read to better understand the design of any of the three components. Please be aware that
we cannot merge model, scheduler, or pipeline additions that strongly diverge from our design philosophy
as it will lead to API inconsistencies. If you fundamentally disagree with a design choice, please
open a <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=&amp;template=feedback.md&amp;title=" rel="nofollow">Feedback issue</a> instead so that it can be discussed whether a certain design
pattern/design choice shall be changed everywhere in the library and whether we shall update our design philosophy. Consistency across the library is very important for us.`,io,ut,ql=`Please make sure to add links to the original codebase/paper to the PR and ideally also ping the
original author directly on the PR so that they can follow the progress and potentially help with questions.`,so,ft,Rl="If you are unsure or stuck in the PR, don’t hesitate to leave a message to ask for a first review or help.",oo,ht,no,pt,Al="<strong>The better your issue is written, the higher the chances that it will be quickly resolved.</strong>",lo,dt,jl='<li>Make sure that you’ve used the correct template for your issue. You can pick between <em>Bug Report</em>, <em>Feature Request</em>, <em>Feedback about API Design</em>, <em>New model/pipeline/scheduler addition</em>, <em>Forum</em>, or a blank issue. Make sure to pick the correct one when opening <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">a new issue</a>.</li> <li><strong>Be precise</strong>: Give your issue a fitting title. Try to formulate your issue description as simple as possible. The more precise you are when submitting an issue, the less time it takes to understand the issue and potentially solve it. Make sure to open an issue for one issue only and not for multiple issues. If you found multiple issues, simply open multiple issues. If your issue is a bug, try to be as precise as possible about what bug it is - you should not just write “Error in diffusers”.</li> <li><strong>Reproducibility</strong>: No reproducible code snippet == no solution. If you encounter a bug, maintainers <strong>have to be able to reproduce</strong> it. Make sure that you include a code snippet that can be copy-pasted into a Python interpreter to reproduce the issue. Make sure that your code snippet works, <em>i.e.</em> that there are no missing imports or missing links to images, … Your issue should contain an error message <strong>and</strong> a code snippet that can be copy-pasted without any changes to reproduce the exact same error message. If your issue is using local model weights or local data that cannot be accessed by the reader, the issue cannot be solved. If you cannot share your data or model, try to make a dummy model or dummy data.</li> <li><strong>Minimalistic</strong>: Try to help the reader as much as you can to understand the issue as quickly as possible by staying as concise as possible. Remove all code / all information that is irrelevant to the issue. If you have found a bug, try to create the easiest code example you can to demonstrate your issue, do not just dump your whole workflow into the issue as soon as you have found a bug. E.g., if you train a model and get an error at some point during the training, you should first try to understand what part of the training code is responsible for the error and try to reproduce it with a couple of lines. Try to use dummy data instead of full datasets.</li> <li>Add links. If you are referring to a certain naming, method, or model make sure to provide a link so that the reader can better understand what you mean. If you are referring to a specific PR or issue, make sure to link it to your issue. Do not assume that the reader knows what you are talking about. The more links you add to your issue the better.</li> <li>Formatting. Make sure to nicely format your issue by formatting code into Python code syntax, and error messages into normal code syntax. See the <a href="https://docs.github.com/en/get-started/writing-on-github/getting-started-with-writing-and-formatting-on-github/basic-writing-and-formatting-syntax" rel="nofollow">official GitHub formatting docs</a> for more information.</li> <li>Think of your issue not as a ticket to be solved, but rather as a beautiful entry to a well-written encyclopedia. Every added issue is a contribution to publicly available knowledge. By adding a nicely written issue you not only make it easier for maintainers to solve your issue, but you are helping the whole community to better understand a certain aspect of the library.</li>',ao,mt,ro,ct,Ul=`<li>Be a chameleon. Understand existing design patterns and syntax and make sure your code additions flow seamlessly into the existing code base. Pull requests that significantly diverge from existing design patterns or user interfaces will not be merged.</li> <li>Be laser focused. A pull request should solve one problem and one problem only. Make sure to not fall into the trap of “also fixing another problem while we’re adding it”. It is much more difficult to review pull requests that solve multiple, unrelated problems at once.</li> <li>If helpful, try to add a code snippet that displays an example of how your addition can be used.</li> <li>The title of your pull request should be a summary of its contribution.</li> <li>If your pull request addresses an issue, please mention the issue number in
the pull request description to make sure they are linked (and people
consulting the issue know you are working on it);</li> <li>To indicate a work in progress please prefix the title with <code>[WIP]</code>. These
are useful to avoid duplicated work, and to differentiate it from PRs ready
to be merged;</li> <li>Try to formulate and format your text as explained in <a href="#how-to-write-a-good-issue">How to write a good issue</a>.</li> <li>Make sure existing tests pass;</li> <li>Add high-coverage tests. No quality testing = no merge.</li>`,uo,gt,Gl=`<li>If you are adding new <code>@slow</code> tests, make sure they pass using
<code>RUN_SLOW=1 python -m pytest tests/test_my_new_model.py</code>.
CircleCI does not run the slow tests, but GitHub actions does every night!</li>`,fo,x,Jl=`<li>All public methods must have informative docstrings that work nicely with markdown. See <code>[pipeline_latent_diffusion.py](https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/latent_diffusion/pipeline_latent_diffusion.py)</code> for an example.</li> <li>Due to the rapidly growing repository, it is important to make sure that no files that would significantly weigh down the repository are added. This includes images, videos, and other non-text files. We prefer to leverage a hf.co hosted <code>dataset</code> like
<a href="https://huggingface.co/hf-internal-testing" rel="nofollow"><code>hf-internal-testing</code></a> or <a href="https://huggingface.co/datasets/huggingface/documentation-images" rel="nofollow">huggingface/documentation-images</a> to place these files.
If an external contribution, feel free to add the images to your PR and ask a Hugging Face member to migrate your images
to this dataset.</li>`,ho,yt,po,wt,Dl=`Before writing code, we strongly advise you to search through the existing PRs or
issues to make sure that nobody is already working on the same thing. If you are
unsure, it is always a good idea to open an issue to get some feedback.`,mo,bt,Wl=`You will need basic <code>git</code> proficiency to be able to contribute to
🧨 Diffusers. <code>git</code> is not the easiest tool to use but it has the greatest
manual. Type <code>git --help</code> in a shell and enjoy. If you prefer books, <a href="https://git-scm.com/book/en/v2" rel="nofollow">Pro
Git</a> is a very good reference.`,co,vt,Zl='Follow these steps to start contributing (<a href="https://github.com/huggingface/diffusers/blob/main/setup.py#L244" rel="nofollow">supported Python versions</a>):',go,w,ri,Fl=`<p>Fork the <a href="https://github.com/huggingface/diffusers" rel="nofollow">repository</a> by
clicking on the ‘Fork’ button on the repository’s page. This creates a copy of the code
under your GitHub user account.</p>`,on,xt,ui,Sl="Clone your fork to your local disk, and add the base repository as a remote:",nn,$t,ln,Tt,fi,Nl="Create a new branch to hold your development changes:",an,kt,yo,Mt,Yl="<strong>Do not</strong> work on the <code>main</code> branch.",wo,Ct,Ht,hi,Xl="Set up a development environment by running the following command in a virtual environment:",rn,Lt,bo,Pt,zl=`If you have already cloned the repo, you might need to <code>git pull</code> to get the most recent changes in the
library.`,vo,$,El="<li>Develop the features on your branch.</li>",xo,_t,Bl=`As you work on the features, you should make sure that the test suite
passes. You should run the tests impacted by your changes like this:`,$o,It,To,qt,Ol=`You can also run the full suite with the following command, but it takes
a beefy machine to produce a result in a decent amount of time now that
Diffusers has grown a lot. Here is the command for it:`,ko,Rt,Mo,At,Vl=`🧨 Diffusers relies on <code>black</code> and <code>isort</code> to format its source code
consistently. After you make changes, apply automatic style corrections and code verifications
that can’t be automated in one go with:`,Co,jt,Ho,Ut,Ql=`🧨 Diffusers also uses <code>ruff</code> and a few custom scripts to check for coding mistakes. Quality
control runs in CI, however, you can also run the same checks with:`,Lo,Gt,Po,Jt,Kl=`Once you’re happy with your changes, add changed files using <code>git add</code> and
make a commit with <code>git commit</code> to record your changes locally:`,_o,Dt,Io,Wt,ea=`It is a good idea to sync your copy of the code with the original
repository regularly. This way you can quickly account for changes:`,qo,Zt,Ro,Ft,ta="Push the changes to your account using:",Ao,St,jo,T,ia=`<li><p>Once you are satisfied, go to the
webpage of your fork on GitHub. Click on ‘Pull request’ to send your changes
to the project maintainers for review.</p></li> <li><p>It’s ok if maintainers ask you for changes. It happens to core contributors
too! So everyone can see the changes in the Pull request, work in your local
branch and push the changes to your fork. They will automatically appear in
the pull request.</p></li>`,Uo,Nt,Go,Yt,sa=`An extensive test suite is included to test the library behavior and several examples. Library tests can be found in
the <a href="https://github.com/huggingface/diffusers/tree/main/tests" rel="nofollow">tests folder</a>.`,Jo,Xt,oa=`We like <code>pytest</code> and <code>pytest-xdist</code> because it’s faster. From the root of the
repository, here’s how to run tests with <code>pytest</code> for the library:`,Do,zt,Wo,Et,na="In fact, that’s how <code>make test</code> is implemented!",Zo,Bt,la=`You can specify a smaller set of tests in order to test only the feature
you’re working on.`,Fo,Ot,aa=`By default, slow tests are skipped. Set the <code>RUN_SLOW</code> environment variable to
<code>yes</code> to run them. This will download many gigabytes of models — make sure you
have enough disk space and a good Internet connection, or a lot of patience!`,So,Vt,No,Qt,ra="<code>unittest</code> is fully supported, here’s how to run tests with it:",Yo,Kt,Xo,ei,zo,ti,ua=`To avoid pinging the upstream repository which adds reference notes to each upstream PR and sends unnecessary notifications to the developers involved in these PRs,
when syncing the main branch of a forked repository, please, follow these steps:`,Eo,ii,fa="<li>When possible, avoid syncing with the upstream using a branch and PR on the forked repository. Instead, merge directly into the forked main.</li> <li>If a PR is absolutely necessary, use the following steps after checking out your branch:</li>",Bo,si,Oo,oi,Vo,ni,ha='For documentation strings, 🧨 Diffusers follows the <a href="https://google.github.io/styleguide/pyguide.html" rel="nofollow">google style</a>.',Qo,mi,Ko;return k=new c({props:{title:"How to contribute to Diffusers 🧨",local:"how-to-contribute-to-diffusers-",headingTag:"h1"}}),P=new c({props:{title:"Overview",local:"overview",headingTag:"h2"}}),j=new c({props:{title:"1. Asking and answering questions on the Diffusers discussion forum or on the Diffusers Discord",local:"1-asking-and-answering-questions-on-the-diffusers-discussion-forum-or-on-the-diffusers-discord",headingTag:"h3"}}),Z=new c({props:{title:"2. Opening new issues on the GitHub issues tab",local:"2-opening-new-issues-on-the-github-issues-tab",headingTag:"h3"}}),E=new c({props:{title:"2.1. Reproducible, minimal bug reports.",local:"21-reproducible-minimal-bug-reports",headingTag:"h4"}}),K=new c({props:{title:"2.2. Feature requests.",local:"22-feature-requests",headingTag:"h4"}}),oe=new c({props:{title:"2.3 Feedback.",local:"23-feedback",headingTag:"h4"}}),ae=new c({props:{title:"2.4 Technical questions.",local:"24-technical-questions",headingTag:"h4"}}),fe=new c({props:{title:"2.5 Proposal to add a new model, scheduler, or pipeline.",local:"25-proposal-to-add-a-new-model-scheduler-or-pipeline",headingTag:"h4"}}),ce=new c({props:{title:"3. Answering issues on the GitHub issues tab",local:"3-answering-issues-on-the-github-issues-tab",headingTag:"h3"}}),xe=new c({props:{title:"4. Fixing a Good first issue",local:"4-fixing-a-good-first-issue",headingTag:"h3"}}),ke=new c({props:{title:"5. Contribute to the documentation",local:"5-contribute-to-the-documentation",headingTag:"h3"}}),_e=new c({props:{title:"6. Contribute a community pipeline",local:"6-contribute-a-community-pipeline",headingTag:"h3"}}),We=new c({props:{title:"7. Contribute to training examples",local:"7-contribute-to-training-examples",headingTag:"h3"}}),Xe=new g({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2Vycw==",highlighted:'git clone https:<span class="hljs-regexp">//gi</span>thub.com<span class="hljs-regexp">/huggingface/</span>diffusers',wrap:!1}}),Ee=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1yJTIwJTJGZXhhbXBsZXMlMkYlM0N5b3VyLWV4YW1wbGUtZm9sZGVyJTNFJTJGcmVxdWlyZW1lbnRzLnR4dA==",highlighted:'pip install -r <span class="hljs-regexp">/examples/</span>&lt;your-example-folder&gt;/requirements.txt',wrap:!1}}),tt=new c({props:{title:"8. Fixing a Good second issue",local:"8-fixing-a-good-second-issue",headingTag:"h3"}}),st=new c({props:{title:"9. Adding pipelines, models, schedulers",local:"9-adding-pipelines-models-schedulers",headingTag:"h3"}}),ht=new c({props:{title:"How to write a good issue",local:"how-to-write-a-good-issue",headingTag:"h2"}}),mt=new c({props:{title:"How to write a good PR",local:"how-to-write-a-good-pr",headingTag:"h2"}}),yt=new c({props:{title:"How to open a PR",local:"how-to-open-a-pr",headingTag:"h2"}}),$t=new g({props:{code:"JTI0JTIwZ2l0JTIwY2xvbmUlMjBnaXQlNDBnaXRodWIuY29tJTNBJTNDeW91ciUyMEdpdGh1YiUyMGhhbmRsZSUzRSUyRmRpZmZ1c2Vycy5naXQlMEElMjQlMjBjZCUyMGRpZmZ1c2VycyUwQSUyNCUyMGdpdCUyMHJlbW90ZSUyMGFkZCUyMHVwc3RyZWFtJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkaWZmdXNlcnMuZ2l0",highlighted:`$ git <span class="hljs-built_in">clone</span> git@github.com:&lt;your Github handle&gt;/diffusers.git
$ <span class="hljs-built_in">cd</span> diffusers
$ git remote add upstream https://github.com/huggingface/diffusers.git`,wrap:!1}}),kt=new g({props:{code:"JTI0JTIwZ2l0JTIwY2hlY2tvdXQlMjAtYiUyMGEtZGVzY3JpcHRpdmUtbmFtZS1mb3ItbXktY2hhbmdlcw==",highlighted:"$ git checkout -b a-descriptive-name-for-my-changes",wrap:!1}}),Lt=new g({props:{code:"JTI0JTIwcGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QmRldiU1RCUyMg==",highlighted:'$ pip install -e <span class="hljs-string">&quot;.[dev]&quot;</span>',wrap:!1}}),It=new g({props:{code:"JTI0JTIwcHl0ZXN0JTIwdGVzdHMlMkYlM0NURVNUX1RPX1JVTiUzRS5weQ==",highlighted:"$ pytest tests/&lt;TEST_TO_RUN&gt;.py",wrap:!1}}),Rt=new g({props:{code:"JTI0JTIwbWFrZSUyMHRlc3Q=",highlighted:'$ make <span class="hljs-built_in">test</span>',wrap:!1}}),jt=new g({props:{code:"JTI0JTIwbWFrZSUyMHN0eWxl",highlighted:"$ make style",wrap:!1}}),Gt=new g({props:{code:"JTI0JTIwbWFrZSUyMHF1YWxpdHk=",highlighted:"$ make quality",wrap:!1}}),Dt=new g({props:{code:"JTI0JTIwZ2l0JTIwYWRkJTIwbW9kaWZpZWRfZmlsZS5weSUwQSUyNCUyMGdpdCUyMGNvbW1pdA==",highlighted:`$ git add modified_file.py
$ git commit`,wrap:!1}}),Zt=new g({props:{code:"JTI0JTIwZ2l0JTIwcHVsbCUyMHVwc3RyZWFtJTIwbWFpbg==",highlighted:"$ git pull upstream main",wrap:!1}}),St=new g({props:{code:"JTI0JTIwZ2l0JTIwcHVzaCUyMC11JTIwb3JpZ2luJTIwYS1kZXNjcmlwdGl2ZS1uYW1lLWZvci1teS1jaGFuZ2Vz",highlighted:"$ git push -u origin a-descriptive-name-for-my-changes",wrap:!1}}),Nt=new c({props:{title:"Tests",local:"tests",headingTag:"h3"}}),zt=new g({props:{code:"JTI0JTIwcHl0aG9uJTIwLW0lMjBweXRlc3QlMjAtbiUyMGF1dG8lMjAtLWRpc3QlM0Rsb2FkZmlsZSUyMC1zJTIwLXYlMjAuJTJGdGVzdHMlMkY=",highlighted:"$ python -m pytest -n auto --dist=loadfile -s -v ./tests/",wrap:!1}}),Vt=new g({props:{code:"JTI0JTIwUlVOX1NMT1clM0R5ZXMlMjBweXRob24lMjAtbSUyMHB5dGVzdCUyMC1uJTIwYXV0byUyMC0tZGlzdCUzRGxvYWRmaWxlJTIwLXMlMjAtdiUyMC4lMkZ0ZXN0cyUyRg==",highlighted:'$ RUN_SLOW=<span class="hljs-built_in">yes</span> python -m pytest -n auto --dist=loadfile -s -v ./tests/',wrap:!1}}),Kt=new g({props:{code:"JTI0JTIwcHl0aG9uJTIwLW0lMjB1bml0dGVzdCUyMGRpc2NvdmVyJTIwLXMlMjB0ZXN0cyUyMC10JTIwLiUyMC12JTBBJTI0JTIwcHl0aG9uJTIwLW0lMjB1bml0dGVzdCUyMGRpc2NvdmVyJTIwLXMlMjBleGFtcGxlcyUyMC10JTIwZXhhbXBsZXMlMjAtdg==",highlighted:`$ python -m unittest discover -s tests -t . -v
$ python -m unittest discover -s examples -t examples -v`,wrap:!1}}),ei=new c({props:{title:"Syncing forked main with upstream (HuggingFace) main",local:"syncing-forked-main-with-upstream-huggingface-main",headingTag:"h3"}}),si=new g({props:{code:"JTI0JTIwZ2l0JTIwY2hlY2tvdXQlMjAtYiUyMHlvdXItYnJhbmNoLWZvci1zeW5jaW5nJTBBJTI0JTIwZ2l0JTIwcHVsbCUyMC0tc3F1YXNoJTIwLS1uby1jb21taXQlMjB1cHN0cmVhbSUyMG1haW4lMEElMjQlMjBnaXQlMjBjb21taXQlMjAtbSUyMCclM0N5b3VyJTIwbWVzc2FnZSUyMHdpdGhvdXQlMjBHaXRIdWIlMjByZWZlcmVuY2VzJTNFJyUwQSUyNCUyMGdpdCUyMHB1c2glMjAtLXNldC11cHN0cmVhbSUyMG9yaWdpbiUyMHlvdXItYnJhbmNoLWZvci1zeW5jaW5n",highlighted:`<span class="hljs-symbol">$</span> git checkout -b your-branch-<span class="hljs-keyword">for</span>-syncing
<span class="hljs-symbol">$</span> git pull --squash --<span class="hljs-keyword">no</span>-commit upstream main
<span class="hljs-symbol">$</span> git commit -m <span class="hljs-string">&#x27;&lt;your message without GitHub references&gt;&#x27;</span>
<span class="hljs-symbol">$</span> git push --<span class="hljs-keyword">set</span>-upstream <span class="hljs-comment">origin your-branch-for-syncing</span>`,wrap:!1}}),oi=new c({props:{title:"Style guide",local:"style-guide",headingTag:"h3"}}),{c(){b=l("meta"),ci=o(),di=l("p"),gi=o(),u(k.$$.fragment),yi=o(),M=l("p"),M.textContent=fn,wi=o(),C=l("p"),C.innerHTML=hn,bi=o(),H=l("p"),H.innerHTML=pn,vi=o(),L=l("p"),L.textContent=dn,xi=o(),u(P.$$.fragment),$i=o(),_=l("p"),_.textContent=mn,Ti=o(),I=l("p"),I.textContent=cn,ki=o(),q=l("ul"),q.innerHTML=gn,Mi=o(),R=l("p"),R.innerHTML=yn,Ci=o(),A=l("p"),A.innerHTML=wn,Hi=o(),u(j.$$.fragment),Li=o(),U=l("p"),U.innerHTML=bn,Pi=o(),G=l("ul"),G.innerHTML=vn,_i=o(),J=l("p"),J.textContent=xn,Ii=o(),D=l("p"),D.innerHTML=$n,qi=o(),W=l("p"),W.innerHTML=Tn,Ri=o(),u(Z.$$.fragment),Ai=o(),F=l("p"),F.textContent=kn,ji=o(),S=l("p"),S.textContent=Mn,Ui=o(),N=l("p"),N.innerHTML=Cn,Gi=o(),Y=l("p"),Y.innerHTML=Hn,Ji=o(),X=l("ul"),X.innerHTML=Ln,Di=o(),z=l("p"),z.textContent=Pn,Wi=o(),u(E.$$.fragment),Zi=o(),B=l("p"),B.textContent=_n,Fi=o(),O=l("ul"),O.innerHTML=In,Si=o(),V=l("p"),V.innerHTML=qn,Ni=o(),Q=l("p"),Q.innerHTML=Rn,Yi=o(),u(K.$$.fragment),Xi=o(),ee=l("p"),ee.textContent=An,zi=o(),te=l("ol"),te.innerHTML=jn,Ei=o(),ie=l("ul"),ie.innerHTML=Un,Bi=o(),v=l("ol"),v.innerHTML=Gn,Oi=o(),se=l("p"),se.innerHTML=Jn,Vi=o(),u(oe.$$.fragment),Qi=o(),ne=l("p"),ne.innerHTML=Dn,Ki=o(),le=l("p"),le.innerHTML=Wn,es=o(),u(ae.$$.fragment),ts=o(),re=l("p"),re.textContent=Zn,is=o(),ue=l("p"),ue.innerHTML=Fn,ss=o(),u(fe.$$.fragment),os=o(),he=l("p"),he.textContent=Sn,ns=o(),pe=l("ul"),pe.innerHTML=Nn,ls=o(),de=l("p"),de.textContent=Yn,as=o(),me=l("p"),me.innerHTML=Xn,rs=o(),u(ce.$$.fragment),us=o(),ge=l("p"),ge.textContent=zn,fs=o(),ye=l("ul"),ye.innerHTML=En,hs=o(),we=l("p"),we.innerHTML=Bn,ps=o(),be=l("p"),be.textContent=On,ds=o(),ve=l("p"),ve.innerHTML=Vn,ms=o(),u(xe.$$.fragment),cs=o(),$e=l("p"),$e.innerHTML=Qn,gs=o(),Te=l("ul"),Te.innerHTML=Kn,ys=o(),u(ke.$$.fragment),ws=o(),Me=l("p"),Me.innerHTML=el,bs=o(),Ce=l("p"),Ce.textContent=tl,vs=o(),He=l("ul"),He.innerHTML=il,xs=o(),Le=l("p"),Le.innerHTML=sl,$s=o(),Pe=l("p"),Pe.innerHTML=ol,Ts=o(),u(_e.$$.fragment),ks=o(),Ie=l("p"),Ie.innerHTML=nl,Ms=o(),qe=l("ul"),qe.innerHTML=ll,Cs=o(),Re=l("p"),Re.textContent=al,Hs=o(),Ae=l("p"),Ae.innerHTML=rl,Ls=o(),je=l("p"),je.textContent=ul,Ps=o(),Ue=l("p"),Ue.innerHTML=fl,_s=o(),Ge=l("p"),Ge.innerHTML=hl,Is=o(),Je=l("p"),Je.textContent=pl,qs=o(),De=l("p"),De.textContent=dl,Rs=o(),u(We.$$.fragment),As=o(),Ze=l("p"),Ze.innerHTML=ml,js=o(),Fe=l("p"),Fe.textContent=cl,Us=o(),Se=l("ul"),Se.innerHTML=gl,Gs=o(),Ne=l("p"),Ne.innerHTML=yl,Js=o(),Ye=l("p"),Ye.textContent=wl,Ds=o(),u(Xe.$$.fragment),Ws=o(),ze=l("p"),ze.textContent=bl,Zs=o(),u(Ee.$$.fragment),Fs=o(),Be=l("p"),Be.innerHTML=vl,Ss=o(),Oe=l("p"),Oe.textContent=xl,Ns=o(),Ve=l("ul"),Ve.innerHTML=$l,Ys=o(),Qe=l("p"),Qe.innerHTML=Tl,Xs=o(),Ke=l("ul"),Ke.innerHTML=kl,zs=o(),et=l("p"),et.innerHTML=Ml,Es=o(),u(tt.$$.fragment),Bs=o(),it=l("p"),it.innerHTML=Cl,Os=o(),u(st.$$.fragment),Vs=o(),ot=l("p"),ot.textContent=Hl,Qs=o(),nt=l("p"),nt.textContent=Ll,Ks=o(),lt=l("p"),lt.textContent=Pl,eo=o(),at=l("ul"),at.innerHTML=_l,to=o(),rt=l("p"),rt.innerHTML=Il,io=o(),ut=l("p"),ut.textContent=ql,so=o(),ft=l("p"),ft.textContent=Rl,oo=o(),u(ht.$$.fragment),no=o(),pt=l("p"),pt.innerHTML=Al,lo=o(),dt=l("ol"),dt.innerHTML=jl,ao=o(),u(mt.$$.fragment),ro=o(),ct=l("ol"),ct.innerHTML=Ul,uo=o(),gt=l("ul"),gt.innerHTML=Gl,fo=o(),x=l("ol"),x.innerHTML=Jl,ho=o(),u(yt.$$.fragment),po=o(),wt=l("p"),wt.textContent=Dl,mo=o(),bt=l("p"),bt.innerHTML=Wl,co=o(),vt=l("p"),vt.innerHTML=Zl,go=o(),w=l("ol"),ri=l("li"),ri.innerHTML=Fl,on=o(),xt=l("li"),ui=l("p"),ui.textContent=Sl,nn=o(),u($t.$$.fragment),ln=o(),Tt=l("li"),fi=l("p"),fi.textContent=Nl,an=o(),u(kt.$$.fragment),yo=o(),Mt=l("p"),Mt.innerHTML=Yl,wo=o(),Ct=l("ol"),Ht=l("li"),hi=l("p"),hi.textContent=Xl,rn=o(),u(Lt.$$.fragment),bo=o(),Pt=l("p"),Pt.innerHTML=zl,vo=o(),$=l("ol"),$.innerHTML=El,xo=o(),_t=l("p"),_t.textContent=Bl,$o=o(),u(It.$$.fragment),To=o(),qt=l("p"),qt.textContent=Ol,ko=o(),u(Rt.$$.fragment),Mo=o(),At=l("p"),At.innerHTML=Vl,Co=o(),u(jt.$$.fragment),Ho=o(),Ut=l("p"),Ut.innerHTML=Ql,Lo=o(),u(Gt.$$.fragment),Po=o(),Jt=l("p"),Jt.innerHTML=Kl,_o=o(),u(Dt.$$.fragment),Io=o(),Wt=l("p"),Wt.textContent=ea,qo=o(),u(Zt.$$.fragment),Ro=o(),Ft=l("p"),Ft.textContent=ta,Ao=o(),u(St.$$.fragment),jo=o(),T=l("ol"),T.innerHTML=ia,Uo=o(),u(Nt.$$.fragment),Go=o(),Yt=l("p"),Yt.innerHTML=sa,Jo=o(),Xt=l("p"),Xt.innerHTML=oa,Do=o(),u(zt.$$.fragment),Wo=o(),Et=l("p"),Et.innerHTML=na,Zo=o(),Bt=l("p"),Bt.textContent=la,Fo=o(),Ot=l("p"),Ot.innerHTML=aa,So=o(),u(Vt.$$.fragment),No=o(),Qt=l("p"),Qt.innerHTML=ra,Yo=o(),u(Kt.$$.fragment),Xo=o(),u(ei.$$.fragment),zo=o(),ti=l("p"),ti.textContent=ua,Eo=o(),ii=l("ol"),ii.innerHTML=fa,Bo=o(),u(si.$$.fragment),Oo=o(),u(oi.$$.fragment),Vo=o(),ni=l("p"),ni.innerHTML=ha,Qo=o(),mi=l("p"),this.h()},l(e){const t=wa("svelte-u9bgzb",document.head);b=a(t,"META",{name:!0,content:!0}),t.forEach(i),ci=n(e),di=a(e,"P",{}),li(di).forEach(i),gi=n(e),f(k.$$.fragment,e),yi=n(e),M=a(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-5law2j"&&(M.textContent=fn),wi=n(e),C=a(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-rf5fv0"&&(C.innerHTML=hn),bi=n(e),H=a(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-7yk1qu"&&(H.innerHTML=pn),vi=n(e),L=a(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-19e4jq9"&&(L.textContent=dn),xi=n(e),f(P.$$.fragment,e),$i=n(e),_=a(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-qchdhx"&&(_.textContent=mn),Ti=n(e),I=a(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-vste1h"&&(I.textContent=cn),ki=n(e),q=a(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-1f9n7up"&&(q.innerHTML=gn),Mi=n(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1a17ouk"&&(R.innerHTML=yn),Ci=n(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-13u2t4g"&&(A.innerHTML=wn),Hi=n(e),f(j.$$.fragment,e),Li=n(e),U=a(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-eooydc"&&(U.innerHTML=bn),Pi=n(e),G=a(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-1pzwmv0"&&(G.innerHTML=vn),_i=n(e),J=a(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-pnrj3i"&&(J.textContent=xn),Ii=n(e),D=a(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-13m4oj1"&&(D.innerHTML=$n),qi=n(e),W=a(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-14aelba"&&(W.innerHTML=Tn),Ri=n(e),f(Z.$$.fragment,e),Ai=n(e),F=a(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1xkk71m"&&(F.textContent=kn),ji=n(e),S=a(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1kqqlyc"&&(S.textContent=Mn),Ui=n(e),N=a(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-180qij7"&&(N.innerHTML=Cn),Gi=n(e),Y=a(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1fjofc5"&&(Y.innerHTML=Hn),Ji=n(e),X=a(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-pzymlv"&&(X.innerHTML=Ln),Di=n(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1gfbuxb"&&(z.textContent=Pn),Wi=n(e),f(E.$$.fragment,e),Zi=n(e),B=a(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ipsy1e"&&(B.textContent=_n),Fi=n(e),O=a(e,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-qby08s"&&(O.innerHTML=In),Si=n(e),V=a(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-b221ai"&&(V.innerHTML=qn),Ni=n(e),Q=a(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-y09iyf"&&(Q.innerHTML=Rn),Yi=n(e),f(K.$$.fragment,e),Xi=n(e),ee=a(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1s92zhu"&&(ee.textContent=An),zi=n(e),te=a(e,"OL",{"data-svelte-h":!0}),r(te)!=="svelte-1meaa0h"&&(te.innerHTML=jn),Ei=n(e),ie=a(e,"UL",{"data-svelte-h":!0}),r(ie)!=="svelte-1m6et35"&&(ie.innerHTML=Un),Bi=n(e),v=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(v)!=="svelte-1353nnk"&&(v.innerHTML=Gn),Oi=n(e),se=a(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1fbsnox"&&(se.innerHTML=Jn),Vi=n(e),f(oe.$$.fragment,e),Qi=n(e),ne=a(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-14r8j00"&&(ne.innerHTML=Dn),Ki=n(e),le=a(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-19nmi90"&&(le.innerHTML=Wn),es=n(e),f(ae.$$.fragment,e),ts=n(e),re=a(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-8nb70c"&&(re.textContent=Zn),is=n(e),ue=a(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-117d5cx"&&(ue.innerHTML=Fn),ss=n(e),f(fe.$$.fragment,e),os=n(e),he=a(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-10axoet"&&(he.textContent=Sn),ns=n(e),pe=a(e,"UL",{"data-svelte-h":!0}),r(pe)!=="svelte-xff9o9"&&(pe.innerHTML=Nn),ls=n(e),de=a(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1g4ps0b"&&(de.textContent=Yn),as=n(e),me=a(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-sc0vav"&&(me.innerHTML=Xn),rs=n(e),f(ce.$$.fragment,e),us=n(e),ge=a(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-15u5nyq"&&(ge.textContent=zn),fs=n(e),ye=a(e,"UL",{"data-svelte-h":!0}),r(ye)!=="svelte-jf9j68"&&(ye.innerHTML=En),hs=n(e),we=a(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1ebusdj"&&(we.innerHTML=Bn),ps=n(e),be=a(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1n38hfq"&&(be.textContent=On),ds=n(e),ve=a(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-o7ynh7"&&(ve.innerHTML=Vn),ms=n(e),f(xe.$$.fragment,e),cs=n(e),$e=a(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-17d5j91"&&($e.innerHTML=Qn),gs=n(e),Te=a(e,"UL",{"data-svelte-h":!0}),r(Te)!=="svelte-csw3jn"&&(Te.innerHTML=Kn),ys=n(e),f(ke.$$.fragment,e),ws=n(e),Me=a(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-p135hl"&&(Me.innerHTML=el),bs=n(e),Ce=a(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-dmhl9b"&&(Ce.textContent=tl),vs=n(e),He=a(e,"UL",{"data-svelte-h":!0}),r(He)!=="svelte-1r0ctkz"&&(He.innerHTML=il),xs=n(e),Le=a(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1fszx"&&(Le.innerHTML=sl),$s=n(e),Pe=a(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-6of141"&&(Pe.innerHTML=ol),Ts=n(e),f(_e.$$.fragment,e),ks=n(e),Ie=a(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-5eiflc"&&(Ie.innerHTML=nl),Ms=n(e),qe=a(e,"UL",{"data-svelte-h":!0}),r(qe)!=="svelte-1huzw6a"&&(qe.innerHTML=ll),Cs=n(e),Re=a(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-bi46pe"&&(Re.textContent=al),Hs=n(e),Ae=a(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1m88k68"&&(Ae.innerHTML=rl),Ls=n(e),je=a(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1oqcq1v"&&(je.textContent=ul),Ps=n(e),Ue=a(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1yh6g4i"&&(Ue.innerHTML=fl),_s=n(e),Ge=a(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-nd3yab"&&(Ge.innerHTML=hl),Is=n(e),Je=a(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-oxm1xv"&&(Je.textContent=pl),qs=n(e),De=a(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-19m8l5c"&&(De.textContent=dl),Rs=n(e),f(We.$$.fragment,e),As=n(e),Ze=a(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1695xih"&&(Ze.innerHTML=ml),js=n(e),Fe=a(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-dlx7ai"&&(Fe.textContent=cl),Us=n(e),Se=a(e,"UL",{"data-svelte-h":!0}),r(Se)!=="svelte-15twepo"&&(Se.innerHTML=gl),Gs=n(e),Ne=a(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-j907t6"&&(Ne.innerHTML=yl),Js=n(e),Ye=a(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-vgkeor"&&(Ye.textContent=wl),Ds=n(e),f(Xe.$$.fragment,e),Ws=n(e),ze=a(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-idor3x"&&(ze.textContent=bl),Zs=n(e),f(Ee.$$.fragment,e),Fs=n(e),Be=a(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1951zcj"&&(Be.innerHTML=vl),Ss=n(e),Oe=a(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1m6im41"&&(Oe.textContent=xl),Ns=n(e),Ve=a(e,"UL",{"data-svelte-h":!0}),r(Ve)!=="svelte-bnb7i1"&&(Ve.innerHTML=$l),Ys=n(e),Qe=a(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-68kw4k"&&(Qe.innerHTML=Tl),Xs=n(e),Ke=a(e,"UL",{"data-svelte-h":!0}),r(Ke)!=="svelte-16l4ykk"&&(Ke.innerHTML=kl),zs=n(e),et=a(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-paax9d"&&(et.innerHTML=Ml),Es=n(e),f(tt.$$.fragment,e),Bs=n(e),it=a(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-2um9r5"&&(it.innerHTML=Cl),Os=n(e),f(st.$$.fragment,e),Vs=n(e),ot=a(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-if0791"&&(ot.textContent=Hl),Qs=n(e),nt=a(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-9zs46y"&&(nt.textContent=Ll),Ks=n(e),lt=a(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-ktahrm"&&(lt.textContent=Pl),eo=n(e),at=a(e,"UL",{"data-svelte-h":!0}),r(at)!=="svelte-1frr5y8"&&(at.innerHTML=_l),to=n(e),rt=a(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1vts95a"&&(rt.innerHTML=Il),io=n(e),ut=a(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-2xpxr5"&&(ut.textContent=ql),so=n(e),ft=a(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-15y7ezq"&&(ft.textContent=Rl),oo=n(e),f(ht.$$.fragment,e),no=n(e),pt=a(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-160saia"&&(pt.innerHTML=Al),lo=n(e),dt=a(e,"OL",{"data-svelte-h":!0}),r(dt)!=="svelte-147evhz"&&(dt.innerHTML=jl),ao=n(e),f(mt.$$.fragment,e),ro=n(e),ct=a(e,"OL",{"data-svelte-h":!0}),r(ct)!=="svelte-1dyfapb"&&(ct.innerHTML=Ul),uo=n(e),gt=a(e,"UL",{"data-svelte-h":!0}),r(gt)!=="svelte-1re4e05"&&(gt.innerHTML=Gl),fo=n(e),x=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(x)!=="svelte-1bfpdd6"&&(x.innerHTML=Jl),ho=n(e),f(yt.$$.fragment,e),po=n(e),wt=a(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-18wldn4"&&(wt.textContent=Dl),mo=n(e),bt=a(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-ha1e2a"&&(bt.innerHTML=Wl),co=n(e),vt=a(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-hj53bb"&&(vt.innerHTML=Zl),go=n(e),w=a(e,"OL",{});var pi=li(w);ri=a(pi,"LI",{"data-svelte-h":!0}),r(ri)!=="svelte-1051ijo"&&(ri.innerHTML=Fl),on=n(pi),xt=a(pi,"LI",{});var en=li(xt);ui=a(en,"P",{"data-svelte-h":!0}),r(ui)!=="svelte-clge5v"&&(ui.textContent=Sl),nn=n(en),f($t.$$.fragment,en),en.forEach(i),ln=n(pi),Tt=a(pi,"LI",{});var tn=li(Tt);fi=a(tn,"P",{"data-svelte-h":!0}),r(fi)!=="svelte-imt6wq"&&(fi.textContent=Nl),an=n(tn),f(kt.$$.fragment,tn),tn.forEach(i),pi.forEach(i),yo=n(e),Mt=a(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-12bf6z0"&&(Mt.innerHTML=Yl),wo=n(e),Ct=a(e,"OL",{start:!0});var pa=li(Ct);Ht=a(pa,"LI",{});var sn=li(Ht);hi=a(sn,"P",{"data-svelte-h":!0}),r(hi)!=="svelte-1sxg1ux"&&(hi.textContent=Xl),rn=n(sn),f(Lt.$$.fragment,sn),sn.forEach(i),pa.forEach(i),bo=n(e),Pt=a(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-baqsq9"&&(Pt.innerHTML=zl),vo=n(e),$=a(e,"OL",{start:!0,"data-svelte-h":!0}),r($)!=="svelte-1ug4u82"&&($.innerHTML=El),xo=n(e),_t=a(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-6e1eyz"&&(_t.textContent=Bl),$o=n(e),f(It.$$.fragment,e),To=n(e),qt=a(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-1xvc43c"&&(qt.textContent=Ol),ko=n(e),f(Rt.$$.fragment,e),Mo=n(e),At=a(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-1ee1sp3"&&(At.innerHTML=Vl),Co=n(e),f(jt.$$.fragment,e),Ho=n(e),Ut=a(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-1fsb6ew"&&(Ut.innerHTML=Ql),Lo=n(e),f(Gt.$$.fragment,e),Po=n(e),Jt=a(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-1h0d1ob"&&(Jt.innerHTML=Kl),_o=n(e),f(Dt.$$.fragment,e),Io=n(e),Wt=a(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-b5s72j"&&(Wt.textContent=ea),qo=n(e),f(Zt.$$.fragment,e),Ro=n(e),Ft=a(e,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-1adm7yl"&&(Ft.textContent=ta),Ao=n(e),f(St.$$.fragment,e),jo=n(e),T=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(T)!=="svelte-cpur5x"&&(T.innerHTML=ia),Uo=n(e),f(Nt.$$.fragment,e),Go=n(e),Yt=a(e,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-109saxj"&&(Yt.innerHTML=sa),Jo=n(e),Xt=a(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-1w3mw7o"&&(Xt.innerHTML=oa),Do=n(e),f(zt.$$.fragment,e),Wo=n(e),Et=a(e,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-1df4miy"&&(Et.innerHTML=na),Zo=n(e),Bt=a(e,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-12n8jzj"&&(Bt.textContent=la),Fo=n(e),Ot=a(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-kna9l3"&&(Ot.innerHTML=aa),So=n(e),f(Vt.$$.fragment,e),No=n(e),Qt=a(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-6tihfz"&&(Qt.innerHTML=ra),Yo=n(e),f(Kt.$$.fragment,e),Xo=n(e),f(ei.$$.fragment,e),zo=n(e),ti=a(e,"P",{"data-svelte-h":!0}),r(ti)!=="svelte-ciarbw"&&(ti.textContent=ua),Eo=n(e),ii=a(e,"OL",{"data-svelte-h":!0}),r(ii)!=="svelte-ff502d"&&(ii.innerHTML=fa),Bo=n(e),f(si.$$.fragment,e),Oo=n(e),f(oi.$$.fragment,e),Vo=n(e),ni=a(e,"P",{"data-svelte-h":!0}),r(ni)!=="svelte-sp7ck8"&&(ni.innerHTML=ha),Qo=n(e),mi=a(e,"P",{}),li(mi).forEach(i),this.h()},h(){ai(b,"name","hf:doc:metadata"),ai(b,"content",va),ai(v,"start","2"),ai(x,"start","10"),ai(Ct,"start","4"),ai($,"start","5"),ai(T,"start","6")},m(e,t){y(document.head,b),s(e,ci,t),s(e,di,t),s(e,gi,t),h(k,e,t),s(e,yi,t),s(e,M,t),s(e,wi,t),s(e,C,t),s(e,bi,t),s(e,H,t),s(e,vi,t),s(e,L,t),s(e,xi,t),h(P,e,t),s(e,$i,t),s(e,_,t),s(e,Ti,t),s(e,I,t),s(e,ki,t),s(e,q,t),s(e,Mi,t),s(e,R,t),s(e,Ci,t),s(e,A,t),s(e,Hi,t),h(j,e,t),s(e,Li,t),s(e,U,t),s(e,Pi,t),s(e,G,t),s(e,_i,t),s(e,J,t),s(e,Ii,t),s(e,D,t),s(e,qi,t),s(e,W,t),s(e,Ri,t),h(Z,e,t),s(e,Ai,t),s(e,F,t),s(e,ji,t),s(e,S,t),s(e,Ui,t),s(e,N,t),s(e,Gi,t),s(e,Y,t),s(e,Ji,t),s(e,X,t),s(e,Di,t),s(e,z,t),s(e,Wi,t),h(E,e,t),s(e,Zi,t),s(e,B,t),s(e,Fi,t),s(e,O,t),s(e,Si,t),s(e,V,t),s(e,Ni,t),s(e,Q,t),s(e,Yi,t),h(K,e,t),s(e,Xi,t),s(e,ee,t),s(e,zi,t),s(e,te,t),s(e,Ei,t),s(e,ie,t),s(e,Bi,t),s(e,v,t),s(e,Oi,t),s(e,se,t),s(e,Vi,t),h(oe,e,t),s(e,Qi,t),s(e,ne,t),s(e,Ki,t),s(e,le,t),s(e,es,t),h(ae,e,t),s(e,ts,t),s(e,re,t),s(e,is,t),s(e,ue,t),s(e,ss,t),h(fe,e,t),s(e,os,t),s(e,he,t),s(e,ns,t),s(e,pe,t),s(e,ls,t),s(e,de,t),s(e,as,t),s(e,me,t),s(e,rs,t),h(ce,e,t),s(e,us,t),s(e,ge,t),s(e,fs,t),s(e,ye,t),s(e,hs,t),s(e,we,t),s(e,ps,t),s(e,be,t),s(e,ds,t),s(e,ve,t),s(e,ms,t),h(xe,e,t),s(e,cs,t),s(e,$e,t),s(e,gs,t),s(e,Te,t),s(e,ys,t),h(ke,e,t),s(e,ws,t),s(e,Me,t),s(e,bs,t),s(e,Ce,t),s(e,vs,t),s(e,He,t),s(e,xs,t),s(e,Le,t),s(e,$s,t),s(e,Pe,t),s(e,Ts,t),h(_e,e,t),s(e,ks,t),s(e,Ie,t),s(e,Ms,t),s(e,qe,t),s(e,Cs,t),s(e,Re,t),s(e,Hs,t),s(e,Ae,t),s(e,Ls,t),s(e,je,t),s(e,Ps,t),s(e,Ue,t),s(e,_s,t),s(e,Ge,t),s(e,Is,t),s(e,Je,t),s(e,qs,t),s(e,De,t),s(e,Rs,t),h(We,e,t),s(e,As,t),s(e,Ze,t),s(e,js,t),s(e,Fe,t),s(e,Us,t),s(e,Se,t),s(e,Gs,t),s(e,Ne,t),s(e,Js,t),s(e,Ye,t),s(e,Ds,t),h(Xe,e,t),s(e,Ws,t),s(e,ze,t),s(e,Zs,t),h(Ee,e,t),s(e,Fs,t),s(e,Be,t),s(e,Ss,t),s(e,Oe,t),s(e,Ns,t),s(e,Ve,t),s(e,Ys,t),s(e,Qe,t),s(e,Xs,t),s(e,Ke,t),s(e,zs,t),s(e,et,t),s(e,Es,t),h(tt,e,t),s(e,Bs,t),s(e,it,t),s(e,Os,t),h(st,e,t),s(e,Vs,t),s(e,ot,t),s(e,Qs,t),s(e,nt,t),s(e,Ks,t),s(e,lt,t),s(e,eo,t),s(e,at,t),s(e,to,t),s(e,rt,t),s(e,io,t),s(e,ut,t),s(e,so,t),s(e,ft,t),s(e,oo,t),h(ht,e,t),s(e,no,t),s(e,pt,t),s(e,lo,t),s(e,dt,t),s(e,ao,t),h(mt,e,t),s(e,ro,t),s(e,ct,t),s(e,uo,t),s(e,gt,t),s(e,fo,t),s(e,x,t),s(e,ho,t),h(yt,e,t),s(e,po,t),s(e,wt,t),s(e,mo,t),s(e,bt,t),s(e,co,t),s(e,vt,t),s(e,go,t),s(e,w,t),y(w,ri),y(w,on),y(w,xt),y(xt,ui),y(xt,nn),h($t,xt,null),y(w,ln),y(w,Tt),y(Tt,fi),y(Tt,an),h(kt,Tt,null),s(e,yo,t),s(e,Mt,t),s(e,wo,t),s(e,Ct,t),y(Ct,Ht),y(Ht,hi),y(Ht,rn),h(Lt,Ht,null),s(e,bo,t),s(e,Pt,t),s(e,vo,t),s(e,$,t),s(e,xo,t),s(e,_t,t),s(e,$o,t),h(It,e,t),s(e,To,t),s(e,qt,t),s(e,ko,t),h(Rt,e,t),s(e,Mo,t),s(e,At,t),s(e,Co,t),h(jt,e,t),s(e,Ho,t),s(e,Ut,t),s(e,Lo,t),h(Gt,e,t),s(e,Po,t),s(e,Jt,t),s(e,_o,t),h(Dt,e,t),s(e,Io,t),s(e,Wt,t),s(e,qo,t),h(Zt,e,t),s(e,Ro,t),s(e,Ft,t),s(e,Ao,t),h(St,e,t),s(e,jo,t),s(e,T,t),s(e,Uo,t),h(Nt,e,t),s(e,Go,t),s(e,Yt,t),s(e,Jo,t),s(e,Xt,t),s(e,Do,t),h(zt,e,t),s(e,Wo,t),s(e,Et,t),s(e,Zo,t),s(e,Bt,t),s(e,Fo,t),s(e,Ot,t),s(e,So,t),h(Vt,e,t),s(e,No,t),s(e,Qt,t),s(e,Yo,t),h(Kt,e,t),s(e,Xo,t),h(ei,e,t),s(e,zo,t),s(e,ti,t),s(e,Eo,t),s(e,ii,t),s(e,Bo,t),h(si,e,t),s(e,Oo,t),h(oi,e,t),s(e,Vo,t),s(e,ni,t),s(e,Qo,t),s(e,mi,t),Ko=!0},p:ma,i(e){Ko||(p(k.$$.fragment,e),p(P.$$.fragment,e),p(j.$$.fragment,e),p(Z.$$.fragment,e),p(E.$$.fragment,e),p(K.$$.fragment,e),p(oe.$$.fragment,e),p(ae.$$.fragment,e),p(fe.$$.fragment,e),p(ce.$$.fragment,e),p(xe.$$.fragment,e),p(ke.$$.fragment,e),p(_e.$$.fragment,e),p(We.$$.fragment,e),p(Xe.$$.fragment,e),p(Ee.$$.fragment,e),p(tt.$$.fragment,e),p(st.$$.fragment,e),p(ht.$$.fragment,e),p(mt.$$.fragment,e),p(yt.$$.fragment,e),p($t.$$.fragment,e),p(kt.$$.fragment,e),p(Lt.$$.fragment,e),p(It.$$.fragment,e),p(Rt.$$.fragment,e),p(jt.$$.fragment,e),p(Gt.$$.fragment,e),p(Dt.$$.fragment,e),p(Zt.$$.fragment,e),p(St.$$.fragment,e),p(Nt.$$.fragment,e),p(zt.$$.fragment,e),p(Vt.$$.fragment,e),p(Kt.$$.fragment,e),p(ei.$$.fragment,e),p(si.$$.fragment,e),p(oi.$$.fragment,e),Ko=!0)},o(e){d(k.$$.fragment,e),d(P.$$.fragment,e),d(j.$$.fragment,e),d(Z.$$.fragment,e),d(E.$$.fragment,e),d(K.$$.fragment,e),d(oe.$$.fragment,e),d(ae.$$.fragment,e),d(fe.$$.fragment,e),d(ce.$$.fragment,e),d(xe.$$.fragment,e),d(ke.$$.fragment,e),d(_e.$$.fragment,e),d(We.$$.fragment,e),d(Xe.$$.fragment,e),d(Ee.$$.fragment,e),d(tt.$$.fragment,e),d(st.$$.fragment,e),d(ht.$$.fragment,e),d(mt.$$.fragment,e),d(yt.$$.fragment,e),d($t.$$.fragment,e),d(kt.$$.fragment,e),d(Lt.$$.fragment,e),d(It.$$.fragment,e),d(Rt.$$.fragment,e),d(jt.$$.fragment,e),d(Gt.$$.fragment,e),d(Dt.$$.fragment,e),d(Zt.$$.fragment,e),d(St.$$.fragment,e),d(Nt.$$.fragment,e),d(zt.$$.fragment,e),d(Vt.$$.fragment,e),d(Kt.$$.fragment,e),d(ei.$$.fragment,e),d(si.$$.fragment,e),d(oi.$$.fragment,e),Ko=!1},d(e){e&&(i(ci),i(di),i(gi),i(yi),i(M),i(wi),i(C),i(bi),i(H),i(vi),i(L),i(xi),i($i),i(_),i(Ti),i(I),i(ki),i(q),i(Mi),i(R),i(Ci),i(A),i(Hi),i(Li),i(U),i(Pi),i(G),i(_i),i(J),i(Ii),i(D),i(qi),i(W),i(Ri),i(Ai),i(F),i(ji),i(S),i(Ui),i(N),i(Gi),i(Y),i(Ji),i(X),i(Di),i(z),i(Wi),i(Zi),i(B),i(Fi),i(O),i(Si),i(V),i(Ni),i(Q),i(Yi),i(Xi),i(ee),i(zi),i(te),i(Ei),i(ie),i(Bi),i(v),i(Oi),i(se),i(Vi),i(Qi),i(ne),i(Ki),i(le),i(es),i(ts),i(re),i(is),i(ue),i(ss),i(os),i(he),i(ns),i(pe),i(ls),i(de),i(as),i(me),i(rs),i(us),i(ge),i(fs),i(ye),i(hs),i(we),i(ps),i(be),i(ds),i(ve),i(ms),i(cs),i($e),i(gs),i(Te),i(ys),i(ws),i(Me),i(bs),i(Ce),i(vs),i(He),i(xs),i(Le),i($s),i(Pe),i(Ts),i(ks),i(Ie),i(Ms),i(qe),i(Cs),i(Re),i(Hs),i(Ae),i(Ls),i(je),i(Ps),i(Ue),i(_s),i(Ge),i(Is),i(Je),i(qs),i(De),i(Rs),i(As),i(Ze),i(js),i(Fe),i(Us),i(Se),i(Gs),i(Ne),i(Js),i(Ye),i(Ds),i(Ws),i(ze),i(Zs),i(Fs),i(Be),i(Ss),i(Oe),i(Ns),i(Ve),i(Ys),i(Qe),i(Xs),i(Ke),i(zs),i(et),i(Es),i(Bs),i(it),i(Os),i(Vs),i(ot),i(Qs),i(nt),i(Ks),i(lt),i(eo),i(at),i(to),i(rt),i(io),i(ut),i(so),i(ft),i(oo),i(no),i(pt),i(lo),i(dt),i(ao),i(ro),i(ct),i(uo),i(gt),i(fo),i(x),i(ho),i(po),i(wt),i(mo),i(bt),i(co),i(vt),i(go),i(w),i(yo),i(Mt),i(wo),i(Ct),i(bo),i(Pt),i(vo),i($),i(xo),i(_t),i($o),i(To),i(qt),i(ko),i(Mo),i(At),i(Co),i(Ho),i(Ut),i(Lo),i(Po),i(Jt),i(_o),i(Io),i(Wt),i(qo),i(Ro),i(Ft),i(Ao),i(jo),i(T),i(Uo),i(Go),i(Yt),i(Jo),i(Xt),i(Do),i(Wo),i(Et),i(Zo),i(Bt),i(Fo),i(Ot),i(So),i(No),i(Qt),i(Yo),i(Xo),i(zo),i(ti),i(Eo),i(ii),i(Bo),i(Oo),i(Vo),i(ni),i(Qo),i(mi)),i(b),m(k,e),m(P,e),m(j,e),m(Z,e),m(E,e),m(K,e),m(oe,e),m(ae,e),m(fe,e),m(ce,e),m(xe,e),m(ke,e),m(_e,e),m(We,e),m(Xe,e),m(Ee,e),m(tt,e),m(st,e),m(ht,e),m(mt,e),m(yt,e),m($t),m(kt),m(Lt),m(It,e),m(Rt,e),m(jt,e),m(Gt,e),m(Dt,e),m(Zt,e),m(St,e),m(Nt,e),m(zt,e),m(Vt,e),m(Kt,e),m(ei,e),m(si,e),m(oi,e)}}}const va='{"title":"How to contribute to Diffusers 🧨","local":"how-to-contribute-to-diffusers-","sections":[{"title":"Overview","local":"overview","sections":[{"title":"1. Asking and answering questions on the Diffusers discussion forum or on the Diffusers Discord","local":"1-asking-and-answering-questions-on-the-diffusers-discussion-forum-or-on-the-diffusers-discord","sections":[],"depth":3},{"title":"2. Opening new issues on the GitHub issues tab","local":"2-opening-new-issues-on-the-github-issues-tab","sections":[{"title":"2.1. Reproducible, minimal bug reports.","local":"21-reproducible-minimal-bug-reports","sections":[],"depth":4},{"title":"2.2. Feature requests.","local":"22-feature-requests","sections":[],"depth":4},{"title":"2.3 Feedback.","local":"23-feedback","sections":[],"depth":4},{"title":"2.4 Technical questions.","local":"24-technical-questions","sections":[],"depth":4},{"title":"2.5 Proposal to add a new model, scheduler, or pipeline.","local":"25-proposal-to-add-a-new-model-scheduler-or-pipeline","sections":[],"depth":4}],"depth":3},{"title":"3. Answering issues on the GitHub issues tab","local":"3-answering-issues-on-the-github-issues-tab","sections":[],"depth":3},{"title":"4. Fixing a Good first issue","local":"4-fixing-a-good-first-issue","sections":[],"depth":3},{"title":"5. Contribute to the documentation","local":"5-contribute-to-the-documentation","sections":[],"depth":3},{"title":"6. Contribute a community pipeline","local":"6-contribute-a-community-pipeline","sections":[],"depth":3},{"title":"7. Contribute to training examples","local":"7-contribute-to-training-examples","sections":[],"depth":3},{"title":"8. Fixing a Good second issue","local":"8-fixing-a-good-second-issue","sections":[],"depth":3},{"title":"9. Adding pipelines, models, schedulers","local":"9-adding-pipelines-models-schedulers","sections":[],"depth":3}],"depth":2},{"title":"How to write a good issue","local":"how-to-write-a-good-issue","sections":[],"depth":2},{"title":"How to write a good PR","local":"how-to-write-a-good-pr","sections":[],"depth":2},{"title":"How to open a PR","local":"how-to-open-a-pr","sections":[{"title":"Tests","local":"tests","sections":[],"depth":3},{"title":"Syncing forked main with upstream (HuggingFace) main","local":"syncing-forked-main-with-upstream-huggingface-main","sections":[],"depth":3},{"title":"Style guide","local":"style-guide","sections":[],"depth":3}],"depth":2}],"depth":1}';function xa(un){return ca(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ca extends ga{constructor(b){super(),ya(this,b,xa,ba,da,{})}}export{Ca as component};
