import{s as Xs,o as Rs,n as sl}from"../chunks/scheduler.69131cc3.js";import{S as Ns,i as Vs,g as M,s as a,r as c,A as xs,h as i,f as t,c as n,j as As,u as m,x as r,k as Ys,y as Fs,a as s,v as y,d as w,t as J,w as T}from"../chunks/index.e1f30d73.js";import{T as ll}from"../chunks/Tip.22e79575.js";import{C as h}from"../chunks/CodeBlock.30cef355.js";import{H as tl}from"../chunks/Heading.0aab6758.js";function Qs(d){let p,U='This tutorial is also available as a Jupyter Notebook <a href="https://github.com/huggingface/notebooks/blob/main/examples/accelerate_examples/simple_cv_example.ipynb" rel="nofollow">here</a>';return{c(){p=M("p"),p.innerHTML=U},l(o){p=i(o,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1tjynav"&&(p.innerHTML=U)},m(o,j){s(o,p,j)},p:sl,d(o){o&&t(p)}}}function zs(d){let p,U="CUDA can’t be initialized more than once on a multi-GPU system. It’s fine to debug in the notebook and have calls to CUDA, but in order to finally train a full cleanup and restart will need to be performed.";return{c(){p=M("p"),p.textContent=U},l(o){p=i(o,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1cflfr7"&&(p.textContent=U)},m(o,j){s(o,p,j)},p:sl,d(o){o&&t(p)}}}function Ss(d){let p,U="The code has been split up to allow for explainations on each section. A full version that can be copy and pasted will be available at the end";return{c(){p=M("p"),p.textContent=U},l(o){p=i(o,"P",{"data-svelte-h":!0}),r(p)!=="svelte-xpfxn6"&&(p.textContent=U)},m(o,j){s(o,p,j)},p:sl,d(o){o&&t(p)}}}function Es(d){let p,U=`If training on the TPU, your training loop should take in the model as a parameter and it should be instantiated
outside of the training loop function. See the <a href="../concept_guides/training_tpu">TPU best practices</a>
to learn why`;return{c(){p=M("p"),p.innerHTML=U},l(o){p=i(o,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1aol2se"&&(p.innerHTML=U)},m(o,j){s(o,p,j)},p:sl,d(o){o&&t(p)}}}function Hs(d){let p,U="You build the model here so that the seed also controls the new weight initialization";return{c(){p=M("p"),p.textContent=U},l(o){p=i(o,"P",{"data-svelte-h":!0}),r(p)!=="svelte-j432sg"&&(p.textContent=U)},m(o,j){s(o,p,j)},p:sl,d(o){o&&t(p)}}}function Ls(d){let p,U="There is no specific order to remember, you just need to unpack the objects in the same order you gave them to the prepare method.";return{c(){p=M("p"),p.textContent=U},l(o){p=i(o,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1y658j6"&&(p.textContent=U)},m(o,j){s(o,p,j)},p:sl,d(o){o&&t(p)}}}function Ds(d){let p,U="Notice how the <code>node_rank</code> has changed";return{c(){p=M("p"),p.innerHTML=U},l(o){p=i(o,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1dj1i7x"&&(p.innerHTML=U)},m(o,j){s(o,p,j)},p:sl,d(o){o&&t(p)}}}function qs(d){let p,U,o,j,G,nl,_,Vt=`This tutorial teaches you how to fine tune a computer vision model with 🤗 Accelerate from a Jupyter Notebook on a distributed system.
You will also learn how to setup a few requirements needed for ensuring your environment is configured properly, your data has been prepared properly, and finally how to launch training.`,pl,u,Ml,W,il,g,xt="Before any training can be performed, a 🤗 Accelerate config file must exist in the system. Usually this can be done by running the following in a terminal and answering the prompts:",rl,k,ol,B,Ft='However, if general defaults are fine and you are <em>not</em> running on a TPU, 🤗Accelerate has a utility to quickly write your GPU configuration into a config file via <a href="/docs/accelerate/v0.26.0/en/package_reference/utilities#accelerate.commands.config.default.write_basic_config">utils.write_basic_config()</a>.',cl,v,Qt="The following code will restart Jupyter after writing the configuration, as CUDA code was called to perform this.",ml,I,yl,A,wl,Y,Jl,X,zt="Next you should prepare your dataset. As mentioned at earlier, great care should be taken when preparing the <code>DataLoaders</code> and model to make sure that <strong>nothing</strong> is put on <em>any</em> GPU.",Tl,R,St="If you do, it is recommended to put that specific code into a function and call that from within the notebook launcher interface, which will be shown later.",hl,N,Et='Make sure the dataset is downloaded based on the directions <a href="https://github.com/huggingface/accelerate/tree/main/examples#simple-vision-example" rel="nofollow">here</a>',Ul,V,jl,x,Ht="First you need to create a function to extract the class name based on a filename:",dl,F,ul,Q,Il,z,Lt="In the case here, the label is <code>beagle</code>. Using regex you can extract the label from the filename:",bl,S,fl,E,Cl,H,Dt="And you can see it properly returned the right name for our file:",Zl,L,$l,D,qt="Next a <code>Dataset</code> class should be made to handle grabbing the image and the label:",Gl,q,_l,P,Pt=`Now to build the dataset. Outside the training function you can find and declare all the filenames and labels and use them as references inside the
launched function:`,Wl,K,gl,O,Kt="Next gather all the labels:",kl,ee,Bl,le,Ot=`Next, you should make a <code>get_dataloaders</code> function that will return your built dataloaders for you. As mentioned earlier, if data is automatically
sent to the GPU or a TPU device when building your <code>DataLoaders</code>, they must be built using this method.`,vl,te,Al,se,es="Finally, you should import the scheduler to be used later:",Yl,ae,Xl,ne,Rl,pe,ls='Now you can build the training loop. <a href="/docs/accelerate/v0.26.0/en/package_reference/launchers#accelerate.notebook_launcher">notebook_launcher()</a> works by passing in a function to call that will be ran across the distributed system.',Nl,Me,ts="Here is a basic training loop for the animal classification problem:",Vl,b,xl,ie,Fl,re,ss='First you should set the seed and create an <a href="/docs/accelerate/v0.26.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> object as early in the training loop as possible.',Ql,f,zl,oe,as="Next you should build your dataloaders and create your model:",Sl,ce,El,C,Hl,me,ns=`As you are performing transfer learning in this example, the encoder of the model starts out frozen so the head of the model can be
trained only initially:`,Ll,ye,Dl,we,ps="Normalizing the batches of images will make training a little faster:",ql,Je,Pl,Te,Ms="To make these constants available on the active device, you should set it to the Accelerator’s device:",Kl,he,Ol,Ue,is="Next instantiate the rest of the PyTorch classes used for training:",et,je,lt,de,rs='Before passing everything to <a href="/docs/accelerate/v0.26.0/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a>.',tt,Z,st,ue,at,Ie,os="Now train the model:",nt,be,pt,fe,cs=`The evaluation loop will look slightly different compared to the training loop. The number of elements passed as well as the overall
total accuracy of each batch will be added to two constants:`,Mt,Ce,it,Ze,ms="Next you have the rest of your standard PyTorch loop:",rt,$e,ot,Ge,ys="Before finally the last major difference.",ct,_e,ws=`When performing distributed evaluation, the predictions and labels need to be passed through
<a href="/docs/accelerate/v0.26.0/en/package_reference/accelerator#accelerate.Accelerator.gather">gather()</a> so that all of the data is available on the current device and a properly calculated metric can be achieved:`,mt,We,yt,ge,Js='Now you just need to calculate the actual metric for this problem, and you can print it on the main process using <a href="/docs/accelerate/v0.26.0/en/package_reference/accelerator#accelerate.Accelerator.print">print()</a>:',wt,ke,Jt,Be,Ts="A full version of this training loop is available below:",Tt,ve,ht,Ae,Ut,Ye,hs='All that’s left is to use the <a href="/docs/accelerate/v0.26.0/en/package_reference/launchers#accelerate.notebook_launcher">notebook_launcher()</a>.',jt,Xe,Us='You pass in the function, the arguments (as a tuple), and the number of processes to train on. (See the <a href="../package_reference/launchers">documentation</a> for more information)',dt,Re,ut,Ne,It,Ve,js="In the case of running on multiple nodes, you need to set up a Jupyter session at each node and run the launching cell at the same time.",bt,xe,ds="For an environment containing 2 nodes (computers) with 8 GPUs each and the main computer with an IP address of “172.31.43.8”, it would look like so:",ft,Fe,Ct,Qe,us="And in the second Jupyter session on the other machine:",Zt,$,$t,ze,Gt,Se,Is="In the case of running on the TPU, it would look like so:",_t,Ee,Wt,He,bs="As it’s running it will print the progress as well as state how many devices you ran on. This tutorial was ran with two GPUs:",gt,Le,kt,De,fs="And that’s it!",Bt,qe,vt,Pe,Cs=`A common issue when running the <code>notebook_launcher</code> is receiving a CUDA has already been initialized issue. This usually stems
from an import or prior code in the notebook that makes a call to the PyTorch <code>torch.cuda</code> sublibrary. To help narrow down what went wrong,
you can launch the <code>notebook_launcher</code> with <code>ACCELERATE_DEBUG_MODE=yes</code> in your environment and an additional check
will be made when spawning that a regular process can be created and utilize CUDA without issue. (Your CUDA code can still be ran afterwards).`,At,Ke,Yt,Oe,Zs="This notebook showed how to perform distributed training from inside of a Jupyter Notebook. Some key notes to remember:",Xt,el,$s='<li>Make sure to save any code that use CUDA (or CUDA imports) for the function passed to <a href="/docs/accelerate/v0.26.0/en/package_reference/launchers#accelerate.notebook_launcher">notebook_launcher()</a></li> <li>Set the <code>num_processes</code> to be the number of devices used for training (such as number of GPUs, CPUs, TPUs, etc)</li> <li>If using the TPU, declare your model outside the training loop function</li>',Rt,al,Nt;return G=new tl({props:{title:"Launching Multi-GPU Training from a Jupyter Environment",local:"launching-multi-gpu-training-from-a-jupyter-environment",headingTag:"h1"}}),u=new ll({props:{$$slots:{default:[Qs]},$$scope:{ctx:d}}}),W=new tl({props:{title:"Configuring the Environment",local:"configuring-the-environment",headingTag:"h2"}}),k=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),I=new ll({props:{warning:!0,$$slots:{default:[zs]},$$scope:{ctx:d}}}),A=new h({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMHdyaXRlX2Jhc2ljX2NvbmZpZyUwQSUwQXdyaXRlX2Jhc2ljX2NvbmZpZygpJTIwJTIwJTIzJTIwV3JpdGUlMjBhJTIwY29uZmlnJTIwZmlsZSUwQW9zLl9leGl0KDAwKSUyMCUyMCUyMyUyMFJlc3RhcnQlMjB0aGUlMjBub3RlYm9vaw==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()  <span class="hljs-comment"># Write a config file</span>
os._exit(<span class="hljs-number">00</span>)  <span class="hljs-comment"># Restart the notebook</span>`,wrap:!1}}),Y=new tl({props:{title:"Preparing the Dataset and Model",local:"preparing-the-dataset-and-model",headingTag:"h2"}}),V=new h({props:{code:"aW1wb3J0JTIwb3MlMkMlMjByZSUyQyUyMHRvcmNoJTJDJTIwUElMJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZnJvbSUyMHRvcmNoLm9wdGltLmxyX3NjaGVkdWxlciUyMGltcG9ydCUyME9uZUN5Y2xlTFIlMEFmcm9tJTIwdG9yY2gudXRpbHMuZGF0YSUyMGltcG9ydCUyMERhdGFMb2FkZXIlMkMlMjBEYXRhc2V0JTBBZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBDb21wb3NlJTJDJTIwUmFuZG9tUmVzaXplZENyb3AlMkMlMjBSZXNpemUlMkMlMjBUb1RlbnNvciUwQSUwQWZyb20lMjBhY2NlbGVyYXRlJTIwaW1wb3J0JTIwQWNjZWxlcmF0b3IlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMHNldF9zZWVkJTBBZnJvbSUyMHRpbW0lMjBpbXBvcnQlMjBjcmVhdGVfbW9kZWw=",highlighted:`<span class="hljs-keyword">import</span> os, re, torch, PIL
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> torch.optim.lr_scheduler <span class="hljs-keyword">import</span> OneCycleLR
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader, Dataset
<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> Compose, RandomResizedCrop, Resize, ToTensor

<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> set_seed
<span class="hljs-keyword">from</span> timm <span class="hljs-keyword">import</span> create_model`,wrap:!1}}),F=new h({props:{code:"aW1wb3J0JTIwb3MlMEElMEFkYXRhX2RpciUyMCUzRCUyMCUyMi4uJTJGLi4lMkZpbWFnZXMlMjIlMEFmbmFtZXMlMjAlM0QlMjBvcy5saXN0ZGlyKGRhdGFfZGlyKSUwQWZuYW1lJTIwJTNEJTIwZm5hbWVzJTVCMCU1RCUwQXByaW50KGZuYW1lKQ==",highlighted:`<span class="hljs-keyword">import</span> os

data_dir = <span class="hljs-string">&quot;../../images&quot;</span>
fnames = os.listdir(data_dir)
fname = fnames[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(fname)`,wrap:!1}}),Q=new h({props:{code:"YmVhZ2xlXzMyLmpwZw==",highlighted:"beagle_32.jpg",wrap:!1}}),S=new h({props:{code:"aW1wb3J0JTIwcmUlMEElMEElMEFkZWYlMjBleHRyYWN0X2xhYmVsKGZuYW1lKSUzQSUwQSUyMCUyMCUyMCUyMHN0ZW0lMjAlM0QlMjBmbmFtZS5zcGxpdChvcy5wYXRoLnNlcCklNUItMSU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlLnNlYXJjaChyJTIyJTVFKC4qKV8lNUNkJTJCJTVDLmpwZyUyNCUyMiUyQyUyMHN0ZW0pLmdyb3VwcygpJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> re


<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_label</span>(<span class="hljs-params">fname</span>):
    stem = fname.split(os.path.sep)[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">return</span> re.search(<span class="hljs-string">r&quot;^(.*)_\\d+\\.jpg$&quot;</span>, stem).groups()[<span class="hljs-number">0</span>]`,wrap:!1}}),E=new h({props:{code:"ZXh0cmFjdF9sYWJlbChmbmFtZSk=",highlighted:"extract_label(fname)",wrap:!1}}),L=new h({props:{code:"JTIyYmVhZ2xlJTIy",highlighted:'<span class="hljs-string">&quot;beagle&quot;</span>',wrap:!1}}),q=new h({props:{code:"Y2xhc3MlMjBQZXRzRGF0YXNldChEYXRhc2V0KSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBmaWxlX25hbWVzJTJDJTIwaW1hZ2VfdHJhbnNmb3JtJTNETm9uZSUyQyUyMGxhYmVsX3RvX2lkJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZpbGVfbmFtZXMlMjAlM0QlMjBmaWxlX25hbWVzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5pbWFnZV90cmFuc2Zvcm0lMjAlM0QlMjBpbWFnZV90cmFuc2Zvcm0lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmxhYmVsX3RvX2lkJTIwJTNEJTIwbGFiZWxfdG9faWQlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2xlbl9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbGVuKHNlbGYuZmlsZV9uYW1lcyklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2dldGl0ZW1fXyhzZWxmJTJDJTIwaWR4KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZuYW1lJTIwJTNEJTIwc2VsZi5maWxlX25hbWVzJTVCaWR4JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmF3X2ltYWdlJTIwJTNEJTIwUElMLkltYWdlLm9wZW4oZm5hbWUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjByYXdfaW1hZ2UuY29udmVydCglMjJSR0IlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLmltYWdlX3RyYW5zZm9ybSUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwc2VsZi5pbWFnZV90cmFuc2Zvcm0oaW1hZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWwlMjAlM0QlMjBleHRyYWN0X2xhYmVsKGZuYW1lKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc2VsZi5sYWJlbF90b19pZCUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhYmVsJTIwJTNEJTIwc2VsZi5sYWJlbF90b19pZCU1QmxhYmVsJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyaW1hZ2UlMjIlM0ElMjBpbWFnZSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwbGFiZWwlN0Q=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PetsDataset</span>(<span class="hljs-title class_ inherited__">Dataset</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, file_names, image_transform=<span class="hljs-literal">None</span>, label_to_id=<span class="hljs-literal">None</span></span>):
        self.file_names = file_names
        self.image_transform = image_transform
        self.label_to_id = label_to_id

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__len__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">len</span>(self.file_names)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__getitem__</span>(<span class="hljs-params">self, idx</span>):
        fname = self.file_names[idx]
        raw_image = PIL.Image.<span class="hljs-built_in">open</span>(fname)
        image = raw_image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)
        <span class="hljs-keyword">if</span> self.image_transform <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            image = self.image_transform(image)
        label = extract_label(fname)
        <span class="hljs-keyword">if</span> self.label_to_id <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            label = self.label_to_id[label]
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;image&quot;</span>: image, <span class="hljs-string">&quot;label&quot;</span>: label}`,wrap:!1}}),K=new h({props:{code:"Zm5hbWVzJTIwJTNEJTIwJTVCb3MucGF0aC5qb2luKCUyMi4uJTJGLi4lMkZpbWFnZXMlMjIlMkMlMjBmbmFtZSklMjBmb3IlMjBmbmFtZSUyMGluJTIwZm5hbWVzJTIwaWYlMjBmbmFtZS5lbmRzd2l0aCglMjIuanBnJTIyKSU1RA==",highlighted:'fnames = [os.path.join(<span class="hljs-string">&quot;../../images&quot;</span>, fname) <span class="hljs-keyword">for</span> fname <span class="hljs-keyword">in</span> fnames <span class="hljs-keyword">if</span> fname.endswith(<span class="hljs-string">&quot;.jpg&quot;</span>)]',wrap:!1}}),ee=new h({props:{code:"YWxsX2xhYmVscyUyMCUzRCUyMCU1QmV4dHJhY3RfbGFiZWwoZm5hbWUpJTIwZm9yJTIwZm5hbWUlMjBpbiUyMGZuYW1lcyU1RCUwQWlkX3RvX2xhYmVsJTIwJTNEJTIwbGlzdChzZXQoYWxsX2xhYmVscykpJTBBaWRfdG9fbGFiZWwuc29ydCgpJTBBbGFiZWxfdG9faWQlMjAlM0QlMjAlN0JsYmwlM0ElMjBpJTIwZm9yJTIwaSUyQyUyMGxibCUyMGluJTIwZW51bWVyYXRlKGlkX3RvX2xhYmVsKSU3RA==",highlighted:`all_labels = [extract_label(fname) <span class="hljs-keyword">for</span> fname <span class="hljs-keyword">in</span> fnames]
id_to_label = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_labels))
id_to_label.sort()
label_to_id = {lbl: i <span class="hljs-keyword">for</span> i, lbl <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(id_to_label)}`,wrap:!1}}),te=new h({props:{code:"ZGVmJTIwZ2V0X2RhdGFsb2FkZXJzKGJhdGNoX3NpemUlM0ElMjBpbnQlMjAlM0QlMjA2NCklM0ElMEElMjAlMjAlMjAlMjAlMjJCdWlsZHMlMjBhJTIwc2V0JTIwb2YlMjBkYXRhbG9hZGVycyUyMHdpdGglMjBhJTIwYmF0Y2hfc2l6ZSUyMiUwQSUyMCUyMCUyMCUyMHJhbmRvbV9wZXJtJTIwJTNEJTIwbnAucmFuZG9tLnBlcm11dGF0aW9uKGxlbihmbmFtZXMpKSUwQSUyMCUyMCUyMCUyMGN1dCUyMCUzRCUyMGludCgwLjglMjAqJTIwbGVuKGZuYW1lcykpJTBBJTIwJTIwJTIwJTIwdHJhaW5fc3BsaXQlMjAlM0QlMjByYW5kb21fcGVybSU1QiUzQWN1dCU1RCUwQSUyMCUyMCUyMCUyMGV2YWxfc3BsaXQlMjAlM0QlMjByYW5kb21fcGVybSU1QmN1dCUzQSU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEZvciUyMHRyYWluaW5nJTIwYSUyMHNpbXBsZSUyMFJhbmRvbVJlc2l6ZWRDcm9wJTIwd2lsbCUyMGJlJTIwdXNlZCUwQSUyMCUyMCUyMCUyMHRyYWluX3RmbSUyMCUzRCUyMENvbXBvc2UoJTVCUmFuZG9tUmVzaXplZENyb3AoKDIyNCUyQyUyMDIyNCklMkMlMjBzY2FsZSUzRCgwLjUlMkMlMjAxLjApKSUyQyUyMFRvVGVuc29yKCklNUQpJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUyMCUzRCUyMFBldHNEYXRhc2V0KCU1QmZuYW1lcyU1QmklNUQlMjBmb3IlMjBpJTIwaW4lMjB0cmFpbl9zcGxpdCU1RCUyQyUyMGltYWdlX3RyYW5zZm9ybSUzRHRyYWluX3RmbSUyQyUyMGxhYmVsX3RvX2lkJTNEbGFiZWxfdG9faWQpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRm9yJTIwZXZhbHVhdGlvbiUyMGElMjBkZXRlcm1pbmlzdGljJTIwUmVzaXplJTIwd2lsbCUyMGJlJTIwdXNlZCUwQSUyMCUyMCUyMCUyMGV2YWxfdGZtJTIwJTNEJTIwQ29tcG9zZSglNUJSZXNpemUoKDIyNCUyQyUyMDIyNCkpJTJDJTIwVG9UZW5zb3IoKSU1RCklMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlMjAlM0QlMjBQZXRzRGF0YXNldCglNUJmbmFtZXMlNUJpJTVEJTIwZm9yJTIwaSUyMGluJTIwZXZhbF9zcGxpdCU1RCUyQyUyMGltYWdlX3RyYW5zZm9ybSUzRGV2YWxfdGZtJTJDJTIwbGFiZWxfdG9faWQlM0RsYWJlbF90b19pZCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBJbnN0YW50aWF0ZSUyMGRhdGFsb2FkZXJzJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIodHJhaW5fZGF0YXNldCUyQyUyMHNodWZmbGUlM0RUcnVlJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMjBudW1fd29ya2VycyUzRDQpJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihldmFsX2RhdGFzZXQlMkMlMjBzaHVmZmxlJTNERmFsc2UlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyMColMjAyJTJDJTIwbnVtX3dvcmtlcnMlM0Q0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBldmFsX2RhdGFsb2FkZXI=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_dataloaders</span>(<span class="hljs-params">batch_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span></span>):
    <span class="hljs-string">&quot;Builds a set of dataloaders with a batch_size&quot;</span>
    random_perm = np.random.permutation(<span class="hljs-built_in">len</span>(fnames))
    cut = <span class="hljs-built_in">int</span>(<span class="hljs-number">0.8</span> * <span class="hljs-built_in">len</span>(fnames))
    train_split = random_perm[:cut]
    eval_split = random_perm[cut:]

    <span class="hljs-comment"># For training a simple RandomResizedCrop will be used</span>
    train_tfm = Compose([RandomResizedCrop((<span class="hljs-number">224</span>, <span class="hljs-number">224</span>), scale=(<span class="hljs-number">0.5</span>, <span class="hljs-number">1.0</span>)), ToTensor()])
    train_dataset = PetsDataset([fnames[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> train_split], image_transform=train_tfm, label_to_id=label_to_id)

    <span class="hljs-comment"># For evaluation a deterministic Resize will be used</span>
    eval_tfm = Compose([Resize((<span class="hljs-number">224</span>, <span class="hljs-number">224</span>)), ToTensor()])
    eval_dataset = PetsDataset([fnames[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> eval_split], image_transform=eval_tfm, label_to_id=label_to_id)

    <span class="hljs-comment"># Instantiate dataloaders</span>
    train_dataloader = DataLoader(train_dataset, shuffle=<span class="hljs-literal">True</span>, batch_size=batch_size, num_workers=<span class="hljs-number">4</span>)
    eval_dataloader = DataLoader(eval_dataset, shuffle=<span class="hljs-literal">False</span>, batch_size=batch_size * <span class="hljs-number">2</span>, num_workers=<span class="hljs-number">4</span>)
    <span class="hljs-keyword">return</span> train_dataloader, eval_dataloader`,wrap:!1}}),ae=new h({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltLmxyX3NjaGVkdWxlciUyMGltcG9ydCUyMENvc2luZUFubmVhbGluZ0xS",highlighted:'<span class="hljs-keyword">from</span> torch.optim.lr_scheduler <span class="hljs-keyword">import</span> CosineAnnealingLR',wrap:!1}}),ne=new tl({props:{title:"Writing the Training Function",local:"writing-the-training-function",headingTag:"h2"}}),b=new ll({props:{$$slots:{default:[Ss]},$$scope:{ctx:d}}}),ie=new h({props:{code:"ZGVmJTIwdHJhaW5pbmdfbG9vcChtaXhlZF9wcmVjaXNpb24lM0QlMjJmcDE2JTIyJTJDJTIwc2VlZCUzQSUyMGludCUyMCUzRCUyMDQyJTJDJTIwYmF0Y2hfc2l6ZSUzQSUyMGludCUyMCUzRCUyMDY0KSUzQSUwQSUyMCUyMCUyMCUyMHNldF9zZWVkKHNlZWQpJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihtaXhlZF9wcmVjaXNpb24lM0RtaXhlZF9wcmVjaXNpb24p",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">training_loop</span>(<span class="hljs-params">mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>, seed: <span class="hljs-built_in">int</span> = <span class="hljs-number">42</span>, batch_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span></span>):
    set_seed(seed)
    accelerator = Accelerator(mixed_precision=mixed_precision)`,wrap:!1}}),f=new ll({props:{warning:!0,$$slots:{default:[Es]},$$scope:{ctx:d}}}),ce=new h({props:{code:"JTIwJTIwJTIwJTIwdHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyMCUzRCUyMGdldF9kYXRhbG9hZGVycyhiYXRjaF9zaXplKSUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0RsZW4obGFiZWxfdG9faWQpKQ==",highlighted:`    train_dataloader, eval_dataloader = get_dataloaders(batch_size)
    model = create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-built_in">len</span>(label_to_id))`,wrap:!1}}),C=new ll({props:{$$slots:{default:[Hs]},$$scope:{ctx:d}}}),ye=new h({props:{code:"JTIwJTIwJTIwJTIwZm9yJTIwcGFyYW0lMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLnJlcXVpcmVzX2dyYWQlMjAlM0QlMjBGYWxzZSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhcmFtJTIwaW4lMjBtb2RlbC5nZXRfY2xhc3NpZmllcigpLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLnJlcXVpcmVzX2dyYWQlMjAlM0QlMjBUcnVl",highlighted:`    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
        param.requires_grad = <span class="hljs-literal">False</span>
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.get_classifier().parameters():
        param.requires_grad = <span class="hljs-literal">True</span>`,wrap:!1}}),Je=new h({props:{code:"JTIwJTIwJTIwJTIwbWVhbiUyMCUzRCUyMHRvcmNoLnRlbnNvcihtb2RlbC5kZWZhdWx0X2NmZyU1QiUyMm1lYW4lMjIlNUQpJTVCTm9uZSUyQyUyMCUzQSUyQyUyME5vbmUlMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwc3RkJTIwJTNEJTIwdG9yY2gudGVuc29yKG1vZGVsLmRlZmF1bHRfY2ZnJTVCJTIyc3RkJTIyJTVEKSU1Qk5vbmUlMkMlMjAlM0ElMkMlMjBOb25lJTJDJTIwTm9uZSU1RA==",highlighted:`    mean = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;mean&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]
    std = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;std&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]`,wrap:!1}}),he=new h({props:{code:"JTIwJTIwJTIwJTIwbWVhbiUyMCUzRCUyMG1lYW4udG8oYWNjZWxlcmF0b3IuZGV2aWNlKSUwQSUyMCUyMCUyMCUyMHN0ZCUyMCUzRCUyMHN0ZC50byhhY2NlbGVyYXRvci5kZXZpY2Up",highlighted:`    mean = mean.to(accelerator.device)
    std = std.to(accelerator.device)`,wrap:!1}}),je=new h({props:{code:"JTIwJTIwJTIwJTIwb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbShwYXJhbXMlM0Rtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTIlMjAlMkYlMjAyNSklMEElMjAlMjAlMjAlMjBscl9zY2hlZHVsZXIlMjAlM0QlMjBPbmVDeWNsZUxSKG9wdGltaXplciUzRG9wdGltaXplciUyQyUyMG1heF9sciUzRDNlLTIlMkMlMjBlcG9jaHMlM0Q1JTJDJTIwc3RlcHNfcGVyX2Vwb2NoJTNEbGVuKHRyYWluX2RhdGFsb2FkZXIpKQ==",highlighted:`    optimizer = torch.optim.Adam(params=model.parameters(), lr=<span class="hljs-number">3e-2</span> / <span class="hljs-number">25</span>)
    lr_scheduler = OneCycleLR(optimizer=optimizer, max_lr=<span class="hljs-number">3e-2</span>, epochs=<span class="hljs-number">5</span>, steps_per_epoch=<span class="hljs-built_in">len</span>(train_dataloader))`,wrap:!1}}),Z=new ll({props:{$$slots:{default:[Ls]},$$scope:{ctx:d}}}),ue=new h({props:{code:"JTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBldmFsX2RhdGFsb2FkZXIlMkMlMjBscl9zY2hlZHVsZXIlMEElMjAlMjAlMjAlMjAp",highlighted:`    model, optimizer, train_dataloader, eval_dataloader, lr_scheduler = accelerator.prepare(
        model, optimizer, train_dataloader, eval_dataloader, lr_scheduler
    )`,wrap:!1}}),be=new h({props:{code:"JTIwJTIwJTIwJTIwZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKDUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwudHJhaW4oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwKGJhdGNoJTVCJTIyaW1hZ2UlMjIlNUQlMjAtJTIwbWVhbiklMjAlMkYlMjBzdGQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLmNyb3NzX2VudHJvcHkob3V0cHV0cyUyQyUyMGJhdGNoJTVCJTIybGFiZWwlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`    <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
        model.train()
        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            outputs = model(inputs)
            loss = torch.nn.functional.cross_entropy(outputs, batch[<span class="hljs-string">&quot;label&quot;</span>])
            accelerator.backward(loss)
            optimizer.step()
            lr_scheduler.step()
            optimizer.zero_grad()`,wrap:!1}}),Ce=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwuZXZhbCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGUlMjAlM0QlMjAwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2VsZW1zJTIwJTNEJTIwMA==",highlighted:`        model.<span class="hljs-built_in">eval</span>()
        accurate = <span class="hljs-number">0</span>
        num_elems = <span class="hljs-number">0</span>`,wrap:!1}}),$e=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMGV2YWxfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMChiYXRjaCU1QiUyMmltYWdlJTIyJTVEJTIwLSUyMG1lYW4pJTIwJTJGJTIwc3RkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLmFyZ21heChkaW0lM0QtMSk=",highlighted:`        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            <span class="hljs-keyword">with</span> torch.no_grad():
                outputs = model(inputs)
            predictions = outputs.argmax(dim=-<span class="hljs-number">1</span>)`,wrap:!1}}),We=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGVfcHJlZHMlMjAlM0QlMjBhY2NlbGVyYXRvci5nYXRoZXIocHJlZGljdGlvbnMpJTIwJTNEJTNEJTIwYWNjZWxlcmF0b3IuZ2F0aGVyKGJhdGNoJTVCJTIybGFiZWwlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2VsZW1zJTIwJTJCJTNEJTIwYWNjdXJhdGVfcHJlZHMuc2hhcGUlNUIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGUlMjAlMkIlM0QlMjBhY2N1cmF0ZV9wcmVkcy5sb25nKCkuc3VtKCk=",highlighted:`            accurate_preds = accelerator.gather(predictions) == accelerator.gather(batch[<span class="hljs-string">&quot;label&quot;</span>])
            num_elems += accurate_preds.shape[<span class="hljs-number">0</span>]
            accurate += accurate_preds.long().<span class="hljs-built_in">sum</span>()`,wrap:!1}}),ke=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXZhbF9tZXRyaWMlMjAlM0QlMjBhY2N1cmF0ZS5pdGVtKCklMjAlMkYlMjBudW1fZWxlbXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5wcmludChmJTIyZXBvY2glMjAlN0JlcG9jaCU3RCUzQSUyMCU3QjEwMCUyMColMjBldmFsX21ldHJpYyUzQS4yZiU3RCUyMik=",highlighted:`        eval_metric = accurate.item() / num_elems
        accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;epoch <span class="hljs-subst">{epoch}</span>: <span class="hljs-subst">{<span class="hljs-number">100</span> * eval_metric:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`,wrap:!1}}),ve=new h({props:{code:"ZGVmJTIwdHJhaW5pbmdfbG9vcChtaXhlZF9wcmVjaXNpb24lM0QlMjJmcDE2JTIyJTJDJTIwc2VlZCUzQSUyMGludCUyMCUzRCUyMDQyJTJDJTIwYmF0Y2hfc2l6ZSUzQSUyMGludCUyMCUzRCUyMDY0KSUzQSUwQSUyMCUyMCUyMCUyMHNldF9zZWVkKHNlZWQpJTBBJTIwJTIwJTIwJTIwJTIzJTIwSW5pdGlhbGl6ZSUyMGFjY2VsZXJhdG9yJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihtaXhlZF9wcmVjaXNpb24lM0RtaXhlZF9wcmVjaXNpb24pJTBBJTIwJTIwJTIwJTIwJTIzJTIwQnVpbGQlMjBkYXRhbG9hZGVycyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBldmFsX2RhdGFsb2FkZXIlMjAlM0QlMjBnZXRfZGF0YWxvYWRlcnMoYmF0Y2hfc2l6ZSklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBJbnN0YW50aWF0ZSUyMHRoZSUyMG1vZGVsJTIwKHlvdSUyMGJ1aWxkJTIwdGhlJTIwbW9kZWwlMjBoZXJlJTIwc28lMjB0aGF0JTIwdGhlJTIwc2VlZCUyMGFsc28lMjBjb250cm9scyUyMG5ldyUyMHdlaWdodCUyMGluaXRhbGl6aWF0aW9ucyklMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMGNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNEbGVuKGxhYmVsX3RvX2lkKSklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBGcmVlemUlMjB0aGUlMjBiYXNlJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBmb3IlMjBwYXJhbSUyMGluJTIwbW9kZWwucGFyYW1ldGVycygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFyYW0ucmVxdWlyZXNfZ3JhZCUyMCUzRCUyMEZhbHNlJTBBJTIwJTIwJTIwJTIwZm9yJTIwcGFyYW0lMjBpbiUyMG1vZGVsLmdldF9jbGFzc2lmaWVyKCkucGFyYW1ldGVycygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFyYW0ucmVxdWlyZXNfZ3JhZCUyMCUzRCUyMFRydWUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBZb3UlMjBjYW4lMjBub3JtYWxpemUlMjB0aGUlMjBiYXRjaGVzJTIwb2YlMjBpbWFnZXMlMjB0byUyMGJlJTIwYSUyMGJpdCUyMGZhc3RlciUwQSUyMCUyMCUyMCUyMG1lYW4lMjAlM0QlMjB0b3JjaC50ZW5zb3IobW9kZWwuZGVmYXVsdF9jZmclNUIlMjJtZWFuJTIyJTVEKSU1Qk5vbmUlMkMlMjAlM0ElMkMlMjBOb25lJTJDJTIwTm9uZSU1RCUwQSUyMCUyMCUyMCUyMHN0ZCUyMCUzRCUyMHRvcmNoLnRlbnNvcihtb2RlbC5kZWZhdWx0X2NmZyU1QiUyMnN0ZCUyMiU1RCklNUJOb25lJTJDJTIwJTNBJTJDJTIwTm9uZSUyQyUyME5vbmUlNUQlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBUbyUyMG1ha2UlMjB0aGVzZSUyMGNvbnN0YW50cyUyMGF2YWlsYWJsZSUyMG9uJTIwdGhlJTIwYWN0aXZlJTIwZGV2aWNlJTJDJTIwc2V0JTIwaXQlMjB0byUyMHRoZSUyMGFjY2VsZXJhdG9yJTIwZGV2aWNlJTBBJTIwJTIwJTIwJTIwbWVhbiUyMCUzRCUyMG1lYW4udG8oYWNjZWxlcmF0b3IuZGV2aWNlKSUwQSUyMCUyMCUyMCUyMHN0ZCUyMCUzRCUyMHN0ZC50byhhY2NlbGVyYXRvci5kZXZpY2UpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwSW50YW50aWF0ZSUyMHRoZSUyMG9wdGltaXplciUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUyMCUzRCUyMHRvcmNoLm9wdGltLkFkYW0ocGFyYW1zJTNEbW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS0yJTIwJTJGJTIwMjUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwSW5zdGFudGlhdGUlMjB0aGUlMjBsZWFybmluZyUyMHJhdGUlMjBzY2hlZHVsZXIlMEElMjAlMjAlMjAlMjBscl9zY2hlZHVsZXIlMjAlM0QlMjBPbmVDeWNsZUxSKG9wdGltaXplciUzRG9wdGltaXplciUyQyUyMG1heF9sciUzRDNlLTIlMkMlMjBlcG9jaHMlM0Q1JTJDJTIwc3RlcHNfcGVyX2Vwb2NoJTNEbGVuKHRyYWluX2RhdGFsb2FkZXIpKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFByZXBhcmUlMjBldmVyeXRoaW5nJTBBJTIwJTIwJTIwJTIwJTIzJTIwVGhlcmUlMjBpcyUyMG5vJTIwc3BlY2lmaWMlMjBvcmRlciUyMHRvJTIwcmVtZW1iZXIlMkMlMjB5b3UlMjBqdXN0JTIwbmVlZCUyMHRvJTIwdW5wYWNrJTIwdGhlJTIwb2JqZWN0cyUyMGluJTIwdGhlJTIwc2FtZSUyMG9yZGVyJTIweW91JTIwZ2F2ZSUyMHRoZW0lMjB0byUyMHRoZSUwQSUyMCUyMCUyMCUyMCUyMyUyMHByZXBhcmUlMjBtZXRob2QuJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBldmFsX2RhdGFsb2FkZXIlMkMlMjBscl9zY2hlZHVsZXIlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwTm93JTIweW91JTIwdHJhaW4lMjB0aGUlMjBtb2RlbCUwQSUyMCUyMCUyMCUyMGZvciUyMGVwb2NoJTIwaW4lMjByYW5nZSg1KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsLnRyYWluKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBiYXRjaCUyMGluJTIwdHJhaW5fZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMChiYXRjaCU1QiUyMmltYWdlJTIyJTVEJTIwLSUyMG1lYW4pJTIwJTJGJTIwc3RkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5jcm9zc19lbnRyb3B5KG91dHB1dHMlMkMlMjBiYXRjaCU1QiUyMmxhYmVsJTIyJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbC5ldmFsKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2N1cmF0ZSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fZWxlbXMlMjAlM0QlMjAwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMGV2YWxfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMChiYXRjaCU1QiUyMmltYWdlJTIyJTVEJTIwLSUyMG1lYW4pJTIwJTJGJTIwc3RkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLmFyZ21heChkaW0lM0QtMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2N1cmF0ZV9wcmVkcyUyMCUzRCUyMGFjY2VsZXJhdG9yLmdhdGhlcihwcmVkaWN0aW9ucyklMjAlM0QlM0QlMjBhY2NlbGVyYXRvci5nYXRoZXIoYmF0Y2glNUIlMjJsYWJlbCUyMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fZWxlbXMlMjAlMkIlM0QlMjBhY2N1cmF0ZV9wcmVkcy5zaGFwZSU1QjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2N1cmF0ZSUyMCUyQiUzRCUyMGFjY3VyYXRlX3ByZWRzLmxvbmcoKS5zdW0oKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV2YWxfbWV0cmljJTIwJTNEJTIwYWNjdXJhdGUuaXRlbSgpJTIwJTJGJTIwbnVtX2VsZW1zJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwVXNlJTIwYWNjZWxlcmF0b3IucHJpbnQlMjB0byUyMHByaW50JTIwb25seSUyMG9uJTIwdGhlJTIwbWFpbiUyMHByb2Nlc3MuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IucHJpbnQoZiUyMmVwb2NoJTIwJTdCZXBvY2glN0QlM0ElMjAlN0IxMDAlMjAqJTIwZXZhbF9tZXRyaWMlM0EuMmYlN0QlMjIp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">training_loop</span>(<span class="hljs-params">mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>, seed: <span class="hljs-built_in">int</span> = <span class="hljs-number">42</span>, batch_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span></span>):
    set_seed(seed)
    <span class="hljs-comment"># Initialize accelerator</span>
    accelerator = Accelerator(mixed_precision=mixed_precision)
    <span class="hljs-comment"># Build dataloaders</span>
    train_dataloader, eval_dataloader = get_dataloaders(batch_size)

    <span class="hljs-comment"># Instantiate the model (you build the model here so that the seed also controls new weight initaliziations)</span>
    model = create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-built_in">len</span>(label_to_id))

    <span class="hljs-comment"># Freeze the base model</span>
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
        param.requires_grad = <span class="hljs-literal">False</span>
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.get_classifier().parameters():
        param.requires_grad = <span class="hljs-literal">True</span>

    <span class="hljs-comment"># You can normalize the batches of images to be a bit faster</span>
    mean = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;mean&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]
    std = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;std&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]

    <span class="hljs-comment"># To make these constants available on the active device, set it to the accelerator device</span>
    mean = mean.to(accelerator.device)
    std = std.to(accelerator.device)

    <span class="hljs-comment"># Intantiate the optimizer</span>
    optimizer = torch.optim.Adam(params=model.parameters(), lr=<span class="hljs-number">3e-2</span> / <span class="hljs-number">25</span>)

    <span class="hljs-comment"># Instantiate the learning rate scheduler</span>
    lr_scheduler = OneCycleLR(optimizer=optimizer, max_lr=<span class="hljs-number">3e-2</span>, epochs=<span class="hljs-number">5</span>, steps_per_epoch=<span class="hljs-built_in">len</span>(train_dataloader))

    <span class="hljs-comment"># Prepare everything</span>
    <span class="hljs-comment"># There is no specific order to remember, you just need to unpack the objects in the same order you gave them to the</span>
    <span class="hljs-comment"># prepare method.</span>
    model, optimizer, train_dataloader, eval_dataloader, lr_scheduler = accelerator.prepare(
        model, optimizer, train_dataloader, eval_dataloader, lr_scheduler
    )

    <span class="hljs-comment"># Now you train the model</span>
    <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
        model.train()
        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            outputs = model(inputs)
            loss = torch.nn.functional.cross_entropy(outputs, batch[<span class="hljs-string">&quot;label&quot;</span>])
            accelerator.backward(loss)
            optimizer.step()
            lr_scheduler.step()
            optimizer.zero_grad()

        model.<span class="hljs-built_in">eval</span>()
        accurate = <span class="hljs-number">0</span>
        num_elems = <span class="hljs-number">0</span>
        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            <span class="hljs-keyword">with</span> torch.no_grad():
                outputs = model(inputs)
            predictions = outputs.argmax(dim=-<span class="hljs-number">1</span>)
            accurate_preds = accelerator.gather(predictions) == accelerator.gather(batch[<span class="hljs-string">&quot;label&quot;</span>])
            num_elems += accurate_preds.shape[<span class="hljs-number">0</span>]
            accurate += accurate_preds.long().<span class="hljs-built_in">sum</span>()

        eval_metric = accurate.item() / num_elems
        <span class="hljs-comment"># Use accelerator.print to print only on the main process.</span>
        accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;epoch <span class="hljs-subst">{epoch}</span>: <span class="hljs-subst">{<span class="hljs-number">100</span> * eval_metric:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`,wrap:!1}}),Ae=new tl({props:{title:"Using the notebook_launcher",local:"using-the-notebooklauncher",headingTag:"h2"}}),Re=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlcg==",highlighted:'<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher',wrap:!1}}),Ne=new h({props:{code:"YXJncyUyMCUzRCUyMCglMjJmcDE2JTIyJTJDJTIwNDIlMkMlMjA2NCklMEFub3RlYm9va19sYXVuY2hlcih0cmFpbmluZ19sb29wJTJDJTIwYXJncyUyQyUyMG51bV9wcm9jZXNzZXMlM0QyKQ==",highlighted:`args = (<span class="hljs-string">&quot;fp16&quot;</span>, <span class="hljs-number">42</span>, <span class="hljs-number">64</span>)
notebook_launcher(training_loop, args, num_processes=<span class="hljs-number">2</span>)`,wrap:!1}}),Fe=new h({props:{code:"bm90ZWJvb2tfbGF1bmNoZXIodHJhaW5pbmdfbG9vcCUyQyUyMGFyZ3MlMkMlMjBtYXN0ZXJfYWRkciUzRCUyMjE3Mi4zMS40My44JTIyJTJDJTIwbm9kZV9yYW5rJTNEMCUyQyUyMG51bV9ub2RlcyUzRDIlMkMlMjBudW1fcHJvY2Vzc2VzJTNEOCk=",highlighted:'notebook_launcher(training_loop, args, master_addr=<span class="hljs-string">&quot;172.31.43.8&quot;</span>, node_rank=<span class="hljs-number">0</span>, num_nodes=<span class="hljs-number">2</span>, num_processes=<span class="hljs-number">8</span>)',wrap:!1}}),$=new ll({props:{$$slots:{default:[Ds]},$$scope:{ctx:d}}}),ze=new h({props:{code:"bm90ZWJvb2tfbGF1bmNoZXIodHJhaW5pbmdfbG9vcCUyQyUyMGFyZ3MlMkMlMjBtYXN0ZXJfYWRkciUzRCUyMjE3Mi4zMS40My44JTIyJTJDJTIwbm9kZV9yYW5rJTNEMSUyQyUyMG51bV9ub2RlcyUzRDIlMkMlMjBudW1fcHJvY2Vzc2VzJTNEOCk=",highlighted:'notebook_launcher(training_loop, args, master_addr=<span class="hljs-string">&quot;172.31.43.8&quot;</span>, node_rank=<span class="hljs-number">1</span>, num_nodes=<span class="hljs-number">2</span>, num_processes=<span class="hljs-number">8</span>)',wrap:!1}}),Ee=new h({props:{code:"bW9kZWwlMjAlM0QlMjBjcmVhdGVfbW9kZWwoJTIycmVzbmV0NTBkJTIyJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRGxlbihsYWJlbF90b19pZCkpJTBBJTBBYXJncyUyMCUzRCUyMChtb2RlbCUyQyUyMCUyMmZwMTYlMjIlMkMlMjA0MiUyQyUyMDY0KSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2xvb3AlMkMlMjBhcmdzJTJDJTIwbnVtX3Byb2Nlc3NlcyUzRDgp",highlighted:`model = create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-built_in">len</span>(label_to_id))

args = (model, <span class="hljs-string">&quot;fp16&quot;</span>, <span class="hljs-number">42</span>, <span class="hljs-number">64</span>)
notebook_launcher(training_loop, args, num_processes=<span class="hljs-number">8</span>)`,wrap:!1}}),Le=new h({props:{code:"TGF1bmNoaW5nJTIwdHJhaW5pbmclMjBvbiUyMDIlMjBHUFVzLiUwQWVwb2NoJTIwMCUzQSUyMDg4LjEyJTBBZXBvY2glMjAxJTNBJTIwOTEuNzMlMEFlcG9jaCUyMDIlM0ElMjA5Mi41OCUwQWVwb2NoJTIwMyUzQSUyMDkzLjkwJTBBZXBvY2glMjA0JTNBJTIwOTQuNzE=",highlighted:`Launching training on <span class="hljs-number">2</span> GPUs.
epoch <span class="hljs-number">0</span>: <span class="hljs-number">88.12</span>
epoch <span class="hljs-number">1</span>: <span class="hljs-number">91.73</span>
epoch <span class="hljs-number">2</span>: <span class="hljs-number">92.58</span>
epoch <span class="hljs-number">3</span>: <span class="hljs-number">93.90</span>
epoch <span class="hljs-number">4</span>: <span class="hljs-number">94.71</span>`,wrap:!1}}),qe=new tl({props:{title:"Debugging",local:"debugging",headingTag:"h2"}}),Ke=new tl({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),{c(){p=M("meta"),U=a(),o=M("p"),j=a(),c(G.$$.fragment),nl=a(),_=M("p"),_.textContent=Vt,pl=a(),c(u.$$.fragment),Ml=a(),c(W.$$.fragment),il=a(),g=M("p"),g.textContent=xt,rl=a(),c(k.$$.fragment),ol=a(),B=M("p"),B.innerHTML=Ft,cl=a(),v=M("p"),v.textContent=Qt,ml=a(),c(I.$$.fragment),yl=a(),c(A.$$.fragment),wl=a(),c(Y.$$.fragment),Jl=a(),X=M("p"),X.innerHTML=zt,Tl=a(),R=M("p"),R.textContent=St,hl=a(),N=M("p"),N.innerHTML=Et,Ul=a(),c(V.$$.fragment),jl=a(),x=M("p"),x.textContent=Ht,dl=a(),c(F.$$.fragment),ul=a(),c(Q.$$.fragment),Il=a(),z=M("p"),z.innerHTML=Lt,bl=a(),c(S.$$.fragment),fl=a(),c(E.$$.fragment),Cl=a(),H=M("p"),H.textContent=Dt,Zl=a(),c(L.$$.fragment),$l=a(),D=M("p"),D.innerHTML=qt,Gl=a(),c(q.$$.fragment),_l=a(),P=M("p"),P.textContent=Pt,Wl=a(),c(K.$$.fragment),gl=a(),O=M("p"),O.textContent=Kt,kl=a(),c(ee.$$.fragment),Bl=a(),le=M("p"),le.innerHTML=Ot,vl=a(),c(te.$$.fragment),Al=a(),se=M("p"),se.textContent=es,Yl=a(),c(ae.$$.fragment),Xl=a(),c(ne.$$.fragment),Rl=a(),pe=M("p"),pe.innerHTML=ls,Nl=a(),Me=M("p"),Me.textContent=ts,Vl=a(),c(b.$$.fragment),xl=a(),c(ie.$$.fragment),Fl=a(),re=M("p"),re.innerHTML=ss,Ql=a(),c(f.$$.fragment),zl=a(),oe=M("p"),oe.textContent=as,Sl=a(),c(ce.$$.fragment),El=a(),c(C.$$.fragment),Hl=a(),me=M("p"),me.textContent=ns,Ll=a(),c(ye.$$.fragment),Dl=a(),we=M("p"),we.textContent=ps,ql=a(),c(Je.$$.fragment),Pl=a(),Te=M("p"),Te.textContent=Ms,Kl=a(),c(he.$$.fragment),Ol=a(),Ue=M("p"),Ue.textContent=is,et=a(),c(je.$$.fragment),lt=a(),de=M("p"),de.innerHTML=rs,tt=a(),c(Z.$$.fragment),st=a(),c(ue.$$.fragment),at=a(),Ie=M("p"),Ie.textContent=os,nt=a(),c(be.$$.fragment),pt=a(),fe=M("p"),fe.textContent=cs,Mt=a(),c(Ce.$$.fragment),it=a(),Ze=M("p"),Ze.textContent=ms,rt=a(),c($e.$$.fragment),ot=a(),Ge=M("p"),Ge.textContent=ys,ct=a(),_e=M("p"),_e.innerHTML=ws,mt=a(),c(We.$$.fragment),yt=a(),ge=M("p"),ge.innerHTML=Js,wt=a(),c(ke.$$.fragment),Jt=a(),Be=M("p"),Be.textContent=Ts,Tt=a(),c(ve.$$.fragment),ht=a(),c(Ae.$$.fragment),Ut=a(),Ye=M("p"),Ye.innerHTML=hs,jt=a(),Xe=M("p"),Xe.innerHTML=Us,dt=a(),c(Re.$$.fragment),ut=a(),c(Ne.$$.fragment),It=a(),Ve=M("p"),Ve.textContent=js,bt=a(),xe=M("p"),xe.textContent=ds,ft=a(),c(Fe.$$.fragment),Ct=a(),Qe=M("p"),Qe.textContent=us,Zt=a(),c($.$$.fragment),$t=a(),c(ze.$$.fragment),Gt=a(),Se=M("p"),Se.textContent=Is,_t=a(),c(Ee.$$.fragment),Wt=a(),He=M("p"),He.textContent=bs,gt=a(),c(Le.$$.fragment),kt=a(),De=M("p"),De.textContent=fs,Bt=a(),c(qe.$$.fragment),vt=a(),Pe=M("p"),Pe.innerHTML=Cs,At=a(),c(Ke.$$.fragment),Yt=a(),Oe=M("p"),Oe.textContent=Zs,Xt=a(),el=M("ul"),el.innerHTML=$s,Rt=a(),al=M("p"),this.h()},l(e){const l=xs("svelte-u9bgzb",document.head);p=i(l,"META",{name:!0,content:!0}),l.forEach(t),U=n(e),o=i(e,"P",{}),As(o).forEach(t),j=n(e),m(G.$$.fragment,e),nl=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-6spvy7"&&(_.textContent=Vt),pl=n(e),m(u.$$.fragment,e),Ml=n(e),m(W.$$.fragment,e),il=n(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1xlepvp"&&(g.textContent=xt),rl=n(e),m(k.$$.fragment,e),ol=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1t54cwl"&&(B.innerHTML=Ft),cl=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-3qwb6i"&&(v.textContent=Qt),ml=n(e),m(I.$$.fragment,e),yl=n(e),m(A.$$.fragment,e),wl=n(e),m(Y.$$.fragment,e),Jl=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-maqpj6"&&(X.innerHTML=zt),Tl=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1gkh70d"&&(R.textContent=St),hl=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-myu7hv"&&(N.innerHTML=Et),Ul=n(e),m(V.$$.fragment,e),jl=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-h07c4l"&&(x.textContent=Ht),dl=n(e),m(F.$$.fragment,e),ul=n(e),m(Q.$$.fragment,e),Il=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-60ulbw"&&(z.innerHTML=Lt),bl=n(e),m(S.$$.fragment,e),fl=n(e),m(E.$$.fragment,e),Cl=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1kzkru5"&&(H.textContent=Dt),Zl=n(e),m(L.$$.fragment,e),$l=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-eeriqt"&&(D.innerHTML=qt),Gl=n(e),m(q.$$.fragment,e),_l=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1erq0yi"&&(P.textContent=Pt),Wl=n(e),m(K.$$.fragment,e),gl=n(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-17fsfbj"&&(O.textContent=Kt),kl=n(e),m(ee.$$.fragment,e),Bl=n(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1wyd1v3"&&(le.innerHTML=Ot),vl=n(e),m(te.$$.fragment,e),Al=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-s9102n"&&(se.textContent=es),Yl=n(e),m(ae.$$.fragment,e),Xl=n(e),m(ne.$$.fragment,e),Rl=n(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-12h3nze"&&(pe.innerHTML=ls),Nl=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-oa85ci"&&(Me.textContent=ts),Vl=n(e),m(b.$$.fragment,e),xl=n(e),m(ie.$$.fragment,e),Fl=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-mw6g06"&&(re.innerHTML=ss),Ql=n(e),m(f.$$.fragment,e),zl=n(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1ojop43"&&(oe.textContent=as),Sl=n(e),m(ce.$$.fragment,e),El=n(e),m(C.$$.fragment,e),Hl=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-2qfnag"&&(me.textContent=ns),Ll=n(e),m(ye.$$.fragment,e),Dl=n(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-16kq69y"&&(we.textContent=ps),ql=n(e),m(Je.$$.fragment,e),Pl=n(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1x7hf7y"&&(Te.textContent=Ms),Kl=n(e),m(he.$$.fragment,e),Ol=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1drdkyl"&&(Ue.textContent=is),et=n(e),m(je.$$.fragment,e),lt=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-wvbqbt"&&(de.innerHTML=rs),tt=n(e),m(Z.$$.fragment,e),st=n(e),m(ue.$$.fragment,e),at=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-8iqamy"&&(Ie.textContent=os),nt=n(e),m(be.$$.fragment,e),pt=n(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-uq3liu"&&(fe.textContent=cs),Mt=n(e),m(Ce.$$.fragment,e),it=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1vssgg7"&&(Ze.textContent=ms),rt=n(e),m($e.$$.fragment,e),ot=n(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-o67l3v"&&(Ge.textContent=ys),ct=n(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-vdzy84"&&(_e.innerHTML=ws),mt=n(e),m(We.$$.fragment,e),yt=n(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-ytb4g"&&(ge.innerHTML=Js),wt=n(e),m(ke.$$.fragment,e),Jt=n(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1kobhd"&&(Be.textContent=Ts),Tt=n(e),m(ve.$$.fragment,e),ht=n(e),m(Ae.$$.fragment,e),Ut=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-80262m"&&(Ye.innerHTML=hs),jt=n(e),Xe=i(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-7o5jv1"&&(Xe.innerHTML=Us),dt=n(e),m(Re.$$.fragment,e),ut=n(e),m(Ne.$$.fragment,e),It=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-rkokvk"&&(Ve.textContent=js),bt=n(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-192rw96"&&(xe.textContent=ds),ft=n(e),m(Fe.$$.fragment,e),Ct=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-3ig3ul"&&(Qe.textContent=us),Zt=n(e),m($.$$.fragment,e),$t=n(e),m(ze.$$.fragment,e),Gt=n(e),Se=i(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-10flsnd"&&(Se.textContent=Is),_t=n(e),m(Ee.$$.fragment,e),Wt=n(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-svq1hp"&&(He.textContent=bs),gt=n(e),m(Le.$$.fragment,e),kt=n(e),De=i(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-9wooxy"&&(De.textContent=fs),Bt=n(e),m(qe.$$.fragment,e),vt=n(e),Pe=i(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1p7dsaj"&&(Pe.innerHTML=Cs),At=n(e),m(Ke.$$.fragment,e),Yt=n(e),Oe=i(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-ixf1ne"&&(Oe.textContent=Zs),Xt=n(e),el=i(e,"UL",{"data-svelte-h":!0}),r(el)!=="svelte-5e4f3h"&&(el.innerHTML=$s),Rt=n(e),al=i(e,"P",{}),As(al).forEach(t),this.h()},h(){Ys(p,"name","hf:doc:metadata"),Ys(p,"content",Ps)},m(e,l){Fs(document.head,p),s(e,U,l),s(e,o,l),s(e,j,l),y(G,e,l),s(e,nl,l),s(e,_,l),s(e,pl,l),y(u,e,l),s(e,Ml,l),y(W,e,l),s(e,il,l),s(e,g,l),s(e,rl,l),y(k,e,l),s(e,ol,l),s(e,B,l),s(e,cl,l),s(e,v,l),s(e,ml,l),y(I,e,l),s(e,yl,l),y(A,e,l),s(e,wl,l),y(Y,e,l),s(e,Jl,l),s(e,X,l),s(e,Tl,l),s(e,R,l),s(e,hl,l),s(e,N,l),s(e,Ul,l),y(V,e,l),s(e,jl,l),s(e,x,l),s(e,dl,l),y(F,e,l),s(e,ul,l),y(Q,e,l),s(e,Il,l),s(e,z,l),s(e,bl,l),y(S,e,l),s(e,fl,l),y(E,e,l),s(e,Cl,l),s(e,H,l),s(e,Zl,l),y(L,e,l),s(e,$l,l),s(e,D,l),s(e,Gl,l),y(q,e,l),s(e,_l,l),s(e,P,l),s(e,Wl,l),y(K,e,l),s(e,gl,l),s(e,O,l),s(e,kl,l),y(ee,e,l),s(e,Bl,l),s(e,le,l),s(e,vl,l),y(te,e,l),s(e,Al,l),s(e,se,l),s(e,Yl,l),y(ae,e,l),s(e,Xl,l),y(ne,e,l),s(e,Rl,l),s(e,pe,l),s(e,Nl,l),s(e,Me,l),s(e,Vl,l),y(b,e,l),s(e,xl,l),y(ie,e,l),s(e,Fl,l),s(e,re,l),s(e,Ql,l),y(f,e,l),s(e,zl,l),s(e,oe,l),s(e,Sl,l),y(ce,e,l),s(e,El,l),y(C,e,l),s(e,Hl,l),s(e,me,l),s(e,Ll,l),y(ye,e,l),s(e,Dl,l),s(e,we,l),s(e,ql,l),y(Je,e,l),s(e,Pl,l),s(e,Te,l),s(e,Kl,l),y(he,e,l),s(e,Ol,l),s(e,Ue,l),s(e,et,l),y(je,e,l),s(e,lt,l),s(e,de,l),s(e,tt,l),y(Z,e,l),s(e,st,l),y(ue,e,l),s(e,at,l),s(e,Ie,l),s(e,nt,l),y(be,e,l),s(e,pt,l),s(e,fe,l),s(e,Mt,l),y(Ce,e,l),s(e,it,l),s(e,Ze,l),s(e,rt,l),y($e,e,l),s(e,ot,l),s(e,Ge,l),s(e,ct,l),s(e,_e,l),s(e,mt,l),y(We,e,l),s(e,yt,l),s(e,ge,l),s(e,wt,l),y(ke,e,l),s(e,Jt,l),s(e,Be,l),s(e,Tt,l),y(ve,e,l),s(e,ht,l),y(Ae,e,l),s(e,Ut,l),s(e,Ye,l),s(e,jt,l),s(e,Xe,l),s(e,dt,l),y(Re,e,l),s(e,ut,l),y(Ne,e,l),s(e,It,l),s(e,Ve,l),s(e,bt,l),s(e,xe,l),s(e,ft,l),y(Fe,e,l),s(e,Ct,l),s(e,Qe,l),s(e,Zt,l),y($,e,l),s(e,$t,l),y(ze,e,l),s(e,Gt,l),s(e,Se,l),s(e,_t,l),y(Ee,e,l),s(e,Wt,l),s(e,He,l),s(e,gt,l),y(Le,e,l),s(e,kt,l),s(e,De,l),s(e,Bt,l),y(qe,e,l),s(e,vt,l),s(e,Pe,l),s(e,At,l),y(Ke,e,l),s(e,Yt,l),s(e,Oe,l),s(e,Xt,l),s(e,el,l),s(e,Rt,l),s(e,al,l),Nt=!0},p(e,[l]){const Gs={};l&2&&(Gs.$$scope={dirty:l,ctx:e}),u.$set(Gs);const _s={};l&2&&(_s.$$scope={dirty:l,ctx:e}),I.$set(_s);const Ws={};l&2&&(Ws.$$scope={dirty:l,ctx:e}),b.$set(Ws);const gs={};l&2&&(gs.$$scope={dirty:l,ctx:e}),f.$set(gs);const ks={};l&2&&(ks.$$scope={dirty:l,ctx:e}),C.$set(ks);const Bs={};l&2&&(Bs.$$scope={dirty:l,ctx:e}),Z.$set(Bs);const vs={};l&2&&(vs.$$scope={dirty:l,ctx:e}),$.$set(vs)},i(e){Nt||(w(G.$$.fragment,e),w(u.$$.fragment,e),w(W.$$.fragment,e),w(k.$$.fragment,e),w(I.$$.fragment,e),w(A.$$.fragment,e),w(Y.$$.fragment,e),w(V.$$.fragment,e),w(F.$$.fragment,e),w(Q.$$.fragment,e),w(S.$$.fragment,e),w(E.$$.fragment,e),w(L.$$.fragment,e),w(q.$$.fragment,e),w(K.$$.fragment,e),w(ee.$$.fragment,e),w(te.$$.fragment,e),w(ae.$$.fragment,e),w(ne.$$.fragment,e),w(b.$$.fragment,e),w(ie.$$.fragment,e),w(f.$$.fragment,e),w(ce.$$.fragment,e),w(C.$$.fragment,e),w(ye.$$.fragment,e),w(Je.$$.fragment,e),w(he.$$.fragment,e),w(je.$$.fragment,e),w(Z.$$.fragment,e),w(ue.$$.fragment,e),w(be.$$.fragment,e),w(Ce.$$.fragment,e),w($e.$$.fragment,e),w(We.$$.fragment,e),w(ke.$$.fragment,e),w(ve.$$.fragment,e),w(Ae.$$.fragment,e),w(Re.$$.fragment,e),w(Ne.$$.fragment,e),w(Fe.$$.fragment,e),w($.$$.fragment,e),w(ze.$$.fragment,e),w(Ee.$$.fragment,e),w(Le.$$.fragment,e),w(qe.$$.fragment,e),w(Ke.$$.fragment,e),Nt=!0)},o(e){J(G.$$.fragment,e),J(u.$$.fragment,e),J(W.$$.fragment,e),J(k.$$.fragment,e),J(I.$$.fragment,e),J(A.$$.fragment,e),J(Y.$$.fragment,e),J(V.$$.fragment,e),J(F.$$.fragment,e),J(Q.$$.fragment,e),J(S.$$.fragment,e),J(E.$$.fragment,e),J(L.$$.fragment,e),J(q.$$.fragment,e),J(K.$$.fragment,e),J(ee.$$.fragment,e),J(te.$$.fragment,e),J(ae.$$.fragment,e),J(ne.$$.fragment,e),J(b.$$.fragment,e),J(ie.$$.fragment,e),J(f.$$.fragment,e),J(ce.$$.fragment,e),J(C.$$.fragment,e),J(ye.$$.fragment,e),J(Je.$$.fragment,e),J(he.$$.fragment,e),J(je.$$.fragment,e),J(Z.$$.fragment,e),J(ue.$$.fragment,e),J(be.$$.fragment,e),J(Ce.$$.fragment,e),J($e.$$.fragment,e),J(We.$$.fragment,e),J(ke.$$.fragment,e),J(ve.$$.fragment,e),J(Ae.$$.fragment,e),J(Re.$$.fragment,e),J(Ne.$$.fragment,e),J(Fe.$$.fragment,e),J($.$$.fragment,e),J(ze.$$.fragment,e),J(Ee.$$.fragment,e),J(Le.$$.fragment,e),J(qe.$$.fragment,e),J(Ke.$$.fragment,e),Nt=!1},d(e){e&&(t(U),t(o),t(j),t(nl),t(_),t(pl),t(Ml),t(il),t(g),t(rl),t(ol),t(B),t(cl),t(v),t(ml),t(yl),t(wl),t(Jl),t(X),t(Tl),t(R),t(hl),t(N),t(Ul),t(jl),t(x),t(dl),t(ul),t(Il),t(z),t(bl),t(fl),t(Cl),t(H),t(Zl),t($l),t(D),t(Gl),t(_l),t(P),t(Wl),t(gl),t(O),t(kl),t(Bl),t(le),t(vl),t(Al),t(se),t(Yl),t(Xl),t(Rl),t(pe),t(Nl),t(Me),t(Vl),t(xl),t(Fl),t(re),t(Ql),t(zl),t(oe),t(Sl),t(El),t(Hl),t(me),t(Ll),t(Dl),t(we),t(ql),t(Pl),t(Te),t(Kl),t(Ol),t(Ue),t(et),t(lt),t(de),t(tt),t(st),t(at),t(Ie),t(nt),t(pt),t(fe),t(Mt),t(it),t(Ze),t(rt),t(ot),t(Ge),t(ct),t(_e),t(mt),t(yt),t(ge),t(wt),t(Jt),t(Be),t(Tt),t(ht),t(Ut),t(Ye),t(jt),t(Xe),t(dt),t(ut),t(It),t(Ve),t(bt),t(xe),t(ft),t(Ct),t(Qe),t(Zt),t($t),t(Gt),t(Se),t(_t),t(Wt),t(He),t(gt),t(kt),t(De),t(Bt),t(vt),t(Pe),t(At),t(Yt),t(Oe),t(Xt),t(el),t(Rt),t(al)),t(p),T(G,e),T(u,e),T(W,e),T(k,e),T(I,e),T(A,e),T(Y,e),T(V,e),T(F,e),T(Q,e),T(S,e),T(E,e),T(L,e),T(q,e),T(K,e),T(ee,e),T(te,e),T(ae,e),T(ne,e),T(b,e),T(ie,e),T(f,e),T(ce,e),T(C,e),T(ye,e),T(Je,e),T(he,e),T(je,e),T(Z,e),T(ue,e),T(be,e),T(Ce,e),T($e,e),T(We,e),T(ke,e),T(ve,e),T(Ae,e),T(Re,e),T(Ne,e),T(Fe,e),T($,e),T(ze,e),T(Ee,e),T(Le,e),T(qe,e),T(Ke,e)}}}const Ps='{"title":"Launching Multi-GPU Training from a Jupyter Environment","local":"launching-multi-gpu-training-from-a-jupyter-environment","sections":[{"title":"Configuring the Environment","local":"configuring-the-environment","sections":[],"depth":2},{"title":"Preparing the Dataset and Model","local":"preparing-the-dataset-and-model","sections":[],"depth":2},{"title":"Writing the Training Function","local":"writing-the-training-function","sections":[],"depth":2},{"title":"Using the notebook_launcher","local":"using-the-notebooklauncher","sections":[],"depth":2},{"title":"Debugging","local":"debugging","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Ks(d){return Rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class aa extends Ns{constructor(p){super(),Vs(this,p,Ks,qs,Xs,{})}}export{aa as component};
