import{s as He,o as Se,n as Ee}from"../chunks/scheduler.b108d059.js";import{S as Re,i as Ye,g as p,s as a,r as o,A as We,h as i,f as l,c as n,j as ke,u as c,x as j,k as Ze,y as Ae,a as t,v as M,d as h,t as m,w as y}from"../chunks/index.008de539.js";import{T as Be}from"../chunks/Tip.aeb15ab7.js";import{C as f}from"../chunks/CodeBlock.3968c746.js";import{H as $}from"../chunks/Heading.88bfeb84.js";function ze(ys){let r,U='Although you can always use the <a href="https://github.com/huggingface/transformers" rel="nofollow">Python library</a> for server-side inference, using Transformers.js means that you can write all of your code in JavaScript (instead of having to set up and communicate with a separate Python process).';return{c(){r=p("p"),r.innerHTML=U},l(u){r=i(u,"P",{"data-svelte-h":!0}),j(r)!=="svelte-k7e8xo"&&(r.innerHTML=U)},m(u,w){t(u,r,w)},p:Ee,d(u){u&&l(r)}}}function _e(ys){let r,U="Since we use lazy loading, the first request made to the server will also be responsible for loading the pipeline. If you would like to begin loading the pipeline as soon as the server starts running, you can add the following line of code after defining <code>MyClassificationPipeline</code>:",u,w,T;return w=new f({props:{code:"TXlDbGFzc2lmaWNhdGlvblBpcGVsaW5lLmdldEluc3RhbmNlKCklM0I=",highlighted:'<span class="hljs-title class_">MyClassificationPipeline</span>.<span class="hljs-title function_">getInstance</span>();',wrap:!1}}),{c(){r=p("p"),r.innerHTML=U,u=a(),o(w.$$.fragment)},l(d){r=i(d,"P",{"data-svelte-h":!0}),j(r)!=="svelte-1ym4f5o"&&(r.innerHTML=U),u=n(d),c(w.$$.fragment,d)},m(d,J){t(d,r,J),t(d,u,J),M(w,d,J),T=!0},p:Ee,i(d){T||(h(w.$$.fragment,d),T=!0)},o(d){m(w.$$.fragment,d),T=!1},d(d){d&&(l(r),l(u)),y(w,d)}}}function Xe(ys){let r,U,u,w,T,d,J,re="Although Transformers.js was originally designed to be used in the browser, it’s also able to run inference on the server. In this tutorial, we will design a simple Node.js API that uses Transformers.js for sentiment analysis.",ds,g,oe="We’ll also show you how to use the library in both CommonJS and ECMAScript modules, so you can choose the module system that works best for your project:",us,I,ce=`<li><a href="#ecmascript-modules-esm">ECMAScript modules (ESM)</a> - The official standard format
to package JavaScript code for reuse. It’s the default module system in modern
browsers, with modules imported using <code>import</code> and exported using <code>export</code>.
Fortunately, starting with version 13.2.0, Node.js has stable support of ES modules.</li> <li><a href="#commonjs">CommonJS</a> - The default module system in Node.js. In this system,
modules are imported using <code>require()</code> and exported using <code>module.exports</code>.</li>`,ws,b,fs,v,Me="<strong>Useful links:</strong>",Ts,x,he='<li>Source code (<a href="https://github.com/xenova/transformers.js/tree/main/examples/node/esm/app.js" rel="nofollow">ESM</a> or <a href="https://github.com/xenova/transformers.js/tree/main/examples/node/commonjs/app.js" rel="nofollow">CommonJS</a>)</li> <li><a href="https://huggingface.co/docs/transformers.js" rel="nofollow">Documentation</a></li>',Js,N,Us,G,me='<li><a href="https://nodejs.org/en/" rel="nofollow">Node.js</a> version 18+</li> <li><a href="https://www.npmjs.com/" rel="nofollow">npm</a> version 9+</li>',$s,k,bs,Z,ye='Let’s start by creating a new Node.js project and installing Transformers.js via <a href="https://www.npmjs.com/package/@xenova/transformers" rel="nofollow">NPM</a>:',Cs,B,gs,E,je='Next, create a new file called <code>app.js</code>, which will be the entry point for our application. Depending on whether you’re using <a href="#ecmascript-modules-esm">ECMAScript modules</a> or <a href="#commonjs">CommonJS</a>, you will need to do some things differently (see below).',Is,H,de='We’ll also create a helper class called <code>MyClassificationPipeline</code> control the loading of the pipeline. It uses the <a href="https://en.wikipedia.org/wiki/Singleton_pattern" rel="nofollow">singleton pattern</a> to lazily create a single instance of the pipeline when <code>getInstance</code> is first called, and uses this pipeline for all subsequent calls:',vs,S,xs,R,ue="To indicate that your project uses ECMAScript modules, you need to add <code>&quot;type&quot;: &quot;module&quot;</code> to your <code>package.json</code>:",Ns,Y,Gs,W,we="Next, you will need to add the following imports to the top of <code>app.js</code>:",ks,A,Zs,z,fe="Following that, let’s import Transformers.js and define the <code>MyClassificationPipeline</code> class.",Bs,_,Es,X,Hs,Q,Te="Start by adding the following imports to the top of <code>app.js</code>:",Ss,V,Rs,L,Je='Following that, let’s import Transformers.js and define the <code>MyClassificationPipeline</code> class. Since Transformers.js is an ESM module, we will need to dynamically import the library using the <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/import" rel="nofollow"><code>import()</code></a> function:',Ys,F,Ws,q,As,P,Ue='Next, let’s create a basic server with the built-in <a href="https://nodejs.org/api/http.html#http" rel="nofollow">HTTP</a> module. We will listen for requests made to the server (using the <code>/classify</code> endpoint), extract the <code>text</code> query parameter, and run this through the pipeline.',zs,D,_s,C,Xs,K,$e="To start the server, run the following command:",Qs,O,Vs,ss,be='The server should be live at <a href="http://127.0.0.1:3000/" rel="nofollow">http://127.0.0.1:3000/</a>, which you can visit in your web browser. You should see the following message:',Ls,es,Fs,ls,Ce='This is because we aren’t targeting the <code>/classify</code> endpoint with a valid <code>text</code> query parameter. Let’s try again, this time with a valid request. For example, you can visit <a href="http://127.0.0.1:3000/classify?text=I%20love%20Transformers.js" rel="nofollow">http://127.0.0.1:3000/classify?text=I%20love%20Transformers.js</a> and you should see:',qs,ts,Ps,as,ge="Great! We’ve successfully created a basic HTTP server that uses Transformers.js to classify text.",Ds,ns,Ks,ps,Os,is,Ie="By default, the first time you run the application, it will download the model files and cache them on your file system (in <code>./node_modules/@xenova/transformers/.cache/</code>). All subsequent requests will then use this model. You can change the location of the cache by setting <code>env.cacheDir</code>. For example, to cache the model in the <code>.cache</code> directory in the current working directory, you can add:",se,rs,ee,os,le,cs,ve="If you want to use local model files, you can set <code>env.localModelPath</code> as follows:",te,Ms,ae,hs,xe="You can also disable loading of remote models by setting <code>env.allowRemoteModels</code> to <code>false</code>:",ne,ms,pe,js,ie;return T=new $({props:{title:"Server-side Inference in Node.js",local:"server-side-inference-in-nodejs",headingTag:"h1"}}),b=new Be({props:{$$slots:{default:[ze]},$$scope:{ctx:ys}}}),N=new $({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),k=new $({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),B=new f({props:{code:"bnBtJTIwaW5pdCUyMC15JTBBbnBtJTIwaSUyMCU0MHhlbm92YSUyRnRyYW5zZm9ybWVycw==",highlighted:`npm init -y
npm i @xenova/transformers`,wrap:!1}}),S=new $({props:{title:"ECMAScript modules (ESM)",local:"ecmascript-modules-esm",headingTag:"h3"}}),Y=new f({props:{code:"JTdCJTBBJTIwJTIwLi4uJTBBJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm1vZHVsZSUyMiUyQyUwQSUyMCUyMC4uLiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  ...
  <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;module&quot;</span><span class="hljs-punctuation">,</span>
  ...
<span class="hljs-punctuation">}</span>`,wrap:!1}}),A=new f({props:{code:"aW1wb3J0JTIwaHR0cCUyMGZyb20lMjAnaHR0cCclM0IlMEFpbXBvcnQlMjBxdWVyeXN0cmluZyUyMGZyb20lMjAncXVlcnlzdHJpbmcnJTNCJTBBaW1wb3J0JTIwdXJsJTIwZnJvbSUyMCd1cmwnJTNC",highlighted:`<span class="hljs-keyword">import</span> http <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;http&#x27;</span>;
<span class="hljs-keyword">import</span> querystring <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;querystring&#x27;</span>;
<span class="hljs-keyword">import</span> url <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;url&#x27;</span>;`,wrap:!1}}),_=new f({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMkMlMjBlbnYlMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFjbGFzcyUyME15Q2xhc3NpZmljYXRpb25QaXBlbGluZSUyMCU3QiUwQSUyMCUyMHN0YXRpYyUyMHRhc2slMjAlM0QlMjAndGV4dC1jbGFzc2lmaWNhdGlvbiclM0IlMEElMjAlMjBzdGF0aWMlMjBtb2RlbCUyMCUzRCUyMCdYZW5vdmElMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCclM0IlMEElMjAlMjBzdGF0aWMlMjBpbnN0YW5jZSUyMCUzRCUyMG51bGwlM0IlMEElMEElMjAlMjBzdGF0aWMlMjBhc3luYyUyMGdldEluc3RhbmNlKHByb2dyZXNzX2NhbGxiYWNrJTIwJTNEJTIwbnVsbCklMjAlN0IlMEElMjAlMjAlMjAlMjBpZiUyMCh0aGlzLmluc3RhbmNlJTIwJTNEJTNEJTNEJTIwbnVsbCklMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMkYlMkYlMjBOT1RFJTNBJTIwVW5jb21tZW50JTIwdGhpcyUyMHRvJTIwY2hhbmdlJTIwdGhlJTIwY2FjaGUlMjBkaXJlY3RvcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMkYlMkYlMjBlbnYuY2FjaGVEaXIlMjAlM0QlMjAnLiUyRi5jYWNoZSclM0IlMEElMEElMjAlMjAlMjAlMjAlMjAlMjB0aGlzLmluc3RhbmNlJTIwJTNEJTIwcGlwZWxpbmUodGhpcy50YXNrJTJDJTIwdGhpcy5tb2RlbCUyQyUyMCU3QiUyMHByb2dyZXNzX2NhbGxiYWNrJTIwJTdEKSUzQiUwQSUyMCUyMCUyMCUyMCU3RCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRoaXMuaW5zdGFuY2UlM0IlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-keyword">import</span> { pipeline, env } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyClassificationPipeline</span> {
  <span class="hljs-keyword">static</span> task = <span class="hljs-string">&#x27;text-classification&#x27;</span>;
  <span class="hljs-keyword">static</span> model = <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>;
  <span class="hljs-keyword">static</span> instance = <span class="hljs-literal">null</span>;

  <span class="hljs-keyword">static</span> <span class="hljs-keyword">async</span> <span class="hljs-title function_">getInstance</span>(<span class="hljs-params">progress_callback = <span class="hljs-literal">null</span></span>) {
    <span class="hljs-keyword">if</span> (<span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> === <span class="hljs-literal">null</span>) {
      <span class="hljs-comment">// <span class="hljs-doctag">NOTE:</span> Uncomment this to change the cache directory</span>
      <span class="hljs-comment">// env.cacheDir = &#x27;./.cache&#x27;;</span>

      <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> = <span class="hljs-title function_">pipeline</span>(<span class="hljs-variable language_">this</span>.<span class="hljs-property">task</span>, <span class="hljs-variable language_">this</span>.<span class="hljs-property">model</span>, { progress_callback });
    }

    <span class="hljs-keyword">return</span> <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span>;
  }
}`,wrap:!1}}),X=new $({props:{title:"CommonJS",local:"commonjs",headingTag:"h3"}}),V=new f({props:{code:"Y29uc3QlMjBodHRwJTIwJTNEJTIwcmVxdWlyZSgnaHR0cCcpJTNCJTBBY29uc3QlMjBxdWVyeXN0cmluZyUyMCUzRCUyMHJlcXVpcmUoJ3F1ZXJ5c3RyaW5nJyklM0IlMEFjb25zdCUyMHVybCUyMCUzRCUyMHJlcXVpcmUoJ3VybCcpJTNC",highlighted:`<span class="hljs-keyword">const</span> http = <span class="hljs-built_in">require</span>(<span class="hljs-string">&#x27;http&#x27;</span>);
<span class="hljs-keyword">const</span> querystring = <span class="hljs-built_in">require</span>(<span class="hljs-string">&#x27;querystring&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-built_in">require</span>(<span class="hljs-string">&#x27;url&#x27;</span>);`,wrap:!1}}),F=new f({props:{code:"Y2xhc3MlMjBNeUNsYXNzaWZpY2F0aW9uUGlwZWxpbmUlMjAlN0IlMEElMjAlMjBzdGF0aWMlMjB0YXNrJTIwJTNEJTIwJ3RleHQtY2xhc3NpZmljYXRpb24nJTNCJTBBJTIwJTIwc3RhdGljJTIwbW9kZWwlMjAlM0QlMjAnWGVub3ZhJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnJTNCJTBBJTIwJTIwc3RhdGljJTIwaW5zdGFuY2UlMjAlM0QlMjBudWxsJTNCJTBBJTBBJTIwJTIwc3RhdGljJTIwYXN5bmMlMjBnZXRJbnN0YW5jZShwcm9ncmVzc19jYWxsYmFjayUyMCUzRCUyMG51bGwpJTIwJTdCJTBBJTIwJTIwJTIwJTIwaWYlMjAodGhpcy5pbnN0YW5jZSUyMCUzRCUzRCUzRCUyMG51bGwpJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTJGJTIwRHluYW1pY2FsbHklMjBpbXBvcnQlMjB0aGUlMjBUcmFuc2Zvcm1lcnMuanMlMjBsaWJyYXJ5JTBBJTIwJTIwJTIwJTIwJTIwJTIwbGV0JTIwJTdCJTIwcGlwZWxpbmUlMkMlMjBlbnYlMjAlN0QlMjAlM0QlMjBhd2FpdCUyMGltcG9ydCgnJTQweGVub3ZhJTJGdHJhbnNmb3JtZXJzJyklM0IlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMkYlMkYlMjBOT1RFJTNBJTIwVW5jb21tZW50JTIwdGhpcyUyMHRvJTIwY2hhbmdlJTIwdGhlJTIwY2FjaGUlMjBkaXJlY3RvcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMkYlMkYlMjBlbnYuY2FjaGVEaXIlMjAlM0QlMjAnLiUyRi5jYWNoZSclM0IlMEElMEElMjAlMjAlMjAlMjAlMjAlMjB0aGlzLmluc3RhbmNlJTIwJTNEJTIwcGlwZWxpbmUodGhpcy50YXNrJTJDJTIwdGhpcy5tb2RlbCUyQyUyMCU3QiUyMHByb2dyZXNzX2NhbGxiYWNrJTIwJTdEKSUzQiUwQSUyMCUyMCUyMCUyMCU3RCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRoaXMuaW5zdGFuY2UlM0IlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyClassificationPipeline</span> {
  <span class="hljs-keyword">static</span> task = <span class="hljs-string">&#x27;text-classification&#x27;</span>;
  <span class="hljs-keyword">static</span> model = <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>;
  <span class="hljs-keyword">static</span> instance = <span class="hljs-literal">null</span>;

  <span class="hljs-keyword">static</span> <span class="hljs-keyword">async</span> <span class="hljs-title function_">getInstance</span>(<span class="hljs-params">progress_callback = <span class="hljs-literal">null</span></span>) {
    <span class="hljs-keyword">if</span> (<span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> === <span class="hljs-literal">null</span>) {
      <span class="hljs-comment">// Dynamically import the Transformers.js library</span>
      <span class="hljs-keyword">let</span> { pipeline, env } = <span class="hljs-keyword">await</span> <span class="hljs-keyword">import</span>(<span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>);

      <span class="hljs-comment">// <span class="hljs-doctag">NOTE:</span> Uncomment this to change the cache directory</span>
      <span class="hljs-comment">// env.cacheDir = &#x27;./.cache&#x27;;</span>

      <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> = <span class="hljs-title function_">pipeline</span>(<span class="hljs-variable language_">this</span>.<span class="hljs-property">task</span>, <span class="hljs-variable language_">this</span>.<span class="hljs-property">model</span>, { progress_callback });
    }

    <span class="hljs-keyword">return</span> <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span>;
  }
}`,wrap:!1}}),q=new $({props:{title:"Creating a basic HTTP server",local:"creating-a-basic-http-server",headingTag:"h2"}}),D=new f({props:{code:"JTJGJTJGJTIwRGVmaW5lJTIwdGhlJTIwSFRUUCUyMHNlcnZlciUwQWNvbnN0JTIwc2VydmVyJTIwJTNEJTIwaHR0cC5jcmVhdGVTZXJ2ZXIoKSUzQiUwQWNvbnN0JTIwaG9zdG5hbWUlMjAlM0QlMjAnMTI3LjAuMC4xJyUzQiUwQWNvbnN0JTIwcG9ydCUyMCUzRCUyMDMwMDAlM0IlMEElMEElMkYlMkYlMjBMaXN0ZW4lMjBmb3IlMjByZXF1ZXN0cyUyMG1hZGUlMjB0byUyMHRoZSUyMHNlcnZlciUwQXNlcnZlci5vbigncmVxdWVzdCclMkMlMjBhc3luYyUyMChyZXElMkMlMjByZXMpJTIwJTNEJTNFJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwUGFyc2UlMjB0aGUlMjByZXF1ZXN0JTIwVVJMJTBBJTIwJTIwY29uc3QlMjBwYXJzZWRVcmwlMjAlM0QlMjB1cmwucGFyc2UocmVxLnVybCklM0IlMEElMEElMjAlMjAlMkYlMkYlMjBFeHRyYWN0JTIwdGhlJTIwcXVlcnklMjBwYXJhbWV0ZXJzJTBBJTIwJTIwY29uc3QlMjAlN0IlMjB0ZXh0JTIwJTdEJTIwJTNEJTIwcXVlcnlzdHJpbmcucGFyc2UocGFyc2VkVXJsLnF1ZXJ5KSUzQiUwQSUwQSUyMCUyMCUyRiUyRiUyMFNldCUyMHRoZSUyMHJlc3BvbnNlJTIwaGVhZGVycyUwQSUyMCUyMHJlcy5zZXRIZWFkZXIoJ0NvbnRlbnQtVHlwZSclMkMlMjAnYXBwbGljYXRpb24lMkZqc29uJyklM0IlMEElMEElMjAlMjBsZXQlMjByZXNwb25zZSUzQiUwQSUyMCUyMGlmJTIwKHBhcnNlZFVybC5wYXRobmFtZSUyMCUzRCUzRCUzRCUyMCclMkZjbGFzc2lmeSclMjAlMjYlMjYlMjB0ZXh0KSUyMCU3QiUwQSUyMCUyMCUyMCUyMGNvbnN0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwTXlDbGFzc2lmaWNhdGlvblBpcGVsaW5lLmdldEluc3RhbmNlKCklM0IlMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih0ZXh0KSUzQiUwQSUyMCUyMCUyMCUyMHJlcy5zdGF0dXNDb2RlJTIwJTNEJTIwMjAwJTNCJTBBJTIwJTIwJTdEJTIwZWxzZSUyMCU3QiUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwJTdCJTIwJ2Vycm9yJyUzQSUyMCdCYWQlMjByZXF1ZXN0JyUyMCU3RCUwQSUyMCUyMCUyMCUyMHJlcy5zdGF0dXNDb2RlJTIwJTNEJTIwNDAwJTNCJTBBJTIwJTIwJTdEJTBBJTBBJTIwJTIwJTJGJTJGJTIwU2VuZCUyMHRoZSUyMEpTT04lMjByZXNwb25zZSUwQSUyMCUyMHJlcy5lbmQoSlNPTi5zdHJpbmdpZnkocmVzcG9uc2UpKSUzQiUwQSU3RCklM0IlMEElMEFzZXJ2ZXIubGlzdGVuKHBvcnQlMkMlMjBob3N0bmFtZSUyQyUyMCgpJTIwJTNEJTNFJTIwJTdCJTBBJTIwJTIwY29uc29sZS5sb2coJTYwU2VydmVyJTIwcnVubmluZyUyMGF0JTIwaHR0cCUzQSUyRiUyRiUyNCU3Qmhvc3RuYW1lJTdEJTNBJTI0JTdCcG9ydCU3RCUyRiU2MCklM0IlMEElN0QpJTNCJTBB",highlighted:`<span class="hljs-comment">// Define the HTTP server</span>
<span class="hljs-keyword">const</span> server = http.<span class="hljs-title function_">createServer</span>();
<span class="hljs-keyword">const</span> hostname = <span class="hljs-string">&#x27;127.0.0.1&#x27;</span>;
<span class="hljs-keyword">const</span> port = <span class="hljs-number">3000</span>;

<span class="hljs-comment">// Listen for requests made to the server</span>
server.<span class="hljs-title function_">on</span>(<span class="hljs-string">&#x27;request&#x27;</span>, <span class="hljs-keyword">async</span> (req, res) =&gt; {
  <span class="hljs-comment">// Parse the request URL</span>
  <span class="hljs-keyword">const</span> parsedUrl = url.<span class="hljs-title function_">parse</span>(req.<span class="hljs-property">url</span>);

  <span class="hljs-comment">// Extract the query parameters</span>
  <span class="hljs-keyword">const</span> { text } = querystring.<span class="hljs-title function_">parse</span>(parsedUrl.<span class="hljs-property">query</span>);

  <span class="hljs-comment">// Set the response headers</span>
  res.<span class="hljs-title function_">setHeader</span>(<span class="hljs-string">&#x27;Content-Type&#x27;</span>, <span class="hljs-string">&#x27;application/json&#x27;</span>);

  <span class="hljs-keyword">let</span> response;
  <span class="hljs-keyword">if</span> (parsedUrl.<span class="hljs-property">pathname</span> === <span class="hljs-string">&#x27;/classify&#x27;</span> &amp;&amp; text) {
    <span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title class_">MyClassificationPipeline</span>.<span class="hljs-title function_">getInstance</span>();
    response = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text);
    res.<span class="hljs-property">statusCode</span> = <span class="hljs-number">200</span>;
  } <span class="hljs-keyword">else</span> {
    response = { <span class="hljs-string">&#x27;error&#x27;</span>: <span class="hljs-string">&#x27;Bad request&#x27;</span> }
    res.<span class="hljs-property">statusCode</span> = <span class="hljs-number">400</span>;
  }

  <span class="hljs-comment">// Send the JSON response</span>
  res.<span class="hljs-title function_">end</span>(<span class="hljs-title class_">JSON</span>.<span class="hljs-title function_">stringify</span>(response));
});

server.<span class="hljs-title function_">listen</span>(port, hostname, <span class="hljs-function">() =&gt;</span> {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">\`Server running at http://<span class="hljs-subst">\${hostname}</span>:<span class="hljs-subst">\${port}</span>/\`</span>);
});
`,wrap:!1}}),C=new Be({props:{$$slots:{default:[_e]},$$scope:{ctx:ys}}}),O=new f({props:{code:"bm9kZSUyMGFwcC5qcw==",highlighted:"node app.js",wrap:!1}}),es=new f({props:{code:"JTdCJTIyZXJyb3IlMjIlM0ElMjJCYWQlMjByZXF1ZXN0JTIyJTdE",highlighted:'<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;error&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;Bad request&quot;</span><span class="hljs-punctuation">}</span>',wrap:!1}}),ts=new f({props:{code:"JTVCJTdCJTIybGFiZWwlMjIlM0ElMjJQT1NJVElWRSUyMiUyQyUyMnNjb3JlJTIyJTNBMC45OTk2NzIxMTQ4NDkwOTA2JTdEJTVE",highlighted:'<span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;label&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;POSITIVE&quot;</span><span class="hljs-punctuation">,</span><span class="hljs-attr">&quot;score&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-number">0.9996721148490906</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span>',wrap:!1}}),ns=new $({props:{title:"(Optional) Customization",local:"optional-customization",headingTag:"h2"}}),ps=new $({props:{title:"Model caching",local:"model-caching",headingTag:"h3"}}),rs=new f({props:{code:"ZW52LmNhY2hlRGlyJTIwJTNEJTIwJy4lMkYuY2FjaGUnJTNC",highlighted:'env.<span class="hljs-property">cacheDir</span> = <span class="hljs-string">&#x27;./.cache&#x27;</span>;',wrap:!1}}),os=new $({props:{title:"Use local models",local:"use-local-models",headingTag:"h3"}}),Ms=new f({props:{code:"JTJGJTJGJTIwU3BlY2lmeSUyMGElMjBjdXN0b20lMjBsb2NhdGlvbiUyMGZvciUyMG1vZGVscyUyMChkZWZhdWx0cyUyMHRvJTIwJyUyRm1vZGVscyUyRicpLiUwQWVudi5sb2NhbE1vZGVsUGF0aCUyMCUzRCUyMCclMkZwYXRoJTJGdG8lMkZtb2RlbHMlMkYnJTNC",highlighted:`<span class="hljs-comment">// Specify a custom location for models (defaults to &#x27;/models/&#x27;).</span>
env.<span class="hljs-property">localModelPath</span> = <span class="hljs-string">&#x27;/path/to/models/&#x27;</span>;`,wrap:!1}}),ms=new f({props:{code:"JTJGJTJGJTIwRGlzYWJsZSUyMHRoZSUyMGxvYWRpbmclMjBvZiUyMHJlbW90ZSUyMG1vZGVscyUyMGZyb20lMjB0aGUlMjBIdWdnaW5nJTIwRmFjZSUyMEh1YiUzQSUwQWVudi5hbGxvd1JlbW90ZU1vZGVscyUyMCUzRCUyMGZhbHNlJTNC",highlighted:`<span class="hljs-comment">// Disable the loading of remote models from the Hugging Face Hub:</span>
env.<span class="hljs-property">allowRemoteModels</span> = <span class="hljs-literal">false</span>;`,wrap:!1}}),{c(){r=p("meta"),U=a(),u=p("p"),w=a(),o(T.$$.fragment),d=a(),J=p("p"),J.textContent=re,ds=a(),g=p("p"),g.textContent=oe,us=a(),I=p("ul"),I.innerHTML=ce,ws=a(),o(b.$$.fragment),fs=a(),v=p("p"),v.innerHTML=Me,Ts=a(),x=p("ul"),x.innerHTML=he,Js=a(),o(N.$$.fragment),Us=a(),G=p("ul"),G.innerHTML=me,$s=a(),o(k.$$.fragment),bs=a(),Z=p("p"),Z.innerHTML=ye,Cs=a(),o(B.$$.fragment),gs=a(),E=p("p"),E.innerHTML=je,Is=a(),H=p("p"),H.innerHTML=de,vs=a(),o(S.$$.fragment),xs=a(),R=p("p"),R.innerHTML=ue,Ns=a(),o(Y.$$.fragment),Gs=a(),W=p("p"),W.innerHTML=we,ks=a(),o(A.$$.fragment),Zs=a(),z=p("p"),z.innerHTML=fe,Bs=a(),o(_.$$.fragment),Es=a(),o(X.$$.fragment),Hs=a(),Q=p("p"),Q.innerHTML=Te,Ss=a(),o(V.$$.fragment),Rs=a(),L=p("p"),L.innerHTML=Je,Ys=a(),o(F.$$.fragment),Ws=a(),o(q.$$.fragment),As=a(),P=p("p"),P.innerHTML=Ue,zs=a(),o(D.$$.fragment),_s=a(),o(C.$$.fragment),Xs=a(),K=p("p"),K.textContent=$e,Qs=a(),o(O.$$.fragment),Vs=a(),ss=p("p"),ss.innerHTML=be,Ls=a(),o(es.$$.fragment),Fs=a(),ls=p("p"),ls.innerHTML=Ce,qs=a(),o(ts.$$.fragment),Ps=a(),as=p("p"),as.textContent=ge,Ds=a(),o(ns.$$.fragment),Ks=a(),o(ps.$$.fragment),Os=a(),is=p("p"),is.innerHTML=Ie,se=a(),o(rs.$$.fragment),ee=a(),o(os.$$.fragment),le=a(),cs=p("p"),cs.innerHTML=ve,te=a(),o(Ms.$$.fragment),ae=a(),hs=p("p"),hs.innerHTML=xe,ne=a(),o(ms.$$.fragment),pe=a(),js=p("p"),this.h()},l(s){const e=We("svelte-u9bgzb",document.head);r=i(e,"META",{name:!0,content:!0}),e.forEach(l),U=n(s),u=i(s,"P",{}),ke(u).forEach(l),w=n(s),c(T.$$.fragment,s),d=n(s),J=i(s,"P",{"data-svelte-h":!0}),j(J)!=="svelte-vfkn35"&&(J.textContent=re),ds=n(s),g=i(s,"P",{"data-svelte-h":!0}),j(g)!=="svelte-a8f7x7"&&(g.textContent=oe),us=n(s),I=i(s,"UL",{"data-svelte-h":!0}),j(I)!=="svelte-9qlumf"&&(I.innerHTML=ce),ws=n(s),c(b.$$.fragment,s),fs=n(s),v=i(s,"P",{"data-svelte-h":!0}),j(v)!=="svelte-1kriz5m"&&(v.innerHTML=Me),Ts=n(s),x=i(s,"UL",{"data-svelte-h":!0}),j(x)!=="svelte-1jbtrzy"&&(x.innerHTML=he),Js=n(s),c(N.$$.fragment,s),Us=n(s),G=i(s,"UL",{"data-svelte-h":!0}),j(G)!=="svelte-1qy4daj"&&(G.innerHTML=me),$s=n(s),c(k.$$.fragment,s),bs=n(s),Z=i(s,"P",{"data-svelte-h":!0}),j(Z)!=="svelte-1w613qw"&&(Z.innerHTML=ye),Cs=n(s),c(B.$$.fragment,s),gs=n(s),E=i(s,"P",{"data-svelte-h":!0}),j(E)!=="svelte-7flmsa"&&(E.innerHTML=je),Is=n(s),H=i(s,"P",{"data-svelte-h":!0}),j(H)!=="svelte-1dmzt6g"&&(H.innerHTML=de),vs=n(s),c(S.$$.fragment,s),xs=n(s),R=i(s,"P",{"data-svelte-h":!0}),j(R)!=="svelte-nul6wy"&&(R.innerHTML=ue),Ns=n(s),c(Y.$$.fragment,s),Gs=n(s),W=i(s,"P",{"data-svelte-h":!0}),j(W)!=="svelte-44hxyv"&&(W.innerHTML=we),ks=n(s),c(A.$$.fragment,s),Zs=n(s),z=i(s,"P",{"data-svelte-h":!0}),j(z)!=="svelte-1va2gp1"&&(z.innerHTML=fe),Bs=n(s),c(_.$$.fragment,s),Es=n(s),c(X.$$.fragment,s),Hs=n(s),Q=i(s,"P",{"data-svelte-h":!0}),j(Q)!=="svelte-1nm1y09"&&(Q.innerHTML=Te),Ss=n(s),c(V.$$.fragment,s),Rs=n(s),L=i(s,"P",{"data-svelte-h":!0}),j(L)!=="svelte-1qn48sh"&&(L.innerHTML=Je),Ys=n(s),c(F.$$.fragment,s),Ws=n(s),c(q.$$.fragment,s),As=n(s),P=i(s,"P",{"data-svelte-h":!0}),j(P)!=="svelte-aklufa"&&(P.innerHTML=Ue),zs=n(s),c(D.$$.fragment,s),_s=n(s),c(C.$$.fragment,s),Xs=n(s),K=i(s,"P",{"data-svelte-h":!0}),j(K)!=="svelte-1orujzn"&&(K.textContent=$e),Qs=n(s),c(O.$$.fragment,s),Vs=n(s),ss=i(s,"P",{"data-svelte-h":!0}),j(ss)!=="svelte-52uecr"&&(ss.innerHTML=be),Ls=n(s),c(es.$$.fragment,s),Fs=n(s),ls=i(s,"P",{"data-svelte-h":!0}),j(ls)!=="svelte-tmlcgt"&&(ls.innerHTML=Ce),qs=n(s),c(ts.$$.fragment,s),Ps=n(s),as=i(s,"P",{"data-svelte-h":!0}),j(as)!=="svelte-xomwwl"&&(as.textContent=ge),Ds=n(s),c(ns.$$.fragment,s),Ks=n(s),c(ps.$$.fragment,s),Os=n(s),is=i(s,"P",{"data-svelte-h":!0}),j(is)!=="svelte-znv5ud"&&(is.innerHTML=Ie),se=n(s),c(rs.$$.fragment,s),ee=n(s),c(os.$$.fragment,s),le=n(s),cs=i(s,"P",{"data-svelte-h":!0}),j(cs)!=="svelte-tw138n"&&(cs.innerHTML=ve),te=n(s),c(Ms.$$.fragment,s),ae=n(s),hs=i(s,"P",{"data-svelte-h":!0}),j(hs)!=="svelte-1tbr80q"&&(hs.innerHTML=xe),ne=n(s),c(ms.$$.fragment,s),pe=n(s),js=i(s,"P",{}),ke(js).forEach(l),this.h()},h(){Ze(r,"name","hf:doc:metadata"),Ze(r,"content",Qe)},m(s,e){Ae(document.head,r),t(s,U,e),t(s,u,e),t(s,w,e),M(T,s,e),t(s,d,e),t(s,J,e),t(s,ds,e),t(s,g,e),t(s,us,e),t(s,I,e),t(s,ws,e),M(b,s,e),t(s,fs,e),t(s,v,e),t(s,Ts,e),t(s,x,e),t(s,Js,e),M(N,s,e),t(s,Us,e),t(s,G,e),t(s,$s,e),M(k,s,e),t(s,bs,e),t(s,Z,e),t(s,Cs,e),M(B,s,e),t(s,gs,e),t(s,E,e),t(s,Is,e),t(s,H,e),t(s,vs,e),M(S,s,e),t(s,xs,e),t(s,R,e),t(s,Ns,e),M(Y,s,e),t(s,Gs,e),t(s,W,e),t(s,ks,e),M(A,s,e),t(s,Zs,e),t(s,z,e),t(s,Bs,e),M(_,s,e),t(s,Es,e),M(X,s,e),t(s,Hs,e),t(s,Q,e),t(s,Ss,e),M(V,s,e),t(s,Rs,e),t(s,L,e),t(s,Ys,e),M(F,s,e),t(s,Ws,e),M(q,s,e),t(s,As,e),t(s,P,e),t(s,zs,e),M(D,s,e),t(s,_s,e),M(C,s,e),t(s,Xs,e),t(s,K,e),t(s,Qs,e),M(O,s,e),t(s,Vs,e),t(s,ss,e),t(s,Ls,e),M(es,s,e),t(s,Fs,e),t(s,ls,e),t(s,qs,e),M(ts,s,e),t(s,Ps,e),t(s,as,e),t(s,Ds,e),M(ns,s,e),t(s,Ks,e),M(ps,s,e),t(s,Os,e),t(s,is,e),t(s,se,e),M(rs,s,e),t(s,ee,e),M(os,s,e),t(s,le,e),t(s,cs,e),t(s,te,e),M(Ms,s,e),t(s,ae,e),t(s,hs,e),t(s,ne,e),M(ms,s,e),t(s,pe,e),t(s,js,e),ie=!0},p(s,[e]){const Ne={};e&2&&(Ne.$$scope={dirty:e,ctx:s}),b.$set(Ne);const Ge={};e&2&&(Ge.$$scope={dirty:e,ctx:s}),C.$set(Ge)},i(s){ie||(h(T.$$.fragment,s),h(b.$$.fragment,s),h(N.$$.fragment,s),h(k.$$.fragment,s),h(B.$$.fragment,s),h(S.$$.fragment,s),h(Y.$$.fragment,s),h(A.$$.fragment,s),h(_.$$.fragment,s),h(X.$$.fragment,s),h(V.$$.fragment,s),h(F.$$.fragment,s),h(q.$$.fragment,s),h(D.$$.fragment,s),h(C.$$.fragment,s),h(O.$$.fragment,s),h(es.$$.fragment,s),h(ts.$$.fragment,s),h(ns.$$.fragment,s),h(ps.$$.fragment,s),h(rs.$$.fragment,s),h(os.$$.fragment,s),h(Ms.$$.fragment,s),h(ms.$$.fragment,s),ie=!0)},o(s){m(T.$$.fragment,s),m(b.$$.fragment,s),m(N.$$.fragment,s),m(k.$$.fragment,s),m(B.$$.fragment,s),m(S.$$.fragment,s),m(Y.$$.fragment,s),m(A.$$.fragment,s),m(_.$$.fragment,s),m(X.$$.fragment,s),m(V.$$.fragment,s),m(F.$$.fragment,s),m(q.$$.fragment,s),m(D.$$.fragment,s),m(C.$$.fragment,s),m(O.$$.fragment,s),m(es.$$.fragment,s),m(ts.$$.fragment,s),m(ns.$$.fragment,s),m(ps.$$.fragment,s),m(rs.$$.fragment,s),m(os.$$.fragment,s),m(Ms.$$.fragment,s),m(ms.$$.fragment,s),ie=!1},d(s){s&&(l(U),l(u),l(w),l(d),l(J),l(ds),l(g),l(us),l(I),l(ws),l(fs),l(v),l(Ts),l(x),l(Js),l(Us),l(G),l($s),l(bs),l(Z),l(Cs),l(gs),l(E),l(Is),l(H),l(vs),l(xs),l(R),l(Ns),l(Gs),l(W),l(ks),l(Zs),l(z),l(Bs),l(Es),l(Hs),l(Q),l(Ss),l(Rs),l(L),l(Ys),l(Ws),l(As),l(P),l(zs),l(_s),l(Xs),l(K),l(Qs),l(Vs),l(ss),l(Ls),l(Fs),l(ls),l(qs),l(Ps),l(as),l(Ds),l(Ks),l(Os),l(is),l(se),l(ee),l(le),l(cs),l(te),l(ae),l(hs),l(ne),l(pe),l(js)),l(r),y(T,s),y(b,s),y(N,s),y(k,s),y(B,s),y(S,s),y(Y,s),y(A,s),y(_,s),y(X,s),y(V,s),y(F,s),y(q,s),y(D,s),y(C,s),y(O,s),y(es,s),y(ts,s),y(ns,s),y(ps,s),y(rs,s),y(os,s),y(Ms,s),y(ms,s)}}}const Qe='{"title":"Server-side Inference in Node.js","local":"server-side-inference-in-nodejs","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Getting started","local":"getting-started","sections":[{"title":"ECMAScript modules (ESM)","local":"ecmascript-modules-esm","sections":[],"depth":3},{"title":"CommonJS","local":"commonjs","sections":[],"depth":3}],"depth":2},{"title":"Creating a basic HTTP server","local":"creating-a-basic-http-server","sections":[],"depth":2},{"title":"(Optional) Customization","local":"optional-customization","sections":[{"title":"Model caching","local":"model-caching","sections":[],"depth":3},{"title":"Use local models","local":"use-local-models","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ve(ys){return Se(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ke extends Re{constructor(r){super(),Ye(this,r,Ve,Xe,He,{})}}export{Ke as component};
