import{s as Ve,o as Ee,n as Se}from"../chunks/scheduler.b108d059.js";import{S as Fe,i as Le,g as o,s as a,r as m,A as ze,h as p,f as t,c as n,j as Ae,u as h,x as c,k as He,y as Pe,a as l,v as w,d,t as u,w as f}from"../chunks/index.008de539.js";import{T as Qe}from"../chunks/Tip.aeb15ab7.js";import{C as F}from"../chunks/CodeBlock.3968c746.js";import{H as Ue}from"../chunks/Heading.88bfeb84.js";function De(L){let i,j='This tutorial will be written as an ES module, but you can easily adapt it to use CommonJS instead. For more information, see the <a href="https://huggingface.co/docs/transformers.js/tutorials/node" rel="nofollow">node tutorial</a>.';return{c(){i=o("p"),i.innerHTML=j},l(r){i=p(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-19bu2gi"&&(i.innerHTML=j)},m(r,M){l(r,i,M)},p:Se,d(r){r&&t(i)}}}function qe(L){let i,j="Remember to add <code>&quot;type&quot;: &quot;module&quot;</code> to your <code>package.json</code> to indicate that your project uses ECMAScript modules.";return{c(){i=o("p"),i.innerHTML=j},l(r){i=p(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1hk65wu"&&(i.innerHTML=j)},m(r,M){l(r,i,M)},p:Se,d(r){r&&t(i)}}}function Ke(L){let i,j,r,M,J,P,b,$e='A major benefit of writing code for the web is that you can access the multitude of APIs that are available in modern browsers. Unfortunately, when writing server-side code, we are not afforded such luxury, so we have to find another way. In this tutorial, we will design a simple Node.js application that uses Transformers.js for speech recognition with <a href="https://huggingface.co/Xenova/whisper-tiny.en" rel="nofollow">Whisper</a>, and in the process, learn how to process audio on the server.',D,U,ve='The main problem we need to solve is that the <a href="https://developer.mozilla.org/en-US/docs/Web/API/Web_Audio_API" rel="nofollow">Web Audio API</a> is not available in Node.js, meaning we can’t use the <a href="https://developer.mozilla.org/en-US/docs/Web/API/AudioContext" rel="nofollow"><code>AudioContext</code></a> class to process audio. So, we will need to install third-party libraries to obtain the raw audio data. For this example, we will only consider <code>.wav</code> files, but the same principles apply to other audio formats.',q,T,K,$,Ie="<strong>Useful links:</strong>",O,v,ge='<li><a href="https://github.com/xenova/transformers.js/tree/main/examples/node-audio-processing" rel="nofollow">Source code</a></li> <li><a href="https://huggingface.co/docs/transformers.js" rel="nofollow">Documentation</a></li>',ee,I,se,g,Ce='<li><a href="https://nodejs.org/en/" rel="nofollow">Node.js</a> version 18+</li> <li><a href="https://www.npmjs.com/" rel="nofollow">npm</a> version 9+</li>',te,C,le,k,ke='Let’s start by creating a new Node.js project and installing Transformers.js via <a href="https://www.npmjs.com/package/@xenova/transformers" rel="nofollow">NPM</a>:',ae,B,ne,y,ie,Z,Be='Next, let’s install the <a href="https://www.npmjs.com/package/wavefile" rel="nofollow"><code>wavefile</code></a> package, which we will use for loading <code>.wav</code> files:',oe,x,pe,G,re,W,Ze="Start by creating a new file called <code>index.js</code>, which will be the entry point for our application. Let’s also import the necessary modules:",ce,_,me,N,xe='For this tutorial, we will use the <code>Xenova/whisper-tiny.en</code> model, but feel free to choose one of the other whisper models from the <a href="https://huggingface.co/models?library=transformers.js&amp;search=whisper" rel="nofollow">Hugging Face Hub</a>. Let’s create our pipeline with:',he,R,we,Y,Ge="Next, let’s load an audio file and convert it to the format required by Transformers.js:",de,X,ue,A,We="Finally, let’s run the model and measure execution duration.",fe,H,je,Q,_e="You can now run the application with <code>node index.js</code>. Note that when running the script for the first time, it may take a while to download and cache the model. Subsequent requests will use the cached model, and model loading will be much faster.",Me,S,Ne="You should see output similar to:",Te,V,ye,E,Re="That’s it! You’ve successfully created a Node.js application that uses Transformers.js for speech recognition with Whisper. You can now use this as a starting point for your own applications.",Je,z,be;return J=new Ue({props:{title:"Server-side Audio Processing in Node.js",local:"server-side-audio-processing-in-nodejs",headingTag:"h1"}}),T=new Qe({props:{$$slots:{default:[De]},$$scope:{ctx:L}}}),I=new Ue({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),C=new Ue({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),B=new F({props:{code:"bnBtJTIwaW5pdCUyMC15JTBBbnBtJTIwaSUyMCU0MHhlbm92YSUyRnRyYW5zZm9ybWVycw==",highlighted:`npm init -y
npm i @xenova/transformers`,wrap:!1}}),y=new Qe({props:{$$slots:{default:[qe]},$$scope:{ctx:L}}}),x=new F({props:{code:"bnBtJTIwaSUyMHdhdmVmaWxl",highlighted:"npm i wavefile",wrap:!1}}),G=new Ue({props:{title:"Creating the application",local:"creating-the-application",headingTag:"h2"}}),_=new F({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEFpbXBvcnQlMjB3YXZlZmlsZSUyMGZyb20lMjAnd2F2ZWZpbGUnJTNC",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;
<span class="hljs-keyword">import</span> wavefile <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;wavefile&#x27;</span>;`,wrap:!1}}),R=new F({props:{code:"bGV0JTIwdHJhbnNjcmliZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJyUyQyUyMCdYZW5vdmElMkZ3aGlzcGVyLXRpbnkuZW4nKSUzQg==",highlighted:'<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);',wrap:!1}}),X=new F({props:{code:"JTJGJTJGJTIwTG9hZCUyMGF1ZGlvJTIwZGF0YSUwQWxldCUyMHVybCUyMCUzRCUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZYZW5vdmElMkZ0cmFuc2Zvcm1lcnMuanMtZG9jcyUyRnJlc29sdmUlMkZtYWluJTJGamZrLndhdiclM0IlMEFsZXQlMjBidWZmZXIlMjAlM0QlMjBCdWZmZXIuZnJvbShhd2FpdCUyMGZldGNoKHVybCkudGhlbih4JTIwJTNEJTNFJTIweC5hcnJheUJ1ZmZlcigpKSklMEElMEElMkYlMkYlMjBSZWFkJTIwLndhdiUyMGZpbGUlMjBhbmQlMjBjb252ZXJ0JTIwaXQlMjB0byUyMHJlcXVpcmVkJTIwZm9ybWF0JTBBbGV0JTIwd2F2JTIwJTNEJTIwbmV3JTIwd2F2ZWZpbGUuV2F2ZUZpbGUoYnVmZmVyKSUzQiUwQXdhdi50b0JpdERlcHRoKCczMmYnKSUzQiUyMCUyRiUyRiUyMFBpcGVsaW5lJTIwZXhwZWN0cyUyMGlucHV0JTIwYXMlMjBhJTIwRmxvYXQzMkFycmF5JTBBd2F2LnRvU2FtcGxlUmF0ZSgxNjAwMCklM0IlMjAlMkYlMkYlMjBXaGlzcGVyJTIwZXhwZWN0cyUyMGF1ZGlvJTIwd2l0aCUyMGElMjBzYW1wbGluZyUyMHJhdGUlMjBvZiUyMDE2MDAwJTBBbGV0JTIwYXVkaW9EYXRhJTIwJTNEJTIwd2F2LmdldFNhbXBsZXMoKSUzQiUwQWlmJTIwKEFycmF5LmlzQXJyYXkoYXVkaW9EYXRhKSklMjAlN0IlMEElMjAlMjBpZiUyMChhdWRpb0RhdGEubGVuZ3RoJTIwJTNFJTIwMSklMjAlN0IlMEElMjAlMjAlMjAlMjBjb25zdCUyMFNDQUxJTkdfRkFDVE9SJTIwJTNEJTIwTWF0aC5zcXJ0KDIpJTNCJTBBJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwTWVyZ2UlMjBjaGFubmVscyUyMChpbnRvJTIwZmlyc3QlMjBjaGFubmVsJTIwdG8lMjBzYXZlJTIwbWVtb3J5KSUwQSUyMCUyMCUyMCUyMGZvciUyMChsZXQlMjBpJTIwJTNEJTIwMCUzQiUyMGklMjAlM0MlMjBhdWRpb0RhdGElNUIwJTVELmxlbmd0aCUzQiUyMCUyQiUyQmkpJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9EYXRhJTVCMCU1RCU1QmklNUQlMjAlM0QlMjBTQ0FMSU5HX0ZBQ1RPUiUyMColMjAoYXVkaW9EYXRhJTVCMCU1RCU1QmklNUQlMjAlMkIlMjBhdWRpb0RhdGElNUIxJTVEJTVCaSU1RCklMjAlMkYlMjAyJTNCJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTBBJTIwJTIwJTJGJTJGJTIwU2VsZWN0JTIwZmlyc3QlMjBjaGFubmVsJTBBJTIwJTIwYXVkaW9EYXRhJTIwJTNEJTIwYXVkaW9EYXRhJTVCMCU1RCUzQiUwQSU3RA==",highlighted:`<span class="hljs-comment">// Load audio data</span>
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> buffer = <span class="hljs-title class_">Buffer</span>.<span class="hljs-title function_">from</span>(<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(url).<span class="hljs-title function_">then</span>(<span class="hljs-function"><span class="hljs-params">x</span> =&gt;</span> x.<span class="hljs-title function_">arrayBuffer</span>()))

<span class="hljs-comment">// Read .wav file and convert it to required format</span>
<span class="hljs-keyword">let</span> wav = <span class="hljs-keyword">new</span> wavefile.<span class="hljs-title class_">WaveFile</span>(buffer);
wav.<span class="hljs-title function_">toBitDepth</span>(<span class="hljs-string">&#x27;32f&#x27;</span>); <span class="hljs-comment">// Pipeline expects input as a Float32Array</span>
wav.<span class="hljs-title function_">toSampleRate</span>(<span class="hljs-number">16000</span>); <span class="hljs-comment">// Whisper expects audio with a sampling rate of 16000</span>
<span class="hljs-keyword">let</span> audioData = wav.<span class="hljs-title function_">getSamples</span>();
<span class="hljs-keyword">if</span> (<span class="hljs-title class_">Array</span>.<span class="hljs-title function_">isArray</span>(audioData)) {
  <span class="hljs-keyword">if</span> (audioData.<span class="hljs-property">length</span> &gt; <span class="hljs-number">1</span>) {
    <span class="hljs-keyword">const</span> <span class="hljs-variable constant_">SCALING_FACTOR</span> = <span class="hljs-title class_">Math</span>.<span class="hljs-title function_">sqrt</span>(<span class="hljs-number">2</span>);

    <span class="hljs-comment">// Merge channels (into first channel to save memory)</span>
    <span class="hljs-keyword">for</span> (<span class="hljs-keyword">let</span> i = <span class="hljs-number">0</span>; i &lt; audioData[<span class="hljs-number">0</span>].<span class="hljs-property">length</span>; ++i) {
      audioData[<span class="hljs-number">0</span>][i] = <span class="hljs-variable constant_">SCALING_FACTOR</span> * (audioData[<span class="hljs-number">0</span>][i] + audioData[<span class="hljs-number">1</span>][i]) / <span class="hljs-number">2</span>;
    }
  }

  <span class="hljs-comment">// Select first channel</span>
  audioData = audioData[<span class="hljs-number">0</span>];
}`,wrap:!1}}),H=new F({props:{code:"bGV0JTIwc3RhcnQlMjAlM0QlMjBwZXJmb3JtYW5jZS5ub3coKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwdHJhbnNjcmliZXIoYXVkaW9EYXRhKSUzQiUwQWxldCUyMGVuZCUyMCUzRCUyMHBlcmZvcm1hbmNlLm5vdygpJTNCJTBBY29uc29sZS5sb2coJTYwRXhlY3V0aW9uJTIwZHVyYXRpb24lM0ElMjAlMjQlN0IoZW5kJTIwLSUyMHN0YXJ0KSUyMCUyRiUyMDEwMDAlN0QlMjBzZWNvbmRzJTYwKSUzQiUwQWNvbnNvbGUubG9nKG91dHB1dCklM0I=",highlighted:`<span class="hljs-keyword">let</span> start = performance.<span class="hljs-title function_">now</span>();
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(audioData);
<span class="hljs-keyword">let</span> end = performance.<span class="hljs-title function_">now</span>();
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">\`Execution duration: <span class="hljs-subst">\${(end - start) / <span class="hljs-number">1000</span>}</span> seconds\`</span>);
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(output);`,wrap:!1}}),V=new F({props:{code:"RXhlY3V0aW9uJTIwZHVyYXRpb24lM0ElMjAwLjY0NjAzMTc5OTk3MjA1NzQlMjBzZWNvbmRzJTBBJTdCJTBBJTIwJTIwdGV4dCUzQSUyMCclMjBBbmQlMjBzbyUyMG15JTIwZmVsbG93JTIwQW1lcmljYW5zJTIwYXNrJTIwbm90JTIwd2hhdCUyMHlvdXIlMjBjb3VudHJ5JTIwY2FuJTIwZG8lMjBmb3IlMjB5b3UuJTIwQXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJyUwQSU3RA==",highlighted:`Execution duration: <span class="hljs-number">0.6460317999720574</span> seconds
{
  text: &#x27; And so my fellow Americans ask not what your country can <span class="hljs-keyword">do</span> <span class="hljs-keyword">for</span> <span class="hljs-title class_">you</span>. Ask what you can <span class="hljs-keyword">do</span> <span class="hljs-keyword">for</span> <span class="hljs-title class_">your</span> country.&#x27;
}`,wrap:!1}}),{c(){i=o("meta"),j=a(),r=o("p"),M=a(),m(J.$$.fragment),P=a(),b=o("p"),b.innerHTML=$e,D=a(),U=o("p"),U.innerHTML=ve,q=a(),m(T.$$.fragment),K=a(),$=o("p"),$.innerHTML=Ie,O=a(),v=o("ul"),v.innerHTML=ge,ee=a(),m(I.$$.fragment),se=a(),g=o("ul"),g.innerHTML=Ce,te=a(),m(C.$$.fragment),le=a(),k=o("p"),k.innerHTML=ke,ae=a(),m(B.$$.fragment),ne=a(),m(y.$$.fragment),ie=a(),Z=o("p"),Z.innerHTML=Be,oe=a(),m(x.$$.fragment),pe=a(),m(G.$$.fragment),re=a(),W=o("p"),W.innerHTML=Ze,ce=a(),m(_.$$.fragment),me=a(),N=o("p"),N.innerHTML=xe,he=a(),m(R.$$.fragment),we=a(),Y=o("p"),Y.textContent=Ge,de=a(),m(X.$$.fragment),ue=a(),A=o("p"),A.textContent=We,fe=a(),m(H.$$.fragment),je=a(),Q=o("p"),Q.innerHTML=_e,Me=a(),S=o("p"),S.textContent=Ne,Te=a(),m(V.$$.fragment),ye=a(),E=o("p"),E.textContent=Re,Je=a(),z=o("p"),this.h()},l(e){const s=ze("svelte-u9bgzb",document.head);i=p(s,"META",{name:!0,content:!0}),s.forEach(t),j=n(e),r=p(e,"P",{}),Ae(r).forEach(t),M=n(e),h(J.$$.fragment,e),P=n(e),b=p(e,"P",{"data-svelte-h":!0}),c(b)!=="svelte-ga23p1"&&(b.innerHTML=$e),D=n(e),U=p(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-1p7qc0w"&&(U.innerHTML=ve),q=n(e),h(T.$$.fragment,e),K=n(e),$=p(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-1kriz5m"&&($.innerHTML=Ie),O=n(e),v=p(e,"UL",{"data-svelte-h":!0}),c(v)!=="svelte-lnhmef"&&(v.innerHTML=ge),ee=n(e),h(I.$$.fragment,e),se=n(e),g=p(e,"UL",{"data-svelte-h":!0}),c(g)!=="svelte-1qy4daj"&&(g.innerHTML=Ce),te=n(e),h(C.$$.fragment,e),le=n(e),k=p(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1w613qw"&&(k.innerHTML=ke),ae=n(e),h(B.$$.fragment,e),ne=n(e),h(y.$$.fragment,e),ie=n(e),Z=p(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-e9y8ng"&&(Z.innerHTML=Be),oe=n(e),h(x.$$.fragment,e),pe=n(e),h(G.$$.fragment,e),re=n(e),W=p(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-wc1j2"&&(W.innerHTML=Ze),ce=n(e),h(_.$$.fragment,e),me=n(e),N=p(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-g3d4hf"&&(N.innerHTML=xe),he=n(e),h(R.$$.fragment,e),we=n(e),Y=p(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1jpls9q"&&(Y.textContent=Ge),de=n(e),h(X.$$.fragment,e),ue=n(e),A=p(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-1sjiopi"&&(A.textContent=We),fe=n(e),h(H.$$.fragment,e),je=n(e),Q=p(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-cx7eio"&&(Q.innerHTML=_e),Me=n(e),S=p(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-s5mxam"&&(S.textContent=Ne),Te=n(e),h(V.$$.fragment,e),ye=n(e),E=p(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-1mxb03j"&&(E.textContent=Re),Je=n(e),z=p(e,"P",{}),Ae(z).forEach(t),this.h()},h(){He(i,"name","hf:doc:metadata"),He(i,"content",Oe)},m(e,s){Pe(document.head,i),l(e,j,s),l(e,r,s),l(e,M,s),w(J,e,s),l(e,P,s),l(e,b,s),l(e,D,s),l(e,U,s),l(e,q,s),w(T,e,s),l(e,K,s),l(e,$,s),l(e,O,s),l(e,v,s),l(e,ee,s),w(I,e,s),l(e,se,s),l(e,g,s),l(e,te,s),w(C,e,s),l(e,le,s),l(e,k,s),l(e,ae,s),w(B,e,s),l(e,ne,s),w(y,e,s),l(e,ie,s),l(e,Z,s),l(e,oe,s),w(x,e,s),l(e,pe,s),w(G,e,s),l(e,re,s),l(e,W,s),l(e,ce,s),w(_,e,s),l(e,me,s),l(e,N,s),l(e,he,s),w(R,e,s),l(e,we,s),l(e,Y,s),l(e,de,s),w(X,e,s),l(e,ue,s),l(e,A,s),l(e,fe,s),w(H,e,s),l(e,je,s),l(e,Q,s),l(e,Me,s),l(e,S,s),l(e,Te,s),w(V,e,s),l(e,ye,s),l(e,E,s),l(e,Je,s),l(e,z,s),be=!0},p(e,[s]){const Ye={};s&2&&(Ye.$$scope={dirty:s,ctx:e}),T.$set(Ye);const Xe={};s&2&&(Xe.$$scope={dirty:s,ctx:e}),y.$set(Xe)},i(e){be||(d(J.$$.fragment,e),d(T.$$.fragment,e),d(I.$$.fragment,e),d(C.$$.fragment,e),d(B.$$.fragment,e),d(y.$$.fragment,e),d(x.$$.fragment,e),d(G.$$.fragment,e),d(_.$$.fragment,e),d(R.$$.fragment,e),d(X.$$.fragment,e),d(H.$$.fragment,e),d(V.$$.fragment,e),be=!0)},o(e){u(J.$$.fragment,e),u(T.$$.fragment,e),u(I.$$.fragment,e),u(C.$$.fragment,e),u(B.$$.fragment,e),u(y.$$.fragment,e),u(x.$$.fragment,e),u(G.$$.fragment,e),u(_.$$.fragment,e),u(R.$$.fragment,e),u(X.$$.fragment,e),u(H.$$.fragment,e),u(V.$$.fragment,e),be=!1},d(e){e&&(t(j),t(r),t(M),t(P),t(b),t(D),t(U),t(q),t(K),t($),t(O),t(v),t(ee),t(se),t(g),t(te),t(le),t(k),t(ae),t(ne),t(ie),t(Z),t(oe),t(pe),t(re),t(W),t(ce),t(me),t(N),t(he),t(we),t(Y),t(de),t(ue),t(A),t(fe),t(je),t(Q),t(Me),t(S),t(Te),t(ye),t(E),t(Je),t(z)),t(i),f(J,e),f(T,e),f(I,e),f(C,e),f(B,e),f(y,e),f(x,e),f(G,e),f(_,e),f(R,e),f(X,e),f(H,e),f(V,e)}}}const Oe='{"title":"Server-side Audio Processing in Node.js","local":"server-side-audio-processing-in-nodejs","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Getting started","local":"getting-started","sections":[],"depth":2},{"title":"Creating the application","local":"creating-the-application","sections":[],"depth":2}],"depth":1}';function es(L){return Ee(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class is extends Fe{constructor(i){super(),Le(this,i,es,Ke,Ve,{})}}export{is as component};
