import{s as sd,n as dd,o as nd}from"../chunks/scheduler.b108d059.js";import{S as rd,i as ud,g as d,s as o,r as p,A as ad,h as n,f as t,c as s,j as a,u as c,x as r,k as u,y as pd,a as i,v as f,d as h,t as m,w as b}from"../chunks/index.008de539.js";import{H as _}from"../chunks/Heading.88bfeb84.js";function cd(zo){let T,At,xt,jt,$,Et,v,Ut,g,Do='Utility functions to interact with the Hugging Face Hub (<a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>)',Ot,P,Wo='<li><a href="#module_utils/hub">utils/hub</a><ul><li><em>static</em><ul><li><a href="#module_utils/hub.getFile"><code>.getFile(urlOrPath)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response)&gt;</code></li> <li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options])</code></a> ⇒ <code>Promise</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li> <li><a href="#module_utils/hub.getModelFile..buffer"><code>~buffer</code></a> : <code>Uint8Array</code></li></ul></li> <li><a href="#module_utils/hub.getModelJSON"><code>.getModelJSON(modelPath, fileName, [fatal], [options])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+_CONTENT_TYPE_MAP"><code>._CONTENT_TYPE_MAP</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response)</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li> <li><a href="#module_utils/hub..isValidHttpUrl"><code>~isValidHttpUrl(string, [validHosts])</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/hub..handleError"><code>~handleError(status, remoteURL, fatal)</code></a> ⇒ <code>null</code></li> <li><a href="#module_utils/hub..tryCache"><code>~tryCache(cache, ...names)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code></li> <li><a href="#module_utils/hub..readResponse"><code>~readResponse(response, progress_callback)</code></a> ⇒ <code>Promise.&lt;Uint8Array&gt;</code></li> <li><a href="#module_utils/hub..pathJoin"><code>~pathJoin(...parts)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/hub..PretrainedOptions"><code>~PretrainedOptions</code></a> : <code>Object</code></li></ul></li></ul></li>',Bt,Kt,qt,R,Nt,y,kt,C,Yo="Helper function to get a file, using either the Fetch API or FileSystem API.",St,H,Vo='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response)&gt;</code> - A promise that resolves to a FileResponse object (if the file is retrieved using the FileSystem API), or a Response object (if the file is retrieved using the Fetch API).',It,M,Go="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>urlOrPath</td><td><code>URL</code> | <code>string</code></td><td><p>The URL/path of the file to get.</p></td></tr></tbody>",Jt,zt,Dt,F,Wt,L,Yt,x,Qo=`Retrieves a file from either a remote URL using the Fetch API or from the local file system using the FileSystem API.
If the filesystem is available and <code>env.useCache = true</code>, the file will be downloaded and cached.`,Vt,w,Xo='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise</code> - A Promise that resolves with the file content as a buffer.<br/> <strong>Throws</strong>:',Gt,A,Zo="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",Qt,j,es="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>path_or_repo_id</td><td><code>string</code></td><td></td><td><p>This can be either:</p> <ul><li>a string, the <em>model id</em> of a model repo on huggingface.co.</li> <li>a path to a <em>directory</em> potentially containing the file.</li></ul></td> </tr><tr><td>filename</td><td><code>string</code></td><td></td><td><p>The name of the file to locate in <code>path_or_repo</code>.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td></tr></tbody>",Xt,E,ts='<li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options])</code></a> ⇒ <code>Promise</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li> <li><a href="#module_utils/hub.getModelFile..buffer"><code>~buffer</code></a> : <code>Uint8Array</code></li></ul></li>',Zt,el,tl,U,ll,O,il,B,ls='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',ol,sl,dl,K,nl,q,rl,N,is='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',ul,al,pl,k,cl,S,fl,I,os='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',hl,ml,bl,J,_l,z,Tl,D,ss="Fetches a JSON file from a given path and file name.",$l,W,ds='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - The JSON data parsed into a JavaScript object.<br/> <strong>Throws</strong>:',vl,Y,ns="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",gl,V,rs="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>modelPath</td><td><code>string</code></td><td></td><td><p>The path to the directory containing the file.</p></td> </tr><tr><td>fileName</td><td><code>string</code></td><td></td><td><p>The name of the file to fetch.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td></tr></tbody>",Pl,Rl,yl,G,Cl,Q,Hl,X,us='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',Ml,Z,as='<li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+_CONTENT_TYPE_MAP"><code>._CONTENT_TYPE_MAP</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',Fl,Ll,xl,ee,wl,te,Al,le,ps="Creates a new <code>FileResponse</code> object.",jl,ie,cs="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>filePath</td><td><code>string</code> | <code>URL</code></td></tr></tbody>",El,Ul,Ol,oe,Bl,se,Kl,de,fs="Mapping from file extensions to MIME types.",ql,ne,hs='<strong>Kind</strong>: instance property of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a>',Nl,kl,Sl,re,Il,ue,Jl,ae,ms=`Updates the ‘content-type’ header property of the response based on the extension of
the file specified by the filePath property of the current object.`,zl,pe,bs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a>',Dl,Wl,Yl,ce,Vl,fe,Gl,he,_s="Clone the current FileResponse object.",Ql,me,Ts='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>FileResponse</code> - A new FileResponse object with the same properties as the current object.',Xl,Zl,ei,be,ti,_e,li,Te,$s=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with an ArrayBuffer containing the file’s contents.`,ii,$e,vs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ArrayBuffer&gt;</code> - A Promise that resolves with an ArrayBuffer containing the file’s contents.<br/> <strong>Throws</strong>:',oi,ve,gs="<li><code>Error</code> If the file cannot be read.</li>",si,di,ni,ge,ri,Pe,ui,Re,Ps=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a Blob containing the file’s contents.`,ai,ye,Rs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Blob&gt;</code> - A Promise that resolves with a Blob containing the file’s contents.<br/> <strong>Throws</strong>:',pi,Ce,ys="<li><code>Error</code> If the file cannot be read.</li>",ci,fi,hi,He,mi,Me,bi,Fe,Cs=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a string containing the file’s contents.`,_i,Le,Hs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;string&gt;</code> - A Promise that resolves with a string containing the file’s contents.<br/> <strong>Throws</strong>:',Ti,xe,Ms="<li><code>Error</code> If the file cannot be read.</li>",$i,vi,gi,we,Pi,Ae,Ri,je,Fs=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a parsed JavaScript object containing the file’s contents.`,yi,Ee,Ls='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - A Promise that resolves with a parsed JavaScript object containing the file’s contents.<br/> <strong>Throws</strong>:',Ci,Ue,xs="<li><code>Error</code> If the file cannot be read.</li>",Hi,Mi,Fi,Oe,Li,Be,xi,Ke,ws='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',wi,qe,As='<li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response)</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li>',Ai,ji,Ei,Ne,Ui,ke,Oi,Se,js="Instantiate a <code>FileCache</code> object.",Bi,Ie,Es="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>path</td><td><code>string</code></td></tr></tbody>",Ki,qi,Ni,Je,ki,ze,Si,De,Us="Checks whether the given request is in the cache.",Ii,We,Os='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',Ji,Ye,Bs="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td></tr></tbody>",zi,Di,Wi,Ve,Yi,Ge,Vi,Qe,Ks="Adds the given response to the cache.",Gi,Xe,qs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',Qi,Ze,Ns="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td> </tr><tr><td>response</td><td><code>Response</code> | <code>FileResponse</code></td></tr></tbody>",Xi,Zi,eo,et,to,tt,lo,lt,ks="Determines whether the given string is a valid HTTP or HTTPS URL.",io,it,Ss='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>boolean</code> - True if the string is a valid HTTP or HTTPS URL, false otherwise.',oo,ot,Is="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>string</td><td><code>string</code> | <code>URL</code></td><td></td><td><p>The string to test for validity as an HTTP or HTTPS URL.</p></td> </tr><tr><td>[validHosts]</td><td><code>Array.&lt;string&gt;</code></td><td><code></code></td><td><p>A list of valid hostnames. If specified, the URL&#39;s hostname must be in this list.</p></td></tr></tbody>",so,no,ro,st,uo,dt,ao,nt,Js="Helper method to handle fatal errors that occur while trying to load a file from the Hugging Face Hub.",po,rt,zs='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>null</code> - Returns <code>null</code> if <code>fatal = true</code>.<br/> <strong>Throws</strong>:',co,ut,Ds="<li><code>Error</code> If `fatal = false`.</li>",fo,at,Ws="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>status</td><td><code>number</code></td><td><p>The HTTP status code of the error.</p></td> </tr><tr><td>remoteURL</td><td><code>string</code></td><td><p>The URL of the file that could not be loaded.</p></td> </tr><tr><td>fatal</td><td><code>boolean</code></td><td><p>Whether to raise an error if the file could not be loaded.</p></td></tr></tbody>",ho,mo,bo,pt,_o,ct,To,ft,Ys='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code> - The item from the cache, or undefined if not found.',$o,ht,Vs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>cache</td><td><code>FileCache</code> | <code>Cache</code></td><td><p>The cache to search</p></td> </tr><tr><td>...names</td><td><code>Array.&lt;string&gt;</code></td><td><p>The names of the item to search for</p></td></tr></tbody>",vo,go,Po,mt,Ro,bt,yo,_t,Gs="Read and track progress when reading a Response object",Co,Tt,Qs='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Uint8Array&gt;</code> - A Promise that resolves with the Uint8Array buffer',Ho,$t,Xs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>response</td><td><code>any</code></td><td><p>The Response object to read</p></td> </tr><tr><td>progress_callback</td><td><code>function</code></td><td><p>The function to call with progress updates</p></td></tr></tbody>",Mo,Fo,Lo,vt,xo,gt,wo,Pt,Zs="Joins multiple parts of a path into a single path, while handling leading and trailing slashes.",Ao,Rt,ed='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>string</code> - A string representing the joined path.',jo,yt,td="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...parts</td><td><code>string</code></td><td><p>Multiple parts of a path.</p></td></tr></tbody>",Eo,Uo,Oo,Ct,Bo,Ht,Ko,Mt,ld="Options for loading a pretrained model.",qo,Ft,id='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Properties</strong>',No,Lt,od=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[quantized]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to load the 8-bit quantized version of the model (only applicable when loading model files).</p></td> </tr><tr><td>[progress_callback]</td><td><code>function</code></td><td><code></code></td><td><p>If specified, this function will be called during model construction, to provide the user with progress updates.</p></td> </tr><tr><td>[config]</td><td><code>Object</code></td><td><code></code></td><td><p>Configuration for the model to use instead of an automatically loaded configuration. Configuration can be automatically loaded when:</p> <ul><li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained model).</li> <li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a configuration JSON file named <em>config.json</em> is found in the directory.</li></ul></td> </tr><tr><td>[cache_dir]</td><td><code>string</code></td><td><code>null</code></td><td><p>Path to a directory in which a downloaded pretrained model configuration should be cached if the standard cache should not be used.</p></td> </tr><tr><td>[local_files_only]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to only look at local files (e.g., not try downloading the model).</p></td> </tr><tr><td>[revision]</td><td><code>string</code></td><td><code>&quot;&#39;main&#39;&quot;</code></td><td><p>The specific model version to use. It can be a branch name, a tag name, or a commit id,
since we use a git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier allowed by git.
NOTE: This setting is ignored for local requests.</p></td> </tr><tr><td>[model_file_name]</td><td><code>string</code></td><td><code>null</code></td><td><p>If specified, load the model with this name (excluding the .onnx suffix). Currently only valid for encoder- or decoder-only models.</p></td></tr></tbody>`,ko,So,Io,wt,Jo;return v=new _({props:{title:"utils/hub",local:"utilshub",headingTag:"h1"}}),y=new _({props:{title:"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>",local:"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code",headingTag:"h2"}}),L=new _({props:{title:"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options]) ⇒ <code> Promise </code>",local:"utilshubgetmodelfilepathorrepoid-filename-fatal-options--code-promise-code",headingTag:"h2"}}),O=new _({props:{title:"getModelFile~cacheKey : <code> string </code>",local:"getmodelfilecachekey--code-string-code",headingTag:"h3"}}),q=new _({props:{title:"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>",local:"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code",headingTag:"h3"}}),S=new _({props:{title:"getModelFile~buffer : <code> Uint8Array </code>",local:"getmodelfilebuffer--code-uint8array-code",headingTag:"h3"}}),z=new _({props:{title:"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>",local:"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code",headingTag:"h2"}}),Q=new _({props:{title:"utils/hub~FileResponse",local:"utilshubfileresponse",headingTag:"h2"}}),te=new _({props:{title:"new FileResponse(filePath)",local:"new-fileresponsefilepath",headingTag:"h3"}}),se=new _({props:{title:"fileResponse._CONTENT_TYPE_MAP",local:"fileresponsecontenttypemap",headingTag:"h3"}}),ue=new _({props:{title:"fileResponse.updateContentType() ⇒ <code> void </code>",local:"fileresponseupdatecontenttype--code-void-code",headingTag:"h3"}}),fe=new _({props:{title:"fileResponse.clone() ⇒ <code> FileResponse </code>",local:"fileresponseclone--code-fileresponse-code",headingTag:"h3"}}),_e=new _({props:{title:"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>",local:"fileresponsearraybuffer--code-promise--arraybuffer--code",headingTag:"h3"}}),Pe=new _({props:{title:"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>",local:"fileresponseblob--code-promise--blob--code",headingTag:"h3"}}),Me=new _({props:{title:"fileResponse.text() ⇒ <code> Promise. < string > </code>",local:"fileresponsetext--code-promise--string--code",headingTag:"h3"}}),Ae=new _({props:{title:"fileResponse.json() ⇒ <code> Promise. < Object > </code>",local:"fileresponsejson--code-promise--object--code",headingTag:"h3"}}),Be=new _({props:{title:"utils/hub~FileCache",local:"utilshubfilecache",headingTag:"h2"}}),ke=new _({props:{title:"new FileCache(path)",local:"new-filecachepath",headingTag:"h3"}}),ze=new _({props:{title:"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>",local:"filecachematchrequest--code-promise--fileresponseundefined--code",headingTag:"h3"}}),Ge=new _({props:{title:"fileCache.put(request, response) ⇒ <code> Promise. < void > </code>",local:"filecacheputrequest-response--code-promise--void--code",headingTag:"h3"}}),tt=new _({props:{title:"utils/hub~isValidHttpUrl(string, [validHosts]) ⇒ <code> boolean </code>",local:"utilshubisvalidhttpurlstring-validhosts--code-boolean-code",headingTag:"h2"}}),dt=new _({props:{title:"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>",local:"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code",headingTag:"h2"}}),ct=new _({props:{title:"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>",local:"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code",headingTag:"h2"}}),bt=new _({props:{title:"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>",local:"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code",headingTag:"h2"}}),gt=new _({props:{title:"utils/hub~pathJoin(...parts) ⇒ <code> string </code>",local:"utilshubpathjoinparts--code-string-code",headingTag:"h2"}}),Ht=new _({props:{title:"utils/hub~PretrainedOptions : <code> Object </code>",local:"utilshubpretrainedoptions--code-object-code",headingTag:"h2"}}),{c(){T=d("meta"),At=o(),xt=d("p"),jt=o(),$=d("a"),Et=o(),p(v.$$.fragment),Ut=o(),g=d("p"),g.innerHTML=Do,Ot=o(),P=d("ul"),P.innerHTML=Wo,Bt=o(),Kt=d("hr"),qt=o(),R=d("a"),Nt=o(),p(y.$$.fragment),kt=o(),C=d("p"),C.textContent=Yo,St=o(),H=d("p"),H.innerHTML=Vo,It=o(),M=d("table"),M.innerHTML=Go,Jt=o(),zt=d("hr"),Dt=o(),F=d("a"),Wt=o(),p(L.$$.fragment),Yt=o(),x=d("p"),x.innerHTML=Qo,Vt=o(),w=d("p"),w.innerHTML=Xo,Gt=o(),A=d("ul"),A.innerHTML=Zo,Qt=o(),j=d("table"),j.innerHTML=es,Xt=o(),E=d("ul"),E.innerHTML=ts,Zt=o(),el=d("hr"),tl=o(),U=d("a"),ll=o(),p(O.$$.fragment),il=o(),B=d("p"),B.innerHTML=ls,ol=o(),sl=d("hr"),dl=o(),K=d("a"),nl=o(),p(q.$$.fragment),rl=o(),N=d("p"),N.innerHTML=is,ul=o(),al=d("hr"),pl=o(),k=d("a"),cl=o(),p(S.$$.fragment),fl=o(),I=d("p"),I.innerHTML=os,hl=o(),ml=d("hr"),bl=o(),J=d("a"),_l=o(),p(z.$$.fragment),Tl=o(),D=d("p"),D.textContent=ss,$l=o(),W=d("p"),W.innerHTML=ds,vl=o(),Y=d("ul"),Y.innerHTML=ns,gl=o(),V=d("table"),V.innerHTML=rs,Pl=o(),Rl=d("hr"),yl=o(),G=d("a"),Cl=o(),p(Q.$$.fragment),Hl=o(),X=d("p"),X.innerHTML=us,Ml=o(),Z=d("ul"),Z.innerHTML=as,Fl=o(),Ll=d("hr"),xl=o(),ee=d("a"),wl=o(),p(te.$$.fragment),Al=o(),le=d("p"),le.innerHTML=ps,jl=o(),ie=d("table"),ie.innerHTML=cs,El=o(),Ul=d("hr"),Ol=o(),oe=d("a"),Bl=o(),p(se.$$.fragment),Kl=o(),de=d("p"),de.textContent=fs,ql=o(),ne=d("p"),ne.innerHTML=hs,Nl=o(),kl=d("hr"),Sl=o(),re=d("a"),Il=o(),p(ue.$$.fragment),Jl=o(),ae=d("p"),ae.textContent=ms,zl=o(),pe=d("p"),pe.innerHTML=bs,Dl=o(),Wl=d("hr"),Yl=o(),ce=d("a"),Vl=o(),p(fe.$$.fragment),Gl=o(),he=d("p"),he.textContent=_s,Ql=o(),me=d("p"),me.innerHTML=Ts,Xl=o(),Zl=d("hr"),ei=o(),be=d("a"),ti=o(),p(_e.$$.fragment),li=o(),Te=d("p"),Te.textContent=$s,ii=o(),$e=d("p"),$e.innerHTML=vs,oi=o(),ve=d("ul"),ve.innerHTML=gs,si=o(),di=d("hr"),ni=o(),ge=d("a"),ri=o(),p(Pe.$$.fragment),ui=o(),Re=d("p"),Re.textContent=Ps,ai=o(),ye=d("p"),ye.innerHTML=Rs,pi=o(),Ce=d("ul"),Ce.innerHTML=ys,ci=o(),fi=d("hr"),hi=o(),He=d("a"),mi=o(),p(Me.$$.fragment),bi=o(),Fe=d("p"),Fe.textContent=Cs,_i=o(),Le=d("p"),Le.innerHTML=Hs,Ti=o(),xe=d("ul"),xe.innerHTML=Ms,$i=o(),vi=d("hr"),gi=o(),we=d("a"),Pi=o(),p(Ae.$$.fragment),Ri=o(),je=d("p"),je.textContent=Fs,yi=o(),Ee=d("p"),Ee.innerHTML=Ls,Ci=o(),Ue=d("ul"),Ue.innerHTML=xs,Hi=o(),Mi=d("hr"),Fi=o(),Oe=d("a"),Li=o(),p(Be.$$.fragment),xi=o(),Ke=d("p"),Ke.innerHTML=ws,wi=o(),qe=d("ul"),qe.innerHTML=As,Ai=o(),ji=d("hr"),Ei=o(),Ne=d("a"),Ui=o(),p(ke.$$.fragment),Oi=o(),Se=d("p"),Se.innerHTML=js,Bi=o(),Ie=d("table"),Ie.innerHTML=Es,Ki=o(),qi=d("hr"),Ni=o(),Je=d("a"),ki=o(),p(ze.$$.fragment),Si=o(),De=d("p"),De.textContent=Us,Ii=o(),We=d("p"),We.innerHTML=Os,Ji=o(),Ye=d("table"),Ye.innerHTML=Bs,zi=o(),Di=d("hr"),Wi=o(),Ve=d("a"),Yi=o(),p(Ge.$$.fragment),Vi=o(),Qe=d("p"),Qe.textContent=Ks,Gi=o(),Xe=d("p"),Xe.innerHTML=qs,Qi=o(),Ze=d("table"),Ze.innerHTML=Ns,Xi=o(),Zi=d("hr"),eo=o(),et=d("a"),to=o(),p(tt.$$.fragment),lo=o(),lt=d("p"),lt.textContent=ks,io=o(),it=d("p"),it.innerHTML=Ss,oo=o(),ot=d("table"),ot.innerHTML=Is,so=o(),no=d("hr"),ro=o(),st=d("a"),uo=o(),p(dt.$$.fragment),ao=o(),nt=d("p"),nt.textContent=Js,po=o(),rt=d("p"),rt.innerHTML=zs,co=o(),ut=d("ul"),ut.innerHTML=Ds,fo=o(),at=d("table"),at.innerHTML=Ws,ho=o(),mo=d("hr"),bo=o(),pt=d("a"),_o=o(),p(ct.$$.fragment),To=o(),ft=d("p"),ft.innerHTML=Ys,$o=o(),ht=d("table"),ht.innerHTML=Vs,vo=o(),go=d("hr"),Po=o(),mt=d("a"),Ro=o(),p(bt.$$.fragment),yo=o(),_t=d("p"),_t.textContent=Gs,Co=o(),Tt=d("p"),Tt.innerHTML=Qs,Ho=o(),$t=d("table"),$t.innerHTML=Xs,Mo=o(),Fo=d("hr"),Lo=o(),vt=d("a"),xo=o(),p(gt.$$.fragment),wo=o(),Pt=d("p"),Pt.textContent=Zs,Ao=o(),Rt=d("p"),Rt.innerHTML=ed,jo=o(),yt=d("table"),yt.innerHTML=td,Eo=o(),Uo=d("hr"),Oo=o(),Ct=d("a"),Bo=o(),p(Ht.$$.fragment),Ko=o(),Mt=d("p"),Mt.textContent=ld,qo=o(),Ft=d("p"),Ft.innerHTML=id,No=o(),Lt=d("table"),Lt.innerHTML=od,ko=o(),So=d("hr"),Io=o(),wt=d("p"),this.h()},l(e){const l=ad("svelte-u9bgzb",document.head);T=n(l,"META",{name:!0,content:!0}),l.forEach(t),At=s(e),xt=n(e,"P",{}),a(xt).forEach(t),jt=s(e),$=n(e,"A",{id:!0,class:!0}),a($).forEach(t),Et=s(e),c(v.$$.fragment,e),Ut=s(e),g=n(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1jxl61c"&&(g.innerHTML=Do),Ot=s(e),P=n(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-10lc5q7"&&(P.innerHTML=Wo),Bt=s(e),Kt=n(e,"HR",{}),qt=s(e),R=n(e,"A",{id:!0,class:!0}),a(R).forEach(t),Nt=s(e),c(y.$$.fragment,e),kt=s(e),C=n(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-10mshiw"&&(C.textContent=Yo),St=s(e),H=n(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1jj7eze"&&(H.innerHTML=Vo),It=s(e),M=n(e,"TABLE",{"data-svelte-h":!0}),r(M)!=="svelte-pbwhgs"&&(M.innerHTML=Go),Jt=s(e),zt=n(e,"HR",{}),Dt=s(e),F=n(e,"A",{id:!0,class:!0}),a(F).forEach(t),Wt=s(e),c(L.$$.fragment,e),Yt=s(e),x=n(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1l3bjq3"&&(x.innerHTML=Qo),Vt=s(e),w=n(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1rwfklh"&&(w.innerHTML=Xo),Gt=s(e),A=n(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-jl6z4b"&&(A.innerHTML=Zo),Qt=s(e),j=n(e,"TABLE",{"data-svelte-h":!0}),r(j)!=="svelte-1o6u9nv"&&(j.innerHTML=es),Xt=s(e),E=n(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-xatn75"&&(E.innerHTML=ts),Zt=s(e),el=n(e,"HR",{}),tl=s(e),U=n(e,"A",{id:!0,class:!0}),a(U).forEach(t),ll=s(e),c(O.$$.fragment,e),il=s(e),B=n(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ys3w38"&&(B.innerHTML=ls),ol=s(e),sl=n(e,"HR",{}),dl=s(e),K=n(e,"A",{id:!0,class:!0}),a(K).forEach(t),nl=s(e),c(q.$$.fragment,e),rl=s(e),N=n(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1ys3w38"&&(N.innerHTML=is),ul=s(e),al=n(e,"HR",{}),pl=s(e),k=n(e,"A",{id:!0,class:!0}),a(k).forEach(t),cl=s(e),c(S.$$.fragment,e),fl=s(e),I=n(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1ys3w38"&&(I.innerHTML=os),hl=s(e),ml=n(e,"HR",{}),bl=s(e),J=n(e,"A",{id:!0,class:!0}),a(J).forEach(t),_l=s(e),c(z.$$.fragment,e),Tl=s(e),D=n(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1en2wh4"&&(D.textContent=ss),$l=s(e),W=n(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1l5qo0i"&&(W.innerHTML=ds),vl=s(e),Y=n(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-jl6z4b"&&(Y.innerHTML=ns),gl=s(e),V=n(e,"TABLE",{"data-svelte-h":!0}),r(V)!=="svelte-1iel3tk"&&(V.innerHTML=rs),Pl=s(e),Rl=n(e,"HR",{}),yl=s(e),G=n(e,"A",{id:!0,class:!0}),a(G).forEach(t),Cl=s(e),c(Q.$$.fragment,e),Hl=s(e),X=n(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-16uuos4"&&(X.innerHTML=us),Ml=s(e),Z=n(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-165ijwb"&&(Z.innerHTML=as),Fl=s(e),Ll=n(e,"HR",{}),xl=s(e),ee=n(e,"A",{id:!0,class:!0}),a(ee).forEach(t),wl=s(e),c(te.$$.fragment,e),Al=s(e),le=n(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-zzl0lp"&&(le.innerHTML=ps),jl=s(e),ie=n(e,"TABLE",{"data-svelte-h":!0}),r(ie)!=="svelte-1y2k5ta"&&(ie.innerHTML=cs),El=s(e),Ul=n(e,"HR",{}),Ol=s(e),oe=n(e,"A",{id:!0,class:!0}),a(oe).forEach(t),Bl=s(e),c(se.$$.fragment,e),Kl=s(e),de=n(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-15u13r6"&&(de.textContent=fs),ql=s(e),ne=n(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-g2qxul"&&(ne.innerHTML=hs),Nl=s(e),kl=n(e,"HR",{}),Sl=s(e),re=n(e,"A",{id:!0,class:!0}),a(re).forEach(t),Il=s(e),c(ue.$$.fragment,e),Jl=s(e),ae=n(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1u1tjx3"&&(ae.textContent=ms),zl=s(e),pe=n(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1sowe6d"&&(pe.innerHTML=bs),Dl=s(e),Wl=n(e,"HR",{}),Yl=s(e),ce=n(e,"A",{id:!0,class:!0}),a(ce).forEach(t),Vl=s(e),c(fe.$$.fragment,e),Gl=s(e),he=n(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-d8j2xp"&&(he.textContent=_s),Ql=s(e),me=n(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-8jlahc"&&(me.innerHTML=Ts),Xl=s(e),Zl=n(e,"HR",{}),ei=s(e),be=n(e,"A",{id:!0,class:!0}),a(be).forEach(t),ti=s(e),c(_e.$$.fragment,e),li=s(e),Te=n(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1a8fecx"&&(Te.textContent=$s),ii=s(e),$e=n(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-v2f2ae"&&($e.innerHTML=vs),oi=s(e),ve=n(e,"UL",{"data-svelte-h":!0}),r(ve)!=="svelte-1f4f3jw"&&(ve.innerHTML=gs),si=s(e),di=n(e,"HR",{}),ni=s(e),ge=n(e,"A",{id:!0,class:!0}),a(ge).forEach(t),ri=s(e),c(Pe.$$.fragment,e),ui=s(e),Re=n(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-h3zv97"&&(Re.textContent=Ps),ai=s(e),ye=n(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1e723py"&&(ye.innerHTML=Rs),pi=s(e),Ce=n(e,"UL",{"data-svelte-h":!0}),r(Ce)!=="svelte-1f4f3jw"&&(Ce.innerHTML=ys),ci=s(e),fi=n(e,"HR",{}),hi=s(e),He=n(e,"A",{id:!0,class:!0}),a(He).forEach(t),mi=s(e),c(Me.$$.fragment,e),bi=s(e),Fe=n(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-jd4zuh"&&(Fe.textContent=Cs),_i=s(e),Le=n(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1ozy582"&&(Le.innerHTML=Hs),Ti=s(e),xe=n(e,"UL",{"data-svelte-h":!0}),r(xe)!=="svelte-1f4f3jw"&&(xe.innerHTML=Ms),$i=s(e),vi=n(e,"HR",{}),gi=s(e),we=n(e,"A",{id:!0,class:!0}),a(we).forEach(t),Pi=s(e),c(Ae.$$.fragment,e),Ri=s(e),je=n(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-cd4397"&&(je.textContent=Fs),yi=s(e),Ee=n(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-j83voe"&&(Ee.innerHTML=Ls),Ci=s(e),Ue=n(e,"UL",{"data-svelte-h":!0}),r(Ue)!=="svelte-1f4f3jw"&&(Ue.innerHTML=xs),Hi=s(e),Mi=n(e,"HR",{}),Fi=s(e),Oe=n(e,"A",{id:!0,class:!0}),a(Oe).forEach(t),Li=s(e),c(Be.$$.fragment,e),xi=s(e),Ke=n(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-16uuos4"&&(Ke.innerHTML=ws),wi=s(e),qe=n(e,"UL",{"data-svelte-h":!0}),r(qe)!=="svelte-136j1yr"&&(qe.innerHTML=As),Ai=s(e),ji=n(e,"HR",{}),Ei=s(e),Ne=n(e,"A",{id:!0,class:!0}),a(Ne).forEach(t),Ui=s(e),c(ke.$$.fragment,e),Oi=s(e),Se=n(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-pake4r"&&(Se.innerHTML=js),Bi=s(e),Ie=n(e,"TABLE",{"data-svelte-h":!0}),r(Ie)!=="svelte-f03x1m"&&(Ie.innerHTML=Es),Ki=s(e),qi=n(e,"HR",{}),Ni=s(e),Je=n(e,"A",{id:!0,class:!0}),a(Je).forEach(t),ki=s(e),c(ze.$$.fragment,e),Si=s(e),De=n(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-13oc2rp"&&(De.textContent=Us),Ii=s(e),We=n(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1wxlxpn"&&(We.innerHTML=Os),Ji=s(e),Ye=n(e,"TABLE",{"data-svelte-h":!0}),r(Ye)!=="svelte-2kmk06"&&(Ye.innerHTML=Bs),zi=s(e),Di=n(e,"HR",{}),Wi=s(e),Ve=n(e,"A",{id:!0,class:!0}),a(Ve).forEach(t),Yi=s(e),c(Ge.$$.fragment,e),Vi=s(e),Qe=n(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-bwoz3v"&&(Qe.textContent=Ks),Gi=s(e),Xe=n(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1wxlxpn"&&(Xe.innerHTML=qs),Qi=s(e),Ze=n(e,"TABLE",{"data-svelte-h":!0}),r(Ze)!=="svelte-yj5tj6"&&(Ze.innerHTML=Ns),Xi=s(e),Zi=n(e,"HR",{}),eo=s(e),et=n(e,"A",{id:!0,class:!0}),a(et).forEach(t),to=s(e),c(tt.$$.fragment,e),lo=s(e),lt=n(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-19yu0hw"&&(lt.textContent=ks),io=s(e),it=n(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1ifo88t"&&(it.innerHTML=Ss),oo=s(e),ot=n(e,"TABLE",{"data-svelte-h":!0}),r(ot)!=="svelte-msmjch"&&(ot.innerHTML=Is),so=s(e),no=n(e,"HR",{}),ro=s(e),st=n(e,"A",{id:!0,class:!0}),a(st).forEach(t),uo=s(e),c(dt.$$.fragment,e),ao=s(e),nt=n(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-112gzs0"&&(nt.textContent=Js),po=s(e),rt=n(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-9i72aw"&&(rt.innerHTML=zs),co=s(e),ut=n(e,"UL",{"data-svelte-h":!0}),r(ut)!=="svelte-w7pu3"&&(ut.innerHTML=Ds),fo=s(e),at=n(e,"TABLE",{"data-svelte-h":!0}),r(at)!=="svelte-bpbhxc"&&(at.innerHTML=Ws),ho=s(e),mo=n(e,"HR",{}),bo=s(e),pt=n(e,"A",{id:!0,class:!0}),a(pt).forEach(t),_o=s(e),c(ct.$$.fragment,e),To=s(e),ft=n(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1h1o1yf"&&(ft.innerHTML=Ys),$o=s(e),ht=n(e,"TABLE",{"data-svelte-h":!0}),r(ht)!=="svelte-17sk6uf"&&(ht.innerHTML=Vs),vo=s(e),go=n(e,"HR",{}),Po=s(e),mt=n(e,"A",{id:!0,class:!0}),a(mt).forEach(t),Ro=s(e),c(bt.$$.fragment,e),yo=s(e),_t=n(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-1tqccie"&&(_t.textContent=Gs),Co=s(e),Tt=n(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-dyyw29"&&(Tt.innerHTML=Qs),Ho=s(e),$t=n(e,"TABLE",{"data-svelte-h":!0}),r($t)!=="svelte-13fau3m"&&($t.innerHTML=Xs),Mo=s(e),Fo=n(e,"HR",{}),Lo=s(e),vt=n(e,"A",{id:!0,class:!0}),a(vt).forEach(t),xo=s(e),c(gt.$$.fragment,e),wo=s(e),Pt=n(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-7vbcne"&&(Pt.textContent=Zs),Ao=s(e),Rt=n(e,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-wjfx67"&&(Rt.innerHTML=ed),jo=s(e),yt=n(e,"TABLE",{"data-svelte-h":!0}),r(yt)!=="svelte-61qi9d"&&(yt.innerHTML=td),Eo=s(e),Uo=n(e,"HR",{}),Oo=s(e),Ct=n(e,"A",{id:!0,class:!0}),a(Ct).forEach(t),Bo=s(e),c(Ht.$$.fragment,e),Ko=s(e),Mt=n(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1oi15lr"&&(Mt.textContent=ld),qo=s(e),Ft=n(e,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-121rdz"&&(Ft.innerHTML=id),No=s(e),Lt=n(e,"TABLE",{"data-svelte-h":!0}),r(Lt)!=="svelte-1kbnzqd"&&(Lt.innerHTML=od),ko=s(e),So=n(e,"HR",{}),Io=s(e),wt=n(e,"P",{}),a(wt).forEach(t),this.h()},h(){u(T,"name","hf:doc:metadata"),u(T,"content",fd),u($,"id","module_utils/hub"),u($,"class","group"),u(R,"id","module_utils/hub.getFile"),u(R,"class","group"),u(F,"id","module_utils/hub.getModelFile"),u(F,"class","group"),u(U,"id","module_utils/hub.getModelFile..cacheKey"),u(U,"class","group"),u(K,"id","module_utils/hub.getModelFile..response"),u(K,"class","group"),u(k,"id","module_utils/hub.getModelFile..buffer"),u(k,"class","group"),u(J,"id","module_utils/hub.getModelJSON"),u(J,"class","group"),u(G,"id","module_utils/hub..FileResponse"),u(G,"class","group"),u(ee,"id","new_module_utils/hub..FileResponse_new"),u(ee,"class","group"),u(oe,"id","module_utils/hub..FileResponse+_CONTENT_TYPE_MAP"),u(oe,"class","group"),u(re,"id","module_utils/hub..FileResponse+updateContentType"),u(re,"class","group"),u(ce,"id","module_utils/hub..FileResponse+clone"),u(ce,"class","group"),u(be,"id","module_utils/hub..FileResponse+arrayBuffer"),u(be,"class","group"),u(ge,"id","module_utils/hub..FileResponse+blob"),u(ge,"class","group"),u(He,"id","module_utils/hub..FileResponse+text"),u(He,"class","group"),u(we,"id","module_utils/hub..FileResponse+json"),u(we,"class","group"),u(Oe,"id","module_utils/hub..FileCache"),u(Oe,"class","group"),u(Ne,"id","new_module_utils/hub..FileCache_new"),u(Ne,"class","group"),u(Je,"id","module_utils/hub..FileCache+match"),u(Je,"class","group"),u(Ve,"id","module_utils/hub..FileCache+put"),u(Ve,"class","group"),u(et,"id","module_utils/hub..isValidHttpUrl"),u(et,"class","group"),u(st,"id","module_utils/hub..handleError"),u(st,"class","group"),u(pt,"id","module_utils/hub..tryCache"),u(pt,"class","group"),u(mt,"id","module_utils/hub..readResponse"),u(mt,"class","group"),u(vt,"id","module_utils/hub..pathJoin"),u(vt,"class","group"),u(Ct,"id","module_utils/hub..PretrainedOptions"),u(Ct,"class","group")},m(e,l){pd(document.head,T),i(e,At,l),i(e,xt,l),i(e,jt,l),i(e,$,l),i(e,Et,l),f(v,e,l),i(e,Ut,l),i(e,g,l),i(e,Ot,l),i(e,P,l),i(e,Bt,l),i(e,Kt,l),i(e,qt,l),i(e,R,l),i(e,Nt,l),f(y,e,l),i(e,kt,l),i(e,C,l),i(e,St,l),i(e,H,l),i(e,It,l),i(e,M,l),i(e,Jt,l),i(e,zt,l),i(e,Dt,l),i(e,F,l),i(e,Wt,l),f(L,e,l),i(e,Yt,l),i(e,x,l),i(e,Vt,l),i(e,w,l),i(e,Gt,l),i(e,A,l),i(e,Qt,l),i(e,j,l),i(e,Xt,l),i(e,E,l),i(e,Zt,l),i(e,el,l),i(e,tl,l),i(e,U,l),i(e,ll,l),f(O,e,l),i(e,il,l),i(e,B,l),i(e,ol,l),i(e,sl,l),i(e,dl,l),i(e,K,l),i(e,nl,l),f(q,e,l),i(e,rl,l),i(e,N,l),i(e,ul,l),i(e,al,l),i(e,pl,l),i(e,k,l),i(e,cl,l),f(S,e,l),i(e,fl,l),i(e,I,l),i(e,hl,l),i(e,ml,l),i(e,bl,l),i(e,J,l),i(e,_l,l),f(z,e,l),i(e,Tl,l),i(e,D,l),i(e,$l,l),i(e,W,l),i(e,vl,l),i(e,Y,l),i(e,gl,l),i(e,V,l),i(e,Pl,l),i(e,Rl,l),i(e,yl,l),i(e,G,l),i(e,Cl,l),f(Q,e,l),i(e,Hl,l),i(e,X,l),i(e,Ml,l),i(e,Z,l),i(e,Fl,l),i(e,Ll,l),i(e,xl,l),i(e,ee,l),i(e,wl,l),f(te,e,l),i(e,Al,l),i(e,le,l),i(e,jl,l),i(e,ie,l),i(e,El,l),i(e,Ul,l),i(e,Ol,l),i(e,oe,l),i(e,Bl,l),f(se,e,l),i(e,Kl,l),i(e,de,l),i(e,ql,l),i(e,ne,l),i(e,Nl,l),i(e,kl,l),i(e,Sl,l),i(e,re,l),i(e,Il,l),f(ue,e,l),i(e,Jl,l),i(e,ae,l),i(e,zl,l),i(e,pe,l),i(e,Dl,l),i(e,Wl,l),i(e,Yl,l),i(e,ce,l),i(e,Vl,l),f(fe,e,l),i(e,Gl,l),i(e,he,l),i(e,Ql,l),i(e,me,l),i(e,Xl,l),i(e,Zl,l),i(e,ei,l),i(e,be,l),i(e,ti,l),f(_e,e,l),i(e,li,l),i(e,Te,l),i(e,ii,l),i(e,$e,l),i(e,oi,l),i(e,ve,l),i(e,si,l),i(e,di,l),i(e,ni,l),i(e,ge,l),i(e,ri,l),f(Pe,e,l),i(e,ui,l),i(e,Re,l),i(e,ai,l),i(e,ye,l),i(e,pi,l),i(e,Ce,l),i(e,ci,l),i(e,fi,l),i(e,hi,l),i(e,He,l),i(e,mi,l),f(Me,e,l),i(e,bi,l),i(e,Fe,l),i(e,_i,l),i(e,Le,l),i(e,Ti,l),i(e,xe,l),i(e,$i,l),i(e,vi,l),i(e,gi,l),i(e,we,l),i(e,Pi,l),f(Ae,e,l),i(e,Ri,l),i(e,je,l),i(e,yi,l),i(e,Ee,l),i(e,Ci,l),i(e,Ue,l),i(e,Hi,l),i(e,Mi,l),i(e,Fi,l),i(e,Oe,l),i(e,Li,l),f(Be,e,l),i(e,xi,l),i(e,Ke,l),i(e,wi,l),i(e,qe,l),i(e,Ai,l),i(e,ji,l),i(e,Ei,l),i(e,Ne,l),i(e,Ui,l),f(ke,e,l),i(e,Oi,l),i(e,Se,l),i(e,Bi,l),i(e,Ie,l),i(e,Ki,l),i(e,qi,l),i(e,Ni,l),i(e,Je,l),i(e,ki,l),f(ze,e,l),i(e,Si,l),i(e,De,l),i(e,Ii,l),i(e,We,l),i(e,Ji,l),i(e,Ye,l),i(e,zi,l),i(e,Di,l),i(e,Wi,l),i(e,Ve,l),i(e,Yi,l),f(Ge,e,l),i(e,Vi,l),i(e,Qe,l),i(e,Gi,l),i(e,Xe,l),i(e,Qi,l),i(e,Ze,l),i(e,Xi,l),i(e,Zi,l),i(e,eo,l),i(e,et,l),i(e,to,l),f(tt,e,l),i(e,lo,l),i(e,lt,l),i(e,io,l),i(e,it,l),i(e,oo,l),i(e,ot,l),i(e,so,l),i(e,no,l),i(e,ro,l),i(e,st,l),i(e,uo,l),f(dt,e,l),i(e,ao,l),i(e,nt,l),i(e,po,l),i(e,rt,l),i(e,co,l),i(e,ut,l),i(e,fo,l),i(e,at,l),i(e,ho,l),i(e,mo,l),i(e,bo,l),i(e,pt,l),i(e,_o,l),f(ct,e,l),i(e,To,l),i(e,ft,l),i(e,$o,l),i(e,ht,l),i(e,vo,l),i(e,go,l),i(e,Po,l),i(e,mt,l),i(e,Ro,l),f(bt,e,l),i(e,yo,l),i(e,_t,l),i(e,Co,l),i(e,Tt,l),i(e,Ho,l),i(e,$t,l),i(e,Mo,l),i(e,Fo,l),i(e,Lo,l),i(e,vt,l),i(e,xo,l),f(gt,e,l),i(e,wo,l),i(e,Pt,l),i(e,Ao,l),i(e,Rt,l),i(e,jo,l),i(e,yt,l),i(e,Eo,l),i(e,Uo,l),i(e,Oo,l),i(e,Ct,l),i(e,Bo,l),f(Ht,e,l),i(e,Ko,l),i(e,Mt,l),i(e,qo,l),i(e,Ft,l),i(e,No,l),i(e,Lt,l),i(e,ko,l),i(e,So,l),i(e,Io,l),i(e,wt,l),Jo=!0},p:dd,i(e){Jo||(h(v.$$.fragment,e),h(y.$$.fragment,e),h(L.$$.fragment,e),h(O.$$.fragment,e),h(q.$$.fragment,e),h(S.$$.fragment,e),h(z.$$.fragment,e),h(Q.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(_e.$$.fragment,e),h(Pe.$$.fragment,e),h(Me.$$.fragment,e),h(Ae.$$.fragment,e),h(Be.$$.fragment,e),h(ke.$$.fragment,e),h(ze.$$.fragment,e),h(Ge.$$.fragment,e),h(tt.$$.fragment,e),h(dt.$$.fragment,e),h(ct.$$.fragment,e),h(bt.$$.fragment,e),h(gt.$$.fragment,e),h(Ht.$$.fragment,e),Jo=!0)},o(e){m(v.$$.fragment,e),m(y.$$.fragment,e),m(L.$$.fragment,e),m(O.$$.fragment,e),m(q.$$.fragment,e),m(S.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(ue.$$.fragment,e),m(fe.$$.fragment,e),m(_e.$$.fragment,e),m(Pe.$$.fragment,e),m(Me.$$.fragment,e),m(Ae.$$.fragment,e),m(Be.$$.fragment,e),m(ke.$$.fragment,e),m(ze.$$.fragment,e),m(Ge.$$.fragment,e),m(tt.$$.fragment,e),m(dt.$$.fragment,e),m(ct.$$.fragment,e),m(bt.$$.fragment,e),m(gt.$$.fragment,e),m(Ht.$$.fragment,e),Jo=!1},d(e){e&&(t(At),t(xt),t(jt),t($),t(Et),t(Ut),t(g),t(Ot),t(P),t(Bt),t(Kt),t(qt),t(R),t(Nt),t(kt),t(C),t(St),t(H),t(It),t(M),t(Jt),t(zt),t(Dt),t(F),t(Wt),t(Yt),t(x),t(Vt),t(w),t(Gt),t(A),t(Qt),t(j),t(Xt),t(E),t(Zt),t(el),t(tl),t(U),t(ll),t(il),t(B),t(ol),t(sl),t(dl),t(K),t(nl),t(rl),t(N),t(ul),t(al),t(pl),t(k),t(cl),t(fl),t(I),t(hl),t(ml),t(bl),t(J),t(_l),t(Tl),t(D),t($l),t(W),t(vl),t(Y),t(gl),t(V),t(Pl),t(Rl),t(yl),t(G),t(Cl),t(Hl),t(X),t(Ml),t(Z),t(Fl),t(Ll),t(xl),t(ee),t(wl),t(Al),t(le),t(jl),t(ie),t(El),t(Ul),t(Ol),t(oe),t(Bl),t(Kl),t(de),t(ql),t(ne),t(Nl),t(kl),t(Sl),t(re),t(Il),t(Jl),t(ae),t(zl),t(pe),t(Dl),t(Wl),t(Yl),t(ce),t(Vl),t(Gl),t(he),t(Ql),t(me),t(Xl),t(Zl),t(ei),t(be),t(ti),t(li),t(Te),t(ii),t($e),t(oi),t(ve),t(si),t(di),t(ni),t(ge),t(ri),t(ui),t(Re),t(ai),t(ye),t(pi),t(Ce),t(ci),t(fi),t(hi),t(He),t(mi),t(bi),t(Fe),t(_i),t(Le),t(Ti),t(xe),t($i),t(vi),t(gi),t(we),t(Pi),t(Ri),t(je),t(yi),t(Ee),t(Ci),t(Ue),t(Hi),t(Mi),t(Fi),t(Oe),t(Li),t(xi),t(Ke),t(wi),t(qe),t(Ai),t(ji),t(Ei),t(Ne),t(Ui),t(Oi),t(Se),t(Bi),t(Ie),t(Ki),t(qi),t(Ni),t(Je),t(ki),t(Si),t(De),t(Ii),t(We),t(Ji),t(Ye),t(zi),t(Di),t(Wi),t(Ve),t(Yi),t(Vi),t(Qe),t(Gi),t(Xe),t(Qi),t(Ze),t(Xi),t(Zi),t(eo),t(et),t(to),t(lo),t(lt),t(io),t(it),t(oo),t(ot),t(so),t(no),t(ro),t(st),t(uo),t(ao),t(nt),t(po),t(rt),t(co),t(ut),t(fo),t(at),t(ho),t(mo),t(bo),t(pt),t(_o),t(To),t(ft),t($o),t(ht),t(vo),t(go),t(Po),t(mt),t(Ro),t(yo),t(_t),t(Co),t(Tt),t(Ho),t($t),t(Mo),t(Fo),t(Lo),t(vt),t(xo),t(wo),t(Pt),t(Ao),t(Rt),t(jo),t(yt),t(Eo),t(Uo),t(Oo),t(Ct),t(Bo),t(Ko),t(Mt),t(qo),t(Ft),t(No),t(Lt),t(ko),t(So),t(Io),t(wt)),t(T),b(v,e),b(y,e),b(L,e),b(O,e),b(q,e),b(S,e),b(z,e),b(Q,e),b(te,e),b(se,e),b(ue,e),b(fe,e),b(_e,e),b(Pe,e),b(Me,e),b(Ae,e),b(Be,e),b(ke,e),b(ze,e),b(Ge,e),b(tt,e),b(dt,e),b(ct,e),b(bt,e),b(gt,e),b(Ht,e)}}}const fd='{"title":"utils/hub","local":"utilshub","sections":[{"title":"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>","local":"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code","sections":[],"depth":2},{"title":"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options]) ⇒ <code> Promise </code>","local":"utilshubgetmodelfilepathorrepoid-filename-fatal-options--code-promise-code","sections":[{"title":"getModelFile~cacheKey : <code> string </code>","local":"getmodelfilecachekey--code-string-code","sections":[],"depth":3},{"title":"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>","local":"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code","sections":[],"depth":3},{"title":"getModelFile~buffer : <code> Uint8Array </code>","local":"getmodelfilebuffer--code-uint8array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>","local":"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code","sections":[],"depth":2},{"title":"utils/hub~FileResponse","local":"utilshubfileresponse","sections":[{"title":"new FileResponse(filePath)","local":"new-fileresponsefilepath","sections":[],"depth":3},{"title":"fileResponse._CONTENT_TYPE_MAP","local":"fileresponsecontenttypemap","sections":[],"depth":3},{"title":"fileResponse.updateContentType() ⇒ <code> void </code>","local":"fileresponseupdatecontenttype--code-void-code","sections":[],"depth":3},{"title":"fileResponse.clone() ⇒ <code> FileResponse </code>","local":"fileresponseclone--code-fileresponse-code","sections":[],"depth":3},{"title":"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>","local":"fileresponsearraybuffer--code-promise--arraybuffer--code","sections":[],"depth":3},{"title":"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>","local":"fileresponseblob--code-promise--blob--code","sections":[],"depth":3},{"title":"fileResponse.text() ⇒ <code> Promise. < string > </code>","local":"fileresponsetext--code-promise--string--code","sections":[],"depth":3},{"title":"fileResponse.json() ⇒ <code> Promise. < Object > </code>","local":"fileresponsejson--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~FileCache","local":"utilshubfilecache","sections":[{"title":"new FileCache(path)","local":"new-filecachepath","sections":[],"depth":3},{"title":"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>","local":"filecachematchrequest--code-promise--fileresponseundefined--code","sections":[],"depth":3},{"title":"fileCache.put(request, response) ⇒ <code> Promise. < void > </code>","local":"filecacheputrequest-response--code-promise--void--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~isValidHttpUrl(string, [validHosts]) ⇒ <code> boolean </code>","local":"utilshubisvalidhttpurlstring-validhosts--code-boolean-code","sections":[],"depth":2},{"title":"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>","local":"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code","sections":[],"depth":2},{"title":"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>","local":"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code","sections":[],"depth":2},{"title":"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>","local":"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code","sections":[],"depth":2},{"title":"utils/hub~pathJoin(...parts) ⇒ <code> string </code>","local":"utilshubpathjoinparts--code-string-code","sections":[],"depth":2},{"title":"utils/hub~PretrainedOptions : <code> Object </code>","local":"utilshubpretrainedoptions--code-object-code","sections":[],"depth":2}],"depth":1}';function hd(zo){return nd(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Td extends rd{constructor(T){super(),ud(this,T,hd,cd,sd,{})}}export{Td as component};
