import{s as Ie,o as Ne,n as Je}from"../chunks/scheduler.182ea377.js";import{S as qe,i as Ae,g as r,s,r as w,A as Ze,h as l,f as n,c as i,j as F,u as x,x as p,k as Q,y as f,a as o,v as y,d as T,t as D,w as $}from"../chunks/index.abf12888.js";import{T as Ee}from"../chunks/Tip.230e2334.js";import{D as we}from"../chunks/Docstring.93f6f462.js";import{C as We}from"../chunks/CodeBlock.57fe6e13.js";import{E as ze}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as xe}from"../chunks/Heading.16916d63.js";function Ve(W){let a,M='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){a=r("p"),a.innerHTML=M},l(c){a=l(c,"P",{"data-svelte-h":!0}),p(a)!=="svelte-1wmc0l4"&&(a.innerHTML=M)},m(c,m){o(c,a,m)},p:Je,d(c){c&&n(a)}}}function Xe(W){let a,M="Examples:",c,m,g;return m=new We({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyME11c2ljTERNUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMHNjaXB5JTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnVjc2QtcmVhY2glMkZtdXNpY2xkbSUyMiUwQXBpcGUlMjAlM0QlMjBNdXNpY0xETVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyVGVjaG5vJTIwbXVzaWMlMjB3aXRoJTIwYSUyMHN0cm9uZyUyQyUyMHVwYmVhdCUyMHRlbXBvJTIwYW5kJTIwaGlnaCUyMG1lbG9kaWMlMjByaWZmcyUyMiUwQWF1ZGlvJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAlMkMlMjBhdWRpb19sZW5ndGhfaW5fcyUzRDUuMCkuYXVkaW9zJTVCMCU1RCUwQSUwQSUyMyUyMHNhdmUlMjB0aGUlMjBhdWRpbyUyMHNhbXBsZSUyMGFzJTIwYSUyMC53YXYlMjBmaWxlJTBBc2NpcHkuaW8ud2F2ZmlsZS53cml0ZSglMjJ0ZWNobm8ud2F2JTIyJTJDJTIwcmF0ZSUzRDE2MDAwJTJDJTIwZGF0YSUzRGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MusicLDMPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;ucsd-reach/musicldm&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = MusicLDMPipeline.from_pretrained(repo_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Techno music with a strong, upbeat tempo and high melodic riffs&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = pipe(prompt, num_inference_steps=<span class="hljs-number">10</span>, audio_length_in_s=<span class="hljs-number">5.0</span>).audios[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save the audio sample as a .wav file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;techno.wav&quot;</span>, rate=<span class="hljs-number">16000</span>, data=audio)`,wrap:!1}}),{c(){a=r("p"),a.textContent=M,c=s(),w(m.$$.fragment)},l(d){a=l(d,"P",{"data-svelte-h":!0}),p(a)!=="svelte-kvfsh7"&&(a.textContent=M),c=i(d),x(m.$$.fragment,d)},m(d,_){o(d,a,_),o(d,c,_),y(m,d,_),g=!0},p:Je,i(d){g||(T(m.$$.fragment,d),g=!0)},o(d){D(m.$$.fragment,d),g=!1},d(d){d&&(n(a),n(c)),$(m,d)}}}function Oe(W){let a,M,c,m,g,d,_,ye=`MusicLDM was proposed in <a href="https://huggingface.co/papers/2308.01546" rel="nofollow">MusicLDM: Enhancing Novelty in Text-to-Music Generation Using Beat-Synchronous Mixup Strategies</a> by Ke Chen, Yusong Wu, Haohe Liu, Marianna Nezhurina, Taylor Berg-Kirkpatrick, Shlomo Dubnov.
MusicLDM takes a text prompt as input and predicts the corresponding music sample.`,Y,k,Te=`Inspired by <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview" rel="nofollow">Stable Diffusion</a> and <a href="https://huggingface.co/docs/diffusers/api/pipelines/audioldm" rel="nofollow">AudioLDM</a>,
MusicLDM is a text-to-music <em>latent diffusion model (LDM)</em> that learns continuous audio representations from <a href="https://huggingface.co/docs/transformers/main/model_doc/clap" rel="nofollow">CLAP</a>
latents.`,K,U,De="MusicLDM is trained on a corpus of 466 hours of music data. Beat-synchronous data augmentation strategies are applied to the music samples, both in the time domain and in the latent space. Using beat-synchronous data augmentation strategies encourages the model to interpolate between the training samples, but stay within the domain of the training data. The result is generated music that is more diverse while staying faithful to the corresponding style.",ee,j,$e="The abstract of the paper is the following:",te,S,Le="<em>Diffusion models have shown promising results in cross-modal generation tasks, including text-to-image and text-to-audio generation. However, generating music, as a special type of audio, presents unique challenges due to limited availability of music data and sensitive issues related to copyright and plagiarism. In this paper, to tackle these challenges, we first construct a state-of-the-art text-to-music model, MusicLDM, that adapts Stable Diffusion and AudioLDM architectures to the music domain. We achieve this by retraining the contrastive language-audio pretraining model (CLAP) and the Hifi-GAN vocoder, as components of MusicLDM, on a collection of music data samples. Then, to address the limitations of training data and to avoid plagiarism, we leverage a beat tracking model and propose two different mixup strategies for data augmentation: beat-synchronous audio mixup and beat-synchronous latent mixup, which recombine training audio directly or via a latent embeddings space, respectively. Such mixup strategies encourage the model to interpolate between musical training samples and generate new music within the convex hull of the training data, making the generated music more diverse while still staying faithful to the corresponding style. In addition to popular evaluation metrics, we design several new evaluation metrics based on CLAP score to demonstrate that our proposed MusicLDM and beat-synchronous mixup strategies improve both the quality and novelty of generated music, as well as the correspondence between input text and generated music.</em>",ne,G,Pe='This pipeline was contributed by <a href="https://huggingface.co/sanchit-gandhi" rel="nofollow">sanchit-gandhi</a>.',oe,H,ae,B,Ce="When constructing a prompt, keep in mind:",se,J,ke="<li>Descriptive prompt inputs work best; use adjectives to describe the sound (for example, “high quality” or “clear”) and make the prompt context specific where possible (e.g. “melodic techno with a fast beat and synths” works better than “techno”).</li> <li>Using a <em>negative prompt</em> can significantly improve the quality of the generated audio. Try using a negative prompt of “low quality, average quality”.</li>",ie,I,Ue="During inference:",re,N,je="<li>The <em>quality</em> of the generated audio sample can be controlled by the <code>num_inference_steps</code> argument; higher steps give higher quality audio at the expense of slower inference.</li> <li>Multiple waveforms can be generated in one go: set <code>num_waveforms_per_prompt</code> to a value greater than 1 to enable. Automatic scoring will be performed between the generated waveforms and prompt text, and the audios ranked from best to worst accordingly.</li> <li>The <em>length</em> of the generated audio sample can be controlled by varying the <code>audio_length_in_s</code> argument.</li>",le,L,de,q,ce,u,A,fe,z,Se="Pipeline for text-to-audio generation using MusicLDM.",he,V,Ge=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,ge,v,Z,_e,X,He="The call function to the pipeline for generation.",Me,P,ve,C,E,be,O,Be=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,pe,R,ue;return g=new xe({props:{title:"MusicLDM",local:"musicldm",headingTag:"h1"}}),H=new xe({props:{title:"Tips",local:"tips",headingTag:"h2"}}),L=new Ee({props:{$$slots:{default:[Ve]},$$scope:{ctx:W}}}),q=new xe({props:{title:"MusicLDMPipeline",local:"diffusers.MusicLDMPipeline",headingTag:"h2"}}),A=new we({props:{name:"class diffusers.MusicLDMPipeline",anchor:"diffusers.MusicLDMPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": Union"},{name:"tokenizer",val:": Union"},{name:"feature_extractor",val:": Optional"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vocoder",val:": SpeechT5HifiGan"}],parametersDescription:[{anchor:"diffusers.MusicLDMPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.MusicLDMPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap#transformers.ClapModel" rel="nofollow">ClapModel</a>) &#x2014;
Frozen text-audio embedding model (<code>ClapTextModel</code>), specifically the
<a href="https://huggingface.co/laion/clap-htsat-unfused" rel="nofollow">laion/clap-htsat-unfused</a> variant.`,name:"text_encoder"},{anchor:"diffusers.MusicLDMPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>PreTrainedTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizer" rel="nofollow">RobertaTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.MusicLDMPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap#transformers.ClapFeatureExtractor" rel="nofollow">ClapFeatureExtractor</a>) &#x2014;
Feature extractor to compute mel-spectrograms from audio waveforms.`,name:"feature_extractor"},{anchor:"diffusers.MusicLDMPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded audio latents.`,name:"unet"},{anchor:"diffusers.MusicLDMPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded audio latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.MusicLDMPipeline.vocoder",description:`<strong>vocoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5HifiGan" rel="nofollow">SpeechT5HifiGan</a>) &#x2014;
Vocoder of class <code>SpeechT5HifiGan</code>.`,name:"vocoder"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/musicldm/pipeline_musicldm.py#L67"}}),Z=new we({props:{name:"__call__",anchor:"diffusers.MusicLDMPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"audio_length_in_s",val:": Optional = None"},{name:"num_inference_steps",val:": int = 200"},{name:"guidance_scale",val:": float = 2.0"},{name:"negative_prompt",val:": Union = None"},{name:"num_waveforms_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": Optional = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"output_type",val:": Optional = 'np'"}],parametersDescription:[{anchor:"diffusers.MusicLDMPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide audio generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.MusicLDMPipeline.__call__.audio_length_in_s",description:`<strong>audio_length_in_s</strong> (<code>int</code>, <em>optional</em>, defaults to 10.24) &#x2014;
The length of the generated audio sample in seconds.`,name:"audio_length_in_s"},{anchor:"diffusers.MusicLDMPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 200) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality audio at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.MusicLDMPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
A higher guidance scale value encourages the model to generate audio that is closely linked to the text
<code>prompt</code> at the expense of lower sound quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.MusicLDMPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in audio generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.MusicLDMPipeline.__call__.num_waveforms_per_prompt",description:`<strong>num_waveforms_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of waveforms to generate per prompt. If <code>num_waveforms_per_prompt &gt; 1</code>, the text encoding
model is a joint text-audio model (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap#transformers.ClapModel" rel="nofollow">ClapModel</a>), and the tokenizer is a
<code>[~transformers.ClapProcessor]</code>, then automatic scoring will be performed between the generated outputs
and the input text. This scoring ranks the generated waveforms based on their cosine similarity to text
input in the joint text-audio embedding space.`,name:"num_waveforms_per_prompt"},{anchor:"diffusers.MusicLDMPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.MusicLDMPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.MusicLDMPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.MusicLDMPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.MusicLDMPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.MusicLDMPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/audioldm#diffusers.AudioPipelineOutput">AudioPipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.MusicLDMPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.MusicLDMPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.MusicLDMPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.MusicLDMPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated audio. Choose between <code>&quot;np&quot;</code> to return a NumPy <code>np.ndarray</code> or
<code>&quot;pt&quot;</code> to return a PyTorch <code>torch.Tensor</code> object. Set to <code>&quot;latent&quot;</code> to return the latent diffusion
model (LDM) output.`,name:"output_type"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/musicldm/pipeline_musicldm.py#L418",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/audioldm#diffusers.AudioPipelineOutput"
>AudioPipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/audioldm#diffusers.AudioPipelineOutput"
>AudioPipelineOutput</a> or <code>tuple</code></p>
`}}),P=new ze({props:{anchor:"diffusers.MusicLDMPipeline.__call__.example",$$slots:{default:[Xe]},$$scope:{ctx:W}}}),E=new we({props:{name:"enable_model_cpu_offload",anchor:"diffusers.MusicLDMPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/musicldm/pipeline_musicldm.py#L384"}}),{c(){a=r("meta"),M=s(),c=r("p"),m=s(),w(g.$$.fragment),d=s(),_=r("p"),_.innerHTML=ye,Y=s(),k=r("p"),k.innerHTML=Te,K=s(),U=r("p"),U.textContent=De,ee=s(),j=r("p"),j.textContent=$e,te=s(),S=r("p"),S.innerHTML=Le,ne=s(),G=r("p"),G.innerHTML=Pe,oe=s(),w(H.$$.fragment),ae=s(),B=r("p"),B.textContent=Ce,se=s(),J=r("ul"),J.innerHTML=ke,ie=s(),I=r("p"),I.textContent=Ue,re=s(),N=r("ul"),N.innerHTML=je,le=s(),w(L.$$.fragment),de=s(),w(q.$$.fragment),ce=s(),u=r("div"),w(A.$$.fragment),fe=s(),z=r("p"),z.textContent=Se,he=s(),V=r("p"),V.innerHTML=Ge,ge=s(),v=r("div"),w(Z.$$.fragment),_e=s(),X=r("p"),X.textContent=He,Me=s(),w(P.$$.fragment),ve=s(),C=r("div"),w(E.$$.fragment),be=s(),O=r("p"),O.innerHTML=Be,pe=s(),R=r("p"),this.h()},l(e){const t=Ze("svelte-u9bgzb",document.head);a=l(t,"META",{name:!0,content:!0}),t.forEach(n),M=i(e),c=l(e,"P",{}),F(c).forEach(n),m=i(e),x(g.$$.fragment,e),d=i(e),_=l(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-dgtsvr"&&(_.innerHTML=ye),Y=i(e),k=l(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-xz1yc5"&&(k.innerHTML=Te),K=i(e),U=l(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-59771y"&&(U.textContent=De),ee=i(e),j=l(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-wu27l3"&&(j.textContent=$e),te=i(e),S=l(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-qsxrno"&&(S.innerHTML=Le),ne=i(e),G=l(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-ig43pw"&&(G.innerHTML=Pe),oe=i(e),x(H.$$.fragment,e),ae=i(e),B=l(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1dvtu0c"&&(B.textContent=Ce),se=i(e),J=l(e,"UL",{"data-svelte-h":!0}),p(J)!=="svelte-1gnv7ni"&&(J.innerHTML=ke),ie=i(e),I=l(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1g0t9wk"&&(I.textContent=Ue),re=i(e),N=l(e,"UL",{"data-svelte-h":!0}),p(N)!=="svelte-1ynscju"&&(N.innerHTML=je),le=i(e),x(L.$$.fragment,e),de=i(e),x(q.$$.fragment,e),ce=i(e),u=l(e,"DIV",{class:!0});var h=F(u);x(A.$$.fragment,h),fe=i(h),z=l(h,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1abu1jx"&&(z.textContent=Se),he=i(h),V=l(h,"P",{"data-svelte-h":!0}),p(V)!=="svelte-496sm0"&&(V.innerHTML=Ge),ge=i(h),v=l(h,"DIV",{class:!0});var b=F(v);x(Z.$$.fragment,b),_e=i(b),X=l(b,"P",{"data-svelte-h":!0}),p(X)!=="svelte-50j04k"&&(X.textContent=He),Me=i(b),x(P.$$.fragment,b),b.forEach(n),ve=i(h),C=l(h,"DIV",{class:!0});var me=F(C);x(E.$$.fragment,me),be=i(me),O=l(me,"P",{"data-svelte-h":!0}),p(O)!=="svelte-d7vywi"&&(O.innerHTML=Be),me.forEach(n),h.forEach(n),pe=i(e),R=l(e,"P",{}),F(R).forEach(n),this.h()},h(){Q(a,"name","hf:doc:metadata"),Q(a,"content",Re),Q(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Q(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Q(u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){f(document.head,a),o(e,M,t),o(e,c,t),o(e,m,t),y(g,e,t),o(e,d,t),o(e,_,t),o(e,Y,t),o(e,k,t),o(e,K,t),o(e,U,t),o(e,ee,t),o(e,j,t),o(e,te,t),o(e,S,t),o(e,ne,t),o(e,G,t),o(e,oe,t),y(H,e,t),o(e,ae,t),o(e,B,t),o(e,se,t),o(e,J,t),o(e,ie,t),o(e,I,t),o(e,re,t),o(e,N,t),o(e,le,t),y(L,e,t),o(e,de,t),y(q,e,t),o(e,ce,t),o(e,u,t),y(A,u,null),f(u,fe),f(u,z),f(u,he),f(u,V),f(u,ge),f(u,v),y(Z,v,null),f(v,_e),f(v,X),f(v,Me),y(P,v,null),f(u,ve),f(u,C),y(E,C,null),f(C,be),f(C,O),o(e,pe,t),o(e,R,t),ue=!0},p(e,[t]){const h={};t&2&&(h.$$scope={dirty:t,ctx:e}),L.$set(h);const b={};t&2&&(b.$$scope={dirty:t,ctx:e}),P.$set(b)},i(e){ue||(T(g.$$.fragment,e),T(H.$$.fragment,e),T(L.$$.fragment,e),T(q.$$.fragment,e),T(A.$$.fragment,e),T(Z.$$.fragment,e),T(P.$$.fragment,e),T(E.$$.fragment,e),ue=!0)},o(e){D(g.$$.fragment,e),D(H.$$.fragment,e),D(L.$$.fragment,e),D(q.$$.fragment,e),D(A.$$.fragment,e),D(Z.$$.fragment,e),D(P.$$.fragment,e),D(E.$$.fragment,e),ue=!1},d(e){e&&(n(M),n(c),n(m),n(d),n(_),n(Y),n(k),n(K),n(U),n(ee),n(j),n(te),n(S),n(ne),n(G),n(oe),n(ae),n(B),n(se),n(J),n(ie),n(I),n(re),n(N),n(le),n(de),n(ce),n(u),n(pe),n(R)),n(a),$(g,e),$(H,e),$(L,e),$(q,e),$(A),$(Z),$(P),$(E)}}}const Re='{"title":"MusicLDM","local":"musicldm","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"MusicLDMPipeline","local":"diffusers.MusicLDMPipeline","sections":[],"depth":2}],"depth":1}';function Fe(W){return Ne(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class at extends qe{constructor(a){super(),Ae(this,a,Fe,Oe,Ie,{})}}export{at as component};
