import{s as fl,f as Ae,n as Il,o as Cl}from"../chunks/scheduler.37c15a92.js";import{S as Bl,i as vl,g as o,s as n,r as y,A as Zl,h as i,f as l,c as a,j as Ge,u as m,x as M,k as p,y as Al,a as s,v as c,d as u,t as w,w as h}from"../chunks/index.2bf4358c.js";import{C as Ze}from"../chunks/CodeBlock.4e987730.js";import{H as Jt}from"../chunks/Heading.8ada512a.js";import{E as Gl}from"../chunks/getInferenceSnippets.b4622733.js";function Wl(We){let T,bt,dt,gt,j,ft,J,_e="In the last section, we learned how we can create Agents from scratch using Python code, and we <strong>saw just how tedious that process can be</strong>. Fortunately, many Agent libraries simplify this work by <strong>handling much of the heavy lifting for you</strong>.",It,d,He="In this tutorial, <strong>you’ll create your very first Agent</strong> capable of performing actions such as image generation, web search, time zone checking and much more!",Ct,U,xe="You will also publish your agent <strong>on a Hugging Face Space so you can share it with friends and colleagues</strong>.",Bt,b,Ee="Let’s get started!",vt,g,Zt,f,ke,At,I,Ve="To make this Agent, we’re going to use <code>smolagents</code>, a library that <strong>provides a framework for developing your agents with ease</strong>.",Gt,C,Re="This lightweight library is designed for simplicity, but it abstracts away much of the complexity of building an Agent, allowing you to focus on designing your agent’s behavior.",Wt,B,Se='We’re going to get deeper into smolagents in the next Unit. Meanwhile, you can also check this <a href="https://huggingface.co/blog/smolagents" target="_blank">blog post</a> or the library’s <a href="https://github.com/huggingface/smolagents" target="_blank">repo in GitHub</a>.',_t,v,Qe="In short, <code>smolagents</code> is a library that focuses on <strong>codeAgent</strong>, a kind of agent that performs <strong>“Actions”</strong> through code blocks, and then <strong>“Observes”</strong> results by executing the code.",Ht,Z,ze="Here is an example of what we’ll build!",xt,A,Ne="We provided our agent with an <strong>Image generation tool</strong> and asked it to generate an image of a cat.",Et,G,Xe="The agent inside <code>smolagents</code> is going to have the <strong>same behaviors as the custom one we built previously</strong>: it’s going <strong>to think, act and observe in cycle</strong> until it reaches a final answer:",kt,r,Fe,Vt,W,$e="Exciting, right?",Rt,_,St,H,Le='To start, duplicate this Space: <a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>',Qt,x,Ye='<p>Thanks to <a href="https://huggingface.co/m-ric" target="_blank">Aymeric</a> for this template! 🙌</p>',zt,E,qe="Duplicating this space means <strong>creating a local copy on your own profile</strong>:",Nt,k,Pe,Xt,V,De="After duplicating the Space, you’ll need to add your Hugging Face API token so your agent can access the model API:",Ft,R,Ke='<li>First, get your Hugging Face token from <a href="https://hf.co/settings/tokens" rel="nofollow">https://hf.co/settings/tokens</a> with permission for inference, if you don’t already have one</li> <li>Go to your duplicated Space and click on the <strong>Settings</strong> tab</li> <li>Scroll down to the <strong>Variables and Secrets</strong> section and click <strong>New Secret</strong></li> <li>Create a secret with the name <code>HF_TOKEN</code> and paste your token as the value</li> <li>Click <strong>Save</strong> to store your token securely</li>',$t,S,Oe='Throughout this lesson, the only file you will need to modify is the (currently incomplete) <strong>“app.py”</strong>. You can see here the <a href="https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py" rel="nofollow">original one in the template</a>. To find yours, go to your copy of the space, then click the <code>Files</code> tab and then on <code>app.py</code> in the directory listing.',Lt,Q,tl="Let’s break down the code together:",Yt,z,el="<li>The file begins with some simple but necessary library imports</li>",qt,N,Pt,X,ll="As outlined earlier, we will directly use the <strong>CodeAgent</strong> class from <strong>smolagents</strong>.",Dt,F,Kt,$,sl='Now let’s get into the tools! If you want a refresher about tools, don’t hesitate to go back to the <a href="tools">Tools</a> section of the course.',Ot,L,te,Y,nl="The Tools are what we are encouraging you to build in this section! We give you two examples:",ee,q,al="<li>A <strong>non-working dummy Tool</strong> that you can modify to make something useful.</li> <li>An <strong>actually working Tool</strong> that gets the current time somewhere in the world.</li>",le,P,ol="To define your tool it is important to:",se,D,il="<li>Provide input and output types for your function, like in <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li><strong>A well formatted docstring</strong>. <code>smolagents</code> is expecting all the arguments to have a <strong>textual description in the docstring</strong>.</li>",ne,K,ae,O,Ml='It uses <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> as the LLM engine. This is a very capable model that we’ll access via the serverless API.',oe,tt,ie,et,rl="This Agent still uses the <code>InferenceClient</code> we saw in an earlier section behind the <strong>InferenceClientModel</strong> class!",Me,lt,pl="We will give more in-depth examples when we present the framework in Unit 2. For now, you need to focus on <strong>adding new tools to the list of tools</strong> using the <code>tools</code> parameter of your Agent.",re,st,yl="For example, you could use the <code>DuckDuckGoSearchTool</code> that was imported in the first line of the code, or you can examine the <code>image_generation_tool</code> that is loaded from the Hub later in the code.",pe,nt,ml="<strong>Adding tools will give your agent new capabilities</strong>, try to be creative here!",ye,at,me,ot,cl="The agent’s system prompt is stored in a separate <code>prompts.yaml</code> file. This file contains predefined instructions that guide the agent’s behavior.",ce,it,ul="Storing prompts in a YAML file allows for easy customization and reuse across different agents or use cases.",ue,Mt,wl='You can check the <a href="https://huggingface.co/spaces/agents-course/First_agent_template/tree/main" rel="nofollow">Space’s file structure</a> to see where the <code>prompts.yaml</code> file is located and how it’s organized within the project.',we,rt,hl="The complete “app.py”:",he,pt,Te,yt,Tl="Your <strong>Goal</strong> is to get familiar with the Space and the Agent.",je,mt,jl="Currently, the agent in the template <strong>does not use any tools, so try to provide it with some of the pre-made ones or even make some new tools yourself!</strong>",Je,ct,Jl="We are eagerly waiting for your amazing agents output in the discord channel <strong>#agents-course-showcase</strong>!",de,Ue,be,ut,dl="Congratulations, you’ve built your first Agent! Don’t hesitate to share it with your friends and colleagues.",ge,wt,Ul="Since this is your first try, it’s perfectly normal if it’s a little buggy or slow. In future units, we’ll learn how to build even better Agents.",fe,ht,bl="The best way to learn is to try, so don’t hesitate to update it, add more tools, try with another model, etc.",Ie,Tt,gl="In the next section, you’re going to fill the final Quiz and get your certificate!",Ce,jt,Be,Ut,ve;return j=new Jt({props:{title:"Let’s Create Our First Agent Using smolagents",local:"lets-create-our-first-agent-using-smolagents",headingTag:"h1"}}),g=new Jt({props:{title:"What is smolagents?",local:"what-is-smolagents",headingTag:"h2"}}),_=new Jt({props:{title:"Let’s build our Agent!",local:"lets-build-our-agent",headingTag:"h2"}}),N=new Ze({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEZpbmFsQW5zd2VyVG9vbCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTJDJTIwbG9hZF90b29sJTJDJTIwdG9vbCUwQWltcG9ydCUyMGRhdGV0aW1lJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBweXR6JTBBaW1wb3J0JTIweWFtbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, FinalAnswerTool, InferenceClientModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml`,wrap:!1}}),F=new Jt({props:{title:"The Tools",local:"the-tools",headingTag:"h3"}}),L=new Ze({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),K=new Jt({props:{title:"The Agent",local:"the-agent",headingTag:"h3"}}),tt=new Ze({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QyMDk2JTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjUlMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCdRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QnJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JvbGVfY29udmVyc2lvbnMlM0ROb25lJTJDJTBBKSUwQSUwQXdpdGglMjBvcGVuKCUyMnByb21wdHMueWFtbCUyMiUyQyUyMCdyJyklMjBhcyUyMHN0cmVhbSUzQSUwQSUyMCUyMCUyMCUyMHByb21wdF90ZW1wbGF0ZXMlMjAlM0QlMjB5YW1sLnNhZmVfbG9hZChzdHJlYW0pJTBBJTIwJTIwJTIwJTIwJTBBJTIzJTIwV2UncmUlMjBjcmVhdGluZyUyMG91ciUyMENvZGVBZ2VudCUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QmZpbmFsX2Fuc3dlciU1RCUyQyUyMCUyMyUyMGFkZCUyMHlvdXIlMjB0b29scyUyMGhlcmUlMjAoZG9uJ3QlMjByZW1vdmUlMjBmaW5hbF9hbnN3ZXIpJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNENiUyQyUwQSUyMCUyMCUyMCUyMHZlcmJvc2l0eV9sZXZlbCUzRDElMkMlMEElMjAlMjAlMjAlMjBncmFtbWFyJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHBsYW5uaW5nX2ludGVydmFsJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3RlbXBsYXRlcyUzRHByb21wdF90ZW1wbGF0ZXMlMEEpJTBBJTBBR3JhZGlvVUkoYWdlbnQpLmxhdW5jaCgp",highlighted:`final_answer = FinalAnswerTool()
model = InferenceClientModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
<span class="hljs-comment"># We&#x27;re creating our CodeAgent</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),at=new Jt({props:{title:"The System Prompt",local:"the-system-prompt",headingTag:"h3"}}),pt=new Ze({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># Below is an example of a tool that does nothing. Amaze us with your creativity!</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = InferenceClientModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)


<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Load system prompt from prompt.yaml file</span>
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates <span class="hljs-comment"># Pass system prompt to CodeAgent</span>
)


GradioUI(agent).launch()`,wrap:!1}}),jt=new Gl({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/tutorial.mdx"}}),{c(){T=o("meta"),bt=n(),dt=o("p"),gt=n(),y(j.$$.fragment),ft=n(),J=o("p"),J.innerHTML=_e,It=n(),d=o("p"),d.innerHTML=He,Ct=n(),U=o("p"),U.innerHTML=xe,Bt=n(),b=o("p"),b.textContent=Ee,vt=n(),y(g.$$.fragment),Zt=n(),f=o("img"),At=n(),I=o("p"),I.innerHTML=Ve,Gt=n(),C=o("p"),C.textContent=Re,Wt=n(),B=o("p"),B.innerHTML=Se,_t=n(),v=o("p"),v.innerHTML=Qe,Ht=n(),Z=o("p"),Z.textContent=ze,xt=n(),A=o("p"),A.innerHTML=Ne,Et=n(),G=o("p"),G.innerHTML=Xe,kt=n(),r=o("iframe"),Vt=n(),W=o("p"),W.textContent=$e,Rt=n(),y(_.$$.fragment),St=n(),H=o("p"),H.innerHTML=Le,Qt=n(),x=o("blockquote"),x.innerHTML=Ye,zt=n(),E=o("p"),E.innerHTML=qe,Nt=n(),k=o("img"),Xt=n(),V=o("p"),V.textContent=De,Ft=n(),R=o("ol"),R.innerHTML=Ke,$t=n(),S=o("p"),S.innerHTML=Oe,Lt=n(),Q=o("p"),Q.textContent=tl,Yt=n(),z=o("ul"),z.innerHTML=el,qt=n(),y(N.$$.fragment),Pt=n(),X=o("p"),X.innerHTML=ll,Dt=n(),y(F.$$.fragment),Kt=n(),$=o("p"),$.innerHTML=sl,Ot=n(),y(L.$$.fragment),te=n(),Y=o("p"),Y.textContent=nl,ee=n(),q=o("ol"),q.innerHTML=al,le=n(),P=o("p"),P.textContent=ol,se=n(),D=o("ol"),D.innerHTML=il,ne=n(),y(K.$$.fragment),ae=n(),O=o("p"),O.innerHTML=Ml,oe=n(),y(tt.$$.fragment),ie=n(),et=o("p"),et.innerHTML=rl,Me=n(),lt=o("p"),lt.innerHTML=pl,re=n(),st=o("p"),st.innerHTML=yl,pe=n(),nt=o("p"),nt.innerHTML=ml,ye=n(),y(at.$$.fragment),me=n(),ot=o("p"),ot.innerHTML=cl,ce=n(),it=o("p"),it.textContent=ul,ue=n(),Mt=o("p"),Mt.innerHTML=wl,we=n(),rt=o("p"),rt.textContent=hl,he=n(),y(pt.$$.fragment),Te=n(),yt=o("p"),yt.innerHTML=Tl,je=n(),mt=o("p"),mt.innerHTML=jl,Je=n(),ct=o("p"),ct.innerHTML=Jl,de=n(),Ue=o("hr"),be=n(),ut=o("p"),ut.textContent=dl,ge=n(),wt=o("p"),wt.textContent=Ul,fe=n(),ht=o("p"),ht.textContent=bl,Ie=n(),Tt=o("p"),Tt.textContent=gl,Ce=n(),y(jt.$$.fragment),Be=n(),Ut=o("p"),this.h()},l(t){const e=Zl("svelte-u9bgzb",document.head);T=i(e,"META",{name:!0,content:!0}),e.forEach(l),bt=a(t),dt=i(t,"P",{}),Ge(dt).forEach(l),gt=a(t),m(j.$$.fragment,t),ft=a(t),J=i(t,"P",{"data-svelte-h":!0}),M(J)!=="svelte-gmmoh4"&&(J.innerHTML=_e),It=a(t),d=i(t,"P",{"data-svelte-h":!0}),M(d)!=="svelte-isl0ka"&&(d.innerHTML=He),Ct=a(t),U=i(t,"P",{"data-svelte-h":!0}),M(U)!=="svelte-zy1mev"&&(U.innerHTML=xe),Bt=a(t),b=i(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-4b3xjd"&&(b.textContent=Ee),vt=a(t),m(g.$$.fragment,t),Zt=a(t),f=i(t,"IMG",{src:!0,alt:!0}),At=a(t),I=i(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1bet7no"&&(I.innerHTML=Ve),Gt=a(t),C=i(t,"P",{"data-svelte-h":!0}),M(C)!=="svelte-oceeap"&&(C.textContent=Re),Wt=a(t),B=i(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1wfbi7x"&&(B.innerHTML=Se),_t=a(t),v=i(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1kxxgvd"&&(v.innerHTML=Qe),Ht=a(t),Z=i(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1x3dozw"&&(Z.textContent=ze),xt=a(t),A=i(t,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1kwa3nr"&&(A.innerHTML=Ne),Et=a(t),G=i(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-4nw0u8"&&(G.innerHTML=Xe),kt=a(t),r=i(t,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),Ge(r).forEach(l),Vt=a(t),W=i(t,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1riubhm"&&(W.textContent=$e),Rt=a(t),m(_.$$.fragment,t),St=a(t),H=i(t,"P",{"data-svelte-h":!0}),M(H)!=="svelte-3pukde"&&(H.innerHTML=Le),Qt=a(t),x=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(x)!=="svelte-1lji2e8"&&(x.innerHTML=Ye),zt=a(t),E=i(t,"P",{"data-svelte-h":!0}),M(E)!=="svelte-xpoxi8"&&(E.innerHTML=qe),Nt=a(t),k=i(t,"IMG",{src:!0,alt:!0}),Xt=a(t),V=i(t,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1to4f3l"&&(V.textContent=De),Ft=a(t),R=i(t,"OL",{"data-svelte-h":!0}),M(R)!=="svelte-1dpkmu0"&&(R.innerHTML=Ke),$t=a(t),S=i(t,"P",{"data-svelte-h":!0}),M(S)!=="svelte-e4oew5"&&(S.innerHTML=Oe),Lt=a(t),Q=i(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-xgl3rm"&&(Q.textContent=tl),Yt=a(t),z=i(t,"UL",{"data-svelte-h":!0}),M(z)!=="svelte-g8ecnx"&&(z.innerHTML=el),qt=a(t),m(N.$$.fragment,t),Pt=a(t),X=i(t,"P",{"data-svelte-h":!0}),M(X)!=="svelte-eq9rdr"&&(X.innerHTML=ll),Dt=a(t),m(F.$$.fragment,t),Kt=a(t),$=i(t,"P",{"data-svelte-h":!0}),M($)!=="svelte-1qrccm5"&&($.innerHTML=sl),Ot=a(t),m(L.$$.fragment,t),te=a(t),Y=i(t,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-qrpozm"&&(Y.textContent=nl),ee=a(t),q=i(t,"OL",{"data-svelte-h":!0}),M(q)!=="svelte-12muy28"&&(q.innerHTML=al),le=a(t),P=i(t,"P",{"data-svelte-h":!0}),M(P)!=="svelte-mmcol7"&&(P.textContent=ol),se=a(t),D=i(t,"OL",{"data-svelte-h":!0}),M(D)!=="svelte-p349vr"&&(D.innerHTML=il),ne=a(t),m(K.$$.fragment,t),ae=a(t),O=i(t,"P",{"data-svelte-h":!0}),M(O)!=="svelte-16qafzg"&&(O.innerHTML=Ml),oe=a(t),m(tt.$$.fragment,t),ie=a(t),et=i(t,"P",{"data-svelte-h":!0}),M(et)!=="svelte-k111f3"&&(et.innerHTML=rl),Me=a(t),lt=i(t,"P",{"data-svelte-h":!0}),M(lt)!=="svelte-t0wd0t"&&(lt.innerHTML=pl),re=a(t),st=i(t,"P",{"data-svelte-h":!0}),M(st)!=="svelte-1m08tlu"&&(st.innerHTML=yl),pe=a(t),nt=i(t,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-13ckn13"&&(nt.innerHTML=ml),ye=a(t),m(at.$$.fragment,t),me=a(t),ot=i(t,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-1wl8y4j"&&(ot.innerHTML=cl),ce=a(t),it=i(t,"P",{"data-svelte-h":!0}),M(it)!=="svelte-dchyno"&&(it.textContent=ul),ue=a(t),Mt=i(t,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-1sn4nls"&&(Mt.innerHTML=wl),we=a(t),rt=i(t,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-11duvvf"&&(rt.textContent=hl),he=a(t),m(pt.$$.fragment,t),Te=a(t),yt=i(t,"P",{"data-svelte-h":!0}),M(yt)!=="svelte-1djj761"&&(yt.innerHTML=Tl),je=a(t),mt=i(t,"P",{"data-svelte-h":!0}),M(mt)!=="svelte-1xqfrp"&&(mt.innerHTML=jl),Je=a(t),ct=i(t,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-h3h5uq"&&(ct.innerHTML=Jl),de=a(t),Ue=i(t,"HR",{}),be=a(t),ut=i(t,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-1vcdjz4"&&(ut.textContent=dl),ge=a(t),wt=i(t,"P",{"data-svelte-h":!0}),M(wt)!=="svelte-10mjkny"&&(wt.textContent=Ul),fe=a(t),ht=i(t,"P",{"data-svelte-h":!0}),M(ht)!=="svelte-10xgfu5"&&(ht.textContent=bl),Ie=a(t),Tt=i(t,"P",{"data-svelte-h":!0}),M(Tt)!=="svelte-1s9m3df"&&(Tt.textContent=gl),Ce=a(t),m(jt.$$.fragment,t),Be=a(t),Ut=i(t,"P",{}),Ge(Ut).forEach(l),this.h()},h(){p(T,"name","hf:doc:metadata"),p(T,"content",_l),Ae(f.src,ke="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||p(f,"src",ke),p(f,"alt","smolagents"),p(r,"width","560"),p(r,"height","315"),Ae(r.src,Fe="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA")||p(r,"src",Fe),p(r,"title","YouTube video player"),p(r,"frameborder","0"),p(r,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),p(r,"referrerpolicy","strict-origin-when-cross-origin"),r.allowFullscreen="",Ae(k.src,Pe="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||p(k,"src",Pe),p(k,"alt","Duplicate")},m(t,e){Al(document.head,T),s(t,bt,e),s(t,dt,e),s(t,gt,e),c(j,t,e),s(t,ft,e),s(t,J,e),s(t,It,e),s(t,d,e),s(t,Ct,e),s(t,U,e),s(t,Bt,e),s(t,b,e),s(t,vt,e),c(g,t,e),s(t,Zt,e),s(t,f,e),s(t,At,e),s(t,I,e),s(t,Gt,e),s(t,C,e),s(t,Wt,e),s(t,B,e),s(t,_t,e),s(t,v,e),s(t,Ht,e),s(t,Z,e),s(t,xt,e),s(t,A,e),s(t,Et,e),s(t,G,e),s(t,kt,e),s(t,r,e),s(t,Vt,e),s(t,W,e),s(t,Rt,e),c(_,t,e),s(t,St,e),s(t,H,e),s(t,Qt,e),s(t,x,e),s(t,zt,e),s(t,E,e),s(t,Nt,e),s(t,k,e),s(t,Xt,e),s(t,V,e),s(t,Ft,e),s(t,R,e),s(t,$t,e),s(t,S,e),s(t,Lt,e),s(t,Q,e),s(t,Yt,e),s(t,z,e),s(t,qt,e),c(N,t,e),s(t,Pt,e),s(t,X,e),s(t,Dt,e),c(F,t,e),s(t,Kt,e),s(t,$,e),s(t,Ot,e),c(L,t,e),s(t,te,e),s(t,Y,e),s(t,ee,e),s(t,q,e),s(t,le,e),s(t,P,e),s(t,se,e),s(t,D,e),s(t,ne,e),c(K,t,e),s(t,ae,e),s(t,O,e),s(t,oe,e),c(tt,t,e),s(t,ie,e),s(t,et,e),s(t,Me,e),s(t,lt,e),s(t,re,e),s(t,st,e),s(t,pe,e),s(t,nt,e),s(t,ye,e),c(at,t,e),s(t,me,e),s(t,ot,e),s(t,ce,e),s(t,it,e),s(t,ue,e),s(t,Mt,e),s(t,we,e),s(t,rt,e),s(t,he,e),c(pt,t,e),s(t,Te,e),s(t,yt,e),s(t,je,e),s(t,mt,e),s(t,Je,e),s(t,ct,e),s(t,de,e),s(t,Ue,e),s(t,be,e),s(t,ut,e),s(t,ge,e),s(t,wt,e),s(t,fe,e),s(t,ht,e),s(t,Ie,e),s(t,Tt,e),s(t,Ce,e),c(jt,t,e),s(t,Be,e),s(t,Ut,e),ve=!0},p:Il,i(t){ve||(u(j.$$.fragment,t),u(g.$$.fragment,t),u(_.$$.fragment,t),u(N.$$.fragment,t),u(F.$$.fragment,t),u(L.$$.fragment,t),u(K.$$.fragment,t),u(tt.$$.fragment,t),u(at.$$.fragment,t),u(pt.$$.fragment,t),u(jt.$$.fragment,t),ve=!0)},o(t){w(j.$$.fragment,t),w(g.$$.fragment,t),w(_.$$.fragment,t),w(N.$$.fragment,t),w(F.$$.fragment,t),w(L.$$.fragment,t),w(K.$$.fragment,t),w(tt.$$.fragment,t),w(at.$$.fragment,t),w(pt.$$.fragment,t),w(jt.$$.fragment,t),ve=!1},d(t){t&&(l(bt),l(dt),l(gt),l(ft),l(J),l(It),l(d),l(Ct),l(U),l(Bt),l(b),l(vt),l(Zt),l(f),l(At),l(I),l(Gt),l(C),l(Wt),l(B),l(_t),l(v),l(Ht),l(Z),l(xt),l(A),l(Et),l(G),l(kt),l(r),l(Vt),l(W),l(Rt),l(St),l(H),l(Qt),l(x),l(zt),l(E),l(Nt),l(k),l(Xt),l(V),l(Ft),l(R),l($t),l(S),l(Lt),l(Q),l(Yt),l(z),l(qt),l(Pt),l(X),l(Dt),l(Kt),l($),l(Ot),l(te),l(Y),l(ee),l(q),l(le),l(P),l(se),l(D),l(ne),l(ae),l(O),l(oe),l(ie),l(et),l(Me),l(lt),l(re),l(st),l(pe),l(nt),l(ye),l(me),l(ot),l(ce),l(it),l(ue),l(Mt),l(we),l(rt),l(he),l(Te),l(yt),l(je),l(mt),l(Je),l(ct),l(de),l(Ue),l(be),l(ut),l(ge),l(wt),l(fe),l(ht),l(Ie),l(Tt),l(Ce),l(Be),l(Ut)),l(T),h(j,t),h(g,t),h(_,t),h(N,t),h(F,t),h(L,t),h(K,t),h(tt,t),h(at,t),h(pt,t),h(jt,t)}}}const _l='{"title":"Let’s Create Our First Agent Using smolagents","local":"lets-create-our-first-agent-using-smolagents","sections":[{"title":"What is smolagents?","local":"what-is-smolagents","sections":[],"depth":2},{"title":"Let’s build our Agent!","local":"lets-build-our-agent","sections":[{"title":"The Tools","local":"the-tools","sections":[],"depth":3},{"title":"The Agent","local":"the-agent","sections":[],"depth":3},{"title":"The System Prompt","local":"the-system-prompt","sections":[],"depth":3}],"depth":2}],"depth":1}';function Hl(We){return Cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sl extends Bl{constructor(T){super(),vl(this,T,Hl,Wl,fl,{})}}export{Sl as component};
