import{s as Ns,f as _l,n as Ps,o as Fs}from"../chunks/scheduler.37c15a92.js";import{S as Ks,i as Ds,g as a,s as n,r as p,A as Os,h as o,f as l,c as i,j as Ll,u as r,x as M,k as c,y as Gl,a as s,v as u,d as w,t as T,w as y}from"../chunks/index.2bf4358c.js";import{C as m}from"../chunks/CodeBlock.4e987730.js";import{H as qt}from"../chunks/Heading.8ada512a.js";import{E as tn}from"../chunks/getInferenceSnippets.b4622733.js";function en(Wl){let J,Kt,Pt,Dt,h,Ot,d,$l,te,I,kl="One crucial aspect of AI Agents is their ability to take <strong>actions</strong>. As we saw, this happens through the use of <strong>Tools</strong>.",ee,U,El="In this section, we’ll learn what Tools are, how to design them effectively, and how to integrate them into your Agent via the System Message.",le,f,Rl="By giving your Agent the right Tools—and clearly describing how those Tools work—you can dramatically increase what your AI can accomplish. Let’s dive in!",se,C,ne,b,Zl="A <strong>Tool is a function given to the LLM</strong>. This function should fulfill a <strong>clear objective</strong>.",ie,A,Sl="Here are some commonly used tools in AI agents:",ae,v,Vl="<thead><tr><th>Tool</th> <th>Description</th></tr></thead> <tbody><tr><td>Web Search</td> <td>Allows the agent to fetch up-to-date information from the internet.</td></tr> <tr><td>Image Generation</td> <td>Creates images based on text descriptions.</td></tr> <tr><td>Retrieval</td> <td>Retrieves information from an external source.</td></tr> <tr><td>API Interface</td> <td>Interacts with an external API (GitHub, YouTube, Spotify, etc.).</td></tr></tbody>",oe,g,Ql="Those are only examples, as you can in fact create a tool for any use case!",Me,B,Yl="A good tool should be something that <strong>complements the power of an LLM</strong>.",pe,x,zl="For instance, if you need to perform arithmetic, giving a <strong>calculator tool</strong> to your LLM will provide better results than relying on the native capabilities of the model.",re,_,Xl="Furthermore, <strong>LLMs predict the completion of a prompt based on their training data</strong>, which means that their internal knowledge only includes events prior to their training. Therefore, if your agent needs up-to-date data you must provide it through some tool.",ue,H,ql="For instance, if you ask an LLM directly (without a search tool) for today’s weather, the LLM will potentially hallucinate random weather.",we,L,Nl,Te,G,Pl="<li><p>A Tool should contain:</p> <ul><li>A <strong>textual description of what the function does</strong>.</li> <li>A <em>Callable</em> (something to perform an action).</li> <li><em>Arguments</em> with typings.</li> <li>(Optional) Outputs with typings.</li></ul></li>",ye,W,ce,$,Fl="LLMs, as we saw, can only receive text inputs and generate text outputs. They have no way to call tools on their own. When we talk about providing tools to an Agent, we mean teaching the LLM about the existence of these tools and instructing it to generate text-based invocations when needed.",Je,k,Kl="For example, if we provide a tool to check the weather at a location from the internet and then ask the LLM about the weather in Paris, the LLM will recognize that this is an opportunity to use the “weather” tool. Instead of retrieving the weather data itself, the LLM will generate text that represents a tool call, such as call weather_tool(‘Paris’).",me,E,Dl="The <strong>Agent</strong> then reads this response, identifies that a tool call is required, executes the tool on the LLM’s behalf, and retrieves the actual weather data.",je,R,Ol="The Tool-calling steps are typically not shown to the user: the Agent appends them as a new message before passing the updated conversation to the LLM again. The LLM then processes this additional context and generates a natural-sounding response for the user. From the user’s perspective, it appears as if the LLM directly interacted with the tool, but in reality, it was the Agent that handled the entire execution process in the background.",he,Z,ts="We’ll talk a lot more about this process in future sessions.",de,S,Ie,V,es="The complete answer may seem overwhelming, but we essentially use the system prompt to provide textual descriptions of available tools to the model:",Ue,Q,ls,fe,Y,ss="For this to work, we have to be very precise and accurate about:",Ce,z,ns="<li><strong>What the tool does</strong></li> <li><strong>What exact inputs it expects</strong></li>",be,X,is="This is the reason why tool descriptions are usually provided using expressive but precise structures, such as computer languages or JSON. It’s not <em>necessary</em> to do it like that, any precise and coherent format would work.",Ae,q,as="If this seems too theoretical, let’s understand it through a concrete example.",ve,N,os="We will implement a simplified <strong>calculator</strong> tool that will just multiply two integers. This could be our Python implementation:",ge,P,Be,F,Ms="So our tool is called <code>calculator</code>, it <strong>multiplies two integers</strong>, and it requires the following inputs:",xe,K,ps="<li><strong><code>a</code></strong> (<em>int</em>): An integer.</li> <li><strong><code>b</code></strong> (<em>int</em>): An integer.</li>",_e,D,rs="The output of the tool is another integer number that we can describe like this:",He,O,us="<li>(<em>int</em>): The product of <code>a</code> and <code>b</code>.</li>",Le,tt,ws="All of these details are important. Let’s put them together in a text string that describes our tool for the LLM to understand.",Ge,et,We,lt,Ts="<p><strong>Reminder:</strong> This textual description is <em>what we want the LLM to know about the tool</em>.</p>",$e,st,ys="When we pass the previous string as part of the input to the LLM, the model will recognize it as a tool, and will know what it needs to pass as inputs and what to expect from the output.",ke,nt,cs="If we want to provide additional tools, we must be consistent and always use the same format. This process can be fragile, and we might accidentally overlook some details.",Ee,it,Js="Is there a better way?",Re,at,Ze,ot,ms="Our tool was written in Python, and the implementation already provides everything we need:",Se,Mt,js="<li>A descriptive name of what it does: <code>calculator</code></li> <li>A longer description, provided by the function’s docstring comment: <code>Multiply two integers.</code></li> <li>The inputs and their type: the function clearly expects two <code>int</code>s.</li> <li>The type of the output.</li>",Ve,pt,hs="There’s a reason people use programming languages: they are expressive, concise, and precise.",Qe,rt,ds="We could provide the Python source code as the <em>specification</em> of the tool for the LLM, but the way the tool is implemented does not matter. All that matters is its name, what it does, the inputs it expects and the output it provides.",Ye,ut,Is="We will leverage Python’s introspection features to leverage the source code and build a tool description automatically for us. All we need is that the tool implementation uses type hints, docstrings, and sensible function names. We will write some code to extract the relevant portions from the source code.",ze,wt,Us="After we are done, we’ll only need to use a Python decorator to indicate that the <code>calculator</code> function is a tool:",Xe,Tt,qe,yt,fs="Note the <code>@tool</code> decorator before the function definition.",Ne,ct,Cs="With the implementation we’ll see next, we will be able to retrieve the following text automatically from the source code via the <code>to_string()</code> function provided by the decorator:",Pe,Jt,Fe,mt,bs="As you can see, it’s the same thing we wrote manually before!",Ke,jt,De,ht,As="We create a generic <code>Tool</code> class that we can reuse whenever we need to use a tool.",Oe,dt,vs="<p><strong>Disclaimer:</strong> This example implementation is fictional but closely resembles real implementations in most libraries.</p>",tl,It,el,Ut,gs="It may seem complicated, but if we go slowly through it we can see what it does. We define a <strong><code>Tool</code></strong> class that includes:",ll,ft,Bs="<li><strong><code>name</code></strong> (<em>str</em>): The name of the tool.</li> <li><strong><code>description</code></strong> (<em>str</em>): A brief description of what the tool does.</li> <li><strong><code>function</code></strong> (<em>callable</em>): The function the tool executes.</li> <li><strong><code>arguments</code></strong> (<em>list</em>): The expected input parameters.</li> <li><strong><code>outputs</code></strong> (<em>str</em> or <em>list</em>): The expected outputs of the tool.</li> <li><strong><code>__call__()</code></strong>: Calls the function when the tool instance is invoked.</li> <li><strong><code>to_string()</code></strong>: Converts the tool’s attributes into a textual representation.</li>",sl,Ct,xs="We could create a Tool with this class using code like the following:",nl,bt,il,At,_s="But we can also use Python’s <code>inspect</code> module to retrieve all the information for us! This is what the <code>@tool</code> decorator does.",al,vt,Hs="<p>If you are interested, you can disclose the following section to look at the decorator implementation.</p>",ol,j,Nt,Ls="decorator code",Hl,gt,Ml,Bt,Gs="Just to reiterate, with this decorator in place we can implement our tool like this:",pl,xt,rl,_t,Ws="And we can use the <code>Tool</code>’s <code>to_string</code> method to automatically retrieve a text suitable to be used as a tool description for an LLM:",ul,Ht,wl,Lt,$s="The description is <strong>injected</strong> in the system prompt. Taking the example with which we started this section, here is how it would look like after replacing the <code>tools_description</code>:",Tl,Gt,ks,yl,Wt,Es='In the <a href="actions">Actions</a> section, we will learn more about how an Agent can <strong>Call</strong> this tool we just created.',cl,$t,Jl,kt,Rs=`Model Context Protocol (MCP) is an <strong>open protocol</strong> that standardizes how applications <strong>provide tools to LLMs</strong>.
MCP provides:`,ml,Et,Zs="<li>A growing list of pre-built integrations that your LLM can directly plug into</li> <li>The flexibility to switch between LLM providers and vendors</li> <li>Best practices for securing your data within your infrastructure</li>",jl,Rt,Ss="This means that <strong>any framework implementing MCP can leverage tools defined within the protocol</strong>, eliminating the need to reimplement the same tool interface for each framework.",hl,Zt,Vs='If you want to dive deeper about MCP, you can check our <a href="https://huggingface.co/learn/mcp-course/" rel="nofollow">free MCP Course</a>.',dl,Il,Ul,St,Qs="Tools play a crucial role in enhancing the capabilities of AI agents.",fl,Vt,Ys="To summarize, we learned:",Cl,Qt,zs="<li><p><em>What Tools Are</em>: Functions that give LLMs extra capabilities, such as performing calculations or accessing external data.</p></li> <li><p><em>How to Define a Tool</em>: By providing a clear textual description, inputs, outputs, and a callable function.</p></li> <li><p><em>Why Tools Are Essential</em>: They enable Agents to overcome the limitations of static model training, handle real-time tasks, and perform specialized actions.</p></li>",bl,Yt,Xs='Now, we can move on to the <a href="agent-steps-and-structure">Agent Workflow</a> where you’ll see how an Agent observes, thinks, and acts. This <strong>brings together everything we’ve covered so far</strong> and sets the stage for creating your own fully functional AI Agent.',Al,zt,qs="But first, it’s time for another short quiz!",vl,Xt,gl,Ft,Bl;return h=new qt({props:{title:"What are Tools?",local:"what-are-tools",headingTag:"h1"}}),C=new qt({props:{title:"What are AI Tools?",local:"what-are-ai-tools",headingTag:"h2"}}),W=new qt({props:{title:"How do tools work?",local:"how-do-tools-work",headingTag:"h2"}}),S=new qt({props:{title:"How do we give tools to an LLM?",local:"how-do-we-give-tools-to-an-llm",headingTag:"h2"}}),P=new m({props:{code:"ZGVmJTIwY2FsY3VsYXRvcihhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwaW50JTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyTXVsdGlwbHklMjB0d28lMjBpbnRlZ2Vycy4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwKiUyMGI=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b`,wrap:!1}}),et=new m({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:"Tool Name: calculator, Description: Multiply two integers., Arguments: a: int, b: int, Outputs: int",wrap:!1}}),at=new qt({props:{title:"Auto-formatting Tool sections",local:"auto-formatting-tool-sections",headingTag:"h3"}}),Tt=new m({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),Jt=new m({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:"Tool Name: calculator, Description: Multiply two integers., Arguments: a: int, b: int, Outputs: int",wrap:!1}}),jt=new qt({props:{title:"Generic Tool implementation",local:"generic-tool-implementation",headingTag:"h3"}}),It=new m({props:{code:"ZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMENhbGxhYmxlJTBBJTBBJTBBY2xhc3MlMjBUb29sJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwQSUyMGNsYXNzJTIwcmVwcmVzZW50aW5nJTIwYSUyMHJldXNhYmxlJTIwcGllY2UlMjBvZiUyMGNvZGUlMjAoVG9vbCkuJTBBJTBBJTIwJTIwJTIwJTIwQXR0cmlidXRlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5hbWUlMjAoc3RyKSUzQSUyME5hbWUlMjBvZiUyMHRoZSUyMHRvb2wuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAoc3RyKSUzQSUyMEElMjB0ZXh0dWFsJTIwZGVzY3JpcHRpb24lMjBvZiUyMHdoYXQlMjB0aGUlMjB0b29sJTIwZG9lcy4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmdW5jJTIwKGNhbGxhYmxlKSUzQSUyMFRoZSUyMGZ1bmN0aW9uJTIwdGhpcyUyMHRvb2wlMjB3cmFwcy4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmd1bWVudHMlMjAobGlzdCklM0ElMjBBJTIwbGlzdCUyMG9mJTIwYXJndW1lbnQuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMChzdHIlMjBvciUyMGxpc3QpJTNBJTIwVGhlJTIwcmV0dXJuJTIwdHlwZShzKSUyMG9mJTIwdGhlJTIwd3JhcHBlZCUyMGZ1bmN0aW9uLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNBJTIwc3RyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0ElMjBzdHIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmdW5jJTNBJTIwQ2FsbGFibGUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmd1bWVudHMlM0ElMjBsaXN0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm5hbWUlMjAlM0QlMjBuYW1lJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5kZXNjcmlwdGlvbiUyMCUzRCUyMGRlc2NyaXB0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5mdW5jJTIwJTNEJTIwZnVuYyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYXJndW1lbnRzJTIwJTNEJTIwYXJndW1lbnRzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5vdXRwdXRzJTIwJTNEJTIwb3V0cHV0cyUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHRvX3N0cmluZyhzZWxmKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSZXR1cm4lMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMHRvb2wlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbmNsdWRpbmclMjBpdHMlMjBuYW1lJTJDJTIwZGVzY3JpcHRpb24lMkMlMjBhcmd1bWVudHMlMkMlMjBhbmQlMjBvdXRwdXRzLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFyZ3Nfc3RyJTIwJTNEJTIwJTIyJTJDJTIwJTIyLmpvaW4oJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMiU3QmFyZ19uYW1lJTdEJTNBJTIwJTdCYXJnX3R5cGUlN0QlMjIlMjBmb3IlMjBhcmdfbmFtZSUyQyUyMGFyZ190eXBlJTIwaW4lMjBzZWxmLmFyZ3VtZW50cyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMlRvb2wlMjBOYW1lJTNBJTIwJTdCc2VsZi5uYW1lJTdEJTJDJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMiUyMERlc2NyaXB0aW9uJTNBJTIwJTdCc2VsZi5kZXNjcmlwdGlvbiU3RCUyQyUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjIlMjBBcmd1bWVudHMlM0ElMjAlN0JhcmdzX3N0ciU3RCUyQyUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjIlMjBPdXRwdXRzJTNBJTIwJTdCc2VsZi5vdXRwdXRzJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYlMkMlMjAqYXJncyUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEludm9rZSUyMHRoZSUyMHVuZGVybHlpbmclMjBmdW5jdGlvbiUyMChjYWxsYWJsZSklMjB3aXRoJTIwcHJvdmlkZWQlMjBhcmd1bWVudHMuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5mdW5jKCphcmdzJTJDJTIwKiprd2FyZ3Mp",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Callable</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">Tool</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    A class representing a reusable piece of code (Tool).

    Attributes:
        name (str): Name of the tool.
        description (str): A textual description of what the tool does.
        func (callable): The function this tool wraps.
        arguments (list): A list of argument.
        outputs (str or list): The return type(s) of the wrapped function.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self,
                 name: <span class="hljs-built_in">str</span>,
                 description: <span class="hljs-built_in">str</span>,
                 func: <span class="hljs-type">Callable</span>,
                 arguments: <span class="hljs-built_in">list</span>,
                 outputs: <span class="hljs-built_in">str</span></span>):
        self.name = name
        self.description = description
        self.func = func
        self.arguments = arguments
        self.outputs = outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_string</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return a string representation of the tool,
        including its name, description, arguments, and outputs.
        &quot;&quot;&quot;</span>
        args_str = <span class="hljs-string">&quot;, &quot;</span>.join([
            <span class="hljs-string">f&quot;<span class="hljs-subst">{arg_name}</span>: <span class="hljs-subst">{arg_type}</span>&quot;</span> <span class="hljs-keyword">for</span> arg_name, arg_type <span class="hljs-keyword">in</span> self.arguments
        ])

        <span class="hljs-keyword">return</span> (
            <span class="hljs-string">f&quot;Tool Name: <span class="hljs-subst">{self.name}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Description: <span class="hljs-subst">{self.description}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Arguments: <span class="hljs-subst">{args_str}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Outputs: <span class="hljs-subst">{self.outputs}</span>&quot;</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, *args, **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Invoke the underlying function (callable) with provided arguments.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> self.func(*args, **kwargs)`,wrap:!1}}),bt=new m({props:{code:"Y2FsY3VsYXRvcl90b29sJTIwJTNEJTIwVG9vbCglMEElMjAlMjAlMjAlMjAlMjJjYWxjdWxhdG9yJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbmFtZSUwQSUyMCUyMCUyMCUyMCUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZGVzY3JpcHRpb24lMEElMjAlMjAlMjAlMjBjYWxjdWxhdG9yJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZnVuY3Rpb24lMjB0byUyMGNhbGwlMEElMjAlMjAlMjAlMjAlNUIoJTIyYSUyMiUyQyUyMCUyMmludCUyMiklMkMlMjAoJTIyYiUyMiUyQyUyMCUyMmludCUyMiklNUQlMkMlMjAlMjAlMjAlMjMlMjBpbnB1dHMlMjAobmFtZXMlMjBhbmQlMjB0eXBlcyklMEElMjAlMjAlMjAlMjAlMjJpbnQlMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBvdXRwdXQlMEEp",highlighted:`calculator_tool = Tool(
    <span class="hljs-string">&quot;calculator&quot;</span>,                   <span class="hljs-comment"># name</span>
    <span class="hljs-string">&quot;Multiply two integers.&quot;</span>,       <span class="hljs-comment"># description</span>
    calculator,                     <span class="hljs-comment"># function to call</span>
    [(<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>), (<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>)],   <span class="hljs-comment"># inputs (names and types)</span>
    <span class="hljs-string">&quot;int&quot;</span>,                          <span class="hljs-comment"># output</span>
)`,wrap:!1}}),gt=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> inspect

<span class="hljs-keyword">def</span> <span class="hljs-title function_">tool</span>(<span class="hljs-params">func</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A decorator that creates a Tool instance from the given function.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Get the function signature</span>
    signature = inspect.signature(func)

    <span class="hljs-comment"># Extract (param_name, param_annotation) pairs for inputs</span>
    arguments = []
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> signature.parameters.values():
        annotation_name = (
            param.annotation.__name__
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(param.annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>)
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(param.annotation)
        )
        arguments.append((param.name, annotation_name))

    <span class="hljs-comment"># Determine the return annotation</span>
    return_annotation = signature.return_annotation
    <span class="hljs-keyword">if</span> return_annotation <span class="hljs-keyword">is</span> inspect._empty:
        outputs = <span class="hljs-string">&quot;No return annotation&quot;</span>
    <span class="hljs-keyword">else</span>:
        outputs = (
            return_annotation.__name__
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(return_annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>)
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(return_annotation)
        )

    <span class="hljs-comment"># Use the function&#x27;s docstring as the description (default if None)</span>
    description = func.__doc__ <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;No description provided.&quot;</span>

    <span class="hljs-comment"># The function name becomes the Tool name</span>
    name = func.__name__

    <span class="hljs-comment"># Return a new Tool instance</span>
    <span class="hljs-keyword">return</span> Tool(
        name=name,
        description=description,
        func=func,
        arguments=arguments,
        outputs=outputs
    )`,wrap:!1}}),xt=new m({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),Ht=new m({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:"Tool Name: calculator, Description: Multiply two integers., Arguments: a: int, b: int, Outputs: int",wrap:!1}}),$t=new qt({props:{title:"Model Context Protocol (MCP): a unified tool interface",local:"model-context-protocol-mcp-a-unified-tool-interface",headingTag:"h3"}}),Xt=new tn({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/tools.mdx"}}),{c(){J=a("meta"),Kt=n(),Pt=a("p"),Dt=n(),p(h.$$.fragment),Ot=n(),d=a("img"),te=n(),I=a("p"),I.innerHTML=kl,ee=n(),U=a("p"),U.textContent=El,le=n(),f=a("p"),f.textContent=Rl,se=n(),p(C.$$.fragment),ne=n(),b=a("p"),b.innerHTML=Zl,ie=n(),A=a("p"),A.textContent=Sl,ae=n(),v=a("table"),v.innerHTML=Vl,oe=n(),g=a("p"),g.textContent=Ql,Me=n(),B=a("p"),B.innerHTML=Yl,pe=n(),x=a("p"),x.innerHTML=zl,re=n(),_=a("p"),_.innerHTML=Xl,ue=n(),H=a("p"),H.textContent=ql,we=n(),L=a("img"),Te=n(),G=a("ul"),G.innerHTML=Pl,ye=n(),p(W.$$.fragment),ce=n(),$=a("p"),$.textContent=Fl,Je=n(),k=a("p"),k.textContent=Kl,me=n(),E=a("p"),E.innerHTML=Dl,je=n(),R=a("p"),R.textContent=Ol,he=n(),Z=a("p"),Z.textContent=ts,de=n(),p(S.$$.fragment),Ie=n(),V=a("p"),V.textContent=es,Ue=n(),Q=a("img"),fe=n(),Y=a("p"),Y.textContent=ss,Ce=n(),z=a("ol"),z.innerHTML=ns,be=n(),X=a("p"),X.innerHTML=is,Ae=n(),q=a("p"),q.textContent=as,ve=n(),N=a("p"),N.innerHTML=os,ge=n(),p(P.$$.fragment),Be=n(),F=a("p"),F.innerHTML=Ms,xe=n(),K=a("ul"),K.innerHTML=ps,_e=n(),D=a("p"),D.textContent=rs,He=n(),O=a("ul"),O.innerHTML=us,Le=n(),tt=a("p"),tt.textContent=ws,Ge=n(),p(et.$$.fragment),We=n(),lt=a("blockquote"),lt.innerHTML=Ts,$e=n(),st=a("p"),st.textContent=ys,ke=n(),nt=a("p"),nt.textContent=cs,Ee=n(),it=a("p"),it.textContent=Js,Re=n(),p(at.$$.fragment),Ze=n(),ot=a("p"),ot.textContent=ms,Se=n(),Mt=a("ul"),Mt.innerHTML=js,Ve=n(),pt=a("p"),pt.textContent=hs,Qe=n(),rt=a("p"),rt.innerHTML=ds,Ye=n(),ut=a("p"),ut.textContent=Is,ze=n(),wt=a("p"),wt.innerHTML=Us,Xe=n(),p(Tt.$$.fragment),qe=n(),yt=a("p"),yt.innerHTML=fs,Ne=n(),ct=a("p"),ct.innerHTML=Cs,Pe=n(),p(Jt.$$.fragment),Fe=n(),mt=a("p"),mt.textContent=bs,Ke=n(),p(jt.$$.fragment),De=n(),ht=a("p"),ht.innerHTML=As,Oe=n(),dt=a("blockquote"),dt.innerHTML=vs,tl=n(),p(It.$$.fragment),el=n(),Ut=a("p"),Ut.innerHTML=gs,ll=n(),ft=a("ul"),ft.innerHTML=Bs,sl=n(),Ct=a("p"),Ct.textContent=xs,nl=n(),p(bt.$$.fragment),il=n(),At=a("p"),At.innerHTML=_s,al=n(),vt=a("blockquote"),vt.innerHTML=Hs,ol=n(),j=a("details"),Nt=a("summary"),Nt.textContent=Ls,Hl=n(),p(gt.$$.fragment),Ml=n(),Bt=a("p"),Bt.textContent=Gs,pl=n(),p(xt.$$.fragment),rl=n(),_t=a("p"),_t.innerHTML=Ws,ul=n(),p(Ht.$$.fragment),wl=n(),Lt=a("p"),Lt.innerHTML=$s,Tl=n(),Gt=a("img"),yl=n(),Wt=a("p"),Wt.innerHTML=Es,cl=n(),p($t.$$.fragment),Jl=n(),kt=a("p"),kt.innerHTML=Rs,ml=n(),Et=a("ul"),Et.innerHTML=Zs,jl=n(),Rt=a("p"),Rt.innerHTML=Ss,hl=n(),Zt=a("p"),Zt.innerHTML=Vs,dl=n(),Il=a("hr"),Ul=n(),St=a("p"),St.textContent=Qs,fl=n(),Vt=a("p"),Vt.textContent=Ys,Cl=n(),Qt=a("ul"),Qt.innerHTML=zs,bl=n(),Yt=a("p"),Yt.innerHTML=Xs,Al=n(),zt=a("p"),zt.textContent=qs,vl=n(),p(Xt.$$.fragment),gl=n(),Ft=a("p"),this.h()},l(t){const e=Os("svelte-u9bgzb",document.head);J=o(e,"META",{name:!0,content:!0}),e.forEach(l),Kt=i(t),Pt=o(t,"P",{}),Ll(Pt).forEach(l),Dt=i(t),r(h.$$.fragment,t),Ot=i(t),d=o(t,"IMG",{src:!0,alt:!0}),te=i(t),I=o(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-12q0l6c"&&(I.innerHTML=kl),ee=i(t),U=o(t,"P",{"data-svelte-h":!0}),M(U)!=="svelte-vccz0n"&&(U.textContent=El),le=i(t),f=o(t,"P",{"data-svelte-h":!0}),M(f)!=="svelte-g748wk"&&(f.textContent=Rl),se=i(t),r(C.$$.fragment,t),ne=i(t),b=o(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-d0memu"&&(b.innerHTML=Zl),ie=i(t),A=o(t,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1bnicmb"&&(A.textContent=Sl),ae=i(t),v=o(t,"TABLE",{"data-svelte-h":!0}),M(v)!=="svelte-1r7ovsn"&&(v.innerHTML=Vl),oe=i(t),g=o(t,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1fuccdy"&&(g.textContent=Ql),Me=i(t),B=o(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-178hc7g"&&(B.innerHTML=Yl),pe=i(t),x=o(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1redoxr"&&(x.innerHTML=zl),re=i(t),_=o(t,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1v1ck09"&&(_.innerHTML=Xl),ue=i(t),H=o(t,"P",{"data-svelte-h":!0}),M(H)!=="svelte-mz2far"&&(H.textContent=ql),we=i(t),L=o(t,"IMG",{src:!0,alt:!0}),Te=i(t),G=o(t,"UL",{"data-svelte-h":!0}),M(G)!=="svelte-gj3em1"&&(G.innerHTML=Pl),ye=i(t),r(W.$$.fragment,t),ce=i(t),$=o(t,"P",{"data-svelte-h":!0}),M($)!=="svelte-12sfw6d"&&($.textContent=Fl),Je=i(t),k=o(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-17ojdf7"&&(k.textContent=Kl),me=i(t),E=o(t,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1ym7xfc"&&(E.innerHTML=Dl),je=i(t),R=o(t,"P",{"data-svelte-h":!0}),M(R)!=="svelte-16cdakx"&&(R.textContent=Ol),he=i(t),Z=o(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1gym7on"&&(Z.textContent=ts),de=i(t),r(S.$$.fragment,t),Ie=i(t),V=o(t,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1m76tol"&&(V.textContent=es),Ue=i(t),Q=o(t,"IMG",{src:!0,alt:!0}),fe=i(t),Y=o(t,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-e466s4"&&(Y.textContent=ss),Ce=i(t),z=o(t,"OL",{"data-svelte-h":!0}),M(z)!=="svelte-12vrnnv"&&(z.innerHTML=ns),be=i(t),X=o(t,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1lxlzbg"&&(X.innerHTML=is),Ae=i(t),q=o(t,"P",{"data-svelte-h":!0}),M(q)!=="svelte-1p033lp"&&(q.textContent=as),ve=i(t),N=o(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1if40sb"&&(N.innerHTML=os),ge=i(t),r(P.$$.fragment,t),Be=i(t),F=o(t,"P",{"data-svelte-h":!0}),M(F)!=="svelte-somofk"&&(F.innerHTML=Ms),xe=i(t),K=o(t,"UL",{"data-svelte-h":!0}),M(K)!=="svelte-1qi2vj"&&(K.innerHTML=ps),_e=i(t),D=o(t,"P",{"data-svelte-h":!0}),M(D)!=="svelte-z90coj"&&(D.textContent=rs),He=i(t),O=o(t,"UL",{"data-svelte-h":!0}),M(O)!=="svelte-1rd1o27"&&(O.innerHTML=us),Le=i(t),tt=o(t,"P",{"data-svelte-h":!0}),M(tt)!=="svelte-1gl47rm"&&(tt.textContent=ws),Ge=i(t),r(et.$$.fragment,t),We=i(t),lt=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(lt)!=="svelte-jn5onw"&&(lt.innerHTML=Ts),$e=i(t),st=o(t,"P",{"data-svelte-h":!0}),M(st)!=="svelte-dd2uu2"&&(st.textContent=ys),ke=i(t),nt=o(t,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-1ec16zo"&&(nt.textContent=cs),Ee=i(t),it=o(t,"P",{"data-svelte-h":!0}),M(it)!=="svelte-xhigt1"&&(it.textContent=Js),Re=i(t),r(at.$$.fragment,t),Ze=i(t),ot=o(t,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-xwh6nk"&&(ot.textContent=ms),Se=i(t),Mt=o(t,"UL",{"data-svelte-h":!0}),M(Mt)!=="svelte-1mufwba"&&(Mt.innerHTML=js),Ve=i(t),pt=o(t,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-6ogn9l"&&(pt.textContent=hs),Qe=i(t),rt=o(t,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-2908e6"&&(rt.innerHTML=ds),Ye=i(t),ut=o(t,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-1nshzlk"&&(ut.textContent=Is),ze=i(t),wt=o(t,"P",{"data-svelte-h":!0}),M(wt)!=="svelte-1iag2er"&&(wt.innerHTML=Us),Xe=i(t),r(Tt.$$.fragment,t),qe=i(t),yt=o(t,"P",{"data-svelte-h":!0}),M(yt)!=="svelte-1xfdhk0"&&(yt.innerHTML=fs),Ne=i(t),ct=o(t,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-hj3bkt"&&(ct.innerHTML=Cs),Pe=i(t),r(Jt.$$.fragment,t),Fe=i(t),mt=o(t,"P",{"data-svelte-h":!0}),M(mt)!=="svelte-ah55dy"&&(mt.textContent=bs),Ke=i(t),r(jt.$$.fragment,t),De=i(t),ht=o(t,"P",{"data-svelte-h":!0}),M(ht)!=="svelte-1g4lbet"&&(ht.innerHTML=As),Oe=i(t),dt=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(dt)!=="svelte-17jlnyo"&&(dt.innerHTML=vs),tl=i(t),r(It.$$.fragment,t),el=i(t),Ut=o(t,"P",{"data-svelte-h":!0}),M(Ut)!=="svelte-1m24zfs"&&(Ut.innerHTML=gs),ll=i(t),ft=o(t,"UL",{"data-svelte-h":!0}),M(ft)!=="svelte-1aoag7f"&&(ft.innerHTML=Bs),sl=i(t),Ct=o(t,"P",{"data-svelte-h":!0}),M(Ct)!=="svelte-9jg0w0"&&(Ct.textContent=xs),nl=i(t),r(bt.$$.fragment,t),il=i(t),At=o(t,"P",{"data-svelte-h":!0}),M(At)!=="svelte-imjo5d"&&(At.innerHTML=_s),al=i(t),vt=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(vt)!=="svelte-5gslq7"&&(vt.innerHTML=Hs),ol=i(t),j=o(t,"DETAILS",{});var xl=Ll(j);Nt=o(xl,"SUMMARY",{"data-svelte-h":!0}),M(Nt)!=="svelte-14wmf42"&&(Nt.textContent=Ls),Hl=i(xl),r(gt.$$.fragment,xl),xl.forEach(l),Ml=i(t),Bt=o(t,"P",{"data-svelte-h":!0}),M(Bt)!=="svelte-1pxgdsn"&&(Bt.textContent=Gs),pl=i(t),r(xt.$$.fragment,t),rl=i(t),_t=o(t,"P",{"data-svelte-h":!0}),M(_t)!=="svelte-oh725x"&&(_t.innerHTML=Ws),ul=i(t),r(Ht.$$.fragment,t),wl=i(t),Lt=o(t,"P",{"data-svelte-h":!0}),M(Lt)!=="svelte-1gsasw4"&&(Lt.innerHTML=$s),Tl=i(t),Gt=o(t,"IMG",{src:!0,alt:!0}),yl=i(t),Wt=o(t,"P",{"data-svelte-h":!0}),M(Wt)!=="svelte-14h2jbz"&&(Wt.innerHTML=Es),cl=i(t),r($t.$$.fragment,t),Jl=i(t),kt=o(t,"P",{"data-svelte-h":!0}),M(kt)!=="svelte-123mz07"&&(kt.innerHTML=Rs),ml=i(t),Et=o(t,"UL",{"data-svelte-h":!0}),M(Et)!=="svelte-jdb0o1"&&(Et.innerHTML=Zs),jl=i(t),Rt=o(t,"P",{"data-svelte-h":!0}),M(Rt)!=="svelte-v0j64b"&&(Rt.innerHTML=Ss),hl=i(t),Zt=o(t,"P",{"data-svelte-h":!0}),M(Zt)!=="svelte-ki6njs"&&(Zt.innerHTML=Vs),dl=i(t),Il=o(t,"HR",{}),Ul=i(t),St=o(t,"P",{"data-svelte-h":!0}),M(St)!=="svelte-yaz9vn"&&(St.textContent=Qs),fl=i(t),Vt=o(t,"P",{"data-svelte-h":!0}),M(Vt)!=="svelte-1mncb1b"&&(Vt.textContent=Ys),Cl=i(t),Qt=o(t,"UL",{"data-svelte-h":!0}),M(Qt)!=="svelte-1lbaznq"&&(Qt.innerHTML=zs),bl=i(t),Yt=o(t,"P",{"data-svelte-h":!0}),M(Yt)!=="svelte-16mxhlc"&&(Yt.innerHTML=Xs),Al=i(t),zt=o(t,"P",{"data-svelte-h":!0}),M(zt)!=="svelte-1w2njod"&&(zt.textContent=qs),vl=i(t),r(Xt.$$.fragment,t),gl=i(t),Ft=o(t,"P",{}),Ll(Ft).forEach(l),this.h()},h(){c(J,"name","hf:doc:metadata"),c(J,"content",ln),_l(d.src,$l="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-2.jpg")||c(d,"src",$l),c(d,"alt","Unit 1 planning"),_l(L.src,Nl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/weather.jpg")||c(L,"src",Nl),c(L,"alt","Weather"),_l(Q.src,ls="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt.png")||c(Q,"src",ls),c(Q,"alt","System prompt for tools"),_l(Gt.src,ks="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt_tools.png")||c(Gt,"src",ks),c(Gt,"alt","System prompt for tools")},m(t,e){Gl(document.head,J),s(t,Kt,e),s(t,Pt,e),s(t,Dt,e),u(h,t,e),s(t,Ot,e),s(t,d,e),s(t,te,e),s(t,I,e),s(t,ee,e),s(t,U,e),s(t,le,e),s(t,f,e),s(t,se,e),u(C,t,e),s(t,ne,e),s(t,b,e),s(t,ie,e),s(t,A,e),s(t,ae,e),s(t,v,e),s(t,oe,e),s(t,g,e),s(t,Me,e),s(t,B,e),s(t,pe,e),s(t,x,e),s(t,re,e),s(t,_,e),s(t,ue,e),s(t,H,e),s(t,we,e),s(t,L,e),s(t,Te,e),s(t,G,e),s(t,ye,e),u(W,t,e),s(t,ce,e),s(t,$,e),s(t,Je,e),s(t,k,e),s(t,me,e),s(t,E,e),s(t,je,e),s(t,R,e),s(t,he,e),s(t,Z,e),s(t,de,e),u(S,t,e),s(t,Ie,e),s(t,V,e),s(t,Ue,e),s(t,Q,e),s(t,fe,e),s(t,Y,e),s(t,Ce,e),s(t,z,e),s(t,be,e),s(t,X,e),s(t,Ae,e),s(t,q,e),s(t,ve,e),s(t,N,e),s(t,ge,e),u(P,t,e),s(t,Be,e),s(t,F,e),s(t,xe,e),s(t,K,e),s(t,_e,e),s(t,D,e),s(t,He,e),s(t,O,e),s(t,Le,e),s(t,tt,e),s(t,Ge,e),u(et,t,e),s(t,We,e),s(t,lt,e),s(t,$e,e),s(t,st,e),s(t,ke,e),s(t,nt,e),s(t,Ee,e),s(t,it,e),s(t,Re,e),u(at,t,e),s(t,Ze,e),s(t,ot,e),s(t,Se,e),s(t,Mt,e),s(t,Ve,e),s(t,pt,e),s(t,Qe,e),s(t,rt,e),s(t,Ye,e),s(t,ut,e),s(t,ze,e),s(t,wt,e),s(t,Xe,e),u(Tt,t,e),s(t,qe,e),s(t,yt,e),s(t,Ne,e),s(t,ct,e),s(t,Pe,e),u(Jt,t,e),s(t,Fe,e),s(t,mt,e),s(t,Ke,e),u(jt,t,e),s(t,De,e),s(t,ht,e),s(t,Oe,e),s(t,dt,e),s(t,tl,e),u(It,t,e),s(t,el,e),s(t,Ut,e),s(t,ll,e),s(t,ft,e),s(t,sl,e),s(t,Ct,e),s(t,nl,e),u(bt,t,e),s(t,il,e),s(t,At,e),s(t,al,e),s(t,vt,e),s(t,ol,e),s(t,j,e),Gl(j,Nt),Gl(j,Hl),u(gt,j,null),s(t,Ml,e),s(t,Bt,e),s(t,pl,e),u(xt,t,e),s(t,rl,e),s(t,_t,e),s(t,ul,e),u(Ht,t,e),s(t,wl,e),s(t,Lt,e),s(t,Tl,e),s(t,Gt,e),s(t,yl,e),s(t,Wt,e),s(t,cl,e),u($t,t,e),s(t,Jl,e),s(t,kt,e),s(t,ml,e),s(t,Et,e),s(t,jl,e),s(t,Rt,e),s(t,hl,e),s(t,Zt,e),s(t,dl,e),s(t,Il,e),s(t,Ul,e),s(t,St,e),s(t,fl,e),s(t,Vt,e),s(t,Cl,e),s(t,Qt,e),s(t,bl,e),s(t,Yt,e),s(t,Al,e),s(t,zt,e),s(t,vl,e),u(Xt,t,e),s(t,gl,e),s(t,Ft,e),Bl=!0},p:Ps,i(t){Bl||(w(h.$$.fragment,t),w(C.$$.fragment,t),w(W.$$.fragment,t),w(S.$$.fragment,t),w(P.$$.fragment,t),w(et.$$.fragment,t),w(at.$$.fragment,t),w(Tt.$$.fragment,t),w(Jt.$$.fragment,t),w(jt.$$.fragment,t),w(It.$$.fragment,t),w(bt.$$.fragment,t),w(gt.$$.fragment,t),w(xt.$$.fragment,t),w(Ht.$$.fragment,t),w($t.$$.fragment,t),w(Xt.$$.fragment,t),Bl=!0)},o(t){T(h.$$.fragment,t),T(C.$$.fragment,t),T(W.$$.fragment,t),T(S.$$.fragment,t),T(P.$$.fragment,t),T(et.$$.fragment,t),T(at.$$.fragment,t),T(Tt.$$.fragment,t),T(Jt.$$.fragment,t),T(jt.$$.fragment,t),T(It.$$.fragment,t),T(bt.$$.fragment,t),T(gt.$$.fragment,t),T(xt.$$.fragment,t),T(Ht.$$.fragment,t),T($t.$$.fragment,t),T(Xt.$$.fragment,t),Bl=!1},d(t){t&&(l(Kt),l(Pt),l(Dt),l(Ot),l(d),l(te),l(I),l(ee),l(U),l(le),l(f),l(se),l(ne),l(b),l(ie),l(A),l(ae),l(v),l(oe),l(g),l(Me),l(B),l(pe),l(x),l(re),l(_),l(ue),l(H),l(we),l(L),l(Te),l(G),l(ye),l(ce),l($),l(Je),l(k),l(me),l(E),l(je),l(R),l(he),l(Z),l(de),l(Ie),l(V),l(Ue),l(Q),l(fe),l(Y),l(Ce),l(z),l(be),l(X),l(Ae),l(q),l(ve),l(N),l(ge),l(Be),l(F),l(xe),l(K),l(_e),l(D),l(He),l(O),l(Le),l(tt),l(Ge),l(We),l(lt),l($e),l(st),l(ke),l(nt),l(Ee),l(it),l(Re),l(Ze),l(ot),l(Se),l(Mt),l(Ve),l(pt),l(Qe),l(rt),l(Ye),l(ut),l(ze),l(wt),l(Xe),l(qe),l(yt),l(Ne),l(ct),l(Pe),l(Fe),l(mt),l(Ke),l(De),l(ht),l(Oe),l(dt),l(tl),l(el),l(Ut),l(ll),l(ft),l(sl),l(Ct),l(nl),l(il),l(At),l(al),l(vt),l(ol),l(j),l(Ml),l(Bt),l(pl),l(rl),l(_t),l(ul),l(wl),l(Lt),l(Tl),l(Gt),l(yl),l(Wt),l(cl),l(Jl),l(kt),l(ml),l(Et),l(jl),l(Rt),l(hl),l(Zt),l(dl),l(Il),l(Ul),l(St),l(fl),l(Vt),l(Cl),l(Qt),l(bl),l(Yt),l(Al),l(zt),l(vl),l(gl),l(Ft)),l(J),y(h,t),y(C,t),y(W,t),y(S,t),y(P,t),y(et,t),y(at,t),y(Tt,t),y(Jt,t),y(jt,t),y(It,t),y(bt,t),y(gt),y(xt,t),y(Ht,t),y($t,t),y(Xt,t)}}}const ln='{"title":"What are Tools?","local":"what-are-tools","sections":[{"title":"What are AI Tools?","local":"what-are-ai-tools","sections":[],"depth":2},{"title":"How do tools work?","local":"how-do-tools-work","sections":[],"depth":2},{"title":"How do we give tools to an LLM?","local":"how-do-we-give-tools-to-an-llm","sections":[{"title":"Auto-formatting Tool sections","local":"auto-formatting-tool-sections","sections":[],"depth":3},{"title":"Generic Tool implementation","local":"generic-tool-implementation","sections":[],"depth":3},{"title":"Model Context Protocol (MCP): a unified tool interface","local":"model-context-protocol-mcp-a-unified-tool-interface","sections":[],"depth":3}],"depth":2}],"depth":1}';function sn(Wl){return Fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rn extends Ks{constructor(J){super(),Ds(this,J,sn,en,Ns,{})}}export{rn as component};
