import{s as ll,o as nl,n as Ue}from"../chunks/scheduler.defa9a21.js";import{S as al,i as sl,g as o,s as a,r as u,A as il,h as r,f as l,c as s,j as el,u as m,x as p,k as tl,y as cl,a as n,v as f,d,t as h,w as y,m as ol,n as rl}from"../chunks/index.fe795e71.js";import{T as $e}from"../chunks/Tip.179eb360.js";import{C as $}from"../chunks/CodeBlock.204b6c34.js";import{H as ge,E as pl}from"../chunks/getInferenceSnippets.5aa7956d.js";function ul(J){let i,w=`It’s recommended you run <code>accelerate config</code> before using <code>accelerate launch</code> to configure your environment to your liking.
Otherwise Accelerate will use very basic defaults depending on your system setup.`;return{c(){i=o("p"),i.innerHTML=w},l(c){i=r(c,"P",{"data-svelte-h":!0}),p(i)!=="svelte-u7llw1"&&(i.innerHTML=w)},m(c,M){n(c,i,M)},p:Ue,d(c){c&&l(i)}}}function ml(J){let i,w="If you are familiar with launching scripts in PyTorch yourself such as with <code>torchrun</code>, you can still do this. It is not required to use <code>accelerate launch</code>.";return{c(){i=o("p"),i.innerHTML=w},l(c){i=r(c,"P",{"data-svelte-h":!0}),p(i)!=="svelte-l2vpv8"&&(i.innerHTML=w)},m(c,M){n(c,i,M)},p:Ue,d(c){c&&l(i)}}}function fl(J){let i,w="Even if you are not using Accelerate in your code, you can still use the launcher for starting your scripts!";return{c(){i=o("p"),i.textContent=w},l(c){i=r(c,"P",{"data-svelte-h":!0}),p(i)!=="svelte-fshzln"&&(i.textContent=w)},m(c,M){n(c,i,M)},p:Ue,d(c){c&&l(i)}}}function dl(J){let i,w="You can run your code on CPU as well! This is helpful for debugging and testing purposes on toy models and datasets.",c,M,g;return M=new $({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tY3B1JTIwJTdCc2NyaXB0X25hbWUucHklN0QlMjAlN0ItLWFyZzElN0QlMjAlN0ItLWFyZzIlN0Q=",highlighted:"accelerate launch --cpu {script_name.py} {--arg1} {--arg2}",wrap:!1}}),{c(){i=o("p"),i.textContent=w,c=a(),u(M.$$.fragment)},l(T){i=r(T,"P",{"data-svelte-h":!0}),p(i)!=="svelte-zpf42g"&&(i.textContent=w),c=s(T),m(M.$$.fragment,T)},m(T,U){n(T,i,U),n(T,c,U),f(M,T,U),g=!0},p:Ue,i(T){g||(d(M.$$.fragment,T),g=!0)},o(T){h(M.$$.fragment,T),g=!1},d(T){T&&(l(i),l(c)),y(M,T)}}}function hl(J){let i;return{c(){i=ol("It is required that the command be ran on all nodes for everything to start, not just running it from the main node. You can use something like SLURM or a different process executor to wrap around this requirement and call everything from a single command.")},l(w){i=rl(w,"It is required that the command be ran on all nodes for everything to start, not just running it from the main node. You can use something like SLURM or a different process executor to wrap around this requirement and call everything from a single command.")},m(w,c){n(w,i,c)},d(w){w&&l(i)}}}function yl(J){let i,w="It is recommended to use the intranet IP of your main node over the public IP for better latency. This is the <code>192.168.x.x</code> or the <code>172.x.x.x</code> address you see when you run <code>hostname -I</code> on the main node.";return{c(){i=o("p"),i.innerHTML=w},l(c){i=r(c,"P",{"data-svelte-h":!0}),p(i)!=="svelte-psz6nh"&&(i.innerHTML=w)},m(c,M){n(c,i,M)},p:Ue,d(c){c&&l(i)}}}function wl(J){let i,w,c,M,g,T,U,gt=`In the previous tutorial, you were introduced to how to modify your current training script to use Accelerate.
The final version of that code is shown below:`,Ce,Z,Ie,W,Ut="But how do you run this code and have it utilize the special hardware available to it?",be,x,Ct="First, you should rewrite the above code into a function, and make it callable as a script. For example:",je,G,ve,L,It="Next, you need to launch it with <code>accelerate launch</code>.",_e,C,Ze,B,We,N,bt=`Accelerate has a special CLI command to help you launch your code in your system through <code>accelerate launch</code>.
This command wraps around all of the different commands needed to launch your script on various platforms, without you having to remember what each of them is.`,xe,I,Ge,S,jt="You can launch your script quickly by using:",Le,Y,Be,H,vt="Just put <code>accelerate launch</code> at the start of your command, and pass in additional arguments and parameters to your script afterward like normal!",Ne,A,_t=`Since this runs the various torch spawn methods, all of the expected environment variables can be modified here as well.
For example, here is how to use <code>accelerate launch</code> with a single GPU:`,Se,k,Ye,V,Zt=`You can also use <code>accelerate launch</code> without performing <code>accelerate config</code> first, but you may need to manually pass in the right configuration parameters.
In this case, Accelerate will make some hyperparameter decisions for you, e.g., if GPUs are available, it will use all of them by default without the mixed precision.
Here is how you would use all GPUs and train with mixed precision disabled:`,He,F,Ae,R,Wt="Or by specifying a number of GPUs to use:",ke,z,Ve,X,xt=`To get more specific you should pass in the needed parameters yourself. For instance, here is how you
would also launch that same script on two GPUs using mixed precision while avoiding all of the warnings:`,Fe,E,Re,Q,Gt="For a complete list of parameters you can pass in, run:",ze,P,Xe,b,Ee,D,Lt="For a visualization of this difference, that earlier <code>accelerate launch</code> on multi-gpu would look something like so with <code>torchrun</code>:",Qe,q,Pe,K,Bt=`You can also launch your script utilizing the launch CLI as a python module itself, enabling the ability to pass in other python-specific
launching behaviors. To do so, use <code>accelerate.commands.launch</code> instead of <code>accelerate launch</code>:`,De,O,qe,ee,Nt=`If you want to execute the script with any other python flags, you can pass them in as well similar to <code>-m</code>, such as
the below example enabling unbuffered stdout and stderr:`,Ke,te,Oe,j,et,le,tt,ne,St="Why is it useful to the point you should <strong>always</strong> run <code>accelerate config</code>?",lt,ae,Yt=`Remember that earlier call to <code>accelerate launch</code> as well as <code>torchrun</code>?
Post configuration, to run that script with the needed parts you just need to use <code>accelerate launch</code> outright, without passing anything else in:`,nt,se,at,ie,st,ce,Ht=`As briefly mentioned earlier, <code>accelerate launch</code> should be mostly used through combining set configurations
made with the <code>accelerate config</code> command. These configs are saved to a <code>default_config.yaml</code> file in your cache folder for Accelerate.
This cache folder is located at (with decreasing order of priority):`,it,oe,At=`<li>The content of your environment variable <code>HF_HOME</code> suffixed with <code>accelerate</code>.</li> <li>If it does not exist, the content of your environment variable <code>XDG_CACHE_HOME</code> suffixed with
<code>huggingface/accelerate</code>.</li> <li>If this does not exist either, the folder <code>~/.cache/huggingface/accelerate</code>.</li>`,ct,re,kt=`To have multiple configurations, the flag <code>--config_file</code> can be passed to the <code>accelerate launch</code> command paired
with the location of the custom yaml.`,ot,pe,Vt="An example yaml may look something like the following for two GPUs on a single machine using <code>fp16</code> for mixed precision:",rt,ue,pt,me,Ft="Launching a script from the location of that custom yaml file looks like the following:",ut,fe,mt,de,ft,he,Rt='Multi-node training with Accelerate is similar to <a href="https://pytorch.org/tutorials/intermediate/ddp_series_multinode.html" rel="nofollow">multi-node training with torchrun</a>. The simplest way to launch a multi-node training run is to do the following:',dt,ye,zt="<li>Copy your codebase and data to all nodes. (or place them on a shared filesystem)</li> <li>Setup your python packages on all nodes.</li> <li>Run <code>accelerate config</code> on the main single node first. After specifying the number of nodes, you will be asked to specify the rank of each node (this will be 0 for the main/master node), along with the IP address and port for the main process. This is required for the worker nodes to communicate with the main process. Afterwards, you can copy or send this config file across all of your nodes, changing the <code>machine_rank</code> to 1, 2,3, etc. to avoid having to run the command (or just follow their directions directly for launching with <code>torchrun</code> as well)</li>",ht,we,Xt="Once you have done this, you can start your multi-node training run by running <code>accelerate launch</code> (or <code>torchrun</code>) on all nodes.",yt,v,wt,_,Mt,Me,Et='To get a better idea about multi-node training, check out our example for <a href="https://huggingface.co/blog/ram-efficient-pytorch-fsdp" rel="nofollow">multi-node training with FSDP</a>.',Tt,Te,$t,Je,Jt;return g=new ge({props:{title:"Launching Accelerate scripts",local:"launching-accelerate-scripts",headingTag:"h1"}}),Z=new $({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBKSUwQSUwQWZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCklMEElMjAlMjAlMjAlMjBzY2hlZHVsZXIuc3RlcCgp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()

model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    optimizer.zero_grad()
    inputs, targets = batch
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    accelerator.backward(loss)
    optimizer.step()
    scheduler.step()`,wrap:!1}}),G=new $({props:{code:"JTIwJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyMCUyMCUwQSUyQiUyMGRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzY2hlZHVsZXIuc3RlcCgpJTBBJTBBJTJCJTIwaWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTBBJTJCJTIwJTIwJTIwJTIwJTIwbWFpbigp",highlighted:`  from accelerate import Accelerator
  
<span class="hljs-addition">+ def main():</span>
      accelerator = Accelerator()

      model, optimizer, training_dataloader, scheduler = accelerator.prepare(
          model, optimizer, training_dataloader, scheduler
      )

      for batch in training_dataloader:
          optimizer.zero_grad()
          inputs, targets = batch
          outputs = model(inputs)
          loss = loss_function(outputs, targets)
          accelerator.backward(loss)
          optimizer.step()
          scheduler.step()

<span class="hljs-addition">+ if __name__ == &quot;__main__&quot;:</span>
<span class="hljs-addition">+     main()</span>`,wrap:!1}}),C=new $e({props:{warning:!0,$$slots:{default:[ul]},$$scope:{ctx:J}}}),B=new ge({props:{title:"Using accelerate launch",local:"using-accelerate-launch",headingTag:"h2"}}),I=new $e({props:{$$slots:{default:[ml]},$$scope:{ctx:J}}}),Y=new $({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMCU3QnNjcmlwdF9uYW1lLnB5JTdEJTIwLS1hcmcxJTIwLS1hcmcyJTIwLi4u",highlighted:"accelerate launch {script_name.py} --arg1 --arg2 ...",wrap:!1}}),k=new $({props:{code:"JTIzJTIwZm9yJTIwY3VkYSUyMGRldmljZSUzQSUwQUNVREFfVklTSUJMRV9ERVZJQ0VTJTNEJTIyMCUyMiUyMGFjY2VsZXJhdGUlMjBsYXVuY2glMjAlN0JzY3JpcHRfbmFtZS5weSU3RCUyMC0tYXJnMSUyMC0tYXJnMiUyMC4uLiUwQSUyMyUyMGZvciUyMHhwdSUyMGRldmljZSUzQSUwQVpFX0FGRklOSVRZX01BU0slM0QlMjIwJTIyJTIwYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMCU3QnNjcmlwdF9uYW1lLnB5JTdEJTIwLS1hcmcxJTIwLS1hcmcyJTIwLi4u",highlighted:`<span class="hljs-comment"># for cuda device:</span>
CUDA_VISIBLE_DEVICES=<span class="hljs-string">&quot;0&quot;</span> accelerate launch {script_name.py} --arg1 --arg2 ...
<span class="hljs-comment"># for xpu device:</span>
ZE_AFFINITY_MASK=<span class="hljs-string">&quot;0&quot;</span> accelerate launch {script_name.py} --arg1 --arg2 ...`,wrap:!1}}),F=new $({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbXVsdGlfZ3B1JTIwJTdCc2NyaXB0X25hbWUucHklN0QlMjAlN0ItLWFyZzElN0QlMjAlN0ItLWFyZzIlN0QlMjAuLi4=",highlighted:"accelerate launch --multi_gpu {script_name.py} {--arg1} {--arg2} ...",wrap:!1}}),z=new $({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbnVtX3Byb2Nlc3NlcyUzRDIlMjAlN0JzY3JpcHRfbmFtZS5weSU3RCUyMCU3Qi0tYXJnMSU3RCUyMCU3Qi0tYXJnMiU3RCUyMC4uLg==",highlighted:"accelerate launch --num_processes=2 {script_name.py} {--arg1} {--arg2} ...",wrap:!1}}),E=new $({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbXVsdGlfZ3B1JTIwLS1taXhlZF9wcmVjaXNpb24lM0RmcDE2JTIwLS1udW1fcHJvY2Vzc2VzJTNEMiUyMCU3QnNjcmlwdF9uYW1lLnB5JTdEJTIwJTdCLS1hcmcxJTdEJTIwJTdCLS1hcmcyJTdEJTIwLi4u",highlighted:"accelerate launch --multi_gpu --mixed_precision=fp16 --num_processes=2 {script_name.py} {--arg1} {--arg2} ...",wrap:!1}}),P=new $({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC1o",highlighted:"accelerate launch -h",wrap:!1}}),b=new $e({props:{$$slots:{default:[fl]},$$scope:{ctx:J}}}),q=new $({props:{code:"TUlYRURfUFJFQ0lTSU9OJTNEJTIyZnAxNiUyMiUyMHRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDIlMjAtLW5ub2RlcyUzRDElMjAlN0JzY3JpcHRfbmFtZS5weSU3RCUyMCU3Qi0tYXJnMSU3RCUyMCU3Qi0tYXJnMiU3RCUyMC4uLg==",highlighted:'MIXED_PRECISION=<span class="hljs-string">&quot;fp16&quot;</span> torchrun --nproc_per_node=2 --nnodes=1 {script_name.py} {--arg1} {--arg2} ...',wrap:!1}}),O=new $({props:{code:"cHl0aG9uJTIwLW0lMjBhY2NlbGVyYXRlLmNvbW1hbmRzLmxhdW5jaCUyMC0tbnVtX3Byb2Nlc3NlcyUzRDIlMjAlN0JzY3JpcHRfbmFtZS5weSU3RCUyMCU3Qi0tYXJnMSU3RCUyMCU3Qi0tYXJnMiU3RA==",highlighted:"python -m accelerate.commands.launch --num_processes=2 {script_name.py} {--arg1} {--arg2}",wrap:!1}}),te=new $({props:{code:"cHl0aG9uJTIwLXUlMjAtbSUyMGFjY2VsZXJhdGUuY29tbWFuZHMubGF1bmNoJTIwLS1udW1fcHJvY2Vzc2VzJTNEMiUyMCU3QnNjcmlwdF9uYW1lLnB5JTdEJTIwJTdCLS1hcmcxJTdEJTIwJTdCLS1hcmcyJTdE",highlighted:"python -u -m accelerate.commands.launch --num_processes=2 {script_name.py} {--arg1} {--arg2}",wrap:!1}}),j=new $e({props:{$$slots:{default:[dl]},$$scope:{ctx:J}}}),le=new ge({props:{title:"Why you should always use accelerate config",local:"why-you-should-always-use-accelerate-config",headingTag:"h2"}}),se=new $({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMCU3QnNjcmlwdF9uYW1lLnB5JTdEJTIwJTdCLS1hcmcxJTdEJTIwJTdCLS1hcmcyJTdEJTIwLi4u",highlighted:"accelerate launch {script_name.py} {--arg1} {--arg2} ...",wrap:!1}}),ie=new ge({props:{title:"Custom Configurations",local:"custom-configurations",headingTag:"h2"}}),ue=new $({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTIwJTdCJTdEJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyME1VTFRJX0dQVSUwQWZzZHBfY29uZmlnJTNBJTIwJTdCJTdEJTBBbWFjaGluZV9yYW5rJTNBJTIwMCUwQW1haW5fcHJvY2Vzc19pcCUzQSUyMG51bGwlMEFtYWluX3Byb2Nlc3NfcG9ydCUzQSUyMG51bGwlMEFtYWluX3RyYWluaW5nX2Z1bmN0aW9uJTNBJTIwbWFpbiUwQW1peGVkX3ByZWNpc2lvbiUzQSUyMGZwMTYlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDIlMEF1c2VfY3B1JTNBJTIwZmFsc2U=",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">deepspeed_config:</span> {}
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">MULTI_GPU</span>
<span class="hljs-attr">fsdp_config:</span> {}
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_process_ip:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">main_process_port:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">fp16</span>
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),fe=new $({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tY29uZmlnX2ZpbGUlMjAlN0JwYXRoJTJGdG8lMkZjb25maWclMkZteV9jb25maWdfZmlsZS55YW1sJTdEJTIwJTdCc2NyaXB0X25hbWUucHklN0QlMjAlN0ItLWFyZzElN0QlMjAlN0ItLWFyZzIlN0QlMjAuLi4=",highlighted:"accelerate launch --config_file {path/to/config/my_config_file.yaml} {script_name.py} {--arg1} {--arg2} ...",wrap:!1}}),de=new ge({props:{title:"Multi-node training",local:"multi-node-training",headingTag:"h2"}}),v=new $e({props:{$$slots:{default:[hl]},$$scope:{ctx:J}}}),_=new $e({props:{$$slots:{default:[yl]},$$scope:{ctx:J}}}),Te=new pl({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/basic_tutorials/launch.md"}}),{c(){i=o("meta"),w=a(),c=o("p"),M=a(),u(g.$$.fragment),T=a(),U=o("p"),U.textContent=gt,Ce=a(),u(Z.$$.fragment),Ie=a(),W=o("p"),W.textContent=Ut,be=a(),x=o("p"),x.textContent=Ct,je=a(),u(G.$$.fragment),ve=a(),L=o("p"),L.innerHTML=It,_e=a(),u(C.$$.fragment),Ze=a(),u(B.$$.fragment),We=a(),N=o("p"),N.innerHTML=bt,xe=a(),u(I.$$.fragment),Ge=a(),S=o("p"),S.textContent=jt,Le=a(),u(Y.$$.fragment),Be=a(),H=o("p"),H.innerHTML=vt,Ne=a(),A=o("p"),A.innerHTML=_t,Se=a(),u(k.$$.fragment),Ye=a(),V=o("p"),V.innerHTML=Zt,He=a(),u(F.$$.fragment),Ae=a(),R=o("p"),R.textContent=Wt,ke=a(),u(z.$$.fragment),Ve=a(),X=o("p"),X.textContent=xt,Fe=a(),u(E.$$.fragment),Re=a(),Q=o("p"),Q.textContent=Gt,ze=a(),u(P.$$.fragment),Xe=a(),u(b.$$.fragment),Ee=a(),D=o("p"),D.innerHTML=Lt,Qe=a(),u(q.$$.fragment),Pe=a(),K=o("p"),K.innerHTML=Bt,De=a(),u(O.$$.fragment),qe=a(),ee=o("p"),ee.innerHTML=Nt,Ke=a(),u(te.$$.fragment),Oe=a(),u(j.$$.fragment),et=a(),u(le.$$.fragment),tt=a(),ne=o("p"),ne.innerHTML=St,lt=a(),ae=o("p"),ae.innerHTML=Yt,nt=a(),u(se.$$.fragment),at=a(),u(ie.$$.fragment),st=a(),ce=o("p"),ce.innerHTML=Ht,it=a(),oe=o("ul"),oe.innerHTML=At,ct=a(),re=o("p"),re.innerHTML=kt,ot=a(),pe=o("p"),pe.innerHTML=Vt,rt=a(),u(ue.$$.fragment),pt=a(),me=o("p"),me.textContent=Ft,ut=a(),u(fe.$$.fragment),mt=a(),u(de.$$.fragment),ft=a(),he=o("p"),he.innerHTML=Rt,dt=a(),ye=o("ul"),ye.innerHTML=zt,ht=a(),we=o("p"),we.innerHTML=Xt,yt=a(),u(v.$$.fragment),wt=a(),u(_.$$.fragment),Mt=a(),Me=o("p"),Me.innerHTML=Et,Tt=a(),u(Te.$$.fragment),$t=a(),Je=o("p"),this.h()},l(e){const t=il("svelte-u9bgzb",document.head);i=r(t,"META",{name:!0,content:!0}),t.forEach(l),w=s(e),c=r(e,"P",{}),el(c).forEach(l),M=s(e),m(g.$$.fragment,e),T=s(e),U=r(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-lkgw9a"&&(U.textContent=gt),Ce=s(e),m(Z.$$.fragment,e),Ie=s(e),W=r(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-16box71"&&(W.textContent=Ut),be=s(e),x=r(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-aneby1"&&(x.textContent=Ct),je=s(e),m(G.$$.fragment,e),ve=s(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-10zvu98"&&(L.innerHTML=It),_e=s(e),m(C.$$.fragment,e),Ze=s(e),m(B.$$.fragment,e),We=s(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1vv9yh"&&(N.innerHTML=bt),xe=s(e),m(I.$$.fragment,e),Ge=s(e),S=r(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1h0cdt"&&(S.textContent=jt),Le=s(e),m(Y.$$.fragment,e),Be=s(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1pkspsa"&&(H.innerHTML=vt),Ne=s(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-pi8kj9"&&(A.innerHTML=_t),Se=s(e),m(k.$$.fragment,e),Ye=s(e),V=r(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-362fsb"&&(V.innerHTML=Zt),He=s(e),m(F.$$.fragment,e),Ae=s(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1f9nwyt"&&(R.textContent=Wt),ke=s(e),m(z.$$.fragment,e),Ve=s(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1sylg60"&&(X.textContent=xt),Fe=s(e),m(E.$$.fragment,e),Re=s(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-16vu16q"&&(Q.textContent=Gt),ze=s(e),m(P.$$.fragment,e),Xe=s(e),m(b.$$.fragment,e),Ee=s(e),D=r(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-vejsyy"&&(D.innerHTML=Lt),Qe=s(e),m(q.$$.fragment,e),Pe=s(e),K=r(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1bdn45"&&(K.innerHTML=Bt),De=s(e),m(O.$$.fragment,e),qe=s(e),ee=r(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1fkf60g"&&(ee.innerHTML=Nt),Ke=s(e),m(te.$$.fragment,e),Oe=s(e),m(j.$$.fragment,e),et=s(e),m(le.$$.fragment,e),tt=s(e),ne=r(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-uc738h"&&(ne.innerHTML=St),lt=s(e),ae=r(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1kcurae"&&(ae.innerHTML=Yt),nt=s(e),m(se.$$.fragment,e),at=s(e),m(ie.$$.fragment,e),st=s(e),ce=r(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-5vvoem"&&(ce.innerHTML=Ht),it=s(e),oe=r(e,"UL",{"data-svelte-h":!0}),p(oe)!=="svelte-12bywag"&&(oe.innerHTML=At),ct=s(e),re=r(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1m3wa4r"&&(re.innerHTML=kt),ot=s(e),pe=r(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1aynacm"&&(pe.innerHTML=Vt),rt=s(e),m(ue.$$.fragment,e),pt=s(e),me=r(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-s3hhms"&&(me.textContent=Ft),ut=s(e),m(fe.$$.fragment,e),mt=s(e),m(de.$$.fragment,e),ft=s(e),he=r(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-11ne4r6"&&(he.innerHTML=Rt),dt=s(e),ye=r(e,"UL",{"data-svelte-h":!0}),p(ye)!=="svelte-3qaail"&&(ye.innerHTML=zt),ht=s(e),we=r(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1dl49tf"&&(we.innerHTML=Xt),yt=s(e),m(v.$$.fragment,e),wt=s(e),m(_.$$.fragment,e),Mt=s(e),Me=r(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-ajn4si"&&(Me.innerHTML=Et),Tt=s(e),m(Te.$$.fragment,e),$t=s(e),Je=r(e,"P",{}),el(Je).forEach(l),this.h()},h(){tl(i,"name","hf:doc:metadata"),tl(i,"content",Ml)},m(e,t){cl(document.head,i),n(e,w,t),n(e,c,t),n(e,M,t),f(g,e,t),n(e,T,t),n(e,U,t),n(e,Ce,t),f(Z,e,t),n(e,Ie,t),n(e,W,t),n(e,be,t),n(e,x,t),n(e,je,t),f(G,e,t),n(e,ve,t),n(e,L,t),n(e,_e,t),f(C,e,t),n(e,Ze,t),f(B,e,t),n(e,We,t),n(e,N,t),n(e,xe,t),f(I,e,t),n(e,Ge,t),n(e,S,t),n(e,Le,t),f(Y,e,t),n(e,Be,t),n(e,H,t),n(e,Ne,t),n(e,A,t),n(e,Se,t),f(k,e,t),n(e,Ye,t),n(e,V,t),n(e,He,t),f(F,e,t),n(e,Ae,t),n(e,R,t),n(e,ke,t),f(z,e,t),n(e,Ve,t),n(e,X,t),n(e,Fe,t),f(E,e,t),n(e,Re,t),n(e,Q,t),n(e,ze,t),f(P,e,t),n(e,Xe,t),f(b,e,t),n(e,Ee,t),n(e,D,t),n(e,Qe,t),f(q,e,t),n(e,Pe,t),n(e,K,t),n(e,De,t),f(O,e,t),n(e,qe,t),n(e,ee,t),n(e,Ke,t),f(te,e,t),n(e,Oe,t),f(j,e,t),n(e,et,t),f(le,e,t),n(e,tt,t),n(e,ne,t),n(e,lt,t),n(e,ae,t),n(e,nt,t),f(se,e,t),n(e,at,t),f(ie,e,t),n(e,st,t),n(e,ce,t),n(e,it,t),n(e,oe,t),n(e,ct,t),n(e,re,t),n(e,ot,t),n(e,pe,t),n(e,rt,t),f(ue,e,t),n(e,pt,t),n(e,me,t),n(e,ut,t),f(fe,e,t),n(e,mt,t),f(de,e,t),n(e,ft,t),n(e,he,t),n(e,dt,t),n(e,ye,t),n(e,ht,t),n(e,we,t),n(e,yt,t),f(v,e,t),n(e,wt,t),f(_,e,t),n(e,Mt,t),n(e,Me,t),n(e,Tt,t),f(Te,e,t),n(e,$t,t),n(e,Je,t),Jt=!0},p(e,[t]){const Qt={};t&2&&(Qt.$$scope={dirty:t,ctx:e}),C.$set(Qt);const Pt={};t&2&&(Pt.$$scope={dirty:t,ctx:e}),I.$set(Pt);const Dt={};t&2&&(Dt.$$scope={dirty:t,ctx:e}),b.$set(Dt);const qt={};t&2&&(qt.$$scope={dirty:t,ctx:e}),j.$set(qt);const Kt={};t&2&&(Kt.$$scope={dirty:t,ctx:e}),v.$set(Kt);const Ot={};t&2&&(Ot.$$scope={dirty:t,ctx:e}),_.$set(Ot)},i(e){Jt||(d(g.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(C.$$.fragment,e),d(B.$$.fragment,e),d(I.$$.fragment,e),d(Y.$$.fragment,e),d(k.$$.fragment,e),d(F.$$.fragment,e),d(z.$$.fragment,e),d(E.$$.fragment,e),d(P.$$.fragment,e),d(b.$$.fragment,e),d(q.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(j.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ie.$$.fragment,e),d(ue.$$.fragment,e),d(fe.$$.fragment,e),d(de.$$.fragment,e),d(v.$$.fragment,e),d(_.$$.fragment,e),d(Te.$$.fragment,e),Jt=!0)},o(e){h(g.$$.fragment,e),h(Z.$$.fragment,e),h(G.$$.fragment,e),h(C.$$.fragment,e),h(B.$$.fragment,e),h(I.$$.fragment,e),h(Y.$$.fragment,e),h(k.$$.fragment,e),h(F.$$.fragment,e),h(z.$$.fragment,e),h(E.$$.fragment,e),h(P.$$.fragment,e),h(b.$$.fragment,e),h(q.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(j.$$.fragment,e),h(le.$$.fragment,e),h(se.$$.fragment,e),h(ie.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(de.$$.fragment,e),h(v.$$.fragment,e),h(_.$$.fragment,e),h(Te.$$.fragment,e),Jt=!1},d(e){e&&(l(w),l(c),l(M),l(T),l(U),l(Ce),l(Ie),l(W),l(be),l(x),l(je),l(ve),l(L),l(_e),l(Ze),l(We),l(N),l(xe),l(Ge),l(S),l(Le),l(Be),l(H),l(Ne),l(A),l(Se),l(Ye),l(V),l(He),l(Ae),l(R),l(ke),l(Ve),l(X),l(Fe),l(Re),l(Q),l(ze),l(Xe),l(Ee),l(D),l(Qe),l(Pe),l(K),l(De),l(qe),l(ee),l(Ke),l(Oe),l(et),l(tt),l(ne),l(lt),l(ae),l(nt),l(at),l(st),l(ce),l(it),l(oe),l(ct),l(re),l(ot),l(pe),l(rt),l(pt),l(me),l(ut),l(mt),l(ft),l(he),l(dt),l(ye),l(ht),l(we),l(yt),l(wt),l(Mt),l(Me),l(Tt),l($t),l(Je)),l(i),y(g,e),y(Z,e),y(G,e),y(C,e),y(B,e),y(I,e),y(Y,e),y(k,e),y(F,e),y(z,e),y(E,e),y(P,e),y(b,e),y(q,e),y(O,e),y(te,e),y(j,e),y(le,e),y(se,e),y(ie,e),y(ue,e),y(fe,e),y(de,e),y(v,e),y(_,e),y(Te,e)}}}const Ml='{"title":"Launching Accelerate scripts","local":"launching-accelerate-scripts","sections":[{"title":"Using accelerate launch","local":"using-accelerate-launch","sections":[],"depth":2},{"title":"Why you should always use accelerate config","local":"why-you-should-always-use-accelerate-config","sections":[],"depth":2},{"title":"Custom Configurations","local":"custom-configurations","sections":[],"depth":2},{"title":"Multi-node training","local":"multi-node-training","sections":[],"depth":2}],"depth":1}';function Tl(J){return nl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends al{constructor(i){super(),sl(this,i,Tl,wl,ll,{})}}export{Il as component};
