import{s as st,o as ot,n as it}from"../chunks/scheduler.defa9a21.js";import{S as at,i as nt,g as n,s as i,r as c,A as dt,h as d,f as s,c as a,j as et,u as p,x as r,k as K,y as rt,a as o,v as f,d as h,t as m,w as u}from"../chunks/index.fe795e71.js";import{T as lt}from"../chunks/Tip.179eb360.js";import{C as tt}from"../chunks/CodeBlock.204b6c34.js";import{H as w,E as ct}from"../chunks/getInferenceSnippets.5aa7956d.js";function pt(ee){let l,P="In the image above, the tensors were sharded across the 1st dimension for the sake of fitting the image on the screen, in reality, they are sharded across the 0th dimension as stated above";return{c(){l=n("p"),l.textContent=P},l(g){l=d(g,"P",{"data-svelte-h":!0}),r(l)!=="svelte-1t34evv"&&(l.textContent=P)},m(g,O){o(g,l,O)},p:it,d(g){g&&s(l)}}}function ft(ee){let l,P,g,O,T,te,D,Ee="This guide explains the key differences between <code>FSDP1</code> and <code>FSDP2</code> and helps you migrate your existing code to use <code>FSDP2</code> with minimal changes.",se,b,oe,S,Ae="First, we want to understand how <code>FSDP1</code> and <code>FSDP2</code> work internally to understand the differences between them. This also helps us understand the limitations of <code>FSDP1</code> and how <code>FSDP2</code> solves them.",ie,M,Ie="We’ll be discussing a scenario where we have a single <code>Layer</code> that contains 3 <code>Linear</code> layers and is wrapped using <code>FSDP</code> to be sharded across 2 GPUs.",ae,$,Ue='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/accelerate/layer.png" alt="Layer"/>',ne,F,de,L,je="First, we have to understand the original <code>FSDP1</code> and the limitations it brings. It represents each <code>FSDP</code> module as a single <code>FlatParameter</code> which is a single 1D tensor that contains all of the module parameters, which then get sharded across ranks. I.e. if you wrap the <code>Layer</code> with <code>FSDP1</code>, you’d achieve something as such:",re,v,Ze='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/accelerate/fsdp1.png" alt="FSDP1"/>',le,H,Ge="You might notice a problem. The whole <code>Layer</code> gets flattened into a single <code>FlatParameter</code>, which then gets sharded across ranks. But if it’s a single <code>FlatParameter</code> object, how do we store metadata? That is one of the limitations. Properly storing per-parameter metadata such as <code>dtype</code>, <code>requires_grad</code>, etc. is not possible without some ugly hacks.",ce,x,pe,C,Re='This is why <code>FSDP2</code> was introduced. It doesn’t use <code>FlatParameter</code>, instead it uses <code>DTensor</code> which is short for “Distributed Tensor”. Each <code>DTensor</code> basically represents a vanilla <code>torch.Tensor</code> that has been sharded across ranks. It contains metadata about the original <code>torch.Tensor</code> and how it’s sharded, what is the <a href="https://pytorch.org/docs/stable/distributed.tensor.html#module-torch.distributed.tensor.placement_types" rel="nofollow">placement type</a> and so on. This is why it’s called <code>per-parameter sharding</code>. The following figure shows the difference:',fe,y,We='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/accelerate/fsdp2.png" alt="FSDP2"/>',he,k,Be="Each Parameter of the original <code>Layer</code> is sharded across the 0th dimension, and split between 2 GPUs. Now, each <code>Linear</code> layer is a separate <code>DTensor</code> and storing metadata per-parameter is possible and straightforward.",me,_,ue,E,ge,A,Ve="<code>FSDP2</code> is a new and improved version of PyTorch’s fully-sharded data parallel training API. Its main advantage is using <code>DTensor</code> to represent sharded parameters. Compared to <code>FSDP1</code>, it offers:",we,I,Ye='<li>Simpler internal implementation, where each <code>Parameter</code> is a separate <code>DTensor</code></li> <li>Enables simple partial parameter freezing because of the above, which makes methods as <a href="https://arxiv.org/abs/2106.09685" rel="nofollow"><code>LORA</code></a> work out of the box</li> <li>With <code>DTensor</code>, <code>FSDP2</code> supports mixing <code>fp8</code> and other parameter types in the same model out of the box</li> <li>Faster and simpler checkpointing without extra communication across ranks using <code>SHARDED_STATE_DICT</code> and <a href="https://pytorch.org/docs/stable/distributed.checkpoint.html" rel="nofollow"><code>torch.distributed.checkpoint</code></a>, this way, each rank only saves its own shard and corresponding metadata</li> <li>For loading, it uses a <code>state_dict</code> of the sharded model to directly load the sharded parameters</li> <li>Support for asynchronous checkpointing, where parameters are first copied to CPU memory, after this, main thread continues training while another thread stores the parameters on disk</li> <li>Memory efficiency and deterministic memory usage, <code>FSDP2</code> doesn’t use <code>recordStream</code> anymore and uses stream-to-stream synchronization (for more technical details see <a href="https://dev-discuss.pytorch.org/t/fsdp-cudacachingallocator-an-outsider-newb-perspective/1486" rel="nofollow">this forum post</a> and <a href="https://github.com/pytorch/pytorch/issues/114299" rel="nofollow">this issue</a>)</li> <li>In the future, optimizations of the communication patterns via <code>torch.compile</code> are planned, further improving the performance and memory efficiency</li>',$e,U,ve,j,Ne="We have already discussed the internal differences, now let’s discuss the differences, you, as a user, will need to know.",ye,Z,ze="Here are the main changes in configuration options when using <code>FSDP2</code> through the <code>accelerate</code> CLI:",_e,G,Je="<thead><tr><th>Previous (<code>FSDP1</code>)</th> <th>New (<code>FSDP2</code>)</th> <th>What Changed</th></tr></thead> <tbody><tr><td><code>--fsdp_sharding_strategy</code></td> <td><code>--fsdp_reshard_after_forward</code></td> <td>replaces <code>--fsdp_sharding_strategy</code>, changed to <code>true</code> (previously <code>FULL_SHARD</code>) or <code>false</code> (previously <code>SHARD_GRAD_OP</code>)</td></tr> <tr><td><code>--fsdp_backward_prefetch</code></td> <td>**<strong>REMOVED</strong>**</td> <td><code>FSDP2</code> uses previous <code>BACKWARD_PRE</code> option by default, as only this allows communication and computation overlap</td></tr> <tr><td><code>--fsdp_forward_prefetch</code></td> <td>**<strong>NOT YET IMPLEMENTED</strong>**</td> <td>How to implement this is under active discussion, for now it is not supported in <code>FSDP2</code></td></tr> <tr><td><code>--fsdp_sync_module_states</code></td> <td>**<strong>REMOVED</strong>**</td> <td>with <code>FSDP2</code>, this parameter becomes redundant</td></tr> <tr><td><code>--fsdp_cpu_ram_efficient_loading</code></td> <td><code>--fsdp_cpu_ram_efficient_loading</code></td> <td>if <code>true</code>, <code>FSDP2</code> will similarly load the model only on rank 0, and then parameters get synced to other ranks, this is the same behavior as <code>FSDP1</code>, however, setting <code>--fsdp_sync_module_states</code> isn’t required anymore</td></tr> <tr><td><code>--fsdp_state_dict_type</code></td> <td><code>--fsdp_state_dict_type</code></td> <td><code>LOCAL_STATE_DICT</code> becomes obsolete and with <code>FSDP2</code> <code>SHARDED_STATE_DICT</code> is the default option, which results in no extra communication and each rank saving its own shard, other possible option is <code>FULL_STATE_DICT</code> which results in extra communication and spike in memory usage but saves the full model from rank 0.</td></tr> <tr><td><code>--fsdp_use_orig_params</code></td> <td>**<strong>REMOVED</strong>**</td> <td><code>FSDP2</code> uses a <code>DTensor</code> class on the background, which means it <em>always</em> uses the original parameters by default</td></tr> <tr><td>**<strong>NEW</strong>**</td> <td><code>--fsdp_version</code></td> <td><code>1</code> is the default option, to not break existing code, set to <code>2</code> to use <code>FSDP2</code></td></tr></tbody>",Pe,R,Xe='For all other options that remain unchanged, see the <a href="../usage_guides/fsdp.md"><code>FSDP</code> documentation</a>.',Te,W,De,B,be,V,qe="Simply set <code>fsdp_version=2</code> when creating your plugin and replace options according to the table above.",Se,Y,Me,N,Fe,z,Oe="Use our conversion tool:",Le,J,He,X,Qe="This will automatically convert all FSDP1 settings to their FSDP2 equivalents. Use <code>--overwrite</code> to update the existing file instead of creating a new one.",xe,q,Ce,Q,ke;return T=new w({props:{title:"FSDP1 vs FSDP2",local:"fsdp1-vs-fsdp2",headingTag:"h1"}}),b=new w({props:{title:"How is FSDP2 better than FSDP1?",local:"how-is-fsdp2-better-than-fsdp1",headingTag:"h2"}}),F=new w({props:{title:"FSDP1",local:"fsdp1",headingTag:"h3"}}),x=new w({props:{title:"FSDP2",local:"fsdp2",headingTag:"h3"}}),_=new lt({props:{warning:!1,$$slots:{default:[pt]},$$scope:{ctx:ee}}}),E=new w({props:{title:"What does FSDP2 offer?",local:"what-does-fsdp2-offer",headingTag:"h2"}}),U=new w({props:{title:"API Differences",local:"api-differences",headingTag:"h2"}}),W=new w({props:{title:"How to Switch to FSDP2",local:"how-to-switch-to-fsdp2",headingTag:"h2"}}),B=new w({props:{title:"If using Python code:",local:"if-using-python-code",headingTag:"h3"}}),Y=new tt({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBGdWxseVNoYXJkZWREYXRhUGFyYWxsZWxQbHVnaW4lMkMlMjBBY2NlbGVyYXRvciUwQSUwQWZzZHBfcGx1Z2luJTIwJTNEJTIwRnVsbHlTaGFyZGVkRGF0YVBhcmFsbGVsUGx1Z2luKCUwQSUyMCUyMCUyMCUyMGZzZHBfdmVyc2lvbiUzRDIlMEElMjAlMjAlMjAlMjAlMjMlMjBvdGhlciUyMG9wdGlvbnMuLi4lMEEpJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihmc2RwX3BsdWdpbiUzRGZzZHBfcGx1Z2luKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> FullyShardedDataParallelPlugin, Accelerator

fsdp_plugin = FullyShardedDataParallelPlugin(
    fsdp_version=<span class="hljs-number">2</span>
    <span class="hljs-comment"># other options...</span>
)
accelerator = Accelerator(fsdp_plugin=fsdp_plugin)`,wrap:!1}}),N=new w({props:{title:"If using YAML config:",local:"if-using-yaml-config",headingTag:"h3"}}),J=new tt({props:{code:"YWNjZWxlcmF0ZSUyMHRvLWZzZHAyJTIwLS1jb25maWdfZmlsZSUyMGNvbmZpZy55YW1sJTIwLS1vdXRwdXRfZmlsZSUyMG5ld19jb25maWcueWFtbA==",highlighted:"accelerate to-fsdp2 --config_file config.yaml --output_file new_config.yaml",wrap:!1}}),q=new ct({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/concept_guides/fsdp1_vs_fsdp2.md"}}),{c(){l=n("meta"),P=i(),g=n("p"),O=i(),c(T.$$.fragment),te=i(),D=n("p"),D.innerHTML=Ee,se=i(),c(b.$$.fragment),oe=i(),S=n("p"),S.innerHTML=Ae,ie=i(),M=n("p"),M.innerHTML=Ie,ae=i(),$=n("div"),$.innerHTML=Ue,ne=i(),c(F.$$.fragment),de=i(),L=n("p"),L.innerHTML=je,re=i(),v=n("div"),v.innerHTML=Ze,le=i(),H=n("p"),H.innerHTML=Ge,ce=i(),c(x.$$.fragment),pe=i(),C=n("p"),C.innerHTML=Re,fe=i(),y=n("div"),y.innerHTML=We,he=i(),k=n("p"),k.innerHTML=Be,me=i(),c(_.$$.fragment),ue=i(),c(E.$$.fragment),ge=i(),A=n("p"),A.innerHTML=Ve,we=i(),I=n("ul"),I.innerHTML=Ye,$e=i(),c(U.$$.fragment),ve=i(),j=n("p"),j.textContent=Ne,ye=i(),Z=n("p"),Z.innerHTML=ze,_e=i(),G=n("table"),G.innerHTML=Je,Pe=i(),R=n("p"),R.innerHTML=Xe,Te=i(),c(W.$$.fragment),De=i(),c(B.$$.fragment),be=i(),V=n("p"),V.innerHTML=qe,Se=i(),c(Y.$$.fragment),Me=i(),c(N.$$.fragment),Fe=i(),z=n("p"),z.textContent=Oe,Le=i(),c(J.$$.fragment),He=i(),X=n("p"),X.innerHTML=Qe,xe=i(),c(q.$$.fragment),Ce=i(),Q=n("p"),this.h()},l(e){const t=dt("svelte-u9bgzb",document.head);l=d(t,"META",{name:!0,content:!0}),t.forEach(s),P=a(e),g=d(e,"P",{}),et(g).forEach(s),O=a(e),p(T.$$.fragment,e),te=a(e),D=d(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-j1458a"&&(D.innerHTML=Ee),se=a(e),p(b.$$.fragment,e),oe=a(e),S=d(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-i773ia"&&(S.innerHTML=Ae),ie=a(e),M=d(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-64broj"&&(M.innerHTML=Ie),ae=a(e),$=d(e,"DIV",{align:!0,"data-svelte-h":!0}),r($)!=="svelte-1ksxz48"&&($.innerHTML=Ue),ne=a(e),p(F.$$.fragment,e),de=a(e),L=d(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-jq6gpq"&&(L.innerHTML=je),re=a(e),v=d(e,"DIV",{align:!0,"data-svelte-h":!0}),r(v)!=="svelte-1b5af3k"&&(v.innerHTML=Ze),le=a(e),H=d(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-uuw76g"&&(H.innerHTML=Ge),ce=a(e),p(x.$$.fragment,e),pe=a(e),C=d(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-metqvu"&&(C.innerHTML=Re),fe=a(e),y=d(e,"DIV",{align:!0,"data-svelte-h":!0}),r(y)!=="svelte-reftl0"&&(y.innerHTML=We),he=a(e),k=d(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-14923cw"&&(k.innerHTML=Be),me=a(e),p(_.$$.fragment,e),ue=a(e),p(E.$$.fragment,e),ge=a(e),A=d(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-pi572c"&&(A.innerHTML=Ve),we=a(e),I=d(e,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-1r35fqd"&&(I.innerHTML=Ye),$e=a(e),p(U.$$.fragment,e),ve=a(e),j=d(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1ckeirw"&&(j.textContent=Ne),ye=a(e),Z=d(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-ovpb8y"&&(Z.innerHTML=ze),_e=a(e),G=d(e,"TABLE",{"data-svelte-h":!0}),r(G)!=="svelte-c2d485"&&(G.innerHTML=Je),Pe=a(e),R=d(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-17n7k2o"&&(R.innerHTML=Xe),Te=a(e),p(W.$$.fragment,e),De=a(e),p(B.$$.fragment,e),be=a(e),V=d(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1bc4t35"&&(V.innerHTML=qe),Se=a(e),p(Y.$$.fragment,e),Me=a(e),p(N.$$.fragment,e),Fe=a(e),z=d(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-t6vwot"&&(z.textContent=Oe),Le=a(e),p(J.$$.fragment,e),He=a(e),X=d(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-nil0yf"&&(X.innerHTML=Qe),xe=a(e),p(q.$$.fragment,e),Ce=a(e),Q=d(e,"P",{}),et(Q).forEach(s),this.h()},h(){K(l,"name","hf:doc:metadata"),K(l,"content",ht),K($,"align","center"),K(v,"align","center"),K(y,"align","center")},m(e,t){rt(document.head,l),o(e,P,t),o(e,g,t),o(e,O,t),f(T,e,t),o(e,te,t),o(e,D,t),o(e,se,t),f(b,e,t),o(e,oe,t),o(e,S,t),o(e,ie,t),o(e,M,t),o(e,ae,t),o(e,$,t),o(e,ne,t),f(F,e,t),o(e,de,t),o(e,L,t),o(e,re,t),o(e,v,t),o(e,le,t),o(e,H,t),o(e,ce,t),f(x,e,t),o(e,pe,t),o(e,C,t),o(e,fe,t),o(e,y,t),o(e,he,t),o(e,k,t),o(e,me,t),f(_,e,t),o(e,ue,t),f(E,e,t),o(e,ge,t),o(e,A,t),o(e,we,t),o(e,I,t),o(e,$e,t),f(U,e,t),o(e,ve,t),o(e,j,t),o(e,ye,t),o(e,Z,t),o(e,_e,t),o(e,G,t),o(e,Pe,t),o(e,R,t),o(e,Te,t),f(W,e,t),o(e,De,t),f(B,e,t),o(e,be,t),o(e,V,t),o(e,Se,t),f(Y,e,t),o(e,Me,t),f(N,e,t),o(e,Fe,t),o(e,z,t),o(e,Le,t),f(J,e,t),o(e,He,t),o(e,X,t),o(e,xe,t),f(q,e,t),o(e,Ce,t),o(e,Q,t),ke=!0},p(e,[t]){const Ke={};t&2&&(Ke.$$scope={dirty:t,ctx:e}),_.$set(Ke)},i(e){ke||(h(T.$$.fragment,e),h(b.$$.fragment,e),h(F.$$.fragment,e),h(x.$$.fragment,e),h(_.$$.fragment,e),h(E.$$.fragment,e),h(U.$$.fragment,e),h(W.$$.fragment,e),h(B.$$.fragment,e),h(Y.$$.fragment,e),h(N.$$.fragment,e),h(J.$$.fragment,e),h(q.$$.fragment,e),ke=!0)},o(e){m(T.$$.fragment,e),m(b.$$.fragment,e),m(F.$$.fragment,e),m(x.$$.fragment,e),m(_.$$.fragment,e),m(E.$$.fragment,e),m(U.$$.fragment,e),m(W.$$.fragment,e),m(B.$$.fragment,e),m(Y.$$.fragment,e),m(N.$$.fragment,e),m(J.$$.fragment,e),m(q.$$.fragment,e),ke=!1},d(e){e&&(s(P),s(g),s(O),s(te),s(D),s(se),s(oe),s(S),s(ie),s(M),s(ae),s($),s(ne),s(de),s(L),s(re),s(v),s(le),s(H),s(ce),s(pe),s(C),s(fe),s(y),s(he),s(k),s(me),s(ue),s(ge),s(A),s(we),s(I),s($e),s(ve),s(j),s(ye),s(Z),s(_e),s(G),s(Pe),s(R),s(Te),s(De),s(be),s(V),s(Se),s(Me),s(Fe),s(z),s(Le),s(He),s(X),s(xe),s(Ce),s(Q)),s(l),u(T,e),u(b,e),u(F,e),u(x,e),u(_,e),u(E,e),u(U,e),u(W,e),u(B,e),u(Y,e),u(N,e),u(J,e),u(q,e)}}}const ht='{"title":"FSDP1 vs FSDP2","local":"fsdp1-vs-fsdp2","sections":[{"title":"How is FSDP2 better than FSDP1?","local":"how-is-fsdp2-better-than-fsdp1","sections":[{"title":"FSDP1","local":"fsdp1","sections":[],"depth":3},{"title":"FSDP2","local":"fsdp2","sections":[],"depth":3}],"depth":2},{"title":"What does FSDP2 offer?","local":"what-does-fsdp2-offer","sections":[],"depth":2},{"title":"API Differences","local":"api-differences","sections":[],"depth":2},{"title":"How to Switch to FSDP2","local":"how-to-switch-to-fsdp2","sections":[{"title":"If using Python code:","local":"if-using-python-code","sections":[],"depth":3},{"title":"If using YAML config:","local":"if-using-yaml-config","sections":[],"depth":3}],"depth":2}],"depth":1}';function mt(ee){return ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yt extends at{constructor(l){super(),nt(this,l,mt,ft,st,{})}}export{yt as component};
