import{s as no,o as lo,n as er}from"../chunks/scheduler.9991993c.js";import{S as io,i as mo,g as n,s as a,r as p,A as co,h as l,f as t,c as o,j as $,u as f,x as m,k as b,y as s,a as i,v as u,d as h,t as g,w as _}from"../chunks/index.7fc9a5e7.js";import{T as oa}from"../chunks/Tip.9de92fc6.js";import{D as M}from"../chunks/Docstring.8180f571.js";import{C as rr}from"../chunks/CodeBlock.e11cba92.js";import{E as na}from"../chunks/ExampleCodeBlock.a03fccd6.js";import{H as pe}from"../chunks/Heading.e3de321f.js";function po(X){let d,T=`This class method is simply calling the feature extractor
<a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){d=n("p"),d.innerHTML=T},l(v){d=l(v,"P",{"data-svelte-h":!0}),m(d)!=="svelte-1numcrz"&&(d.innerHTML=T)},m(v,x){i(v,d,x)},p:er,d(v){v&&t(d)}}}function fo(X){let d,T="Examples:",v,x,C;return x=new rr({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMHByb2Nlc3NvciUyMHRvJTIweW91ciUyMG5hbWVzcGFjZSUyMHdpdGglMjB0aGUlMjBuYW1lJTIwJTIybXktZmluZXR1bmVkLWJlcnQlMjIuJTBBcHJvY2Vzc29yLnB1c2hfdG9faHViKCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyKSUwQSUwQSUyMyUyMFB1c2glMjB0aGUlMjBwcm9jZXNzb3IlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFwcm9jZXNzb3IucHVzaF90b19odWIoJTIyaHVnZ2luZ2ZhY2UlMkZteS1maW5ldHVuZWQtYmVydCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the processor to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the processor to an organization with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){d=n("p"),d.textContent=T,v=a(),p(x.$$.fragment)},l(c){d=l(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-kvfsh7"&&(d.textContent=T),v=o(c),f(x.$$.fragment,c)},m(c,I){i(c,d,I),i(c,v,I),u(x,c,I),C=!0},p:er,i(c){C||(h(x.$$.fragment,c),C=!0)},o(c){g(x.$$.fragment,c),C=!1},d(c){c&&(t(d),t(v)),_(x,c)}}}function uo(X){let d,T="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){d=n("p"),d.textContent=T},l(v){d=l(v,"P",{"data-svelte-h":!0}),m(d)!=="svelte-15rpg4"&&(d.textContent=T)},m(v,x){i(v,d,x)},p:er,d(v){v&&t(d)}}}function ho(X){let d,T=`This class method is simply calling <a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/zh/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){d=n("p"),d.innerHTML=T},l(v){d=l(v,"P",{"data-svelte-h":!0}),m(d)!=="svelte-6mch0o"&&(d.innerHTML=T)},m(v,x){i(v,d,x)},p:er,d(v){v&&t(d)}}}function go(X){let d,T="Examples:",v,x,C;return x=new rr({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMGFzJTIwdGZkcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBJTBBdHJhaW5pbmdfZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzREZhbHNlKSUwQWV2YWx1YXRpb25fZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow_datasets <span class="hljs-keyword">as</span> tfds

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>training_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>evaluation_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){d=n("p"),d.textContent=T,v=a(),p(x.$$.fragment)},l(c){d=l(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-kvfsh7"&&(d.textContent=T),v=o(c),f(x.$$.fragment,c)},m(c,I){i(c,d,I),i(c,v,I),u(x,c,I),C=!0},p:er,i(c){C||(h(x.$$.fragment,c),C=!0)},o(c){g(x.$$.fragment,c),C=!1},d(c){c&&(t(d),t(v)),_(x,c)}}}function _o(X){let d,T="Example:",v,x,C;return x=new rr({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwU3F1YWRWMlByb2Nlc3NvcigpJTBBZXhhbXBsZXMlMjAlM0QlMjBwcm9jZXNzb3IuZ2V0X2Rldl9leGFtcGxlcyhkYXRhX2RpciklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEYXJncy5tYXhfc2VxX2xlbmd0aCUyQyUwQSUyMCUyMCUyMCUyMGRvY19zdHJpZGUlM0RhcmdzLmRvY19zdHJpZGUlMkMlMEElMjAlMjAlMjAlMjBtYXhfcXVlcnlfbGVuZ3RoJTNEYXJncy5tYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`processor = SquadV2Processor()
examples = processor.get_dev_examples(data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=args.max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=args.max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){d=n("p"),d.textContent=T,v=a(),p(x.$$.fragment)},l(c){d=l(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=T),v=o(c),f(x.$$.fragment,c)},m(c,I){i(c,d,I),i(c,v,I),u(x,c,I),C=!0},p:er,i(c){C||(h(x.$$.fragment,c),C=!0)},o(c){g(x.$$.fragment,c),C=!1},d(c){c&&(t(d),t(v)),_(x,c)}}}function vo(X){let d,T,v,x,C,c,I,la="在 Transformers 库中，processors可以有两种不同的含义：",sr,fe,ia='<li>为多模态模型，例如<a href="../model_doc/wav2vec2">Wav2Vec2</a>（语音和文本）或<a href="../model_doc/clip">CLIP</a>（文本和视觉）预处理输入的对象</li> <li>在库的旧版本中用于预处理GLUE或SQUAD数据的已弃用对象。</li>',ar,ue,or,he,ma="任何多模态模型都需要一个对象来编码或解码将多个模态（包括文本、视觉和音频）组合在一起的数据。这由称为processors的对象处理，这些processors将两个或多个处理对象组合在一起，例如tokenizers（用于文本模态），image processors（用于视觉）和feature extractors（用于音频）。",nr,ge,da="这些processors继承自以下实现保存和加载功能的基类：",lr,y,_e,ns,yt,ca="This is a mixin used to provide saving/loading functionality for all processor classes.",ls,D,ve,is,Mt,pa="Instantiates a type of <code>~processing_utils.ProcessingMixin</code> from a Python dictionary of parameters.",ms,j,xe,ds,wt,fa="Instantiate a processor associated with a pretrained model.",cs,G,ps,W,$e,fs,Tt,ua=`From a <code>pretrained_model_name_or_path</code>, resolve to a dictionary of parameters, to be used for instantiating a
processor of type <code>~processing_utils.ProcessingMixin</code> using <code>from_args_and_dict</code>.`,us,z,be,hs,Ct,ha="Upload the processor files to the 🤗 Model Hub.",gs,R,_s,V,ye,vs,Pt,ga=`Register this class with a given auto class. This should only be used for custom feature extractors as the ones
in the library are already mapped with <code>AutoProcessor</code>.`,xs,Q,$s,q,Me,bs,It,_a=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/main/zh/main_classes/processors#transformers.ProcessorMixin.from_pretrained">from_pretrained()</a> method.`,ys,Y,Ms,A,we,ws,Ut,va="Serializes this instance to a Python dictionary.",Ts,O,Te,Cs,kt,xa="Save this instance to a JSON file.",Ps,K,Ce,Is,Xt,$a="Serializes this instance to a JSON string.",ir,Pe,mr,Ie,ba='所有processor都遵循与 <a href="/docs/transformers/main/zh/main_classes/processors#transformers.DataProcessor">DataProcessor</a> 相同的架构。processor返回一个 <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> 列表。这些 <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> 可以转换为 <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputFeatures">InputFeatures</a> 以供输送到模型。',dr,P,Ue,Us,Jt,ya="Base class for data converters for sequence classification data sets.",ks,ee,ke,Xs,Zt,Ma='Gets a collection of <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the dev set.',Js,te,Xe,Zs,Lt,wa="Gets an example from a dict with tensorflow tensors.",Ls,re,Je,js,jt,Ta="Gets the list of labels for this data set.",zs,se,Ze,Vs,zt,Ca='Gets a collection of <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the test set.',qs,ae,Le,Es,Vt,Pa='Gets a collection of <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the train set.',Hs,oe,je,Bs,qt,Ia=`Some tensorflow_datasets datasets are not formatted the same way the GLUE datasets are. This method converts
examples to the correct format.`,cr,J,ze,Fs,Et,Ua="A single training/test example for simple sequence classification.",Ss,ne,Ve,Ns,Ht,ka="Serializes this instance to a JSON string.",pr,Z,qe,Ds,Bt,Xa="A single set of features of data. Property names are the same names as the corresponding inputs to a model.",Gs,le,Ee,Ws,Ft,Ja="Serializes this instance to a JSON string.",fr,He,ur,Be,Za='<a href="https://gluebenchmark.com/" rel="nofollow">General Language Understanding Evaluation (GLUE)</a> 是一个基准测试，评估模型在各种现有的自然语言理解任务上的性能。它与论文 <a href="https://openreview.net/pdf?id=rJ4km2R5t7" rel="nofollow">GLUE: A multi-task benchmark and analysis platform for natural language understanding</a> 一同发布。',hr,Fe,La="该库为以下任务提供了总共10个processor：MRPC、MNLI、MNLI（mismatched）、CoLA、SST2、STSB、QQP、QNLI、RTE 和 WNLI。",gr,Se,ja="这些processor是：",_r,Ne,za="<li><code>~data.processors.utils.MrpcProcessor</code></li> <li><code>~data.processors.utils.MnliProcessor</code></li> <li><code>~data.processors.utils.MnliMismatchedProcessor</code></li> <li><code>~data.processors.utils.Sst2Processor</code></li> <li><code>~data.processors.utils.StsbProcessor</code></li> <li><code>~data.processors.utils.QqpProcessor</code></li> <li><code>~data.processors.utils.QnliProcessor</code></li> <li><code>~data.processors.utils.RteProcessor</code></li> <li><code>~data.processors.utils.WnliProcessor</code></li>",vr,De,Va='此外，还可以使用以下方法从数据文件加载值并将其转换为 <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> 列表。',xr,B,Ge,Rs,St,qa="Loads a data file into a list of <code>InputFeatures</code>",$r,We,br,Re,Ea='<a href="https://www.nyu.edu/projects/bowman/xnli/" rel="nofollow">跨语言NLI语料库（XNLI）</a> 是一个评估跨语言文本表示质量的基准测试。XNLI是一个基于<a href="http://www.nyu.edu/projects/bowman/multinli/" rel="nofollow"><em>MultiNLI</em></a>的众包数据集：”文本对“被标记为包含15种不同语言（包括英语等高资源语言和斯瓦希里语等低资源语言）的文本蕴涵注释。',yr,Qe,Ha='它与论文 <a href="https://arxiv.org/abs/1809.05053" rel="nofollow">XNLI: Evaluating Cross-lingual Sentence Representations</a> 一同发布。',Mr,Ye,Ba="该库提供了加载XNLI数据的processor：",wr,Ae,Fa="<li><code>~data.processors.utils.XnliProcessor</code></li>",Tr,Oe,Sa="请注意，由于测试集上有“gold”标签，因此评估是在测试集上进行的。",Cr,Ke,Na='使用这些processor的示例在 <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-classification/run_xnli.py" rel="nofollow">run_xnli.py</a> 脚本中提供。',Pr,et,Ir,tt,Da='<a href="https://rajpurkar.github.io/SQuAD-explorer//" rel="nofollow">斯坦福问答数据集（SQuAD）</a> 是一个评估模型在问答上性能的基准测试。有两个版本，v1.1 和 v2.0。第一个版本（v1.1）与论文 <a href="https://arxiv.org/abs/1606.05250" rel="nofollow">SQuAD: 100,000+ Questions for Machine Comprehension of Text</a> 一同发布。第二个版本（v2.0）与论文 <a href="https://arxiv.org/abs/1806.03822" rel="nofollow">Know What You Don’t Know: Unanswerable Questions for SQuAD</a> 一同发布。',Ur,rt,Ga="该库为两个版本各自提供了一个processor：",kr,st,Xr,at,Wa="这两个processor是：",Jr,ot,Ra="<li><code>~data.processors.utils.SquadV1Processor</code></li> <li><code>~data.processors.utils.SquadV2Processor</code></li>",Zr,nt,Qa="它们都继承自抽象类 <code>~data.processors.utils.SquadProcessor</code>。",Lr,k,lt,Qs,Nt,Ya=`Processor for the SQuAD data set. overridden by SquadV1Processor and SquadV2Processor, used by the version 1.1 and
version 2.0 of SQuAD, respectively.`,Ys,ie,it,As,Dt,Aa="Returns the evaluation example from the data directory.",Os,E,mt,Ks,Gt,Oa="Creates a list of <code>SquadExample</code> using a TFDS dataset.",ea,me,ta,de,dt,ra,Wt,Ka="Returns the training examples from the data directory.",jr,ct,eo="此外，可以使用以下方法将 SQuAD 示例转换为可用作模型输入的 <code>~data.processors.utils.SquadFeatures</code>。",zr,L,pt,sa,Rt,to=`Converts a list of examples into a list of features that can be directly given as input to a model. It is
model-dependant and takes advantage of many of the tokenizer’s features to create the model’s inputs.`,aa,ce,Vr,ft,ro="这些processor以及前面提到的方法可以与包含数据的文件以及tensorflow_datasets包一起使用。下面给出了示例。",qr,ut,Er,ht,so="以下是使用processor以及使用数据文件的转换方法的示例：",Hr,gt,Br,_t,ao="使用 <em>tensorflow_datasets</em> 就像使用数据文件一样简单：",Fr,vt,Sr,xt,oo='另一个使用这些processor的示例在 <a href="https://github.com/huggingface/transformers/tree/main/examples/legacy/question-answering/run_squad.py" rel="nofollow">run_squad.py</a> 脚本中提供。',Nr,tr,Dr;return C=new pe({props:{title:"Processors",local:"processors",headingTag:"h1"}}),ue=new pe({props:{title:"多模态processors",local:"transformers.ProcessorMixin",headingTag:"h2"}}),_e=new M({props:{name:"class transformers.ProcessorMixin",anchor:"transformers.ProcessorMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L56"}}),ve=new M({props:{name:"from_args_and_dict",anchor:"transformers.ProcessorMixin.from_args_and_dict",parameters:[{name:"args",val:""},{name:"processor_dict",val:": Dict"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_args_and_dict.processor_dict",description:`<strong>processor_dict</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary that will be used to instantiate the processor object. Such a dictionary can be
retrieved from a pretrained checkpoint by leveraging the
<code>~processing_utils.ProcessingMixin.to_dict</code> method.`,name:"processor_dict"},{anchor:"transformers.ProcessorMixin.from_args_and_dict.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Additional parameters from which to initialize the processor object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L365",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processor object instantiated from those
parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~processing_utils.ProcessingMixin</code></p>
`}}),xe=new M({props:{name:"from_pretrained",anchor:"transformers.ProcessorMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L406"}}),G=new oa({props:{$$slots:{default:[po]},$$scope:{ctx:X}}}),$e=new M({props:{name:"get_processor_dict",anchor:"transformers.ProcessorMixin.get_processor_dict",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.get_processor_dict.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The identifier of the pre-trained checkpoint from which we want the dictionary of parameters.`,name:"pretrained_model_name_or_path"},{anchor:"transformers.ProcessorMixin.get_processor_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L256",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary(ies) that will be used to instantiate the processor object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[Dict, Dict]</code></p>
`}}),be=new M({props:{name:"push_to_hub",anchor:"transformers.ProcessorMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": Optional = None"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"max_shard_size",val:": Union = '5GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"revision",val:": str = None"},{name:"commit_description",val:": str = None"},{name:"tags",val:": Optional = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your processor to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.ProcessorMixin.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload processor&quot;</code>.`,name:"commit_message"},{anchor:"transformers.ProcessorMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.ProcessorMixin.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.ProcessorMixin.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;5GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>). We default it to <code>&quot;5GB&quot;</code> so that users can easily load models on free-tier
Google Colab instances without any CPU OOM issues.`,name:"max_shard_size"},{anchor:"transformers.ProcessorMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.ProcessorMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.ProcessorMixin.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"transformers.ProcessorMixin.push_to_hub.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to push on the Hub.`,name:"tags"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/hub.py#L768"}}),R=new na({props:{anchor:"transformers.ProcessorMixin.push_to_hub.example",$$slots:{default:[fo]},$$scope:{ctx:X}}}),ye=new M({props:{name:"register_for_auto_class",anchor:"transformers.ProcessorMixin.register_for_auto_class",parameters:[{name:"auto_class",val:" = 'AutoProcessor'"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.register_for_auto_class.auto_class",description:`<strong>auto_class</strong> (<code>str</code> or <code>type</code>, <em>optional</em>, defaults to <code>&quot;AutoProcessor&quot;</code>) &#x2014;
The auto class to register this new feature extractor with.`,name:"auto_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L471"}}),Q=new oa({props:{warning:!0,$$slots:{default:[uo]},$$scope:{ctx:X}}}),Me=new M({props:{name:"save_pretrained",anchor:"transformers.ProcessorMixin.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.ProcessorMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.ProcessorMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L167"}}),Y=new oa({props:{$$slots:{default:[ho]},$$scope:{ctx:X}}}),we=new M({props:{name:"to_dict",anchor:"transformers.ProcessorMixin.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L102",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this processor instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Te=new M({props:{name:"to_json_file",anchor:"transformers.ProcessorMixin.to_json_file",parameters:[{name:"json_file_path",val:": Union"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.to_json_file.json_file_path",description:`<strong>json_file_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file in which this processor instance&#x2019;s parameters will be saved.`,name:"json_file_path"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L151"}}),Ce=new M({props:{name:"to_json_string",anchor:"transformers.ProcessorMixin.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L140",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>String containing all the attributes that make up this feature_extractor instance in JSON format.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Pe=new pe({props:{title:"已弃用的processors",local:"transformers.DataProcessor",headingTag:"h2"}}),Ue=new M({props:{name:"class transformers.DataProcessor",anchor:"transformers.DataProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L80"}}),ke=new M({props:{name:"get_dev_examples",anchor:"transformers.DataProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L97"}}),Xe=new M({props:{name:"get_example_from_tensor_dict",anchor:"transformers.DataProcessor.get_example_from_tensor_dict",parameters:[{name:"tensor_dict",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L83"}}),Je=new M({props:{name:"get_labels",anchor:"transformers.DataProcessor.get_labels",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L105"}}),Ze=new M({props:{name:"get_test_examples",anchor:"transformers.DataProcessor.get_test_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L101"}}),Le=new M({props:{name:"get_train_examples",anchor:"transformers.DataProcessor.get_train_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L93"}}),je=new M({props:{name:"tfds_map",anchor:"transformers.DataProcessor.tfds_map",parameters:[{name:"example",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L109"}}),ze=new M({props:{name:"class transformers.InputExample",anchor:"transformers.InputExample",parameters:[{name:"guid",val:": str"},{name:"text_a",val:": str"},{name:"text_b",val:": Optional = None"},{name:"label",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L29"}}),Ve=new M({props:{name:"to_json_string",anchor:"transformers.InputExample.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L49"}}),qe=new M({props:{name:"class transformers.InputFeatures",anchor:"transformers.InputFeatures",parameters:[{name:"input_ids",val:": List"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"label",val:": Union = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L54"}}),Ee=new M({props:{name:"to_json_string",anchor:"transformers.InputFeatures.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L75"}}),He=new pe({props:{title:"GLUE",local:"transformers.glue_convert_examples_to_features",headingTag:"h2"}}),Ge=new M({props:{name:"transformers.glue_convert_examples_to_features",anchor:"transformers.glue_convert_examples_to_features",parameters:[{name:"examples",val:": Union"},{name:"tokenizer",val:": PreTrainedTokenizer"},{name:"max_length",val:": Optional = None"},{name:"task",val:" = None"},{name:"label_list",val:" = None"},{name:"output_mode",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/glue.py#L41",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If the <code>examples</code> input is a <code>tf.data.Dataset</code>, will return a <code>tf.data.Dataset</code> containing the task-specific
features. If the input is a list of <code>InputExamples</code>, will return a list of task-specific <code>InputFeatures</code> which
can be fed to the model.</p>
`}}),We=new pe({props:{title:"XNLI",local:"xnli",headingTag:"h2"}}),et=new pe({props:{title:"SQuAD",local:"squad",headingTag:"h2"}}),st=new pe({props:{title:"Processors",local:"transformers.data.processors.squad.SquadProcessor",headingTag:"h3"}}),lt=new M({props:{name:"class transformers.data.processors.squad.SquadProcessor",anchor:"transformers.data.processors.squad.SquadProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L541"}}),it=new M({props:{name:"get_dev_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L629"}}),mt=new M({props:{name:"get_examples_from_dataset",anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset",parameters:[{name:"dataset",val:""},{name:"evaluate",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of SquadExample</p>
`}}),me=new na({props:{anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset.example",$$slots:{default:[go]},$$scope:{ctx:X}}}),dt=new M({props:{name:"get_train_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_train_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L607"}}),pt=new M({props:{name:"transformers.squad_convert_examples_to_features",anchor:"transformers.squad_convert_examples_to_features",parameters:[{name:"examples",val:""},{name:"tokenizer",val:""},{name:"max_seq_length",val:""},{name:"doc_stride",val:""},{name:"max_query_length",val:""},{name:"is_training",val:""},{name:"padding_strategy",val:" = 'max_length'"},{name:"return_dataset",val:" = False"},{name:"threads",val:" = 1"},{name:"tqdm_enabled",val:" = True"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L316",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <code>SquadFeatures</code></p>
`}}),ce=new na({props:{anchor:"transformers.squad_convert_examples_to_features.example",$$slots:{default:[_o]},$$scope:{ctx:X}}}),ut=new pe({props:{title:"Example使用",local:"example使用",headingTag:"h3"}}),gt=new rr({props:{code:"JTIzJTIwTG9hZGluZyUyMGElMjBWMiUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjJQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjJfZGF0YV9kaXIpJTBBJTBBJTIzJTIwTG9hZGluZyUyMGElMjBWMSUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjFQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjFfZGF0YV9kaXIpJTBBJTBBZmVhdHVyZXMlMjAlM0QlMjBzcXVhZF9jb252ZXJ0X2V4YW1wbGVzX3RvX2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEZXhhbXBsZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRG1heF9zZXFfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwZG9jX3N0cmlkZSUzRGFyZ3MuZG9jX3N0cmlkZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9xdWVyeV9sZW5ndGglM0RtYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Loading a V2 processor</span>
processor = SquadV2Processor()
examples = processor.get_dev_examples(squad_v2_data_dir)

<span class="hljs-comment"># Loading a V1 processor</span>
processor = SquadV1Processor()
examples = processor.get_dev_examples(squad_v1_data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),vt=new rr({props:{code:"JTIzJTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMG9ubHklMjBoYW5kbGUlMjBTcXVhZCUyMFYxLiUwQXRmZHNfZXhhbXBsZXMlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBZXhhbXBsZXMlMjAlM0QlMjBTcXVhZFYxUHJvY2Vzc29yKCkuZ2V0X2V4YW1wbGVzX2Zyb21fZGF0YXNldCh0ZmRzX2V4YW1wbGVzJTJDJTIwZXZhbHVhdGUlM0RldmFsdWF0ZSklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBkb2Nfc3RyaWRlJTNEYXJncy5kb2Nfc3RyaWRlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3F1ZXJ5X2xlbmd0aCUzRG1heF9xdWVyeV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBpc190cmFpbmluZyUzRG5vdCUyMGV2YWx1YXRlJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># tensorflow_datasets only handle Squad V1.</span>
tfds_examples = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)
examples = SquadV1Processor().get_examples_from_dataset(tfds_examples, evaluate=evaluate)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){d=n("meta"),T=a(),v=n("p"),x=a(),p(C.$$.fragment),c=a(),I=n("p"),I.textContent=la,sr=a(),fe=n("ul"),fe.innerHTML=ia,ar=a(),p(ue.$$.fragment),or=a(),he=n("p"),he.textContent=ma,nr=a(),ge=n("p"),ge.textContent=da,lr=a(),y=n("div"),p(_e.$$.fragment),ns=a(),yt=n("p"),yt.textContent=ca,ls=a(),D=n("div"),p(ve.$$.fragment),is=a(),Mt=n("p"),Mt.innerHTML=pa,ms=a(),j=n("div"),p(xe.$$.fragment),ds=a(),wt=n("p"),wt.textContent=fa,cs=a(),p(G.$$.fragment),ps=a(),W=n("div"),p($e.$$.fragment),fs=a(),Tt=n("p"),Tt.innerHTML=ua,us=a(),z=n("div"),p(be.$$.fragment),hs=a(),Ct=n("p"),Ct.textContent=ha,gs=a(),p(R.$$.fragment),_s=a(),V=n("div"),p(ye.$$.fragment),vs=a(),Pt=n("p"),Pt.innerHTML=ga,xs=a(),p(Q.$$.fragment),$s=a(),q=n("div"),p(Me.$$.fragment),bs=a(),It=n("p"),It.innerHTML=_a,ys=a(),p(Y.$$.fragment),Ms=a(),A=n("div"),p(we.$$.fragment),ws=a(),Ut=n("p"),Ut.textContent=va,Ts=a(),O=n("div"),p(Te.$$.fragment),Cs=a(),kt=n("p"),kt.textContent=xa,Ps=a(),K=n("div"),p(Ce.$$.fragment),Is=a(),Xt=n("p"),Xt.textContent=$a,ir=a(),p(Pe.$$.fragment),mr=a(),Ie=n("p"),Ie.innerHTML=ba,dr=a(),P=n("div"),p(Ue.$$.fragment),Us=a(),Jt=n("p"),Jt.textContent=ya,ks=a(),ee=n("div"),p(ke.$$.fragment),Xs=a(),Zt=n("p"),Zt.innerHTML=Ma,Js=a(),te=n("div"),p(Xe.$$.fragment),Zs=a(),Lt=n("p"),Lt.textContent=wa,Ls=a(),re=n("div"),p(Je.$$.fragment),js=a(),jt=n("p"),jt.textContent=Ta,zs=a(),se=n("div"),p(Ze.$$.fragment),Vs=a(),zt=n("p"),zt.innerHTML=Ca,qs=a(),ae=n("div"),p(Le.$$.fragment),Es=a(),Vt=n("p"),Vt.innerHTML=Pa,Hs=a(),oe=n("div"),p(je.$$.fragment),Bs=a(),qt=n("p"),qt.textContent=Ia,cr=a(),J=n("div"),p(ze.$$.fragment),Fs=a(),Et=n("p"),Et.textContent=Ua,Ss=a(),ne=n("div"),p(Ve.$$.fragment),Ns=a(),Ht=n("p"),Ht.textContent=ka,pr=a(),Z=n("div"),p(qe.$$.fragment),Ds=a(),Bt=n("p"),Bt.textContent=Xa,Gs=a(),le=n("div"),p(Ee.$$.fragment),Ws=a(),Ft=n("p"),Ft.textContent=Ja,fr=a(),p(He.$$.fragment),ur=a(),Be=n("p"),Be.innerHTML=Za,hr=a(),Fe=n("p"),Fe.textContent=La,gr=a(),Se=n("p"),Se.textContent=ja,_r=a(),Ne=n("ul"),Ne.innerHTML=za,vr=a(),De=n("p"),De.innerHTML=Va,xr=a(),B=n("div"),p(Ge.$$.fragment),Rs=a(),St=n("p"),St.innerHTML=qa,$r=a(),p(We.$$.fragment),br=a(),Re=n("p"),Re.innerHTML=Ea,yr=a(),Qe=n("p"),Qe.innerHTML=Ha,Mr=a(),Ye=n("p"),Ye.textContent=Ba,wr=a(),Ae=n("ul"),Ae.innerHTML=Fa,Tr=a(),Oe=n("p"),Oe.textContent=Sa,Cr=a(),Ke=n("p"),Ke.innerHTML=Na,Pr=a(),p(et.$$.fragment),Ir=a(),tt=n("p"),tt.innerHTML=Da,Ur=a(),rt=n("p"),rt.textContent=Ga,kr=a(),p(st.$$.fragment),Xr=a(),at=n("p"),at.textContent=Wa,Jr=a(),ot=n("ul"),ot.innerHTML=Ra,Zr=a(),nt=n("p"),nt.innerHTML=Qa,Lr=a(),k=n("div"),p(lt.$$.fragment),Qs=a(),Nt=n("p"),Nt.textContent=Ya,Ys=a(),ie=n("div"),p(it.$$.fragment),As=a(),Dt=n("p"),Dt.textContent=Aa,Os=a(),E=n("div"),p(mt.$$.fragment),Ks=a(),Gt=n("p"),Gt.innerHTML=Oa,ea=a(),p(me.$$.fragment),ta=a(),de=n("div"),p(dt.$$.fragment),ra=a(),Wt=n("p"),Wt.textContent=Ka,jr=a(),ct=n("p"),ct.innerHTML=eo,zr=a(),L=n("div"),p(pt.$$.fragment),sa=a(),Rt=n("p"),Rt.textContent=to,aa=a(),p(ce.$$.fragment),Vr=a(),ft=n("p"),ft.textContent=ro,qr=a(),p(ut.$$.fragment),Er=a(),ht=n("p"),ht.textContent=so,Hr=a(),p(gt.$$.fragment),Br=a(),_t=n("p"),_t.innerHTML=ao,Fr=a(),p(vt.$$.fragment),Sr=a(),xt=n("p"),xt.innerHTML=oo,Nr=a(),tr=n("p"),this.h()},l(e){const r=co("svelte-u9bgzb",document.head);d=l(r,"META",{name:!0,content:!0}),r.forEach(t),T=o(e),v=l(e,"P",{}),$(v).forEach(t),x=o(e),f(C.$$.fragment,e),c=o(e),I=l(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1fd9lf0"&&(I.textContent=la),sr=o(e),fe=l(e,"UL",{"data-svelte-h":!0}),m(fe)!=="svelte-rmvfpp"&&(fe.innerHTML=ia),ar=o(e),f(ue.$$.fragment,e),or=o(e),he=l(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-ctzpmo"&&(he.textContent=ma),nr=o(e),ge=l(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-9fh2y4"&&(ge.textContent=da),lr=o(e),y=l(e,"DIV",{class:!0});var w=$(y);f(_e.$$.fragment,w),ns=o(w),yt=l(w,"P",{"data-svelte-h":!0}),m(yt)!=="svelte-1s4wckx"&&(yt.textContent=ca),ls=o(w),D=l(w,"DIV",{class:!0});var $t=$(D);f(ve.$$.fragment,$t),is=o($t),Mt=l($t,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-1i2d3vx"&&(Mt.innerHTML=pa),$t.forEach(t),ms=o(w),j=l(w,"DIV",{class:!0});var F=$(j);f(xe.$$.fragment,F),ds=o(F),wt=l(F,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-1cj8dcb"&&(wt.textContent=fa),cs=o(F),f(G.$$.fragment,F),F.forEach(t),ps=o(w),W=l(w,"DIV",{class:!0});var bt=$(W);f($e.$$.fragment,bt),fs=o(bt),Tt=l(bt,"P",{"data-svelte-h":!0}),m(Tt)!=="svelte-hsvutq"&&(Tt.innerHTML=ua),bt.forEach(t),us=o(w),z=l(w,"DIV",{class:!0});var S=$(z);f(be.$$.fragment,S),hs=o(S),Ct=l(S,"P",{"data-svelte-h":!0}),m(Ct)!=="svelte-1cwsjho"&&(Ct.textContent=ha),gs=o(S),f(R.$$.fragment,S),S.forEach(t),_s=o(w),V=l(w,"DIV",{class:!0});var N=$(V);f(ye.$$.fragment,N),vs=o(N),Pt=l(N,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-hhsvto"&&(Pt.innerHTML=ga),xs=o(N),f(Q.$$.fragment,N),N.forEach(t),$s=o(w),q=l(w,"DIV",{class:!0});var Qt=$(q);f(Me.$$.fragment,Qt),bs=o(Qt),It=l(Qt,"P",{"data-svelte-h":!0}),m(It)!=="svelte-wdcnpg"&&(It.innerHTML=_a),ys=o(Qt),f(Y.$$.fragment,Qt),Qt.forEach(t),Ms=o(w),A=l(w,"DIV",{class:!0});var Gr=$(A);f(we.$$.fragment,Gr),ws=o(Gr),Ut=l(Gr,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-1ww3wqq"&&(Ut.textContent=va),Gr.forEach(t),Ts=o(w),O=l(w,"DIV",{class:!0});var Wr=$(O);f(Te.$$.fragment,Wr),Cs=o(Wr),kt=l(Wr,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-1g70y32"&&(kt.textContent=xa),Wr.forEach(t),Ps=o(w),K=l(w,"DIV",{class:!0});var Rr=$(K);f(Ce.$$.fragment,Rr),Is=o(Rr),Xt=l(Rr,"P",{"data-svelte-h":!0}),m(Xt)!=="svelte-5ayq1f"&&(Xt.textContent=$a),Rr.forEach(t),w.forEach(t),ir=o(e),f(Pe.$$.fragment,e),mr=o(e),Ie=l(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-1gqc2ou"&&(Ie.innerHTML=ba),dr=o(e),P=l(e,"DIV",{class:!0});var U=$(P);f(Ue.$$.fragment,U),Us=o(U),Jt=l(U,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-1bsw04k"&&(Jt.textContent=ya),ks=o(U),ee=l(U,"DIV",{class:!0});var Qr=$(ee);f(ke.$$.fragment,Qr),Xs=o(Qr),Zt=l(Qr,"P",{"data-svelte-h":!0}),m(Zt)!=="svelte-i9v8dv"&&(Zt.innerHTML=Ma),Qr.forEach(t),Js=o(U),te=l(U,"DIV",{class:!0});var Yr=$(te);f(Xe.$$.fragment,Yr),Zs=o(Yr),Lt=l(Yr,"P",{"data-svelte-h":!0}),m(Lt)!=="svelte-pplryq"&&(Lt.textContent=wa),Yr.forEach(t),Ls=o(U),re=l(U,"DIV",{class:!0});var Ar=$(re);f(Je.$$.fragment,Ar),js=o(Ar),jt=l(Ar,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-3oqyjr"&&(jt.textContent=Ta),Ar.forEach(t),zs=o(U),se=l(U,"DIV",{class:!0});var Or=$(se);f(Ze.$$.fragment,Or),Vs=o(Or),zt=l(Or,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-1f447o"&&(zt.innerHTML=Ca),Or.forEach(t),qs=o(U),ae=l(U,"DIV",{class:!0});var Kr=$(ae);f(Le.$$.fragment,Kr),Es=o(Kr),Vt=l(Kr,"P",{"data-svelte-h":!0}),m(Vt)!=="svelte-n3qvn6"&&(Vt.innerHTML=Pa),Kr.forEach(t),Hs=o(U),oe=l(U,"DIV",{class:!0});var es=$(oe);f(je.$$.fragment,es),Bs=o(es),qt=l(es,"P",{"data-svelte-h":!0}),m(qt)!=="svelte-1jevh15"&&(qt.textContent=Ia),es.forEach(t),U.forEach(t),cr=o(e),J=l(e,"DIV",{class:!0});var Yt=$(J);f(ze.$$.fragment,Yt),Fs=o(Yt),Et=l(Yt,"P",{"data-svelte-h":!0}),m(Et)!=="svelte-vkt0pi"&&(Et.textContent=Ua),Ss=o(Yt),ne=l(Yt,"DIV",{class:!0});var ts=$(ne);f(Ve.$$.fragment,ts),Ns=o(ts),Ht=l(ts,"P",{"data-svelte-h":!0}),m(Ht)!=="svelte-5ayq1f"&&(Ht.textContent=ka),ts.forEach(t),Yt.forEach(t),pr=o(e),Z=l(e,"DIV",{class:!0});var At=$(Z);f(qe.$$.fragment,At),Ds=o(At),Bt=l(At,"P",{"data-svelte-h":!0}),m(Bt)!=="svelte-168wf64"&&(Bt.textContent=Xa),Gs=o(At),le=l(At,"DIV",{class:!0});var rs=$(le);f(Ee.$$.fragment,rs),Ws=o(rs),Ft=l(rs,"P",{"data-svelte-h":!0}),m(Ft)!=="svelte-5ayq1f"&&(Ft.textContent=Ja),rs.forEach(t),At.forEach(t),fr=o(e),f(He.$$.fragment,e),ur=o(e),Be=l(e,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-pf4p60"&&(Be.innerHTML=Za),hr=o(e),Fe=l(e,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-17867sm"&&(Fe.textContent=La),gr=o(e),Se=l(e,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-190jb0p"&&(Se.textContent=ja),_r=o(e),Ne=l(e,"UL",{"data-svelte-h":!0}),m(Ne)!=="svelte-my8qym"&&(Ne.innerHTML=za),vr=o(e),De=l(e,"P",{"data-svelte-h":!0}),m(De)!=="svelte-f7vo7d"&&(De.innerHTML=Va),xr=o(e),B=l(e,"DIV",{class:!0});var ss=$(B);f(Ge.$$.fragment,ss),Rs=o(ss),St=l(ss,"P",{"data-svelte-h":!0}),m(St)!=="svelte-5lvrve"&&(St.innerHTML=qa),ss.forEach(t),$r=o(e),f(We.$$.fragment,e),br=o(e),Re=l(e,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-143feg"&&(Re.innerHTML=Ea),yr=o(e),Qe=l(e,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-1y5f8bi"&&(Qe.innerHTML=Ha),Mr=o(e),Ye=l(e,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-1n6xg4v"&&(Ye.textContent=Ba),wr=o(e),Ae=l(e,"UL",{"data-svelte-h":!0}),m(Ae)!=="svelte-1e2xq99"&&(Ae.innerHTML=Fa),Tr=o(e),Oe=l(e,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-1514ut0"&&(Oe.textContent=Sa),Cr=o(e),Ke=l(e,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-18t4sjl"&&(Ke.innerHTML=Na),Pr=o(e),f(et.$$.fragment,e),Ir=o(e),tt=l(e,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-1cqsmed"&&(tt.innerHTML=Da),Ur=o(e),rt=l(e,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-1hd0jdd"&&(rt.textContent=Ga),kr=o(e),f(st.$$.fragment,e),Xr=o(e),at=l(e,"P",{"data-svelte-h":!0}),m(at)!=="svelte-utkcp6"&&(at.textContent=Wa),Jr=o(e),ot=l(e,"UL",{"data-svelte-h":!0}),m(ot)!=="svelte-1qiv3qf"&&(ot.innerHTML=Ra),Zr=o(e),nt=l(e,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-165sa1k"&&(nt.innerHTML=Qa),Lr=o(e),k=l(e,"DIV",{class:!0});var H=$(k);f(lt.$$.fragment,H),Qs=o(H),Nt=l(H,"P",{"data-svelte-h":!0}),m(Nt)!=="svelte-173gxyd"&&(Nt.textContent=Ya),Ys=o(H),ie=l(H,"DIV",{class:!0});var as=$(ie);f(it.$$.fragment,as),As=o(as),Dt=l(as,"P",{"data-svelte-h":!0}),m(Dt)!=="svelte-wmaktk"&&(Dt.textContent=Aa),as.forEach(t),Os=o(H),E=l(H,"DIV",{class:!0});var Ot=$(E);f(mt.$$.fragment,Ot),Ks=o(Ot),Gt=l(Ot,"P",{"data-svelte-h":!0}),m(Gt)!=="svelte-11nqnea"&&(Gt.innerHTML=Oa),ea=o(Ot),f(me.$$.fragment,Ot),Ot.forEach(t),ta=o(H),de=l(H,"DIV",{class:!0});var os=$(de);f(dt.$$.fragment,os),ra=o(os),Wt=l(os,"P",{"data-svelte-h":!0}),m(Wt)!=="svelte-d5zv1x"&&(Wt.textContent=Ka),os.forEach(t),H.forEach(t),jr=o(e),ct=l(e,"P",{"data-svelte-h":!0}),m(ct)!=="svelte-7uap0d"&&(ct.innerHTML=eo),zr=o(e),L=l(e,"DIV",{class:!0});var Kt=$(L);f(pt.$$.fragment,Kt),sa=o(Kt),Rt=l(Kt,"P",{"data-svelte-h":!0}),m(Rt)!=="svelte-169nh0g"&&(Rt.textContent=to),aa=o(Kt),f(ce.$$.fragment,Kt),Kt.forEach(t),Vr=o(e),ft=l(e,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-1dp3thd"&&(ft.textContent=ro),qr=o(e),f(ut.$$.fragment,e),Er=o(e),ht=l(e,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-1tuty7g"&&(ht.textContent=so),Hr=o(e),f(gt.$$.fragment,e),Br=o(e),_t=l(e,"P",{"data-svelte-h":!0}),m(_t)!=="svelte-1klp1tb"&&(_t.innerHTML=ao),Fr=o(e),f(vt.$$.fragment,e),Sr=o(e),xt=l(e,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-1mzejoo"&&(xt.innerHTML=oo),Nr=o(e),tr=l(e,"P",{}),$(tr).forEach(t),this.h()},h(){b(d,"name","hf:doc:metadata"),b(d,"content",xo),b(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){s(document.head,d),i(e,T,r),i(e,v,r),i(e,x,r),u(C,e,r),i(e,c,r),i(e,I,r),i(e,sr,r),i(e,fe,r),i(e,ar,r),u(ue,e,r),i(e,or,r),i(e,he,r),i(e,nr,r),i(e,ge,r),i(e,lr,r),i(e,y,r),u(_e,y,null),s(y,ns),s(y,yt),s(y,ls),s(y,D),u(ve,D,null),s(D,is),s(D,Mt),s(y,ms),s(y,j),u(xe,j,null),s(j,ds),s(j,wt),s(j,cs),u(G,j,null),s(y,ps),s(y,W),u($e,W,null),s(W,fs),s(W,Tt),s(y,us),s(y,z),u(be,z,null),s(z,hs),s(z,Ct),s(z,gs),u(R,z,null),s(y,_s),s(y,V),u(ye,V,null),s(V,vs),s(V,Pt),s(V,xs),u(Q,V,null),s(y,$s),s(y,q),u(Me,q,null),s(q,bs),s(q,It),s(q,ys),u(Y,q,null),s(y,Ms),s(y,A),u(we,A,null),s(A,ws),s(A,Ut),s(y,Ts),s(y,O),u(Te,O,null),s(O,Cs),s(O,kt),s(y,Ps),s(y,K),u(Ce,K,null),s(K,Is),s(K,Xt),i(e,ir,r),u(Pe,e,r),i(e,mr,r),i(e,Ie,r),i(e,dr,r),i(e,P,r),u(Ue,P,null),s(P,Us),s(P,Jt),s(P,ks),s(P,ee),u(ke,ee,null),s(ee,Xs),s(ee,Zt),s(P,Js),s(P,te),u(Xe,te,null),s(te,Zs),s(te,Lt),s(P,Ls),s(P,re),u(Je,re,null),s(re,js),s(re,jt),s(P,zs),s(P,se),u(Ze,se,null),s(se,Vs),s(se,zt),s(P,qs),s(P,ae),u(Le,ae,null),s(ae,Es),s(ae,Vt),s(P,Hs),s(P,oe),u(je,oe,null),s(oe,Bs),s(oe,qt),i(e,cr,r),i(e,J,r),u(ze,J,null),s(J,Fs),s(J,Et),s(J,Ss),s(J,ne),u(Ve,ne,null),s(ne,Ns),s(ne,Ht),i(e,pr,r),i(e,Z,r),u(qe,Z,null),s(Z,Ds),s(Z,Bt),s(Z,Gs),s(Z,le),u(Ee,le,null),s(le,Ws),s(le,Ft),i(e,fr,r),u(He,e,r),i(e,ur,r),i(e,Be,r),i(e,hr,r),i(e,Fe,r),i(e,gr,r),i(e,Se,r),i(e,_r,r),i(e,Ne,r),i(e,vr,r),i(e,De,r),i(e,xr,r),i(e,B,r),u(Ge,B,null),s(B,Rs),s(B,St),i(e,$r,r),u(We,e,r),i(e,br,r),i(e,Re,r),i(e,yr,r),i(e,Qe,r),i(e,Mr,r),i(e,Ye,r),i(e,wr,r),i(e,Ae,r),i(e,Tr,r),i(e,Oe,r),i(e,Cr,r),i(e,Ke,r),i(e,Pr,r),u(et,e,r),i(e,Ir,r),i(e,tt,r),i(e,Ur,r),i(e,rt,r),i(e,kr,r),u(st,e,r),i(e,Xr,r),i(e,at,r),i(e,Jr,r),i(e,ot,r),i(e,Zr,r),i(e,nt,r),i(e,Lr,r),i(e,k,r),u(lt,k,null),s(k,Qs),s(k,Nt),s(k,Ys),s(k,ie),u(it,ie,null),s(ie,As),s(ie,Dt),s(k,Os),s(k,E),u(mt,E,null),s(E,Ks),s(E,Gt),s(E,ea),u(me,E,null),s(k,ta),s(k,de),u(dt,de,null),s(de,ra),s(de,Wt),i(e,jr,r),i(e,ct,r),i(e,zr,r),i(e,L,r),u(pt,L,null),s(L,sa),s(L,Rt),s(L,aa),u(ce,L,null),i(e,Vr,r),i(e,ft,r),i(e,qr,r),u(ut,e,r),i(e,Er,r),i(e,ht,r),i(e,Hr,r),u(gt,e,r),i(e,Br,r),i(e,_t,r),i(e,Fr,r),u(vt,e,r),i(e,Sr,r),i(e,xt,r),i(e,Nr,r),i(e,tr,r),Dr=!0},p(e,[r]){const w={};r&2&&(w.$$scope={dirty:r,ctx:e}),G.$set(w);const $t={};r&2&&($t.$$scope={dirty:r,ctx:e}),R.$set($t);const F={};r&2&&(F.$$scope={dirty:r,ctx:e}),Q.$set(F);const bt={};r&2&&(bt.$$scope={dirty:r,ctx:e}),Y.$set(bt);const S={};r&2&&(S.$$scope={dirty:r,ctx:e}),me.$set(S);const N={};r&2&&(N.$$scope={dirty:r,ctx:e}),ce.$set(N)},i(e){Dr||(h(C.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(xe.$$.fragment,e),h(G.$$.fragment,e),h($e.$$.fragment,e),h(be.$$.fragment,e),h(R.$$.fragment,e),h(ye.$$.fragment,e),h(Q.$$.fragment,e),h(Me.$$.fragment,e),h(Y.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(Ce.$$.fragment,e),h(Pe.$$.fragment,e),h(Ue.$$.fragment,e),h(ke.$$.fragment,e),h(Xe.$$.fragment,e),h(Je.$$.fragment,e),h(Ze.$$.fragment,e),h(Le.$$.fragment,e),h(je.$$.fragment,e),h(ze.$$.fragment,e),h(Ve.$$.fragment,e),h(qe.$$.fragment,e),h(Ee.$$.fragment,e),h(He.$$.fragment,e),h(Ge.$$.fragment,e),h(We.$$.fragment,e),h(et.$$.fragment,e),h(st.$$.fragment,e),h(lt.$$.fragment,e),h(it.$$.fragment,e),h(mt.$$.fragment,e),h(me.$$.fragment,e),h(dt.$$.fragment,e),h(pt.$$.fragment,e),h(ce.$$.fragment,e),h(ut.$$.fragment,e),h(gt.$$.fragment,e),h(vt.$$.fragment,e),Dr=!0)},o(e){g(C.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(xe.$$.fragment,e),g(G.$$.fragment,e),g($e.$$.fragment,e),g(be.$$.fragment,e),g(R.$$.fragment,e),g(ye.$$.fragment,e),g(Q.$$.fragment,e),g(Me.$$.fragment,e),g(Y.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(Ce.$$.fragment,e),g(Pe.$$.fragment,e),g(Ue.$$.fragment,e),g(ke.$$.fragment,e),g(Xe.$$.fragment,e),g(Je.$$.fragment,e),g(Ze.$$.fragment,e),g(Le.$$.fragment,e),g(je.$$.fragment,e),g(ze.$$.fragment,e),g(Ve.$$.fragment,e),g(qe.$$.fragment,e),g(Ee.$$.fragment,e),g(He.$$.fragment,e),g(Ge.$$.fragment,e),g(We.$$.fragment,e),g(et.$$.fragment,e),g(st.$$.fragment,e),g(lt.$$.fragment,e),g(it.$$.fragment,e),g(mt.$$.fragment,e),g(me.$$.fragment,e),g(dt.$$.fragment,e),g(pt.$$.fragment,e),g(ce.$$.fragment,e),g(ut.$$.fragment,e),g(gt.$$.fragment,e),g(vt.$$.fragment,e),Dr=!1},d(e){e&&(t(T),t(v),t(x),t(c),t(I),t(sr),t(fe),t(ar),t(or),t(he),t(nr),t(ge),t(lr),t(y),t(ir),t(mr),t(Ie),t(dr),t(P),t(cr),t(J),t(pr),t(Z),t(fr),t(ur),t(Be),t(hr),t(Fe),t(gr),t(Se),t(_r),t(Ne),t(vr),t(De),t(xr),t(B),t($r),t(br),t(Re),t(yr),t(Qe),t(Mr),t(Ye),t(wr),t(Ae),t(Tr),t(Oe),t(Cr),t(Ke),t(Pr),t(Ir),t(tt),t(Ur),t(rt),t(kr),t(Xr),t(at),t(Jr),t(ot),t(Zr),t(nt),t(Lr),t(k),t(jr),t(ct),t(zr),t(L),t(Vr),t(ft),t(qr),t(Er),t(ht),t(Hr),t(Br),t(_t),t(Fr),t(Sr),t(xt),t(Nr),t(tr)),t(d),_(C,e),_(ue,e),_(_e),_(ve),_(xe),_(G),_($e),_(be),_(R),_(ye),_(Q),_(Me),_(Y),_(we),_(Te),_(Ce),_(Pe,e),_(Ue),_(ke),_(Xe),_(Je),_(Ze),_(Le),_(je),_(ze),_(Ve),_(qe),_(Ee),_(He,e),_(Ge),_(We,e),_(et,e),_(st,e),_(lt),_(it),_(mt),_(me),_(dt),_(pt),_(ce),_(ut,e),_(gt,e),_(vt,e)}}}const xo='{"title":"Processors","local":"processors","sections":[{"title":"多模态processors","local":"transformers.ProcessorMixin","sections":[],"depth":2},{"title":"已弃用的processors","local":"transformers.DataProcessor","sections":[],"depth":2},{"title":"GLUE","local":"transformers.glue_convert_examples_to_features","sections":[],"depth":2},{"title":"XNLI","local":"xnli","sections":[],"depth":2},{"title":"SQuAD","local":"squad","sections":[{"title":"Processors","local":"transformers.data.processors.squad.SquadProcessor","sections":[],"depth":3},{"title":"Example使用","local":"example使用","sections":[],"depth":3}],"depth":2}],"depth":1}';function $o(X){return lo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Io extends io{constructor(d){super(),mo(this,d,$o,vo,no,{})}}export{Io as component};
