import{s as Hp,o as Ep,n as Ip}from"../chunks/scheduler.9bc65507.js";import{S as Qp,i as Rp,g as d,s as n,r as u,A as Up,h as i,f as t,c as s,j as _,u as c,x as f,k as g,y as r,a,v as l,d as p,t as h,w as m}from"../chunks/index.707bf1b6.js";import{T as Dp}from"../chunks/Tip.c2ecdbf4.js";import{D as T}from"../chunks/Docstring.17db21ae.js";import{C as Vp}from"../chunks/CodeBlock.54a9f38d.js";import{H as b}from"../chunks/Heading.342b1fa6.js";function Xp(Rn){let v,j=`When passing <code>output_hidden_states=True</code> you may expect the <code>outputs.hidden_states[-1]</code> to match <code>outputs.last_hidden_states</code> exactly.
However, this is not always the case. Some models apply normalization or subsequent process to the last hidden state when it’s returned.`;return{c(){v=d("p"),v.innerHTML=j},l(x){v=i(x,"P",{"data-svelte-h":!0}),f(v)!=="svelte-7cxjzb"&&(v.innerHTML=j)},m(x,ke){a(x,v,ke)},p:Ip,d(x){x&&t(v)}}}function Jp(Rn){let v,j=`You can’t unpack a <code>ModelOutput</code> directly. Use the <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput.to_tuple">to_tuple()</a> method to convert it to a tuple
before.`;return{c(){v=d("p"),v.innerHTML=j},l(x){v=i(x,"P",{"data-svelte-h":!0}),f(v)!=="svelte-1cvfezb"&&(v.innerHTML=j)},m(x,ke){a(x,v,ke)},p:Ip,d(x){x&&t(v)}}}function Zp(Rn){let v,j,x,ke,Ye,Aa,Ke,dl=`All models have outputs that are instances of subclasses of <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>. Those are
data structures containing all the information returned by the model, but that can also be used as tuples or
dictionaries.`,Pa,et,il="Let’s see how this looks in an example:",La,tt,Ba,ot,ul=`The <code>outputs</code> object is a <a href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput">SequenceClassifierOutput</a>, as we can see in the
documentation of that class below, it means it has an optional <code>loss</code>, a <code>logits</code>, an optional <code>hidden_states</code> and
an optional <code>attentions</code> attribute. Here we have the <code>loss</code> since we passed along <code>labels</code>, but we don’t have
<code>hidden_states</code> and <code>attentions</code> because we didn’t pass <code>output_hidden_states=True</code> or
<code>output_attentions=True</code>.`,Wa,Ae,ja,nt,cl=`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get <code>None</code>. Here for instance <code>outputs.loss</code> is the loss computed by the model, and <code>outputs.attentions</code> is
<code>None</code>.`,Da,st,ll=`When considering our <code>outputs</code> object as tuple, it only considers the attributes that don’t have <code>None</code> values.
Here for instance, it has two elements, <code>loss</code> then <code>logits</code>, so`,Va,at,Ia,rt,pl="will return the tuple <code>(outputs.loss, outputs.logits)</code> for instance.",Ha,dt,hl=`When considering our <code>outputs</code> object as dictionary, it only considers the attributes that don’t have <code>None</code>
values. Here for instance, it has two keys that are <code>loss</code> and <code>logits</code>.`,Ea,it,ml=`We document here the generic model outputs that are used by more than one model type. Specific output types are
documented on their corresponding model page.`,Qa,ut,Ra,$,ct,bu,Un,fl=`Base class for all model outputs as dataclass. Has a <code>__getitem__</code> that allows indexing by integer or slice (like a
tuple) or strings (like a dictionary) that will ignore the <code>None</code> attributes. Otherwise behaves like a regular
python dictionary.`,vu,Pe,xu,Le,lt,$u,Xn,_l="Convert self to a tuple containing all the attributes/keys that are not <code>None</code>.",Ua,pt,Xa,D,ht,qu,Jn,gl="Base class for model’s outputs, with potential hidden states and attentions.",Ja,mt,Za,V,ft,wu,Zn,Tl="Base class for model’s outputs that also contains a pooling of the last hidden states.",Ga,_t,Ya,I,gt,yu,Gn,bl="Base class for model’s outputs, with potential hidden states and attentions.",Ka,Tt,er,H,bt,Ou,Yn,vl="Base class for model’s outputs that also contains a pooling of the last hidden states.",tr,vt,or,E,xt,Su,Kn,xl="Base class for model’s outputs that may also contain a past key/values (to speed up sequential decoding).",nr,$t,sr,Q,qt,Fu,es,$l="Base class for model’s outputs that may also contain a past key/values (to speed up sequential decoding).",ar,wt,rr,R,yt,Mu,ts,ql=`Base class for model encoder’s outputs that also contains : pre-computed hidden states that can speed up sequential
decoding.`,dr,Ot,ir,U,St,Cu,os,wl="Base class for causal language model (or autoregressive) outputs.",ur,Ft,cr,X,Mt,zu,ns,yl="Base class for causal language model (or autoregressive) outputs.",lr,Ct,pr,J,zt,Nu,ss,Ol="Base class for causal language model (or autoregressive) outputs.",hr,Nt,mr,Z,kt,ku,as,Sl="Base class for masked language models outputs.",fr,At,_r,G,Pt,Au,rs,Fl="Base class for sequence-to-sequence language models outputs.",gr,Lt,Tr,Y,Bt,Pu,ds,Ml="Base class for outputs of models predicting if two sentences are consecutive or not.",br,Wt,vr,K,jt,Lu,is,Cl="Base class for outputs of sentence classification models.",xr,Dt,$r,ee,Vt,Bu,us,zl="Base class for outputs of sequence-to-sequence sentence classification models.",qr,It,wr,te,Ht,Wu,cs,Nl="Base class for outputs of multiple choice models.",yr,Et,Or,oe,Qt,ju,ls,kl="Base class for outputs of token classification models.",Sr,Rt,Fr,ne,Ut,Du,ps,Al="Base class for outputs of question answering models.",Mr,Xt,Cr,se,Jt,Vu,hs,Pl="Base class for outputs of sequence-to-sequence question answering models.",zr,Zt,Nr,ae,Gt,Iu,ms,Ll="Base class for sequence-to-sequence spectrogram outputs.",kr,Yt,Ar,re,Kt,Hu,fs,Bl="Base class for outputs of semantic segmentation models.",Pr,eo,Lr,de,to,Eu,_s,Wl="Base class for outputs of image classification models.",Br,oo,Wr,ie,no,Qu,gs,jl="Base class for outputs of image classification models.",jr,so,Dr,ue,ao,Ru,Ts,Dl="Base class for outputs of depth estimation models.",Vr,ro,Ir,ce,io,Uu,bs,Vl="Base class for models that have been trained with the Wav2Vec2 loss objective.",Hr,uo,Er,le,co,Xu,vs,Il='Output type of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForXVector">Wav2Vec2ForXVector</a>.',Qr,lo,Rr,pe,po,Ju,xs,Hl=`Base class for time series model’s encoder outputs that also contains pre-computed hidden states that can speed up
sequential decoding.`,Ur,ho,Xr,he,mo,Zu,$s,El=`Base class for time series model’s decoder outputs that also contain the loss as well as the parameters of the
chosen distribution.`,Jr,fo,Zr,me,_o,Gu,qs,Ql=`Base class for time series model’s predictions outputs that contains the sampled values from the chosen
distribution.`,Gr,go,Yr,fe,To,Yu,ws,Rl="Base class for model’s outputs, with potential hidden states and attentions.",Kr,bo,ed,_e,vo,Ku,ys,Ul="Base class for model’s outputs that also contains a pooling of the last hidden states.",td,xo,od,ge,$o,ec,Os,Xl="Base class for model’s outputs that also contains a pooling of the last hidden states.",nd,qo,sd,Te,wo,tc,Ss,Jl="Base class for model’s outputs that may also contain a past key/values (to speed up sequential decoding).",ad,yo,rd,be,Oo,oc,Fs,Zl="Base class for model’s outputs that may also contain a past key/values (to speed up sequential decoding).",dd,So,id,ve,Fo,nc,Ms,Gl=`Base class for model encoder’s outputs that also contains : pre-computed hidden states that can speed up sequential
decoding.`,ud,Mo,cd,xe,Co,sc,Cs,Yl="Base class for causal language model (or autoregressive) outputs.",ld,zo,pd,$e,No,ac,zs,Kl="Base class for causal language model (or autoregressive) outputs.",hd,ko,md,qe,Ao,rc,Ns,ep="Base class for causal language model (or autoregressive) outputs.",fd,Po,_d,we,Lo,dc,ks,tp="Base class for masked language models outputs.",gd,Bo,Td,ye,Wo,ic,As,op="Base class for sequence-to-sequence language models outputs.",bd,jo,vd,Oe,Do,uc,Ps,np="Base class for outputs of models predicting if two sentences are consecutive or not.",xd,Vo,$d,Se,Io,cc,Ls,sp="Base class for outputs of sentence classification models.",qd,Ho,wd,Fe,Eo,lc,Bs,ap="Base class for outputs of sequence-to-sequence sentence classification models.",yd,Qo,Od,Me,Ro,pc,Ws,rp="Base class for outputs of multiple choice models.",Sd,Uo,Fd,Ce,Xo,hc,js,dp="Base class for outputs of token classification models.",Md,Jo,Cd,ze,Zo,mc,Ds,ip="Base class for outputs of question answering models.",zd,Go,Nd,Ne,Yo,fc,Vs,up="Base class for outputs of sequence-to-sequence question answering models.",kd,Ko,Ad,q,en,_c,Is,cp="Base class for model’s outputs, with potential hidden states and attentions.",gc,Be,tn,Tc,Hs,lp="“Returns a new object replacing the specified fields with new values.",Pd,on,Ld,w,nn,bc,Es,pp="Base class for model’s outputs, with potential hidden states and attentions.",vc,We,sn,xc,Qs,hp="“Returns a new object replacing the specified fields with new values.",Bd,an,Wd,y,rn,$c,Rs,mp="Base class for model’s outputs that also contains a pooling of the last hidden states.",qc,je,dn,wc,Us,fp="“Returns a new object replacing the specified fields with new values.",jd,un,Dd,O,cn,yc,Xs,_p="Base class for model’s outputs that may also contain a past key/values (to speed up sequential decoding).",Oc,De,ln,Sc,Js,gp="“Returns a new object replacing the specified fields with new values.",Vd,pn,Id,S,hn,Fc,Zs,Tp=`Base class for model encoder’s outputs that also contains : pre-computed hidden states that can speed up sequential
decoding.`,Mc,Ve,mn,Cc,Gs,bp="“Returns a new object replacing the specified fields with new values.",Hd,fn,Ed,F,_n,zc,Ys,vp="Base class for causal language model (or autoregressive) outputs.",Nc,Ie,gn,kc,Ks,xp="“Returns a new object replacing the specified fields with new values.",Qd,Tn,Rd,M,bn,Ac,ea,$p="Base class for masked language models outputs.",Pc,He,vn,Lc,ta,qp="“Returns a new object replacing the specified fields with new values.",Ud,xn,Xd,C,$n,Bc,oa,wp="Base class for sequence-to-sequence language models outputs.",Wc,Ee,qn,jc,na,yp="“Returns a new object replacing the specified fields with new values.",Jd,wn,Zd,z,yn,Dc,sa,Op="Base class for outputs of models predicting if two sentences are consecutive or not.",Vc,Qe,On,Ic,aa,Sp="“Returns a new object replacing the specified fields with new values.",Gd,Sn,Yd,N,Fn,Hc,ra,Fp="Base class for outputs of sentence classification models.",Ec,Re,Mn,Qc,da,Mp="“Returns a new object replacing the specified fields with new values.",Kd,Cn,ei,k,zn,Rc,ia,Cp="Base class for outputs of sequence-to-sequence sentence classification models.",Uc,Ue,Nn,Xc,ua,zp="“Returns a new object replacing the specified fields with new values.",ti,kn,oi,A,An,Jc,ca,Np="Base class for outputs of multiple choice models.",Zc,Xe,Pn,Gc,la,kp="“Returns a new object replacing the specified fields with new values.",ni,Ln,si,P,Bn,Yc,pa,Ap="Base class for outputs of token classification models.",Kc,Je,Wn,el,ha,Pp="“Returns a new object replacing the specified fields with new values.",ai,jn,ri,L,Dn,tl,ma,Lp="Base class for outputs of question answering models.",ol,Ze,Vn,nl,fa,Bp="“Returns a new object replacing the specified fields with new values.",di,In,ii,B,Hn,sl,_a,Wp="Base class for outputs of sequence-to-sequence question answering models.",al,Ge,En,rl,ga,jp="“Returns a new object replacing the specified fields with new values.",ui,ka,ci;return Ye=new b({props:{title:"Model outputs",local:"model-outputs",headingTag:"h1"}}),tt=new Vp({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXIlMkMlMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQmVydFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKS51bnNxdWVlemUoMCklMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizer, BertForSequenceClassification
<span class="hljs-keyword">import</span> torch

tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
model = BertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
labels = torch.tensor([<span class="hljs-number">1</span>]).unsqueeze(<span class="hljs-number">0</span>)  <span class="hljs-comment"># Batch size 1</span>
outputs = model(**inputs, labels=labels)`,wrap:!1}}),Ae=new Dp({props:{$$slots:{default:[Xp]},$$scope:{ctx:Rn}}}),at=new Vp({props:{code:"b3V0cHV0cyU1QiUzQTIlNUQ=",highlighted:'outputs[:<span class="hljs-number">2</span>]',wrap:!1}}),ut=new b({props:{title:"ModelOutput",local:"transformers.utils.ModelOutput",headingTag:"h2"}}),ct=new T({props:{name:"class transformers.utils.ModelOutput",anchor:"transformers.utils.ModelOutput",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/generic.py#L290"}}),Pe=new Dp({props:{warning:!0,$$slots:{default:[Jp]},$$scope:{ctx:Rn}}}),lt=new T({props:{name:"to_tuple",anchor:"transformers.utils.ModelOutput.to_tuple",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/generic.py#L434"}}),pt=new b({props:{title:"BaseModelOutput",local:"transformers.modeling_outputs.BaseModelOutput",headingTag:"h2"}}),ht=new T({props:{name:"class transformers.modeling_outputs.BaseModelOutput",anchor:"transformers.modeling_outputs.BaseModelOutput",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L24"}}),mt=new b({props:{title:"BaseModelOutputWithPooling",local:"transformers.modeling_outputs.BaseModelOutputWithPooling",headingTag:"h2"}}),ft=new T({props:{name:"class transformers.modeling_outputs.BaseModelOutputWithPooling",anchor:"transformers.modeling_outputs.BaseModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"pooler_output",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.`,name:"pooler_output"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L69"}}),_t=new b({props:{title:"BaseModelOutputWithCrossAttentions",local:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions",headingTag:"h2"}}),gt=new T({props:{name:"class transformers.modeling_outputs.BaseModelOutputWithCrossAttentions",anchor:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L162"}}),Tt=new b({props:{title:"BaseModelOutputWithPoolingAndCrossAttentions",local:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions",headingTag:"h2"}}),bt=new T({props:{name:"class transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions",anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"pooler_output",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.pooler_output",description:`<strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.`,name:"pooler_output"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L195"}}),vt=new b({props:{title:"BaseModelOutputWithPast",local:"transformers.modeling_outputs.BaseModelOutputWithPast",headingTag:"h2"}}),xt=new T({props:{name:"class transformers.modeling_outputs.BaseModelOutputWithPast",anchor:"transformers.modeling_outputs.BaseModelOutputWithPast",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"past_key_values",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutputWithPast.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPast.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPast.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPast.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L123"}}),$t=new b({props:{title:"BaseModelOutputWithPastAndCrossAttentions",local:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions",headingTag:"h2"}}),qt=new T({props:{name:"class transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions",anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"past_key_values",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L244"}}),wt=new b({props:{title:"Seq2SeqModelOutput",local:"transformers.modeling_outputs.Seq2SeqModelOutput",headingTag:"h2"}}),yt=new T({props:{name:"class transformers.modeling_outputs.Seq2SeqModelOutput",anchor:"transformers.modeling_outputs.Seq2SeqModelOutput",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"past_key_values",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"encoder_last_hidden_state",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the optional initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the optional initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L515"}}),Ot=new b({props:{title:"CausalLMOutput",local:"transformers.modeling_outputs.CausalLMOutput",headingTag:"h2"}}),St=new T({props:{name:"class transformers.modeling_outputs.CausalLMOutput",anchor:"transformers.modeling_outputs.CausalLMOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.CausalLMOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_outputs.CausalLMOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.CausalLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.CausalLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L648"}}),Ft=new b({props:{title:"CausalLMOutputWithCrossAttentions",local:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions",headingTag:"h2"}}),Mt=new T({props:{name:"class transformers.modeling_outputs.CausalLMOutputWithCrossAttentions",anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions",parameters:[{name:"loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"past_key_values",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L713"}}),Ct=new b({props:{title:"CausalLMOutputWithPast",local:"transformers.modeling_outputs.CausalLMOutputWithPast",headingTag:"h2"}}),zt=new T({props:{name:"class transformers.modeling_outputs.CausalLMOutputWithPast",anchor:"transformers.modeling_outputs.CausalLMOutputWithPast",parameters:[{name:"loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"past_key_values",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.CausalLMOutputWithPast.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithPast.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithPast.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithPast.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithPast.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L677"}}),Nt=new b({props:{title:"MaskedLMOutput",local:"transformers.modeling_outputs.MaskedLMOutput",headingTag:"h2"}}),kt=new T({props:{name:"class transformers.modeling_outputs.MaskedLMOutput",anchor:"transformers.modeling_outputs.MaskedLMOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.MaskedLMOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Masked language modeling (MLM) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.MaskedLMOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.MaskedLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.MaskedLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L793"}}),At=new b({props:{title:"Seq2SeqLMOutput",local:"transformers.modeling_outputs.Seq2SeqLMOutput",headingTag:"h2"}}),Pt=new T({props:{name:"class transformers.modeling_outputs.Seq2SeqLMOutput",anchor:"transformers.modeling_outputs.Seq2SeqLMOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"past_key_values",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"encoder_last_hidden_state",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L822"}}),Lt=new b({props:{title:"NextSentencePredictorOutput",local:"transformers.modeling_outputs.NextSentencePredictorOutput",headingTag:"h2"}}),Bt=new T({props:{name:"class transformers.modeling_outputs.NextSentencePredictorOutput",anchor:"transformers.modeling_outputs.NextSentencePredictorOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.NextSentencePredictorOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>next_sentence_label</code> is provided) &#x2014;
Next sequence prediction (classification) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.NextSentencePredictorOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2)</code>) &#x2014;
Prediction scores of the next sequence prediction (classification) head (scores of True/False continuation
before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.NextSentencePredictorOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.NextSentencePredictorOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L957"}}),Wt=new b({props:{title:"SequenceClassifierOutput",local:"transformers.modeling_outputs.SequenceClassifierOutput",headingTag:"h2"}}),jt=new T({props:{name:"class transformers.modeling_outputs.SequenceClassifierOutput",anchor:"transformers.modeling_outputs.SequenceClassifierOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.SequenceClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.SequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.SequenceClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.SequenceClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L987"}}),Dt=new b({props:{title:"Seq2SeqSequenceClassifierOutput",local:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput",headingTag:"h2"}}),Vt=new T({props:{name:"class transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput",anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"past_key_values",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"encoder_last_hidden_state",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>label</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L1016"}}),It=new b({props:{title:"MultipleChoiceModelOutput",local:"transformers.modeling_outputs.MultipleChoiceModelOutput",headingTag:"h2"}}),Ht=new T({props:{name:"class transformers.modeling_outputs.MultipleChoiceModelOutput",anchor:"transformers.modeling_outputs.MultipleChoiceModelOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.MultipleChoiceModelOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <em>(1,)</em>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.MultipleChoiceModelOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices)</code>) &#x2014;
<em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.MultipleChoiceModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.MultipleChoiceModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L1076"}}),Et=new b({props:{title:"TokenClassifierOutput",local:"transformers.modeling_outputs.TokenClassifierOutput",headingTag:"h2"}}),Qt=new T({props:{name:"class transformers.modeling_outputs.TokenClassifierOutput",anchor:"transformers.modeling_outputs.TokenClassifierOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.TokenClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  &#x2014;
Classification loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.TokenClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) &#x2014;
Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.TokenClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.TokenClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L1107"}}),Rt=new b({props:{title:"QuestionAnsweringModelOutput",local:"transformers.modeling_outputs.QuestionAnsweringModelOutput",headingTag:"h2"}}),Ut=new T({props:{name:"class transformers.modeling_outputs.QuestionAnsweringModelOutput",anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"start_logits",val:": FloatTensor = None"},{name:"end_logits",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.`,name:"loss"},{anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L1136"}}),Xt=new b({props:{title:"Seq2SeqQuestionAnsweringModelOutput",local:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput",headingTag:"h2"}}),Jt=new T({props:{name:"class transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput",anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"start_logits",val:": FloatTensor = None"},{name:"end_logits",val:": FloatTensor = None"},{name:"past_key_values",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"encoder_last_hidden_state",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.`,name:"loss"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L1168"}}),Zt=new b({props:{title:"Seq2SeqSpectrogramOutput",local:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput",headingTag:"h2"}}),Gt=new T({props:{name:"class transformers.modeling_outputs.Seq2SeqSpectrogramOutput",anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"spectrogram",val:": FloatTensor = None"},{name:"past_key_values",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"encoder_last_hidden_state",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Spectrogram generation loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.spectrogram",description:`<strong>spectrogram</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, num_bins)</code>) &#x2014;
The predicted spectrogram.`,name:"spectrogram"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L1501"}}),Yt=new b({props:{title:"SemanticSegmenterOutput",local:"transformers.modeling_outputs.SemanticSegmenterOutput",headingTag:"h2"}}),Kt=new T({props:{name:"class transformers.modeling_outputs.SemanticSegmenterOutput",anchor:"transformers.modeling_outputs.SemanticSegmenterOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.SemanticSegmenterOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.SemanticSegmenterOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels, logits_height, logits_width)</code>) &#x2014;
Classification scores for each pixel.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The logits returned do not necessarily have the same size as the <code>pixel_values</code> passed as inputs. This is
to avoid doing two interpolations and lose some quality when a user needs to resize the logits to the
original image size as post-processing. You should always check your logits shape and resize as needed.</p>

					</div>`,name:"logits"},{anchor:"transformers.modeling_outputs.SemanticSegmenterOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, patch_size, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.SemanticSegmenterOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L1231"}}),eo=new b({props:{title:"ImageClassifierOutput",local:"transformers.modeling_outputs.ImageClassifierOutput",headingTag:"h2"}}),to=new T({props:{name:"class transformers.modeling_outputs.ImageClassifierOutput",anchor:"transformers.modeling_outputs.ImageClassifierOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.ImageClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.ImageClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.ImageClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.ImageClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L1269"}}),oo=new b({props:{title:"ImageClassifierOutputWithNoAttention",local:"transformers.modeling_outputs.ImageClassifierOutputWithNoAttention",headingTag:"h2"}}),no=new T({props:{name:"class transformers.modeling_outputs.ImageClassifierOutputWithNoAttention",anchor:"transformers.modeling_outputs.ImageClassifierOutputWithNoAttention",parameters:[{name:"loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.ImageClassifierOutputWithNoAttention.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.ImageClassifierOutputWithNoAttention.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.ImageClassifierOutputWithNoAttention.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also
called feature maps) of the model at the output of each stage.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L1297"}}),so=new b({props:{title:"DepthEstimatorOutput",local:"transformers.modeling_outputs.DepthEstimatorOutput",headingTag:"h2"}}),ao=new T({props:{name:"class transformers.modeling_outputs.DepthEstimatorOutput",anchor:"transformers.modeling_outputs.DepthEstimatorOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"predicted_depth",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.DepthEstimatorOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.DepthEstimatorOutput.predicted_depth",description:`<strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) &#x2014;
Predicted depth for each pixel.`,name:"predicted_depth"},{anchor:"transformers.modeling_outputs.DepthEstimatorOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.DepthEstimatorOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L1318"}}),ro=new b({props:{title:"Wav2Vec2BaseModelOutput",local:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput",headingTag:"h2"}}),io=new T({props:{name:"class transformers.modeling_outputs.Wav2Vec2BaseModelOutput",anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"extract_features",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.extract_features",description:`<strong>extract_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, conv_dim[-1])</code>) &#x2014;
Sequence of extracted feature vectors of the last convolutional layer of the model.`,name:"extract_features"},{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L1376"}}),uo=new b({props:{title:"XVectorOutput",local:"transformers.modeling_outputs.XVectorOutput",headingTag:"h2"}}),co=new T({props:{name:"class transformers.modeling_outputs.XVectorOutput",anchor:"transformers.modeling_outputs.XVectorOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"embeddings",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.XVectorOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.XVectorOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.xvector_output_dim)</code>) &#x2014;
Classification hidden states before AMSoftmax.`,name:"logits"},{anchor:"transformers.modeling_outputs.XVectorOutput.embeddings",description:`<strong>embeddings</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.xvector_output_dim)</code>) &#x2014;
Utterance embeddings used for vector similarity-based retrieval.`,name:"embeddings"},{anchor:"transformers.modeling_outputs.XVectorOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.XVectorOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L1405"}}),lo=new b({props:{title:"Seq2SeqTSModelOutput",local:"transformers.modeling_outputs.Seq2SeqTSModelOutput",headingTag:"h2"}}),po=new T({props:{name:"class transformers.modeling_outputs.Seq2SeqTSModelOutput",anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"past_key_values",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"encoder_last_hidden_state",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"loc",val:": Optional = None"},{name:"scale",val:": Optional = None"},{name:"static_features",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the optional initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the optional initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.loc",description:`<strong>loc</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size,)</code> or <code>(batch_size, input_size)</code>, <em>optional</em>) &#x2014;
Shift values of each time series&#x2019; context window which is used to give the model inputs of the same
magnitude and then used to shift back to the original magnitude.`,name:"loc"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.scale",description:`<strong>scale</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size,)</code> or <code>(batch_size, input_size)</code>, <em>optional</em>) &#x2014;
Scaling values of each time series&#x2019; context window which is used to give the model inputs of the same
magnitude and then used to rescale back to the original magnitude.`,name:"scale"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.static_features",description:`<strong>static_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, feature size)</code>, <em>optional</em>) &#x2014;
Static features of each time series&#x2019; in a batch which are copied to the covariates at inference time.`,name:"static_features"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L1561"}}),ho=new b({props:{title:"Seq2SeqTSPredictionOutput",local:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput",headingTag:"h2"}}),mo=new T({props:{name:"class transformers.modeling_outputs.Seq2SeqTSPredictionOutput",anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"params",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"encoder_last_hidden_state",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"loc",val:": Optional = None"},{name:"scale",val:": Optional = None"},{name:"static_features",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when a <code>future_values</code> is provided) &#x2014;
Distributional loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.params",description:`<strong>params</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_samples, num_params)</code>) &#x2014;
Parameters of the chosen distribution.`,name:"params"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.loc",description:`<strong>loc</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size,)</code> or <code>(batch_size, input_size)</code>, <em>optional</em>) &#x2014;
Shift values of each time series&#x2019; context window which is used to give the model inputs of the same
magnitude and then used to shift back to the original magnitude.`,name:"loc"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.scale",description:`<strong>scale</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size,)</code> or <code>(batch_size, input_size)</code>, <em>optional</em>) &#x2014;
Scaling values of each time series&#x2019; context window which is used to give the model inputs of the same
magnitude and then used to rescale back to the original magnitude.`,name:"scale"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.static_features",description:`<strong>static_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, feature size)</code>, <em>optional</em>) &#x2014;
Static features of each time series&#x2019; in a batch which are copied to the covariates at inference time.`,name:"static_features"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L1633"}}),fo=new b({props:{title:"SampleTSPredictionOutput",local:"transformers.modeling_outputs.SampleTSPredictionOutput",headingTag:"h2"}}),_o=new T({props:{name:"class transformers.modeling_outputs.SampleTSPredictionOutput",anchor:"transformers.modeling_outputs.SampleTSPredictionOutput",parameters:[{name:"sequences",val:": FloatTensor = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.SampleTSPredictionOutput.sequences",description:`<strong>sequences</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_samples, prediction_length)</code> or <code>(batch_size, num_samples, prediction_length, input_size)</code>) &#x2014;
Sampled values from the chosen distribution.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L1705"}}),go=new b({props:{title:"TFBaseModelOutput",local:"transformers.modeling_tf_outputs.TFBaseModelOutput",headingTag:"h2"}}),To=new T({props:{name:"class transformers.modeling_tf_outputs.TFBaseModelOutput",anchor:"transformers.modeling_tf_outputs.TFBaseModelOutput",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L26"}}),bo=new b({props:{title:"TFBaseModelOutputWithPooling",local:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling",headingTag:"h2"}}),vo=new T({props:{name:"class transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling",anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"pooler_output",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.</p>
<p>This output is usually <em>not</em> a good summary of the semantic content of the input, you&#x2019;re often better with
averaging or pooling the sequence of hidden-states for the whole input sequence.`,name:"pooler_output"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L71"}}),xo=new b({props:{title:"TFBaseModelOutputWithPoolingAndCrossAttentions",local:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions",headingTag:"h2"}}),$o=new T({props:{name:"class transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions",anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"pooler_output",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.pooler_output",description:`<strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.</p>
<p>This output is usually <em>not</em> a good summary of the semantic content of the input, you&#x2019;re often better with
averaging or pooling the sequence of hidden-states for the whole input sequence.`,name:"pooler_output"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L127"}}),qo=new b({props:{title:"TFBaseModelOutputWithPast",local:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast",headingTag:"h2"}}),wo=new T({props:{name:"class transformers.modeling_tf_outputs.TFBaseModelOutputWithPast",anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L175"}}),yo=new b({props:{title:"TFBaseModelOutputWithPastAndCrossAttentions",local:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions",headingTag:"h2"}}),Oo=new T({props:{name:"class transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions",anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L244"}}),So=new b({props:{title:"TFSeq2SeqModelOutput",local:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput",headingTag:"h2"}}),Fo=new T({props:{name:"class transformers.modeling_tf_outputs.TFSeq2SeqModelOutput",anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"decoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"decoder_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_last_hidden_state",val:": tf.Tensor | None = None"},{name:"encoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) of the decoder that can be
used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L287"}}),Mo=new b({props:{title:"TFCausalLMOutput",local:"transformers.modeling_tf_outputs.TFCausalLMOutput",headingTag:"h2"}}),Co=new T({props:{name:"class transformers.modeling_tf_outputs.TFCausalLMOutput",anchor:"transformers.modeling_tf_outputs.TFCausalLMOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L347"}}),zo=new b({props:{title:"TFCausalLMOutputWithCrossAttentions",local:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions",headingTag:"h2"}}),No=new T({props:{name:"class transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions",anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L412"}}),ko=new b({props:{title:"TFCausalLMOutputWithPast",local:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast",headingTag:"h2"}}),Ao=new T({props:{name:"class transformers.modeling_tf_outputs.TFCausalLMOutputWithPast",anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L376"}}),Po=new b({props:{title:"TFMaskedLMOutput",local:"transformers.modeling_tf_outputs.TFMaskedLMOutput",headingTag:"h2"}}),Lo=new T({props:{name:"class transformers.modeling_tf_outputs.TFMaskedLMOutput",anchor:"transformers.modeling_tf_outputs.TFMaskedLMOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFMaskedLMOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) &#x2014;
Masked language modeling (MLM) loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFMaskedLMOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFMaskedLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFMaskedLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L455"}}),Bo=new b({props:{title:"TFSeq2SeqLMOutput",local:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput",headingTag:"h2"}}),Wo=new T({props:{name:"class transformers.modeling_tf_outputs.TFSeq2SeqLMOutput",anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"decoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"decoder_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_last_hidden_state",val:": tf.Tensor | None = None"},{name:"encoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) of the decoder that can be
used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L484"}}),jo=new b({props:{title:"TFNextSentencePredictorOutput",local:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput",headingTag:"h2"}}),Do=new T({props:{name:"class transformers.modeling_tf_outputs.TFNextSentencePredictorOutput",anchor:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>next_sentence_label</code> is provided) &#x2014;
Next sentence prediction loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, 2)</code>) &#x2014;
Prediction scores of the next sequence prediction (classification) head (scores of True/False continuation
before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L543"}}),Vo=new b({props:{title:"TFSequenceClassifierOutput",local:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput",headingTag:"h2"}}),Io=new T({props:{name:"class transformers.modeling_tf_outputs.TFSequenceClassifierOutput",anchor:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L573"}}),Ho=new b({props:{title:"TFSeq2SeqSequenceClassifierOutput",local:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput",headingTag:"h2"}}),Eo=new T({props:{name:"class transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput",anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"decoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"decoder_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_last_hidden_state",val:": tf.Tensor | None = None"},{name:"encoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>label</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) of the decoder that can be
used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>`,name:"cross_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L602"}}),Qo=new b({props:{title:"TFMultipleChoiceModelOutput",local:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput",headingTag:"h2"}}),Ro=new T({props:{name:"class transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput",anchor:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <em>(batch_size, )</em>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_choices)</code>) &#x2014;
<em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L753"}}),Uo=new b({props:{title:"TFTokenClassifierOutput",local:"transformers.modeling_tf_outputs.TFTokenClassifierOutput",headingTag:"h2"}}),Xo=new T({props:{name:"class transformers.modeling_tf_outputs.TFTokenClassifierOutput",anchor:"transformers.modeling_tf_outputs.TFTokenClassifierOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFTokenClassifierOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of unmasked labels, returned when <code>labels</code> is provided)  &#x2014;
Classification loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFTokenClassifierOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) &#x2014;
Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFTokenClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFTokenClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L784"}}),Jo=new b({props:{title:"TFQuestionAnsweringModelOutput",local:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput",headingTag:"h2"}}),Zo=new T({props:{name:"class transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput",anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"start_logits",val:": tf.Tensor = None"},{name:"end_logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>, returned when <code>start_positions</code> and <code>end_positions</code> are provided) &#x2014;
Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L813"}}),Go=new b({props:{title:"TFSeq2SeqQuestionAnsweringModelOutput",local:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput",headingTag:"h2"}}),Yo=new T({props:{name:"class transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput",anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"start_logits",val:": tf.Tensor = None"},{name:"end_logits",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"decoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"decoder_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_last_hidden_state",val:": tf.Tensor | None = None"},{name:"encoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) of the decoder that can be
used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_tf_outputs.py#L845"}}),Ko=new b({props:{title:"FlaxBaseModelOutput",local:"transformers.modeling_flax_outputs.FlaxBaseModelOutput",headingTag:"h2"}}),en=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxBaseModelOutput",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutput",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_flax_outputs.py#L22"}}),tn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),on=new b({props:{title:"FlaxBaseModelOutputWithPast",local:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast",headingTag:"h2"}}),nn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"past_key_values",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast.past_key_values",description:`<strong>past_key_values</strong> (<code>Dict[str, jnp.ndarray]</code>) &#x2014;
Dictionary of pre-computed hidden-states (key and values in the attention blocks) that can be used for fast
auto-regressive decoding. Pre-computed key and value hidden-states are of shape <em>[batch_size, max_length]</em>.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_flax_outputs.py#L106"}}),sn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),an=new b({props:{title:"FlaxBaseModelOutputWithPooling",local:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling",headingTag:"h2"}}),rn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"pooler_output",val:": Array = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.`,name:"pooler_output"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_flax_outputs.py#L136"}}),dn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),un=new b({props:{title:"FlaxBaseModelOutputWithPastAndCrossAttentions",local:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions",headingTag:"h2"}}),cn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"past_key_values",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_flax_outputs.py#L216"}}),ln=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),pn=new b({props:{title:"FlaxSeq2SeqModelOutput",local:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput",headingTag:"h2"}}),hn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"past_key_values",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"encoder_last_hidden_state",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_flax_outputs.py#L262"}}),mn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),fn=new b({props:{title:"FlaxCausalLMOutputWithCrossAttentions",local:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions",headingTag:"h2"}}),_n=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions",anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions",parameters:[{name:"logits",val:": Array = None"},{name:"past_key_values",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key, value
states of the self-attention and the cross-attention layers if model is used in encoder-decoder setting.
Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_flax_outputs.py#L323"}}),gn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),Tn=new b({props:{title:"FlaxMaskedLMOutput",local:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput",headingTag:"h2"}}),bn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxMaskedLMOutput",anchor:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput",parameters:[{name:"logits",val:": Array = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_flax_outputs.py#L364"}}),vn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),xn=new b({props:{title:"FlaxSeq2SeqLMOutput",local:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput",headingTag:"h2"}}),$n=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput",parameters:[{name:"logits",val:": Array = None"},{name:"past_key_values",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"encoder_last_hidden_state",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_flax_outputs.py#L393"}}),qn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),wn=new b({props:{title:"FlaxNextSentencePredictorOutput",local:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput",headingTag:"h2"}}),yn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput",anchor:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput",parameters:[{name:"logits",val:": Array = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, 2)</code>) &#x2014;
Prediction scores of the next sequence prediction (classification) head (scores of True/False continuation
before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_flax_outputs.py#L450"}}),On=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),Sn=new b({props:{title:"FlaxSequenceClassifierOutput",local:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput",headingTag:"h2"}}),Fn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput",anchor:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput",parameters:[{name:"logits",val:": Array = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_flax_outputs.py#L477"}}),Mn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),Cn=new b({props:{title:"FlaxSeq2SeqSequenceClassifierOutput",local:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput",headingTag:"h2"}}),zn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput",parameters:[{name:"logits",val:": Array = None"},{name:"past_key_values",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"encoder_last_hidden_state",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_flax_outputs.py#L503"}}),Nn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),kn=new b({props:{title:"FlaxMultipleChoiceModelOutput",local:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput",headingTag:"h2"}}),An=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput",anchor:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput",parameters:[{name:"logits",val:": Array = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, num_choices)</code>) &#x2014;
<em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_flax_outputs.py#L560"}}),Pn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),Ln=new b({props:{title:"FlaxTokenClassifierOutput",local:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput",headingTag:"h2"}}),Bn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxTokenClassifierOutput",anchor:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput",parameters:[{name:"logits",val:": Array = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) &#x2014;
Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_flax_outputs.py#L588"}}),Wn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),jn=new b({props:{title:"FlaxQuestionAnsweringModelOutput",local:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput",headingTag:"h2"}}),Dn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput",anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput",parameters:[{name:"start_logits",val:": Array = None"},{name:"end_logits",val:": Array = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_flax_outputs.py#L614"}}),Vn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),In=new b({props:{title:"FlaxSeq2SeqQuestionAnsweringModelOutput",local:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput",headingTag:"h2"}}),Hn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput",parameters:[{name:"start_logits",val:": Array = None"},{name:"end_logits",val:": Array = None"},{name:"past_key_values",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"encoder_last_hidden_state",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_flax_outputs.py#L643"}}),En=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),{c(){v=d("meta"),j=n(),x=d("p"),ke=n(),u(Ye.$$.fragment),Aa=n(),Ke=d("p"),Ke.innerHTML=dl,Pa=n(),et=d("p"),et.textContent=il,La=n(),u(tt.$$.fragment),Ba=n(),ot=d("p"),ot.innerHTML=ul,Wa=n(),u(Ae.$$.fragment),ja=n(),nt=d("p"),nt.innerHTML=cl,Da=n(),st=d("p"),st.innerHTML=ll,Va=n(),u(at.$$.fragment),Ia=n(),rt=d("p"),rt.innerHTML=pl,Ha=n(),dt=d("p"),dt.innerHTML=hl,Ea=n(),it=d("p"),it.textContent=ml,Qa=n(),u(ut.$$.fragment),Ra=n(),$=d("div"),u(ct.$$.fragment),bu=n(),Un=d("p"),Un.innerHTML=fl,vu=n(),u(Pe.$$.fragment),xu=n(),Le=d("div"),u(lt.$$.fragment),$u=n(),Xn=d("p"),Xn.innerHTML=_l,Ua=n(),u(pt.$$.fragment),Xa=n(),D=d("div"),u(ht.$$.fragment),qu=n(),Jn=d("p"),Jn.textContent=gl,Ja=n(),u(mt.$$.fragment),Za=n(),V=d("div"),u(ft.$$.fragment),wu=n(),Zn=d("p"),Zn.textContent=Tl,Ga=n(),u(_t.$$.fragment),Ya=n(),I=d("div"),u(gt.$$.fragment),yu=n(),Gn=d("p"),Gn.textContent=bl,Ka=n(),u(Tt.$$.fragment),er=n(),H=d("div"),u(bt.$$.fragment),Ou=n(),Yn=d("p"),Yn.textContent=vl,tr=n(),u(vt.$$.fragment),or=n(),E=d("div"),u(xt.$$.fragment),Su=n(),Kn=d("p"),Kn.textContent=xl,nr=n(),u($t.$$.fragment),sr=n(),Q=d("div"),u(qt.$$.fragment),Fu=n(),es=d("p"),es.textContent=$l,ar=n(),u(wt.$$.fragment),rr=n(),R=d("div"),u(yt.$$.fragment),Mu=n(),ts=d("p"),ts.textContent=ql,dr=n(),u(Ot.$$.fragment),ir=n(),U=d("div"),u(St.$$.fragment),Cu=n(),os=d("p"),os.textContent=wl,ur=n(),u(Ft.$$.fragment),cr=n(),X=d("div"),u(Mt.$$.fragment),zu=n(),ns=d("p"),ns.textContent=yl,lr=n(),u(Ct.$$.fragment),pr=n(),J=d("div"),u(zt.$$.fragment),Nu=n(),ss=d("p"),ss.textContent=Ol,hr=n(),u(Nt.$$.fragment),mr=n(),Z=d("div"),u(kt.$$.fragment),ku=n(),as=d("p"),as.textContent=Sl,fr=n(),u(At.$$.fragment),_r=n(),G=d("div"),u(Pt.$$.fragment),Au=n(),rs=d("p"),rs.textContent=Fl,gr=n(),u(Lt.$$.fragment),Tr=n(),Y=d("div"),u(Bt.$$.fragment),Pu=n(),ds=d("p"),ds.textContent=Ml,br=n(),u(Wt.$$.fragment),vr=n(),K=d("div"),u(jt.$$.fragment),Lu=n(),is=d("p"),is.textContent=Cl,xr=n(),u(Dt.$$.fragment),$r=n(),ee=d("div"),u(Vt.$$.fragment),Bu=n(),us=d("p"),us.textContent=zl,qr=n(),u(It.$$.fragment),wr=n(),te=d("div"),u(Ht.$$.fragment),Wu=n(),cs=d("p"),cs.textContent=Nl,yr=n(),u(Et.$$.fragment),Or=n(),oe=d("div"),u(Qt.$$.fragment),ju=n(),ls=d("p"),ls.textContent=kl,Sr=n(),u(Rt.$$.fragment),Fr=n(),ne=d("div"),u(Ut.$$.fragment),Du=n(),ps=d("p"),ps.textContent=Al,Mr=n(),u(Xt.$$.fragment),Cr=n(),se=d("div"),u(Jt.$$.fragment),Vu=n(),hs=d("p"),hs.textContent=Pl,zr=n(),u(Zt.$$.fragment),Nr=n(),ae=d("div"),u(Gt.$$.fragment),Iu=n(),ms=d("p"),ms.textContent=Ll,kr=n(),u(Yt.$$.fragment),Ar=n(),re=d("div"),u(Kt.$$.fragment),Hu=n(),fs=d("p"),fs.textContent=Bl,Pr=n(),u(eo.$$.fragment),Lr=n(),de=d("div"),u(to.$$.fragment),Eu=n(),_s=d("p"),_s.textContent=Wl,Br=n(),u(oo.$$.fragment),Wr=n(),ie=d("div"),u(no.$$.fragment),Qu=n(),gs=d("p"),gs.textContent=jl,jr=n(),u(so.$$.fragment),Dr=n(),ue=d("div"),u(ao.$$.fragment),Ru=n(),Ts=d("p"),Ts.textContent=Dl,Vr=n(),u(ro.$$.fragment),Ir=n(),ce=d("div"),u(io.$$.fragment),Uu=n(),bs=d("p"),bs.textContent=Vl,Hr=n(),u(uo.$$.fragment),Er=n(),le=d("div"),u(co.$$.fragment),Xu=n(),vs=d("p"),vs.innerHTML=Il,Qr=n(),u(lo.$$.fragment),Rr=n(),pe=d("div"),u(po.$$.fragment),Ju=n(),xs=d("p"),xs.textContent=Hl,Ur=n(),u(ho.$$.fragment),Xr=n(),he=d("div"),u(mo.$$.fragment),Zu=n(),$s=d("p"),$s.textContent=El,Jr=n(),u(fo.$$.fragment),Zr=n(),me=d("div"),u(_o.$$.fragment),Gu=n(),qs=d("p"),qs.textContent=Ql,Gr=n(),u(go.$$.fragment),Yr=n(),fe=d("div"),u(To.$$.fragment),Yu=n(),ws=d("p"),ws.textContent=Rl,Kr=n(),u(bo.$$.fragment),ed=n(),_e=d("div"),u(vo.$$.fragment),Ku=n(),ys=d("p"),ys.textContent=Ul,td=n(),u(xo.$$.fragment),od=n(),ge=d("div"),u($o.$$.fragment),ec=n(),Os=d("p"),Os.textContent=Xl,nd=n(),u(qo.$$.fragment),sd=n(),Te=d("div"),u(wo.$$.fragment),tc=n(),Ss=d("p"),Ss.textContent=Jl,ad=n(),u(yo.$$.fragment),rd=n(),be=d("div"),u(Oo.$$.fragment),oc=n(),Fs=d("p"),Fs.textContent=Zl,dd=n(),u(So.$$.fragment),id=n(),ve=d("div"),u(Fo.$$.fragment),nc=n(),Ms=d("p"),Ms.textContent=Gl,ud=n(),u(Mo.$$.fragment),cd=n(),xe=d("div"),u(Co.$$.fragment),sc=n(),Cs=d("p"),Cs.textContent=Yl,ld=n(),u(zo.$$.fragment),pd=n(),$e=d("div"),u(No.$$.fragment),ac=n(),zs=d("p"),zs.textContent=Kl,hd=n(),u(ko.$$.fragment),md=n(),qe=d("div"),u(Ao.$$.fragment),rc=n(),Ns=d("p"),Ns.textContent=ep,fd=n(),u(Po.$$.fragment),_d=n(),we=d("div"),u(Lo.$$.fragment),dc=n(),ks=d("p"),ks.textContent=tp,gd=n(),u(Bo.$$.fragment),Td=n(),ye=d("div"),u(Wo.$$.fragment),ic=n(),As=d("p"),As.textContent=op,bd=n(),u(jo.$$.fragment),vd=n(),Oe=d("div"),u(Do.$$.fragment),uc=n(),Ps=d("p"),Ps.textContent=np,xd=n(),u(Vo.$$.fragment),$d=n(),Se=d("div"),u(Io.$$.fragment),cc=n(),Ls=d("p"),Ls.textContent=sp,qd=n(),u(Ho.$$.fragment),wd=n(),Fe=d("div"),u(Eo.$$.fragment),lc=n(),Bs=d("p"),Bs.textContent=ap,yd=n(),u(Qo.$$.fragment),Od=n(),Me=d("div"),u(Ro.$$.fragment),pc=n(),Ws=d("p"),Ws.textContent=rp,Sd=n(),u(Uo.$$.fragment),Fd=n(),Ce=d("div"),u(Xo.$$.fragment),hc=n(),js=d("p"),js.textContent=dp,Md=n(),u(Jo.$$.fragment),Cd=n(),ze=d("div"),u(Zo.$$.fragment),mc=n(),Ds=d("p"),Ds.textContent=ip,zd=n(),u(Go.$$.fragment),Nd=n(),Ne=d("div"),u(Yo.$$.fragment),fc=n(),Vs=d("p"),Vs.textContent=up,kd=n(),u(Ko.$$.fragment),Ad=n(),q=d("div"),u(en.$$.fragment),_c=n(),Is=d("p"),Is.textContent=cp,gc=n(),Be=d("div"),u(tn.$$.fragment),Tc=n(),Hs=d("p"),Hs.textContent=lp,Pd=n(),u(on.$$.fragment),Ld=n(),w=d("div"),u(nn.$$.fragment),bc=n(),Es=d("p"),Es.textContent=pp,vc=n(),We=d("div"),u(sn.$$.fragment),xc=n(),Qs=d("p"),Qs.textContent=hp,Bd=n(),u(an.$$.fragment),Wd=n(),y=d("div"),u(rn.$$.fragment),$c=n(),Rs=d("p"),Rs.textContent=mp,qc=n(),je=d("div"),u(dn.$$.fragment),wc=n(),Us=d("p"),Us.textContent=fp,jd=n(),u(un.$$.fragment),Dd=n(),O=d("div"),u(cn.$$.fragment),yc=n(),Xs=d("p"),Xs.textContent=_p,Oc=n(),De=d("div"),u(ln.$$.fragment),Sc=n(),Js=d("p"),Js.textContent=gp,Vd=n(),u(pn.$$.fragment),Id=n(),S=d("div"),u(hn.$$.fragment),Fc=n(),Zs=d("p"),Zs.textContent=Tp,Mc=n(),Ve=d("div"),u(mn.$$.fragment),Cc=n(),Gs=d("p"),Gs.textContent=bp,Hd=n(),u(fn.$$.fragment),Ed=n(),F=d("div"),u(_n.$$.fragment),zc=n(),Ys=d("p"),Ys.textContent=vp,Nc=n(),Ie=d("div"),u(gn.$$.fragment),kc=n(),Ks=d("p"),Ks.textContent=xp,Qd=n(),u(Tn.$$.fragment),Rd=n(),M=d("div"),u(bn.$$.fragment),Ac=n(),ea=d("p"),ea.textContent=$p,Pc=n(),He=d("div"),u(vn.$$.fragment),Lc=n(),ta=d("p"),ta.textContent=qp,Ud=n(),u(xn.$$.fragment),Xd=n(),C=d("div"),u($n.$$.fragment),Bc=n(),oa=d("p"),oa.textContent=wp,Wc=n(),Ee=d("div"),u(qn.$$.fragment),jc=n(),na=d("p"),na.textContent=yp,Jd=n(),u(wn.$$.fragment),Zd=n(),z=d("div"),u(yn.$$.fragment),Dc=n(),sa=d("p"),sa.textContent=Op,Vc=n(),Qe=d("div"),u(On.$$.fragment),Ic=n(),aa=d("p"),aa.textContent=Sp,Gd=n(),u(Sn.$$.fragment),Yd=n(),N=d("div"),u(Fn.$$.fragment),Hc=n(),ra=d("p"),ra.textContent=Fp,Ec=n(),Re=d("div"),u(Mn.$$.fragment),Qc=n(),da=d("p"),da.textContent=Mp,Kd=n(),u(Cn.$$.fragment),ei=n(),k=d("div"),u(zn.$$.fragment),Rc=n(),ia=d("p"),ia.textContent=Cp,Uc=n(),Ue=d("div"),u(Nn.$$.fragment),Xc=n(),ua=d("p"),ua.textContent=zp,ti=n(),u(kn.$$.fragment),oi=n(),A=d("div"),u(An.$$.fragment),Jc=n(),ca=d("p"),ca.textContent=Np,Zc=n(),Xe=d("div"),u(Pn.$$.fragment),Gc=n(),la=d("p"),la.textContent=kp,ni=n(),u(Ln.$$.fragment),si=n(),P=d("div"),u(Bn.$$.fragment),Yc=n(),pa=d("p"),pa.textContent=Ap,Kc=n(),Je=d("div"),u(Wn.$$.fragment),el=n(),ha=d("p"),ha.textContent=Pp,ai=n(),u(jn.$$.fragment),ri=n(),L=d("div"),u(Dn.$$.fragment),tl=n(),ma=d("p"),ma.textContent=Lp,ol=n(),Ze=d("div"),u(Vn.$$.fragment),nl=n(),fa=d("p"),fa.textContent=Bp,di=n(),u(In.$$.fragment),ii=n(),B=d("div"),u(Hn.$$.fragment),sl=n(),_a=d("p"),_a.textContent=Wp,al=n(),Ge=d("div"),u(En.$$.fragment),rl=n(),ga=d("p"),ga.textContent=jp,ui=n(),ka=d("p"),this.h()},l(e){const o=Up("svelte-u9bgzb",document.head);v=i(o,"META",{name:!0,content:!0}),o.forEach(t),j=s(e),x=i(e,"P",{}),_(x).forEach(t),ke=s(e),c(Ye.$$.fragment,e),Aa=s(e),Ke=i(e,"P",{"data-svelte-h":!0}),f(Ke)!=="svelte-mz14yt"&&(Ke.innerHTML=dl),Pa=s(e),et=i(e,"P",{"data-svelte-h":!0}),f(et)!=="svelte-zk7t5e"&&(et.textContent=il),La=s(e),c(tt.$$.fragment,e),Ba=s(e),ot=i(e,"P",{"data-svelte-h":!0}),f(ot)!=="svelte-1q1tk26"&&(ot.innerHTML=ul),Wa=s(e),c(Ae.$$.fragment,e),ja=s(e),nt=i(e,"P",{"data-svelte-h":!0}),f(nt)!=="svelte-ww282k"&&(nt.innerHTML=cl),Da=s(e),st=i(e,"P",{"data-svelte-h":!0}),f(st)!=="svelte-qrkykg"&&(st.innerHTML=ll),Va=s(e),c(at.$$.fragment,e),Ia=s(e),rt=i(e,"P",{"data-svelte-h":!0}),f(rt)!=="svelte-sv5ldg"&&(rt.innerHTML=pl),Ha=s(e),dt=i(e,"P",{"data-svelte-h":!0}),f(dt)!=="svelte-1tp97x6"&&(dt.innerHTML=hl),Ea=s(e),it=i(e,"P",{"data-svelte-h":!0}),f(it)!=="svelte-1b6en9a"&&(it.textContent=ml),Qa=s(e),c(ut.$$.fragment,e),Ra=s(e),$=i(e,"DIV",{class:!0});var W=_($);c(ct.$$.fragment,W),bu=s(W),Un=i(W,"P",{"data-svelte-h":!0}),f(Un)!=="svelte-1q6gwat"&&(Un.innerHTML=fl),vu=s(W),c(Pe.$$.fragment,W),xu=s(W),Le=i(W,"DIV",{class:!0});var Qn=_(Le);c(lt.$$.fragment,Qn),$u=s(Qn),Xn=i(Qn,"P",{"data-svelte-h":!0}),f(Xn)!=="svelte-1gdpts"&&(Xn.innerHTML=_l),Qn.forEach(t),W.forEach(t),Ua=s(e),c(pt.$$.fragment,e),Xa=s(e),D=i(e,"DIV",{class:!0});var li=_(D);c(ht.$$.fragment,li),qu=s(li),Jn=i(li,"P",{"data-svelte-h":!0}),f(Jn)!=="svelte-19jpj19"&&(Jn.textContent=gl),li.forEach(t),Ja=s(e),c(mt.$$.fragment,e),Za=s(e),V=i(e,"DIV",{class:!0});var pi=_(V);c(ft.$$.fragment,pi),wu=s(pi),Zn=i(pi,"P",{"data-svelte-h":!0}),f(Zn)!=="svelte-rzpgnp"&&(Zn.textContent=Tl),pi.forEach(t),Ga=s(e),c(_t.$$.fragment,e),Ya=s(e),I=i(e,"DIV",{class:!0});var hi=_(I);c(gt.$$.fragment,hi),yu=s(hi),Gn=i(hi,"P",{"data-svelte-h":!0}),f(Gn)!=="svelte-19jpj19"&&(Gn.textContent=bl),hi.forEach(t),Ka=s(e),c(Tt.$$.fragment,e),er=s(e),H=i(e,"DIV",{class:!0});var mi=_(H);c(bt.$$.fragment,mi),Ou=s(mi),Yn=i(mi,"P",{"data-svelte-h":!0}),f(Yn)!=="svelte-rzpgnp"&&(Yn.textContent=vl),mi.forEach(t),tr=s(e),c(vt.$$.fragment,e),or=s(e),E=i(e,"DIV",{class:!0});var fi=_(E);c(xt.$$.fragment,fi),Su=s(fi),Kn=i(fi,"P",{"data-svelte-h":!0}),f(Kn)!=="svelte-1kt4x95"&&(Kn.textContent=xl),fi.forEach(t),nr=s(e),c($t.$$.fragment,e),sr=s(e),Q=i(e,"DIV",{class:!0});var _i=_(Q);c(qt.$$.fragment,_i),Fu=s(_i),es=i(_i,"P",{"data-svelte-h":!0}),f(es)!=="svelte-1kt4x95"&&(es.textContent=$l),_i.forEach(t),ar=s(e),c(wt.$$.fragment,e),rr=s(e),R=i(e,"DIV",{class:!0});var gi=_(R);c(yt.$$.fragment,gi),Mu=s(gi),ts=i(gi,"P",{"data-svelte-h":!0}),f(ts)!=="svelte-k12cko"&&(ts.textContent=ql),gi.forEach(t),dr=s(e),c(Ot.$$.fragment,e),ir=s(e),U=i(e,"DIV",{class:!0});var Ti=_(U);c(St.$$.fragment,Ti),Cu=s(Ti),os=i(Ti,"P",{"data-svelte-h":!0}),f(os)!=="svelte-3npkmq"&&(os.textContent=wl),Ti.forEach(t),ur=s(e),c(Ft.$$.fragment,e),cr=s(e),X=i(e,"DIV",{class:!0});var bi=_(X);c(Mt.$$.fragment,bi),zu=s(bi),ns=i(bi,"P",{"data-svelte-h":!0}),f(ns)!=="svelte-3npkmq"&&(ns.textContent=yl),bi.forEach(t),lr=s(e),c(Ct.$$.fragment,e),pr=s(e),J=i(e,"DIV",{class:!0});var vi=_(J);c(zt.$$.fragment,vi),Nu=s(vi),ss=i(vi,"P",{"data-svelte-h":!0}),f(ss)!=="svelte-3npkmq"&&(ss.textContent=Ol),vi.forEach(t),hr=s(e),c(Nt.$$.fragment,e),mr=s(e),Z=i(e,"DIV",{class:!0});var xi=_(Z);c(kt.$$.fragment,xi),ku=s(xi),as=i(xi,"P",{"data-svelte-h":!0}),f(as)!=="svelte-1xezu93"&&(as.textContent=Sl),xi.forEach(t),fr=s(e),c(At.$$.fragment,e),_r=s(e),G=i(e,"DIV",{class:!0});var $i=_(G);c(Pt.$$.fragment,$i),Au=s($i),rs=i($i,"P",{"data-svelte-h":!0}),f(rs)!=="svelte-1dobm33"&&(rs.textContent=Fl),$i.forEach(t),gr=s(e),c(Lt.$$.fragment,e),Tr=s(e),Y=i(e,"DIV",{class:!0});var qi=_(Y);c(Bt.$$.fragment,qi),Pu=s(qi),ds=i(qi,"P",{"data-svelte-h":!0}),f(ds)!=="svelte-1bm2i0r"&&(ds.textContent=Ml),qi.forEach(t),br=s(e),c(Wt.$$.fragment,e),vr=s(e),K=i(e,"DIV",{class:!0});var wi=_(K);c(jt.$$.fragment,wi),Lu=s(wi),is=i(wi,"P",{"data-svelte-h":!0}),f(is)!=="svelte-o4u80u"&&(is.textContent=Cl),wi.forEach(t),xr=s(e),c(Dt.$$.fragment,e),$r=s(e),ee=i(e,"DIV",{class:!0});var yi=_(ee);c(Vt.$$.fragment,yi),Bu=s(yi),us=i(yi,"P",{"data-svelte-h":!0}),f(us)!=="svelte-1kfw2sn"&&(us.textContent=zl),yi.forEach(t),qr=s(e),c(It.$$.fragment,e),wr=s(e),te=i(e,"DIV",{class:!0});var Oi=_(te);c(Ht.$$.fragment,Oi),Wu=s(Oi),cs=i(Oi,"P",{"data-svelte-h":!0}),f(cs)!=="svelte-yql1ve"&&(cs.textContent=Nl),Oi.forEach(t),yr=s(e),c(Et.$$.fragment,e),Or=s(e),oe=i(e,"DIV",{class:!0});var Si=_(oe);c(Qt.$$.fragment,Si),ju=s(Si),ls=i(Si,"P",{"data-svelte-h":!0}),f(ls)!=="svelte-1iv9pso"&&(ls.textContent=kl),Si.forEach(t),Sr=s(e),c(Rt.$$.fragment,e),Fr=s(e),ne=i(e,"DIV",{class:!0});var Fi=_(ne);c(Ut.$$.fragment,Fi),Du=s(Fi),ps=i(Fi,"P",{"data-svelte-h":!0}),f(ps)!=="svelte-w7415f"&&(ps.textContent=Al),Fi.forEach(t),Mr=s(e),c(Xt.$$.fragment,e),Cr=s(e),se=i(e,"DIV",{class:!0});var Mi=_(se);c(Jt.$$.fragment,Mi),Vu=s(Mi),hs=i(Mi,"P",{"data-svelte-h":!0}),f(hs)!=="svelte-dhzux4"&&(hs.textContent=Pl),Mi.forEach(t),zr=s(e),c(Zt.$$.fragment,e),Nr=s(e),ae=i(e,"DIV",{class:!0});var Ci=_(ae);c(Gt.$$.fragment,Ci),Iu=s(Ci),ms=i(Ci,"P",{"data-svelte-h":!0}),f(ms)!=="svelte-8u8l5m"&&(ms.textContent=Ll),Ci.forEach(t),kr=s(e),c(Yt.$$.fragment,e),Ar=s(e),re=i(e,"DIV",{class:!0});var zi=_(re);c(Kt.$$.fragment,zi),Hu=s(zi),fs=i(zi,"P",{"data-svelte-h":!0}),f(fs)!=="svelte-kob7ff"&&(fs.textContent=Bl),zi.forEach(t),Pr=s(e),c(eo.$$.fragment,e),Lr=s(e),de=i(e,"DIV",{class:!0});var Ni=_(de);c(to.$$.fragment,Ni),Eu=s(Ni),_s=i(Ni,"P",{"data-svelte-h":!0}),f(_s)!=="svelte-sv2ymo"&&(_s.textContent=Wl),Ni.forEach(t),Br=s(e),c(oo.$$.fragment,e),Wr=s(e),ie=i(e,"DIV",{class:!0});var ki=_(ie);c(no.$$.fragment,ki),Qu=s(ki),gs=i(ki,"P",{"data-svelte-h":!0}),f(gs)!=="svelte-sv2ymo"&&(gs.textContent=jl),ki.forEach(t),jr=s(e),c(so.$$.fragment,e),Dr=s(e),ue=i(e,"DIV",{class:!0});var Ai=_(ue);c(ao.$$.fragment,Ai),Ru=s(Ai),Ts=i(Ai,"P",{"data-svelte-h":!0}),f(Ts)!=="svelte-1rjgll"&&(Ts.textContent=Dl),Ai.forEach(t),Vr=s(e),c(ro.$$.fragment,e),Ir=s(e),ce=i(e,"DIV",{class:!0});var Pi=_(ce);c(io.$$.fragment,Pi),Uu=s(Pi),bs=i(Pi,"P",{"data-svelte-h":!0}),f(bs)!=="svelte-1tmia4b"&&(bs.textContent=Vl),Pi.forEach(t),Hr=s(e),c(uo.$$.fragment,e),Er=s(e),le=i(e,"DIV",{class:!0});var Li=_(le);c(co.$$.fragment,Li),Xu=s(Li),vs=i(Li,"P",{"data-svelte-h":!0}),f(vs)!=="svelte-157p217"&&(vs.innerHTML=Il),Li.forEach(t),Qr=s(e),c(lo.$$.fragment,e),Rr=s(e),pe=i(e,"DIV",{class:!0});var Bi=_(pe);c(po.$$.fragment,Bi),Ju=s(Bi),xs=i(Bi,"P",{"data-svelte-h":!0}),f(xs)!=="svelte-dz9ong"&&(xs.textContent=Hl),Bi.forEach(t),Ur=s(e),c(ho.$$.fragment,e),Xr=s(e),he=i(e,"DIV",{class:!0});var Wi=_(he);c(mo.$$.fragment,Wi),Zu=s(Wi),$s=i(Wi,"P",{"data-svelte-h":!0}),f($s)!=="svelte-os2t7w"&&($s.textContent=El),Wi.forEach(t),Jr=s(e),c(fo.$$.fragment,e),Zr=s(e),me=i(e,"DIV",{class:!0});var ji=_(me);c(_o.$$.fragment,ji),Gu=s(ji),qs=i(ji,"P",{"data-svelte-h":!0}),f(qs)!=="svelte-1iolpnx"&&(qs.textContent=Ql),ji.forEach(t),Gr=s(e),c(go.$$.fragment,e),Yr=s(e),fe=i(e,"DIV",{class:!0});var Di=_(fe);c(To.$$.fragment,Di),Yu=s(Di),ws=i(Di,"P",{"data-svelte-h":!0}),f(ws)!=="svelte-19jpj19"&&(ws.textContent=Rl),Di.forEach(t),Kr=s(e),c(bo.$$.fragment,e),ed=s(e),_e=i(e,"DIV",{class:!0});var Vi=_(_e);c(vo.$$.fragment,Vi),Ku=s(Vi),ys=i(Vi,"P",{"data-svelte-h":!0}),f(ys)!=="svelte-rzpgnp"&&(ys.textContent=Ul),Vi.forEach(t),td=s(e),c(xo.$$.fragment,e),od=s(e),ge=i(e,"DIV",{class:!0});var Ii=_(ge);c($o.$$.fragment,Ii),ec=s(Ii),Os=i(Ii,"P",{"data-svelte-h":!0}),f(Os)!=="svelte-rzpgnp"&&(Os.textContent=Xl),Ii.forEach(t),nd=s(e),c(qo.$$.fragment,e),sd=s(e),Te=i(e,"DIV",{class:!0});var Hi=_(Te);c(wo.$$.fragment,Hi),tc=s(Hi),Ss=i(Hi,"P",{"data-svelte-h":!0}),f(Ss)!=="svelte-1kt4x95"&&(Ss.textContent=Jl),Hi.forEach(t),ad=s(e),c(yo.$$.fragment,e),rd=s(e),be=i(e,"DIV",{class:!0});var Ei=_(be);c(Oo.$$.fragment,Ei),oc=s(Ei),Fs=i(Ei,"P",{"data-svelte-h":!0}),f(Fs)!=="svelte-1kt4x95"&&(Fs.textContent=Zl),Ei.forEach(t),dd=s(e),c(So.$$.fragment,e),id=s(e),ve=i(e,"DIV",{class:!0});var Qi=_(ve);c(Fo.$$.fragment,Qi),nc=s(Qi),Ms=i(Qi,"P",{"data-svelte-h":!0}),f(Ms)!=="svelte-k12cko"&&(Ms.textContent=Gl),Qi.forEach(t),ud=s(e),c(Mo.$$.fragment,e),cd=s(e),xe=i(e,"DIV",{class:!0});var Ri=_(xe);c(Co.$$.fragment,Ri),sc=s(Ri),Cs=i(Ri,"P",{"data-svelte-h":!0}),f(Cs)!=="svelte-3npkmq"&&(Cs.textContent=Yl),Ri.forEach(t),ld=s(e),c(zo.$$.fragment,e),pd=s(e),$e=i(e,"DIV",{class:!0});var Ui=_($e);c(No.$$.fragment,Ui),ac=s(Ui),zs=i(Ui,"P",{"data-svelte-h":!0}),f(zs)!=="svelte-3npkmq"&&(zs.textContent=Kl),Ui.forEach(t),hd=s(e),c(ko.$$.fragment,e),md=s(e),qe=i(e,"DIV",{class:!0});var Xi=_(qe);c(Ao.$$.fragment,Xi),rc=s(Xi),Ns=i(Xi,"P",{"data-svelte-h":!0}),f(Ns)!=="svelte-3npkmq"&&(Ns.textContent=ep),Xi.forEach(t),fd=s(e),c(Po.$$.fragment,e),_d=s(e),we=i(e,"DIV",{class:!0});var Ji=_(we);c(Lo.$$.fragment,Ji),dc=s(Ji),ks=i(Ji,"P",{"data-svelte-h":!0}),f(ks)!=="svelte-1xezu93"&&(ks.textContent=tp),Ji.forEach(t),gd=s(e),c(Bo.$$.fragment,e),Td=s(e),ye=i(e,"DIV",{class:!0});var Zi=_(ye);c(Wo.$$.fragment,Zi),ic=s(Zi),As=i(Zi,"P",{"data-svelte-h":!0}),f(As)!=="svelte-1dobm33"&&(As.textContent=op),Zi.forEach(t),bd=s(e),c(jo.$$.fragment,e),vd=s(e),Oe=i(e,"DIV",{class:!0});var Gi=_(Oe);c(Do.$$.fragment,Gi),uc=s(Gi),Ps=i(Gi,"P",{"data-svelte-h":!0}),f(Ps)!=="svelte-1bm2i0r"&&(Ps.textContent=np),Gi.forEach(t),xd=s(e),c(Vo.$$.fragment,e),$d=s(e),Se=i(e,"DIV",{class:!0});var Yi=_(Se);c(Io.$$.fragment,Yi),cc=s(Yi),Ls=i(Yi,"P",{"data-svelte-h":!0}),f(Ls)!=="svelte-o4u80u"&&(Ls.textContent=sp),Yi.forEach(t),qd=s(e),c(Ho.$$.fragment,e),wd=s(e),Fe=i(e,"DIV",{class:!0});var Ki=_(Fe);c(Eo.$$.fragment,Ki),lc=s(Ki),Bs=i(Ki,"P",{"data-svelte-h":!0}),f(Bs)!=="svelte-1kfw2sn"&&(Bs.textContent=ap),Ki.forEach(t),yd=s(e),c(Qo.$$.fragment,e),Od=s(e),Me=i(e,"DIV",{class:!0});var eu=_(Me);c(Ro.$$.fragment,eu),pc=s(eu),Ws=i(eu,"P",{"data-svelte-h":!0}),f(Ws)!=="svelte-yql1ve"&&(Ws.textContent=rp),eu.forEach(t),Sd=s(e),c(Uo.$$.fragment,e),Fd=s(e),Ce=i(e,"DIV",{class:!0});var tu=_(Ce);c(Xo.$$.fragment,tu),hc=s(tu),js=i(tu,"P",{"data-svelte-h":!0}),f(js)!=="svelte-1iv9pso"&&(js.textContent=dp),tu.forEach(t),Md=s(e),c(Jo.$$.fragment,e),Cd=s(e),ze=i(e,"DIV",{class:!0});var ou=_(ze);c(Zo.$$.fragment,ou),mc=s(ou),Ds=i(ou,"P",{"data-svelte-h":!0}),f(Ds)!=="svelte-w7415f"&&(Ds.textContent=ip),ou.forEach(t),zd=s(e),c(Go.$$.fragment,e),Nd=s(e),Ne=i(e,"DIV",{class:!0});var nu=_(Ne);c(Yo.$$.fragment,nu),fc=s(nu),Vs=i(nu,"P",{"data-svelte-h":!0}),f(Vs)!=="svelte-dhzux4"&&(Vs.textContent=up),nu.forEach(t),kd=s(e),c(Ko.$$.fragment,e),Ad=s(e),q=i(e,"DIV",{class:!0});var Ta=_(q);c(en.$$.fragment,Ta),_c=s(Ta),Is=i(Ta,"P",{"data-svelte-h":!0}),f(Is)!=="svelte-19jpj19"&&(Is.textContent=cp),gc=s(Ta),Be=i(Ta,"DIV",{class:!0});var su=_(Be);c(tn.$$.fragment,su),Tc=s(su),Hs=i(su,"P",{"data-svelte-h":!0}),f(Hs)!=="svelte-5ihtpa"&&(Hs.textContent=lp),su.forEach(t),Ta.forEach(t),Pd=s(e),c(on.$$.fragment,e),Ld=s(e),w=i(e,"DIV",{class:!0});var ba=_(w);c(nn.$$.fragment,ba),bc=s(ba),Es=i(ba,"P",{"data-svelte-h":!0}),f(Es)!=="svelte-19jpj19"&&(Es.textContent=pp),vc=s(ba),We=i(ba,"DIV",{class:!0});var au=_(We);c(sn.$$.fragment,au),xc=s(au),Qs=i(au,"P",{"data-svelte-h":!0}),f(Qs)!=="svelte-5ihtpa"&&(Qs.textContent=hp),au.forEach(t),ba.forEach(t),Bd=s(e),c(an.$$.fragment,e),Wd=s(e),y=i(e,"DIV",{class:!0});var va=_(y);c(rn.$$.fragment,va),$c=s(va),Rs=i(va,"P",{"data-svelte-h":!0}),f(Rs)!=="svelte-rzpgnp"&&(Rs.textContent=mp),qc=s(va),je=i(va,"DIV",{class:!0});var ru=_(je);c(dn.$$.fragment,ru),wc=s(ru),Us=i(ru,"P",{"data-svelte-h":!0}),f(Us)!=="svelte-5ihtpa"&&(Us.textContent=fp),ru.forEach(t),va.forEach(t),jd=s(e),c(un.$$.fragment,e),Dd=s(e),O=i(e,"DIV",{class:!0});var xa=_(O);c(cn.$$.fragment,xa),yc=s(xa),Xs=i(xa,"P",{"data-svelte-h":!0}),f(Xs)!=="svelte-1kt4x95"&&(Xs.textContent=_p),Oc=s(xa),De=i(xa,"DIV",{class:!0});var du=_(De);c(ln.$$.fragment,du),Sc=s(du),Js=i(du,"P",{"data-svelte-h":!0}),f(Js)!=="svelte-5ihtpa"&&(Js.textContent=gp),du.forEach(t),xa.forEach(t),Vd=s(e),c(pn.$$.fragment,e),Id=s(e),S=i(e,"DIV",{class:!0});var $a=_(S);c(hn.$$.fragment,$a),Fc=s($a),Zs=i($a,"P",{"data-svelte-h":!0}),f(Zs)!=="svelte-k12cko"&&(Zs.textContent=Tp),Mc=s($a),Ve=i($a,"DIV",{class:!0});var iu=_(Ve);c(mn.$$.fragment,iu),Cc=s(iu),Gs=i(iu,"P",{"data-svelte-h":!0}),f(Gs)!=="svelte-5ihtpa"&&(Gs.textContent=bp),iu.forEach(t),$a.forEach(t),Hd=s(e),c(fn.$$.fragment,e),Ed=s(e),F=i(e,"DIV",{class:!0});var qa=_(F);c(_n.$$.fragment,qa),zc=s(qa),Ys=i(qa,"P",{"data-svelte-h":!0}),f(Ys)!=="svelte-3npkmq"&&(Ys.textContent=vp),Nc=s(qa),Ie=i(qa,"DIV",{class:!0});var uu=_(Ie);c(gn.$$.fragment,uu),kc=s(uu),Ks=i(uu,"P",{"data-svelte-h":!0}),f(Ks)!=="svelte-5ihtpa"&&(Ks.textContent=xp),uu.forEach(t),qa.forEach(t),Qd=s(e),c(Tn.$$.fragment,e),Rd=s(e),M=i(e,"DIV",{class:!0});var wa=_(M);c(bn.$$.fragment,wa),Ac=s(wa),ea=i(wa,"P",{"data-svelte-h":!0}),f(ea)!=="svelte-1xezu93"&&(ea.textContent=$p),Pc=s(wa),He=i(wa,"DIV",{class:!0});var cu=_(He);c(vn.$$.fragment,cu),Lc=s(cu),ta=i(cu,"P",{"data-svelte-h":!0}),f(ta)!=="svelte-5ihtpa"&&(ta.textContent=qp),cu.forEach(t),wa.forEach(t),Ud=s(e),c(xn.$$.fragment,e),Xd=s(e),C=i(e,"DIV",{class:!0});var ya=_(C);c($n.$$.fragment,ya),Bc=s(ya),oa=i(ya,"P",{"data-svelte-h":!0}),f(oa)!=="svelte-1dobm33"&&(oa.textContent=wp),Wc=s(ya),Ee=i(ya,"DIV",{class:!0});var lu=_(Ee);c(qn.$$.fragment,lu),jc=s(lu),na=i(lu,"P",{"data-svelte-h":!0}),f(na)!=="svelte-5ihtpa"&&(na.textContent=yp),lu.forEach(t),ya.forEach(t),Jd=s(e),c(wn.$$.fragment,e),Zd=s(e),z=i(e,"DIV",{class:!0});var Oa=_(z);c(yn.$$.fragment,Oa),Dc=s(Oa),sa=i(Oa,"P",{"data-svelte-h":!0}),f(sa)!=="svelte-1bm2i0r"&&(sa.textContent=Op),Vc=s(Oa),Qe=i(Oa,"DIV",{class:!0});var pu=_(Qe);c(On.$$.fragment,pu),Ic=s(pu),aa=i(pu,"P",{"data-svelte-h":!0}),f(aa)!=="svelte-5ihtpa"&&(aa.textContent=Sp),pu.forEach(t),Oa.forEach(t),Gd=s(e),c(Sn.$$.fragment,e),Yd=s(e),N=i(e,"DIV",{class:!0});var Sa=_(N);c(Fn.$$.fragment,Sa),Hc=s(Sa),ra=i(Sa,"P",{"data-svelte-h":!0}),f(ra)!=="svelte-o4u80u"&&(ra.textContent=Fp),Ec=s(Sa),Re=i(Sa,"DIV",{class:!0});var hu=_(Re);c(Mn.$$.fragment,hu),Qc=s(hu),da=i(hu,"P",{"data-svelte-h":!0}),f(da)!=="svelte-5ihtpa"&&(da.textContent=Mp),hu.forEach(t),Sa.forEach(t),Kd=s(e),c(Cn.$$.fragment,e),ei=s(e),k=i(e,"DIV",{class:!0});var Fa=_(k);c(zn.$$.fragment,Fa),Rc=s(Fa),ia=i(Fa,"P",{"data-svelte-h":!0}),f(ia)!=="svelte-1kfw2sn"&&(ia.textContent=Cp),Uc=s(Fa),Ue=i(Fa,"DIV",{class:!0});var mu=_(Ue);c(Nn.$$.fragment,mu),Xc=s(mu),ua=i(mu,"P",{"data-svelte-h":!0}),f(ua)!=="svelte-5ihtpa"&&(ua.textContent=zp),mu.forEach(t),Fa.forEach(t),ti=s(e),c(kn.$$.fragment,e),oi=s(e),A=i(e,"DIV",{class:!0});var Ma=_(A);c(An.$$.fragment,Ma),Jc=s(Ma),ca=i(Ma,"P",{"data-svelte-h":!0}),f(ca)!=="svelte-yql1ve"&&(ca.textContent=Np),Zc=s(Ma),Xe=i(Ma,"DIV",{class:!0});var fu=_(Xe);c(Pn.$$.fragment,fu),Gc=s(fu),la=i(fu,"P",{"data-svelte-h":!0}),f(la)!=="svelte-5ihtpa"&&(la.textContent=kp),fu.forEach(t),Ma.forEach(t),ni=s(e),c(Ln.$$.fragment,e),si=s(e),P=i(e,"DIV",{class:!0});var Ca=_(P);c(Bn.$$.fragment,Ca),Yc=s(Ca),pa=i(Ca,"P",{"data-svelte-h":!0}),f(pa)!=="svelte-1iv9pso"&&(pa.textContent=Ap),Kc=s(Ca),Je=i(Ca,"DIV",{class:!0});var _u=_(Je);c(Wn.$$.fragment,_u),el=s(_u),ha=i(_u,"P",{"data-svelte-h":!0}),f(ha)!=="svelte-5ihtpa"&&(ha.textContent=Pp),_u.forEach(t),Ca.forEach(t),ai=s(e),c(jn.$$.fragment,e),ri=s(e),L=i(e,"DIV",{class:!0});var za=_(L);c(Dn.$$.fragment,za),tl=s(za),ma=i(za,"P",{"data-svelte-h":!0}),f(ma)!=="svelte-w7415f"&&(ma.textContent=Lp),ol=s(za),Ze=i(za,"DIV",{class:!0});var gu=_(Ze);c(Vn.$$.fragment,gu),nl=s(gu),fa=i(gu,"P",{"data-svelte-h":!0}),f(fa)!=="svelte-5ihtpa"&&(fa.textContent=Bp),gu.forEach(t),za.forEach(t),di=s(e),c(In.$$.fragment,e),ii=s(e),B=i(e,"DIV",{class:!0});var Na=_(B);c(Hn.$$.fragment,Na),sl=s(Na),_a=i(Na,"P",{"data-svelte-h":!0}),f(_a)!=="svelte-dhzux4"&&(_a.textContent=Wp),al=s(Na),Ge=i(Na,"DIV",{class:!0});var Tu=_(Ge);c(En.$$.fragment,Tu),rl=s(Tu),ga=i(Tu,"P",{"data-svelte-h":!0}),f(ga)!=="svelte-5ihtpa"&&(ga.textContent=jp),Tu.forEach(t),Na.forEach(t),ui=s(e),ka=i(e,"P",{}),_(ka).forEach(t),this.h()},h(){g(v,"name","hf:doc:metadata"),g(v,"content",Gp),g(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){r(document.head,v),a(e,j,o),a(e,x,o),a(e,ke,o),l(Ye,e,o),a(e,Aa,o),a(e,Ke,o),a(e,Pa,o),a(e,et,o),a(e,La,o),l(tt,e,o),a(e,Ba,o),a(e,ot,o),a(e,Wa,o),l(Ae,e,o),a(e,ja,o),a(e,nt,o),a(e,Da,o),a(e,st,o),a(e,Va,o),l(at,e,o),a(e,Ia,o),a(e,rt,o),a(e,Ha,o),a(e,dt,o),a(e,Ea,o),a(e,it,o),a(e,Qa,o),l(ut,e,o),a(e,Ra,o),a(e,$,o),l(ct,$,null),r($,bu),r($,Un),r($,vu),l(Pe,$,null),r($,xu),r($,Le),l(lt,Le,null),r(Le,$u),r(Le,Xn),a(e,Ua,o),l(pt,e,o),a(e,Xa,o),a(e,D,o),l(ht,D,null),r(D,qu),r(D,Jn),a(e,Ja,o),l(mt,e,o),a(e,Za,o),a(e,V,o),l(ft,V,null),r(V,wu),r(V,Zn),a(e,Ga,o),l(_t,e,o),a(e,Ya,o),a(e,I,o),l(gt,I,null),r(I,yu),r(I,Gn),a(e,Ka,o),l(Tt,e,o),a(e,er,o),a(e,H,o),l(bt,H,null),r(H,Ou),r(H,Yn),a(e,tr,o),l(vt,e,o),a(e,or,o),a(e,E,o),l(xt,E,null),r(E,Su),r(E,Kn),a(e,nr,o),l($t,e,o),a(e,sr,o),a(e,Q,o),l(qt,Q,null),r(Q,Fu),r(Q,es),a(e,ar,o),l(wt,e,o),a(e,rr,o),a(e,R,o),l(yt,R,null),r(R,Mu),r(R,ts),a(e,dr,o),l(Ot,e,o),a(e,ir,o),a(e,U,o),l(St,U,null),r(U,Cu),r(U,os),a(e,ur,o),l(Ft,e,o),a(e,cr,o),a(e,X,o),l(Mt,X,null),r(X,zu),r(X,ns),a(e,lr,o),l(Ct,e,o),a(e,pr,o),a(e,J,o),l(zt,J,null),r(J,Nu),r(J,ss),a(e,hr,o),l(Nt,e,o),a(e,mr,o),a(e,Z,o),l(kt,Z,null),r(Z,ku),r(Z,as),a(e,fr,o),l(At,e,o),a(e,_r,o),a(e,G,o),l(Pt,G,null),r(G,Au),r(G,rs),a(e,gr,o),l(Lt,e,o),a(e,Tr,o),a(e,Y,o),l(Bt,Y,null),r(Y,Pu),r(Y,ds),a(e,br,o),l(Wt,e,o),a(e,vr,o),a(e,K,o),l(jt,K,null),r(K,Lu),r(K,is),a(e,xr,o),l(Dt,e,o),a(e,$r,o),a(e,ee,o),l(Vt,ee,null),r(ee,Bu),r(ee,us),a(e,qr,o),l(It,e,o),a(e,wr,o),a(e,te,o),l(Ht,te,null),r(te,Wu),r(te,cs),a(e,yr,o),l(Et,e,o),a(e,Or,o),a(e,oe,o),l(Qt,oe,null),r(oe,ju),r(oe,ls),a(e,Sr,o),l(Rt,e,o),a(e,Fr,o),a(e,ne,o),l(Ut,ne,null),r(ne,Du),r(ne,ps),a(e,Mr,o),l(Xt,e,o),a(e,Cr,o),a(e,se,o),l(Jt,se,null),r(se,Vu),r(se,hs),a(e,zr,o),l(Zt,e,o),a(e,Nr,o),a(e,ae,o),l(Gt,ae,null),r(ae,Iu),r(ae,ms),a(e,kr,o),l(Yt,e,o),a(e,Ar,o),a(e,re,o),l(Kt,re,null),r(re,Hu),r(re,fs),a(e,Pr,o),l(eo,e,o),a(e,Lr,o),a(e,de,o),l(to,de,null),r(de,Eu),r(de,_s),a(e,Br,o),l(oo,e,o),a(e,Wr,o),a(e,ie,o),l(no,ie,null),r(ie,Qu),r(ie,gs),a(e,jr,o),l(so,e,o),a(e,Dr,o),a(e,ue,o),l(ao,ue,null),r(ue,Ru),r(ue,Ts),a(e,Vr,o),l(ro,e,o),a(e,Ir,o),a(e,ce,o),l(io,ce,null),r(ce,Uu),r(ce,bs),a(e,Hr,o),l(uo,e,o),a(e,Er,o),a(e,le,o),l(co,le,null),r(le,Xu),r(le,vs),a(e,Qr,o),l(lo,e,o),a(e,Rr,o),a(e,pe,o),l(po,pe,null),r(pe,Ju),r(pe,xs),a(e,Ur,o),l(ho,e,o),a(e,Xr,o),a(e,he,o),l(mo,he,null),r(he,Zu),r(he,$s),a(e,Jr,o),l(fo,e,o),a(e,Zr,o),a(e,me,o),l(_o,me,null),r(me,Gu),r(me,qs),a(e,Gr,o),l(go,e,o),a(e,Yr,o),a(e,fe,o),l(To,fe,null),r(fe,Yu),r(fe,ws),a(e,Kr,o),l(bo,e,o),a(e,ed,o),a(e,_e,o),l(vo,_e,null),r(_e,Ku),r(_e,ys),a(e,td,o),l(xo,e,o),a(e,od,o),a(e,ge,o),l($o,ge,null),r(ge,ec),r(ge,Os),a(e,nd,o),l(qo,e,o),a(e,sd,o),a(e,Te,o),l(wo,Te,null),r(Te,tc),r(Te,Ss),a(e,ad,o),l(yo,e,o),a(e,rd,o),a(e,be,o),l(Oo,be,null),r(be,oc),r(be,Fs),a(e,dd,o),l(So,e,o),a(e,id,o),a(e,ve,o),l(Fo,ve,null),r(ve,nc),r(ve,Ms),a(e,ud,o),l(Mo,e,o),a(e,cd,o),a(e,xe,o),l(Co,xe,null),r(xe,sc),r(xe,Cs),a(e,ld,o),l(zo,e,o),a(e,pd,o),a(e,$e,o),l(No,$e,null),r($e,ac),r($e,zs),a(e,hd,o),l(ko,e,o),a(e,md,o),a(e,qe,o),l(Ao,qe,null),r(qe,rc),r(qe,Ns),a(e,fd,o),l(Po,e,o),a(e,_d,o),a(e,we,o),l(Lo,we,null),r(we,dc),r(we,ks),a(e,gd,o),l(Bo,e,o),a(e,Td,o),a(e,ye,o),l(Wo,ye,null),r(ye,ic),r(ye,As),a(e,bd,o),l(jo,e,o),a(e,vd,o),a(e,Oe,o),l(Do,Oe,null),r(Oe,uc),r(Oe,Ps),a(e,xd,o),l(Vo,e,o),a(e,$d,o),a(e,Se,o),l(Io,Se,null),r(Se,cc),r(Se,Ls),a(e,qd,o),l(Ho,e,o),a(e,wd,o),a(e,Fe,o),l(Eo,Fe,null),r(Fe,lc),r(Fe,Bs),a(e,yd,o),l(Qo,e,o),a(e,Od,o),a(e,Me,o),l(Ro,Me,null),r(Me,pc),r(Me,Ws),a(e,Sd,o),l(Uo,e,o),a(e,Fd,o),a(e,Ce,o),l(Xo,Ce,null),r(Ce,hc),r(Ce,js),a(e,Md,o),l(Jo,e,o),a(e,Cd,o),a(e,ze,o),l(Zo,ze,null),r(ze,mc),r(ze,Ds),a(e,zd,o),l(Go,e,o),a(e,Nd,o),a(e,Ne,o),l(Yo,Ne,null),r(Ne,fc),r(Ne,Vs),a(e,kd,o),l(Ko,e,o),a(e,Ad,o),a(e,q,o),l(en,q,null),r(q,_c),r(q,Is),r(q,gc),r(q,Be),l(tn,Be,null),r(Be,Tc),r(Be,Hs),a(e,Pd,o),l(on,e,o),a(e,Ld,o),a(e,w,o),l(nn,w,null),r(w,bc),r(w,Es),r(w,vc),r(w,We),l(sn,We,null),r(We,xc),r(We,Qs),a(e,Bd,o),l(an,e,o),a(e,Wd,o),a(e,y,o),l(rn,y,null),r(y,$c),r(y,Rs),r(y,qc),r(y,je),l(dn,je,null),r(je,wc),r(je,Us),a(e,jd,o),l(un,e,o),a(e,Dd,o),a(e,O,o),l(cn,O,null),r(O,yc),r(O,Xs),r(O,Oc),r(O,De),l(ln,De,null),r(De,Sc),r(De,Js),a(e,Vd,o),l(pn,e,o),a(e,Id,o),a(e,S,o),l(hn,S,null),r(S,Fc),r(S,Zs),r(S,Mc),r(S,Ve),l(mn,Ve,null),r(Ve,Cc),r(Ve,Gs),a(e,Hd,o),l(fn,e,o),a(e,Ed,o),a(e,F,o),l(_n,F,null),r(F,zc),r(F,Ys),r(F,Nc),r(F,Ie),l(gn,Ie,null),r(Ie,kc),r(Ie,Ks),a(e,Qd,o),l(Tn,e,o),a(e,Rd,o),a(e,M,o),l(bn,M,null),r(M,Ac),r(M,ea),r(M,Pc),r(M,He),l(vn,He,null),r(He,Lc),r(He,ta),a(e,Ud,o),l(xn,e,o),a(e,Xd,o),a(e,C,o),l($n,C,null),r(C,Bc),r(C,oa),r(C,Wc),r(C,Ee),l(qn,Ee,null),r(Ee,jc),r(Ee,na),a(e,Jd,o),l(wn,e,o),a(e,Zd,o),a(e,z,o),l(yn,z,null),r(z,Dc),r(z,sa),r(z,Vc),r(z,Qe),l(On,Qe,null),r(Qe,Ic),r(Qe,aa),a(e,Gd,o),l(Sn,e,o),a(e,Yd,o),a(e,N,o),l(Fn,N,null),r(N,Hc),r(N,ra),r(N,Ec),r(N,Re),l(Mn,Re,null),r(Re,Qc),r(Re,da),a(e,Kd,o),l(Cn,e,o),a(e,ei,o),a(e,k,o),l(zn,k,null),r(k,Rc),r(k,ia),r(k,Uc),r(k,Ue),l(Nn,Ue,null),r(Ue,Xc),r(Ue,ua),a(e,ti,o),l(kn,e,o),a(e,oi,o),a(e,A,o),l(An,A,null),r(A,Jc),r(A,ca),r(A,Zc),r(A,Xe),l(Pn,Xe,null),r(Xe,Gc),r(Xe,la),a(e,ni,o),l(Ln,e,o),a(e,si,o),a(e,P,o),l(Bn,P,null),r(P,Yc),r(P,pa),r(P,Kc),r(P,Je),l(Wn,Je,null),r(Je,el),r(Je,ha),a(e,ai,o),l(jn,e,o),a(e,ri,o),a(e,L,o),l(Dn,L,null),r(L,tl),r(L,ma),r(L,ol),r(L,Ze),l(Vn,Ze,null),r(Ze,nl),r(Ze,fa),a(e,di,o),l(In,e,o),a(e,ii,o),a(e,B,o),l(Hn,B,null),r(B,sl),r(B,_a),r(B,al),r(B,Ge),l(En,Ge,null),r(Ge,rl),r(Ge,ga),a(e,ui,o),a(e,ka,o),ci=!0},p(e,[o]){const W={};o&2&&(W.$$scope={dirty:o,ctx:e}),Ae.$set(W);const Qn={};o&2&&(Qn.$$scope={dirty:o,ctx:e}),Pe.$set(Qn)},i(e){ci||(p(Ye.$$.fragment,e),p(tt.$$.fragment,e),p(Ae.$$.fragment,e),p(at.$$.fragment,e),p(ut.$$.fragment,e),p(ct.$$.fragment,e),p(Pe.$$.fragment,e),p(lt.$$.fragment,e),p(pt.$$.fragment,e),p(ht.$$.fragment,e),p(mt.$$.fragment,e),p(ft.$$.fragment,e),p(_t.$$.fragment,e),p(gt.$$.fragment,e),p(Tt.$$.fragment,e),p(bt.$$.fragment,e),p(vt.$$.fragment,e),p(xt.$$.fragment,e),p($t.$$.fragment,e),p(qt.$$.fragment,e),p(wt.$$.fragment,e),p(yt.$$.fragment,e),p(Ot.$$.fragment,e),p(St.$$.fragment,e),p(Ft.$$.fragment,e),p(Mt.$$.fragment,e),p(Ct.$$.fragment,e),p(zt.$$.fragment,e),p(Nt.$$.fragment,e),p(kt.$$.fragment,e),p(At.$$.fragment,e),p(Pt.$$.fragment,e),p(Lt.$$.fragment,e),p(Bt.$$.fragment,e),p(Wt.$$.fragment,e),p(jt.$$.fragment,e),p(Dt.$$.fragment,e),p(Vt.$$.fragment,e),p(It.$$.fragment,e),p(Ht.$$.fragment,e),p(Et.$$.fragment,e),p(Qt.$$.fragment,e),p(Rt.$$.fragment,e),p(Ut.$$.fragment,e),p(Xt.$$.fragment,e),p(Jt.$$.fragment,e),p(Zt.$$.fragment,e),p(Gt.$$.fragment,e),p(Yt.$$.fragment,e),p(Kt.$$.fragment,e),p(eo.$$.fragment,e),p(to.$$.fragment,e),p(oo.$$.fragment,e),p(no.$$.fragment,e),p(so.$$.fragment,e),p(ao.$$.fragment,e),p(ro.$$.fragment,e),p(io.$$.fragment,e),p(uo.$$.fragment,e),p(co.$$.fragment,e),p(lo.$$.fragment,e),p(po.$$.fragment,e),p(ho.$$.fragment,e),p(mo.$$.fragment,e),p(fo.$$.fragment,e),p(_o.$$.fragment,e),p(go.$$.fragment,e),p(To.$$.fragment,e),p(bo.$$.fragment,e),p(vo.$$.fragment,e),p(xo.$$.fragment,e),p($o.$$.fragment,e),p(qo.$$.fragment,e),p(wo.$$.fragment,e),p(yo.$$.fragment,e),p(Oo.$$.fragment,e),p(So.$$.fragment,e),p(Fo.$$.fragment,e),p(Mo.$$.fragment,e),p(Co.$$.fragment,e),p(zo.$$.fragment,e),p(No.$$.fragment,e),p(ko.$$.fragment,e),p(Ao.$$.fragment,e),p(Po.$$.fragment,e),p(Lo.$$.fragment,e),p(Bo.$$.fragment,e),p(Wo.$$.fragment,e),p(jo.$$.fragment,e),p(Do.$$.fragment,e),p(Vo.$$.fragment,e),p(Io.$$.fragment,e),p(Ho.$$.fragment,e),p(Eo.$$.fragment,e),p(Qo.$$.fragment,e),p(Ro.$$.fragment,e),p(Uo.$$.fragment,e),p(Xo.$$.fragment,e),p(Jo.$$.fragment,e),p(Zo.$$.fragment,e),p(Go.$$.fragment,e),p(Yo.$$.fragment,e),p(Ko.$$.fragment,e),p(en.$$.fragment,e),p(tn.$$.fragment,e),p(on.$$.fragment,e),p(nn.$$.fragment,e),p(sn.$$.fragment,e),p(an.$$.fragment,e),p(rn.$$.fragment,e),p(dn.$$.fragment,e),p(un.$$.fragment,e),p(cn.$$.fragment,e),p(ln.$$.fragment,e),p(pn.$$.fragment,e),p(hn.$$.fragment,e),p(mn.$$.fragment,e),p(fn.$$.fragment,e),p(_n.$$.fragment,e),p(gn.$$.fragment,e),p(Tn.$$.fragment,e),p(bn.$$.fragment,e),p(vn.$$.fragment,e),p(xn.$$.fragment,e),p($n.$$.fragment,e),p(qn.$$.fragment,e),p(wn.$$.fragment,e),p(yn.$$.fragment,e),p(On.$$.fragment,e),p(Sn.$$.fragment,e),p(Fn.$$.fragment,e),p(Mn.$$.fragment,e),p(Cn.$$.fragment,e),p(zn.$$.fragment,e),p(Nn.$$.fragment,e),p(kn.$$.fragment,e),p(An.$$.fragment,e),p(Pn.$$.fragment,e),p(Ln.$$.fragment,e),p(Bn.$$.fragment,e),p(Wn.$$.fragment,e),p(jn.$$.fragment,e),p(Dn.$$.fragment,e),p(Vn.$$.fragment,e),p(In.$$.fragment,e),p(Hn.$$.fragment,e),p(En.$$.fragment,e),ci=!0)},o(e){h(Ye.$$.fragment,e),h(tt.$$.fragment,e),h(Ae.$$.fragment,e),h(at.$$.fragment,e),h(ut.$$.fragment,e),h(ct.$$.fragment,e),h(Pe.$$.fragment,e),h(lt.$$.fragment,e),h(pt.$$.fragment,e),h(ht.$$.fragment,e),h(mt.$$.fragment,e),h(ft.$$.fragment,e),h(_t.$$.fragment,e),h(gt.$$.fragment,e),h(Tt.$$.fragment,e),h(bt.$$.fragment,e),h(vt.$$.fragment,e),h(xt.$$.fragment,e),h($t.$$.fragment,e),h(qt.$$.fragment,e),h(wt.$$.fragment,e),h(yt.$$.fragment,e),h(Ot.$$.fragment,e),h(St.$$.fragment,e),h(Ft.$$.fragment,e),h(Mt.$$.fragment,e),h(Ct.$$.fragment,e),h(zt.$$.fragment,e),h(Nt.$$.fragment,e),h(kt.$$.fragment,e),h(At.$$.fragment,e),h(Pt.$$.fragment,e),h(Lt.$$.fragment,e),h(Bt.$$.fragment,e),h(Wt.$$.fragment,e),h(jt.$$.fragment,e),h(Dt.$$.fragment,e),h(Vt.$$.fragment,e),h(It.$$.fragment,e),h(Ht.$$.fragment,e),h(Et.$$.fragment,e),h(Qt.$$.fragment,e),h(Rt.$$.fragment,e),h(Ut.$$.fragment,e),h(Xt.$$.fragment,e),h(Jt.$$.fragment,e),h(Zt.$$.fragment,e),h(Gt.$$.fragment,e),h(Yt.$$.fragment,e),h(Kt.$$.fragment,e),h(eo.$$.fragment,e),h(to.$$.fragment,e),h(oo.$$.fragment,e),h(no.$$.fragment,e),h(so.$$.fragment,e),h(ao.$$.fragment,e),h(ro.$$.fragment,e),h(io.$$.fragment,e),h(uo.$$.fragment,e),h(co.$$.fragment,e),h(lo.$$.fragment,e),h(po.$$.fragment,e),h(ho.$$.fragment,e),h(mo.$$.fragment,e),h(fo.$$.fragment,e),h(_o.$$.fragment,e),h(go.$$.fragment,e),h(To.$$.fragment,e),h(bo.$$.fragment,e),h(vo.$$.fragment,e),h(xo.$$.fragment,e),h($o.$$.fragment,e),h(qo.$$.fragment,e),h(wo.$$.fragment,e),h(yo.$$.fragment,e),h(Oo.$$.fragment,e),h(So.$$.fragment,e),h(Fo.$$.fragment,e),h(Mo.$$.fragment,e),h(Co.$$.fragment,e),h(zo.$$.fragment,e),h(No.$$.fragment,e),h(ko.$$.fragment,e),h(Ao.$$.fragment,e),h(Po.$$.fragment,e),h(Lo.$$.fragment,e),h(Bo.$$.fragment,e),h(Wo.$$.fragment,e),h(jo.$$.fragment,e),h(Do.$$.fragment,e),h(Vo.$$.fragment,e),h(Io.$$.fragment,e),h(Ho.$$.fragment,e),h(Eo.$$.fragment,e),h(Qo.$$.fragment,e),h(Ro.$$.fragment,e),h(Uo.$$.fragment,e),h(Xo.$$.fragment,e),h(Jo.$$.fragment,e),h(Zo.$$.fragment,e),h(Go.$$.fragment,e),h(Yo.$$.fragment,e),h(Ko.$$.fragment,e),h(en.$$.fragment,e),h(tn.$$.fragment,e),h(on.$$.fragment,e),h(nn.$$.fragment,e),h(sn.$$.fragment,e),h(an.$$.fragment,e),h(rn.$$.fragment,e),h(dn.$$.fragment,e),h(un.$$.fragment,e),h(cn.$$.fragment,e),h(ln.$$.fragment,e),h(pn.$$.fragment,e),h(hn.$$.fragment,e),h(mn.$$.fragment,e),h(fn.$$.fragment,e),h(_n.$$.fragment,e),h(gn.$$.fragment,e),h(Tn.$$.fragment,e),h(bn.$$.fragment,e),h(vn.$$.fragment,e),h(xn.$$.fragment,e),h($n.$$.fragment,e),h(qn.$$.fragment,e),h(wn.$$.fragment,e),h(yn.$$.fragment,e),h(On.$$.fragment,e),h(Sn.$$.fragment,e),h(Fn.$$.fragment,e),h(Mn.$$.fragment,e),h(Cn.$$.fragment,e),h(zn.$$.fragment,e),h(Nn.$$.fragment,e),h(kn.$$.fragment,e),h(An.$$.fragment,e),h(Pn.$$.fragment,e),h(Ln.$$.fragment,e),h(Bn.$$.fragment,e),h(Wn.$$.fragment,e),h(jn.$$.fragment,e),h(Dn.$$.fragment,e),h(Vn.$$.fragment,e),h(In.$$.fragment,e),h(Hn.$$.fragment,e),h(En.$$.fragment,e),ci=!1},d(e){e&&(t(j),t(x),t(ke),t(Aa),t(Ke),t(Pa),t(et),t(La),t(Ba),t(ot),t(Wa),t(ja),t(nt),t(Da),t(st),t(Va),t(Ia),t(rt),t(Ha),t(dt),t(Ea),t(it),t(Qa),t(Ra),t($),t(Ua),t(Xa),t(D),t(Ja),t(Za),t(V),t(Ga),t(Ya),t(I),t(Ka),t(er),t(H),t(tr),t(or),t(E),t(nr),t(sr),t(Q),t(ar),t(rr),t(R),t(dr),t(ir),t(U),t(ur),t(cr),t(X),t(lr),t(pr),t(J),t(hr),t(mr),t(Z),t(fr),t(_r),t(G),t(gr),t(Tr),t(Y),t(br),t(vr),t(K),t(xr),t($r),t(ee),t(qr),t(wr),t(te),t(yr),t(Or),t(oe),t(Sr),t(Fr),t(ne),t(Mr),t(Cr),t(se),t(zr),t(Nr),t(ae),t(kr),t(Ar),t(re),t(Pr),t(Lr),t(de),t(Br),t(Wr),t(ie),t(jr),t(Dr),t(ue),t(Vr),t(Ir),t(ce),t(Hr),t(Er),t(le),t(Qr),t(Rr),t(pe),t(Ur),t(Xr),t(he),t(Jr),t(Zr),t(me),t(Gr),t(Yr),t(fe),t(Kr),t(ed),t(_e),t(td),t(od),t(ge),t(nd),t(sd),t(Te),t(ad),t(rd),t(be),t(dd),t(id),t(ve),t(ud),t(cd),t(xe),t(ld),t(pd),t($e),t(hd),t(md),t(qe),t(fd),t(_d),t(we),t(gd),t(Td),t(ye),t(bd),t(vd),t(Oe),t(xd),t($d),t(Se),t(qd),t(wd),t(Fe),t(yd),t(Od),t(Me),t(Sd),t(Fd),t(Ce),t(Md),t(Cd),t(ze),t(zd),t(Nd),t(Ne),t(kd),t(Ad),t(q),t(Pd),t(Ld),t(w),t(Bd),t(Wd),t(y),t(jd),t(Dd),t(O),t(Vd),t(Id),t(S),t(Hd),t(Ed),t(F),t(Qd),t(Rd),t(M),t(Ud),t(Xd),t(C),t(Jd),t(Zd),t(z),t(Gd),t(Yd),t(N),t(Kd),t(ei),t(k),t(ti),t(oi),t(A),t(ni),t(si),t(P),t(ai),t(ri),t(L),t(di),t(ii),t(B),t(ui),t(ka)),t(v),m(Ye,e),m(tt,e),m(Ae,e),m(at,e),m(ut,e),m(ct),m(Pe),m(lt),m(pt,e),m(ht),m(mt,e),m(ft),m(_t,e),m(gt),m(Tt,e),m(bt),m(vt,e),m(xt),m($t,e),m(qt),m(wt,e),m(yt),m(Ot,e),m(St),m(Ft,e),m(Mt),m(Ct,e),m(zt),m(Nt,e),m(kt),m(At,e),m(Pt),m(Lt,e),m(Bt),m(Wt,e),m(jt),m(Dt,e),m(Vt),m(It,e),m(Ht),m(Et,e),m(Qt),m(Rt,e),m(Ut),m(Xt,e),m(Jt),m(Zt,e),m(Gt),m(Yt,e),m(Kt),m(eo,e),m(to),m(oo,e),m(no),m(so,e),m(ao),m(ro,e),m(io),m(uo,e),m(co),m(lo,e),m(po),m(ho,e),m(mo),m(fo,e),m(_o),m(go,e),m(To),m(bo,e),m(vo),m(xo,e),m($o),m(qo,e),m(wo),m(yo,e),m(Oo),m(So,e),m(Fo),m(Mo,e),m(Co),m(zo,e),m(No),m(ko,e),m(Ao),m(Po,e),m(Lo),m(Bo,e),m(Wo),m(jo,e),m(Do),m(Vo,e),m(Io),m(Ho,e),m(Eo),m(Qo,e),m(Ro),m(Uo,e),m(Xo),m(Jo,e),m(Zo),m(Go,e),m(Yo),m(Ko,e),m(en),m(tn),m(on,e),m(nn),m(sn),m(an,e),m(rn),m(dn),m(un,e),m(cn),m(ln),m(pn,e),m(hn),m(mn),m(fn,e),m(_n),m(gn),m(Tn,e),m(bn),m(vn),m(xn,e),m($n),m(qn),m(wn,e),m(yn),m(On),m(Sn,e),m(Fn),m(Mn),m(Cn,e),m(zn),m(Nn),m(kn,e),m(An),m(Pn),m(Ln,e),m(Bn),m(Wn),m(jn,e),m(Dn),m(Vn),m(In,e),m(Hn),m(En)}}}const Gp='{"title":"Model outputs","local":"model-outputs","sections":[{"title":"ModelOutput","local":"transformers.utils.ModelOutput","sections":[],"depth":2},{"title":"BaseModelOutput","local":"transformers.modeling_outputs.BaseModelOutput","sections":[],"depth":2},{"title":"BaseModelOutputWithPooling","local":"transformers.modeling_outputs.BaseModelOutputWithPooling","sections":[],"depth":2},{"title":"BaseModelOutputWithCrossAttentions","local":"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions","sections":[],"depth":2},{"title":"BaseModelOutputWithPoolingAndCrossAttentions","local":"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions","sections":[],"depth":2},{"title":"BaseModelOutputWithPast","local":"transformers.modeling_outputs.BaseModelOutputWithPast","sections":[],"depth":2},{"title":"BaseModelOutputWithPastAndCrossAttentions","local":"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions","sections":[],"depth":2},{"title":"Seq2SeqModelOutput","local":"transformers.modeling_outputs.Seq2SeqModelOutput","sections":[],"depth":2},{"title":"CausalLMOutput","local":"transformers.modeling_outputs.CausalLMOutput","sections":[],"depth":2},{"title":"CausalLMOutputWithCrossAttentions","local":"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions","sections":[],"depth":2},{"title":"CausalLMOutputWithPast","local":"transformers.modeling_outputs.CausalLMOutputWithPast","sections":[],"depth":2},{"title":"MaskedLMOutput","local":"transformers.modeling_outputs.MaskedLMOutput","sections":[],"depth":2},{"title":"Seq2SeqLMOutput","local":"transformers.modeling_outputs.Seq2SeqLMOutput","sections":[],"depth":2},{"title":"NextSentencePredictorOutput","local":"transformers.modeling_outputs.NextSentencePredictorOutput","sections":[],"depth":2},{"title":"SequenceClassifierOutput","local":"transformers.modeling_outputs.SequenceClassifierOutput","sections":[],"depth":2},{"title":"Seq2SeqSequenceClassifierOutput","local":"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput","sections":[],"depth":2},{"title":"MultipleChoiceModelOutput","local":"transformers.modeling_outputs.MultipleChoiceModelOutput","sections":[],"depth":2},{"title":"TokenClassifierOutput","local":"transformers.modeling_outputs.TokenClassifierOutput","sections":[],"depth":2},{"title":"QuestionAnsweringModelOutput","local":"transformers.modeling_outputs.QuestionAnsweringModelOutput","sections":[],"depth":2},{"title":"Seq2SeqQuestionAnsweringModelOutput","local":"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput","sections":[],"depth":2},{"title":"Seq2SeqSpectrogramOutput","local":"transformers.modeling_outputs.Seq2SeqSpectrogramOutput","sections":[],"depth":2},{"title":"SemanticSegmenterOutput","local":"transformers.modeling_outputs.SemanticSegmenterOutput","sections":[],"depth":2},{"title":"ImageClassifierOutput","local":"transformers.modeling_outputs.ImageClassifierOutput","sections":[],"depth":2},{"title":"ImageClassifierOutputWithNoAttention","local":"transformers.modeling_outputs.ImageClassifierOutputWithNoAttention","sections":[],"depth":2},{"title":"DepthEstimatorOutput","local":"transformers.modeling_outputs.DepthEstimatorOutput","sections":[],"depth":2},{"title":"Wav2Vec2BaseModelOutput","local":"transformers.modeling_outputs.Wav2Vec2BaseModelOutput","sections":[],"depth":2},{"title":"XVectorOutput","local":"transformers.modeling_outputs.XVectorOutput","sections":[],"depth":2},{"title":"Seq2SeqTSModelOutput","local":"transformers.modeling_outputs.Seq2SeqTSModelOutput","sections":[],"depth":2},{"title":"Seq2SeqTSPredictionOutput","local":"transformers.modeling_outputs.Seq2SeqTSPredictionOutput","sections":[],"depth":2},{"title":"SampleTSPredictionOutput","local":"transformers.modeling_outputs.SampleTSPredictionOutput","sections":[],"depth":2},{"title":"TFBaseModelOutput","local":"transformers.modeling_tf_outputs.TFBaseModelOutput","sections":[],"depth":2},{"title":"TFBaseModelOutputWithPooling","local":"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling","sections":[],"depth":2},{"title":"TFBaseModelOutputWithPoolingAndCrossAttentions","local":"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions","sections":[],"depth":2},{"title":"TFBaseModelOutputWithPast","local":"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast","sections":[],"depth":2},{"title":"TFBaseModelOutputWithPastAndCrossAttentions","local":"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions","sections":[],"depth":2},{"title":"TFSeq2SeqModelOutput","local":"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput","sections":[],"depth":2},{"title":"TFCausalLMOutput","local":"transformers.modeling_tf_outputs.TFCausalLMOutput","sections":[],"depth":2},{"title":"TFCausalLMOutputWithCrossAttentions","local":"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions","sections":[],"depth":2},{"title":"TFCausalLMOutputWithPast","local":"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast","sections":[],"depth":2},{"title":"TFMaskedLMOutput","local":"transformers.modeling_tf_outputs.TFMaskedLMOutput","sections":[],"depth":2},{"title":"TFSeq2SeqLMOutput","local":"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput","sections":[],"depth":2},{"title":"TFNextSentencePredictorOutput","local":"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput","sections":[],"depth":2},{"title":"TFSequenceClassifierOutput","local":"transformers.modeling_tf_outputs.TFSequenceClassifierOutput","sections":[],"depth":2},{"title":"TFSeq2SeqSequenceClassifierOutput","local":"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput","sections":[],"depth":2},{"title":"TFMultipleChoiceModelOutput","local":"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput","sections":[],"depth":2},{"title":"TFTokenClassifierOutput","local":"transformers.modeling_tf_outputs.TFTokenClassifierOutput","sections":[],"depth":2},{"title":"TFQuestionAnsweringModelOutput","local":"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput","sections":[],"depth":2},{"title":"TFSeq2SeqQuestionAnsweringModelOutput","local":"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput","sections":[],"depth":2},{"title":"FlaxBaseModelOutput","local":"transformers.modeling_flax_outputs.FlaxBaseModelOutput","sections":[],"depth":2},{"title":"FlaxBaseModelOutputWithPast","local":"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast","sections":[],"depth":2},{"title":"FlaxBaseModelOutputWithPooling","local":"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling","sections":[],"depth":2},{"title":"FlaxBaseModelOutputWithPastAndCrossAttentions","local":"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions","sections":[],"depth":2},{"title":"FlaxSeq2SeqModelOutput","local":"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput","sections":[],"depth":2},{"title":"FlaxCausalLMOutputWithCrossAttentions","local":"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions","sections":[],"depth":2},{"title":"FlaxMaskedLMOutput","local":"transformers.modeling_flax_outputs.FlaxMaskedLMOutput","sections":[],"depth":2},{"title":"FlaxSeq2SeqLMOutput","local":"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput","sections":[],"depth":2},{"title":"FlaxNextSentencePredictorOutput","local":"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput","sections":[],"depth":2},{"title":"FlaxSequenceClassifierOutput","local":"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput","sections":[],"depth":2},{"title":"FlaxSeq2SeqSequenceClassifierOutput","local":"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput","sections":[],"depth":2},{"title":"FlaxMultipleChoiceModelOutput","local":"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput","sections":[],"depth":2},{"title":"FlaxTokenClassifierOutput","local":"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput","sections":[],"depth":2},{"title":"FlaxQuestionAnsweringModelOutput","local":"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput","sections":[],"depth":2},{"title":"FlaxSeq2SeqQuestionAnsweringModelOutput","local":"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput","sections":[],"depth":2}],"depth":1}';function Yp(Rn){return Ep(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ah extends Qp{constructor(v){super(),Rp(this,v,Yp,Zp,Hp,{})}}export{ah as component};
