import{s as At,n as Kt,o as Ot}from"../chunks/scheduler.9bc65507.js";import{S as el,i as tl,g as i,s as a,r as g,A as ll,h as o,f as l,c as s,j as St,u as p,x as m,k as Dt,y as nl,a as n,v as r,d as u,t as d,w as c}from"../chunks/index.707bf1b6.js";import{C as h}from"../chunks/CodeBlock.54a9f38d.js";import{D as al}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as M}from"../chunks/Heading.342b1fa6.js";function sl(Mt){let f,Me,he,be,b,Te,T,ye,y,bt='There are several multilingual models in 🤗 Transformers, and their inference usage differs from monolingual models. Not <em>all</em> multilingual model usage is different though. Some models, like <a href="https://huggingface.co/bert-base-multilingual-uncased" rel="nofollow">bert-base-multilingual-uncased</a>, can be used just like a monolingual model. This guide will show you how to use multilingual models whose usage differs for inference.',Je,J,Ue,U,Tt="XLM has ten different checkpoints, only one of which is monolingual. The nine remaining model checkpoints can be split into two categories: the checkpoints that use language embeddings and those that don’t.",we,w,$e,$,yt="The following XLM models use language embeddings to specify the language used at inference:",ke,k,Jt="<li><code>xlm-mlm-ende-1024</code> (Masked language modeling, English-German)</li> <li><code>xlm-mlm-enfr-1024</code> (Masked language modeling, English-French)</li> <li><code>xlm-mlm-enro-1024</code> (Masked language modeling, English-Romanian)</li> <li><code>xlm-mlm-xnli15-1024</code> (Masked language modeling, XNLI languages)</li> <li><code>xlm-mlm-tlm-xnli15-1024</code> (Masked language modeling + translation, XNLI languages)</li> <li><code>xlm-clm-enfr-1024</code> (Causal language modeling, English-French)</li> <li><code>xlm-clm-ende-1024</code> (Causal language modeling, English-German)</li>",je,j,Ut="Language embeddings are represented as a tensor of the same shape as the <code>input_ids</code> passed to the model. The values in these tensors depend on the language used and are identified by the tokenizer’s <code>lang2id</code> and <code>id2lang</code> attributes.",xe,x,wt="In this example, load the <code>xlm-clm-enfr-1024</code> checkpoint (Causal language modeling, English-French):",ve,v,Ce,C,$t="The <code>lang2id</code> attribute of the tokenizer displays this model’s languages and their ids:",Ze,Z,_e,_,kt="Next, create an example input:",Xe,X,Ie,I,jt="Set the language id as <code>&quot;en&quot;</code> and use it to define the language embedding. The language embedding is a tensor filled with <code>0</code> since that is the language id for English. This tensor should be the same size as <code>input_ids</code>.",Ge,G,We,W,xt="Now you can pass the <code>input_ids</code> and language embedding to the model:",Re,R,Ve,V,vt='The <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-generation/run_generation.py" rel="nofollow">run_generation.py</a> script can generate text with language embeddings using the <code>xlm-clm</code> checkpoints.',Le,L,Be,B,Ct="The following XLM models do not require language embeddings during inference:",ze,z,Zt="<li><code>xlm-mlm-17-1280</code> (Masked language modeling, 17 languages)</li> <li><code>xlm-mlm-100-1280</code> (Masked language modeling, 100 languages)</li>",Ee,E,_t="These models are used for generic sentence representations, unlike the previous XLM checkpoints.",Fe,F,He,H,Xt="The following BERT models can be used for multilingual tasks:",qe,q,It="<li><code>bert-base-multilingual-uncased</code> (Masked language modeling + Next sentence prediction, 102 languages)</li> <li><code>bert-base-multilingual-cased</code> (Masked language modeling + Next sentence prediction, 104 languages)</li>",Qe,Q,Gt=`These models do not require language embeddings during inference. They should identify the language from the
context and infer accordingly.`,Ne,N,Ye,Y,Wt="The following XLM-RoBERTa models can be used for multilingual tasks:",Pe,P,Rt="<li><code>xlm-roberta-base</code> (Masked language modeling, 100 languages)</li> <li><code>xlm-roberta-large</code> (Masked language modeling, 100 languages)</li>",Se,S,Vt="XLM-RoBERTa was trained on 2.5TB of newly created and cleaned CommonCrawl data in 100 languages. It provides strong gains over previously released multilingual models like mBERT or XLM on downstream tasks like classification, sequence labeling, and question answering.",De,D,Ae,A,Lt="The following M2M100 models can be used for multilingual translation:",Ke,K,Bt="<li><code>facebook/m2m100_418M</code> (Translation)</li> <li><code>facebook/m2m100_1.2B</code> (Translation)</li>",Oe,O,zt="In this example, load the <code>facebook/m2m100_418M</code> checkpoint to translate from Chinese to English. You can set the source language in the tokenizer:",et,ee,tt,te,Et="Tokenize the text:",lt,le,nt,ne,Ft="M2M100 forces the target language id as the first generated token to translate to the target language. Set the <code>forced_bos_token_id</code> to <code>en</code> in the <code>generate</code> method to translate to English:",at,ae,st,se,it,ie,Ht="The following MBart models can be used for multilingual translation:",ot,oe,qt="<li><code>facebook/mbart-large-50-one-to-many-mmt</code> (One-to-many multilingual machine translation, 50 languages)</li> <li><code>facebook/mbart-large-50-many-to-many-mmt</code> (Many-to-many multilingual machine translation, 50 languages)</li> <li><code>facebook/mbart-large-50-many-to-one-mmt</code> (Many-to-one multilingual machine translation, 50 languages)</li> <li><code>facebook/mbart-large-50</code> (Multilingual translation, 50 languages)</li> <li><code>facebook/mbart-large-cc25</code></li>",mt,me,Qt="In this example, load the <code>facebook/mbart-large-50-many-to-many-mmt</code> checkpoint to translate Finnish to English. You can set the source language in the tokenizer:",gt,ge,pt,pe,Nt="Tokenize the text:",rt,re,ut,ue,Yt="MBart forces the target language id as the first generated token to translate to the target language. Set the <code>forced_bos_token_id</code> to <code>en</code> in the <code>generate</code> method to translate to English:",dt,de,ct,ce,Pt="If you are using the <code>facebook/mbart-large-50-many-to-one-mmt</code> checkpoint, you don’t need to force the target language id as the first generated token otherwise the usage is the same.",ht,fe,ft;return b=new M({props:{title:"Multilingual models for inference",local:"multilingual-models-for-inference",headingTag:"h1"}}),T=new al({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/multilingual.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/multilingual.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/multilingual.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/multilingual.ipynb"}]}}),J=new M({props:{title:"XLM",local:"xlm",headingTag:"h2"}}),w=new M({props:{title:"XLM with language embeddings",local:"xlm-with-language-embeddings",headingTag:"h3"}}),v=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwWExNVG9rZW5pemVyJTJDJTIwWExNV2l0aExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExNVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ4bG0tY2xtLWVuZnItMTAyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFhMTVdpdGhMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyeGxtLWNsbS1lbmZyLTEwMjQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLMTokenizer, XLMWithLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLMTokenizer.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = XLMWithLMHeadModel.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)`,wrap:!1}}),Z=new h({props:{code:"cHJpbnQodG9rZW5pemVyLmxhbmcyaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.lang2id)
{<span class="hljs-string">&#x27;en&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;fr&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),X=new h({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUoJTIyV2lraXBlZGlhJTIwd2FzJTIwdXNlZCUyMHRvJTIyKSU1RCklMjAlMjAlMjMlMjBiYXRjaCUyMHNpemUlMjBvZiUyMDE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(<span class="hljs-string">&quot;Wikipedia was used to&quot;</span>)])  <span class="hljs-comment"># batch size of 1</span>',wrap:!1}}),G=new h({props:{code:"bGFuZ3VhZ2VfaWQlMjAlM0QlMjB0b2tlbml6ZXIubGFuZzJpZCU1QiUyMmVuJTIyJTVEJTIwJTIwJTIzJTIwMCUwQWxhbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qmxhbmd1YWdlX2lkJTVEJTIwKiUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQpJTIwJTIwJTIzJTIwdG9yY2gudGVuc29yKCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMC4uLiUyQyUyMDAlNUQpJTBBJTBBJTIzJTIwV2UlMjByZXNoYXBlJTIwaXQlMjB0byUyMGJlJTIwb2YlMjBzaXplJTIwKGJhdGNoX3NpemUlMkMlMjBzZXF1ZW5jZV9sZW5ndGgpJTBBbGFuZ3MlMjAlM0QlMjBsYW5ncy52aWV3KDElMkMlMjAtMSklMjAlMjAlMjMlMjBpcyUyMG5vdyUyMG9mJTIwc2hhcGUlMjAlNUIxJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTVEJTIwKHdlJTIwaGF2ZSUyMGElMjBiYXRjaCUyMHNpemUlMjBvZiUyMDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>language_id = tokenizer.lang2id[<span class="hljs-string">&quot;en&quot;</span>]  <span class="hljs-comment"># 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = torch.tensor([language_id] * input_ids.shape[<span class="hljs-number">1</span>])  <span class="hljs-comment"># torch.tensor([0, 0, 0, ..., 0])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We reshape it to be of size (batch_size, sequence_length)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = langs.view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)  <span class="hljs-comment"># is now of shape [1, sequence_length] (we have a batch size of 1)</span>`,wrap:!1}}),R=new h({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhbmdzJTNEbGFuZ3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, langs=langs)',wrap:!1}}),L=new M({props:{title:"XLM without language embeddings",local:"xlm-without-language-embeddings",headingTag:"h3"}}),F=new M({props:{title:"BERT",local:"bert",headingTag:"h2"}}),N=new M({props:{title:"XLM-RoBERTa",local:"xlm-roberta",headingTag:"h2"}}),D=new M({props:{title:"M2M100",local:"m2m100",headingTag:"h2"}}),ee=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME0yTTEwMEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME0yTTEwMFRva2VuaXplciUwQSUwQWVuX3RleHQlMjAlM0QlMjAlMjJEbyUyMG5vdCUyMG1lZGRsZSUyMGluJTIwdGhlJTIwYWZmYWlycyUyMG9mJTIwd2l6YXJkcyUyQyUyMGZvciUyMHRoZXklMjBhcmUlMjBzdWJ0bGUlMjBhbmQlMjBxdWljayUyMHRvJTIwYW5nZXIuJTIyJTBBY2hpbmVzZV90ZXh0JTIwJTNEJTIwJTIyJUU0JUI4JThEJUU4JUE2JTgxJUU2JThGJTkyJUU2JTg5JThCJUU1JUI3JUFCJUU1JUI4JUFCJUU3JTlBJTg0JUU0JUJBJThCJUU1JThCJTk5JTJDJTIwJUU1JTlCJUEwJUU3JTgyJUJBJUU0JUJCJTk2JUU1JTgwJTkxJUU2JTk4JUFGJUU1JUJFJUFFJUU1JUE2JTk5JUU3JTlBJTg0JTJDJTIwJUU1JUJFJTg4JUU1JUJGJUFCJUU1JUIwJUIxJUU2JTlDJTgzJUU3JTk5JUJDJUU2JTgwJTkyLiUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyME0yTTEwMFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtMm0xMDBfNDE4TSUyMiUyQyUyMHNyY19sYW5nJTNEJTIyemglMjIpJTBBbW9kZWwlMjAlM0QlMjBNMk0xMDBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbTJtMTAwXzQxOE0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> M2M100ForConditionalGeneration, M2M100Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chinese_text = <span class="hljs-string">&quot;不要插手巫師的事務, 因為他們是微妙的, 很快就會發怒.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = M2M100Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>, src_lang=<span class="hljs-string">&quot;zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = M2M100ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>)`,wrap:!1}}),le=new h({props:{code:"ZW5jb2RlZF96aCUyMCUzRCUyMHRva2VuaXplcihjaGluZXNlX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_zh = tokenizer(chinese_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ae=new h({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF96aCUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZ2V0X2xhbmdfaWQoJTIyZW4lMjIpKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_zh, forced_bos_token_id=tokenizer.get_lang_id(<span class="hljs-string">&quot;en&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Do not interfere with the matters of the witches, because they are delicate and will soon be angry.&#x27;</span>`,wrap:!1}}),se=new M({props:{title:"MBart",local:"mbart",headingTag:"h2"}}),ge=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFlbl90ZXh0JTIwJTNEJTIwJTIyRG8lMjBub3QlMjBtZWRkbGUlMjBpbiUyMHRoZSUyMGFmZmFpcnMlMjBvZiUyMHdpemFyZHMlMkMlMjBmb3IlMjB0aGV5JTIwYXJlJTIwc3VidGxlJTIwYW5kJTIwcXVpY2slMjB0byUyMGFuZ2VyLiUyMiUwQWZpX3RleHQlMjAlM0QlMjAlMjIlQzMlODRsJUMzJUE0JTIwc2VrYWFubnUlMjB2ZWxob2plbiUyMGFzaW9paGluJTJDJTIwc2lsbCVDMyVBNCUyMG5lJTIwb3ZhdCUyMGhpZW5vdmFyYWlzaWElMjBqYSUyMG5vcGVhc3RpJTIwdmloYWlzaWEuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJmaV9GSSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fi_text = <span class="hljs-string">&quot;Älä sekaannu velhojen asioihin, sillä ne ovat hienovaraisia ja nopeasti vihaisia.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;fi_FI&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>)`,wrap:!1}}),re=new h({props:{code:"ZW5jb2RlZF9lbiUyMCUzRCUyMHRva2VuaXplcihlbl90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_en = tokenizer(en_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),de=new h({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF9lbiUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIubGFuZ19jb2RlX3RvX2lkJTVCJTIyZW5fWFglMjIlNUQpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_en, forced_bos_token_id=tokenizer.lang_code_to_id[<span class="hljs-string">&quot;en_XX&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Don&#x27;t interfere with the wizard&#x27;s affairs, because they are subtle, will soon get angry.&quot;</span>`,wrap:!1}}),{c(){f=i("meta"),Me=a(),he=i("p"),be=a(),g(b.$$.fragment),Te=a(),g(T.$$.fragment),ye=a(),y=i("p"),y.innerHTML=bt,Je=a(),g(J.$$.fragment),Ue=a(),U=i("p"),U.textContent=Tt,we=a(),g(w.$$.fragment),$e=a(),$=i("p"),$.textContent=yt,ke=a(),k=i("ul"),k.innerHTML=Jt,je=a(),j=i("p"),j.innerHTML=Ut,xe=a(),x=i("p"),x.innerHTML=wt,ve=a(),g(v.$$.fragment),Ce=a(),C=i("p"),C.innerHTML=$t,Ze=a(),g(Z.$$.fragment),_e=a(),_=i("p"),_.textContent=kt,Xe=a(),g(X.$$.fragment),Ie=a(),I=i("p"),I.innerHTML=jt,Ge=a(),g(G.$$.fragment),We=a(),W=i("p"),W.innerHTML=xt,Re=a(),g(R.$$.fragment),Ve=a(),V=i("p"),V.innerHTML=vt,Le=a(),g(L.$$.fragment),Be=a(),B=i("p"),B.textContent=Ct,ze=a(),z=i("ul"),z.innerHTML=Zt,Ee=a(),E=i("p"),E.textContent=_t,Fe=a(),g(F.$$.fragment),He=a(),H=i("p"),H.textContent=Xt,qe=a(),q=i("ul"),q.innerHTML=It,Qe=a(),Q=i("p"),Q.textContent=Gt,Ne=a(),g(N.$$.fragment),Ye=a(),Y=i("p"),Y.textContent=Wt,Pe=a(),P=i("ul"),P.innerHTML=Rt,Se=a(),S=i("p"),S.textContent=Vt,De=a(),g(D.$$.fragment),Ae=a(),A=i("p"),A.textContent=Lt,Ke=a(),K=i("ul"),K.innerHTML=Bt,Oe=a(),O=i("p"),O.innerHTML=zt,et=a(),g(ee.$$.fragment),tt=a(),te=i("p"),te.textContent=Et,lt=a(),g(le.$$.fragment),nt=a(),ne=i("p"),ne.innerHTML=Ft,at=a(),g(ae.$$.fragment),st=a(),g(se.$$.fragment),it=a(),ie=i("p"),ie.textContent=Ht,ot=a(),oe=i("ul"),oe.innerHTML=qt,mt=a(),me=i("p"),me.innerHTML=Qt,gt=a(),g(ge.$$.fragment),pt=a(),pe=i("p"),pe.textContent=Nt,rt=a(),g(re.$$.fragment),ut=a(),ue=i("p"),ue.innerHTML=Yt,dt=a(),g(de.$$.fragment),ct=a(),ce=i("p"),ce.innerHTML=Pt,ht=a(),fe=i("p"),this.h()},l(e){const t=ll("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(l),Me=s(e),he=o(e,"P",{}),St(he).forEach(l),be=s(e),p(b.$$.fragment,e),Te=s(e),p(T.$$.fragment,e),ye=s(e),y=o(e,"P",{"data-svelte-h":!0}),m(y)!=="svelte-esxaab"&&(y.innerHTML=bt),Je=s(e),p(J.$$.fragment,e),Ue=s(e),U=o(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-gat0c0"&&(U.textContent=Tt),we=s(e),p(w.$$.fragment,e),$e=s(e),$=o(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1rdjt2u"&&($.textContent=yt),ke=s(e),k=o(e,"UL",{"data-svelte-h":!0}),m(k)!=="svelte-1iu32ge"&&(k.innerHTML=Jt),je=s(e),j=o(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-etk90v"&&(j.innerHTML=Ut),xe=s(e),x=o(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1matafr"&&(x.innerHTML=wt),ve=s(e),p(v.$$.fragment,e),Ce=s(e),C=o(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-ncydbw"&&(C.innerHTML=$t),Ze=s(e),p(Z.$$.fragment,e),_e=s(e),_=o(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1a9p0ho"&&(_.textContent=kt),Xe=s(e),p(X.$$.fragment,e),Ie=s(e),I=o(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-vuczip"&&(I.innerHTML=jt),Ge=s(e),p(G.$$.fragment,e),We=s(e),W=o(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-v1jc9q"&&(W.innerHTML=xt),Re=s(e),p(R.$$.fragment,e),Ve=s(e),V=o(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-c53qag"&&(V.innerHTML=vt),Le=s(e),p(L.$$.fragment,e),Be=s(e),B=o(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1m6ccze"&&(B.textContent=Ct),ze=s(e),z=o(e,"UL",{"data-svelte-h":!0}),m(z)!=="svelte-qmf2p4"&&(z.innerHTML=Zt),Ee=s(e),E=o(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1fn4lmn"&&(E.textContent=_t),Fe=s(e),p(F.$$.fragment,e),He=s(e),H=o(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-ze8b37"&&(H.textContent=Xt),qe=s(e),q=o(e,"UL",{"data-svelte-h":!0}),m(q)!=="svelte-q5bq75"&&(q.innerHTML=It),Qe=s(e),Q=o(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1uvjv96"&&(Q.textContent=Gt),Ne=s(e),p(N.$$.fragment,e),Ye=s(e),Y=o(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-cq4taf"&&(Y.textContent=Wt),Pe=s(e),P=o(e,"UL",{"data-svelte-h":!0}),m(P)!=="svelte-1rac7bc"&&(P.innerHTML=Rt),Se=s(e),S=o(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1ahupcy"&&(S.textContent=Vt),De=s(e),p(D.$$.fragment,e),Ae=s(e),A=o(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1n18e2"&&(A.textContent=Lt),Ke=s(e),K=o(e,"UL",{"data-svelte-h":!0}),m(K)!=="svelte-xli8b1"&&(K.innerHTML=Bt),Oe=s(e),O=o(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1hz3ybz"&&(O.innerHTML=zt),et=s(e),p(ee.$$.fragment,e),tt=s(e),te=o(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1v7p0in"&&(te.textContent=Et),lt=s(e),p(le.$$.fragment,e),nt=s(e),ne=o(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-1t7zua3"&&(ne.innerHTML=Ft),at=s(e),p(ae.$$.fragment,e),st=s(e),p(se.$$.fragment,e),it=s(e),ie=o(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-1kinu1v"&&(ie.textContent=Ht),ot=s(e),oe=o(e,"UL",{"data-svelte-h":!0}),m(oe)!=="svelte-xa5lcq"&&(oe.innerHTML=qt),mt=s(e),me=o(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-aaduni"&&(me.innerHTML=Qt),gt=s(e),p(ge.$$.fragment,e),pt=s(e),pe=o(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-1v7p0in"&&(pe.textContent=Nt),rt=s(e),p(re.$$.fragment,e),ut=s(e),ue=o(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-1hdrcsc"&&(ue.innerHTML=Yt),dt=s(e),p(de.$$.fragment,e),ct=s(e),ce=o(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1la8qcj"&&(ce.innerHTML=Pt),ht=s(e),fe=o(e,"P",{}),St(fe).forEach(l),this.h()},h(){Dt(f,"name","hf:doc:metadata"),Dt(f,"content",il)},m(e,t){nl(document.head,f),n(e,Me,t),n(e,he,t),n(e,be,t),r(b,e,t),n(e,Te,t),r(T,e,t),n(e,ye,t),n(e,y,t),n(e,Je,t),r(J,e,t),n(e,Ue,t),n(e,U,t),n(e,we,t),r(w,e,t),n(e,$e,t),n(e,$,t),n(e,ke,t),n(e,k,t),n(e,je,t),n(e,j,t),n(e,xe,t),n(e,x,t),n(e,ve,t),r(v,e,t),n(e,Ce,t),n(e,C,t),n(e,Ze,t),r(Z,e,t),n(e,_e,t),n(e,_,t),n(e,Xe,t),r(X,e,t),n(e,Ie,t),n(e,I,t),n(e,Ge,t),r(G,e,t),n(e,We,t),n(e,W,t),n(e,Re,t),r(R,e,t),n(e,Ve,t),n(e,V,t),n(e,Le,t),r(L,e,t),n(e,Be,t),n(e,B,t),n(e,ze,t),n(e,z,t),n(e,Ee,t),n(e,E,t),n(e,Fe,t),r(F,e,t),n(e,He,t),n(e,H,t),n(e,qe,t),n(e,q,t),n(e,Qe,t),n(e,Q,t),n(e,Ne,t),r(N,e,t),n(e,Ye,t),n(e,Y,t),n(e,Pe,t),n(e,P,t),n(e,Se,t),n(e,S,t),n(e,De,t),r(D,e,t),n(e,Ae,t),n(e,A,t),n(e,Ke,t),n(e,K,t),n(e,Oe,t),n(e,O,t),n(e,et,t),r(ee,e,t),n(e,tt,t),n(e,te,t),n(e,lt,t),r(le,e,t),n(e,nt,t),n(e,ne,t),n(e,at,t),r(ae,e,t),n(e,st,t),r(se,e,t),n(e,it,t),n(e,ie,t),n(e,ot,t),n(e,oe,t),n(e,mt,t),n(e,me,t),n(e,gt,t),r(ge,e,t),n(e,pt,t),n(e,pe,t),n(e,rt,t),r(re,e,t),n(e,ut,t),n(e,ue,t),n(e,dt,t),r(de,e,t),n(e,ct,t),n(e,ce,t),n(e,ht,t),n(e,fe,t),ft=!0},p:Kt,i(e){ft||(u(b.$$.fragment,e),u(T.$$.fragment,e),u(J.$$.fragment,e),u(w.$$.fragment,e),u(v.$$.fragment,e),u(Z.$$.fragment,e),u(X.$$.fragment,e),u(G.$$.fragment,e),u(R.$$.fragment,e),u(L.$$.fragment,e),u(F.$$.fragment,e),u(N.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(se.$$.fragment,e),u(ge.$$.fragment,e),u(re.$$.fragment,e),u(de.$$.fragment,e),ft=!0)},o(e){d(b.$$.fragment,e),d(T.$$.fragment,e),d(J.$$.fragment,e),d(w.$$.fragment,e),d(v.$$.fragment,e),d(Z.$$.fragment,e),d(X.$$.fragment,e),d(G.$$.fragment,e),d(R.$$.fragment,e),d(L.$$.fragment,e),d(F.$$.fragment,e),d(N.$$.fragment,e),d(D.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),d(ge.$$.fragment,e),d(re.$$.fragment,e),d(de.$$.fragment,e),ft=!1},d(e){e&&(l(Me),l(he),l(be),l(Te),l(ye),l(y),l(Je),l(Ue),l(U),l(we),l($e),l($),l(ke),l(k),l(je),l(j),l(xe),l(x),l(ve),l(Ce),l(C),l(Ze),l(_e),l(_),l(Xe),l(Ie),l(I),l(Ge),l(We),l(W),l(Re),l(Ve),l(V),l(Le),l(Be),l(B),l(ze),l(z),l(Ee),l(E),l(Fe),l(He),l(H),l(qe),l(q),l(Qe),l(Q),l(Ne),l(Ye),l(Y),l(Pe),l(P),l(Se),l(S),l(De),l(Ae),l(A),l(Ke),l(K),l(Oe),l(O),l(et),l(tt),l(te),l(lt),l(nt),l(ne),l(at),l(st),l(it),l(ie),l(ot),l(oe),l(mt),l(me),l(gt),l(pt),l(pe),l(rt),l(ut),l(ue),l(dt),l(ct),l(ce),l(ht),l(fe)),l(f),c(b,e),c(T,e),c(J,e),c(w,e),c(v,e),c(Z,e),c(X,e),c(G,e),c(R,e),c(L,e),c(F,e),c(N,e),c(D,e),c(ee,e),c(le,e),c(ae,e),c(se,e),c(ge,e),c(re,e),c(de,e)}}}const il='{"title":"Multilingual models for inference","local":"multilingual-models-for-inference","sections":[{"title":"XLM","local":"xlm","sections":[{"title":"XLM with language embeddings","local":"xlm-with-language-embeddings","sections":[],"depth":3},{"title":"XLM without language embeddings","local":"xlm-without-language-embeddings","sections":[],"depth":3}],"depth":2},{"title":"BERT","local":"bert","sections":[],"depth":2},{"title":"XLM-RoBERTa","local":"xlm-roberta","sections":[],"depth":2},{"title":"M2M100","local":"m2m100","sections":[],"depth":2},{"title":"MBart","local":"mbart","sections":[],"depth":2}],"depth":1}';function ol(Mt){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dl extends el{constructor(f){super(),tl(this,f,ol,sl,At,{})}}export{dl as component};
