import{s as Nl,o as Yl,n as Ql}from"../chunks/scheduler.182ea377.js";import{S as Ll,i as zl,g as i,s as n,r as m,A as Dl,h as p,f as l,c as a,j as Hl,u as c,x as o,k as g,y as El,a as s,v as M,d as u,t as f,w as d}from"../chunks/index.abf12888.js";import{T as Rl}from"../chunks/Tip.230e2334.js";import{C as h}from"../chunks/CodeBlock.57fe6e13.js";import{H as I}from"../chunks/Heading.16916d63.js";function ql(xe){let r,j='Support for <code>fuse_qkv_projections()</code> is limited and experimental. As such, it’s not available for many non-SD pipelines such as <a href="../using-diffusers/kandinsky.md">Kandinsky</a>. You can refer to <a href="https://github.com/huggingface/diffusers/pull/6179" rel="nofollow">this PR</a> to get an idea about how to support this kind of computation.';return{c(){r=i("p"),r.innerHTML=j},l(y){r=p(y,"P",{"data-svelte-h":!0}),o(r)!=="svelte-izvj6c"&&(r.innerHTML=j)},m(y,b){s(y,r,b)},p:Ql,d(y){y&&l(r)}}}function Pl(xe){let r,j='Through experimentation, we found that certain linear layers in the UNet and the VAE don’t benefit from dynamic int8 quantization. You can check out the full code for filtering those layers <a href="https://github.com/huggingface/diffusion-fast/blob/0f169640b1db106fe6a479f78c1ed3bfaeba3386/utils/pipeline_utils.py#L16" rel="nofollow">here</a> (referred to as <code>dynamic_quant_filter_fn</code> below).';return{c(){r=i("p"),r.innerHTML=j},l(y){r=p(y,"P",{"data-svelte-h":!0}),o(r)!=="svelte-1xe2fym"&&(r.innerHTML=j)},m(y,b){s(y,r,b)},p:Ql,d(y){y&&l(r)}}}function Kl(xe){let r,j,y,b,G,Xe,$,Pt="Diffusion models are known to be slower than their counter parts, GANs, because of the iterative and sequential reverse diffusion process. Recent works try to address limitation with:",Se,B,Kt='<li>progressive timestep distillation (such as <a href="../using-diffusers/inference_with_lcm_lora.md">LCM LoRA</a>)</li> <li>model compression (such as <a href="https://huggingface.co/segmind/SSD-1B" rel="nofollow">SSD-1B</a>)</li> <li>reusing adjacent features of the denoiser (such as <a href="https://github.com/horseee/DeepCache" rel="nofollow">DeepCache</a>)</li>',Ve,k,Ot='In this tutorial, we focus on leveraging the power of PyTorch 2 to accelerate the inference latency of text-to-image diffusion pipeline, instead. We will use <a href="../using-diffusers/sdxl.md">Stable Diffusion XL (SDXL)</a> as a case study, but the techniques we will discuss should extend to other text-to-image diffusion pipelines.',Fe,A,He,x,el="Make sure you’re on the latest version of <code>diffusers</code>:",Re,W,Qe,X,tl="Then upgrade the other required libraries too:",Ne,S,Ye,V,ll='To benefit from the fastest kernels, use PyTorch nightly. You can find the installation instructions <a href="https://pytorch.org/" rel="nofollow">here</a>.',Le,F,sl="To report the numbers shown below, we used an 80GB 400W A100 with its clock rate set to the maximum.",ze,H,nl='<em>This tutorial doesn’t present the benchmarking code and focuses on how to perform the optimizations, instead. For the full benchmarking code, refer to: <a href="https://github.com/huggingface/diffusion-fast" rel="nofollow">https://github.com/huggingface/diffusion-fast</a>.</em>',De,R,Ee,Q,al='Let’s start with a baseline. Disable the use of a reduced precision and <a href="../optimization/torch2.0.md"><code>scaled_dot_product_attention</code></a>:',qe,N,Pe,Y,il="This takes 7.36 seconds:",Ke,w,pl='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_0.png" width="500"/>',Oe,L,et,z,ol="Enable the first optimization: use a reduced precision to run the inference.",tt,D,lt,E,rl="bfloat16 reduces the latency from 7.36 seconds to 4.63 seconds:",st,J,ml='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_1.png" width="500"/>',nt,q,cl="<strong>Why bfloat16?</strong>",at,P,Ml="<li>Using a reduced numerical precision (such as float16, bfloat16) to run inference doesn’t affect the generation quality but significantly improves latency.</li> <li>The benefits of using the bfloat16 numerical precision as compared to float16 are hardware-dependent. Modern generations of GPUs tend to favor bfloat16.</li> <li>Furthermore, in our experiments, we bfloat16 to be much more resilient when used with quantization in comparison to float16.</li>",it,K,ul='We have a <a href="../optimization/fp16.md">dedicated guide</a> for running inference in a reduced precision.',pt,O,ot,ee,fl='Attention blocks are intensive to run. But with PyTorch’s <a href="../optimization/torch2.0.md"><code>scaled_dot_product_attention</code></a>, we can run them efficiently.',rt,te,mt,le,dl="<code>scaled_dot_product_attention</code> improves the latency from 4.63 seconds to 3.31 seconds.",ct,T,yl='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_2.png" width="500"/>',Mt,se,ut,ne,hl="Compile the UNet and the VAE to benefit from the faster kernels. First, configure a few compiler flags:",ft,ae,dt,ie,jl='For the full list of compiler flags, refer to <a href="https://github.com/pytorch/pytorch/blob/main/torch/_inductor/config.py" rel="nofollow">this file</a>.',yt,pe,bl="It is also important to change the memory layout of the UNet and the VAE to “channels_last” when compiling them. This ensures maximum speed:",ht,oe,jt,re,wl="Then, compile and perform inference:",bt,me,wt,ce,Jl="<code>torch.compile</code> offers different backends and modes. As we’re aiming for maximum inference speed, we opt for the inductor backend using the “max-autotune”. “max-autotune” uses CUDA graphs and optimizes the compilation graph specifically for latency. Specifying fullgraph to be True ensures that there are no graph breaks in the underlying model, ensuring the fullest potential of <code>torch.compile</code>.",Jt,Me,Tl="Using SDPA attention and compiling both the UNet and VAE reduces the latency from 3.31 seconds to 2.54 seconds.",Tt,U,Ul='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_3.png" width="500"/>',Ut,ue,Ct,fe,Cl="Both the UNet and the VAE used in SDXL make use of Transformer-like blocks. A Transformer block consists of attention blocks and feed-forward blocks.",vt,de,vl="In an attention block, the input is projected into three sub-spaces using three different projection matrices – Q, K, and V. In the naive implementation, these projections are performed separately on the input. But we can horizontally combine the projection matrices into a single matrix and perform the projection in one shot. This increases the size of the matmuls of the input projections and improves the impact of quantization (to be discussed next).",_t,ye,_l="Enabling this kind of computation in Diffusers just takes a single line of code:",Zt,he,gt,je,Zl="It provides a minor boost from 2.54 seconds to 2.52 seconds.",It,C,gl='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_4.png" width="500"/>',Gt,v,$t,be,Bt,we,Il='Aapply <a href="https://pytorch.org/tutorials/recipes/recipes/dynamic_quantization.html" rel="nofollow">dynamic int8 quantization</a> to both the UNet and the VAE. This is because quantization adds additional conversion overhead to the model that is hopefully made up for by faster matmuls (dynamic quantization). If the matmuls are too small, these techniques may degrade performance.',kt,_,At,Je,Gl='You will leverage the ultra-lightweight pure PyTorch library <a href="https://github.com/pytorch-labs/ao" rel="nofollow">torchao</a> to use its user-friendly APIs for quantization.',xt,Te,$l="First, configure all the compiler tags:",Wt,Ue,Xt,Ce,Bl="Define the filtering functions:",St,ve,Vt,_e,kl="Then apply all the optimizations discussed so far:",Ft,Ze,Ht,ge,Al="Since this quantization support is limited to linear layers only, we also turn suitable pointwise convolution layers into linear layers to maximize the benefit.",Rt,Ie,Qt,Ge,xl="Apply dynamic quantization:",Nt,$e,Yt,Be,Wl="Finally, compile and perform inference:",Lt,ke,zt,Ae,Xl="Applying dynamic quantization improves the latency from 2.52 seconds to 2.43 seconds.",Dt,Z,Sl='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_5.png" width="500"/>',Et,We,qt;return G=new I({props:{title:"Accelerate inference of text-to-image diffusion models",local:"accelerate-inference-of-text-to-image-diffusion-models",headingTag:"h1"}}),A=new I({props:{title:"Setup",local:"setup",headingTag:"h2"}}),W=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZGlmZnVzZXJz",highlighted:"pip install -U diffusers",wrap:!1}}),S=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMHBlZnQ=",highlighted:"pip install -U transformers accelerate peft",wrap:!1}}),R=new I({props:{title:"Baseline",local:"baseline",headingTag:"h2"}}),N=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwcGlwZWxpbmUlMjBpbiUyMGZ1bGwtcHJlY2lzaW9uJTIwYW5kJTIwcGxhY2UlMjBpdHMlMjBtb2RlbCUyMGNvbXBvbmVudHMlMjBvbiUyMENVREEuJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUwQSkudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBSdW4lMjB0aGUlMjBhdHRlbnRpb24lMjBvcHMlMjB3aXRob3V0JTIwZWZmaWNpZW5jeS4lMEFwaXBlLnVuZXQuc2V0X2RlZmF1bHRfYXR0bl9wcm9jZXNzb3IoKSUwQXBpcGUudmFlLnNldF9kZWZhdWx0X2F0dG5fcHJvY2Vzc29yKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

<span class="hljs-comment"># Load the pipeline in full-precision and place its model components on CUDA.</span>
pipe = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Run the attention ops without efficiency.</span>
pipe.unet.set_default_attn_processor()
pipe.vae.set_default_attn_processor()

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),L=new I({props:{title:"Running inference in bfloat16",local:"running-inference-in-bfloat16",headingTag:"h2"}}),D=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMDklMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMFJ1biUyMHRoZSUyMGF0dGVudGlvbiUyMG9wcyUyMHdpdGhvdXQlMjBlZmZpY2llbmN5LiUwQXBpcGUudW5ldC5zZXRfZGVmYXVsdF9hdHRuX3Byb2Nlc3NvcigpJTBBcGlwZS52YWUuc2V0X2RlZmF1bHRfYXR0bl9wcm9jZXNzb3IoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

pipe = StableDiffusionXLPipeline.from_pretrained(
	<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Run the attention ops without efficiency.</span>
pipe.unet.set_default_attn_processor()
pipe.vae.set_default_attn_processor()

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),O=new I({props:{title:"Running attention efficiently",local:"running-attention-efficiently",headingTag:"h2"}}),te=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMDklMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

pipe = StableDiffusionXLPipeline.from_pretrained(
	<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),se=new I({props:{title:"Use faster kernels with torch.compile",local:"use-faster-kernels-with-torchcompile",headingTag:"h2"}}),ae=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuY29udl8xeDFfYXNfbW0lMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5jb29yZGluYXRlX2Rlc2NlbnRfdHVuaW5nJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuZXBpbG9ndWVfZnVzaW9uJTIwJTNEJTIwRmFsc2UlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmNvb3JkaW5hdGVfZGVzY2VudF9jaGVja19hbGxfZGlyZWN0aW9ucyUyMCUzRCUyMFRydWU=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

torch._inductor.config.conv_1x1_as_mm = <span class="hljs-literal">True</span>
torch._inductor.config.coordinate_descent_tuning = <span class="hljs-literal">True</span>
torch._inductor.config.epilogue_fusion = <span class="hljs-literal">False</span>
torch._inductor.config.coordinate_descent_check_all_directions = <span class="hljs-literal">True</span>`,wrap:!1}}),oe=new h({props:{code:"cGlwZS51bmV0LnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KSUwQXBpcGUudmFlLnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KQ==",highlighted:`pipe.unet.to(memory_format=torch.channels_last)
pipe.vae.to(memory_format=torch.channels_last)`,wrap:!1}}),me=new h({props:{code:"JTIzJTIwQ29tcGlsZSUyMHRoZSUyMFVOZXQlMjBhbmQlMjBWQUUuJTBBcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEFwaXBlLnZhZS5kZWNvZGUlMjAlM0QlMjB0b3JjaC5jb21waWxlKHBpcGUudmFlLmRlY29kZSUyQyUyMG1vZGUlM0QlMjJtYXgtYXV0b3R1bmUlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEElMEElMjMlMjBGaXJzdCUyMGNhbGwlMjB0byUyMCU2MHBpcGUlNjAlMjB3aWxsJTIwYmUlMjBzbG93JTJDJTIwc3Vic2VxdWVudCUyMG9uZXMlMjB3aWxsJTIwYmUlMjBmYXN0ZXIuJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-comment"># Compile the UNet and VAE.</span>
pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipe.vae.decode = torch.<span class="hljs-built_in">compile</span>(pipe.vae.decode, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># First call to \`pipe\` will be slow, subsequent ones will be faster.</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ue=new I({props:{title:"Combine the projection matrices of attention",local:"combine-the-projection-matrices-of-attention",headingTag:"h2"}}),he=new h({props:{code:"cGlwZS5mdXNlX3Frdl9wcm9qZWN0aW9ucygp",highlighted:"pipe.fuse_qkv_projections()",wrap:!1}}),v=new Rl({props:{warning:!0,$$slots:{default:[ql]},$$scope:{ctx:xe}}}),be=new I({props:{title:"Dynamic quantization",local:"dynamic-quantization",headingTag:"h2"}}),_=new Rl({props:{$$slots:{default:[Pl]},$$scope:{ctx:xe}}}),Ue=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUyMCUwQSUwQSUyMyUyME5vdGljZSUyMHRoZSUyMHR3byUyMG5ldyUyMGZsYWdzJTIwYXQlMjB0aGUlMjBlbmQuJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5jb252XzF4MV9hc19tbSUyMCUzRCUyMFRydWUlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmNvb3JkaW5hdGVfZGVzY2VudF90dW5pbmclMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5lcGlsb2d1ZV9mdXNpb24lMjAlM0QlMjBGYWxzZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuY29vcmRpbmF0ZV9kZXNjZW50X2NoZWNrX2FsbF9kaXJlY3Rpb25zJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuZm9yY2VfZnVzZV9pbnRfbW1fd2l0aF9tdWwlMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy51c2VfbWl4ZWRfbW0lMjAlM0QlMjBUcnVl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch 

<span class="hljs-comment"># Notice the two new flags at the end.</span>
torch._inductor.config.conv_1x1_as_mm = <span class="hljs-literal">True</span>
torch._inductor.config.coordinate_descent_tuning = <span class="hljs-literal">True</span>
torch._inductor.config.epilogue_fusion = <span class="hljs-literal">False</span>
torch._inductor.config.coordinate_descent_check_all_directions = <span class="hljs-literal">True</span>
torch._inductor.config.force_fuse_int_mm_with_mul = <span class="hljs-literal">True</span>
torch._inductor.config.use_mixed_mm = <span class="hljs-literal">True</span>`,wrap:!1}}),ve=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">dynamic_quant_filter_fn</span>(<span class="hljs-params">mod, *args</span>):
    <span class="hljs-keyword">return</span> (
        <span class="hljs-built_in">isinstance</span>(mod, torch.nn.Linear)
        <span class="hljs-keyword">and</span> mod.in_features &gt; <span class="hljs-number">16</span>
        <span class="hljs-keyword">and</span> (mod.in_features, mod.out_features)
        <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [
            (<span class="hljs-number">1280</span>, <span class="hljs-number">640</span>),
            (<span class="hljs-number">1920</span>, <span class="hljs-number">1280</span>),
            (<span class="hljs-number">1920</span>, <span class="hljs-number">640</span>),
            (<span class="hljs-number">2048</span>, <span class="hljs-number">1280</span>),
            (<span class="hljs-number">2048</span>, <span class="hljs-number">2560</span>),
            (<span class="hljs-number">2560</span>, <span class="hljs-number">1280</span>),
            (<span class="hljs-number">256</span>, <span class="hljs-number">128</span>),
            (<span class="hljs-number">2816</span>, <span class="hljs-number">1280</span>),
            (<span class="hljs-number">320</span>, <span class="hljs-number">640</span>),
            (<span class="hljs-number">512</span>, <span class="hljs-number">1536</span>),
            (<span class="hljs-number">512</span>, <span class="hljs-number">256</span>),
            (<span class="hljs-number">512</span>, <span class="hljs-number">512</span>),
            (<span class="hljs-number">640</span>, <span class="hljs-number">1280</span>),
            (<span class="hljs-number">640</span>, <span class="hljs-number">1920</span>),
            (<span class="hljs-number">640</span>, <span class="hljs-number">320</span>),
            (<span class="hljs-number">640</span>, <span class="hljs-number">5120</span>),
            (<span class="hljs-number">640</span>, <span class="hljs-number">640</span>),
            (<span class="hljs-number">960</span>, <span class="hljs-number">320</span>),
            (<span class="hljs-number">960</span>, <span class="hljs-number">640</span>),
        ]
    )


<span class="hljs-keyword">def</span> <span class="hljs-title function_">conv_filter_fn</span>(<span class="hljs-params">mod, *args</span>):
    <span class="hljs-keyword">return</span> (
        <span class="hljs-built_in">isinstance</span>(mod, torch.nn.Conv2d) <span class="hljs-keyword">and</span> mod.kernel_size == (<span class="hljs-number">1</span>, <span class="hljs-number">1</span>) <span class="hljs-keyword">and</span> <span class="hljs-number">128</span> <span class="hljs-keyword">in</span> [mod.in_channels, mod.out_channels]
    )`,wrap:!1}}),Ze=new h({props:{code:"JTIzJTIwU0RQQSUyMCUyQiUyMGJmbG9hdDE2LiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMDklMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMENvbWJpbmUlMjBhdHRlbnRpb24lMjBwcm9qZWN0aW9uJTIwbWF0cmljZXMuJTBBcGlwZS5mdXNlX3Frdl9wcm9qZWN0aW9ucygpJTBBJTBBJTIzJTIwQ2hhbmdlJTIwdGhlJTIwbWVtb3J5JTIwbGF5b3V0LiUwQXBpcGUudW5ldC50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEFwaXBlLnZhZS50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCk=",highlighted:`<span class="hljs-comment"># SDPA + bfloat16.</span>
pipe = StableDiffusionXLPipeline.from_pretrained(
	<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Combine attention projection matrices.</span>
pipe.fuse_qkv_projections()

<span class="hljs-comment"># Change the memory layout.</span>
pipe.unet.to(memory_format=torch.channels_last)
pipe.vae.to(memory_format=torch.channels_last)`,wrap:!1}}),Ie=new h({props:{code:"ZnJvbSUyMHRvcmNoYW8lMjBpbXBvcnQlMjBzd2FwX2NvbnYyZF8xeDFfdG9fbGluZWFyJTBBJTBBc3dhcF9jb252MmRfMXgxX3RvX2xpbmVhcihwaXBlLnVuZXQlMkMlMjBjb252X2ZpbHRlcl9mbiklMEFzd2FwX2NvbnYyZF8xeDFfdG9fbGluZWFyKHBpcGUudmFlJTJDJTIwY29udl9maWx0ZXJfZm4p",highlighted:`<span class="hljs-keyword">from</span> torchao <span class="hljs-keyword">import</span> swap_conv2d_1x1_to_linear

swap_conv2d_1x1_to_linear(pipe.unet, conv_filter_fn)
swap_conv2d_1x1_to_linear(pipe.vae, conv_filter_fn)`,wrap:!1}}),$e=new h({props:{code:"ZnJvbSUyMHRvcmNoYW8lMjBpbXBvcnQlMjBhcHBseV9keW5hbWljX3F1YW50JTBBJTBBYXBwbHlfZHluYW1pY19xdWFudChwaXBlLnVuZXQlMkMlMjBkeW5hbWljX3F1YW50X2ZpbHRlcl9mbiklMEFhcHBseV9keW5hbWljX3F1YW50KHBpcGUudmFlJTJDJTIwZHluYW1pY19xdWFudF9maWx0ZXJfZm4p",highlighted:`<span class="hljs-keyword">from</span> torchao <span class="hljs-keyword">import</span> apply_dynamic_quant

apply_dynamic_quant(pipe.unet, dynamic_quant_filter_fn)
apply_dynamic_quant(pipe.vae, dynamic_quant_filter_fn)`,wrap:!1}}),ke=new h({props:{code:"cGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEFwaXBlLnZhZS5kZWNvZGUlMjAlM0QlMjB0b3JjaC5jb21waWxlKHBpcGUudmFlLmRlY29kZSUyQyUyMG1vZGUlM0QlMjJtYXgtYXV0b3R1bmUlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwKS5pbWFnZXMlNUIwJTVE",highlighted:`pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipe.vae.decode = torch.<span class="hljs-built_in">compile</span>(pipe.vae.decode, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){r=i("meta"),j=n(),y=i("p"),b=n(),m(G.$$.fragment),Xe=n(),$=i("p"),$.textContent=Pt,Se=n(),B=i("ul"),B.innerHTML=Kt,Ve=n(),k=i("p"),k.innerHTML=Ot,Fe=n(),m(A.$$.fragment),He=n(),x=i("p"),x.innerHTML=el,Re=n(),m(W.$$.fragment),Qe=n(),X=i("p"),X.textContent=tl,Ne=n(),m(S.$$.fragment),Ye=n(),V=i("p"),V.innerHTML=ll,Le=n(),F=i("p"),F.textContent=sl,ze=n(),H=i("p"),H.innerHTML=nl,De=n(),m(R.$$.fragment),Ee=n(),Q=i("p"),Q.innerHTML=al,qe=n(),m(N.$$.fragment),Pe=n(),Y=i("p"),Y.textContent=il,Ke=n(),w=i("div"),w.innerHTML=pl,Oe=n(),m(L.$$.fragment),et=n(),z=i("p"),z.textContent=ol,tt=n(),m(D.$$.fragment),lt=n(),E=i("p"),E.textContent=rl,st=n(),J=i("div"),J.innerHTML=ml,nt=n(),q=i("p"),q.innerHTML=cl,at=n(),P=i("ul"),P.innerHTML=Ml,it=n(),K=i("p"),K.innerHTML=ul,pt=n(),m(O.$$.fragment),ot=n(),ee=i("p"),ee.innerHTML=fl,rt=n(),m(te.$$.fragment),mt=n(),le=i("p"),le.innerHTML=dl,ct=n(),T=i("div"),T.innerHTML=yl,Mt=n(),m(se.$$.fragment),ut=n(),ne=i("p"),ne.textContent=hl,ft=n(),m(ae.$$.fragment),dt=n(),ie=i("p"),ie.innerHTML=jl,yt=n(),pe=i("p"),pe.textContent=bl,ht=n(),m(oe.$$.fragment),jt=n(),re=i("p"),re.textContent=wl,bt=n(),m(me.$$.fragment),wt=n(),ce=i("p"),ce.innerHTML=Jl,Jt=n(),Me=i("p"),Me.textContent=Tl,Tt=n(),U=i("div"),U.innerHTML=Ul,Ut=n(),m(ue.$$.fragment),Ct=n(),fe=i("p"),fe.textContent=Cl,vt=n(),de=i("p"),de.textContent=vl,_t=n(),ye=i("p"),ye.textContent=_l,Zt=n(),m(he.$$.fragment),gt=n(),je=i("p"),je.textContent=Zl,It=n(),C=i("div"),C.innerHTML=gl,Gt=n(),m(v.$$.fragment),$t=n(),m(be.$$.fragment),Bt=n(),we=i("p"),we.innerHTML=Il,kt=n(),m(_.$$.fragment),At=n(),Je=i("p"),Je.innerHTML=Gl,xt=n(),Te=i("p"),Te.textContent=$l,Wt=n(),m(Ue.$$.fragment),Xt=n(),Ce=i("p"),Ce.textContent=Bl,St=n(),m(ve.$$.fragment),Vt=n(),_e=i("p"),_e.textContent=kl,Ft=n(),m(Ze.$$.fragment),Ht=n(),ge=i("p"),ge.textContent=Al,Rt=n(),m(Ie.$$.fragment),Qt=n(),Ge=i("p"),Ge.textContent=xl,Nt=n(),m($e.$$.fragment),Yt=n(),Be=i("p"),Be.textContent=Wl,Lt=n(),m(ke.$$.fragment),zt=n(),Ae=i("p"),Ae.textContent=Xl,Dt=n(),Z=i("div"),Z.innerHTML=Sl,Et=n(),We=i("p"),this.h()},l(e){const t=Dl("svelte-u9bgzb",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(l),j=a(e),y=p(e,"P",{}),Hl(y).forEach(l),b=a(e),c(G.$$.fragment,e),Xe=a(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-pkpiyo"&&($.textContent=Pt),Se=a(e),B=p(e,"UL",{"data-svelte-h":!0}),o(B)!=="svelte-1n3ja6f"&&(B.innerHTML=Kt),Ve=a(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1ahq65p"&&(k.innerHTML=Ot),Fe=a(e),c(A.$$.fragment,e),He=a(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-609t4e"&&(x.innerHTML=el),Re=a(e),c(W.$$.fragment,e),Qe=a(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1s5viqc"&&(X.textContent=tl),Ne=a(e),c(S.$$.fragment,e),Ye=a(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-2y23yy"&&(V.innerHTML=ll),Le=a(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-zfizj4"&&(F.textContent=sl),ze=a(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-teht3n"&&(H.innerHTML=nl),De=a(e),c(R.$$.fragment,e),Ee=a(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-zqipth"&&(Q.innerHTML=al),qe=a(e),c(N.$$.fragment,e),Pe=a(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1x1lehr"&&(Y.textContent=il),Ke=a(e),w=p(e,"DIV",{align:!0,"data-svelte-h":!0}),o(w)!=="svelte-1do855s"&&(w.innerHTML=pl),Oe=a(e),c(L.$$.fragment,e),et=a(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-59kzwp"&&(z.textContent=ol),tt=a(e),c(D.$$.fragment,e),lt=a(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1kdjw5n"&&(E.textContent=rl),st=a(e),J=p(e,"DIV",{align:!0,"data-svelte-h":!0}),o(J)!=="svelte-lxnqqr"&&(J.innerHTML=ml),nt=a(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-17gxfqr"&&(q.innerHTML=cl),at=a(e),P=p(e,"UL",{"data-svelte-h":!0}),o(P)!=="svelte-eu6tje"&&(P.innerHTML=Ml),it=a(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-ezaz6j"&&(K.innerHTML=ul),pt=a(e),c(O.$$.fragment,e),ot=a(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-i6cij5"&&(ee.innerHTML=fl),rt=a(e),c(te.$$.fragment,e),mt=a(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1ya4pwz"&&(le.innerHTML=dl),ct=a(e),T=p(e,"DIV",{align:!0,"data-svelte-h":!0}),o(T)!=="svelte-1vt8crq"&&(T.innerHTML=yl),Mt=a(e),c(se.$$.fragment,e),ut=a(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-125vukj"&&(ne.textContent=hl),ft=a(e),c(ae.$$.fragment,e),dt=a(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-wn8tu2"&&(ie.innerHTML=jl),yt=a(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1xhp6zo"&&(pe.textContent=bl),ht=a(e),c(oe.$$.fragment,e),jt=a(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1huthp1"&&(re.textContent=wl),bt=a(e),c(me.$$.fragment,e),wt=a(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1r146mn"&&(ce.innerHTML=Jl),Jt=a(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-ax8e93"&&(Me.textContent=Tl),Tt=a(e),U=p(e,"DIV",{align:!0,"data-svelte-h":!0}),o(U)!=="svelte-h7n375"&&(U.innerHTML=Ul),Ut=a(e),c(ue.$$.fragment,e),Ct=a(e),fe=p(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1ok923t"&&(fe.textContent=Cl),vt=a(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1vgoh8g"&&(de.textContent=vl),_t=a(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1g4675p"&&(ye.textContent=_l),Zt=a(e),c(he.$$.fragment,e),gt=a(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1ip60rj"&&(je.textContent=Zl),It=a(e),C=p(e,"DIV",{align:!0,"data-svelte-h":!0}),o(C)!=="svelte-bdlltg"&&(C.innerHTML=gl),Gt=a(e),c(v.$$.fragment,e),$t=a(e),c(be.$$.fragment,e),Bt=a(e),we=p(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-k2whf5"&&(we.innerHTML=Il),kt=a(e),c(_.$$.fragment,e),At=a(e),Je=p(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-mctow8"&&(Je.innerHTML=Gl),xt=a(e),Te=p(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-gvi9jq"&&(Te.textContent=$l),Wt=a(e),c(Ue.$$.fragment,e),Xt=a(e),Ce=p(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-tgt4ub"&&(Ce.textContent=Bl),St=a(e),c(ve.$$.fragment,e),Vt=a(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-1848xq7"&&(_e.textContent=kl),Ft=a(e),c(Ze.$$.fragment,e),Ht=a(e),ge=p(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1nbn6cl"&&(ge.textContent=Al),Rt=a(e),c(Ie.$$.fragment,e),Qt=a(e),Ge=p(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-13vdbpw"&&(Ge.textContent=xl),Nt=a(e),c($e.$$.fragment,e),Yt=a(e),Be=p(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-145l8jb"&&(Be.textContent=Wl),Lt=a(e),c(ke.$$.fragment,e),zt=a(e),Ae=p(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-od9x3v"&&(Ae.textContent=Xl),Dt=a(e),Z=p(e,"DIV",{align:!0,"data-svelte-h":!0}),o(Z)!=="svelte-j96t4n"&&(Z.innerHTML=Sl),Et=a(e),We=p(e,"P",{}),Hl(We).forEach(l),this.h()},h(){g(r,"name","hf:doc:metadata"),g(r,"content",Ol),g(w,"align","center"),g(J,"align","center"),g(T,"align","center"),g(U,"align","center"),g(C,"align","center"),g(Z,"align","center")},m(e,t){El(document.head,r),s(e,j,t),s(e,y,t),s(e,b,t),M(G,e,t),s(e,Xe,t),s(e,$,t),s(e,Se,t),s(e,B,t),s(e,Ve,t),s(e,k,t),s(e,Fe,t),M(A,e,t),s(e,He,t),s(e,x,t),s(e,Re,t),M(W,e,t),s(e,Qe,t),s(e,X,t),s(e,Ne,t),M(S,e,t),s(e,Ye,t),s(e,V,t),s(e,Le,t),s(e,F,t),s(e,ze,t),s(e,H,t),s(e,De,t),M(R,e,t),s(e,Ee,t),s(e,Q,t),s(e,qe,t),M(N,e,t),s(e,Pe,t),s(e,Y,t),s(e,Ke,t),s(e,w,t),s(e,Oe,t),M(L,e,t),s(e,et,t),s(e,z,t),s(e,tt,t),M(D,e,t),s(e,lt,t),s(e,E,t),s(e,st,t),s(e,J,t),s(e,nt,t),s(e,q,t),s(e,at,t),s(e,P,t),s(e,it,t),s(e,K,t),s(e,pt,t),M(O,e,t),s(e,ot,t),s(e,ee,t),s(e,rt,t),M(te,e,t),s(e,mt,t),s(e,le,t),s(e,ct,t),s(e,T,t),s(e,Mt,t),M(se,e,t),s(e,ut,t),s(e,ne,t),s(e,ft,t),M(ae,e,t),s(e,dt,t),s(e,ie,t),s(e,yt,t),s(e,pe,t),s(e,ht,t),M(oe,e,t),s(e,jt,t),s(e,re,t),s(e,bt,t),M(me,e,t),s(e,wt,t),s(e,ce,t),s(e,Jt,t),s(e,Me,t),s(e,Tt,t),s(e,U,t),s(e,Ut,t),M(ue,e,t),s(e,Ct,t),s(e,fe,t),s(e,vt,t),s(e,de,t),s(e,_t,t),s(e,ye,t),s(e,Zt,t),M(he,e,t),s(e,gt,t),s(e,je,t),s(e,It,t),s(e,C,t),s(e,Gt,t),M(v,e,t),s(e,$t,t),M(be,e,t),s(e,Bt,t),s(e,we,t),s(e,kt,t),M(_,e,t),s(e,At,t),s(e,Je,t),s(e,xt,t),s(e,Te,t),s(e,Wt,t),M(Ue,e,t),s(e,Xt,t),s(e,Ce,t),s(e,St,t),M(ve,e,t),s(e,Vt,t),s(e,_e,t),s(e,Ft,t),M(Ze,e,t),s(e,Ht,t),s(e,ge,t),s(e,Rt,t),M(Ie,e,t),s(e,Qt,t),s(e,Ge,t),s(e,Nt,t),M($e,e,t),s(e,Yt,t),s(e,Be,t),s(e,Lt,t),M(ke,e,t),s(e,zt,t),s(e,Ae,t),s(e,Dt,t),s(e,Z,t),s(e,Et,t),s(e,We,t),qt=!0},p(e,[t]){const Vl={};t&2&&(Vl.$$scope={dirty:t,ctx:e}),v.$set(Vl);const Fl={};t&2&&(Fl.$$scope={dirty:t,ctx:e}),_.$set(Fl)},i(e){qt||(u(G.$$.fragment,e),u(A.$$.fragment,e),u(W.$$.fragment,e),u(S.$$.fragment,e),u(R.$$.fragment,e),u(N.$$.fragment,e),u(L.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(me.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(v.$$.fragment,e),u(be.$$.fragment,e),u(_.$$.fragment,e),u(Ue.$$.fragment,e),u(ve.$$.fragment,e),u(Ze.$$.fragment,e),u(Ie.$$.fragment,e),u($e.$$.fragment,e),u(ke.$$.fragment,e),qt=!0)},o(e){f(G.$$.fragment,e),f(A.$$.fragment,e),f(W.$$.fragment,e),f(S.$$.fragment,e),f(R.$$.fragment,e),f(N.$$.fragment,e),f(L.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(se.$$.fragment,e),f(ae.$$.fragment,e),f(oe.$$.fragment,e),f(me.$$.fragment,e),f(ue.$$.fragment,e),f(he.$$.fragment,e),f(v.$$.fragment,e),f(be.$$.fragment,e),f(_.$$.fragment,e),f(Ue.$$.fragment,e),f(ve.$$.fragment,e),f(Ze.$$.fragment,e),f(Ie.$$.fragment,e),f($e.$$.fragment,e),f(ke.$$.fragment,e),qt=!1},d(e){e&&(l(j),l(y),l(b),l(Xe),l($),l(Se),l(B),l(Ve),l(k),l(Fe),l(He),l(x),l(Re),l(Qe),l(X),l(Ne),l(Ye),l(V),l(Le),l(F),l(ze),l(H),l(De),l(Ee),l(Q),l(qe),l(Pe),l(Y),l(Ke),l(w),l(Oe),l(et),l(z),l(tt),l(lt),l(E),l(st),l(J),l(nt),l(q),l(at),l(P),l(it),l(K),l(pt),l(ot),l(ee),l(rt),l(mt),l(le),l(ct),l(T),l(Mt),l(ut),l(ne),l(ft),l(dt),l(ie),l(yt),l(pe),l(ht),l(jt),l(re),l(bt),l(wt),l(ce),l(Jt),l(Me),l(Tt),l(U),l(Ut),l(Ct),l(fe),l(vt),l(de),l(_t),l(ye),l(Zt),l(gt),l(je),l(It),l(C),l(Gt),l($t),l(Bt),l(we),l(kt),l(At),l(Je),l(xt),l(Te),l(Wt),l(Xt),l(Ce),l(St),l(Vt),l(_e),l(Ft),l(Ht),l(ge),l(Rt),l(Qt),l(Ge),l(Nt),l(Yt),l(Be),l(Lt),l(zt),l(Ae),l(Dt),l(Z),l(Et),l(We)),l(r),d(G,e),d(A,e),d(W,e),d(S,e),d(R,e),d(N,e),d(L,e),d(D,e),d(O,e),d(te,e),d(se,e),d(ae,e),d(oe,e),d(me,e),d(ue,e),d(he,e),d(v,e),d(be,e),d(_,e),d(Ue,e),d(ve,e),d(Ze,e),d(Ie,e),d($e,e),d(ke,e)}}}const Ol='{"title":"Accelerate inference of text-to-image diffusion models","local":"accelerate-inference-of-text-to-image-diffusion-models","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Baseline","local":"baseline","sections":[],"depth":2},{"title":"Running inference in bfloat16","local":"running-inference-in-bfloat16","sections":[],"depth":2},{"title":"Running attention efficiently","local":"running-attention-efficiently","sections":[],"depth":2},{"title":"Use faster kernels with torch.compile","local":"use-faster-kernels-with-torchcompile","sections":[],"depth":2},{"title":"Combine the projection matrices of attention","local":"combine-the-projection-matrices-of-attention","sections":[],"depth":2},{"title":"Dynamic quantization","local":"dynamic-quantization","sections":[],"depth":2}],"depth":1}';function es(xe){return Yl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class is extends Ll{constructor(r){super(),zl(this,r,es,Kl,Nl,{})}}export{is as component};
