import{s as Ee,o as ke,n as Ie}from"../chunks/scheduler.182ea377.js";import{S as je,i as He,g as o,s as i,p as P,A as Pe,h as l,f as t,c as p,j as y,q as S,m,k as h,v as c,a as s,r as G,d as Z,t as L,u as W}from"../chunks/index.008d68e4.js";import{T as Ce}from"../chunks/Tip.4f096367.js";import{I as fe}from"../chunks/IconCopyLink.96bbb92b.js";import{C as Ue}from"../chunks/CodeBlock.5ed6eb7b.js";function Se(B){let a,d='In many cases, optimizing for speed or memory leads to improved performance in the other, so you should try to optimize for both whenever you can. This guide focuses on inference speed, but you can learn more about preserving memory in the <a href="memory">Reduce memory usage</a> guide.';return{c(){a=o("p"),a.innerHTML=d},l(r){a=l(r,"P",{"data-svelte-h":!0}),m(a)!=="svelte-1dpd5a8"&&(a.innerHTML=d)},m(r,f){s(r,a,f)},p:Ie,d(r){r&&t(a)}}}function Ge(B){let a,d='Don’t use <a href="https://pytorch.org/docs/stable/amp.html#torch.autocast" rel="nofollow"><code>torch.autocast</code></a> in any of the pipelines as it can lead to black images and is always slower than pure float16 precision.';return{c(){a=o("p"),a.innerHTML=d},l(r){a=l(r,"P",{"data-svelte-h":!0}),m(a)!=="svelte-19ow5yd"&&(a.innerHTML=d)},m(r,f){s(r,a,f)},p:Ie,d(r){r&&t(a)}}}function Ze(B){let a,d,r,f,R,b,pe,N,me="Speed up inference",X,_,de='There are several ways to optimize 🤗 Diffusers for inference speed. As a general rule of thumb, we recommend using either <a href="xformers">xFormers</a> or <code>torch.nn.functional.scaled_dot_product_attention</code> in PyTorch 2.0 for their memory-efficient attention.',q,v,Q,J,ue="The results below are obtained from generating a single 512x512 image from the prompt <code>a photo of an astronaut riding a horse on mars</code> with 50 DDIM steps on a Nvidia Titan RTX, demonstrating the speed-up you can expect.",Y,M,we="<thead><tr><th></th> <th>latency</th> <th>speed-up</th></tr></thead> <tbody><tr><td>original</td> <td>9.50s</td> <td>x1</td></tr> <tr><td>fp16</td> <td>3.61s</td> <td>x2.63</td></tr> <tr><td>channels last</td> <td>3.30s</td> <td>x2.88</td></tr> <tr><td>traced UNet</td> <td>3.21s</td> <td>x2.96</td></tr> <tr><td>memory efficient attention</td> <td>2.63s</td> <td>x3.61</td></tr></tbody>",K,u,g,z,x,he,F,ye="Use TensorFloat-32",O,C,ve='On Ampere and later CUDA devices, matrix multiplications and convolutions can use the <a href="https://blogs.nvidia.com/blog/2020/05/14/tensorfloat-32-precision-format/" rel="nofollow">TensorFloat-32 (TF32)</a> mode for faster, but slightly less accurate computations. By default, PyTorch enables TF32 mode for convolutions but not matrix multiplications. Unless your network requires full float32 precision, we recommend enabling TF32 for matrix multiplications. It can significantly speeds up computations with typically negligible loss in numerical accuracy.',ee,U,te,I,ge='You can learn more about TF32 in the <a href="https://huggingface.co/docs/transformers/en/perf_train_gpu_one#tf32" rel="nofollow">Mixed precision training</a> guide.',ne,w,$,D,E,ce,A,$e="Half-precision weights",ae,k,Te="To save GPU memory and get more speed, try loading and running the model weights directly in half-precision or float16:",se,j,re,T,oe;return b=new fe({}),v=new Ce({props:{$$slots:{default:[Se]},$$scope:{ctx:B}}}),x=new fe({}),U=new Ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF0b3JjaC5iYWNrZW5kcy5jdWRhLm1hdG11bC5hbGxvd190ZjMyJTIwJTNEJTIwVHJ1ZQ==",highlighted:`<span class="hljs-keyword">import</span> torch

torch.backends.cuda.matmul.allow_tf32 = <span class="hljs-literal">True</span>`}}),E=new fe({}),j=new Ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
image = pipe(prompt).images[<span class="hljs-number">0</span>]`}}),T=new Ce({props:{warning:!0,$$slots:{default:[Ge]},$$scope:{ctx:B}}}),{c(){a=o("meta"),d=i(),r=o("h1"),f=o("a"),R=o("span"),P(b.$$.fragment),pe=i(),N=o("span"),N.textContent=me,X=i(),_=o("p"),_.innerHTML=de,q=i(),P(v.$$.fragment),Q=i(),J=o("p"),J.innerHTML=ue,Y=i(),M=o("table"),M.innerHTML=we,K=i(),u=o("h2"),g=o("a"),z=o("span"),P(x.$$.fragment),he=i(),F=o("span"),F.textContent=ye,O=i(),C=o("p"),C.innerHTML=ve,ee=i(),P(U.$$.fragment),te=i(),I=o("p"),I.innerHTML=ge,ne=i(),w=o("h2"),$=o("a"),D=o("span"),P(E.$$.fragment),ce=i(),A=o("span"),A.textContent=$e,ae=i(),k=o("p"),k.textContent=Te,se=i(),P(j.$$.fragment),re=i(),P(T.$$.fragment),this.h()},l(e){const n=Pe("svelte-1phssyn",document.head);a=l(n,"META",{name:!0,content:!0}),n.forEach(t),d=p(e),r=l(e,"H1",{class:!0});var H=y(r);f=l(H,"A",{id:!0,class:!0,href:!0});var V=y(f);R=l(V,"SPAN",{});var be=y(R);S(b.$$.fragment,be),be.forEach(t),V.forEach(t),pe=p(H),N=l(H,"SPAN",{"data-svelte-h":!0}),m(N)!=="svelte-174cjw4"&&(N.textContent=me),H.forEach(t),X=p(e),_=l(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1pehmy1"&&(_.innerHTML=de),q=p(e),S(v.$$.fragment,e),Q=p(e),J=l(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-1iu9895"&&(J.innerHTML=ue),Y=p(e),M=l(e,"TABLE",{"data-svelte-h":!0}),m(M)!=="svelte-1osaemz"&&(M.innerHTML=we),K=p(e),u=l(e,"H2",{class:!0});var le=y(u);g=l(le,"A",{id:!0,class:!0,href:!0});var _e=y(g);z=l(_e,"SPAN",{});var Je=y(z);S(x.$$.fragment,Je),Je.forEach(t),_e.forEach(t),he=p(le),F=l(le,"SPAN",{"data-svelte-h":!0}),m(F)!=="svelte-1rk0ow1"&&(F.textContent=ye),le.forEach(t),O=p(e),C=l(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-sgc3mn"&&(C.innerHTML=ve),ee=p(e),S(U.$$.fragment,e),te=p(e),I=l(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-ahb0o9"&&(I.innerHTML=ge),ne=p(e),w=l(e,"H2",{class:!0});var ie=y(w);$=l(ie,"A",{id:!0,class:!0,href:!0});var Me=y($);D=l(Me,"SPAN",{});var xe=y(D);S(E.$$.fragment,xe),xe.forEach(t),Me.forEach(t),ce=p(ie),A=l(ie,"SPAN",{"data-svelte-h":!0}),m(A)!=="svelte-85swle"&&(A.textContent=$e),ie.forEach(t),ae=p(e),k=l(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-rv9wu9"&&(k.textContent=Te),se=p(e),S(j.$$.fragment,e),re=p(e),S(T.$$.fragment,e),this.h()},h(){h(a,"name","hf:doc:metadata"),h(a,"content",JSON.stringify(Le)),h(f,"id","speed-up-inference"),h(f,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(f,"href","#speed-up-inference"),h(r,"class","relative group"),h(g,"id","use-tensorfloat32"),h(g,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(g,"href","#use-tensorfloat32"),h(u,"class","relative group"),h($,"id","halfprecision-weights"),h($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h($,"href","#halfprecision-weights"),h(w,"class","relative group")},m(e,n){c(document.head,a),s(e,d,n),s(e,r,n),c(r,f),c(f,R),G(b,R,null),c(r,pe),c(r,N),s(e,X,n),s(e,_,n),s(e,q,n),G(v,e,n),s(e,Q,n),s(e,J,n),s(e,Y,n),s(e,M,n),s(e,K,n),s(e,u,n),c(u,g),c(g,z),G(x,z,null),c(u,he),c(u,F),s(e,O,n),s(e,C,n),s(e,ee,n),G(U,e,n),s(e,te,n),s(e,I,n),s(e,ne,n),s(e,w,n),c(w,$),c($,D),G(E,D,null),c(w,ce),c(w,A),s(e,ae,n),s(e,k,n),s(e,se,n),G(j,e,n),s(e,re,n),G(T,e,n),oe=!0},p(e,[n]){const H={};n&2&&(H.$$scope={dirty:n,ctx:e}),v.$set(H);const V={};n&2&&(V.$$scope={dirty:n,ctx:e}),T.$set(V)},i(e){oe||(Z(b.$$.fragment,e),Z(v.$$.fragment,e),Z(x.$$.fragment,e),Z(U.$$.fragment,e),Z(E.$$.fragment,e),Z(j.$$.fragment,e),Z(T.$$.fragment,e),oe=!0)},o(e){L(b.$$.fragment,e),L(v.$$.fragment,e),L(x.$$.fragment,e),L(U.$$.fragment,e),L(E.$$.fragment,e),L(j.$$.fragment,e),L(T.$$.fragment,e),oe=!1},d(e){e&&(t(d),t(r),t(X),t(_),t(q),t(Q),t(J),t(Y),t(M),t(K),t(u),t(O),t(C),t(ee),t(te),t(I),t(ne),t(w),t(ae),t(k),t(se),t(re)),t(a),W(b),W(v,e),W(x),W(U,e),W(E),W(j,e),W(T,e)}}}const Le={local:"speed-up-inference",sections:[{local:"use-tensorfloat32",title:"Use TensorFloat-32"},{local:"halfprecision-weights",title:"Half-precision weights"}],title:"Speed up inference"};function We(B){return ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ze extends je{constructor(a){super(),He(this,a,We,Ze,Ee,{})}}export{ze as component};
