import{s as Cn,o as Wn,n as Kt}from"../chunks/scheduler.182ea377.js";import{S as kn,i as Xn,g as i,s as l,r as d,A as Rn,h as o,f as n,c as a,j as R,u as m,x as p,k as V,y as M,a as s,v as u,d as f,t as g,w as h}from"../chunks/index.abf12888.js";import{T as Vn}from"../chunks/Tip.230e2334.js";import{D as Ye}from"../chunks/Docstring.93f6f462.js";import{C as j}from"../chunks/CodeBlock.57fe6e13.js";import{E as Bn}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as P}from"../chunks/Heading.16916d63.js";function Pn(v){let c,Z='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){c=i("p"),c.innerHTML=Z},l(y){c=o(y,"P",{"data-svelte-h":!0}),p(c)!=="svelte-1wmc0l4"&&(c.innerHTML=Z)},m(y,b){s(y,c,b)},p:Kt,d(y){y&&n(c)}}}function Nn(v){let c,Z="Examples:",y,b,T;return b=new j({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler, StableDiffusionPix2PixZeroPipeline


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">download</span>(<span class="hljs-params">embedding_url, local_filepath</span>):
<span class="hljs-meta">... </span>    r = requests.get(embedding_url)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(local_filepath, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(r.content)


<span class="hljs-meta">&gt;&gt;&gt; </span>model_ckpt = <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPix2PixZeroPipeline.from_pretrained(model_ckpt, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a high resolution painting of a cat in the style of van gough&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>source_emb_url = <span class="hljs-string">&quot;https://hf.co/datasets/sayakpaul/sample-datasets/resolve/main/cat.pt&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_emb_url = <span class="hljs-string">&quot;https://hf.co/datasets/sayakpaul/sample-datasets/resolve/main/dog.pt&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> url <span class="hljs-keyword">in</span> [source_emb_url, target_emb_url]:
<span class="hljs-meta">... </span>    download(url, url.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>src_embeds = torch.load(source_emb_url.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>target_embeds = torch.load(target_emb_url.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipeline(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    source_embeds=src_embeds,
<span class="hljs-meta">... </span>    target_embeds=target_embeds,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    cross_attention_guidance_amount=<span class="hljs-number">0.15</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;edited_image_dog.png&quot;</span>)`,wrap:!1}}),{c(){c=i("p"),c.textContent=Z,y=l(),d(b.$$.fragment)},l(r){c=o(r,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=Z),y=a(r),m(b.$$.fragment,r)},m(r,_){s(r,c,_),s(r,y,_),u(b,r,_),T=!0},p:Kt,i(r){T||(f(b.$$.fragment,r),T=!0)},o(r){g(b.$$.fragment,r),T=!1},d(r){r&&(n(c),n(y)),h(b,r)}}}function Sn(v){let c,Z="Examples:",y,b,T;return b=new j({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BlipForConditionalGeneration, BlipProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler, DDIMInverseScheduler, StableDiffusionPix2PixZeroPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>captioner_id = <span class="hljs-string">&quot;Salesforce/blip-image-captioning-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = BlipProcessor.from_pretrained(captioner_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BlipForConditionalGeneration.from_pretrained(
<span class="hljs-meta">... </span>    captioner_id, torch_dtype=torch.float16, low_cpu_mem_usage=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>sd_model_ckpt = <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPix2PixZeroPipeline.from_pretrained(
<span class="hljs-meta">... </span>    sd_model_ckpt,
<span class="hljs-meta">... </span>    caption_generator=model,
<span class="hljs-meta">... </span>    caption_processor=processor,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    safety_checker=<span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.inverse_scheduler = DDIMInverseScheduler.from_config(pipeline.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://github.com/pix2pixzero/pix2pix-zero/raw/main/assets/test_images/cats/cat_6.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>raw_image = Image.<span class="hljs-built_in">open</span>(requests.get(img_url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate caption</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>caption = pipeline.generate_caption(raw_image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># &quot;a photography of a cat with flowers and dai dai daie - daie - daie kasaii&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inv_latents = pipeline.invert(caption, image=raw_image).latents
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># we need to generate source and target embeds</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>source_prompts = [<span class="hljs-string">&quot;a cat sitting on the street&quot;</span>, <span class="hljs-string">&quot;a cat playing in the field&quot;</span>, <span class="hljs-string">&quot;a face of a cat&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>target_prompts = [<span class="hljs-string">&quot;a dog sitting on the street&quot;</span>, <span class="hljs-string">&quot;a dog playing in the field&quot;</span>, <span class="hljs-string">&quot;a face of a dog&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>source_embeds = pipeline.get_embeds(source_prompts)
<span class="hljs-meta">&gt;&gt;&gt; </span>target_embeds = pipeline.get_embeds(target_prompts)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the latents can then be used to edit a real image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># when using Stable Diffusion 2 or other models that use v-prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set \`cross_attention_guidance_amount\` to 0.01 or less to avoid input latent gradient explosion</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipeline(
<span class="hljs-meta">... </span>    caption,
<span class="hljs-meta">... </span>    source_embeds=source_embeds,
<span class="hljs-meta">... </span>    target_embeds=target_embeds,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    cross_attention_guidance_amount=<span class="hljs-number">0.15</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    latents=inv_latents,
<span class="hljs-meta">... </span>    negative_prompt=caption,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;edited_image.png&quot;</span>)`,wrap:!1}}),{c(){c=i("p"),c.textContent=Z,y=l(),d(b.$$.fragment)},l(r){c=o(r,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=Z),y=a(r),m(b.$$.fragment,r)},m(r,_){s(r,c,_),s(r,y,_),u(b,r,_),T=!0},p:Kt,i(r){T||(f(b.$$.fragment,r),T=!0)},o(r){g(b.$$.fragment,r),T=!1},d(r){r&&(n(c),n(y)),h(b,r)}}}function En(v){let c,Z,y,b,T,r,_,Ot='<a href="https://huggingface.co/papers/2302.03027" rel="nofollow">Zero-shot Image-to-Image Translation</a> is by Gaurav Parmar, Krishna Kumar Singh, Richard Zhang, Yijun Li, Jingwan Lu, and Jun-Yan Zhu.',Fe,N,en="The abstract from the paper is:",ze,S,tn="<em>Large-scale text-to-image generative models have shown their remarkable ability to synthesize diverse and high-quality images. However, it is still challenging to directly apply these models for editing real images for two reasons. First, it is hard for users to come up with a perfect text prompt that accurately describes every visual detail in the input image. Second, while existing models can introduce desirable changes in certain regions, they often dramatically alter the input content and introduce unexpected changes in unwanted regions. In this work, we propose pix2pix-zero, an image-to-image translation method that can preserve the content of the original image without manual prompting. We first automatically discover editing directions that reflect desired edits in the text embedding space. To preserve the general content structure after editing, we further propose cross-attention guidance, which aims to retain the cross-attention maps of the input image throughout the diffusion process. In addition, our method does not need additional training for these edits and can directly use the existing pre-trained text-to-image diffusion model. We conduct extensive experiments and show that our method outperforms existing and concurrent works for both real and synthetic image editing.</em>",Qe,E,nn='You can find additional information about Pix2Pix Zero on the <a href="https://pix2pixzero.github.io/" rel="nofollow">project page</a>,  <a href="https://github.com/pix2pixzero/pix2pix-zero" rel="nofollow">original codebase</a>, and try it out in a <a href="https://huggingface.co/spaces/pix2pix-zero-library/pix2pix-zero-demo" rel="nofollow">demo</a>.',He,Y,De,$,sn=`<li>The pipeline can be conditioned on real input images. Check out the code examples below to know more.</li> <li>The pipeline exposes two arguments namely <code>source_embeds</code> and <code>target_embeds</code>
that let you control the direction of the semantic edits in the final image to be generated. Let’s say,
you wanted to translate from “cat” to “dog”. In this case, the edit direction will be “cat -&gt; dog”. To reflect
this in the pipeline, you simply have to set the embeddings related to the phrases including “cat” to
<code>source_embeds</code> and “dog” to <code>target_embeds</code>. Refer to the code example below for more details.</li> <li>When you’re using this pipeline from a prompt, specify the <em>source</em> concept in the prompt. Taking
the above example, a valid input prompt would be: “a high resolution painting of a <strong>cat</strong> in the style of van gogh”.</li> <li>If you wanted to reverse the direction in the example above, i.e., “dog -&gt; cat”, then it’s recommended to:<ul><li>Swap the <code>source_embeds</code> and <code>target_embeds</code>.</li> <li>Change the input prompt to include “dog”.</li></ul></li> <li>To learn more about how the source and target embeddings are generated, refer to the <a href="https://arxiv.org/abs/2302.03027" rel="nofollow">original paper</a>. Below, we also provide some directions on how to generate the embeddings.</li> <li>Note that the quality of the outputs generated with this pipeline is dependent on how good the <code>source_embeds</code> and <code>target_embeds</code> are. Please, refer to <a href="#generating-source-and-target-embeddings">this discussion</a> for some suggestions on the topic.</li>`,Ae,F,Le,z,ln='<thead><tr><th>Pipeline</th> <th>Tasks</th> <th align="center">Demo</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_pix2pix_zero.py" rel="nofollow">StableDiffusionPix2PixZeroPipeline</a></td> <td><em>Text-Based Image Editing</em></td> <td align="center"><a href="https://huggingface.co/spaces/pix2pix-zero-library/pix2pix-zero-demo" rel="nofollow">🤗 Space</a></td></tr></tbody>',qe,Q,Ke,H,Oe,D,et,A,tt,L,an=`When the pipeline is conditioned on an input image, we first obtain an inverted
noise from it using a <code>DDIMInverseScheduler</code> with the help of a generated caption. Then the inverted noise is used to start the generation process.`,nt,q,on="First, let’s load our pipeline:",st,K,lt,O,rn="Then, we load an input image for conditioning and obtain a suitable caption for it:",at,ee,it,te,pn="Then we employ the generated caption and the input image to get the inverted noise:",ot,ne,rt,se,cn="Now, generate the image with edit directions:",pt,le,ct,ae,dt,ie,dn=`The authors originally used the <a href="https://openai.com/api/" rel="nofollow">GPT-3 API</a> to generate the source and target captions for discovering
edit directions. However, we can also leverage open source and public models for the same purpose.
Below, we provide an end-to-end example with the <a href="https://huggingface.co/docs/transformers/model_doc/flan-t5" rel="nofollow">Flan-T5</a> model
for generating captions and <a href="https://huggingface.co/docs/transformers/model_doc/clip" rel="nofollow">CLIP</a> for
computing embeddings on the generated captions.`,mt,oe,mn="<strong>1. Load the generation model</strong>:",ut,re,ft,pe,un="<strong>2. Construct a starting prompt</strong>:",gt,ce,ht,de,fn="Here, we’re interested in the “cat -> dog” direction.",Mt,me,gn="<strong>3. Generate captions</strong>:",bt,ue,hn="We can use a utility like so for this purpose.",yt,fe,wt,ge,Mn="And then we just call it to generate our captions:",Jt,he,Tt,Me,bn=`We encourage you to play around with the different parameters supported by the
<code>generate()</code> method (<a href="https://huggingface.co/docs/transformers/main/en/main_classes/text_generation#transformers.generation_tf_utils.TFGenerationMixin.generate" rel="nofollow">documentation</a>) for the generation quality you are looking for.`,_t,be,yn="<strong>4. Load the embedding model</strong>:",jt,ye,wn="Here, we need to use the same text encoder model used by the subsequent Stable Diffusion model.",Zt,we,Ut,Je,Jn="<strong>5. Compute embeddings</strong>:",xt,Te,It,_e,Tn='And you’re done! <a href="https://colab.research.google.com/drive/1tz2C1EdfZYAPlzXXbTnf-5PRBiR8_R1F?usp=sharing" rel="nofollow">Here</a> is a Colab Notebook that you can use to interact with the entire process.',vt,je,_n="Now, you can use these embeddings directly while calling the pipeline:",Gt,Ze,Bt,G,Ct,Ue,Wt,w,xe,Pt,ke,jn="Pipeline for pixel-levl image editing using Pix2Pix Zero. Based on Stable Diffusion.",Nt,Xe,Zn=`This model inherits from <a href="/docs/diffusers/v0.24.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,St,U,Ie,Et,Re,Un="Function invoked when calling the pipeline for generation.",Yt,B,$t,C,ve,Ft,Ve,xn="Constructs the edit direction to steer the image generation process semantically.",zt,W,Ge,Qt,Pe,In="Encodes the prompt into text encoder hidden states.",Ht,k,Be,Dt,Ne,vn="Generates caption for a given image.",At,x,Ce,Lt,Se,Gn="Function used to generate inverted latents given a prompt and image.",qt,X,kt,$e,Xt;return T=new P({props:{title:"Pix2Pix Zero",local:"pix2pix-zero",headingTag:"h1"}}),Y=new P({props:{title:"Tips",local:"tips",headingTag:"h2"}}),F=new P({props:{title:"Available Pipelines:",local:"available-pipelines",headingTag:"h2"}}),Q=new P({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),H=new P({props:{title:"Based on an image generated with the input prompt",local:"based-on-an-image-generated-with-the-input-prompt",headingTag:"h3"}}),D=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler, StableDiffusionPix2PixZeroPipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">download</span>(<span class="hljs-params">embedding_url, local_filepath</span>):
    r = requests.get(embedding_url)
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(local_filepath, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
        f.write(r.content)


model_ckpt = <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
pipeline = StableDiffusionPix2PixZeroPipeline.from_pretrained(
    model_ckpt, conditions_input_image=<span class="hljs-literal">False</span>, torch_dtype=torch.float16
)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a high resolution painting of a cat in the style of van gogh&quot;</span>
src_embs_url = <span class="hljs-string">&quot;https://github.com/pix2pixzero/pix2pix-zero/raw/main/assets/embeddings_sd_1.4/cat.pt&quot;</span>
target_embs_url = <span class="hljs-string">&quot;https://github.com/pix2pixzero/pix2pix-zero/raw/main/assets/embeddings_sd_1.4/dog.pt&quot;</span>

<span class="hljs-keyword">for</span> url <span class="hljs-keyword">in</span> [src_embs_url, target_embs_url]:
    download(url, url.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>])

src_embeds = torch.load(src_embs_url.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>])
target_embeds = torch.load(target_embs_url.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>])

image = pipeline(
    prompt,
    source_embeds=src_embeds,
    target_embeds=target_embeds,
    num_inference_steps=<span class="hljs-number">50</span>,
    cross_attention_guidance_amount=<span class="hljs-number">0.15</span>,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),A=new P({props:{title:"Based on an input image",local:"based-on-an-input-image",headingTag:"h3"}}),K=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQmxpcEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyMEJsaXBQcm9jZXNzb3IlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVNjaGVkdWxlciUyQyUyMERESU1JbnZlcnNlU2NoZWR1bGVyJTJDJTIwU3RhYmxlRGlmZnVzaW9uUGl4MlBpeFplcm9QaXBlbGluZSUwQSUwQWNhcHRpb25lcl9pZCUyMCUzRCUyMCUyMlNhbGVzZm9yY2UlMkZibGlwLWltYWdlLWNhcHRpb25pbmctYmFzZSUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMEJsaXBQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKGNhcHRpb25lcl9pZCklMEFtb2RlbCUyMCUzRCUyMEJsaXBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNhcHRpb25lcl9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMGxvd19jcHVfbWVtX3VzYWdlJTNEVHJ1ZSklMEElMEFzZF9tb2RlbF9ja3B0JTIwJTNEJTIwJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGl4MlBpeFplcm9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwc2RfbW9kZWxfY2twdCUyQyUwQSUyMCUyMCUyMCUyMGNhcHRpb25fZ2VuZXJhdG9yJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBjYXB0aW9uX3Byb2Nlc3NvciUzRHByb2Nlc3NvciUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHNhZmV0eV9jaGVja2VyJTNETm9uZSUyQyUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUuaW52ZXJzZV9zY2hlZHVsZXIlMjAlM0QlMjBERElNSW52ZXJzZVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BlipForConditionalGeneration, BlipProcessor
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler, DDIMInverseScheduler, StableDiffusionPix2PixZeroPipeline

captioner_id = <span class="hljs-string">&quot;Salesforce/blip-image-captioning-base&quot;</span>
processor = BlipProcessor.from_pretrained(captioner_id)
model = BlipForConditionalGeneration.from_pretrained(captioner_id, torch_dtype=torch.float16, low_cpu_mem_usage=<span class="hljs-literal">True</span>)

sd_model_ckpt = <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
pipeline = StableDiffusionPix2PixZeroPipeline.from_pretrained(
    sd_model_ckpt,
    caption_generator=model,
    caption_processor=processor,
    torch_dtype=torch.float16,
    safety_checker=<span class="hljs-literal">None</span>,
)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.inverse_scheduler = DDIMInverseScheduler.from_config(pipeline.scheduler.config)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),ee=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGcGl4MnBpeHplcm8lMkZwaXgycGl4LXplcm8lMkZyYXclMkZtYWluJTJGYXNzZXRzJTJGdGVzdF9pbWFnZXMlMkZjYXRzJTJGY2F0XzYucG5nJTIyJTBBcmF3X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEFjYXB0aW9uJTIwJTNEJTIwcGlwZWxpbmUuZ2VuZXJhdGVfY2FwdGlvbihyYXdfaW1hZ2UpJTBBY2FwdGlvbg==",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img_url = <span class="hljs-string">&quot;https://github.com/pix2pixzero/pix2pix-zero/raw/main/assets/test_images/cats/cat_6.png&quot;</span>
raw_image = load_image(url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
caption = pipeline.generate_caption(raw_image)
caption`,wrap:!1}}),ne=new j({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2gubWFudWFsX3NlZWQoMCklMEFpbnZfbGF0ZW50cyUyMCUzRCUyMHBpcGVsaW5lLmludmVydChjYXB0aW9uJTJDJTIwaW1hZ2UlM0RyYXdfaW1hZ2UlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmxhdGVudHM=",highlighted:`generator = torch.manual_seed(<span class="hljs-number">0</span>)
inv_latents = pipeline.invert(caption, image=raw_image, generator=generator).latents`,wrap:!1}}),le=new j({props:{code:"JTIzJTIwU2VlJTIwdGhlJTIwJTIyR2VuZXJhdGluZyUyMHNvdXJjZSUyMGFuZCUyMHRhcmdldCUyMGVtYmVkZGluZ3MlMjIlMjBzZWN0aW9uJTIwYmVsb3clMjB0byUwQSUyMyUyMGF1dG9tYXRlJTIwdGhlJTIwZ2VuZXJhdGlvbiUyMG9mJTIwdGhlc2UlMjBjYXB0aW9ucyUyMHdpdGglMjBhJTIwcHJlLXRyYWluZWQlMjBtb2RlbCUyMGxpa2UlMjBGbGFuLVQ1JTIwYXMlMjBleHBsYWluZWQlMjBiZWxvdy4lMEFzb3VyY2VfcHJvbXB0cyUyMCUzRCUyMCU1QiUyMmElMjBjYXQlMjBzaXR0aW5nJTIwb24lMjB0aGUlMjBzdHJlZXQlMjIlMkMlMjAlMjJhJTIwY2F0JTIwcGxheWluZyUyMGluJTIwdGhlJTIwZmllbGQlMjIlMkMlMjAlMjJhJTIwZmFjZSUyMG9mJTIwYSUyMGNhdCUyMiU1RCUwQXRhcmdldF9wcm9tcHRzJTIwJTNEJTIwJTVCJTIyYSUyMGRvZyUyMHNpdHRpbmclMjBvbiUyMHRoZSUyMHN0cmVldCUyMiUyQyUyMCUyMmElMjBkb2clMjBwbGF5aW5nJTIwaW4lMjB0aGUlMjBmaWVsZCUyMiUyQyUyMCUyMmElMjBmYWNlJTIwb2YlMjBhJTIwZG9nJTIyJTVEJTBBJTBBc291cmNlX2VtYmVkcyUyMCUzRCUyMHBpcGVsaW5lLmdldF9lbWJlZHMoc291cmNlX3Byb21wdHMlMkMlMjBiYXRjaF9zaXplJTNEMiklMEF0YXJnZXRfZW1iZWRzJTIwJTNEJTIwcGlwZWxpbmUuZ2V0X2VtYmVkcyh0YXJnZXRfcHJvbXB0cyUyQyUyMGJhdGNoX3NpemUlM0QyKSUwQSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwY2FwdGlvbiUyQyUwQSUyMCUyMCUyMCUyMHNvdXJjZV9lbWJlZHMlM0Rzb3VyY2VfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X2VtYmVkcyUzRHRhcmdldF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBjcm9zc19hdHRlbnRpb25fZ3VpZGFuY2VfYW1vdW50JTNEMC4xNSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGxhdGVudHMlM0RpbnZfbGF0ZW50cyUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRGNhcHRpb24lMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-comment"># See the &quot;Generating source and target embeddings&quot; section below to</span>
<span class="hljs-comment"># automate the generation of these captions with a pre-trained model like Flan-T5 as explained below.</span>
source_prompts = [<span class="hljs-string">&quot;a cat sitting on the street&quot;</span>, <span class="hljs-string">&quot;a cat playing in the field&quot;</span>, <span class="hljs-string">&quot;a face of a cat&quot;</span>]
target_prompts = [<span class="hljs-string">&quot;a dog sitting on the street&quot;</span>, <span class="hljs-string">&quot;a dog playing in the field&quot;</span>, <span class="hljs-string">&quot;a face of a dog&quot;</span>]

source_embeds = pipeline.get_embeds(source_prompts, batch_size=<span class="hljs-number">2</span>)
target_embeds = pipeline.get_embeds(target_prompts, batch_size=<span class="hljs-number">2</span>)


image = pipeline(
    caption,
    source_embeds=source_embeds,
    target_embeds=target_embeds,
    num_inference_steps=<span class="hljs-number">50</span>,
    cross_attention_guidance_amount=<span class="hljs-number">0.15</span>,
    generator=generator,
    latents=inv_latents,
    negative_prompt=caption,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ae=new P({props:{title:"Generating source and target embeddings",local:"generating-source-and-target-embeddings",headingTag:"h2"}}),re=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS14bCUyMiklMEFtb2RlbCUyMCUzRCUyMFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LXhsJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, T5ForConditionalGeneration

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-xl&quot;</span>)
model = T5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-xl&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.float16)`,wrap:!1}}),ce=new j({props:{code:"c291cmNlX2NvbmNlcHQlMjAlM0QlMjAlMjJjYXQlMjIlMEF0YXJnZXRfY29uY2VwdCUyMCUzRCUyMCUyMmRvZyUyMiUwQSUwQXNvdXJjZV90ZXh0JTIwJTNEJTIwZiUyMlByb3ZpZGUlMjBhJTIwY2FwdGlvbiUyMGZvciUyMGltYWdlcyUyMGNvbnRhaW5pbmclMjBhJTIwJTdCc291cmNlX2NvbmNlcHQlN0QuJTIwJTIyJTBBJTIyVGhlJTIwY2FwdGlvbnMlMjBzaG91bGQlMjBiZSUyMGluJTIwRW5nbGlzaCUyMGFuZCUyMHNob3VsZCUyMGJlJTIwbm8lMjBsb25nZXIlMjB0aGFuJTIwMTUwJTIwY2hhcmFjdGVycy4lMjIlMEElMEF0YXJnZXRfdGV4dCUyMCUzRCUyMGYlMjJQcm92aWRlJTIwYSUyMGNhcHRpb24lMjBmb3IlMjBpbWFnZXMlMjBjb250YWluaW5nJTIwYSUyMCU3QnRhcmdldF9jb25jZXB0JTdELiUyMCUyMiUwQSUyMlRoZSUyMGNhcHRpb25zJTIwc2hvdWxkJTIwYmUlMjBpbiUyMEVuZ2xpc2glMjBhbmQlMjBzaG91bGQlMjBiZSUyMG5vJTIwbG9uZ2VyJTIwdGhhbiUyMDE1MCUyMGNoYXJhY3RlcnMuJTIy",highlighted:`source_concept = <span class="hljs-string">&quot;cat&quot;</span>
target_concept = <span class="hljs-string">&quot;dog&quot;</span>

source_text = <span class="hljs-string">f&quot;Provide a caption for images containing a <span class="hljs-subst">{source_concept}</span>. &quot;</span>
<span class="hljs-string">&quot;The captions should be in English and should be no longer than 150 characters.&quot;</span>

target_text = <span class="hljs-string">f&quot;Provide a caption for images containing a <span class="hljs-subst">{target_concept}</span>. &quot;</span>
<span class="hljs-string">&quot;The captions should be in English and should be no longer than 150 characters.&quot;</span>`,wrap:!1}}),fe=new j({props:{code:"ZGVmJTIwZ2VuZXJhdGVfY2FwdGlvbnMoaW5wdXRfcHJvbXB0KSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplcihpbnB1dF9wcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMudG8oJTIyY3VkYSUyMiklMEElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTJDJTIwdGVtcGVyYXR1cmUlM0QwLjglMkMlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDE2JTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTI4JTJDJTIwdG9wX2slM0QxMCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_captions</span>(<span class="hljs-params">input_prompt</span>):
    input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids.to(<span class="hljs-string">&quot;cuda&quot;</span>)

    outputs = model.generate(
        input_ids, temperature=<span class="hljs-number">0.8</span>, num_return_sequences=<span class="hljs-number">16</span>, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">128</span>, top_k=<span class="hljs-number">10</span>
    )
    <span class="hljs-keyword">return</span> tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),he=new j({props:{code:"c291cmNlX2NhcHRpb25zJTIwJTNEJTIwZ2VuZXJhdGVfY2FwdGlvbnMoc291cmNlX3RleHQpJTBBdGFyZ2V0X2NhcHRpb25zJTIwJTNEJTIwZ2VuZXJhdGVfY2FwdGlvbnModGFyZ2V0X2NvbmNlcHQpJTBBcHJpbnQoc291cmNlX2NhcHRpb25zJTJDJTIwdGFyZ2V0X2NhcHRpb25zJTJDJTIwc2VwJTNEJyU1Q24nKQ==",highlighted:`source_captions = generate_captions(source_text)
target_captions = generate_captions(target_concept)
<span class="hljs-built_in">print</span>(source_captions, target_captions, sep=<span class="hljs-string">&#x27;\\n&#x27;</span>)`,wrap:!1}}),we=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpeDJQaXhaZXJvUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpeDJQaXhaZXJvUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMHBpcGVsaW5lLnRva2VuaXplciUwQXRleHRfZW5jb2RlciUyMCUzRCUyMHBpcGVsaW5lLnRleHRfZW5jb2Rlcg==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPix2PixZeroPipeline

pipeline = StableDiffusionPix2PixZeroPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, torch_dtype=torch.float16
)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
tokenizer = pipeline.tokenizer
text_encoder = pipeline.text_encoder`,wrap:!1}}),Te=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBlbWJlZF9jYXB0aW9ucyhzZW50ZW5jZXMlMkMlMjB0b2tlbml6ZXIlMkMlMjB0ZXh0X2VuY29kZXIlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKSUzQSUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbWJlZGRpbmdzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwc2VudCUyMGluJTIwc2VudGVuY2VzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VudCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUzRHRva2VuaXplci5tb2RlbF9tYXhfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHRfaW5wdXRfaWRzJTIwJTNEJTIwdGV4dF9pbnB1dHMuaW5wdXRfaWRzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUyMCUzRCUyMHRleHRfZW5jb2Rlcih0ZXh0X2lucHV0X2lkcy50byhkZXZpY2UpJTJDJTIwYXR0ZW50aW9uX21hc2slM0ROb25lKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbWJlZGRpbmdzLmFwcGVuZChwcm9tcHRfZW1iZWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRvcmNoLmNvbmNhdGVuYXRlKGVtYmVkZGluZ3MlMkMlMjBkaW0lM0QwKS5tZWFuKGRpbSUzRDApLnVuc3F1ZWV6ZSgwKSUwQSUwQXNvdXJjZV9lbWJlZGRpbmdzJTIwJTNEJTIwZW1iZWRfY2FwdGlvbnMoc291cmNlX2NhcHRpb25zJTJDJTIwdG9rZW5pemVyJTJDJTIwdGV4dF9lbmNvZGVyKSUwQXRhcmdldF9lbWJlZGRpbmdzJTIwJTNEJTIwZW1iZWRfY2FwdGlvbnModGFyZ2V0X2NhcHRpb25zJTJDJTIwdG9rZW5pemVyJTJDJTIwdGV4dF9lbmNvZGVyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">embed_captions</span>(<span class="hljs-params">sentences, tokenizer, text_encoder, device=<span class="hljs-string">&quot;cuda&quot;</span></span>):
    <span class="hljs-keyword">with</span> torch.no_grad():
        embeddings = []
        <span class="hljs-keyword">for</span> sent <span class="hljs-keyword">in</span> sentences:
            text_inputs = tokenizer(
                sent,
                padding=<span class="hljs-string">&quot;max_length&quot;</span>,
                max_length=tokenizer.model_max_length,
                truncation=<span class="hljs-literal">True</span>,
                return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
            )
            text_input_ids = text_inputs.input_ids
            prompt_embeds = text_encoder(text_input_ids.to(device), attention_mask=<span class="hljs-literal">None</span>)[<span class="hljs-number">0</span>]
            embeddings.append(prompt_embeds)
    <span class="hljs-keyword">return</span> torch.concatenate(embeddings, dim=<span class="hljs-number">0</span>).mean(dim=<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)

source_embeddings = embed_captions(source_captions, tokenizer, text_encoder)
target_embeddings = embed_captions(target_captions, tokenizer, text_encoder)`,wrap:!1}}),Ze=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERESU1TY2hlZHVsZXIlMEElMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBzb3VyY2VfZW1iZWRzJTNEc291cmNlX2VtYmVkZGluZ3MlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfZW1iZWRzJTNEdGFyZ2V0X2VtYmVkZGluZ3MlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBjcm9zc19hdHRlbnRpb25fZ3VpZGFuY2VfYW1vdW50JTNEMC4xNSUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler

pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)

image = pipeline(
    prompt,
    source_embeds=source_embeddings,
    target_embeds=target_embeddings,
    num_inference_steps=<span class="hljs-number">50</span>,
    cross_attention_guidance_amount=<span class="hljs-number">0.15</span>,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),G=new Vn({props:{$$slots:{default:[Pn]},$$scope:{ctx:v}}}),Ue=new P({props:{title:"StableDiffusionPix2PixZeroPipeline",local:"diffusers.StableDiffusionPix2PixZeroPipeline",headingTag:"h2"}}),xe=new Ye({props:{name:"class diffusers.StableDiffusionPix2PixZeroPipeline",anchor:"diffusers.StableDiffusionPix2PixZeroPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddpm.DDPMScheduler, diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_euler_ancestral_discrete.EulerAncestralDiscreteScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"inverse_scheduler",val:": DDIMInverseScheduler"},{name:"caption_generator",val:": BlipForConditionalGeneration"},{name:"caption_processor",val:": BlipProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.24.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/v0.24.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.24.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.24.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.24.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, <a href="/docs/diffusers/v0.24.0/en/api/schedulers/euler_ancestral#diffusers.EulerAncestralDiscreteScheduler">EulerAncestralDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.24.0/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please, refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for details.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
Model that extracts features from generated images to be used as inputs for the <code>safety_checker</code>.`,name:"feature_extractor"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.requires_safety_checker",description:`<strong>requires_safety_checker</strong> (bool) &#x2014;
Whether the pipeline requires a safety checker. We recommend setting it to True if you&#x2019;re using the
pipeline publicly.`,name:"requires_safety_checker"}],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_pix2pix_zero.py#L283"}}),Ie=new Ye({props:{name:"__call__",anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"source_embeds",val:": Tensor = None"},{name:"target_embeds",val:": Tensor = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"cross_attention_guidance_amount",val:": float = 0.1"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": typing.Optional[int] = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.source_embeds",description:`<strong>source_embeds</strong> (<code>torch.Tensor</code>) &#x2014;
Source concept embeddings. Generation of the embeddings as per the <a href="https://arxiv.org/abs/2302.03027" rel="nofollow">original
paper</a>. Used in discovering the edit direction.`,name:"source_embeds"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.target_embeds",description:`<strong>target_embeds</strong> (<code>torch.Tensor</code>) &#x2014;
Target concept embeddings. Generation of the embeddings as per the <a href="https://arxiv.org/abs/2302.03027" rel="nofollow">original
paper</a>. Used in discovering the edit direction.`,name:"target_embeds"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/v0.24.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.cross_attention_guidance_amount",description:`<strong>cross_attention_guidance_amount</strong> (<code>float</code>, defaults to 0.1) &#x2014;
Amount of guidance needed from the reference cross-attention maps.`,name:"cross_attention_guidance_amount"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.24.0/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_pix2pix_zero.py#L810",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.24.0/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.24.0/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),B=new Bn({props:{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.__call__.example",$$slots:{default:[Nn]},$$scope:{ctx:v}}}),ve=new Ye({props:{name:"construct_direction",anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.construct_direction",parameters:[{name:"embs_source",val:": Tensor"},{name:"embs_target",val:": Tensor"}],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_pix2pix_zero.py#L700"}}),Ge=new Ye({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_pix2pix_zero.py#L406"}}),Be=new Ye({props:{name:"generate_caption",anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.generate_caption",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_pix2pix_zero.py#L680"}}),Ce=new Ye({props:{name:"invert",anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert",parameters:[{name:"prompt",val:": typing.Optional[str] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"cross_attention_guidance_amount",val:": float = 0.1"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": typing.Optional[int] = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"lambda_auto_corr",val:": float = 20.0"},{name:"lambda_kl",val:": float = 20.0"},{name:"num_reg_steps",val:": int = 5"},{name:"num_auto_corr_rolls",val:": int = 5"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code> <code>np.ndarray</code>, <code>PIL.Image.Image</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be used for conditioning. Can also accept
image latents as <code>image</code>, if passing latents directly, it will not be encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert.cross_attention_guidance_amount",description:`<strong>cross_attention_guidance_amount</strong> (<code>float</code>, defaults to 0.1) &#x2014;
Amount of guidance needed from the reference cross-attention maps.`,name:"cross_attention_guidance_amount"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.24.0/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert.lambda_auto_corr",description:`<strong>lambda_auto_corr</strong> (<code>float</code>, <em>optional</em>, defaults to 20.0) &#x2014;
Lambda parameter to control auto correction`,name:"lambda_auto_corr"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert.lambda_kl",description:`<strong>lambda_kl</strong> (<code>float</code>, <em>optional</em>, defaults to 20.0) &#x2014;
Lambda parameter to control Kullback&#x2013;Leibler divergence output`,name:"lambda_kl"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert.num_reg_steps",description:`<strong>num_reg_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
Number of regularization loss steps`,name:"num_reg_steps"},{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert.num_auto_corr_rolls",description:`<strong>num_auto_corr_rolls</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
Number of auto correction roll steps`,name:"num_auto_corr_rolls"}],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_pix2pix_zero.py#L1101",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Pix2PixInversionPipelineOutput</code> or
<code>tuple</code>:
<code>Pix2PixInversionPipelineOutput</code> if
<code>return_dict</code> is True, otherwise a \`tuple. When returning a tuple, the first element is the inverted
latents tensor and then second is the corresponding decoded image.</p>
`}}),X=new Bn({props:{anchor:"diffusers.StableDiffusionPix2PixZeroPipeline.invert.example",$$slots:{default:[Sn]},$$scope:{ctx:v}}}),{c(){c=i("meta"),Z=l(),y=i("p"),b=l(),d(T.$$.fragment),r=l(),_=i("p"),_.innerHTML=Ot,Fe=l(),N=i("p"),N.textContent=en,ze=l(),S=i("p"),S.innerHTML=tn,Qe=l(),E=i("p"),E.innerHTML=nn,He=l(),d(Y.$$.fragment),De=l(),$=i("ul"),$.innerHTML=sn,Ae=l(),d(F.$$.fragment),Le=l(),z=i("table"),z.innerHTML=ln,qe=l(),d(Q.$$.fragment),Ke=l(),d(H.$$.fragment),Oe=l(),d(D.$$.fragment),et=l(),d(A.$$.fragment),tt=l(),L=i("p"),L.innerHTML=an,nt=l(),q=i("p"),q.textContent=on,st=l(),d(K.$$.fragment),lt=l(),O=i("p"),O.textContent=rn,at=l(),d(ee.$$.fragment),it=l(),te=i("p"),te.textContent=pn,ot=l(),d(ne.$$.fragment),rt=l(),se=i("p"),se.textContent=cn,pt=l(),d(le.$$.fragment),ct=l(),d(ae.$$.fragment),dt=l(),ie=i("p"),ie.innerHTML=dn,mt=l(),oe=i("p"),oe.innerHTML=mn,ut=l(),d(re.$$.fragment),ft=l(),pe=i("p"),pe.innerHTML=un,gt=l(),d(ce.$$.fragment),ht=l(),de=i("p"),de.textContent=fn,Mt=l(),me=i("p"),me.innerHTML=gn,bt=l(),ue=i("p"),ue.textContent=hn,yt=l(),d(fe.$$.fragment),wt=l(),ge=i("p"),ge.textContent=Mn,Jt=l(),d(he.$$.fragment),Tt=l(),Me=i("p"),Me.innerHTML=bn,_t=l(),be=i("p"),be.innerHTML=yn,jt=l(),ye=i("p"),ye.textContent=wn,Zt=l(),d(we.$$.fragment),Ut=l(),Je=i("p"),Je.innerHTML=Jn,xt=l(),d(Te.$$.fragment),It=l(),_e=i("p"),_e.innerHTML=Tn,vt=l(),je=i("p"),je.textContent=_n,Gt=l(),d(Ze.$$.fragment),Bt=l(),d(G.$$.fragment),Ct=l(),d(Ue.$$.fragment),Wt=l(),w=i("div"),d(xe.$$.fragment),Pt=l(),ke=i("p"),ke.textContent=jn,Nt=l(),Xe=i("p"),Xe.innerHTML=Zn,St=l(),U=i("div"),d(Ie.$$.fragment),Et=l(),Re=i("p"),Re.textContent=Un,Yt=l(),d(B.$$.fragment),$t=l(),C=i("div"),d(ve.$$.fragment),Ft=l(),Ve=i("p"),Ve.textContent=xn,zt=l(),W=i("div"),d(Ge.$$.fragment),Qt=l(),Pe=i("p"),Pe.textContent=In,Ht=l(),k=i("div"),d(Be.$$.fragment),Dt=l(),Ne=i("p"),Ne.textContent=vn,At=l(),x=i("div"),d(Ce.$$.fragment),Lt=l(),Se=i("p"),Se.textContent=Gn,qt=l(),d(X.$$.fragment),kt=l(),$e=i("p"),this.h()},l(e){const t=Rn("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(n),Z=a(e),y=o(e,"P",{}),R(y).forEach(n),b=a(e),m(T.$$.fragment,e),r=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-m4a8hg"&&(_.innerHTML=Ot),Fe=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1cwsb16"&&(N.textContent=en),ze=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1lao33u"&&(S.innerHTML=tn),Qe=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-10o1922"&&(E.innerHTML=nn),He=a(e),m(Y.$$.fragment,e),De=a(e),$=o(e,"UL",{"data-svelte-h":!0}),p($)!=="svelte-12lyhj5"&&($.innerHTML=sn),Ae=a(e),m(F.$$.fragment,e),Le=a(e),z=o(e,"TABLE",{"data-svelte-h":!0}),p(z)!=="svelte-u4gxbr"&&(z.innerHTML=ln),qe=a(e),m(Q.$$.fragment,e),Ke=a(e),m(H.$$.fragment,e),Oe=a(e),m(D.$$.fragment,e),et=a(e),m(A.$$.fragment,e),tt=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1thsbuj"&&(L.innerHTML=an),nt=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-rqov6b"&&(q.textContent=on),st=a(e),m(K.$$.fragment,e),lt=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-tkvp7f"&&(O.textContent=rn),at=a(e),m(ee.$$.fragment,e),it=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-11g26yv"&&(te.textContent=pn),ot=a(e),m(ne.$$.fragment,e),rt=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-hby9t"&&(se.textContent=cn),pt=a(e),m(le.$$.fragment,e),ct=a(e),m(ae.$$.fragment,e),dt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-5d8ier"&&(ie.innerHTML=dn),mt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-dzz9x4"&&(oe.innerHTML=mn),ut=a(e),m(re.$$.fragment,e),ft=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-awj8oj"&&(pe.innerHTML=un),gt=a(e),m(ce.$$.fragment,e),ht=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-zrtsc4"&&(de.textContent=fn),Mt=a(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1e9w56y"&&(me.innerHTML=gn),bt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-trszhu"&&(ue.textContent=hn),yt=a(e),m(fe.$$.fragment,e),wt=a(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-s1sn7u"&&(ge.textContent=Mn),Jt=a(e),m(he.$$.fragment,e),Tt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-h28h26"&&(Me.innerHTML=bn),_t=a(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-a5diii"&&(be.innerHTML=yn),jt=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-4903a2"&&(ye.textContent=wn),Zt=a(e),m(we.$$.fragment,e),Ut=a(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1mrx13j"&&(Je.innerHTML=Jn),xt=a(e),m(Te.$$.fragment,e),It=a(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1epnafg"&&(_e.innerHTML=Tn),vt=a(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1skcryl"&&(je.textContent=_n),Gt=a(e),m(Ze.$$.fragment,e),Bt=a(e),m(G.$$.fragment,e),Ct=a(e),m(Ue.$$.fragment,e),Wt=a(e),w=o(e,"DIV",{class:!0});var J=R(w);m(xe.$$.fragment,J),Pt=a(J),ke=o(J,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1tdg9ts"&&(ke.textContent=jn),Nt=a(J),Xe=o(J,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-1v56lyg"&&(Xe.innerHTML=Zn),St=a(J),U=o(J,"DIV",{class:!0});var I=R(U);m(Ie.$$.fragment,I),Et=a(I),Re=o(I,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-v78lg8"&&(Re.textContent=Un),Yt=a(I),m(B.$$.fragment,I),I.forEach(n),$t=a(J),C=o(J,"DIV",{class:!0});var We=R(C);m(ve.$$.fragment,We),Ft=a(We),Ve=o(We,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1wk7p1r"&&(Ve.textContent=xn),We.forEach(n),zt=a(J),W=o(J,"DIV",{class:!0});var Rt=R(W);m(Ge.$$.fragment,Rt),Qt=a(Rt),Pe=o(Rt,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-16q0ax1"&&(Pe.textContent=In),Rt.forEach(n),Ht=a(J),k=o(J,"DIV",{class:!0});var Vt=R(k);m(Be.$$.fragment,Vt),Dt=a(Vt),Ne=o(Vt,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-11am968"&&(Ne.textContent=vn),Vt.forEach(n),At=a(J),x=o(J,"DIV",{class:!0});var Ee=R(x);m(Ce.$$.fragment,Ee),Lt=a(Ee),Se=o(Ee,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-g5m2pl"&&(Se.textContent=Gn),qt=a(Ee),m(X.$$.fragment,Ee),Ee.forEach(n),J.forEach(n),kt=a(e),$e=o(e,"P",{}),R($e).forEach(n),this.h()},h(){V(c,"name","hf:doc:metadata"),V(c,"content",Yn),V(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){M(document.head,c),s(e,Z,t),s(e,y,t),s(e,b,t),u(T,e,t),s(e,r,t),s(e,_,t),s(e,Fe,t),s(e,N,t),s(e,ze,t),s(e,S,t),s(e,Qe,t),s(e,E,t),s(e,He,t),u(Y,e,t),s(e,De,t),s(e,$,t),s(e,Ae,t),u(F,e,t),s(e,Le,t),s(e,z,t),s(e,qe,t),u(Q,e,t),s(e,Ke,t),u(H,e,t),s(e,Oe,t),u(D,e,t),s(e,et,t),u(A,e,t),s(e,tt,t),s(e,L,t),s(e,nt,t),s(e,q,t),s(e,st,t),u(K,e,t),s(e,lt,t),s(e,O,t),s(e,at,t),u(ee,e,t),s(e,it,t),s(e,te,t),s(e,ot,t),u(ne,e,t),s(e,rt,t),s(e,se,t),s(e,pt,t),u(le,e,t),s(e,ct,t),u(ae,e,t),s(e,dt,t),s(e,ie,t),s(e,mt,t),s(e,oe,t),s(e,ut,t),u(re,e,t),s(e,ft,t),s(e,pe,t),s(e,gt,t),u(ce,e,t),s(e,ht,t),s(e,de,t),s(e,Mt,t),s(e,me,t),s(e,bt,t),s(e,ue,t),s(e,yt,t),u(fe,e,t),s(e,wt,t),s(e,ge,t),s(e,Jt,t),u(he,e,t),s(e,Tt,t),s(e,Me,t),s(e,_t,t),s(e,be,t),s(e,jt,t),s(e,ye,t),s(e,Zt,t),u(we,e,t),s(e,Ut,t),s(e,Je,t),s(e,xt,t),u(Te,e,t),s(e,It,t),s(e,_e,t),s(e,vt,t),s(e,je,t),s(e,Gt,t),u(Ze,e,t),s(e,Bt,t),u(G,e,t),s(e,Ct,t),u(Ue,e,t),s(e,Wt,t),s(e,w,t),u(xe,w,null),M(w,Pt),M(w,ke),M(w,Nt),M(w,Xe),M(w,St),M(w,U),u(Ie,U,null),M(U,Et),M(U,Re),M(U,Yt),u(B,U,null),M(w,$t),M(w,C),u(ve,C,null),M(C,Ft),M(C,Ve),M(w,zt),M(w,W),u(Ge,W,null),M(W,Qt),M(W,Pe),M(w,Ht),M(w,k),u(Be,k,null),M(k,Dt),M(k,Ne),M(w,At),M(w,x),u(Ce,x,null),M(x,Lt),M(x,Se),M(x,qt),u(X,x,null),s(e,kt,t),s(e,$e,t),Xt=!0},p(e,[t]){const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),G.$set(J);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),B.$set(I);const We={};t&2&&(We.$$scope={dirty:t,ctx:e}),X.$set(We)},i(e){Xt||(f(T.$$.fragment,e),f(Y.$$.fragment,e),f(F.$$.fragment,e),f(Q.$$.fragment,e),f(H.$$.fragment,e),f(D.$$.fragment,e),f(A.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(ne.$$.fragment,e),f(le.$$.fragment,e),f(ae.$$.fragment,e),f(re.$$.fragment,e),f(ce.$$.fragment,e),f(fe.$$.fragment,e),f(he.$$.fragment,e),f(we.$$.fragment,e),f(Te.$$.fragment,e),f(Ze.$$.fragment,e),f(G.$$.fragment,e),f(Ue.$$.fragment,e),f(xe.$$.fragment,e),f(Ie.$$.fragment,e),f(B.$$.fragment,e),f(ve.$$.fragment,e),f(Ge.$$.fragment,e),f(Be.$$.fragment,e),f(Ce.$$.fragment,e),f(X.$$.fragment,e),Xt=!0)},o(e){g(T.$$.fragment,e),g(Y.$$.fragment,e),g(F.$$.fragment,e),g(Q.$$.fragment,e),g(H.$$.fragment,e),g(D.$$.fragment,e),g(A.$$.fragment,e),g(K.$$.fragment,e),g(ee.$$.fragment,e),g(ne.$$.fragment,e),g(le.$$.fragment,e),g(ae.$$.fragment,e),g(re.$$.fragment,e),g(ce.$$.fragment,e),g(fe.$$.fragment,e),g(he.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(Ze.$$.fragment,e),g(G.$$.fragment,e),g(Ue.$$.fragment,e),g(xe.$$.fragment,e),g(Ie.$$.fragment,e),g(B.$$.fragment,e),g(ve.$$.fragment,e),g(Ge.$$.fragment,e),g(Be.$$.fragment,e),g(Ce.$$.fragment,e),g(X.$$.fragment,e),Xt=!1},d(e){e&&(n(Z),n(y),n(b),n(r),n(_),n(Fe),n(N),n(ze),n(S),n(Qe),n(E),n(He),n(De),n($),n(Ae),n(Le),n(z),n(qe),n(Ke),n(Oe),n(et),n(tt),n(L),n(nt),n(q),n(st),n(lt),n(O),n(at),n(it),n(te),n(ot),n(rt),n(se),n(pt),n(ct),n(dt),n(ie),n(mt),n(oe),n(ut),n(ft),n(pe),n(gt),n(ht),n(de),n(Mt),n(me),n(bt),n(ue),n(yt),n(wt),n(ge),n(Jt),n(Tt),n(Me),n(_t),n(be),n(jt),n(ye),n(Zt),n(Ut),n(Je),n(xt),n(It),n(_e),n(vt),n(je),n(Gt),n(Bt),n(Ct),n(Wt),n(w),n(kt),n($e)),n(c),h(T,e),h(Y,e),h(F,e),h(Q,e),h(H,e),h(D,e),h(A,e),h(K,e),h(ee,e),h(ne,e),h(le,e),h(ae,e),h(re,e),h(ce,e),h(fe,e),h(he,e),h(we,e),h(Te,e),h(Ze,e),h(G,e),h(Ue,e),h(xe),h(Ie),h(B),h(ve),h(Ge),h(Be),h(Ce),h(X)}}}const Yn='{"title":"Pix2Pix Zero","local":"pix2pix-zero","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"Available Pipelines:","local":"available-pipelines","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Based on an image generated with the input prompt","local":"based-on-an-image-generated-with-the-input-prompt","sections":[],"depth":3},{"title":"Based on an input image","local":"based-on-an-input-image","sections":[],"depth":3}],"depth":2},{"title":"Generating source and target embeddings","local":"generating-source-and-target-embeddings","sections":[],"depth":2},{"title":"StableDiffusionPix2PixZeroPipeline","local":"diffusers.StableDiffusionPix2PixZeroPipeline","sections":[],"depth":2}],"depth":1}';function $n(v){return Wn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qn extends kn{constructor(c){super(),Xn(this,c,$n,En,Cn,{})}}export{qn as component};
