import{s as vl,n as Al,o as Nl}from"../chunks/scheduler.9bc65507.js";import{S as Hl,i as El,g as M,s as a,r as i,A as Fl,h as o,f as e,c as n,j as Yl,u as p,x as c,k as kl,y as zl,a as t,v as r,d as y,t as m,w as d}from"../chunks/index.707bf1b6.js";import{C as j}from"../chunks/CodeBlock.54a9f38d.js";import{D as $l}from"../chunks/DocNotebookDropdown.3e6b3817.js";import{H as Ql}from"../chunks/Heading.342b1fa6.js";function xl(wl){let J,Q,z,x,U,S,b,q,u,hl='知識の蒸留は、より大規模で複雑なモデル (教師) からより小規模で単純なモデル (生徒) に知識を伝達するために使用される手法です。あるモデルから別のモデルに知識を抽出するには、特定のタスク (この場合は画像分類) でトレーニングされた事前トレーニング済み教師モデルを取得し、画像分類でトレーニングされる生徒モデルをランダムに初期化します。次に、学生モデルをトレーニングして、その出力と教師の出力の差を最小限に抑え、動作を模倣します。これは <a href="https://arxiv.org/abs/1503.02531" rel="nofollow">Distilling the Knowledge in a Neural Network by Hinton et al</a> で最初に導入されました。このガイドでは、タスク固有の知識の蒸留を行います。これには <a href="https://huggingface.co/datasets/beans" rel="nofollow">Beans データセット</a> を使用します。',L,w,Tl='このガイドでは、<a href="https://huggingface.co/merve/vit-mobilenet-beans-224" rel="nofollow">微調整された ViT モデル</a> (教師モデル) を抽出して [MobileNet](<a href="https://huggingface." rel="nofollow">https://huggingface.</a> co/google/mobilenet_v2_1.4_224) (学生モデル) 🤗 Transformers の <a href="https://huggingface.co/docs/transformers/en/main_classes/trainer#trainer" rel="nofollow">Trainer API</a> を使用します。',K,h,fl="蒸留とプロセスの評価に必要なライブラリをインストールしましょう。",D,T,P,f,Cl="この例では、教師モデルとして<code>merve/beans-vit-224</code>モデルを使用しています。これは、Bean データセットに基づいて微調整された<code>google/vit-base-patch16-224-in21k</code>に基づく画像分類モデルです。このモデルをランダムに初期化された MobileNetV2 に抽出します。",O,C,Zl="次に、データセットをロードします。",ll,Z,sl,g,gl="この場合、同じ解像度で同じ出力が返されるため、どちらのモデルの画像プロセッサも使用できます。 <code>dataset</code>の<code>map()</code>メソッドを使用して、データセットのすべての分割に前処理を適用します。",el,_,tl,I,_l="基本的に、我々は生徒モデル（ランダムに初期化されたMobileNet）が教師モデル（微調整されたビジョン変換器）を模倣することを望む。これを実現するために、まず教師と生徒からロジット出力を得る。次に、それぞれのソフトターゲットの重要度を制御するパラメータ<code>temperature</code>で分割する。<code>lambda</code>と呼ばれるパラメータは蒸留ロスの重要度を量る。この例では、<code>temperature=5</code>、<code>lambda=0.5</code>とする。生徒と教師の間の発散を計算するために、Kullback-Leibler発散損失を使用します。2つのデータPとQが与えられたとき、KLダイバージェンスはQを使ってPを表現するためにどれだけの余分な情報が必要かを説明します。もし2つが同じであれば、QからPを説明するために必要な他の情報はないので、それらのKLダイバージェンスはゼロになります。",al,W,nl,R,Il="次に、Hugging Face Hub にログインして、<code>trainer</code>を通じてモデルを Hugging Face Hub にプッシュできるようにします。",Ml,G,ol,V,Wl="教師モデルと生徒モデルである<code>TrainingArguments</code>を設定しましょう。",cl,X,il,B,Rl="<code>compute_metrics</code> 関数を使用して、テスト セットでモデルを評価できます。この関数は、トレーニング プロセス中にモデルの<code>accuracy</code>と<code>f1</code>を計算するために使用されます。",pl,Y,rl,k,Gl="定義したトレーニング引数を使用して<code>Trainer</code>を初期化しましょう。データ照合装置も初期化します。",yl,v,ml,A,Vl="これでモデルをトレーニングできるようになりました。",dl,N,jl,H,Xl="テスト セットでモデルを評価できます。",Jl,E,Ul,F,Bl='テスト セットでは、モデルの精度は 72% に達します。蒸留効率の健全性チェックを行うために、同じハイパーパラメータを使用して Bean データセットで MobileNet を最初からトレーニングし、テスト セットで 63% の精度を観察しました。読者の皆様には、さまざまな事前トレーニング済み教師モデル、学生アーキテクチャ、蒸留パラメータを試していただき、その結果を報告していただくようお勧めします。抽出されたモデルのトレーニング ログとチェックポイントは <a href="https://huggingface.co/merve/vit-mobilenet-beans-224" rel="nofollow">このリポジトリ</a> にあり、最初からトレーニングされた MobileNetV2 はこの <a href="https://huggingface.co/merve/resnet-mobilenet-beans-5" rel="nofollow">リポジトリ</a>。',bl,$,ul;return U=new Ql({props:{title:"Knowledge Distillation for Computer Vision",local:"knowledge-distillation-for-computer-vision",headingTag:"h1"}}),b=new $l({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/knowledge_distillation_for_image_classification.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/knowledge_distillation_for_image_classification.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/knowledge_distillation_for_image_classification.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/knowledge_distillation_for_image_classification.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/knowledge_distillation_for_image_classification.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/knowledge_distillation_for_image_classification.ipynb"}]}}),T=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwYWNjZWxlcmF0ZSUyMHRlbnNvcmJvYXJkJTIwZXZhbHVhdGUlMjAtLXVwZ3JhZGU=",highlighted:"pip install transformers datasets accelerate tensorboard evaluate --upgrade",wrap:!1}}),Z=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJiZWFucyUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;beans&quot;</span>)`,wrap:!1}}),_=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQXRlYWNoZXJfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtZXJ2ZSUyRmJlYW5zLXZpdC0yMjQlMjIpJTBBJTBBZGVmJTIwcHJvY2VzcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBwcm9jZXNzZWRfaW5wdXRzJTIwJTNEJTIwdGVhY2hlcl9wcm9jZXNzb3IoZXhhbXBsZXMlNUIlMjJpbWFnZSUyMiU1RCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBwcm9jZXNzZWRfaW5wdXRzJTBBJTBBcHJvY2Vzc2VkX2RhdGFzZXRzJTIwJTNEJTIwZGF0YXNldC5tYXAocHJvY2VzcyUyQyUyMGJhdGNoZWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor
teacher_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;merve/beans-vit-224&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">process</span>(<span class="hljs-params">examples</span>):
    processed_inputs = teacher_processor(examples[<span class="hljs-string">&quot;image&quot;</span>])
    <span class="hljs-keyword">return</span> processed_inputs

processed_datasets = dataset.<span class="hljs-built_in">map</span>(process, batched=<span class="hljs-literal">True</span>)`,wrap:!1}}),W=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwdG9yY2gubm4lMjBhcyUyMG5uJTBBaW1wb3J0JTIwdG9yY2gubm4uZnVuY3Rpb25hbCUyMGFzJTIwRiUwQSUwQSUwQWNsYXNzJTIwSW1hZ2VEaXN0aWxUcmFpbmVyKFRyYWluZXIpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMCphcmdzJTJDJTIwdGVhY2hlcl9tb2RlbCUzRE5vbmUlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCphcmdzJTJDJTIwKiprd2FyZ3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi50ZWFjaGVyJTIwJTNEJTIwdGVhY2hlcl9tb2RlbCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuc3R1ZGVudCUyMCUzRCUyMHN0dWRlbnRfbW9kZWwlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmxvc3NfZnVuY3Rpb24lMjAlM0QlMjBubi5LTERpdkxvc3MocmVkdWN0aW9uJTNEJTIyYmF0Y2htZWFuJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRldmljZSUyMCUzRCUyMHRvcmNoLmRldmljZSgnY3VkYSclMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJ2NwdScpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi50ZWFjaGVyLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnRlYWNoZXIuZXZhbCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi50ZW1wZXJhdHVyZSUyMCUzRCUyMHRlbXBlcmF0dXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5sYW1iZGFfcGFyYW0lMjAlM0QlMjBsYW1iZGFfcGFyYW0lMEElMEElMjAlMjAlMjAlMjBkZWYlMjBjb21wdXRlX2xvc3Moc2VsZiUyQyUyMHN0dWRlbnQlMkMlMjBpbnB1dHMlMkMlMjByZXR1cm5fb3V0cHV0cyUzREZhbHNlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0dWRlbnRfb3V0cHV0JTIwJTNEJTIwc2VsZi5zdHVkZW50KCoqaW5wdXRzKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZWFjaGVyX291dHB1dCUyMCUzRCUyMHNlbGYudGVhY2hlcigqKmlucHV0cyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBDb21wdXRlJTIwc29mdCUyMHRhcmdldHMlMjBmb3IlMjB0ZWFjaGVyJTIwYW5kJTIwc3R1ZGVudCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNvZnRfdGVhY2hlciUyMCUzRCUyMEYuc29mdG1heCh0ZWFjaGVyX291dHB1dC5sb2dpdHMlMjAlMkYlMjBzZWxmLnRlbXBlcmF0dXJlJTJDJTIwZGltJTNELTEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc29mdF9zdHVkZW50JTIwJTNEJTIwRi5sb2dfc29mdG1heChzdHVkZW50X291dHB1dC5sb2dpdHMlMjAlMkYlMjBzZWxmLnRlbXBlcmF0dXJlJTJDJTIwZGltJTNELTEpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQ29tcHV0ZSUyMHRoZSUyMGxvc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkaXN0aWxsYXRpb25fbG9zcyUyMCUzRCUyMHNlbGYubG9zc19mdW5jdGlvbihzb2Z0X3N0dWRlbnQlMkMlMjBzb2Z0X3RlYWNoZXIpJTIwKiUyMChzZWxmLnRlbXBlcmF0dXJlJTIwKiolMjAyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENvbXB1dGUlMjB0aGUlMjB0cnVlJTIwbGFiZWwlMjBsb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3R1ZGVudF90YXJnZXRfbG9zcyUyMCUzRCUyMHN0dWRlbnRfb3V0cHV0Lmxvc3MlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBDYWxjdWxhdGUlMjBmaW5hbCUyMGxvc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwKDEuJTIwLSUyMHNlbGYubGFtYmRhX3BhcmFtKSUyMColMjBzdHVkZW50X3RhcmdldF9sb3NzJTIwJTJCJTIwc2VsZi5sYW1iZGFfcGFyYW0lMjAqJTIwZGlzdGlsbGF0aW9uX2xvc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAobG9zcyUyQyUyMHN0dWRlbnRfb3V0cHV0KSUyMGlmJTIwcmV0dXJuX291dHB1dHMlMjBlbHNlJTIwbG9zcw==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ImageDistilTrainer</span>(<span class="hljs-title class_ inherited__">Trainer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, *args, teacher_model=<span class="hljs-literal">None</span>, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(*args, **kwargs)
        self.teacher = teacher_model
        self.student = student_model
        self.loss_function = nn.KLDivLoss(reduction=<span class="hljs-string">&quot;batchmean&quot;</span>)
        device = torch.device(<span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span>)
        self.teacher.to(device)
        self.teacher.<span class="hljs-built_in">eval</span>()
        self.temperature = temperature
        self.lambda_param = lambda_param

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_loss</span>(<span class="hljs-params">self, student, inputs, return_outputs=<span class="hljs-literal">False</span></span>):
        student_output = self.student(**inputs)

        <span class="hljs-keyword">with</span> torch.no_grad():
          teacher_output = self.teacher(**inputs)

        <span class="hljs-comment"># Compute soft targets for teacher and student</span>
        soft_teacher = F.softmax(teacher_output.logits / self.temperature, dim=-<span class="hljs-number">1</span>)
        soft_student = F.log_softmax(student_output.logits / self.temperature, dim=-<span class="hljs-number">1</span>)

        <span class="hljs-comment"># Compute the loss</span>
        distillation_loss = self.loss_function(soft_student, soft_teacher) * (self.temperature ** <span class="hljs-number">2</span>)

        <span class="hljs-comment"># Compute the true label loss</span>
        student_target_loss = student_output.loss

        <span class="hljs-comment"># Calculate final loss</span>
        loss = (<span class="hljs-number">1.</span> - self.lambda_param) * student_target_loss + self.lambda_param * distillation_loss
        <span class="hljs-keyword">return</span> (loss, student_output) <span class="hljs-keyword">if</span> return_outputs <span class="hljs-keyword">else</span> loss`,wrap:!1}}),G=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),X=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMkMlMjBNb2JpbGVOZXRWMkNvbmZpZyUyQyUyME1vYmlsZU5ldFYyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIybXktYXdlc29tZS1tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QzMCUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19kaXIlM0RmJTIyJTdCcmVwb19uYW1lJTdEJTJGbG9ncyUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvZ2dpbmdfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljX2Zvcl9iZXN0X21vZGVsJTNEJTIyYWNjdXJhY3klMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlMjJ0ZW5zb3Jib2FyZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGh1Yl9zdHJhdGVneSUzRCUyMmV2ZXJ5X3NhdmUlMjIlMkMlMEElMjAlMjAlMjAlMjBodWJfbW9kZWxfaWQlM0RyZXBvX25hbWUlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihwcm9jZXNzZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMmxhYmVscyUyMiU1RC5uYW1lcyklMEElMEElMjMlMjBpbml0aWFsaXplJTIwbW9kZWxzJTBBdGVhY2hlcl9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMm1lcnZlJTJGYmVhbnMtdml0LTIyNCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTBBJTIwJTIwJTIwJTIwaWdub3JlX21pc21hdGNoZWRfc2l6ZXMlM0RUcnVlJTBBKSUwQSUwQSUyMyUyMHRyYWluaW5nJTIwTW9iaWxlTmV0VjIlMjBmcm9tJTIwc2NyYXRjaCUwQXN0dWRlbnRfY29uZmlnJTIwJTNEJTIwTW9iaWxlTmV0VjJDb25maWcoKSUwQXN0dWRlbnRfY29uZmlnLm51bV9sYWJlbHMlMjAlM0QlMjBudW1fbGFiZWxzJTBBc3R1ZGVudF9tb2RlbCUyMCUzRCUyME1vYmlsZU5ldFYyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihzdHVkZW50X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification, MobileNetV2Config, MobileNetV2ForImageClassification

training_args = TrainingArguments(
    output_dir=<span class="hljs-string">&quot;my-awesome-model&quot;</span>,
    num_train_epochs=<span class="hljs-number">30</span>,
    fp16=<span class="hljs-literal">True</span>,
    logging_dir=<span class="hljs-string">f&quot;<span class="hljs-subst">{repo_name}</span>/logs&quot;</span>,
    logging_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    metric_for_best_model=<span class="hljs-string">&quot;accuracy&quot;</span>,
    report_to=<span class="hljs-string">&quot;tensorboard&quot;</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    hub_strategy=<span class="hljs-string">&quot;every_save&quot;</span>,
    hub_model_id=repo_name,
    )

num_labels = <span class="hljs-built_in">len</span>(processed_datasets[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;labels&quot;</span>].names)

<span class="hljs-comment"># initialize models</span>
teacher_model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;merve/beans-vit-224&quot;</span>,
    num_labels=num_labels,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># training MobileNetV2 from scratch</span>
student_config = MobileNetV2Config()
student_config.num_labels = num_labels
student_model = MobileNetV2ForImageClassification(student_config)`,wrap:!1}}),Y=new j({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFhY2N1cmFjeSUyMCUzRCUyMGV2YWx1YXRlLmxvYWQoJTIyYWNjdXJhY3klMjIpJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMGFjYyUyMCUzRCUyMGFjY3VyYWN5LmNvbXB1dGUocmVmZXJlbmNlcyUzRGxhYmVscyUyQyUyMHByZWRpY3Rpb25zJTNEbnAuYXJnbWF4KHByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmFjY3VyYWN5JTIyJTNBJTIwYWNjJTVCJTIyYWNjdXJhY3klMjIlNUQlN0Q=",highlighted:`<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

accuracy = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    acc = accuracy.compute(references=labels, predictions=np.argmax(predictions, axis=<span class="hljs-number">1</span>))
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;accuracy&quot;</span>: acc[<span class="hljs-string">&quot;accuracy&quot;</span>]}`,wrap:!1}}),v=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcigpJTBBdHJhaW5lciUyMCUzRCUyMEltYWdlRGlzdGlsVHJhaW5lciglMEElMjAlMjAlMjAlMjBzdHVkZW50X21vZGVsJTNEc3R1ZGVudF9tb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRlYWNoZXJfbW9kZWwlM0R0ZWFjaGVyX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5pbmdfYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEcHJvY2Vzc2VkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0Rwcm9jZXNzZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0ZWFjaGVyX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNENSUyQyUwQSUyMCUyMCUyMCUyMGxhbWJkYV9wYXJhbSUzRDAuNSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

data_collator = DefaultDataCollator()
trainer = ImageDistilTrainer(
    student_model=student_model,
    teacher_model=teacher_model,
    training_args=training_args,
    train_dataset=processed_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=processed_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=teacher_extractor,
    compute_metrics=compute_metrics,
    temperature=<span class="hljs-number">5</span>,
    lambda_param=<span class="hljs-number">0.5</span>
)`,wrap:!1}}),N=new j({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),E=new j({props:{code:"dHJhaW5lci5ldmFsdWF0ZShwcm9jZXNzZWRfZGF0YXNldHMlNUIlMjJ0ZXN0JTIyJTVEKQ==",highlighted:'trainer.evaluate(processed_datasets[<span class="hljs-string">&quot;test&quot;</span>])',wrap:!1}}),{c(){J=M("meta"),Q=a(),z=M("p"),x=a(),i(U.$$.fragment),S=a(),i(b.$$.fragment),q=a(),u=M("p"),u.innerHTML=hl,L=a(),w=M("p"),w.innerHTML=Tl,K=a(),h=M("p"),h.textContent=fl,D=a(),i(T.$$.fragment),P=a(),f=M("p"),f.innerHTML=Cl,O=a(),C=M("p"),C.textContent=Zl,ll=a(),i(Z.$$.fragment),sl=a(),g=M("p"),g.innerHTML=gl,el=a(),i(_.$$.fragment),tl=a(),I=M("p"),I.innerHTML=_l,al=a(),i(W.$$.fragment),nl=a(),R=M("p"),R.innerHTML=Il,Ml=a(),i(G.$$.fragment),ol=a(),V=M("p"),V.innerHTML=Wl,cl=a(),i(X.$$.fragment),il=a(),B=M("p"),B.innerHTML=Rl,pl=a(),i(Y.$$.fragment),rl=a(),k=M("p"),k.innerHTML=Gl,yl=a(),i(v.$$.fragment),ml=a(),A=M("p"),A.textContent=Vl,dl=a(),i(N.$$.fragment),jl=a(),H=M("p"),H.textContent=Xl,Jl=a(),i(E.$$.fragment),Ul=a(),F=M("p"),F.innerHTML=Bl,bl=a(),$=M("p"),this.h()},l(l){const s=Fl("svelte-u9bgzb",document.head);J=o(s,"META",{name:!0,content:!0}),s.forEach(e),Q=n(l),z=o(l,"P",{}),Yl(z).forEach(e),x=n(l),p(U.$$.fragment,l),S=n(l),p(b.$$.fragment,l),q=n(l),u=o(l,"P",{"data-svelte-h":!0}),c(u)!=="svelte-g6zwxf"&&(u.innerHTML=hl),L=n(l),w=o(l,"P",{"data-svelte-h":!0}),c(w)!=="svelte-5etgnj"&&(w.innerHTML=Tl),K=n(l),h=o(l,"P",{"data-svelte-h":!0}),c(h)!=="svelte-jic642"&&(h.textContent=fl),D=n(l),p(T.$$.fragment,l),P=n(l),f=o(l,"P",{"data-svelte-h":!0}),c(f)!=="svelte-17bqj69"&&(f.innerHTML=Cl),O=n(l),C=o(l,"P",{"data-svelte-h":!0}),c(C)!=="svelte-17v1c71"&&(C.textContent=Zl),ll=n(l),p(Z.$$.fragment,l),sl=n(l),g=o(l,"P",{"data-svelte-h":!0}),c(g)!=="svelte-1dtz5lw"&&(g.innerHTML=gl),el=n(l),p(_.$$.fragment,l),tl=n(l),I=o(l,"P",{"data-svelte-h":!0}),c(I)!=="svelte-e05tyc"&&(I.innerHTML=_l),al=n(l),p(W.$$.fragment,l),nl=n(l),R=o(l,"P",{"data-svelte-h":!0}),c(R)!=="svelte-193zzpj"&&(R.innerHTML=Il),Ml=n(l),p(G.$$.fragment,l),ol=n(l),V=o(l,"P",{"data-svelte-h":!0}),c(V)!=="svelte-1tcn498"&&(V.innerHTML=Wl),cl=n(l),p(X.$$.fragment,l),il=n(l),B=o(l,"P",{"data-svelte-h":!0}),c(B)!=="svelte-1kxppjo"&&(B.innerHTML=Rl),pl=n(l),p(Y.$$.fragment,l),rl=n(l),k=o(l,"P",{"data-svelte-h":!0}),c(k)!=="svelte-xih5j9"&&(k.innerHTML=Gl),yl=n(l),p(v.$$.fragment,l),ml=n(l),A=o(l,"P",{"data-svelte-h":!0}),c(A)!=="svelte-syywia"&&(A.textContent=Vl),dl=n(l),p(N.$$.fragment,l),jl=n(l),H=o(l,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1udiga3"&&(H.textContent=Xl),Jl=n(l),p(E.$$.fragment,l),Ul=n(l),F=o(l,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1sg5l9o"&&(F.innerHTML=Bl),bl=n(l),$=o(l,"P",{}),Yl($).forEach(e),this.h()},h(){kl(J,"name","hf:doc:metadata"),kl(J,"content",Sl)},m(l,s){zl(document.head,J),t(l,Q,s),t(l,z,s),t(l,x,s),r(U,l,s),t(l,S,s),r(b,l,s),t(l,q,s),t(l,u,s),t(l,L,s),t(l,w,s),t(l,K,s),t(l,h,s),t(l,D,s),r(T,l,s),t(l,P,s),t(l,f,s),t(l,O,s),t(l,C,s),t(l,ll,s),r(Z,l,s),t(l,sl,s),t(l,g,s),t(l,el,s),r(_,l,s),t(l,tl,s),t(l,I,s),t(l,al,s),r(W,l,s),t(l,nl,s),t(l,R,s),t(l,Ml,s),r(G,l,s),t(l,ol,s),t(l,V,s),t(l,cl,s),r(X,l,s),t(l,il,s),t(l,B,s),t(l,pl,s),r(Y,l,s),t(l,rl,s),t(l,k,s),t(l,yl,s),r(v,l,s),t(l,ml,s),t(l,A,s),t(l,dl,s),r(N,l,s),t(l,jl,s),t(l,H,s),t(l,Jl,s),r(E,l,s),t(l,Ul,s),t(l,F,s),t(l,bl,s),t(l,$,s),ul=!0},p:Al,i(l){ul||(y(U.$$.fragment,l),y(b.$$.fragment,l),y(T.$$.fragment,l),y(Z.$$.fragment,l),y(_.$$.fragment,l),y(W.$$.fragment,l),y(G.$$.fragment,l),y(X.$$.fragment,l),y(Y.$$.fragment,l),y(v.$$.fragment,l),y(N.$$.fragment,l),y(E.$$.fragment,l),ul=!0)},o(l){m(U.$$.fragment,l),m(b.$$.fragment,l),m(T.$$.fragment,l),m(Z.$$.fragment,l),m(_.$$.fragment,l),m(W.$$.fragment,l),m(G.$$.fragment,l),m(X.$$.fragment,l),m(Y.$$.fragment,l),m(v.$$.fragment,l),m(N.$$.fragment,l),m(E.$$.fragment,l),ul=!1},d(l){l&&(e(Q),e(z),e(x),e(S),e(q),e(u),e(L),e(w),e(K),e(h),e(D),e(P),e(f),e(O),e(C),e(ll),e(sl),e(g),e(el),e(tl),e(I),e(al),e(nl),e(R),e(Ml),e(ol),e(V),e(cl),e(il),e(B),e(pl),e(rl),e(k),e(yl),e(ml),e(A),e(dl),e(jl),e(H),e(Jl),e(Ul),e(F),e(bl),e($)),e(J),d(U,l),d(b,l),d(T,l),d(Z,l),d(_,l),d(W,l),d(G,l),d(X,l),d(Y,l),d(v,l),d(N,l),d(E,l)}}}const Sl='{"title":"Knowledge Distillation for Computer Vision","local":"knowledge-distillation-for-computer-vision","sections":[],"depth":1}';function ql(wl){return Nl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ls extends Hl{constructor(J){super(),El(this,J,ql,xl,vl,{})}}export{ls as component};
