import{s as Yl,o as Vl}from"../chunks/scheduler.6062bdaf.js";import{S as Ql,i as Wl,g as p,s as a,r as M,A as ql,h as i,f as l,c as n,j as Fl,u as c,x as r,k as Ds,y as Hl,a as t,v as o,d as y,t as u,w as j,m as Ks,n as Os}from"../chunks/index.4bca734e.js";import{H as Ae,g as xl}from"../chunks/Heading.949e2f88.js";import{T as Ps}from"../chunks/Tip.b9ac1f03.js";import{C as d}from"../chunks/CodeBlock.fa01571c.js";function zl(J){let m;return{c(){m=Ks(`From within your Space, secrets are available as environment variables (or
Streamlit Secrets Management if using Streamlit). No need to fetch them via the API!`)},l(h){m=Os(h,`From within your Space, secrets are available as environment variables (or
Streamlit Secrets Management if using Streamlit). No need to fetch them via the API!`)},m(h,w){t(h,m,w)},d(h){h&&l(m)}}}function Ll(J){let m;return{c(){m=Ks("Any change in your Space configuration (secrets or hardware) will trigger a restart of your app.")},l(h){m=Os(h,"Any change in your Space configuration (secrets or hardware) will trigger a restart of your app.")},m(h,w){t(h,m,w)},d(h){h&&l(m)}}}function Dl(J){let m;return{c(){m=Ks(`Such a workflow does not support concurrent access as normal demos.
In particular, the interface will be disabled when training occurs.
It is preferable to set your repo as private to ensure you are the only user.`)},l(h){m=Os(h,`Such a workflow does not support concurrent access as normal demos.
In particular, the interface will be disabled when training occurs.
It is preferable to set your repo as private to ensure you are the only user.`)},m(h,w){t(h,m,w)},d(h){h&&l(m)}}}function Pl(J){let m,h,w,Se,I,Ee,_,el=`In this guide, we will see how to manage your Space runtime
(<a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">secrets</a>,
<a href="https://huggingface.co/docs/hub/spaces-gpus" rel="nofollow">hardware</a>, and <a href="https://huggingface.co/docs/hub/spaces-storage#persistent-storage" rel="nofollow">storage</a>) using <code>huggingface_hub</code>.`,Ne,k,ve,C,sl="Here is an end-to-end example to create and setup a Space on the Hub.",Re,B,ll="<strong>1. Create a Space on the Hub.</strong>",Fe,Z,Ye,G,tl="<strong>1. (bis) Duplicate a Space.</strong>",Ve,$,al=`This can prove useful if you want to build up from an existing Space instead of starting from scratch.
It is also useful is you want control over the configuration/settings of a public Space. See <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/hf_api#huggingface_hub.HfApi.duplicate_space">duplicate_space()</a> for more details.`,Qe,b,We,X,nl="<strong>2. Upload your code using your preferred solution.</strong>",qe,A,pl="Here is an example to upload the local folder <code>src/</code> from your machine to your Space:",He,S,xe,E,il=`At this step, your app should already be running on the Hub for free !
However, you might want to configure it further with secrets and upgraded hardware.`,ze,N,rl="<strong>3. Configure secrets and variables</strong>",Le,v,Ml=`Your Space might require some secret keys, token or variables to work.
See <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">docs</a> for more details.
For example, an HF token to upload an image dataset to the Hub once generated from your Space.`,De,R,Pe,F,cl="Secrets and variables can be deleted as well:",Ke,Y,Oe,T,es,U,ss,V,ol="<strong>Bonus: set secrets and variables when creating or duplicating the Space!</strong>",ls,Q,yl="Secrets and variables can be set when creating or duplicating a space:",ts,W,as,q,ns,H,ul="<strong>4. Configure the hardware</strong>",ps,x,jl=`By default, your Space will run on a CPU environment for free. You can upgrade the hardware
to run it on GPUs. A payment card or a community grant is required to access upgrade your
Space. See <a href="https://huggingface.co/docs/hub/spaces-gpus" rel="nofollow">docs</a> for more details.`,is,z,rs,L,ml=`Hardware updates are not done immediately as your Space has to be reloaded on our servers.
At any time, you can check on which hardware your Space is running to see if your request
has been met.`,Ms,D,cs,P,hl=`You now have a Space fully configured. Make sure to downgrade your Space back to “cpu-classic”
when you are done using it.`,os,K,dl="<strong>Bonus: request hardware when creating or duplicating the Space!</strong>",ys,O,wl="Upgraded hardware will be automatically assigned to your Space once it’s built.",us,ee,js,se,ms,le,Jl="<strong>5. Pause and restart your Space</strong>",hs,te,Tl=`By default if your Space is running on an upgraded hardware, it will never be stopped. However to avoid getting billed,
you might want to pause it when you are not using it. This is possible using <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/hf_api#huggingface_hub.HfApi.pause_space">pause_space()</a>. A paused Space will be
inactive until the owner of the Space restarts it, either with the UI or via API using <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/hf_api#huggingface_hub.HfApi.restart_space">restart_space()</a>.
For more details about paused mode, please refer to <a href="https://huggingface.co/docs/hub/spaces-gpus#pause" rel="nofollow">this section</a>`,ds,ae,ws,ne,Ul=`Another possibility is to set a timeout for your Space. If your Space is inactive for more than the timeout duration,
it will go to sleep. Any visitor landing on your Space will start it back up. You can set a timeout using
<a href="/docs/huggingface_hub/v0.19.2/en/package_reference/hf_api#huggingface_hub.HfApi.set_space_sleep_time">set_space_sleep_time()</a>. For more details about sleeping mode, please refer to <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">this section</a>.`,Js,pe,Ts,ie,fl=`Note: if you are using a ‘cpu-basic’ hardware, you cannot configure a custom sleep time. Your Space will automatically
be paused after 48h of inactivity.`,Us,re,gl="<strong>Bonus: set a sleep time while requesting hardware</strong>",fs,Me,Il="Upgraded hardware will be automatically assigned to your Space once it’s built.",gs,ce,Is,oe,_l="<strong>Bonus: set a sleep time when creating or duplicating the Space!</strong>",_s,ye,ks,ue,Cs,je,kl="<strong>6. Add persistent storage to your Space</strong>",Bs,me,Cl='You can choose the storage tier of your choice to access disk space that persists across restarts of your Space. This means you can read and write from disk like you would with a traditional hard drive. See <a href="https://huggingface.co/docs/hub/spaces-storage#persistent-storage" rel="nofollow">docs</a> for more details.',Zs,he,Gs,de,Bl="You can also delete your storage, losing all the data permanently.",$s,we,bs,Je,Zl=`Note: You cannot decrease the storage tier of your space once it’s been granted. To do so,
you must delete the storage first then request the new desired tier.`,Xs,Te,Gl="<strong>Bonus: request storage when creating or duplicating the Space!</strong>",As,Ue,Ss,fe,Es,ge,Ns,Ie,$l=`Spaces allow for a lot of different use cases. Sometimes, you might want
to temporarily run a Space on a specific hardware, do something and then shut it down. In
this section, we will explore how to benefit from Spaces to finetune a model on demand.
This is only one way of solving this particular problem. It has to be taken as a suggestion
and adapted to your use case.`,vs,_e,bl=`Let’s assume we have a Space to finetune a model. It is a Gradio app that takes as input
a model id and a dataset id. The workflow is as follows:`,Rs,f,Xl="<li>(Prompt the user for a model and a dataset)</li> <li>Load the model from the Hub.</li> <li>Load the dataset from the Hub.</li> <li>Finetune the model on the dataset.</li> <li>Upload the new model to the Hub.</li>",Fs,ke,Al=`Step 3. requires a custom hardware but you don’t want your Space to be running all the time on a paid
GPU. A solution is to dynamically request hardware for the training and shut it
down afterwards. Since requesting hardware restarts your Space, your app must somehow “remember”
the current task it is performing. There are multiple ways of doing this. In this guide
we will see one solution using a Dataset as “task scheduler”.`,Ys,Ce,Vs,Be,Sl=`Here is what your app would look like. On startup, check if a task is scheduled and if yes,
run it on the correct hardware. Once done, set back hardware to the free-plan CPU and
prompt the user for a new task.`,Qs,g,Ws,Ze,qs,Ge,Hs,$e,El=`Scheduling tasks can be done in many ways. Here is an example how it could be done using
a simple CSV stored as a Dataset.`,xs,be,zs,Xe,Ls;return I=new Ae({props:{title:"Manage your Space",local:"manage-your-space",headingTag:"h1"}}),k=new Ae({props:{title:"A simple example: configure secrets and hardware.",local:"a-simple-example-configure-secrets-and-hardware",headingTag:"h2"}}),Z=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBcmVwb19pZCUyMCUzRCUyMCUyMldhdXBsaW4lMkZteS1jb29sLXRyYWluaW5nLXNwYWNlJTIyJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5jcmVhdGVfcmVwbyhyZXBvX2lkJTNEcmVwb19pZCUyQyUyMHJlcG9fdHlwZSUzRCUyMnNwYWNlJTIyJTJDJTIwc3BhY2Vfc2RrJTNEJTIyZ3JhZGlvJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;Wauplin/my-cool-training-space&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># For example with a Gradio SDK</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(repo_id=repo_id, repo_type=<span class="hljs-string">&quot;space&quot;</span>, space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>)`,wrap:!1}}),b=new d({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMjJtdWx0aW1vZGFsYXJ0JTJGZHJlYW1ib290aC10cmFpbmluZyUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>)',wrap:!1}}),S=new d({props:{code:"YXBpLnVwbG9hZF9mb2xkZXIocmVwb19pZCUzRHJlcG9faWQlMkMlMjByZXBvX3R5cGUlM0QlMjJzcGFjZSUyMiUyQyUyMGZvbGRlcl9wYXRoJTNEJTIyc3JjJTJGJTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(repo_id=repo_id, repo_type=<span class="hljs-string">&quot;space&quot;</span>, folder_path=<span class="hljs-string">&quot;src/&quot;</span>)',wrap:!1}}),R=new d({props:{code:"YXBpLmFkZF9zcGFjZV9zZWNyZXQocmVwb19pZCUzRHJlcG9faWQlMkMlMjBrZXklM0QlMjJIRl9UT0tFTiUyMiUyQyUyMHZhbHVlJTNEJTIyaGZfYXBpXyoqKiUyMiklMEFhcGkuYWRkX3NwYWNlX3ZhcmlhYmxlKHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwa2V5JTNEJTIyTU9ERUxfUkVQT19JRCUyMiUyQyUyMHZhbHVlJTNEJTIydXNlciUyRnJlcG8lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.add_space_secret(repo_id=repo_id, key=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>, value=<span class="hljs-string">&quot;hf_api_***&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.add_space_variable(repo_id=repo_id, key=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>, value=<span class="hljs-string">&quot;user/repo&quot;</span>)`,wrap:!1}}),Y=new d({props:{code:"YXBpLmRlbGV0ZV9zcGFjZV9zZWNyZXQocmVwb19pZCUzRHJlcG9faWQlMkMlMjBrZXklM0QlMjJIRl9UT0tFTiUyMiklMEFhcGkuZGVsZXRlX3NwYWNlX3ZhcmlhYmxlKHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwa2V5JTNEJTIyTU9ERUxfUkVQT19JRCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.delete_space_secret(repo_id=repo_id, key=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.delete_space_variable(repo_id=repo_id, key=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>)`,wrap:!1}}),T=new Ps({props:{$$slots:{default:[zl]},$$scope:{ctx:J}}}),U=new Ps({props:{warning:!0,$$slots:{default:[Ll]},$$scope:{ctx:J}}}),W=new d({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZWNyZXRzJTNEJTVCJTdCJTIya2V5JTIyJTNEJTIySEZfVE9LRU4lMjIlMkMlMjAlMjJ2YWx1ZSUyMiUzRCUyMmhmX2FwaV8qKiolMjIlN0QlMkMlMjAuLi4lNUQlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV92YXJpYWJsZXMlM0QlNUIlN0IlMjJrZXklMjIlM0QlMjJNT0RFTF9SRVBPX0lEJTIyJTJDJTIwJTIydmFsdWUlMjIlM0QlMjJ1c2VyJTJGcmVwbyUyMiU3RCUyQyUyMC4uLiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>,
<span class="hljs-meta">... </span>    space_secrets=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;hf_api_***&quot;</span>}, ...],
<span class="hljs-meta">... </span>    space_variables=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;user/repo&quot;</span>}, ...],
<span class="hljs-meta">... </span>)`,wrap:!1}}),q=new d({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMHNlY3JldHMlM0QlNUIlN0IlMjJrZXklMjIlM0QlMjJIRl9UT0tFTiUyMiUyQyUyMCUyMnZhbHVlJTIyJTNEJTIyaGZfYXBpXyoqKiUyMiU3RCUyQyUyMC4uLiU1RCUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhYmxlcyUzRCU1QiU3QiUyMmtleSUyMiUzRCUyMk1PREVMX1JFUE9fSUQlMjIlMkMlMjAlMjJ2YWx1ZSUyMiUzRCUyMnVzZXIlMkZyZXBvJTIyJTdEJTJDJTIwLi4uJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    secrets=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;hf_api_***&quot;</span>}, ...],
<span class="hljs-meta">... </span>    variables=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;user/repo&quot;</span>}, ...],
<span class="hljs-meta">... </span>)`,wrap:!1}}),z=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFNwYWNlSGFyZHdhcmUlMEFhcGkucmVxdWVzdF9zcGFjZV9oYXJkd2FyZShyZXBvX2lkJTNEcmVwb19pZCUyQyUyMGhhcmR3YXJlJTNEU3BhY2VIYXJkd2FyZS5UNF9NRURJVU0pJTBBJTBBYXBpLnJlcXVlc3Rfc3BhY2VfaGFyZHdhcmUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBoYXJkd2FyZSUzRCUyMnQ0LW1lZGl1bSUyMik=",highlighted:`<span class="hljs-comment"># Use \`SpaceHardware\` enum</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> SpaceHardware
<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_hardware(repo_id=repo_id, hardware=SpaceHardware.T4_MEDIUM)

<span class="hljs-comment"># Or simply pass a string value</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_hardware(repo_id=repo_id, hardware=<span class="hljs-string">&quot;t4-medium&quot;</span>)`,wrap:!1}}),D=new d({props:{code:"cnVudGltZSUyMCUzRCUyMGFwaS5nZXRfc3BhY2VfcnVudGltZShyZXBvX2lkJTNEcmVwb19pZCklMEFydW50aW1lLnN0YWdlJTBBcnVudGltZS5oYXJkd2FyZSUwQXJ1bnRpbWUucmVxdWVzdGVkX2hhcmR3YXJl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>runtime = api.get_space_runtime(repo_id=repo_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>runtime.stage
<span class="hljs-string">&quot;RUNNING_BUILDING&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>runtime.hardware
<span class="hljs-string">&quot;cpu-basic&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>runtime.requested_hardware
<span class="hljs-string">&quot;t4-medium&quot;</span>`,wrap:!1}}),ee=new d({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMEElMjAlMjAlMjAlMjBzcGFjZV9oYXJkd2FyZSUzRCUyMmNwdS11cGdyYWRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BhY2Vfc3RvcmFnZSUzRCUyMnNtYWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BhY2Vfc2xlZXBfdGltZSUzRCUyMjcyMDAlMjIlMkMlMjAlMjMlMjAyJTIwaG91cnMlMjBpbiUyMHNlY3MlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>
<span class="hljs-meta">... </span>    space_hardware=<span class="hljs-string">&quot;cpu-upgrade&quot;</span>,
<span class="hljs-meta">... </span>    space_storage=<span class="hljs-string">&quot;small&quot;</span>,
<span class="hljs-meta">... </span>    space_sleep_time=<span class="hljs-string">&quot;7200&quot;</span>, <span class="hljs-comment"># 2 hours in secs</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),se=new d({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMGhhcmR3YXJlJTNEJTIyY3B1LXVwZ3JhZGUlMjIlMkMlMEElMjAlMjAlMjAlMjBzdG9yYWdlJTNEJTIyc21hbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBzbGVlcF90aW1lJTNEJTIyNzIwMCUyMiUyQyUyMCUyMyUyMDIlMjBob3VycyUyMGluJTIwc2VjcyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    hardware=<span class="hljs-string">&quot;cpu-upgrade&quot;</span>,
<span class="hljs-meta">... </span>    storage=<span class="hljs-string">&quot;small&quot;</span>,
<span class="hljs-meta">... </span>    sleep_time=<span class="hljs-string">&quot;7200&quot;</span>, <span class="hljs-comment"># 2 hours in secs</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),ae=new d({props:{code:"YXBpLnBhdXNlX3NwYWNlKHJlcG9faWQlM0RyZXBvX2lkKSUwQWFwaS5yZXN0YXJ0X3NwYWNlKHJlcG9faWQlM0RyZXBvX2lkKQ==",highlighted:`<span class="hljs-comment"># Pause your Space to avoid getting billed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.pause_space(repo_id=repo_id)
<span class="hljs-comment"># (...)</span>
<span class="hljs-comment"># Restart it when you need it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.restart_space(repo_id=repo_id)`,wrap:!1}}),pe=new d({props:{code:"YXBpLnNldF9zcGFjZV9zbGVlcF90aW1lKHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwc2xlZXBfdGltZSUzRDM2MDAp",highlighted:`<span class="hljs-comment"># Put your Space to sleep after 1h of inactivity</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.set_space_sleep_time(repo_id=repo_id, sleep_time=<span class="hljs-number">3600</span>)`,wrap:!1}}),ce=new d({props:{code:"YXBpLnJlcXVlc3Rfc3BhY2VfaGFyZHdhcmUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBoYXJkd2FyZSUzRFNwYWNlSGFyZHdhcmUuVDRfTUVESVVNJTJDJTIwc2xlZXBfdGltZSUzRDM2MDAp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_hardware(repo_id=repo_id, hardware=SpaceHardware.T4_MEDIUM, sleep_time=<span class="hljs-number">3600</span>)',wrap:!1}}),ye=new d({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMEElMjAlMjAlMjAlMjBzcGFjZV9oYXJkd2FyZSUzRCUyMnQ0LW1lZGl1bSUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwYWNlX3NsZWVwX3RpbWUlM0QlMjIzNjAwJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>
<span class="hljs-meta">... </span>    space_hardware=<span class="hljs-string">&quot;t4-medium&quot;</span>,
<span class="hljs-meta">... </span>    space_sleep_time=<span class="hljs-string">&quot;3600&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ue=new d({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMGhhcmR3YXJlJTNEJTIydDQtbWVkaXVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2xlZXBfdGltZSUzRCUyMjM2MDAlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    hardware=<span class="hljs-string">&quot;t4-medium&quot;</span>,
<span class="hljs-meta">... </span>    sleep_time=<span class="hljs-string">&quot;3600&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),he=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFNwYWNlU3RvcmFnZSUwQWFwaS5yZXF1ZXN0X3NwYWNlX3N0b3JhZ2UocmVwb19pZCUzRHJlcG9faWQlMkMlMjBzdG9yYWdlJTNEU3BhY2VTdG9yYWdlLkxBUkdFKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> SpaceStorage
<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_storage(repo_id=repo_id, storage=SpaceStorage.LARGE)`,wrap:!1}}),we=new d({props:{code:"YXBpLmRlbGV0ZV9zcGFjZV9zdG9yYWdlKHJlcG9faWQlM0RyZXBvX2lkKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.delete_space_storage(repo_id=repo_id)',wrap:!1}}),Ue=new d({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMEElMjAlMjAlMjAlMjBzcGFjZV9zdG9yYWdlJTNEJTIybGFyZ2UlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>
<span class="hljs-meta">... </span>    space_storage=<span class="hljs-string">&quot;large&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),fe=new d({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMHN0b3JhZ2UlM0QlMjJsYXJnZSUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    storage=<span class="hljs-string">&quot;large&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ge=new Ae({props:{title:"More advanced: temporarily upgrade your Space !",local:"more-advanced-temporarily-upgrade-your-space-",headingTag:"h2"}}),Ce=new Ae({props:{title:"App skeleton",local:"app-skeleton",headingTag:"h3"}}),g=new Ps({props:{warning:!0,$$slots:{default:[Dl]},$$scope:{ctx:J}}}),Ze=new d({props:{code:"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",highlighted:`<span class="hljs-comment"># Space will need your token to request hardware: set it as a Secret !</span>
HF_TOKEN = os.environ.get(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)

<span class="hljs-comment"># Space own repo_id</span>
TRAINING_SPACE_ID = <span class="hljs-string">&quot;Wauplin/dreambooth-training&quot;</span>

<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, SpaceHardware
api = HfApi(token=HF_TOKEN)

<span class="hljs-comment"># On Space startup, check if a task is scheduled. If yes, finetune the model. If not,</span>
<span class="hljs-comment"># display an interface to request a new task.</span>
task = get_task()
<span class="hljs-keyword">if</span> task <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># Start Gradio app</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">gradio_fn</span>(<span class="hljs-params">task</span>):
        <span class="hljs-comment"># On user request, add task and request hardware</span>
        add_task(task)
        api.request_space_hardware(repo_id=TRAINING_SPACE_ID, hardware=SpaceHardware.T4_MEDIUM)

    gr.Interface(fn=gradio_fn, ...).launch()
<span class="hljs-keyword">else</span>:
    runtime = api.get_space_runtime(repo_id=TRAINING_SPACE_ID)
    <span class="hljs-comment"># Check if Space is loaded with a GPU.</span>
    <span class="hljs-keyword">if</span> runtime.hardware == SpaceHardware.T4_MEDIUM:
        <span class="hljs-comment"># If yes, finetune base model on dataset !</span>
        train_and_upload(task)

        <span class="hljs-comment"># Then, mark the task as &quot;DONE&quot;</span>
        mark_as_done(task)

        <span class="hljs-comment"># DO NOT FORGET: set back CPU hardware</span>
        api.request_space_hardware(repo_id=TRAINING_SPACE_ID, hardware=SpaceHardware.CPU_BASIC)
    <span class="hljs-keyword">else</span>:
        api.request_space_hardware(repo_id=TRAINING_SPACE_ID, hardware=SpaceHardware.T4_MEDIUM)`,wrap:!1}}),Ge=new Ae({props:{title:"Task scheduler",local:"task-scheduler",headingTag:"h3"}}),be=new d({props:{code:"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",highlighted:`<span class="hljs-comment"># Dataset ID in which a \`tasks.csv\` file contains the tasks to perform.</span>
<span class="hljs-comment"># Here is a basic example for \`tasks.csv\` containing inputs (base model and dataset)</span>
<span class="hljs-comment"># and status (PENDING or DONE).</span>
<span class="hljs-comment">#     multimodalart/sd-fine-tunable,Wauplin/concept-1,DONE</span>
<span class="hljs-comment">#     multimodalart/sd-fine-tunable,Wauplin/concept-2,PENDING</span>
TASK_DATASET_ID = <span class="hljs-string">&quot;Wauplin/dreambooth-task-scheduler&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">_get_csv_file</span>():
    <span class="hljs-keyword">return</span> hf_hub_download(repo_id=TASK_DATASET_ID, filename=<span class="hljs-string">&quot;tasks.csv&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, token=HF_TOKEN)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_task</span>():
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(_get_csv_file()) <span class="hljs-keyword">as</span> csv_file:
        csv_reader = csv.reader(csv_file, delimiter=<span class="hljs-string">&#x27;,&#x27;</span>)
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> csv_reader:
            <span class="hljs-keyword">if</span> row[<span class="hljs-number">2</span>] == <span class="hljs-string">&quot;PENDING&quot;</span>:
                <span class="hljs-keyword">return</span> row[<span class="hljs-number">0</span>], row[<span class="hljs-number">1</span>] <span class="hljs-comment"># model_id, dataset_id</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">add_task</span>(<span class="hljs-params">task</span>):
    model_id, dataset_id = task
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(_get_csv_file()) <span class="hljs-keyword">as</span> csv_file:
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(csv_file, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
            tasks = f.read()

    api.upload_file(
        repo_id=repo_id,
        repo_type=repo_type,
        path_in_repo=<span class="hljs-string">&quot;tasks.csv&quot;</span>,
        <span class="hljs-comment"># Quick and dirty way to add a task</span>
        path_or_fileobj=(tasks + <span class="hljs-string">f&quot;\\n<span class="hljs-subst">{model_id}</span>,<span class="hljs-subst">{dataset_id}</span>,PENDING&quot;</span>).encode()
    )

<span class="hljs-keyword">def</span> <span class="hljs-title function_">mark_as_done</span>(<span class="hljs-params">task</span>):
    model_id, dataset_id = task
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(_get_csv_file()) <span class="hljs-keyword">as</span> csv_file:
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(csv_file, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
            tasks = f.read()

    api.upload_file(
        repo_id=repo_id,
        repo_type=repo_type,
        path_in_repo=<span class="hljs-string">&quot;tasks.csv&quot;</span>,
        <span class="hljs-comment"># Quick and dirty way to set the task as DONE</span>
        path_or_fileobj=tasks.replace(
            <span class="hljs-string">f&quot;<span class="hljs-subst">{model_id}</span>,<span class="hljs-subst">{dataset_id}</span>,PENDING&quot;</span>,
            <span class="hljs-string">f&quot;<span class="hljs-subst">{model_id}</span>,<span class="hljs-subst">{dataset_id}</span>,DONE&quot;</span>
        ).encode()
    )`,wrap:!1}}),{c(){m=p("meta"),h=a(),w=p("p"),Se=a(),M(I.$$.fragment),Ee=a(),_=p("p"),_.innerHTML=el,Ne=a(),M(k.$$.fragment),ve=a(),C=p("p"),C.textContent=sl,Re=a(),B=p("p"),B.innerHTML=ll,Fe=a(),M(Z.$$.fragment),Ye=a(),G=p("p"),G.innerHTML=tl,Ve=a(),$=p("p"),$.innerHTML=al,Qe=a(),M(b.$$.fragment),We=a(),X=p("p"),X.innerHTML=nl,qe=a(),A=p("p"),A.innerHTML=pl,He=a(),M(S.$$.fragment),xe=a(),E=p("p"),E.textContent=il,ze=a(),N=p("p"),N.innerHTML=rl,Le=a(),v=p("p"),v.innerHTML=Ml,De=a(),M(R.$$.fragment),Pe=a(),F=p("p"),F.textContent=cl,Ke=a(),M(Y.$$.fragment),Oe=a(),M(T.$$.fragment),es=a(),M(U.$$.fragment),ss=a(),V=p("p"),V.innerHTML=ol,ls=a(),Q=p("p"),Q.textContent=yl,ts=a(),M(W.$$.fragment),as=a(),M(q.$$.fragment),ns=a(),H=p("p"),H.innerHTML=ul,ps=a(),x=p("p"),x.innerHTML=jl,is=a(),M(z.$$.fragment),rs=a(),L=p("p"),L.textContent=ml,Ms=a(),M(D.$$.fragment),cs=a(),P=p("p"),P.textContent=hl,os=a(),K=p("p"),K.innerHTML=dl,ys=a(),O=p("p"),O.textContent=wl,us=a(),M(ee.$$.fragment),js=a(),M(se.$$.fragment),ms=a(),le=p("p"),le.innerHTML=Jl,hs=a(),te=p("p"),te.innerHTML=Tl,ds=a(),M(ae.$$.fragment),ws=a(),ne=p("p"),ne.innerHTML=Ul,Js=a(),M(pe.$$.fragment),Ts=a(),ie=p("p"),ie.textContent=fl,Us=a(),re=p("p"),re.innerHTML=gl,fs=a(),Me=p("p"),Me.textContent=Il,gs=a(),M(ce.$$.fragment),Is=a(),oe=p("p"),oe.innerHTML=_l,_s=a(),M(ye.$$.fragment),ks=a(),M(ue.$$.fragment),Cs=a(),je=p("p"),je.innerHTML=kl,Bs=a(),me=p("p"),me.innerHTML=Cl,Zs=a(),M(he.$$.fragment),Gs=a(),de=p("p"),de.textContent=Bl,$s=a(),M(we.$$.fragment),bs=a(),Je=p("p"),Je.textContent=Zl,Xs=a(),Te=p("p"),Te.innerHTML=Gl,As=a(),M(Ue.$$.fragment),Ss=a(),M(fe.$$.fragment),Es=a(),M(ge.$$.fragment),Ns=a(),Ie=p("p"),Ie.textContent=$l,vs=a(),_e=p("p"),_e.textContent=bl,Rs=a(),f=p("ol"),f.innerHTML=Xl,Fs=a(),ke=p("p"),ke.textContent=Al,Ys=a(),M(Ce.$$.fragment),Vs=a(),Be=p("p"),Be.textContent=Sl,Qs=a(),M(g.$$.fragment),Ws=a(),M(Ze.$$.fragment),qs=a(),M(Ge.$$.fragment),Hs=a(),$e=p("p"),$e.textContent=El,xs=a(),M(be.$$.fragment),zs=a(),Xe=p("p"),this.h()},l(e){const s=ql("svelte-u9bgzb",document.head);m=i(s,"META",{name:!0,content:!0}),s.forEach(l),h=n(e),w=i(e,"P",{}),Fl(w).forEach(l),Se=n(e),c(I.$$.fragment,e),Ee=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1ppnonz"&&(_.innerHTML=el),Ne=n(e),c(k.$$.fragment,e),ve=n(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-16uv4iz"&&(C.textContent=sl),Re=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-ntfke8"&&(B.innerHTML=ll),Fe=n(e),c(Z.$$.fragment,e),Ye=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-18k6wu9"&&(G.innerHTML=tl),Ve=n(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-g6o1w2"&&($.innerHTML=al),Qe=n(e),c(b.$$.fragment,e),We=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-hnqkcz"&&(X.innerHTML=nl),qe=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-8mheo9"&&(A.innerHTML=pl),He=n(e),c(S.$$.fragment,e),xe=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1z3goh"&&(E.textContent=il),ze=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1sfgan5"&&(N.innerHTML=rl),Le=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1704hn0"&&(v.innerHTML=Ml),De=n(e),c(R.$$.fragment,e),Pe=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-65kjzl"&&(F.textContent=cl),Ke=n(e),c(Y.$$.fragment,e),Oe=n(e),c(T.$$.fragment,e),es=n(e),c(U.$$.fragment,e),ss=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-poxyid"&&(V.innerHTML=ol),ls=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1rmjpll"&&(Q.textContent=yl),ts=n(e),c(W.$$.fragment,e),as=n(e),c(q.$$.fragment,e),ns=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-vobpqe"&&(H.innerHTML=ul),ps=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1ctsnq4"&&(x.innerHTML=jl),is=n(e),c(z.$$.fragment,e),rs=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-aczhvz"&&(L.textContent=ml),Ms=n(e),c(D.$$.fragment,e),cs=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-c540cm"&&(P.textContent=hl),os=n(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-jbzoo9"&&(K.innerHTML=dl),ys=n(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-4tl7ie"&&(O.textContent=wl),us=n(e),c(ee.$$.fragment,e),js=n(e),c(se.$$.fragment,e),ms=n(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1i0f4op"&&(le.innerHTML=Jl),hs=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-15nkl4i"&&(te.innerHTML=Tl),ds=n(e),c(ae.$$.fragment,e),ws=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-dw36b2"&&(ne.innerHTML=Ul),Js=n(e),c(pe.$$.fragment,e),Ts=n(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-97ry2r"&&(ie.textContent=fl),Us=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1lxv1bl"&&(re.innerHTML=gl),fs=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-4tl7ie"&&(Me.textContent=Il),gs=n(e),c(ce.$$.fragment,e),Is=n(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-5hjx5j"&&(oe.innerHTML=_l),_s=n(e),c(ye.$$.fragment,e),ks=n(e),c(ue.$$.fragment,e),Cs=n(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-pvw90y"&&(je.innerHTML=kl),Bs=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-2qrjmq"&&(me.innerHTML=Cl),Zs=n(e),c(he.$$.fragment,e),Gs=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1u6d0ko"&&(de.textContent=Bl),$s=n(e),c(we.$$.fragment,e),bs=n(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-m35g6d"&&(Je.textContent=Zl),Xs=n(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1mxuks2"&&(Te.innerHTML=Gl),As=n(e),c(Ue.$$.fragment,e),Ss=n(e),c(fe.$$.fragment,e),Es=n(e),c(ge.$$.fragment,e),Ns=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1gmpxen"&&(Ie.textContent=$l),vs=n(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-10q1pgf"&&(_e.textContent=bl),Rs=n(e),f=i(e,"OL",{start:!0,"data-svelte-h":!0}),r(f)!=="svelte-1guz9nt"&&(f.innerHTML=Xl),Fs=n(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-14y67eb"&&(ke.textContent=Al),Ys=n(e),c(Ce.$$.fragment,e),Vs=n(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-16rgffk"&&(Be.textContent=Sl),Qs=n(e),c(g.$$.fragment,e),Ws=n(e),c(Ze.$$.fragment,e),qs=n(e),c(Ge.$$.fragment,e),Hs=n(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1fps41q"&&($e.textContent=El),xs=n(e),c(be.$$.fragment,e),zs=n(e),Xe=i(e,"P",{}),Fl(Xe).forEach(l),this.h()},h(){Ds(m,"name","hf:doc:metadata"),Ds(m,"content",Kl),Ds(f,"start","0")},m(e,s){Hl(document.head,m),t(e,h,s),t(e,w,s),t(e,Se,s),o(I,e,s),t(e,Ee,s),t(e,_,s),t(e,Ne,s),o(k,e,s),t(e,ve,s),t(e,C,s),t(e,Re,s),t(e,B,s),t(e,Fe,s),o(Z,e,s),t(e,Ye,s),t(e,G,s),t(e,Ve,s),t(e,$,s),t(e,Qe,s),o(b,e,s),t(e,We,s),t(e,X,s),t(e,qe,s),t(e,A,s),t(e,He,s),o(S,e,s),t(e,xe,s),t(e,E,s),t(e,ze,s),t(e,N,s),t(e,Le,s),t(e,v,s),t(e,De,s),o(R,e,s),t(e,Pe,s),t(e,F,s),t(e,Ke,s),o(Y,e,s),t(e,Oe,s),o(T,e,s),t(e,es,s),o(U,e,s),t(e,ss,s),t(e,V,s),t(e,ls,s),t(e,Q,s),t(e,ts,s),o(W,e,s),t(e,as,s),o(q,e,s),t(e,ns,s),t(e,H,s),t(e,ps,s),t(e,x,s),t(e,is,s),o(z,e,s),t(e,rs,s),t(e,L,s),t(e,Ms,s),o(D,e,s),t(e,cs,s),t(e,P,s),t(e,os,s),t(e,K,s),t(e,ys,s),t(e,O,s),t(e,us,s),o(ee,e,s),t(e,js,s),o(se,e,s),t(e,ms,s),t(e,le,s),t(e,hs,s),t(e,te,s),t(e,ds,s),o(ae,e,s),t(e,ws,s),t(e,ne,s),t(e,Js,s),o(pe,e,s),t(e,Ts,s),t(e,ie,s),t(e,Us,s),t(e,re,s),t(e,fs,s),t(e,Me,s),t(e,gs,s),o(ce,e,s),t(e,Is,s),t(e,oe,s),t(e,_s,s),o(ye,e,s),t(e,ks,s),o(ue,e,s),t(e,Cs,s),t(e,je,s),t(e,Bs,s),t(e,me,s),t(e,Zs,s),o(he,e,s),t(e,Gs,s),t(e,de,s),t(e,$s,s),o(we,e,s),t(e,bs,s),t(e,Je,s),t(e,Xs,s),t(e,Te,s),t(e,As,s),o(Ue,e,s),t(e,Ss,s),o(fe,e,s),t(e,Es,s),o(ge,e,s),t(e,Ns,s),t(e,Ie,s),t(e,vs,s),t(e,_e,s),t(e,Rs,s),t(e,f,s),t(e,Fs,s),t(e,ke,s),t(e,Ys,s),o(Ce,e,s),t(e,Vs,s),t(e,Be,s),t(e,Qs,s),o(g,e,s),t(e,Ws,s),o(Ze,e,s),t(e,qs,s),o(Ge,e,s),t(e,Hs,s),t(e,$e,s),t(e,xs,s),o(be,e,s),t(e,zs,s),t(e,Xe,s),Ls=!0},p(e,[s]){const Nl={};s&2&&(Nl.$$scope={dirty:s,ctx:e}),T.$set(Nl);const vl={};s&2&&(vl.$$scope={dirty:s,ctx:e}),U.$set(vl);const Rl={};s&2&&(Rl.$$scope={dirty:s,ctx:e}),g.$set(Rl)},i(e){Ls||(y(I.$$.fragment,e),y(k.$$.fragment,e),y(Z.$$.fragment,e),y(b.$$.fragment,e),y(S.$$.fragment,e),y(R.$$.fragment,e),y(Y.$$.fragment,e),y(T.$$.fragment,e),y(U.$$.fragment,e),y(W.$$.fragment,e),y(q.$$.fragment,e),y(z.$$.fragment,e),y(D.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),y(ae.$$.fragment,e),y(pe.$$.fragment,e),y(ce.$$.fragment,e),y(ye.$$.fragment,e),y(ue.$$.fragment,e),y(he.$$.fragment,e),y(we.$$.fragment,e),y(Ue.$$.fragment,e),y(fe.$$.fragment,e),y(ge.$$.fragment,e),y(Ce.$$.fragment,e),y(g.$$.fragment,e),y(Ze.$$.fragment,e),y(Ge.$$.fragment,e),y(be.$$.fragment,e),Ls=!0)},o(e){u(I.$$.fragment,e),u(k.$$.fragment,e),u(Z.$$.fragment,e),u(b.$$.fragment,e),u(S.$$.fragment,e),u(R.$$.fragment,e),u(Y.$$.fragment,e),u(T.$$.fragment,e),u(U.$$.fragment,e),u(W.$$.fragment,e),u(q.$$.fragment,e),u(z.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(ye.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(we.$$.fragment,e),u(Ue.$$.fragment,e),u(fe.$$.fragment,e),u(ge.$$.fragment,e),u(Ce.$$.fragment,e),u(g.$$.fragment,e),u(Ze.$$.fragment,e),u(Ge.$$.fragment,e),u(be.$$.fragment,e),Ls=!1},d(e){e&&(l(h),l(w),l(Se),l(Ee),l(_),l(Ne),l(ve),l(C),l(Re),l(B),l(Fe),l(Ye),l(G),l(Ve),l($),l(Qe),l(We),l(X),l(qe),l(A),l(He),l(xe),l(E),l(ze),l(N),l(Le),l(v),l(De),l(Pe),l(F),l(Ke),l(Oe),l(es),l(ss),l(V),l(ls),l(Q),l(ts),l(as),l(ns),l(H),l(ps),l(x),l(is),l(rs),l(L),l(Ms),l(cs),l(P),l(os),l(K),l(ys),l(O),l(us),l(js),l(ms),l(le),l(hs),l(te),l(ds),l(ws),l(ne),l(Js),l(Ts),l(ie),l(Us),l(re),l(fs),l(Me),l(gs),l(Is),l(oe),l(_s),l(ks),l(Cs),l(je),l(Bs),l(me),l(Zs),l(Gs),l(de),l($s),l(bs),l(Je),l(Xs),l(Te),l(As),l(Ss),l(Es),l(Ns),l(Ie),l(vs),l(_e),l(Rs),l(f),l(Fs),l(ke),l(Ys),l(Vs),l(Be),l(Qs),l(Ws),l(qs),l(Hs),l($e),l(xs),l(zs),l(Xe)),l(m),j(I,e),j(k,e),j(Z,e),j(b,e),j(S,e),j(R,e),j(Y,e),j(T,e),j(U,e),j(W,e),j(q,e),j(z,e),j(D,e),j(ee,e),j(se,e),j(ae,e),j(pe,e),j(ce,e),j(ye,e),j(ue,e),j(he,e),j(we,e),j(Ue,e),j(fe,e),j(ge,e),j(Ce,e),j(g,e),j(Ze,e),j(Ge,e),j(be,e)}}}const Kl='{"title":"Manage your Space","local":"manage-your-space","sections":[{"title":"A simple example: configure secrets and hardware.","local":"a-simple-example-configure-secrets-and-hardware","sections":[],"depth":2},{"title":"More advanced: temporarily upgrade your Space !","local":"more-advanced-temporarily-upgrade-your-space-","sections":[{"title":"App skeleton","local":"app-skeleton","sections":[],"depth":3},{"title":"Task scheduler","local":"task-scheduler","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ol(J){return Vl(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=xl}),[]}class nt extends Ql{constructor(m){super(),Wl(this,m,Ol,Pl,Yl,{})}}export{nt as component};
