import{s as Za,o as Va,n as va}from"../chunks/scheduler.37c15a92.js";import{S as _a,i as Ba,g as a,s as n,r as M,A as Wa,h as r,f as t,c as p,j as za,u as J,x as i,k as pp,y as Qa,a as l,v as m,d as o,t as y,w as j}from"../chunks/index.2bf4358c.js";import{T as Ra}from"../chunks/Tip.363c041f.js";import{Y as Xa}from"../chunks/Youtube.1e50a667.js";import{C as T}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Aa}from"../chunks/CourseFloatingBanner.33a4139d.js";import{H as mt}from"../chunks/Heading.8ada512a.js";function Na(ot){let c,$=`<strong>更进一步</strong>如果您在包含 unicode 字符的字符串上测试先前normalizers的两个版本，您肯定会注意到这两个normalizers并不完全等效。
为了不过度使用 <code>normalizers.Sequence</code> 使版本过于复杂，我们没有包含当 <code>clean_text</code> 参数设置为 <code>True</code> 时 <code>BertNormalizer</code> 需要的正则表达式替换 - 这是默认行为。 但不要担心：通过在normalizer序列中添加两个 <code>normalizers.Replace</code> 可以在不使用方便的 <code>BertNormalizer</code> 的情况下获得完全相同的规范化。`;return{c(){c=a("p"),c.innerHTML=$},l(u){c=r(u,"P",{"data-svelte-h":!0}),i(c)!=="svelte-1b6zdck"&&(c.innerHTML=$)},m(u,Mt){l(u,c,Mt)},p:va,d(u){u&&t(c)}}}function Ga(ot){let c,$,u,Mt,U,yt,g,jt,w,ap="正如我们在前几节中看到的，标记化包括几个步骤：",Tt,b,rp="<li>规范化（任何认为必要的文本清理，例如删除空格或重音符号、Unicode 规范化等）</li> <li>预标记化（将输入拆分为单词）</li> <li>通过模型处理输入（使用预先拆分的词来生成一系列标记）</li> <li>后处理（添加标记器的特殊标记，生成注意力掩码和标记类型 ID）</li>",ct,h,ip="提醒一下，这里再看一下整个过程",ut,f,Mp='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline.svg" alt="The tokenization pipeline."/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline-dark.svg" alt="The tokenization pipeline."/>',ft,d,Jp='🤗 Tokenizers 库旨在为每个步骤提供多个选项，您可以将它们混合和匹配在一起。在本节中，我们将看到如何从头开始构建标记器，而不是像我们<a href="/course/chapter6/2">第二节 2</a>那样从旧的标记器训练新的标记器.然后，您将能够构建您能想到的任何类型的标记器！',kt,x,$t,I,mp="更准确地说，该库是围绕一个中央“Tokenizer”类构建的，构建这个类的每一部分可以在子模块的列表中重新组合：",Ut,C,op='<li><code>normalizers</code> 包含你可以使用的所有可能的Normalizer类型（完整列表<a href="https://huggingface.co/docs/tokenizers/python/latest/api/reference.html#module-tokenizers.normalizers" rel="nofollow">在这里</a>）。</li> <li><code>pre_tokenizesr</code> 包含您可以使用的所有可能的PreTokenizer类型（完整列表<a href="https://huggingface.co/docs/tokenizers/python/latest/api/reference.html#module-tokenizers.pre_tokenizers" rel="nofollow">在这里</a>）。</li> <li><code>models</code> 包含您可以使用的各种类型的Model，如BPE、WordPiece和Unigram（完整列表<a href="https://huggingface.co/docs/tokenizers/python/latest/api/reference.html#module-tokenizers.models" rel="nofollow">在这里</a>）。</li> <li><code>trainers</code> 包含所有不同类型的 trainer，你可以使用一个语料库训练你的模型（每种模型一个；完整列表<a href="https://huggingface.co/docs/tokenizers/python/latest/api/reference.html#module-tokenizers.trainers" rel="nofollow">在这里</a>）。</li> <li><code>post_processors</code> 包含你可以使用的各种类型的PostProcessor（完整列表<a href="https://huggingface.co/docs/tokenizers/python/latest/api/reference.html#module-tokenizers.processors" rel="nofollow">在这里</a>）。</li> <li><code>decoders</code> 包含各种类型的Decoder，可以用来解码标记化的输出（完整列表<a href="https://huggingface.co/docs/tokenizers/python/latest/components.html#decoders" rel="nofollow">在这里</a>）。</li>',gt,z,yp='您可以<a href="https://huggingface.co/docs/tokenizers/python/latest/components.html" rel="nofollow">在这里</a>找到完整的模块列表。',wt,Z,bt,V,jp='为了训练我们的新标记器，我们将使用一个小的文本语料库（因此示例运行得很快）。获取语​​料库的步骤与我们在[在这章的开始]((/course/chapter6/2)那一小节，但这次我们将使用<a href="https://huggingface.co/datasets/wikitext" rel="nofollow">WikiText-2</a>数据集：',ht,v,dt,_,Tp="<strong>get_training_corpus()</strong> 函数是一个生成器，每次调用的时候将产生 1,000 个文本，我们将用它来训练标记器。",xt,B,cp="🤗 Tokenizers 也可以直接在文本文件上进行训练。以下是我们如何生成一个文本文件，其中包含我们可以在本地使用的来自 WikiText-2 的所有文本/输入：",It,W,Ct,Q,up="接下来，我们将向您展示如何逐块构建您自己的 BERT、GPT-2 和 XLNet 标记器。这将为我们提供三个主要标记化算法的示例：WordPiece、BPE 和 Unigram。让我们从 BERT 开始吧！",zt,R,Zt,X,fp="要使用 🤗 Tokenizers 库构建标记器，我们首先使用<strong>model</strong>实例化一个 <strong>Tokenizer</strong> 对象与  ，然后将 <strong>normalizer</strong> , <strong>pre_tokenizer</strong> , <strong>post_processor</strong> ， 和 <strong>decoder</strong> 属性设置成我们想要的值。",Vt,A,kp="对于这个例子，我们将创建一个 <strong>Tokenizer</strong> 使用 WordPiece 模型：",vt,N,_t,G,$p="我们必须指定 <strong>unk_token</strong> 这样模型才知道当它遇到以前没有见过的字符时要返回什么。我们可以在此处设置的其他参数包括我们模型的<strong>vocab（字典）</strong>（我们将训练模型，所以我们不需要设置它）和 <strong>max_input_chars_per_word</strong> 即每个单词的最大长度（比传递的值长的单词将被拆分）",Bt,q,Up="标记化的第一步是规范化，所以让我们从它开始。 由于 BERT 被广泛使用，所以有一个可以使用的 <code>BertNormalizer</code>，我们可以为 BERT 设置经典的选项：<code>lowercase（小写）</code> 和 <code>strip_accents（去除音调）</code>，不言自明； <code>clean_text</code> 删除所有控制字符并将重复的空格替换为一个； 和 <code>handle_chinese_chars</code>，在汉字周围放置空格。 要实现 <code>bert-base-uncased</code> ，我们可以这样设置这个规范器：",Wt,L,Qt,H,gp="然而，一般来说，在构建新的标记器时，您可以使用已经在 🤗 Tokenizers库中实现的非常方便的normalizer——所以让我们看看如何手动创建 BERT normalizer。 该库提供了一个“Lowercase（小写）”的normalizer和一个“StripAccents”的normalizer，您可以使用“序列”组合多个normalizer：",Rt,D,Xt,E,wp="我们也在使用 <strong>NFD</strong> Unicode normalizer，否则 <strong>StripAccents</strong> normalizer 无法正确识别带重音的字符，因此没办法删除它们。",At,S,bp="正如我们之前看到的，我们可以使用 <strong>normalize</strong> 的 <strong>normalize_str()</strong> 方法查看它对给定文本的影响：",Nt,P,Gt,F,qt,k,Lt,Y,hp="接下来是预标记步骤。 同样，我们可以使用一个预构建的“BertPreTokenizer”：",Ht,K,Dt,O,dp="或者我们可以从头开始构建它：",Et,ee,St,se,xp="请注意，<code>Whitespace</code> 预标记器会在空格和所有非字母、数字或下划线字符的字符上进行拆分，因此在本次的例子中上会根据空格和标点符号进行拆分：",Pt,te,Ft,le,Yt,ne,Ip="如果您只想在空白处进行拆分，则应使用 <strong>WhitespaceSplit</strong> 代替预标记器：",Kt,pe,Ot,ae,el,re,Cp="像normalizers一样，您可以使用 <strong>Sequence</strong> 组成几个预标记器：",sl,ie,tl,Me,ll,Je,zp="标记化管道的下一步是输入给模型。我们已经在初始化中指定了我们的模型，但我们仍然需要训练它，这将需要一个 <strong>WordPieceTrainer</strong> .在 🤗 Tokenizers 中实例化训练器时要记住的主要事情是，您需要将您打算使用的所有特殊标记传递给它 - 否则它不会将它们添加到词汇表中，因为它们不在训练语料库中：",nl,me,pl,oe,Zp="以及指定 <strong>vocab_size（词典大小）</strong> 和 <strong>special_tokens（特殊的标记）</strong> ，我们可以设置 <strong>min_frequency</strong> （记号必须出现在词汇表中的次数）或更改 <strong>continuing_subword_prefix</strong> （如果我们想使用与 <strong>##</strong>指代存在与字词相同的前缀 ）。",al,ye,Vp="要使用我们之前定义的迭代器训练我们的模型，我们只需要执行以下命令：",rl,je,il,Te,vp="我们还可以使用文本文件来训练我们的标记器，它看起来像这样（我们需要先初始化一个空的 <strong>WordPiece</strong> ）：",Ml,ce,Jl,ue,_p="在这两种情况下，我们都可以通过调用文本来测试标记器 <strong>encode()</strong> 方法：",ml,fe,ol,ke,yl,$e,Bp="这个 <strong>encoding</strong> 获得的是一个 <strong>Encoding</strong>对象 ，它的属性中包含标记器的所有必要输出： <strong>ids</strong> , <strong>type_ids</strong> , <strong>tokens</strong> , <strong>offsets</strong> , <strong>attention_mask</strong> , <strong>special_tokens_mask</strong> ， 和 <strong>overflowing</strong> .",jl,Ue,Wp="标记化管道的最后一步是后处理。我们需要添加 <strong>[CLS]</strong> 开头的标记和 <strong>[SEP]</strong> 标记在末尾（或在每个句子之后，如果我们有一对句子）。我们将使用一个 <strong>TemplateProcessor</strong> 为此，但首先我们需要知道 <strong>[CLS]</strong> 和 <strong>[SEP]</strong> 在词汇表中的ID：",Tl,ge,cl,we,ul,be,Qp="为了给 <strong>TemplateProcessor</strong> 编写模板，我们必须指定如何处理单个句子和一对句子。对于两者，我们都编写了我们想要使用的特殊标记；第一个（或单个）句子表示为 <strong>$A</strong> ，而第二个句子（如果对一对进行编码）表示为 <strong>$B</strong> .对于这些特殊标记和句子，我们还需要使用在冒号后指定相应的标记类型 ID。",fl,he,Rp="因此经典的 BERT 模板定义如下：",kl,de,$l,xe,Xp="请注意，我们需要传递特殊标记的 ID，以便标记器可以正确地将特殊标记转换为它们的 ID。",Ul,Ie,Ap="添加后，我们之前的示例将输出出：",gl,Ce,wl,ze,bl,Ze,Np="在一对句子中，我们得到了正确的结果：",hl,Ve,dl,ve,xl,_e,Gp="我们几乎从头开始构建了这个标记器——但是还有最后一步是指定一个解码器：",Il,Be,Cl,We,qp="让我们测试一下我们之前的 <strong>encoding</strong> ：",zl,Qe,Zl,Re,Vl,Xe,Lp="很好！我们可以将标记器保存在一个 JSON 文件中，如下所示：",vl,Ae,_l,Ne,Hp="然后我们可以使用<strong>from_file()</strong> 方法从该文件里重新加载 <strong>Tokenizer</strong> 对象：",Bl,Ge,Wl,qe,Dp="要在 🤗 Transformers 中使用这个标记器，我们必须将它包裹在一个 <strong>PreTrainedTokenizerFast</strong> 类中。我们可以使用泛型类，或者，如果我们的标记器对应于现有模型，则使用该类（例如这里的 <strong>BertTokenizerFast</strong> ）。如果您应用本课来构建全新的标记器，则必须使用第一个选项。",Ql,Le,Ep="要将标记器包装在 <code>PreTrainedTokenizerFast</code> 类中，我们可以将我们构建的标记器作为<code>tokenizer_object</code> 传递，或者将我们保存为<code>tokenizer_file</code> 的标记器文件传递。 要记住的关键是我们必须手动设置所有特殊标记，因为该类无法从 <code>tokenizer</code> 对象推断出哪个标记是掩码标记、<code>[CLS]</code> 标记等：",Rl,He,Xl,De,Sp="如果您使用特定的标记器类（例如 <strong>BertTokenizerFast</strong> )，您只需要指定与默认标记不同的特殊标记（此处没有）：",Al,Ee,Nl,Se,Pp="然后，您可以像使用任何其他 🤗 Transformers 标记器一样使用此标记器。你可以用 <strong>save_pretrained()</strong> 方法，或使用 <strong>push_to_hub()</strong> 方法。",Gl,Pe,Fp="现在我们已经了解了如何构建 WordPiece 标记器，让我们对 BPE 标记器进行同样的操作。因为您已经知道了所有步骤，所以我们会进行地更快一点，并且只突出展示两者不一样的地方。",ql,Fe,Ll,Ye,Yp="现在让我们构建一个 GPT-2 标记器。与 BERT 标记器一样，我们首先使用 <strong>Tokenizer</strong> 初始化一个BPE 模型：",Hl,Ke,Dl,Oe,Kp="和 BERT 一样，如果我们有一个词汇表，我们可以用一个词汇表来初始化这个模型（在这种情况下，我们需要传递 <code>vocab</code> 和 <code>merges</code>），但是由于我们将从头开始训练，所以我们不需要这样去做。 我们也不需要指定“unk_token”，因为 GPT-2 使用的字节级 BPE，不需要“unk_token”。",El,es,Op="GPT-2 不使用归一化器，因此我们跳过该步骤并直接进入预标记化：",Sl,ss,Pl,ts,ea="我们在此处添加到 <code>ByteLevel</code> 的选项是不在句子开头添加空格（默认为ture）。 我们可以看一下使用这个标记器对之前示例文本的预标记：",Fl,ls,Yl,ns,Kl,ps,sa="接下来是需要训练的模型。对于 GPT-2，唯一的特殊标记是文本结束标记：",Ol,as,en,rs,ta="与 <code>WordPieceTrainer</code> 以及 <code>vocab_size</code> 和 <code>special_tokens</code> 一样，我们可以指定 <code>min_frequency</code> 如果我们愿意，或者如果我们有一个词尾后缀（如 <code>&lt;/w&gt;</code> )，我们可以使用 <code>end_of_word_suffix</code> 设置它。",sn,is,la="这个标记器也可以在文本文件上训练：",tn,Ms,ln,Js,na="让我们看一下示例文本的标记化后的结果：",nn,ms,pn,os,an,ys,pa="我们对 GPT-2 标记器添加字节级后处理，如下所示：",rn,js,Mn,Ts,aa="<code>trim_offsets = False</code> 选项指示我们应该保留以 ‘Ġ’ 开头的标记的偏移量：这样偏移量的开头将指向单词之前的空格，而不是第一个单词的字符（因为空格在技术上是标记的一部分）。 让我们看看我们刚刚编码的文本的结果，其中 <code>&#39;Ġtest&#39;</code> 是索引第 4 处的标记：",Jn,cs,mn,us,on,fs,ra="最后，我们添加一个字节级解码器：",yn,ks,jn,$s,ia="我们可以仔细检查它是否正常工作：",Tn,Us,cn,gs,un,ws,Ma="很好！现在我们完成了，我们可以像以前一样保存标记器，并将它包装在一个 <strong>PreTrainedTokenizerFast</strong> 或者 <strong>GPT2TokenizerFast</strong> 如果我们想在 🤗 Transformers中使用它：",fn,bs,kn,hs,Ja="或者：",$n,ds,Un,xs,ma="作为最后一个示例，我们将向您展示如何从头开始构建 Unigram 标记器。",gn,Is,wn,Cs,oa="现在让我们构建一个 XLNet 标记器。与之前的标记器一样，我们首先使用 Unigram 模型初始化一个 <strong>Tokenizer</strong> ：",bn,zs,hn,Zs,ya="同样，如果我们有词汇表，我们可以用词汇表初始化这个模型。",dn,Vs,ja="对于标准化，XLNet 使用了一些替换的方法（来自 SentencePiece）：",xn,vs,In,_s,Ta="这会取代 <strong>“</strong> 和 <strong>”</strong> 和 <strong>”</strong> 以及任何两个或多个空格与单个空格的序列，以及删除文本中的重音以进行标记。",Cn,Bs,ca="用于任何 SentencePiece 标记器的预标记器是 <code>Metaspace</code>：",zn,Ws,Zn,Qs,ua="我们可以像以前一样查看示例文本的预标记化：",Vn,Rs,vn,Xs,_n,As,fa="接下来是需要训练的模型。 XLNet 有不少特殊的标记：",Bn,Ns,Wn,Gs,ka="不要忘记<code>UnigramTrainer</code> 的一个非常重要的参数是<code>unk_token</code>。 我们还可以传递特定于 Unigram 算法的其他参数，例如删除标记的每个步骤的“shrinking_factor（收缩因子）”（默认为 0.75）或指定给定标记的最大长度的“max_piece_length”（默认为 16） .",Qn,qs,$a="这个标记器也可以在文本文件上训练：",Rn,Ls,Xn,Hs,Ua="让我们看一下示例文本的标记化后的结果：",An,Ds,Nn,Es,Gn,Ss,ga=`A peculiarity of XLNet is that it puts the <code>&lt;cls&gt;</code> token at the end of the sentence, with a type ID of 2 (to distinguish it from the other tokens). It’s padding on the left, as a result. We can deal with all the special tokens and token type IDs with a template, like for BERT, but first we have to get the IDs of the <code>&lt;cls&gt;</code> and <code>&lt;sep&gt;</code> tokens:
XLNet 的一个特点是它将<code>&lt;cls&gt;</code> 标记放在句子的末尾，类型ID 为2（以将其与其他标记区分开来）。它会将结果填充在左侧。 我们可以使用模板处理所有特殊标记和标记类型 ID，例如 BERT，但首先我们必须获取 <code>&lt;cls&gt;</code> 和 <code>&lt;sep&gt;</code> 标记的 ID：`,qn,Ps,Ln,Fs,Hn,Ys,wa="模板如下所示：",Dn,Ks,En,Os,ba="我们可以通过编码一对句子来测试它的工作原理：",Sn,et,Pn,st,Fn,tt,ha="最后，我们添加一个 <strong>Metaspace</strong> 解码器：",Yn,lt,Kn,nt,da="我们完成了这个标记器！ 我们可以像以前一样保存标记器，如果我们想在 🤗 Transformers 中使用它，可以将它包装在 <code>PreTrainedTokenizerFast</code> 或 <code>XLNetTokenizerFast</code> 中。 使用 <code>PreTrainedTokenizerFast</code> 时要注意的一件事是，我们需要告诉🤗 Transformers 库应该在左侧填充特殊标记：",On,pt,ep,at,xa="或者：",sp,rt,tp,it,Ia="现在您已经了解了如何使用各种构建块来构建现有的标记器，您应该能够使用 🤗 tokenizer库编写您想要的任何标记器，并能够在 🤗 Transformers中使用它。",lp,Jt,np;return U=new mt({props:{title:"逐块地构建标记器",local:"逐块地构建标记器",headingTag:"h1"}}),g=new Aa({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section8.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section8.ipynb"}]}}),x=new Xa({props:{id:"MR8tZm5ViWU"}}),Z=new mt({props:{title:"获取语​​料库",local:"获取语​​料库",headingTag:"h2"}}),v=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ3aWtpdGV4dCUyMiUyQyUyMG5hbWUlM0QlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBJTBBZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihkYXRhc2V0KSUyQyUyMDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBkYXRhc2V0JTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIydGV4dCUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, name=<span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> dataset[i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),W=new T({props:{code:"d2l0aCUyMG9wZW4oJTIyd2lraXRleHQtMi50eHQlMjIlMkMlMjAlMjJ3JTIyJTJDJTIwZW5jb2RpbmclM0QlMjJ1dGYtOCUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZGF0YXNldCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShkYXRhc2V0JTVCaSU1RCU1QiUyMnRleHQlMjIlNUQlMjAlMkIlMjAlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)):
        f.write(dataset[i][<span class="hljs-string">&quot;text&quot;</span>] + <span class="hljs-string">&quot;\\n&quot;</span>)`,wrap:!1}}),R=new mt({props:{title:"从头开始构建 WordPiece 标记器",local:"从头开始构建 WordPiece 标记器",headingTag:"h2"}}),N=new T({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwZGVjb2RlcnMlMkMlMEElMjAlMjAlMjAlMjBtb2RlbHMlMkMlMEElMjAlMjAlMjAlMjBub3JtYWxpemVycyUyQyUwQSUyMCUyMCUyMCUyMHByZV90b2tlbml6ZXJzJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29ycyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluZXJzJTJDJTBBJTIwJTIwJTIwJTIwVG9rZW5pemVyJTJDJTBBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMFRva2VuaXplcihtb2RlbHMuV29yZFBpZWNlKHVua190b2tlbiUzRCUyMiU1QlVOSyU1RCUyMikp",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> (
    decoders,
    models,
    normalizers,
    pre_tokenizers,
    processors,
    trainers,
    Tokenizer,
)

tokenizer = Tokenizer(models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>))`,wrap:!1}}),L=new T({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5CZXJ0Tm9ybWFsaXplcihsb3dlcmNhc2UlM0RUcnVlKQ==",highlighted:'tokenizer.normalizer = normalizers.BertNormalizer(lowercase=<span class="hljs-literal">True</span>)',wrap:!1}}),D=new T({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5TZXF1ZW5jZSglMEElMjAlMjAlMjAlMjAlNUJub3JtYWxpemVycy5ORkQoKSUyQyUyMG5vcm1hbGl6ZXJzLkxvd2VyY2FzZSgpJTJDJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklNUQlMEEp",highlighted:`tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [normalizers.NFD(), normalizers.Lowercase(), normalizers.StripAccents()]
)`,wrap:!1}}),P=new T({props:{code:"cHJpbnQodG9rZW5pemVyLm5vcm1hbGl6ZXIubm9ybWFsaXplX3N0ciglMjJIJUMzJUE5bGwlQzMlQjIlMjBoJUMzJUI0dyUyMGFyZSUyMCVDMyVCQyUzRiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(tokenizer.normalizer.normalize_str(<span class="hljs-string">&quot;Héllò hôw are ü?&quot;</span>))',wrap:!1}}),F=new T({props:{code:"aGVsbG8lMjBob3clMjBhcmUlMjB1JTNG",highlighted:"hello how are u?",wrap:!1}}),k=new Ra({props:{$$slots:{default:[Na]},$$scope:{ctx:ot}}}),K=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CZXJ0UHJlVG9rZW5pemVyKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.BertPreTokenizer()",wrap:!1}}),ee=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5XaGl0ZXNwYWNlKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Whitespace()",wrap:!1}}),te=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBteSUyMHByZS10b2tlbml6ZXIuJTIyKQ==",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)',wrap:!1}}),le=new T({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),pe=new T({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTBBcHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKCUyMkxldCdzJTIwdGVzdCUyMG15JTIwcHJlLXRva2VuaXplci4lMjIp",highlighted:`pre_tokenizer = pre_tokenizers.WhitespaceSplit()
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),ae=new T({props:{code:"JTVCKCUyMkxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJ3Rlc3QnJTJDJTIwKDYlMkMlMjAxMCkpJTJDJTIwKCdteSclMkMlMjAoMTElMkMlMjAxMykpJTJDJTIwKCdwcmUtdG9rZW5pemVyLiclMkMlMjAoMTQlMkMlMjAyOCkpJTVE",highlighted:'[(<span class="hljs-string">&quot;Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre-tokenizer.&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">28</span>))]',wrap:!1}}),ie=new T({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLlNlcXVlbmNlKCUwQSUyMCUyMCUyMCUyMCU1QnByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTJDJTIwcHJlX3Rva2VuaXplcnMuUHVuY3R1YXRpb24oKSU1RCUwQSklMEFwcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIoJTIyTGV0J3MlMjB0ZXN0JTIwbXklMjBwcmUtdG9rZW5pemVyLiUyMik=",highlighted:`pre_tokenizer = pre_tokenizers.<span class="hljs-type">Sequence</span>(
    [pre_tokenizers.WhitespaceSplit(), pre_tokenizers.Punctuation()]
)
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),Me=new T({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),me=new T({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlNUJVTkslNUQlMjIlMkMlMjAlMjIlNUJQQUQlNUQlMjIlMkMlMjAlMjIlNUJDTFMlNUQlMjIlMkMlMjAlMjIlNUJTRVAlNUQlMjIlMkMlMjAlMjIlNUJNQVNLJTVEJTIyJTVEJTBBdHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLldvcmRQaWVjZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2Vucyk=",highlighted:`special_tokens = [<span class="hljs-string">&quot;[UNK]&quot;</span>, <span class="hljs-string">&quot;[PAD]&quot;</span>, <span class="hljs-string">&quot;[CLS]&quot;</span>, <span class="hljs-string">&quot;[SEP]&quot;</span>, <span class="hljs-string">&quot;[MASK]&quot;</span>]
trainer = trainers.WordPieceTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens)`,wrap:!1}}),je=new T({props:{code:"dG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:"tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)",wrap:!1}}),ce=new T({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLldvcmRQaWVjZSh1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>)
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),fe=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),ke=new T({props:{code:"JTVCJ2xldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJ3Rlc3QnJTJDJTIwJ3RoaXMnJTJDJTIwJ3RvayclMkMlMjAnJTIzJTIzZW5pJyUyQyUyMCclMjMlMjN6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),ge=new T({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiU1QkNMUyU1RCUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTVCU0VQJTVEJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[CLS]&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[SEP]&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),we=new T({props:{code:"KDIlMkMlMjAzKQ==",highlighted:'(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>)',wrap:!1}}),de=new T({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWlyJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjAlMjRCJTNBMSUyMCU1QlNFUCU1RCUzQTElMjIlMkMlMEElMjAlMjAlMjAlMjBzcGVjaWFsX3Rva2VucyUzRCU1QiglMjIlNUJDTFMlNUQlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTJDJTIwKCUyMiU1QlNFUCU1RCUyMiUyQyUyMHNlcF90b2tlbl9pZCklNUQlMkMlMEEp",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0&quot;</span>,
    pair=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0 $B:1 [SEP]:1&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;[CLS]&quot;</span>, cls_token_id), (<span class="hljs-string">&quot;[SEP]&quot;</span>, sep_token_id)],
)`,wrap:!1}}),Ce=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),ze=new T({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLiclMkMlMjAnJTVCU0VQJTVEJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]',wrap:!1}}),Ve=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),ve=new T({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLi4uJyUyQyUyMCclNUJTRVAlNUQnJTJDJTIwJ29uJyUyQyUyMCdhJyUyQyUyMCdwYWlyJyUyQyUyMCdvZiclMkMlMjAnc2VudGVuY2VzJyUyQyUyMCcuJyUyQyUyMCclNUJTRVAlNUQnJTVEJTBBJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVE",highlighted:`[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;...&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;pair&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;sentences&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),Be=new T({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5Xb3JkUGllY2UocHJlZml4JTNEJTIyJTIzJTIzJTIyKQ==",highlighted:'tokenizer.decoder = decoders.WordPiece(prefix=<span class="hljs-string">&quot;##&quot;</span>)',wrap:!1}}),Qe=new T({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),Re=new T({props:{code:"JTIybGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4uLiUyMG9uJTIwYSUyMHBhaXIlMjBvZiUyMHNlbnRlbmNlcy4lMjI=",highlighted:'<span class="hljs-string">&quot;let&#x27;s test this tokenizer... on a pair of sentences.&quot;</span>',wrap:!1}}),Ae=new T({props:{code:"dG9rZW5pemVyLnNhdmUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'tokenizer.save(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Ge=new T({props:{code:"bmV3X3Rva2VuaXplciUyMCUzRCUyMFRva2VuaXplci5mcm9tX2ZpbGUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'new_tokenizer = Tokenizer.from_file(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),He=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwdG9rZW5pemVyX2ZpbGUlM0QlMjJ0b2tlbml6ZXIuanNvbiUyMiUyQyUyMCUyMyUyMFlvdSUyMGNhbiUyMGxvYWQlMjBmcm9tJTIwdGhlJTIwdG9rZW5pemVyJTIwZmlsZSUyQyUyMGFsdGVybmF0aXZlbHklMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlNUJQQUQlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlNUJDTFMlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlNUJTRVAlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTVCTUFTSyU1RCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    <span class="hljs-comment"># tokenizer_file=&quot;tokenizer.json&quot;, # You can load from the tokenizer file, alternatively</span>
    unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>,
    pad_token=<span class="hljs-string">&quot;[PAD]&quot;</span>,
    cls_token=<span class="hljs-string">&quot;[CLS]&quot;</span>,
    sep_token=<span class="hljs-string">&quot;[SEP]&quot;</span>,
    mask_token=<span class="hljs-string">&quot;[MASK]&quot;</span>,
)`,wrap:!1}}),Ee=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizerFast

wrapped_tokenizer = BertTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Fe=new mt({props:{title:"从头开始构建 BPE 标记器",local:"从头开始构建 BPE 标记器",headingTag:"h2"}}),Ke=new T({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5CUEUoKSk=",highlighted:"tokenizer = Tokenizer(models.BPE())",wrap:!1}}),ss=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CeXRlTGV2ZWwoYWRkX3ByZWZpeF9zcGFjZSUzREZhbHNlKQ==",highlighted:'tokenizer.pre_tokenizer = pre_tokenizers.ByteLevel(add_prefix_space=<span class="hljs-literal">False</span>)',wrap:!1}}),ls=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBwcmUtdG9rZW5pemF0aW9uISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test pre-tokenization!&quot;</span>)',wrap:!1}}),ns=new T({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJ3MlMjIlMkMlMjAoMyUyQyUyMDUpKSUyQyUyMCgnJUM0JUEwdGVzdCclMkMlMjAoNSUyQyUyMDEwKSklMkMlMjAoJyVDNCVBMHByZSclMkMlMjAoMTAlMkMlMjAxNCkpJTJDJTIwKCctJyUyQyUyMCgxNCUyQyUyMDE1KSklMkMlMEElMjAoJ3Rva2VuaXphdGlvbiclMkMlMjAoMTUlMkMlMjAyNykpJTJDJTIwKCchJyUyQyUyMCgyNyUyQyUyMDI4KSklNUQ=",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;s&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;Ġtest&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;Ġpre&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">15</span>)),
 (<span class="hljs-string">&#x27;tokenization&#x27;</span>, (<span class="hljs-number">15</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;!&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),as=new T({props:{code:"dHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLkJwZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQpJTBBdG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`trainer = trainers.BpeTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=[<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>])
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),Ms=new T({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLkJQRSgpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.BPE()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),ms=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),os=new T({props:{code:"JTVCJ0wnJTJDJTIwJ2V0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAnJUM0JUEwdGVzdCclMkMlMjAnJUM0JUEwdGhpcyclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2tlbiclMkMlMjAnaXplciclMkMlMjAnLiclNUQ=",highlighted:'[<span class="hljs-string">&#x27;L&#x27;</span>, <span class="hljs-string">&#x27;et&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;Ġtest&#x27;</span>, <span class="hljs-string">&#x27;Ġthis&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),js=new T({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5CeXRlTGV2ZWwodHJpbV9vZmZzZXRzJTNERmFsc2Up",highlighted:'tokenizer.post_processor = processors.ByteLevel(trim_offsets=<span class="hljs-literal">False</span>)',wrap:!1}}),cs=new T({props:{code:"c2VudGVuY2UlMjAlM0QlMjAlMjJMZXQncyUyMHRlc3QlMjB0aGlzJTIwdG9rZW5pemVyLiUyMiUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyLmVuY29kZShzZW50ZW5jZSklMEFzdGFydCUyQyUyMGVuZCUyMCUzRCUyMGVuY29kaW5nLm9mZnNldHMlNUI0JTVEJTBBc2VudGVuY2UlNUJzdGFydCUzQWVuZCU1RA==",highlighted:`sentence = <span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>
encoding = tokenizer.encode(sentence)
start, end = encoding.offsets[<span class="hljs-number">4</span>]
sentence[start:end]`,wrap:!1}}),us=new T({props:{code:"JyUyMHRlc3Qn",highlighted:'<span class="hljs-string">&#x27; test&#x27;</span>',wrap:!1}}),ks=new T({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5CeXRlTGV2ZWwoKQ==",highlighted:"tokenizer.decoder = decoders.ByteLevel()",wrap:!1}}),Us=new T({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),gs=new T({props:{code:"JTIyTGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4lMjI=",highlighted:'<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>',wrap:!1}}),bs=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwZW9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
)`,wrap:!1}}),ds=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2TokenizerFast

wrapped_tokenizer = GPT2TokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Is=new mt({props:{title:"从头开始构建 Unigram 标记器",local:"从头开始构建 Unigram 标记器",headingTag:"h2"}}),zs=new T({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5VbmlncmFtKCkp",highlighted:"tokenizer = Tokenizer(models.Unigram())",wrap:!1}}),vs=new T({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjBSZWdleCUwQSUwQXRva2VuaXplci5ub3JtYWxpemVyJTIwJTNEJTIwbm9ybWFsaXplcnMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuUmVwbGFjZSglMjIlNjAlNjAlMjIlMkMlMjAnJTIyJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKCUyMicnJTIyJTJDJTIwJyUyMicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuTkZLRCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKFJlZ2V4KCUyMiUyMCU3QjIlMkMlN0QlMjIpJTJDJTIwJTIyJTIwJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> Regex

tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [
        normalizers.Replace(<span class="hljs-string">&quot;\`\`&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.Replace(<span class="hljs-string">&quot;&#x27;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.NFKD(),
        normalizers.StripAccents(),
        normalizers.Replace(Regex(<span class="hljs-string">&quot; {2,}&quot;</span>), <span class="hljs-string">&quot; &quot;</span>),
    ]
)`,wrap:!1}}),Ws=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Metaspace()",wrap:!1}}),Rs=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjB0aGUlMjBwcmUtdG9rZW5pemVyISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test the pre-tokenizer!&quot;</span>)',wrap:!1}}),Xs=new T({props:{code:"JTVCKCUyMiVFMiU5NiU4MUxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJyVFMiU5NiU4MXRlc3QnJTJDJTIwKDUlMkMlMjAxMCkpJTJDJTIwKCclRTIlOTYlODF0aGUnJTJDJTIwKDEwJTJDJTIwMTQpKSUyQyUyMCgnJUUyJTk2JTgxcHJlLXRva2VuaXplciEnJTJDJTIwKDE0JTJDJTIwMjkpKSU1RA==",highlighted:'[(<span class="hljs-string">&quot;▁Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;▁test&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;▁the&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;▁pre-tokenizer!&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">29</span>))]',wrap:!1}}),Ns=new T({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlM0NjbHMlM0UlMjIlMkMlMjAlMjIlM0NzZXAlM0UlMjIlMkMlMjAlMjIlM0N1bmslM0UlMjIlMkMlMjAlMjIlM0NwYWQlM0UlMjIlMkMlMjAlMjIlM0NtYXNrJTNFJTIyJTJDJTIwJTIyJTNDcyUzRSUyMiUyQyUyMCUyMiUzQyUyRnMlM0UlMjIlNUQlMEF0cmFpbmVyJTIwJTNEJTIwdHJhaW5lcnMuVW5pZ3JhbVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2VucyUyQyUyMHVua190b2tlbiUzRCUyMiUzQ3VuayUzRSUyMiUwQSklMEF0b2tlbml6ZXIudHJhaW5fZnJvbV9pdGVyYXRvcihnZXRfdHJhaW5pbmdfY29ycHVzKCklMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`special_tokens = [<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;s&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>]
trainer = trainers.UnigramTrainer(
    vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens, unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>
)
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),Ls=new T({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLlVuaWdyYW0oKSUwQXRva2VuaXplci50cmFpbiglNUIlMjJ3aWtpdGV4dC0yLnR4dCUyMiU1RCUyQyUyMHRyYWluZXIlM0R0cmFpbmVyKQ==",highlighted:`tokenizer.model = models.Unigram()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Ds=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Es=new T({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),Ps=new T({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiUzQ2NscyUzRSUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTNDc2VwJTNFJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),Fs=new T({props:{code:"MCUyMDE=",highlighted:'<span class="hljs-number">0</span> <span class="hljs-number">1</span>',wrap:!1}}),Ks=new T({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEJTIyJTI0QSUzQTAlMjAlM0NzZXAlM0UlM0EwJTIwJTNDY2xzJTNFJTNBMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhaXIlM0QlMjIlMjRBJTNBMCUyMCUzQ3NlcCUzRSUzQTAlMjAlMjRCJTNBMSUyMCUzQ3NlcCUzRSUzQTElMjAlM0NjbHMlM0UlM0EyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIoJTIyJTNDc2VwJTNFJTIyJTJDJTIwc2VwX3Rva2VuX2lkKSUyQyUyMCglMjIlM0NjbHMlM0UlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTVEJTJDJTBBKQ==",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 &lt;cls&gt;:2&quot;</span>,
    pair=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 $B:1 &lt;sep&gt;:1 &lt;cls&gt;:2&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, sep_token_id), (<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, cls_token_id)],
)`,wrap:!1}}),et=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMhJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences!&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),st=new T({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdvbiclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdhJyUyQyUyMCclRTIlOTYlODFwYWlyJyUyQyUyMCUwQSUyMCUyMCclRTIlOTYlODFvZiclMkMlMjAnJUUyJTk2JTgxc2VudGVuY2UnJTJDJTIwJ3MnJTJDJTIwJyEnJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJTNDY2xzJTNFJyU1RCUwQSU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAyJTVE",highlighted:`[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;▁pair&#x27;</span>, 
  <span class="hljs-string">&#x27;▁of&#x27;</span>, <span class="hljs-string">&#x27;▁sentence&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;!&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;cls&gt;&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),lt=new T({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.decoder = decoders.Metaspace()",wrap:!1}}),pt=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDcyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMGVvc190b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlM0N1bmslM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlM0NwYWQlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlM0NjbHMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlM0NzZXAlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTNDbWFzayUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;s&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>,
    unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>,
    pad_token=<span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>,
    cls_token=<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>,
    sep_token=<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>,
    mask_token=<span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>,
    padding_side=<span class="hljs-string">&quot;left&quot;</span>,
)`,wrap:!1}}),rt=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFhMTmV0VG9rZW5pemVyRmFzdCUwQSUwQXdyYXBwZWRfdG9rZW5pemVyJTIwJTNEJTIwWExOZXRUb2tlbml6ZXJGYXN0KHRva2VuaXplcl9vYmplY3QlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLNetTokenizerFast

wrapped_tokenizer = XLNetTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),{c(){c=a("meta"),$=n(),u=a("p"),Mt=n(),M(U.$$.fragment),yt=n(),M(g.$$.fragment),jt=n(),w=a("p"),w.textContent=ap,Tt=n(),b=a("ul"),b.innerHTML=rp,ct=n(),h=a("p"),h.textContent=ip,ut=n(),f=a("div"),f.innerHTML=Mp,ft=n(),d=a("p"),d.innerHTML=Jp,kt=n(),M(x.$$.fragment),$t=n(),I=a("p"),I.textContent=mp,Ut=n(),C=a("ul"),C.innerHTML=op,gt=n(),z=a("p"),z.innerHTML=yp,wt=n(),M(Z.$$.fragment),bt=n(),V=a("p"),V.innerHTML=jp,ht=n(),M(v.$$.fragment),dt=n(),_=a("p"),_.innerHTML=Tp,xt=n(),B=a("p"),B.textContent=cp,It=n(),M(W.$$.fragment),Ct=n(),Q=a("p"),Q.textContent=up,zt=n(),M(R.$$.fragment),Zt=n(),X=a("p"),X.innerHTML=fp,Vt=n(),A=a("p"),A.innerHTML=kp,vt=n(),M(N.$$.fragment),_t=n(),G=a("p"),G.innerHTML=$p,Bt=n(),q=a("p"),q.innerHTML=Up,Wt=n(),M(L.$$.fragment),Qt=n(),H=a("p"),H.textContent=gp,Rt=n(),M(D.$$.fragment),Xt=n(),E=a("p"),E.innerHTML=wp,At=n(),S=a("p"),S.innerHTML=bp,Nt=n(),M(P.$$.fragment),Gt=n(),M(F.$$.fragment),qt=n(),M(k.$$.fragment),Lt=n(),Y=a("p"),Y.textContent=hp,Ht=n(),M(K.$$.fragment),Dt=n(),O=a("p"),O.textContent=dp,Et=n(),M(ee.$$.fragment),St=n(),se=a("p"),se.innerHTML=xp,Pt=n(),M(te.$$.fragment),Ft=n(),M(le.$$.fragment),Yt=n(),ne=a("p"),ne.innerHTML=Ip,Kt=n(),M(pe.$$.fragment),Ot=n(),M(ae.$$.fragment),el=n(),re=a("p"),re.innerHTML=Cp,sl=n(),M(ie.$$.fragment),tl=n(),M(Me.$$.fragment),ll=n(),Je=a("p"),Je.innerHTML=zp,nl=n(),M(me.$$.fragment),pl=n(),oe=a("p"),oe.innerHTML=Zp,al=n(),ye=a("p"),ye.textContent=Vp,rl=n(),M(je.$$.fragment),il=n(),Te=a("p"),Te.innerHTML=vp,Ml=n(),M(ce.$$.fragment),Jl=n(),ue=a("p"),ue.innerHTML=_p,ml=n(),M(fe.$$.fragment),ol=n(),M(ke.$$.fragment),yl=n(),$e=a("p"),$e.innerHTML=Bp,jl=n(),Ue=a("p"),Ue.innerHTML=Wp,Tl=n(),M(ge.$$.fragment),cl=n(),M(we.$$.fragment),ul=n(),be=a("p"),be.innerHTML=Qp,fl=n(),he=a("p"),he.textContent=Rp,kl=n(),M(de.$$.fragment),$l=n(),xe=a("p"),xe.textContent=Xp,Ul=n(),Ie=a("p"),Ie.textContent=Ap,gl=n(),M(Ce.$$.fragment),wl=n(),M(ze.$$.fragment),bl=n(),Ze=a("p"),Ze.textContent=Np,hl=n(),M(Ve.$$.fragment),dl=n(),M(ve.$$.fragment),xl=n(),_e=a("p"),_e.textContent=Gp,Il=n(),M(Be.$$.fragment),Cl=n(),We=a("p"),We.innerHTML=qp,zl=n(),M(Qe.$$.fragment),Zl=n(),M(Re.$$.fragment),Vl=n(),Xe=a("p"),Xe.textContent=Lp,vl=n(),M(Ae.$$.fragment),_l=n(),Ne=a("p"),Ne.innerHTML=Hp,Bl=n(),M(Ge.$$.fragment),Wl=n(),qe=a("p"),qe.innerHTML=Dp,Ql=n(),Le=a("p"),Le.innerHTML=Ep,Rl=n(),M(He.$$.fragment),Xl=n(),De=a("p"),De.innerHTML=Sp,Al=n(),M(Ee.$$.fragment),Nl=n(),Se=a("p"),Se.innerHTML=Pp,Gl=n(),Pe=a("p"),Pe.textContent=Fp,ql=n(),M(Fe.$$.fragment),Ll=n(),Ye=a("p"),Ye.innerHTML=Yp,Hl=n(),M(Ke.$$.fragment),Dl=n(),Oe=a("p"),Oe.innerHTML=Kp,El=n(),es=a("p"),es.textContent=Op,Sl=n(),M(ss.$$.fragment),Pl=n(),ts=a("p"),ts.innerHTML=ea,Fl=n(),M(ls.$$.fragment),Yl=n(),M(ns.$$.fragment),Kl=n(),ps=a("p"),ps.textContent=sa,Ol=n(),M(as.$$.fragment),en=n(),rs=a("p"),rs.innerHTML=ta,sn=n(),is=a("p"),is.textContent=la,tn=n(),M(Ms.$$.fragment),ln=n(),Js=a("p"),Js.textContent=na,nn=n(),M(ms.$$.fragment),pn=n(),M(os.$$.fragment),an=n(),ys=a("p"),ys.textContent=pa,rn=n(),M(js.$$.fragment),Mn=n(),Ts=a("p"),Ts.innerHTML=aa,Jn=n(),M(cs.$$.fragment),mn=n(),M(us.$$.fragment),on=n(),fs=a("p"),fs.textContent=ra,yn=n(),M(ks.$$.fragment),jn=n(),$s=a("p"),$s.textContent=ia,Tn=n(),M(Us.$$.fragment),cn=n(),M(gs.$$.fragment),un=n(),ws=a("p"),ws.innerHTML=Ma,fn=n(),M(bs.$$.fragment),kn=n(),hs=a("p"),hs.textContent=Ja,$n=n(),M(ds.$$.fragment),Un=n(),xs=a("p"),xs.textContent=ma,gn=n(),M(Is.$$.fragment),wn=n(),Cs=a("p"),Cs.innerHTML=oa,bn=n(),M(zs.$$.fragment),hn=n(),Zs=a("p"),Zs.textContent=ya,dn=n(),Vs=a("p"),Vs.textContent=ja,xn=n(),M(vs.$$.fragment),In=n(),_s=a("p"),_s.innerHTML=Ta,Cn=n(),Bs=a("p"),Bs.innerHTML=ca,zn=n(),M(Ws.$$.fragment),Zn=n(),Qs=a("p"),Qs.textContent=ua,Vn=n(),M(Rs.$$.fragment),vn=n(),M(Xs.$$.fragment),_n=n(),As=a("p"),As.textContent=fa,Bn=n(),M(Ns.$$.fragment),Wn=n(),Gs=a("p"),Gs.innerHTML=ka,Qn=n(),qs=a("p"),qs.textContent=$a,Rn=n(),M(Ls.$$.fragment),Xn=n(),Hs=a("p"),Hs.textContent=Ua,An=n(),M(Ds.$$.fragment),Nn=n(),M(Es.$$.fragment),Gn=n(),Ss=a("p"),Ss.innerHTML=ga,qn=n(),M(Ps.$$.fragment),Ln=n(),M(Fs.$$.fragment),Hn=n(),Ys=a("p"),Ys.textContent=wa,Dn=n(),M(Ks.$$.fragment),En=n(),Os=a("p"),Os.textContent=ba,Sn=n(),M(et.$$.fragment),Pn=n(),M(st.$$.fragment),Fn=n(),tt=a("p"),tt.innerHTML=ha,Yn=n(),M(lt.$$.fragment),Kn=n(),nt=a("p"),nt.innerHTML=da,On=n(),M(pt.$$.fragment),ep=n(),at=a("p"),at.textContent=xa,sp=n(),M(rt.$$.fragment),tp=n(),it=a("p"),it.textContent=Ia,lp=n(),Jt=a("p"),this.h()},l(e){const s=Wa("svelte-u9bgzb",document.head);c=r(s,"META",{name:!0,content:!0}),s.forEach(t),$=p(e),u=r(e,"P",{}),za(u).forEach(t),Mt=p(e),J(U.$$.fragment,e),yt=p(e),J(g.$$.fragment,e),jt=p(e),w=r(e,"P",{"data-svelte-h":!0}),i(w)!=="svelte-k83bdu"&&(w.textContent=ap),Tt=p(e),b=r(e,"UL",{"data-svelte-h":!0}),i(b)!=="svelte-1h2ljkr"&&(b.innerHTML=rp),ct=p(e),h=r(e,"P",{"data-svelte-h":!0}),i(h)!=="svelte-6j7ns1"&&(h.textContent=ip),ut=p(e),f=r(e,"DIV",{class:!0,"data-svelte-h":!0}),i(f)!=="svelte-oxfng3"&&(f.innerHTML=Mp),ft=p(e),d=r(e,"P",{"data-svelte-h":!0}),i(d)!=="svelte-17ev2i5"&&(d.innerHTML=Jp),kt=p(e),J(x.$$.fragment,e),$t=p(e),I=r(e,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1uf01he"&&(I.textContent=mp),Ut=p(e),C=r(e,"UL",{"data-svelte-h":!0}),i(C)!=="svelte-1dttrl1"&&(C.innerHTML=op),gt=p(e),z=r(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1er1yow"&&(z.innerHTML=yp),wt=p(e),J(Z.$$.fragment,e),bt=p(e),V=r(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-g0mh9v"&&(V.innerHTML=jp),ht=p(e),J(v.$$.fragment,e),dt=p(e),_=r(e,"P",{"data-svelte-h":!0}),i(_)!=="svelte-b2u00j"&&(_.innerHTML=Tp),xt=p(e),B=r(e,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1xc8i1t"&&(B.textContent=cp),It=p(e),J(W.$$.fragment,e),Ct=p(e),Q=r(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1g3lsc2"&&(Q.textContent=up),zt=p(e),J(R.$$.fragment,e),Zt=p(e),X=r(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1s9a6fb"&&(X.innerHTML=fp),Vt=p(e),A=r(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1qy8onm"&&(A.innerHTML=kp),vt=p(e),J(N.$$.fragment,e),_t=p(e),G=r(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1rhqj5l"&&(G.innerHTML=$p),Bt=p(e),q=r(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1q6vv7y"&&(q.innerHTML=Up),Wt=p(e),J(L.$$.fragment,e),Qt=p(e),H=r(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-6k7dq1"&&(H.textContent=gp),Rt=p(e),J(D.$$.fragment,e),Xt=p(e),E=r(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-14hh4md"&&(E.innerHTML=wp),At=p(e),S=r(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-4m2l1q"&&(S.innerHTML=bp),Nt=p(e),J(P.$$.fragment,e),Gt=p(e),J(F.$$.fragment,e),qt=p(e),J(k.$$.fragment,e),Lt=p(e),Y=r(e,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-3yld2x"&&(Y.textContent=hp),Ht=p(e),J(K.$$.fragment,e),Dt=p(e),O=r(e,"P",{"data-svelte-h":!0}),i(O)!=="svelte-vuawww"&&(O.textContent=dp),Et=p(e),J(ee.$$.fragment,e),St=p(e),se=r(e,"P",{"data-svelte-h":!0}),i(se)!=="svelte-tccol7"&&(se.innerHTML=xp),Pt=p(e),J(te.$$.fragment,e),Ft=p(e),J(le.$$.fragment,e),Yt=p(e),ne=r(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-16bqs3e"&&(ne.innerHTML=Ip),Kt=p(e),J(pe.$$.fragment,e),Ot=p(e),J(ae.$$.fragment,e),el=p(e),re=r(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-12x90a0"&&(re.innerHTML=Cp),sl=p(e),J(ie.$$.fragment,e),tl=p(e),J(Me.$$.fragment,e),ll=p(e),Je=r(e,"P",{"data-svelte-h":!0}),i(Je)!=="svelte-y73bvu"&&(Je.innerHTML=zp),nl=p(e),J(me.$$.fragment,e),pl=p(e),oe=r(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-1un2cer"&&(oe.innerHTML=Zp),al=p(e),ye=r(e,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-1pongfb"&&(ye.textContent=Vp),rl=p(e),J(je.$$.fragment,e),il=p(e),Te=r(e,"P",{"data-svelte-h":!0}),i(Te)!=="svelte-1rwwd02"&&(Te.innerHTML=vp),Ml=p(e),J(ce.$$.fragment,e),Jl=p(e),ue=r(e,"P",{"data-svelte-h":!0}),i(ue)!=="svelte-1nh7ncm"&&(ue.innerHTML=_p),ml=p(e),J(fe.$$.fragment,e),ol=p(e),J(ke.$$.fragment,e),yl=p(e),$e=r(e,"P",{"data-svelte-h":!0}),i($e)!=="svelte-1yzsmkm"&&($e.innerHTML=Bp),jl=p(e),Ue=r(e,"P",{"data-svelte-h":!0}),i(Ue)!=="svelte-1trhnv6"&&(Ue.innerHTML=Wp),Tl=p(e),J(ge.$$.fragment,e),cl=p(e),J(we.$$.fragment,e),ul=p(e),be=r(e,"P",{"data-svelte-h":!0}),i(be)!=="svelte-65wzif"&&(be.innerHTML=Qp),fl=p(e),he=r(e,"P",{"data-svelte-h":!0}),i(he)!=="svelte-1vqvr4w"&&(he.textContent=Rp),kl=p(e),J(de.$$.fragment,e),$l=p(e),xe=r(e,"P",{"data-svelte-h":!0}),i(xe)!=="svelte-1qpf89l"&&(xe.textContent=Xp),Ul=p(e),Ie=r(e,"P",{"data-svelte-h":!0}),i(Ie)!=="svelte-1kzxxt6"&&(Ie.textContent=Ap),gl=p(e),J(Ce.$$.fragment,e),wl=p(e),J(ze.$$.fragment,e),bl=p(e),Ze=r(e,"P",{"data-svelte-h":!0}),i(Ze)!=="svelte-1ce7e9"&&(Ze.textContent=Np),hl=p(e),J(Ve.$$.fragment,e),dl=p(e),J(ve.$$.fragment,e),xl=p(e),_e=r(e,"P",{"data-svelte-h":!0}),i(_e)!=="svelte-cz1hun"&&(_e.textContent=Gp),Il=p(e),J(Be.$$.fragment,e),Cl=p(e),We=r(e,"P",{"data-svelte-h":!0}),i(We)!=="svelte-1f68vri"&&(We.innerHTML=qp),zl=p(e),J(Qe.$$.fragment,e),Zl=p(e),J(Re.$$.fragment,e),Vl=p(e),Xe=r(e,"P",{"data-svelte-h":!0}),i(Xe)!=="svelte-1e1865s"&&(Xe.textContent=Lp),vl=p(e),J(Ae.$$.fragment,e),_l=p(e),Ne=r(e,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-mok2vf"&&(Ne.innerHTML=Hp),Bl=p(e),J(Ge.$$.fragment,e),Wl=p(e),qe=r(e,"P",{"data-svelte-h":!0}),i(qe)!=="svelte-1qnyaqe"&&(qe.innerHTML=Dp),Ql=p(e),Le=r(e,"P",{"data-svelte-h":!0}),i(Le)!=="svelte-f3hpqt"&&(Le.innerHTML=Ep),Rl=p(e),J(He.$$.fragment,e),Xl=p(e),De=r(e,"P",{"data-svelte-h":!0}),i(De)!=="svelte-v045ds"&&(De.innerHTML=Sp),Al=p(e),J(Ee.$$.fragment,e),Nl=p(e),Se=r(e,"P",{"data-svelte-h":!0}),i(Se)!=="svelte-fswal0"&&(Se.innerHTML=Pp),Gl=p(e),Pe=r(e,"P",{"data-svelte-h":!0}),i(Pe)!=="svelte-4zbmxt"&&(Pe.textContent=Fp),ql=p(e),J(Fe.$$.fragment,e),Ll=p(e),Ye=r(e,"P",{"data-svelte-h":!0}),i(Ye)!=="svelte-1uk5mrr"&&(Ye.innerHTML=Yp),Hl=p(e),J(Ke.$$.fragment,e),Dl=p(e),Oe=r(e,"P",{"data-svelte-h":!0}),i(Oe)!=="svelte-1pd6gyz"&&(Oe.innerHTML=Kp),El=p(e),es=r(e,"P",{"data-svelte-h":!0}),i(es)!=="svelte-10tl3h9"&&(es.textContent=Op),Sl=p(e),J(ss.$$.fragment,e),Pl=p(e),ts=r(e,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-grspue"&&(ts.innerHTML=ea),Fl=p(e),J(ls.$$.fragment,e),Yl=p(e),J(ns.$$.fragment,e),Kl=p(e),ps=r(e,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-1rfzr5e"&&(ps.textContent=sa),Ol=p(e),J(as.$$.fragment,e),en=p(e),rs=r(e,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-2hoajf"&&(rs.innerHTML=ta),sn=p(e),is=r(e,"P",{"data-svelte-h":!0}),i(is)!=="svelte-1y3u7t5"&&(is.textContent=la),tn=p(e),J(Ms.$$.fragment,e),ln=p(e),Js=r(e,"P",{"data-svelte-h":!0}),i(Js)!=="svelte-drwiu6"&&(Js.textContent=na),nn=p(e),J(ms.$$.fragment,e),pn=p(e),J(os.$$.fragment,e),an=p(e),ys=r(e,"P",{"data-svelte-h":!0}),i(ys)!=="svelte-1oi8nmz"&&(ys.textContent=pa),rn=p(e),J(js.$$.fragment,e),Mn=p(e),Ts=r(e,"P",{"data-svelte-h":!0}),i(Ts)!=="svelte-1979ngo"&&(Ts.innerHTML=aa),Jn=p(e),J(cs.$$.fragment,e),mn=p(e),J(us.$$.fragment,e),on=p(e),fs=r(e,"P",{"data-svelte-h":!0}),i(fs)!=="svelte-1bu1bm"&&(fs.textContent=ra),yn=p(e),J(ks.$$.fragment,e),jn=p(e),$s=r(e,"P",{"data-svelte-h":!0}),i($s)!=="svelte-1r9dk4k"&&($s.textContent=ia),Tn=p(e),J(Us.$$.fragment,e),cn=p(e),J(gs.$$.fragment,e),un=p(e),ws=r(e,"P",{"data-svelte-h":!0}),i(ws)!=="svelte-h0he4x"&&(ws.innerHTML=Ma),fn=p(e),J(bs.$$.fragment,e),kn=p(e),hs=r(e,"P",{"data-svelte-h":!0}),i(hs)!=="svelte-fzp8ed"&&(hs.textContent=Ja),$n=p(e),J(ds.$$.fragment,e),Un=p(e),xs=r(e,"P",{"data-svelte-h":!0}),i(xs)!=="svelte-bz0kts"&&(xs.textContent=ma),gn=p(e),J(Is.$$.fragment,e),wn=p(e),Cs=r(e,"P",{"data-svelte-h":!0}),i(Cs)!=="svelte-1z0ewq9"&&(Cs.innerHTML=oa),bn=p(e),J(zs.$$.fragment,e),hn=p(e),Zs=r(e,"P",{"data-svelte-h":!0}),i(Zs)!=="svelte-1jkt6ld"&&(Zs.textContent=ya),dn=p(e),Vs=r(e,"P",{"data-svelte-h":!0}),i(Vs)!=="svelte-1x3xj2n"&&(Vs.textContent=ja),xn=p(e),J(vs.$$.fragment,e),In=p(e),_s=r(e,"P",{"data-svelte-h":!0}),i(_s)!=="svelte-17t3kkx"&&(_s.innerHTML=Ta),Cn=p(e),Bs=r(e,"P",{"data-svelte-h":!0}),i(Bs)!=="svelte-58cn2e"&&(Bs.innerHTML=ca),zn=p(e),J(Ws.$$.fragment,e),Zn=p(e),Qs=r(e,"P",{"data-svelte-h":!0}),i(Qs)!=="svelte-2hnosu"&&(Qs.textContent=ua),Vn=p(e),J(Rs.$$.fragment,e),vn=p(e),J(Xs.$$.fragment,e),_n=p(e),As=r(e,"P",{"data-svelte-h":!0}),i(As)!=="svelte-1dttqvd"&&(As.textContent=fa),Bn=p(e),J(Ns.$$.fragment,e),Wn=p(e),Gs=r(e,"P",{"data-svelte-h":!0}),i(Gs)!=="svelte-1h6mwb7"&&(Gs.innerHTML=ka),Qn=p(e),qs=r(e,"P",{"data-svelte-h":!0}),i(qs)!=="svelte-1y3u7t5"&&(qs.textContent=$a),Rn=p(e),J(Ls.$$.fragment,e),Xn=p(e),Hs=r(e,"P",{"data-svelte-h":!0}),i(Hs)!=="svelte-drwiu6"&&(Hs.textContent=Ua),An=p(e),J(Ds.$$.fragment,e),Nn=p(e),J(Es.$$.fragment,e),Gn=p(e),Ss=r(e,"P",{"data-svelte-h":!0}),i(Ss)!=="svelte-pgsi7p"&&(Ss.innerHTML=ga),qn=p(e),J(Ps.$$.fragment,e),Ln=p(e),J(Fs.$$.fragment,e),Hn=p(e),Ys=r(e,"P",{"data-svelte-h":!0}),i(Ys)!=="svelte-ose5sl"&&(Ys.textContent=wa),Dn=p(e),J(Ks.$$.fragment,e),En=p(e),Os=r(e,"P",{"data-svelte-h":!0}),i(Os)!=="svelte-5dlnn1"&&(Os.textContent=ba),Sn=p(e),J(et.$$.fragment,e),Pn=p(e),J(st.$$.fragment,e),Fn=p(e),tt=r(e,"P",{"data-svelte-h":!0}),i(tt)!=="svelte-b0kp5k"&&(tt.innerHTML=ha),Yn=p(e),J(lt.$$.fragment,e),Kn=p(e),nt=r(e,"P",{"data-svelte-h":!0}),i(nt)!=="svelte-8ce1v6"&&(nt.innerHTML=da),On=p(e),J(pt.$$.fragment,e),ep=p(e),at=r(e,"P",{"data-svelte-h":!0}),i(at)!=="svelte-fzp8ed"&&(at.textContent=xa),sp=p(e),J(rt.$$.fragment,e),tp=p(e),it=r(e,"P",{"data-svelte-h":!0}),i(it)!=="svelte-looqvs"&&(it.textContent=Ia),lp=p(e),Jt=r(e,"P",{}),za(Jt).forEach(t),this.h()},h(){pp(c,"name","hf:doc:metadata"),pp(c,"content",qa),pp(f,"class","flex justify-center")},m(e,s){Qa(document.head,c),l(e,$,s),l(e,u,s),l(e,Mt,s),m(U,e,s),l(e,yt,s),m(g,e,s),l(e,jt,s),l(e,w,s),l(e,Tt,s),l(e,b,s),l(e,ct,s),l(e,h,s),l(e,ut,s),l(e,f,s),l(e,ft,s),l(e,d,s),l(e,kt,s),m(x,e,s),l(e,$t,s),l(e,I,s),l(e,Ut,s),l(e,C,s),l(e,gt,s),l(e,z,s),l(e,wt,s),m(Z,e,s),l(e,bt,s),l(e,V,s),l(e,ht,s),m(v,e,s),l(e,dt,s),l(e,_,s),l(e,xt,s),l(e,B,s),l(e,It,s),m(W,e,s),l(e,Ct,s),l(e,Q,s),l(e,zt,s),m(R,e,s),l(e,Zt,s),l(e,X,s),l(e,Vt,s),l(e,A,s),l(e,vt,s),m(N,e,s),l(e,_t,s),l(e,G,s),l(e,Bt,s),l(e,q,s),l(e,Wt,s),m(L,e,s),l(e,Qt,s),l(e,H,s),l(e,Rt,s),m(D,e,s),l(e,Xt,s),l(e,E,s),l(e,At,s),l(e,S,s),l(e,Nt,s),m(P,e,s),l(e,Gt,s),m(F,e,s),l(e,qt,s),m(k,e,s),l(e,Lt,s),l(e,Y,s),l(e,Ht,s),m(K,e,s),l(e,Dt,s),l(e,O,s),l(e,Et,s),m(ee,e,s),l(e,St,s),l(e,se,s),l(e,Pt,s),m(te,e,s),l(e,Ft,s),m(le,e,s),l(e,Yt,s),l(e,ne,s),l(e,Kt,s),m(pe,e,s),l(e,Ot,s),m(ae,e,s),l(e,el,s),l(e,re,s),l(e,sl,s),m(ie,e,s),l(e,tl,s),m(Me,e,s),l(e,ll,s),l(e,Je,s),l(e,nl,s),m(me,e,s),l(e,pl,s),l(e,oe,s),l(e,al,s),l(e,ye,s),l(e,rl,s),m(je,e,s),l(e,il,s),l(e,Te,s),l(e,Ml,s),m(ce,e,s),l(e,Jl,s),l(e,ue,s),l(e,ml,s),m(fe,e,s),l(e,ol,s),m(ke,e,s),l(e,yl,s),l(e,$e,s),l(e,jl,s),l(e,Ue,s),l(e,Tl,s),m(ge,e,s),l(e,cl,s),m(we,e,s),l(e,ul,s),l(e,be,s),l(e,fl,s),l(e,he,s),l(e,kl,s),m(de,e,s),l(e,$l,s),l(e,xe,s),l(e,Ul,s),l(e,Ie,s),l(e,gl,s),m(Ce,e,s),l(e,wl,s),m(ze,e,s),l(e,bl,s),l(e,Ze,s),l(e,hl,s),m(Ve,e,s),l(e,dl,s),m(ve,e,s),l(e,xl,s),l(e,_e,s),l(e,Il,s),m(Be,e,s),l(e,Cl,s),l(e,We,s),l(e,zl,s),m(Qe,e,s),l(e,Zl,s),m(Re,e,s),l(e,Vl,s),l(e,Xe,s),l(e,vl,s),m(Ae,e,s),l(e,_l,s),l(e,Ne,s),l(e,Bl,s),m(Ge,e,s),l(e,Wl,s),l(e,qe,s),l(e,Ql,s),l(e,Le,s),l(e,Rl,s),m(He,e,s),l(e,Xl,s),l(e,De,s),l(e,Al,s),m(Ee,e,s),l(e,Nl,s),l(e,Se,s),l(e,Gl,s),l(e,Pe,s),l(e,ql,s),m(Fe,e,s),l(e,Ll,s),l(e,Ye,s),l(e,Hl,s),m(Ke,e,s),l(e,Dl,s),l(e,Oe,s),l(e,El,s),l(e,es,s),l(e,Sl,s),m(ss,e,s),l(e,Pl,s),l(e,ts,s),l(e,Fl,s),m(ls,e,s),l(e,Yl,s),m(ns,e,s),l(e,Kl,s),l(e,ps,s),l(e,Ol,s),m(as,e,s),l(e,en,s),l(e,rs,s),l(e,sn,s),l(e,is,s),l(e,tn,s),m(Ms,e,s),l(e,ln,s),l(e,Js,s),l(e,nn,s),m(ms,e,s),l(e,pn,s),m(os,e,s),l(e,an,s),l(e,ys,s),l(e,rn,s),m(js,e,s),l(e,Mn,s),l(e,Ts,s),l(e,Jn,s),m(cs,e,s),l(e,mn,s),m(us,e,s),l(e,on,s),l(e,fs,s),l(e,yn,s),m(ks,e,s),l(e,jn,s),l(e,$s,s),l(e,Tn,s),m(Us,e,s),l(e,cn,s),m(gs,e,s),l(e,un,s),l(e,ws,s),l(e,fn,s),m(bs,e,s),l(e,kn,s),l(e,hs,s),l(e,$n,s),m(ds,e,s),l(e,Un,s),l(e,xs,s),l(e,gn,s),m(Is,e,s),l(e,wn,s),l(e,Cs,s),l(e,bn,s),m(zs,e,s),l(e,hn,s),l(e,Zs,s),l(e,dn,s),l(e,Vs,s),l(e,xn,s),m(vs,e,s),l(e,In,s),l(e,_s,s),l(e,Cn,s),l(e,Bs,s),l(e,zn,s),m(Ws,e,s),l(e,Zn,s),l(e,Qs,s),l(e,Vn,s),m(Rs,e,s),l(e,vn,s),m(Xs,e,s),l(e,_n,s),l(e,As,s),l(e,Bn,s),m(Ns,e,s),l(e,Wn,s),l(e,Gs,s),l(e,Qn,s),l(e,qs,s),l(e,Rn,s),m(Ls,e,s),l(e,Xn,s),l(e,Hs,s),l(e,An,s),m(Ds,e,s),l(e,Nn,s),m(Es,e,s),l(e,Gn,s),l(e,Ss,s),l(e,qn,s),m(Ps,e,s),l(e,Ln,s),m(Fs,e,s),l(e,Hn,s),l(e,Ys,s),l(e,Dn,s),m(Ks,e,s),l(e,En,s),l(e,Os,s),l(e,Sn,s),m(et,e,s),l(e,Pn,s),m(st,e,s),l(e,Fn,s),l(e,tt,s),l(e,Yn,s),m(lt,e,s),l(e,Kn,s),l(e,nt,s),l(e,On,s),m(pt,e,s),l(e,ep,s),l(e,at,s),l(e,sp,s),m(rt,e,s),l(e,tp,s),l(e,it,s),l(e,lp,s),l(e,Jt,s),np=!0},p(e,[s]){const Ca={};s&2&&(Ca.$$scope={dirty:s,ctx:e}),k.$set(Ca)},i(e){np||(o(U.$$.fragment,e),o(g.$$.fragment,e),o(x.$$.fragment,e),o(Z.$$.fragment,e),o(v.$$.fragment,e),o(W.$$.fragment,e),o(R.$$.fragment,e),o(N.$$.fragment,e),o(L.$$.fragment,e),o(D.$$.fragment,e),o(P.$$.fragment,e),o(F.$$.fragment,e),o(k.$$.fragment,e),o(K.$$.fragment,e),o(ee.$$.fragment,e),o(te.$$.fragment,e),o(le.$$.fragment,e),o(pe.$$.fragment,e),o(ae.$$.fragment,e),o(ie.$$.fragment,e),o(Me.$$.fragment,e),o(me.$$.fragment,e),o(je.$$.fragment,e),o(ce.$$.fragment,e),o(fe.$$.fragment,e),o(ke.$$.fragment,e),o(ge.$$.fragment,e),o(we.$$.fragment,e),o(de.$$.fragment,e),o(Ce.$$.fragment,e),o(ze.$$.fragment,e),o(Ve.$$.fragment,e),o(ve.$$.fragment,e),o(Be.$$.fragment,e),o(Qe.$$.fragment,e),o(Re.$$.fragment,e),o(Ae.$$.fragment,e),o(Ge.$$.fragment,e),o(He.$$.fragment,e),o(Ee.$$.fragment,e),o(Fe.$$.fragment,e),o(Ke.$$.fragment,e),o(ss.$$.fragment,e),o(ls.$$.fragment,e),o(ns.$$.fragment,e),o(as.$$.fragment,e),o(Ms.$$.fragment,e),o(ms.$$.fragment,e),o(os.$$.fragment,e),o(js.$$.fragment,e),o(cs.$$.fragment,e),o(us.$$.fragment,e),o(ks.$$.fragment,e),o(Us.$$.fragment,e),o(gs.$$.fragment,e),o(bs.$$.fragment,e),o(ds.$$.fragment,e),o(Is.$$.fragment,e),o(zs.$$.fragment,e),o(vs.$$.fragment,e),o(Ws.$$.fragment,e),o(Rs.$$.fragment,e),o(Xs.$$.fragment,e),o(Ns.$$.fragment,e),o(Ls.$$.fragment,e),o(Ds.$$.fragment,e),o(Es.$$.fragment,e),o(Ps.$$.fragment,e),o(Fs.$$.fragment,e),o(Ks.$$.fragment,e),o(et.$$.fragment,e),o(st.$$.fragment,e),o(lt.$$.fragment,e),o(pt.$$.fragment,e),o(rt.$$.fragment,e),np=!0)},o(e){y(U.$$.fragment,e),y(g.$$.fragment,e),y(x.$$.fragment,e),y(Z.$$.fragment,e),y(v.$$.fragment,e),y(W.$$.fragment,e),y(R.$$.fragment,e),y(N.$$.fragment,e),y(L.$$.fragment,e),y(D.$$.fragment,e),y(P.$$.fragment,e),y(F.$$.fragment,e),y(k.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(le.$$.fragment,e),y(pe.$$.fragment,e),y(ae.$$.fragment,e),y(ie.$$.fragment,e),y(Me.$$.fragment,e),y(me.$$.fragment,e),y(je.$$.fragment,e),y(ce.$$.fragment,e),y(fe.$$.fragment,e),y(ke.$$.fragment,e),y(ge.$$.fragment,e),y(we.$$.fragment,e),y(de.$$.fragment,e),y(Ce.$$.fragment,e),y(ze.$$.fragment,e),y(Ve.$$.fragment,e),y(ve.$$.fragment,e),y(Be.$$.fragment,e),y(Qe.$$.fragment,e),y(Re.$$.fragment,e),y(Ae.$$.fragment,e),y(Ge.$$.fragment,e),y(He.$$.fragment,e),y(Ee.$$.fragment,e),y(Fe.$$.fragment,e),y(Ke.$$.fragment,e),y(ss.$$.fragment,e),y(ls.$$.fragment,e),y(ns.$$.fragment,e),y(as.$$.fragment,e),y(Ms.$$.fragment,e),y(ms.$$.fragment,e),y(os.$$.fragment,e),y(js.$$.fragment,e),y(cs.$$.fragment,e),y(us.$$.fragment,e),y(ks.$$.fragment,e),y(Us.$$.fragment,e),y(gs.$$.fragment,e),y(bs.$$.fragment,e),y(ds.$$.fragment,e),y(Is.$$.fragment,e),y(zs.$$.fragment,e),y(vs.$$.fragment,e),y(Ws.$$.fragment,e),y(Rs.$$.fragment,e),y(Xs.$$.fragment,e),y(Ns.$$.fragment,e),y(Ls.$$.fragment,e),y(Ds.$$.fragment,e),y(Es.$$.fragment,e),y(Ps.$$.fragment,e),y(Fs.$$.fragment,e),y(Ks.$$.fragment,e),y(et.$$.fragment,e),y(st.$$.fragment,e),y(lt.$$.fragment,e),y(pt.$$.fragment,e),y(rt.$$.fragment,e),np=!1},d(e){e&&(t($),t(u),t(Mt),t(yt),t(jt),t(w),t(Tt),t(b),t(ct),t(h),t(ut),t(f),t(ft),t(d),t(kt),t($t),t(I),t(Ut),t(C),t(gt),t(z),t(wt),t(bt),t(V),t(ht),t(dt),t(_),t(xt),t(B),t(It),t(Ct),t(Q),t(zt),t(Zt),t(X),t(Vt),t(A),t(vt),t(_t),t(G),t(Bt),t(q),t(Wt),t(Qt),t(H),t(Rt),t(Xt),t(E),t(At),t(S),t(Nt),t(Gt),t(qt),t(Lt),t(Y),t(Ht),t(Dt),t(O),t(Et),t(St),t(se),t(Pt),t(Ft),t(Yt),t(ne),t(Kt),t(Ot),t(el),t(re),t(sl),t(tl),t(ll),t(Je),t(nl),t(pl),t(oe),t(al),t(ye),t(rl),t(il),t(Te),t(Ml),t(Jl),t(ue),t(ml),t(ol),t(yl),t($e),t(jl),t(Ue),t(Tl),t(cl),t(ul),t(be),t(fl),t(he),t(kl),t($l),t(xe),t(Ul),t(Ie),t(gl),t(wl),t(bl),t(Ze),t(hl),t(dl),t(xl),t(_e),t(Il),t(Cl),t(We),t(zl),t(Zl),t(Vl),t(Xe),t(vl),t(_l),t(Ne),t(Bl),t(Wl),t(qe),t(Ql),t(Le),t(Rl),t(Xl),t(De),t(Al),t(Nl),t(Se),t(Gl),t(Pe),t(ql),t(Ll),t(Ye),t(Hl),t(Dl),t(Oe),t(El),t(es),t(Sl),t(Pl),t(ts),t(Fl),t(Yl),t(Kl),t(ps),t(Ol),t(en),t(rs),t(sn),t(is),t(tn),t(ln),t(Js),t(nn),t(pn),t(an),t(ys),t(rn),t(Mn),t(Ts),t(Jn),t(mn),t(on),t(fs),t(yn),t(jn),t($s),t(Tn),t(cn),t(un),t(ws),t(fn),t(kn),t(hs),t($n),t(Un),t(xs),t(gn),t(wn),t(Cs),t(bn),t(hn),t(Zs),t(dn),t(Vs),t(xn),t(In),t(_s),t(Cn),t(Bs),t(zn),t(Zn),t(Qs),t(Vn),t(vn),t(_n),t(As),t(Bn),t(Wn),t(Gs),t(Qn),t(qs),t(Rn),t(Xn),t(Hs),t(An),t(Nn),t(Gn),t(Ss),t(qn),t(Ln),t(Hn),t(Ys),t(Dn),t(En),t(Os),t(Sn),t(Pn),t(Fn),t(tt),t(Yn),t(Kn),t(nt),t(On),t(ep),t(at),t(sp),t(tp),t(it),t(lp),t(Jt)),t(c),j(U,e),j(g,e),j(x,e),j(Z,e),j(v,e),j(W,e),j(R,e),j(N,e),j(L,e),j(D,e),j(P,e),j(F,e),j(k,e),j(K,e),j(ee,e),j(te,e),j(le,e),j(pe,e),j(ae,e),j(ie,e),j(Me,e),j(me,e),j(je,e),j(ce,e),j(fe,e),j(ke,e),j(ge,e),j(we,e),j(de,e),j(Ce,e),j(ze,e),j(Ve,e),j(ve,e),j(Be,e),j(Qe,e),j(Re,e),j(Ae,e),j(Ge,e),j(He,e),j(Ee,e),j(Fe,e),j(Ke,e),j(ss,e),j(ls,e),j(ns,e),j(as,e),j(Ms,e),j(ms,e),j(os,e),j(js,e),j(cs,e),j(us,e),j(ks,e),j(Us,e),j(gs,e),j(bs,e),j(ds,e),j(Is,e),j(zs,e),j(vs,e),j(Ws,e),j(Rs,e),j(Xs,e),j(Ns,e),j(Ls,e),j(Ds,e),j(Es,e),j(Ps,e),j(Fs,e),j(Ks,e),j(et,e),j(st,e),j(lt,e),j(pt,e),j(rt,e)}}}const qa='{"title":"逐块地构建标记器","local":"逐块地构建标记器","sections":[{"title":"获取语​​料库","local":"获取语​​料库","sections":[],"depth":2},{"title":"从头开始构建 WordPiece 标记器","local":"从头开始构建 WordPiece 标记器","sections":[],"depth":2},{"title":"从头开始构建 BPE 标记器","local":"从头开始构建 BPE 标记器","sections":[],"depth":2},{"title":"从头开始构建 Unigram 标记器","local":"从头开始构建 Unigram 标记器","sections":[],"depth":2}],"depth":1}';function La(ot){return Va(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ka extends _a{constructor(c){super(),Ba(this,c,La,Ga,Za,{})}}export{Ka as component};
