import{s as oa,o as ca,n as Rs}from"../chunks/scheduler.37c15a92.js";import{S as ja,i as Ja,g as c,s as e,r as M,A as Ua,h as j,f as n,c as t,j as ua,u as i,x as U,k as ya,y as ma,a,v as r,d as u,t as y,w as o}from"../chunks/index.2bf4358c.js";import{T as Ws}from"../chunks/Tip.363c041f.js";import{Y as Ta}from"../chunks/Youtube.1e50a667.js";import{C as m}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as ha}from"../chunks/CourseFloatingBanner.5dff5e20.js";import{H as Cn}from"../chunks/Heading.8ada512a.js";function wa(w){let p,T="💡 Cette section couvre le BPE en profondeur, allant jusqu’à montrer une implémentation complète. Vous pouvez passer directement à la fin si vous souhaitez simplement avoir un aperçu général de l’algorithme de tokenisation.";return{c(){p=c("p"),p.textContent=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-n0frxx"&&(p.textContent=T)},m(J,h){a(J,p,h)},p:Rs,d(J){J&&n(p)}}}function da(w){let p,T="Les <em>tokenizers</em> du GPT-2 et de RoBERTa (qui sont assez similaires) ont une façon intelligente de gérer ce problème : ils ne considèrent pas les mots comme étant écrits avec des caractères Unicode mais avec des octets. De cette façon, le vocabulaire de base a une petite taille (256) et tous les caractères auxquels vous pouvez penser seront inclus dedans et ne finiront pas par être convertis en un <em>token</em> inconnu. Cette astuce est appelée <em>byte-level BPE</em>.";return{c(){p=c("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-1ytsk3t"&&(p.innerHTML=T)},m(J,h){a(J,p,h)},p:Rs,d(J){J&&n(p)}}}function Ca(w){let p,T="✏️ <strong>A votre tour !</strong> A votre avis, quelle sera la prochaine règle de fusion ?";return{c(){p=c("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-1nzfw18"&&(p.innerHTML=T)},m(J,h){a(J,p,h)},p:Rs,d(J){J&&n(p)}}}function xa(w){let p,T="✏️ <strong>A votre tour !</strong> Comment pensez-vous que le mot « unhug » (détacher en français) sera tokenized ?";return{c(){p=c("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-v8uf64"&&(p.innerHTML=T)},m(J,h){a(J,p,h)},p:Rs,d(J){J&&n(p)}}}function ga(w){let p,T="💡 Utiliser <code>train_new_from_iterator()</code> sur le même corpus ne donnera pas exactement le même vocabulaire. C’est parce que lorsqu’il y a un choix de la paire la plus fréquente, nous avons sélectionné la première rencontrée, alors que la bibliothèque 🤗 <em>Tokenizers</em> sélectionne la première en fonction de ses identifiants internes.";return{c(){p=c("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-83jgtn"&&(p.innerHTML=T)},m(J,h){a(J,p,h)},p:Rs,d(J){J&&n(p)}}}function Ia(w){let p,T="⚠️ Notre implémentation lancera une erreur s’il y a un caractère inconnu puisque nous n’avons rien fait pour les gérer. GPT-2 n’a pas réellement de <i>token</i> inconnu (il est impossible d’obtenir un caractère inconnu en utilisant le BPE au niveau de l’octet) mais cela pourrait arriver ici car nous n’avons pas inclus tous les octets possibles dans le vocabulaire initial. Cet aspect du BPE dépasse le cadre de cette section, nous avons donc laissé ces détails de côté.";return{c(){p=c("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-9fj1z7"&&(p.innerHTML=T)},m(J,h){a(J,p,h)},p:Rs,d(J){J&&n(p)}}}function fa(w){let p,T,J,h,b,Ps,q,Ls,$,xn="Le <em>Byte-Pair Encoding</em> (BPE) a été initialement développé en tant qu’algorithme de compression de textes puis utilisé par OpenAI pour la tokenisation du pré-entraînement du modèle GPT. Il est utilisé par de nombreux <em>transformers</em> dont GPT, GPT-2, RoBERTa, BART et DeBERTa.",Fs,k,Ks,d,Os,Q,sl,A,gn="L’entraînement du BPE commence par le calcul de l’unique ensemble de mots utilisés dans le corpus (après les étapes de normalisation et de prétokénisation), puis la construction du vocabulaire en prenant tous les symboles utilisés pour écrire ces mots. A titre d’exemple, disons que notre corpus utilise ces cinq mots :",ll,B,nl,v,In="Le vocabulaire de base sera alors <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;]</code>. Dans le monde réel, le vocabulaire de base contient au moins tous les caractères ASCII et probablement aussi quelques caractères Unicode. Si un exemple que vous tokenisez utilise un caractère qui n’est pas dans le corpus d’entraînement, ce caractère est converti en <em>token</em> inconnu. C’est l’une des raisons pour lesquelles de nombreux modèles de NLP sont par exemple très mauvais dans l’analyse de contenus contenant des emojis.",al,C,el,V,fn="Après avoir obtenu ce vocabulaire de base, nous ajoutons de nouveaux <em>tokens</em> jusqu’à ce que la taille souhaitée du vocabulaire soit atteinte en apprenant les fusions qui sont des règles permettant de fusionner deux éléments du vocabulaire existant pour en créer un nouveau. Ainsi, au début, ces fusions créeront des <em>tokens</em> de deux caractères, puis au fur et à mesure de l’entraînement, des sous-mots plus longs.",tl,E,bn="À chaque étape de l’entraînement du <em>tokenizer</em>, l’algorithme BPE recherche la paire la plus fréquente de <em>tokens</em> existants (par « paire », nous entendons ici deux <em>tokens</em> consécutifs dans un mot). Cette paire la plus fréquente est celle qui sera fusionnée. Nous rinçons et répétons pour l’étape suivante.",pl,z,qn="Pour revenir à notre exemple précédent, supposons que les mots ont les fréquences suivantes :",Ml,Z,il,G,$n="ce qui veut dire que <code>&quot;hug&quot;</code> était présent 10 fois dans le corpus, <code>&quot;pug&quot;</code> 5 fois, <code>&quot;pun&quot;</code> 12 fois, <code>&quot;bun&quot;</code> 4 fois et <code>&quot;hugs&quot;</code>” 5 fois. Nous commençons l’entraînement en divisant chaque mot en caractères (ceux qui forment notre vocabulaire initial) afin de voir chaque mot comme une liste de <em>tokens</em> :",rl,S,ul,N,kn="Ensuite, nous regardons les paires. La paire <code>(&quot;h&quot;, &quot;u&quot;)</code> est présente dans les mots <code>&quot;hug&quot;</code> et <code>&quot;hugs&quot;</code>, donc 15 fois au total dans le corpus. Ce n’est cependant pas la paire la plus fréquente. Cet honneur revient à <code>(&quot;u&quot;, &quot;g&quot;)</code> qui est présent dans <code>&quot;hug&quot;</code>, <code>&quot;pug&quot;</code>, et <code>&quot;hugs&quot;</code>, pour un total de 20 fois dans le vocabulaire.",yl,_,Qn="Ainsi, la première règle de fusion apprise par le <em>tokenizer</em> est <code>(&quot;u&quot;, &quot;g&quot;) -&gt; &quot;ug&quot;</code>, ce qui signifie que <code>&quot;ug&quot;</code> est ajouté au vocabulaire et que la paire doit être fusionnée dans tous les mots du corpus. A la fin de cette étape, le vocabulaire et le corpus ressemblent à ceci :",ol,H,cl,X,An="Nous avons maintenant quelques paires qui aboutissent à un <em>token</em> de plus de deux caractères. Par exemple la paire <code>(&quot;h&quot;, &quot;ug&quot;)</code> présente 15 fois dans le corpus. La paire la plus fréquente à ce stade est <code>(&quot;u&quot;, &quot;n&quot;)</code>, présente 16 fois dans le corpus, donc la deuxième règle de fusion apprise est <code>(&quot;u&quot;, &quot;n&quot;) -&gt; &quot;un&quot;</code>. En ajoutant cela au vocabulaire et en fusionnant toutes les occurrences existantes, nous obtenons :",jl,D,Jl,W,Bn="Maintenant la paire la plus fréquente est <code>(&quot;h&quot;, &quot;ug&quot;)</code> donc nous apprenons la règle de fusion <code>(&quot;h&quot;, &quot;ug&quot;) -&gt; &quot;hug&quot;</code>. Cela nous donne donc notre premier <em>token</em> de trois lettres. Après la fusion, le corpus ressemble à ceci :",Ul,R,ml,Y,vn="Et nous continuons ainsi jusqu’à ce que nous atteignions la taille de vocabulaire souhaitée.",Tl,x,hl,P,wl,L,Vn="La tokenisation suit de près le processus d’entraînement, dans le sens où les nouvelles entrées sont tokenisées en appliquant les étapes suivantes :",dl,F,En="<li>Normalisation</li> <li>Prétokénisation</li> <li>Découpage des mots en caractères individuels</li> <li>Application des règles de fusion apprises dans l’ordre sur ces divisions.</li>",Cl,K,zn="Prenons l’exemple que nous avons utilisé pendant l’entraînement, avec les trois règles de fusion apprises :",xl,O,gl,ss,Zn="Le mot « bug »  sera traduit par « [“b”, “ug”] ». Par contre, le mot « mug » (tasse en français) sera traduit par « [”[UNK]”, “ug”] » puisque la lettre « m » ne fait pas partie du vocabulaire de base. De la même façon, le mot « thug » (voyou en français) sera tokenisé en « [”[UNK]”, “hug”] » car la lettre « t » n’est pas dans le vocabulaire de base et l’application des règles de fusion résulte d’abord en la fusion de « u » et « g » et ensuite en la fusion de « hu » et « g ».",Il,g,fl,ls,bl,ns,Gn="Voyons maintenant une implémentation de l’algorithme BPE. Il ne s’agira pas d’une version optimisée que vous pourrez utiliser sur un grand corpus. Nous voulons simplement vous montrer le code afin que vous puissiez comprendre un peu mieux l’algorithme.",ql,as,Sn="Tout d’abord, nous avons besoin d’un corpus, alors créons un corpus simple avec quelques phrases :",$l,es,kl,ts,Nn="Ensuite, nous devons prétokeniser ce corpus en mots. Puisque nous répliquons un <em>tokenizer</em> BPE (comme celui du GPT-2), nous utiliserons le <em>tokenizer</em> <code>gpt2</code> pour la prétokénisation :",Ql,ps,Al,Ms,_n="Ensuite, nous calculons les fréquences de chaque mot dans le corpus comme nous le faisons pour la prétokénisation :",Bl,is,vl,rs,Vl,us,Hn="L’étape suivante consiste à calculer le vocabulaire de base, formé par tous les caractères utilisés dans le corpus :",El,ys,zl,os,Zl,cs,Xn="Nous ajoutons également les <em>tokens</em> spéciaux utilisés par le modèle au début de ce vocabulaire. Dans le cas du GPT-2, le seul <em>token</em> spécial est <code>&quot;&lt;|endoftext|&gt;&quot;</code> :",Gl,js,Sl,Js,Dn="Nous devons maintenant diviser chaque mot en caractères individuels pour pouvoir commencer l’entraînement :",Nl,Us,_l,ms,Wn="Maintenant que nous sommes prêts pour l’entraînement, écrivons une fonction qui calcule la fréquence de chaque paire. Nous devrons l’utiliser à chaque étape de l’entraînement :",Hl,Ts,Xl,hs,Rn="Jetons un coup d’œil à une partie de ce dictionnaire après les premières divisions :",Dl,ws,Wl,ds,Rl,Cs,Yn="Maintenant, trouver la paire la plus fréquente ne demande qu’une rapide boucle :",Yl,xs,Pl,gs,Ll,Is,Pn="Donc la première fusion à apprendre est <code>(&#39;Ġ&#39;, &#39;t&#39;) -&gt; &#39;Ġt&#39;</code>, et on ajoute <code>&#39;Ġt&#39;</code> au vocabulaire :",Fl,fs,Kl,bs,Ln="Pour continuer, nous devons appliquer cette fusion dans notre dictionnaire <code>splits</code>. Écrivons une autre fonction pour cela :",Ol,qs,sn,$s,Fn="Et nous pouvons regarder le résultat de la première fusion :",ln,ks,nn,Qs,an,As,Kn="Maintenant, nous avons tout ce dont nous avons besoin pour boucler jusqu’à ce que nous ayons appris toutes les fusions que nous voulons. Visons une taille de vocabulaire de 50 :",en,Bs,tn,vs,On="En conséquence, nous avons appris 19 règles de fusion (le vocabulaire initial avait une taille de 31 : 30 caractères dans l’alphabet plus le <em>token</em> spécial) :",pn,Vs,Mn,Es,rn,zs,sa="Et le vocabulaire est composé du <em>token</em> spécial, de l’alphabet initial, et de tous les résultats des fusions :",un,Zs,yn,Gs,on,I,cn,Ss,la="Pour tokeniser un nouveau texte, on le prétokenise, on le divise, puis on applique toutes les règles de fusion apprises :",jn,Ns,Jn,_s,na="Nous pouvons essayer cela sur n’importe quel texte composé de caractères de l’alphabet :",Un,Hs,mn,Xs,Tn,f,hn,Ds,aa="C’est tout pour l’algorithme BPE ! Nous allons nous intéresser à WordPiece dans la suite.",wn,Ys,dn;return b=new Cn({props:{title:"Tokénisation <i> Byte-Pair Encoding </i>",local:"tokénisation-i-byte-pair-encoding-i",headingTag:"h1"}}),q=new ha({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section5.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter6/section5.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section5.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter6/section5.ipynb"}]}}),k=new Ta({props:{id:"HEikzVL-lZU"}}),d=new Ws({props:{$$slots:{default:[wa]},$$scope:{ctx:w}}}),Q=new Cn({props:{title:"Algorithme d’entraînement",local:"algorithme-dentraînement",headingTag:"h2"}}),B=new m({props:{code:"JTIyaHVnJTIyJTJDJTIwJTIycHVnJTIyJTJDJTIwJTIycHVuJTIyJTJDJTIwJTIyYnVuJTIyJTJDJTIwJTIyaHVncyUyMiUyMCUyMyUyMCUyMmMlQzMlQTJsaW4lMjIlMkMlMjAlMjJjYXJsaW4lMjIlMkMlMjAlMjJqZXUlMjBkZSUyMG1vdHMlMjIlMkMlMjAlMjJicmlvY2hlJTIyJTJDJTIwJTIyYyVDMyVBMmxpbnMlMjI=",highlighted:'<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;pug&quot;</span>, <span class="hljs-string">&quot;pun&quot;</span>, <span class="hljs-string">&quot;bun&quot;</span>, <span class="hljs-string">&quot;hugs&quot;</span> <span class="hljs-meta"># <span class="hljs-string">&quot;câlin&quot;</span>, <span class="hljs-string">&quot;carlin&quot;</span>, <span class="hljs-string">&quot;jeu de mots&quot;</span>, <span class="hljs-string">&quot;brioche&quot;</span>, <span class="hljs-string">&quot;câlins&quot;</span></span>',wrap:!1}}),C=new Ws({props:{$$slots:{default:[da]},$$scope:{ctx:w}}}),Z=new m({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),S=new m({props:{code:"KCUyMmglMjIlMjAlMjJ1JTIyJTIwJTIyZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMmclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnUlMjIlMjAlMjJnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),H=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiU1RCUwQUNvcnB1cyUzQSUyMCglMjJoJTIyJTIwJTIydWclMjIlMkMlMjAxMCklMkMlMjAoJTIycCUyMiUyMCUyMnVnJTIyJTJDJTIwNSklMkMlMjAoJTIycCUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwMTIpJTJDJTIwKCUyMmIlMjIlMjAlMjJ1JTIyJTIwJTIybiUyMiUyQyUyMDQpJTJDJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyMCUyMnMlMjIlMkMlMjA1KQ==",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),D=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),R=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTJDJTIwJTIyaHVnJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),x=new Ws({props:{$$slots:{default:[Ca]},$$scope:{ctx:w}}}),P=new Cn({props:{title:"Algorithme de tokenisation",local:"algorithme-de-tokenisation",headingTag:"h2"}}),O=new m({props:{code:"KCUyMnUlMjIlMkMlMjAlMjJnJTIyKSUyMC0lM0UlMjAlMjJ1ZyUyMiUwQSglMjJ1JTIyJTJDJTIwJTIybiUyMiklMjAtJTNFJTIwJTIydW4lMjIlMEEoJTIyaCUyMiUyQyUyMCUyMnVnJTIyKSUyMC0lM0UlMjAlMjJodWclMjI=",highlighted:`<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;ug&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;un&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;hug&quot;</span>`,wrap:!1}}),g=new Ws({props:{$$slots:{default:[xa]},$$scope:{ctx:w}}}),ls=new Cn({props:{title:"Implémentation du BPE",local:"implémentation-du-bpe",headingTag:"h2"}}),es=new m({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBDb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwQydlc3QlMjBsZSUyMGNvdXJzJTIwZCdIdWdnaW5nJTIwRmFjZS4lMEElMjAlMjAlMjAlMjAlMjJUaGlzJTIwY2hhcHRlciUyMGlzJTIwYWJvdXQlMjB0b2tlbml6YXRpb24uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ2UlMjBjaGFwaXRyZSUyMHRyYWl0ZSUyMGRlJTIwbGElMjB0b2tlbmlzYXRpb24uJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMHNlY3Rpb24lMjBzaG93cyUyMHNldmVyYWwlMjB0b2tlbml6ZXIlMjBhbGdvcml0aG1zLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMENldHRlJTIwc2VjdGlvbiUyMHByJUMzJUE5c2VudGUlMjBwbHVzaWV1cnMlMjBhbGdvcml0aG1lcyUyMGRlJTIwdG9rZW5pemVyLiUwQSUyMCUyMCUyMCUyMCUyMkhvcGVmdWxseSUyQyUyMHlvdSUyMHdpbGwlMjBiZSUyMGFibGUlMjB0byUyMHVuZGVyc3RhbmQlMjBob3clMjB0aGV5JTIwYXJlJTIwdHJhaW5lZCUyMGFuZCUyMGdlbmVyYXRlJTIwdG9rZW5zLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMEF2ZWMlMjB1biUyMHBldSUyMGRlJTIwY2hhbmNlJTJDJTIwdm91cyUyMHNlcmV6JTIwZW4lMjBtZXN1cmUlMjBkZSUyMGNvbXByZW5kcmUlMjBjb21tZW50JTIwaWxzJTIwc29udCUyMGVudHJhJUMzJUFFbiVDMyVBOXMlMjBldCUyMGclQzMlQTluJUMzJUE4cmVudCUyMGRlcyUyMHRva2Vucy4lMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face Course.&quot;</span>,
    <span class="hljs-comment"># C&#x27;est le cours d&#x27;Hugging Face.</span>
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-comment"># Ce chapitre traite de la tokenisation.</span>
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-comment"># Cette section présente plusieurs algorithmes de tokenizer.</span>
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
    <span class="hljs-comment"># Avec un peu de chance, vous serez en mesure de comprendre comment ils sont entraînés et génèrent des tokens.</span>
]`,wrap:!1}}),ps=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),is=new m({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBcHJpbnQod29yZF9mcmVxcyk=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

<span class="hljs-built_in">print</span>(word_freqs)`,wrap:!1}}),rs=new m({props:{code:"ZGVmYXVsdGRpY3QoaW50JTJDJTIwJTdCJ1RoaXMnJTNBJTIwMyUyQyUyMCclQzQlQTBpcyclM0ElMjAyJTJDJTIwJyVDNCVBMHRoZSclM0ElMjAxJTJDJTIwJyVDNCVBMEh1Z2dpbmcnJTNBJTIwMSUyQyUyMCclQzQlQTBGYWNlJyUzQSUyMDElMkMlMjAnJUM0JUEwQ291cnNlJyUzQSUyMDElMkMlMjAnLiclM0ElMjA0JTJDJTIwJyVDNCVBMGNoYXB0ZXInJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCclQzQlQTBhYm91dCclM0ElMjAxJTJDJTIwJyVDNCVBMHRva2VuaXphdGlvbiclM0ElMjAxJTJDJTIwJyVDNCVBMHNlY3Rpb24nJTNBJTIwMSUyQyUyMCclQzQlQTBzaG93cyclM0ElMjAxJTJDJTIwJyVDNCVBMHNldmVyYWwnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbml6ZXInJTNBJTIwMSUyQyUyMCclQzQlQTBhbGdvcml0aG1zJyUzQSUyMDElMkMlMEElMjAlMjAlMjAlMjAnSG9wZWZ1bGx5JyUzQSUyMDElMkMlMjAnJTJDJyUzQSUyMDElMkMlMjAnJUM0JUEweW91JyUzQSUyMDElMkMlMjAnJUM0JUEwd2lsbCclM0ElMjAxJTJDJTIwJyVDNCVBMGJlJyUzQSUyMDElMkMlMjAnJUM0JUEwYWJsZSclM0ElMjAxJTJDJTIwJyVDNCVBMHRvJyUzQSUyMDElMkMlMjAnJUM0JUEwdW5kZXJzdGFuZCclM0ElMjAxJTJDJTIwJyVDNCVBMGhvdyclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJyVDNCVBMHRoZXknJTNBJTIwMSUyQyUyMCclQzQlQTBhcmUnJTNBJTIwMSUyQyUyMCclQzQlQTB0cmFpbmVkJyUzQSUyMDElMkMlMjAnJUM0JUEwYW5kJyUzQSUyMDElMkMlMjAnJUM0JUEwZ2VuZXJhdGUnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbnMnJTNBJTIwMSU3RCk=",highlighted:`defaultdict(<span class="hljs-built_in">int</span>, {<span class="hljs-string">&#x27;This&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠHugging&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠFace&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠCourse&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;.&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;Ġchapter&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġabout&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenization&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġsection&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġshows&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġseveral&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenizer&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġalgorithms&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Hopefully&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;,&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġyou&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġwill&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġbe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġable&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġunderstand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġhow&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġthey&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġare&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtrained&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġgenerate&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokens&#x27;</span>: <span class="hljs-number">1</span>})`,wrap:!1}}),ys=new m({props:{code:"YWxwaGFiZXQlMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzLmtleXMoKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGxldHRlciUyMGluJTIwd29yZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGV0dGVyJTIwbm90JTIwaW4lMjBhbHBoYWJldCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFscGhhYmV0LmFwcGVuZChsZXR0ZXIpJTBBYWxwaGFiZXQuc29ydCgpJTBBJTBBcHJpbnQoYWxwaGFiZXQp",highlighted:`alphabet = []

<span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys():
    <span class="hljs-keyword">for</span> letter <span class="hljs-keyword">in</span> word:
        <span class="hljs-keyword">if</span> letter <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
            alphabet.append(letter)
alphabet.sort()

<span class="hljs-built_in">print</span>(alphabet)`,wrap:!1}}),os=new m({props:{code:"JTVCJTIwJyUyQyclMkMlMjAnLiclMkMlMjAnQyclMkMlMjAnRiclMkMlMjAnSCclMkMlMjAnVCclMkMlMjAnYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclMkMlMjAnZSclMkMlMjAnZiclMkMlMjAnZyclMkMlMjAnaCclMkMlMjAnaSclMkMlMjAnayclMkMlMjAnbCclMkMlMjAnbSclMkMlMjAnbiclMkMlMjAnbyclMkMlMjAncCclMkMlMjAnciclMkMlMjAncyclMkMlMEElMjAlMjAndCclMkMlMjAndSclMkMlMjAndiclMkMlMjAndyclMkMlMjAneSclMkMlMjAneiclMkMlMjAnJUM0JUEwJyU1RA==",highlighted:`[ <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>,
  <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>]`,wrap:!1}}),js=new m({props:{code:"dm9jYWIlMjAlM0QlMjAlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQlMjAlMkIlMjBhbHBoYWJldC5jb3B5KCk=",highlighted:'vocab = [<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>] + alphabet.copy()',wrap:!1}}),Us=new m({props:{code:"c3BsaXRzJTIwJTNEJTIwJTdCd29yZCUzQSUyMCU1QmMlMjBmb3IlMjBjJTIwaW4lMjB3b3JkJTVEJTIwZm9yJTIwd29yZCUyMGluJTIwd29yZF9mcmVxcy5rZXlzKCklN0Q=",highlighted:'splits = {word: [c <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys()}',wrap:!1}}),Ts=new m({props:{code:"ZGVmJTIwY29tcHV0ZV9wYWlyX2ZyZXFzKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBwYWlyX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUyMCUyMCUyMCUyMGZvciUyMHdvcmQlMkMlMjBmcmVxJTIwaW4lMjB3b3JkX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0cyU1QndvcmQlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGxlbihzcGxpdCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGludWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oc3BsaXQpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMChzcGxpdCU1QmklNUQlMkMlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlNUJwYWlyJTVEJTIwJTJCJTNEJTIwZnJlcSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHBhaXJfZnJlcXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_pair_freqs</span>(<span class="hljs-params">splits</span>):
    pair_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>):
            pair = (split[i], split[i + <span class="hljs-number">1</span>])
            pair_freqs[pair] += freq
    <span class="hljs-keyword">return</span> pair_freqs`,wrap:!1}}),ws=new m({props:{code:"cGFpcl9mcmVxcyUyMCUzRCUyMGNvbXB1dGVfcGFpcl9mcmVxcyhzcGxpdHMpJTBBJTBBZm9yJTIwaSUyQyUyMGtleSUyMGluJTIwZW51bWVyYXRlKHBhaXJfZnJlcXMua2V5cygpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JrZXklN0QlM0ElMjAlN0JwYWlyX2ZyZXFzJTVCa2V5JTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRSUzRCUyMDUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhaw==",highlighted:`pair_freqs = compute_pair_freqs(splits)

<span class="hljs-keyword">for</span> i, key <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pair_freqs.keys()):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>: <span class="hljs-subst">{pair_freqs[key]}</span>&quot;</span>)
    <span class="hljs-keyword">if</span> i &gt;= <span class="hljs-number">5</span>:
        <span class="hljs-keyword">break</span>`,wrap:!1}}),ds=new m({props:{code:"KCdUJyUyQyUyMCdoJyklM0ElMjAzJTBBKCdoJyUyQyUyMCdpJyklM0ElMjAzJTBBKCdpJyUyQyUyMCdzJyklM0ElMjA1JTBBKCclQzQlQTAnJTJDJTIwJ2knKSUzQSUyMDIlMEEoJyVDNCVBMCclMkMlMjAndCcpJTNBJTIwNyUwQSgndCclMkMlMjAnaCcpJTNBJTIwMw==",highlighted:`(<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-number">5</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">2</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-number">7</span>
(<span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>`,wrap:!1}}),xs=new m({props:{code:"YmVzdF9wYWlyJTIwJTNEJTIwJTIyJTIyJTBBbWF4X2ZyZXElMjAlM0QlMjBOb25lJTBBJTBBZm9yJTIwcGFpciUyQyUyMGZyZXElMjBpbiUyMHBhaXJfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWF4X2ZyZXElMjBpcyUyME5vbmUlMjBvciUyMG1heF9mcmVxJTIwJTNDJTIwZnJlcSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMHBhaXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfZnJlcSUyMCUzRCUyMGZyZXElMEElMEFwcmludChiZXN0X3BhaXIlMkMlMjBtYXhfZnJlcSk=",highlighted:`best_pair = <span class="hljs-string">&quot;&quot;</span>
max_freq = <span class="hljs-literal">None</span>

<span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
    <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
        best_pair = pair
        max_freq = freq

<span class="hljs-built_in">print</span>(best_pair, max_freq)`,wrap:!1}}),gs=new m({props:{code:"KCclQzQlQTAnJTJDJTIwJ3QnKSUyMDc=",highlighted:'(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>) <span class="hljs-number">7</span>',wrap:!1}}),fs=new m({props:{code:"bWVyZ2VzJTIwJTNEJTIwJTdCKCUyMiVDNCVBMCUyMiUyQyUyMCUyMnQlMjIpJTNBJTIwJTIyJUM0JUEwdCUyMiU3RCUwQXZvY2FiLmFwcGVuZCglMjIlQzQlQTB0JTIyKQ==",highlighted:`merges = {(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>): <span class="hljs-string">&quot;Ġt&quot;</span>}
vocab.append(<span class="hljs-string">&quot;Ġt&quot;</span>)`,wrap:!1}}),qs=new m({props:{code:"ZGVmJTIwbWVyZ2VfcGFpcihhJTJDJTIwYiUyQyUyMHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXQlMjAlM0QlMjBzcGxpdHMlNUJ3b3JkJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc3BsaXQpJTIwJTNEJTNEJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRpbnVlJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGlsZSUyMGklMjAlM0MlMjBsZW4oc3BsaXQpJTIwLSUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNwbGl0JTVCaSU1RCUyMCUzRCUzRCUyMGElMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXQlNUIlM0FpJTVEJTIwJTJCJTIwJTVCYSUyMCUyQiUyMGIlNUQlMjAlMkIlMjBzcGxpdCU1QmklMjAlMkIlMjAyJTIwJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAlMkIlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXRzJTVCd29yZCU1RCUyMCUzRCUyMHNwbGl0JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3BsaXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_pair</span>(<span class="hljs-params">a, b, splits</span>):
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs:
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>

        i = <span class="hljs-number">0</span>
        <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
            <span class="hljs-keyword">if</span> split[i] == a <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == b:
                split = split[:i] + [a + b] + split[i + <span class="hljs-number">2</span> :]
            <span class="hljs-keyword">else</span>:
                i += <span class="hljs-number">1</span>
        splits[word] = split
    <span class="hljs-keyword">return</span> splits`,wrap:!1}}),ks=new m({props:{code:"c3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpciglMjIlQzQlQTAlMjIlMkMlMjAlMjJ0JTIyJTJDJTIwc3BsaXRzKSUwQXByaW50KHNwbGl0cyU1QiUyMiVDNCVBMHRyYWluZWQlMjIlNUQp",highlighted:`splits = merge_pair(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, splits)
<span class="hljs-built_in">print</span>(splits[<span class="hljs-string">&quot;Ġtrained&quot;</span>])`,wrap:!1}}),Qs=new m({props:{code:"JTVCJyVDNCVBMHQnJTJDJTIwJ3InJTJDJTIwJ2EnJTJDJTIwJ2knJTJDJTIwJ24nJTJDJTIwJ2UnJTJDJTIwJ2QnJTVE",highlighted:'[<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>]',wrap:!1}}),Bs=new m({props:{code:"dm9jYWJfc2l6ZSUyMCUzRCUyMDUwJTBBJTBBd2hpbGUlMjBsZW4odm9jYWIpJTIwJTNDJTIwdm9jYWJfc2l6ZSUzQSUwQSUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlMjAlM0QlMjBjb21wdXRlX3BhaXJfZnJlcXMoc3BsaXRzKSUwQSUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMG1heF9mcmVxJTIwJTNEJTIwTm9uZSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBmcmVxJTIwaW4lMjBwYWlyX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG1heF9mcmVxJTIwaXMlMjBOb25lJTIwb3IlMjBtYXhfZnJlcSUyMCUzQyUyMGZyZXElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiZXN0X3BhaXIlMjAlM0QlMjBwYWlyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2ZyZXElMjAlM0QlMjBmcmVxJTBBJTIwJTIwJTIwJTIwc3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpcigqYmVzdF9wYWlyJTJDJTIwc3BsaXRzKSUwQSUyMCUyMCUyMCUyMG1lcmdlcyU1QmJlc3RfcGFpciU1RCUyMCUzRCUyMGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEJTBBJTIwJTIwJTIwJTIwdm9jYWIuYXBwZW5kKGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEKQ==",highlighted:`vocab_size = <span class="hljs-number">50</span>

<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(vocab) &lt; vocab_size:
    pair_freqs = compute_pair_freqs(splits)
    best_pair = <span class="hljs-string">&quot;&quot;</span>
    max_freq = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
        <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
            best_pair = pair
            max_freq = freq
    splits = merge_pair(*best_pair, splits)
    merges[best_pair] = best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>]
    vocab.append(best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>])`,wrap:!1}}),Vs=new m({props:{code:"cHJpbnQobWVyZ2VzKQ==",highlighted:'<span class="hljs-built_in">print</span>(merges)',wrap:!1}}),Es=new m({props:{code:"JTdCKCclQzQlQTAnJTJDJTIwJ3QnKSUzQSUyMCclQzQlQTB0JyUyQyUyMCgnaSclMkMlMjAncycpJTNBJTIwJ2lzJyUyQyUyMCgnZSclMkMlMjAncicpJTNBJTIwJ2VyJyUyQyUyMCgnJUM0JUEwJyUyQyUyMCdhJyklM0ElMjAnJUM0JUEwYSclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ28nKSUzQSUyMCclQzQlQTB0byclMkMlMjAoJ2UnJTJDJTIwJ24nKSUzQSUyMCdlbiclMkMlMEElMjAoJ1QnJTJDJTIwJ2gnKSUzQSUyMCdUaCclMkMlMjAoJ1RoJyUyQyUyMCdpcycpJTNBJTIwJ1RoaXMnJTJDJTIwKCdvJyUyQyUyMCd1JyklM0ElMjAnb3UnJTJDJTIwKCdzJyUyQyUyMCdlJyklM0ElMjAnc2UnJTJDJTIwKCclQzQlQTB0byclMkMlMjAnaycpJTNBJTIwJyVDNCVBMHRvayclMkMlMEElMjAoJyVDNCVBMHRvayclMkMlMjAnZW4nKSUzQSUyMCclQzQlQTB0b2tlbiclMkMlMjAoJ24nJTJDJTIwJ2QnKSUzQSUyMCduZCclMkMlMjAoJyVDNCVBMCclMkMlMjAnaXMnKSUzQSUyMCclQzQlQTBpcyclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ2gnKSUzQSUyMCclQzQlQTB0aCclMkMlMjAoJyVDNCVBMHRoJyUyQyUyMCdlJyklM0ElMjAnJUM0JUEwdGhlJyUyQyUwQSUyMCgnaSclMkMlMjAnbicpJTNBJTIwJ2luJyUyQyUyMCgnJUM0JUEwYSclMkMlMjAnYicpJTNBJTIwJyVDNCVBMGFiJyUyQyUyMCgnJUM0JUEwdG9rZW4nJTJDJTIwJ2knKSUzQSUyMCclQzQlQTB0b2tlbmknJTdE",highlighted:`{(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-string">&#x27;Ġt&#x27;</span>, (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-string">&#x27;is&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>): <span class="hljs-string">&#x27;er&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>): <span class="hljs-string">&#x27;Ġa&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>): <span class="hljs-string">&#x27;Ġto&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;en&#x27;</span>,
 (<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Th&#x27;</span>, (<span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;This&#x27;</span>, (<span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>): <span class="hljs-string">&#x27;ou&#x27;</span>, (<span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;se&#x27;</span>, (<span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>): <span class="hljs-string">&#x27;Ġtok&#x27;</span>,
 (<span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>): <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, (<span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>): <span class="hljs-string">&#x27;nd&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;Ġis&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Ġth&#x27;</span>, (<span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;Ġthe&#x27;</span>,
 (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;in&#x27;</span>, (<span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>): <span class="hljs-string">&#x27;Ġab&#x27;</span>, (<span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>}`,wrap:!1}}),Zs=new m({props:{code:"cHJpbnQodm9jYWIp",highlighted:'<span class="hljs-built_in">print</span>(vocab)',wrap:!1}}),Gs=new m({props:{code:"JTVCJyUzQyU3Q2VuZG9mdGV4dCU3QyUzRSclMkMlMjAnJTJDJyUyQyUyMCcuJyUyQyUyMCdDJyUyQyUyMCdGJyUyQyUyMCdIJyUyQyUyMCdUJyUyQyUyMCdhJyUyQyUyMCdiJyUyQyUyMCdjJyUyQyUyMCdkJyUyQyUyMCdlJyUyQyUyMCdmJyUyQyUyMCdnJyUyQyUyMCdoJyUyQyUyMCdpJyUyQyUyMCdrJyUyQyUyMCdsJyUyQyUyMCdtJyUyQyUyMCduJyUyQyUyMCdvJyUyQyUwQSUyMCdwJyUyQyUyMCdyJyUyQyUyMCdzJyUyQyUyMCd0JyUyQyUyMCd1JyUyQyUyMCd2JyUyQyUyMCd3JyUyQyUyMCd5JyUyQyUyMCd6JyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMHQnJTJDJTIwJ2lzJyUyQyUyMCdlciclMkMlMjAnJUM0JUEwYSclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2VuJyUyQyUyMCdUaCclMkMlMjAnVGhpcyclMkMlMjAnb3UnJTJDJTIwJ3NlJyUyQyUwQSUyMCclQzQlQTB0b2snJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCduZCclMkMlMjAnJUM0JUEwaXMnJTJDJTIwJyVDNCVBMHRoJyUyQyUyMCclQzQlQTB0aGUnJTJDJTIwJ2luJyUyQyUyMCclQzQlQTBhYiclMkMlMjAnJUM0JUEwdG9rZW5pJyU1RA==",highlighted:`[<span class="hljs-string">&#x27;&lt;|endoftext|&gt;&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>,
 <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;er&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;ou&#x27;</span>, <span class="hljs-string">&#x27;se&#x27;</span>,
 <span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;nd&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;Ġab&#x27;</span>, <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>]`,wrap:!1}}),I=new Ws({props:{$$slots:{default:[ga]},$$scope:{ctx:w}}}),Ns=new m({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCklM0ElMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVfcmVzdWx0JTIwJTNEJTIwdG9rZW5pemVyLl90b2tlbml6ZXIucHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKHRleHQpJTBBJTIwJTIwJTIwJTIwcHJlX3Rva2VuaXplZF90ZXh0JTIwJTNEJTIwJTVCd29yZCUyMGZvciUyMHdvcmQlMkMlMjBvZmZzZXQlMjBpbiUyMHByZV90b2tlbml6ZV9yZXN1bHQlNUQlMEElMjAlMjAlMjAlMjBzcGxpdHMlMjAlM0QlMjAlNUIlNUJsJTIwZm9yJTIwbCUyMGluJTIwd29yZCU1RCUyMGZvciUyMHdvcmQlMjBpbiUyMHByZV90b2tlbml6ZWRfdGV4dCU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBtZXJnZSUyMGluJTIwbWVyZ2VzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpZHglMkMlMjBzcGxpdCUyMGluJTIwZW51bWVyYXRlKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTNEJTIwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdoaWxlJTIwaSUyMCUzQyUyMGxlbihzcGxpdCklMjAtJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3BsaXQlNUJpJTVEJTIwJTNEJTNEJTIwcGFpciU1QjAlNUQlMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwcGFpciU1QjElNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0JTVCJTNBaSU1RCUyMCUyQiUyMCU1Qm1lcmdlJTVEJTIwJTJCJTIwc3BsaXQlNUJpJTIwJTJCJTIwMiUyMCUzQSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTJCJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0cyU1QmlkeCU1RCUyMCUzRCUyMHNwbGl0JTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3VtKHNwbGl0cyUyQyUyMCU1QiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text</span>):
    pre_tokenize_result = tokenizer._tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> pre_tokenize_result]
    splits = [[l <span class="hljs-keyword">for</span> l <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">for</span> pair, merge <span class="hljs-keyword">in</span> merges.items():
        <span class="hljs-keyword">for</span> idx, split <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(splits):
            i = <span class="hljs-number">0</span>
            <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
                <span class="hljs-keyword">if</span> split[i] == pair[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == pair[<span class="hljs-number">1</span>]:
                    split = split[:i] + [merge] + split[i + <span class="hljs-number">2</span> :]
                <span class="hljs-keyword">else</span>:
                    i += <span class="hljs-number">1</span>
            splits[idx] = split

    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(splits, [])`,wrap:!1}}),Hs=new m({props:{code:"dG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwbm90JTIwYSUyMHRva2VuLiUyMik=",highlighted:'tokenize(<span class="hljs-string">&quot;This is not a token.&quot;</span>)',wrap:!1}}),Xs=new m({props:{code:"JTVCJ1RoaXMnJTJDJTIwJyVDNCVBMGlzJyUyQyUyMCclQzQlQTAnJTJDJTIwJ24nJTJDJTIwJ28nJTJDJTIwJ3QnJTJDJTIwJyVDNCVBMGEnJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCcuJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),f=new Ws({props:{warning:!0,$$slots:{default:[Ia]},$$scope:{ctx:w}}}),{c(){p=c("meta"),T=e(),J=c("p"),h=e(),M(b.$$.fragment),Ps=e(),M(q.$$.fragment),Ls=e(),$=c("p"),$.innerHTML=xn,Fs=e(),M(k.$$.fragment),Ks=e(),M(d.$$.fragment),Os=e(),M(Q.$$.fragment),sl=e(),A=c("p"),A.textContent=gn,ll=e(),M(B.$$.fragment),nl=e(),v=c("p"),v.innerHTML=In,al=e(),M(C.$$.fragment),el=e(),V=c("p"),V.innerHTML=fn,tl=e(),E=c("p"),E.innerHTML=bn,pl=e(),z=c("p"),z.textContent=qn,Ml=e(),M(Z.$$.fragment),il=e(),G=c("p"),G.innerHTML=$n,rl=e(),M(S.$$.fragment),ul=e(),N=c("p"),N.innerHTML=kn,yl=e(),_=c("p"),_.innerHTML=Qn,ol=e(),M(H.$$.fragment),cl=e(),X=c("p"),X.innerHTML=An,jl=e(),M(D.$$.fragment),Jl=e(),W=c("p"),W.innerHTML=Bn,Ul=e(),M(R.$$.fragment),ml=e(),Y=c("p"),Y.textContent=vn,Tl=e(),M(x.$$.fragment),hl=e(),M(P.$$.fragment),wl=e(),L=c("p"),L.textContent=Vn,dl=e(),F=c("ol"),F.innerHTML=En,Cl=e(),K=c("p"),K.textContent=zn,xl=e(),M(O.$$.fragment),gl=e(),ss=c("p"),ss.textContent=Zn,Il=e(),M(g.$$.fragment),fl=e(),M(ls.$$.fragment),bl=e(),ns=c("p"),ns.textContent=Gn,ql=e(),as=c("p"),as.textContent=Sn,$l=e(),M(es.$$.fragment),kl=e(),ts=c("p"),ts.innerHTML=Nn,Ql=e(),M(ps.$$.fragment),Al=e(),Ms=c("p"),Ms.textContent=_n,Bl=e(),M(is.$$.fragment),vl=e(),M(rs.$$.fragment),Vl=e(),us=c("p"),us.textContent=Hn,El=e(),M(ys.$$.fragment),zl=e(),M(os.$$.fragment),Zl=e(),cs=c("p"),cs.innerHTML=Xn,Gl=e(),M(js.$$.fragment),Sl=e(),Js=c("p"),Js.textContent=Dn,Nl=e(),M(Us.$$.fragment),_l=e(),ms=c("p"),ms.textContent=Wn,Hl=e(),M(Ts.$$.fragment),Xl=e(),hs=c("p"),hs.textContent=Rn,Dl=e(),M(ws.$$.fragment),Wl=e(),M(ds.$$.fragment),Rl=e(),Cs=c("p"),Cs.textContent=Yn,Yl=e(),M(xs.$$.fragment),Pl=e(),M(gs.$$.fragment),Ll=e(),Is=c("p"),Is.innerHTML=Pn,Fl=e(),M(fs.$$.fragment),Kl=e(),bs=c("p"),bs.innerHTML=Ln,Ol=e(),M(qs.$$.fragment),sn=e(),$s=c("p"),$s.textContent=Fn,ln=e(),M(ks.$$.fragment),nn=e(),M(Qs.$$.fragment),an=e(),As=c("p"),As.textContent=Kn,en=e(),M(Bs.$$.fragment),tn=e(),vs=c("p"),vs.innerHTML=On,pn=e(),M(Vs.$$.fragment),Mn=e(),M(Es.$$.fragment),rn=e(),zs=c("p"),zs.innerHTML=sa,un=e(),M(Zs.$$.fragment),yn=e(),M(Gs.$$.fragment),on=e(),M(I.$$.fragment),cn=e(),Ss=c("p"),Ss.textContent=la,jn=e(),M(Ns.$$.fragment),Jn=e(),_s=c("p"),_s.textContent=na,Un=e(),M(Hs.$$.fragment),mn=e(),M(Xs.$$.fragment),Tn=e(),M(f.$$.fragment),hn=e(),Ds=c("p"),Ds.textContent=aa,wn=e(),Ys=c("p"),this.h()},l(s){const l=Ua("svelte-u9bgzb",document.head);p=j(l,"META",{name:!0,content:!0}),l.forEach(n),T=t(s),J=j(s,"P",{}),ua(J).forEach(n),h=t(s),i(b.$$.fragment,s),Ps=t(s),i(q.$$.fragment,s),Ls=t(s),$=j(s,"P",{"data-svelte-h":!0}),U($)!=="svelte-dc4rw6"&&($.innerHTML=xn),Fs=t(s),i(k.$$.fragment,s),Ks=t(s),i(d.$$.fragment,s),Os=t(s),i(Q.$$.fragment,s),sl=t(s),A=j(s,"P",{"data-svelte-h":!0}),U(A)!=="svelte-1h87em1"&&(A.textContent=gn),ll=t(s),i(B.$$.fragment,s),nl=t(s),v=j(s,"P",{"data-svelte-h":!0}),U(v)!=="svelte-1uj0emc"&&(v.innerHTML=In),al=t(s),i(C.$$.fragment,s),el=t(s),V=j(s,"P",{"data-svelte-h":!0}),U(V)!=="svelte-1qcfng4"&&(V.innerHTML=fn),tl=t(s),E=j(s,"P",{"data-svelte-h":!0}),U(E)!=="svelte-34wkn5"&&(E.innerHTML=bn),pl=t(s),z=j(s,"P",{"data-svelte-h":!0}),U(z)!=="svelte-1xtdwct"&&(z.textContent=qn),Ml=t(s),i(Z.$$.fragment,s),il=t(s),G=j(s,"P",{"data-svelte-h":!0}),U(G)!=="svelte-8gs7d7"&&(G.innerHTML=$n),rl=t(s),i(S.$$.fragment,s),ul=t(s),N=j(s,"P",{"data-svelte-h":!0}),U(N)!=="svelte-1eoh852"&&(N.innerHTML=kn),yl=t(s),_=j(s,"P",{"data-svelte-h":!0}),U(_)!=="svelte-30qtcv"&&(_.innerHTML=Qn),ol=t(s),i(H.$$.fragment,s),cl=t(s),X=j(s,"P",{"data-svelte-h":!0}),U(X)!=="svelte-cosm6m"&&(X.innerHTML=An),jl=t(s),i(D.$$.fragment,s),Jl=t(s),W=j(s,"P",{"data-svelte-h":!0}),U(W)!=="svelte-1hj74ey"&&(W.innerHTML=Bn),Ul=t(s),i(R.$$.fragment,s),ml=t(s),Y=j(s,"P",{"data-svelte-h":!0}),U(Y)!=="svelte-1phz38r"&&(Y.textContent=vn),Tl=t(s),i(x.$$.fragment,s),hl=t(s),i(P.$$.fragment,s),wl=t(s),L=j(s,"P",{"data-svelte-h":!0}),U(L)!=="svelte-h50xo1"&&(L.textContent=Vn),dl=t(s),F=j(s,"OL",{"data-svelte-h":!0}),U(F)!=="svelte-19lg3ll"&&(F.innerHTML=En),Cl=t(s),K=j(s,"P",{"data-svelte-h":!0}),U(K)!=="svelte-11oyli9"&&(K.textContent=zn),xl=t(s),i(O.$$.fragment,s),gl=t(s),ss=j(s,"P",{"data-svelte-h":!0}),U(ss)!=="svelte-ciih5f"&&(ss.textContent=Zn),Il=t(s),i(g.$$.fragment,s),fl=t(s),i(ls.$$.fragment,s),bl=t(s),ns=j(s,"P",{"data-svelte-h":!0}),U(ns)!=="svelte-hkuo77"&&(ns.textContent=Gn),ql=t(s),as=j(s,"P",{"data-svelte-h":!0}),U(as)!=="svelte-1gfdk4v"&&(as.textContent=Sn),$l=t(s),i(es.$$.fragment,s),kl=t(s),ts=j(s,"P",{"data-svelte-h":!0}),U(ts)!=="svelte-1vs4829"&&(ts.innerHTML=Nn),Ql=t(s),i(ps.$$.fragment,s),Al=t(s),Ms=j(s,"P",{"data-svelte-h":!0}),U(Ms)!=="svelte-1nr0ogy"&&(Ms.textContent=_n),Bl=t(s),i(is.$$.fragment,s),vl=t(s),i(rs.$$.fragment,s),Vl=t(s),us=j(s,"P",{"data-svelte-h":!0}),U(us)!=="svelte-6zl3q0"&&(us.textContent=Hn),El=t(s),i(ys.$$.fragment,s),zl=t(s),i(os.$$.fragment,s),Zl=t(s),cs=j(s,"P",{"data-svelte-h":!0}),U(cs)!=="svelte-zf5wvt"&&(cs.innerHTML=Xn),Gl=t(s),i(js.$$.fragment,s),Sl=t(s),Js=j(s,"P",{"data-svelte-h":!0}),U(Js)!=="svelte-189wuny"&&(Js.textContent=Dn),Nl=t(s),i(Us.$$.fragment,s),_l=t(s),ms=j(s,"P",{"data-svelte-h":!0}),U(ms)!=="svelte-1k3lfsg"&&(ms.textContent=Wn),Hl=t(s),i(Ts.$$.fragment,s),Xl=t(s),hs=j(s,"P",{"data-svelte-h":!0}),U(hs)!=="svelte-jx1j1k"&&(hs.textContent=Rn),Dl=t(s),i(ws.$$.fragment,s),Wl=t(s),i(ds.$$.fragment,s),Rl=t(s),Cs=j(s,"P",{"data-svelte-h":!0}),U(Cs)!=="svelte-1fn9ojv"&&(Cs.textContent=Yn),Yl=t(s),i(xs.$$.fragment,s),Pl=t(s),i(gs.$$.fragment,s),Ll=t(s),Is=j(s,"P",{"data-svelte-h":!0}),U(Is)!=="svelte-ctr4pf"&&(Is.innerHTML=Pn),Fl=t(s),i(fs.$$.fragment,s),Kl=t(s),bs=j(s,"P",{"data-svelte-h":!0}),U(bs)!=="svelte-1he3dod"&&(bs.innerHTML=Ln),Ol=t(s),i(qs.$$.fragment,s),sn=t(s),$s=j(s,"P",{"data-svelte-h":!0}),U($s)!=="svelte-1nfafzn"&&($s.textContent=Fn),ln=t(s),i(ks.$$.fragment,s),nn=t(s),i(Qs.$$.fragment,s),an=t(s),As=j(s,"P",{"data-svelte-h":!0}),U(As)!=="svelte-wy0zl0"&&(As.textContent=Kn),en=t(s),i(Bs.$$.fragment,s),tn=t(s),vs=j(s,"P",{"data-svelte-h":!0}),U(vs)!=="svelte-1wab3fs"&&(vs.innerHTML=On),pn=t(s),i(Vs.$$.fragment,s),Mn=t(s),i(Es.$$.fragment,s),rn=t(s),zs=j(s,"P",{"data-svelte-h":!0}),U(zs)!=="svelte-kmb1d9"&&(zs.innerHTML=sa),un=t(s),i(Zs.$$.fragment,s),yn=t(s),i(Gs.$$.fragment,s),on=t(s),i(I.$$.fragment,s),cn=t(s),Ss=j(s,"P",{"data-svelte-h":!0}),U(Ss)!=="svelte-1dqmvm3"&&(Ss.textContent=la),jn=t(s),i(Ns.$$.fragment,s),Jn=t(s),_s=j(s,"P",{"data-svelte-h":!0}),U(_s)!=="svelte-15d4qki"&&(_s.textContent=na),Un=t(s),i(Hs.$$.fragment,s),mn=t(s),i(Xs.$$.fragment,s),Tn=t(s),i(f.$$.fragment,s),hn=t(s),Ds=j(s,"P",{"data-svelte-h":!0}),U(Ds)!=="svelte-e7tmzh"&&(Ds.textContent=aa),wn=t(s),Ys=j(s,"P",{}),ua(Ys).forEach(n),this.h()},h(){ya(p,"name","hf:doc:metadata"),ya(p,"content",ba)},m(s,l){ma(document.head,p),a(s,T,l),a(s,J,l),a(s,h,l),r(b,s,l),a(s,Ps,l),r(q,s,l),a(s,Ls,l),a(s,$,l),a(s,Fs,l),r(k,s,l),a(s,Ks,l),r(d,s,l),a(s,Os,l),r(Q,s,l),a(s,sl,l),a(s,A,l),a(s,ll,l),r(B,s,l),a(s,nl,l),a(s,v,l),a(s,al,l),r(C,s,l),a(s,el,l),a(s,V,l),a(s,tl,l),a(s,E,l),a(s,pl,l),a(s,z,l),a(s,Ml,l),r(Z,s,l),a(s,il,l),a(s,G,l),a(s,rl,l),r(S,s,l),a(s,ul,l),a(s,N,l),a(s,yl,l),a(s,_,l),a(s,ol,l),r(H,s,l),a(s,cl,l),a(s,X,l),a(s,jl,l),r(D,s,l),a(s,Jl,l),a(s,W,l),a(s,Ul,l),r(R,s,l),a(s,ml,l),a(s,Y,l),a(s,Tl,l),r(x,s,l),a(s,hl,l),r(P,s,l),a(s,wl,l),a(s,L,l),a(s,dl,l),a(s,F,l),a(s,Cl,l),a(s,K,l),a(s,xl,l),r(O,s,l),a(s,gl,l),a(s,ss,l),a(s,Il,l),r(g,s,l),a(s,fl,l),r(ls,s,l),a(s,bl,l),a(s,ns,l),a(s,ql,l),a(s,as,l),a(s,$l,l),r(es,s,l),a(s,kl,l),a(s,ts,l),a(s,Ql,l),r(ps,s,l),a(s,Al,l),a(s,Ms,l),a(s,Bl,l),r(is,s,l),a(s,vl,l),r(rs,s,l),a(s,Vl,l),a(s,us,l),a(s,El,l),r(ys,s,l),a(s,zl,l),r(os,s,l),a(s,Zl,l),a(s,cs,l),a(s,Gl,l),r(js,s,l),a(s,Sl,l),a(s,Js,l),a(s,Nl,l),r(Us,s,l),a(s,_l,l),a(s,ms,l),a(s,Hl,l),r(Ts,s,l),a(s,Xl,l),a(s,hs,l),a(s,Dl,l),r(ws,s,l),a(s,Wl,l),r(ds,s,l),a(s,Rl,l),a(s,Cs,l),a(s,Yl,l),r(xs,s,l),a(s,Pl,l),r(gs,s,l),a(s,Ll,l),a(s,Is,l),a(s,Fl,l),r(fs,s,l),a(s,Kl,l),a(s,bs,l),a(s,Ol,l),r(qs,s,l),a(s,sn,l),a(s,$s,l),a(s,ln,l),r(ks,s,l),a(s,nn,l),r(Qs,s,l),a(s,an,l),a(s,As,l),a(s,en,l),r(Bs,s,l),a(s,tn,l),a(s,vs,l),a(s,pn,l),r(Vs,s,l),a(s,Mn,l),r(Es,s,l),a(s,rn,l),a(s,zs,l),a(s,un,l),r(Zs,s,l),a(s,yn,l),r(Gs,s,l),a(s,on,l),r(I,s,l),a(s,cn,l),a(s,Ss,l),a(s,jn,l),r(Ns,s,l),a(s,Jn,l),a(s,_s,l),a(s,Un,l),r(Hs,s,l),a(s,mn,l),r(Xs,s,l),a(s,Tn,l),r(f,s,l),a(s,hn,l),a(s,Ds,l),a(s,wn,l),a(s,Ys,l),dn=!0},p(s,[l]){const ea={};l&2&&(ea.$$scope={dirty:l,ctx:s}),d.$set(ea);const ta={};l&2&&(ta.$$scope={dirty:l,ctx:s}),C.$set(ta);const pa={};l&2&&(pa.$$scope={dirty:l,ctx:s}),x.$set(pa);const Ma={};l&2&&(Ma.$$scope={dirty:l,ctx:s}),g.$set(Ma);const ia={};l&2&&(ia.$$scope={dirty:l,ctx:s}),I.$set(ia);const ra={};l&2&&(ra.$$scope={dirty:l,ctx:s}),f.$set(ra)},i(s){dn||(u(b.$$.fragment,s),u(q.$$.fragment,s),u(k.$$.fragment,s),u(d.$$.fragment,s),u(Q.$$.fragment,s),u(B.$$.fragment,s),u(C.$$.fragment,s),u(Z.$$.fragment,s),u(S.$$.fragment,s),u(H.$$.fragment,s),u(D.$$.fragment,s),u(R.$$.fragment,s),u(x.$$.fragment,s),u(P.$$.fragment,s),u(O.$$.fragment,s),u(g.$$.fragment,s),u(ls.$$.fragment,s),u(es.$$.fragment,s),u(ps.$$.fragment,s),u(is.$$.fragment,s),u(rs.$$.fragment,s),u(ys.$$.fragment,s),u(os.$$.fragment,s),u(js.$$.fragment,s),u(Us.$$.fragment,s),u(Ts.$$.fragment,s),u(ws.$$.fragment,s),u(ds.$$.fragment,s),u(xs.$$.fragment,s),u(gs.$$.fragment,s),u(fs.$$.fragment,s),u(qs.$$.fragment,s),u(ks.$$.fragment,s),u(Qs.$$.fragment,s),u(Bs.$$.fragment,s),u(Vs.$$.fragment,s),u(Es.$$.fragment,s),u(Zs.$$.fragment,s),u(Gs.$$.fragment,s),u(I.$$.fragment,s),u(Ns.$$.fragment,s),u(Hs.$$.fragment,s),u(Xs.$$.fragment,s),u(f.$$.fragment,s),dn=!0)},o(s){y(b.$$.fragment,s),y(q.$$.fragment,s),y(k.$$.fragment,s),y(d.$$.fragment,s),y(Q.$$.fragment,s),y(B.$$.fragment,s),y(C.$$.fragment,s),y(Z.$$.fragment,s),y(S.$$.fragment,s),y(H.$$.fragment,s),y(D.$$.fragment,s),y(R.$$.fragment,s),y(x.$$.fragment,s),y(P.$$.fragment,s),y(O.$$.fragment,s),y(g.$$.fragment,s),y(ls.$$.fragment,s),y(es.$$.fragment,s),y(ps.$$.fragment,s),y(is.$$.fragment,s),y(rs.$$.fragment,s),y(ys.$$.fragment,s),y(os.$$.fragment,s),y(js.$$.fragment,s),y(Us.$$.fragment,s),y(Ts.$$.fragment,s),y(ws.$$.fragment,s),y(ds.$$.fragment,s),y(xs.$$.fragment,s),y(gs.$$.fragment,s),y(fs.$$.fragment,s),y(qs.$$.fragment,s),y(ks.$$.fragment,s),y(Qs.$$.fragment,s),y(Bs.$$.fragment,s),y(Vs.$$.fragment,s),y(Es.$$.fragment,s),y(Zs.$$.fragment,s),y(Gs.$$.fragment,s),y(I.$$.fragment,s),y(Ns.$$.fragment,s),y(Hs.$$.fragment,s),y(Xs.$$.fragment,s),y(f.$$.fragment,s),dn=!1},d(s){s&&(n(T),n(J),n(h),n(Ps),n(Ls),n($),n(Fs),n(Ks),n(Os),n(sl),n(A),n(ll),n(nl),n(v),n(al),n(el),n(V),n(tl),n(E),n(pl),n(z),n(Ml),n(il),n(G),n(rl),n(ul),n(N),n(yl),n(_),n(ol),n(cl),n(X),n(jl),n(Jl),n(W),n(Ul),n(ml),n(Y),n(Tl),n(hl),n(wl),n(L),n(dl),n(F),n(Cl),n(K),n(xl),n(gl),n(ss),n(Il),n(fl),n(bl),n(ns),n(ql),n(as),n($l),n(kl),n(ts),n(Ql),n(Al),n(Ms),n(Bl),n(vl),n(Vl),n(us),n(El),n(zl),n(Zl),n(cs),n(Gl),n(Sl),n(Js),n(Nl),n(_l),n(ms),n(Hl),n(Xl),n(hs),n(Dl),n(Wl),n(Rl),n(Cs),n(Yl),n(Pl),n(Ll),n(Is),n(Fl),n(Kl),n(bs),n(Ol),n(sn),n($s),n(ln),n(nn),n(an),n(As),n(en),n(tn),n(vs),n(pn),n(Mn),n(rn),n(zs),n(un),n(yn),n(on),n(cn),n(Ss),n(jn),n(Jn),n(_s),n(Un),n(mn),n(Tn),n(hn),n(Ds),n(wn),n(Ys)),n(p),o(b,s),o(q,s),o(k,s),o(d,s),o(Q,s),o(B,s),o(C,s),o(Z,s),o(S,s),o(H,s),o(D,s),o(R,s),o(x,s),o(P,s),o(O,s),o(g,s),o(ls,s),o(es,s),o(ps,s),o(is,s),o(rs,s),o(ys,s),o(os,s),o(js,s),o(Us,s),o(Ts,s),o(ws,s),o(ds,s),o(xs,s),o(gs,s),o(fs,s),o(qs,s),o(ks,s),o(Qs,s),o(Bs,s),o(Vs,s),o(Es,s),o(Zs,s),o(Gs,s),o(I,s),o(Ns,s),o(Hs,s),o(Xs,s),o(f,s)}}}const ba='{"title":"Tokénisation <i> Byte-Pair Encoding </i>","local":"tokénisation-i-byte-pair-encoding-i","sections":[{"title":"Algorithme d’entraînement","local":"algorithme-dentraînement","sections":[],"depth":2},{"title":"Algorithme de tokenisation","local":"algorithme-de-tokenisation","sections":[],"depth":2},{"title":"Implémentation du BPE","local":"implémentation-du-bpe","sections":[],"depth":2}],"depth":1}';function qa(w){return ca(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ea extends ja{constructor(p){super(),Ja(this,p,qa,fa,oa,{})}}export{Ea as component};
