import{s as za,o as _a,n as Ua}from"../chunks/scheduler.37c15a92.js";import{S as Ga,i as Ca,g as o,s as n,r as c,A as Za,h as r,f as t,c as s,j as wa,u as p,x as d,k as ga,y as Ra,a as l,v as m,d as u,t as M,w as f}from"../chunks/index.2bf4358c.js";import{T as ka}from"../chunks/Tip.363c041f.js";import{Y as qa}from"../chunks/Youtube.1e50a667.js";import{C as y}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Ea}from"../chunks/CourseFloatingBanner.5dff5e20.js";import{F as Wa}from"../chunks/FrameworkSwitchCourse.8d4d4ab6.js";import{H as Oe}from"../chunks/Heading.8ada512a.js";function Ha(v){let i,T='💡 Si quieres subir automáticamente tu modelo al Hub durante el entrenamiento, incluye <code>push_to_hub=True</code> en <code>TrainingArguments</code>. Aprenderemos más sobre esto en el <a href="/course/chapter4/3">Capítulo 4</a>.';return{c(){i=o("p"),i.innerHTML=T},l(b){i=r(b,"P",{"data-svelte-h":!0}),d(i)!=="svelte-dbd6l7"&&(i.innerHTML=T)},m(b,$){l(b,i,$)},p:Ua,d(b){b&&t(i)}}}function Ia(v){let i,T="✏️ <strong>¡Inténtalo!</strong> Ajusta un modelo sobre el dataset GLUE SST-2 utilizando el procesamiento de datos que has implementado en la sección 2.";return{c(){i=o("p"),i.innerHTML=T},l(b){i=r(b,"P",{"data-svelte-h":!0}),d(i)!=="svelte-1r59oo1"&&(i.innerHTML=T)},m(b,$){l(b,i,$)},p:Ua,d(b){b&&t(i)}}}function Fa(v){let i,T,b,$,j,ce,w,pe,g,me,k,ue,U,ea='🤗 Transformers incluye una clase <code>Trainer</code> para ayudarte a ajustar cualquiera de los modelos preentrenados proporcionados en tu dataset. Una vez que hayas hecho todo el trabajo de preprocesamiento de datos de la última sección, sólo te quedan unos pocos pasos para definir el <code>Trainer</code>. La parte más difícil será preparar el entorno para ejecutar <code>Trainer.train()</code>, ya que se ejecutará muy lentamente en una CPU. Si no tienes una GPU preparada, puedes acceder a GPUs o TPUs gratuitas en <a href="https://colab.research.google.com/" rel="nofollow">Google Colab</a>.',Me,z,aa="Los siguientes ejemplos de código suponen que ya has ejecutado los ejemplos de la sección anterior. Aquí tienes un breve resumen de lo que necesitas:",fe,_,be,G,ye,C,ta="El primer paso antes de que podamos definir nuestro <code>Trainer</code> es definir una clase <code>TrainingArguments</code> que contendrá todos los hiperparámetros que el <code>Trainer</code> utilizará para el entrenamiento y la evaluación del modelo. El único argumento que tienes que proporcionar es el directorio donde se guardarán tanto el modelo entrenado como los puntos de control (checkpoints). Para los demás parámetros puedes dejar los valores por defecto, deberían funcionar bastante bien para un ajuste básico.",Te,Z,$e,h,je,R,la='El segundo paso es definir nuestro modelo. Como en el <a href="/course/chapter2">capítulo anterior</a>, utilizaremos la clase <code>AutoModelForSequenceClassification</code>, con dos etiquetas:',he,q,Je,E,na='Observarás que, a diferencia del <a href="/course/chapter2">Capítulo 2</a>, aparece una advertencia después de instanciar este modelo preentrenado. Esto se debe a que BERT no ha sido preentrenado para la clasificación de pares de frases, por lo que la cabeza del modelo preentrenado se ha eliminado y en su lugar se ha añadido una nueva cabeza adecuada para la clasificación de secuencias. Las advertencias indican que algunos pesos no se han utilizado (los correspondientes a la cabeza de preentrenamiento eliminada) y que otros se han inicializado aleatoriamente (los correspondientes a la nueva cabeza). La advertencia concluye animándote a entrenar el modelo, que es exactamente lo que vamos a hacer ahora.',ve,W,sa="Una vez que tenemos nuestro modelo, podemos definir un <code>Trainer</code> pasándole todos los objetos construidos hasta ahora: el <code>model</code>, los <code>training_args</code>, los datasets de entrenamiento y validación, nuestro <code>data_collator</code>, y nuestro <code>tokenizer</code>:",we,H,ge,I,oa="Ten en cuenta que cuando pasas el <code>tokenizer</code> como hicimos aquí, el <code>data_collator</code> por defecto utilizado por el <code>Trainer</code> será un <code>DataCollatorWithPadding</code> como definimos anteriormente, por lo que puedes omitir la línea <code>data_collator=data_collator</code>. De todas formas, era importante mostrarte esta parte del proceso en la sección 2.",ke,F,ra="Para ajustar el modelo en nuestro dataset, sólo tenemos que llamar al método <code>train()</code> de nuestro <code>Trainer</code>:",Ue,X,ze,x,ia="Esto iniciará el ajuste (que debería tardar un par de minutos en una GPU) e informará de la training loss cada 500 pasos. Sin embargo, no te dirá lo bien (o mal) que está rindiendo tu modelo. Esto se debe a que:",_e,V,da="<li>No le hemos dicho al <code>Trainer</code> que evalúe el modelo durante el entrenamiento especificando un valor para <code>evaluation_strategy</code>: <code>steps</code> (evaluar cada <code>eval_steps</code>) o <code>epoch</code> (evaluar al final de cada época).</li> <li>No hemos proporcionado al <code>Trainer</code> una función <code>compute_metrics()</code> para calcular una métrica durante dicha evaluación (de lo contrario, la evaluación sólo habría impreso la pérdida, que no es un número muy intuitivo).</li>",Ge,B,Ce,Y,ca="Veamos cómo podemos construir una buena función <code>compute_metrics()</code> para utilizarla la próxima vez que entrenemos. La función debe tomar un objeto <code>EvalPrediction</code> (que es una tupla nombrada con un campo <code>predictions</code> y un campo <code>label_ids</code>) y devolverá un diccionario que asigna cadenas a flotantes (las cadenas son los nombres de las métricas devueltas, y los flotantes sus valores). Para obtener algunas predicciones de nuestro modelo, podemos utilizar el comando <code>Trainer.predict()</code>:",Ze,A,Re,L,qe,N,pa="La salida del método <code>predict()</code> es otra tupla con tres campos: <code>predictions</code>, <code>label_ids</code>, y <code>metrics</code>. El campo <code>metrics</code> sólo contendrá la pérdida en el dataset proporcionado, así como algunas métricas de tiempo (cuánto se tardó en predecir, en total y de media). Una vez que completemos nuestra función <code>compute_metrics()</code> y la pasemos al <code>Trainer</code>, ese campo también contendrá las métricas devueltas por <code>compute_metrics()</code>.",Ee,Q,ma='Como puedes ver, <code>predictions</code> es una matriz bidimensional con forma 408 x 2 (408 es el número de elementos del dataset que hemos utilizado). Esos son los logits de cada elemento del dataset que proporcionamos a <code>predict()</code> (como viste en el <a href="/curso/cap%C3%ADtulo2">capítulo anterior</a>, todos los modelos Transformer devuelven logits). Para convertirlos en predicciones que podamos comparar con nuestras etiquetas, necesitamos tomar el índice con el valor máximo en el segundo eje:',We,P,He,S,ua='Ahora podemos comparar esas predicciones <code>preds</code> con las etiquetas. Para construir nuestra función <code>compute_metric()</code>, nos basaremos en las métricas de la librería 🤗 <a href="https://github.com/huggingface/evaluate/" rel="nofollow">Evaluate</a>. Podemos cargar las métricas asociadas al dataset MRPC tan fácilmente como cargamos el dataset, esta vez con la función <code>evaluate.load()</code>. El objeto devuelto tiene un método <code>compute()</code> que podemos utilizar para calcular de la métrica:',Ie,D,Fe,K,Xe,O,Ma='Los resultados exactos que obtengas pueden variar, ya que la inicialización aleatoria de la cabeza del modelo podría cambiar las métricas obtenidas. Aquí, podemos ver que nuestro modelo tiene una precisión del 85,78% en el conjunto de validación y una puntuación F1 de 89,97. Estas son las dos métricas utilizadas para evaluar los resultados en el dataset MRPC para la prueba GLUE. La tabla del <a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">paper de BERT</a> recoge una puntuación F1 de 88,9 para el modelo base. Se trataba del modelo “uncased” (el texto se reescribe en minúsculas antes de la tokenización), mientras que nosotros hemos utilizado el modelo “cased” (el texto se tokeniza sin reescribir), lo que explica el mejor resultado.',xe,ee,fa="Juntándolo todo obtenemos nuestra función <code>compute_metrics()</code>:",Ve,ae,Be,te,ba="Y para ver cómo se utiliza para informar de las métricas al final de cada época, así es como definimos un nuevo <code>Trainer</code> con nuestra función <code>compute_metrics()</code>:",Ye,le,Ae,ne,ya="Ten en cuenta que hemos creado un nuevo <code>TrainingArguments</code> con su <code>evaluation_strategy</code> configurado como <code>&quot;epoch&quot;</code> y un nuevo modelo. De lo contrario sólo estaríamos continuando el entrenamiento del modelo que ya habíamos entrenado. Para lanzar una nueva ejecución de entrenamiento, ejecutamos:",Le,se,Ne,oe,Ta="Esta vez, nos informará de la pérdida de validación y las métricas al final de cada época, además de la pérdida de entrenamiento. De nuevo, la puntuación exacta de precisión/F1 que alcances puede ser un poco diferente de la que encontramos nosotros, debido a la inicialización aleatoria del modelo, pero debería estar en el mismo rango.",Qe,re,$a="El <code>Trainer</code> funciona en múltiples GPUs o TPUs y proporciona muchas opciones, como el entrenamiento de precisión mixta (usa <code>fp16 = True</code> en tus argumentos de entrenamiento). Repasaremos todo lo que ofrece en el capítulo 10.",Pe,ie,ja='Con esto concluye la introducción al ajuste utilizando la API de <code>Trainer</code>. En el <a href="/course/chapter7">Capítulo 7</a> se dará un ejemplo de cómo hacer esto para las tareas más comunes de PLN, pero ahora veamos cómo hacer lo mismo en PyTorch puro.',Se,J,De,de,Ke;return j=new Wa({props:{fw:v[0]}}),w=new Oe({props:{title:"Ajuste de un modelo con la API Trainer",local:"ajuste-de-un-modelo-con-la-api-trainer",headingTag:"h1"}}),g=new Ea({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"}]}}),k=new qa({props:{id:"nvBXf7s7vTI"}}),_=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),G=new Oe({props:{title:"Entrenamiento",local:"entrenamiento",headingTag:"h3"}}),Z=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>)`,wrap:!1}}),h=new ka({props:{$$slots:{default:[Ha]},$$scope:{ctx:v}}}),q=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),H=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),X=new y({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),B=new Oe({props:{title:"Evaluación",local:"evaluación",headingTag:"h3"}}),A=new y({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjB0cmFpbmVyLnByZWRpY3QodG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCklMEFwcmludChwcmVkaWN0aW9ucy5wcmVkaWN0aW9ucy5zaGFwZSUyQyUyMHByZWRpY3Rpb25zLmxhYmVsX2lkcy5zaGFwZSk=",highlighted:`predictions = trainer.predict(tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>])
<span class="hljs-built_in">print</span>(predictions.predictions.shape, predictions.label_ids.shape)`,wrap:!1}}),L=new y({props:{code:"KDQwOCUyQyUyMDIpJTIwKDQwOCUyQyk=",highlighted:'(<span class="hljs-number">408</span>, <span class="hljs-number">2</span>) (<span class="hljs-number">408</span>,)',wrap:!1}}),P=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcHJlZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZGljdGlvbnMucHJlZGljdGlvbnMlMkMlMjBheGlzJTNELTEp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

preds = np.argmax(predictions.predictions, axis=-<span class="hljs-number">1</span>)`,wrap:!1}}),D=new y({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZHMlMkMlMjByZWZlcmVuY2VzJTNEcHJlZGljdGlvbnMubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
metric.compute(predictions=preds, references=predictions.label_ids)`,wrap:!1}}),K=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODU3ODQzMTM3MjU0OTAxOSUyQyUyMCdmMSclM0ElMjAwLjg5OTY1Mzk3OTIzODc1NDIlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8578431372549019</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8996539792387542</span>}',wrap:!1}}),ae=new y({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZHMpJTNBJTBBJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwZXZhbHVhdGUubG9hZCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_preds</span>):
    metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
    logits, labels = eval_preds
    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),le=new y({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMiUyQyUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>, evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),se=new y({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),J=new ka({props:{$$slots:{default:[Ia]},$$scope:{ctx:v}}}),{c(){i=o("meta"),T=n(),b=o("p"),$=n(),c(j.$$.fragment),ce=n(),c(w.$$.fragment),pe=n(),c(g.$$.fragment),me=n(),c(k.$$.fragment),ue=n(),U=o("p"),U.innerHTML=ea,Me=n(),z=o("p"),z.textContent=aa,fe=n(),c(_.$$.fragment),be=n(),c(G.$$.fragment),ye=n(),C=o("p"),C.innerHTML=ta,Te=n(),c(Z.$$.fragment),$e=n(),c(h.$$.fragment),je=n(),R=o("p"),R.innerHTML=la,he=n(),c(q.$$.fragment),Je=n(),E=o("p"),E.innerHTML=na,ve=n(),W=o("p"),W.innerHTML=sa,we=n(),c(H.$$.fragment),ge=n(),I=o("p"),I.innerHTML=oa,ke=n(),F=o("p"),F.innerHTML=ra,Ue=n(),c(X.$$.fragment),ze=n(),x=o("p"),x.textContent=ia,_e=n(),V=o("ol"),V.innerHTML=da,Ge=n(),c(B.$$.fragment),Ce=n(),Y=o("p"),Y.innerHTML=ca,Ze=n(),c(A.$$.fragment),Re=n(),c(L.$$.fragment),qe=n(),N=o("p"),N.innerHTML=pa,Ee=n(),Q=o("p"),Q.innerHTML=ma,We=n(),c(P.$$.fragment),He=n(),S=o("p"),S.innerHTML=ua,Ie=n(),c(D.$$.fragment),Fe=n(),c(K.$$.fragment),Xe=n(),O=o("p"),O.innerHTML=Ma,xe=n(),ee=o("p"),ee.innerHTML=fa,Ve=n(),c(ae.$$.fragment),Be=n(),te=o("p"),te.innerHTML=ba,Ye=n(),c(le.$$.fragment),Ae=n(),ne=o("p"),ne.innerHTML=ya,Le=n(),c(se.$$.fragment),Ne=n(),oe=o("p"),oe.textContent=Ta,Qe=n(),re=o("p"),re.innerHTML=$a,Pe=n(),ie=o("p"),ie.innerHTML=ja,Se=n(),c(J.$$.fragment),De=n(),de=o("p"),this.h()},l(e){const a=Za("svelte-u9bgzb",document.head);i=r(a,"META",{name:!0,content:!0}),a.forEach(t),T=s(e),b=r(e,"P",{}),wa(b).forEach(t),$=s(e),p(j.$$.fragment,e),ce=s(e),p(w.$$.fragment,e),pe=s(e),p(g.$$.fragment,e),me=s(e),p(k.$$.fragment,e),ue=s(e),U=r(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1ioswij"&&(U.innerHTML=ea),Me=s(e),z=r(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1n68yzx"&&(z.textContent=aa),fe=s(e),p(_.$$.fragment,e),be=s(e),p(G.$$.fragment,e),ye=s(e),C=r(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-spbpzt"&&(C.innerHTML=ta),Te=s(e),p(Z.$$.fragment,e),$e=s(e),p(h.$$.fragment,e),je=s(e),R=r(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-s800sj"&&(R.innerHTML=la),he=s(e),p(q.$$.fragment,e),Je=s(e),E=r(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-8gn8o6"&&(E.innerHTML=na),ve=s(e),W=r(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-h6rgta"&&(W.innerHTML=sa),we=s(e),p(H.$$.fragment,e),ge=s(e),I=r(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-126a12e"&&(I.innerHTML=oa),ke=s(e),F=r(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-w03l4u"&&(F.innerHTML=ra),Ue=s(e),p(X.$$.fragment,e),ze=s(e),x=r(e,"P",{"data-svelte-h":!0}),d(x)!=="svelte-eh57f6"&&(x.textContent=ia),_e=s(e),V=r(e,"OL",{"data-svelte-h":!0}),d(V)!=="svelte-1fdlgix"&&(V.innerHTML=da),Ge=s(e),p(B.$$.fragment,e),Ce=s(e),Y=r(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-5pdhb3"&&(Y.innerHTML=ca),Ze=s(e),p(A.$$.fragment,e),Re=s(e),p(L.$$.fragment,e),qe=s(e),N=r(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-k3mln9"&&(N.innerHTML=pa),Ee=s(e),Q=r(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-11xlp0r"&&(Q.innerHTML=ma),We=s(e),p(P.$$.fragment,e),He=s(e),S=r(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-18sbboe"&&(S.innerHTML=ua),Ie=s(e),p(D.$$.fragment,e),Fe=s(e),p(K.$$.fragment,e),Xe=s(e),O=r(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-muir2z"&&(O.innerHTML=Ma),xe=s(e),ee=r(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-c6xa55"&&(ee.innerHTML=fa),Ve=s(e),p(ae.$$.fragment,e),Be=s(e),te=r(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-15dzqc"&&(te.innerHTML=ba),Ye=s(e),p(le.$$.fragment,e),Ae=s(e),ne=r(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-q9rqtn"&&(ne.innerHTML=ya),Le=s(e),p(se.$$.fragment,e),Ne=s(e),oe=r(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-2wt3k3"&&(oe.textContent=Ta),Qe=s(e),re=r(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1c09h90"&&(re.innerHTML=$a),Pe=s(e),ie=r(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-9zkwyk"&&(ie.innerHTML=ja),Se=s(e),p(J.$$.fragment,e),De=s(e),de=r(e,"P",{}),wa(de).forEach(t),this.h()},h(){ga(i,"name","hf:doc:metadata"),ga(i,"content",Xa)},m(e,a){Ra(document.head,i),l(e,T,a),l(e,b,a),l(e,$,a),m(j,e,a),l(e,ce,a),m(w,e,a),l(e,pe,a),m(g,e,a),l(e,me,a),m(k,e,a),l(e,ue,a),l(e,U,a),l(e,Me,a),l(e,z,a),l(e,fe,a),m(_,e,a),l(e,be,a),m(G,e,a),l(e,ye,a),l(e,C,a),l(e,Te,a),m(Z,e,a),l(e,$e,a),m(h,e,a),l(e,je,a),l(e,R,a),l(e,he,a),m(q,e,a),l(e,Je,a),l(e,E,a),l(e,ve,a),l(e,W,a),l(e,we,a),m(H,e,a),l(e,ge,a),l(e,I,a),l(e,ke,a),l(e,F,a),l(e,Ue,a),m(X,e,a),l(e,ze,a),l(e,x,a),l(e,_e,a),l(e,V,a),l(e,Ge,a),m(B,e,a),l(e,Ce,a),l(e,Y,a),l(e,Ze,a),m(A,e,a),l(e,Re,a),m(L,e,a),l(e,qe,a),l(e,N,a),l(e,Ee,a),l(e,Q,a),l(e,We,a),m(P,e,a),l(e,He,a),l(e,S,a),l(e,Ie,a),m(D,e,a),l(e,Fe,a),m(K,e,a),l(e,Xe,a),l(e,O,a),l(e,xe,a),l(e,ee,a),l(e,Ve,a),m(ae,e,a),l(e,Be,a),l(e,te,a),l(e,Ye,a),m(le,e,a),l(e,Ae,a),l(e,ne,a),l(e,Le,a),m(se,e,a),l(e,Ne,a),l(e,oe,a),l(e,Qe,a),l(e,re,a),l(e,Pe,a),l(e,ie,a),l(e,Se,a),m(J,e,a),l(e,De,a),l(e,de,a),Ke=!0},p(e,[a]){const ha={};a&1&&(ha.fw=e[0]),j.$set(ha);const Ja={};a&2&&(Ja.$$scope={dirty:a,ctx:e}),h.$set(Ja);const va={};a&2&&(va.$$scope={dirty:a,ctx:e}),J.$set(va)},i(e){Ke||(u(j.$$.fragment,e),u(w.$$.fragment,e),u(g.$$.fragment,e),u(k.$$.fragment,e),u(_.$$.fragment,e),u(G.$$.fragment,e),u(Z.$$.fragment,e),u(h.$$.fragment,e),u(q.$$.fragment,e),u(H.$$.fragment,e),u(X.$$.fragment,e),u(B.$$.fragment,e),u(A.$$.fragment,e),u(L.$$.fragment,e),u(P.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(ae.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(J.$$.fragment,e),Ke=!0)},o(e){M(j.$$.fragment,e),M(w.$$.fragment,e),M(g.$$.fragment,e),M(k.$$.fragment,e),M(_.$$.fragment,e),M(G.$$.fragment,e),M(Z.$$.fragment,e),M(h.$$.fragment,e),M(q.$$.fragment,e),M(H.$$.fragment,e),M(X.$$.fragment,e),M(B.$$.fragment,e),M(A.$$.fragment,e),M(L.$$.fragment,e),M(P.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),M(ae.$$.fragment,e),M(le.$$.fragment,e),M(se.$$.fragment,e),M(J.$$.fragment,e),Ke=!1},d(e){e&&(t(T),t(b),t($),t(ce),t(pe),t(me),t(ue),t(U),t(Me),t(z),t(fe),t(be),t(ye),t(C),t(Te),t($e),t(je),t(R),t(he),t(Je),t(E),t(ve),t(W),t(we),t(ge),t(I),t(ke),t(F),t(Ue),t(ze),t(x),t(_e),t(V),t(Ge),t(Ce),t(Y),t(Ze),t(Re),t(qe),t(N),t(Ee),t(Q),t(We),t(He),t(S),t(Ie),t(Fe),t(Xe),t(O),t(xe),t(ee),t(Ve),t(Be),t(te),t(Ye),t(Ae),t(ne),t(Le),t(Ne),t(oe),t(Qe),t(re),t(Pe),t(ie),t(Se),t(De),t(de)),t(i),f(j,e),f(w,e),f(g,e),f(k,e),f(_,e),f(G,e),f(Z,e),f(h,e),f(q,e),f(H,e),f(X,e),f(B,e),f(A,e),f(L,e),f(P,e),f(D,e),f(K,e),f(ae,e),f(le,e),f(se,e),f(J,e)}}}const Xa='{"title":"Ajuste de un modelo con la API Trainer","local":"ajuste-de-un-modelo-con-la-api-trainer","sections":[{"title":"Entrenamiento","local":"entrenamiento","sections":[],"depth":3},{"title":"Evaluación","local":"evaluación","sections":[],"depth":3}],"depth":1}';function xa(v,i,T){let b="pt";return _a(()=>{const $=new URLSearchParams(window.location.search);T(0,b=$.get("fw")||"pt")}),[b]}class Sa extends Ga{constructor(i){super(),Ca(this,i,xa,Fa,za,{})}}export{Sa as component};
