import{s as hs,o as js,n as Js}from"../chunks/scheduler.1d51f4c0.js";import{S as Us,i as Ts,g as m,s as n,r as i,A as fs,h as o,f as s,c as a,j as us,u as r,x as u,k as ys,y as gs,a as t,v as p,d,t as M,w as c,m as Cs,n as Zs}from"../chunks/index.85d39492.js";import{T as ws}from"../chunks/Tip.9d1f4d4d.js";import{Y as bs}from"../chunks/Youtube.3728976b.js";import{C as y}from"../chunks/CodeBlock.55acaf9d.js";import{C as Bs}from"../chunks/CourseFloatingBanner.d94d31a4.js";import{H as Ie}from"../chunks/Heading.537027d1.js";function ks(Ze){let w,b="✏️ <strong>Probier es selbt!</strong> Ändere die vorherige Trainingsschleife, um dein Modell auf dem SST-2-Datensatz fein zu tunen.";return{c(){w=m("p"),w.innerHTML=b},l(h){w=o(h,"P",{"data-svelte-h":!0}),u(w)!=="svelte-10uj33w"&&(w.innerHTML=b)},m(h,Be){t(h,w,Be)},p:Js,d(h){h&&s(w)}}}function Is(Ze){let w;return{c(){w=Cs('⚠️ Um von dem Geschwindigkeitsvorteil der Cloud TPUs zu profitieren, empfehlen wir, deine Samples mit den Argumenten `padding="max_length"` und `max_length` des Tokenizers auf eine feste Länge aufzufüllen.')},l(b){w=Zs(b,'⚠️ Um von dem Geschwindigkeitsvorteil der Cloud TPUs zu profitieren, empfehlen wir, deine Samples mit den Argumenten `padding="max_length"` und `max_length` des Tokenizers auf eine feste Länge aufzufüllen.')},m(b,h){t(b,w,h)},d(b){b&&s(w)}}}function Gs(Ze){let w,b,h,Be,U,Ge,T,$e,f,ve,g,_l="In diesem Abschnitt befassen wir uns damit, wie wir die gleichen Ergebnisse wie im letzten Abschnitt erzielen können, ohne die Klasse <code>Trainer</code> zu verwenden. Auch hier gehen wir davon aus, dass du die Datenverarbeitung in Abschnitt 2 durchgeführt hast. Hier ist eine kurze Zusammenfassung mit allem, was du brauchst:",We,C,Xe,Z,ze,B,Yl="Bevor wir unsere Trainingsschleife schreiben, müssen wir noch einige Objekte definieren. Zunächst müssen wir die Datalader definieren, mit denen wir über die Batches iterieren werden. Doch bevor wir diese Dataloader definieren können, müssen wir unsere <code>tokenized_datasets</code> nachbearbeiten, um einige Dinge zu erledigen, die der <code>Trainer</code> automatisch für uns erledigt hat. Konkret heißt das, dass wir:",Re,k,Vl="<li>Die Spalten entfernen, die Werte enthalten, die das Modell nicht erwartet (wie die Spalten <code>sentence1</code> und <code>sentence2</code>).</li> <li>Die Spalte <code>label</code> in <code>labels</code> umbenennen (weil das Modell erwartet, dass das Argument <code>labels</code> heißt).</li> <li>Das Format der Datensätze anpassen, so dass sie PyTorch-Tensoren statt Listen zurückgeben.</li>",Ae,I,Nl="Das <code>tokenized_datasets</code> hat eine Methode für jeden dieser Schritte:",_e,G,Ye,$,El="Anschließend können wir überprüfen, ob der Output nur Spalten enthält, die unser Modell akzeptiert:",Ve,v,Ne,W,Fl="Jetzt können wir ganz einfach unsere Dataloader definieren:",Ee,X,Fe,z,Ql="Um sicher zu gehen, überprüfen wir ein Batch auf Fehler in der Datenverarbeitung:",Qe,R,xe,A,He,_,xl="Beachte, dass die Dimensionen der Tensoren wahrscheinlich etwas anders aussehen werden, da wir für den Trainingsdatenlader <code>shuffle=True</code> eingestellt haben und innerhalb des Batches auf die maximale Länge auffüllen.",Se,Y,Hl="Da wir nun mit der Datenvorverarbeitung fertig sind (ein zufriedenstellendes aber schwer erreichbares Ziel für jeden ML-Experten), können wir uns nun dem Modell zuwenden. Wir instanziieren es genauso wie im vorherigen Abschnitt:",De,V,Ke,N,Sl="Als weitere Sicherheitsmaßnahme übergeben wir unseren Batch an das Modell, um sicherzustellen, dass beim Training alles glatt läuft:",Le,E,qe,F,Pe,Q,Dl="Alle 🤗 Transformer Modelle geben den Verlust zurück, wenn <code>labels</code> angegeben werden, und wir erhalten zusätzlich die Logits (zwei für jede Eingabe in unserem Batch, also einen Tensor der Größe 8 x 2).",Oe,x,Kl='Wir sind fast so weit, unsere Trainingsschleife zu schreiben! Es fehlen nur noch zwei Dinge: ein Optimierer und ein Scheduler für die Lernrate. Da wir versuchen, das zu wiederholen, was der <code>Trainer</code> automatisch gemacht hat, werden wir die gleichen Standardwerte verwenden. Der Optimierer, den der <code>Trainer</code> verwendet, heißt “AdamW” und ist größtenteils derselbe wie Adam, abgesehen von einer Abwandlung für die “Weight Decay Regularization” (siehe [“Decoupled Weight Decay Regularization”] (<a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>) von Ilya Loshchilov und Frank Hutter):',el,H,ll,S,Ll="Der standardmäßig verwendete Scheduler für die Lernrate ist ein linearer Abstieg vom Maximalwert (5e-5) auf 0. Um ihn richtig zu definieren, müssen wir die Anzahl der Trainingsschritte kennen, d.h. die Anzahl der Epochen, die die Trainingsschleife durchlaufen soll, multipliziert mit der Anzahl der Trainingsbatches (der Länge unseres Trainingsdatenordners). Der <code>Trainer</code> verwendet standardmäßig drei Epochen, woran wir uns hier orientieren werden:",sl,D,tl,K,nl,L,al,q,ql="Ein letzter Hinweis: Wir wollen die GPU zum Training nutzen, wenn wir Zugang zu einer haben (auf einer CPU kann das Training mehrere Stunden statt ein paar Minuten dauern). Dazu definieren wir <code>device</code> als Gerät auf dem wir unser Modell und unsere Batches speichern:",il,P,rl,O,pl,ee,Pl="Wir sind jetzt bereit für das Training! Um ein Gefühl dafür zu bekommen, wann das Training abgeschlossen sein wird, fügen wir mit der Bibliothek <code>tqdm</code> einen Fortschrittsbalken über die Anzahl der Trainingsschritte ein:",dl,le,Ml,se,Ol="Der Kern der Trainingsschleife sieht ähnlich aus wie in der Einleitung. Da wir keine Berichte angefordert haben, gibt die Trainingsschleife nichts über die Performance des Modells zurück. Dafür müssen wir eine Evaluationsschleife einfügen.",cl,te,ml,ne,es="Wie schon zuvor verwenden wir eine Metrik, die von der 🤗 Evaluate-Bibliothek bereitgestellt wird. Wir haben bereits die Methode <code>metric.compute()</code> gesehen, aber Metriken können auch Batches für uns akkumulieren, wenn wir die Vorhersageschleife mit der Methode <code>add_batch()</code> durchlaufen. Sobald wir alle Batches gesammelt haben, können wir das Endergebnis mit der Methode <code>metric.compute()</code> ermitteln. So implementierst du all das in eine Evaluationsschleife:",ol,ae,ul,ie,yl,re,ls="Auch hier werden deine Ergebnisse wegen der Zufälligkeit bei der Initialisierung des Modellkopfes und der Datenverteilung etwas anders ausfallen, aber sie sollten in etwa gleich sein.",wl,j,bl,pe,hl,de,jl,Me,ss='Die Trainingsschleife, die wir zuvor definiert haben, funktioniert gut auf einer einzelnen CPU oder GPU. Aber mit der Bibliothek <a href="https://github.com/huggingface/accelerate" rel="nofollow">🤗 Accelerate</a> können wir mit wenigen Anpassungen verteiltes Training auf mehreren GPUs oder TPUs implementieren. Beginnend mit der Erstellung der Trainings- und Validierungsdaten, sieht unsere manuelle Trainingsschleife nun folgendermaßen aus:',Jl,ce,Ul,me,ts="Und hier sind die Änderungen:",Tl,oe,fl,ue,ns="Die erste Zeile, die hinzugefügt werden muss, ist die Import-Zeile. Die zweite Zeile instanziiert ein <code>Accelerator</code>-Objekt, das die Hardware analysiert und die richtige verteilte Umgebung initialisiert. Accelerate kümmert sich um die Anordnung der Geräte, du kannst also die Zeilen entfernen, die das Modell auf dem Gerät platzieren (oder, wenn du das möchtest, sie so ändern, dass sie <code>accelerator.device</code> anstelle von <code>device</code> verwenden).",gl,ye,as="Der Hauptteil der Arbeit wird dann in der Zeile erledigt, die die Dataloader, das Modell und den Optimierer an <code>accelerator.prepare()</code> sendet. Dadurch werden diese Objekte in den richtigen Container verpackt, damit das verteilte Training wie vorgesehen funktioniert. Die verbleibenden Änderungen sind das Entfernen der Zeile, die das Batch auf dem Gerät mit <code>device</code> ablegt (wenn du das beibehalten willst, kannst du es einfach in <code>accelerator.device</code> ändern) und das Ersetzen von <code>loss.backward()</code> durch <code>accelerator.backward(loss)</code>.",Cl,J,Zl,we,is="Wenn du damit experimentieren möchtest, siehst du hier, wie die komplette Trainingsschleife mit 🤗 Accelerate aussieht:",Bl,be,kl,he,rs="Wenn dies in das Script <code>train.py</code> eingefügt wird, kann das Script auf jeder Art von verteilter Hardware ausgeführt werden. Um es auf deiner verteilten Hardware auszuprobieren, führe den folgenden Befehl aus:",Il,je,Gl,Je,ps="Du wirst dann aufgefordert werden, einige Fragen zu beantworten und die Antworten in eine Konfigurationsdatei zu schreiben, die von diesem Befehl verwendet wird:",$l,Ue,vl,Te,ds="Damit wird das verteilte Training gestartet.",Wl,fe,Ms="Wenn du das in einem Notebook ausprobieren möchtest (z. B. um es mit TPUs auf Colab zu testen), füge den Code einfach in eine <code>training_function()</code> ein und führe eine letzte Zelle mit aus:",Xl,ge,zl,Ce,cs='Weitere Beispiele findest du in dem <a href="https://github.com/huggingface/accelerate/tree/main/examples" rel="nofollow">🤗 Accelerate Repo</a>.',Rl,ke,Al;return U=new Ie({props:{title:"Komplettes Training",local:"komplettes-training",headingTag:"h1"}}),T=new Bs({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/de/chapter3/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/de/chapter3/section4.ipynb"}]}}),f=new bs({props:{id:"Dh9CL8fyG80"}}),C=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),Z=new Ie({props:{title:"Vorbereitung für das Training",local:"vorbereitung-für-das-training",headingTag:"h3"}}),G=new y({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiUyQyUyMCUyMmlkeCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXM=",highlighted:`tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;idx&quot;</span>])
tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)
tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].column_names`,wrap:!1}}),v=new y({props:{code:"JTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>]',wrap:!1}}),X=new y({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMEEpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUwQSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

train_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>], shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)
eval_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)`,wrap:!1}}),R=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSU3QmslM0ElMjB2LnNoYXBlJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-keyword">break</span>
{k: v.shape <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}`,wrap:!1}}),A=new y({props:{code:"JTdCJ2F0dGVudGlvbl9tYXNrJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSUyQyUwQSUyMCdpbnB1dF9pZHMnJTNBJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwNjUlNUQpJTJDJTBBJTIwJ2xhYmVscyclM0ElMjB0b3JjaC5TaXplKCU1QjglNUQpJTJDJTBBJTIwJ3Rva2VuX3R5cGVfaWRzJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSU3RA==",highlighted:`{<span class="hljs-string">&#x27;attention_mask&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: torch.Size([<span class="hljs-number">8</span>]),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>])}`,wrap:!1}}),V=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),E=new y({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBcHJpbnQob3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5sb2dpdHMuc2hhcGUp",highlighted:`outputs = model(**batch)
<span class="hljs-built_in">print</span>(outputs.loss, outputs.logits.shape)`,wrap:!1}}),F=new y({props:{code:"dGVuc29yKDAuNTQ0MSUyQyUyMGdyYWRfZm4lM0QlM0NObGxMb3NzQmFja3dhcmQlM0UpJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwMiU1RCk=",highlighted:'tensor(<span class="hljs-number">0.5441</span>, grad_fn=&lt;NllLossBackward&gt;) torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">2</span>])',wrap:!1}}),H=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEFkYW1XJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0Q1ZS01KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AdamW

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),D=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUyQyUwQSklMEFwcmludChudW1fdHJhaW5pbmdfc3RlcHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)
<span class="hljs-built_in">print</span>(num_training_steps)`,wrap:!1}}),K=new y({props:{code:"MTM3Nw==",highlighted:'<span class="hljs-number">1377</span>',wrap:!1}}),L=new Ie({props:{title:"Die Trainingsschleife",local:"die-trainingsschleife",headingTag:"h3"}}),P=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBZGV2aWNl",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)
device`,wrap:!1}}),O=new y({props:{code:"ZGV2aWNlKHR5cGUlM0QnY3VkYScp",highlighted:'device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;cuda&#x27;</span>)',wrap:!1}}),le=new y({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),te=new Ie({props:{title:"Die Evaluationsschleife",local:"die-evaluationsschleife",headingTag:"h3"}}),ae=new y({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1vZGVsLmV2YWwoKSUwQWZvciUyMGJhdGNoJTIwaW4lMjBldmFsX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2gocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCklMEElMEFtZXRyaWMuY29tcHV0ZSgp",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(**batch)

    logits = outputs.logits
    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

metric.compute()`,wrap:!1}}),ie=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODQzMTM3MjU0OTAxOTYwOCUyQyUyMCdmMSclM0ElMjAwLjg5MDc4NDk4MjkzNTE1MzUlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8431372549019608</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8907849829351535</span>}',wrap:!1}}),j=new ws({props:{$$slots:{default:[ks]},$$scope:{ctx:Ze}}}),pe=new Ie({props:{title:"Verbessere deine Trainingsschleife mit 🤗 Accelerate",local:"verbessere-deine-trainingsschleife-mit--accelerate",headingTag:"h3"}}),de=new bs({props:{id:"s7dy8QRgjJ0"}}),ce=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEFkYW1XJTJDJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMGdldF9zY2hlZHVsZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTUpJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIpJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMHRvcmNoLmRldmljZSglMjJjcHUlMjIpJTBBbW9kZWwudG8oZGV2aWNlKSUwQSUwQW51bV9lcG9jaHMlMjAlM0QlMjAzJTBBbnVtX3RyYWluaW5nX3N0ZXBzJTIwJTNEJTIwbnVtX2Vwb2NocyUyMColMjBsZW4odHJhaW5fZGF0YWxvYWRlciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AdamW, AutoModelForSequenceClassification, get_scheduler

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),oe=new y({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from transformers import AdamW, AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),J=new ws({props:{$$slots:{default:[Is]},$$scope:{ctx:Ze}}}),be=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBZGFtVyUyQyUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AdamW, AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),je=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),Ue=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:'accelerate <span class="hljs-built_in">launch</span> train.py',wrap:!1}}),ge=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),{c(){w=m("meta"),b=n(),h=m("p"),Be=n(),i(U.$$.fragment),Ge=n(),i(T.$$.fragment),$e=n(),i(f.$$.fragment),ve=n(),g=m("p"),g.innerHTML=_l,We=n(),i(C.$$.fragment),Xe=n(),i(Z.$$.fragment),ze=n(),B=m("p"),B.innerHTML=Yl,Re=n(),k=m("ul"),k.innerHTML=Vl,Ae=n(),I=m("p"),I.innerHTML=Nl,_e=n(),i(G.$$.fragment),Ye=n(),$=m("p"),$.textContent=El,Ve=n(),i(v.$$.fragment),Ne=n(),W=m("p"),W.textContent=Fl,Ee=n(),i(X.$$.fragment),Fe=n(),z=m("p"),z.textContent=Ql,Qe=n(),i(R.$$.fragment),xe=n(),i(A.$$.fragment),He=n(),_=m("p"),_.innerHTML=xl,Se=n(),Y=m("p"),Y.textContent=Hl,De=n(),i(V.$$.fragment),Ke=n(),N=m("p"),N.textContent=Sl,Le=n(),i(E.$$.fragment),qe=n(),i(F.$$.fragment),Pe=n(),Q=m("p"),Q.innerHTML=Dl,Oe=n(),x=m("p"),x.innerHTML=Kl,el=n(),i(H.$$.fragment),ll=n(),S=m("p"),S.innerHTML=Ll,sl=n(),i(D.$$.fragment),tl=n(),i(K.$$.fragment),nl=n(),i(L.$$.fragment),al=n(),q=m("p"),q.innerHTML=ql,il=n(),i(P.$$.fragment),rl=n(),i(O.$$.fragment),pl=n(),ee=m("p"),ee.innerHTML=Pl,dl=n(),i(le.$$.fragment),Ml=n(),se=m("p"),se.textContent=Ol,cl=n(),i(te.$$.fragment),ml=n(),ne=m("p"),ne.innerHTML=es,ol=n(),i(ae.$$.fragment),ul=n(),i(ie.$$.fragment),yl=n(),re=m("p"),re.textContent=ls,wl=n(),i(j.$$.fragment),bl=n(),i(pe.$$.fragment),hl=n(),i(de.$$.fragment),jl=n(),Me=m("p"),Me.innerHTML=ss,Jl=n(),i(ce.$$.fragment),Ul=n(),me=m("p"),me.textContent=ts,Tl=n(),i(oe.$$.fragment),fl=n(),ue=m("p"),ue.innerHTML=ns,gl=n(),ye=m("p"),ye.innerHTML=as,Cl=n(),i(J.$$.fragment),Zl=n(),we=m("p"),we.textContent=is,Bl=n(),i(be.$$.fragment),kl=n(),he=m("p"),he.innerHTML=rs,Il=n(),i(je.$$.fragment),Gl=n(),Je=m("p"),Je.textContent=ps,$l=n(),i(Ue.$$.fragment),vl=n(),Te=m("p"),Te.textContent=ds,Wl=n(),fe=m("p"),fe.innerHTML=Ms,Xl=n(),i(ge.$$.fragment),zl=n(),Ce=m("p"),Ce.innerHTML=cs,Rl=n(),ke=m("p"),this.h()},l(e){const l=fs("svelte-u9bgzb",document.head);w=o(l,"META",{name:!0,content:!0}),l.forEach(s),b=a(e),h=o(e,"P",{}),us(h).forEach(s),Be=a(e),r(U.$$.fragment,e),Ge=a(e),r(T.$$.fragment,e),$e=a(e),r(f.$$.fragment,e),ve=a(e),g=o(e,"P",{"data-svelte-h":!0}),u(g)!=="svelte-u9dlj6"&&(g.innerHTML=_l),We=a(e),r(C.$$.fragment,e),Xe=a(e),r(Z.$$.fragment,e),ze=a(e),B=o(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-10uwzhv"&&(B.innerHTML=Yl),Re=a(e),k=o(e,"UL",{"data-svelte-h":!0}),u(k)!=="svelte-97ia1"&&(k.innerHTML=Vl),Ae=a(e),I=o(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1xre5mi"&&(I.innerHTML=Nl),_e=a(e),r(G.$$.fragment,e),Ye=a(e),$=o(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-1ne07l6"&&($.textContent=El),Ve=a(e),r(v.$$.fragment,e),Ne=a(e),W=o(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-1qzexy9"&&(W.textContent=Fl),Ee=a(e),r(X.$$.fragment,e),Fe=a(e),z=o(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-58ge5g"&&(z.textContent=Ql),Qe=a(e),r(R.$$.fragment,e),xe=a(e),r(A.$$.fragment,e),He=a(e),_=o(e,"P",{"data-svelte-h":!0}),u(_)!=="svelte-tuv6h6"&&(_.innerHTML=xl),Se=a(e),Y=o(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-qcm9iy"&&(Y.textContent=Hl),De=a(e),r(V.$$.fragment,e),Ke=a(e),N=o(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-1o9btcm"&&(N.textContent=Sl),Le=a(e),r(E.$$.fragment,e),qe=a(e),r(F.$$.fragment,e),Pe=a(e),Q=o(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-1xdm3p"&&(Q.innerHTML=Dl),Oe=a(e),x=o(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-n59cj8"&&(x.innerHTML=Kl),el=a(e),r(H.$$.fragment,e),ll=a(e),S=o(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-1d7k25q"&&(S.innerHTML=Ll),sl=a(e),r(D.$$.fragment,e),tl=a(e),r(K.$$.fragment,e),nl=a(e),r(L.$$.fragment,e),al=a(e),q=o(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-10laz2u"&&(q.innerHTML=ql),il=a(e),r(P.$$.fragment,e),rl=a(e),r(O.$$.fragment,e),pl=a(e),ee=o(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-5rg5wc"&&(ee.innerHTML=Pl),dl=a(e),r(le.$$.fragment,e),Ml=a(e),se=o(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-p31dwq"&&(se.textContent=Ol),cl=a(e),r(te.$$.fragment,e),ml=a(e),ne=o(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-1ho21o0"&&(ne.innerHTML=es),ol=a(e),r(ae.$$.fragment,e),ul=a(e),r(ie.$$.fragment,e),yl=a(e),re=o(e,"P",{"data-svelte-h":!0}),u(re)!=="svelte-14ibogl"&&(re.textContent=ls),wl=a(e),r(j.$$.fragment,e),bl=a(e),r(pe.$$.fragment,e),hl=a(e),r(de.$$.fragment,e),jl=a(e),Me=o(e,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-105b2zv"&&(Me.innerHTML=ss),Jl=a(e),r(ce.$$.fragment,e),Ul=a(e),me=o(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-1b5atwv"&&(me.textContent=ts),Tl=a(e),r(oe.$$.fragment,e),fl=a(e),ue=o(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-1rigc9c"&&(ue.innerHTML=ns),gl=a(e),ye=o(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-2rrnhi"&&(ye.innerHTML=as),Cl=a(e),r(J.$$.fragment,e),Zl=a(e),we=o(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-1la63xh"&&(we.textContent=is),Bl=a(e),r(be.$$.fragment,e),kl=a(e),he=o(e,"P",{"data-svelte-h":!0}),u(he)!=="svelte-1l337r5"&&(he.innerHTML=rs),Il=a(e),r(je.$$.fragment,e),Gl=a(e),Je=o(e,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-134ovcr"&&(Je.textContent=ps),$l=a(e),r(Ue.$$.fragment,e),vl=a(e),Te=o(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-1m2v744"&&(Te.textContent=ds),Wl=a(e),fe=o(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-umh1t9"&&(fe.innerHTML=Ms),Xl=a(e),r(ge.$$.fragment,e),zl=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-1vh5l4m"&&(Ce.innerHTML=cs),Rl=a(e),ke=o(e,"P",{}),us(ke).forEach(s),this.h()},h(){ys(w,"name","hf:doc:metadata"),ys(w,"content",$s)},m(e,l){gs(document.head,w),t(e,b,l),t(e,h,l),t(e,Be,l),p(U,e,l),t(e,Ge,l),p(T,e,l),t(e,$e,l),p(f,e,l),t(e,ve,l),t(e,g,l),t(e,We,l),p(C,e,l),t(e,Xe,l),p(Z,e,l),t(e,ze,l),t(e,B,l),t(e,Re,l),t(e,k,l),t(e,Ae,l),t(e,I,l),t(e,_e,l),p(G,e,l),t(e,Ye,l),t(e,$,l),t(e,Ve,l),p(v,e,l),t(e,Ne,l),t(e,W,l),t(e,Ee,l),p(X,e,l),t(e,Fe,l),t(e,z,l),t(e,Qe,l),p(R,e,l),t(e,xe,l),p(A,e,l),t(e,He,l),t(e,_,l),t(e,Se,l),t(e,Y,l),t(e,De,l),p(V,e,l),t(e,Ke,l),t(e,N,l),t(e,Le,l),p(E,e,l),t(e,qe,l),p(F,e,l),t(e,Pe,l),t(e,Q,l),t(e,Oe,l),t(e,x,l),t(e,el,l),p(H,e,l),t(e,ll,l),t(e,S,l),t(e,sl,l),p(D,e,l),t(e,tl,l),p(K,e,l),t(e,nl,l),p(L,e,l),t(e,al,l),t(e,q,l),t(e,il,l),p(P,e,l),t(e,rl,l),p(O,e,l),t(e,pl,l),t(e,ee,l),t(e,dl,l),p(le,e,l),t(e,Ml,l),t(e,se,l),t(e,cl,l),p(te,e,l),t(e,ml,l),t(e,ne,l),t(e,ol,l),p(ae,e,l),t(e,ul,l),p(ie,e,l),t(e,yl,l),t(e,re,l),t(e,wl,l),p(j,e,l),t(e,bl,l),p(pe,e,l),t(e,hl,l),p(de,e,l),t(e,jl,l),t(e,Me,l),t(e,Jl,l),p(ce,e,l),t(e,Ul,l),t(e,me,l),t(e,Tl,l),p(oe,e,l),t(e,fl,l),t(e,ue,l),t(e,gl,l),t(e,ye,l),t(e,Cl,l),p(J,e,l),t(e,Zl,l),t(e,we,l),t(e,Bl,l),p(be,e,l),t(e,kl,l),t(e,he,l),t(e,Il,l),p(je,e,l),t(e,Gl,l),t(e,Je,l),t(e,$l,l),p(Ue,e,l),t(e,vl,l),t(e,Te,l),t(e,Wl,l),t(e,fe,l),t(e,Xl,l),p(ge,e,l),t(e,zl,l),t(e,Ce,l),t(e,Rl,l),t(e,ke,l),Al=!0},p(e,[l]){const ms={};l&2&&(ms.$$scope={dirty:l,ctx:e}),j.$set(ms);const os={};l&2&&(os.$$scope={dirty:l,ctx:e}),J.$set(os)},i(e){Al||(d(U.$$.fragment,e),d(T.$$.fragment,e),d(f.$$.fragment,e),d(C.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(v.$$.fragment,e),d(X.$$.fragment,e),d(R.$$.fragment,e),d(A.$$.fragment,e),d(V.$$.fragment,e),d(E.$$.fragment,e),d(F.$$.fragment,e),d(H.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(L.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(le.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(j.$$.fragment,e),d(pe.$$.fragment,e),d(de.$$.fragment,e),d(ce.$$.fragment,e),d(oe.$$.fragment,e),d(J.$$.fragment,e),d(be.$$.fragment,e),d(je.$$.fragment,e),d(Ue.$$.fragment,e),d(ge.$$.fragment,e),Al=!0)},o(e){M(U.$$.fragment,e),M(T.$$.fragment,e),M(f.$$.fragment,e),M(C.$$.fragment,e),M(Z.$$.fragment,e),M(G.$$.fragment,e),M(v.$$.fragment,e),M(X.$$.fragment,e),M(R.$$.fragment,e),M(A.$$.fragment,e),M(V.$$.fragment,e),M(E.$$.fragment,e),M(F.$$.fragment,e),M(H.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),M(L.$$.fragment,e),M(P.$$.fragment,e),M(O.$$.fragment,e),M(le.$$.fragment,e),M(te.$$.fragment,e),M(ae.$$.fragment,e),M(ie.$$.fragment,e),M(j.$$.fragment,e),M(pe.$$.fragment,e),M(de.$$.fragment,e),M(ce.$$.fragment,e),M(oe.$$.fragment,e),M(J.$$.fragment,e),M(be.$$.fragment,e),M(je.$$.fragment,e),M(Ue.$$.fragment,e),M(ge.$$.fragment,e),Al=!1},d(e){e&&(s(b),s(h),s(Be),s(Ge),s($e),s(ve),s(g),s(We),s(Xe),s(ze),s(B),s(Re),s(k),s(Ae),s(I),s(_e),s(Ye),s($),s(Ve),s(Ne),s(W),s(Ee),s(Fe),s(z),s(Qe),s(xe),s(He),s(_),s(Se),s(Y),s(De),s(Ke),s(N),s(Le),s(qe),s(Pe),s(Q),s(Oe),s(x),s(el),s(ll),s(S),s(sl),s(tl),s(nl),s(al),s(q),s(il),s(rl),s(pl),s(ee),s(dl),s(Ml),s(se),s(cl),s(ml),s(ne),s(ol),s(ul),s(yl),s(re),s(wl),s(bl),s(hl),s(jl),s(Me),s(Jl),s(Ul),s(me),s(Tl),s(fl),s(ue),s(gl),s(ye),s(Cl),s(Zl),s(we),s(Bl),s(kl),s(he),s(Il),s(Gl),s(Je),s($l),s(vl),s(Te),s(Wl),s(fe),s(Xl),s(zl),s(Ce),s(Rl),s(ke)),s(w),c(U,e),c(T,e),c(f,e),c(C,e),c(Z,e),c(G,e),c(v,e),c(X,e),c(R,e),c(A,e),c(V,e),c(E,e),c(F,e),c(H,e),c(D,e),c(K,e),c(L,e),c(P,e),c(O,e),c(le,e),c(te,e),c(ae,e),c(ie,e),c(j,e),c(pe,e),c(de,e),c(ce,e),c(oe,e),c(J,e),c(be,e),c(je,e),c(Ue,e),c(ge,e)}}}const $s='{"title":"Komplettes Training","local":"komplettes-training","sections":[{"title":"Vorbereitung für das Training","local":"vorbereitung-für-das-training","sections":[],"depth":3},{"title":"Die Trainingsschleife","local":"die-trainingsschleife","sections":[],"depth":3},{"title":"Die Evaluationsschleife","local":"die-evaluationsschleife","sections":[],"depth":3},{"title":"Verbessere deine Trainingsschleife mit 🤗 Accelerate","local":"verbessere-deine-trainingsschleife-mit--accelerate","sections":[],"depth":3}],"depth":1}';function vs(Ze){return js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vs extends Us{constructor(w){super(),Ts(this,w,vs,Gs,hs,{})}}export{Vs as component};
