import{s as ya,n as wa,o as fa}from"../chunks/scheduler.6062bdaf.js";import{S as Ta,i as ba,g as s,s as o,r as d,A as Ja,h as n,f as t,c as i,j as c,u as M,x as p,k as r,y as h,a,v as u,d as m,t as y,w}from"../chunks/index.4bca734e.js";import{I as f}from"../chunks/IconCopyLink.68a13644.js";import{C as Re}from"../chunks/CodeBlock.f213e6a5.js";function ja(pl){let T,De,b,x,Xe,X,el,Ae,cl="Integrate any ML framework with the Hub",Oe,V,dl=`The Hugging Face Hub makes hosting and sharing models with the community easy. It supports
<a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">dozens of libraries</a> in the Open Source ecosystem. We are always
working on expanding this support to push collaborative Machine Learning forward. The <code>huggingface_hub</code> library plays a
key role in this process, allowing any Python script to easily push and load files.`,et,Q,Ml="There are four main ways to integrate a library with the Hub:",tt,N,ul=`<li><strong>Push to Hub:</strong> implement a method to upload a model to the Hub. This includes the model weights, as well as
<a href="https://huggingface.co/docs/huggingface_hub/how-to-model-cards" rel="nofollow">the model card</a> and any other relevant information
or data necessary to run the model (for example, training logs). This method is often called <code>push_to_hub()</code>.</li> <li><strong>Download from Hub:</strong> implement a method to load a model from the Hub. The method should download the model
configuration/weights and load the model. This method is often called <code>from_pretrained</code> or <code>load_from_hub()</code>.</li> <li><strong>Inference API:</strong> use our servers to run inference on models supported by your library for free.</li> <li><strong>Widgets:</strong> display a widget on the landing page of your models on the Hub. It allows users to quickly try a model
from the browser.</li>`,lt,F,ml=`In this guide, we will focus on the first two topics. We will present the two main approaches you can use to integrate
a library, with their advantages and drawbacks. Everything is summarized at the end of the guide to help you choose
between the two. Please keep in mind that these are only guidelines that you are free to adapt to you requirements.`,at,L,yl=`If you are interested in Inference and Widgets, you can follow <a href="https://huggingface.co/docs/hub/models-adding-libraries#set-up-the-inference-api" rel="nofollow">this guide</a>.
In both cases, you can reach out to us if you are integrating a library with the Hub and want to be listed
<a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">in our docs</a>.`,st,J,A,Ve,z,tl,Be,wl="A flexible approach: helpers",nt,P,fl=`The first approach to integrate a library to the Hub is to actually implement the <code>push_to_hub</code> and <code>from_pretrained</code>
methods by yourself. This gives you full flexibility on which files you need to upload/download and how to handle inputs
specific to your framework. You can refer to the two <a href="./upload">upload files</a> and <a href="./download">download files</a> guides
to learn more about how to do that. This is, for example how the FastAI integration is implemented (see <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/mixins#huggingface_hub.push_to_hub_fastai">push_to_hub_fastai()</a>
and <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/mixins#huggingface_hub.from_pretrained_fastai">from_pretrained_fastai()</a>).`,ot,q,Tl="Implementation can differ between libraries, but the workflow is often similar.",it,j,B,Qe,K,ll,Ze,bl="from_pretrained",rt,D,Jl="This is how a <code>from_pretrained</code> method usually look like:",ht,O,pt,U,Z,Ne,ee,al,Ge,jl="push_to_hub",ct,te,Ul=`The <code>push_to_hub</code> method often requires a bit more complexity to handle repo creation, generate the model card and save weights.
A common approach is to save all of these files in a temporary folder, upload it and then delete it.`,dt,le,Mt,ae,gl=`This is of course only an example. If you are interested in more complex manipulations (delete remote files, upload
weights on the fly, persist weights locally, etc.) please refer to the <a href="./upload">upload files</a> guide.`,ut,g,G,Fe,se,sl,He,Il="Limitations",mt,ne,Cl=`While being flexible, this approach has some drawbacks, especially in terms of maintenance. Hugging Face users are often
used to additional features when working with <code>huggingface_hub</code>. For example, when loading files from the Hub, it is
common to offer parameters like:`,yt,oe,vl="<li><code>token</code>: to download from a private repo</li> <li><code>revision</code>: to download from a specific branch</li> <li><code>cache_dir</code>: to cache files in a specific directory</li> <li><code>force_download</code>/<code>resume_download</code>/<code>local_files_only</code>: to reuse the cache or not</li> <li><code>api_endpoint</code>/<code>proxies</code>: configure HTTP session</li>",wt,ie,_l="When pushing models, similar parameters are supported:",ft,re,kl="<li><code>commit_message</code>: custom commit message</li> <li><code>private</code>: create a private repo if missing</li> <li><code>create_pr</code>: create a PR instead of pushing to <code>main</code></li> <li><code>branch</code>: push to a branch instead of the <code>main</code> branch</li> <li><code>allow_patterns</code>/<code>ignore_patterns</code>: filter which files to upload</li> <li><code>token</code></li> <li><code>api_endpoint</code></li> <li>…</li>",Tt,he,xl=`All of these parameters can be added to the implementations we saw above and passed to the <code>huggingface_hub</code> methods.
However, if a parameter changes or a new feature is added, you will need to update your package. Supporting those
parameters also means more documentation to maintain on your side. To see how to mitigate these limitations, let’s jump
to our next section <strong>class inheritance</strong>.`,bt,I,H,Le,pe,nl,Ee,Al="A more complex approach: class inheritance",Jt,ce,Bl=`As we saw above, there are two main methods to include in your library to integrate it with the Hub: upload files
(<code>push_to_hub</code>) and download files (<code>from_pretrained</code>). You can implement those methods by yourself but it comes with
caveats. To tackle this, <code>huggingface_hub</code> provides a tool that uses class inheritance. Let’s see how it works!`,jt,de,Zl=`In a lot of cases, a library already implements its model using a Python class. The class contains the properties of
the model and methods to load, run, train, and evaluate it. Our approach is to extend this class to include upload and
download features using mixins. A <a href="https://stackoverflow.com/a/547714" rel="nofollow">Mixin</a> is a class that is meant to extend an
existing class with a set of specific features using multiple inheritance. <code>huggingface_hub</code> provides its own mixin,
the <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>. The key here is to understand its behavior and how to customize it.`,Ut,Me,Gl=`The <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> class implements 3 <em>public</em> methods (<code>push_to_hub</code>, <code>save_pretrained</code> and <code>from_pretrained</code>). Those
are the methods that your users will call to load/save models with your library. <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> also defines 2
<em>private</em> methods (<code>_save_pretrained</code> and <code>_from_pretrained</code>). Those are the ones you must implement. So to integrate
your library, you should:`,gt,ue,Hl=`<li>Make your Model class inherit from <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>.</li> <li>Implement the private methods:<ul><li><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/mixins#huggingface_hub.ModelHubMixin._save_pretrained">_save_pretrained()</a>: method taking as input a path to a directory and saving the model to it.
You must write all the logic to dump your model in this method: model card, model weights, configuration files,
training logs, and figures. Any relevant information for this model must be handled by this method.
<a href="https://huggingface.co/docs/hub/model-cards" rel="nofollow">Model Cards</a> are particularly important to describe your model. Check
out <a href="./model-cards">our implementation guide</a> for more details.</li> <li><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/mixins#huggingface_hub.ModelHubMixin._from_pretrained">_from_pretrained()</a>: <strong>class method</strong> taking as input a <code>model_id</code> and returning an instantiated
model. The method must download the relevant files and load them.</li></ul></li> <li>You are done!</li>`,It,me,El=`The advantage of using <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> is that once you take care of the serialization/loading of the files, you
are ready to go. You don’t need to worry about stuff like repo creation, commits, PRs, or revisions. All
of this is handled by the mixin and is available to your users. The Mixin also ensures that public methods are well
documented and type annotated.`,Ct,C,E,ze,ye,ol,We,Wl="A concrete example: PyTorch",vt,we,$l=`A good example of what we saw above is <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/mixins#huggingface_hub.PyTorchModelHubMixin">PyTorchModelHubMixin</a>, our integration for the PyTorch framework. This is a
ready-to-use integration.`,_t,v,W,Pe,fe,il,$e,Yl="How to use it?",kt,Te,Sl="Here is how any user can load/save a PyTorch model from/to the Hub:",xt,be,At,_,$,qe,Je,rl,Ye,Rl="Implementation",Bt,je,Xl='The implementation is actually very straightforward, and the full implementation can be found <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py" rel="nofollow">here</a>.',Zt,Ue,Vl="<li>First, inherit your class from <code>ModelHubMixin</code>:</li>",Gt,ge,Ht,Y,Ql="<li>Implement the <code>_save_pretrained</code> method:</li>",Et,Ie,Wt,S,Nl="<li>Implement the <code>_from_pretrained</code> method:</li>",$t,Ce,Yt,ve,Fl="And that’s it! Your library now enables users to upload and download files to and from the Hub.",St,k,R,Ke,_e,hl,Se,Ll="Quick comparison",Rt,ke,zl=`Let’s quickly sum up the two approaches we saw with their advantages and drawbacks. The table below is only indicative.
Your framework might have some specificities that you need to address. This guide is only here to give guidelines and
ideas on how to handle integration. In any case, feel free to contact us if you have any questions!`,Xt,xe,Pl='<thead><tr><th align="center">Integration</th> <th align="center">Using helpers</th> <th align="center">Using <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a></th></tr></thead> <tbody><tr><td align="center">User experience</td> <td align="center"><code>model = load_from_hub(...)</code><br/><code>push_to_hub(model, ...)</code></td> <td align="center"><code>model = MyModel.from_pretrained(...)</code><br/><code>model.push_to_hub(...)</code></td></tr> <tr><td align="center">Flexibility</td> <td align="center">Very flexible.<br/>You fully control the implementation.</td> <td align="center">Less flexible.<br/>Your framework must have a model class.</td></tr> <tr><td align="center">Maintenance</td> <td align="center">More maintenance to add support for configuration, and new features. Might also require fixing issues reported by users.</td> <td align="center">Less maintenance as most of the interactions with the Hub are implemented in <code>huggingface_hub</code>.</td></tr> <tr><td align="center">Documentation / Type annotation</td> <td align="center">To be written manually.</td> <td align="center">Partially handled by <code>huggingface_hub</code>.</td></tr></tbody>',Vt;return X=new f({}),z=new f({}),K=new f({}),O=new Re({props:{code:"ZGVmJTIwZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTNBJTIwc3RyKSUyMC0lM0UlMjBNeU1vZGVsQ2xhc3MlM0ElMEElMjAlMjAlMjAlMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwZnJvbSUyMEh1YiUwQSUyMCUyMCUyMGNhY2hlZF9tb2RlbCUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGZpbGVuYW1lJTNEJTIybW9kZWwucGtsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIyZmFzdGFpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV92ZXJzaW9uJTNEZ2V0X2Zhc3RhaV92ZXJzaW9uKCklMkMlMEElMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIzJTIwTG9hZCUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbG9hZF9tb2RlbChjYWNoZWRfbW9kZWwp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">from_pretrained</span>(<span class="hljs-params">model_id: <span class="hljs-built_in">str</span></span>) -&gt; MyModelClass:
   <span class="hljs-comment"># Download model from Hub</span>
   cached_model = hf_hub_download(
      repo_id=repo_id,
      filename=<span class="hljs-string">&quot;model.pkl&quot;</span>,
      library_name=<span class="hljs-string">&quot;fastai&quot;</span>,
      library_version=get_fastai_version(),
   )

   <span class="hljs-comment"># Load model</span>
    <span class="hljs-keyword">return</span> load_model(cached_model)`}}),ee=new f({}),le=new Re({props:{code:"ZGVmJTIwcHVzaF90b19odWIobW9kZWwlM0ElMjBNeU1vZGVsQ2xhc3MlMkMlMjByZXBvX25hbWUlM0ElMjBzdHIpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjBhcGklMjAlM0QlMjBIZkFwaSgpJTBBJTBBJTIwJTIwJTIwJTIzJTIwQ3JlYXRlJTIwcmVwbyUyMGlmJTIwbm90JTIwZXhpc3RpbmclMjB5ZXQlMjBhbmQlMjBnZXQlMjB0aGUlMjBhc3NvY2lhdGVkJTIwcmVwb19pZCUwQSUyMCUyMCUyMHJlcG9faWQlMjAlM0QlMjBhcGkuY3JlYXRlX3JlcG8ocmVwb19uYW1lJTJDJTIwZXhpc3Rfb2slM0RUcnVlKSUwQSUwQSUyMCUyMCUyMCUyMyUyMFNhdmUlMjBhbGwlMjBmaWxlcyUyMGluJTIwYSUyMHRlbXBvcmFyeSUyMGRpcmVjdG9yeSUyMGFuZCUyMHB1c2glMjB0aGVtJTIwaW4lMjBhJTIwc2luZ2xlJTIwY29tbWl0JTBBJTIwJTIwJTIwd2l0aCUyMFRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBkaXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjB0bXBkaXIlMjAlM0QlMjBQYXRoKHRtcGRpciklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXZlJTIwd2VpZ2h0cyUwQSUyMCUyMCUyMCUyMCUyMCUyMHNhdmVfbW9kZWwobW9kZWwlMkMlMjB0bXBkaXIlMjAlMkYlMjAlMjJtb2RlbC5zYWZldGVuc29ycyUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHZW5lcmF0ZSUyMG1vZGVsJTIwY2FyZCUwQSUyMCUyMCUyMCUyMCUyMCUyMGNhcmQlMjAlM0QlMjBnZW5lcmF0ZV9tb2RlbF9jYXJkKG1vZGVsKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCh0bXBkaXIlMjAlMkYlMjAlMjJSRUFETUUubWQlMjIpLndyaXRlX3RleHQoY2FyZCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXZlJTIwbG9ncyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFNhdmUlMjBmaWd1cmVzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwU2F2ZSUyMGV2YWx1YXRpb24lMjBtZXRyaWNzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUHVzaCUyMHRvJTIwaHViJTBBJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwYXBpLnVwbG9hZF9mb2xkZXIocmVwb19pZCUzRHJlcG9faWQlMkMlMjBmb2xkZXJfcGF0aCUzRHRtcGRpcik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">model: MyModelClass, repo_name: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-literal">None</span>:
   api = HfApi()

   <span class="hljs-comment"># Create repo if not existing yet and get the associated repo_id</span>
   repo_id = api.create_repo(repo_name, exist_ok=<span class="hljs-literal">True</span>)

   <span class="hljs-comment"># Save all files in a temporary directory and push them in a single commit</span>
   <span class="hljs-keyword">with</span> TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdir:
      tmpdir = Path(tmpdir)

      <span class="hljs-comment"># Save weights</span>
      save_model(model, tmpdir / <span class="hljs-string">&quot;model.safetensors&quot;</span>)

      <span class="hljs-comment"># Generate model card</span>
      card = generate_model_card(model)
      (tmpdir / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(card)

      <span class="hljs-comment"># Save logs</span>
      <span class="hljs-comment"># Save figures</span>
      <span class="hljs-comment"># Save evaluation metrics</span>
      <span class="hljs-comment"># ...</span>

      <span class="hljs-comment"># Push to hub</span>
      <span class="hljs-keyword">return</span> api.upload_folder(repo_id=repo_id, folder_path=tmpdir)`}}),se=new f({}),pe=new f({}),ye=new f({}),fe=new f({}),be=new Re({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyME15TW9kZWwobm4uTW9kdWxlJTJDJTIwUHlUb3JjaE1vZGVsSHViTWl4aW4pJTNBJTIwJTIzJTIwbXVsdGlwbGUlMjBpbmhlcml0YW5jZSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5wYXJhbSUyMCUzRCUyMG5uLlBhcmFtZXRlcih0b3JjaC5yYW5kKDMlMkMlMjA0KSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmxpbmVhciUyMCUzRCUyMG5uLkxpbmVhcig0JTJDJTIwNSklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjB4KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubGluZWFyKHglMjAlMkIlMjBzZWxmLnBhcmFtKSUwQW1vZGVsJTIwJTNEJTIwTXlNb2RlbCgpJTBBJTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMnBhdGglMkZ0byUyRm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTBBbW9kZWwucHVzaF90b19odWIoJTIybXktYXdlc29tZS1tb2RlbCUyMiklMEElMEFtb2RlbCUyMCUzRCUyME15TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnVzZXJuYW1lJTJGbXktYXdlc29tZS1tb2RlbCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin

<span class="hljs-comment"># 1. Define your Pytorch model exactly the same way you are used to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(nn.Module, PyTorchModelHubMixin): <span class="hljs-comment"># multiple inheritance</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__() 
<span class="hljs-meta">... </span>        self.param = nn.Parameter(torch.rand(<span class="hljs-number">3</span>, <span class="hljs-number">4</span>))
<span class="hljs-meta">... </span>        self.linear = nn.Linear(<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> self.linear(x + self.param)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel()

<span class="hljs-comment"># 2. (optional) Save model to local directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;path/to/my-awesome-model&quot;</span>)

<span class="hljs-comment"># 3. Push model weights to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># 4. Initialize model from the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)`}}),Je=new f({}),ge=new Re({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)`}}),Ie=new Re({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUyQyUyME1vZGVsQ2FyZERhdGElMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLiklMEElMEElMjAlMjAlMjBkZWYlMjBfc2F2ZV9wcmV0cmFpbmVkKHNlbGYlMkMlMjBzYXZlX2RpcmVjdG9yeSUzQSUyMFBhdGgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyR2VuZXJhdGUlMjBNb2RlbCUyMENhcmQlMjBhbmQlMjBzYXZlJTIwd2VpZ2h0cyUyMGZyb20lMjBhJTIwUHl0b3JjaCUyMG1vZGVsJTIwdG8lMjBhJTIwbG9jYWwlMjBkaXJlY3RvcnkuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfY2FyZCUyMCUzRCUyME1vZGVsQ2FyZC5mcm9tX3RlbXBsYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRfZGF0YSUzRE1vZGVsQ2FyZERhdGEoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGljZW5zZSUzRCdtaXQnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9zdW1tYXJ5JTNELi4uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfdHlwZSUzRC4uLiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAoc2F2ZV9kaXJlY3RvcnklMjAlMkYlMjAlMjJSRUFETUUubWQlMjIpLndyaXRlX3RleHQoc3RyKG1vZGVsKSklMEElMjAlMjAlMjAlMjAlMjAlMjB0b3JjaC5zYXZlKG9iaiUzRHNlbGYubW9kdWxlLnN0YXRlX2RpY3QoKSUyQyUyMGYlM0RzYXZlX2RpcmVjdG9yeSUyMCUyRiUyMCUyMnB5dG9yY2hfbW9kZWwuYmluJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard, ModelCardData

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_pretrained</span>(<span class="hljs-params">self, save_directory: Path</span>):
      <span class="hljs-string">&quot;&quot;&quot;Generate Model Card and save weights from a Pytorch model to a local directory.&quot;&quot;&quot;</span>
      model_card = ModelCard.from_template(
         card_data=ModelCardData(
            license=<span class="hljs-string">&#x27;mit&#x27;</span>,
            library_name=<span class="hljs-string">&quot;pytorch&quot;</span>,
            ...
         ),
         model_summary=...,
         model_type=...,
         ...
      )
      (save_directory / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(<span class="hljs-built_in">str</span>(model))
      torch.save(obj=self.module.state_dict(), f=save_directory / <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)`}}),Ce=new Re({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

<span class="hljs-meta">   @classmethod </span><span class="hljs-comment"># Must be a classmethod!</span>
   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_from_pretrained</span>(<span class="hljs-params">
      cls,
      *,
      model_id: <span class="hljs-built_in">str</span>,
      revision: <span class="hljs-built_in">str</span>,
      cache_dir: <span class="hljs-built_in">str</span>,
      force_download: <span class="hljs-built_in">bool</span>,
      proxies: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>],
      resume_download: <span class="hljs-built_in">bool</span>,
      local_files_only: <span class="hljs-built_in">bool</span>,
      token: <span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>, <span class="hljs-literal">None</span>],
      map_location: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span>, <span class="hljs-comment"># additional argument</span>
      strict: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>, <span class="hljs-comment"># additional argument</span>
      **model_kwargs,
   </span>):
      <span class="hljs-string">&quot;&quot;&quot;Load Pytorch pretrained weights and return the loaded model.&quot;&quot;&quot;</span>
      <span class="hljs-keyword">if</span> os.path.isdir(model_id): <span class="hljs-comment"># Can either be a local directory</span>
         <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading weights from local directory&quot;</span>)
         model_file = os.path.join(model_id, <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)
      <span class="hljs-keyword">else</span>: <span class="hljs-comment"># Or a model on the Hub</span>
         model_file = hf_hub_download( <span class="hljs-comment"># Download from the hub, passing same input args</span>
            repo_id=model_id,
            filename=<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
            revision=revision,
            cache_dir=cache_dir,
            force_download=force_download,
            proxies=proxies,
            resume_download=resume_download,
            token=token,
            local_files_only=local_files_only,
         )

      <span class="hljs-comment"># Load model and return - custom logic depending on your framework</span>
      model = cls(**model_kwargs)
      state_dict = torch.load(model_file, map_location=torch.device(map_location))
      model.load_state_dict(state_dict, strict=strict)
      model.<span class="hljs-built_in">eval</span>()
      <span class="hljs-keyword">return</span> model`}}),_e=new f({}),{c(){T=s("meta"),De=o(),b=s("h1"),x=s("a"),Xe=s("span"),d(X.$$.fragment),el=o(),Ae=s("span"),Ae.textContent=cl,Oe=o(),V=s("p"),V.innerHTML=dl,et=o(),Q=s("p"),Q.textContent=Ml,tt=o(),N=s("ol"),N.innerHTML=ul,lt=o(),F=s("p"),F.textContent=ml,at=o(),L=s("p"),L.innerHTML=yl,st=o(),J=s("h2"),A=s("a"),Ve=s("span"),d(z.$$.fragment),tl=o(),Be=s("span"),Be.textContent=wl,nt=o(),P=s("p"),P.innerHTML=fl,ot=o(),q=s("p"),q.textContent=Tl,it=o(),j=s("h3"),B=s("a"),Qe=s("span"),d(K.$$.fragment),ll=o(),Ze=s("span"),Ze.textContent=bl,rt=o(),D=s("p"),D.innerHTML=Jl,ht=o(),d(O.$$.fragment),pt=o(),U=s("h3"),Z=s("a"),Ne=s("span"),d(ee.$$.fragment),al=o(),Ge=s("span"),Ge.textContent=jl,ct=o(),te=s("p"),te.innerHTML=Ul,dt=o(),d(le.$$.fragment),Mt=o(),ae=s("p"),ae.innerHTML=gl,ut=o(),g=s("h3"),G=s("a"),Fe=s("span"),d(se.$$.fragment),sl=o(),He=s("span"),He.textContent=Il,mt=o(),ne=s("p"),ne.innerHTML=Cl,yt=o(),oe=s("ul"),oe.innerHTML=vl,wt=o(),ie=s("p"),ie.textContent=_l,ft=o(),re=s("ul"),re.innerHTML=kl,Tt=o(),he=s("p"),he.innerHTML=xl,bt=o(),I=s("h2"),H=s("a"),Le=s("span"),d(pe.$$.fragment),nl=o(),Ee=s("span"),Ee.textContent=Al,Jt=o(),ce=s("p"),ce.innerHTML=Bl,jt=o(),de=s("p"),de.innerHTML=Zl,Ut=o(),Me=s("p"),Me.innerHTML=Gl,gt=o(),ue=s("ol"),ue.innerHTML=Hl,It=o(),me=s("p"),me.innerHTML=El,Ct=o(),C=s("h3"),E=s("a"),ze=s("span"),d(ye.$$.fragment),ol=o(),We=s("span"),We.textContent=Wl,vt=o(),we=s("p"),we.innerHTML=$l,_t=o(),v=s("h4"),W=s("a"),Pe=s("span"),d(fe.$$.fragment),il=o(),$e=s("span"),$e.textContent=Yl,kt=o(),Te=s("p"),Te.textContent=Sl,xt=o(),d(be.$$.fragment),At=o(),_=s("h4"),$=s("a"),qe=s("span"),d(Je.$$.fragment),rl=o(),Ye=s("span"),Ye.textContent=Rl,Bt=o(),je=s("p"),je.innerHTML=Xl,Zt=o(),Ue=s("ol"),Ue.innerHTML=Vl,Gt=o(),d(ge.$$.fragment),Ht=o(),Y=s("ol"),Y.innerHTML=Ql,Et=o(),d(Ie.$$.fragment),Wt=o(),S=s("ol"),S.innerHTML=Nl,$t=o(),d(Ce.$$.fragment),Yt=o(),ve=s("p"),ve.textContent=Fl,St=o(),k=s("h2"),R=s("a"),Ke=s("span"),d(_e.$$.fragment),hl=o(),Se=s("span"),Se.textContent=Ll,Rt=o(),ke=s("p"),ke.textContent=zl,Xt=o(),xe=s("table"),xe.innerHTML=Pl,this.h()},l(e){const l=Ja("svelte-1phssyn",document.head);T=n(l,"META",{name:!0,content:!0}),l.forEach(t),De=i(e),b=n(e,"H1",{class:!0});var Qt=c(b);x=n(Qt,"A",{id:!0,class:!0,href:!0});var ql=c(x);Xe=n(ql,"SPAN",{});var Kl=c(Xe);M(X.$$.fragment,Kl),Kl.forEach(t),ql.forEach(t),el=i(Qt),Ae=n(Qt,"SPAN",{"data-svelte-h":!0}),p(Ae)!=="svelte-1rebw4h"&&(Ae.textContent=cl),Qt.forEach(t),Oe=i(e),V=n(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-uvt37o"&&(V.innerHTML=dl),et=i(e),Q=n(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-14vdlq5"&&(Q.textContent=Ml),tt=i(e),N=n(e,"OL",{"data-svelte-h":!0}),p(N)!=="svelte-14btp4x"&&(N.innerHTML=ul),lt=i(e),F=n(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1tx4sul"&&(F.textContent=ml),at=i(e),L=n(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-10f3yyh"&&(L.innerHTML=yl),st=i(e),J=n(e,"H2",{class:!0});var Nt=c(J);A=n(Nt,"A",{id:!0,class:!0,href:!0});var Dl=c(A);Ve=n(Dl,"SPAN",{});var Ol=c(Ve);M(z.$$.fragment,Ol),Ol.forEach(t),Dl.forEach(t),tl=i(Nt),Be=n(Nt,"SPAN",{"data-svelte-h":!0}),p(Be)!=="svelte-vt28ya"&&(Be.textContent=wl),Nt.forEach(t),nt=i(e),P=n(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-z3s6vh"&&(P.innerHTML=fl),ot=i(e),q=n(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1g2giur"&&(q.textContent=Tl),it=i(e),j=n(e,"H3",{class:!0});var Ft=c(j);B=n(Ft,"A",{id:!0,class:!0,href:!0});var ea=c(B);Qe=n(ea,"SPAN",{});var ta=c(Qe);M(K.$$.fragment,ta),ta.forEach(t),ea.forEach(t),ll=i(Ft),Ze=n(Ft,"SPAN",{"data-svelte-h":!0}),p(Ze)!=="svelte-16jalha"&&(Ze.textContent=bl),Ft.forEach(t),rt=i(e),D=n(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-bozc1x"&&(D.innerHTML=Jl),ht=i(e),M(O.$$.fragment,e),pt=i(e),U=n(e,"H3",{class:!0});var Lt=c(U);Z=n(Lt,"A",{id:!0,class:!0,href:!0});var la=c(Z);Ne=n(la,"SPAN",{});var aa=c(Ne);M(ee.$$.fragment,aa),aa.forEach(t),la.forEach(t),al=i(Lt),Ge=n(Lt,"SPAN",{"data-svelte-h":!0}),p(Ge)!=="svelte-xuwr0f"&&(Ge.textContent=jl),Lt.forEach(t),ct=i(e),te=n(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-7bmo7d"&&(te.innerHTML=Ul),dt=i(e),M(le.$$.fragment,e),Mt=i(e),ae=n(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-15vgu12"&&(ae.innerHTML=gl),ut=i(e),g=n(e,"H3",{class:!0});var zt=c(g);G=n(zt,"A",{id:!0,class:!0,href:!0});var sa=c(G);Fe=n(sa,"SPAN",{});var na=c(Fe);M(se.$$.fragment,na),na.forEach(t),sa.forEach(t),sl=i(zt),He=n(zt,"SPAN",{"data-svelte-h":!0}),p(He)!=="svelte-z4yr6i"&&(He.textContent=Il),zt.forEach(t),mt=i(e),ne=n(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-tzwehq"&&(ne.innerHTML=Cl),yt=i(e),oe=n(e,"UL",{"data-svelte-h":!0}),p(oe)!=="svelte-wxu08k"&&(oe.innerHTML=vl),wt=i(e),ie=n(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-3m9y73"&&(ie.textContent=_l),ft=i(e),re=n(e,"UL",{"data-svelte-h":!0}),p(re)!=="svelte-zj5lmn"&&(re.innerHTML=kl),Tt=i(e),he=n(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-p8rs76"&&(he.innerHTML=xl),bt=i(e),I=n(e,"H2",{class:!0});var Pt=c(I);H=n(Pt,"A",{id:!0,class:!0,href:!0});var oa=c(H);Le=n(oa,"SPAN",{});var ia=c(Le);M(pe.$$.fragment,ia),ia.forEach(t),oa.forEach(t),nl=i(Pt),Ee=n(Pt,"SPAN",{"data-svelte-h":!0}),p(Ee)!=="svelte-16evagz"&&(Ee.textContent=Al),Pt.forEach(t),Jt=i(e),ce=n(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1uvlinw"&&(ce.innerHTML=Bl),jt=i(e),de=n(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1memefn"&&(de.innerHTML=Zl),Ut=i(e),Me=n(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-sn3bvf"&&(Me.innerHTML=Gl),gt=i(e),ue=n(e,"OL",{"data-svelte-h":!0}),p(ue)!=="svelte-134aape"&&(ue.innerHTML=Hl),It=i(e),me=n(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1rpcp8e"&&(me.innerHTML=El),Ct=i(e),C=n(e,"H3",{class:!0});var qt=c(C);E=n(qt,"A",{id:!0,class:!0,href:!0});var ra=c(E);ze=n(ra,"SPAN",{});var ha=c(ze);M(ye.$$.fragment,ha),ha.forEach(t),ra.forEach(t),ol=i(qt),We=n(qt,"SPAN",{"data-svelte-h":!0}),p(We)!=="svelte-5f6inm"&&(We.textContent=Wl),qt.forEach(t),vt=i(e),we=n(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-sa76vx"&&(we.innerHTML=$l),_t=i(e),v=n(e,"H4",{class:!0});var Kt=c(v);W=n(Kt,"A",{id:!0,class:!0,href:!0});var pa=c(W);Pe=n(pa,"SPAN",{});var ca=c(Pe);M(fe.$$.fragment,ca),ca.forEach(t),pa.forEach(t),il=i(Kt),$e=n(Kt,"SPAN",{"data-svelte-h":!0}),p($e)!=="svelte-1jqcfaj"&&($e.textContent=Yl),Kt.forEach(t),kt=i(e),Te=n(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-l2ktl8"&&(Te.textContent=Sl),xt=i(e),M(be.$$.fragment,e),At=i(e),_=n(e,"H4",{class:!0});var Dt=c(_);$=n(Dt,"A",{id:!0,class:!0,href:!0});var da=c($);qe=n(da,"SPAN",{});var Ma=c(qe);M(Je.$$.fragment,Ma),Ma.forEach(t),da.forEach(t),rl=i(Dt),Ye=n(Dt,"SPAN",{"data-svelte-h":!0}),p(Ye)!=="svelte-95uh9b"&&(Ye.textContent=Rl),Dt.forEach(t),Bt=i(e),je=n(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-l2iz9k"&&(je.innerHTML=Xl),Zt=i(e),Ue=n(e,"OL",{"data-svelte-h":!0}),p(Ue)!=="svelte-1a9vqht"&&(Ue.innerHTML=Vl),Gt=i(e),M(ge.$$.fragment,e),Ht=i(e),Y=n(e,"OL",{start:!0,"data-svelte-h":!0}),p(Y)!=="svelte-mclxy5"&&(Y.innerHTML=Ql),Et=i(e),M(Ie.$$.fragment,e),Wt=i(e),S=n(e,"OL",{start:!0,"data-svelte-h":!0}),p(S)!=="svelte-1vfuaub"&&(S.innerHTML=Nl),$t=i(e),M(Ce.$$.fragment,e),Yt=i(e),ve=n(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-zuw9zy"&&(ve.textContent=Fl),St=i(e),k=n(e,"H2",{class:!0});var Ot=c(k);R=n(Ot,"A",{id:!0,class:!0,href:!0});var ua=c(R);Ke=n(ua,"SPAN",{});var ma=c(Ke);M(_e.$$.fragment,ma),ma.forEach(t),ua.forEach(t),hl=i(Ot),Se=n(Ot,"SPAN",{"data-svelte-h":!0}),p(Se)!=="svelte-1nbzn7l"&&(Se.textContent=Ll),Ot.forEach(t),Rt=i(e),ke=n(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1qi11kl"&&(ke.textContent=zl),Xt=i(e),xe=n(e,"TABLE",{"data-svelte-h":!0}),p(xe)!=="svelte-1eqnjwl"&&(xe.innerHTML=Pl),this.h()},h(){r(T,"name","hf:doc:metadata"),r(T,"content",JSON.stringify(Ua)),r(x,"id","integrate-any-ml-framework-with-the-hub"),r(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(x,"href","#integrate-any-ml-framework-with-the-hub"),r(b,"class","relative group"),r(A,"id","a-flexible-approach-helpers"),r(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(A,"href","#a-flexible-approach-helpers"),r(J,"class","relative group"),r(B,"id","frompretrained"),r(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(B,"href","#frompretrained"),r(j,"class","relative group"),r(Z,"id","pushtohub"),r(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Z,"href","#pushtohub"),r(U,"class","relative group"),r(G,"id","limitations"),r(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(G,"href","#limitations"),r(g,"class","relative group"),r(H,"id","a-more-complex-approach-class-inheritance"),r(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(H,"href","#a-more-complex-approach-class-inheritance"),r(I,"class","relative group"),r(E,"id","a-concrete-example-pytorch"),r(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(E,"href","#a-concrete-example-pytorch"),r(C,"class","relative group"),r(W,"id","how-to-use-it"),r(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(W,"href","#how-to-use-it"),r(v,"class","relative group"),r($,"id","implementation"),r($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r($,"href","#implementation"),r(_,"class","relative group"),r(Y,"start","2"),r(S,"start","3"),r(R,"id","quick-comparison"),r(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(R,"href","#quick-comparison"),r(k,"class","relative group")},m(e,l){h(document.head,T),a(e,De,l),a(e,b,l),h(b,x),h(x,Xe),u(X,Xe,null),h(b,el),h(b,Ae),a(e,Oe,l),a(e,V,l),a(e,et,l),a(e,Q,l),a(e,tt,l),a(e,N,l),a(e,lt,l),a(e,F,l),a(e,at,l),a(e,L,l),a(e,st,l),a(e,J,l),h(J,A),h(A,Ve),u(z,Ve,null),h(J,tl),h(J,Be),a(e,nt,l),a(e,P,l),a(e,ot,l),a(e,q,l),a(e,it,l),a(e,j,l),h(j,B),h(B,Qe),u(K,Qe,null),h(j,ll),h(j,Ze),a(e,rt,l),a(e,D,l),a(e,ht,l),u(O,e,l),a(e,pt,l),a(e,U,l),h(U,Z),h(Z,Ne),u(ee,Ne,null),h(U,al),h(U,Ge),a(e,ct,l),a(e,te,l),a(e,dt,l),u(le,e,l),a(e,Mt,l),a(e,ae,l),a(e,ut,l),a(e,g,l),h(g,G),h(G,Fe),u(se,Fe,null),h(g,sl),h(g,He),a(e,mt,l),a(e,ne,l),a(e,yt,l),a(e,oe,l),a(e,wt,l),a(e,ie,l),a(e,ft,l),a(e,re,l),a(e,Tt,l),a(e,he,l),a(e,bt,l),a(e,I,l),h(I,H),h(H,Le),u(pe,Le,null),h(I,nl),h(I,Ee),a(e,Jt,l),a(e,ce,l),a(e,jt,l),a(e,de,l),a(e,Ut,l),a(e,Me,l),a(e,gt,l),a(e,ue,l),a(e,It,l),a(e,me,l),a(e,Ct,l),a(e,C,l),h(C,E),h(E,ze),u(ye,ze,null),h(C,ol),h(C,We),a(e,vt,l),a(e,we,l),a(e,_t,l),a(e,v,l),h(v,W),h(W,Pe),u(fe,Pe,null),h(v,il),h(v,$e),a(e,kt,l),a(e,Te,l),a(e,xt,l),u(be,e,l),a(e,At,l),a(e,_,l),h(_,$),h($,qe),u(Je,qe,null),h(_,rl),h(_,Ye),a(e,Bt,l),a(e,je,l),a(e,Zt,l),a(e,Ue,l),a(e,Gt,l),u(ge,e,l),a(e,Ht,l),a(e,Y,l),a(e,Et,l),u(Ie,e,l),a(e,Wt,l),a(e,S,l),a(e,$t,l),u(Ce,e,l),a(e,Yt,l),a(e,ve,l),a(e,St,l),a(e,k,l),h(k,R),h(R,Ke),u(_e,Ke,null),h(k,hl),h(k,Se),a(e,Rt,l),a(e,ke,l),a(e,Xt,l),a(e,xe,l),Vt=!0},p:wa,i(e){Vt||(m(X.$$.fragment,e),m(z.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(pe.$$.fragment,e),m(ye.$$.fragment,e),m(fe.$$.fragment,e),m(be.$$.fragment,e),m(Je.$$.fragment,e),m(ge.$$.fragment,e),m(Ie.$$.fragment,e),m(Ce.$$.fragment,e),m(_e.$$.fragment,e),Vt=!0)},o(e){y(X.$$.fragment,e),y(z.$$.fragment,e),y(K.$$.fragment,e),y(O.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(se.$$.fragment,e),y(pe.$$.fragment,e),y(ye.$$.fragment,e),y(fe.$$.fragment,e),y(be.$$.fragment,e),y(Je.$$.fragment,e),y(ge.$$.fragment,e),y(Ie.$$.fragment,e),y(Ce.$$.fragment,e),y(_e.$$.fragment,e),Vt=!1},d(e){e&&(t(De),t(b),t(Oe),t(V),t(et),t(Q),t(tt),t(N),t(lt),t(F),t(at),t(L),t(st),t(J),t(nt),t(P),t(ot),t(q),t(it),t(j),t(rt),t(D),t(ht),t(pt),t(U),t(ct),t(te),t(dt),t(Mt),t(ae),t(ut),t(g),t(mt),t(ne),t(yt),t(oe),t(wt),t(ie),t(ft),t(re),t(Tt),t(he),t(bt),t(I),t(Jt),t(ce),t(jt),t(de),t(Ut),t(Me),t(gt),t(ue),t(It),t(me),t(Ct),t(C),t(vt),t(we),t(_t),t(v),t(kt),t(Te),t(xt),t(At),t(_),t(Bt),t(je),t(Zt),t(Ue),t(Gt),t(Ht),t(Y),t(Et),t(Wt),t(S),t($t),t(Yt),t(ve),t(St),t(k),t(Rt),t(ke),t(Xt),t(xe)),t(T),w(X),w(z),w(K),w(O,e),w(ee),w(le,e),w(se),w(pe),w(ye),w(fe),w(be,e),w(Je),w(ge,e),w(Ie,e),w(Ce,e),w(_e)}}}const Ua={local:"integrate-any-ml-framework-with-the-hub",sections:[{local:"a-flexible-approach-helpers",sections:[{local:"frompretrained",title:"from_pretrained"},{local:"pushtohub",title:"push_to_hub"},{local:"limitations",title:"Limitations"}],title:"A flexible approach: helpers"},{local:"a-more-complex-approach-class-inheritance",sections:[{local:"a-concrete-example-pytorch",sections:[{local:"how-to-use-it",title:"How to use it?"},{local:"implementation",title:"Implementation"}],title:"A concrete example: PyTorch"}],title:"A more complex approach: class inheritance"},{local:"quick-comparison",title:"Quick comparison"}],title:"Integrate any ML framework with the Hub"};function ga(pl){return fa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ka extends Ta{constructor(T){super(),ba(this,T,ga,ja,ya,{})}}export{ka as component};
