import{s as mn,o as yn,n as vn}from"../chunks/scheduler.6062bdaf.js";import{S as wn,i as _n,g as l,s as r,r as u,A as bn,h as n,f as t,c as o,j as h,u as g,x as c,k as i,y as p,a as s,v as f,d,t as m,w as y}from"../chunks/index.4bca734e.js";import{T as $n}from"../chunks/Tip.b9ac1f03.js";import{I as w}from"../chunks/IconCopyLink.68a13644.js";import{C as _}from"../chunks/CodeBlock.f213e6a5.js";function Mn(zt){let v,ae=`If you are used to working with platforms such as GitLab/GitHub/Bitbucket, your first instinct
might be to use <code>git</code> CLI to clone your repo (<code>git clone</code>), commit changes (<code>git add, git commit</code>) and push them
(<code>git push</code>). This is valid when using the Hugging Face Hub. However, software engineering and machine learning do
not share the same requirements and workflows. Model repositories might maintain large model weight files for different
frameworks and tools, so cloning the repository can lead to you maintaining large local folders with massive sizes. As
a result, it may be more efficient to use our custom HTTP methods. You can read our <a href="../concepts/git_vs_http">Git vs HTTP paradigm</a>
explanation page for more details.`;return{c(){v=l("p"),v.innerHTML=ae},l(b){v=n(b,"P",{"data-svelte-h":!0}),c(v)!=="svelte-7thk71"&&(v.innerHTML=ae)},m(b,$){s(b,v,$)},p:vn,d(b){b&&t(v)}}}function kn(zt){let v,ae,b,$,Zt,se,ks,dt,Ls="Create and manage a repository",Qt,le,Ps=`The Hugging Face Hub is a collection of git repositories. <a href="https://git-scm.com/" rel="nofollow">Git</a> is a widely used tool in software
development to easily version projects when working collaboratively. This guide will show you how to interact with the
repositories on the Hub, especially:`,Dt,ne,As="<li>Create and delete a repository.</li> <li>Manage branches and tags.</li> <li>Rename your repository.</li> <li>Update your repository visibility.</li> <li>Manage a local copy of your repository.</li>",Kt,q,Ot,re,Es=`If you want to create and manage a repository on the Hub, your machine must be logged in. If you are not, please refer to
<a href="../quick-start#login">this section</a>. In the rest of this guide, we will assume that your machine is logged in.`,ea,M,I,Ht,oe,js,mt,Fs="Repo creation and deletion",ta,ie,Bs=`The first step is to know how to create and delete repositories. You can only manage repositories that you own (under
your username namespace) or from organizations in which you have write permissions.`,aa,k,L,Nt,pe,xs,yt,Ws="Create a repository",sa,he,Vs='Create an empty repository with <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a> and give it a name with the <code>repo_id</code> parameter. The <code>repo_id</code> is your namespace followed by the repository name: <code>username_or_org/repo_name</code>.',la,ce,na,ue,zs='By default, <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a> creates a model repository. But you can use the <code>repo_type</code> parameter to specify another repository type. For example, if you want to create a dataset repository:',ra,ge,oa,fe,Qs="When you create a repository, you can set your repository visibility with the <code>private</code> parameter.",ia,de,pa,me,Ds='If you want to change the repository visibility at a later time, you can use the <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi.update_repo_visibility">update_repo_visibility()</a> function.',ha,j,P,Xt,ye,Ts,vt,Ks="Delete a repository",ca,ve,Os='Delete a repository with <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi.delete_repo">delete_repo()</a>. Make sure you want to delete a repository because this is an irreversible process!',ua,we,el="Specify the <code>repo_id</code> of the repository you want to delete:",ga,_e,fa,x,A,Yt,be,Js,wt,tl="Duplicate a repository (only for Spaces)",da,$e,al=`In some cases, you want to copy someone else’s repo to adapt it to your use case.
This is possible for Spaces using the <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi.duplicate_space">duplicate_space()</a> method. It will duplicate the whole repository.
You will still need to configure your own settings (hardware, sleep-time, storage, variables and secrets). Check out our <a href="./manage-spaces">Manage your Space</a> guide for more details.`,ma,Me,ya,T,E,Rt,ke,Cs,_t,sl="Upload and download files",va,je,ll="Now that you have created your repository, you are interested in pushing changes to it and downloading files from it.",wa,xe,nl=`These 2 topics deserve their own guides. Please refer to the <a href="./upload">upload</a> and the <a href="./download">download</a> guides
to learn how to use your repository.`,_a,J,F,St,Te,Us,bt,rl="Branches and tags",ba,Je,ol=`Git repositories often make use of branches to store different versions of a same repository.
Tags can also be used to flag a specific state of your repository, for example, when releasing a version.
More generally, branches and tags are referred as <a href="https://git-scm.com/book/en/v2/Git-Internals-Git-References" rel="nofollow">git references</a>.`,$a,C,B,qt,Ce,Gs,$t,il="Create branches and tags",Ma,Ue,pl='You can create new branch and tags using <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi.create_branch">create_branch()</a> and <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi.create_tag">create_tag()</a>:',ka,Ge,ja,Ze,hl='You can use the <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi.delete_branch">delete_branch()</a> and <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi.delete_tag">delete_tag()</a> functions in the same way to delete a branch or a tag.',xa,U,W,It,He,Zs,Mt,cl="List all branches and tags",Ta,Ne,ul='You can also list the existing git refs from a repository using <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi.list_repo_refs">list_repo_refs()</a>:',Ja,Xe,Ca,G,V,Lt,Ye,Hs,kt,gl="Change repository settings",Ua,Re,fl=`Repositories come with some settings that you can configure. Most of the time, you will want to do that manually in the
repo settings page in your browser. You must have write access to a repo to configure it (either own it or being part of
an organization). In this section, we will see the settings that you can also configure programmatically using <code>huggingface_hub</code>.`,Ga,Se,dl='Some settings are specific to Spaces (hardware, environment variables,…). To configure those, please refer to our <a href="../guides/manage-spaces">Manage your Spaces</a> guide.',Za,Z,z,Pt,qe,Ns,jt,ml="Update visibility",Ha,Ie,yl="A repository can be public or private. A private repository is only visible to you or members of the organization in which the repository is located. Change a repository to private as shown in the following:",Na,Le,Xa,H,Q,At,Pe,Xs,xt,vl="Rename your repository",Ya,Ae,wl=`You can rename your repository on the Hub using <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi.move_repo">move_repo()</a>. Using this method, you can also move the repo from a user to
an organization. When doing so, there are a <a href="https://hf.co/docs/hub/repositories-settings#renaming-or-transferring-a-repo" rel="nofollow">few limitations</a>
that you should be aware of. For example, you can’t transfer your repo to another user.`,Ra,Ee,Sa,N,D,Et,Fe,Ys,Tt,_l="Manage a local copy of your repository",qa,Be,bl=`All the actions described above can be done using HTTP requests. However, in some cases you might be interested in having
a local copy of your repository and interact with it using the Git commands you are familiar with.`,Ia,We,$l=`The <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/repository#huggingface_hub.Repository">Repository</a> class allows you to interact with files and repositories on the Hub with functions similar to Git commands.
It is a wrapper over Git and Git-LFS methods to use the Git commands you already know and love. Before starting, please make
sure you have Git-LFS installed (see <a href="https://git-lfs.github.com/" rel="nofollow">here</a> for installation instructions).`,La,X,K,Ft,Ve,Rs,Jt,Ml="Use a local repository",Pa,ze,kl='Instantiate a <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/repository#huggingface_hub.Repository">Repository</a> object with a path to a local repository:',Aa,Qe,Ea,Y,O,Bt,De,Ss,Ct,jl="Clone",Fa,Ke,xl="The <code>clone_from</code> parameter clones a repository from a Hugging Face repository ID to a local directory specified by the <code>local_dir</code> argument:",Ba,Oe,Wa,et,Tl="<code>clone_from</code> can also clone a repository using a URL:",Va,tt,za,at,Jl='You can combine the <code>clone_from</code> parameter with <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a> to create and clone a repository:',Qa,st,Da,lt,Cl="You can also configure a Git username and email to a cloned repository by specifying the <code>git_user</code> and <code>git_email</code> parameters when you clone a repository. When users commit to that repository, Git will be aware of the commit author.",Ka,nt,Oa,R,ee,Wt,rt,qs,Ut,Ul="Branch",es,ot,Gl='Branches are important for collaboration and experimentation without impacting your current files and code. Switch between branches with <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/repository#huggingface_hub.Repository.git_checkout">git_checkout()</a>. For example, if you want to switch from <code>branch1</code> to <code>branch2</code>:',ts,it,as,S,te,Vt,pt,Is,Gt,Zl="Pull",ss,ht,Hl='<a href="/docs/huggingface_hub/v0.17.3/en/package_reference/repository#huggingface_hub.Repository.git_pull">git_pull()</a> allows you to update a current local branch with changes from a remote repository:',ls,ct,ns,ut,Nl="Set <code>rebase=True</code> if you want your local commits to occur after your branch is updated with the new commits from the remote:",rs,gt,os;return se=new w({}),q=new $n({props:{warning:!0,$$slots:{default:[Mn]},$$scope:{ctx:zt}}}),oe=new w({}),pe=new w({}),ce=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LW1vZGVsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-model&quot;</span>)
<span class="hljs-string">&#x27;https://huggingface.co/lysandre/test-model&#x27;</span>`}}),ge=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LWRhdGFzZXQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;https://huggingface.co/datasets/lysandre/test-dataset&#x27;</span>`}}),de=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LXByaXZhdGUlMjIlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-private&quot;</span>, private=<span class="hljs-literal">True</span>)`}}),ye=new w({}),_e=new _({props:{code:"ZGVsZXRlX3JlcG8ocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGbXktY29ycnVwdGVkLWRhdGFzZXQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>delete_repo(repo_id=<span class="hljs-string">&quot;lysandre/my-corrupted-dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)'}}),be=new w({}),Me=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGR1cGxpY2F0ZV9zcGFjZSUwQWR1cGxpY2F0ZV9zcGFjZSglMjJtdWx0aW1vZGFsYXJ0JTJGZHJlYW1ib290aC10cmFpbmluZyUyMiUyQyUyMHByaXZhdGUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> duplicate_space
<span class="hljs-meta">&gt;&gt;&gt; </span>duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>, private=<span class="hljs-literal">False</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/spaces/nateraw/dreambooth-training&#x27;</span>,...)`}}),ke=new w({}),Te=new w({}),Ce=new w({}),Ge=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9icmFuY2glMkMlMjBjcmVhdGVfdGFnJTBBJTBBY3JlYXRlX2JyYW5jaCglMjJNYXR0aGlqcyUyRnNwZWVjaHQ1LXR0cy1kZW1vJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMjBicmFuY2glM0QlMjJoYW5kbGUtZG9nLXNwZWFrZXIlMjIpJTBBJTBBY3JlYXRlX2JyYW5jaCglMjJiaWdjb2RlJTJGdGhlLXN0YWNrJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUyMHJldmlzaW9uJTNEJTIydjAuMS1yZWxlYXNlJTIyJTJDJTIwdGFnJTNEJTIydjAuMS4xJTIyJTJDJTIwdGFnX21lc3NhZ2UlM0QlMjJCdW1wJTIwcmVsZWFzZSUyMHZlcnNpb24uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_branch, create_tag

<span class="hljs-comment"># Create a branch on a Space repo from \`main\` branch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_branch(<span class="hljs-string">&quot;Matthijs/speecht5-tts-demo&quot;</span>, repo_type=<span class="hljs-string">&quot;space&quot;</span>, branch=<span class="hljs-string">&quot;handle-dog-speaker&quot;</span>)

<span class="hljs-comment"># Create a tag on a Dataset repo from \`v0.1-release\` branch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_branch(<span class="hljs-string">&quot;bigcode/the-stack&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, revision=<span class="hljs-string">&quot;v0.1-release&quot;</span>, tag=<span class="hljs-string">&quot;v0.1.1&quot;</span>, tag_message=<span class="hljs-string">&quot;Bump release version.&quot;</span>)`}}),He=new w({}),Xe=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVwb19yZWZzJTBBYXBpLmxpc3RfcmVwb19yZWZzKCUyMmJpZ2NvZGUlMkZ0aGUtc3RhY2slMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_repo_refs
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_repo_refs(<span class="hljs-string">&quot;bigcode/the-stack&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
GitRefs(
   branches=[
         GitRefInfo(name=<span class="hljs-string">&#x27;main&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>, target_commit=<span class="hljs-string">&#x27;18edc1591d9ce72aa82f56c4431b3c969b210ae3&#x27;</span>),
         GitRefInfo(name=<span class="hljs-string">&#x27;v1.1.a1&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/v1.1.a1&#x27;</span>, target_commit=<span class="hljs-string">&#x27;f9826b862d1567f3822d3d25649b0d6d22ace714&#x27;</span>)
   ],
   converts=[],
   tags=[
         GitRefInfo(name=<span class="hljs-string">&#x27;v1.0&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/tags/v1.0&#x27;</span>, target_commit=<span class="hljs-string">&#x27;c37a8cd1e382064d8aced5e05543c5f7753834da&#x27;</span>)
   ]
)`}}),Ye=new w({}),qe=new w({}),Le=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV9yZXBvX3Zpc2liaWxpdHklMEF1cGRhdGVfcmVwb192aXNpYmlsaXR5KHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwcHJpdmF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_repo_visibility
<span class="hljs-meta">&gt;&gt;&gt; </span>update_repo_visibility(repo_id=repo_id, private=<span class="hljs-literal">True</span>)`}}),Pe=new w({}),Ee=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1vdmVfcmVwbyUwQW1vdmVfcmVwbyhmcm9tX2lkJTNEJTIyV2F1cGxpbiUyRmNvb2wtbW9kZWwlMjIlMkMlMjB0b19pZCUzRCUyMmh1Z2dpbmdmYWNlJTJGY29vbC1tb2RlbCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> move_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>move_repo(from_id=<span class="hljs-string">&quot;Wauplin/cool-model&quot;</span>, to_id=<span class="hljs-string">&quot;huggingface/cool-model&quot;</span>)`}}),Fe=new w({}),Ve=new w({}),Qe=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjIlM0NwYXRoJTNFJTJGJTNDdG8lM0UlMkYlM0Nmb2xkZXIlM0UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;&lt;path&gt;/&lt;to&gt;/&lt;folder&gt;&quot;</span>)`}}),De=new w({}),Oe=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjJ3MnYyJTIyJTJDJTIwY2xvbmVfZnJvbSUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItbGFyZ2UtOTYwaC1sdjYwJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;w2v2&quot;</span>, clone_from=<span class="hljs-string">&quot;facebook/wav2vec2-large-960h-lv60&quot;</span>)`}}),tt=new _({props:{code:"cmVwbyUyMCUzRCUyMFJlcG9zaXRvcnkobG9jYWxfZGlyJTNEJTIyaHVnZ2luZ2ZhY2UtaHViJTIyJTJDJTIwY2xvbmVfZnJvbSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;huggingface-hub&quot;</span>, clone_from=<span class="hljs-string">&quot;https://huggingface.co/facebook/wav2vec2-large-960h-lv60&quot;</span>)'}}),st=new _({props:{code:"cmVwb191cmwlMjAlM0QlMjBjcmVhdGVfcmVwbyhyZXBvX2lkJTNEJTIycmVwb19uYW1lJTIyKSUwQXJlcG8lMjAlM0QlMjBSZXBvc2l0b3J5KGxvY2FsX2RpciUzRCUyMnJlcG9fbG9jYWxfcGF0aCUyMiUyQyUyMGNsb25lX2Zyb20lM0RyZXBvX3VybCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>repo_url = create_repo(repo_id=<span class="hljs-string">&quot;repo_name&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;repo_local_path&quot;</span>, clone_from=repo_url)`}}),nt=new _({props:{code:"cmVwbyUyMCUzRCUyMFJlcG9zaXRvcnkoJTBBJTIwJTIwJTIybXktZGF0YXNldCUyMiUyQyUwQSUyMCUyMGNsb25lX2Zyb20lM0QlMjIlM0N1c2VyJTNFJTJGJTNDZGF0YXNldF9pZCUzRSUyMiUyQyUwQSUyMCUyMHRva2VuJTNEVHJ1ZSUyQyUwQSUyMCUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMEElMjAlMjBnaXRfdXNlciUzRCUyMk15TmFtZSUyMiUyQyUwQSUyMCUyMGdpdF9lbWFpbCUzRCUyMm1lJTQwY29vbC5tYWlsJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;my-dataset&quot;</span>,
<span class="hljs-meta">... </span>  clone_from=<span class="hljs-string">&quot;&lt;user&gt;/&lt;dataset_id&gt;&quot;</span>,
<span class="hljs-meta">... </span>  token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>  repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>  git_user=<span class="hljs-string">&quot;MyName&quot;</span>,
<span class="hljs-meta">... </span>  git_email=<span class="hljs-string">&quot;me@cool.mail&quot;</span>
<span class="hljs-meta">... </span>)`}}),rt=new w({}),it=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjJodWdnaW5nZmFjZS1odWIlMjIlMkMlMjBjbG9uZV9mcm9tJTNEJTIyJTNDdXNlciUzRSUyRiUzQ2RhdGFzZXRfaWQlM0UlMjIlMkMlMjByZXZpc2lvbiUzRCdicmFuY2gxJyklMEFyZXBvLmdpdF9jaGVja291dCglMjJicmFuY2gyJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;huggingface-hub&quot;</span>, clone_from=<span class="hljs-string">&quot;&lt;user&gt;/&lt;dataset_id&gt;&quot;</span>, revision=<span class="hljs-string">&#x27;branch1&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_checkout(<span class="hljs-string">&quot;branch2&quot;</span>)`}}),pt=new w({}),ct=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvLmdpdF9wdWxsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_pull()`}}),gt=new _({props:{code:"cmVwby5naXRfcHVsbChyZWJhc2UlM0RUcnVlKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_pull(rebase=<span class="hljs-literal">True</span>)'}}),{c(){v=l("meta"),ae=r(),b=l("h1"),$=l("a"),Zt=l("span"),u(se.$$.fragment),ks=r(),dt=l("span"),dt.textContent=Ls,Qt=r(),le=l("p"),le.innerHTML=Ps,Dt=r(),ne=l("ul"),ne.innerHTML=As,Kt=r(),u(q.$$.fragment),Ot=r(),re=l("p"),re.innerHTML=Es,ea=r(),M=l("h2"),I=l("a"),Ht=l("span"),u(oe.$$.fragment),js=r(),mt=l("span"),mt.textContent=Fs,ta=r(),ie=l("p"),ie.textContent=Bs,aa=r(),k=l("h3"),L=l("a"),Nt=l("span"),u(pe.$$.fragment),xs=r(),yt=l("span"),yt.textContent=Ws,sa=r(),he=l("p"),he.innerHTML=Vs,la=r(),u(ce.$$.fragment),na=r(),ue=l("p"),ue.innerHTML=zs,ra=r(),u(ge.$$.fragment),oa=r(),fe=l("p"),fe.innerHTML=Qs,ia=r(),u(de.$$.fragment),pa=r(),me=l("p"),me.innerHTML=Ds,ha=r(),j=l("h3"),P=l("a"),Xt=l("span"),u(ye.$$.fragment),Ts=r(),vt=l("span"),vt.textContent=Ks,ca=r(),ve=l("p"),ve.innerHTML=Os,ua=r(),we=l("p"),we.innerHTML=el,ga=r(),u(_e.$$.fragment),fa=r(),x=l("h3"),A=l("a"),Yt=l("span"),u(be.$$.fragment),Js=r(),wt=l("span"),wt.textContent=tl,da=r(),$e=l("p"),$e.innerHTML=al,ma=r(),u(Me.$$.fragment),ya=r(),T=l("h2"),E=l("a"),Rt=l("span"),u(ke.$$.fragment),Cs=r(),_t=l("span"),_t.textContent=sl,va=r(),je=l("p"),je.textContent=ll,wa=r(),xe=l("p"),xe.innerHTML=nl,_a=r(),J=l("h2"),F=l("a"),St=l("span"),u(Te.$$.fragment),Us=r(),bt=l("span"),bt.textContent=rl,ba=r(),Je=l("p"),Je.innerHTML=ol,$a=r(),C=l("h3"),B=l("a"),qt=l("span"),u(Ce.$$.fragment),Gs=r(),$t=l("span"),$t.textContent=il,Ma=r(),Ue=l("p"),Ue.innerHTML=pl,ka=r(),u(Ge.$$.fragment),ja=r(),Ze=l("p"),Ze.innerHTML=hl,xa=r(),U=l("h3"),W=l("a"),It=l("span"),u(He.$$.fragment),Zs=r(),Mt=l("span"),Mt.textContent=cl,Ta=r(),Ne=l("p"),Ne.innerHTML=ul,Ja=r(),u(Xe.$$.fragment),Ca=r(),G=l("h2"),V=l("a"),Lt=l("span"),u(Ye.$$.fragment),Hs=r(),kt=l("span"),kt.textContent=gl,Ua=r(),Re=l("p"),Re.innerHTML=fl,Ga=r(),Se=l("p"),Se.innerHTML=dl,Za=r(),Z=l("h3"),z=l("a"),Pt=l("span"),u(qe.$$.fragment),Ns=r(),jt=l("span"),jt.textContent=ml,Ha=r(),Ie=l("p"),Ie.textContent=yl,Na=r(),u(Le.$$.fragment),Xa=r(),H=l("h3"),Q=l("a"),At=l("span"),u(Pe.$$.fragment),Xs=r(),xt=l("span"),xt.textContent=vl,Ya=r(),Ae=l("p"),Ae.innerHTML=wl,Ra=r(),u(Ee.$$.fragment),Sa=r(),N=l("h2"),D=l("a"),Et=l("span"),u(Fe.$$.fragment),Ys=r(),Tt=l("span"),Tt.textContent=_l,qa=r(),Be=l("p"),Be.textContent=bl,Ia=r(),We=l("p"),We.innerHTML=$l,La=r(),X=l("h3"),K=l("a"),Ft=l("span"),u(Ve.$$.fragment),Rs=r(),Jt=l("span"),Jt.textContent=Ml,Pa=r(),ze=l("p"),ze.innerHTML=kl,Aa=r(),u(Qe.$$.fragment),Ea=r(),Y=l("h3"),O=l("a"),Bt=l("span"),u(De.$$.fragment),Ss=r(),Ct=l("span"),Ct.textContent=jl,Fa=r(),Ke=l("p"),Ke.innerHTML=xl,Ba=r(),u(Oe.$$.fragment),Wa=r(),et=l("p"),et.innerHTML=Tl,Va=r(),u(tt.$$.fragment),za=r(),at=l("p"),at.innerHTML=Jl,Qa=r(),u(st.$$.fragment),Da=r(),lt=l("p"),lt.innerHTML=Cl,Ka=r(),u(nt.$$.fragment),Oa=r(),R=l("h3"),ee=l("a"),Wt=l("span"),u(rt.$$.fragment),qs=r(),Ut=l("span"),Ut.textContent=Ul,es=r(),ot=l("p"),ot.innerHTML=Gl,ts=r(),u(it.$$.fragment),as=r(),S=l("h3"),te=l("a"),Vt=l("span"),u(pt.$$.fragment),Is=r(),Gt=l("span"),Gt.textContent=Zl,ss=r(),ht=l("p"),ht.innerHTML=Hl,ls=r(),u(ct.$$.fragment),ns=r(),ut=l("p"),ut.innerHTML=Nl,rs=r(),u(gt.$$.fragment),this.h()},l(e){const a=bn("svelte-1phssyn",document.head);v=n(a,"META",{name:!0,content:!0}),a.forEach(t),ae=o(e),b=n(e,"H1",{class:!0});var ft=h(b);$=n(ft,"A",{id:!0,class:!0,href:!0});var Xl=h($);Zt=n(Xl,"SPAN",{});var Yl=h(Zt);g(se.$$.fragment,Yl),Yl.forEach(t),Xl.forEach(t),ks=o(ft),dt=n(ft,"SPAN",{"data-svelte-h":!0}),c(dt)!=="svelte-1abadk6"&&(dt.textContent=Ls),ft.forEach(t),Qt=o(e),le=n(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-15r6soe"&&(le.innerHTML=Ps),Dt=o(e),ne=n(e,"UL",{"data-svelte-h":!0}),c(ne)!=="svelte-zmlzlm"&&(ne.innerHTML=As),Kt=o(e),g(q.$$.fragment,e),Ot=o(e),re=n(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-ybftem"&&(re.innerHTML=Es),ea=o(e),M=n(e,"H2",{class:!0});var is=h(M);I=n(is,"A",{id:!0,class:!0,href:!0});var Rl=h(I);Ht=n(Rl,"SPAN",{});var Sl=h(Ht);g(oe.$$.fragment,Sl),Sl.forEach(t),Rl.forEach(t),js=o(is),mt=n(is,"SPAN",{"data-svelte-h":!0}),c(mt)!=="svelte-1cpakbv"&&(mt.textContent=Fs),is.forEach(t),ta=o(e),ie=n(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-1yl5xsc"&&(ie.textContent=Bs),aa=o(e),k=n(e,"H3",{class:!0});var ps=h(k);L=n(ps,"A",{id:!0,class:!0,href:!0});var ql=h(L);Nt=n(ql,"SPAN",{});var Il=h(Nt);g(pe.$$.fragment,Il),Il.forEach(t),ql.forEach(t),xs=o(ps),yt=n(ps,"SPAN",{"data-svelte-h":!0}),c(yt)!=="svelte-1sm7qry"&&(yt.textContent=Ws),ps.forEach(t),sa=o(e),he=n(e,"P",{"data-svelte-h":!0}),c(he)!=="svelte-lqwad9"&&(he.innerHTML=Vs),la=o(e),g(ce.$$.fragment,e),na=o(e),ue=n(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-1bwj71x"&&(ue.innerHTML=zs),ra=o(e),g(ge.$$.fragment,e),oa=o(e),fe=n(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-1lhlim8"&&(fe.innerHTML=Qs),ia=o(e),g(de.$$.fragment,e),pa=o(e),me=n(e,"P",{"data-svelte-h":!0}),c(me)!=="svelte-3s7w41"&&(me.innerHTML=Ds),ha=o(e),j=n(e,"H3",{class:!0});var hs=h(j);P=n(hs,"A",{id:!0,class:!0,href:!0});var Ll=h(P);Xt=n(Ll,"SPAN",{});var Pl=h(Xt);g(ye.$$.fragment,Pl),Pl.forEach(t),Ll.forEach(t),Ts=o(hs),vt=n(hs,"SPAN",{"data-svelte-h":!0}),c(vt)!=="svelte-9f8jhr"&&(vt.textContent=Ks),hs.forEach(t),ca=o(e),ve=n(e,"P",{"data-svelte-h":!0}),c(ve)!=="svelte-1pl1oj9"&&(ve.innerHTML=Os),ua=o(e),we=n(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-130g6n6"&&(we.innerHTML=el),ga=o(e),g(_e.$$.fragment,e),fa=o(e),x=n(e,"H3",{class:!0});var cs=h(x);A=n(cs,"A",{id:!0,class:!0,href:!0});var Al=h(A);Yt=n(Al,"SPAN",{});var El=h(Yt);g(be.$$.fragment,El),El.forEach(t),Al.forEach(t),Js=o(cs),wt=n(cs,"SPAN",{"data-svelte-h":!0}),c(wt)!=="svelte-jelyaq"&&(wt.textContent=tl),cs.forEach(t),da=o(e),$e=n(e,"P",{"data-svelte-h":!0}),c($e)!=="svelte-1cxsspu"&&($e.innerHTML=al),ma=o(e),g(Me.$$.fragment,e),ya=o(e),T=n(e,"H2",{class:!0});var us=h(T);E=n(us,"A",{id:!0,class:!0,href:!0});var Fl=h(E);Rt=n(Fl,"SPAN",{});var Bl=h(Rt);g(ke.$$.fragment,Bl),Bl.forEach(t),Fl.forEach(t),Cs=o(us),_t=n(us,"SPAN",{"data-svelte-h":!0}),c(_t)!=="svelte-mk4a0"&&(_t.textContent=sl),us.forEach(t),va=o(e),je=n(e,"P",{"data-svelte-h":!0}),c(je)!=="svelte-1sdwkqa"&&(je.textContent=ll),wa=o(e),xe=n(e,"P",{"data-svelte-h":!0}),c(xe)!=="svelte-1sqatlx"&&(xe.innerHTML=nl),_a=o(e),J=n(e,"H2",{class:!0});var gs=h(J);F=n(gs,"A",{id:!0,class:!0,href:!0});var Wl=h(F);St=n(Wl,"SPAN",{});var Vl=h(St);g(Te.$$.fragment,Vl),Vl.forEach(t),Wl.forEach(t),Us=o(gs),bt=n(gs,"SPAN",{"data-svelte-h":!0}),c(bt)!=="svelte-11r8q35"&&(bt.textContent=rl),gs.forEach(t),ba=o(e),Je=n(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-1rc0mjs"&&(Je.innerHTML=ol),$a=o(e),C=n(e,"H3",{class:!0});var fs=h(C);B=n(fs,"A",{id:!0,class:!0,href:!0});var zl=h(B);qt=n(zl,"SPAN",{});var Ql=h(qt);g(Ce.$$.fragment,Ql),Ql.forEach(t),zl.forEach(t),Gs=o(fs),$t=n(fs,"SPAN",{"data-svelte-h":!0}),c($t)!=="svelte-e4pebf"&&($t.textContent=il),fs.forEach(t),Ma=o(e),Ue=n(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-tdhjte"&&(Ue.innerHTML=pl),ka=o(e),g(Ge.$$.fragment,e),ja=o(e),Ze=n(e,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-1rwcdmj"&&(Ze.innerHTML=hl),xa=o(e),U=n(e,"H3",{class:!0});var ds=h(U);W=n(ds,"A",{id:!0,class:!0,href:!0});var Dl=h(W);It=n(Dl,"SPAN",{});var Kl=h(It);g(He.$$.fragment,Kl),Kl.forEach(t),Dl.forEach(t),Zs=o(ds),Mt=n(ds,"SPAN",{"data-svelte-h":!0}),c(Mt)!=="svelte-1x7kii"&&(Mt.textContent=cl),ds.forEach(t),Ta=o(e),Ne=n(e,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-t32lve"&&(Ne.innerHTML=ul),Ja=o(e),g(Xe.$$.fragment,e),Ca=o(e),G=n(e,"H2",{class:!0});var ms=h(G);V=n(ms,"A",{id:!0,class:!0,href:!0});var Ol=h(V);Lt=n(Ol,"SPAN",{});var en=h(Lt);g(Ye.$$.fragment,en),en.forEach(t),Ol.forEach(t),Hs=o(ms),kt=n(ms,"SPAN",{"data-svelte-h":!0}),c(kt)!=="svelte-oa1idq"&&(kt.textContent=gl),ms.forEach(t),Ua=o(e),Re=n(e,"P",{"data-svelte-h":!0}),c(Re)!=="svelte-1nx84sp"&&(Re.innerHTML=fl),Ga=o(e),Se=n(e,"P",{"data-svelte-h":!0}),c(Se)!=="svelte-16vpsz9"&&(Se.innerHTML=dl),Za=o(e),Z=n(e,"H3",{class:!0});var ys=h(Z);z=n(ys,"A",{id:!0,class:!0,href:!0});var tn=h(z);Pt=n(tn,"SPAN",{});var an=h(Pt);g(qe.$$.fragment,an),an.forEach(t),tn.forEach(t),Ns=o(ys),jt=n(ys,"SPAN",{"data-svelte-h":!0}),c(jt)!=="svelte-1vuziik"&&(jt.textContent=ml),ys.forEach(t),Ha=o(e),Ie=n(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-17yd1o0"&&(Ie.textContent=yl),Na=o(e),g(Le.$$.fragment,e),Xa=o(e),H=n(e,"H3",{class:!0});var vs=h(H);Q=n(vs,"A",{id:!0,class:!0,href:!0});var sn=h(Q);At=n(sn,"SPAN",{});var ln=h(At);g(Pe.$$.fragment,ln),ln.forEach(t),sn.forEach(t),Xs=o(vs),xt=n(vs,"SPAN",{"data-svelte-h":!0}),c(xt)!=="svelte-1n5mpc0"&&(xt.textContent=vl),vs.forEach(t),Ya=o(e),Ae=n(e,"P",{"data-svelte-h":!0}),c(Ae)!=="svelte-1jnmcek"&&(Ae.innerHTML=wl),Ra=o(e),g(Ee.$$.fragment,e),Sa=o(e),N=n(e,"H2",{class:!0});var ws=h(N);D=n(ws,"A",{id:!0,class:!0,href:!0});var nn=h(D);Et=n(nn,"SPAN",{});var rn=h(Et);g(Fe.$$.fragment,rn),rn.forEach(t),nn.forEach(t),Ys=o(ws),Tt=n(ws,"SPAN",{"data-svelte-h":!0}),c(Tt)!=="svelte-1abz8wt"&&(Tt.textContent=_l),ws.forEach(t),qa=o(e),Be=n(e,"P",{"data-svelte-h":!0}),c(Be)!=="svelte-y0ecwu"&&(Be.textContent=bl),Ia=o(e),We=n(e,"P",{"data-svelte-h":!0}),c(We)!=="svelte-1gp4vko"&&(We.innerHTML=$l),La=o(e),X=n(e,"H3",{class:!0});var _s=h(X);K=n(_s,"A",{id:!0,class:!0,href:!0});var on=h(K);Ft=n(on,"SPAN",{});var pn=h(Ft);g(Ve.$$.fragment,pn),pn.forEach(t),on.forEach(t),Rs=o(_s),Jt=n(_s,"SPAN",{"data-svelte-h":!0}),c(Jt)!=="svelte-1jmyz4e"&&(Jt.textContent=Ml),_s.forEach(t),Pa=o(e),ze=n(e,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-jy01tm"&&(ze.innerHTML=kl),Aa=o(e),g(Qe.$$.fragment,e),Ea=o(e),Y=n(e,"H3",{class:!0});var bs=h(Y);O=n(bs,"A",{id:!0,class:!0,href:!0});var hn=h(O);Bt=n(hn,"SPAN",{});var cn=h(Bt);g(De.$$.fragment,cn),cn.forEach(t),hn.forEach(t),Ss=o(bs),Ct=n(bs,"SPAN",{"data-svelte-h":!0}),c(Ct)!=="svelte-d0lu92"&&(Ct.textContent=jl),bs.forEach(t),Fa=o(e),Ke=n(e,"P",{"data-svelte-h":!0}),c(Ke)!=="svelte-1efx20p"&&(Ke.innerHTML=xl),Ba=o(e),g(Oe.$$.fragment,e),Wa=o(e),et=n(e,"P",{"data-svelte-h":!0}),c(et)!=="svelte-1kdxyrq"&&(et.innerHTML=Tl),Va=o(e),g(tt.$$.fragment,e),za=o(e),at=n(e,"P",{"data-svelte-h":!0}),c(at)!=="svelte-6k7ch4"&&(at.innerHTML=Jl),Qa=o(e),g(st.$$.fragment,e),Da=o(e),lt=n(e,"P",{"data-svelte-h":!0}),c(lt)!=="svelte-2rn2fx"&&(lt.innerHTML=Cl),Ka=o(e),g(nt.$$.fragment,e),Oa=o(e),R=n(e,"H3",{class:!0});var $s=h(R);ee=n($s,"A",{id:!0,class:!0,href:!0});var un=h(ee);Wt=n(un,"SPAN",{});var gn=h(Wt);g(rt.$$.fragment,gn),gn.forEach(t),un.forEach(t),qs=o($s),Ut=n($s,"SPAN",{"data-svelte-h":!0}),c(Ut)!=="svelte-1wf52a9"&&(Ut.textContent=Ul),$s.forEach(t),es=o(e),ot=n(e,"P",{"data-svelte-h":!0}),c(ot)!=="svelte-wjbj1u"&&(ot.innerHTML=Gl),ts=o(e),g(it.$$.fragment,e),as=o(e),S=n(e,"H3",{class:!0});var Ms=h(S);te=n(Ms,"A",{id:!0,class:!0,href:!0});var fn=h(te);Vt=n(fn,"SPAN",{});var dn=h(Vt);g(pt.$$.fragment,dn),dn.forEach(t),fn.forEach(t),Is=o(Ms),Gt=n(Ms,"SPAN",{"data-svelte-h":!0}),c(Gt)!=="svelte-17mgzoo"&&(Gt.textContent=Zl),Ms.forEach(t),ss=o(e),ht=n(e,"P",{"data-svelte-h":!0}),c(ht)!=="svelte-1fmnli2"&&(ht.innerHTML=Hl),ls=o(e),g(ct.$$.fragment,e),ns=o(e),ut=n(e,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-199y79p"&&(ut.innerHTML=Nl),rs=o(e),g(gt.$$.fragment,e),this.h()},h(){i(v,"name","hf:doc:metadata"),i(v,"content",JSON.stringify(jn)),i($,"id","create-and-manage-a-repository"),i($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i($,"href","#create-and-manage-a-repository"),i(b,"class","relative group"),i(I,"id","repo-creation-and-deletion"),i(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(I,"href","#repo-creation-and-deletion"),i(M,"class","relative group"),i(L,"id","create-a-repository"),i(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(L,"href","#create-a-repository"),i(k,"class","relative group"),i(P,"id","delete-a-repository"),i(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(P,"href","#delete-a-repository"),i(j,"class","relative group"),i(A,"id","duplicate-a-repository-only-for-spaces"),i(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(A,"href","#duplicate-a-repository-only-for-spaces"),i(x,"class","relative group"),i(E,"id","upload-and-download-files"),i(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(E,"href","#upload-and-download-files"),i(T,"class","relative group"),i(F,"id","branches-and-tags"),i(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(F,"href","#branches-and-tags"),i(J,"class","relative group"),i(B,"id","create-branches-and-tags"),i(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(B,"href","#create-branches-and-tags"),i(C,"class","relative group"),i(W,"id","list-all-branches-and-tags"),i(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(W,"href","#list-all-branches-and-tags"),i(U,"class","relative group"),i(V,"id","change-repository-settings"),i(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(V,"href","#change-repository-settings"),i(G,"class","relative group"),i(z,"id","update-visibility"),i(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(z,"href","#update-visibility"),i(Z,"class","relative group"),i(Q,"id","rename-your-repository"),i(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(Q,"href","#rename-your-repository"),i(H,"class","relative group"),i(D,"id","manage-a-local-copy-of-your-repository"),i(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(D,"href","#manage-a-local-copy-of-your-repository"),i(N,"class","relative group"),i(K,"id","use-a-local-repository"),i(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(K,"href","#use-a-local-repository"),i(X,"class","relative group"),i(O,"id","clone"),i(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(O,"href","#clone"),i(Y,"class","relative group"),i(ee,"id","branch"),i(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(ee,"href","#branch"),i(R,"class","relative group"),i(te,"id","pull"),i(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(te,"href","#pull"),i(S,"class","relative group")},m(e,a){p(document.head,v),s(e,ae,a),s(e,b,a),p(b,$),p($,Zt),f(se,Zt,null),p(b,ks),p(b,dt),s(e,Qt,a),s(e,le,a),s(e,Dt,a),s(e,ne,a),s(e,Kt,a),f(q,e,a),s(e,Ot,a),s(e,re,a),s(e,ea,a),s(e,M,a),p(M,I),p(I,Ht),f(oe,Ht,null),p(M,js),p(M,mt),s(e,ta,a),s(e,ie,a),s(e,aa,a),s(e,k,a),p(k,L),p(L,Nt),f(pe,Nt,null),p(k,xs),p(k,yt),s(e,sa,a),s(e,he,a),s(e,la,a),f(ce,e,a),s(e,na,a),s(e,ue,a),s(e,ra,a),f(ge,e,a),s(e,oa,a),s(e,fe,a),s(e,ia,a),f(de,e,a),s(e,pa,a),s(e,me,a),s(e,ha,a),s(e,j,a),p(j,P),p(P,Xt),f(ye,Xt,null),p(j,Ts),p(j,vt),s(e,ca,a),s(e,ve,a),s(e,ua,a),s(e,we,a),s(e,ga,a),f(_e,e,a),s(e,fa,a),s(e,x,a),p(x,A),p(A,Yt),f(be,Yt,null),p(x,Js),p(x,wt),s(e,da,a),s(e,$e,a),s(e,ma,a),f(Me,e,a),s(e,ya,a),s(e,T,a),p(T,E),p(E,Rt),f(ke,Rt,null),p(T,Cs),p(T,_t),s(e,va,a),s(e,je,a),s(e,wa,a),s(e,xe,a),s(e,_a,a),s(e,J,a),p(J,F),p(F,St),f(Te,St,null),p(J,Us),p(J,bt),s(e,ba,a),s(e,Je,a),s(e,$a,a),s(e,C,a),p(C,B),p(B,qt),f(Ce,qt,null),p(C,Gs),p(C,$t),s(e,Ma,a),s(e,Ue,a),s(e,ka,a),f(Ge,e,a),s(e,ja,a),s(e,Ze,a),s(e,xa,a),s(e,U,a),p(U,W),p(W,It),f(He,It,null),p(U,Zs),p(U,Mt),s(e,Ta,a),s(e,Ne,a),s(e,Ja,a),f(Xe,e,a),s(e,Ca,a),s(e,G,a),p(G,V),p(V,Lt),f(Ye,Lt,null),p(G,Hs),p(G,kt),s(e,Ua,a),s(e,Re,a),s(e,Ga,a),s(e,Se,a),s(e,Za,a),s(e,Z,a),p(Z,z),p(z,Pt),f(qe,Pt,null),p(Z,Ns),p(Z,jt),s(e,Ha,a),s(e,Ie,a),s(e,Na,a),f(Le,e,a),s(e,Xa,a),s(e,H,a),p(H,Q),p(Q,At),f(Pe,At,null),p(H,Xs),p(H,xt),s(e,Ya,a),s(e,Ae,a),s(e,Ra,a),f(Ee,e,a),s(e,Sa,a),s(e,N,a),p(N,D),p(D,Et),f(Fe,Et,null),p(N,Ys),p(N,Tt),s(e,qa,a),s(e,Be,a),s(e,Ia,a),s(e,We,a),s(e,La,a),s(e,X,a),p(X,K),p(K,Ft),f(Ve,Ft,null),p(X,Rs),p(X,Jt),s(e,Pa,a),s(e,ze,a),s(e,Aa,a),f(Qe,e,a),s(e,Ea,a),s(e,Y,a),p(Y,O),p(O,Bt),f(De,Bt,null),p(Y,Ss),p(Y,Ct),s(e,Fa,a),s(e,Ke,a),s(e,Ba,a),f(Oe,e,a),s(e,Wa,a),s(e,et,a),s(e,Va,a),f(tt,e,a),s(e,za,a),s(e,at,a),s(e,Qa,a),f(st,e,a),s(e,Da,a),s(e,lt,a),s(e,Ka,a),f(nt,e,a),s(e,Oa,a),s(e,R,a),p(R,ee),p(ee,Wt),f(rt,Wt,null),p(R,qs),p(R,Ut),s(e,es,a),s(e,ot,a),s(e,ts,a),f(it,e,a),s(e,as,a),s(e,S,a),p(S,te),p(te,Vt),f(pt,Vt,null),p(S,Is),p(S,Gt),s(e,ss,a),s(e,ht,a),s(e,ls,a),f(ct,e,a),s(e,ns,a),s(e,ut,a),s(e,rs,a),f(gt,e,a),os=!0},p(e,[a]){const ft={};a&2&&(ft.$$scope={dirty:a,ctx:e}),q.$set(ft)},i(e){os||(d(se.$$.fragment,e),d(q.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(ge.$$.fragment,e),d(de.$$.fragment,e),d(ye.$$.fragment,e),d(_e.$$.fragment,e),d(be.$$.fragment,e),d(Me.$$.fragment,e),d(ke.$$.fragment,e),d(Te.$$.fragment,e),d(Ce.$$.fragment,e),d(Ge.$$.fragment,e),d(He.$$.fragment,e),d(Xe.$$.fragment,e),d(Ye.$$.fragment,e),d(qe.$$.fragment,e),d(Le.$$.fragment,e),d(Pe.$$.fragment,e),d(Ee.$$.fragment,e),d(Fe.$$.fragment,e),d(Ve.$$.fragment,e),d(Qe.$$.fragment,e),d(De.$$.fragment,e),d(Oe.$$.fragment,e),d(tt.$$.fragment,e),d(st.$$.fragment,e),d(nt.$$.fragment,e),d(rt.$$.fragment,e),d(it.$$.fragment,e),d(pt.$$.fragment,e),d(ct.$$.fragment,e),d(gt.$$.fragment,e),os=!0)},o(e){m(se.$$.fragment,e),m(q.$$.fragment,e),m(oe.$$.fragment,e),m(pe.$$.fragment,e),m(ce.$$.fragment,e),m(ge.$$.fragment,e),m(de.$$.fragment,e),m(ye.$$.fragment,e),m(_e.$$.fragment,e),m(be.$$.fragment,e),m(Me.$$.fragment,e),m(ke.$$.fragment,e),m(Te.$$.fragment,e),m(Ce.$$.fragment,e),m(Ge.$$.fragment,e),m(He.$$.fragment,e),m(Xe.$$.fragment,e),m(Ye.$$.fragment,e),m(qe.$$.fragment,e),m(Le.$$.fragment,e),m(Pe.$$.fragment,e),m(Ee.$$.fragment,e),m(Fe.$$.fragment,e),m(Ve.$$.fragment,e),m(Qe.$$.fragment,e),m(De.$$.fragment,e),m(Oe.$$.fragment,e),m(tt.$$.fragment,e),m(st.$$.fragment,e),m(nt.$$.fragment,e),m(rt.$$.fragment,e),m(it.$$.fragment,e),m(pt.$$.fragment,e),m(ct.$$.fragment,e),m(gt.$$.fragment,e),os=!1},d(e){e&&(t(ae),t(b),t(Qt),t(le),t(Dt),t(ne),t(Kt),t(Ot),t(re),t(ea),t(M),t(ta),t(ie),t(aa),t(k),t(sa),t(he),t(la),t(na),t(ue),t(ra),t(oa),t(fe),t(ia),t(pa),t(me),t(ha),t(j),t(ca),t(ve),t(ua),t(we),t(ga),t(fa),t(x),t(da),t($e),t(ma),t(ya),t(T),t(va),t(je),t(wa),t(xe),t(_a),t(J),t(ba),t(Je),t($a),t(C),t(Ma),t(Ue),t(ka),t(ja),t(Ze),t(xa),t(U),t(Ta),t(Ne),t(Ja),t(Ca),t(G),t(Ua),t(Re),t(Ga),t(Se),t(Za),t(Z),t(Ha),t(Ie),t(Na),t(Xa),t(H),t(Ya),t(Ae),t(Ra),t(Sa),t(N),t(qa),t(Be),t(Ia),t(We),t(La),t(X),t(Pa),t(ze),t(Aa),t(Ea),t(Y),t(Fa),t(Ke),t(Ba),t(Wa),t(et),t(Va),t(za),t(at),t(Qa),t(Da),t(lt),t(Ka),t(Oa),t(R),t(es),t(ot),t(ts),t(as),t(S),t(ss),t(ht),t(ls),t(ns),t(ut),t(rs)),t(v),y(se),y(q,e),y(oe),y(pe),y(ce,e),y(ge,e),y(de,e),y(ye),y(_e,e),y(be),y(Me,e),y(ke),y(Te),y(Ce),y(Ge,e),y(He),y(Xe,e),y(Ye),y(qe),y(Le,e),y(Pe),y(Ee,e),y(Fe),y(Ve),y(Qe,e),y(De),y(Oe,e),y(tt,e),y(st,e),y(nt,e),y(rt),y(it,e),y(pt),y(ct,e),y(gt,e)}}}const jn={local:"create-and-manage-a-repository",sections:[{local:"repo-creation-and-deletion",sections:[{local:"create-a-repository",title:"Create a repository"},{local:"delete-a-repository",title:"Delete a repository"},{local:"duplicate-a-repository-only-for-spaces",title:"Duplicate a repository (only for Spaces)"}],title:"Repo creation and deletion"},{local:"upload-and-download-files",title:"Upload and download files"},{local:"branches-and-tags",sections:[{local:"create-branches-and-tags",title:"Create branches and tags"},{local:"list-all-branches-and-tags",title:"List all branches and tags"}],title:"Branches and tags"},{local:"change-repository-settings",sections:[{local:"update-visibility",title:"Update visibility"},{local:"rename-your-repository",title:"Rename your repository"}],title:"Change repository settings"},{local:"manage-a-local-copy-of-your-repository",sections:[{local:"use-a-local-repository",title:"Use a local repository"},{local:"clone",title:"Clone"},{local:"branch",title:"Branch"},{local:"pull",title:"Pull"}],title:"Manage a local copy of your repository"}],title:"Create and manage a repository"};function xn(zt){return yn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zn extends wn{constructor(v){super(),_n(this,v,xn,kn,mn,{})}}export{Zn as component};
