import{s as _t,o as Gt,n as Ut}from"../chunks/scheduler.37c15a92.js";import{S as Zt,i as Rt,g as i,s as a,r as c,A as Ct,h as r,f as l,c as n,j as gt,u as d,x as o,k as vt,y as Wt,a as s,v as m,d as M,t as u,w as f}from"../chunks/index.2bf4358c.js";import{T as kt}from"../chunks/Tip.363c041f.js";import{Y as Ht}from"../chunks/Youtube.1e50a667.js";import{C as T}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Ft}from"../chunks/CourseFloatingBanner.15ba07e6.js";import{F as Et}from"../chunks/FrameworkSwitchCourse.8d4d4ab6.js";import{H as Oe}from"../chunks/Heading.8ada512a.js";function It(w){let p,$='💡 ถ้าคุณต้องการจะอัพโหลดโมเดลของคุณขึ้น Hub ระหว่างที่ทำการเทรนโดยอัตโนมัติ ให้ใส่ <code>push_to_hub=True</code> เข้าไปใน <code>TrainingArguments</code> ด้วย โดยเราจะเรียนรู้เพิ่มเติมใน <a href="/course/chapter4/3">Chapter 4</a>';return{c(){p=i("p"),p.innerHTML=$},l(b){p=r(b,"P",{"data-svelte-h":!0}),o(p)!=="svelte-t794qd"&&(p.innerHTML=$)},m(b,y){s(b,p,y)},p:Ut,d(b){b&&l(p)}}}function zt(w){let p,$="✏️ <strong>ลองเลย!</strong> Fine-tune โมเดลโดยใช้ GLUE SST-2 dataset โดยใช้การประมวลผลข้อมูลแบบที่คุณทำไว้ใน section 2";return{c(){p=i("p"),p.innerHTML=$},l(b){p=r(b,"P",{"data-svelte-h":!0}),o(p)!=="svelte-1fbhp95"&&(p.innerHTML=$)},m(b,y){s(b,p,y)},p:Ut,d(b){b&&l(p)}}}function Xt(w){let p,$,b,y,h,ce,g,de,v,me,k,Me,U,et='🤗 Transformers มี <code>Trainer</code> class เพื่อช่วยให้คุณสามารถ fine-tune โมเดลที่ผ่านการเทรนมาแล้วด้วย dataset ของคุณเองได้ หลังจากที่คุณได้ทำการประมวลผลข้อมูลใน section ที่แล้ว ก็เหลืองานอีกไม่กี่ขั้นตอนเท่านั้นในการกำหนดตัว <code>Trainer</code> ซึ่งงานส่วนที่ยากที่สุดน่าจะเป็นการเตรียม environment ในการ run <code>Trainer.train()</code> เนื่องจากมันจะ run ได้ช้ามากบน CPU ถ้าคุณไม่มีการติดตั้ง GPU คุณก็สามารถเข้าถึง free GPUs หรือ TPUs ได้บน <a href="https://colab.research.google.com/" rel="nofollow">Google Colab</a>',ue,_,tt="โค้ดตัวอย่างข้างล่างนี้สันนิษฐานไว้ว่าคุณได้ทำตัวอย่างใน section ที่แล้วมาเรียบร้อยแล้ว นี่คือการสรุปสั้น ๆ เพื่อทบทวนสิ่งที่คุณต้องเตรียมให้พร้อม:",fe,G,be,Z,Te,R,lt="ขั้นตอนแรกก่อนที่เราจะกำหนด <code>Trainer</code> ของเราก็คือการกำหนด <code>TrainingArguments</code> class ที่จะมีข้อมูลของ hyperparameters ทุกตัวที่ <code>Trainer</code> จะใช้ในการ train และการ evaluate โดยอากิวเมนต์เดียวที่คุณต้องใส่คือ directory ที่จะเซฟข้อมูลโมเดลที่เทรนแล้ว รวมถึง checkpoints ระหว่างการเทรน ที่เหลือนั้นคุณสามารถปล่อยให้เป็นไปตามค่าเริ่มต้นได้ ซึ่งน่าจะทำงานได้ดีสำหรับการ fine-tune แบบพื้นฐาน",$e,C,ye,j,he,W,st='ขั้นตอนที่สองคือการกำหนดโมเดลของพวกเรา เหมือนกับใน <a href="/course/chapter2">previous chapter</a> เราจะใช้ <code>AutoModelForSequenceClassification</code> class โดยมี 2 labels:',je,H,Je,F,at='คุณจะสังเกตได้ว่าคุณจะได้รับคำเตือนหลังจากที่สร้างโมเดลขึ้นมา ไม่เหมือนกับใน <a href="/course/chapter2">Chapter 2</a> ที่เป็นเช่นนี้เนื่องจาก BERT ยังไม่ได้มีการ pretrained ให้สามารถจำแนกคู่ประโยค ดังนั้น head ของโมเดลที่เทรนไว้แล้วจะถูกตัดทิ้งไป และจะใส่ head ใหม่ที่เหมาะกับการจำแนกลำดับ (sequence classification) เข้ามาแทน คำเตือนนี้เป็นการแจ้งว่า weights บางส่วนจะไม่ถูกนำมาใช้ (weights ของ head ที่ถูกตัดทิ้งไป) และ weights บางส่วน (ของ head ใหม่) จะถูกสร้างขึ้นแบบสุ่ม (randomly initialized) และจบคำเตือนโดยการส่งเสริมให้เราเทรนโมเดล ซึ่งก็เป็นสิ่งที่เรากำลังจะทำตอนนี้',we,E,nt="หลังจากที่เราได้โมเดลแล้ว เราสามารถกำหนด <code>Trainer</code> โดยการใส่ออพเจ็กต์ที่เราสร้างขึ้นมาทั้งหมด ได้แก่ <code>model</code>, <code>training_args</code>, ชุดข้อมูล training และ validation, <code>data_collator</code> ของเรา และ <code>tokenizer</code> ของเรา:",ge,I,ve,z,it="ควรสังเกตว่าเมื่อคุณใส่ <code>tokenizer</code> แบบที่เราทำตอนนี้ ตัว <code>data_collator</code> ที่เป็นค่าเริ่มต้นที่ถูกใช้โดย <code>Trainer</code> จะเป็น <code>DataCollatorWithPadding</code> ที่ได้กำหนดไว้ก่อนหน้านี้ ดังนั้นคุณสามารถข้ามบรรทัด <code>data_collator=data_collator</code> ในการ call นี้ไปเลยก็ได้ ซึ่งคุณได้เรียนรู้กระบวนการนี้มาแล้วใน section 2!",ke,X,rt="เพื่อจะทำการ fine-tune โมเดลด้วย dataset ของเรา เราก็แค่ต้องเรียกเมธอด <code>train()</code> จาก <code>Trainer</code> ของเรา:",Ue,x,_e,V,pt="การรันโค้ดนี้จะเป็นการเริ่มต้น fine-tune โมเดล (ซึ่งจะใช้เวลาไม่กี่นาที ถ้าทำบน GPU) และจะรายงาน training loss ทุก ๆ 500 steps แต่มันจะไม่บอกว่าโมเดลของคุณทำงานได้ดีหรือแย่แค่ไหน เนื่องจาก:",Ge,B,ot="<li>เราไม่ได้บอก <code>Trainer</code> ให้ evaluate ระหว่างการเทรนโดยตั้งค่า <code>evaluation_strategy</code> ให้เป็น  <code>&quot;steps&quot;</code> (เพื่อ evaluate ทุก ๆ <code>eval_steps</code>) หรือ <code>&quot;epoch&quot;</code> (เพื่อ evaluate เมื่อจบแต่ละ epoch)</li> <li>เราไม่ได้ใส่ฟังก์ชั่น <code>compute_metrics()</code> เข้าไปใน <code>Trainer</code> ของเรา โดยฟังก์ชั่นนี้จะคำนวณ metric เมื่อมีการ evaluate เกิดขึ้น (ไม่เช่นนั้นเมื่อมีการ evaluate เกิดขึ้น ก็จะรายงานแค่ค่า loss ซึ่งเป็นตัวเลขที่ทำความเข้าใจได้ยาก)</li>",Ze,Y,Re,A,ct="มาดูกันว่าเราจะสามารถสร้างฟังก์ชั่น <code>compute_metrics()</code> และนำไปใช้งานในการเทรนครั้งหน้าได้อย่างไร ฟังก์ชั่นนี้จะต้องรับออพเจกต์ <code>EvalPrediction</code> (ซึ่งเป็น named tuple ที่มี filed เป็น <code>predictions</code> และ <code>label_ids</code>) และจะให้ผลลัพธ์เป็น dictionary ที่มีการ map strings เข้ากับ floats (โดย strings เป็นชื่อของ metrics ผลลัพธ์ และ floats เป็นค่าของ metrics เหล่านั้น) เพื่อจะดูผลการทำนายของโมเดลของเรา เราสามารถใช้คำสั่ง <code>Trainer.predict()</code>:",Ce,N,We,Q,He,L,dt="ผลลัพธ์จากเมธอด <code>predict()</code> จะเป็น named tuple อีกตัวหนึ่งซึ่งประกอบด้วย 3 fields ได้แก่ <code>predictions</code>, <code>label_ids</code> และ <code>metrics</code> โดย field <code>metrics</code> จะเก็บข้อมูล loss บน dataset ที่ป้อนเข้ามา รวมถึง metrics ที่เกี่ยวข้องกับเวลาบางตัว (ใช้เวลาในการทำนายเท่าไร โดยคิดทั้งเวลาทั้งหมดและเวลาโดยเฉลี่ย) เมื่อเราสร้างฟังก์ชั่น <code>compute_metrics()</code> เสร็จแล้วและใส่เข้าไปใน <code>Trainer</code> ตัว field metric ก็จะมีข้อมูล metrics ต่าง ๆ ที่ได้จากฟังก์ชั่น <code>compute_metrics()</code> ด้วย",Fe,q,mt='ดังที่คุณเห็น <code>predictions</code> เป็น array 2 มิติ ที่มี shape 408 x 2 (408 เป็นจำนวนของ element ใน dataset ที่เราใช้) ซึ่งข้อมูลเหล่านี้คือ logits สำหรับแต่ละ element ของ dataset ที่เราส่งเข้าไปให้เมธอด <code>predict()</code> (เหมือนที่คุณเห็นมาแล้วใน <a href="/course/chapter2">previous chapter</a> ว่าโมเดล Transformers ทุกตัวจะให้ผลลัพธ์เป็น logits) เพื่อจะแปลง logits ให้เป็นการทำนายที่เราสามารถเปรียบเทียบกับ label ของเราได้ เราจะต้องหา index ของค่าที่มีค่าสูงสุดใน axis ที่สอง:',Ee,P,Ie,S,Mt='ตอนนี้เราก็สามารถเปรียบเทียบ <code>preds</code> เหล่านี้กับ labels ของเราได้แล้ว เพื่อจะสร้างฟังก์ชั่น <code>compute_metric()</code> ของเรา เราจะยืม  metrics จากไลบรารี่ 🤗 <a href="https://github.com/huggingface/evaluate/" rel="nofollow">Evaluate</a> มาใช้ เราสามารถโหลด metrics ที่เกี่ยวข้องกับ MRPC dataset ได้อย่างง่ายดายเหมือนกับที่เราโหลดชุดข้อมูล โดยการใช้ฟังก์ชั่น <code>evaluate.load()</code> โดยจะได้ผลลัพธ์เป็นออพเจ็กต์ที่มีเมธอด <code>compute()</code> ที่เราสามารถนำไปใช้ในการคำนวณ metric ได้:',ze,K,Xe,D,xe,O,ut='ผลลัพธ์ที่ได้อาจแตกต่างไปเล็กน้อย เนื่องจากมีการกำหนดค่า weight ของ model head ขึ้นมาแบบสุ่ม และอาจเปลี่ยนผลลัพธ์ใน metrics ได้ ซึ่งตรงนี้เราจะเห็นได้ว่าโมเดลของเราได้ accuracy ที่ 85.78% เมื่อทดสอบด้วย validation set และได้ค่า F1 score ที่ 89.97 ซึ่ง metrics ทั้งสองตัวนี้เป็น metrics ที่ใช้วัดผล MRPC dataset สำหรับ GLUE benchmark โดยตารางในรายงาน <a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">BERT paper</a> ได้รายงานค่า F1 score ไว้ที่ 88.9 สำหรับ base model ซึ่งเป็นโมเดล <code>uncased</code> ในขณะที่โมเดลของเราเป็นโมเดล <code>cased</code> จึงเป็นเหตุให้มีผลลัพธ์ที่ดีกว่า',Ve,ee,ft="เมื่อรวมทุกอย่างเข้าด้วยกัน เราก็จะได้ฟังก์ชั่น <code>compute_metrics()</code> ของเราดังนี้:",Be,te,Ye,le,bt="และเพื่อให้มันรายงาน metrics เมื่อจบ epoch แต่ละ epoch เราสามารกำหนด <code>Trainer</code> ตัวใหม่ โดยใช้ฟังก์ชั่น <code>compute_metrics()</code> ได้ดังนี้:",Ae,se,Ne,ae,Tt="ควรสังเกตว่าเราได้สร้าง <code>TrainingArguments</code> ชุดใหม่ โดยกำหนนด <code>evaluation_strategy</code> ให้เป็น <code>&quot;epoch&quot;</code> และสร้างโมเดลขึ้นใหม่ด้วย มิฉะนั้นเราก็จะเทรนโมเดลตัวเดิมของเราต่อ เพื่อจะเริ่มการ training รอบใหม่ เราจะใช้คำสั่ง:",Qe,ne,Le,ie,$t="คราวนี้มันจะรายงาน validation loss และ metrics ต่าง ๆ ทุก ๆ ครั้งที่จบแต่ละ epoch นอกจาก training loss ซึ่ง accuracy และ F1 score ที่คุณได้อาจจะต่างจากนี้ไปเล็กน้อยเนื่องจากการสุ่ม แต่มันก็ควรจะได้ค่าที่ใกล้เคียงกัน",qe,re,yt="<code>Trainer</code> จะสามารถทำงานได้ดีกับการเทรนด้วย GPUs หรือ TPUs หลายตัวโดยไม่ต้องปรับแต่งอะไรมาก และยังมี options มากมายให้เลือกใช้ เช่น mixed-precision training (เลือกได้โดยใส่ <code>fp16 = True</code> เข้าไปใน training arguments ของคุณ) เราจะอธิบายทุกอย่างที่มันทำได้ใน Chapter 10",Pe,pe,ht="ก็เป็นอันเสร็จสิ้นวิธีการ fine-tune โดยใช้ <code>Trainer</code> API ซึ่งตัวอย่างการ fine-tune กับ NLP tasks ส่วนใหญ่ที่ใช้บ่อยจะอยู่ใน Chapter 7 แต่ตอนนี้เรามาดูการทำแบบเดียวกันนี้โดยใช้ PyTorch เพียงอย่างเดียวกัน",Se,J,Ke,oe,De;return h=new Et({props:{fw:w[0]}}),g=new Oe({props:{title:"การ Fine-tune โมเดลด้วย Trainer API",local:"การ-fine-tune-โมเดลดวย-trainer-api",headingTag:"h1"}}),v=new Ft({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/th/chapter3/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/th/chapter3/section3.ipynb"}]}}),k=new Ht({props:{id:"nvBXf7s7vTI"}}),G=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),Z=new Oe({props:{title:"การ Train โมเดล",local:"การ-train-โมเดล",headingTag:"h3"}}),C=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>)`,wrap:!1}}),j=new kt({props:{$$slots:{default:[It]},$$scope:{ctx:w}}}),H=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),I=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),x=new T({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),Y=new Oe({props:{title:"Evaluation (การประเมินผลโมเดล)",local:"evaluation-การประเมนผลโมเดล",headingTag:"h3"}}),N=new T({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjB0cmFpbmVyLnByZWRpY3QodG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCklMEFwcmludChwcmVkaWN0aW9ucy5wcmVkaWN0aW9ucy5zaGFwZSUyQyUyMHByZWRpY3Rpb25zLmxhYmVsX2lkcy5zaGFwZSk=",highlighted:`predictions = trainer.predict(tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>])
<span class="hljs-built_in">print</span>(predictions.predictions.shape, predictions.label_ids.shape)`,wrap:!1}}),Q=new T({props:{code:"KDQwOCUyQyUyMDIpJTIwKDQwOCUyQyk=",highlighted:'(<span class="hljs-number">408</span>, <span class="hljs-number">2</span>) (<span class="hljs-number">408</span>,)',wrap:!1}}),P=new T({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcHJlZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZGljdGlvbnMucHJlZGljdGlvbnMlMkMlMjBheGlzJTNELTEp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

preds = np.argmax(predictions.predictions, axis=-<span class="hljs-number">1</span>)`,wrap:!1}}),K=new T({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZHMlMkMlMjByZWZlcmVuY2VzJTNEcHJlZGljdGlvbnMubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
metric.compute(predictions=preds, references=predictions.label_ids)`,wrap:!1}}),D=new T({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODU3ODQzMTM3MjU0OTAxOSUyQyUyMCdmMSclM0ElMjAwLjg5OTY1Mzk3OTIzODc1NDIlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8578431372549019</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8996539792387542</span>}',wrap:!1}}),te=new T({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZHMpJTNBJTBBJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwZXZhbHVhdGUubG9hZCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_preds</span>):
    metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
    logits, labels = eval_preds
    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),se=new T({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMiUyQyUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>, evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),ne=new T({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'trainer.trai<span class="hljs-meta">n</span>()',wrap:!1}}),J=new kt({props:{$$slots:{default:[zt]},$$scope:{ctx:w}}}),{c(){p=i("meta"),$=a(),b=i("p"),y=a(),c(h.$$.fragment),ce=a(),c(g.$$.fragment),de=a(),c(v.$$.fragment),me=a(),c(k.$$.fragment),Me=a(),U=i("p"),U.innerHTML=et,ue=a(),_=i("p"),_.textContent=tt,fe=a(),c(G.$$.fragment),be=a(),c(Z.$$.fragment),Te=a(),R=i("p"),R.innerHTML=lt,$e=a(),c(C.$$.fragment),ye=a(),c(j.$$.fragment),he=a(),W=i("p"),W.innerHTML=st,je=a(),c(H.$$.fragment),Je=a(),F=i("p"),F.innerHTML=at,we=a(),E=i("p"),E.innerHTML=nt,ge=a(),c(I.$$.fragment),ve=a(),z=i("p"),z.innerHTML=it,ke=a(),X=i("p"),X.innerHTML=rt,Ue=a(),c(x.$$.fragment),_e=a(),V=i("p"),V.textContent=pt,Ge=a(),B=i("ol"),B.innerHTML=ot,Ze=a(),c(Y.$$.fragment),Re=a(),A=i("p"),A.innerHTML=ct,Ce=a(),c(N.$$.fragment),We=a(),c(Q.$$.fragment),He=a(),L=i("p"),L.innerHTML=dt,Fe=a(),q=i("p"),q.innerHTML=mt,Ee=a(),c(P.$$.fragment),Ie=a(),S=i("p"),S.innerHTML=Mt,ze=a(),c(K.$$.fragment),Xe=a(),c(D.$$.fragment),xe=a(),O=i("p"),O.innerHTML=ut,Ve=a(),ee=i("p"),ee.innerHTML=ft,Be=a(),c(te.$$.fragment),Ye=a(),le=i("p"),le.innerHTML=bt,Ae=a(),c(se.$$.fragment),Ne=a(),ae=i("p"),ae.innerHTML=Tt,Qe=a(),c(ne.$$.fragment),Le=a(),ie=i("p"),ie.textContent=$t,qe=a(),re=i("p"),re.innerHTML=yt,Pe=a(),pe=i("p"),pe.innerHTML=ht,Se=a(),c(J.$$.fragment),Ke=a(),oe=i("p"),this.h()},l(e){const t=Ct("svelte-u9bgzb",document.head);p=r(t,"META",{name:!0,content:!0}),t.forEach(l),$=n(e),b=r(e,"P",{}),gt(b).forEach(l),y=n(e),d(h.$$.fragment,e),ce=n(e),d(g.$$.fragment,e),de=n(e),d(v.$$.fragment,e),me=n(e),d(k.$$.fragment,e),Me=n(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-ri2n1m"&&(U.innerHTML=et),ue=n(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-lju15h"&&(_.textContent=tt),fe=n(e),d(G.$$.fragment,e),be=n(e),d(Z.$$.fragment,e),Te=n(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1coier3"&&(R.innerHTML=lt),$e=n(e),d(C.$$.fragment,e),ye=n(e),d(j.$$.fragment,e),he=n(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1g21eac"&&(W.innerHTML=st),je=n(e),d(H.$$.fragment,e),Je=n(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1a4jhzb"&&(F.innerHTML=at),we=n(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-12nwfzl"&&(E.innerHTML=nt),ge=n(e),d(I.$$.fragment,e),ve=n(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-qx8k75"&&(z.innerHTML=it),ke=n(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-12asvlz"&&(X.innerHTML=rt),Ue=n(e),d(x.$$.fragment,e),_e=n(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-19xu70u"&&(V.textContent=pt),Ge=n(e),B=r(e,"OL",{"data-svelte-h":!0}),o(B)!=="svelte-tfbmtd"&&(B.innerHTML=ot),Ze=n(e),d(Y.$$.fragment,e),Re=n(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-3by548"&&(A.innerHTML=ct),Ce=n(e),d(N.$$.fragment,e),We=n(e),d(Q.$$.fragment,e),He=n(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-uaqzl2"&&(L.innerHTML=dt),Fe=n(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-34397x"&&(q.innerHTML=mt),Ee=n(e),d(P.$$.fragment,e),Ie=n(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-t56ve1"&&(S.innerHTML=Mt),ze=n(e),d(K.$$.fragment,e),Xe=n(e),d(D.$$.fragment,e),xe=n(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1vg21xz"&&(O.innerHTML=ut),Ve=n(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1h8o6pr"&&(ee.innerHTML=ft),Be=n(e),d(te.$$.fragment,e),Ye=n(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1ehxxhw"&&(le.innerHTML=bt),Ae=n(e),d(se.$$.fragment,e),Ne=n(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-ulktjg"&&(ae.innerHTML=Tt),Qe=n(e),d(ne.$$.fragment,e),Le=n(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-ufdqz2"&&(ie.textContent=$t),qe=n(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1h2xg0o"&&(re.innerHTML=yt),Pe=n(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1g5sfnr"&&(pe.innerHTML=ht),Se=n(e),d(J.$$.fragment,e),Ke=n(e),oe=r(e,"P",{}),gt(oe).forEach(l),this.h()},h(){vt(p,"name","hf:doc:metadata"),vt(p,"content",xt)},m(e,t){Wt(document.head,p),s(e,$,t),s(e,b,t),s(e,y,t),m(h,e,t),s(e,ce,t),m(g,e,t),s(e,de,t),m(v,e,t),s(e,me,t),m(k,e,t),s(e,Me,t),s(e,U,t),s(e,ue,t),s(e,_,t),s(e,fe,t),m(G,e,t),s(e,be,t),m(Z,e,t),s(e,Te,t),s(e,R,t),s(e,$e,t),m(C,e,t),s(e,ye,t),m(j,e,t),s(e,he,t),s(e,W,t),s(e,je,t),m(H,e,t),s(e,Je,t),s(e,F,t),s(e,we,t),s(e,E,t),s(e,ge,t),m(I,e,t),s(e,ve,t),s(e,z,t),s(e,ke,t),s(e,X,t),s(e,Ue,t),m(x,e,t),s(e,_e,t),s(e,V,t),s(e,Ge,t),s(e,B,t),s(e,Ze,t),m(Y,e,t),s(e,Re,t),s(e,A,t),s(e,Ce,t),m(N,e,t),s(e,We,t),m(Q,e,t),s(e,He,t),s(e,L,t),s(e,Fe,t),s(e,q,t),s(e,Ee,t),m(P,e,t),s(e,Ie,t),s(e,S,t),s(e,ze,t),m(K,e,t),s(e,Xe,t),m(D,e,t),s(e,xe,t),s(e,O,t),s(e,Ve,t),s(e,ee,t),s(e,Be,t),m(te,e,t),s(e,Ye,t),s(e,le,t),s(e,Ae,t),m(se,e,t),s(e,Ne,t),s(e,ae,t),s(e,Qe,t),m(ne,e,t),s(e,Le,t),s(e,ie,t),s(e,qe,t),s(e,re,t),s(e,Pe,t),s(e,pe,t),s(e,Se,t),m(J,e,t),s(e,Ke,t),s(e,oe,t),De=!0},p(e,[t]){const jt={};t&1&&(jt.fw=e[0]),h.$set(jt);const Jt={};t&2&&(Jt.$$scope={dirty:t,ctx:e}),j.$set(Jt);const wt={};t&2&&(wt.$$scope={dirty:t,ctx:e}),J.$set(wt)},i(e){De||(M(h.$$.fragment,e),M(g.$$.fragment,e),M(v.$$.fragment,e),M(k.$$.fragment,e),M(G.$$.fragment,e),M(Z.$$.fragment,e),M(C.$$.fragment,e),M(j.$$.fragment,e),M(H.$$.fragment,e),M(I.$$.fragment,e),M(x.$$.fragment,e),M(Y.$$.fragment,e),M(N.$$.fragment,e),M(Q.$$.fragment,e),M(P.$$.fragment,e),M(K.$$.fragment,e),M(D.$$.fragment,e),M(te.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(J.$$.fragment,e),De=!0)},o(e){u(h.$$.fragment,e),u(g.$$.fragment,e),u(v.$$.fragment,e),u(k.$$.fragment,e),u(G.$$.fragment,e),u(Z.$$.fragment,e),u(C.$$.fragment,e),u(j.$$.fragment,e),u(H.$$.fragment,e),u(I.$$.fragment,e),u(x.$$.fragment,e),u(Y.$$.fragment,e),u(N.$$.fragment,e),u(Q.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(D.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(ne.$$.fragment,e),u(J.$$.fragment,e),De=!1},d(e){e&&(l($),l(b),l(y),l(ce),l(de),l(me),l(Me),l(U),l(ue),l(_),l(fe),l(be),l(Te),l(R),l($e),l(ye),l(he),l(W),l(je),l(Je),l(F),l(we),l(E),l(ge),l(ve),l(z),l(ke),l(X),l(Ue),l(_e),l(V),l(Ge),l(B),l(Ze),l(Re),l(A),l(Ce),l(We),l(He),l(L),l(Fe),l(q),l(Ee),l(Ie),l(S),l(ze),l(Xe),l(xe),l(O),l(Ve),l(ee),l(Be),l(Ye),l(le),l(Ae),l(Ne),l(ae),l(Qe),l(Le),l(ie),l(qe),l(re),l(Pe),l(pe),l(Se),l(Ke),l(oe)),l(p),f(h,e),f(g,e),f(v,e),f(k,e),f(G,e),f(Z,e),f(C,e),f(j,e),f(H,e),f(I,e),f(x,e),f(Y,e),f(N,e),f(Q,e),f(P,e),f(K,e),f(D,e),f(te,e),f(se,e),f(ne,e),f(J,e)}}}const xt='{"title":"การ Fine-tune โมเดลด้วย Trainer API","local":"การ-fine-tune-โมเดลดวย-trainer-api","sections":[{"title":"การ Train โมเดล","local":"การ-train-โมเดล","sections":[],"depth":3},{"title":"Evaluation (การประเมินผลโมเดล)","local":"evaluation-การประเมนผลโมเดล","sections":[],"depth":3}],"depth":1}';function Vt(w,p,$){let b="pt";return Gt(()=>{const y=new URLSearchParams(window.location.search);$(0,b=y.get("fw")||"pt")}),[b]}class St extends Zt{constructor(p){super(),Rt(this,p,Vt,Xt,_t,{})}}export{St as component};
