import{s as oH,o as aH,n as H}from"../chunks/scheduler.6062bdaf.js";import{S as sH,i as rH,g as c,s,r as u,A as iH,h as l,f as p,c as r,j,u as h,x as d,k as M,y as o,a as $,v as f,d as m,t as _,w as b,m as cH,n as lH}from"../chunks/index.4bca734e.js";import{T as I}from"../chunks/Tip.b9ac1f03.js";import{D as q}from"../chunks/Docstring.88ece41f.js";import{C as U}from"../chunks/CodeBlock.cbbddafc.js";import{E as C}from"../chunks/ExampleCodeBlock.906f6a40.js";import{H as A,E as pH}from"../chunks/getInferenceSnippets.8c4585c8.js";function dH(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGFkZF9jb2xsZWN0aW9uX2l0ZW0lMEFjb2xsZWN0aW9uJTIwJTNEJTIwYWRkX2NvbGxlY3Rpb25faXRlbSglMEElMjAlMjAlMjAlMjBjb2xsZWN0aW9uX3NsdWclM0QlMjJkYXZhbnN0cmllbiUyRmNsaW1hdGUtNjRmOTlkYzJhNTA2N2Y2YjY1NTMxYmFiJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXRlbV9pZCUzRCUyMnBpZXJyZS1sb2ljJTJGY2xpbWF0ZS1uZXdzLWFydGljbGVzJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXRlbV90eXBlJTNEJTIyZGF0YXNldCUyMiUwQSklMEFjb2xsZWN0aW9uLml0ZW1zJTVCLTElNUQuaXRlbV9pZCUwQSUwQWFkZF9jb2xsZWN0aW9uX2l0ZW0oJTBBJTIwJTIwJTIwJTIwY29sbGVjdGlvbl9zbHVnJTNEJTIyZGF2YW5zdHJpZW4lMkZjbGltYXRlLTY0Zjk5ZGMyYTUwNjdmNmI2NTUzMWJhYiUyMiUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1faWQlM0QlMjJkYXRhc2V0cyUyRmNsaW1hdGVfZmV2ZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBpdGVtX3R5cGUlM0QlMjJkYXRhc2V0JTIyJTBBJTIwJTIwJTIwJTIwbm90ZSUzRCUyMlRoaXMlMjBkYXRhc2V0JTIwYWRvcHRzJTIwdGhlJTIwRkVWRVIlMjBtZXRob2RvbG9neSUyMHRoYXQlMjBjb25zaXN0cyUyMG9mJTIwMSUyQzUzNSUyMHJlYWwtd29ybGQlMjBjbGFpbXMlMjByZWdhcmRpbmclMjBjbGltYXRlLWNoYW5nZSUyMGNvbGxlY3RlZCUyMG9uJTIwdGhlJTIwaW50ZXJuZXQuJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> add_collection_item
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = add_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;davanstrien/climate-64f99dc2a5067f6b65531bab&quot;</span>,
<span class="hljs-meta">... </span>    item_id=<span class="hljs-string">&quot;pierre-loic/climate-news-articles&quot;</span>,
<span class="hljs-meta">... </span>    item_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.items[-<span class="hljs-number">1</span>].item_id
<span class="hljs-string">&quot;pierre-loic/climate-news-articles&quot;</span>
<span class="hljs-comment"># ^item got added to the collection on last position</span>

<span class="hljs-comment"># Add item with a note</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>add_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;davanstrien/climate-64f99dc2a5067f6b65531bab&quot;</span>,
<span class="hljs-meta">... </span>    item_id=<span class="hljs-string">&quot;datasets/climate_fever&quot;</span>,
<span class="hljs-meta">... </span>    item_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>    note=<span class="hljs-string">&quot;This dataset adopts the FEVER methodology that consists of 1,535 real-world claims regarding climate-change collected on the internet.&quot;</span>
<span class="hljs-meta">... </span>)
(...)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function gH(T){let n,y="Check if the user has access to a repository:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGF1dGhfY2hlY2slMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViLnV0aWxzJTIwaW1wb3J0JTIwR2F0ZWRSZXBvRXJyb3IlMkMlMjBSZXBvc2l0b3J5Tm90Rm91bmRFcnJvciUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> auth_check
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.utils <span class="hljs-keyword">import</span> GatedRepoError, RepositoryNotFoundError

<span class="hljs-keyword">try</span>:
    auth_check(<span class="hljs-string">&quot;user/my-cool-model&quot;</span>)
<span class="hljs-keyword">except</span> GatedRepoError:
    <span class="hljs-comment"># Handle gated repository error</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;You do not have permission to access this gated repository.&quot;</span>)
<span class="hljs-keyword">except</span> RepositoryNotFoundError:
    <span class="hljs-comment"># Handle repository not found error</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The repository was not found or you do not have access.&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-12u7bhh"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function uH(T){let n,y="Examples:",i,a,g;return a=new U({props:{code:"bmV3X3RpdGxlJTIwJTNEJTIwJTIyTmV3JTIwdGl0bGUlMkMlMjBmaXhpbmclMjBhJTIwdHlwbyUyMiUwQUhmQXBpKCkucmVuYW1lX2Rpc2N1c3Npb24oJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGcmVwb19uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGlzY3Vzc2lvbl9udW0lM0QzNCUwQSUyMCUyMCUyMCUyMG5ld190aXRsZSUzRG5ld190aXRsZSUwQSklMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>new_title = <span class="hljs-string">&quot;New title, fixing a typo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi().rename_discussion(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo_name&quot;</span>,
<span class="hljs-meta">... </span>    discussion_num=<span class="hljs-number">34</span>
<span class="hljs-meta">... </span>    new_title=new_title
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># DiscussionStatusChange(id=&#x27;deadbeef0000000&#x27;, type=&#x27;status-change&#x27;, ...)</span>
`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-kvfsh7"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function hH(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function fH(T){let n,y="Examples:",i,a,g;return a=new U({props:{code:"JTBBY29tbWVudCUyMCUzRCUyMCUyMiUyMiUyMiUwQUhlbGxvJTIwJTQwb3RoZXJ1c2VyISUwQSUyMyUyMFRoaXMlMjBpcyUyMGElMjB0aXRsZSUwQSoqVGhpcyUyMGlzJTIwYm9sZCoqJTJDJTIwKnRoaXMlMjBpcyUyMGl0YWxpYyolMjBhbmQlMjB+dGhpcyUyMGlzJTIwc3RyaWtldGhyb3VnaH4lMEFBbmQlMjAlNUJ0aGlzJTVEKGh0dHAlM0ElMkYlMkZ1cmwpJTIwaXMlMjBhJTIwbGluayUwQSUyMiUyMiUyMiUwQSUwQUhmQXBpKCkuY29tbWVudF9kaXNjdXNzaW9uKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRnJlcG9fbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGRpc2N1c3Npb25fbnVtJTNEMzQlMEElMjAlMjAlMjAlMjBjb21tZW50JTNEY29tbWVudCUwQSklMEE=",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span>comment = <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>Hello @otheruser!
...
<span class="hljs-meta">... </span># This is a title
...
<span class="hljs-meta">... </span>**This is bold**, *this is italic* and ~this is strikethrough~
<span class="hljs-meta">... </span>And [this](http://url) is a link
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi().comment_discussion(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo_name&quot;</span>,
<span class="hljs-meta">... </span>    discussion_num=<span class="hljs-number">34</span>
<span class="hljs-meta">... </span>    comment=comment
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># DiscussionComment(id=&#x27;deadbeef0000000&#x27;, type=&#x27;comment&#x27;, ...)</span>
`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-kvfsh7"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function mH(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function _H(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGNyZWF0ZV9jb2xsZWN0aW9uKCUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIySUNDViUyMDIwMjMlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlBvcnRmb2xpbyUyMG9mJTIwbW9kZWxzJTJDJTIwcGFwZXJzJTIwYW5kJTIwZGVtb3MlMjBJJTIwcHJlc2VudGVkJTIwYXQlMjBJQ0NWJTIwMjAyMyUyMiUyQyUwQSklMEFjb2xsZWN0aW9uLnNsdWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = create_collection(
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;ICCV 2023&quot;</span>,
<span class="hljs-meta">... </span>    description=<span class="hljs-string">&quot;Portfolio of models, papers and demos I presented at ICCV 2023&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.slug
<span class="hljs-string">&quot;username/iccv-2023-64f9a55bb3115b4f513ec026&quot;</span>`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function bH(T){let n,y=`The input list of <code>CommitOperation</code> will be mutated during the commit process. Do not reuse the same objects
for multiple commits.`;return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1i3qk8u"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function yH(T){let n,y=`<code>create_commit</code> assumes that the repo already exists on the Hub. If you get a
Client error 404, please make sure you are authenticated and that <code>repo_id</code> and
<code>repo_type</code> are set correctly. If repo does not exist, create it first using
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`;return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-hn9ry1"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function vH(T){let n,y="<code>create_commit</code> is limited to 25k LFS files and a 1GB payload for regular files.";return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-yun5lq"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function xH(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function $H(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIybXktZW5kcG9pbnQtbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9zaXRvcnklM0QlMjJncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDIlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIyaW50ZWwtaWNsJTIyJTJDJTBBKSUwQWVuZHBvaW50JTBBJTBBZW5kcG9pbnQuY2xpZW50LnRleHRfZ2VuZXJhdGlvbiguLi4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;my-endpoint-name&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;gpt2&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;cpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x2&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, status=<span class="hljs-string">&quot;pending&quot;</span>,...)

<span class="hljs-comment"># Run inference on the endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_generation(...)
<span class="hljs-string">&quot;...&quot;</span>`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function wH(T){let n,y;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIyYXdzLXplcGh5ci03Yi1iZXRhLTA0ODYlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvc2l0b3J5JTNEJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmdwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDElMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIybnZpZGlhLWExMGclMjIlMkMlMEElMjAlMjAlMjAlMjBlbnYlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfQkFUQ0hfUFJFRklMTF9UT0tFTlMlMjIlM0ElMjAlMjIyMDQ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX0xFTkdUSCUyMiUzQSUyMCUyMjEwMjQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyJTJGcmVwb3NpdG9yeSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMGN1c3RvbV9pbWFnZSUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlYWx0aF9yb3V0ZSUyMiUzQSUyMCUyMiUyRmhlYWx0aCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0ExLjEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMHNlY3JldHMlM0QlN0IlMjJNWV9TRUNSRVRfS0VZJTIyJTNBJTIwJTIyc2VjcmV0X3ZhbHVlJTIyJTdEJTJDJTBBJTIwJTIwJTIwdGFncyUzRCU1QiUyMmRldiUyMiUyQyUyMCUyMnRleHQtZ2VuZXJhdGlvbiUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Start an Inference Endpoint running Zephyr-7b-beta on TGI</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;aws-zephyr-7b-beta-0486&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x1&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;nvidia-a10g&quot;</span>,
<span class="hljs-meta">... </span>    env={
<span class="hljs-meta">... </span>          <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;2048&quot;</span>,
<span class="hljs-meta">... </span>          <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
<span class="hljs-meta">... </span>          <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
<span class="hljs-meta">... </span>          <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    custom_image={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:1.1.0&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>   secrets={<span class="hljs-string">&quot;MY_SECRET_KEY&quot;</span>: <span class="hljs-string">&quot;secret_value&quot;</span>},
<span class="hljs-meta">... </span>   tags=[<span class="hljs-string">&quot;dev&quot;</span>, <span class="hljs-string">&quot;text-generation&quot;</span>],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){u(n.$$.fragment)},l(i){h(n.$$.fragment,i)},m(i,a){f(n,i,a),y=!0},p:H,i(i){y||(m(n.$$.fragment,i),y=!0)},o(i){_(n.$$.fragment,i),y=!1},d(i){b(n,i)}}}function kH(T){let n,y;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIyZmluYmVydC1jbGFzc2lmaWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb3NpdG9yeSUzRCUyMlByb3N1c0FJJTJGZmluYmVydCUyMiUyQyUwQSUyMCUyMCUyMCUyMGZyYW1ld29yayUzRCUyMnB5dG9yY2glMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrJTNEJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1pbl9yZXBsaWNhJTNEMCUyQyUwQSUyMCUyMCUyMCUyMHNjYWxlX3RvX3plcm9fdGltZW91dCUzRDE1JTJDJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IlM0QlMjJjcHUlMjIlMkMlMEElMjAlMjAlMjAlMjB2ZW5kb3IlM0QlMjJhd3MlMjIlMkMlMEElMjAlMjAlMjAlMjByZWdpb24lM0QlMjJ1cy1lYXN0LTElMjIlMkMlMEElMjAlMjAlMjAlMjB0eXBlJTNEJTIycHJvdGVjdGVkJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMngyJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCUyMmludGVsLWljbCUyMiUyQyUwQSklMEFlbmRwb2ludC53YWl0KHRpbWVvdXQlM0QzMDApJTBBZW5kcG9pbnQuY2xpZW50LnRleHRfZ2VuZXJhdGlvbiguLi4p",highlighted:`<span class="hljs-comment"># Start an Inference Endpoint running ProsusAI/finbert while scaling to zero in 15 minutes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;finbert-classifier&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;ProsusAI/finbert&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-classification&quot;</span>,
<span class="hljs-meta">... </span>    min_replica=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>    scale_to_zero_timeout=<span class="hljs-number">15</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;cpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x2&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait(timeout=<span class="hljs-number">300</span>)
<span class="hljs-comment"># Run inference on the endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_generation(...)
TextClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.8983615040779114</span>)`,wrap:!1}}),{c(){u(n.$$.fragment)},l(i){h(n.$$.fragment,i)},m(i,a){f(n,i,a),y=!0},p:H,i(i){y||(m(n.$$.fragment,i),y=!0)},o(i){_(n.$$.fragment,i),y=!1},d(i){b(n,i)}}}function TH(T){let n,y=`<code>create_inference_endpoint_from_catalog</code> is experimental. Its API is subject to change in the future. Please provide feedback
if you have any suggestions or requests.`;return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1bm6hf4"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function jH(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function MH(T){let n,y="Create your first scheduled Job:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9zY2hlZHVsZWRfam9iJTBBY3JlYXRlX3NjaGVkdWxlZF9qb2IoaW1hZ2UlM0QlMjJweXRob24lM0EzLjEyJTIyJTJDJTIwY29tbWFuZCUzRCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTIwJTJDJTIycHJpbnQoJ0hlbGxvJTIwZnJvbSUyMEhGJTIwY29tcHV0ZSEnKSUyMiU1RCUyQyUyMHNjaGVkdWxlJTNEJTIyJTQwaG91cmx5JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_job(image=<span class="hljs-string">&quot;python:3.12&quot;</span>, command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span> ,<span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>], schedule=<span class="hljs-string">&quot;@hourly&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1n2fn9b"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function qH(T){let n,y="Use a CRON schedule expression:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9zY2hlZHVsZWRfam9iJTBBY3JlYXRlX3NjaGVkdWxlZF9qb2IoaW1hZ2UlM0QlMjJweXRob24lM0EzLjEyJTIyJTJDJTIwY29tbWFuZCUzRCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTIwJTJDJTIycHJpbnQoJ3RoaXMlMjBydW5zJTIwZXZlcnklMjA1bWluJyklMjIlNUQlMkMlMjBzY2hlZHVsZSUzRCUyMiolMkY1JTIwKiUyMColMjAqJTIwKiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_job(image=<span class="hljs-string">&quot;python:3.12&quot;</span>, command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span> ,<span class="hljs-string">&quot;print(&#x27;this runs every 5min&#x27;)&quot;</span>], schedule=<span class="hljs-string">&quot;*/5 * * * *&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1ax4n75"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function HH(T){let n,y="Create a scheduled GPU Job:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9zY2hlZHVsZWRfam9iJTBBaW1hZ2UlMjAlM0QlMjAlMjJweXRvcmNoJTJGcHl0b3JjaCUzQTIuNi4wLWN1ZGExMi40LWN1ZG5uOS1kZXZlbCUyMiUwQWNvbW1hbmQlMjAlM0QlMjAlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyQyUyMCUyMmltcG9ydCUyMHRvcmNoJTNCJTIwcHJpbnQoZiUyMlRoaXMlMjBjb2RlJTIwcmFuJTIwd2l0aCUyMHRoZSUyMGZvbGxvd2luZyUyMEdQVSUzQSUyMCU3QnRvcmNoLmN1ZGEuZ2V0X2RldmljZV9uYW1lKCklN0QlMjIpJTIyJTVEJTBBY3JlYXRlX3NjaGVkdWxlZF9qb2IoaW1hZ2UlMkMlMjBjb21tYW5kJTJDJTIwZmxhdm9yJTNEJTIyYTEwZy1zbWFsbCUyMiUyQyUyMHNjaGVkdWxlJTNEJTIyJTQwaG91cmx5JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>command = [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import torch; print(f&quot;</span>This code ran <span class="hljs-keyword">with</span> the following GPU: {torch.cuda.get_device_name()}<span class="hljs-string">&quot;)&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_job(image, command, flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>, schedule=<span class="hljs-string">&quot;@hourly&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-l75qip"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function UH(T){let n,y="Schedule a script from a URL:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9zY2hlZHVsZWRfdXZfam9iJTBBc2NyaXB0JTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmwlMkZyZWZzJTJGaGVhZHMlMkZtYWluJTJGdHJsJTJGc2NyaXB0cyUyRnNmdC5weSUyMiUwQXNjcmlwdF9hcmdzJTIwJTNEJTIwJTVCJTIyLS1tb2RlbF9uYW1lX29yX3BhdGglMjIlMkMlMjAlMjJRd2VuJTJGUXdlbjItMC41QiUyMiUyQyUyMCUyMi0tZGF0YXNldF9uYW1lJTIyJTJDJTIwJTIydHJsLWxpYiUyRkNhcHliYXJhJTIyJTJDJTIwJTIyLS1wdXNoX3RvX2h1YiUyMiU1RCUwQWNyZWF0ZV9zY2hlZHVsZWRfdXZfam9iKHNjcmlwdCUyQyUyMHNjcmlwdF9hcmdzJTNEc2NyaXB0X2FyZ3MlMkMlMjBkZXBlbmRlbmNpZXMlM0QlNUIlMjJ0cmwlMjIlNUQlMkMlMjBmbGF2b3IlM0QlMjJhMTBnLXNtYWxsJTIyJTJDJTIwc2NoZWR1bGUlM0QlMjIlNDB3ZWVrbHklMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_scheduled_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>script = <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/refs/heads/main/trl/scripts/sft.py&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>script_args = [<span class="hljs-string">&quot;--model_name_or_path&quot;</span>, <span class="hljs-string">&quot;Qwen/Qwen2-0.5B&quot;</span>, <span class="hljs-string">&quot;--dataset_name&quot;</span>, <span class="hljs-string">&quot;trl-lib/Capybara&quot;</span>, <span class="hljs-string">&quot;--push_to_hub&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_uv_job(script, script_args=script_args, dependencies=[<span class="hljs-string">&quot;trl&quot;</span>], flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>, schedule=<span class="hljs-string">&quot;@weekly&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-q3fkmx"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function CH(T){let n,y="Schedule a local script:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9zY2hlZHVsZWRfdXZfam9iJTBBc2NyaXB0JTIwJTNEJTIwJTIybXlfc2Z0LnB5JTIyJTBBc2NyaXB0X2FyZ3MlMjAlM0QlMjAlNUIlMjItLW1vZGVsX25hbWVfb3JfcGF0aCUyMiUyQyUyMCUyMlF3ZW4lMkZRd2VuMi0wLjVCJTIyJTJDJTIwJTIyLS1kYXRhc2V0X25hbWUlMjIlMkMlMjAlMjJ0cmwtbGliJTJGQ2FweWJhcmElMjIlMkMlMjAlMjItLXB1c2hfdG9faHViJTIyJTVEJTBBY3JlYXRlX3NjaGVkdWxlZF91dl9qb2Ioc2NyaXB0JTJDJTIwc2NyaXB0X2FyZ3MlM0RzY3JpcHRfYXJncyUyQyUyMGRlcGVuZGVuY2llcyUzRCU1QiUyMnRybCUyMiU1RCUyQyUyMGZsYXZvciUzRCUyMmExMGctc21hbGwlMjIlMkMlMjBzY2hlZHVsZSUzRCUyMiU0MHdlZWtseSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_scheduled_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>script = <span class="hljs-string">&quot;my_sft.py&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>script_args = [<span class="hljs-string">&quot;--model_name_or_path&quot;</span>, <span class="hljs-string">&quot;Qwen/Qwen2-0.5B&quot;</span>, <span class="hljs-string">&quot;--dataset_name&quot;</span>, <span class="hljs-string">&quot;trl-lib/Capybara&quot;</span>, <span class="hljs-string">&quot;--push_to_hub&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_uv_job(script, script_args=script_args, dependencies=[<span class="hljs-string">&quot;trl&quot;</span>], flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>, schedule=<span class="hljs-string">&quot;@weekly&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-n7nqq"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function IH(T){let n,y="Schedule a command:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9zY2hlZHVsZWRfdXZfam9iJTBBc2NyaXB0JTIwJTNEJTIwJTIybGlnaHRldmFsJTIyJTBBc2NyaXB0X2FyZ3MlM0QlMjAlNUIlMjJlbmRwb2ludCUyMiUyQyUyMCUyMmluZmVyZW5jZS1wcm92aWRlcnMlMjIlMkMlMjAlMjJtb2RlbF9uYW1lJTNEb3BlbmFpJTJGZ3B0LW9zcy0yMGIlMkNwcm92aWRlciUzRGF1dG8lMjIlMkMlMjAlMjJsaWdodGV2YWwlN0Nnc204ayU3QzAlN0MwJTIyJTVEJTBBY3JlYXRlX3NjaGVkdWxlZF91dl9qb2Ioc2NyaXB0JTJDJTIwc2NyaXB0X2FyZ3MlM0RzY3JpcHRfYXJncyUyQyUyMGRlcGVuZGVuY2llcyUzRCU1QiUyMmxpZ2h0ZXZhbCUyMiU1RCUyQyUyMGZsYXZvciUzRCUyMmExMGctc21hbGwlMjIlMkMlMjBzY2hlZHVsZSUzRCUyMiU0MHdlZWtseSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_scheduled_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>script = <span class="hljs-string">&quot;lighteval&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>script_args= [<span class="hljs-string">&quot;endpoint&quot;</span>, <span class="hljs-string">&quot;inference-providers&quot;</span>, <span class="hljs-string">&quot;model_name=openai/gpt-oss-20b,provider=auto&quot;</span>, <span class="hljs-string">&quot;lighteval|gsm8k|0|0&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_uv_job(script, script_args=script_args, dependencies=[<span class="hljs-string">&quot;lighteval&quot;</span>], flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>, schedule=<span class="hljs-string">&quot;@weekly&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-l2cd0v"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function JH(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV93ZWJob29rJTBBcGF5bG9hZCUyMCUzRCUyMGNyZWF0ZV93ZWJob29rKCUwQSUyMCUyMCUyMCUyMHdhdGNoZWQlM0QlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMm5hbWUlMjIlM0ElMjAlMjJqdWxpZW4tYyUyMiU3RCUyQyUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJvcmclMjIlMkMlMjAlMjJuYW1lJTIyJTNBJTIwJTIySHVnZ2luZ0ZhY2VINCUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMHVybCUzRCUyMmh0dHBzJTNBJTJGJTJGd2ViaG9vay5zaXRlJTJGYTIxNzZlODItNTcyMC00M2VlLTllMDYtZjkxY2I0YzkxNTQ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwZG9tYWlucyUzRCU1QiUyMnJlcG8lMjIlMkMlMjAlMjJkaXNjdXNzaW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2VjcmV0JTNEJTIybXktc2VjcmV0JTIyJTJDJTBBKSUwQXByaW50KHBheWxvYWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>payload = create_webhook(
<span class="hljs-meta">... </span>    watched=[{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;julien-c&quot;</span>}, {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;org&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;HuggingFaceH4&quot;</span>}],
<span class="hljs-meta">... </span>    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
<span class="hljs-meta">... </span>    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
<span class="hljs-meta">... </span>    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(payload)
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function NH(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1jar68o"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function AH(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRlbGV0ZV9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGRlbGV0ZV9jb2xsZWN0aW9uKCUyMnVzZXJuYW1lJTJGdXNlbGVzcy1jb2xsZWN0aW9uLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUyMG1pc3Npbmdfb2slM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> delete_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = delete_collection(<span class="hljs-string">&quot;username/useless-collection-64f9a55bb3115b4f513ec026&quot;</span>, missing_ok=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function EH(T){let n,y="This is a non-revertible action. A deleted collection cannot be restored.";return{c(){n=c("p"),n.textContent=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1k7dttx"&&(n.textContent=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function DH(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTJDJTIwZGVsZXRlX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb24lMjAlM0QlMjBnZXRfY29sbGVjdGlvbiglMjJUaGVCbG9rZSUyRnJlY2VudC1tb2RlbHMtNjRmOWE1NWJiMzExNWI0ZjUxM2VjMDI2JTIyKSUwQSUwQWRlbGV0ZV9jb2xsZWN0aW9uX2l0ZW0oJTBBJTIwJTIwJTIwJTIwY29sbGVjdGlvbl9zbHVnJTNEJTIyVGhlQmxva2UlMkZyZWNlbnQtbW9kZWxzLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1fb2JqZWN0X2lkJTNEY29sbGVjdGlvbi5pdGVtcyU1Qi0xJTVELml0ZW1fb2JqZWN0X2lkJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection, delete_collection_item

<span class="hljs-comment"># Get collection first</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>)

<span class="hljs-comment"># Delete item based on its ID</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>delete_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>,
<span class="hljs-meta">... </span>    item_object_id=collection.items[-<span class="hljs-number">1</span>].item_object_id,
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function RH(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError">EntryNotFoundError</a>
If the file to download cannot be found.</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1qc32pt"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function GH(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRlbGV0ZV93ZWJob29rJTBBZGVsZXRlX3dlYmhvb2soJTIyNjU0YmJiYzE2ZjJlYzE0ZDc3ZjEwOWNjJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> delete_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>delete_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function ZH(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRpc2FibGVfd2ViaG9vayUwQWRpc2FibGVkX3dlYmhvb2slMjAlM0QlMjBkaXNhYmxlX3dlYmhvb2soJTIyNjU0YmJiYzE2ZjJlYzE0ZDc3ZjEwOWNjJTIyKSUwQWRpc2FibGVkX3dlYmhvb2s=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> disable_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>disabled_webhook = disable_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>disabled_webhook
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function FH(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGR1cGxpY2F0ZV9zcGFjZSUwQSUwQWR1cGxpY2F0ZV9zcGFjZSglMjJtdWx0aW1vZGFsYXJ0JTJGZHJlYW1ib290aC10cmFpbmluZyUyMiklMEElMEFkdXBsaWNhdGVfc3BhY2UoJTIybXVsdGltb2RhbGFydCUyRmRyZWFtYm9vdGgtdHJhaW5pbmclMjIlMkMlMjB0b19pZCUzRCUyMm15LWRyZWFtYm9vdGglMjIlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> duplicate_space

<span class="hljs-comment"># Duplicate a Space to your account</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/spaces/nateraw/dreambooth-training&#x27;</span>,...)

<span class="hljs-comment"># Can set custom destination id and visibility flag.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>, to_id=<span class="hljs-string">&quot;my-dreambooth&quot;</span>, private=<span class="hljs-literal">True</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/spaces/nateraw/my-dreambooth&#x27;</span>,...)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function SH(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function LH(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGVuYWJsZV93ZWJob29rJTBBZW5hYmxlZF93ZWJob29rJTIwJTNEJTIwZW5hYmxlX3dlYmhvb2soJTIyNjU0YmJiYzE2ZjJlYzE0ZDc3ZjEwOWNjJTIyKSUwQWVuYWJsZWRfd2ViaG9vaw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> enable_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>enabled_webhook = enable_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>enabled_webhook
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function WH(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGZldGNoX2pvYl9sb2dzJTJDJTIwcnVuX2pvYiUwQWpvYiUyMCUzRCUyMHJ1bl9qb2IoaW1hZ2UlM0QlMjJweXRob24lM0EzLjEyJTIyJTJDJTIwY29tbWFuZCUzRCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTIwJTJDJTIycHJpbnQoJ0hlbGxvJTIwZnJvbSUyMEhGJTIwY29tcHV0ZSEnKSUyMiU1RCklMEFmb3IlMjBsb2clMjBpbiUyMGZldGNoX2pvYl9sb2dzKGpvYi5pZCklM0ElMEElMjAlMjAlMjAlMjBwcmludChsb2cp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> fetch_job_logs, run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>job = run_job(image=<span class="hljs-string">&quot;python:3.12&quot;</span>, command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span> ,<span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> fetch_job_logs(job.<span class="hljs-built_in">id</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(log)
Hello <span class="hljs-keyword">from</span> HF compute!`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function VH(T){let n,y="Examples:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGZpbGVfZXhpc3RzJTBBZmlsZV9leGlzdHMoJTIyYmlnY29kZSUyRnN0YXJjb2RlciUyMiUyQyUyMCUyMmNvbmZpZy5qc29uJTIyKSUwQWZpbGVfZXhpc3RzKCUyMmJpZ2NvZGUlMkZzdGFyY29kZXIlMjIlMkMlMjAlMjJub3QtYS1maWxlJTIyKSUwQWZpbGVfZXhpc3RzKCUyMmJpZ2NvZGUlMkZub3QtYS1yZXBvJTIyJTJDJTIwJTIyY29uZmlnLmpzb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> file_exists
<span class="hljs-meta">&gt;&gt;&gt; </span>file_exists(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>, <span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_exists(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>, <span class="hljs-string">&quot;not-a-file&quot;</span>)
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_exists(<span class="hljs-string">&quot;bigcode/not-a-repo&quot;</span>, <span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-kvfsh7"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function BH(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGdldF9jb2xsZWN0aW9uKCUyMlRoZUJsb2tlJTJGcmVjZW50LW1vZGVscy02NGY5YTU1YmIzMTE1YjRmNTEzZWMwMjYlMjIpJTBBY29sbGVjdGlvbi50aXRsZSUwQWxlbihjb2xsZWN0aW9uLml0ZW1zKSUwQWNvbGxlY3Rpb24uaXRlbXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.title
<span class="hljs-string">&#x27;Recent models&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(collection.items)
<span class="hljs-number">37</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.items[<span class="hljs-number">0</span>]
CollectionItem(
    item_object_id=<span class="hljs-string">&#x27;651446103cd773a050bf64c2&#x27;</span>,
    item_id=<span class="hljs-string">&#x27;TheBloke/U-Amethyst-20B-AWQ&#x27;</span>,
    item_type=<span class="hljs-string">&#x27;model&#x27;</span>,
    position=<span class="hljs-number">88</span>,
    note=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function PH(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function YH(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmdldF9pbmZlcmVuY2VfZW5kcG9pbnQoJTIybXktdGV4dC10by1pbWFnZSUyMiklMEFlbmRwb2ludCUwQSUwQWVuZHBvaW50LnN0YXR1cyUwQWVuZHBvaW50LnVybCUwQSUwQWVuZHBvaW50LmNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.get_inference_endpoint(<span class="hljs-string">&quot;my-text-to-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-text-to-image&#x27;</span>, ...)

<span class="hljs-comment"># Get status</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.status
<span class="hljs-string">&#x27;running&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.url
<span class="hljs-string">&#x27;https://my-text-to-image.region.vendor.endpoints.huggingface.cloud&#x27;</span>

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_to_image(...)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function XH(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9wYXRoc19pbmZvJTBBcGF0aHNfaW5mbyUyMCUzRCUyMGdldF9wYXRoc19pbmZvKCUyMmFsbGVuYWklMkZjNCUyMiUyQyUyMCU1QiUyMlJFQURNRS5tZCUyMiUyQyUyMCUyMmVuJTIyJTVEJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiklMEFwYXRoc19pbmZv",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_paths_info
<span class="hljs-meta">&gt;&gt;&gt; </span>paths_info = get_paths_info(<span class="hljs-string">&quot;allenai/c4&quot;</span>, [<span class="hljs-string">&quot;README.md&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>], repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>paths_info
[
    RepoFile(path=<span class="hljs-string">&#x27;README.md&#x27;</span>, size=<span class="hljs-number">2379</span>, blob_id=<span class="hljs-string">&#x27;f84cb4c97182890fc1dbdeaf1a6a468fd27b4fff&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFolder(path=<span class="hljs-string">&#x27;en&#x27;</span>, tree_id=<span class="hljs-string">&#x27;dc943c4c40f53d02b31ced1defa7e5f438d5862e&#x27;</span>, last_commit=<span class="hljs-literal">None</span>)
]`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function zH(T){let n,y="Collecting all discussions of a repo in a list:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9yZXBvX2Rpc2N1c3Npb25zJTBBZGlzY3Vzc2lvbnNfbGlzdCUyMCUzRCUyMGxpc3QoZ2V0X3JlcG9fZGlzY3Vzc2lvbnMocmVwb19pZCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_repo_discussions
<span class="hljs-meta">&gt;&gt;&gt; </span>discussions_list = <span class="hljs-built_in">list</span>(get_repo_discussions(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>))`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1p6axsk"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function QH(T){let n,y="Iterating over discussions of a repo:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9yZXBvX2Rpc2N1c3Npb25zJTBBZm9yJTIwZGlzY3Vzc2lvbiUyMGluJTIwZ2V0X3JlcG9fZGlzY3Vzc2lvbnMocmVwb19pZCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGRpc2N1c3Npb24ubnVtJTJDJTIwZGlzY3Vzc2lvbi50aXRsZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_repo_discussions
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> discussion <span class="hljs-keyword">in</span> get_repo_discussions(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(discussion.num, discussion.title)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-121l6g4"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function OH(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"bWV0YWRhdGElMjAlM0QlMjBnZXRfc2FmZXRlbnNvcnNfbWV0YWRhdGEoJTIyYmlnc2NpZW5jZSUyRmJsb29tei01NjBtJTIyKSUwQW1ldGFkYXRhJTBBbWV0YWRhdGEuZmlsZXNfbWV0YWRhdGElNUIlMjJtb2RlbC5zYWZldGVuc29ycyUyMiU1RC5tZXRhZGF0YSUwQSUwQW1ldGFkYXRhJTIwJTNEJTIwZ2V0X3NhZmV0ZW5zb3JzX21ldGFkYXRhKCUyMmJpZ3NjaWVuY2UlMkZibG9vbSUyMiklMEFtZXRhZGF0YSUwQWxlbihtZXRhZGF0YS5maWxlc19tZXRhZGF0YSklMEElMEFnZXRfc2FmZXRlbnNvcnNfbWV0YWRhdGEoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIp",highlighted:`<span class="hljs-comment"># Parse repo with single weights file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata = get_safetensors_metadata(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata
SafetensorsRepoMetadata(
    metadata=<span class="hljs-literal">None</span>,
    sharded=<span class="hljs-literal">False</span>,
    weight_map={<span class="hljs-string">&#x27;h.0.input_layernorm.bias&#x27;</span>: <span class="hljs-string">&#x27;model.safetensors&#x27;</span>, ...},
    files_metadata={<span class="hljs-string">&#x27;model.safetensors&#x27;</span>: SafetensorsFileMetadata(...)}
)
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata.files_metadata[<span class="hljs-string">&quot;model.safetensors&quot;</span>].metadata
{<span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;pt&#x27;</span>}

<span class="hljs-comment"># Parse repo with sharded model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata = get_safetensors_metadata(<span class="hljs-string">&quot;bigscience/bloom&quot;</span>)
Parse safetensors files: <span class="hljs-number">100</span>%|██████████████████████████████████████████| <span class="hljs-number">72</span>/<span class="hljs-number">72</span> [<span class="hljs-number">00</span>:<span class="hljs-number">12</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">5.78</span>it/s]
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata
SafetensorsRepoMetadata(metadata={<span class="hljs-string">&#x27;total_size&#x27;</span>: <span class="hljs-number">352494542848</span>}, sharded=<span class="hljs-literal">True</span>, weight_map={...}, files_metadata={...})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(metadata.files_metadata)
<span class="hljs-number">72</span>  <span class="hljs-comment"># All safetensors files have been fetched</span>

<span class="hljs-comment"># Parse repo with sharded model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>get_safetensors_metadata(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
NotASafetensorsRepoError: <span class="hljs-string">&#x27;runwayml/stable-diffusion-v1-5&#x27;</span> <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> a safetensors repo. Couldn<span class="hljs-string">&#x27;t find &#x27;</span>model.safetensors.index.json<span class="hljs-string">&#x27; or &#x27;</span>model.safetensors<span class="hljs-string">&#x27; files.</span>`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function KH(T){let n,y=`This method is deprecated and will be removed in version 1.0. Permissions are more complex than when
<code>get_token_permission</code> was first introduced. OAuth and fine-grain tokens allows for more detailed permissions.
If you need to know the permissions associated with a token, please use <code>whoami</code> and check the <code>&#39;auth&#39;</code> key.`;return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1uyfywd"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function eU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF93ZWJob29rJTBBd2ViaG9vayUyMCUzRCUyMGdldF93ZWJob29rKCUyMjY1NGJiYmMxNmYyZWMxNGQ3N2YxMDljYyUyMiklMEFwcmludCh3ZWJob29rKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>webhook = get_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(webhook)
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function tU(T){let n,y;return n=new U({props:{code:"JTVCJTIwJTIwOTYlNUQlMjAlMjAuJTBBJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwJTVCJTIwMTYwJTVEJTIwJTIwbW9kZWxzLS1qdWxpZW4tYy0tRXNwZXJCRVJUby1zbWFsbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMCU1QiUyMDE2MCU1RCUyMCUyMGJsb2JzJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwJTVCMzIxTSU1RCUyMCUyMDQwMzQ1MGUyMzRkNjU5NDNhN2RjZjdlMDVhNzcxY2UzYzkyZmFhODRkZDA3ZGI0YWMyMGY1OTIwMzdhMWU0YmQlMEElMjAlMjAlMjAlMjAlRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAzOTglNUQlMjAlMjA3Y2IxOGRjOWJhZmJmY2Y3NDYyOWE0Yjc2MGFmMWIxNjA5NTdhODNlJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwJTVCMS40SyU1RCUyMCUyMGQ3ZWRmNmJkMmE2ODFmYjAxNzVmNzczNTI5OTgzMWVlMWIyMmI4MTIlMEElMjAlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAlMjA5NiU1RCUyMCUyMHJlZnMlMEElMjAlMjAlMjAlMjAlRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAlMjA0MCU1RCUyMCUyMG1haW4lMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAxMjglNUQlMjAlMjBzbmFwc2hvdHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAxMjglNUQlMjAlMjAyNDM5ZjYwZWYzM2EwZDQ2ZDg1ZGE1MDAxZDUyYWVkYTViMDBjZTlmJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwJTVCJTIwJTIwNTIlNUQlMjAlMjBSRUFETUUubWQlMjAtJTNFJTIwLi4lMkYuLiUyRmJsb2JzJTJGZDdlZGY2YmQyYTY4MWZiMDE3NWY3NzM1Mjk5ODMxZWUxYjIyYjgxMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMCU1QiUyMCUyMDc2JTVEJTIwJTIwcHl0b3JjaF9tb2RlbC5iaW4lMjAtJTNFJTIwLi4lMkYuLiUyRmJsb2JzJTJGNDAzNDUwZTIzNGQ2NTk0M2E3ZGNmN2UwNWE3NzFjZTNjOTJmYWE4NGRkMDdkYjRhYzIwZjU5MjAzN2ExZTRiZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMCU1QiUyMDEyOCU1RCUyMCUyMGJiYzc3YzgxMzJhZjFjYzVjZjY3OGRhM2YxZGRmMmRlNDM2MDZkNDglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAlMjA1MiU1RCUyMCUyMFJFQURNRS5tZCUyMC0lM0UlMjAuLiUyRi4uJTJGYmxvYnMlMkY3Y2IxOGRjOWJhZmJmY2Y3NDYyOWE0Yjc2MGFmMWIxNjA5NTdhODNlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwJTVCJTIwJTIwNzYlNUQlMjAlMjBweXRvcmNoX21vZGVsLmJpbiUyMC0lM0UlMjAuLiUyRi4uJTJGYmxvYnMlMkY0MDM0NTBlMjM0ZDY1OTQzYTdkY2Y3ZTA1YTc3MWNlM2M5MmZhYTg0ZGQwN2RiNGFjMjBmNTkyMDM3YTFlNGJk",highlighted:`<span class="hljs-selector-attr">[  96]</span>  .
└── <span class="hljs-selector-attr">[ 160]</span>  models<span class="hljs-attr">--julien-c--EsperBERTo-small</span>
    ├── <span class="hljs-selector-attr">[ 160]</span>  blobs
    │   ├── <span class="hljs-selector-attr">[321M]</span>  <span class="hljs-number">403450</span>e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
    │   ├── <span class="hljs-selector-attr">[ 398]</span>  <span class="hljs-number">7</span>cb18dc9bafbfcf74629a4b760af1b160957a83e
    │   └── <span class="hljs-selector-attr">[1.4K]</span>  d7edf6bd2a681fb0175f7735299831ee1b22b812
    ├── <span class="hljs-selector-attr">[  96]</span>  refs
    │   └── <span class="hljs-selector-attr">[  40]</span>  <span class="hljs-selector-tag">main</span>
    └── <span class="hljs-selector-attr">[ 128]</span>  snapshots
        ├── <span class="hljs-selector-attr">[ 128]</span>  <span class="hljs-number">2439</span>f60ef33a0d46d85da5001d52aeda5b00ce9f
        │   ├── <span class="hljs-selector-attr">[  52]</span>  README<span class="hljs-selector-class">.md</span> -&gt; ../../blobs/d7edf6bd2a681fb0175f7735299831ee1b22b812
        │   └── <span class="hljs-selector-attr">[  76]</span>  pytorch_model<span class="hljs-selector-class">.bin</span> -&gt; ../../blobs/<span class="hljs-number">403450</span>e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
        └── <span class="hljs-selector-attr">[ 128]</span>  bbc77c8132af1cc5cf678da3f1ddf2de43606d48
            ├── <span class="hljs-selector-attr">[  52]</span>  README<span class="hljs-selector-class">.md</span> -&gt; ../../blobs/<span class="hljs-number">7</span>cb18dc9bafbfcf74629a4b760af1b160957a83e
            └── <span class="hljs-selector-attr">[  76]</span>  pytorch_model<span class="hljs-selector-class">.bin</span> -&gt; ../../blobs/<span class="hljs-number">403450</span>e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd`,wrap:!1}}),{c(){u(n.$$.fragment)},l(i){h(n.$$.fragment,i)},m(i,a){f(n,i,a),y=!0},p:H,i(i){y||(m(n.$$.fragment,i),y=!0)},o(i){_(n.$$.fragment,i),y=!1},d(i){b(n,i)}}}function nU(T){let n;return{c(){n=cH("Hidden comments' content cannot be retrieved anymore. Hiding a comment is irreversible.")},l(y){n=lH(y,"Hidden comments' content cannot be retrieved anymore. Hiding a comment is irreversible.")},m(y,i){$(y,n,i)},d(y){y&&p(n)}}}function oU(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function aU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGluc3BlY3Rfam9iJTJDJTIwcnVuX2pvYiUwQWpvYiUyMCUzRCUyMHJ1bl9qb2IoaW1hZ2UlM0QlMjJweXRob24lM0EzLjEyJTIyJTJDJTIwY29tbWFuZCUzRCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTIwJTJDJTIycHJpbnQoJ0hlbGxvJTIwZnJvbSUyMEhGJTIwY29tcHV0ZSEnKSUyMiU1RCklMEFpbnNwZWN0X2pvYihqb2IuaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> inspect_job, run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>job = run_job(image=<span class="hljs-string">&quot;python:3.12&quot;</span>, command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span> ,<span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>inspect_job(job.<span class="hljs-built_in">id</span>)
JobInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;68780d00bbe36d38803f645f&#x27;</span>,
    created_at=datetime.datetime(<span class="hljs-number">2025</span>, <span class="hljs-number">7</span>, <span class="hljs-number">16</span>, <span class="hljs-number">20</span>, <span class="hljs-number">35</span>, <span class="hljs-number">12</span>, <span class="hljs-number">808000</span>, tzinfo=datetime.timezone.utc),
    docker_image=<span class="hljs-string">&#x27;python:3.12&#x27;</span>,
    space_id=<span class="hljs-literal">None</span>,
    command=[<span class="hljs-string">&#x27;python&#x27;</span>, <span class="hljs-string">&#x27;-c&#x27;</span>, <span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>],
    arguments=[],
    environment={},
    secrets={},
    flavor=<span class="hljs-string">&#x27;cpu-basic&#x27;</span>,
    status=JobStatus(stage=<span class="hljs-string">&#x27;RUNNING&#x27;</span>, message=<span class="hljs-literal">None</span>)
)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function sU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGluc3BlY3Rfam9iJTJDJTIwY3JlYXRlX3NjaGVkdWxlZF9qb2IlMEFzY2hlZHVsZWRfam9iJTIwJTNEJTIwY3JlYXRlX3NjaGVkdWxlZF9qb2IoaW1hZ2UlM0QlMjJweXRob24lM0EzLjEyJTIyJTJDJTIwY29tbWFuZCUzRCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTIwJTJDJTIycHJpbnQoJ0hlbGxvJTIwZnJvbSUyMEhGJTIwY29tcHV0ZSEnKSUyMiU1RCUyQyUyMHNjaGVkdWxlJTNEJTIyJTQwaG91cmx5JTIyKSUwQWluc3BlY3Rfc2NoZWR1bGVkX2pvYihzY2hlZHVsZWRfam9iLmlkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> inspect_job, create_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduled_job = create_scheduled_job(image=<span class="hljs-string">&quot;python:3.12&quot;</span>, command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span> ,<span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>], schedule=<span class="hljs-string">&quot;@hourly&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inspect_scheduled_job(scheduled_job.<span class="hljs-built_in">id</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function rU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfYWNjZXB0ZWRfYWNjZXNzX3JlcXVlc3RzJTBBJTBBcmVxdWVzdHMlMjAlM0QlMjBsaXN0X2FjY2VwdGVkX2FjY2Vzc19yZXF1ZXN0cyglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03YiUyMiklMEFsZW4ocmVxdWVzdHMpJTBBcmVxdWVzdHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_accepted_access_requests

<span class="hljs-meta">&gt;&gt;&gt; </span>requests = list_accepted_access_requests(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(requests)
<span class="hljs-number">411</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests[<span class="hljs-number">0</span>]
[
    AccessRequest(
        username=<span class="hljs-string">&#x27;clem&#x27;</span>,
        fullname=<span class="hljs-string">&#x27;Clem 🤗&#x27;</span>,
        email=<span class="hljs-string">&#x27;***&#x27;</span>,
        timestamp=datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">11</span>, <span class="hljs-number">23</span>, <span class="hljs-number">18</span>, <span class="hljs-number">4</span>, <span class="hljs-number">53</span>, <span class="hljs-number">828000</span>, tzinfo=datetime.timezone.utc),
        status=<span class="hljs-string">&#x27;accepted&#x27;</span>,
        fields=<span class="hljs-literal">None</span>,
    ),
    ...
]`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function iU(T){let n,y=`When listing collections, the item list per collection is truncated to 4 items maximum. To retrieve all items
from a collection, you must use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_collection">get_collection()</a>.`;return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1azfyye"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function cU(T){let n,y="Example usage with the <code>filter</code> argument:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X2RhdGFzZXRzKCklMEElMEElMEFhcGkubGlzdF9kYXRhc2V0cyhmaWx0ZXIlM0QlMjJ0YXNrX2NhdGVnb3JpZXMlM0F0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyKSUwQSUwQSUwQWFwaS5saXN0X2RhdGFzZXRzKCUwQSUyMCUyMCUyMCUyMGZpbHRlciUzRCglMjJsYW5ndWFnZSUzQXJ1JTIyJTJDJTIwJTIydGFza19pZHMlM0FsYW5ndWFnZS1tb2RlbGluZyUyMiklMEEpJTBBJTBBYXBpLmxpc3RfZGF0YXNldHModGFncyUzRCUyMmZpZnR5b25lJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all datasets</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets()


<span class="hljs-comment"># List only the text classification datasets</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(<span class="hljs-built_in">filter</span>=<span class="hljs-string">&quot;task_categories:text-classification&quot;</span>)


<span class="hljs-comment"># List only the datasets in russian for language modeling</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(
<span class="hljs-meta">... </span>    <span class="hljs-built_in">filter</span>=(<span class="hljs-string">&quot;language:ru&quot;</span>, <span class="hljs-string">&quot;task_ids:language-modeling&quot;</span>)
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># List FiftyOne datasets (identified by the tag &quot;fiftyone&quot; in dataset card)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(tags=<span class="hljs-string">&quot;fiftyone&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.innerHTML=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1lrmw6w"&&(n.innerHTML=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function lU(T){let n,y="Example usage with the <code>search</code> argument:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X2RhdGFzZXRzKHNlYXJjaCUzRCUyMnRleHQlMjIpJTBBJTBBYXBpLmxpc3RfZGF0YXNldHMoc2VhcmNoJTNEJTIydGV4dCUyMiUyQyUyMGF1dGhvciUzRCUyMmdvb2dsZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all datasets with &quot;text&quot; in their name</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(search=<span class="hljs-string">&quot;text&quot;</span>)

<span class="hljs-comment"># List all datasets with &quot;text&quot; in their name made by google</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(search=<span class="hljs-string">&quot;text&quot;</span>, author=<span class="hljs-string">&quot;google&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.innerHTML=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1oyacuq"&&(n.innerHTML=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function pU(T){let n,y=`<code>list_inference_catalog</code> is experimental. Its API is subject to change in the future. Please provide feedback
if you have any suggestions or requests.`;return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-jn3ftn"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function dU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5saXN0X2luZmVyZW5jZV9lbmRwb2ludHMoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_inference_endpoints()
[InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint&#x27;</span>, ...), ...]`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function gU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWxmc19maWxlcyUyMCUzRCUyMGFwaS5saXN0X2xmc19maWxlcyglMjJ1c2VybmFtZSUyRm15LWNvb2wtcmVwbyUyMiklMEElMEFsZnNfZmlsZXNfdG9fZGVsZXRlJTIwJTNEJTIwKGxmc19maWxlJTIwZm9yJTIwbGZzX2ZpbGUlMjBpbiUyMGxmc19maWxlcyUyMGlmJTIwbGZzX2ZpbGUuZmlsZW5hbWUuc3RhcnRzd2l0aCglMjJjaGVja3BvaW50cyUyRiUyMikpJTBBJTBBYXBpLnBlcm1hbmVudGx5X2RlbGV0ZV9sZnNfZmlsZXMoJTIydXNlcm5hbWUlMkZteS1jb29sLXJlcG8lMjIlMkMlMjBsZnNfZmlsZXNfdG9fZGVsZXRlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files = api.list_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>)

<span class="hljs-comment"># Filter files files to delete based on a combination of \`filename\`, \`pushed_at\`, \`ref\` or \`size\`.</span>
<span class="hljs-comment"># e.g. select only LFS files in the &quot;checkpoints&quot; folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files_to_delete = (lfs_file <span class="hljs-keyword">for</span> lfs_file <span class="hljs-keyword">in</span> lfs_files <span class="hljs-keyword">if</span> lfs_file.filename.startswith(<span class="hljs-string">&quot;checkpoints/&quot;</span>))

<span class="hljs-comment"># Permanently delete LFS files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.permanently_delete_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>, lfs_files_to_delete)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function uU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfbGlrZWRfcmVwb3MlMEElMEFsaWtlcyUyMCUzRCUyMGxpc3RfbGlrZWRfcmVwb3MoJTIyanVsaWVuLWMlMjIpJTBBJTBBbGlrZXMudXNlciUwQSUwQWxpa2VzLm1vZGVscw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_liked_repos

<span class="hljs-meta">&gt;&gt;&gt; </span>likes = list_liked_repos(<span class="hljs-string">&quot;julien-c&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>likes.user
<span class="hljs-string">&quot;julien-c&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>likes.models
[<span class="hljs-string">&quot;osanseviero/streamlit_1.15&quot;</span>, <span class="hljs-string">&quot;Xhaheen/ChatGPT_HF&quot;</span>, ...]`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function hU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X21vZGVscygpJTBBJTBBYXBpLmxpc3RfbW9kZWxzKGZpbHRlciUzRCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBYXBpLmxpc3RfbW9kZWxzKGZpbHRlciUzRCUyMmtlcmFzLWh1YiUyMiklMEElMEFhcGkubGlzdF9tb2RlbHMoaW5mZXJlbmNlX3Byb3ZpZGVyJTNEJTIyY29oZXJlJTIyKSUwQSUwQWFwaS5saXN0X21vZGVscyhzZWFyY2glM0QlMjJiZXJ0JTIyKSUwQSUwQWFwaS5saXN0X21vZGVscyhzZWFyY2glM0QlMjJiZXJ0JTIyJTJDJTIwYXV0aG9yJTNEJTIyZ29vZ2xlJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all models</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models()

<span class="hljs-comment"># List text classification models</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(<span class="hljs-built_in">filter</span>=<span class="hljs-string">&quot;text-classification&quot;</span>)

<span class="hljs-comment"># List models from the KerasHub library</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(<span class="hljs-built_in">filter</span>=<span class="hljs-string">&quot;keras-hub&quot;</span>)

<span class="hljs-comment"># List models served by Cohere</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(inference_provider=<span class="hljs-string">&quot;cohere&quot;</span>)

<span class="hljs-comment"># List models with &quot;bert&quot; in their name</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(search=<span class="hljs-string">&quot;bert&quot;</span>)

<span class="hljs-comment"># List models with &quot;bert&quot; in their name and pushed by google</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(search=<span class="hljs-string">&quot;bert&quot;</span>, author=<span class="hljs-string">&quot;google&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function fU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X3BhcGVycyhxdWVyeSUzRCUyMmF0dGVudGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all papers with &quot;attention&quot; in their title</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_papers(query=<span class="hljs-string">&quot;attention&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function mU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcGVuZGluZ19hY2Nlc3NfcmVxdWVzdHMlMkMlMjBhY2NlcHRfYWNjZXNzX3JlcXVlc3QlMEElMEFyZXF1ZXN0cyUyMCUzRCUyMGxpc3RfcGVuZGluZ19hY2Nlc3NfcmVxdWVzdHMoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2IlMjIpJTBBbGVuKHJlcXVlc3RzKSUwQXJlcXVlc3RzJTVCMCU1RCUwQSUwQWFjY2VwdF9hY2Nlc3NfcmVxdWVzdCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03YiUyMiUyQyUyMCUyMmNsZW0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_pending_access_requests, accept_access_request

<span class="hljs-comment"># List pending requests</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests = list_pending_access_requests(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(requests)
<span class="hljs-number">411</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests[<span class="hljs-number">0</span>]
[
    AccessRequest(
        username=<span class="hljs-string">&#x27;clem&#x27;</span>,
        fullname=<span class="hljs-string">&#x27;Clem 🤗&#x27;</span>,
        email=<span class="hljs-string">&#x27;***&#x27;</span>,
        timestamp=datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">11</span>, <span class="hljs-number">23</span>, <span class="hljs-number">18</span>, <span class="hljs-number">4</span>, <span class="hljs-number">53</span>, <span class="hljs-number">828000</span>, tzinfo=datetime.timezone.utc),
        status=<span class="hljs-string">&#x27;pending&#x27;</span>,
        fields=<span class="hljs-literal">None</span>,
    ),
    ...
]

<span class="hljs-comment"># Accept Clem&#x27;s request</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>accept_access_request(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>, <span class="hljs-string">&quot;clem&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function _U(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVqZWN0ZWRfYWNjZXNzX3JlcXVlc3RzJTBBJTBBcmVxdWVzdHMlMjAlM0QlMjBsaXN0X3JlamVjdGVkX2FjY2Vzc19yZXF1ZXN0cyglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03YiUyMiklMEFsZW4ocmVxdWVzdHMpJTBBcmVxdWVzdHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_rejected_access_requests

<span class="hljs-meta">&gt;&gt;&gt; </span>requests = list_rejected_access_requests(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(requests)
<span class="hljs-number">411</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests[<span class="hljs-number">0</span>]
[
    AccessRequest(
        username=<span class="hljs-string">&#x27;clem&#x27;</span>,
        fullname=<span class="hljs-string">&#x27;Clem 🤗&#x27;</span>,
        email=<span class="hljs-string">&#x27;***&#x27;</span>,
        timestamp=datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">11</span>, <span class="hljs-number">23</span>, <span class="hljs-number">18</span>, <span class="hljs-number">4</span>, <span class="hljs-number">53</span>, <span class="hljs-number">828000</span>, tzinfo=datetime.timezone.utc),
        status=<span class="hljs-string">&#x27;rejected&#x27;</span>,
        fields=<span class="hljs-literal">None</span>,
    ),
    ...
]`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function bU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWluaXRpYWxfY29tbWl0JTIwJTNEJTIwYXBpLmxpc3RfcmVwb19jb21taXRzKCUyMmdwdDIlMjIpJTVCLTElNUQlMEElMEFpbml0aWFsX2NvbW1pdCUwQSUwQWFwaS5jcmVhdGVfYnJhbmNoKCUyMmdwdDIlMjIlMkMlMjAlMjJuZXdfZW1wdHlfYnJhbmNoJTIyJTJDJTIwcmV2aXNpb24lM0Rpbml0aWFsX2NvbW1pdC5jb21taXRfaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># Commits are sorted by date (last commit first)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>initial_commit = api.list_repo_commits(<span class="hljs-string">&quot;gpt2&quot;</span>)[-<span class="hljs-number">1</span>]

<span class="hljs-comment"># Initial commit is always a system commit containing the \`.gitattributes\` file.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>initial_commit
GitCommitInfo(
    commit_id=<span class="hljs-string">&#x27;9b865efde13a30c13e0a33e536cf3e4a5a9d71d8&#x27;</span>,
    authors=[<span class="hljs-string">&#x27;system&#x27;</span>],
    created_at=datetime.datetime(<span class="hljs-number">2019</span>, <span class="hljs-number">2</span>, <span class="hljs-number">18</span>, <span class="hljs-number">10</span>, <span class="hljs-number">36</span>, <span class="hljs-number">15</span>, tzinfo=datetime.timezone.utc),
    title=<span class="hljs-string">&#x27;initial commit&#x27;</span>,
    message=<span class="hljs-string">&#x27;&#x27;</span>,
    formatted_title=<span class="hljs-literal">None</span>,
    formatted_message=<span class="hljs-literal">None</span>
)

<span class="hljs-comment"># Create an empty branch by deriving from initial commit</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_branch(<span class="hljs-string">&quot;gpt2&quot;</span>, <span class="hljs-string">&quot;new_empty_branch&quot;</span>, revision=initial_commit.commit_id)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function yU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5saXN0X3JlcG9fcmVmcyglMjJncHQyJTIyKSUwQSUwQWFwaS5saXN0X3JlcG9fcmVmcyglMjJiaWdjb2RlJTJGdGhlLXN0YWNrJTIyJTJDJTIwcmVwb190eXBlJTNEJ2RhdGFzZXQnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_repo_refs(<span class="hljs-string">&quot;gpt2&quot;</span>)
GitRefs(branches=[GitRefInfo(name=<span class="hljs-string">&#x27;main&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>, target_commit=<span class="hljs-string">&#x27;e7da7f221d5bf496a48136c0cd264e630fe9fcc8&#x27;</span>)], converts=[], tags=[])

<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_repo_refs(<span class="hljs-string">&quot;bigcode/the-stack&quot;</span>, repo_type=<span class="hljs-string">&#x27;dataset&#x27;</span>)
GitRefs(
    branches=[
        GitRefInfo(name=<span class="hljs-string">&#x27;main&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>, target_commit=<span class="hljs-string">&#x27;18edc1591d9ce72aa82f56c4431b3c969b210ae3&#x27;</span>),
        GitRefInfo(name=<span class="hljs-string">&#x27;v1.1.a1&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/v1.1.a1&#x27;</span>, target_commit=<span class="hljs-string">&#x27;f9826b862d1567f3822d3d25649b0d6d22ace714&#x27;</span>)
    ],
    converts=[],
    tags=[
        GitRefInfo(name=<span class="hljs-string">&#x27;v1.0&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/tags/v1.0&#x27;</span>, target_commit=<span class="hljs-string">&#x27;c37a8cd1e382064d8aced5e05543c5f7753834da&#x27;</span>)
    ]
)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function vU(T){let n,y;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVwb190cmVlJTBBcmVwb190cmVlJTIwJTNEJTIwbGlzdF9yZXBvX3RyZWUoJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIpJTBBcmVwb190cmVlJTBBbGlzdChyZXBvX3RyZWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_repo_tree
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_tree = list_repo_tree(<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_tree
&lt;generator <span class="hljs-built_in">object</span> HfApi.list_repo_tree at <span class="hljs-number">0x7fa4088e1ac0</span>&gt;
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(repo_tree)
[
    RepoFile(path=<span class="hljs-string">&#x27;.gitattributes&#x27;</span>, size=<span class="hljs-number">391</span>, blob_id=<span class="hljs-string">&#x27;ae8c63daedbd4206d7d40126955d4e6ab1c80f8f&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(path=<span class="hljs-string">&#x27;README.md&#x27;</span>, size=<span class="hljs-number">391</span>, blob_id=<span class="hljs-string">&#x27;43bd404b159de6fba7c2f4d3264347668d43af25&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(path=<span class="hljs-string">&#x27;config.json&#x27;</span>, size=<span class="hljs-number">554</span>, blob_id=<span class="hljs-string">&#x27;2f9618c3a19b9a61add74f70bfb121335aeef666&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(
        path=<span class="hljs-string">&#x27;flax_model.msgpack&#x27;</span>, size=<span class="hljs-number">497764107</span>, blob_id=<span class="hljs-string">&#x27;8095a62ccb4d806da7666fcda07467e2d150218e&#x27;</span>,
        lfs={<span class="hljs-string">&#x27;size&#x27;</span>: <span class="hljs-number">497764107</span>, <span class="hljs-string">&#x27;sha256&#x27;</span>: <span class="hljs-string">&#x27;d88b0d6a6ff9c3f8151f9d3228f57092aaea997f09af009eefd7373a77b5abb9&#x27;</span>, <span class="hljs-string">&#x27;pointer_size&#x27;</span>: <span class="hljs-number">134</span>}, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>
    ),
    RepoFile(path=<span class="hljs-string">&#x27;merges.txt&#x27;</span>, size=<span class="hljs-number">456318</span>, blob_id=<span class="hljs-string">&#x27;226b0752cac7789c48f0cb3ec53eda48b7be36cc&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(
        path=<span class="hljs-string">&#x27;pytorch_model.bin&#x27;</span>, size=<span class="hljs-number">548123560</span>, blob_id=<span class="hljs-string">&#x27;64eaa9c526867e404b68f2c5d66fd78e27026523&#x27;</span>,
        lfs={<span class="hljs-string">&#x27;size&#x27;</span>: <span class="hljs-number">548123560</span>, <span class="hljs-string">&#x27;sha256&#x27;</span>: <span class="hljs-string">&#x27;9be78edb5b928eba33aa88f431551348f7466ba9f5ef3daf1d552398722a5436&#x27;</span>, <span class="hljs-string">&#x27;pointer_size&#x27;</span>: <span class="hljs-number">134</span>}, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>
    ),
    RepoFile(path=<span class="hljs-string">&#x27;vocab.json&#x27;</span>, size=<span class="hljs-number">898669</span>, blob_id=<span class="hljs-string">&#x27;b00361fece0387ca34b4b8b8539ed830d644dbeb&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>)]
]`,wrap:!1}}),{c(){u(n.$$.fragment)},l(i){h(n.$$.fragment,i)},m(i,a){f(n,i,a),y=!0},p:H,i(i){y||(m(n.$$.fragment,i),y=!0)},o(i){_(n.$$.fragment,i),y=!1},d(i){b(n,i)}}}function xU(T){let n,y;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVwb190cmVlJTBBcmVwb190cmVlJTIwJTNEJTIwbGlzdF9yZXBvX3RyZWUoJTIycHJvbXB0aGVybyUyRm9wZW5qb3VybmV5LXY0JTIyJTJDJTIwZXhwYW5kJTNEVHJ1ZSklMEFsaXN0KHJlcG9fdHJlZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_repo_tree
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_tree = list_repo_tree(<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>, expand=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(repo_tree)
[
    RepoFolder(
        path=<span class="hljs-string">&#x27;feature_extractor&#x27;</span>,
        tree_id=<span class="hljs-string">&#x27;aa536c4ea18073388b5b0bc791057a7296a00398&#x27;</span>,
        last_commit={
            <span class="hljs-string">&#x27;oid&#x27;</span>: <span class="hljs-string">&#x27;47b62b20b20e06b9de610e840282b7e6c3d51190&#x27;</span>,
            <span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Upload diffusers weights (#48)&#x27;</span>,
            <span class="hljs-string">&#x27;date&#x27;</span>: datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">3</span>, <span class="hljs-number">21</span>, <span class="hljs-number">9</span>, <span class="hljs-number">5</span>, <span class="hljs-number">27</span>, tzinfo=datetime.timezone.utc)
        }
    ),
    RepoFolder(
        path=<span class="hljs-string">&#x27;safety_checker&#x27;</span>,
        tree_id=<span class="hljs-string">&#x27;65aef9d787e5557373fdf714d6c34d4fcdd70440&#x27;</span>,
        last_commit={
            <span class="hljs-string">&#x27;oid&#x27;</span>: <span class="hljs-string">&#x27;47b62b20b20e06b9de610e840282b7e6c3d51190&#x27;</span>,
            <span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Upload diffusers weights (#48)&#x27;</span>,
            <span class="hljs-string">&#x27;date&#x27;</span>: datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">3</span>, <span class="hljs-number">21</span>, <span class="hljs-number">9</span>, <span class="hljs-number">5</span>, <span class="hljs-number">27</span>, tzinfo=datetime.timezone.utc)
        }
    ),
    RepoFile(
        path=<span class="hljs-string">&#x27;model_index.json&#x27;</span>,
        size=<span class="hljs-number">582</span>,
        blob_id=<span class="hljs-string">&#x27;d3d7c1e8c3e78eeb1640b8e2041ee256e24c9ee1&#x27;</span>,
        lfs=<span class="hljs-literal">None</span>,
        last_commit={
            <span class="hljs-string">&#x27;oid&#x27;</span>: <span class="hljs-string">&#x27;b195ed2d503f3eb29637050a886d77bd81d35f0e&#x27;</span>,
            <span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Fix deprecation warning by changing \`CLIPFeatureExtractor\` to \`CLIPImageProcessor\`. (#54)&#x27;</span>,
            <span class="hljs-string">&#x27;date&#x27;</span>: datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">5</span>, <span class="hljs-number">15</span>, <span class="hljs-number">21</span>, <span class="hljs-number">41</span>, <span class="hljs-number">59</span>, tzinfo=datetime.timezone.utc)
        },
        security={
            <span class="hljs-string">&#x27;safe&#x27;</span>: <span class="hljs-literal">True</span>,
            <span class="hljs-string">&#x27;av_scan&#x27;</span>: {<span class="hljs-string">&#x27;virusFound&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;virusNames&#x27;</span>: <span class="hljs-literal">None</span>},
            <span class="hljs-string">&#x27;pickle_import_scan&#x27;</span>: <span class="hljs-literal">None</span>
        }
    )
    ...
]`,wrap:!1}}),{c(){u(n.$$.fragment)},l(i){h(n.$$.fragment,i)},m(i,a){f(n,i,a),y=!0},p:H,i(i){y||(m(n.$$.fragment,i),y=!0)},o(i){_(n.$$.fragment,i),y=!1},d(i){b(n,i)}}}function $U(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3Rfd2ViaG9va3MlMEF3ZWJob29rcyUyMCUzRCUyMGxpc3Rfd2ViaG9va3MoKSUwQWxlbih3ZWJob29rcyklMEF3ZWJob29rcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_webhooks
<span class="hljs-meta">&gt;&gt;&gt; </span>webhooks = list_webhooks()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(webhooks)
<span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>webhooks[<span class="hljs-number">0</span>]
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function wU(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function kU(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1jar68o"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function TU(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1bg6k8f"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function jU(T){let n,y=`This is a permanent action that will affect all commits referencing the deleted files and might corrupt your
repository. This is a non-revertible operation. Use it only if you know what you are doing.`;return{c(){n=c("p"),n.textContent=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1tduvyk"&&(n.textContent=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function MU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWxmc19maWxlcyUyMCUzRCUyMGFwaS5saXN0X2xmc19maWxlcyglMjJ1c2VybmFtZSUyRm15LWNvb2wtcmVwbyUyMiklMEElMEFsZnNfZmlsZXNfdG9fZGVsZXRlJTIwJTNEJTIwKGxmc19maWxlJTIwZm9yJTIwbGZzX2ZpbGUlMjBpbiUyMGxmc19maWxlcyUyMGlmJTIwbGZzX2ZpbGUuZmlsZW5hbWUuc3RhcnRzd2l0aCglMjJjaGVja3BvaW50cyUyRiUyMikpJTBBJTBBYXBpLnBlcm1hbmVudGx5X2RlbGV0ZV9sZnNfZmlsZXMoJTIydXNlcm5hbWUlMkZteS1jb29sLXJlcG8lMjIlMkMlMjBsZnNfZmlsZXNfdG9fZGVsZXRlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files = api.list_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>)

<span class="hljs-comment"># Filter files files to delete based on a combination of \`filename\`, \`pushed_at\`, \`ref\` or \`size\`.</span>
<span class="hljs-comment"># e.g. select only LFS files in the &quot;checkpoints&quot; folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files_to_delete = (lfs_file <span class="hljs-keyword">for</span> lfs_file <span class="hljs-keyword">in</span> lfs_files <span class="hljs-keyword">if</span> lfs_file.filename.startswith(<span class="hljs-string">&quot;checkpoints/&quot;</span>))

<span class="hljs-comment"># Permanently delete LFS files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.permanently_delete_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>, lfs_files_to_delete)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function qU(T){let n,y=`This is a power-user method. You shouldn’t need to call it directly to make a normal commit.
Use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> directly instead.`;return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1p5fkuq"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function HU(T){let n,y=`Commit operations will be mutated during the process. In particular, the attached <code>path_or_fileobj</code> will be
removed after the upload to save memory (and replaced by an empty <code>bytes</code> object). Do not reuse the same
objects except to pass them to <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>. If you don’t want to remove the attached content from the
commit operation object, pass <code>free_memory=False</code>.`;return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-3d3emz"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function UU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdE9wZXJhdGlvbkFkZCUyQyUyMHByZXVwbG9hZF9sZnNfZmlsZXMlMkMlMjBjcmVhdGVfY29tbWl0JTJDJTIwY3JlYXRlX3JlcG8lMEElMEFyZXBvX2lkJTIwJTNEJTIwY3JlYXRlX3JlcG8oJTIydGVzdF9wcmV1cGxvYWQlMjIpLnJlcG9faWQlMEElMEFvcGVyYXRpb25zJTIwJTNEJTIwJTVCJTVEJTIwJTIzJTIwTGlzdCUyMG9mJTIwYWxsJTIwJTYwQ29tbWl0T3BlcmF0aW9uQWRkJTYwJTIwb2JqZWN0cyUyMHRoYXQlMjB3aWxsJTIwYmUlMjBnZW5lcmF0ZWQlMEFmb3IlMjBpJTIwaW4lMjByYW5nZSg1KSUzQSUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlMjAlM0QlMjAuLi4lMjAlMjMlMjBnZW5lcmF0ZSUyMGJpbmFyeSUyMGNvbnRlbnQlMEElMjAlMjAlMjAlMjBhZGRpdGlvbiUyMCUzRCUyMENvbW1pdE9wZXJhdGlvbkFkZChwYXRoX2luX3JlcG8lM0RmJTIyc2hhcmRfJTdCaSU3RF9vZl81LmJpbiUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGNvbnRlbnQpJTBBJTIwJTIwJTIwJTIwcHJldXBsb2FkX2xmc19maWxlcyhyZXBvX2lkJTJDJTIwYWRkaXRpb25zJTNEJTVCYWRkaXRpb24lNUQpJTIwJTIzJTIwdXBsb2FkJTIwJTJCJTIwZnJlZSUyMG1lbW9yeSUwQSUyMCUyMCUyMCUyMG9wZXJhdGlvbnMuYXBwZW5kKGFkZGl0aW9uKSUwQSUwQWNyZWF0ZV9jb21taXQocmVwb19pZCUyQyUyMG9wZXJhdGlvbnMlM0RvcGVyYXRpb25zJTJDJTIwY29tbWl0X21lc3NhZ2UlM0QlMjJDb21taXQlMjBhbGwlMjBzaGFyZHMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitOperationAdd, preupload_lfs_files, create_commit, create_repo

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = create_repo(<span class="hljs-string">&quot;test_preupload&quot;</span>).repo_id

<span class="hljs-comment"># Generate and preupload LFS files one by one</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>operations = [] <span class="hljs-comment"># List of all \`CommitOperationAdd\` objects that will be generated</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
<span class="hljs-meta">... </span>    content = ... <span class="hljs-comment"># generate binary content</span>
<span class="hljs-meta">... </span>    addition = CommitOperationAdd(path_in_repo=<span class="hljs-string">f&quot;shard_<span class="hljs-subst">{i}</span>_of_5.bin&quot;</span>, path_or_fileobj=content)
<span class="hljs-meta">... </span>    preupload_lfs_files(repo_id, additions=[addition]) <span class="hljs-comment"># upload + free memory</span>
<span class="hljs-meta">... </span>    operations.append(addition)

<span class="hljs-comment"># Create commit</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_commit(repo_id, operations=operations, commit_message=<span class="hljs-string">&quot;Commit all shards&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function CU(T){let n,y="Examples:",i,a,g;return a=new U({props:{code:"bmV3X3RpdGxlJTIwJTNEJTIwJTIyTmV3JTIwdGl0bGUlMkMlMjBmaXhpbmclMjBhJTIwdHlwbyUyMiUwQUhmQXBpKCkucmVuYW1lX2Rpc2N1c3Npb24oJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGcmVwb19uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGlzY3Vzc2lvbl9udW0lM0QzNCUwQSUyMCUyMCUyMCUyMG5ld190aXRsZSUzRG5ld190aXRsZSUwQSklMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>new_title = <span class="hljs-string">&quot;New title, fixing a typo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi().rename_discussion(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo_name&quot;</span>,
<span class="hljs-meta">... </span>    discussion_num=<span class="hljs-number">34</span>
<span class="hljs-meta">... </span>    new_title=new_title
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># DiscussionTitleChange(id=&#x27;deadbeef0000000&#x27;, type=&#x27;title-change&#x27;, ...)</span>
`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-kvfsh7"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function IU(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function JU(T){let n,y="Examples:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJlcG9fZXhpc3RzJTBBcmVwb19leGlzdHMoJTIyZ29vZ2xlJTJGZ2VtbWEtN2IlMjIpJTBBcmVwb19leGlzdHMoJTIyZ29vZ2xlJTJGbm90LWEtcmVwbyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> repo_exists
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_exists(<span class="hljs-string">&quot;google/gemma-7b&quot;</span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_exists(<span class="hljs-string">&quot;google/not-a-repo&quot;</span>)
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-kvfsh7"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function NU(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1jar68o"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function AU(T){let n,y='It is also possible to request hardware directly when creating the Space repo! See <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a> for details.';return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-s3mdaf"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function EU(T){let n,y=`It is not possible to decrease persistent storage after its granted. To do so, you must delete it
via <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_space_storage">delete_space_storage()</a>.`;return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-n1vlsa"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function DU(T){let n,y="Examples:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJldmlzaW9uX2V4aXN0cyUwQXJldmlzaW9uX2V4aXN0cyglMjJnb29nbGUlMkZnZW1tYS03YiUyMiUyQyUyMCUyMmZsb2F0MTYlMjIpJTBBcmV2aXNpb25fZXhpc3RzKCUyMmdvb2dsZSUyRmdlbW1hLTdiJTIyJTJDJTIwJTIybm90LWEtcmV2aXNpb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> revision_exists
<span class="hljs-meta">&gt;&gt;&gt; </span>revision_exists(<span class="hljs-string">&quot;google/gemma-7b&quot;</span>, <span class="hljs-string">&quot;float16&quot;</span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>revision_exists(<span class="hljs-string">&quot;google/gemma-7b&quot;</span>, <span class="hljs-string">&quot;not-a-revision&quot;</span>)
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-kvfsh7"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function RU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWZ1dHVyZSUyMCUzRCUyMGFwaS5ydW5fYXNfZnV0dXJlKGFwaS53aG9hbWkpJTIwJTIzJTIwaW5zdGFudCUwQWZ1dHVyZS5kb25lKCklMEFmdXR1cmUucmVzdWx0KCklMjAlMjMlMjB3YWl0JTIwdW50aWwlMjBjb21wbGV0ZSUyMGFuZCUyMHJldHVybiUyMHJlc3VsdCUwQWZ1dHVyZS5kb25lKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>future = api.run_as_future(api.whoami) <span class="hljs-comment"># instant</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>future.done()
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>future.result() <span class="hljs-comment"># wait until complete and return result</span>
(...)
<span class="hljs-meta">&gt;&gt;&gt; </span>future.done()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function GU(T){let n,y="Run your first Job:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFydW5fam9iKGltYWdlJTNEJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUyMGNvbW1hbmQlM0QlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyMCUyQyUyMnByaW50KCdIZWxsbyUyMGZyb20lMjBIRiUyMGNvbXB1dGUhJyklMjIlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(image=<span class="hljs-string">&quot;python:3.12&quot;</span>, command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span> ,<span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>])`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1t6yql5"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function ZU(T){let n,y="Run a GPU Job:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFpbWFnZSUyMCUzRCUyMCUyMnB5dG9yY2glMkZweXRvcmNoJTNBMi42LjAtY3VkYTEyLjQtY3Vkbm45LWRldmVsJTIyJTBBY29tbWFuZCUyMCUzRCUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTJDJTIwJTIyaW1wb3J0JTIwdG9yY2glM0IlMjBwcmludChmJTIyVGhpcyUyMGNvZGUlMjByYW4lMjB3aXRoJTIwdGhlJTIwZm9sbG93aW5nJTIwR1BVJTNBJTIwJTdCdG9yY2guY3VkYS5nZXRfZGV2aWNlX25hbWUoKSU3RCUyMiklMjIlNUQlMEFydW5fam9iKGltYWdlJTNEaW1hZ2UlMkMlMjBjb21tYW5kJTNEY29tbWFuZCUyQyUyMGZsYXZvciUzRCUyMmExMGctc21hbGwlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>command = [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import torch; print(f&quot;</span>This code ran <span class="hljs-keyword">with</span> the following GPU: {torch.cuda.get_device_name()}<span class="hljs-string">&quot;)&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(image=image, command=command, flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1b2mkbl"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function FU(T){let n,y="Run a script from a URL:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFzY3JpcHQlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZodWdnaW5nZmFjZSUyRnRybCUyRnJlZnMlMkZoZWFkcyUyRm1haW4lMkZ0cmwlMkZzY3JpcHRzJTJGc2Z0LnB5JTIyJTBBc2NyaXB0X2FyZ3MlMjAlM0QlMjAlNUIlMjItLW1vZGVsX25hbWVfb3JfcGF0aCUyMiUyQyUyMCUyMlF3ZW4lMkZRd2VuMi0wLjVCJTIyJTJDJTIwJTIyLS1kYXRhc2V0X25hbWUlMjIlMkMlMjAlMjJ0cmwtbGliJTJGQ2FweWJhcmElMjIlMkMlMjAlMjItLXB1c2hfdG9faHViJTIyJTVEJTBBcnVuX3V2X2pvYihzY3JpcHQlMkMlMjBzY3JpcHRfYXJncyUzRHNjcmlwdF9hcmdzJTJDJTIwZGVwZW5kZW5jaWVzJTNEJTVCJTIydHJsJTIyJTVEJTJDJTIwZmxhdm9yJTNEJTIyYTEwZy1zbWFsbCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>script = <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/refs/heads/main/trl/scripts/sft.py&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>script_args = [<span class="hljs-string">&quot;--model_name_or_path&quot;</span>, <span class="hljs-string">&quot;Qwen/Qwen2-0.5B&quot;</span>, <span class="hljs-string">&quot;--dataset_name&quot;</span>, <span class="hljs-string">&quot;trl-lib/Capybara&quot;</span>, <span class="hljs-string">&quot;--push_to_hub&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(script, script_args=script_args, dependencies=[<span class="hljs-string">&quot;trl&quot;</span>], flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1cabkub"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function SU(T){let n,y="Run a local script:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFzY3JpcHQlMjAlM0QlMjAlMjJteV9zZnQucHklMjIlMEFzY3JpcHRfYXJncyUyMCUzRCUyMCU1QiUyMi0tbW9kZWxfbmFtZV9vcl9wYXRoJTIyJTJDJTIwJTIyUXdlbiUyRlF3ZW4yLTAuNUIlMjIlMkMlMjAlMjItLWRhdGFzZXRfbmFtZSUyMiUyQyUyMCUyMnRybC1saWIlMkZDYXB5YmFyYSUyMiUyQyUyMCUyMi0tcHVzaF90b19odWIlMjIlNUQlMEFydW5fdXZfam9iKHNjcmlwdCUyQyUyMHNjcmlwdF9hcmdzJTNEc2NyaXB0X2FyZ3MlMkMlMjBkZXBlbmRlbmNpZXMlM0QlNUIlMjJ0cmwlMjIlNUQlMkMlMjBmbGF2b3IlM0QlMjJhMTBnLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>script = <span class="hljs-string">&quot;my_sft.py&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>script_args = [<span class="hljs-string">&quot;--model_name_or_path&quot;</span>, <span class="hljs-string">&quot;Qwen/Qwen2-0.5B&quot;</span>, <span class="hljs-string">&quot;--dataset_name&quot;</span>, <span class="hljs-string">&quot;trl-lib/Capybara&quot;</span>, <span class="hljs-string">&quot;--push_to_hub&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(script, script_args=script_args, dependencies=[<span class="hljs-string">&quot;trl&quot;</span>], flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-18unv7m"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function LU(T){let n,y="Run a command:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFzY3JpcHQlMjAlM0QlMjAlMjJsaWdodGV2YWwlMjIlMEFzY3JpcHRfYXJncyUzRCUyMCU1QiUyMmVuZHBvaW50JTIyJTJDJTIwJTIyaW5mZXJlbmNlLXByb3ZpZGVycyUyMiUyQyUyMCUyMm1vZGVsX25hbWUlM0RvcGVuYWklMkZncHQtb3NzLTIwYiUyQ3Byb3ZpZGVyJTNEYXV0byUyMiUyQyUyMCUyMmxpZ2h0ZXZhbCU3Q2dzbThrJTdDMCU3QzAlMjIlNUQlMEFydW5fdXZfam9iKHNjcmlwdCUyQyUyMHNjcmlwdF9hcmdzJTNEc2NyaXB0X2FyZ3MlMkMlMjBkZXBlbmRlbmNpZXMlM0QlNUIlMjJsaWdodGV2YWwlMjIlNUQlMkMlMjBmbGF2b3IlM0QlMjJhMTBnLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>script = <span class="hljs-string">&quot;lighteval&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>script_args= [<span class="hljs-string">&quot;endpoint&quot;</span>, <span class="hljs-string">&quot;inference-providers&quot;</span>, <span class="hljs-string">&quot;model_name=openai/gpt-oss-20b,provider=auto&quot;</span>, <span class="hljs-string">&quot;lighteval|gsm8k|0|0&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(script, script_args=script_args, dependencies=[<span class="hljs-string">&quot;lighteval&quot;</span>], flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-ko0f2l"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function WU(T){let n,y='It is also possible to set a custom sleep time when requesting hardware with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.request_space_hardware">request_space_hardware()</a>.';return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1kki46i"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function VU(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1jar68o"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function BU(T){let n,y="Once squashed, the commit history cannot be retrieved. This is a non-revertible operation.";return{c(){n=c("p"),n.textContent=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-16nd2e3"&&(n.textContent=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function PU(T){let n,y=`Once the history of a branch has been squashed, it is not possible to merge it back into another branch since
their history will have diverged.`;return{c(){n=c("p"),n.textContent=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-qbmppr"&&(n.textContent=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function YU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQXJlcG9faWQlMjAlM0QlMjBhcGkuY3JlYXRlX3JlcG8oJTIydGVzdC1zcXVhc2glMjIpLnJlcG9faWQlMEElMEFhcGkudXBsb2FkX2ZpbGUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBwYXRoX2luX3JlcG8lM0QlMjJmaWxlLnR4dCUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGIlMjJjb250ZW50JTIyKSUwQWFwaS51cGxvYWRfZmlsZShyZXBvX2lkJTNEcmVwb19pZCUyQyUyMHBhdGhfaW5fcmVwbyUzRCUyMmxmcy5iaW4lMjIlMkMlMjBwYXRoX29yX2ZpbGVvYmolM0RiJTIyY29udGVudCUyMiklMEFhcGkudXBsb2FkX2ZpbGUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBwYXRoX2luX3JlcG8lM0QlMjJmaWxlLnR4dCUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGIlMjJhbm90aGVyX2NvbnRlbnQlMjIpJTBBJTBBYXBpLnN1cGVyX3NxdWFzaF9oaXN0b3J5KHJlcG9faWQlM0RyZXBvX2lkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># Create repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = api.create_repo(<span class="hljs-string">&quot;test-squash&quot;</span>).repo_id

<span class="hljs-comment"># Make a lot of commits.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(repo_id=repo_id, path_in_repo=<span class="hljs-string">&quot;file.txt&quot;</span>, path_or_fileobj=<span class="hljs-string">b&quot;content&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(repo_id=repo_id, path_in_repo=<span class="hljs-string">&quot;lfs.bin&quot;</span>, path_or_fileobj=<span class="hljs-string">b&quot;content&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(repo_id=repo_id, path_in_repo=<span class="hljs-string">&quot;file.txt&quot;</span>, path_or_fileobj=<span class="hljs-string">b&quot;another_content&quot;</span>)

<span class="hljs-comment"># Squash history</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.super_squash_history(repo_id=repo_id)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function XU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfbGlrZWRfcmVwb3MlMkMlMjB1bmxpa2UlMEElMjJncHQyJTIyJTIwaW4lMjBsaXN0X2xpa2VkX3JlcG9zKCkubW9kZWxzJTIwJTIzJTIwd2UlMjBhc3N1bWUlMjB5b3UlMjBoYXZlJTIwYWxyZWFkeSUyMGxpa2VkJTIwZ3B0MiUwQXVubGlrZSglMjJncHQyJTIyKSUwQSUyMmdwdDIlMjIlMjBpbiUyMGxpc3RfbGlrZWRfcmVwb3MoKS5tb2RlbHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_liked_repos, unlike
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;gpt2&quot;</span> <span class="hljs-keyword">in</span> list_liked_repos().models <span class="hljs-comment"># we assume you have already liked gpt2</span>
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>unlike(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;gpt2&quot;</span> <span class="hljs-keyword">in</span> list_liked_repos().models
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function zU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTJDJTIwdXBkYXRlX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb24lMjAlM0QlMjBnZXRfY29sbGVjdGlvbiglMjJUaGVCbG9rZSUyRnJlY2VudC1tb2RlbHMtNjRmOWE1NWJiMzExNWI0ZjUxM2VjMDI2JTIyKSUwQSUwQXVwZGF0ZV9jb2xsZWN0aW9uX2l0ZW0oJTBBJTIwJTIwJTIwJTIwY29sbGVjdGlvbl9zbHVnJTNEJTIyVGhlQmxva2UlMkZyZWNlbnQtbW9kZWxzLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1fb2JqZWN0X2lkJTNEY29sbGVjdGlvbi5pdGVtcyU1Qi0xJTVELml0ZW1fb2JqZWN0X2lkJTJDJTBBJTIwJTIwJTIwJTIwbm90ZSUzRCUyMk5ld2x5JTIwdXBkYXRlZCUyMG1vZGVsISUyMiUwQSUyMCUyMCUyMCUyMHBvc2l0aW9uJTNEMCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection, update_collection_item

<span class="hljs-comment"># Get collection first</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>)

<span class="hljs-comment"># Update item based on its ID (add note + update position)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>update_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>,
<span class="hljs-meta">... </span>    item_object_id=collection.items[-<span class="hljs-number">1</span>].item_object_id,
<span class="hljs-meta">... </span>    note=<span class="hljs-string">&quot;Newly updated model!&quot;</span>
<span class="hljs-meta">... </span>    position=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function QU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV9jb2xsZWN0aW9uX21ldGFkYXRhJTBBY29sbGVjdGlvbiUyMCUzRCUyMHVwZGF0ZV9jb2xsZWN0aW9uX21ldGFkYXRhKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMnVzZXJuYW1lJTJGaWNjdi0yMDIzLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIySUNDViUyME9jdC4lMjAyMDIzJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJQb3J0Zm9saW8lMjBvZiUyMG1vZGVscyUyQyUyMGRhdGFzZXRzJTJDJTIwcGFwZXJzJTIwYW5kJTIwZGVtb3MlMjBJJTIwcHJlc2VudGVkJTIwYXQlMjBJQ0NWJTIwT2N0LiUyMDIwMjMlMjIlMkMlMEElMjAlMjAlMjAlMjBwcml2YXRlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjB0aGVtZSUzRCUyMnBpbmslMjIlMkMlMEEpJTBBY29sbGVjdGlvbi5zbHVn",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_collection_metadata
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = update_collection_metadata(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;username/iccv-2023-64f9a55bb3115b4f513ec026&quot;</span>,
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;ICCV Oct. 2023&quot;</span>
<span class="hljs-meta">... </span>    description=<span class="hljs-string">&quot;Portfolio of models, datasets, papers and demos I presented at ICCV Oct. 2023&quot;</span>,
<span class="hljs-meta">... </span>    private=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    theme=<span class="hljs-string">&quot;pink&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.slug
<span class="hljs-string">&quot;username/iccv-oct-2023-64f9a55bb3115b4f513ec026&quot;</span>
<span class="hljs-comment"># ^collection slug got updated but not the trailing ID</span>`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function OU(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1bg6k8f"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function KU(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV93ZWJob29rJTBBdXBkYXRlZF9wYXlsb2FkJTIwJTNEJTIwdXBkYXRlX3dlYmhvb2soJTBBJTIwJTIwJTIwJTIwd2ViaG9va19pZCUzRCUyMjY1NGJiYmMxNmYyZWMxNGQ3N2YxMDljYyUyMiUyQyUwQSUyMCUyMCUyMCUyMHVybCUzRCUyMmh0dHBzJTNBJTJGJTJGbmV3LndlYmhvb2suc2l0ZSUyRmEyMTc2ZTgyLTU3MjAtNDNlZS05ZTA2LWY5MWNiNGM5MTU0OCUyMiUyQyUwQSUyMCUyMCUyMCUyMHdhdGNoZWQlM0QlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMm5hbWUlMjIlM0ElMjAlMjJqdWxpZW4tYyUyMiU3RCUyQyUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJvcmclMjIlMkMlMjAlMjJuYW1lJTIyJTNBJTIwJTIySHVnZ2luZ0ZhY2VINCUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMGRvbWFpbnMlM0QlNUIlMjJyZXBvJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2VjcmV0JTNEJTIybXktc2VjcmV0JTIyJTJDJTBBKSUwQXByaW50KHVwZGF0ZWRfcGF5bG9hZCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_payload = update_webhook(
<span class="hljs-meta">... </span>    webhook_id=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
<span class="hljs-meta">... </span>    url=<span class="hljs-string">&quot;https://new.webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
<span class="hljs-meta">... </span>    watched=[{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;julien-c&quot;</span>}, {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;org&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;HuggingFaceH4&quot;</span>}],
<span class="hljs-meta">... </span>    domains=[<span class="hljs-string">&quot;repo&quot;</span>],
<span class="hljs-meta">... </span>    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(updated_payload)
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://new.webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">False</span>,`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function e4(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1m0jr8h"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function t4(T){let n,y=`<code>upload_file</code> assumes that the repo already exists on the Hub. If you get a
Client error 404, please make sure you are authenticated and that <code>repo_id</code> and
<code>repo_type</code> are set correctly. If repo does not exist, create it first using
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`;return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-14jkuxx"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function n4(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwbG9hZF9maWxlJTBBJTBBd2l0aCUyMG9wZW4oJTIyLiUyRmxvY2FsJTJGZmlsZXBhdGglMjIlMkMlMjAlMjJyYiUyMiklMjBhcyUyMGZvYmolM0ElMEElMjAlMjAlMjAlMjB1cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0RmaWxlb2JqJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF0aF9pbl9yZXBvJTNEJTIycmVtb3RlJTJGZmlsZSUyRnBhdGguaDUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRva2VuJTNEJTIybXlfdG9rZW4lMjIlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBdXBsb2FkX2ZpbGUoJTBBJTIwJTIwJTIwJTIwcGF0aF9vcl9maWxlb2JqJTNEJTIyLiU1QyU1Q2xvY2FsJTVDJTVDZmlsZSU1QyU1Q3BhdGglMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZmaWxlJTJGcGF0aC5oNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRm15LW1vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW4lM0QlMjJteV90b2tlbiUyMiUyQyUwQSklMEElMEF1cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0QlMjIuJTVDJTVDbG9jYWwlNUMlNUNmaWxlJTVDJTVDcGF0aCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMnJlbW90ZSUyRmZpbGUlMkZwYXRoLmg1JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGbXktbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3JlYXRlX3ByJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> upload_file

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;./local/filepath&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> fobj:
<span class="hljs-meta">... </span>    upload_file(
<span class="hljs-meta">... </span>        path_or_fileobj=fileobj,
<span class="hljs-meta">... </span>        path_in_repo=<span class="hljs-string">&quot;remote/file/path.h5&quot;</span>,
<span class="hljs-meta">... </span>        repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>        repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>        token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    )
<span class="hljs-string">&quot;https://huggingface.co/datasets/username/my-dataset/blob/main/remote/file/path.h5&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>upload_file(
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">&quot;.\\\\local\\\\file\\\\path&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/file/path.h5&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/username/my-model/blob/main/remote/file/path.h5&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>upload_file(
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">&quot;.\\\\local\\\\file\\\\path&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/file/path.h5&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    create_pr=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/username/my-model/blob/refs%2Fpr%2F1/remote/file/path.h5&quot;</span>`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function o4(T){let n,y="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li>`;return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-182te9i"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1l6tbi1"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function a4(T){let n,y=`<code>upload_folder</code> assumes that the repo already exists on the Hub. If you get a Client error 404, please make
sure you are authenticated and that <code>repo_id</code> and <code>repo_type</code> are set correctly. If repo does not exist, create
it first using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`;return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1ji36op"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function s4(T){let n,y='When dealing with a large folder (thousands of files or hundreds of GB), we recommend using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_large_folder">upload_large_folder()</a> instead.';return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-10xj0hr"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function r4(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"dXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZleHBlcmltZW50JTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwaWdub3JlX3BhdHRlcm5zJTNEJTIyKiolMkZsb2dzJTJGKi50eHQlMjIlMkMlMEEpJTBBJTBBdXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZleHBlcmltZW50JTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVsZXRlX3BhdHRlcm5zJTNEJTIyKiolMkZsb2dzJTJGKi50eHQlMjIlMkMlMEEpJTBBJTBBdXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZleHBlcmltZW50JTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3JlYXRlX3ByJTNEVHJ1ZSUyQyUwQSklMEE=",highlighted:`<span class="hljs-comment"># Upload checkpoints folder except the log files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/experiment/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;datasets&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    ignore_patterns=<span class="hljs-string">&quot;**/logs/*.txt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># &quot;https://huggingface.co/datasets/username/my-dataset/tree/main/remote/experiment/checkpoints&quot;</span>

<span class="hljs-comment"># Upload checkpoints folder including logs while deleting existing logs from the repo</span>
<span class="hljs-comment"># Useful if you don&#x27;t know exactly which log files have already being pushed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/experiment/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;datasets&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    delete_patterns=<span class="hljs-string">&quot;**/logs/*.txt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/datasets/username/my-dataset/tree/main/remote/experiment/checkpoints&quot;</span>

<span class="hljs-comment"># Upload checkpoints folder while creating a PR</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/experiment/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;datasets&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    create_pr=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/datasets/username/my-dataset/tree/refs%2Fpr%2F1/remote/experiment/checkpoints&quot;</span>
`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function i4(T){let n,y="A few things to keep in mind:",i,a,g='<li>Repository limits still apply: <a href="https://huggingface.co/docs/hub/repositories-recommendations" rel="nofollow">https://huggingface.co/docs/hub/repositories-recommendations</a></li> <li>Do not start several processes in parallel.</li> <li>You can interrupt and resume the process at any time.</li> <li>Do not upload the same folder to several repositories. If you need to do so, you must delete the local <code>.cache/.huggingface/</code> folder first.</li>';return{c(){n=c("p"),n.textContent=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-vnn6d1"&&(n.textContent=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1iweq7b"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function c4(T){let n,y='While being much more robust to upload large folders, <code>upload_large_folder</code> is more limited than <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> feature-wise. In practice:',i,a,g='<li>you cannot set a custom <code>path_in_repo</code>. If you want to upload to a subfolder, you need to set the proper structure locally.</li> <li>you cannot set a custom <code>commit_message</code> and <code>commit_description</code> since multiple commits are created.</li> <li>you cannot delete from the repo while uploading. Please make a separate commit first.</li> <li>you cannot create a PR directly. Please create a PR first (from the UI or using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_pull_request">create_pull_request()</a>) and then commit to it by passing <code>revision</code>.</li>';return{c(){n=c("p"),n.innerHTML=y,i=s(),a=c("ul"),a.innerHTML=g},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-wp9z6w"&&(n.innerHTML=y),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-mz4t5f"&&(a.innerHTML=g)},m(e,x){$(e,n,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(n),p(i),p(a))}}}function l4(T){let n,y=`Most attributes of this class are optional. This is because the data returned by the Hub depends on the query made.
In general, the more specific the query, the more information is returned. On the contrary, when listing datasets
using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_datasets">list_datasets()</a> only a subset of the attributes are returned.`;return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-5rfhi2"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function p4(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWxmc19maWxlcyUyMCUzRCUyMGFwaS5saXN0X2xmc19maWxlcyglMjJ1c2VybmFtZSUyRm15LWNvb2wtcmVwbyUyMiklMEElMEFsZnNfZmlsZXNfdG9fZGVsZXRlJTIwJTNEJTIwKGxmc19maWxlJTIwZm9yJTIwbGZzX2ZpbGUlMjBpbiUyMGxmc19maWxlcyUyMGlmJTIwbGZzX2ZpbGUuZmlsZW5hbWUuc3RhcnRzd2l0aCglMjJjaGVja3BvaW50cyUyRiUyMikpJTBBJTBBYXBpLnBlcm1hbmVudGx5X2RlbGV0ZV9sZnNfZmlsZXMoJTIydXNlcm5hbWUlMkZteS1jb29sLXJlcG8lMjIlMkMlMjBsZnNfZmlsZXNfdG9fZGVsZXRlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files = api.list_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>)

<span class="hljs-comment"># Filter files files to delete based on a combination of \`filename\`, \`pushed_at\`, \`ref\` or \`size\`.</span>
<span class="hljs-comment"># e.g. select only LFS files in the &quot;checkpoints&quot; folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files_to_delete = (lfs_file <span class="hljs-keyword">for</span> lfs_file <span class="hljs-keyword">in</span> lfs_files <span class="hljs-keyword">if</span> lfs_file.filename.startswith(<span class="hljs-string">&quot;checkpoints/&quot;</span>))

<span class="hljs-comment"># Permanently delete LFS files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.permanently_delete_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>, lfs_files_to_delete)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function d4(T){let n,y=`Most attributes of this class are optional. This is because the data returned by the Hub depends on the query made.
In general, the more specific the query, the more information is returned. On the contrary, when listing models
using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_models">list_models()</a> only a subset of the attributes are returned.`;return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-15v1iox"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function g4(T){let n,y=`All attributes of this class are optional except <code>rfilename</code>. This is because only the file names are returned when
listing repositories on the Hub (with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_models">list_models()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_datasets">list_datasets()</a> or <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_spaces">list_spaces()</a>). If you need more
information like file size, blob id or lfs details, you must request them specifically from one repo at a time
(using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.model_info">model_info()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.dataset_info">dataset_info()</a> or <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.space_info">space_info()</a>) as it adds more constraints on the backend server to
retrieve these.`;return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-6ldscx"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function u4(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"UmVwb1VybCgnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmdwdDInKSUwQSUwQVJlcG9VcmwoJ2h0dHBzJTNBJTJGJTJGaHViLWNpLmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkdW1teV91c2VyJTJGZHVtbXlfZGF0YXNldCclMkMlMjBlbmRwb2ludCUzRCdodHRwcyUzQSUyRiUyRmh1Yi1jaS5odWdnaW5nZmFjZS5jbycpJTBBJTBBUmVwb1VybCgnaGYlM0ElMkYlMkZkYXRhc2V0cyUyRm15LXVzZXIlMkZteS1kYXRhc2V0JyklMEElMEFIZkFwaS5jcmVhdGVfcmVwbyglMjJkdW1teV9tb2RlbCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/gpt2&#x27;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/gpt2&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;model&#x27;</span>, repo_id=<span class="hljs-string">&#x27;gpt2&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>RepoUrl(<span class="hljs-string">&#x27;https://hub-ci.huggingface.co/datasets/dummy_user/dummy_dataset&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://hub-ci.huggingface.co&#x27;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://hub-ci.huggingface.co/datasets/dummy_user/dummy_dataset&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://hub-ci.huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;dataset&#x27;</span>, repo_id=<span class="hljs-string">&#x27;dummy_user/dummy_dataset&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>RepoUrl(<span class="hljs-string">&#x27;hf://datasets/my-user/my-dataset&#x27;</span>)
RepoUrl(<span class="hljs-string">&#x27;hf://datasets/my-user/my-dataset&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;dataset&#x27;</span>, repo_id=<span class="hljs-string">&#x27;user/dataset&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi.create_repo(<span class="hljs-string">&quot;dummy_model&quot;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/Wauplin/dummy_model&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;model&#x27;</span>, repo_id=<span class="hljs-string">&#x27;Wauplin/dummy_model&#x27;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function h4(T){let n,y=`Most attributes of this class are optional. This is because the data returned by the Hub depends on the query made.
In general, the more specific the query, the more information is returned. On the contrary, when listing spaces
using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_spaces">list_spaces()</a> only a subset of the attributes are returned.`;return{c(){n=c("p"),n.innerHTML=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-hrpd0g"&&(n.innerHTML=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function f4(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"b3BlcmF0aW9uJTIwJTNEJTIwQ29tbWl0T3BlcmF0aW9uQWRkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMnJlbW90ZSUyRmRpciUyRndlaWdodHMuaDUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0QlMjIuJTJGbG9jYWwlMkZ3ZWlnaHRzLmg1JTIyJTJDJTBBKSUwQSUwQXdpdGglMjBvcGVyYXRpb24uYXNfZmlsZSgpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwY29udGVudCUyMCUzRCUyMGZpbGUucmVhZCgpJTBBJTBBd2l0aCUyMG9wZXJhdGlvbi5hc19maWxlKHdpdGhfdHFkbSUzRFRydWUpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwd2hpbGUlMjBUcnVlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YSUyMCUzRCUyMGZpbGUucmVhZCgxMDI0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbm90JTIwZGF0YSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBd2l0aCUyMG9wZXJhdGlvbi5hc19maWxlKHdpdGhfdHFkbSUzRFRydWUpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwcmVxdWVzdHMucHV0KC4uLiUyQyUyMGRhdGElM0RmaWxlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>operation = CommitOperationAdd(
<span class="hljs-meta">... </span>       path_in_repo=<span class="hljs-string">&quot;remote/dir/weights.h5&quot;</span>,
<span class="hljs-meta">... </span>       path_or_fileobj=<span class="hljs-string">&quot;./local/weights.h5&quot;</span>,
<span class="hljs-meta">... </span>)
CommitOperationAdd(path_in_repo=<span class="hljs-string">&#x27;remote/dir/weights.h5&#x27;</span>, path_or_fileobj=<span class="hljs-string">&#x27;./local/weights.h5&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> operation.as_file() <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    content = file.read()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> operation.as_file(with_tqdm=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
<span class="hljs-meta">... </span>        data = file.read(<span class="hljs-number">1024</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> data:
<span class="hljs-meta">... </span>             <span class="hljs-keyword">break</span>
config.json: <span class="hljs-number">100</span>%|█████████████████████████| <span class="hljs-number">8.19</span>k/<span class="hljs-number">8.19</span>k [<span class="hljs-number">00</span>:02&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">3.72</span>kB/s]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> operation.as_file(with_tqdm=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    requests.put(..., data=file)
config.json: <span class="hljs-number">100</span>%|█████████████████████████| <span class="hljs-number">8.19</span>k/<span class="hljs-number">8.19</span>k [<span class="hljs-number">00</span>:02&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">3.72</span>kB/s]`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function m4(T){let n,y="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdFNjaGVkdWxlciUwQSUwQWNzdl9wYXRoJTIwJTNEJTIwUGF0aCglMjJ3YXRjaGVkX2ZvbGRlciUyRmRhdGEuY3N2JTIyKSUwQUNvbW1pdFNjaGVkdWxlcihyZXBvX2lkJTNEJTIydGVzdF9zY2hlZHVsZXIlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyJTJDJTIwZm9sZGVyX3BhdGglM0Rjc3ZfcGF0aC5wYXJlbnQlMkMlMjBldmVyeSUzRDEwKSUwQSUwQXdpdGglMjBjc3ZfcGF0aC5vcGVuKCUyMmElMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwZi53cml0ZSglMjJmaXJzdCUyMGxpbmUlMjIpJTBBJTBBd2l0aCUyMGNzdl9wYXRoLm9wZW4oJTIyYSUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmLndyaXRlKCUyMnNlY29uZCUyMGxpbmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitScheduler

<span class="hljs-comment"># Scheduler uploads every 10 minutes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>csv_path = Path(<span class="hljs-string">&quot;watched_folder/data.csv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>CommitScheduler(repo_id=<span class="hljs-string">&quot;test_scheduler&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, folder_path=csv_path.parent, every=<span class="hljs-number">10</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;first line&quot;</span>)

<span class="hljs-comment"># Some time later (...)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;second line&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function _4(T){let n,y="Example using a context manager:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdFNjaGVkdWxlciUwQSUwQXdpdGglMjBDb21taXRTY2hlZHVsZXIocmVwb19pZCUzRCUyMnRlc3Rfc2NoZWR1bGVyJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUyMGZvbGRlcl9wYXRoJTNEJTIyd2F0Y2hlZF9mb2xkZXIlMjIlMkMlMjBldmVyeSUzRDEwKSUyMGFzJTIwc2NoZWR1bGVyJTNBJTBBJTIwJTIwJTIwJTIwY3N2X3BhdGglMjAlM0QlMjBQYXRoKCUyMndhdGNoZWRfZm9sZGVyJTJGZGF0YS5jc3YlMjIpJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGNzdl9wYXRoLm9wZW4oJTIyYSUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmLndyaXRlKCUyMmZpcnN0JTIwbGluZSUyMiklMEElMjAlMjAlMjAlMjAoLi4uKSUwQSUyMCUyMCUyMCUyMHdpdGglMjBjc3ZfcGF0aC5vcGVuKCUyMmElMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZSglMjJzZWNvbmQlMjBsaW5lJTIyKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> CommitScheduler(repo_id=<span class="hljs-string">&quot;test_scheduler&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, folder_path=<span class="hljs-string">&quot;watched_folder&quot;</span>, every=<span class="hljs-number">10</span>) <span class="hljs-keyword">as</span> scheduler:
<span class="hljs-meta">... </span>    csv_path = Path(<span class="hljs-string">&quot;watched_folder/data.csv&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(<span class="hljs-string">&quot;first line&quot;</span>)
<span class="hljs-meta">... </span>    (...)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(<span class="hljs-string">&quot;second line&quot;</span>)

<span class="hljs-comment"># Scheduler is now stopped and last commit have been triggered</span>`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,i=s(),u(a.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),d(n)!=="svelte-k44prv"&&(n.textContent=y),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,n,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(n),p(i)),b(a,e)}}}function b4(T){let n,y=`This method is not meant to be called directly. It is run in the background by the scheduler, respecting a
queue mechanism to avoid concurrent commits. Making a direct call to the method might lead to concurrency
issues.`;return{c(){n=c("p"),n.textContent=y},l(i){n=l(i,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1oh5a50"&&(n.textContent=y)},m(i,a){$(i,n,a)},p:H,d(i){i&&p(n)}}}function y4(T){let n,y,i,a,g,e,x,Lk="Below is the documentation for the <code>HfApi</code> class, which serves as a Python wrapper for the Hugging Face Hub’s API.",Pf,Ur,Wk="All methods from the <code>HfApi</code> are also accessible from the package’s root directly. Both approaches are detailed below.",Yf,Cr,Vk=`Using the root method is more straightforward but the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> class gives you more flexibility.
In particular, you can pass a token that will be reused in all HTTP calls. This is different
than <code>hf auth login</code> or <a href="/docs/huggingface_hub/main/en/package_reference/authentication#huggingface_hub.login">login()</a> as the token is not persisted on the machine.
It is also possible to provide a different endpoint or configure a custom user-agent.`,Xf,Ir,zf,Jr,Qf,w,Nr,s_,wp,Bk="Client to interact with the Hugging Face Hub via HTTP.",r_,kp,Pk=`The client is initialized with some high-level settings used in all requests
made to the Hub (HF endpoint, authentication, user agents…). Using the <code>HfApi</code>
client is preferred but not mandatory as all of its public methods are exposed
directly at the root of <code>huggingface_hub</code>.`,i_,Ze,Ar,c_,Tp,Yk="Accept an access request from a user for a given gated repo.",l_,jp,Xk=`Once the request is accepted, the user will be able to download any file of the repo and access the community
tab. If the approval mode is automatic, you don’t have to accept requests manually. An accepted request can be
cancelled or rejected at any time using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>.`,p_,Mp,zk='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',d_,Fe,Er,g_,qp,Qk="Add an item to a collection on the Hub.",u_,Hp,Ok='Returns: <a href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.Collection">Collection</a>',h_,Vo,f_,an,Dr,m_,Up,Kk="Adds or updates a secret in a Space.",__,Cp,eT=`Secrets allow to set secret keys or tokens to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,b_,sn,Rr,y_,Ip,tT="Adds or updates a variable in a Space.",v_,Jp,nT=`Variables allow to set environment variables to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>`,x_,G,Gr,$_,Np,oT="Check if the provided user token has access to a specific repository on the Hugging Face Hub.",w_,Ap,aT=`This method verifies whether the user, authenticated via the provided token, has access to the specified
repository. If the repository is not found or if the user lacks the required permissions to access it,
the method raises an appropriate exception.`,k_,Ep,sT="Example:",T_,Bo,j_,Dp,rT="In this example:",M_,Rp,iT=`<li>If the user has access, the method completes successfully.</li> <li>If the repository is gated or does not exist, appropriate exceptions are raised, allowing the user
to handle them accordingly.</li>`,q_,Se,Zr,H_,Gp,cT="Cancel an access request from a user for a given gated repo.",U_,Zp,lT="A cancelled request will go back to the pending list and the user will lose access to the repo.",C_,Fp,pT='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',I_,Po,Fr,J_,Sp,dT="Cancel a compute Job on Hugging Face infrastructure.",N_,Le,Sr,A_,Lp,gT="Closes or re-opens a Discussion or Pull Request.",E_,Yo,D_,Xo,R_,We,Lr,G_,Wp,uT="Creates a new comment on the given Discussion.",Z_,zo,F_,Qo,S_,Oo,Wr,L_,Vp,hT=`Create a new branch for a repo on the Hub, starting from the specified revision (defaults to <code>main</code>).
To find a revision suiting your needs, you can use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_repo_refs">list_repo_refs()</a> or <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_repo_commits">list_repo_commits()</a>.`,W_,Ve,Vr,V_,Bp,fT="Create a new Collection on the Hub.",B_,Pp,mT='Returns: <a href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.Collection">Collection</a>',P_,Ko,Y_,ge,Br,X_,Yp,_T="Creates a commit in the given repo, deleting & uploading files as needed.",z_,ea,Q_,ta,O_,na,K_,L,Pr,eb,Xp,bT="Creates a Discussion or Pull Request.",tb,zp,yT="Pull Requests created programmatically will be in <code>&quot;draft&quot;</code> status.",nb,Qp,vT='Creating a Pull Request with changes can also be done at once with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">HfApi.create_commit()</a>.',ob,Op,xT='Returns: <a href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionWithDetails">DiscussionWithDetails</a>',ab,oa,sb,ue,Yr,rb,Kp,$T="Create a new Inference Endpoint.",ib,aa,cb,sa,lb,ra,pb,Be,Xr,db,ed,wT="Create a new Inference Endpoint from a model in the Hugging Face Inference Catalog.",gb,td,kT=`The goal of the Inference Catalog is to provide a curated list of models that are optimized for inference
and for which default configurations have been tested. See <a href="https://endpoints.huggingface.co/catalog" rel="nofollow">https://endpoints.huggingface.co/catalog</a> for a list
of available models in the catalog.`,ub,ia,hb,W,zr,fb,nd,TT="Creates a Pull Request . Pull Requests created programmatically will be in <code>&quot;draft&quot;</code> status.",mb,od,jT='Creating a Pull Request with changes can also be done at once with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">HfApi.create_commit()</a>;',_b,ad,MT='This is a wrapper around <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_discussion">HfApi.create_discussion()</a>.',bb,sd,qT='Returns: <a href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionWithDetails">DiscussionWithDetails</a>',yb,ca,vb,la,Qr,xb,rd,HT="Create an empty repo on the HuggingFace Hub.",$b,V,Or,wb,id,UT="Create scheduled compute Jobs on Hugging Face infrastructure.",kb,cd,CT="Example:",Tb,pa,jb,da,Mb,ga,qb,B,Kr,Hb,ld,IT="Run a UV script Job on Hugging Face infrastructure.",Ub,pd,JT="Example:",Cb,ua,Ib,ha,Jb,fa,Nb,ma,ei,Ab,dd,NT="Tag a given commit of a repo on the Hub.",Eb,rn,ti,Db,gd,AT="Create a new webhook.",Rb,_a,Gb,Pe,ni,Zb,ud,ET="Get info on one specific dataset on huggingface.co.",Fb,hd,DT="Dataset can be private if you pass an acceptable token.",Sb,ba,Lb,ya,oi,Wb,fd,RT="Delete a branch from a repo on the Hub.",Vb,Ye,ai,Bb,md,GT="Delete a collection on the Hub.",Pb,va,Yb,xa,Xb,cn,si,zb,_d,ZT="Delete an item from a collection.",Qb,$a,Ob,ln,ri,Kb,bd,FT="Deletes a file in the given repo.",ey,wa,ty,pn,ii,ny,yd,ST="Delete files from a repository on the Hub.",oy,vd,LT=`If a folder path is provided, the entire folder is deleted as well as
all files it contained.`,ay,dn,ci,sy,xd,WT="Deletes a folder in the given repo.",ry,$d,VT='Simple wrapper around <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> method.',iy,Xe,li,cy,wd,BT="Delete an Inference Endpoint.",ly,kd,PT=`This operation is not reversible. If you don’t want to be charged for an Inference Endpoint, it is preferable
to pause it with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a> or scale it to zero with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>.`,py,Td,YT='For convenience, you can also delete an Inference Endpoint using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.delete">InferenceEndpoint.delete()</a>.',dy,ka,pi,gy,jd,XT="Delete a repo from the HuggingFace Hub. CAUTION: this is irreversible.",uy,Ta,di,hy,Md,zT="Delete a scheduled compute Job on Hugging Face infrastructure.",fy,gn,gi,my,qd,QT="Deletes a secret from a Space.",_y,Hd,OT=`Secrets allow to set secret keys or tokens to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,by,ja,ui,yy,Ud,KT="Delete persistent storage for a Space.",vy,un,hi,xy,Cd,e0="Deletes a variable from a Space.",$y,Id,t0=`Variables allow to set environment variables to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>`,wy,Ma,fi,ky,Jd,n0="Delete a tag from a repo on the Hub.",Ty,hn,mi,jy,Nd,o0="Delete a webhook.",My,qa,qy,fn,_i,Hy,Ad,a0="Disable a webhook (makes it “disabled”).",Uy,Ha,Cy,ze,bi,Iy,Ed,s0="Duplicate a Space.",Jy,Dd,r0=`Programmatically duplicate a Space. The new Space will be created in your account and will be in the same state
as the original Space (running or paused). You can duplicate a Space no matter the current state of a Space.`,Ny,Ua,Ay,mn,yi,Ey,Rd,i0="Edits a comment on a Discussion / Pull Request.",Dy,Ca,Ry,_n,vi,Gy,Gd,c0="Enable a webhook (makes it “active”).",Zy,Ia,Fy,bn,xi,Sy,Zd,l0="Fetch all the logs from a compute Job on Hugging Face infrastructure.",Ly,Ja,Wy,yn,$i,Vy,Fd,p0="Checks if a file exists in a repository on the Hugging Face Hub.",By,Na,Py,Qe,wi,Yy,Sd,d0="Gets information about a Collection on the Hub.",Xy,Ld,g0='Returns: <a href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.Collection">Collection</a>',zy,Aa,Qy,Ea,ki,Oy,Wd,u0="List all valid dataset tags as a nested namespace object.",Ky,Oe,Ti,ev,Vd,h0="Fetches a Discussion’s / Pull Request ‘s details from the Hub.",tv,Bd,f0='Returns: <a href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionWithDetails">DiscussionWithDetails</a>',nv,Da,ov,Ra,ji,av,Pd,m0=`Returns the repository name for a given model ID and optional
organization.`,sv,Ga,Mi,rv,Yd,_0="Fetch metadata of a file versioned on the Hub for a given url.",iv,vn,qi,cv,Xd,b0="Get information about an Inference Endpoint.",lv,Za,pv,Fa,Hi,dv,zd,y0="List all valid model tags as a nested namespace object",gv,xn,Ui,uv,Qd,v0="Get information about a repo’s paths.",hv,Sa,fv,he,Ci,mv,Od,x0="Fetches Discussions and Pull Requests for the given repo.",_v,Kd,$0="Example:",bv,La,yv,Wa,vv,P,Ii,xv,eg,w0="Parse metadata for a safetensors repo on the Hub.",$v,tg,k0=`We first check if the repo has a single safetensors file or a sharded safetensors repo. If it’s a single
safetensors file, we parse the metadata from this file. If it’s a sharded safetensors repo, we parse the
metadata from the index file and then parse the metadata from each shard.`,wv,ng,T0='To parse metadata from a single safetensors file, use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.parse_safetensors_file_metadata">parse_safetensors_file_metadata()</a>.',kv,og,j0='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',Tv,Va,jv,Ba,Ji,Mv,ag,M0="Gets runtime information about a Space.",qv,$n,Ni,Hv,sg,q0="Gets all variables from a Space.",Uv,rg,H0=`Variables allow to set environment variables to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>`,Cv,Ke,Ai,Iv,ig,U0="Check if a given <code>token</code> is valid and return its permissions.",Jv,Pa,Nv,cg,C0='For more details about tokens, please refer to <a href="https://huggingface.co/docs/hub/security-tokens#what-are-user-access-tokens" rel="nofollow">https://huggingface.co/docs/hub/security-tokens#what-are-user-access-tokens</a>.',Av,Ya,Ei,Ev,lg,I0="Get an overview of a user on the Hub.",Dv,wn,Di,Rv,pg,J0="Get a webhook by its id.",Gv,Xa,Zv,et,Ri,Fv,dg,N0="Grant access to a user for a given gated repo.",Sv,gg,A0=`Granting access don’t require for the user to send an access request by themselves. The user is automatically
added to the accepted list meaning they can download the files You can revoke the granted access at any time
using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a> or <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>.`,Lv,ug,E0='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Wv,Y,Gi,Vv,hg,D0="Download a given file if it’s not already present in the local cache.",Bv,fg,R0="The new cache file layout looks like this:",Pv,mg,G0=`<li>The cache directory contains one subfolder per repo_id (namespaced by repo type)</li> <li>inside each repo folder:<ul><li>refs is a list of the latest known revision =&gt; commit_hash pairs</li> <li>blobs contains the actual file blobs (identified by their git-sha or sha256, depending on
whether they’re LFS files or not)</li> <li>snapshots contains one subfolder per commit, each “commit” contains the subset of the files
that have been resolved at that particular commit. Each filename is a symlink to the blob
at that particular commit.</li></ul></li>`,Yv,za,Xv,_g,Z0=`If <code>local_dir</code> is provided, the file structure from the repo will be replicated in this location. When using this
option, the <code>cache_dir</code> will not be used and a <code>.cache/huggingface/</code> folder will be created at the root of <code>local_dir</code>
to store some metadata related to the downloaded files. While this mechanism is not as robust as the main
cache-system, it’s optimized for regularly pulling the latest version of a repository.`,zv,tt,Zi,Qv,bg,F0="Hides a comment on a Discussion / Pull Request.",Ov,Qa,Kv,Oa,ex,kn,Fi,tx,yg,S0="Inspect a compute Job on Hugging Face infrastructure.",nx,Ka,ox,Tn,Si,ax,vg,L0="Inspect a scheduled compute Job on Hugging Face infrastructure.",sx,es,rx,fe,Li,ix,xg,W0="Get accepted access requests for a given gated repo.",cx,$g,V0=`An accepted request means the user has requested access to the repo and the request has been accepted. The user
can download any file of the repo. If the approval mode is automatic, this list should contains by default all
requests. Accepted requests can be cancelled or rejected at any time using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a> and
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>. A cancelled request will go back to the pending list while a rejected request will
go to the rejected list. In both cases, the user will lose access to the repo.`,lx,wg,B0='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',px,ts,dx,jn,Wi,gx,kg,P0="List collections on the Huggingface Hub, given some filters.",ux,ns,hx,nt,Vi,fx,Tg,Y0="List datasets hosted on the Huggingface Hub, given some filters.",mx,os,_x,as,bx,me,Bi,yx,jg,X0="List models available in the Hugging Face Inference Catalog.",vx,Mg,z0=`The goal of the Inference Catalog is to provide a curated list of models that are optimized for inference
and for which default configurations have been tested. See <a href="https://endpoints.huggingface.co/catalog" rel="nofollow">https://endpoints.huggingface.co/catalog</a> for a list
of available models in the catalog.`,xx,qg,Q0='Use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint_from_catalog">create_inference_endpoint_from_catalog()</a> to deploy a model from the catalog.',$x,ss,wx,Mn,Pi,kx,Hg,O0="Lists all inference endpoints for the given namespace.",Tx,rs,jx,is,Yi,Mx,Ug,K0="List compute Jobs on Hugging Face infrastructure.",qx,ot,Xi,Hx,Cg,ej="List all LFS files in a repo on the Hub.",Ux,Ig,tj=`This is primarily useful to count how much storage a repo is using and to eventually clean up large files
with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.permanently_delete_lfs_files">permanently_delete_lfs_files()</a>. Note that this would be a permanent action that will affect all commits
referencing this deleted files and that cannot be undone.`,Cx,cs,Ix,_e,zi,Jx,Jg,nj="List all public repos liked by a user on huggingface.co.",Nx,Ng,oj=`This list is public so token is optional. If <code>user</code> is not passed, it defaults to
the logged in user.`,Ax,Ag,aj='See also <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.unlike">unlike()</a>.',Ex,ls,Dx,qn,Qi,Rx,Eg,sj="List models hosted on the Huggingface Hub, given some filters.",Gx,ps,Zx,ds,Oi,Fx,Dg,rj="List of members of an organization on the Hub.",Sx,Hn,Ki,Lx,Rg,ij="List daily papers on the Hugging Face Hub given a search query.",Wx,gs,Vx,be,ec,Bx,Gg,cj="Get pending access requests for a given gated repo.",Px,Zg,lj=`A pending request means the user has requested access to the repo but the request has not been processed yet.
If the approval mode is automatic, this list should be empty. Pending requests can be accepted or rejected
using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.accept_access_request">accept_access_request()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>.`,Yx,Fg,pj='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Xx,us,zx,ye,tc,Qx,Sg,dj="Get rejected access requests for a given gated repo.",Ox,Lg,gj=`A rejected request means the user has requested access to the repo and the request has been explicitly rejected
by a repo owner (either you or another user from your organization). The user cannot download any file of the
repo. Rejected requests can be accepted or cancelled at any time using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.accept_access_request">accept_access_request()</a> and
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a>. A cancelled request will go back to the pending list while an accepted request will
go to the accepted list.`,Kx,Wg,uj='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',e$,hs,t$,at,nc,n$,Vg,hj="Get the list of commits of a given revision for a repo on the Hub.",o$,Bg,fj="Commits are sorted by date (last commit first).",a$,fs,s$,ms,oc,r$,Pg,mj="Get the list of files in a given repo.",i$,Un,ac,c$,Yg,_j="List all users who liked a given repo on the hugging Face Hub.",l$,Xg,bj='See also <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_liked_repos">list_liked_repos()</a>.',p$,Cn,sc,d$,zg,yj="Get the list of refs of a given repo (both tags and branches).",g$,_s,u$,Z,rc,h$,Qg,vj="List a repo tree’s files and folders and get information about them.",f$,Og,xj="Examples:",m$,Kg,$j="Get information about a repo’s tree.",_$,bs,b$,eu,wj="Get even more information about a repo’s tree (last commit and files’ security scan results)",y$,ys,v$,vs,ic,x$,tu,kj="List scheduled compute Jobs on Hugging Face infrastructure.",$$,xs,cc,w$,nu,Tj="List spaces hosted on the Huggingface Hub, given some filters.",k$,$s,lc,T$,ou,jj="Get the list of followers of a user on the Hub.",j$,ws,pc,M$,au,Mj="Get the list of users followed by a user on the Hub.",q$,In,dc,H$,su,qj="List all configured webhooks.",U$,ks,C$,Jn,gc,I$,ru,Hj="Merges a Pull Request.",J$,Ts,N$,st,uc,A$,iu,Uj="Get info on one specific model on huggingface.co",E$,cu,Cj="Model can be private if you pass an acceptable token or are logged in.",D$,js,R$,rt,hc,G$,lu,Ij="Moving a repository from namespace1/repo_name1 to namespace2/repo_name2",Z$,pu,Jj=`Note there are certain limitations. For more information about moving
repositories, please see
<a href="https://hf.co/docs/hub/repositories-settings#renaming-or-transferring-a-repo" rel="nofollow">https://hf.co/docs/hub/repositories-settings#renaming-or-transferring-a-repo</a>.`,F$,Ms,S$,qs,fc,L$,du,Nj="Get information for a paper on the Hub.",W$,it,mc,V$,gu,Aj="Parse metadata from a safetensors file on the Hub.",B$,uu,Ej='To parse metadata from all safetensors files in a repo at once, use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_safetensors_metadata">get_safetensors_metadata()</a>.',P$,hu,Dj='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',Y$,ct,_c,X$,fu,Rj="Pause an Inference Endpoint.",z$,mu,Gj=`A paused Inference Endpoint will not be charged. It can be resumed at any time using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>.
This is different than scaling the Inference Endpoint to zero with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>, which
would be automatically restarted when a request is made to it.`,Q$,_u,Zj='For convenience, you can also pause an Inference Endpoint using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>.',O$,lt,bc,K$,bu,Fj="Pause your Space.",e2,yu,Sj=`A paused Space stops executing until manually restarted by its owner. This is different from the sleeping
state in which free Spaces go after 48h of inactivity. Paused time is not billed to your account, no matter the
hardware you’ve selected. To restart your Space, use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.restart_space">restart_space()</a> and go to your Space settings page.`,t2,vu,Lj='For more details, please visit <a href="https://huggingface.co/docs/hub/spaces-gpus#pause" rel="nofollow">the docs</a>.',n2,pt,yc,o2,xu,Wj="Permanently delete LFS files from a repo on the Hub.",a2,Hs,s2,Us,r2,X,vc,i2,$u,Vj="Pre-upload LFS files to S3 in preparation on a future commit.",c2,wu,Bj=`This method is useful if you are generating the files to upload on-the-fly and you don’t want to store them
in memory before uploading them all at once.`,l2,Cs,p2,Is,d2,Js,g2,dt,xc,u2,ku,Pj="Reject an access request from a user for a given gated repo.",h2,Tu,Yj=`A rejected request will go to the rejected list. The user cannot download any file of the repo. Rejected
requests can be accepted or cancelled at any time using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.accept_access_request">accept_access_request()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a>.
A cancelled request will go back to the pending list while an accepted request will go to the accepted list.`,f2,ju,Xj='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',m2,gt,$c,_2,Mu,zj="Renames a Discussion.",b2,Ns,y2,As,v2,Nn,wc,x2,qu,Qj="Checks if a repository exists on the Hugging Face Hub.",$2,Es,w2,An,kc,k2,Hu,Oj="Get the info object for a given repo of a given type.",T2,Ds,j2,En,Tc,M2,Uu,Kj="Request new hardware for a Space.",q2,Rs,H2,Dn,jc,U2,Cu,eM="Request persistent storage for a Space.",C2,Gs,I2,ut,Mc,J2,Iu,tM="Restart your Space.",N2,Ju,nM=`This is the only way to programmatically restart a Space if you’ve put it on Pause (see <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.pause_space">pause_space()</a>). You
must be the owner of the Space to restart it. If you are using an upgraded hardware, your account will be
billed as soon as the Space is restarted. You can trigger a restart no matter the current state of a Space.`,A2,Nu,oM='For more details, please visit <a href="https://huggingface.co/docs/hub/spaces-gpus#pause" rel="nofollow">the docs</a>.',E2,Rn,qc,D2,Au,aM="Resume an Inference Endpoint.",R2,Eu,sM='For convenience, you can also resume an Inference Endpoint using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">InferenceEndpoint.resume()</a>.',G2,Zs,Hc,Z2,Du,rM="Resume (unpause) a scheduled compute Job on Hugging Face infrastructure.",F2,Gn,Uc,S2,Ru,iM="Checks if a specific revision exists on a repo on the Hugging Face Hub.",L2,Fs,W2,ve,Cc,V2,Gu,cM="Run a method in the background and return a Future instance.",B2,Zu,lM=`The main goal is to run methods without blocking the main thread (e.g. to push data during a training).
Background jobs are queued to preserve order but are not ran in parallel. If you need to speed-up your scripts
by parallelizing lots of call to the API, you must setup and use your own <a href="https://docs.python.org/3/library/concurrent.futures.html#threadpoolexecutor" rel="nofollow">ThreadPoolExecutor</a>.`,P2,Fu,pM=`Note: Most-used methods like <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> have a <code>run_as_future: bool</code>
argument to directly call them in the background. This is equivalent to calling <code>api.run_as_future(...)</code> on them
but less verbose.`,Y2,Ss,X2,xe,Ic,z2,Su,dM="Run compute Jobs on Hugging Face infrastructure.",Q2,Lu,gM="Example:",O2,Ls,K2,Ws,e1,z,Jc,t1,Wu,uM="Run a UV script Job on Hugging Face infrastructure.",n1,Vu,hM="Example:",o1,Vs,a1,Bs,s1,Ps,r1,ht,Nc,i1,Bu,fM="Scale Inference Endpoint to zero.",c1,Pu,mM=`An Inference Endpoint scaled to zero will not be charged. It will be resume on the next request to it, with a
cold start delay. This is different than pausing the Inference Endpoint with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>, which
would require a manual resume with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>.`,l1,Yu,_M='For convenience, you can also scale an Inference Endpoint to zero using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">InferenceEndpoint.scale_to_zero()</a>.',p1,ft,Ac,d1,Xu,bM="Set a custom sleep time for a Space running on upgraded hardware..",g1,zu,yM=`Your Space will go to sleep after X seconds of inactivity. You are not billed when your Space is in “sleep”
mode. If a new visitor lands on your Space, it will “wake it up”. Only upgraded hardware can have a
configurable sleep time. To know more about the sleep stage, please refer to
<a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a>.`,u1,Ys,h1,$e,Ec,f1,Qu,vM="Download repo files.",m1,Ou,xM=`Download a whole snapshot of a repo’s files at the specified revision. This is useful when you want all files from
a repo, because you don’t know which ones you will need a priori. All files are nested inside a folder in order
to keep their actual filename relative to that folder. You can also filter which files to download using
<code>allow_patterns</code> and <code>ignore_patterns</code>.`,_1,Ku,$M=`If <code>local_dir</code> is provided, the file structure from the repo will be replicated in this location. When using this
option, the <code>cache_dir</code> will not be used and a <code>.cache/huggingface/</code> folder will be created at the root of <code>local_dir</code>
to store some metadata related to the downloaded files.While this mechanism is not as robust as the main
cache-system, it’s optimized for regularly pulling the latest version of a repository.`,b1,eh,wM=`An alternative would be to clone the repo but this requires git and git-lfs to be installed and properly
configured. It is also not possible to filter which files to download when cloning a repository using git.`,y1,mt,Dc,v1,th,kM="Get info on one specific Space on huggingface.co.",x1,nh,TM="Space can be private if you pass an acceptable token.",$1,Xs,w1,Q,Rc,k1,oh,jM="Squash commit history on a branch for a repo on the Hub.",T1,ah,MM=`Squashing the repo history is useful when you know you’ll make hundreds of commits and you don’t want to
clutter the history. Squashing commits can only be performed from the head of a branch.`,j1,zs,M1,Qs,q1,Os,H1,Ks,Gc,U1,sh,qM="Suspend (pause) a scheduled compute Job on Hugging Face infrastructure.",C1,we,Zc,I1,rh,HM="Unlike a given repo on the Hub (e.g. remove from favorite list).",J1,ih,UM="To prevent spam usage, it is not possible to <code>like</code> a repository from a script.",N1,ch,CM='See also <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_liked_repos">list_liked_repos()</a>.',A1,er,E1,Zn,Fc,D1,lh,IM="Update an item in a collection.",R1,tr,G1,ke,Sc,Z1,ph,JM="Update metadata of a collection on the Hub.",F1,dh,NM="All arguments are optional. Only provided metadata will be updated.",S1,gh,AM='Returns: <a href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.Collection">Collection</a>',L1,nr,W1,_t,Lc,V1,uh,EM="Update an Inference Endpoint.",B1,hh,DM=`This method allows the update of either the compute configuration, the deployed model, the route, or any combination.
All arguments are optional but at least one must be provided.`,P1,fh,RM='For convenience, you can also update an Inference Endpoint using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">InferenceEndpoint.update()</a>.',Y1,Fn,Wc,X1,mh,GM="Update the settings of a repository, including gated access and visibility.",z1,_h,ZM=`To give more control over how repos are used, the Hub allows repo authors to enable
access requests for their repos, and also to set the visibility of the repo to private.`,Q1,bt,Vc,O1,bh,FM="Update the visibility setting of a repository.",K1,yh,SM="Deprecated. Use <code>update_repo_settings</code> instead.",ew,or,tw,Sn,Bc,nw,vh,LM="Update an existing webhook.",ow,ar,aw,Te,Pc,sw,xh,WM=`Upload a local file (up to 50 GB) to the given repo. The upload is done
through a HTTP post request, and doesn’t require git or git-lfs to be
installed.`,rw,sr,iw,rr,cw,ir,lw,N,Yc,pw,$h,VM=`Upload a local folder to the given repo. The upload is done through a HTTP requests, and doesn’t require git or
git-lfs to be installed.`,dw,wh,BM=`The structure of the folder will be preserved. Files with the same name already present in the repository will
be overwritten. Others will be left untouched.`,gw,kh,PM=`Use the <code>allow_patterns</code> and <code>ignore_patterns</code> arguments to specify which files to upload. These parameters
accept either a single pattern or a list of patterns. Patterns are Standard Wildcards (globbing patterns) as
documented <a href="https://tldp.org/LDP/GNU-Linux-Tools-Summary/html/x11655.htm" rel="nofollow">here</a>. If both <code>allow_patterns</code> and
<code>ignore_patterns</code> are provided, both constraints apply. By default, all files from the folder are uploaded.`,uw,Th,YM=`Use the <code>delete_patterns</code> argument to specify remote files you want to delete. Input type is the same as for
<code>allow_patterns</code> (see above). If <code>path_in_repo</code> is also provided, the patterns are matched against paths
relative to this folder. For example, <code>upload_folder(..., path_in_repo=&quot;experiment&quot;, delete_patterns=&quot;logs/*&quot;)</code>
will delete any remote file under <code>./experiment/logs/</code>. Note that the <code>.gitattributes</code> file will not be deleted
even if it matches the patterns.`,hw,jh,XM=`Any <code>.git/</code> folder present in any subdirectory will be ignored. However, please be aware that the <code>.gitignore</code>
file is not taken into account.`,fw,Mh,zM="Uses <code>HfApi.create_commit</code> under the hood.",mw,cr,_w,lr,bw,pr,yw,dr,vw,J,Xc,xw,qh,QM="Upload a large folder to the Hub in the most resilient way possible.",$w,Hh,OM=`Several workers are started to upload files in an optimized way. Before being committed to a repo, files must be
hashed and be pre-uploaded if they are LFS files. Workers will perform these tasks for each file in the folder.
At each step, some metadata information about the upload process is saved in the folder under <code>.cache/.huggingface/</code>
to be able to resume the process if interrupted. The whole process might result in several commits.`,ww,gr,kw,ur,Tw,Uh,KM="<strong>Technical details:</strong>",jw,Ch,eq="<code>upload_large_folder</code> process is as follow:",Mw,Ih,tq=`<li>(Check parameters and setup.)</li> <li>Create repo if missing.</li> <li>List local files to upload.</li> <li>Run validation checks and display warnings if repository limits might be exceeded:<ul><li>Warns if the total number of files exceeds 100k (recommended limit).</li> <li>Warns if any folder contains more than 10k files (recommended limit).</li> <li>Warns about files larger than 20GB (recommended) or 50GB (hard limit).</li></ul></li> <li>Start workers. Workers can perform the following tasks:<ul><li>Hash a file.</li> <li>Get upload mode (regular or LFS) for a list of files.</li> <li>Pre-upload an LFS file.</li> <li>Commit a bunch of files.
Once a worker finishes a task, it will move on to the next task based on the priority list (see below) until
all files are uploaded and committed.</li></ul></li> <li>While workers are up, regularly print a report to sys.stdout.</li>`,qw,Jh,nq="Order of priority:",Hw,Nh,oq="<li>Commit if more than 5 minutes since last commit attempt (and at least 1 file).</li> <li>Commit if at least 150 files are ready to commit.</li> <li>Get upload mode if at least 10 files have been hashed.</li> <li>Pre-upload LFS file if at least 1 file and no worker is pre-uploading.</li> <li>Hash file if at least 1 file and no worker is hashing.</li> <li>Get upload mode if at least 1 file and no worker is getting upload mode.</li> <li>Pre-upload LFS file if at least 1 file (exception: if hf_transfer is enabled, only 1 worker can preupload LFS at a time).</li> <li>Hash file if at least 1 file to hash.</li> <li>Get upload mode if at least 1 file to get upload mode.</li> <li>Commit if at least 1 file to commit and at least 1 min since last commit attempt.</li> <li>Commit if at least 1 file to commit and all other queues are empty.</li>",Uw,Ah,aq="Special rules:",Cw,Eh,sq="<li>If <code>hf_transfer</code> is enabled, only 1 LFS uploader at a time. Otherwise the CPU would be bloated by <code>hf_transfer</code>.</li> <li>Only one worker can commit at a time.</li> <li>If no tasks are available, the worker waits for 10 seconds before checking again.</li>",Iw,hr,zc,Jw,Dh,rq="Call HF API to know “whoami”.",Of,Qc,Kf,Oc,em,Kn,Kc,Nw,Rh,iq="Data structure containing information about a user access request.",tm,el,nm,vt,tl,Aw,Gh,cq="Data structure containing information about a newly created commit.",Ew,Zh,lq=`Returned by any method that creates a commit on the Hub: <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>,
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_file">delete_file()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_folder">delete_folder()</a>. It inherits from <code>str</code> for backward compatibility but using methods specific
to <code>str</code> is deprecated.`,om,nl,am,xt,ol,Dw,Fh,pq='Contains information about a dataset on the Hub. This object is returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.dataset_info">dataset_info()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_datasets">list_datasets()</a>.',Rw,fr,sm,al,rm,eo,sl,Gw,Sh,dq="Contains information about a git reference for a repo on the Hub.",im,rl,cm,to,il,Zw,Lh,gq='Contains information about a git commit for a repo on the Hub. Check out <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_repo_commits">list_repo_commits()</a> for more details.',lm,cl,pm,$t,ll,Fw,Wh,uq="Contains information about all git references for a repo on the Hub.",Sw,Vh,hq='Object is returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_repo_refs">list_repo_refs()</a>.',dm,pl,gm,dl,gl,um,ul,hm,K,hl,Lw,Bh,fq="Contains information about a file stored as LFS on a repo on the Hub.",Ww,Ph,mq=`Used in the context of listing and permanently deleting LFS files from a repo to free-up space.
See <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_lfs_files">list_lfs_files()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.permanently_delete_lfs_files">permanently_delete_lfs_files()</a> for more details.`,Vw,Yh,_q=`Git LFS files are tracked using SHA-256 object IDs, rather than file paths, to optimize performance
This approach is necessary because a single object can be referenced by multiple paths across different commits,
making it impractical to search and resolve these connections. Check out <a href="https://huggingface.co/docs/hub/storage-limits#advanced-track-lfs-file-references" rel="nofollow">our documentation</a>
to learn how to know which filename(s) is(are) associated with each SHA.`,Bw,mr,fm,fl,mm,wt,ml,Pw,Xh,bq='Contains information about a model on the Hub. This object is returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.model_info">model_info()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_models">list_models()</a>.',Yw,_r,_m,_l,bm,kt,bl,Xw,zh,yq="Contains basic information about a repo file inside a repo on the Hub.",zw,br,ym,yl,vm,no,vl,Qw,Qh,vq="Contains information about a file on the Hub.",xm,xl,$m,ee,$l,Ow,Oh,xq="Subclass of <code>str</code> describing a repo URL on the Hub.",Kw,Kh,$q=`<code>RepoUrl</code> is returned by <code>HfApi.create_repo</code>. It inherits from <code>str</code> for backward
compatibility. At initialization, the URL is parsed to populate properties:`,ek,ef,wq="<li>endpoint (<code>str</code>)</li> <li>namespace (<code>Optional[str]</code>)</li> <li>repo_name (<code>str</code>)</li> <li>repo_id (<code>str</code>)</li> <li>repo_type (<code>Literal[&quot;model&quot;, &quot;dataset&quot;, &quot;space&quot;]</code>)</li> <li>url (<code>str</code>)</li>",tk,yr,wm,wl,km,te,kl,nk,tf,kq="Metadata for a Safetensors repo.",ok,nf,Tq=`A repo is considered to be a Safetensors repo if it contains either a ‘model.safetensors’ weight file (non-shared
model) or a ‘model.safetensors.index.json’ index file (sharded model) at its root.`,ak,of,jq='This class is returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_safetensors_metadata">get_safetensors_metadata()</a>.',sk,af,Mq='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',Tm,Tl,jm,je,jl,rk,sf,qq="Metadata for a Safetensors file hosted on the Hub.",ik,rf,Hq='This class is returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.parse_safetensors_file_metadata">parse_safetensors_file_metadata()</a>.',ck,cf,Uq='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',Mm,Ml,qm,Tt,ql,lk,lf,Cq='Contains information about a Space on the Hub. This object is returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.space_info">space_info()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_spaces">list_spaces()</a>.',pk,vr,Hm,Hl,Um,jt,Ul,dk,pf,Iq="Information about a tensor.",gk,df,Jq='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',Cm,Cl,Im,oo,Il,uk,gf,Nq="Contains information about a user on the Hub.",Jm,Jl,Nm,ao,Nl,hk,uf,Aq="Contains information about a user likes on the Hub.",Am,Al,Em,so,El,fk,hf,Eq="Data structure containing information about a webhook.",Dm,Dl,Rm,ro,Rl,mk,ff,Dq="Data structure containing information about the items watched by a webhook.",Gm,Gl,Zm,Zl,Rq="Below are the supported values for <code>CommitOperation()</code>:",Fm,Me,Fl,_k,mf,Gq="Data structure holding necessary info to upload a file to a repository on the Hub.",bk,Ln,Sl,yk,_f,Zq=`A context manager that yields a file-like object allowing to read the underlying
data behind <code>path_or_fileobj</code>.`,vk,xr,xk,Wn,Ll,$k,bf,Fq="The base64-encoded content of <code>path_or_fileobj</code>",wk,yf,Sq="Returns: <code>bytes</code>",Sm,io,Wl,kk,vf,Lq=`Data structure holding necessary info to delete a file or a folder from a repository
on the Hub.`,Lm,ne,Vl,Tk,xf,Wq="Data structure holding necessary info to copy a file in a repository on the Hub.",jk,$f,Vq="Limitations:",Mk,wf,Bq="<li>Only LFS files can be copied. To copy a regular file, you need to download it locally and re-upload it</li> <li>Cross-repository copies are not supported.</li>",qk,kf,Pq='Note: you can combine a <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationCopy">CommitOperationCopy</a> and a <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationDelete">CommitOperationDelete</a> to rename an LFS file on the Hub.',Wm,Bl,Vm,R,Pl,Hk,Tf,Yq="Scheduler to upload a local folder to the Hub at regular intervals (e.g. push to hub every 5 minutes).",Uk,jf,Xq=`The recommended way to use the scheduler is to use it as a context manager. This ensures that the scheduler is
properly stopped and the last commit is triggered when the script ends. The scheduler can also be stopped manually
with the <code>stop</code> method. Checkout the <a href="https://huggingface.co/docs/huggingface_hub/guides/upload#scheduled-uploads" rel="nofollow">upload guide</a>
to learn more about how to use it.`,Ck,$r,Ik,wr,Jk,yt,Yl,Nk,Mf,zq="Push folder to the Hub and return the commit info.",Ak,kr,Ek,qf,Qq=`The default behavior of <code>push_to_hub</code> is to assume an append-only folder. It lists all files in the folder and
uploads only changed files. If no changes are found, the method returns without committing anything. If you want
to change this behavior, you can inherit from <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a> and override this method. This can be useful
for example to compress data together in a single file before committing. For more details and examples, check
out our <a href="https://huggingface.co/docs/huggingface_hub/main/en/guides/upload#scheduled-uploads" rel="nofollow">integration guide</a>.`,Dk,Vn,Xl,Rk,Hf,Oq="Stop the scheduler.",Gk,Uf,Kq="A stopped scheduler cannot be restarted. Mostly for tests purposes.",Zk,Bn,zl,Fk,Cf,eH="Trigger a <code>push_to_hub</code> and return a future.",Sk,If,tH=`This method is automatically called every <code>every</code> minutes. You can also call it manually to trigger a commit
immediately, without waiting for the next scheduled commit.`,Bm,Ql,Pm,Bf,Ym;return g=new A({props:{title:"HfApi Client",local:"hfapi-client",headingTag:"h1"}}),Ir=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwbGlzdF9tb2RlbHMlMEElMEElMjMlMjBVc2UlMjByb290JTIwbWV0aG9kJTBBbW9kZWxzJTIwJTNEJTIwbGlzdF9tb2RlbHMoKSUwQSUwQSUyMyUyME9yJTIwY29uZmlndXJlJTIwYSUyMEhmQXBpJTIwY2xpZW50JTBBaGZfYXBpJTIwJTNEJTIwSGZBcGkoJTBBJTIwJTIwJTIwJTIwZW5kcG9pbnQlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTIyJTJDJTIwJTIzJTIwQ2FuJTIwYmUlMjBhJTIwUHJpdmF0ZSUyMEh1YiUyMGVuZHBvaW50LiUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyaGZfeHh4JTIyJTJDJTIwJTIzJTIwVG9rZW4lMjBpcyUyMG5vdCUyMHBlcnNpc3RlZCUyMG9uJTIwdGhlJTIwbWFjaGluZS4lMEEpJTBBbW9kZWxzJTIwJTNEJTIwaGZfYXBpLmxpc3RfbW9kZWxzKCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, list_models

<span class="hljs-comment"># Use root method</span>
models = list_models()

<span class="hljs-comment"># Or configure a HfApi client</span>
hf_api = HfApi(
    endpoint=<span class="hljs-string">&quot;https://huggingface.co&quot;</span>, <span class="hljs-comment"># Can be a Private Hub endpoint.</span>
    token=<span class="hljs-string">&quot;hf_xxx&quot;</span>, <span class="hljs-comment"># Token is not persisted on the machine.</span>
)
models = hf_api.list_models()`,wrap:!1}}),Jr=new A({props:{title:"HfApi",local:"huggingface_hub.HfApi",headingTag:"h2"}}),Nr=new q({props:{name:"class huggingface_hub.HfApi",anchor:"huggingface_hub.HfApi",parameters:[{name:"endpoint",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"library_name",val:": Optional[str] = None"},{name:"library_version",val:": Optional[str] = None"},{name:"user_agent",val:": Union[Dict, str, None] = None"},{name:"headers",val:": Optional[Dict[str, str]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.endpoint",description:`<strong>endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Endpoint of the Hub. Defaults to <a href="https://huggingface.co" rel="nofollow">https://huggingface.co</a>.`,name:"endpoint"},{anchor:"huggingface_hub.HfApi.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.library_name",description:`<strong>library_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the library that is making the HTTP request. Will be added to
the user-agent header. Example: <code>&quot;transformers&quot;</code>.`,name:"library_name"},{anchor:"huggingface_hub.HfApi.library_version",description:`<strong>library_version</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The version of the library that is making the HTTP request. Will be added
to the user-agent header. Example: <code>&quot;4.24.0&quot;</code>.`,name:"library_version"},{anchor:"huggingface_hub.HfApi.user_agent",description:`<strong>user_agent</strong> (<code>str</code>, <code>dict</code>, <em>optional</em>) &#x2014;
The user agent info in the form of a dictionary or a single string. It will
be completed with information about the installed packages.`,name:"user_agent"},{anchor:"huggingface_hub.HfApi.headers",description:`<strong>headers</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional headers to be sent with each request. Example: <code>{&quot;X-My-Header&quot;: &quot;value&quot;}</code>.
Headers passed here are taking precedence over the default headers.`,name:"headers"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1675"}}),Ar=new q({props:{name:"accept_access_request",anchor:"huggingface_hub.HfApi.accept_access_request",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.accept_access_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to accept access request for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.accept_access_request.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user which access request should be accepted.`,name:"user"},{anchor:"huggingface_hub.HfApi.accept_access_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to accept access request for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.accept_access_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8995",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request cannot be found.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request is already in the accepted list.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Er=new q({props:{name:"add_collection_item",anchor:"huggingface_hub.HfApi.add_collection_item",parameters:[{name:"collection_slug",val:": str"},{name:"item_id",val:": str"},{name:"item_type",val:": CollectionItemType_T"},{name:"note",val:": Optional[str] = None"},{name:"exists_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.add_collection_item.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.add_collection_item.item_id",description:`<strong>item_id</strong> (<code>str</code>) &#x2014;
ID of the item to add to the collection. It can be the ID of a repo on the Hub (e.g. <code>&quot;facebook/bart-large-mnli&quot;</code>)
or a paper id (e.g. <code>&quot;2307.09288&quot;</code>).`,name:"item_id"},{anchor:"huggingface_hub.HfApi.add_collection_item.item_type",description:`<strong>item_type</strong> (<code>str</code>) &#x2014;
Type of the item to add. Can be one of <code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code>, <code>&quot;space&quot;</code> or <code>&quot;paper&quot;</code>.`,name:"item_type"},{anchor:"huggingface_hub.HfApi.add_collection_item.note",description:`<strong>note</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A note to attach to the item in the collection. The maximum size for a note is 500 characters.`,name:"note"},{anchor:"huggingface_hub.HfApi.add_collection_item.exists_ok",description:`<strong>exists_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if item already exists.`,name:"exists_ok"},{anchor:"huggingface_hub.HfApi.add_collection_item.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8547",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the item you try to add to the collection does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 409 if the item you try to add to the collection is already in the collection (and exists_ok=False)</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Vo=new C({props:{anchor:"huggingface_hub.HfApi.add_collection_item.example",$$slots:{default:[dH]},$$scope:{ctx:T}}}),Dr=new q({props:{name:"add_space_secret",anchor:"huggingface_hub.HfApi.add_space_secret",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"value",val:": str"},{name:"description",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.add_space_secret.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.add_space_secret.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Secret key. Example: <code>&quot;GITHUB_API_KEY&quot;</code>`,name:"key"},{anchor:"huggingface_hub.HfApi.add_space_secret.value",description:`<strong>value</strong> (<code>str</code>) &#x2014;
Secret value. Example: <code>&quot;your_github_api_key&quot;</code>.`,name:"value"},{anchor:"huggingface_hub.HfApi.add_space_secret.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Secret description. Example: <code>&quot;Github API key to access the Github API&quot;</code>.`,name:"description"},{anchor:"huggingface_hub.HfApi.add_space_secret.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6996"}}),Rr=new q({props:{name:"add_space_variable",anchor:"huggingface_hub.HfApi.add_space_variable",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"value",val:": str"},{name:"description",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.add_space_variable.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.add_space_variable.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Variable key. Example: <code>&quot;MODEL_REPO_ID&quot;</code>`,name:"key"},{anchor:"huggingface_hub.HfApi.add_space_variable.value",description:`<strong>value</strong> (<code>str</code>) &#x2014;
Variable value. Example: <code>&quot;the_model_repo_id&quot;</code>.`,name:"value"},{anchor:"huggingface_hub.HfApi.add_space_variable.description",description:`<strong>description</strong> (<code>str</code>) &#x2014;
Description of the variable. Example: <code>&quot;Model Repo ID of the implemented model&quot;</code>.`,name:"description"},{anchor:"huggingface_hub.HfApi.add_space_variable.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7084"}}),Gr=new q({props:{name:"auth_check",anchor:"huggingface_hub.HfApi.auth_check",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.auth_check.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to check for access. Format should be <code>&quot;user/repo_name&quot;</code>.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.auth_check.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository. Should be one of <code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code>, or <code>&quot;space&quot;</code>.
If not specified, the default is <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.auth_check.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9903",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>
<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
Raised if the repository does not exist, is private, or the user does not have access. This can
occur if the <code>repo_id</code> or <code>repo_type</code> is incorrect or if the repository is private but the user
is not authenticated.</p>
</li>
<li>
<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.GatedRepoError"
>GatedRepoError</a> —
Raised if the repository exists but is gated and the user is not authorized to access it.</p>
</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.GatedRepoError"
>GatedRepoError</a></p>
`}}),Bo=new C({props:{anchor:"huggingface_hub.HfApi.auth_check.example",$$slots:{default:[gH]},$$scope:{ctx:T}}}),Zr=new q({props:{name:"cancel_access_request",anchor:"huggingface_hub.HfApi.cancel_access_request",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.cancel_access_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to cancel access request for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.cancel_access_request.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user which access request should be cancelled.`,name:"user"},{anchor:"huggingface_hub.HfApi.cancel_access_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to cancel access request for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.cancel_access_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8955",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request cannot be found.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request is already in the pending list.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Fr=new q({props:{name:"cancel_job",anchor:"huggingface_hub.HfApi.cancel_job",parameters:[{name:"job_id",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.cancel_job.job_id",description:`<strong>job_id</strong> (<code>str</code>) &#x2014;
ID of the Job.`,name:"job_id"},{anchor:"huggingface_hub.HfApi.cancel_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job is running. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.cancel_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10225"}}),Sr=new q({props:{name:"change_discussion_status",anchor:"huggingface_hub.HfApi.change_discussion_status",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"new_status",val:": Literal['open', 'closed']"},{name:"token",val:": Union[bool, str, None] = None"},{name:"comment",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.change_discussion_status.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.change_discussion_status.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.change_discussion_status.new_status",description:`<strong>new_status</strong> (<code>str</code>) &#x2014;
The new status for the discussion, either <code>&quot;open&quot;</code> or <code>&quot;closed&quot;</code>.`,name:"new_status"},{anchor:"huggingface_hub.HfApi.change_discussion_status.comment",description:`<strong>comment</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional comment to post with the status change.`,name:"comment"},{anchor:"huggingface_hub.HfApi.change_discussion_status.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.change_discussion_status.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6738",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the status change event</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionStatusChange"
>DiscussionStatusChange</a></p>
`}}),Yo=new C({props:{anchor:"huggingface_hub.HfApi.change_discussion_status.example",$$slots:{default:[uH]},$$scope:{ctx:T}}}),Xo=new I({props:{$$slots:{default:[hH]},$$scope:{ctx:T}}}),Lr=new q({props:{name:"comment_discussion",anchor:"huggingface_hub.HfApi.comment_discussion",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"comment",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.comment_discussion.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.comment_discussion.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.comment_discussion.comment",description:`<strong>comment</strong> (<code>str</code>) &#x2014;
The content of the comment to create. Comments support markdown formatting.`,name:"comment"},{anchor:"huggingface_hub.HfApi.comment_discussion.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.comment_discussion.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6589",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the newly created comment</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionComment"
>DiscussionComment</a></p>
`}}),zo=new C({props:{anchor:"huggingface_hub.HfApi.comment_discussion.example",$$slots:{default:[fH]},$$scope:{ctx:T}}}),Qo=new I({props:{$$slots:{default:[mH]},$$scope:{ctx:T}}}),Wr=new q({props:{name:"create_branch",anchor:"huggingface_hub.HfApi.create_branch",parameters:[{name:"repo_id",val:": str"},{name:"branch",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"exist_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_branch.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which the branch will be created.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_branch.branch",description:`<strong>branch</strong> (<code>str</code>) &#x2014;
The name of the branch to create.`,name:"branch"},{anchor:"huggingface_hub.HfApi.create_branch.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to create the branch from. It can be a branch name or
the OID/SHA of a commit, as a hexadecimal string. Defaults to the head
of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_branch.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_branch.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if creating a branch on a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if tagging a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_branch.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if branch already exists.`,name:"exist_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5930",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If invalid reference for a branch. Ex: <code>refs/pr/5</code> or ‘refs/foo/bar’.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If the branch already exists on the repo (error 409) and <code>exist_ok</code> is
set to <code>False</code>.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a></p>
`}}),Vr=new q({props:{name:"create_collection",anchor:"huggingface_hub.HfApi.create_collection",parameters:[{name:"title",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"description",val:": Optional[str] = None"},{name:"private",val:": bool = False"},{name:"exists_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_collection.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
Title of the collection to create. Example: <code>&quot;Recent models&quot;</code>.`,name:"title"},{anchor:"huggingface_hub.HfApi.create_collection.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Namespace of the collection to create (username or org). Will default to the owner name.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.create_collection.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Description of the collection to create.`,name:"description"},{anchor:"huggingface_hub.HfApi.create_collection.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the collection should be private or not. Defaults to <code>False</code> (i.e. public collection).`,name:"private"},{anchor:"huggingface_hub.HfApi.create_collection.exists_ok",description:`<strong>exists_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if collection already exists.`,name:"exists_ok"},{anchor:"huggingface_hub.HfApi.create_collection.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8370"}}),Ko=new C({props:{anchor:"huggingface_hub.HfApi.create_collection.example",$$slots:{default:[_H]},$$scope:{ctx:T}}}),Br=new q({props:{name:"create_commit",anchor:"huggingface_hub.HfApi.create_commit",parameters:[{name:"repo_id",val:": str"},{name:"operations",val:": Iterable[CommitOperation]"},{name:"commit_message",val:": str"},{name:"commit_description",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"num_threads",val:": int = 5"},{name:"parent_commit",val:": Optional[str] = None"},{name:"run_as_future",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_commit.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which the commit will be created, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_commit.operations",description:`<strong>operations</strong> (<code>Iterable</code> of <code>CommitOperation()</code>) &#x2014;
An iterable of operations to include in the commit, either:</p>
<ul>
<li><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationAdd">CommitOperationAdd</a> to upload a file</li>
<li><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationDelete">CommitOperationDelete</a> to delete a file</li>
<li><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationCopy">CommitOperationCopy</a> to copy a file</li>
</ul>
<p>Operation objects will be mutated to include information relative to the upload. Do not reuse the
same objects for multiple commits.`,name:"operations"},{anchor:"huggingface_hub.HfApi.create_commit.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
The summary (first line) of the commit that will be created.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.create_commit.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.create_commit.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_commit.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_commit.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_commit.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.create_commit.num_threads",description:`<strong>num_threads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of concurrent threads for uploading files. Defaults to 5.
Setting it to 2 means at most 2 files will be uploaded concurrently.`,name:"num_threads"},{anchor:"huggingface_hub.HfApi.create_commit.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string.
Shorthands (7 first characters) are also supported. If specified and <code>create_pr</code> is <code>False</code>,
the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>. If specified and <code>create_pr</code>
is <code>True</code>, the pull request will be created from <code>parent_commit</code>. Specifying <code>parent_commit</code>
ensures the repo has not changed before committing the changes, and can be especially useful
if the repo is updated / committed to concurrently.`,name:"parent_commit"},{anchor:"huggingface_hub.HfApi.create_commit.run_as_future",description:`<strong>run_as_future</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to run this method in the background. Background jobs are run sequentially without
blocking the main thread. Passing <code>run_as_future=True</code> will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow">Future</a>
object. Defaults to <code>False</code>.`,name:"run_as_future"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4071",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Instance of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> containing information about the newly created commit (commit hash, commit
url, pr url, commit message,…). If <code>run_as_future=True</code> is passed, returns a Future object which will
contain the result when executed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> or <code>Future</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If commit message is empty.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If parent commit is not a valid commit OID.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If a README.md file with an invalid metadata section is committed. In this case, the commit will fail
early, before trying to upload any file.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>create_pr</code> is <code>True</code> and revision is neither <code>None</code> nor <code>"main"</code>.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),ea=new I({props:{warning:!0,$$slots:{default:[bH]},$$scope:{ctx:T}}}),ta=new I({props:{warning:!0,$$slots:{default:[yH]},$$scope:{ctx:T}}}),na=new I({props:{warning:!0,$$slots:{default:[vH]},$$scope:{ctx:T}}}),Pr=new q({props:{name:"create_discussion",anchor:"huggingface_hub.HfApi.create_discussion",parameters:[{name:"repo_id",val:": str"},{name:"title",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"description",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"pull_request",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_discussion.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_discussion.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
The title of the discussion. It can be up to 200 characters long,
and must be at least 3 characters long. Leading and trailing whitespaces
will be stripped.`,name:"title"},{anchor:"huggingface_hub.HfApi.create_discussion.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_discussion.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional description for the Pull Request.
Defaults to <code>&quot;Discussion opened with the huggingface_hub Python library&quot;</code>`,name:"description"},{anchor:"huggingface_hub.HfApi.create_discussion.pull_request",description:`<strong>pull_request</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to create a Pull Request or discussion. If <code>True</code>, creates a Pull Request.
If <code>False</code>, creates a discussion. Defaults to <code>False</code>.`,name:"pull_request"},{anchor:"huggingface_hub.HfApi.create_discussion.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6410"}}),oa=new I({props:{$$slots:{default:[xH]},$$scope:{ctx:T}}}),Yr=new q({props:{name:"create_inference_endpoint",anchor:"huggingface_hub.HfApi.create_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"repository",val:": str"},{name:"framework",val:": str"},{name:"accelerator",val:": str"},{name:"instance_size",val:": str"},{name:"instance_type",val:": str"},{name:"region",val:": str"},{name:"vendor",val:": str"},{name:"account_id",val:": Optional[str] = None"},{name:"min_replica",val:": int = 1"},{name:"max_replica",val:": int = 1"},{name:"scale_to_zero_timeout",val:": Optional[int] = None"},{name:"revision",val:": Optional[str] = None"},{name:"task",val:": Optional[str] = None"},{name:"custom_image",val:": Optional[Dict] = None"},{name:"env",val:": Optional[Dict[str, str]] = None"},{name:"secrets",val:": Optional[Dict[str, str]] = None"},{name:"type",val:": InferenceEndpointType = <InferenceEndpointType.PROTECTED: 'protected'>"},{name:"domain",val:": Optional[str] = None"},{name:"path",val:": Optional[str] = None"},{name:"cache_http_responses",val:": Optional[bool] = None"},{name:"tags",val:": Optional[List[str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The unique name for the new Inference Endpoint.`,name:"name"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.repository",description:`<strong>repository</strong> (<code>str</code>) &#x2014;
The name of the model repository associated with the Inference Endpoint (e.g. <code>&quot;gpt2&quot;</code>).`,name:"repository"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.framework",description:`<strong>framework</strong> (<code>str</code>) &#x2014;
The machine learning framework used for the model (e.g. <code>&quot;custom&quot;</code>).`,name:"framework"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.accelerator",description:`<strong>accelerator</strong> (<code>str</code>) &#x2014;
The hardware accelerator to be used for inference (e.g. <code>&quot;cpu&quot;</code>).`,name:"accelerator"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.instance_size",description:`<strong>instance_size</strong> (<code>str</code>) &#x2014;
The size or type of the instance to be used for hosting the model (e.g. <code>&quot;x4&quot;</code>).`,name:"instance_size"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.instance_type",description:`<strong>instance_type</strong> (<code>str</code>) &#x2014;
The cloud instance type where the Inference Endpoint will be deployed (e.g. <code>&quot;intel-icl&quot;</code>).`,name:"instance_type"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.region",description:`<strong>region</strong> (<code>str</code>) &#x2014;
The cloud region in which the Inference Endpoint will be created (e.g. <code>&quot;us-east-1&quot;</code>).`,name:"region"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.vendor",description:`<strong>vendor</strong> (<code>str</code>) &#x2014;
The cloud provider or vendor where the Inference Endpoint will be hosted (e.g. <code>&quot;aws&quot;</code>).`,name:"vendor"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.account_id",description:`<strong>account_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The account ID used to link a VPC to a private Inference Endpoint (if applicable).`,name:"account_id"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.min_replica",description:`<strong>min_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of replicas (instances) to keep running for the Inference Endpoint. To enable
scaling to zero, set this value to 0 and adjust <code>scale_to_zero_timeout</code> accordingly. Defaults to 1.`,name:"min_replica"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.max_replica",description:`<strong>max_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of replicas (instances) to scale to for the Inference Endpoint. Defaults to 1.`,name:"max_replica"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.scale_to_zero_timeout",description:`<strong>scale_to_zero_timeout</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The duration in minutes before an inactive endpoint is scaled to zero, or no scaling to zero if
set to None and <code>min_replica</code> is not 0. Defaults to None.`,name:"scale_to_zero_timeout"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model revision to deploy on the Inference Endpoint (e.g. <code>&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</code>).`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task on which to deploy the model (e.g. <code>&quot;text-classification&quot;</code>).`,name:"task"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.custom_image",description:`<strong>custom_image</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A custom Docker image to use for the Inference Endpoint. This is useful if you want to deploy an
Inference Endpoint running on the <code>text-generation-inference</code> (TGI) framework (see examples).`,name:"custom_image"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.env",description:`<strong>env</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Non-secret environment variables to inject in the container environment.`,name:"env"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.secrets",description:`<strong>secrets</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Secret values to inject in the container environment.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.type",description:"<strong>type</strong> ([`InferenceEndpointType]<code>, *optional*) -- The type of the Inference Endpoint, which can be </code>&#x201C;protected&#x201D;<code>(default),</code>&#x201C;public&#x201D;<code>or</code>&#x201C;private&#x201D;`.",name:"type"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.domain",description:`<strong>domain</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The custom domain for the Inference Endpoint deployment, if setup the inference endpoint will be available at this domain (e.g. <code>&quot;my-new-domain.cool-website.woof&quot;</code>).`,name:"domain"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.path",description:`<strong>path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The custom path to the deployed model, should start with a <code>/</code> (e.g. <code>&quot;/models/google-bert/bert-base-uncased&quot;</code>).`,name:"path"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.cache_http_responses",description:`<strong>cache_http_responses</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to cache HTTP responses from the Inference Endpoint. Defaults to <code>False</code>.`,name:"cache_http_responses"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of tags to associate with the Inference Endpoint.`,name:"tags"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Inference Endpoint will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7613",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the updated Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),aa=new C({props:{anchor:"huggingface_hub.HfApi.create_inference_endpoint.example",$$slots:{default:[$H]},$$scope:{ctx:T}}}),sa=new C({props:{anchor:"huggingface_hub.HfApi.create_inference_endpoint.example-2",$$slots:{default:[wH]},$$scope:{ctx:T}}}),ra=new C({props:{anchor:"huggingface_hub.HfApi.create_inference_endpoint.example-3",$$slots:{default:[kH]},$$scope:{ctx:T}}}),Xr=new q({props:{name:"create_inference_endpoint_from_catalog",anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog",parameters:[{name:"repo_id",val:": str"},{name:"name",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"namespace",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The ID of the model in the catalog to deploy as an Inference Endpoint.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.name",description:`<strong>name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The unique name for the new Inference Endpoint. If not provided, a random name will be generated.`,name:"name"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).`,name:"token"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Inference Endpoint will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7842",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the new Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),ia=new I({props:{warning:!0,$$slots:{default:[TH]},$$scope:{ctx:T}}}),zr=new q({props:{name:"create_pull_request",anchor:"huggingface_hub.HfApi.create_pull_request",parameters:[{name:"repo_id",val:": str"},{name:"title",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"description",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_pull_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_pull_request.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
The title of the discussion. It can be up to 200 characters long,
and must be at least 3 characters long. Leading and trailing whitespaces
will be stripped.`,name:"title"},{anchor:"huggingface_hub.HfApi.create_pull_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_pull_request.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional description for the Pull Request.
Defaults to <code>&quot;Discussion opened with the huggingface_hub Python library&quot;</code>`,name:"description"},{anchor:"huggingface_hub.HfApi.create_pull_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6502"}}),ca=new I({props:{$$slots:{default:[jH]},$$scope:{ctx:T}}}),Qr=new q({props:{name:"create_repo",anchor:"huggingface_hub.HfApi.create_repo",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"private",val:": Optional[bool] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"exist_ok",val:": bool = False"},{name:"resource_group_id",val:": Optional[str] = None"},{name:"space_sdk",val:": Optional[str] = None"},{name:"space_hardware",val:": Optional[SpaceHardware] = None"},{name:"space_storage",val:": Optional[SpaceStorage] = None"},{name:"space_sleep_time",val:": Optional[int] = None"},{name:"space_secrets",val:": Optional[List[Dict[str, str]]] = None"},{name:"space_variables",val:": Optional[List[Dict[str, str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_repo.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_repo.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_repo.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to make the repo private. If <code>None</code> (default), the repo will be public unless the organization&#x2019;s default is private. This value is ignored if the repo already exists.`,name:"private"},{anchor:"huggingface_hub.HfApi.create_repo.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_repo.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if repo already exists.`,name:"exist_ok"},{anchor:"huggingface_hub.HfApi.create_repo.resource_group_id",description:`<strong>resource_group_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Resource group in which to create the repo. Resource groups is only available for Enterprise Hub organizations and
allow to define which members of the organization can access the resource. The ID of a resource group
can be found in the URL of the resource&#x2019;s page on the Hub (e.g. <code>&quot;66670e5163145ca562cb1988&quot;</code>).
To learn more about resource groups, see <a href="https://huggingface.co/docs/hub/en/security-resource-groups" rel="nofollow">https://huggingface.co/docs/hub/en/security-resource-groups</a>.`,name:"resource_group_id"},{anchor:"huggingface_hub.HfApi.create_repo.space_sdk",description:`<strong>space_sdk</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Choice of SDK to use if repo_type is &#x201C;space&#x201D;. Can be &#x201C;streamlit&#x201D;, &#x201C;gradio&#x201D;, &#x201C;docker&#x201D;, or &#x201C;static&#x201D;.`,name:"space_sdk"},{anchor:"huggingface_hub.HfApi.create_repo.space_hardware",description:`<strong>space_hardware</strong> (<code>SpaceHardware</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of Hardware if repo_type is &#x201C;space&#x201D;. See <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for a complete list.`,name:"space_hardware"},{anchor:"huggingface_hub.HfApi.create_repo.space_storage",description:`<strong>space_storage</strong> (<code>SpaceStorage</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of persistent storage tier. Example: <code>&quot;small&quot;</code>. See <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceStorage">SpaceStorage</a> for a complete list.`,name:"space_storage"},{anchor:"huggingface_hub.HfApi.create_repo.space_sleep_time",description:`<strong>space_sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to sleep (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"space_sleep_time"},{anchor:"huggingface_hub.HfApi.create_repo.space_secrets",description:`<strong>space_secrets</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of secret keys to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,name:"space_secrets"},{anchor:"huggingface_hub.HfApi.create_repo.space_variables",description:`<strong>space_variables</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of public environment variables to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>.`,name:"space_variables"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3637",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>URL to the newly created repo. Value is a subclass of <code>str</code> containing
attributes like <code>endpoint</code>, <code>repo_type</code> and <code>repo_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.RepoUrl"
>RepoUrl</a></p>
`}}),Or=new q({props:{name:"create_scheduled_job",anchor:"huggingface_hub.HfApi.create_scheduled_job",parameters:[{name:"image",val:": str"},{name:"command",val:": List[str]"},{name:"schedule",val:": str"},{name:"suspend",val:": Optional[bool] = None"},{name:"concurrency",val:": Optional[bool] = None"},{name:"env",val:": Optional[Dict[str, Any]] = None"},{name:"secrets",val:": Optional[Dict[str, Any]] = None"},{name:"flavor",val:": Optional[SpaceHardware] = None"},{name:"timeout",val:": Optional[Union[int, float, str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_scheduled_job.image",description:`<strong>image</strong> (<code>str</code>) &#x2014;
The Docker image to use.
Examples: <code>&quot;ubuntu&quot;</code>, <code>&quot;python:3.12&quot;</code>, <code>&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</code>.
Example with an image from a Space: <code>&quot;hf.co/spaces/lhoestq/duckdb&quot;</code>.`,name:"image"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.command",description:`<strong>command</strong> (<code>List[str]</code>) &#x2014;
The command to run. Example: <code>[&quot;echo&quot;, &quot;hello&quot;]</code>.`,name:"command"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.schedule",description:`<strong>schedule</strong> (<code>str</code>) &#x2014;
One of &#x201C;@annually&#x201D;, &#x201C;@yearly&#x201D;, &#x201C;@monthly&#x201D;, &#x201C;@weekly&#x201D;, &#x201C;@daily&#x201D;, &#x201C;@hourly&#x201D;, or a
CRON schedule expression (e.g., &#x2018;0 9 * * 1&#x2019; for 9 AM every Monday).`,name:"schedule"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.suspend",description:`<strong>suspend</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If True, the scheduled Job is suspended (paused).  Defaults to False.`,name:"suspend"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.concurrency",description:`<strong>concurrency</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If True, multiple instances of this Job can run concurrently. Defaults to False.`,name:"concurrency"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.env",description:`<strong>env</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the environment variables for the Job.`,name:"env"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.secrets",description:`<strong>secrets</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the secret environment variables for the Job.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.flavor",description:`<strong>flavor</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Flavor for the hardware, as in Hugging Face Spaces. See <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for possible values.
Defaults to <code>&quot;cpu-basic&quot;</code>.`,name:"flavor"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.timeout",description:`<strong>timeout</strong> (<code>Union[int, float, str]</code>, <em>optional</em>) &#x2014;
Max duration for the Job: int/float with s (seconds, default), m (minutes), h (hours) or d (days).
Example: <code>300</code> or <code>&quot;5m&quot;</code> for 5 minutes.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10369"}}),pa=new C({props:{anchor:"huggingface_hub.HfApi.create_scheduled_job.example",$$slots:{default:[MH]},$$scope:{ctx:T}}}),da=new C({props:{anchor:"huggingface_hub.HfApi.create_scheduled_job.example-2",$$slots:{default:[qH]},$$scope:{ctx:T}}}),ga=new C({props:{anchor:"huggingface_hub.HfApi.create_scheduled_job.example-3",$$slots:{default:[HH]},$$scope:{ctx:T}}}),Kr=new q({props:{name:"create_scheduled_uv_job",anchor:"huggingface_hub.HfApi.create_scheduled_uv_job",parameters:[{name:"script",val:": str"},{name:"script_args",val:": Optional[List[str]] = None"},{name:"schedule",val:": str"},{name:"suspend",val:": Optional[bool] = None"},{name:"concurrency",val:": Optional[bool] = None"},{name:"dependencies",val:": Optional[List[str]] = None"},{name:"python",val:": Optional[str] = None"},{name:"image",val:": Optional[str] = None"},{name:"env",val:": Optional[Dict[str, Any]] = None"},{name:"secrets",val:": Optional[Dict[str, Any]] = None"},{name:"flavor",val:": Optional[SpaceHardware] = None"},{name:"timeout",val:": Optional[Union[int, float, str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"_repo",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.script",description:`<strong>script</strong> (<code>str</code>) &#x2014;
Path or URL of the UV script, or a command.`,name:"script"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.script_args",description:`<strong>script_args</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Arguments to pass to the script, or a command.`,name:"script_args"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.schedule",description:`<strong>schedule</strong> (<code>str</code>) &#x2014;
One of &#x201C;@annually&#x201D;, &#x201C;@yearly&#x201D;, &#x201C;@monthly&#x201D;, &#x201C;@weekly&#x201D;, &#x201C;@daily&#x201D;, &#x201C;@hourly&#x201D;, or a
CRON schedule expression (e.g., &#x2018;0 9 * * 1&#x2019; for 9 AM every Monday).`,name:"schedule"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.suspend",description:`<strong>suspend</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If True, the scheduled Job is suspended (paused).  Defaults to False.`,name:"suspend"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.concurrency",description:`<strong>concurrency</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If True, multiple instances of this Job can run concurrently. Defaults to False.`,name:"concurrency"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.dependencies",description:`<strong>dependencies</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Dependencies to use to run the UV script.`,name:"dependencies"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.python",description:`<strong>python</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Use a specific Python version. Default is 3.12.`,name:"python"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.image",description:`<strong>image</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;ghcr.io/astral-sh/uv &#x2014;python3.12-bookworm&#x201D;):
Use a custom Docker image with <code>uv</code> installed.`,name:"image"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.env",description:`<strong>env</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the environment variables for the Job.`,name:"env"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.secrets",description:`<strong>secrets</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the secret environment variables for the Job.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.flavor",description:`<strong>flavor</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Flavor for the hardware, as in Hugging Face Spaces. See <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for possible values.
Defaults to <code>&quot;cpu-basic&quot;</code>.`,name:"flavor"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.timeout",description:`<strong>timeout</strong> (<code>Union[int, float, str]</code>, <em>optional</em>) &#x2014;
Max duration for the Job: int/float with s (seconds, default), m (minutes), h (hours) or d (days).
Example: <code>300</code> or <code>&quot;5m&quot;</code> for 5 minutes.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10641"}}),ua=new C({props:{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.example",$$slots:{default:[UH]},$$scope:{ctx:T}}}),ha=new C({props:{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.example-2",$$slots:{default:[CH]},$$scope:{ctx:T}}}),fa=new C({props:{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.example-3",$$slots:{default:[IH]},$$scope:{ctx:T}}}),ei=new q({props:{name:"create_tag",anchor:"huggingface_hub.HfApi.create_tag",parameters:[{name:"repo_id",val:": str"},{name:"tag",val:": str"},{name:"tag_message",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"exist_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_tag.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which a commit will be tagged.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_tag.tag",description:`<strong>tag</strong> (<code>str</code>) &#x2014;
The name of the tag to create.`,name:"tag"},{anchor:"huggingface_hub.HfApi.create_tag.tag_message",description:`<strong>tag_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the tag to create.`,name:"tag_message"},{anchor:"huggingface_hub.HfApi.create_tag.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to tag. It can be a branch name or the OID/SHA of a
commit, as a hexadecimal string. Shorthands (7 first characters) are
also supported. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_tag.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_tag.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if tagging a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if tagging a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_tag.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if tag already exists.`,name:"exist_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6062",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If the branch already exists on the repo (error 409) and <code>exist_ok</code> is
set to <code>False</code>.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a></p>
`}}),ti=new q({props:{name:"create_webhook",anchor:"huggingface_hub.HfApi.create_webhook",parameters:[{name:"url",val:": str"},{name:"watched",val:": List[Union[Dict, WebhookWatchedItem]]"},{name:"domains",val:": Optional[List[constants.WEBHOOK_DOMAIN_T]] = None"},{name:"secret",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_webhook.url",description:`<strong>url</strong> (<code>str</code>) &#x2014;
URL to send the payload to.`,name:"url"},{anchor:"huggingface_hub.HfApi.create_webhook.watched",description:`<strong>watched</strong> (<code>List[WebhookWatchedItem]</code>) &#x2014;
List of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.WebhookWatchedItem">WebhookWatchedItem</a> to be watched by the webhook. It can be users, orgs, models, datasets or spaces.
Watched items can also be provided as plain dictionaries.`,name:"watched"},{anchor:"huggingface_hub.HfApi.create_webhook.domains",description:`<strong>domains</strong> (<code>List[Literal[&quot;repo&quot;, &quot;discussion&quot;]]</code>, optional) &#x2014;
List of domains to watch. It can be &#x201C;repo&#x201D;, &#x201C;discussion&#x201D; or both.`,name:"domains"},{anchor:"huggingface_hub.HfApi.create_webhook.secret",description:`<strong>secret</strong> (<code>str</code>, optional) &#x2014;
A secret to sign the payload with.`,name:"secret"},{anchor:"huggingface_hub.HfApi.create_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9274",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the newly created webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.WebhookInfo"
>WebhookInfo</a></p>
`}}),_a=new C({props:{anchor:"huggingface_hub.HfApi.create_webhook.example",$$slots:{default:[JH]},$$scope:{ctx:T}}}),ni=new q({props:{name:"dataset_info",anchor:"huggingface_hub.HfApi.dataset_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[List[ExpandDatasetProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.dataset_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.dataset_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the dataset repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.dataset_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.dataset_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.dataset_info.expand",description:`<strong>expand</strong> (<code>List[ExpandDatasetProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>files_metadata</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;citation&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;description&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;paperswithcode_id&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>,<code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.dataset_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2653",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dataset repository information.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.DatasetInfo"
>hf_api.DatasetInfo</a></p>
`}}),ba=new I({props:{$$slots:{default:[NH]},$$scope:{ctx:T}}}),oi=new q({props:{name:"delete_branch",anchor:"huggingface_hub.HfApi.delete_branch",parameters:[{name:"repo_id",val:": str"},{name:"branch",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_branch.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which a branch will be deleted.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_branch.branch",description:`<strong>branch</strong> (<code>str</code>) &#x2014;
The name of the branch to delete.`,name:"branch"},{anchor:"huggingface_hub.HfApi.delete_branch.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_branch.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if creating a branch on a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if tagging a model. Default is <code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6010",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If trying to delete a protected branch. Ex: <code>main</code> cannot be deleted.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If trying to delete a branch that does not exist.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a></p>
`}}),ai=new q({props:{name:"delete_collection",anchor:"huggingface_hub.HfApi.delete_collection",parameters:[{name:"collection_slug",val:": str"},{name:"missing_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_collection.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to delete. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.delete_collection.missing_ok",description:`<strong>missing_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if collection doesn&#x2019;t exists.`,name:"missing_ok"},{anchor:"huggingface_hub.HfApi.delete_collection.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8506"}}),va=new C({props:{anchor:"huggingface_hub.HfApi.delete_collection.example",$$slots:{default:[AH]},$$scope:{ctx:T}}}),xa=new I({props:{warning:!0,$$slots:{default:[EH]},$$scope:{ctx:T}}}),si=new q({props:{name:"delete_collection_item",anchor:"huggingface_hub.HfApi.delete_collection_item",parameters:[{name:"collection_slug",val:": str"},{name:"item_object_id",val:": str"},{name:"missing_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_collection_item.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.delete_collection_item.item_object_id",description:`<strong>item_object_id</strong> (<code>str</code>) &#x2014;
ID of the item in the collection. This is not the id of the item on the Hub (repo_id or paper id).
It must be retrieved from a <a href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.CollectionItem">CollectionItem</a> object. Example: <code>collection.items[0].item_object_id</code>.`,name:"item_object_id"},{anchor:"huggingface_hub.HfApi.delete_collection_item.missing_ok",description:`<strong>missing_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if item doesn&#x2019;t exists.`,name:"missing_ok"},{anchor:"huggingface_hub.HfApi.delete_collection_item.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8682"}}),$a=new C({props:{anchor:"huggingface_hub.HfApi.delete_collection_item.example",$$slots:{default:[DH]},$$scope:{ctx:T}}}),ri=new q({props:{name:"delete_file",anchor:"huggingface_hub.HfApi.delete_file",parameters:[{name:"path_in_repo",val:": str"},{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_file.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example:
<code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.delete_file.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository from which the file will be deleted, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_file.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_file.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the file is in a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if in a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.delete_file.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit. Defaults to
<code>f&quot;Delete {path_in_repo} with huggingface_hub&quot;</code>.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.delete_file.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.delete_file.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.delete_file.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5023"}}),wa=new I({props:{$$slots:{default:[RH]},$$scope:{ctx:T}}}),ii=new q({props:{name:"delete_files",anchor:"huggingface_hub.HfApi.delete_files",parameters:[{name:"repo_id",val:": str"},{name:"delete_patterns",val:": List[str]"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository from which the folder will be deleted, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_files.delete_patterns",description:`<strong>delete_patterns</strong> (<code>List[str]</code>) &#x2014;
List of files or folders to delete. Each string can either be
a file path, a folder path or a Unix shell-style wildcard.
E.g. <code>[&quot;file.txt&quot;, &quot;folder/&quot;, &quot;data/*.parquet&quot;]</code>`,name:"delete_patterns"},{anchor:"huggingface_hub.HfApi.delete_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.
to the stored token.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of the repo to delete files from. Can be <code>&quot;model&quot;</code>,
<code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>. Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_files.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.delete_files.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary (first line) of the generated commit. Defaults to
<code>f&quot;Delete files using huggingface_hub&quot;</code>.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.delete_files.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit.`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.delete_files.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.delete_files.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5113"}}),ci=new q({props:{name:"delete_folder",anchor:"huggingface_hub.HfApi.delete_folder",parameters:[{name:"path_in_repo",val:": str"},{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_folder.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative folder path in the repo, for example: <code>&quot;checkpoints/1fec34a&quot;</code>.`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.delete_folder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository from which the folder will be deleted, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_folder.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.
to the stored token.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_folder.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the folder is in a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if in a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_folder.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.delete_folder.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit. Defaults to
<code>f&quot;Delete folder {path_in_repo} with huggingface_hub&quot;</code>.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.delete_folder.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit.`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.delete_folder.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.delete_folder.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5189"}}),li=new q({props:{name:"delete_inference_endpoint",anchor:"huggingface_hub.HfApi.delete_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to delete.`,name:"name"},{anchor:"huggingface_hub.HfApi.delete_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.delete_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8114"}}),pi=new q({props:{name:"delete_repo",anchor:"huggingface_hub.HfApi.delete_repo",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"missing_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_repo.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_repo.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_repo.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_repo.missing_ok",description:`<strong>missing_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if repo does not exist.`,name:"missing_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3786",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to delete from cannot be found and <code>missing_ok</code> is set to False (default).</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),di=new q({props:{name:"delete_scheduled_job",anchor:"huggingface_hub.HfApi.delete_scheduled_job",parameters:[{name:"scheduled_job_id",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_scheduled_job.scheduled_job_id",description:`<strong>scheduled_job_id</strong> (<code>str</code>) &#x2014;
ID of the scheduled Job.`,name:"scheduled_job_id"},{anchor:"huggingface_hub.HfApi.delete_scheduled_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the scheduled Job is. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.delete_scheduled_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10553"}}),gi=new q({props:{name:"delete_space_secret",anchor:"huggingface_hub.HfApi.delete_space_secret",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_space_secret.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_space_secret.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Secret key. Example: <code>&quot;GITHUB_API_KEY&quot;</code>.`,name:"key"},{anchor:"huggingface_hub.HfApi.delete_space_secret.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7036"}}),ui=new q({props:{name:"delete_space_storage",anchor:"huggingface_hub.HfApi.delete_space_storage",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_space_storage.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to update. Example: <code>&quot;open-llm-leaderboard/open_llm_leaderboard&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_space_storage.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7520",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>BadRequestError</code> —
If space has no persistent storage.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>BadRequestError</code></p>
`}}),hi=new q({props:{name:"delete_space_variable",anchor:"huggingface_hub.HfApi.delete_space_variable",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_space_variable.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_space_variable.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Variable key. Example: <code>&quot;MODEL_REPO_ID&quot;</code>`,name:"key"},{anchor:"huggingface_hub.HfApi.delete_space_variable.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7125"}}),fi=new q({props:{name:"delete_tag",anchor:"huggingface_hub.HfApi.delete_tag",parameters:[{name:"repo_id",val:": str"},{name:"tag",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_tag.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which a tag will be deleted.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_tag.tag",description:`<strong>tag</strong> (<code>str</code>) &#x2014;
The name of the tag to delete.`,name:"tag"},{anchor:"huggingface_hub.HfApi.delete_tag.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_tag.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if tagging a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if tagging a model. Default is <code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6136",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If tag is not found.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a></p>
`}}),mi=new q({props:{name:"delete_webhook",anchor:"huggingface_hub.HfApi.delete_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to delete.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.delete_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9528",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>None</code></p>
`}}),qa=new C({props:{anchor:"huggingface_hub.HfApi.delete_webhook.example",$$slots:{default:[GH]},$$scope:{ctx:T}}}),_i=new q({props:{name:"disable_webhook",anchor:"huggingface_hub.HfApi.disable_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.disable_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to disable.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.disable_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9477",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the disabled webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.WebhookInfo"
>WebhookInfo</a></p>
`}}),Ha=new C({props:{anchor:"huggingface_hub.HfApi.disable_webhook.example",$$slots:{default:[ZH]},$$scope:{ctx:T}}}),bi=new q({props:{name:"duplicate_space",anchor:"huggingface_hub.HfApi.duplicate_space",parameters:[{name:"from_id",val:": str"},{name:"to_id",val:": Optional[str] = None"},{name:"private",val:": Optional[bool] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"exist_ok",val:": bool = False"},{name:"hardware",val:": Optional[SpaceHardware] = None"},{name:"storage",val:": Optional[SpaceStorage] = None"},{name:"sleep_time",val:": Optional[int] = None"},{name:"secrets",val:": Optional[List[Dict[str, str]]] = None"},{name:"variables",val:": Optional[List[Dict[str, str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.duplicate_space.from_id",description:`<strong>from_id</strong> (<code>str</code>) &#x2014;
ID of the Space to duplicate. Example: <code>&quot;pharma/CLIP-Interrogator&quot;</code>.`,name:"from_id"},{anchor:"huggingface_hub.HfApi.duplicate_space.to_id",description:`<strong>to_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
ID of the new Space. Example: <code>&quot;dog/CLIP-Interrogator&quot;</code>. If not provided, the new Space will have the same
name as the original Space, but in your account.`,name:"to_id"},{anchor:"huggingface_hub.HfApi.duplicate_space.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the new Space should be private or not. Defaults to the same privacy as the original Space.`,name:"private"},{anchor:"huggingface_hub.HfApi.duplicate_space.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.duplicate_space.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if repo already exists.`,name:"exist_ok"},{anchor:"huggingface_hub.HfApi.duplicate_space.hardware",description:`<strong>hardware</strong> (<code>SpaceHardware</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of Hardware. Example: <code>&quot;t4-medium&quot;</code>. See <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for a complete list.`,name:"hardware"},{anchor:"huggingface_hub.HfApi.duplicate_space.storage",description:`<strong>storage</strong> (<code>SpaceStorage</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of persistent storage tier. Example: <code>&quot;small&quot;</code>. See <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceStorage">SpaceStorage</a> for a complete list.`,name:"storage"},{anchor:"huggingface_hub.HfApi.duplicate_space.sleep_time",description:`<strong>sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to sleep (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"sleep_time"},{anchor:"huggingface_hub.HfApi.duplicate_space.secrets",description:`<strong>secrets</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of secret keys to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.duplicate_space.variables",description:`<strong>variables</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of public environment variables to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>.`,name:"variables"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7363",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>URL to the newly created repo. Value is a subclass of <code>str</code> containing
attributes like <code>endpoint</code>, <code>repo_type</code> and <code>repo_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.RepoUrl"
>RepoUrl</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If one of <code>from_id</code> or <code>to_id</code> cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
If the HuggingFace API returned an error</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <code>HTTPError</code></p>
`}}),Ua=new C({props:{anchor:"huggingface_hub.HfApi.duplicate_space.example",$$slots:{default:[FH]},$$scope:{ctx:T}}}),yi=new q({props:{name:"edit_discussion_comment",anchor:"huggingface_hub.HfApi.edit_discussion_comment",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"comment_id",val:": str"},{name:"new_content",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.edit_discussion_comment.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.comment_id",description:`<strong>comment_id</strong> (<code>str</code>) &#x2014;
The ID of the comment to edit.`,name:"comment_id"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.new_content",description:`<strong>new_content</strong> (<code>str</code>) &#x2014;
The new content of the comment. Comments support markdown formatting.`,name:"new_content"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6872",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the edited comment</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionComment"
>DiscussionComment</a></p>
`}}),Ca=new I({props:{$$slots:{default:[SH]},$$scope:{ctx:T}}}),vi=new q({props:{name:"enable_webhook",anchor:"huggingface_hub.HfApi.enable_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.enable_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to enable.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.enable_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9426",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the enabled webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.WebhookInfo"
>WebhookInfo</a></p>
`}}),Ia=new C({props:{anchor:"huggingface_hub.HfApi.enable_webhook.example",$$slots:{default:[LH]},$$scope:{ctx:T}}}),xi=new q({props:{name:"fetch_job_logs",anchor:"huggingface_hub.HfApi.fetch_job_logs",parameters:[{name:"job_id",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.fetch_job_logs.job_id",description:`<strong>job_id</strong> (<code>str</code>) &#x2014;
ID of the Job.`,name:"job_id"},{anchor:"huggingface_hub.HfApi.fetch_job_logs.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job is running. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.fetch_job_logs.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10050"}}),Ja=new C({props:{anchor:"huggingface_hub.HfApi.fetch_job_logs.example",$$slots:{default:[WH]},$$scope:{ctx:T}}}),$i=new q({props:{name:"file_exists",anchor:"huggingface_hub.HfApi.file_exists",parameters:[{name:"repo_id",val:": str"},{name:"filename",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.file_exists.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.file_exists.filename",description:`<strong>filename</strong> (<code>str</code>) &#x2014;
The name of the file to check, for example:
<code>&quot;config.json&quot;</code>`,name:"filename"},{anchor:"huggingface_hub.HfApi.file_exists.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.file_exists.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the information. Defaults to <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.file_exists.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2964",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if the file exists, False otherwise.</p>
`}}),Na=new C({props:{anchor:"huggingface_hub.HfApi.file_exists.example",$$slots:{default:[VH]},$$scope:{ctx:T}}}),wi=new q({props:{name:"get_collection",anchor:"huggingface_hub.HfApi.get_collection",parameters:[{name:"collection_slug",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_collection.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection of the Hub. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.get_collection.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8331"}}),Aa=new C({props:{anchor:"huggingface_hub.HfApi.get_collection.example",$$slots:{default:[BH]},$$scope:{ctx:T}}}),ki=new q({props:{name:"get_dataset_tags",anchor:"huggingface_hub.HfApi.get_dataset_tags",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1849"}}),Ti=new q({props:{name:"get_discussion_details",anchor:"huggingface_hub.HfApi.get_discussion_details",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_discussion_details.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_discussion_details.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.get_discussion_details.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_discussion_details.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6331"}}),Da=new I({props:{$$slots:{default:[PH]},$$scope:{ctx:T}}}),ji=new q({props:{name:"get_full_repo_name",anchor:"huggingface_hub.HfApi.get_full_repo_name",parameters:[{name:"model_id",val:": str"},{name:"organization",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_full_repo_name.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
The name of the model.`,name:"model_id"},{anchor:"huggingface_hub.HfApi.get_full_repo_name.organization",description:`<strong>organization</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If passed, the repository name will be in the organization
namespace instead of the user namespace.`,name:"organization"},{anchor:"huggingface_hub.HfApi.get_full_repo_name.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6185",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The repository name in the user’s namespace
({username}/{model_id}) if no organization is passed, and under the
organization namespace ({organization}/{model_id}) otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Mi=new q({props:{name:"get_hf_file_metadata",anchor:"huggingface_hub.HfApi.get_hf_file_metadata",parameters:[{name:"url",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"proxies",val:": Optional[Dict] = None"},{name:"timeout",val:": Optional[float] = 10"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.url",description:`<strong>url</strong> (<code>str</code>) &#x2014;
File url, for example returned by <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_url">hf_hub_url()</a>.`,name:"url"},{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.proxies",description:`<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary mapping protocol to the URL of the proxy passed to <code>requests.request</code>.`,name:"proxies"},{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>, defaults to 10) &#x2014;
How many seconds to wait for the server to send metadata before giving up.`,name:"timeout"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5380",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.HfFileMetadata"
>HfFileMetadata</a> object containing metadata such as location, etag, size and commit_hash.</p>
`}}),qi=new q({props:{name:"get_inference_endpoint",anchor:"huggingface_hub.HfApi.get_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to retrieve information about.`,name:"name"},{anchor:"huggingface_hub.HfApi.get_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.get_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7930",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the requested Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Za=new C({props:{anchor:"huggingface_hub.HfApi.get_inference_endpoint.example",$$slots:{default:[YH]},$$scope:{ctx:T}}}),Hi=new q({props:{name:"get_model_tags",anchor:"huggingface_hub.HfApi.get_model_tags",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1840"}}),Ui=new q({props:{name:"get_paths_info",anchor:"huggingface_hub.HfApi.get_paths_info",parameters:[{name:"repo_id",val:": str"},{name:"paths",val:": Union[List[str], str]"},{name:"expand",val:": bool = False"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_paths_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_paths_info.paths",description:`<strong>paths</strong> (<code>Union[List[str], str]</code>, <em>optional</em>) &#x2014;
The paths to get information about. If a path do not exist, it is ignored without raising
an exception.`,name:"paths"},{anchor:"huggingface_hub.HfApi.get_paths_info.expand",description:`<strong>expand</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fetch more information about the paths (e.g. last commit and files&#x2019; security scan results). This
operation is more expensive for the server so only 50 results are returned per page (instead of 1000).
As pagination is implemented in <code>huggingface_hub</code>, this is transparent for you except for the time it
takes to get the results.`,name:"expand"},{anchor:"huggingface_hub.HfApi.get_paths_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the information. Defaults to <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.get_paths_info.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository from which to get the information (<code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>.
Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_paths_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3349",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The information about the paths, as a list of <code>RepoFile</code> and <code>RepoFolder</code> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Union[RepoFile, RepoFolder]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a></p>
`}}),Sa=new C({props:{anchor:"huggingface_hub.HfApi.get_paths_info.example",$$slots:{default:[XH]},$$scope:{ctx:T}}}),Ci=new q({props:{name:"get_repo_discussions",anchor:"huggingface_hub.HfApi.get_repo_discussions",parameters:[{name:"repo_id",val:": str"},{name:"author",val:": Optional[str] = None"},{name:"discussion_type",val:": Optional[constants.DiscussionTypeFilter] = None"},{name:"discussion_status",val:": Optional[constants.DiscussionStatusFilter] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_repo_discussions.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass a value to filter by discussion author. <code>None</code> means no filter.
Default is <code>None</code>.`,name:"author"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.discussion_type",description:`<strong>discussion_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;pull_request&quot;</code> to fetch only pull requests, <code>&quot;discussion&quot;</code>
to fetch only discussions. Set to <code>&quot;all&quot;</code> or <code>None</code> to fetch both.
Default is <code>None</code>.`,name:"discussion_type"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.discussion_status",description:`<strong>discussion_status</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;open&quot;</code> (respectively <code>&quot;closed&quot;</code>) to fetch only open
(respectively closed) discussions. Set to <code>&quot;all&quot;</code> or <code>None</code>
to fetch both.
Default is <code>None</code>.`,name:"discussion_status"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if fetching from a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if fetching from a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6223",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An iterator of <a
  href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.Discussion"
>Discussion</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterator[Discussion]</code></p>
`}}),La=new C({props:{anchor:"huggingface_hub.HfApi.get_repo_discussions.example",$$slots:{default:[zH]},$$scope:{ctx:T}}}),Wa=new C({props:{anchor:"huggingface_hub.HfApi.get_repo_discussions.example-2",$$slots:{default:[QH]},$$scope:{ctx:T}}}),Ii=new q({props:{name:"get_safetensors_metadata",anchor:"huggingface_hub.HfApi.get_safetensors_metadata",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the file is in a dataset or space, <code>None</code> or <code>&quot;model&quot;</code> if in a
model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to fetch the file from. Can be a branch name, a tag, or a commit hash. Defaults to the
head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5687",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information related to safetensors repo.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>SafetensorsRepoMetadata</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>NotASafetensorsRepoError</code> —
If the repo is not a safetensors repo i.e. doesn’t have either a
<code>model.safetensors</code> or a <code>model.safetensors.index.json</code> file.</li>
<li><code>SafetensorsParsingError</code> —
If a safetensors file header couldn’t be parsed correctly.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>NotASafetensorsRepoError</code> or <code>SafetensorsParsingError</code></p>
`}}),Va=new C({props:{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.example",$$slots:{default:[OH]},$$scope:{ctx:T}}}),Ji=new q({props:{name:"get_space_runtime",anchor:"huggingface_hub.HfApi.get_space_runtime",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_space_runtime.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_space_runtime.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7153",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),Ni=new q({props:{name:"get_space_variables",anchor:"huggingface_hub.HfApi.get_space_variables",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_space_variables.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to query. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_space_variables.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7061"}}),Ai=new q({props:{name:"get_token_permission",anchor:"huggingface_hub.HfApi.get_token_permission",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_token_permission.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1800",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Permission granted by the token (“read” or “write”). Returns <code>None</code> if no
token passed, if token is invalid or if role is not returned by the server. This typically happens when the token is an OAuth token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Literal["read", "write", "fineGrained", None]</code></p>
`}}),Pa=new I({props:{warning:!0,$$slots:{default:[KH]},$$scope:{ctx:T}}}),Ei=new q({props:{name:"get_user_overview",anchor:"huggingface_hub.HfApi.get_user_overview",parameters:[{name:"username",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_user_overview.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user to get an overview of.`,name:"username"},{anchor:"huggingface_hub.HfApi.get_user_overview.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9727",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.User"
>User</a> object with the user’s overview.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>User</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Di=new q({props:{name:"get_webhook",anchor:"huggingface_hub.HfApi.get_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to get.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.get_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9173",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.WebhookInfo"
>WebhookInfo</a></p>
`}}),Xa=new C({props:{anchor:"huggingface_hub.HfApi.get_webhook.example",$$slots:{default:[eU]},$$scope:{ctx:T}}}),Ri=new q({props:{name:"grant_access",anchor:"huggingface_hub.HfApi.grant_access",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.grant_access.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to grant access to.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.grant_access.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user to grant access.`,name:"user"},{anchor:"huggingface_hub.HfApi.grant_access.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to grant access to. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.grant_access.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9118",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the user already has access to the repo.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Gi=new q({props:{name:"hf_hub_download",anchor:"huggingface_hub.HfApi.hf_hub_download",parameters:[{name:"repo_id",val:": str"},{name:"filename",val:": str"},{name:"subfolder",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"cache_dir",val:": Union[str, Path, None] = None"},{name:"local_dir",val:": Union[str, Path, None] = None"},{name:"force_download",val:": bool = False"},{name:"proxies",val:": Optional[Dict] = None"},{name:"etag_timeout",val:": float = 10"},{name:"token",val:": Union[bool, str, None] = None"},{name:"local_files_only",val:": bool = False"},{name:"resume_download",val:": Optional[bool] = None"},{name:"force_filename",val:": Optional[str] = None"},{name:"local_dir_use_symlinks",val:": Union[bool, Literal['auto']] = 'auto'"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.hf_hub_download.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.hf_hub_download.filename",description:`<strong>filename</strong> (<code>str</code>) &#x2014;
The name of the file in the repo.`,name:"filename"},{anchor:"huggingface_hub.HfApi.hf_hub_download.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional value corresponding to a folder inside the repository.`,name:"subfolder"},{anchor:"huggingface_hub.HfApi.hf_hub_download.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if downloading from a dataset or space,
<code>None</code> or <code>&quot;model&quot;</code> if downloading from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.hf_hub_download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional Git revision id which can be a branch name, a tag, or a
commit hash.`,name:"revision"},{anchor:"huggingface_hub.HfApi.hf_hub_download.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.HfApi.hf_hub_download.local_dir",description:`<strong>local_dir</strong> (<code>str</code> or <code>Path</code>, <em>optional</em>) &#x2014;
If provided, the downloaded file will be placed under this directory.`,name:"local_dir"},{anchor:"huggingface_hub.HfApi.hf_hub_download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the file should be downloaded even if it already exists in
the local cache.`,name:"force_download"},{anchor:"huggingface_hub.HfApi.hf_hub_download.proxies",description:`<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary mapping protocol to the URL of the proxy passed to
<code>requests.request</code>.`,name:"proxies"},{anchor:"huggingface_hub.HfApi.hf_hub_download.etag_timeout",description:`<strong>etag_timeout</strong> (<code>float</code>, <em>optional</em>, defaults to <code>10</code>) &#x2014;
When fetching ETag, how many seconds to wait for the server to send
data before giving up which is passed to <code>requests.request</code>.`,name:"etag_timeout"},{anchor:"huggingface_hub.HfApi.hf_hub_download.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.hf_hub_download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the
local cached file if it exists.`,name:"local_files_only"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5422",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Local path of file or if networking is off, last version of file cached on disk.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If the revision to download from cannot be found.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a> —
If the file to download cannot be found.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.LocalEntryNotFoundError"
>LocalEntryNotFoundError</a> —
If network is disabled or unavailable and file is not found in cache.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a> —
If <code>token=True</code> but the token cannot be found.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#OSError"
  rel="nofollow"
><code>OSError</code></a> —
If ETag cannot be determined.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If some parameter value is invalid.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.LocalEntryNotFoundError"
>LocalEntryNotFoundError</a> or <code>EnvironmentError</code> or <code>OSError</code> or <code>ValueError</code></p>
`}}),za=new C({props:{anchor:"huggingface_hub.HfApi.hf_hub_download.example",$$slots:{default:[tU]},$$scope:{ctx:T}}}),Zi=new q({props:{name:"hide_discussion_comment",anchor:"huggingface_hub.HfApi.hide_discussion_comment",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"comment_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.hide_discussion_comment.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.comment_id",description:`<strong>comment_id</strong> (<code>str</code>) &#x2014;
The ID of the comment to edit.`,name:"comment_id"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6932",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the hidden comment</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionComment"
>DiscussionComment</a></p>
`}}),Qa=new I({props:{warning:!0,$$slots:{default:[nU]},$$scope:{ctx:T}}}),Oa=new I({props:{$$slots:{default:[oU]},$$scope:{ctx:T}}}),Fi=new q({props:{name:"inspect_job",anchor:"huggingface_hub.HfApi.inspect_job",parameters:[{name:"job_id",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.inspect_job.job_id",description:`<strong>job_id</strong> (<code>str</code>) &#x2014;
ID of the Job.`,name:"job_id"},{anchor:"huggingface_hub.HfApi.inspect_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job is running. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.inspect_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10174"}}),Ka=new C({props:{anchor:"huggingface_hub.HfApi.inspect_job.example",$$slots:{default:[aU]},$$scope:{ctx:T}}}),Si=new q({props:{name:"inspect_scheduled_job",anchor:"huggingface_hub.HfApi.inspect_scheduled_job",parameters:[{name:"scheduled_job_id",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.inspect_scheduled_job.scheduled_job_id",description:`<strong>scheduled_job_id</strong> (<code>str</code>) &#x2014;
ID of the scheduled Job.`,name:"scheduled_job_id"},{anchor:"huggingface_hub.HfApi.inspect_scheduled_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the scheduled Job is. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.inspect_scheduled_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10514"}}),es=new C({props:{anchor:"huggingface_hub.HfApi.inspect_scheduled_job.example",$$slots:{default:[sU]},$$scope:{ctx:T}}}),Li=new q({props:{name:"list_accepted_access_requests",anchor:"huggingface_hub.HfApi.list_accepted_access_requests",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to get access requests for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to get access requests for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8802",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <code>AccessRequest</code> objects. Each time contains a <code>username</code>, <code>email</code>,
<code>status</code> and <code>timestamp</code> attribute. If the gated repo has a custom form, the <code>fields</code> attribute will
be populated with user’s answers.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AccessRequest]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),ts=new C({props:{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.example",$$slots:{default:[rU]},$$scope:{ctx:T}}}),Wi=new q({props:{name:"list_collections",anchor:"huggingface_hub.HfApi.list_collections",parameters:[{name:"owner",val:": Union[List[str], str, None] = None"},{name:"item",val:": Union[List[str], str, None] = None"},{name:"sort",val:": Optional[Literal['lastModified', 'trending', 'upvotes']] = None"},{name:"limit",val:": Optional[int] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_collections.owner",description:`<strong>owner</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
Filter by owner&#x2019;s username.`,name:"owner"},{anchor:"huggingface_hub.HfApi.list_collections.item",description:`<strong>item</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
Filter collections containing a particular items. Example: <code>&quot;models/teknium/OpenHermes-2.5-Mistral-7B&quot;</code>, <code>&quot;datasets/squad&quot;</code> or <code>&quot;papers/2311.12983&quot;</code>.`,name:"item"},{anchor:"huggingface_hub.HfApi.list_collections.sort",description:`<strong>sort</strong> (<code>Literal[&quot;lastModified&quot;, &quot;trending&quot;, &quot;upvotes&quot;]</code>, <em>optional</em>) &#x2014;
Sort collections by last modified, trending or upvotes.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_collections.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of collections to be returned.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_collections.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8272",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.Collection"
>Collection</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[Collection]</code></p>
`}}),ns=new I({props:{warning:!0,$$slots:{default:[iU]},$$scope:{ctx:T}}}),Vi=new q({props:{name:"list_datasets",anchor:"huggingface_hub.HfApi.list_datasets",parameters:[{name:"filter",val:": Union[str, Iterable[str], None] = None"},{name:"author",val:": Optional[str] = None"},{name:"benchmark",val:": Optional[Union[str, List[str]]] = None"},{name:"dataset_name",val:": Optional[str] = None"},{name:"gated",val:": Optional[bool] = None"},{name:"language_creators",val:": Optional[Union[str, List[str]]] = None"},{name:"language",val:": Optional[Union[str, List[str]]] = None"},{name:"multilinguality",val:": Optional[Union[str, List[str]]] = None"},{name:"size_categories",val:": Optional[Union[str, List[str]]] = None"},{name:"task_categories",val:": Optional[Union[str, List[str]]] = None"},{name:"task_ids",val:": Optional[Union[str, List[str]]] = None"},{name:"search",val:": Optional[str] = None"},{name:"sort",val:": Optional[Union[Literal['last_modified'], str]] = None"},{name:"direction",val:": Optional[Literal[-1]] = None"},{name:"limit",val:": Optional[int] = None"},{name:"expand",val:": Optional[List[ExpandDatasetProperty_T]] = None"},{name:"full",val:": Optional[bool] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"tags",val:": Optional[Union[str, List[str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_datasets.filter",description:`<strong>filter</strong> (<code>str</code> or <code>Iterable[str]</code>, <em>optional</em>) &#x2014;
A string or list of string to filter datasets on the hub.`,name:"filter"},{anchor:"huggingface_hub.HfApi.list_datasets.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string which identify the author of the returned datasets.`,name:"author"},{anchor:"huggingface_hub.HfApi.list_datasets.benchmark",description:`<strong>benchmark</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by their official benchmark.`,name:"benchmark"},{anchor:"huggingface_hub.HfApi.list_datasets.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by its name, such as <code>SQAC</code> or <code>wikineural</code>`,name:"dataset_name"},{anchor:"huggingface_hub.HfApi.list_datasets.gated",description:`<strong>gated</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
A boolean to filter datasets on the Hub that are gated or not. By default, all datasets are returned.
If <code>gated=True</code> is passed, only gated datasets are returned.
If <code>gated=False</code> is passed, only non-gated datasets are returned.`,name:"gated"},{anchor:"huggingface_hub.HfApi.list_datasets.language_creators",description:`<strong>language_creators</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub with how the data was curated, such as <code>crowdsourced</code> or
<code>machine_generated</code>.`,name:"language_creators"},{anchor:"huggingface_hub.HfApi.list_datasets.language",description:`<strong>language</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings representing a two-character language to
filter datasets by on the Hub.`,name:"language"},{anchor:"huggingface_hub.HfApi.list_datasets.multilinguality",description:`<strong>multilinguality</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings representing a filter for datasets that
contain multiple languages.`,name:"multilinguality"},{anchor:"huggingface_hub.HfApi.list_datasets.size_categories",description:`<strong>size_categories</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by the size of the dataset such as <code>100K&lt;n&lt;1M</code> or
<code>1M&lt;n&lt;10M</code>.`,name:"size_categories"},{anchor:"huggingface_hub.HfApi.list_datasets.tags",description:`<strong>tags</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
Deprecated. Pass tags in <code>filter</code> to filter datasets by tags.`,name:"tags"},{anchor:"huggingface_hub.HfApi.list_datasets.task_categories",description:`<strong>task_categories</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by the designed task, such as <code>audio_classification</code> or
<code>named_entity_recognition</code>.`,name:"task_categories"},{anchor:"huggingface_hub.HfApi.list_datasets.task_ids",description:`<strong>task_ids</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by the specific task such as <code>speech_emotion_recognition</code> or
<code>paraphrase</code>.`,name:"task_ids"},{anchor:"huggingface_hub.HfApi.list_datasets.search",description:`<strong>search</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that will be contained in the returned datasets.`,name:"search"},{anchor:"huggingface_hub.HfApi.list_datasets.sort",description:`<strong>sort</strong> (<code>Literal[&quot;last_modified&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The key with which to sort the resulting models. Possible values are &#x201C;last_modified&#x201D;, &#x201C;trending_score&#x201D;,
&#x201C;created_at&#x201D;, &#x201C;downloads&#x201D; and &#x201C;likes&#x201D;.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_datasets.direction",description:`<strong>direction</strong> (<code>Literal[-1]</code> or <code>int</code>, <em>optional</em>) &#x2014;
Direction in which to sort. The value <code>-1</code> sorts by descending
order while all other values sort by ascending order.`,name:"direction"},{anchor:"huggingface_hub.HfApi.list_datasets.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The limit on the number of datasets fetched. Leaving this option
to <code>None</code> fetches all datasets.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_datasets.expand",description:`<strong>expand</strong> (<code>List[ExpandDatasetProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;citation&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;description&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;paperswithcode_id&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_datasets.full",description:`<strong>full</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch all dataset data, including the <code>last_modified</code>,
the <code>card_data</code> and  the files. Can contain useful information such as the
PapersWithCode ID.`,name:"full"},{anchor:"huggingface_hub.HfApi.list_datasets.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2086",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.DatasetInfo"
>huggingface_hub.hf_api.DatasetInfo</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[DatasetInfo]</code></p>
`}}),os=new C({props:{anchor:"huggingface_hub.HfApi.list_datasets.example",$$slots:{default:[cU]},$$scope:{ctx:T}}}),as=new C({props:{anchor:"huggingface_hub.HfApi.list_datasets.example-2",$$slots:{default:[lU]},$$scope:{ctx:T}}}),Bi=new q({props:{name:"list_inference_catalog",anchor:"huggingface_hub.HfApi.list_inference_catalog",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_inference_catalog.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7897",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of model IDs available in the catalog.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List<code>str</code></p>
`}}),ss=new I({props:{warning:!0,$$slots:{default:[pU]},$$scope:{ctx:T}}}),Pi=new q({props:{name:"list_inference_endpoints",anchor:"huggingface_hub.HfApi.list_inference_endpoints",parameters:[{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_inference_endpoints.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace to list endpoints for. Defaults to the current user. Set to <code>&quot;*&quot;</code> to list all endpoints
from all namespaces (i.e. personal namespace and all orgs the user belongs to).`,name:"namespace"},{anchor:"huggingface_hub.HfApi.list_inference_endpoints.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7555",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of all inference endpoints for the given namespace.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List<a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),rs=new C({props:{anchor:"huggingface_hub.HfApi.list_inference_endpoints.example",$$slots:{default:[dU]},$$scope:{ctx:T}}}),Yi=new q({props:{name:"list_jobs",anchor:"huggingface_hub.HfApi.list_jobs",parameters:[{name:"timeout",val:": Optional[int] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_jobs.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.list_jobs.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace from where it lists the jobs. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.list_jobs.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10142"}}),Xi=new q({props:{name:"list_lfs_files",anchor:"huggingface_hub.HfApi.list_lfs_files",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_lfs_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository for which you are listing LFS files.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_lfs_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of repository. Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing from a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_lfs_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3512",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An iterator of <code>LFSFileInfo</code> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[LFSFileInfo]</code></p>
`}}),cs=new C({props:{anchor:"huggingface_hub.HfApi.list_lfs_files.example",$$slots:{default:[gU]},$$scope:{ctx:T}}}),zi=new q({props:{name:"list_liked_repos",anchor:"huggingface_hub.HfApi.list_liked_repos",parameters:[{name:"user",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_liked_repos.user",description:`<strong>user</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the user for which you want to fetch the likes.`,name:"user"},{anchor:"huggingface_hub.HfApi.list_liked_repos.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2460",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>object containing the user name and 3 lists of repo ids (1 for
models, 1 for datasets and 1 for Spaces).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.UserLikes"
>UserLikes</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>user</code> is not passed and no token found (either from argument or from machine).</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),ls=new C({props:{anchor:"huggingface_hub.HfApi.list_liked_repos.example",$$slots:{default:[uU]},$$scope:{ctx:T}}}),Qi=new q({props:{name:"list_models",anchor:"huggingface_hub.HfApi.list_models",parameters:[{name:"filter",val:": Union[str, Iterable[str], None] = None"},{name:"author",val:": Optional[str] = None"},{name:"apps",val:": Optional[Union[str, List[str]]] = None"},{name:"gated",val:": Optional[bool] = None"},{name:"inference",val:": Optional[Literal['warm']] = None"},{name:"inference_provider",val:": Optional[Union[Literal['all'], 'PROVIDER_T', List['PROVIDER_T']]] = None"},{name:"model_name",val:": Optional[str] = None"},{name:"trained_dataset",val:": Optional[Union[str, List[str]]] = None"},{name:"search",val:": Optional[str] = None"},{name:"pipeline_tag",val:": Optional[str] = None"},{name:"emissions_thresholds",val:": Optional[Tuple[float, float]] = None"},{name:"sort",val:": Union[Literal['last_modified'], str, None] = None"},{name:"direction",val:": Optional[Literal[-1]] = None"},{name:"limit",val:": Optional[int] = None"},{name:"expand",val:": Optional[List[ExpandModelProperty_T]] = None"},{name:"full",val:": Optional[bool] = None"},{name:"cardData",val:": bool = False"},{name:"fetch_config",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"},{name:"language",val:": Optional[Union[str, List[str]]] = None"},{name:"library",val:": Optional[Union[str, List[str]]] = None"},{name:"tags",val:": Optional[Union[str, List[str]]] = None"},{name:"task",val:": Optional[Union[str, List[str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_models.filter",description:`<strong>filter</strong> (<code>str</code> or <code>Iterable[str]</code>, <em>optional</em>) &#x2014;
A string or list of string to filter models on the Hub.
Models can be filtered by library, language, task, tags, and more.`,name:"filter"},{anchor:"huggingface_hub.HfApi.list_models.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string which identify the author (user or organization) of the
returned models.`,name:"author"},{anchor:"huggingface_hub.HfApi.list_models.apps",description:`<strong>apps</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings to filter models on the Hub that
support the specified apps. Example values include <code>&quot;ollama&quot;</code> or <code>[&quot;ollama&quot;, &quot;vllm&quot;]</code>.`,name:"apps"},{anchor:"huggingface_hub.HfApi.list_models.gated",description:`<strong>gated</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
A boolean to filter models on the Hub that are gated or not. By default, all models are returned.
If <code>gated=True</code> is passed, only gated models are returned.
If <code>gated=False</code> is passed, only non-gated models are returned.`,name:"gated"},{anchor:"huggingface_hub.HfApi.list_models.inference",description:`<strong>inference</strong> (<code>Literal[&quot;warm&quot;]</code>, <em>optional</em>) &#x2014;
If &#x201C;warm&#x201D;, filter models on the Hub currently served by at least one provider.`,name:"inference"},{anchor:"huggingface_hub.HfApi.list_models.inference_provider",description:`<strong>inference_provider</strong> (<code>Literal[&quot;all&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
A string to filter models on the Hub that are served by a specific provider.
Pass <code>&quot;all&quot;</code> to get all models served by at least one provider.`,name:"inference_provider"},{anchor:"huggingface_hub.HfApi.list_models.library",description:`<strong>library</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
Deprecated. Pass a library name in <code>filter</code> to filter models by library.`,name:"library"},{anchor:"huggingface_hub.HfApi.list_models.language",description:`<strong>language</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
Deprecated. Pass a language in <code>filter</code> to filter models by language.`,name:"language"},{anchor:"huggingface_hub.HfApi.list_models.model_name",description:`<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that contain complete or partial names for models on the
Hub, such as &#x201C;bert&#x201D; or &#x201C;bert-base-cased&#x201D;`,name:"model_name"},{anchor:"huggingface_hub.HfApi.list_models.task",description:`<strong>task</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
Deprecated. Pass a task in <code>filter</code> to filter models by task.`,name:"task"},{anchor:"huggingface_hub.HfApi.list_models.trained_dataset",description:`<strong>trained_dataset</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string tag or a list of string tags of the trained dataset for a
model on the Hub.`,name:"trained_dataset"},{anchor:"huggingface_hub.HfApi.list_models.tags",description:`<strong>tags</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
Deprecated. Pass tags in <code>filter</code> to filter models by tags.`,name:"tags"},{anchor:"huggingface_hub.HfApi.list_models.search",description:`<strong>search</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that will be contained in the returned model ids.`,name:"search"},{anchor:"huggingface_hub.HfApi.list_models.pipeline_tag",description:`<strong>pipeline_tag</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string pipeline tag to filter models on the Hub by, such as <code>summarization</code>.`,name:"pipeline_tag"},{anchor:"huggingface_hub.HfApi.list_models.emissions_thresholds",description:`<strong>emissions_thresholds</strong> (<code>Tuple</code>, <em>optional</em>) &#x2014;
A tuple of two ints or floats representing a minimum and maximum
carbon footprint to filter the resulting models with in grams.`,name:"emissions_thresholds"},{anchor:"huggingface_hub.HfApi.list_models.sort",description:`<strong>sort</strong> (<code>Literal[&quot;last_modified&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The key with which to sort the resulting models. Possible values are &#x201C;last_modified&#x201D;, &#x201C;trending_score&#x201D;,
&#x201C;created_at&#x201D;, &#x201C;downloads&#x201D; and &#x201C;likes&#x201D;.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_models.direction",description:`<strong>direction</strong> (<code>Literal[-1]</code> or <code>int</code>, <em>optional</em>) &#x2014;
Direction in which to sort. The value <code>-1</code> sorts by descending
order while all other values sort by ascending order.`,name:"direction"},{anchor:"huggingface_hub.HfApi.list_models.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The limit on the number of models fetched. Leaving this option
to <code>None</code> fetches all models.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_models.expand",description:`<strong>expand</strong> (<code>List[ExpandModelProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code>, <code>cardData</code> or <code>fetch_config</code> are passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;config&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;gguf&quot;</code>, <code>&quot;inference&quot;</code>, <code>&quot;inferenceProviderMapping&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;library_name&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;mask_token&quot;</code>, <code>&quot;model-index&quot;</code>, <code>&quot;pipeline_tag&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;safetensors&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;spaces&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;transformersInfo&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;widgetData&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_models.full",description:`<strong>full</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch all model data, including the <code>last_modified</code>,
the <code>sha</code>, the files and the <code>tags</code>. This is set to <code>True</code> by
default when using a filter.`,name:"full"},{anchor:"huggingface_hub.HfApi.list_models.cardData",description:`<strong>cardData</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to grab the metadata for the model as well. Can contain
useful information such as carbon emissions, metrics, and
datasets trained on.`,name:"cardData"},{anchor:"huggingface_hub.HfApi.list_models.fetch_config",description:`<strong>fetch_config</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch the model configs as well. This is not included
in <code>full</code> due to its size.`,name:"fetch_config"},{anchor:"huggingface_hub.HfApi.list_models.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1858",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.ModelInfo"
>huggingface_hub.hf_api.ModelInfo</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[ModelInfo]</code></p>
`}}),ps=new C({props:{anchor:"huggingface_hub.HfApi.list_models.example",$$slots:{default:[hU]},$$scope:{ctx:T}}}),Oi=new q({props:{name:"list_organization_members",anchor:"huggingface_hub.HfApi.list_organization_members",parameters:[{name:"organization",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_organization_members.organization",description:`<strong>organization</strong> (<code>str</code>) &#x2014;
Name of the organization to get the members of.`,name:"organization"},{anchor:"huggingface_hub.HfApi.list_organization_members.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9753",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.User"
>User</a> objects with the members of the organization.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the organization does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Ki=new q({props:{name:"list_papers",anchor:"huggingface_hub.HfApi.list_papers",parameters:[{name:"query",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_papers.query",description:`<strong>query</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A search query string to find papers.
If provided, returns papers that match the query.`,name:"query"},{anchor:"huggingface_hub.HfApi.list_papers.token",description:`<strong>token</strong> (Union[bool, str, None], <em>optional</em>) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9837",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <code>huggingface_hub.hf_api.PaperInfo</code> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[PaperInfo]</code></p>
`}}),gs=new C({props:{anchor:"huggingface_hub.HfApi.list_papers.example",$$slots:{default:[fU]},$$scope:{ctx:T}}}),ec=new q({props:{name:"list_pending_access_requests",anchor:"huggingface_hub.HfApi.list_pending_access_requests",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_pending_access_requests.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to get access requests for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_pending_access_requests.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to get access requests for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_pending_access_requests.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8738",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <code>AccessRequest</code> objects. Each time contains a <code>username</code>, <code>email</code>,
<code>status</code> and <code>timestamp</code> attribute. If the gated repo has a custom form, the <code>fields</code> attribute will
be populated with user’s answers.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AccessRequest]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),us=new C({props:{anchor:"huggingface_hub.HfApi.list_pending_access_requests.example",$$slots:{default:[mU]},$$scope:{ctx:T}}}),tc=new q({props:{name:"list_rejected_access_requests",anchor:"huggingface_hub.HfApi.list_rejected_access_requests",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to get access requests for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to get access requests for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8864",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <code>AccessRequest</code> objects. Each time contains a <code>username</code>, <code>email</code>,
<code>status</code> and <code>timestamp</code> attribute. If the gated repo has a custom form, the <code>fields</code> attribute will
be populated with user’s answers.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AccessRequest]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),hs=new C({props:{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.example",$$slots:{default:[_U]},$$scope:{ctx:T}}}),nc=new q({props:{name:"list_repo_commits",anchor:"huggingface_hub.HfApi.list_repo_commits",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"revision",val:": Optional[str] = None"},{name:"formatted",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_commits.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_commits.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing commits from a dataset or a Space, <code>None</code> or <code>&quot;model&quot;</code> if
listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_commits.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.list_repo_commits.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.list_repo_commits.formatted",description:`<strong>formatted</strong> (<code>bool</code>) &#x2014;
Whether to return the HTML-formatted title and description of the commits. Defaults to False.`,name:"formatted"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3263",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of objects containing information about the commits for a repo on the Hub.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List[<a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.GitCommitInfo"
>GitCommitInfo</a>]</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a></p>
`}}),fs=new C({props:{anchor:"huggingface_hub.HfApi.list_repo_commits.example",$$slots:{default:[bU]},$$scope:{ctx:T}}}),oc=new q({props:{name:"list_repo_files",anchor:"huggingface_hub.HfApi.list_repo_files",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_files.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.list_repo_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to
a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3022",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the list of files in a given repository.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),ac=new q({props:{name:"list_repo_likers",anchor:"huggingface_hub.HfApi.list_repo_likers",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_likers.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to retrieve . Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_likers.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.list_repo_likers.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2536",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.User"
>huggingface_hub.hf_api.User</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`}}),sc=new q({props:{name:"list_repo_refs",anchor:"huggingface_hub.HfApi.list_repo_refs",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"include_pull_requests",val:": bool = False"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_refs.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_refs.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing refs from a dataset or a Space,
<code>None</code> or <code>&quot;model&quot;</code> if listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_refs.include_pull_requests",description:`<strong>include_pull_requests</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to include refs from pull requests in the list. Defaults to <code>False</code>.`,name:"include_pull_requests"},{anchor:"huggingface_hub.HfApi.list_repo_refs.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3191",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>object containing all information about branches and tags for a
repo on the Hub.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.GitRefs"
>GitRefs</a></p>
`}}),_s=new C({props:{anchor:"huggingface_hub.HfApi.list_repo_refs.example",$$slots:{default:[yU]},$$scope:{ctx:T}}}),rc=new q({props:{name:"list_repo_tree",anchor:"huggingface_hub.HfApi.list_repo_tree",parameters:[{name:"repo_id",val:": str"},{name:"path_in_repo",val:": Optional[str] = None"},{name:"recursive",val:": bool = False"},{name:"expand",val:": bool = False"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_tree.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_tree.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Relative path of the tree (folder) in the repo, for example:
<code>&quot;checkpoints/1fec34a/results&quot;</code>. Will default to the root tree (folder) of the repository.`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.list_repo_tree.recursive",description:`<strong>recursive</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to list tree&#x2019;s files and folders recursively.`,name:"recursive"},{anchor:"huggingface_hub.HfApi.list_repo_tree.expand",description:`<strong>expand</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fetch more information about the tree&#x2019;s files and folders (e.g. last commit and files&#x2019; security scan results). This
operation is more expensive for the server so only 50 results are returned per page (instead of 1000).
As pagination is implemented in <code>huggingface_hub</code>, this is transparent for you except for the time it
takes to get the results.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_repo_tree.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the tree. Defaults to <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.list_repo_tree.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository from which to get the tree (<code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>.
Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_tree.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3059",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The information about the tree’s files and folders, as an iterable of <code>RepoFile</code> and <code>RepoFolder</code> objects. The order of the files and folders is
not guaranteed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[Union[RepoFile, RepoFolder]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a> —
If the tree (folder) does not exist (error 404) on the repo.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a></p>
`}}),bs=new C({props:{anchor:"huggingface_hub.HfApi.list_repo_tree.example",$$slots:{default:[vU]},$$scope:{ctx:T}}}),ys=new C({props:{anchor:"huggingface_hub.HfApi.list_repo_tree.example-2",$$slots:{default:[xU]},$$scope:{ctx:T}}}),ic=new q({props:{name:"list_scheduled_jobs",anchor:"huggingface_hub.HfApi.list_scheduled_jobs",parameters:[{name:"timeout",val:": Optional[int] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_scheduled_jobs.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.list_scheduled_jobs.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace from where it lists the jobs. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.list_scheduled_jobs.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10482"}}),cc=new q({props:{name:"list_spaces",anchor:"huggingface_hub.HfApi.list_spaces",parameters:[{name:"filter",val:": Union[str, Iterable[str], None] = None"},{name:"author",val:": Optional[str] = None"},{name:"search",val:": Optional[str] = None"},{name:"datasets",val:": Union[str, Iterable[str], None] = None"},{name:"models",val:": Union[str, Iterable[str], None] = None"},{name:"linked",val:": bool = False"},{name:"sort",val:": Union[Literal['last_modified'], str, None] = None"},{name:"direction",val:": Optional[Literal[-1]] = None"},{name:"limit",val:": Optional[int] = None"},{name:"expand",val:": Optional[List[ExpandSpaceProperty_T]] = None"},{name:"full",val:": Optional[bool] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_spaces.filter",description:`<strong>filter</strong> (<code>str</code> or <code>Iterable</code>, <em>optional</em>) &#x2014;
A string tag or list of tags that can be used to identify Spaces on the Hub.`,name:"filter"},{anchor:"huggingface_hub.HfApi.list_spaces.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string which identify the author of the returned Spaces.`,name:"author"},{anchor:"huggingface_hub.HfApi.list_spaces.search",description:`<strong>search</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that will be contained in the returned Spaces.`,name:"search"},{anchor:"huggingface_hub.HfApi.list_spaces.datasets",description:`<strong>datasets</strong> (<code>str</code> or <code>Iterable</code>, <em>optional</em>) &#x2014;
Whether to return Spaces that make use of a dataset.
The name of a specific dataset can be passed as a string.`,name:"datasets"},{anchor:"huggingface_hub.HfApi.list_spaces.models",description:`<strong>models</strong> (<code>str</code> or <code>Iterable</code>, <em>optional</em>) &#x2014;
Whether to return Spaces that make use of a model.
The name of a specific model can be passed as a string.`,name:"models"},{anchor:"huggingface_hub.HfApi.list_spaces.linked",description:`<strong>linked</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return Spaces that make use of either a model or a dataset.`,name:"linked"},{anchor:"huggingface_hub.HfApi.list_spaces.sort",description:`<strong>sort</strong> (<code>Literal[&quot;last_modified&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The key with which to sort the resulting models. Possible values are &#x201C;last_modified&#x201D;, &#x201C;trending_score&#x201D;,
&#x201C;created_at&#x201D; and &#x201C;likes&#x201D;.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_spaces.direction",description:`<strong>direction</strong> (<code>Literal[-1]</code> or <code>int</code>, <em>optional</em>) &#x2014;
Direction in which to sort. The value <code>-1</code> sorts by descending
order while all other values sort by ascending order.`,name:"direction"},{anchor:"huggingface_hub.HfApi.list_spaces.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The limit on the number of Spaces fetched. Leaving this option
to <code>None</code> fetches all Spaces.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_spaces.expand",description:`<strong>expand</strong> (<code>List[ExpandSpaceProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;datasets&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;models&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;runtime&quot;</code>, <code>&quot;sdk&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;subdomain&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_spaces.full",description:`<strong>full</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch all Spaces data, including the <code>last_modified</code>, <code>siblings</code>
and <code>card_data</code> fields.`,name:"full"},{anchor:"huggingface_hub.HfApi.list_spaces.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2299",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.SpaceInfo"
>huggingface_hub.hf_api.SpaceInfo</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[SpaceInfo]</code></p>
`}}),lc=new q({props:{name:"list_user_followers",anchor:"huggingface_hub.HfApi.list_user_followers",parameters:[{name:"username",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_user_followers.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user to get the followers of.`,name:"username"},{anchor:"huggingface_hub.HfApi.list_user_followers.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9781",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.User"
>User</a> objects with the followers of the user.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),pc=new q({props:{name:"list_user_following",anchor:"huggingface_hub.HfApi.list_user_following",parameters:[{name:"username",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_user_following.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user to get the users followed by.`,name:"username"},{anchor:"huggingface_hub.HfApi.list_user_following.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9809",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.User"
>User</a> objects with the users followed by the user.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),dc=new q({props:{name:"list_webhooks",anchor:"huggingface_hub.HfApi.list_webhooks",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_webhooks.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9224",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of webhook info objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[WebhookInfo]</code></p>
`}}),ks=new C({props:{anchor:"huggingface_hub.HfApi.list_webhooks.example",$$slots:{default:[$U]},$$scope:{ctx:T}}}),gc=new q({props:{name:"merge_pull_request",anchor:"huggingface_hub.HfApi.merge_pull_request",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"token",val:": Union[bool, str, None] = None"},{name:"comment",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.merge_pull_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.merge_pull_request.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.merge_pull_request.comment",description:`<strong>comment</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional comment to post with the status change.`,name:"comment"},{anchor:"huggingface_hub.HfApi.merge_pull_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.merge_pull_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6816",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the status change event</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionStatusChange"
>DiscussionStatusChange</a></p>
`}}),Ts=new I({props:{$$slots:{default:[wU]},$$scope:{ctx:T}}}),uc=new q({props:{name:"model_info",anchor:"huggingface_hub.HfApi.model_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"securityStatus",val:": Optional[bool] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[List[ExpandModelProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.model_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.model_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the model repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.model_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.model_info.securityStatus",description:`<strong>securityStatus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to retrieve the security status from the model
repository as well. The security status will be returned in the <code>security_repo_status</code> field.`,name:"securityStatus"},{anchor:"huggingface_hub.HfApi.model_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.model_info.expand",description:`<strong>expand</strong> (<code>List[ExpandModelProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>securityStatus</code> or <code>files_metadata</code> are passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;baseModels&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;childrenModelCount&quot;</code>, <code>&quot;config&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;gguf&quot;</code>, <code>&quot;inference&quot;</code>, <code>&quot;inferenceProviderMapping&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;library_name&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;mask_token&quot;</code>, <code>&quot;model-index&quot;</code>, <code>&quot;pipeline_tag&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;safetensors&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;spaces&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;transformersInfo&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;widgetData&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.model_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2575",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The model repository information.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.ModelInfo"
>huggingface_hub.hf_api.ModelInfo</a></p>
`}}),js=new I({props:{$$slots:{default:[kU]},$$scope:{ctx:T}}}),hc=new q({props:{name:"move_repo",anchor:"huggingface_hub.HfApi.move_repo",parameters:[{name:"from_id",val:": str"},{name:"to_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.move_repo.from_id",description:`<strong>from_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>. Original repository identifier.`,name:"from_id"},{anchor:"huggingface_hub.HfApi.move_repo.to_id",description:`<strong>to_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>. Final repository identifier.`,name:"to_id"},{anchor:"huggingface_hub.HfApi.move_repo.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.move_repo.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3972"}}),Ms=new I({props:{$$slots:{default:[TU]},$$scope:{ctx:T}}}),fc=new q({props:{name:"paper_info",anchor:"huggingface_hub.HfApi.paper_info",parameters:[{name:"id",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.paper_info.id",description:`<strong>id</strong> (<code>str</code>, <strong>optional</strong>) &#x2014;
ArXiv id of the paper.`,name:"id"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9883",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>PaperInfo</code> object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PaperInfo</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the paper does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),mc=new q({props:{name:"parse_safetensors_file_metadata",anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata",parameters:[{name:"repo_id",val:": str"},{name:"filename",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.filename",description:`<strong>filename</strong> (<code>str</code>) &#x2014;
The name of the file in the repo.`,name:"filename"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the file is in a dataset or space, <code>None</code> or <code>&quot;model&quot;</code> if in a
model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to fetch the file from. Can be a branch name, a tag, or a commit hash. Defaults to the
head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5827",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information related to a safetensors file.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>SafetensorsFileMetadata</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>NotASafetensorsRepoError</code> —
If the repo is not a safetensors repo i.e. doesn’t have either a
<code>model.safetensors</code> or a <code>model.safetensors.index.json</code> file.</li>
<li><code>SafetensorsParsingError</code> —
If a safetensors file header couldn’t be parsed correctly.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>NotASafetensorsRepoError</code> or <code>SafetensorsParsingError</code></p>
`}}),_c=new q({props:{name:"pause_inference_endpoint",anchor:"huggingface_hub.HfApi.pause_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.pause_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to pause.`,name:"name"},{anchor:"huggingface_hub.HfApi.pause_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.pause_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8142",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the paused Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),bc=new q({props:{name:"pause_space",anchor:"huggingface_hub.HfApi.pause_space",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.pause_space.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to pause. Example: <code>&quot;Salesforce/BLIP2&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.pause_space.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7278",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about your Space including <code>stage=PAUSED</code> and requested hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If your Space is not found (error 404). Most probably wrong repo_id or your space is private but you
are not authenticated.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
403 Forbidden: only the owner of a Space can pause it. If you want to manage a Space that you don’t
own, either ask the owner by opening a Discussion or duplicate the Space.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If your Space is a static Space. Static Spaces are always running and never billed. If you want to hide
a static Space, you can set it to private.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a></p>
`}}),yc=new q({props:{name:"permanently_delete_lfs_files",anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files",parameters:[{name:"repo_id",val:": str"},{name:"lfs_files",val:": Iterable[LFSFileInfo]"},{name:"rewrite_history",val:": bool = True"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository for which you are listing LFS files.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.lfs_files",description:`<strong>lfs_files</strong> (<code>Iterable[LFSFileInfo]</code>) &#x2014;
An iterable of <code>LFSFileInfo</code> items to permanently delete from the repo. Use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_lfs_files">list_lfs_files()</a> to list
all LFS files from a repo.`,name:"lfs_files"},{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.rewrite_history",description:`<strong>rewrite_history</strong> (<code>bool</code>, <em>optional</em>, default to <code>True</code>) &#x2014;
Whether to rewrite repository history to remove file pointers referencing the deleted LFS files (recommended).`,name:"rewrite_history"},{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of repository. Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing from a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3566"}}),Hs=new I({props:{warning:!0,$$slots:{default:[jU]},$$scope:{ctx:T}}}),Us=new C({props:{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.example",$$slots:{default:[MU]},$$scope:{ctx:T}}}),vc=new q({props:{name:"preupload_lfs_files",anchor:"huggingface_hub.HfApi.preupload_lfs_files",parameters:[{name:"repo_id",val:": str"},{name:"additions",val:": Iterable[CommitOperationAdd]"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"num_threads",val:": int = 5"},{name:"free_memory",val:": bool = True"},{name:"gitignore_content",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.preupload_lfs_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which you will commit the files, for example: <code>&quot;username/custom_transformers&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.operations",description:`<strong>operations</strong> (<code>Iterable</code> of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationAdd">CommitOperationAdd</a>) &#x2014;
The list of files to upload. Warning: the objects in this list will be mutated to include information
relative to the upload. Do not reuse the same objects for multiple commits.`,name:"operations"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of repository to upload to (e.g. <code>&quot;model&quot;</code> -default-, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>).`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not you plan to create a Pull Request with that commit. Defaults to <code>False</code>.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.num_threads",description:`<strong>num_threads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of concurrent threads for uploading files. Defaults to 5.
Setting it to 2 means at most 2 files will be uploaded concurrently.`,name:"num_threads"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.gitignore_content",description:`<strong>gitignore_content</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The content of the <code>.gitignore</code> file to know which files should be ignored. The order of priority
is to first check if <code>gitignore_content</code> is passed, then check if the <code>.gitignore</code> file is present
in the list of files to commit and finally default to the <code>.gitignore</code> file already hosted on the Hub
(if any).`,name:"gitignore_content"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4367"}}),Cs=new I({props:{warning:!0,$$slots:{default:[qU]},$$scope:{ctx:T}}}),Is=new I({props:{warning:!0,$$slots:{default:[HU]},$$scope:{ctx:T}}}),Js=new C({props:{anchor:"huggingface_hub.HfApi.preupload_lfs_files.example",$$slots:{default:[UU]},$$scope:{ctx:T}}}),xc=new q({props:{name:"reject_access_request",anchor:"huggingface_hub.HfApi.reject_access_request",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"rejection_reason",val:": Optional[str]"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.reject_access_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to reject access request for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.reject_access_request.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user which access request should be rejected.`,name:"user"},{anchor:"huggingface_hub.HfApi.reject_access_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to reject access request for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.reject_access_request.rejection_reason",description:`<strong>rejection_reason</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Optional rejection reason that will be visible to the user (max 200 characters).`,name:"rejection_reason"},{anchor:"huggingface_hub.HfApi.reject_access_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9037",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request cannot be found.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request is already in the rejected list.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),$c=new q({props:{name:"rename_discussion",anchor:"huggingface_hub.HfApi.rename_discussion",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"new_title",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.rename_discussion.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.rename_discussion.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.rename_discussion.new_title",description:`<strong>new_title</strong> (<code>str</code>) &#x2014;
The new title for the discussion`,name:"new_title"},{anchor:"huggingface_hub.HfApi.rename_discussion.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.rename_discussion.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6668",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the title change event</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionTitleChange"
>DiscussionTitleChange</a></p>
`}}),Ns=new C({props:{anchor:"huggingface_hub.HfApi.rename_discussion.example",$$slots:{default:[CU]},$$scope:{ctx:T}}}),As=new I({props:{$$slots:{default:[IU]},$$scope:{ctx:T}}}),wc=new q({props:{name:"repo_exists",anchor:"huggingface_hub.HfApi.repo_exists",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.repo_exists.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.repo_exists.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.repo_exists.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2873",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if the repository exists, False otherwise.</p>
`}}),Es=new C({props:{anchor:"huggingface_hub.HfApi.repo_exists.example",$$slots:{default:[JU]},$$scope:{ctx:T}}}),kc=new q({props:{name:"repo_info",anchor:"huggingface_hub.HfApi.repo_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[Union[ExpandModelProperty_T, ExpandDatasetProperty_T, ExpandSpaceProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.repo_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.repo_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.repo_info.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.repo_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.repo_info.expand",description:`<strong>expand</strong> (<code>ExpandModelProperty_T</code> or <code>ExpandDatasetProperty_T</code> or <code>ExpandSpaceProperty_T</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>files_metadata</code> is passed.
For an exhaustive list of available properties, check out <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.model_info">model_info()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.dataset_info">dataset_info()</a> or <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.space_info">space_info()</a>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.repo_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.repo_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2799",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The repository information, as a
<a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.DatasetInfo"
>huggingface_hub.hf_api.DatasetInfo</a>, <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.ModelInfo"
>huggingface_hub.hf_api.ModelInfo</a>
or <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.SpaceInfo"
>huggingface_hub.hf_api.SpaceInfo</a> object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[SpaceInfo, DatasetInfo, ModelInfo]</code></p>
`}}),Ds=new I({props:{$$slots:{default:[NU]},$$scope:{ctx:T}}}),Tc=new q({props:{name:"request_space_hardware",anchor:"huggingface_hub.HfApi.request_space_hardware",parameters:[{name:"repo_id",val:": str"},{name:"hardware",val:": SpaceHardware"},{name:"token",val:": Union[bool, str, None] = None"},{name:"sleep_time",val:": Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.request_space_hardware.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.request_space_hardware.hardware",description:`<strong>hardware</strong> (<code>str</code> or <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a>) &#x2014;
Hardware on which to run the Space. Example: <code>&quot;t4-medium&quot;</code>.`,name:"hardware"},{anchor:"huggingface_hub.HfApi.request_space_hardware.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.request_space_hardware.sleep_time",description:`<strong>sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to sleep (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"sleep_time"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7174",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),Rs=new I({props:{$$slots:{default:[AU]},$$scope:{ctx:T}}}),jc=new q({props:{name:"request_space_storage",anchor:"huggingface_hub.HfApi.request_space_storage",parameters:[{name:"repo_id",val:": str"},{name:"storage",val:": SpaceStorage"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.request_space_storage.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to update. Example: <code>&quot;open-llm-leaderboard/open_llm_leaderboard&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.request_space_storage.storage",description:`<strong>storage</strong> (<code>str</code> or <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceStorage">SpaceStorage</a>) &#x2014;
Storage tier. Either &#x2018;small&#x2019;, &#x2018;medium&#x2019;, or &#x2018;large&#x2019;.`,name:"storage"},{anchor:"huggingface_hub.HfApi.request_space_storage.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7481",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),Gs=new I({props:{$$slots:{default:[EU]},$$scope:{ctx:T}}}),Mc=new q({props:{name:"restart_space",anchor:"huggingface_hub.HfApi.restart_space",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"factory_reboot",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.restart_space.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to restart. Example: <code>&quot;Salesforce/BLIP2&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.restart_space.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.restart_space.factory_reboot",description:`<strong>factory_reboot</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, the Space will be rebuilt from scratch without caching any requirements.`,name:"factory_reboot"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7317",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about your Space.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If your Space is not found (error 404). Most probably wrong repo_id or your space is private but you
are not authenticated.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
403 Forbidden: only the owner of a Space can restart it. If you want to restart a Space that you don’t
own, either ask the owner by opening a Discussion or duplicate the Space.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If your Space is a static Space. Static Spaces are always running and never billed. If you want to hide
a static Space, you can set it to private.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a></p>
`}}),qc=new q({props:{name:"resume_inference_endpoint",anchor:"huggingface_hub.HfApi.resume_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"running_ok",val:": bool = True"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to resume.`,name:"name"},{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.running_ok",description:`<strong>running_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, the method will not raise an error if the Inference Endpoint is already running. Defaults to
<code>True</code>.`,name:"running_ok"},{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8177",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the resumed Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Hc=new q({props:{name:"resume_scheduled_job",anchor:"huggingface_hub.HfApi.resume_scheduled_job",parameters:[{name:"scheduled_job_id",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.resume_scheduled_job.scheduled_job_id",description:`<strong>scheduled_job_id</strong> (<code>str</code>) &#x2014;
ID of the scheduled Job.`,name:"scheduled_job_id"},{anchor:"huggingface_hub.HfApi.resume_scheduled_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the scheduled Job is. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.resume_scheduled_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10612"}}),Uc=new q({props:{name:"revision_exists",anchor:"huggingface_hub.HfApi.revision_exists",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.revision_exists.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.revision_exists.revision",description:`<strong>revision</strong> (<code>str</code>) &#x2014;
The revision of the repository to check.`,name:"revision"},{anchor:"huggingface_hub.HfApi.revision_exists.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.revision_exists.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2917",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if the repository and the revision exists, False otherwise.</p>
`}}),Fs=new C({props:{anchor:"huggingface_hub.HfApi.revision_exists.example",$$slots:{default:[DU]},$$scope:{ctx:T}}}),Cc=new q({props:{name:"run_as_future",anchor:"huggingface_hub.HfApi.run_as_future",parameters:[{name:"fn",val:": Callable[..., R]"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfApi.run_as_future.fn",description:`<strong>fn</strong> (<code>Callable</code>) &#x2014;
The method to run in the background.`,name:"fn"},{anchor:"huggingface_hub.HfApi.run_as_future.*args,",description:`<strong>*args,</strong> **kwargs &#x2014;
Arguments with which the method will be called.`,name:"*args,"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1723",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a <a
  href="https://docs.python.org/3/library/concurrent.futures.html#future-objects"
  rel="nofollow"
>Future</a> instance to
get the result of the task.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Future</code></p>
`}}),Ss=new C({props:{anchor:"huggingface_hub.HfApi.run_as_future.example",$$slots:{default:[RU]},$$scope:{ctx:T}}}),Ic=new q({props:{name:"run_job",anchor:"huggingface_hub.HfApi.run_job",parameters:[{name:"image",val:": str"},{name:"command",val:": List[str]"},{name:"env",val:": Optional[Dict[str, Any]] = None"},{name:"secrets",val:": Optional[Dict[str, Any]] = None"},{name:"flavor",val:": Optional[SpaceHardware] = None"},{name:"timeout",val:": Optional[Union[int, float, str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.run_job.image",description:`<strong>image</strong> (<code>str</code>) &#x2014;
The Docker image to use.
Examples: <code>&quot;ubuntu&quot;</code>, <code>&quot;python:3.12&quot;</code>, <code>&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</code>.
Example with an image from a Space: <code>&quot;hf.co/spaces/lhoestq/duckdb&quot;</code>.`,name:"image"},{anchor:"huggingface_hub.HfApi.run_job.command",description:`<strong>command</strong> (<code>List[str]</code>) &#x2014;
The command to run. Example: <code>[&quot;echo&quot;, &quot;hello&quot;]</code>.`,name:"command"},{anchor:"huggingface_hub.HfApi.run_job.env",description:`<strong>env</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the environment variables for the Job.`,name:"env"},{anchor:"huggingface_hub.HfApi.run_job.secrets",description:`<strong>secrets</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the secret environment variables for the Job.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.run_job.flavor",description:`<strong>flavor</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Flavor for the hardware, as in Hugging Face Spaces. See <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for possible values.
Defaults to <code>&quot;cpu-basic&quot;</code>.`,name:"flavor"},{anchor:"huggingface_hub.HfApi.run_job.timeout",description:`<strong>timeout</strong> (<code>Union[int, float, str]</code>, <em>optional</em>) &#x2014;
Max duration for the Job: int/float with s (seconds, default), m (minutes), h (hours) or d (days).
Example: <code>300</code> or <code>&quot;5m&quot;</code> for 5 minutes.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.run_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.run_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9967"}}),Ls=new C({props:{anchor:"huggingface_hub.HfApi.run_job.example",$$slots:{default:[GU]},$$scope:{ctx:T}}}),Ws=new C({props:{anchor:"huggingface_hub.HfApi.run_job.example-2",$$slots:{default:[ZU]},$$scope:{ctx:T}}}),Jc=new q({props:{name:"run_uv_job",anchor:"huggingface_hub.HfApi.run_uv_job",parameters:[{name:"script",val:": str"},{name:"script_args",val:": Optional[List[str]] = None"},{name:"dependencies",val:": Optional[List[str]] = None"},{name:"python",val:": Optional[str] = None"},{name:"image",val:": Optional[str] = None"},{name:"env",val:": Optional[Dict[str, Any]] = None"},{name:"secrets",val:": Optional[Dict[str, Any]] = None"},{name:"flavor",val:": Optional[SpaceHardware] = None"},{name:"timeout",val:": Optional[Union[int, float, str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"_repo",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.run_uv_job.script",description:`<strong>script</strong> (<code>str</code>) &#x2014;
Path or URL of the UV script, or a command.`,name:"script"},{anchor:"huggingface_hub.HfApi.run_uv_job.script_args",description:`<strong>script_args</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Arguments to pass to the script or command.`,name:"script_args"},{anchor:"huggingface_hub.HfApi.run_uv_job.dependencies",description:`<strong>dependencies</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Dependencies to use to run the UV script.`,name:"dependencies"},{anchor:"huggingface_hub.HfApi.run_uv_job.python",description:`<strong>python</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Use a specific Python version. Default is 3.12.`,name:"python"},{anchor:"huggingface_hub.HfApi.run_uv_job.image",description:`<strong>image</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;ghcr.io/astral-sh/uv &#x2014;python3.12-bookworm&#x201D;):
Use a custom Docker image with <code>uv</code> installed.`,name:"image"},{anchor:"huggingface_hub.HfApi.run_uv_job.env",description:`<strong>env</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the environment variables for the Job.`,name:"env"},{anchor:"huggingface_hub.HfApi.run_uv_job.secrets",description:`<strong>secrets</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the secret environment variables for the Job.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.run_uv_job.flavor",description:`<strong>flavor</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Flavor for the hardware, as in Hugging Face Spaces. See <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for possible values.
Defaults to <code>&quot;cpu-basic&quot;</code>.`,name:"flavor"},{anchor:"huggingface_hub.HfApi.run_uv_job.timeout",description:`<strong>timeout</strong> (<code>Union[int, float, str]</code>, <em>optional</em>) &#x2014;
Max duration for the Job: int/float with s (seconds, default), m (minutes), h (hours) or d (days).
Example: <code>300</code> or <code>&quot;5m&quot;</code> for 5 minutes.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.run_uv_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.run_uv_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10254"}}),Vs=new C({props:{anchor:"huggingface_hub.HfApi.run_uv_job.example",$$slots:{default:[FU]},$$scope:{ctx:T}}}),Bs=new C({props:{anchor:"huggingface_hub.HfApi.run_uv_job.example-2",$$slots:{default:[SU]},$$scope:{ctx:T}}}),Ps=new C({props:{anchor:"huggingface_hub.HfApi.run_uv_job.example-3",$$slots:{default:[LU]},$$scope:{ctx:T}}}),Nc=new q({props:{name:"scale_to_zero_inference_endpoint",anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to scale to zero.`,name:"name"},{anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8223",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the scaled-to-zero Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Ac=new q({props:{name:"set_space_sleep_time",anchor:"huggingface_hub.HfApi.set_space_sleep_time",parameters:[{name:"repo_id",val:": str"},{name:"sleep_time",val:": int"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.set_space_sleep_time.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.set_space_sleep_time.sleep_time",description:`<strong>sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to pause (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"sleep_time"},{anchor:"huggingface_hub.HfApi.set_space_sleep_time.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7227",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),Ys=new I({props:{$$slots:{default:[WU]},$$scope:{ctx:T}}}),Ec=new q({props:{name:"snapshot_download",anchor:"huggingface_hub.HfApi.snapshot_download",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"cache_dir",val:": Union[str, Path, None] = None"},{name:"local_dir",val:": Union[str, Path, None] = None"},{name:"proxies",val:": Optional[Dict] = None"},{name:"etag_timeout",val:": float = 10"},{name:"force_download",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"},{name:"local_files_only",val:": bool = False"},{name:"allow_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"ignore_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"max_workers",val:": int = 8"},{name:"tqdm_class",val:": Optional[Type[base_tqdm]] = None"},{name:"local_dir_use_symlinks",val:": Union[bool, Literal['auto']] = 'auto'"},{name:"resume_download",val:": Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.snapshot_download.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.snapshot_download.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if downloading from a dataset or space,
<code>None</code> or <code>&quot;model&quot;</code> if downloading from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.snapshot_download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional Git revision id which can be a branch name, a tag, or a
commit hash.`,name:"revision"},{anchor:"huggingface_hub.HfApi.snapshot_download.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.HfApi.snapshot_download.local_dir",description:`<strong>local_dir</strong> (<code>str</code> or <code>Path</code>, <em>optional</em>) &#x2014;
If provided, the downloaded files will be placed under this directory.`,name:"local_dir"},{anchor:"huggingface_hub.HfApi.snapshot_download.proxies",description:`<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary mapping protocol to the URL of the proxy passed to
<code>requests.request</code>.`,name:"proxies"},{anchor:"huggingface_hub.HfApi.snapshot_download.etag_timeout",description:`<strong>etag_timeout</strong> (<code>float</code>, <em>optional</em>, defaults to <code>10</code>) &#x2014;
When fetching ETag, how many seconds to wait for the server to send
data before giving up which is passed to <code>requests.request</code>.`,name:"etag_timeout"},{anchor:"huggingface_hub.HfApi.snapshot_download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the file should be downloaded even if it already exists in the local cache.`,name:"force_download"},{anchor:"huggingface_hub.HfApi.snapshot_download.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.snapshot_download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the
local cached file if it exists.`,name:"local_files_only"},{anchor:"huggingface_hub.HfApi.snapshot_download.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are downloaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.HfApi.snapshot_download.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not downloaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.HfApi.snapshot_download.max_workers",description:`<strong>max_workers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of concurrent threads to download files (1 thread = 1 file download).
Defaults to 8.`,name:"max_workers"},{anchor:"huggingface_hub.HfApi.snapshot_download.tqdm_class",description:`<strong>tqdm_class</strong> (<code>tqdm</code>, <em>optional</em>) &#x2014;
If provided, overwrites the default behavior for the progress bar. Passed
argument must inherit from <code>tqdm.auto.tqdm</code> or at least mimic its behavior.
Note that the <code>tqdm_class</code> is not passed to each individual download.
Defaults to the custom HF progress bar that can be disabled by setting
<code>HF_HUB_DISABLE_PROGRESS_BARS</code> environment variable.`,name:"tqdm_class"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5562",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>folder path of the repo snapshot.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If the revision to download from cannot be found.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a> —
If <code>token=True</code> and the token cannot be found.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#OSError"
  rel="nofollow"
><code>OSError</code></a> — if
ETag cannot be determined.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
if some parameter value is invalid.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <code>EnvironmentError</code> or <code>OSError</code> or <code>ValueError</code></p>
`}}),Dc=new q({props:{name:"space_info",anchor:"huggingface_hub.HfApi.space_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[List[ExpandSpaceProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.space_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.space_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the space repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.space_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.space_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.space_info.expand",description:`<strong>expand</strong> (<code>List[ExpandSpaceProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;datasets&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;models&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;runtime&quot;</code>, <code>&quot;sdk&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;subdomain&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.space_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2726",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The space repository information.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.SpaceInfo"
>SpaceInfo</a></p>
`}}),Xs=new I({props:{$$slots:{default:[VU]},$$scope:{ctx:T}}}),Rc=new q({props:{name:"super_squash_history",anchor:"huggingface_hub.HfApi.super_squash_history",parameters:[{name:"repo_id",val:": str"},{name:"branch",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.super_squash_history.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.super_squash_history.branch",description:`<strong>branch</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The branch to squash. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"branch"},{anchor:"huggingface_hub.HfApi.super_squash_history.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The commit message to use for the squashed commit.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.super_squash_history.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing commits from a dataset or a Space, <code>None</code> or <code>&quot;model&quot;</code> if
listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.super_squash_history.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3426",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If the branch to squash cannot be found.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If invalid reference for a branch. You cannot squash history on tags.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a></p>
`}}),zs=new I({props:{warning:!0,$$slots:{default:[BU]},$$scope:{ctx:T}}}),Qs=new I({props:{warning:!0,$$slots:{default:[PU]},$$scope:{ctx:T}}}),Os=new C({props:{anchor:"huggingface_hub.HfApi.super_squash_history.example",$$slots:{default:[YU]},$$scope:{ctx:T}}}),Gc=new q({props:{name:"suspend_scheduled_job",anchor:"huggingface_hub.HfApi.suspend_scheduled_job",parameters:[{name:"scheduled_job_id",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.suspend_scheduled_job.scheduled_job_id",description:`<strong>scheduled_job_id</strong> (<code>str</code>) &#x2014;
ID of the scheduled Job.`,name:"scheduled_job_id"},{anchor:"huggingface_hub.HfApi.suspend_scheduled_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the scheduled Job is. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.suspend_scheduled_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10583"}}),Zc=new q({props:{name:"unlike",anchor:"huggingface_hub.HfApi.unlike",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.unlike.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to unlike. Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.unlike.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.unlike.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if unliking a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if unliking a model. Default is <code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2409",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),er=new C({props:{anchor:"huggingface_hub.HfApi.unlike.example",$$slots:{default:[XU]},$$scope:{ctx:T}}}),Fc=new q({props:{name:"update_collection_item",anchor:"huggingface_hub.HfApi.update_collection_item",parameters:[{name:"collection_slug",val:": str"},{name:"item_object_id",val:": str"},{name:"note",val:": Optional[str] = None"},{name:"position",val:": Optional[int] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_collection_item.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.update_collection_item.item_object_id",description:`<strong>item_object_id</strong> (<code>str</code>) &#x2014;
ID of the item in the collection. This is not the id of the item on the Hub (repo_id or paper id).
It must be retrieved from a <a href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.CollectionItem">CollectionItem</a> object. Example: <code>collection.items[0].item_object_id</code>.`,name:"item_object_id"},{anchor:"huggingface_hub.HfApi.update_collection_item.note",description:`<strong>note</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A note to attach to the item in the collection. The maximum size for a note is 500 characters.`,name:"note"},{anchor:"huggingface_hub.HfApi.update_collection_item.position",description:`<strong>position</strong> (<code>int</code>, <em>optional</em>) &#x2014;
New position of the item in the collection.`,name:"position"},{anchor:"huggingface_hub.HfApi.update_collection_item.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8629"}}),tr=new C({props:{anchor:"huggingface_hub.HfApi.update_collection_item.example",$$slots:{default:[zU]},$$scope:{ctx:T}}}),Sc=new q({props:{name:"update_collection_metadata",anchor:"huggingface_hub.HfApi.update_collection_metadata",parameters:[{name:"collection_slug",val:": str"},{name:"title",val:": Optional[str] = None"},{name:"description",val:": Optional[str] = None"},{name:"position",val:": Optional[int] = None"},{name:"private",val:": Optional[bool] = None"},{name:"theme",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_collection_metadata.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
Title of the collection to update.`,name:"title"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Description of the collection to update.`,name:"description"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.position",description:`<strong>position</strong> (<code>int</code>, <em>optional</em>) &#x2014;
New position of the collection in the list of collections of the user.`,name:"position"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the collection should be private or not.`,name:"private"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.theme",description:`<strong>theme</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Theme of the collection on the Hub.`,name:"theme"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8438"}}),nr=new C({props:{anchor:"huggingface_hub.HfApi.update_collection_metadata.example",$$slots:{default:[QU]},$$scope:{ctx:T}}}),Lc=new q({props:{name:"update_inference_endpoint",anchor:"huggingface_hub.HfApi.update_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"accelerator",val:": Optional[str] = None"},{name:"instance_size",val:": Optional[str] = None"},{name:"instance_type",val:": Optional[str] = None"},{name:"min_replica",val:": Optional[int] = None"},{name:"max_replica",val:": Optional[int] = None"},{name:"scale_to_zero_timeout",val:": Optional[int] = None"},{name:"repository",val:": Optional[str] = None"},{name:"framework",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"task",val:": Optional[str] = None"},{name:"custom_image",val:": Optional[Dict] = None"},{name:"env",val:": Optional[Dict[str, str]] = None"},{name:"secrets",val:": Optional[Dict[str, str]] = None"},{name:"domain",val:": Optional[str] = None"},{name:"path",val:": Optional[str] = None"},{name:"cache_http_responses",val:": Optional[bool] = None"},{name:"tags",val:": Optional[List[str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to update.`,name:"name"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.accelerator",description:`<strong>accelerator</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The hardware accelerator to be used for inference (e.g. <code>&quot;cpu&quot;</code>).`,name:"accelerator"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.instance_size",description:`<strong>instance_size</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The size or type of the instance to be used for hosting the model (e.g. <code>&quot;x4&quot;</code>).`,name:"instance_size"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.instance_type",description:`<strong>instance_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The cloud instance type where the Inference Endpoint will be deployed (e.g. <code>&quot;intel-icl&quot;</code>).`,name:"instance_type"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.min_replica",description:`<strong>min_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of replicas (instances) to keep running for the Inference Endpoint.`,name:"min_replica"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.max_replica",description:`<strong>max_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of replicas (instances) to scale to for the Inference Endpoint.`,name:"max_replica"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.scale_to_zero_timeout",description:`<strong>scale_to_zero_timeout</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The duration in minutes before an inactive endpoint is scaled to zero.`,name:"scale_to_zero_timeout"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.repository",description:`<strong>repository</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the model repository associated with the Inference Endpoint (e.g. <code>&quot;gpt2&quot;</code>).`,name:"repository"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The machine learning framework used for the model (e.g. <code>&quot;custom&quot;</code>).`,name:"framework"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model revision to deploy on the Inference Endpoint (e.g. <code>&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</code>).`,name:"revision"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task on which to deploy the model (e.g. <code>&quot;text-classification&quot;</code>).`,name:"task"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.custom_image",description:`<strong>custom_image</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A custom Docker image to use for the Inference Endpoint. This is useful if you want to deploy an
Inference Endpoint running on the <code>text-generation-inference</code> (TGI) framework (see examples).`,name:"custom_image"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.env",description:`<strong>env</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Non-secret environment variables to inject in the container environment`,name:"env"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.secrets",description:`<strong>secrets</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Secret values to inject in the container environment.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.domain",description:`<strong>domain</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The custom domain for the Inference Endpoint deployment, if setup the inference endpoint will be available at this domain (e.g. <code>&quot;my-new-domain.cool-website.woof&quot;</code>).`,name:"domain"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.path",description:`<strong>path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The custom path to the deployed model, should start with a <code>/</code> (e.g. <code>&quot;/models/google-bert/bert-base-uncased&quot;</code>).`,name:"path"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.cache_http_responses",description:`<strong>cache_http_responses</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to cache HTTP responses from the Inference Endpoint.`,name:"cache_http_responses"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of tags to associate with the Inference Endpoint.`,name:"tags"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Inference Endpoint will be updated. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7977",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the updated Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Wc=new q({props:{name:"update_repo_settings",anchor:"huggingface_hub.HfApi.update_repo_settings",parameters:[{name:"repo_id",val:": str"},{name:"gated",val:": Optional[Literal['auto', 'manual', False]] = None"},{name:"private",val:": Optional[bool] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"xet_enabled",val:": Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_repo_settings.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a /.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.update_repo_settings.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
The gated status for the repository. If set to <code>None</code> (default), the <code>gated</code> setting of the repository won&#x2019;t be updated.<ul>
<li>&#x201C;auto&#x201D;: The repository is gated, and access requests are automatically approved or denied based on predefined criteria.</li>
<li>&#x201C;manual&#x201D;: The repository is gated, and access requests require manual approval.</li>
<li>False : The repository is not gated, and anyone can access it.</li>
</ul>`,name:"gated"},{anchor:"huggingface_hub.HfApi.update_repo_settings.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the repository should be private.`,name:"private"},{anchor:"huggingface_hub.HfApi.update_repo_settings.token",description:`<strong>token</strong> (<code>Union[str, bool, None]</code>, <em>optional</em>) &#x2014;
A valid user access token (string). Defaults to the locally saved token,
which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass False.`,name:"token"},{anchor:"huggingface_hub.HfApi.update_repo_settings.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository to update settings from (<code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>).
Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.update_repo_settings.xet_enabled",description:`<strong>xet_enabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the repository should be enabled for Xet Storage.`,name:"xet_enabled"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3891",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If gated is not one of “auto”, “manual”, or False.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If repo_type is not one of the values in constants.REPO_TYPES.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If the request to the Hugging Face Hub API fails.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),Vc=new q({props:{name:"update_repo_visibility",anchor:"huggingface_hub.HfApi.update_repo_visibility",parameters:[{name:"repo_id",val:": str"},{name:"private",val:": bool = False"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_repo_visibility.repo_id",description:`<strong>repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.update_repo_visibility.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the repository should be private.`,name:"private"},{anchor:"huggingface_hub.HfApi.update_repo_visibility.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.update_repo_visibility.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3836",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The HTTP response in json.</p>
`}}),or=new I({props:{$$slots:{default:[OU]},$$scope:{ctx:T}}}),Bc=new q({props:{name:"update_webhook",anchor:"huggingface_hub.HfApi.update_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"url",val:": Optional[str] = None"},{name:"watched",val:": Optional[List[Union[Dict, WebhookWatchedItem]]] = None"},{name:"domains",val:": Optional[List[constants.WEBHOOK_DOMAIN_T]] = None"},{name:"secret",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to be updated.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.update_webhook.url",description:`<strong>url</strong> (<code>str</code>, optional) &#x2014;
The URL to which the payload will be sent.`,name:"url"},{anchor:"huggingface_hub.HfApi.update_webhook.watched",description:`<strong>watched</strong> (<code>List[WebhookWatchedItem]</code>, optional) &#x2014;
List of items to watch. It can be users, orgs, models, datasets, or spaces.
Refer to <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.WebhookWatchedItem">WebhookWatchedItem</a> for more details. Watched items can also be provided as plain dictionaries.`,name:"watched"},{anchor:"huggingface_hub.HfApi.update_webhook.domains",description:`<strong>domains</strong> (<code>List[Literal[&quot;repo&quot;, &quot;discussion&quot;]]</code>, optional) &#x2014;
The domains to watch. This can include &#x201C;repo&#x201D;, &#x201C;discussion&#x201D;, or both.`,name:"domains"},{anchor:"huggingface_hub.HfApi.update_webhook.secret",description:`<strong>secret</strong> (<code>str</code>, optional) &#x2014;
A secret to sign the payload with, providing an additional layer of security.`,name:"secret"},{anchor:"huggingface_hub.HfApi.update_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9347",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the updated webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.WebhookInfo"
>WebhookInfo</a></p>
`}}),ar=new C({props:{anchor:"huggingface_hub.HfApi.update_webhook.example",$$slots:{default:[KU]},$$scope:{ctx:T}}}),Pc=new q({props:{name:"upload_file",anchor:"huggingface_hub.HfApi.upload_file",parameters:[{name:"path_or_fileobj",val:": Union[str, Path, bytes, BinaryIO]"},{name:"path_in_repo",val:": str"},{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"},{name:"run_as_future",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.upload_file.path_or_fileobj",description:`<strong>path_or_fileobj</strong> (<code>str</code>, <code>Path</code>, <code>bytes</code>, or <code>IO</code>) &#x2014;
Path to a file on the local machine or binary data stream /
fileobj / buffer.`,name:"path_or_fileobj"},{anchor:"huggingface_hub.HfApi.upload_file.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example:
<code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.upload_file.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to which the file will be uploaded, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.upload_file.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.upload_file.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.upload_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.upload_file.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.upload_file.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.upload_file.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.upload_file.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"},{anchor:"huggingface_hub.HfApi.upload_file.run_as_future",description:`<strong>run_as_future</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to run this method in the background. Background jobs are run sequentially without
blocking the main thread. Passing <code>run_as_future=True</code> will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow">Future</a>
object. Defaults to <code>False</code>.`,name:"run_as_future"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4582",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Instance of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> containing information about the newly created commit (commit hash, commit
url, pr url, commit message,…). If <code>run_as_future=True</code> is passed, returns a Future object which will
contain the result when executed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> or <code>Future</code></p>
`}}),sr=new I({props:{$$slots:{default:[e4]},$$scope:{ctx:T}}}),rr=new I({props:{warning:!0,$$slots:{default:[t4]},$$scope:{ctx:T}}}),ir=new C({props:{anchor:"huggingface_hub.HfApi.upload_file.example",$$slots:{default:[n4]},$$scope:{ctx:T}}}),Yc=new q({props:{name:"upload_folder",anchor:"huggingface_hub.HfApi.upload_folder",parameters:[{name:"repo_id",val:": str"},{name:"folder_path",val:": Union[str, Path]"},{name:"path_in_repo",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"},{name:"allow_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"ignore_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"delete_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"run_as_future",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.upload_folder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to which the file will be uploaded, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.upload_folder.folder_path",description:`<strong>folder_path</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to the folder to upload on the local file system`,name:"folder_path"},{anchor:"huggingface_hub.HfApi.upload_folder.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Relative path of the directory in the repo, for example:
<code>&quot;checkpoints/1fec34a/results&quot;</code>. Will default to the root folder of the repository.`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.upload_folder.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.upload_folder.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.upload_folder.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.upload_folder.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit. Defaults to:
<code>f&quot;Upload {path_in_repo} with huggingface_hub&quot;</code>`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.upload_folder.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.upload_folder.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>. If <code>revision</code> is not
set, PR is opened against the <code>&quot;main&quot;</code> branch. If <code>revision</code> is set and is a branch, PR is opened
against this branch. If <code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.upload_folder.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"},{anchor:"huggingface_hub.HfApi.upload_folder.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are uploaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.HfApi.upload_folder.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not uploaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.HfApi.upload_folder.delete_patterns",description:`<strong>delete_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, remote files matching any of the patterns will be deleted from the repo while committing
new files. This is useful if you don&#x2019;t know which files have already been uploaded.
Note: to avoid discrepancies the <code>.gitattributes</code> file is not deleted even if it matches the pattern.`,name:"delete_patterns"},{anchor:"huggingface_hub.HfApi.upload_folder.run_as_future",description:`<strong>run_as_future</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to run this method in the background. Background jobs are run sequentially without
blocking the main thread. Passing <code>run_as_future=True</code> will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow">Future</a>
object. Defaults to <code>False</code>.`,name:"run_as_future"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4790",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Instance of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> containing information about the newly created commit (commit hash, commit
url, pr url, commit message,…). If <code>run_as_future=True</code> is passed, returns a Future object which will
contain the result when executed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> or <code>Future</code></p>
`}}),cr=new I({props:{$$slots:{default:[o4]},$$scope:{ctx:T}}}),lr=new I({props:{warning:!0,$$slots:{default:[a4]},$$scope:{ctx:T}}}),pr=new I({props:{$$slots:{default:[s4]},$$scope:{ctx:T}}}),dr=new C({props:{anchor:"huggingface_hub.HfApi.upload_folder.example",$$slots:{default:[r4]},$$scope:{ctx:T}}}),Xc=new q({props:{name:"upload_large_folder",anchor:"huggingface_hub.HfApi.upload_large_folder",parameters:[{name:"repo_id",val:": str"},{name:"folder_path",val:": Union[str, Path]"},{name:"repo_type",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"private",val:": Optional[bool] = None"},{name:"allow_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"ignore_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"num_workers",val:": Optional[int] = None"},{name:"print_report",val:": bool = True"},{name:"print_report_every",val:": int = 60"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.upload_large_folder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to which the file will be uploaded.
E.g. <code>&quot;HuggingFaceTB/smollm-corpus&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.upload_large_folder.folder_path",description:`<strong>folder_path</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to the folder to upload on the local file system.`,name:"folder_path"},{anchor:"huggingface_hub.HfApi.upload_large_folder.repo_type",description:`<strong>repo_type</strong> (<code>str</code>) &#x2014;
Type of the repository. Must be one of <code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>.
Unlike in all other <code>HfApi</code> methods, <code>repo_type</code> is explicitly required here. This is to avoid
any mistake when uploading a large folder to the Hub, and therefore prevent from having to re-upload
everything.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.upload_large_folder.revision",description:`<strong>revision</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The branch to commit to. If not provided, the <code>main</code> branch will be used.`,name:"revision"},{anchor:"huggingface_hub.HfApi.upload_large_folder.private",description:`<strong>private</strong> (<code>bool</code>, <code>optional</code>) &#x2014;
Whether the repository should be private.
If <code>None</code> (default), the repo will be public unless the organization&#x2019;s default is private.`,name:"private"},{anchor:"huggingface_hub.HfApi.upload_large_folder.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are uploaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.HfApi.upload_large_folder.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not uploaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.HfApi.upload_large_folder.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of workers to start. Defaults to <code>os.cpu_count() - 2</code> (minimum 2).
A higher number of workers may speed up the process if your machine allows it. However, on machines with a
slower connection, it is recommended to keep the number of workers low to ensure better resumability.
Indeed, partially uploaded files will have to be completely re-uploaded if the process is interrupted.`,name:"num_workers"},{anchor:"huggingface_hub.HfApi.upload_large_folder.print_report",description:`<strong>print_report</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to print a report of the upload progress. Defaults to True.
Report is printed to <code>sys.stdout</code> every X seconds (60 by defaults) and overwrites the previous report.`,name:"print_report"},{anchor:"huggingface_hub.HfApi.upload_large_folder.print_report_every",description:`<strong>print_report_every</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Frequency at which the report is printed. Defaults to 60 seconds.`,name:"print_report_every"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5257"}}),gr=new I({props:{$$slots:{default:[i4]},$$scope:{ctx:T}}}),ur=new I({props:{warning:!0,$$slots:{default:[c4]},$$scope:{ctx:T}}}),zc=new q({props:{name:"whoami",anchor:"huggingface_hub.HfApi.whoami",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.whoami.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1763"}}),Qc=new A({props:{title:"API Dataclasses",local:"api-dataclasses",headingTag:"h2"}}),Oc=new A({props:{title:"AccessRequest",local:"huggingface_hub.hf_api.AccessRequest",headingTag:"h3"}}),Kc=new q({props:{name:"class huggingface_hub.hf_api.AccessRequest",anchor:"huggingface_hub.hf_api.AccessRequest",parameters:[{name:"username",val:": str"},{name:"fullname",val:": str"},{name:"email",val:": Optional[str]"},{name:"timestamp",val:": datetime"},{name:"status",val:": Literal['pending', 'accepted', 'rejected']"},{name:"fields",val:": Optional[Dict[str, Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.hf_api.AccessRequest.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user who requested access.`,name:"username"},{anchor:"huggingface_hub.hf_api.AccessRequest.fullname",description:`<strong>fullname</strong> (<code>str</code>) &#x2014;
Fullname of the user who requested access.`,name:"fullname"},{anchor:"huggingface_hub.hf_api.AccessRequest.email",description:`<strong>email</strong> (<code>Optional[str]</code>) &#x2014;
Email of the user who requested access.
Can only be <code>None</code> in the /accepted list if the user was granted access manually.`,name:"email"},{anchor:"huggingface_hub.hf_api.AccessRequest.timestamp",description:`<strong>timestamp</strong> (<code>datetime</code>) &#x2014;
Timestamp of the request.`,name:"timestamp"},{anchor:"huggingface_hub.hf_api.AccessRequest.status",description:`<strong>status</strong> (<code>Literal[&quot;pending&quot;, &quot;accepted&quot;, &quot;rejected&quot;]</code>) &#x2014;
Status of the request. Can be one of <code>[&quot;pending&quot;, &quot;accepted&quot;, &quot;rejected&quot;]</code>.`,name:"status"},{anchor:"huggingface_hub.hf_api.AccessRequest.fields",description:`<strong>fields</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional fields filled by the user in the gate form.`,name:"fields"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L465"}}),el=new A({props:{title:"CommitInfo",local:"huggingface_hub.CommitInfo",headingTag:"h3"}}),tl=new q({props:{name:"class huggingface_hub.CommitInfo",anchor:"huggingface_hub.CommitInfo",parameters:[{name:"*args",val:""},{name:"commit_url",val:": str"},{name:"_url",val:": Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.CommitInfo.commit_url",description:`<strong>commit_url</strong> (<code>str</code>) &#x2014;
Url where to find the commit.`,name:"commit_url"},{anchor:"huggingface_hub.CommitInfo.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
The summary (first line) of the commit that has been created.`,name:"commit_message"},{anchor:"huggingface_hub.CommitInfo.commit_description",description:`<strong>commit_description</strong> (<code>str</code>) &#x2014;
Description of the commit that has been created. Can be empty.`,name:"commit_description"},{anchor:"huggingface_hub.CommitInfo.oid",description:`<strong>oid</strong> (<code>str</code>) &#x2014;
Commit hash id. Example: <code>&quot;91c54ad1727ee830252e457677f467be0bfd8a57&quot;</code>.`,name:"oid"},{anchor:"huggingface_hub.CommitInfo.pr_url",description:`<strong>pr_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Url to the PR that has been created, if any. Populated when <code>create_pr=True</code>
is passed.`,name:"pr_url"},{anchor:"huggingface_hub.CommitInfo.pr_revision",description:`<strong>pr_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision of the PR that has been created, if any. Populated when
<code>create_pr=True</code> is passed. Example: <code>&quot;refs/pr/1&quot;</code>.`,name:"pr_revision"},{anchor:"huggingface_hub.CommitInfo.pr_num",description:`<strong>pr_num</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of the PR discussion that has been created, if any. Populated when
<code>create_pr=True</code> is passed. Can be passed as <code>discussion_num</code> in
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_discussion_details">get_discussion_details()</a>. Example: <code>1</code>.`,name:"pr_num"},{anchor:"huggingface_hub.CommitInfo.repo_url",description:`<strong>repo_url</strong> (<code>RepoUrl</code>) &#x2014;
Repo URL of the commit containing info like repo_id, repo_type, etc.`,name:"repo_url"},{anchor:"huggingface_hub.CommitInfo._url",description:`<strong>_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Legacy url for <code>str</code> compatibility. Can be the url to the uploaded file on the Hub (if returned by
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>), to the uploaded folder on the Hub (if returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>) or to the commit on
the Hub (if returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>). Defaults to <code>commit_url</code>. It is deprecated to use this
attribute. Please use <code>commit_url</code> instead.`,name:"_url"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L385"}}),nl=new A({props:{title:"DatasetInfo",local:"huggingface_hub.DatasetInfo",headingTag:"h3"}}),ol=new q({props:{name:"class huggingface_hub.DatasetInfo",anchor:"huggingface_hub.DatasetInfo",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.DatasetInfo.id",description:`<strong>id</strong> (<code>str</code>) &#x2014;
ID of dataset.`,name:"id"},{anchor:"huggingface_hub.DatasetInfo.author",description:`<strong>author</strong> (<code>str</code>) &#x2014;
Author of the dataset.`,name:"author"},{anchor:"huggingface_hub.DatasetInfo.sha",description:`<strong>sha</strong> (<code>str</code>) &#x2014;
Repo SHA at this particular revision.`,name:"sha"},{anchor:"huggingface_hub.DatasetInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of creation of the repo on the Hub. Note that the lowest value is <code>2022-03-02T23:29:04.000Z</code>,
corresponding to the date when we began to store creation dates.`,name:"created_at"},{anchor:"huggingface_hub.DatasetInfo.last_modified",description:`<strong>last_modified</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of last commit to the repo.`,name:"last_modified"},{anchor:"huggingface_hub.DatasetInfo.private",description:`<strong>private</strong> (<code>bool</code>) &#x2014;
Is the repo private.`,name:"private"},{anchor:"huggingface_hub.DatasetInfo.disabled",description:`<strong>disabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Is the repo disabled.`,name:"disabled"},{anchor:"huggingface_hub.DatasetInfo.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
Is the repo gated.
If so, whether there is manual or automatic approval.`,name:"gated"},{anchor:"huggingface_hub.DatasetInfo.downloads",description:`<strong>downloads</strong> (<code>int</code>) &#x2014;
Number of downloads of the dataset over the last 30 days.`,name:"downloads"},{anchor:"huggingface_hub.DatasetInfo.downloads_all_time",description:`<strong>downloads_all_time</strong> (<code>int</code>) &#x2014;
Cumulated number of downloads of the model since its creation.`,name:"downloads_all_time"},{anchor:"huggingface_hub.DatasetInfo.likes",description:`<strong>likes</strong> (<code>int</code>) &#x2014;
Number of likes of the dataset.`,name:"likes"},{anchor:"huggingface_hub.DatasetInfo.tags",description:`<strong>tags</strong> (<code>List[str]</code>) &#x2014;
List of tags of the dataset.`,name:"tags"},{anchor:"huggingface_hub.DatasetInfo.card_data",description:`<strong>card_data</strong> (<code>DatasetCardData</code>, <em>optional</em>) &#x2014;
Model Card Metadata  as a <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.DatasetCardData">huggingface_hub.repocard_data.DatasetCardData</a> object.`,name:"card_data"},{anchor:"huggingface_hub.DatasetInfo.siblings",description:`<strong>siblings</strong> (<code>List[RepoSibling]</code>) &#x2014;
List of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.hf_api.RepoSibling">huggingface_hub.hf_api.RepoSibling</a> objects that constitute the dataset.`,name:"siblings"},{anchor:"huggingface_hub.DatasetInfo.paperswithcode_id",description:`<strong>paperswithcode_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Papers with code ID of the dataset.`,name:"paperswithcode_id"},{anchor:"huggingface_hub.DatasetInfo.trending_score",description:`<strong>trending_score</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Trending score of the dataset.`,name:"trending_score"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L946"}}),fr=new I({props:{$$slots:{default:[l4]},$$scope:{ctx:T}}}),al=new A({props:{title:"GitRefInfo",local:"huggingface_hub.GitRefInfo",headingTag:"h3"}}),sl=new q({props:{name:"class huggingface_hub.GitRefInfo",anchor:"huggingface_hub.GitRefInfo",parameters:[{name:"name",val:": str"},{name:"ref",val:": str"},{name:"target_commit",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.GitRefInfo.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
Name of the reference (e.g. tag name or branch name).`,name:"name"},{anchor:"huggingface_hub.GitRefInfo.ref",description:`<strong>ref</strong> (<code>str</code>) &#x2014;
Full git ref on the Hub (e.g. <code>&quot;refs/heads/main&quot;</code> or <code>&quot;refs/tags/v1.0&quot;</code>).`,name:"ref"},{anchor:"huggingface_hub.GitRefInfo.target_commit",description:`<strong>target_commit</strong> (<code>str</code>) &#x2014;
OID of the target commit for the ref (e.g. <code>&quot;e7da7f221d5bf496a48136c0cd264e630fe9fcc8&quot;</code>)`,name:"target_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1304"}}),rl=new A({props:{title:"GitCommitInfo",local:"huggingface_hub.GitCommitInfo",headingTag:"h3"}}),il=new q({props:{name:"class huggingface_hub.GitCommitInfo",anchor:"huggingface_hub.GitCommitInfo",parameters:[{name:"commit_id",val:": str"},{name:"authors",val:": List[str]"},{name:"created_at",val:": datetime"},{name:"title",val:": str"},{name:"message",val:": str"},{name:"formatted_title",val:": Optional[str]"},{name:"formatted_message",val:": Optional[str]"}],parametersDescription:[{anchor:"huggingface_hub.GitCommitInfo.commit_id",description:`<strong>commit_id</strong> (<code>str</code>) &#x2014;
OID of the commit (e.g. <code>&quot;e7da7f221d5bf496a48136c0cd264e630fe9fcc8&quot;</code>)`,name:"commit_id"},{anchor:"huggingface_hub.GitCommitInfo.authors",description:`<strong>authors</strong> (<code>List[str]</code>) &#x2014;
List of authors of the commit.`,name:"authors"},{anchor:"huggingface_hub.GitCommitInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>) &#x2014;
Datetime when the commit was created.`,name:"created_at"},{anchor:"huggingface_hub.GitCommitInfo.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
Title of the commit. This is a free-text value entered by the authors.`,name:"title"},{anchor:"huggingface_hub.GitCommitInfo.message",description:`<strong>message</strong> (<code>str</code>) &#x2014;
Description of the commit. This is a free-text value entered by the authors.`,name:"message"},{anchor:"huggingface_hub.GitCommitInfo.formatted_title",description:`<strong>formatted_title</strong> (<code>str</code>) &#x2014;
Title of the commit formatted as HTML. Only returned if <code>formatted=True</code> is set.`,name:"formatted_title"},{anchor:"huggingface_hub.GitCommitInfo.formatted_message",description:`<strong>formatted_message</strong> (<code>str</code>) &#x2014;
Description of the commit formatted as HTML. Only returned if <code>formatted=True</code> is set.`,name:"formatted_message"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1349"}}),cl=new A({props:{title:"GitRefs",local:"huggingface_hub.GitRefs",headingTag:"h3"}}),ll=new q({props:{name:"class huggingface_hub.GitRefs",anchor:"huggingface_hub.GitRefs",parameters:[{name:"branches",val:": List[GitRefInfo]"},{name:"converts",val:": List[GitRefInfo]"},{name:"tags",val:": List[GitRefInfo]"},{name:"pull_requests",val:": Optional[List[GitRefInfo]] = None"}],parametersDescription:[{anchor:"huggingface_hub.GitRefs.branches",description:`<strong>branches</strong> (<code>List[GitRefInfo]</code>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about branches on the repo.`,name:"branches"},{anchor:"huggingface_hub.GitRefs.converts",description:`<strong>converts</strong> (<code>List[GitRefInfo]</code>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about &#x201C;convert&#x201D; refs on the repo.
Converts are refs used (internally) to push preprocessed data in Dataset repos.`,name:"converts"},{anchor:"huggingface_hub.GitRefs.tags",description:`<strong>tags</strong> (<code>List[GitRefInfo]</code>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about tags on the repo.`,name:"tags"},{anchor:"huggingface_hub.GitRefs.pull_requests",description:`<strong>pull_requests</strong> (<code>List[GitRefInfo]</code>, <em>optional</em>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about pull requests on the repo.
Only returned if <code>include_prs=True</code> is set.`,name:"pull_requests"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1323"}}),pl=new A({props:{title:"InferenceProviderMapping",local:"huggingface_hub.hf_api.InferenceProviderMapping",headingTag:"h3"}}),gl=new q({props:{name:"class huggingface_hub.hf_api.InferenceProviderMapping",anchor:"huggingface_hub.hf_api.InferenceProviderMapping",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L722"}}),ul=new A({props:{title:"LFSFileInfo",local:"huggingface_hub.hf_api.LFSFileInfo",headingTag:"h3"}}),hl=new q({props:{name:"class huggingface_hub.hf_api.LFSFileInfo",anchor:"huggingface_hub.hf_api.LFSFileInfo",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.hf_api.LFSFileInfo.file_oid",description:`<strong>file_oid</strong> (<code>str</code>) &#x2014;
SHA-256 object ID of the file. This is the identifier to pass when permanently deleting the file.`,name:"file_oid"},{anchor:"huggingface_hub.hf_api.LFSFileInfo.filename",description:`<strong>filename</strong> (<code>str</code>) &#x2014;
Possible filename for the LFS object. See the note above for more information.`,name:"filename"},{anchor:"huggingface_hub.hf_api.LFSFileInfo.oid",description:`<strong>oid</strong> (<code>str</code>) &#x2014;
OID of the LFS object.`,name:"oid"},{anchor:"huggingface_hub.hf_api.LFSFileInfo.pushed_at",description:`<strong>pushed_at</strong> (<code>datetime</code>) &#x2014;
Date the LFS object was pushed to the repo.`,name:"pushed_at"},{anchor:"huggingface_hub.hf_api.LFSFileInfo.ref",description:`<strong>ref</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Ref where the LFS object has been pushed (if any).`,name:"ref"},{anchor:"huggingface_hub.hf_api.LFSFileInfo.size",description:`<strong>size</strong> (<code>int</code>) &#x2014;
Size of the LFS object.`,name:"size"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1582"}}),mr=new C({props:{anchor:"huggingface_hub.hf_api.LFSFileInfo.example",$$slots:{default:[p4]},$$scope:{ctx:T}}}),fl=new A({props:{title:"ModelInfo",local:"huggingface_hub.ModelInfo",headingTag:"h3"}}),ml=new q({props:{name:"class huggingface_hub.ModelInfo",anchor:"huggingface_hub.ModelInfo",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelInfo.id",description:`<strong>id</strong> (<code>str</code>) &#x2014;
ID of model.`,name:"id"},{anchor:"huggingface_hub.ModelInfo.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Author of the model.`,name:"author"},{anchor:"huggingface_hub.ModelInfo.sha",description:`<strong>sha</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Repo SHA at this particular revision.`,name:"sha"},{anchor:"huggingface_hub.ModelInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of creation of the repo on the Hub. Note that the lowest value is <code>2022-03-02T23:29:04.000Z</code>,
corresponding to the date when we began to store creation dates.`,name:"created_at"},{anchor:"huggingface_hub.ModelInfo.last_modified",description:`<strong>last_modified</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of last commit to the repo.`,name:"last_modified"},{anchor:"huggingface_hub.ModelInfo.private",description:`<strong>private</strong> (<code>bool</code>) &#x2014;
Is the repo private.`,name:"private"},{anchor:"huggingface_hub.ModelInfo.disabled",description:`<strong>disabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Is the repo disabled.`,name:"disabled"},{anchor:"huggingface_hub.ModelInfo.downloads",description:`<strong>downloads</strong> (<code>int</code>) &#x2014;
Number of downloads of the model over the last 30 days.`,name:"downloads"},{anchor:"huggingface_hub.ModelInfo.downloads_all_time",description:`<strong>downloads_all_time</strong> (<code>int</code>) &#x2014;
Cumulated number of downloads of the model since its creation.`,name:"downloads_all_time"},{anchor:"huggingface_hub.ModelInfo.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
Is the repo gated.
If so, whether there is manual or automatic approval.`,name:"gated"},{anchor:"huggingface_hub.ModelInfo.gguf",description:`<strong>gguf</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
GGUF information of the model.`,name:"gguf"},{anchor:"huggingface_hub.ModelInfo.inference",description:`<strong>inference</strong> (<code>Literal[&quot;warm&quot;]</code>, <em>optional</em>) &#x2014;
Status of the model on Inference Providers. Warm if the model is served by at least one provider.`,name:"inference"},{anchor:"huggingface_hub.ModelInfo.inference_provider_mapping",description:`<strong>inference_provider_mapping</strong> (<code>List[InferenceProviderMapping]</code>, <em>optional</em>) &#x2014;
A list of <code>InferenceProviderMapping</code> ordered after the user&#x2019;s provider order.`,name:"inference_provider_mapping"},{anchor:"huggingface_hub.ModelInfo.likes",description:`<strong>likes</strong> (<code>int</code>) &#x2014;
Number of likes of the model.`,name:"likes"},{anchor:"huggingface_hub.ModelInfo.library_name",description:`<strong>library_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Library associated with the model.`,name:"library_name"},{anchor:"huggingface_hub.ModelInfo.tags",description:`<strong>tags</strong> (<code>List[str]</code>) &#x2014;
List of tags of the model. Compared to <code>card_data.tags</code>, contains extra tags computed by the Hub
(e.g. supported libraries, model&#x2019;s arXiv).`,name:"tags"},{anchor:"huggingface_hub.ModelInfo.pipeline_tag",description:`<strong>pipeline_tag</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pipeline tag associated with the model.`,name:"pipeline_tag"},{anchor:"huggingface_hub.ModelInfo.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mask token used by the model.`,name:"mask_token"},{anchor:"huggingface_hub.ModelInfo.widget_data",description:`<strong>widget_data</strong> (<code>Any</code>, <em>optional</em>) &#x2014;
Widget data associated with the model.`,name:"widget_data"},{anchor:"huggingface_hub.ModelInfo.model_index",description:`<strong>model_index</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Model index for evaluation.`,name:"model_index"},{anchor:"huggingface_hub.ModelInfo.config",description:`<strong>config</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Model configuration.`,name:"config"},{anchor:"huggingface_hub.ModelInfo.transformers_info",description:`<strong>transformers_info</strong> (<code>TransformersInfo</code>, <em>optional</em>) &#x2014;
Transformers-specific info (auto class, processor, etc.) associated with the model.`,name:"transformers_info"},{anchor:"huggingface_hub.ModelInfo.trending_score",description:`<strong>trending_score</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Trending score of the model.`,name:"trending_score"},{anchor:"huggingface_hub.ModelInfo.card_data",description:`<strong>card_data</strong> (<code>ModelCardData</code>, <em>optional</em>) &#x2014;
Model Card Metadata  as a <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.ModelCardData">huggingface_hub.repocard_data.ModelCardData</a> object.`,name:"card_data"},{anchor:"huggingface_hub.ModelInfo.siblings",description:`<strong>siblings</strong> (<code>List[RepoSibling]</code>) &#x2014;
List of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.hf_api.RepoSibling">huggingface_hub.hf_api.RepoSibling</a> objects that constitute the model.`,name:"siblings"},{anchor:"huggingface_hub.ModelInfo.spaces",description:`<strong>spaces</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of spaces using the model.`,name:"spaces"},{anchor:"huggingface_hub.ModelInfo.safetensors",description:`<strong>safetensors</strong> (<code>SafeTensorsInfo</code>, <em>optional</em>) &#x2014;
Model&#x2019;s safetensors information.`,name:"safetensors"},{anchor:"huggingface_hub.ModelInfo.security_repo_status",description:`<strong>security_repo_status</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Model&#x2019;s security scan status.`,name:"security_repo_status"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L747"}}),_r=new I({props:{$$slots:{default:[d4]},$$scope:{ctx:T}}}),_l=new A({props:{title:"RepoSibling",local:"huggingface_hub.hf_api.RepoSibling",headingTag:"h3"}}),bl=new q({props:{name:"class huggingface_hub.hf_api.RepoSibling",anchor:"huggingface_hub.hf_api.RepoSibling",parameters:[{name:"rfilename",val:": str"},{name:"size",val:": Optional[int] = None"},{name:"blob_id",val:": Optional[str] = None"},{name:"lfs",val:": Optional[BlobLfsInfo] = None"}],parametersDescription:[{anchor:"huggingface_hub.hf_api.RepoSibling.rfilename",description:`<strong>rfilename</strong> (str) &#x2014;
file name, relative to the repo root.`,name:"rfilename"},{anchor:"huggingface_hub.hf_api.RepoSibling.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The file&#x2019;s size, in bytes. This attribute is defined when <code>files_metadata</code> argument of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.repo_info">repo_info()</a> is set
to <code>True</code>. It&#x2019;s <code>None</code> otherwise.`,name:"size"},{anchor:"huggingface_hub.hf_api.RepoSibling.blob_id",description:`<strong>blob_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The file&#x2019;s git OID. This attribute is defined when <code>files_metadata</code> argument of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.repo_info">repo_info()</a> is set to
<code>True</code>. It&#x2019;s <code>None</code> otherwise.`,name:"blob_id"},{anchor:"huggingface_hub.hf_api.RepoSibling.lfs",description:`<strong>lfs</strong> (<code>BlobLfsInfo</code>, <em>optional</em>) &#x2014;
The file&#x2019;s LFS metadata. This attribute is defined when<code>files_metadata</code> argument of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.repo_info">repo_info()</a> is set to
<code>True</code> and the file is stored with Git LFS. It&#x2019;s <code>None</code> otherwise.`,name:"lfs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L598"}}),br=new I({props:{$$slots:{default:[g4]},$$scope:{ctx:T}}}),yl=new A({props:{title:"RepoFile",local:"huggingface_hub.hf_api.RepoFile",headingTag:"h3"}}),vl=new q({props:{name:"class huggingface_hub.hf_api.RepoFile",anchor:"huggingface_hub.hf_api.RepoFile",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.hf_api.RepoFile.path",description:`<strong>path</strong> (str) &#x2014;
file path relative to the repo root.`,name:"path"},{anchor:"huggingface_hub.hf_api.RepoFile.size",description:`<strong>size</strong> (<code>int</code>) &#x2014;
The file&#x2019;s size, in bytes.`,name:"size"},{anchor:"huggingface_hub.hf_api.RepoFile.blob_id",description:`<strong>blob_id</strong> (<code>str</code>) &#x2014;
The file&#x2019;s git OID.`,name:"blob_id"},{anchor:"huggingface_hub.hf_api.RepoFile.lfs",description:`<strong>lfs</strong> (<code>BlobLfsInfo</code>) &#x2014;
The file&#x2019;s LFS metadata.`,name:"lfs"},{anchor:"huggingface_hub.hf_api.RepoFile.last_commit",description:`<strong>last_commit</strong> (<code>LastCommitInfo</code>, <em>optional</em>) &#x2014;
The file&#x2019;s last commit metadata. Only defined if <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_repo_tree">list_repo_tree()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_paths_info">get_paths_info()</a>
are called with <code>expand=True</code>.`,name:"last_commit"},{anchor:"huggingface_hub.hf_api.RepoFile.security",description:`<strong>security</strong> (<code>BlobSecurityInfo</code>, <em>optional</em>) &#x2014;
The file&#x2019;s security scan metadata. Only defined if <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_repo_tree">list_repo_tree()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_paths_info">get_paths_info()</a>
are called with <code>expand=True</code>.`,name:"security"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L633"}}),xl=new A({props:{title:"RepoUrl",local:"huggingface_hub.RepoUrl",headingTag:"h3"}}),$l=new q({props:{name:"class huggingface_hub.RepoUrl",anchor:"huggingface_hub.RepoUrl",parameters:[{name:"url",val:": Any"},{name:"endpoint",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.RepoUrl.url",description:`<strong>url</strong> (<code>Any</code>) &#x2014;
String value of the repo url.`,name:"url"},{anchor:"huggingface_hub.RepoUrl.endpoint",description:`<strong>endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Endpoint of the Hub. Defaults to <a href="https://huggingface.co" rel="nofollow">https://huggingface.co</a>.`,name:"endpoint"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L536",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If URL cannot be parsed.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>repo_type</code> is unknown.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),yr=new C({props:{anchor:"huggingface_hub.RepoUrl.example",$$slots:{default:[u4]},$$scope:{ctx:T}}}),wl=new A({props:{title:"SafetensorsRepoMetadata",local:"huggingface_hub.utils.SafetensorsRepoMetadata",headingTag:"h3"}}),kl=new q({props:{name:"class huggingface_hub.utils.SafetensorsRepoMetadata",anchor:"huggingface_hub.utils.SafetensorsRepoMetadata",parameters:[{name:"metadata",val:": typing.Optional[typing.Dict]"},{name:"sharded",val:": bool"},{name:"weight_map",val:": typing.Dict[str, str]"},{name:"files_metadata",val:": typing.Dict[str, huggingface_hub.utils._safetensors.SafetensorsFileMetadata]"}],parametersDescription:[{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.metadata",description:`<strong>metadata</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
The metadata contained in the &#x2018;model.safetensors.index.json&#x2019; file, if it exists. Only populated for sharded
models.`,name:"metadata"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.sharded",description:`<strong>sharded</strong> (<code>bool</code>) &#x2014;
Whether the repo contains a sharded model or not.`,name:"sharded"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.weight_map",description:`<strong>weight_map</strong> (<code>Dict[str, str]</code>) &#x2014;
A map of all weights. Keys are tensor names and values are filenames of the files containing the tensors.`,name:"weight_map"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.files_metadata",description:`<strong>files_metadata</strong> (<code>Dict[str, SafetensorsFileMetadata]</code>) &#x2014;
A map of all files metadata. Keys are filenames and values are the metadata of the corresponding file, as
a <code>SafetensorsFileMetadata</code> object.`,name:"files_metadata"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.parameter_count",description:`<strong>parameter_count</strong> (<code>Dict[str, int]</code>) &#x2014;
A map of the number of parameters per data type. Keys are data types and values are the number of parameters
of that data type.`,name:"parameter_count"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_safetensors.py#L74"}}),Tl=new A({props:{title:"SafetensorsFileMetadata",local:"huggingface_hub.utils.SafetensorsFileMetadata",headingTag:"h3"}}),jl=new q({props:{name:"class huggingface_hub.utils.SafetensorsFileMetadata",anchor:"huggingface_hub.utils.SafetensorsFileMetadata",parameters:[{name:"metadata",val:": typing.Dict[str, str]"},{name:"tensors",val:": typing.Dict[str, huggingface_hub.utils._safetensors.TensorInfo]"}],parametersDescription:[{anchor:"huggingface_hub.utils.SafetensorsFileMetadata.metadata",description:`<strong>metadata</strong> (<code>Dict</code>) &#x2014;
The metadata contained in the file.`,name:"metadata"},{anchor:"huggingface_hub.utils.SafetensorsFileMetadata.tensors",description:`<strong>tensors</strong> (<code>Dict[str, TensorInfo]</code>) &#x2014;
A map of all tensors. Keys are tensor names and values are information about the corresponding tensor, as a
<code>TensorInfo</code> object.`,name:"tensors"},{anchor:"huggingface_hub.utils.SafetensorsFileMetadata.parameter_count",description:`<strong>parameter_count</strong> (<code>Dict[str, int]</code>) &#x2014;
A map of the number of parameters per data type. Keys are data types and values are the number of parameters
of that data type.`,name:"parameter_count"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_safetensors.py#L44"}}),Ml=new A({props:{title:"SpaceInfo",local:"huggingface_hub.SpaceInfo",headingTag:"h3"}}),ql=new q({props:{name:"class huggingface_hub.SpaceInfo",anchor:"huggingface_hub.SpaceInfo",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.SpaceInfo.id",description:`<strong>id</strong> (<code>str</code>) &#x2014;
ID of the Space.`,name:"id"},{anchor:"huggingface_hub.SpaceInfo.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Author of the Space.`,name:"author"},{anchor:"huggingface_hub.SpaceInfo.sha",description:`<strong>sha</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Repo SHA at this particular revision.`,name:"sha"},{anchor:"huggingface_hub.SpaceInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of creation of the repo on the Hub. Note that the lowest value is <code>2022-03-02T23:29:04.000Z</code>,
corresponding to the date when we began to store creation dates.`,name:"created_at"},{anchor:"huggingface_hub.SpaceInfo.last_modified",description:`<strong>last_modified</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of last commit to the repo.`,name:"last_modified"},{anchor:"huggingface_hub.SpaceInfo.private",description:`<strong>private</strong> (<code>bool</code>) &#x2014;
Is the repo private.`,name:"private"},{anchor:"huggingface_hub.SpaceInfo.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
Is the repo gated.
If so, whether there is manual or automatic approval.`,name:"gated"},{anchor:"huggingface_hub.SpaceInfo.disabled",description:`<strong>disabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Is the Space disabled.`,name:"disabled"},{anchor:"huggingface_hub.SpaceInfo.host",description:`<strong>host</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Host URL of the Space.`,name:"host"},{anchor:"huggingface_hub.SpaceInfo.subdomain",description:`<strong>subdomain</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Subdomain of the Space.`,name:"subdomain"},{anchor:"huggingface_hub.SpaceInfo.likes",description:`<strong>likes</strong> (<code>int</code>) &#x2014;
Number of likes of the Space.`,name:"likes"},{anchor:"huggingface_hub.SpaceInfo.tags",description:`<strong>tags</strong> (<code>List[str]</code>) &#x2014;
List of tags of the Space.`,name:"tags"},{anchor:"huggingface_hub.SpaceInfo.siblings",description:`<strong>siblings</strong> (<code>List[RepoSibling]</code>) &#x2014;
List of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.hf_api.RepoSibling">huggingface_hub.hf_api.RepoSibling</a> objects that constitute the Space.`,name:"siblings"},{anchor:"huggingface_hub.SpaceInfo.card_data",description:`<strong>card_data</strong> (<code>SpaceCardData</code>, <em>optional</em>) &#x2014;
Space Card Metadata  as a <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.SpaceCardData">huggingface_hub.repocard_data.SpaceCardData</a> object.`,name:"card_data"},{anchor:"huggingface_hub.SpaceInfo.runtime",description:`<strong>runtime</strong> (<code>SpaceRuntime</code>, <em>optional</em>) &#x2014;
Space runtime information as a <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceRuntime">huggingface_hub.hf_api.SpaceRuntime</a> object.`,name:"runtime"},{anchor:"huggingface_hub.SpaceInfo.sdk",description:`<strong>sdk</strong> (<code>str</code>, <em>optional</em>) &#x2014;
SDK used by the Space.`,name:"sdk"},{anchor:"huggingface_hub.SpaceInfo.models",description:`<strong>models</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of models used by the Space.`,name:"models"},{anchor:"huggingface_hub.SpaceInfo.datasets",description:`<strong>datasets</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of datasets used by the Space.`,name:"datasets"},{anchor:"huggingface_hub.SpaceInfo.trending_score",description:`<strong>trending_score</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Trending score of the Space.`,name:"trending_score"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1065"}}),vr=new I({props:{$$slots:{default:[h4]},$$scope:{ctx:T}}}),Hl=new A({props:{title:"TensorInfo",local:"huggingface_hub.utils.TensorInfo",headingTag:"h3"}}),Ul=new q({props:{name:"class huggingface_hub.utils.TensorInfo",anchor:"huggingface_hub.utils.TensorInfo",parameters:[{name:"dtype",val:": typing.Literal['F64', 'F32', 'F16', 'BF16', 'I64', 'I32', 'I16', 'I8', 'U8', 'BOOL']"},{name:"shape",val:": typing.List[int]"},{name:"data_offsets",val:": typing.Tuple[int, int]"}],parametersDescription:[{anchor:"huggingface_hub.utils.TensorInfo.dtype",description:`<strong>dtype</strong> (<code>str</code>) &#x2014;
The data type of the tensor (&#x201C;F64&#x201D;, &#x201C;F32&#x201D;, &#x201C;F16&#x201D;, &#x201C;BF16&#x201D;, &#x201C;I64&#x201D;, &#x201C;I32&#x201D;, &#x201C;I16&#x201D;, &#x201C;I8&#x201D;, &#x201C;U8&#x201D;, &#x201C;BOOL&#x201D;).`,name:"dtype"},{anchor:"huggingface_hub.utils.TensorInfo.shape",description:`<strong>shape</strong> (<code>List[int]</code>) &#x2014;
The shape of the tensor.`,name:"shape"},{anchor:"huggingface_hub.utils.TensorInfo.data_offsets",description:`<strong>data_offsets</strong> (<code>Tuple[int, int]</code>) &#x2014;
The offsets of the data in the file as a tuple <code>[BEGIN, END]</code>.`,name:"data_offsets"},{anchor:"huggingface_hub.utils.TensorInfo.parameter_count",description:`<strong>parameter_count</strong> (<code>int</code>) &#x2014;
The number of parameters in the tensor.`,name:"parameter_count"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_safetensors.py#L14"}}),Cl=new A({props:{title:"User",local:"huggingface_hub.User",headingTag:"h3"}}),Il=new q({props:{name:"class huggingface_hub.User",anchor:"huggingface_hub.User",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.User.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Name of the user on the Hub (unique).`,name:"username"},{anchor:"huggingface_hub.User.fullname",description:`<strong>fullname</strong> (<code>str</code>) &#x2014;
User&#x2019;s full name.`,name:"fullname"},{anchor:"huggingface_hub.User.avatar_url",description:`<strong>avatar_url</strong> (<code>str</code>) &#x2014;
URL of the user&#x2019;s avatar.`,name:"avatar_url"},{anchor:"huggingface_hub.User.details",description:`<strong>details</strong> (<code>str</code>, <em>optional</em>) &#x2014;
User&#x2019;s details.`,name:"details"},{anchor:"huggingface_hub.User.is_following",description:`<strong>is_following</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the authenticated user is following this user.`,name:"is_following"},{anchor:"huggingface_hub.User.is_pro",description:`<strong>is_pro</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the user is a pro user.`,name:"is_pro"},{anchor:"huggingface_hub.User.num_models",description:`<strong>num_models</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of models created by the user.`,name:"num_models"},{anchor:"huggingface_hub.User.num_datasets",description:`<strong>num_datasets</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of datasets created by the user.`,name:"num_datasets"},{anchor:"huggingface_hub.User.num_spaces",description:`<strong>num_spaces</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of spaces created by the user.`,name:"num_spaces"},{anchor:"huggingface_hub.User.num_discussions",description:`<strong>num_discussions</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of discussions initiated by the user.`,name:"num_discussions"},{anchor:"huggingface_hub.User.num_papers",description:`<strong>num_papers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of papers authored by the user.`,name:"num_papers"},{anchor:"huggingface_hub.User.num_upvotes",description:`<strong>num_upvotes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of upvotes received by the user.`,name:"num_upvotes"},{anchor:"huggingface_hub.User.num_likes",description:`<strong>num_likes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of likes given by the user.`,name:"num_likes"},{anchor:"huggingface_hub.User.num_following",description:`<strong>num_following</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of users this user is following.`,name:"num_following"},{anchor:"huggingface_hub.User.num_followers",description:`<strong>num_followers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of users following this user.`,name:"num_followers"},{anchor:"huggingface_hub.User.orgs",description:`<strong>orgs</strong> (list of <code>Organization</code>) &#x2014;
List of organizations the user is part of.`,name:"orgs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1437"}}),Jl=new A({props:{title:"UserLikes",local:"huggingface_hub.UserLikes",headingTag:"h3"}}),Nl=new q({props:{name:"class huggingface_hub.UserLikes",anchor:"huggingface_hub.UserLikes",parameters:[{name:"user",val:": str"},{name:"total",val:": int"},{name:"datasets",val:": List[str]"},{name:"models",val:": List[str]"},{name:"spaces",val:": List[str]"}],parametersDescription:[{anchor:"huggingface_hub.UserLikes.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
Name of the user for which we fetched the likes.`,name:"user"},{anchor:"huggingface_hub.UserLikes.total",description:`<strong>total</strong> (<code>int</code>) &#x2014;
Total number of likes.`,name:"total"},{anchor:"huggingface_hub.UserLikes.datasets",description:`<strong>datasets</strong> (<code>List[str]</code>) &#x2014;
List of datasets liked by the user (as repo_ids).`,name:"datasets"},{anchor:"huggingface_hub.UserLikes.models",description:`<strong>models</strong> (<code>List[str]</code>) &#x2014;
List of models liked by the user (as repo_ids).`,name:"models"},{anchor:"huggingface_hub.UserLikes.spaces",description:`<strong>spaces</strong> (<code>List[str]</code>) &#x2014;
List of spaces liked by the user (as repo_ids).`,name:"spaces"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1382"}}),Al=new A({props:{title:"WebhookInfo",local:"huggingface_hub.WebhookInfo",headingTag:"h3"}}),El=new q({props:{name:"class huggingface_hub.WebhookInfo",anchor:"huggingface_hub.WebhookInfo",parameters:[{name:"id",val:": str"},{name:"url",val:": str"},{name:"watched",val:": List[WebhookWatchedItem]"},{name:"domains",val:": List[constants.WEBHOOK_DOMAIN_T]"},{name:"secret",val:": Optional[str]"},{name:"disabled",val:": bool"}],parametersDescription:[{anchor:"huggingface_hub.WebhookInfo.id",description:`<strong>id</strong> (<code>str</code>) &#x2014;
ID of the webhook.`,name:"id"},{anchor:"huggingface_hub.WebhookInfo.url",description:`<strong>url</strong> (<code>str</code>) &#x2014;
URL of the webhook.`,name:"url"},{anchor:"huggingface_hub.WebhookInfo.watched",description:`<strong>watched</strong> (<code>List[WebhookWatchedItem]</code>) &#x2014;
List of items watched by the webhook, see <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.WebhookWatchedItem">WebhookWatchedItem</a>.`,name:"watched"},{anchor:"huggingface_hub.WebhookInfo.domains",description:`<strong>domains</strong> (<code>List[WEBHOOK_DOMAIN_T]</code>) &#x2014;
List of domains the webhook is watching. Can be one of <code>[&quot;repo&quot;, &quot;discussions&quot;]</code>.`,name:"domains"},{anchor:"huggingface_hub.WebhookInfo.secret",description:`<strong>secret</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Secret of the webhook.`,name:"secret"},{anchor:"huggingface_hub.WebhookInfo.disabled",description:`<strong>disabled</strong> (<code>bool</code>) &#x2014;
Whether the webhook is disabled or not.`,name:"disabled"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L510"}}),Dl=new A({props:{title:"WebhookWatchedItem",local:"huggingface_hub.WebhookWatchedItem",headingTag:"h3"}}),Rl=new q({props:{name:"class huggingface_hub.WebhookWatchedItem",anchor:"huggingface_hub.WebhookWatchedItem",parameters:[{name:"type",val:": Literal['dataset', 'model', 'org', 'space', 'user']"},{name:"name",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.WebhookWatchedItem.type",description:`<strong>type</strong> (<code>Literal[&quot;dataset&quot;, &quot;model&quot;, &quot;org&quot;, &quot;space&quot;, &quot;user&quot;]</code>) &#x2014;
Type of the item to be watched. Can be one of <code>[&quot;dataset&quot;, &quot;model&quot;, &quot;org&quot;, &quot;space&quot;, &quot;user&quot;]</code>.`,name:"type"},{anchor:"huggingface_hub.WebhookWatchedItem.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
Name of the item to be watched. Can be the username, organization name, model name, dataset name or space name.`,name:"name"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L495"}}),Gl=new A({props:{title:"CommitOperation",local:"huggingface_hub.CommitOperationAdd",headingTag:"h2"}}),Fl=new q({props:{name:"class huggingface_hub.CommitOperationAdd",anchor:"huggingface_hub.CommitOperationAdd",parameters:[{name:"path_in_repo",val:": str"},{name:"path_or_fileobj",val:": typing.Union[str, pathlib.Path, bytes, typing.BinaryIO]"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationAdd.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example: <code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitOperationAdd.path_or_fileobj",description:`<strong>path_or_fileobj</strong> (<code>str</code>, <code>Path</code>, <code>bytes</code>, or <code>BinaryIO</code>) &#x2014;
Either:<ul>
<li>a path to a local file (as <code>str</code> or <code>pathlib.Path</code>) to upload</li>
<li>a buffer of bytes (<code>bytes</code>) holding the content of the file to upload</li>
<li>a &#x201C;file object&#x201D; (subclass of <code>io.BufferedIOBase</code>), typically obtained
with <code>open(path, &quot;rb&quot;)</code>. It must support <code>seek()</code> and <code>tell()</code> methods.</li>
</ul>`,name:"path_or_fileobj"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L124",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>path_or_fileobj</code> is not one of <code>str</code>, <code>Path</code>, <code>bytes</code> or <code>io.BufferedIOBase</code>.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>path_or_fileobj</code> is a <code>str</code> or <code>Path</code> but not a path to an existing file.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>path_or_fileobj</code> is a <code>io.BufferedIOBase</code> but it doesn’t support both
<code>seek()</code> and <code>tell()</code>.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Sl=new q({props:{name:"as_file",anchor:"huggingface_hub.CommitOperationAdd.as_file",parameters:[{name:"with_tqdm",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationAdd.as_file.with_tqdm",description:`<strong>with_tqdm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True, iterating over the file object will display a progress bar. Only
works if the file-like object is a path to a file. Pure bytes and buffers
are not supported.`,name:"with_tqdm"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L206"}}),xr=new C({props:{anchor:"huggingface_hub.CommitOperationAdd.as_file.example",$$slots:{default:[f4]},$$scope:{ctx:T}}}),Ll=new q({props:{name:"b64content",anchor:"huggingface_hub.CommitOperationAdd.b64content",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L256"}}),Wl=new q({props:{name:"class huggingface_hub.CommitOperationDelete",anchor:"huggingface_hub.CommitOperationDelete",parameters:[{name:"path_in_repo",val:": str"},{name:"is_folder",val:": typing.Union[bool, typing.Literal['auto']] = 'auto'"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationDelete.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example: <code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>
for a file or <code>&quot;checkpoints/1fec34a/&quot;</code> for a folder.`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitOperationDelete.is_folder",description:`<strong>is_folder</strong> (<code>bool</code> or <code>Literal[&quot;auto&quot;]</code>, <em>optional</em>) &#x2014;
Whether the Delete Operation applies to a folder or not. If &#x201C;auto&#x201D;, the path
type (file or folder) is guessed automatically by looking if path ends with
a &#x201D;/&#x201D; (folder) or not (file). To explicitly set the path type, you can set
<code>is_folder=True</code> or <code>is_folder=False</code>.`,name:"is_folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L57"}}),Vl=new q({props:{name:"class huggingface_hub.CommitOperationCopy",anchor:"huggingface_hub.CommitOperationCopy",parameters:[{name:"src_path_in_repo",val:": str"},{name:"path_in_repo",val:": str"},{name:"src_revision",val:": typing.Optional[str] = None"},{name:"_src_oid",val:": typing.Optional[str] = None"},{name:"_dest_oid",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationCopy.src_path_in_repo",description:`<strong>src_path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo of the file to be copied, e.g. <code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>.`,name:"src_path_in_repo"},{anchor:"huggingface_hub.CommitOperationCopy.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo where to copy the file, e.g. <code>&quot;checkpoints/1fec34a/weights_copy.bin&quot;</code>.`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitOperationCopy.src_revision",description:`<strong>src_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision of the file to be copied. Can be any valid git revision.
Default to the target commit revision.`,name:"src_revision"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L88"}}),Bl=new A({props:{title:"CommitScheduler",local:"huggingface_hub.CommitScheduler",headingTag:"h2"}}),Pl=new q({props:{name:"class huggingface_hub.CommitScheduler",anchor:"huggingface_hub.CommitScheduler",parameters:[{name:"repo_id",val:": str"},{name:"folder_path",val:": typing.Union[str, pathlib.Path]"},{name:"every",val:": typing.Union[int, float] = 5"},{name:"path_in_repo",val:": typing.Optional[str] = None"},{name:"repo_type",val:": typing.Optional[str] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"allow_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"ignore_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"squash_history",val:": bool = False"},{name:"hf_api",val:": typing.Optional[ForwardRef('HfApi')] = None"}],parametersDescription:[{anchor:"huggingface_hub.CommitScheduler.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to commit to.`,name:"repo_id"},{anchor:"huggingface_hub.CommitScheduler.folder_path",description:`<strong>folder_path</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to the local folder to upload regularly.`,name:"folder_path"},{anchor:"huggingface_hub.CommitScheduler.every",description:`<strong>every</strong> (<code>int</code> or <code>float</code>, <em>optional</em>) &#x2014;
The number of minutes between each commit. Defaults to 5 minutes.`,name:"every"},{anchor:"huggingface_hub.CommitScheduler.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Relative path of the directory in the repo, for example: <code>&quot;checkpoints/&quot;</code>. Defaults to the root folder
of the repository.`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitScheduler.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to commit to. Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.CommitScheduler.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repo to commit to. Defaults to <code>main</code>.`,name:"revision"},{anchor:"huggingface_hub.CommitScheduler.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to make the repo private. If <code>None</code> (default), the repo will be public unless the organization&#x2019;s default is private. This value is ignored if the repo already exists.`,name:"private"},{anchor:"huggingface_hub.CommitScheduler.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use to commit to the repo. Defaults to the token saved on the machine.`,name:"token"},{anchor:"huggingface_hub.CommitScheduler.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are uploaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.CommitScheduler.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not uploaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.CommitScheduler.squash_history",description:`<strong>squash_history</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to squash the history of the repo after each commit. Defaults to <code>False</code>. Squashing commits is
useful to avoid degraded performances on the repo when it grows too large.`,name:"squash_history"},{anchor:"huggingface_hub.CommitScheduler.hf_api",description:`<strong>hf_api</strong> (<code>HfApi</code>, <em>optional</em>) &#x2014;
The <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> client to use to commit to the Hub. Can be set with custom settings (user agent, token,&#x2026;).`,name:"hf_api"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L29"}}),$r=new C({props:{anchor:"huggingface_hub.CommitScheduler.example",$$slots:{default:[m4]},$$scope:{ctx:T}}}),wr=new C({props:{anchor:"huggingface_hub.CommitScheduler.example-2",$$slots:{default:[_4]},$$scope:{ctx:T}}}),Yl=new q({props:{name:"push_to_hub",anchor:"huggingface_hub.CommitScheduler.push_to_hub",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L204"}}),kr=new I({props:{warning:!0,$$slots:{default:[b4]},$$scope:{ctx:T}}}),Xl=new q({props:{name:"stop",anchor:"huggingface_hub.CommitScheduler.stop",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L157"}}),zl=new q({props:{name:"trigger",anchor:"huggingface_hub.CommitScheduler.trigger",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L181"}}),Ql=new pH({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/hf_api.md"}}),{c(){n=c("meta"),y=s(),i=c("p"),a=s(),u(g.$$.fragment),e=s(),x=c("p"),x.innerHTML=Lk,Pf=s(),Ur=c("p"),Ur.innerHTML=Wk,Yf=s(),Cr=c("p"),Cr.innerHTML=Vk,Xf=s(),u(Ir.$$.fragment),zf=s(),u(Jr.$$.fragment),Qf=s(),w=c("div"),u(Nr.$$.fragment),s_=s(),wp=c("p"),wp.textContent=Bk,r_=s(),kp=c("p"),kp.innerHTML=Pk,i_=s(),Ze=c("div"),u(Ar.$$.fragment),c_=s(),Tp=c("p"),Tp.textContent=Yk,l_=s(),jp=c("p"),jp.innerHTML=Xk,p_=s(),Mp=c("p"),Mp.innerHTML=zk,d_=s(),Fe=c("div"),u(Er.$$.fragment),g_=s(),qp=c("p"),qp.textContent=Qk,u_=s(),Hp=c("p"),Hp.innerHTML=Ok,h_=s(),u(Vo.$$.fragment),f_=s(),an=c("div"),u(Dr.$$.fragment),m_=s(),Up=c("p"),Up.textContent=Kk,__=s(),Cp=c("p"),Cp.innerHTML=eT,b_=s(),sn=c("div"),u(Rr.$$.fragment),y_=s(),Ip=c("p"),Ip.textContent=tT,v_=s(),Jp=c("p"),Jp.innerHTML=nT,x_=s(),G=c("div"),u(Gr.$$.fragment),$_=s(),Np=c("p"),Np.textContent=oT,w_=s(),Ap=c("p"),Ap.textContent=aT,k_=s(),Ep=c("p"),Ep.textContent=sT,T_=s(),u(Bo.$$.fragment),j_=s(),Dp=c("p"),Dp.textContent=rT,M_=s(),Rp=c("ul"),Rp.innerHTML=iT,q_=s(),Se=c("div"),u(Zr.$$.fragment),H_=s(),Gp=c("p"),Gp.textContent=cT,U_=s(),Zp=c("p"),Zp.textContent=lT,C_=s(),Fp=c("p"),Fp.innerHTML=pT,I_=s(),Po=c("div"),u(Fr.$$.fragment),J_=s(),Sp=c("p"),Sp.textContent=dT,N_=s(),Le=c("div"),u(Sr.$$.fragment),A_=s(),Lp=c("p"),Lp.textContent=gT,E_=s(),u(Yo.$$.fragment),D_=s(),u(Xo.$$.fragment),R_=s(),We=c("div"),u(Lr.$$.fragment),G_=s(),Wp=c("p"),Wp.textContent=uT,Z_=s(),u(zo.$$.fragment),F_=s(),u(Qo.$$.fragment),S_=s(),Oo=c("div"),u(Wr.$$.fragment),L_=s(),Vp=c("p"),Vp.innerHTML=hT,W_=s(),Ve=c("div"),u(Vr.$$.fragment),V_=s(),Bp=c("p"),Bp.textContent=fT,B_=s(),Pp=c("p"),Pp.innerHTML=mT,P_=s(),u(Ko.$$.fragment),Y_=s(),ge=c("div"),u(Br.$$.fragment),X_=s(),Yp=c("p"),Yp.textContent=_T,z_=s(),u(ea.$$.fragment),Q_=s(),u(ta.$$.fragment),O_=s(),u(na.$$.fragment),K_=s(),L=c("div"),u(Pr.$$.fragment),eb=s(),Xp=c("p"),Xp.textContent=bT,tb=s(),zp=c("p"),zp.innerHTML=yT,nb=s(),Qp=c("p"),Qp.innerHTML=vT,ob=s(),Op=c("p"),Op.innerHTML=xT,ab=s(),u(oa.$$.fragment),sb=s(),ue=c("div"),u(Yr.$$.fragment),rb=s(),Kp=c("p"),Kp.textContent=$T,ib=s(),u(aa.$$.fragment),cb=s(),u(sa.$$.fragment),lb=s(),u(ra.$$.fragment),pb=s(),Be=c("div"),u(Xr.$$.fragment),db=s(),ed=c("p"),ed.textContent=wT,gb=s(),td=c("p"),td.innerHTML=kT,ub=s(),u(ia.$$.fragment),hb=s(),W=c("div"),u(zr.$$.fragment),fb=s(),nd=c("p"),nd.innerHTML=TT,mb=s(),od=c("p"),od.innerHTML=jT,_b=s(),ad=c("p"),ad.innerHTML=MT,bb=s(),sd=c("p"),sd.innerHTML=qT,yb=s(),u(ca.$$.fragment),vb=s(),la=c("div"),u(Qr.$$.fragment),xb=s(),rd=c("p"),rd.textContent=HT,$b=s(),V=c("div"),u(Or.$$.fragment),wb=s(),id=c("p"),id.textContent=UT,kb=s(),cd=c("p"),cd.textContent=CT,Tb=s(),u(pa.$$.fragment),jb=s(),u(da.$$.fragment),Mb=s(),u(ga.$$.fragment),qb=s(),B=c("div"),u(Kr.$$.fragment),Hb=s(),ld=c("p"),ld.textContent=IT,Ub=s(),pd=c("p"),pd.textContent=JT,Cb=s(),u(ua.$$.fragment),Ib=s(),u(ha.$$.fragment),Jb=s(),u(fa.$$.fragment),Nb=s(),ma=c("div"),u(ei.$$.fragment),Ab=s(),dd=c("p"),dd.textContent=NT,Eb=s(),rn=c("div"),u(ti.$$.fragment),Db=s(),gd=c("p"),gd.textContent=AT,Rb=s(),u(_a.$$.fragment),Gb=s(),Pe=c("div"),u(ni.$$.fragment),Zb=s(),ud=c("p"),ud.textContent=ET,Fb=s(),hd=c("p"),hd.textContent=DT,Sb=s(),u(ba.$$.fragment),Lb=s(),ya=c("div"),u(oi.$$.fragment),Wb=s(),fd=c("p"),fd.textContent=RT,Vb=s(),Ye=c("div"),u(ai.$$.fragment),Bb=s(),md=c("p"),md.textContent=GT,Pb=s(),u(va.$$.fragment),Yb=s(),u(xa.$$.fragment),Xb=s(),cn=c("div"),u(si.$$.fragment),zb=s(),_d=c("p"),_d.textContent=ZT,Qb=s(),u($a.$$.fragment),Ob=s(),ln=c("div"),u(ri.$$.fragment),Kb=s(),bd=c("p"),bd.textContent=FT,ey=s(),u(wa.$$.fragment),ty=s(),pn=c("div"),u(ii.$$.fragment),ny=s(),yd=c("p"),yd.textContent=ST,oy=s(),vd=c("p"),vd.textContent=LT,ay=s(),dn=c("div"),u(ci.$$.fragment),sy=s(),xd=c("p"),xd.textContent=WT,ry=s(),$d=c("p"),$d.innerHTML=VT,iy=s(),Xe=c("div"),u(li.$$.fragment),cy=s(),wd=c("p"),wd.textContent=BT,ly=s(),kd=c("p"),kd.innerHTML=PT,py=s(),Td=c("p"),Td.innerHTML=YT,dy=s(),ka=c("div"),u(pi.$$.fragment),gy=s(),jd=c("p"),jd.textContent=XT,uy=s(),Ta=c("div"),u(di.$$.fragment),hy=s(),Md=c("p"),Md.textContent=zT,fy=s(),gn=c("div"),u(gi.$$.fragment),my=s(),qd=c("p"),qd.textContent=QT,_y=s(),Hd=c("p"),Hd.innerHTML=OT,by=s(),ja=c("div"),u(ui.$$.fragment),yy=s(),Ud=c("p"),Ud.textContent=KT,vy=s(),un=c("div"),u(hi.$$.fragment),xy=s(),Cd=c("p"),Cd.textContent=e0,$y=s(),Id=c("p"),Id.innerHTML=t0,wy=s(),Ma=c("div"),u(fi.$$.fragment),ky=s(),Jd=c("p"),Jd.textContent=n0,Ty=s(),hn=c("div"),u(mi.$$.fragment),jy=s(),Nd=c("p"),Nd.textContent=o0,My=s(),u(qa.$$.fragment),qy=s(),fn=c("div"),u(_i.$$.fragment),Hy=s(),Ad=c("p"),Ad.textContent=a0,Uy=s(),u(Ha.$$.fragment),Cy=s(),ze=c("div"),u(bi.$$.fragment),Iy=s(),Ed=c("p"),Ed.textContent=s0,Jy=s(),Dd=c("p"),Dd.textContent=r0,Ny=s(),u(Ua.$$.fragment),Ay=s(),mn=c("div"),u(yi.$$.fragment),Ey=s(),Rd=c("p"),Rd.textContent=i0,Dy=s(),u(Ca.$$.fragment),Ry=s(),_n=c("div"),u(vi.$$.fragment),Gy=s(),Gd=c("p"),Gd.textContent=c0,Zy=s(),u(Ia.$$.fragment),Fy=s(),bn=c("div"),u(xi.$$.fragment),Sy=s(),Zd=c("p"),Zd.textContent=l0,Ly=s(),u(Ja.$$.fragment),Wy=s(),yn=c("div"),u($i.$$.fragment),Vy=s(),Fd=c("p"),Fd.textContent=p0,By=s(),u(Na.$$.fragment),Py=s(),Qe=c("div"),u(wi.$$.fragment),Yy=s(),Sd=c("p"),Sd.textContent=d0,Xy=s(),Ld=c("p"),Ld.innerHTML=g0,zy=s(),u(Aa.$$.fragment),Qy=s(),Ea=c("div"),u(ki.$$.fragment),Oy=s(),Wd=c("p"),Wd.textContent=u0,Ky=s(),Oe=c("div"),u(Ti.$$.fragment),ev=s(),Vd=c("p"),Vd.textContent=h0,tv=s(),Bd=c("p"),Bd.innerHTML=f0,nv=s(),u(Da.$$.fragment),ov=s(),Ra=c("div"),u(ji.$$.fragment),av=s(),Pd=c("p"),Pd.textContent=m0,sv=s(),Ga=c("div"),u(Mi.$$.fragment),rv=s(),Yd=c("p"),Yd.textContent=_0,iv=s(),vn=c("div"),u(qi.$$.fragment),cv=s(),Xd=c("p"),Xd.textContent=b0,lv=s(),u(Za.$$.fragment),pv=s(),Fa=c("div"),u(Hi.$$.fragment),dv=s(),zd=c("p"),zd.textContent=y0,gv=s(),xn=c("div"),u(Ui.$$.fragment),uv=s(),Qd=c("p"),Qd.textContent=v0,hv=s(),u(Sa.$$.fragment),fv=s(),he=c("div"),u(Ci.$$.fragment),mv=s(),Od=c("p"),Od.textContent=x0,_v=s(),Kd=c("p"),Kd.textContent=$0,bv=s(),u(La.$$.fragment),yv=s(),u(Wa.$$.fragment),vv=s(),P=c("div"),u(Ii.$$.fragment),xv=s(),eg=c("p"),eg.textContent=w0,$v=s(),tg=c("p"),tg.textContent=k0,wv=s(),ng=c("p"),ng.innerHTML=T0,kv=s(),og=c("p"),og.innerHTML=j0,Tv=s(),u(Va.$$.fragment),jv=s(),Ba=c("div"),u(Ji.$$.fragment),Mv=s(),ag=c("p"),ag.textContent=M0,qv=s(),$n=c("div"),u(Ni.$$.fragment),Hv=s(),sg=c("p"),sg.textContent=q0,Uv=s(),rg=c("p"),rg.innerHTML=H0,Cv=s(),Ke=c("div"),u(Ai.$$.fragment),Iv=s(),ig=c("p"),ig.innerHTML=U0,Jv=s(),u(Pa.$$.fragment),Nv=s(),cg=c("p"),cg.innerHTML=C0,Av=s(),Ya=c("div"),u(Ei.$$.fragment),Ev=s(),lg=c("p"),lg.textContent=I0,Dv=s(),wn=c("div"),u(Di.$$.fragment),Rv=s(),pg=c("p"),pg.textContent=J0,Gv=s(),u(Xa.$$.fragment),Zv=s(),et=c("div"),u(Ri.$$.fragment),Fv=s(),dg=c("p"),dg.textContent=N0,Sv=s(),gg=c("p"),gg.innerHTML=A0,Lv=s(),ug=c("p"),ug.innerHTML=E0,Wv=s(),Y=c("div"),u(Gi.$$.fragment),Vv=s(),hg=c("p"),hg.textContent=D0,Bv=s(),fg=c("p"),fg.textContent=R0,Pv=s(),mg=c("ul"),mg.innerHTML=G0,Yv=s(),u(za.$$.fragment),Xv=s(),_g=c("p"),_g.innerHTML=Z0,zv=s(),tt=c("div"),u(Zi.$$.fragment),Qv=s(),bg=c("p"),bg.textContent=F0,Ov=s(),u(Qa.$$.fragment),Kv=s(),u(Oa.$$.fragment),ex=s(),kn=c("div"),u(Fi.$$.fragment),tx=s(),yg=c("p"),yg.textContent=S0,nx=s(),u(Ka.$$.fragment),ox=s(),Tn=c("div"),u(Si.$$.fragment),ax=s(),vg=c("p"),vg.textContent=L0,sx=s(),u(es.$$.fragment),rx=s(),fe=c("div"),u(Li.$$.fragment),ix=s(),xg=c("p"),xg.textContent=W0,cx=s(),$g=c("p"),$g.innerHTML=V0,lx=s(),wg=c("p"),wg.innerHTML=B0,px=s(),u(ts.$$.fragment),dx=s(),jn=c("div"),u(Wi.$$.fragment),gx=s(),kg=c("p"),kg.textContent=P0,ux=s(),u(ns.$$.fragment),hx=s(),nt=c("div"),u(Vi.$$.fragment),fx=s(),Tg=c("p"),Tg.textContent=Y0,mx=s(),u(os.$$.fragment),_x=s(),u(as.$$.fragment),bx=s(),me=c("div"),u(Bi.$$.fragment),yx=s(),jg=c("p"),jg.textContent=X0,vx=s(),Mg=c("p"),Mg.innerHTML=z0,xx=s(),qg=c("p"),qg.innerHTML=Q0,$x=s(),u(ss.$$.fragment),wx=s(),Mn=c("div"),u(Pi.$$.fragment),kx=s(),Hg=c("p"),Hg.textContent=O0,Tx=s(),u(rs.$$.fragment),jx=s(),is=c("div"),u(Yi.$$.fragment),Mx=s(),Ug=c("p"),Ug.textContent=K0,qx=s(),ot=c("div"),u(Xi.$$.fragment),Hx=s(),Cg=c("p"),Cg.textContent=ej,Ux=s(),Ig=c("p"),Ig.innerHTML=tj,Cx=s(),u(cs.$$.fragment),Ix=s(),_e=c("div"),u(zi.$$.fragment),Jx=s(),Jg=c("p"),Jg.textContent=nj,Nx=s(),Ng=c("p"),Ng.innerHTML=oj,Ax=s(),Ag=c("p"),Ag.innerHTML=aj,Ex=s(),u(ls.$$.fragment),Dx=s(),qn=c("div"),u(Qi.$$.fragment),Rx=s(),Eg=c("p"),Eg.textContent=sj,Gx=s(),u(ps.$$.fragment),Zx=s(),ds=c("div"),u(Oi.$$.fragment),Fx=s(),Dg=c("p"),Dg.textContent=rj,Sx=s(),Hn=c("div"),u(Ki.$$.fragment),Lx=s(),Rg=c("p"),Rg.textContent=ij,Wx=s(),u(gs.$$.fragment),Vx=s(),be=c("div"),u(ec.$$.fragment),Bx=s(),Gg=c("p"),Gg.textContent=cj,Px=s(),Zg=c("p"),Zg.innerHTML=lj,Yx=s(),Fg=c("p"),Fg.innerHTML=pj,Xx=s(),u(us.$$.fragment),zx=s(),ye=c("div"),u(tc.$$.fragment),Qx=s(),Sg=c("p"),Sg.textContent=dj,Ox=s(),Lg=c("p"),Lg.innerHTML=gj,Kx=s(),Wg=c("p"),Wg.innerHTML=uj,e$=s(),u(hs.$$.fragment),t$=s(),at=c("div"),u(nc.$$.fragment),n$=s(),Vg=c("p"),Vg.textContent=hj,o$=s(),Bg=c("p"),Bg.textContent=fj,a$=s(),u(fs.$$.fragment),s$=s(),ms=c("div"),u(oc.$$.fragment),r$=s(),Pg=c("p"),Pg.textContent=mj,i$=s(),Un=c("div"),u(ac.$$.fragment),c$=s(),Yg=c("p"),Yg.textContent=_j,l$=s(),Xg=c("p"),Xg.innerHTML=bj,p$=s(),Cn=c("div"),u(sc.$$.fragment),d$=s(),zg=c("p"),zg.textContent=yj,g$=s(),u(_s.$$.fragment),u$=s(),Z=c("div"),u(rc.$$.fragment),h$=s(),Qg=c("p"),Qg.textContent=vj,f$=s(),Og=c("p"),Og.textContent=xj,m$=s(),Kg=c("p"),Kg.textContent=$j,_$=s(),u(bs.$$.fragment),b$=s(),eu=c("p"),eu.textContent=wj,y$=s(),u(ys.$$.fragment),v$=s(),vs=c("div"),u(ic.$$.fragment),x$=s(),tu=c("p"),tu.textContent=kj,$$=s(),xs=c("div"),u(cc.$$.fragment),w$=s(),nu=c("p"),nu.textContent=Tj,k$=s(),$s=c("div"),u(lc.$$.fragment),T$=s(),ou=c("p"),ou.textContent=jj,j$=s(),ws=c("div"),u(pc.$$.fragment),M$=s(),au=c("p"),au.textContent=Mj,q$=s(),In=c("div"),u(dc.$$.fragment),H$=s(),su=c("p"),su.textContent=qj,U$=s(),u(ks.$$.fragment),C$=s(),Jn=c("div"),u(gc.$$.fragment),I$=s(),ru=c("p"),ru.textContent=Hj,J$=s(),u(Ts.$$.fragment),N$=s(),st=c("div"),u(uc.$$.fragment),A$=s(),iu=c("p"),iu.textContent=Uj,E$=s(),cu=c("p"),cu.textContent=Cj,D$=s(),u(js.$$.fragment),R$=s(),rt=c("div"),u(hc.$$.fragment),G$=s(),lu=c("p"),lu.textContent=Ij,Z$=s(),pu=c("p"),pu.innerHTML=Jj,F$=s(),u(Ms.$$.fragment),S$=s(),qs=c("div"),u(fc.$$.fragment),L$=s(),du=c("p"),du.textContent=Nj,W$=s(),it=c("div"),u(mc.$$.fragment),V$=s(),gu=c("p"),gu.textContent=Aj,B$=s(),uu=c("p"),uu.innerHTML=Ej,P$=s(),hu=c("p"),hu.innerHTML=Dj,Y$=s(),ct=c("div"),u(_c.$$.fragment),X$=s(),fu=c("p"),fu.textContent=Rj,z$=s(),mu=c("p"),mu.innerHTML=Gj,Q$=s(),_u=c("p"),_u.innerHTML=Zj,O$=s(),lt=c("div"),u(bc.$$.fragment),K$=s(),bu=c("p"),bu.textContent=Fj,e2=s(),yu=c("p"),yu.innerHTML=Sj,t2=s(),vu=c("p"),vu.innerHTML=Lj,n2=s(),pt=c("div"),u(yc.$$.fragment),o2=s(),xu=c("p"),xu.textContent=Wj,a2=s(),u(Hs.$$.fragment),s2=s(),u(Us.$$.fragment),r2=s(),X=c("div"),u(vc.$$.fragment),i2=s(),$u=c("p"),$u.textContent=Vj,c2=s(),wu=c("p"),wu.textContent=Bj,l2=s(),u(Cs.$$.fragment),p2=s(),u(Is.$$.fragment),d2=s(),u(Js.$$.fragment),g2=s(),dt=c("div"),u(xc.$$.fragment),u2=s(),ku=c("p"),ku.textContent=Pj,h2=s(),Tu=c("p"),Tu.innerHTML=Yj,f2=s(),ju=c("p"),ju.innerHTML=Xj,m2=s(),gt=c("div"),u($c.$$.fragment),_2=s(),Mu=c("p"),Mu.textContent=zj,b2=s(),u(Ns.$$.fragment),y2=s(),u(As.$$.fragment),v2=s(),Nn=c("div"),u(wc.$$.fragment),x2=s(),qu=c("p"),qu.textContent=Qj,$2=s(),u(Es.$$.fragment),w2=s(),An=c("div"),u(kc.$$.fragment),k2=s(),Hu=c("p"),Hu.textContent=Oj,T2=s(),u(Ds.$$.fragment),j2=s(),En=c("div"),u(Tc.$$.fragment),M2=s(),Uu=c("p"),Uu.textContent=Kj,q2=s(),u(Rs.$$.fragment),H2=s(),Dn=c("div"),u(jc.$$.fragment),U2=s(),Cu=c("p"),Cu.textContent=eM,C2=s(),u(Gs.$$.fragment),I2=s(),ut=c("div"),u(Mc.$$.fragment),J2=s(),Iu=c("p"),Iu.textContent=tM,N2=s(),Ju=c("p"),Ju.innerHTML=nM,A2=s(),Nu=c("p"),Nu.innerHTML=oM,E2=s(),Rn=c("div"),u(qc.$$.fragment),D2=s(),Au=c("p"),Au.textContent=aM,R2=s(),Eu=c("p"),Eu.innerHTML=sM,G2=s(),Zs=c("div"),u(Hc.$$.fragment),Z2=s(),Du=c("p"),Du.textContent=rM,F2=s(),Gn=c("div"),u(Uc.$$.fragment),S2=s(),Ru=c("p"),Ru.textContent=iM,L2=s(),u(Fs.$$.fragment),W2=s(),ve=c("div"),u(Cc.$$.fragment),V2=s(),Gu=c("p"),Gu.textContent=cM,B2=s(),Zu=c("p"),Zu.innerHTML=lM,P2=s(),Fu=c("p"),Fu.innerHTML=pM,Y2=s(),u(Ss.$$.fragment),X2=s(),xe=c("div"),u(Ic.$$.fragment),z2=s(),Su=c("p"),Su.textContent=dM,Q2=s(),Lu=c("p"),Lu.textContent=gM,O2=s(),u(Ls.$$.fragment),K2=s(),u(Ws.$$.fragment),e1=s(),z=c("div"),u(Jc.$$.fragment),t1=s(),Wu=c("p"),Wu.textContent=uM,n1=s(),Vu=c("p"),Vu.textContent=hM,o1=s(),u(Vs.$$.fragment),a1=s(),u(Bs.$$.fragment),s1=s(),u(Ps.$$.fragment),r1=s(),ht=c("div"),u(Nc.$$.fragment),i1=s(),Bu=c("p"),Bu.textContent=fM,c1=s(),Pu=c("p"),Pu.innerHTML=mM,l1=s(),Yu=c("p"),Yu.innerHTML=_M,p1=s(),ft=c("div"),u(Ac.$$.fragment),d1=s(),Xu=c("p"),Xu.textContent=bM,g1=s(),zu=c("p"),zu.innerHTML=yM,u1=s(),u(Ys.$$.fragment),h1=s(),$e=c("div"),u(Ec.$$.fragment),f1=s(),Qu=c("p"),Qu.textContent=vM,m1=s(),Ou=c("p"),Ou.innerHTML=xM,_1=s(),Ku=c("p"),Ku.innerHTML=$M,b1=s(),eh=c("p"),eh.textContent=wM,y1=s(),mt=c("div"),u(Dc.$$.fragment),v1=s(),th=c("p"),th.textContent=kM,x1=s(),nh=c("p"),nh.textContent=TM,$1=s(),u(Xs.$$.fragment),w1=s(),Q=c("div"),u(Rc.$$.fragment),k1=s(),oh=c("p"),oh.textContent=jM,T1=s(),ah=c("p"),ah.textContent=MM,j1=s(),u(zs.$$.fragment),M1=s(),u(Qs.$$.fragment),q1=s(),u(Os.$$.fragment),H1=s(),Ks=c("div"),u(Gc.$$.fragment),U1=s(),sh=c("p"),sh.textContent=qM,C1=s(),we=c("div"),u(Zc.$$.fragment),I1=s(),rh=c("p"),rh.textContent=HM,J1=s(),ih=c("p"),ih.innerHTML=UM,N1=s(),ch=c("p"),ch.innerHTML=CM,A1=s(),u(er.$$.fragment),E1=s(),Zn=c("div"),u(Fc.$$.fragment),D1=s(),lh=c("p"),lh.textContent=IM,R1=s(),u(tr.$$.fragment),G1=s(),ke=c("div"),u(Sc.$$.fragment),Z1=s(),ph=c("p"),ph.textContent=JM,F1=s(),dh=c("p"),dh.textContent=NM,S1=s(),gh=c("p"),gh.innerHTML=AM,L1=s(),u(nr.$$.fragment),W1=s(),_t=c("div"),u(Lc.$$.fragment),V1=s(),uh=c("p"),uh.textContent=EM,B1=s(),hh=c("p"),hh.textContent=DM,P1=s(),fh=c("p"),fh.innerHTML=RM,Y1=s(),Fn=c("div"),u(Wc.$$.fragment),X1=s(),mh=c("p"),mh.textContent=GM,z1=s(),_h=c("p"),_h.textContent=ZM,Q1=s(),bt=c("div"),u(Vc.$$.fragment),O1=s(),bh=c("p"),bh.textContent=FM,K1=s(),yh=c("p"),yh.innerHTML=SM,ew=s(),u(or.$$.fragment),tw=s(),Sn=c("div"),u(Bc.$$.fragment),nw=s(),vh=c("p"),vh.textContent=LM,ow=s(),u(ar.$$.fragment),aw=s(),Te=c("div"),u(Pc.$$.fragment),sw=s(),xh=c("p"),xh.textContent=WM,rw=s(),u(sr.$$.fragment),iw=s(),u(rr.$$.fragment),cw=s(),u(ir.$$.fragment),lw=s(),N=c("div"),u(Yc.$$.fragment),pw=s(),$h=c("p"),$h.textContent=VM,dw=s(),wh=c("p"),wh.textContent=BM,gw=s(),kh=c("p"),kh.innerHTML=PM,uw=s(),Th=c("p"),Th.innerHTML=YM,hw=s(),jh=c("p"),jh.innerHTML=XM,fw=s(),Mh=c("p"),Mh.innerHTML=zM,mw=s(),u(cr.$$.fragment),_w=s(),u(lr.$$.fragment),bw=s(),u(pr.$$.fragment),yw=s(),u(dr.$$.fragment),vw=s(),J=c("div"),u(Xc.$$.fragment),xw=s(),qh=c("p"),qh.textContent=QM,$w=s(),Hh=c("p"),Hh.innerHTML=OM,ww=s(),u(gr.$$.fragment),kw=s(),u(ur.$$.fragment),Tw=s(),Uh=c("p"),Uh.innerHTML=KM,jw=s(),Ch=c("p"),Ch.innerHTML=eq,Mw=s(),Ih=c("ol"),Ih.innerHTML=tq,qw=s(),Jh=c("p"),Jh.textContent=nq,Hw=s(),Nh=c("ol"),Nh.innerHTML=oq,Uw=s(),Ah=c("p"),Ah.textContent=aq,Cw=s(),Eh=c("ul"),Eh.innerHTML=sq,Iw=s(),hr=c("div"),u(zc.$$.fragment),Jw=s(),Dh=c("p"),Dh.textContent=rq,Of=s(),u(Qc.$$.fragment),Kf=s(),u(Oc.$$.fragment),em=s(),Kn=c("div"),u(Kc.$$.fragment),Nw=s(),Rh=c("p"),Rh.textContent=iq,tm=s(),u(el.$$.fragment),nm=s(),vt=c("div"),u(tl.$$.fragment),Aw=s(),Gh=c("p"),Gh.textContent=cq,Ew=s(),Zh=c("p"),Zh.innerHTML=lq,om=s(),u(nl.$$.fragment),am=s(),xt=c("div"),u(ol.$$.fragment),Dw=s(),Fh=c("p"),Fh.innerHTML=pq,Rw=s(),u(fr.$$.fragment),sm=s(),u(al.$$.fragment),rm=s(),eo=c("div"),u(sl.$$.fragment),Gw=s(),Sh=c("p"),Sh.textContent=dq,im=s(),u(rl.$$.fragment),cm=s(),to=c("div"),u(il.$$.fragment),Zw=s(),Lh=c("p"),Lh.innerHTML=gq,lm=s(),u(cl.$$.fragment),pm=s(),$t=c("div"),u(ll.$$.fragment),Fw=s(),Wh=c("p"),Wh.textContent=uq,Sw=s(),Vh=c("p"),Vh.innerHTML=hq,dm=s(),u(pl.$$.fragment),gm=s(),dl=c("div"),u(gl.$$.fragment),um=s(),u(ul.$$.fragment),hm=s(),K=c("div"),u(hl.$$.fragment),Lw=s(),Bh=c("p"),Bh.textContent=fq,Ww=s(),Ph=c("p"),Ph.innerHTML=mq,Vw=s(),Yh=c("p"),Yh.innerHTML=_q,Bw=s(),u(mr.$$.fragment),fm=s(),u(fl.$$.fragment),mm=s(),wt=c("div"),u(ml.$$.fragment),Pw=s(),Xh=c("p"),Xh.innerHTML=bq,Yw=s(),u(_r.$$.fragment),_m=s(),u(_l.$$.fragment),bm=s(),kt=c("div"),u(bl.$$.fragment),Xw=s(),zh=c("p"),zh.textContent=yq,zw=s(),u(br.$$.fragment),ym=s(),u(yl.$$.fragment),vm=s(),no=c("div"),u(vl.$$.fragment),Qw=s(),Qh=c("p"),Qh.textContent=vq,xm=s(),u(xl.$$.fragment),$m=s(),ee=c("div"),u($l.$$.fragment),Ow=s(),Oh=c("p"),Oh.innerHTML=xq,Kw=s(),Kh=c("p"),Kh.innerHTML=$q,ek=s(),ef=c("ul"),ef.innerHTML=wq,tk=s(),u(yr.$$.fragment),wm=s(),u(wl.$$.fragment),km=s(),te=c("div"),u(kl.$$.fragment),nk=s(),tf=c("p"),tf.textContent=kq,ok=s(),nf=c("p"),nf.textContent=Tq,ak=s(),of=c("p"),of.innerHTML=jq,sk=s(),af=c("p"),af.innerHTML=Mq,Tm=s(),u(Tl.$$.fragment),jm=s(),je=c("div"),u(jl.$$.fragment),rk=s(),sf=c("p"),sf.textContent=qq,ik=s(),rf=c("p"),rf.innerHTML=Hq,ck=s(),cf=c("p"),cf.innerHTML=Uq,Mm=s(),u(Ml.$$.fragment),qm=s(),Tt=c("div"),u(ql.$$.fragment),lk=s(),lf=c("p"),lf.innerHTML=Cq,pk=s(),u(vr.$$.fragment),Hm=s(),u(Hl.$$.fragment),Um=s(),jt=c("div"),u(Ul.$$.fragment),dk=s(),pf=c("p"),pf.textContent=Iq,gk=s(),df=c("p"),df.innerHTML=Jq,Cm=s(),u(Cl.$$.fragment),Im=s(),oo=c("div"),u(Il.$$.fragment),uk=s(),gf=c("p"),gf.textContent=Nq,Jm=s(),u(Jl.$$.fragment),Nm=s(),ao=c("div"),u(Nl.$$.fragment),hk=s(),uf=c("p"),uf.textContent=Aq,Am=s(),u(Al.$$.fragment),Em=s(),so=c("div"),u(El.$$.fragment),fk=s(),hf=c("p"),hf.textContent=Eq,Dm=s(),u(Dl.$$.fragment),Rm=s(),ro=c("div"),u(Rl.$$.fragment),mk=s(),ff=c("p"),ff.textContent=Dq,Gm=s(),u(Gl.$$.fragment),Zm=s(),Zl=c("p"),Zl.innerHTML=Rq,Fm=s(),Me=c("div"),u(Fl.$$.fragment),_k=s(),mf=c("p"),mf.textContent=Gq,bk=s(),Ln=c("div"),u(Sl.$$.fragment),yk=s(),_f=c("p"),_f.innerHTML=Zq,vk=s(),u(xr.$$.fragment),xk=s(),Wn=c("div"),u(Ll.$$.fragment),$k=s(),bf=c("p"),bf.innerHTML=Fq,wk=s(),yf=c("p"),yf.innerHTML=Sq,Sm=s(),io=c("div"),u(Wl.$$.fragment),kk=s(),vf=c("p"),vf.textContent=Lq,Lm=s(),ne=c("div"),u(Vl.$$.fragment),Tk=s(),xf=c("p"),xf.textContent=Wq,jk=s(),$f=c("p"),$f.textContent=Vq,Mk=s(),wf=c("ul"),wf.innerHTML=Bq,qk=s(),kf=c("p"),kf.innerHTML=Pq,Wm=s(),u(Bl.$$.fragment),Vm=s(),R=c("div"),u(Pl.$$.fragment),Hk=s(),Tf=c("p"),Tf.textContent=Yq,Uk=s(),jf=c("p"),jf.innerHTML=Xq,Ck=s(),u($r.$$.fragment),Ik=s(),u(wr.$$.fragment),Jk=s(),yt=c("div"),u(Yl.$$.fragment),Nk=s(),Mf=c("p"),Mf.textContent=zq,Ak=s(),u(kr.$$.fragment),Ek=s(),qf=c("p"),qf.innerHTML=Qq,Dk=s(),Vn=c("div"),u(Xl.$$.fragment),Rk=s(),Hf=c("p"),Hf.textContent=Oq,Gk=s(),Uf=c("p"),Uf.textContent=Kq,Zk=s(),Bn=c("div"),u(zl.$$.fragment),Fk=s(),Cf=c("p"),Cf.innerHTML=eH,Sk=s(),If=c("p"),If.innerHTML=tH,Bm=s(),u(Ql.$$.fragment),Pm=s(),Bf=c("p"),this.h()},l(t){const v=iH("svelte-u9bgzb",document.head);n=l(v,"META",{name:!0,content:!0}),v.forEach(p),y=r(t),i=l(t,"P",{}),j(i).forEach(p),a=r(t),h(g.$$.fragment,t),e=r(t),x=l(t,"P",{"data-svelte-h":!0}),d(x)!=="svelte-vbqehn"&&(x.innerHTML=Lk),Pf=r(t),Ur=l(t,"P",{"data-svelte-h":!0}),d(Ur)!=="svelte-ii6hxn"&&(Ur.innerHTML=Wk),Yf=r(t),Cr=l(t,"P",{"data-svelte-h":!0}),d(Cr)!=="svelte-trrml4"&&(Cr.innerHTML=Vk),Xf=r(t),h(Ir.$$.fragment,t),zf=r(t),h(Jr.$$.fragment,t),Qf=r(t),w=l(t,"DIV",{class:!0});var k=j(w);h(Nr.$$.fragment,k),s_=r(k),wp=l(k,"P",{"data-svelte-h":!0}),d(wp)!=="svelte-868tea"&&(wp.textContent=Bk),r_=r(k),kp=l(k,"P",{"data-svelte-h":!0}),d(kp)!=="svelte-mq1mm2"&&(kp.innerHTML=Pk),i_=r(k),Ze=l(k,"DIV",{class:!0});var Mt=j(Ze);h(Ar.$$.fragment,Mt),c_=r(Mt),Tp=l(Mt,"P",{"data-svelte-h":!0}),d(Tp)!=="svelte-nwim5u"&&(Tp.textContent=Yk),l_=r(Mt),jp=l(Mt,"P",{"data-svelte-h":!0}),d(jp)!=="svelte-1p3hclb"&&(jp.innerHTML=Xk),p_=r(Mt),Mp=l(Mt,"P",{"data-svelte-h":!0}),d(Mp)!=="svelte-xxbgtf"&&(Mp.innerHTML=zk),Mt.forEach(p),d_=r(k),Fe=l(k,"DIV",{class:!0});var qt=j(Fe);h(Er.$$.fragment,qt),g_=r(qt),qp=l(qt,"P",{"data-svelte-h":!0}),d(qp)!=="svelte-pl69v6"&&(qp.textContent=Qk),u_=r(qt),Hp=l(qt,"P",{"data-svelte-h":!0}),d(Hp)!=="svelte-164ppjv"&&(Hp.innerHTML=Ok),h_=r(qt),h(Vo.$$.fragment,qt),qt.forEach(p),f_=r(k),an=l(k,"DIV",{class:!0});var co=j(an);h(Dr.$$.fragment,co),m_=r(co),Up=l(co,"P",{"data-svelte-h":!0}),d(Up)!=="svelte-p5bez4"&&(Up.textContent=Kk),__=r(co),Cp=l(co,"P",{"data-svelte-h":!0}),d(Cp)!=="svelte-eb77qn"&&(Cp.innerHTML=eT),co.forEach(p),b_=r(k),sn=l(k,"DIV",{class:!0});var lo=j(sn);h(Rr.$$.fragment,lo),y_=r(lo),Ip=l(lo,"P",{"data-svelte-h":!0}),d(Ip)!=="svelte-1ck64b0"&&(Ip.textContent=tT),v_=r(lo),Jp=l(lo,"P",{"data-svelte-h":!0}),d(Jp)!=="svelte-xt39ay"&&(Jp.innerHTML=nT),lo.forEach(p),x_=r(k),G=l(k,"DIV",{class:!0});var F=j(G);h(Gr.$$.fragment,F),$_=r(F),Np=l(F,"P",{"data-svelte-h":!0}),d(Np)!=="svelte-1ryj8c0"&&(Np.textContent=oT),w_=r(F),Ap=l(F,"P",{"data-svelte-h":!0}),d(Ap)!=="svelte-vnh51y"&&(Ap.textContent=aT),k_=r(F),Ep=l(F,"P",{"data-svelte-h":!0}),d(Ep)!=="svelte-11lpom8"&&(Ep.textContent=sT),T_=r(F),h(Bo.$$.fragment,F),j_=r(F),Dp=l(F,"P",{"data-svelte-h":!0}),d(Dp)!=="svelte-15bi1il"&&(Dp.textContent=rT),M_=r(F),Rp=l(F,"UL",{"data-svelte-h":!0}),d(Rp)!=="svelte-1cixf91"&&(Rp.innerHTML=iT),F.forEach(p),q_=r(k),Se=l(k,"DIV",{class:!0});var Ht=j(Se);h(Zr.$$.fragment,Ht),H_=r(Ht),Gp=l(Ht,"P",{"data-svelte-h":!0}),d(Gp)!=="svelte-1v3ljxo"&&(Gp.textContent=cT),U_=r(Ht),Zp=l(Ht,"P",{"data-svelte-h":!0}),d(Zp)!=="svelte-zq4mwt"&&(Zp.textContent=lT),C_=r(Ht),Fp=l(Ht,"P",{"data-svelte-h":!0}),d(Fp)!=="svelte-xxbgtf"&&(Fp.innerHTML=pT),Ht.forEach(p),I_=r(k),Po=l(k,"DIV",{class:!0});var Ol=j(Po);h(Fr.$$.fragment,Ol),J_=r(Ol),Sp=l(Ol,"P",{"data-svelte-h":!0}),d(Sp)!=="svelte-a2pb7d"&&(Sp.textContent=dT),Ol.forEach(p),N_=r(k),Le=l(k,"DIV",{class:!0});var Ut=j(Le);h(Sr.$$.fragment,Ut),A_=r(Ut),Lp=l(Ut,"P",{"data-svelte-h":!0}),d(Lp)!=="svelte-16mfbn3"&&(Lp.textContent=gT),E_=r(Ut),h(Yo.$$.fragment,Ut),D_=r(Ut),h(Xo.$$.fragment,Ut),Ut.forEach(p),R_=r(k),We=l(k,"DIV",{class:!0});var Ct=j(We);h(Lr.$$.fragment,Ct),G_=r(Ct),Wp=l(Ct,"P",{"data-svelte-h":!0}),d(Wp)!=="svelte-1xtlk3i"&&(Wp.textContent=uT),Z_=r(Ct),h(zo.$$.fragment,Ct),F_=r(Ct),h(Qo.$$.fragment,Ct),Ct.forEach(p),S_=r(k),Oo=l(k,"DIV",{class:!0});var Kl=j(Oo);h(Wr.$$.fragment,Kl),L_=r(Kl),Vp=l(Kl,"P",{"data-svelte-h":!0}),d(Vp)!=="svelte-q41614"&&(Vp.innerHTML=hT),Kl.forEach(p),W_=r(k),Ve=l(k,"DIV",{class:!0});var It=j(Ve);h(Vr.$$.fragment,It),V_=r(It),Bp=l(It,"P",{"data-svelte-h":!0}),d(Bp)!=="svelte-8lce12"&&(Bp.textContent=fT),B_=r(It),Pp=l(It,"P",{"data-svelte-h":!0}),d(Pp)!=="svelte-164ppjv"&&(Pp.innerHTML=mT),P_=r(It),h(Ko.$$.fragment,It),It.forEach(p),Y_=r(k),ge=l(k,"DIV",{class:!0});var qe=j(ge);h(Br.$$.fragment,qe),X_=r(qe),Yp=l(qe,"P",{"data-svelte-h":!0}),d(Yp)!=="svelte-pth6mb"&&(Yp.textContent=_T),z_=r(qe),h(ea.$$.fragment,qe),Q_=r(qe),h(ta.$$.fragment,qe),O_=r(qe),h(na.$$.fragment,qe),qe.forEach(p),K_=r(k),L=l(k,"DIV",{class:!0});var oe=j(L);h(Pr.$$.fragment,oe),eb=r(oe),Xp=l(oe,"P",{"data-svelte-h":!0}),d(Xp)!=="svelte-1g87pq3"&&(Xp.textContent=bT),tb=r(oe),zp=l(oe,"P",{"data-svelte-h":!0}),d(zp)!=="svelte-1gunwzz"&&(zp.innerHTML=yT),nb=r(oe),Qp=l(oe,"P",{"data-svelte-h":!0}),d(Qp)!=="svelte-r5v8l0"&&(Qp.innerHTML=vT),ob=r(oe),Op=l(oe,"P",{"data-svelte-h":!0}),d(Op)!=="svelte-1on7ni7"&&(Op.innerHTML=xT),ab=r(oe),h(oa.$$.fragment,oe),oe.forEach(p),sb=r(k),ue=l(k,"DIV",{class:!0});var He=j(ue);h(Yr.$$.fragment,He),rb=r(He),Kp=l(He,"P",{"data-svelte-h":!0}),d(Kp)!=="svelte-aoy5wl"&&(Kp.textContent=$T),ib=r(He),h(aa.$$.fragment,He),cb=r(He),h(sa.$$.fragment,He),lb=r(He),h(ra.$$.fragment,He),He.forEach(p),pb=r(k),Be=l(k,"DIV",{class:!0});var Jt=j(Be);h(Xr.$$.fragment,Jt),db=r(Jt),ed=l(Jt,"P",{"data-svelte-h":!0}),d(ed)!=="svelte-1mk48gz"&&(ed.textContent=wT),gb=r(Jt),td=l(Jt,"P",{"data-svelte-h":!0}),d(td)!=="svelte-s9x0iz"&&(td.innerHTML=kT),ub=r(Jt),h(ia.$$.fragment,Jt),Jt.forEach(p),hb=r(k),W=l(k,"DIV",{class:!0});var ae=j(W);h(zr.$$.fragment,ae),fb=r(ae),nd=l(ae,"P",{"data-svelte-h":!0}),d(nd)!=="svelte-1hp36yr"&&(nd.innerHTML=TT),mb=r(ae),od=l(ae,"P",{"data-svelte-h":!0}),d(od)!=="svelte-r57fdn"&&(od.innerHTML=jT),_b=r(ae),ad=l(ae,"P",{"data-svelte-h":!0}),d(ad)!=="svelte-13rslc6"&&(ad.innerHTML=MT),bb=r(ae),sd=l(ae,"P",{"data-svelte-h":!0}),d(sd)!=="svelte-1on7ni7"&&(sd.innerHTML=qT),yb=r(ae),h(ca.$$.fragment,ae),ae.forEach(p),vb=r(k),la=l(k,"DIV",{class:!0});var ep=j(la);h(Qr.$$.fragment,ep),xb=r(ep),rd=l(ep,"P",{"data-svelte-h":!0}),d(rd)!=="svelte-12go647"&&(rd.textContent=HT),ep.forEach(p),$b=r(k),V=l(k,"DIV",{class:!0});var se=j(V);h(Or.$$.fragment,se),wb=r(se),id=l(se,"P",{"data-svelte-h":!0}),d(id)!=="svelte-254b6u"&&(id.textContent=UT),kb=r(se),cd=l(se,"P",{"data-svelte-h":!0}),d(cd)!=="svelte-11lpom8"&&(cd.textContent=CT),Tb=r(se),h(pa.$$.fragment,se),jb=r(se),h(da.$$.fragment,se),Mb=r(se),h(ga.$$.fragment,se),se.forEach(p),qb=r(k),B=l(k,"DIV",{class:!0});var re=j(B);h(Kr.$$.fragment,re),Hb=r(re),ld=l(re,"P",{"data-svelte-h":!0}),d(ld)!=="svelte-13uq06b"&&(ld.textContent=IT),Ub=r(re),pd=l(re,"P",{"data-svelte-h":!0}),d(pd)!=="svelte-11lpom8"&&(pd.textContent=JT),Cb=r(re),h(ua.$$.fragment,re),Ib=r(re),h(ha.$$.fragment,re),Jb=r(re),h(fa.$$.fragment,re),re.forEach(p),Nb=r(k),ma=l(k,"DIV",{class:!0});var tp=j(ma);h(ei.$$.fragment,tp),Ab=r(tp),dd=l(tp,"P",{"data-svelte-h":!0}),d(dd)!=="svelte-14fvvbg"&&(dd.textContent=NT),tp.forEach(p),Eb=r(k),rn=l(k,"DIV",{class:!0});var po=j(rn);h(ti.$$.fragment,po),Db=r(po),gd=l(po,"P",{"data-svelte-h":!0}),d(gd)!=="svelte-1g6e2ay"&&(gd.textContent=AT),Rb=r(po),h(_a.$$.fragment,po),po.forEach(p),Gb=r(k),Pe=l(k,"DIV",{class:!0});var Nt=j(Pe);h(ni.$$.fragment,Nt),Zb=r(Nt),ud=l(Nt,"P",{"data-svelte-h":!0}),d(ud)!=="svelte-15pbnj8"&&(ud.textContent=ET),Fb=r(Nt),hd=l(Nt,"P",{"data-svelte-h":!0}),d(hd)!=="svelte-1fg5f6l"&&(hd.textContent=DT),Sb=r(Nt),h(ba.$$.fragment,Nt),Nt.forEach(p),Lb=r(k),ya=l(k,"DIV",{class:!0});var np=j(ya);h(oi.$$.fragment,np),Wb=r(np),fd=l(np,"P",{"data-svelte-h":!0}),d(fd)!=="svelte-1n7quvg"&&(fd.textContent=RT),np.forEach(p),Vb=r(k),Ye=l(k,"DIV",{class:!0});var At=j(Ye);h(ai.$$.fragment,At),Bb=r(At),md=l(At,"P",{"data-svelte-h":!0}),d(md)!=="svelte-1s6a009"&&(md.textContent=GT),Pb=r(At),h(va.$$.fragment,At),Yb=r(At),h(xa.$$.fragment,At),At.forEach(p),Xb=r(k),cn=l(k,"DIV",{class:!0});var go=j(cn);h(si.$$.fragment,go),zb=r(go),_d=l(go,"P",{"data-svelte-h":!0}),d(_d)!=="svelte-gmiayq"&&(_d.textContent=ZT),Qb=r(go),h($a.$$.fragment,go),go.forEach(p),Ob=r(k),ln=l(k,"DIV",{class:!0});var uo=j(ln);h(ri.$$.fragment,uo),Kb=r(uo),bd=l(uo,"P",{"data-svelte-h":!0}),d(bd)!=="svelte-l8j8qy"&&(bd.textContent=FT),ey=r(uo),h(wa.$$.fragment,uo),uo.forEach(p),ty=r(k),pn=l(k,"DIV",{class:!0});var ho=j(pn);h(ii.$$.fragment,ho),ny=r(ho),yd=l(ho,"P",{"data-svelte-h":!0}),d(yd)!=="svelte-eigln8"&&(yd.textContent=ST),oy=r(ho),vd=l(ho,"P",{"data-svelte-h":!0}),d(vd)!=="svelte-11xoqkr"&&(vd.textContent=LT),ho.forEach(p),ay=r(k),dn=l(k,"DIV",{class:!0});var fo=j(dn);h(ci.$$.fragment,fo),sy=r(fo),xd=l(fo,"P",{"data-svelte-h":!0}),d(xd)!=="svelte-1gp9ysc"&&(xd.textContent=WT),ry=r(fo),$d=l(fo,"P",{"data-svelte-h":!0}),d($d)!=="svelte-1seiqi6"&&($d.innerHTML=VT),fo.forEach(p),iy=r(k),Xe=l(k,"DIV",{class:!0});var Et=j(Xe);h(li.$$.fragment,Et),cy=r(Et),wd=l(Et,"P",{"data-svelte-h":!0}),d(wd)!=="svelte-xvin3w"&&(wd.textContent=BT),ly=r(Et),kd=l(Et,"P",{"data-svelte-h":!0}),d(kd)!=="svelte-1vd9l2b"&&(kd.innerHTML=PT),py=r(Et),Td=l(Et,"P",{"data-svelte-h":!0}),d(Td)!=="svelte-wf2uv4"&&(Td.innerHTML=YT),Et.forEach(p),dy=r(k),ka=l(k,"DIV",{class:!0});var op=j(ka);h(pi.$$.fragment,op),gy=r(op),jd=l(op,"P",{"data-svelte-h":!0}),d(jd)!=="svelte-17rezgl"&&(jd.textContent=XT),op.forEach(p),uy=r(k),Ta=l(k,"DIV",{class:!0});var ap=j(Ta);h(di.$$.fragment,ap),hy=r(ap),Md=l(ap,"P",{"data-svelte-h":!0}),d(Md)!=="svelte-rjrkh7"&&(Md.textContent=zT),ap.forEach(p),fy=r(k),gn=l(k,"DIV",{class:!0});var mo=j(gn);h(gi.$$.fragment,mo),my=r(mo),qd=l(mo,"P",{"data-svelte-h":!0}),d(qd)!=="svelte-1lh7ib8"&&(qd.textContent=QT),_y=r(mo),Hd=l(mo,"P",{"data-svelte-h":!0}),d(Hd)!=="svelte-eb77qn"&&(Hd.innerHTML=OT),mo.forEach(p),by=r(k),ja=l(k,"DIV",{class:!0});var sp=j(ja);h(ui.$$.fragment,sp),yy=r(sp),Ud=l(sp,"P",{"data-svelte-h":!0}),d(Ud)!=="svelte-2wnalp"&&(Ud.textContent=KT),sp.forEach(p),vy=r(k),un=l(k,"DIV",{class:!0});var _o=j(un);h(hi.$$.fragment,_o),xy=r(_o),Cd=l(_o,"P",{"data-svelte-h":!0}),d(Cd)!=="svelte-idifvk"&&(Cd.textContent=e0),$y=r(_o),Id=l(_o,"P",{"data-svelte-h":!0}),d(Id)!=="svelte-xt39ay"&&(Id.innerHTML=t0),_o.forEach(p),wy=r(k),Ma=l(k,"DIV",{class:!0});var rp=j(Ma);h(fi.$$.fragment,rp),ky=r(rp),Jd=l(rp,"P",{"data-svelte-h":!0}),d(Jd)!=="svelte-1k595hs"&&(Jd.textContent=n0),rp.forEach(p),Ty=r(k),hn=l(k,"DIV",{class:!0});var bo=j(hn);h(mi.$$.fragment,bo),jy=r(bo),Nd=l(bo,"P",{"data-svelte-h":!0}),d(Nd)!=="svelte-odm3i5"&&(Nd.textContent=o0),My=r(bo),h(qa.$$.fragment,bo),bo.forEach(p),qy=r(k),fn=l(k,"DIV",{class:!0});var yo=j(fn);h(_i.$$.fragment,yo),Hy=r(yo),Ad=l(yo,"P",{"data-svelte-h":!0}),d(Ad)!=="svelte-u3qpxi"&&(Ad.textContent=a0),Uy=r(yo),h(Ha.$$.fragment,yo),yo.forEach(p),Cy=r(k),ze=l(k,"DIV",{class:!0});var Dt=j(ze);h(bi.$$.fragment,Dt),Iy=r(Dt),Ed=l(Dt,"P",{"data-svelte-h":!0}),d(Ed)!=="svelte-106oizm"&&(Ed.textContent=s0),Jy=r(Dt),Dd=l(Dt,"P",{"data-svelte-h":!0}),d(Dd)!=="svelte-1tfv4hv"&&(Dd.textContent=r0),Ny=r(Dt),h(Ua.$$.fragment,Dt),Dt.forEach(p),Ay=r(k),mn=l(k,"DIV",{class:!0});var vo=j(mn);h(yi.$$.fragment,vo),Ey=r(vo),Rd=l(vo,"P",{"data-svelte-h":!0}),d(Rd)!=="svelte-13117mw"&&(Rd.textContent=i0),Dy=r(vo),h(Ca.$$.fragment,vo),vo.forEach(p),Ry=r(k),_n=l(k,"DIV",{class:!0});var xo=j(_n);h(vi.$$.fragment,xo),Gy=r(xo),Gd=l(xo,"P",{"data-svelte-h":!0}),d(Gd)!=="svelte-isyqd"&&(Gd.textContent=c0),Zy=r(xo),h(Ia.$$.fragment,xo),xo.forEach(p),Fy=r(k),bn=l(k,"DIV",{class:!0});var $o=j(bn);h(xi.$$.fragment,$o),Sy=r($o),Zd=l($o,"P",{"data-svelte-h":!0}),d(Zd)!=="svelte-idzq2w"&&(Zd.textContent=l0),Ly=r($o),h(Ja.$$.fragment,$o),$o.forEach(p),Wy=r(k),yn=l(k,"DIV",{class:!0});var wo=j(yn);h($i.$$.fragment,wo),Vy=r(wo),Fd=l(wo,"P",{"data-svelte-h":!0}),d(Fd)!=="svelte-sivey2"&&(Fd.textContent=p0),By=r(wo),h(Na.$$.fragment,wo),wo.forEach(p),Py=r(k),Qe=l(k,"DIV",{class:!0});var Rt=j(Qe);h(wi.$$.fragment,Rt),Yy=r(Rt),Sd=l(Rt,"P",{"data-svelte-h":!0}),d(Sd)!=="svelte-1niezvm"&&(Sd.textContent=d0),Xy=r(Rt),Ld=l(Rt,"P",{"data-svelte-h":!0}),d(Ld)!=="svelte-164ppjv"&&(Ld.innerHTML=g0),zy=r(Rt),h(Aa.$$.fragment,Rt),Rt.forEach(p),Qy=r(k),Ea=l(k,"DIV",{class:!0});var ip=j(Ea);h(ki.$$.fragment,ip),Oy=r(ip),Wd=l(ip,"P",{"data-svelte-h":!0}),d(Wd)!=="svelte-1o179eo"&&(Wd.textContent=u0),ip.forEach(p),Ky=r(k),Oe=l(k,"DIV",{class:!0});var Gt=j(Oe);h(Ti.$$.fragment,Gt),ev=r(Gt),Vd=l(Gt,"P",{"data-svelte-h":!0}),d(Vd)!=="svelte-1av5ht1"&&(Vd.textContent=h0),tv=r(Gt),Bd=l(Gt,"P",{"data-svelte-h":!0}),d(Bd)!=="svelte-1on7ni7"&&(Bd.innerHTML=f0),nv=r(Gt),h(Da.$$.fragment,Gt),Gt.forEach(p),ov=r(k),Ra=l(k,"DIV",{class:!0});var cp=j(Ra);h(ji.$$.fragment,cp),av=r(cp),Pd=l(cp,"P",{"data-svelte-h":!0}),d(Pd)!=="svelte-1a5sg0y"&&(Pd.textContent=m0),cp.forEach(p),sv=r(k),Ga=l(k,"DIV",{class:!0});var lp=j(Ga);h(Mi.$$.fragment,lp),rv=r(lp),Yd=l(lp,"P",{"data-svelte-h":!0}),d(Yd)!=="svelte-13tt6xv"&&(Yd.textContent=_0),lp.forEach(p),iv=r(k),vn=l(k,"DIV",{class:!0});var ko=j(vn);h(qi.$$.fragment,ko),cv=r(ko),Xd=l(ko,"P",{"data-svelte-h":!0}),d(Xd)!=="svelte-oj23bg"&&(Xd.textContent=b0),lv=r(ko),h(Za.$$.fragment,ko),ko.forEach(p),pv=r(k),Fa=l(k,"DIV",{class:!0});var pp=j(Fa);h(Hi.$$.fragment,pp),dv=r(pp),zd=l(pp,"P",{"data-svelte-h":!0}),d(zd)!=="svelte-d99h9l"&&(zd.textContent=y0),pp.forEach(p),gv=r(k),xn=l(k,"DIV",{class:!0});var To=j(xn);h(Ui.$$.fragment,To),uv=r(To),Qd=l(To,"P",{"data-svelte-h":!0}),d(Qd)!=="svelte-fasffe"&&(Qd.textContent=v0),hv=r(To),h(Sa.$$.fragment,To),To.forEach(p),fv=r(k),he=l(k,"DIV",{class:!0});var Ue=j(he);h(Ci.$$.fragment,Ue),mv=r(Ue),Od=l(Ue,"P",{"data-svelte-h":!0}),d(Od)!=="svelte-1ipows8"&&(Od.textContent=x0),_v=r(Ue),Kd=l(Ue,"P",{"data-svelte-h":!0}),d(Kd)!=="svelte-11lpom8"&&(Kd.textContent=$0),bv=r(Ue),h(La.$$.fragment,Ue),yv=r(Ue),h(Wa.$$.fragment,Ue),Ue.forEach(p),vv=r(k),P=l(k,"DIV",{class:!0});var ie=j(P);h(Ii.$$.fragment,ie),xv=r(ie),eg=l(ie,"P",{"data-svelte-h":!0}),d(eg)!=="svelte-1d865z6"&&(eg.textContent=w0),$v=r(ie),tg=l(ie,"P",{"data-svelte-h":!0}),d(tg)!=="svelte-vb94yg"&&(tg.textContent=k0),wv=r(ie),ng=l(ie,"P",{"data-svelte-h":!0}),d(ng)!=="svelte-cpm9yd"&&(ng.innerHTML=T0),kv=r(ie),og=l(ie,"P",{"data-svelte-h":!0}),d(og)!=="svelte-ndzof3"&&(og.innerHTML=j0),Tv=r(ie),h(Va.$$.fragment,ie),ie.forEach(p),jv=r(k),Ba=l(k,"DIV",{class:!0});var dp=j(Ba);h(Ji.$$.fragment,dp),Mv=r(dp),ag=l(dp,"P",{"data-svelte-h":!0}),d(ag)!=="svelte-130dnbj"&&(ag.textContent=M0),dp.forEach(p),qv=r(k),$n=l(k,"DIV",{class:!0});var jo=j($n);h(Ni.$$.fragment,jo),Hv=r(jo),sg=l(jo,"P",{"data-svelte-h":!0}),d(sg)!=="svelte-20b1wq"&&(sg.textContent=q0),Uv=r(jo),rg=l(jo,"P",{"data-svelte-h":!0}),d(rg)!=="svelte-xt39ay"&&(rg.innerHTML=H0),jo.forEach(p),Cv=r(k),Ke=l(k,"DIV",{class:!0});var Zt=j(Ke);h(Ai.$$.fragment,Zt),Iv=r(Zt),ig=l(Zt,"P",{"data-svelte-h":!0}),d(ig)!=="svelte-1vu5uho"&&(ig.innerHTML=U0),Jv=r(Zt),h(Pa.$$.fragment,Zt),Nv=r(Zt),cg=l(Zt,"P",{"data-svelte-h":!0}),d(cg)!=="svelte-65kopl"&&(cg.innerHTML=C0),Zt.forEach(p),Av=r(k),Ya=l(k,"DIV",{class:!0});var gp=j(Ya);h(Ei.$$.fragment,gp),Ev=r(gp),lg=l(gp,"P",{"data-svelte-h":!0}),d(lg)!=="svelte-i5g6s6"&&(lg.textContent=I0),gp.forEach(p),Dv=r(k),wn=l(k,"DIV",{class:!0});var Mo=j(wn);h(Di.$$.fragment,Mo),Rv=r(Mo),pg=l(Mo,"P",{"data-svelte-h":!0}),d(pg)!=="svelte-1qqa7u0"&&(pg.textContent=J0),Gv=r(Mo),h(Xa.$$.fragment,Mo),Mo.forEach(p),Zv=r(k),et=l(k,"DIV",{class:!0});var Ft=j(et);h(Ri.$$.fragment,Ft),Fv=r(Ft),dg=l(Ft,"P",{"data-svelte-h":!0}),d(dg)!=="svelte-19fc6id"&&(dg.textContent=N0),Sv=r(Ft),gg=l(Ft,"P",{"data-svelte-h":!0}),d(gg)!=="svelte-14mt8n5"&&(gg.innerHTML=A0),Lv=r(Ft),ug=l(Ft,"P",{"data-svelte-h":!0}),d(ug)!=="svelte-xxbgtf"&&(ug.innerHTML=E0),Ft.forEach(p),Wv=r(k),Y=l(k,"DIV",{class:!0});var ce=j(Y);h(Gi.$$.fragment,ce),Vv=r(ce),hg=l(ce,"P",{"data-svelte-h":!0}),d(hg)!=="svelte-gsbehr"&&(hg.textContent=D0),Bv=r(ce),fg=l(ce,"P",{"data-svelte-h":!0}),d(fg)!=="svelte-1rkm1l0"&&(fg.textContent=R0),Pv=r(ce),mg=l(ce,"UL",{"data-svelte-h":!0}),d(mg)!=="svelte-1t8qnom"&&(mg.innerHTML=G0),Yv=r(ce),h(za.$$.fragment,ce),Xv=r(ce),_g=l(ce,"P",{"data-svelte-h":!0}),d(_g)!=="svelte-mwwpv9"&&(_g.innerHTML=Z0),ce.forEach(p),zv=r(k),tt=l(k,"DIV",{class:!0});var St=j(tt);h(Zi.$$.fragment,St),Qv=r(St),bg=l(St,"P",{"data-svelte-h":!0}),d(bg)!=="svelte-1ia1m9g"&&(bg.textContent=F0),Ov=r(St),h(Qa.$$.fragment,St),Kv=r(St),h(Oa.$$.fragment,St),St.forEach(p),ex=r(k),kn=l(k,"DIV",{class:!0});var qo=j(kn);h(Fi.$$.fragment,qo),tx=r(qo),yg=l(qo,"P",{"data-svelte-h":!0}),d(yg)!=="svelte-1eaf7r1"&&(yg.textContent=S0),nx=r(qo),h(Ka.$$.fragment,qo),qo.forEach(p),ox=r(k),Tn=l(k,"DIV",{class:!0});var Ho=j(Tn);h(Si.$$.fragment,Ho),ax=r(Ho),vg=l(Ho,"P",{"data-svelte-h":!0}),d(vg)!=="svelte-zmo2i"&&(vg.textContent=L0),sx=r(Ho),h(es.$$.fragment,Ho),Ho.forEach(p),rx=r(k),fe=l(k,"DIV",{class:!0});var Ce=j(fe);h(Li.$$.fragment,Ce),ix=r(Ce),xg=l(Ce,"P",{"data-svelte-h":!0}),d(xg)!=="svelte-1a7k7d"&&(xg.textContent=W0),cx=r(Ce),$g=l(Ce,"P",{"data-svelte-h":!0}),d($g)!=="svelte-145s2tk"&&($g.innerHTML=V0),lx=r(Ce),wg=l(Ce,"P",{"data-svelte-h":!0}),d(wg)!=="svelte-xxbgtf"&&(wg.innerHTML=B0),px=r(Ce),h(ts.$$.fragment,Ce),Ce.forEach(p),dx=r(k),jn=l(k,"DIV",{class:!0});var Uo=j(jn);h(Wi.$$.fragment,Uo),gx=r(Uo),kg=l(Uo,"P",{"data-svelte-h":!0}),d(kg)!=="svelte-1rbvjim"&&(kg.textContent=P0),ux=r(Uo),h(ns.$$.fragment,Uo),Uo.forEach(p),hx=r(k),nt=l(k,"DIV",{class:!0});var Lt=j(nt);h(Vi.$$.fragment,Lt),fx=r(Lt),Tg=l(Lt,"P",{"data-svelte-h":!0}),d(Tg)!=="svelte-f61qi5"&&(Tg.textContent=Y0),mx=r(Lt),h(os.$$.fragment,Lt),_x=r(Lt),h(as.$$.fragment,Lt),Lt.forEach(p),bx=r(k),me=l(k,"DIV",{class:!0});var Ie=j(me);h(Bi.$$.fragment,Ie),yx=r(Ie),jg=l(Ie,"P",{"data-svelte-h":!0}),d(jg)!=="svelte-5021cf"&&(jg.textContent=X0),vx=r(Ie),Mg=l(Ie,"P",{"data-svelte-h":!0}),d(Mg)!=="svelte-s9x0iz"&&(Mg.innerHTML=z0),xx=r(Ie),qg=l(Ie,"P",{"data-svelte-h":!0}),d(qg)!=="svelte-1rebg38"&&(qg.innerHTML=Q0),$x=r(Ie),h(ss.$$.fragment,Ie),Ie.forEach(p),wx=r(k),Mn=l(k,"DIV",{class:!0});var Co=j(Mn);h(Pi.$$.fragment,Co),kx=r(Co),Hg=l(Co,"P",{"data-svelte-h":!0}),d(Hg)!=="svelte-omx1g3"&&(Hg.textContent=O0),Tx=r(Co),h(rs.$$.fragment,Co),Co.forEach(p),jx=r(k),is=l(k,"DIV",{class:!0});var up=j(is);h(Yi.$$.fragment,up),Mx=r(up),Ug=l(up,"P",{"data-svelte-h":!0}),d(Ug)!=="svelte-2krbhz"&&(Ug.textContent=K0),up.forEach(p),qx=r(k),ot=l(k,"DIV",{class:!0});var Wt=j(ot);h(Xi.$$.fragment,Wt),Hx=r(Wt),Cg=l(Wt,"P",{"data-svelte-h":!0}),d(Cg)!=="svelte-1wmqeve"&&(Cg.textContent=ej),Ux=r(Wt),Ig=l(Wt,"P",{"data-svelte-h":!0}),d(Ig)!=="svelte-1qhy0tu"&&(Ig.innerHTML=tj),Cx=r(Wt),h(cs.$$.fragment,Wt),Wt.forEach(p),Ix=r(k),_e=l(k,"DIV",{class:!0});var Je=j(_e);h(zi.$$.fragment,Je),Jx=r(Je),Jg=l(Je,"P",{"data-svelte-h":!0}),d(Jg)!=="svelte-lufmym"&&(Jg.textContent=nj),Nx=r(Je),Ng=l(Je,"P",{"data-svelte-h":!0}),d(Ng)!=="svelte-517n25"&&(Ng.innerHTML=oj),Ax=r(Je),Ag=l(Je,"P",{"data-svelte-h":!0}),d(Ag)!=="svelte-1qdx753"&&(Ag.innerHTML=aj),Ex=r(Je),h(ls.$$.fragment,Je),Je.forEach(p),Dx=r(k),qn=l(k,"DIV",{class:!0});var Io=j(qn);h(Qi.$$.fragment,Io),Rx=r(Io),Eg=l(Io,"P",{"data-svelte-h":!0}),d(Eg)!=="svelte-7xr8du"&&(Eg.textContent=sj),Gx=r(Io),h(ps.$$.fragment,Io),Io.forEach(p),Zx=r(k),ds=l(k,"DIV",{class:!0});var hp=j(ds);h(Oi.$$.fragment,hp),Fx=r(hp),Dg=l(hp,"P",{"data-svelte-h":!0}),d(Dg)!=="svelte-1lk5pt4"&&(Dg.textContent=rj),hp.forEach(p),Sx=r(k),Hn=l(k,"DIV",{class:!0});var Jo=j(Hn);h(Ki.$$.fragment,Jo),Lx=r(Jo),Rg=l(Jo,"P",{"data-svelte-h":!0}),d(Rg)!=="svelte-1qh0k4h"&&(Rg.textContent=ij),Wx=r(Jo),h(gs.$$.fragment,Jo),Jo.forEach(p),Vx=r(k),be=l(k,"DIV",{class:!0});var Ne=j(be);h(ec.$$.fragment,Ne),Bx=r(Ne),Gg=l(Ne,"P",{"data-svelte-h":!0}),d(Gg)!=="svelte-1tc2fi9"&&(Gg.textContent=cj),Px=r(Ne),Zg=l(Ne,"P",{"data-svelte-h":!0}),d(Zg)!=="svelte-svm7t8"&&(Zg.innerHTML=lj),Yx=r(Ne),Fg=l(Ne,"P",{"data-svelte-h":!0}),d(Fg)!=="svelte-xxbgtf"&&(Fg.innerHTML=pj),Xx=r(Ne),h(us.$$.fragment,Ne),Ne.forEach(p),zx=r(k),ye=l(k,"DIV",{class:!0});var Ae=j(ye);h(tc.$$.fragment,Ae),Qx=r(Ae),Sg=l(Ae,"P",{"data-svelte-h":!0}),d(Sg)!=="svelte-eo3dek"&&(Sg.textContent=dj),Ox=r(Ae),Lg=l(Ae,"P",{"data-svelte-h":!0}),d(Lg)!=="svelte-fokgh9"&&(Lg.innerHTML=gj),Kx=r(Ae),Wg=l(Ae,"P",{"data-svelte-h":!0}),d(Wg)!=="svelte-xxbgtf"&&(Wg.innerHTML=uj),e$=r(Ae),h(hs.$$.fragment,Ae),Ae.forEach(p),t$=r(k),at=l(k,"DIV",{class:!0});var Vt=j(at);h(nc.$$.fragment,Vt),n$=r(Vt),Vg=l(Vt,"P",{"data-svelte-h":!0}),d(Vg)!=="svelte-1vpgi7z"&&(Vg.textContent=hj),o$=r(Vt),Bg=l(Vt,"P",{"data-svelte-h":!0}),d(Bg)!=="svelte-11ohrqa"&&(Bg.textContent=fj),a$=r(Vt),h(fs.$$.fragment,Vt),Vt.forEach(p),s$=r(k),ms=l(k,"DIV",{class:!0});var fp=j(ms);h(oc.$$.fragment,fp),r$=r(fp),Pg=l(fp,"P",{"data-svelte-h":!0}),d(Pg)!=="svelte-wnw53w"&&(Pg.textContent=mj),fp.forEach(p),i$=r(k),Un=l(k,"DIV",{class:!0});var No=j(Un);h(ac.$$.fragment,No),c$=r(No),Yg=l(No,"P",{"data-svelte-h":!0}),d(Yg)!=="svelte-b4yhj"&&(Yg.textContent=_j),l$=r(No),Xg=l(No,"P",{"data-svelte-h":!0}),d(Xg)!=="svelte-19j5u9b"&&(Xg.innerHTML=bj),No.forEach(p),p$=r(k),Cn=l(k,"DIV",{class:!0});var Ao=j(Cn);h(sc.$$.fragment,Ao),d$=r(Ao),zg=l(Ao,"P",{"data-svelte-h":!0}),d(zg)!=="svelte-12l2ojn"&&(zg.textContent=yj),g$=r(Ao),h(_s.$$.fragment,Ao),Ao.forEach(p),u$=r(k),Z=l(k,"DIV",{class:!0});var S=j(Z);h(rc.$$.fragment,S),h$=r(S),Qg=l(S,"P",{"data-svelte-h":!0}),d(Qg)!=="svelte-ihiuvu"&&(Qg.textContent=vj),f$=r(S),Og=l(S,"P",{"data-svelte-h":!0}),d(Og)!=="svelte-kvfsh7"&&(Og.textContent=xj),m$=r(S),Kg=l(S,"P",{"data-svelte-h":!0}),d(Kg)!=="svelte-cs4ah2"&&(Kg.textContent=$j),_$=r(S),h(bs.$$.fragment,S),b$=r(S),eu=l(S,"P",{"data-svelte-h":!0}),d(eu)!=="svelte-1pnedrv"&&(eu.textContent=wj),y$=r(S),h(ys.$$.fragment,S),S.forEach(p),v$=r(k),vs=l(k,"DIV",{class:!0});var mp=j(vs);h(ic.$$.fragment,mp),x$=r(mp),tu=l(mp,"P",{"data-svelte-h":!0}),d(tu)!=="svelte-e35pw6"&&(tu.textContent=kj),mp.forEach(p),$$=r(k),xs=l(k,"DIV",{class:!0});var _p=j(xs);h(cc.$$.fragment,_p),w$=r(_p),nu=l(_p,"P",{"data-svelte-h":!0}),d(nu)!=="svelte-uowooj"&&(nu.textContent=Tj),_p.forEach(p),k$=r(k),$s=l(k,"DIV",{class:!0});var bp=j($s);h(lc.$$.fragment,bp),T$=r(bp),ou=l(bp,"P",{"data-svelte-h":!0}),d(ou)!=="svelte-apiozp"&&(ou.textContent=jj),bp.forEach(p),j$=r(k),ws=l(k,"DIV",{class:!0});var yp=j(ws);h(pc.$$.fragment,yp),M$=r(yp),au=l(yp,"P",{"data-svelte-h":!0}),d(au)!=="svelte-1qehg6u"&&(au.textContent=Mj),yp.forEach(p),q$=r(k),In=l(k,"DIV",{class:!0});var Eo=j(In);h(dc.$$.fragment,Eo),H$=r(Eo),su=l(Eo,"P",{"data-svelte-h":!0}),d(su)!=="svelte-zuangp"&&(su.textContent=qj),U$=r(Eo),h(ks.$$.fragment,Eo),Eo.forEach(p),C$=r(k),Jn=l(k,"DIV",{class:!0});var Do=j(Jn);h(gc.$$.fragment,Do),I$=r(Do),ru=l(Do,"P",{"data-svelte-h":!0}),d(ru)!=="svelte-tnvivq"&&(ru.textContent=Hj),J$=r(Do),h(Ts.$$.fragment,Do),Do.forEach(p),N$=r(k),st=l(k,"DIV",{class:!0});var Bt=j(st);h(uc.$$.fragment,Bt),A$=r(Bt),iu=l(Bt,"P",{"data-svelte-h":!0}),d(iu)!=="svelte-1qa90id"&&(iu.textContent=Uj),E$=r(Bt),cu=l(Bt,"P",{"data-svelte-h":!0}),d(cu)!=="svelte-1knrefm"&&(cu.textContent=Cj),D$=r(Bt),h(js.$$.fragment,Bt),Bt.forEach(p),R$=r(k),rt=l(k,"DIV",{class:!0});var Pt=j(rt);h(hc.$$.fragment,Pt),G$=r(Pt),lu=l(Pt,"P",{"data-svelte-h":!0}),d(lu)!=="svelte-3q13qo"&&(lu.textContent=Ij),Z$=r(Pt),pu=l(Pt,"P",{"data-svelte-h":!0}),d(pu)!=="svelte-1p5ibr4"&&(pu.innerHTML=Jj),F$=r(Pt),h(Ms.$$.fragment,Pt),Pt.forEach(p),S$=r(k),qs=l(k,"DIV",{class:!0});var vp=j(qs);h(fc.$$.fragment,vp),L$=r(vp),du=l(vp,"P",{"data-svelte-h":!0}),d(du)!=="svelte-15c9e8d"&&(du.textContent=Nj),vp.forEach(p),W$=r(k),it=l(k,"DIV",{class:!0});var Yt=j(it);h(mc.$$.fragment,Yt),V$=r(Yt),gu=l(Yt,"P",{"data-svelte-h":!0}),d(gu)!=="svelte-cs1v9f"&&(gu.textContent=Aj),B$=r(Yt),uu=l(Yt,"P",{"data-svelte-h":!0}),d(uu)!=="svelte-1kxlgey"&&(uu.innerHTML=Ej),P$=r(Yt),hu=l(Yt,"P",{"data-svelte-h":!0}),d(hu)!=="svelte-ndzof3"&&(hu.innerHTML=Dj),Yt.forEach(p),Y$=r(k),ct=l(k,"DIV",{class:!0});var Xt=j(ct);h(_c.$$.fragment,Xt),X$=r(Xt),fu=l(Xt,"P",{"data-svelte-h":!0}),d(fu)!=="svelte-16tls2x"&&(fu.textContent=Rj),z$=r(Xt),mu=l(Xt,"P",{"data-svelte-h":!0}),d(mu)!=="svelte-n0cprg"&&(mu.innerHTML=Gj),Q$=r(Xt),_u=l(Xt,"P",{"data-svelte-h":!0}),d(_u)!=="svelte-mf5z8c"&&(_u.innerHTML=Zj),Xt.forEach(p),O$=r(k),lt=l(k,"DIV",{class:!0});var zt=j(lt);h(bc.$$.fragment,zt),K$=r(zt),bu=l(zt,"P",{"data-svelte-h":!0}),d(bu)!=="svelte-keb9bv"&&(bu.textContent=Fj),e2=r(zt),yu=l(zt,"P",{"data-svelte-h":!0}),d(yu)!=="svelte-2lslon"&&(yu.innerHTML=Sj),t2=r(zt),vu=l(zt,"P",{"data-svelte-h":!0}),d(vu)!=="svelte-12do56u"&&(vu.innerHTML=Lj),zt.forEach(p),n2=r(k),pt=l(k,"DIV",{class:!0});var Qt=j(pt);h(yc.$$.fragment,Qt),o2=r(Qt),xu=l(Qt,"P",{"data-svelte-h":!0}),d(xu)!=="svelte-10xq13g"&&(xu.textContent=Wj),a2=r(Qt),h(Hs.$$.fragment,Qt),s2=r(Qt),h(Us.$$.fragment,Qt),Qt.forEach(p),r2=r(k),X=l(k,"DIV",{class:!0});var le=j(X);h(vc.$$.fragment,le),i2=r(le),$u=l(le,"P",{"data-svelte-h":!0}),d($u)!=="svelte-13c8xg2"&&($u.textContent=Vj),c2=r(le),wu=l(le,"P",{"data-svelte-h":!0}),d(wu)!=="svelte-5htwml"&&(wu.textContent=Bj),l2=r(le),h(Cs.$$.fragment,le),p2=r(le),h(Is.$$.fragment,le),d2=r(le),h(Js.$$.fragment,le),le.forEach(p),g2=r(k),dt=l(k,"DIV",{class:!0});var Ot=j(dt);h(xc.$$.fragment,Ot),u2=r(Ot),ku=l(Ot,"P",{"data-svelte-h":!0}),d(ku)!=="svelte-1o1ui5j"&&(ku.textContent=Pj),h2=r(Ot),Tu=l(Ot,"P",{"data-svelte-h":!0}),d(Tu)!=="svelte-zzdx9o"&&(Tu.innerHTML=Yj),f2=r(Ot),ju=l(Ot,"P",{"data-svelte-h":!0}),d(ju)!=="svelte-xxbgtf"&&(ju.innerHTML=Xj),Ot.forEach(p),m2=r(k),gt=l(k,"DIV",{class:!0});var Kt=j(gt);h($c.$$.fragment,Kt),_2=r(Kt),Mu=l(Kt,"P",{"data-svelte-h":!0}),d(Mu)!=="svelte-vjmct2"&&(Mu.textContent=zj),b2=r(Kt),h(Ns.$$.fragment,Kt),y2=r(Kt),h(As.$$.fragment,Kt),Kt.forEach(p),v2=r(k),Nn=l(k,"DIV",{class:!0});var Ro=j(Nn);h(wc.$$.fragment,Ro),x2=r(Ro),qu=l(Ro,"P",{"data-svelte-h":!0}),d(qu)!=="svelte-1h0ufuc"&&(qu.textContent=Qj),$2=r(Ro),h(Es.$$.fragment,Ro),Ro.forEach(p),w2=r(k),An=l(k,"DIV",{class:!0});var Go=j(An);h(kc.$$.fragment,Go),k2=r(Go),Hu=l(Go,"P",{"data-svelte-h":!0}),d(Hu)!=="svelte-1my46uo"&&(Hu.textContent=Oj),T2=r(Go),h(Ds.$$.fragment,Go),Go.forEach(p),j2=r(k),En=l(k,"DIV",{class:!0});var Zo=j(En);h(Tc.$$.fragment,Zo),M2=r(Zo),Uu=l(Zo,"P",{"data-svelte-h":!0}),d(Uu)!=="svelte-5pcxuz"&&(Uu.textContent=Kj),q2=r(Zo),h(Rs.$$.fragment,Zo),Zo.forEach(p),H2=r(k),Dn=l(k,"DIV",{class:!0});var Fo=j(Dn);h(jc.$$.fragment,Fo),U2=r(Fo),Cu=l(Fo,"P",{"data-svelte-h":!0}),d(Cu)!=="svelte-10aqzwl"&&(Cu.textContent=eM),C2=r(Fo),h(Gs.$$.fragment,Fo),Fo.forEach(p),I2=r(k),ut=l(k,"DIV",{class:!0});var en=j(ut);h(Mc.$$.fragment,en),J2=r(en),Iu=l(en,"P",{"data-svelte-h":!0}),d(Iu)!=="svelte-38gi4y"&&(Iu.textContent=tM),N2=r(en),Ju=l(en,"P",{"data-svelte-h":!0}),d(Ju)!=="svelte-65s7rh"&&(Ju.innerHTML=nM),A2=r(en),Nu=l(en,"P",{"data-svelte-h":!0}),d(Nu)!=="svelte-12do56u"&&(Nu.innerHTML=oM),en.forEach(p),E2=r(k),Rn=l(k,"DIV",{class:!0});var So=j(Rn);h(qc.$$.fragment,So),D2=r(So),Au=l(So,"P",{"data-svelte-h":!0}),d(Au)!=="svelte-o2dz8s"&&(Au.textContent=aM),R2=r(So),Eu=l(So,"P",{"data-svelte-h":!0}),d(Eu)!=="svelte-198t660"&&(Eu.innerHTML=sM),So.forEach(p),G2=r(k),Zs=l(k,"DIV",{class:!0});var xp=j(Zs);h(Hc.$$.fragment,xp),Z2=r(xp),Du=l(xp,"P",{"data-svelte-h":!0}),d(Du)!=="svelte-1772xvt"&&(Du.textContent=rM),xp.forEach(p),F2=r(k),Gn=l(k,"DIV",{class:!0});var Lo=j(Gn);h(Uc.$$.fragment,Lo),S2=r(Lo),Ru=l(Lo,"P",{"data-svelte-h":!0}),d(Ru)!=="svelte-kx7a2l"&&(Ru.textContent=iM),L2=r(Lo),h(Fs.$$.fragment,Lo),Lo.forEach(p),W2=r(k),ve=l(k,"DIV",{class:!0});var Ee=j(ve);h(Cc.$$.fragment,Ee),V2=r(Ee),Gu=l(Ee,"P",{"data-svelte-h":!0}),d(Gu)!=="svelte-i4rj9b"&&(Gu.textContent=cM),B2=r(Ee),Zu=l(Ee,"P",{"data-svelte-h":!0}),d(Zu)!=="svelte-15iw2gd"&&(Zu.innerHTML=lM),P2=r(Ee),Fu=l(Ee,"P",{"data-svelte-h":!0}),d(Fu)!=="svelte-8s7qco"&&(Fu.innerHTML=pM),Y2=r(Ee),h(Ss.$$.fragment,Ee),Ee.forEach(p),X2=r(k),xe=l(k,"DIV",{class:!0});var De=j(xe);h(Ic.$$.fragment,De),z2=r(De),Su=l(De,"P",{"data-svelte-h":!0}),d(Su)!=="svelte-1o4vhqw"&&(Su.textContent=dM),Q2=r(De),Lu=l(De,"P",{"data-svelte-h":!0}),d(Lu)!=="svelte-11lpom8"&&(Lu.textContent=gM),O2=r(De),h(Ls.$$.fragment,De),K2=r(De),h(Ws.$$.fragment,De),De.forEach(p),e1=r(k),z=l(k,"DIV",{class:!0});var pe=j(z);h(Jc.$$.fragment,pe),t1=r(pe),Wu=l(pe,"P",{"data-svelte-h":!0}),d(Wu)!=="svelte-13uq06b"&&(Wu.textContent=uM),n1=r(pe),Vu=l(pe,"P",{"data-svelte-h":!0}),d(Vu)!=="svelte-11lpom8"&&(Vu.textContent=hM),o1=r(pe),h(Vs.$$.fragment,pe),a1=r(pe),h(Bs.$$.fragment,pe),s1=r(pe),h(Ps.$$.fragment,pe),pe.forEach(p),r1=r(k),ht=l(k,"DIV",{class:!0});var tn=j(ht);h(Nc.$$.fragment,tn),i1=r(tn),Bu=l(tn,"P",{"data-svelte-h":!0}),d(Bu)!=="svelte-6vx93v"&&(Bu.textContent=fM),c1=r(tn),Pu=l(tn,"P",{"data-svelte-h":!0}),d(Pu)!=="svelte-1992tg8"&&(Pu.innerHTML=mM),l1=r(tn),Yu=l(tn,"P",{"data-svelte-h":!0}),d(Yu)!=="svelte-gmy86i"&&(Yu.innerHTML=_M),tn.forEach(p),p1=r(k),ft=l(k,"DIV",{class:!0});var nn=j(ft);h(Ac.$$.fragment,nn),d1=r(nn),Xu=l(nn,"P",{"data-svelte-h":!0}),d(Xu)!=="svelte-h8ye5s"&&(Xu.textContent=bM),g1=r(nn),zu=l(nn,"P",{"data-svelte-h":!0}),d(zu)!=="svelte-1u14fwi"&&(zu.innerHTML=yM),u1=r(nn),h(Ys.$$.fragment,nn),nn.forEach(p),h1=r(k),$e=l(k,"DIV",{class:!0});var Re=j($e);h(Ec.$$.fragment,Re),f1=r(Re),Qu=l(Re,"P",{"data-svelte-h":!0}),d(Qu)!=="svelte-t9d1pp"&&(Qu.textContent=vM),m1=r(Re),Ou=l(Re,"P",{"data-svelte-h":!0}),d(Ou)!=="svelte-xxyl9g"&&(Ou.innerHTML=xM),_1=r(Re),Ku=l(Re,"P",{"data-svelte-h":!0}),d(Ku)!=="svelte-1v8h65f"&&(Ku.innerHTML=$M),b1=r(Re),eh=l(Re,"P",{"data-svelte-h":!0}),d(eh)!=="svelte-k7g81c"&&(eh.textContent=wM),Re.forEach(p),y1=r(k),mt=l(k,"DIV",{class:!0});var on=j(mt);h(Dc.$$.fragment,on),v1=r(on),th=l(on,"P",{"data-svelte-h":!0}),d(th)!=="svelte-1lgtcoe"&&(th.textContent=kM),x1=r(on),nh=l(on,"P",{"data-svelte-h":!0}),d(nh)!=="svelte-zugpyn"&&(nh.textContent=TM),$1=r(on),h(Xs.$$.fragment,on),on.forEach(p),w1=r(k),Q=l(k,"DIV",{class:!0});var de=j(Q);h(Rc.$$.fragment,de),k1=r(de),oh=l(de,"P",{"data-svelte-h":!0}),d(oh)!=="svelte-1j5taqn"&&(oh.textContent=jM),T1=r(de),ah=l(de,"P",{"data-svelte-h":!0}),d(ah)!=="svelte-1oloczu"&&(ah.textContent=MM),j1=r(de),h(zs.$$.fragment,de),M1=r(de),h(Qs.$$.fragment,de),q1=r(de),h(Os.$$.fragment,de),de.forEach(p),H1=r(k),Ks=l(k,"DIV",{class:!0});var $p=j(Ks);h(Gc.$$.fragment,$p),U1=r($p),sh=l($p,"P",{"data-svelte-h":!0}),d(sh)!=="svelte-1lxxeyj"&&(sh.textContent=qM),$p.forEach(p),C1=r(k),we=l(k,"DIV",{class:!0});var Ge=j(we);h(Zc.$$.fragment,Ge),I1=r(Ge),rh=l(Ge,"P",{"data-svelte-h":!0}),d(rh)!=="svelte-z82c1y"&&(rh.textContent=HM),J1=r(Ge),ih=l(Ge,"P",{"data-svelte-h":!0}),d(ih)!=="svelte-w9m9bs"&&(ih.innerHTML=UM),N1=r(Ge),ch=l(Ge,"P",{"data-svelte-h":!0}),d(ch)!=="svelte-19j5u9b"&&(ch.innerHTML=CM),A1=r(Ge),h(er.$$.fragment,Ge),Ge.forEach(p),E1=r(k),Zn=l(k,"DIV",{class:!0});var Wo=j(Zn);h(Fc.$$.fragment,Wo),D1=r(Wo),lh=l(Wo,"P",{"data-svelte-h":!0}),d(lh)!=="svelte-klf1wz"&&(lh.textContent=IM),R1=r(Wo),h(tr.$$.fragment,Wo),Wo.forEach(p),G1=r(k),ke=l(k,"DIV",{class:!0});var Pn=j(ke);h(Sc.$$.fragment,Pn),Z1=r(Pn),ph=l(Pn,"P",{"data-svelte-h":!0}),d(ph)!=="svelte-6tdefx"&&(ph.textContent=JM),F1=r(Pn),dh=l(Pn,"P",{"data-svelte-h":!0}),d(dh)!=="svelte-sjutdt"&&(dh.textContent=NM),S1=r(Pn),gh=l(Pn,"P",{"data-svelte-h":!0}),d(gh)!=="svelte-164ppjv"&&(gh.innerHTML=AM),L1=r(Pn),h(nr.$$.fragment,Pn),Pn.forEach(p),W1=r(k),_t=l(k,"DIV",{class:!0});var Tr=j(_t);h(Lc.$$.fragment,Tr),V1=r(Tr),uh=l(Tr,"P",{"data-svelte-h":!0}),d(uh)!=="svelte-tgkk8q"&&(uh.textContent=EM),B1=r(Tr),hh=l(Tr,"P",{"data-svelte-h":!0}),d(hh)!=="svelte-1yeoh0w"&&(hh.textContent=DM),P1=r(Tr),fh=l(Tr,"P",{"data-svelte-h":!0}),d(fh)!=="svelte-1bxaipy"&&(fh.innerHTML=RM),Tr.forEach(p),Y1=r(k),Fn=l(k,"DIV",{class:!0});var Jf=j(Fn);h(Wc.$$.fragment,Jf),X1=r(Jf),mh=l(Jf,"P",{"data-svelte-h":!0}),d(mh)!=="svelte-1xslq7e"&&(mh.textContent=GM),z1=r(Jf),_h=l(Jf,"P",{"data-svelte-h":!0}),d(_h)!=="svelte-zgmljc"&&(_h.textContent=ZM),Jf.forEach(p),Q1=r(k),bt=l(k,"DIV",{class:!0});var jr=j(bt);h(Vc.$$.fragment,jr),O1=r(jr),bh=l(jr,"P",{"data-svelte-h":!0}),d(bh)!=="svelte-1icdi1y"&&(bh.textContent=FM),K1=r(jr),yh=l(jr,"P",{"data-svelte-h":!0}),d(yh)!=="svelte-1b93kvt"&&(yh.innerHTML=SM),ew=r(jr),h(or.$$.fragment,jr),jr.forEach(p),tw=r(k),Sn=l(k,"DIV",{class:!0});var Nf=j(Sn);h(Bc.$$.fragment,Nf),nw=r(Nf),vh=l(Nf,"P",{"data-svelte-h":!0}),d(vh)!=="svelte-1a9paom"&&(vh.textContent=LM),ow=r(Nf),h(ar.$$.fragment,Nf),Nf.forEach(p),aw=r(k),Te=l(k,"DIV",{class:!0});var Yn=j(Te);h(Pc.$$.fragment,Yn),sw=r(Yn),xh=l(Yn,"P",{"data-svelte-h":!0}),d(xh)!=="svelte-kukbcr"&&(xh.textContent=WM),rw=r(Yn),h(sr.$$.fragment,Yn),iw=r(Yn),h(rr.$$.fragment,Yn),cw=r(Yn),h(ir.$$.fragment,Yn),Yn.forEach(p),lw=r(k),N=l(k,"DIV",{class:!0});var D=j(N);h(Yc.$$.fragment,D),pw=r(D),$h=l(D,"P",{"data-svelte-h":!0}),d($h)!=="svelte-1nvey1d"&&($h.textContent=VM),dw=r(D),wh=l(D,"P",{"data-svelte-h":!0}),d(wh)!=="svelte-1vu0l4l"&&(wh.textContent=BM),gw=r(D),kh=l(D,"P",{"data-svelte-h":!0}),d(kh)!=="svelte-adrskp"&&(kh.innerHTML=PM),uw=r(D),Th=l(D,"P",{"data-svelte-h":!0}),d(Th)!=="svelte-1m6fudm"&&(Th.innerHTML=YM),hw=r(D),jh=l(D,"P",{"data-svelte-h":!0}),d(jh)!=="svelte-nojwu3"&&(jh.innerHTML=XM),fw=r(D),Mh=l(D,"P",{"data-svelte-h":!0}),d(Mh)!=="svelte-90ewc6"&&(Mh.innerHTML=zM),mw=r(D),h(cr.$$.fragment,D),_w=r(D),h(lr.$$.fragment,D),bw=r(D),h(pr.$$.fragment,D),yw=r(D),h(dr.$$.fragment,D),D.forEach(p),vw=r(k),J=l(k,"DIV",{class:!0});var E=j(J);h(Xc.$$.fragment,E),xw=r(E),qh=l(E,"P",{"data-svelte-h":!0}),d(qh)!=="svelte-1a1ittk"&&(qh.textContent=QM),$w=r(E),Hh=l(E,"P",{"data-svelte-h":!0}),d(Hh)!=="svelte-3l9535"&&(Hh.innerHTML=OM),ww=r(E),h(gr.$$.fragment,E),kw=r(E),h(ur.$$.fragment,E),Tw=r(E),Uh=l(E,"P",{"data-svelte-h":!0}),d(Uh)!=="svelte-8c4beu"&&(Uh.innerHTML=KM),jw=r(E),Ch=l(E,"P",{"data-svelte-h":!0}),d(Ch)!=="svelte-25734v"&&(Ch.innerHTML=eq),Mw=r(E),Ih=l(E,"OL",{"data-svelte-h":!0}),d(Ih)!=="svelte-1lqi3gd"&&(Ih.innerHTML=tq),qw=r(E),Jh=l(E,"P",{"data-svelte-h":!0}),d(Jh)!=="svelte-59ei85"&&(Jh.textContent=nq),Hw=r(E),Nh=l(E,"OL",{"data-svelte-h":!0}),d(Nh)!=="svelte-1igkyl7"&&(Nh.innerHTML=oq),Uw=r(E),Ah=l(E,"P",{"data-svelte-h":!0}),d(Ah)!=="svelte-w718ua"&&(Ah.textContent=aq),Cw=r(E),Eh=l(E,"UL",{"data-svelte-h":!0}),d(Eh)!=="svelte-c57nbb"&&(Eh.innerHTML=sq),E.forEach(p),Iw=r(k),hr=l(k,"DIV",{class:!0});var Xm=j(hr);h(zc.$$.fragment,Xm),Jw=r(Xm),Dh=l(Xm,"P",{"data-svelte-h":!0}),d(Dh)!=="svelte-l7gr50"&&(Dh.textContent=rq),Xm.forEach(p),k.forEach(p),Of=r(t),h(Qc.$$.fragment,t),Kf=r(t),h(Oc.$$.fragment,t),em=r(t),Kn=l(t,"DIV",{class:!0});var zm=j(Kn);h(Kc.$$.fragment,zm),Nw=r(zm),Rh=l(zm,"P",{"data-svelte-h":!0}),d(Rh)!=="svelte-frgpd7"&&(Rh.textContent=iq),zm.forEach(p),tm=r(t),h(el.$$.fragment,t),nm=r(t),vt=l(t,"DIV",{class:!0});var Af=j(vt);h(tl.$$.fragment,Af),Aw=r(Af),Gh=l(Af,"P",{"data-svelte-h":!0}),d(Gh)!=="svelte-n4j72f"&&(Gh.textContent=cq),Ew=r(Af),Zh=l(Af,"P",{"data-svelte-h":!0}),d(Zh)!=="svelte-102qt1n"&&(Zh.innerHTML=lq),Af.forEach(p),om=r(t),h(nl.$$.fragment,t),am=r(t),xt=l(t,"DIV",{class:!0});var Ef=j(xt);h(ol.$$.fragment,Ef),Dw=r(Ef),Fh=l(Ef,"P",{"data-svelte-h":!0}),d(Fh)!=="svelte-swwjpw"&&(Fh.innerHTML=pq),Rw=r(Ef),h(fr.$$.fragment,Ef),Ef.forEach(p),sm=r(t),h(al.$$.fragment,t),rm=r(t),eo=l(t,"DIV",{class:!0});var Qm=j(eo);h(sl.$$.fragment,Qm),Gw=r(Qm),Sh=l(Qm,"P",{"data-svelte-h":!0}),d(Sh)!=="svelte-1dp8z99"&&(Sh.textContent=dq),Qm.forEach(p),im=r(t),h(rl.$$.fragment,t),cm=r(t),to=l(t,"DIV",{class:!0});var Om=j(to);h(il.$$.fragment,Om),Zw=r(Om),Lh=l(Om,"P",{"data-svelte-h":!0}),d(Lh)!=="svelte-1m53mfe"&&(Lh.innerHTML=gq),Om.forEach(p),lm=r(t),h(cl.$$.fragment,t),pm=r(t),$t=l(t,"DIV",{class:!0});var Df=j($t);h(ll.$$.fragment,Df),Fw=r(Df),Wh=l(Df,"P",{"data-svelte-h":!0}),d(Wh)!=="svelte-8pkqdq"&&(Wh.textContent=uq),Sw=r(Df),Vh=l(Df,"P",{"data-svelte-h":!0}),d(Vh)!=="svelte-vdyl1q"&&(Vh.innerHTML=hq),Df.forEach(p),dm=r(t),h(pl.$$.fragment,t),gm=r(t),dl=l(t,"DIV",{class:!0});var nH=j(dl);h(gl.$$.fragment,nH),nH.forEach(p),um=r(t),h(ul.$$.fragment,t),hm=r(t),K=l(t,"DIV",{class:!0});var Xn=j(K);h(hl.$$.fragment,Xn),Lw=r(Xn),Bh=l(Xn,"P",{"data-svelte-h":!0}),d(Bh)!=="svelte-ezr8kg"&&(Bh.textContent=fq),Ww=r(Xn),Ph=l(Xn,"P",{"data-svelte-h":!0}),d(Ph)!=="svelte-1e5wnmv"&&(Ph.innerHTML=mq),Vw=r(Xn),Yh=l(Xn,"P",{"data-svelte-h":!0}),d(Yh)!=="svelte-333hb6"&&(Yh.innerHTML=_q),Bw=r(Xn),h(mr.$$.fragment,Xn),Xn.forEach(p),fm=r(t),h(fl.$$.fragment,t),mm=r(t),wt=l(t,"DIV",{class:!0});var Rf=j(wt);h(ml.$$.fragment,Rf),Pw=r(Rf),Xh=l(Rf,"P",{"data-svelte-h":!0}),d(Xh)!=="svelte-fvugq9"&&(Xh.innerHTML=bq),Yw=r(Rf),h(_r.$$.fragment,Rf),Rf.forEach(p),_m=r(t),h(_l.$$.fragment,t),bm=r(t),kt=l(t,"DIV",{class:!0});var Gf=j(kt);h(bl.$$.fragment,Gf),Xw=r(Gf),zh=l(Gf,"P",{"data-svelte-h":!0}),d(zh)!=="svelte-pzc88f"&&(zh.textContent=yq),zw=r(Gf),h(br.$$.fragment,Gf),Gf.forEach(p),ym=r(t),h(yl.$$.fragment,t),vm=r(t),no=l(t,"DIV",{class:!0});var Km=j(no);h(vl.$$.fragment,Km),Qw=r(Km),Qh=l(Km,"P",{"data-svelte-h":!0}),d(Qh)!=="svelte-1eicjbk"&&(Qh.textContent=vq),Km.forEach(p),xm=r(t),h(xl.$$.fragment,t),$m=r(t),ee=l(t,"DIV",{class:!0});var zn=j(ee);h($l.$$.fragment,zn),Ow=r(zn),Oh=l(zn,"P",{"data-svelte-h":!0}),d(Oh)!=="svelte-1v78htg"&&(Oh.innerHTML=xq),Kw=r(zn),Kh=l(zn,"P",{"data-svelte-h":!0}),d(Kh)!=="svelte-murgw9"&&(Kh.innerHTML=$q),ek=r(zn),ef=l(zn,"UL",{"data-svelte-h":!0}),d(ef)!=="svelte-1mrng5l"&&(ef.innerHTML=wq),tk=r(zn),h(yr.$$.fragment,zn),zn.forEach(p),wm=r(t),h(wl.$$.fragment,t),km=r(t),te=l(t,"DIV",{class:!0});var Qn=j(te);h(kl.$$.fragment,Qn),nk=r(Qn),tf=l(Qn,"P",{"data-svelte-h":!0}),d(tf)!=="svelte-ovnxfi"&&(tf.textContent=kq),ok=r(Qn),nf=l(Qn,"P",{"data-svelte-h":!0}),d(nf)!=="svelte-afv8fv"&&(nf.textContent=Tq),ak=r(Qn),of=l(Qn,"P",{"data-svelte-h":!0}),d(of)!=="svelte-18gvp4f"&&(of.innerHTML=jq),sk=r(Qn),af=l(Qn,"P",{"data-svelte-h":!0}),d(af)!=="svelte-ndzof3"&&(af.innerHTML=Mq),Qn.forEach(p),Tm=r(t),h(Tl.$$.fragment,t),jm=r(t),je=l(t,"DIV",{class:!0});var Mr=j(je);h(jl.$$.fragment,Mr),rk=r(Mr),sf=l(Mr,"P",{"data-svelte-h":!0}),d(sf)!=="svelte-2ejdv8"&&(sf.textContent=qq),ik=r(Mr),rf=l(Mr,"P",{"data-svelte-h":!0}),d(rf)!=="svelte-1ff2vxz"&&(rf.innerHTML=Hq),ck=r(Mr),cf=l(Mr,"P",{"data-svelte-h":!0}),d(cf)!=="svelte-ndzof3"&&(cf.innerHTML=Uq),Mr.forEach(p),Mm=r(t),h(Ml.$$.fragment,t),qm=r(t),Tt=l(t,"DIV",{class:!0});var Zf=j(Tt);h(ql.$$.fragment,Zf),lk=r(Zf),lf=l(Zf,"P",{"data-svelte-h":!0}),d(lf)!=="svelte-1fsd0x6"&&(lf.innerHTML=Cq),pk=r(Zf),h(vr.$$.fragment,Zf),Zf.forEach(p),Hm=r(t),h(Hl.$$.fragment,t),Um=r(t),jt=l(t,"DIV",{class:!0});var Ff=j(jt);h(Ul.$$.fragment,Ff),dk=r(Ff),pf=l(Ff,"P",{"data-svelte-h":!0}),d(pf)!=="svelte-by9v9h"&&(pf.textContent=Iq),gk=r(Ff),df=l(Ff,"P",{"data-svelte-h":!0}),d(df)!=="svelte-ndzof3"&&(df.innerHTML=Jq),Ff.forEach(p),Cm=r(t),h(Cl.$$.fragment,t),Im=r(t),oo=l(t,"DIV",{class:!0});var e_=j(oo);h(Il.$$.fragment,e_),uk=r(e_),gf=l(e_,"P",{"data-svelte-h":!0}),d(gf)!=="svelte-f10xp"&&(gf.textContent=Nq),e_.forEach(p),Jm=r(t),h(Jl.$$.fragment,t),Nm=r(t),ao=l(t,"DIV",{class:!0});var t_=j(ao);h(Nl.$$.fragment,t_),hk=r(t_),uf=l(t_,"P",{"data-svelte-h":!0}),d(uf)!=="svelte-s36het"&&(uf.textContent=Aq),t_.forEach(p),Am=r(t),h(Al.$$.fragment,t),Em=r(t),so=l(t,"DIV",{class:!0});var n_=j(so);h(El.$$.fragment,n_),fk=r(n_),hf=l(n_,"P",{"data-svelte-h":!0}),d(hf)!=="svelte-11wrzrg"&&(hf.textContent=Eq),n_.forEach(p),Dm=r(t),h(Dl.$$.fragment,t),Rm=r(t),ro=l(t,"DIV",{class:!0});var o_=j(ro);h(Rl.$$.fragment,o_),mk=r(o_),ff=l(o_,"P",{"data-svelte-h":!0}),d(ff)!=="svelte-10dpb22"&&(ff.textContent=Dq),o_.forEach(p),Gm=r(t),h(Gl.$$.fragment,t),Zm=r(t),Zl=l(t,"P",{"data-svelte-h":!0}),d(Zl)!=="svelte-eea1xn"&&(Zl.innerHTML=Rq),Fm=r(t),Me=l(t,"DIV",{class:!0});var qr=j(Me);h(Fl.$$.fragment,qr),_k=r(qr),mf=l(qr,"P",{"data-svelte-h":!0}),d(mf)!=="svelte-1nyzeix"&&(mf.textContent=Gq),bk=r(qr),Ln=l(qr,"DIV",{class:!0});var Sf=j(Ln);h(Sl.$$.fragment,Sf),yk=r(Sf),_f=l(Sf,"P",{"data-svelte-h":!0}),d(_f)!=="svelte-1d7s5nc"&&(_f.innerHTML=Zq),vk=r(Sf),h(xr.$$.fragment,Sf),Sf.forEach(p),xk=r(qr),Wn=l(qr,"DIV",{class:!0});var Lf=j(Wn);h(Ll.$$.fragment,Lf),$k=r(Lf),bf=l(Lf,"P",{"data-svelte-h":!0}),d(bf)!=="svelte-1o44akx"&&(bf.innerHTML=Fq),wk=r(Lf),yf=l(Lf,"P",{"data-svelte-h":!0}),d(yf)!=="svelte-huzhzj"&&(yf.innerHTML=Sq),Lf.forEach(p),qr.forEach(p),Sm=r(t),io=l(t,"DIV",{class:!0});var a_=j(io);h(Wl.$$.fragment,a_),kk=r(a_),vf=l(a_,"P",{"data-svelte-h":!0}),d(vf)!=="svelte-1cij9yu"&&(vf.textContent=Lq),a_.forEach(p),Lm=r(t),ne=l(t,"DIV",{class:!0});var On=j(ne);h(Vl.$$.fragment,On),Tk=r(On),xf=l(On,"P",{"data-svelte-h":!0}),d(xf)!=="svelte-bx32lj"&&(xf.textContent=Wq),jk=r(On),$f=l(On,"P",{"data-svelte-h":!0}),d($f)!=="svelte-1a6nwfz"&&($f.textContent=Vq),Mk=r(On),wf=l(On,"UL",{"data-svelte-h":!0}),d(wf)!=="svelte-1wreq5n"&&(wf.innerHTML=Bq),qk=r(On),kf=l(On,"P",{"data-svelte-h":!0}),d(kf)!=="svelte-zlmtk1"&&(kf.innerHTML=Pq),On.forEach(p),Wm=r(t),h(Bl.$$.fragment,t),Vm=r(t),R=l(t,"DIV",{class:!0});var O=j(R);h(Pl.$$.fragment,O),Hk=r(O),Tf=l(O,"P",{"data-svelte-h":!0}),d(Tf)!=="svelte-1wfz9hx"&&(Tf.textContent=Yq),Uk=r(O),jf=l(O,"P",{"data-svelte-h":!0}),d(jf)!=="svelte-10g22je"&&(jf.innerHTML=Xq),Ck=r(O),h($r.$$.fragment,O),Ik=r(O),h(wr.$$.fragment,O),Jk=r(O),yt=l(O,"DIV",{class:!0});var Hr=j(yt);h(Yl.$$.fragment,Hr),Nk=r(Hr),Mf=l(Hr,"P",{"data-svelte-h":!0}),d(Mf)!=="svelte-e95u7k"&&(Mf.textContent=zq),Ak=r(Hr),h(kr.$$.fragment,Hr),Ek=r(Hr),qf=l(Hr,"P",{"data-svelte-h":!0}),d(qf)!=="svelte-eijr4"&&(qf.innerHTML=Qq),Hr.forEach(p),Dk=r(O),Vn=l(O,"DIV",{class:!0});var Wf=j(Vn);h(Xl.$$.fragment,Wf),Rk=r(Wf),Hf=l(Wf,"P",{"data-svelte-h":!0}),d(Hf)!=="svelte-t1x1k0"&&(Hf.textContent=Oq),Gk=r(Wf),Uf=l(Wf,"P",{"data-svelte-h":!0}),d(Uf)!=="svelte-1jdo3t2"&&(Uf.textContent=Kq),Wf.forEach(p),Zk=r(O),Bn=l(O,"DIV",{class:!0});var Vf=j(Bn);h(zl.$$.fragment,Vf),Fk=r(Vf),Cf=l(Vf,"P",{"data-svelte-h":!0}),d(Cf)!=="svelte-m2dnyn"&&(Cf.innerHTML=eH),Sk=r(Vf),If=l(Vf,"P",{"data-svelte-h":!0}),d(If)!=="svelte-aasb0o"&&(If.innerHTML=tH),Vf.forEach(p),O.forEach(p),Bm=r(t),h(Ql.$$.fragment,t),Pm=r(t),Bf=l(t,"P",{}),j(Bf).forEach(p),this.h()},h(){M(n,"name","hf:doc:metadata"),M(n,"content",v4),M(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Po,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Oo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(la,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ma,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ya,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ka,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ta,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ja,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ma,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ea,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ra,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ga,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ba,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ya,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(is,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ds,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ms,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ws,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(In,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(An,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(En,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ks,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(eo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(to,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(no,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ao,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(so,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ro,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(io,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,v){o(document.head,n),$(t,y,v),$(t,i,v),$(t,a,v),f(g,t,v),$(t,e,v),$(t,x,v),$(t,Pf,v),$(t,Ur,v),$(t,Yf,v),$(t,Cr,v),$(t,Xf,v),f(Ir,t,v),$(t,zf,v),f(Jr,t,v),$(t,Qf,v),$(t,w,v),f(Nr,w,null),o(w,s_),o(w,wp),o(w,r_),o(w,kp),o(w,i_),o(w,Ze),f(Ar,Ze,null),o(Ze,c_),o(Ze,Tp),o(Ze,l_),o(Ze,jp),o(Ze,p_),o(Ze,Mp),o(w,d_),o(w,Fe),f(Er,Fe,null),o(Fe,g_),o(Fe,qp),o(Fe,u_),o(Fe,Hp),o(Fe,h_),f(Vo,Fe,null),o(w,f_),o(w,an),f(Dr,an,null),o(an,m_),o(an,Up),o(an,__),o(an,Cp),o(w,b_),o(w,sn),f(Rr,sn,null),o(sn,y_),o(sn,Ip),o(sn,v_),o(sn,Jp),o(w,x_),o(w,G),f(Gr,G,null),o(G,$_),o(G,Np),o(G,w_),o(G,Ap),o(G,k_),o(G,Ep),o(G,T_),f(Bo,G,null),o(G,j_),o(G,Dp),o(G,M_),o(G,Rp),o(w,q_),o(w,Se),f(Zr,Se,null),o(Se,H_),o(Se,Gp),o(Se,U_),o(Se,Zp),o(Se,C_),o(Se,Fp),o(w,I_),o(w,Po),f(Fr,Po,null),o(Po,J_),o(Po,Sp),o(w,N_),o(w,Le),f(Sr,Le,null),o(Le,A_),o(Le,Lp),o(Le,E_),f(Yo,Le,null),o(Le,D_),f(Xo,Le,null),o(w,R_),o(w,We),f(Lr,We,null),o(We,G_),o(We,Wp),o(We,Z_),f(zo,We,null),o(We,F_),f(Qo,We,null),o(w,S_),o(w,Oo),f(Wr,Oo,null),o(Oo,L_),o(Oo,Vp),o(w,W_),o(w,Ve),f(Vr,Ve,null),o(Ve,V_),o(Ve,Bp),o(Ve,B_),o(Ve,Pp),o(Ve,P_),f(Ko,Ve,null),o(w,Y_),o(w,ge),f(Br,ge,null),o(ge,X_),o(ge,Yp),o(ge,z_),f(ea,ge,null),o(ge,Q_),f(ta,ge,null),o(ge,O_),f(na,ge,null),o(w,K_),o(w,L),f(Pr,L,null),o(L,eb),o(L,Xp),o(L,tb),o(L,zp),o(L,nb),o(L,Qp),o(L,ob),o(L,Op),o(L,ab),f(oa,L,null),o(w,sb),o(w,ue),f(Yr,ue,null),o(ue,rb),o(ue,Kp),o(ue,ib),f(aa,ue,null),o(ue,cb),f(sa,ue,null),o(ue,lb),f(ra,ue,null),o(w,pb),o(w,Be),f(Xr,Be,null),o(Be,db),o(Be,ed),o(Be,gb),o(Be,td),o(Be,ub),f(ia,Be,null),o(w,hb),o(w,W),f(zr,W,null),o(W,fb),o(W,nd),o(W,mb),o(W,od),o(W,_b),o(W,ad),o(W,bb),o(W,sd),o(W,yb),f(ca,W,null),o(w,vb),o(w,la),f(Qr,la,null),o(la,xb),o(la,rd),o(w,$b),o(w,V),f(Or,V,null),o(V,wb),o(V,id),o(V,kb),o(V,cd),o(V,Tb),f(pa,V,null),o(V,jb),f(da,V,null),o(V,Mb),f(ga,V,null),o(w,qb),o(w,B),f(Kr,B,null),o(B,Hb),o(B,ld),o(B,Ub),o(B,pd),o(B,Cb),f(ua,B,null),o(B,Ib),f(ha,B,null),o(B,Jb),f(fa,B,null),o(w,Nb),o(w,ma),f(ei,ma,null),o(ma,Ab),o(ma,dd),o(w,Eb),o(w,rn),f(ti,rn,null),o(rn,Db),o(rn,gd),o(rn,Rb),f(_a,rn,null),o(w,Gb),o(w,Pe),f(ni,Pe,null),o(Pe,Zb),o(Pe,ud),o(Pe,Fb),o(Pe,hd),o(Pe,Sb),f(ba,Pe,null),o(w,Lb),o(w,ya),f(oi,ya,null),o(ya,Wb),o(ya,fd),o(w,Vb),o(w,Ye),f(ai,Ye,null),o(Ye,Bb),o(Ye,md),o(Ye,Pb),f(va,Ye,null),o(Ye,Yb),f(xa,Ye,null),o(w,Xb),o(w,cn),f(si,cn,null),o(cn,zb),o(cn,_d),o(cn,Qb),f($a,cn,null),o(w,Ob),o(w,ln),f(ri,ln,null),o(ln,Kb),o(ln,bd),o(ln,ey),f(wa,ln,null),o(w,ty),o(w,pn),f(ii,pn,null),o(pn,ny),o(pn,yd),o(pn,oy),o(pn,vd),o(w,ay),o(w,dn),f(ci,dn,null),o(dn,sy),o(dn,xd),o(dn,ry),o(dn,$d),o(w,iy),o(w,Xe),f(li,Xe,null),o(Xe,cy),o(Xe,wd),o(Xe,ly),o(Xe,kd),o(Xe,py),o(Xe,Td),o(w,dy),o(w,ka),f(pi,ka,null),o(ka,gy),o(ka,jd),o(w,uy),o(w,Ta),f(di,Ta,null),o(Ta,hy),o(Ta,Md),o(w,fy),o(w,gn),f(gi,gn,null),o(gn,my),o(gn,qd),o(gn,_y),o(gn,Hd),o(w,by),o(w,ja),f(ui,ja,null),o(ja,yy),o(ja,Ud),o(w,vy),o(w,un),f(hi,un,null),o(un,xy),o(un,Cd),o(un,$y),o(un,Id),o(w,wy),o(w,Ma),f(fi,Ma,null),o(Ma,ky),o(Ma,Jd),o(w,Ty),o(w,hn),f(mi,hn,null),o(hn,jy),o(hn,Nd),o(hn,My),f(qa,hn,null),o(w,qy),o(w,fn),f(_i,fn,null),o(fn,Hy),o(fn,Ad),o(fn,Uy),f(Ha,fn,null),o(w,Cy),o(w,ze),f(bi,ze,null),o(ze,Iy),o(ze,Ed),o(ze,Jy),o(ze,Dd),o(ze,Ny),f(Ua,ze,null),o(w,Ay),o(w,mn),f(yi,mn,null),o(mn,Ey),o(mn,Rd),o(mn,Dy),f(Ca,mn,null),o(w,Ry),o(w,_n),f(vi,_n,null),o(_n,Gy),o(_n,Gd),o(_n,Zy),f(Ia,_n,null),o(w,Fy),o(w,bn),f(xi,bn,null),o(bn,Sy),o(bn,Zd),o(bn,Ly),f(Ja,bn,null),o(w,Wy),o(w,yn),f($i,yn,null),o(yn,Vy),o(yn,Fd),o(yn,By),f(Na,yn,null),o(w,Py),o(w,Qe),f(wi,Qe,null),o(Qe,Yy),o(Qe,Sd),o(Qe,Xy),o(Qe,Ld),o(Qe,zy),f(Aa,Qe,null),o(w,Qy),o(w,Ea),f(ki,Ea,null),o(Ea,Oy),o(Ea,Wd),o(w,Ky),o(w,Oe),f(Ti,Oe,null),o(Oe,ev),o(Oe,Vd),o(Oe,tv),o(Oe,Bd),o(Oe,nv),f(Da,Oe,null),o(w,ov),o(w,Ra),f(ji,Ra,null),o(Ra,av),o(Ra,Pd),o(w,sv),o(w,Ga),f(Mi,Ga,null),o(Ga,rv),o(Ga,Yd),o(w,iv),o(w,vn),f(qi,vn,null),o(vn,cv),o(vn,Xd),o(vn,lv),f(Za,vn,null),o(w,pv),o(w,Fa),f(Hi,Fa,null),o(Fa,dv),o(Fa,zd),o(w,gv),o(w,xn),f(Ui,xn,null),o(xn,uv),o(xn,Qd),o(xn,hv),f(Sa,xn,null),o(w,fv),o(w,he),f(Ci,he,null),o(he,mv),o(he,Od),o(he,_v),o(he,Kd),o(he,bv),f(La,he,null),o(he,yv),f(Wa,he,null),o(w,vv),o(w,P),f(Ii,P,null),o(P,xv),o(P,eg),o(P,$v),o(P,tg),o(P,wv),o(P,ng),o(P,kv),o(P,og),o(P,Tv),f(Va,P,null),o(w,jv),o(w,Ba),f(Ji,Ba,null),o(Ba,Mv),o(Ba,ag),o(w,qv),o(w,$n),f(Ni,$n,null),o($n,Hv),o($n,sg),o($n,Uv),o($n,rg),o(w,Cv),o(w,Ke),f(Ai,Ke,null),o(Ke,Iv),o(Ke,ig),o(Ke,Jv),f(Pa,Ke,null),o(Ke,Nv),o(Ke,cg),o(w,Av),o(w,Ya),f(Ei,Ya,null),o(Ya,Ev),o(Ya,lg),o(w,Dv),o(w,wn),f(Di,wn,null),o(wn,Rv),o(wn,pg),o(wn,Gv),f(Xa,wn,null),o(w,Zv),o(w,et),f(Ri,et,null),o(et,Fv),o(et,dg),o(et,Sv),o(et,gg),o(et,Lv),o(et,ug),o(w,Wv),o(w,Y),f(Gi,Y,null),o(Y,Vv),o(Y,hg),o(Y,Bv),o(Y,fg),o(Y,Pv),o(Y,mg),o(Y,Yv),f(za,Y,null),o(Y,Xv),o(Y,_g),o(w,zv),o(w,tt),f(Zi,tt,null),o(tt,Qv),o(tt,bg),o(tt,Ov),f(Qa,tt,null),o(tt,Kv),f(Oa,tt,null),o(w,ex),o(w,kn),f(Fi,kn,null),o(kn,tx),o(kn,yg),o(kn,nx),f(Ka,kn,null),o(w,ox),o(w,Tn),f(Si,Tn,null),o(Tn,ax),o(Tn,vg),o(Tn,sx),f(es,Tn,null),o(w,rx),o(w,fe),f(Li,fe,null),o(fe,ix),o(fe,xg),o(fe,cx),o(fe,$g),o(fe,lx),o(fe,wg),o(fe,px),f(ts,fe,null),o(w,dx),o(w,jn),f(Wi,jn,null),o(jn,gx),o(jn,kg),o(jn,ux),f(ns,jn,null),o(w,hx),o(w,nt),f(Vi,nt,null),o(nt,fx),o(nt,Tg),o(nt,mx),f(os,nt,null),o(nt,_x),f(as,nt,null),o(w,bx),o(w,me),f(Bi,me,null),o(me,yx),o(me,jg),o(me,vx),o(me,Mg),o(me,xx),o(me,qg),o(me,$x),f(ss,me,null),o(w,wx),o(w,Mn),f(Pi,Mn,null),o(Mn,kx),o(Mn,Hg),o(Mn,Tx),f(rs,Mn,null),o(w,jx),o(w,is),f(Yi,is,null),o(is,Mx),o(is,Ug),o(w,qx),o(w,ot),f(Xi,ot,null),o(ot,Hx),o(ot,Cg),o(ot,Ux),o(ot,Ig),o(ot,Cx),f(cs,ot,null),o(w,Ix),o(w,_e),f(zi,_e,null),o(_e,Jx),o(_e,Jg),o(_e,Nx),o(_e,Ng),o(_e,Ax),o(_e,Ag),o(_e,Ex),f(ls,_e,null),o(w,Dx),o(w,qn),f(Qi,qn,null),o(qn,Rx),o(qn,Eg),o(qn,Gx),f(ps,qn,null),o(w,Zx),o(w,ds),f(Oi,ds,null),o(ds,Fx),o(ds,Dg),o(w,Sx),o(w,Hn),f(Ki,Hn,null),o(Hn,Lx),o(Hn,Rg),o(Hn,Wx),f(gs,Hn,null),o(w,Vx),o(w,be),f(ec,be,null),o(be,Bx),o(be,Gg),o(be,Px),o(be,Zg),o(be,Yx),o(be,Fg),o(be,Xx),f(us,be,null),o(w,zx),o(w,ye),f(tc,ye,null),o(ye,Qx),o(ye,Sg),o(ye,Ox),o(ye,Lg),o(ye,Kx),o(ye,Wg),o(ye,e$),f(hs,ye,null),o(w,t$),o(w,at),f(nc,at,null),o(at,n$),o(at,Vg),o(at,o$),o(at,Bg),o(at,a$),f(fs,at,null),o(w,s$),o(w,ms),f(oc,ms,null),o(ms,r$),o(ms,Pg),o(w,i$),o(w,Un),f(ac,Un,null),o(Un,c$),o(Un,Yg),o(Un,l$),o(Un,Xg),o(w,p$),o(w,Cn),f(sc,Cn,null),o(Cn,d$),o(Cn,zg),o(Cn,g$),f(_s,Cn,null),o(w,u$),o(w,Z),f(rc,Z,null),o(Z,h$),o(Z,Qg),o(Z,f$),o(Z,Og),o(Z,m$),o(Z,Kg),o(Z,_$),f(bs,Z,null),o(Z,b$),o(Z,eu),o(Z,y$),f(ys,Z,null),o(w,v$),o(w,vs),f(ic,vs,null),o(vs,x$),o(vs,tu),o(w,$$),o(w,xs),f(cc,xs,null),o(xs,w$),o(xs,nu),o(w,k$),o(w,$s),f(lc,$s,null),o($s,T$),o($s,ou),o(w,j$),o(w,ws),f(pc,ws,null),o(ws,M$),o(ws,au),o(w,q$),o(w,In),f(dc,In,null),o(In,H$),o(In,su),o(In,U$),f(ks,In,null),o(w,C$),o(w,Jn),f(gc,Jn,null),o(Jn,I$),o(Jn,ru),o(Jn,J$),f(Ts,Jn,null),o(w,N$),o(w,st),f(uc,st,null),o(st,A$),o(st,iu),o(st,E$),o(st,cu),o(st,D$),f(js,st,null),o(w,R$),o(w,rt),f(hc,rt,null),o(rt,G$),o(rt,lu),o(rt,Z$),o(rt,pu),o(rt,F$),f(Ms,rt,null),o(w,S$),o(w,qs),f(fc,qs,null),o(qs,L$),o(qs,du),o(w,W$),o(w,it),f(mc,it,null),o(it,V$),o(it,gu),o(it,B$),o(it,uu),o(it,P$),o(it,hu),o(w,Y$),o(w,ct),f(_c,ct,null),o(ct,X$),o(ct,fu),o(ct,z$),o(ct,mu),o(ct,Q$),o(ct,_u),o(w,O$),o(w,lt),f(bc,lt,null),o(lt,K$),o(lt,bu),o(lt,e2),o(lt,yu),o(lt,t2),o(lt,vu),o(w,n2),o(w,pt),f(yc,pt,null),o(pt,o2),o(pt,xu),o(pt,a2),f(Hs,pt,null),o(pt,s2),f(Us,pt,null),o(w,r2),o(w,X),f(vc,X,null),o(X,i2),o(X,$u),o(X,c2),o(X,wu),o(X,l2),f(Cs,X,null),o(X,p2),f(Is,X,null),o(X,d2),f(Js,X,null),o(w,g2),o(w,dt),f(xc,dt,null),o(dt,u2),o(dt,ku),o(dt,h2),o(dt,Tu),o(dt,f2),o(dt,ju),o(w,m2),o(w,gt),f($c,gt,null),o(gt,_2),o(gt,Mu),o(gt,b2),f(Ns,gt,null),o(gt,y2),f(As,gt,null),o(w,v2),o(w,Nn),f(wc,Nn,null),o(Nn,x2),o(Nn,qu),o(Nn,$2),f(Es,Nn,null),o(w,w2),o(w,An),f(kc,An,null),o(An,k2),o(An,Hu),o(An,T2),f(Ds,An,null),o(w,j2),o(w,En),f(Tc,En,null),o(En,M2),o(En,Uu),o(En,q2),f(Rs,En,null),o(w,H2),o(w,Dn),f(jc,Dn,null),o(Dn,U2),o(Dn,Cu),o(Dn,C2),f(Gs,Dn,null),o(w,I2),o(w,ut),f(Mc,ut,null),o(ut,J2),o(ut,Iu),o(ut,N2),o(ut,Ju),o(ut,A2),o(ut,Nu),o(w,E2),o(w,Rn),f(qc,Rn,null),o(Rn,D2),o(Rn,Au),o(Rn,R2),o(Rn,Eu),o(w,G2),o(w,Zs),f(Hc,Zs,null),o(Zs,Z2),o(Zs,Du),o(w,F2),o(w,Gn),f(Uc,Gn,null),o(Gn,S2),o(Gn,Ru),o(Gn,L2),f(Fs,Gn,null),o(w,W2),o(w,ve),f(Cc,ve,null),o(ve,V2),o(ve,Gu),o(ve,B2),o(ve,Zu),o(ve,P2),o(ve,Fu),o(ve,Y2),f(Ss,ve,null),o(w,X2),o(w,xe),f(Ic,xe,null),o(xe,z2),o(xe,Su),o(xe,Q2),o(xe,Lu),o(xe,O2),f(Ls,xe,null),o(xe,K2),f(Ws,xe,null),o(w,e1),o(w,z),f(Jc,z,null),o(z,t1),o(z,Wu),o(z,n1),o(z,Vu),o(z,o1),f(Vs,z,null),o(z,a1),f(Bs,z,null),o(z,s1),f(Ps,z,null),o(w,r1),o(w,ht),f(Nc,ht,null),o(ht,i1),o(ht,Bu),o(ht,c1),o(ht,Pu),o(ht,l1),o(ht,Yu),o(w,p1),o(w,ft),f(Ac,ft,null),o(ft,d1),o(ft,Xu),o(ft,g1),o(ft,zu),o(ft,u1),f(Ys,ft,null),o(w,h1),o(w,$e),f(Ec,$e,null),o($e,f1),o($e,Qu),o($e,m1),o($e,Ou),o($e,_1),o($e,Ku),o($e,b1),o($e,eh),o(w,y1),o(w,mt),f(Dc,mt,null),o(mt,v1),o(mt,th),o(mt,x1),o(mt,nh),o(mt,$1),f(Xs,mt,null),o(w,w1),o(w,Q),f(Rc,Q,null),o(Q,k1),o(Q,oh),o(Q,T1),o(Q,ah),o(Q,j1),f(zs,Q,null),o(Q,M1),f(Qs,Q,null),o(Q,q1),f(Os,Q,null),o(w,H1),o(w,Ks),f(Gc,Ks,null),o(Ks,U1),o(Ks,sh),o(w,C1),o(w,we),f(Zc,we,null),o(we,I1),o(we,rh),o(we,J1),o(we,ih),o(we,N1),o(we,ch),o(we,A1),f(er,we,null),o(w,E1),o(w,Zn),f(Fc,Zn,null),o(Zn,D1),o(Zn,lh),o(Zn,R1),f(tr,Zn,null),o(w,G1),o(w,ke),f(Sc,ke,null),o(ke,Z1),o(ke,ph),o(ke,F1),o(ke,dh),o(ke,S1),o(ke,gh),o(ke,L1),f(nr,ke,null),o(w,W1),o(w,_t),f(Lc,_t,null),o(_t,V1),o(_t,uh),o(_t,B1),o(_t,hh),o(_t,P1),o(_t,fh),o(w,Y1),o(w,Fn),f(Wc,Fn,null),o(Fn,X1),o(Fn,mh),o(Fn,z1),o(Fn,_h),o(w,Q1),o(w,bt),f(Vc,bt,null),o(bt,O1),o(bt,bh),o(bt,K1),o(bt,yh),o(bt,ew),f(or,bt,null),o(w,tw),o(w,Sn),f(Bc,Sn,null),o(Sn,nw),o(Sn,vh),o(Sn,ow),f(ar,Sn,null),o(w,aw),o(w,Te),f(Pc,Te,null),o(Te,sw),o(Te,xh),o(Te,rw),f(sr,Te,null),o(Te,iw),f(rr,Te,null),o(Te,cw),f(ir,Te,null),o(w,lw),o(w,N),f(Yc,N,null),o(N,pw),o(N,$h),o(N,dw),o(N,wh),o(N,gw),o(N,kh),o(N,uw),o(N,Th),o(N,hw),o(N,jh),o(N,fw),o(N,Mh),o(N,mw),f(cr,N,null),o(N,_w),f(lr,N,null),o(N,bw),f(pr,N,null),o(N,yw),f(dr,N,null),o(w,vw),o(w,J),f(Xc,J,null),o(J,xw),o(J,qh),o(J,$w),o(J,Hh),o(J,ww),f(gr,J,null),o(J,kw),f(ur,J,null),o(J,Tw),o(J,Uh),o(J,jw),o(J,Ch),o(J,Mw),o(J,Ih),o(J,qw),o(J,Jh),o(J,Hw),o(J,Nh),o(J,Uw),o(J,Ah),o(J,Cw),o(J,Eh),o(w,Iw),o(w,hr),f(zc,hr,null),o(hr,Jw),o(hr,Dh),$(t,Of,v),f(Qc,t,v),$(t,Kf,v),f(Oc,t,v),$(t,em,v),$(t,Kn,v),f(Kc,Kn,null),o(Kn,Nw),o(Kn,Rh),$(t,tm,v),f(el,t,v),$(t,nm,v),$(t,vt,v),f(tl,vt,null),o(vt,Aw),o(vt,Gh),o(vt,Ew),o(vt,Zh),$(t,om,v),f(nl,t,v),$(t,am,v),$(t,xt,v),f(ol,xt,null),o(xt,Dw),o(xt,Fh),o(xt,Rw),f(fr,xt,null),$(t,sm,v),f(al,t,v),$(t,rm,v),$(t,eo,v),f(sl,eo,null),o(eo,Gw),o(eo,Sh),$(t,im,v),f(rl,t,v),$(t,cm,v),$(t,to,v),f(il,to,null),o(to,Zw),o(to,Lh),$(t,lm,v),f(cl,t,v),$(t,pm,v),$(t,$t,v),f(ll,$t,null),o($t,Fw),o($t,Wh),o($t,Sw),o($t,Vh),$(t,dm,v),f(pl,t,v),$(t,gm,v),$(t,dl,v),f(gl,dl,null),$(t,um,v),f(ul,t,v),$(t,hm,v),$(t,K,v),f(hl,K,null),o(K,Lw),o(K,Bh),o(K,Ww),o(K,Ph),o(K,Vw),o(K,Yh),o(K,Bw),f(mr,K,null),$(t,fm,v),f(fl,t,v),$(t,mm,v),$(t,wt,v),f(ml,wt,null),o(wt,Pw),o(wt,Xh),o(wt,Yw),f(_r,wt,null),$(t,_m,v),f(_l,t,v),$(t,bm,v),$(t,kt,v),f(bl,kt,null),o(kt,Xw),o(kt,zh),o(kt,zw),f(br,kt,null),$(t,ym,v),f(yl,t,v),$(t,vm,v),$(t,no,v),f(vl,no,null),o(no,Qw),o(no,Qh),$(t,xm,v),f(xl,t,v),$(t,$m,v),$(t,ee,v),f($l,ee,null),o(ee,Ow),o(ee,Oh),o(ee,Kw),o(ee,Kh),o(ee,ek),o(ee,ef),o(ee,tk),f(yr,ee,null),$(t,wm,v),f(wl,t,v),$(t,km,v),$(t,te,v),f(kl,te,null),o(te,nk),o(te,tf),o(te,ok),o(te,nf),o(te,ak),o(te,of),o(te,sk),o(te,af),$(t,Tm,v),f(Tl,t,v),$(t,jm,v),$(t,je,v),f(jl,je,null),o(je,rk),o(je,sf),o(je,ik),o(je,rf),o(je,ck),o(je,cf),$(t,Mm,v),f(Ml,t,v),$(t,qm,v),$(t,Tt,v),f(ql,Tt,null),o(Tt,lk),o(Tt,lf),o(Tt,pk),f(vr,Tt,null),$(t,Hm,v),f(Hl,t,v),$(t,Um,v),$(t,jt,v),f(Ul,jt,null),o(jt,dk),o(jt,pf),o(jt,gk),o(jt,df),$(t,Cm,v),f(Cl,t,v),$(t,Im,v),$(t,oo,v),f(Il,oo,null),o(oo,uk),o(oo,gf),$(t,Jm,v),f(Jl,t,v),$(t,Nm,v),$(t,ao,v),f(Nl,ao,null),o(ao,hk),o(ao,uf),$(t,Am,v),f(Al,t,v),$(t,Em,v),$(t,so,v),f(El,so,null),o(so,fk),o(so,hf),$(t,Dm,v),f(Dl,t,v),$(t,Rm,v),$(t,ro,v),f(Rl,ro,null),o(ro,mk),o(ro,ff),$(t,Gm,v),f(Gl,t,v),$(t,Zm,v),$(t,Zl,v),$(t,Fm,v),$(t,Me,v),f(Fl,Me,null),o(Me,_k),o(Me,mf),o(Me,bk),o(Me,Ln),f(Sl,Ln,null),o(Ln,yk),o(Ln,_f),o(Ln,vk),f(xr,Ln,null),o(Me,xk),o(Me,Wn),f(Ll,Wn,null),o(Wn,$k),o(Wn,bf),o(Wn,wk),o(Wn,yf),$(t,Sm,v),$(t,io,v),f(Wl,io,null),o(io,kk),o(io,vf),$(t,Lm,v),$(t,ne,v),f(Vl,ne,null),o(ne,Tk),o(ne,xf),o(ne,jk),o(ne,$f),o(ne,Mk),o(ne,wf),o(ne,qk),o(ne,kf),$(t,Wm,v),f(Bl,t,v),$(t,Vm,v),$(t,R,v),f(Pl,R,null),o(R,Hk),o(R,Tf),o(R,Uk),o(R,jf),o(R,Ck),f($r,R,null),o(R,Ik),f(wr,R,null),o(R,Jk),o(R,yt),f(Yl,yt,null),o(yt,Nk),o(yt,Mf),o(yt,Ak),f(kr,yt,null),o(yt,Ek),o(yt,qf),o(R,Dk),o(R,Vn),f(Xl,Vn,null),o(Vn,Rk),o(Vn,Hf),o(Vn,Gk),o(Vn,Uf),o(R,Zk),o(R,Bn),f(zl,Bn,null),o(Bn,Fk),o(Bn,Cf),o(Bn,Sk),o(Bn,If),$(t,Bm,v),f(Ql,t,v),$(t,Pm,v),$(t,Bf,v),Ym=!0},p(t,[v]){const k={};v&2&&(k.$$scope={dirty:v,ctx:t}),Vo.$set(k);const Mt={};v&2&&(Mt.$$scope={dirty:v,ctx:t}),Bo.$set(Mt);const qt={};v&2&&(qt.$$scope={dirty:v,ctx:t}),Yo.$set(qt);const co={};v&2&&(co.$$scope={dirty:v,ctx:t}),Xo.$set(co);const lo={};v&2&&(lo.$$scope={dirty:v,ctx:t}),zo.$set(lo);const F={};v&2&&(F.$$scope={dirty:v,ctx:t}),Qo.$set(F);const Ht={};v&2&&(Ht.$$scope={dirty:v,ctx:t}),Ko.$set(Ht);const Ol={};v&2&&(Ol.$$scope={dirty:v,ctx:t}),ea.$set(Ol);const Ut={};v&2&&(Ut.$$scope={dirty:v,ctx:t}),ta.$set(Ut);const Ct={};v&2&&(Ct.$$scope={dirty:v,ctx:t}),na.$set(Ct);const Kl={};v&2&&(Kl.$$scope={dirty:v,ctx:t}),oa.$set(Kl);const It={};v&2&&(It.$$scope={dirty:v,ctx:t}),aa.$set(It);const qe={};v&2&&(qe.$$scope={dirty:v,ctx:t}),sa.$set(qe);const oe={};v&2&&(oe.$$scope={dirty:v,ctx:t}),ra.$set(oe);const He={};v&2&&(He.$$scope={dirty:v,ctx:t}),ia.$set(He);const Jt={};v&2&&(Jt.$$scope={dirty:v,ctx:t}),ca.$set(Jt);const ae={};v&2&&(ae.$$scope={dirty:v,ctx:t}),pa.$set(ae);const ep={};v&2&&(ep.$$scope={dirty:v,ctx:t}),da.$set(ep);const se={};v&2&&(se.$$scope={dirty:v,ctx:t}),ga.$set(se);const re={};v&2&&(re.$$scope={dirty:v,ctx:t}),ua.$set(re);const tp={};v&2&&(tp.$$scope={dirty:v,ctx:t}),ha.$set(tp);const po={};v&2&&(po.$$scope={dirty:v,ctx:t}),fa.$set(po);const Nt={};v&2&&(Nt.$$scope={dirty:v,ctx:t}),_a.$set(Nt);const np={};v&2&&(np.$$scope={dirty:v,ctx:t}),ba.$set(np);const At={};v&2&&(At.$$scope={dirty:v,ctx:t}),va.$set(At);const go={};v&2&&(go.$$scope={dirty:v,ctx:t}),xa.$set(go);const uo={};v&2&&(uo.$$scope={dirty:v,ctx:t}),$a.$set(uo);const ho={};v&2&&(ho.$$scope={dirty:v,ctx:t}),wa.$set(ho);const fo={};v&2&&(fo.$$scope={dirty:v,ctx:t}),qa.$set(fo);const Et={};v&2&&(Et.$$scope={dirty:v,ctx:t}),Ha.$set(Et);const op={};v&2&&(op.$$scope={dirty:v,ctx:t}),Ua.$set(op);const ap={};v&2&&(ap.$$scope={dirty:v,ctx:t}),Ca.$set(ap);const mo={};v&2&&(mo.$$scope={dirty:v,ctx:t}),Ia.$set(mo);const sp={};v&2&&(sp.$$scope={dirty:v,ctx:t}),Ja.$set(sp);const _o={};v&2&&(_o.$$scope={dirty:v,ctx:t}),Na.$set(_o);const rp={};v&2&&(rp.$$scope={dirty:v,ctx:t}),Aa.$set(rp);const bo={};v&2&&(bo.$$scope={dirty:v,ctx:t}),Da.$set(bo);const yo={};v&2&&(yo.$$scope={dirty:v,ctx:t}),Za.$set(yo);const Dt={};v&2&&(Dt.$$scope={dirty:v,ctx:t}),Sa.$set(Dt);const vo={};v&2&&(vo.$$scope={dirty:v,ctx:t}),La.$set(vo);const xo={};v&2&&(xo.$$scope={dirty:v,ctx:t}),Wa.$set(xo);const $o={};v&2&&($o.$$scope={dirty:v,ctx:t}),Va.$set($o);const wo={};v&2&&(wo.$$scope={dirty:v,ctx:t}),Pa.$set(wo);const Rt={};v&2&&(Rt.$$scope={dirty:v,ctx:t}),Xa.$set(Rt);const ip={};v&2&&(ip.$$scope={dirty:v,ctx:t}),za.$set(ip);const Gt={};v&2&&(Gt.$$scope={dirty:v,ctx:t}),Qa.$set(Gt);const cp={};v&2&&(cp.$$scope={dirty:v,ctx:t}),Oa.$set(cp);const lp={};v&2&&(lp.$$scope={dirty:v,ctx:t}),Ka.$set(lp);const ko={};v&2&&(ko.$$scope={dirty:v,ctx:t}),es.$set(ko);const pp={};v&2&&(pp.$$scope={dirty:v,ctx:t}),ts.$set(pp);const To={};v&2&&(To.$$scope={dirty:v,ctx:t}),ns.$set(To);const Ue={};v&2&&(Ue.$$scope={dirty:v,ctx:t}),os.$set(Ue);const ie={};v&2&&(ie.$$scope={dirty:v,ctx:t}),as.$set(ie);const dp={};v&2&&(dp.$$scope={dirty:v,ctx:t}),ss.$set(dp);const jo={};v&2&&(jo.$$scope={dirty:v,ctx:t}),rs.$set(jo);const Zt={};v&2&&(Zt.$$scope={dirty:v,ctx:t}),cs.$set(Zt);const gp={};v&2&&(gp.$$scope={dirty:v,ctx:t}),ls.$set(gp);const Mo={};v&2&&(Mo.$$scope={dirty:v,ctx:t}),ps.$set(Mo);const Ft={};v&2&&(Ft.$$scope={dirty:v,ctx:t}),gs.$set(Ft);const ce={};v&2&&(ce.$$scope={dirty:v,ctx:t}),us.$set(ce);const St={};v&2&&(St.$$scope={dirty:v,ctx:t}),hs.$set(St);const qo={};v&2&&(qo.$$scope={dirty:v,ctx:t}),fs.$set(qo);const Ho={};v&2&&(Ho.$$scope={dirty:v,ctx:t}),_s.$set(Ho);const Ce={};v&2&&(Ce.$$scope={dirty:v,ctx:t}),bs.$set(Ce);const Uo={};v&2&&(Uo.$$scope={dirty:v,ctx:t}),ys.$set(Uo);const Lt={};v&2&&(Lt.$$scope={dirty:v,ctx:t}),ks.$set(Lt);const Ie={};v&2&&(Ie.$$scope={dirty:v,ctx:t}),Ts.$set(Ie);const Co={};v&2&&(Co.$$scope={dirty:v,ctx:t}),js.$set(Co);const up={};v&2&&(up.$$scope={dirty:v,ctx:t}),Ms.$set(up);const Wt={};v&2&&(Wt.$$scope={dirty:v,ctx:t}),Hs.$set(Wt);const Je={};v&2&&(Je.$$scope={dirty:v,ctx:t}),Us.$set(Je);const Io={};v&2&&(Io.$$scope={dirty:v,ctx:t}),Cs.$set(Io);const hp={};v&2&&(hp.$$scope={dirty:v,ctx:t}),Is.$set(hp);const Jo={};v&2&&(Jo.$$scope={dirty:v,ctx:t}),Js.$set(Jo);const Ne={};v&2&&(Ne.$$scope={dirty:v,ctx:t}),Ns.$set(Ne);const Ae={};v&2&&(Ae.$$scope={dirty:v,ctx:t}),As.$set(Ae);const Vt={};v&2&&(Vt.$$scope={dirty:v,ctx:t}),Es.$set(Vt);const fp={};v&2&&(fp.$$scope={dirty:v,ctx:t}),Ds.$set(fp);const No={};v&2&&(No.$$scope={dirty:v,ctx:t}),Rs.$set(No);const Ao={};v&2&&(Ao.$$scope={dirty:v,ctx:t}),Gs.$set(Ao);const S={};v&2&&(S.$$scope={dirty:v,ctx:t}),Fs.$set(S);const mp={};v&2&&(mp.$$scope={dirty:v,ctx:t}),Ss.$set(mp);const _p={};v&2&&(_p.$$scope={dirty:v,ctx:t}),Ls.$set(_p);const bp={};v&2&&(bp.$$scope={dirty:v,ctx:t}),Ws.$set(bp);const yp={};v&2&&(yp.$$scope={dirty:v,ctx:t}),Vs.$set(yp);const Eo={};v&2&&(Eo.$$scope={dirty:v,ctx:t}),Bs.$set(Eo);const Do={};v&2&&(Do.$$scope={dirty:v,ctx:t}),Ps.$set(Do);const Bt={};v&2&&(Bt.$$scope={dirty:v,ctx:t}),Ys.$set(Bt);const Pt={};v&2&&(Pt.$$scope={dirty:v,ctx:t}),Xs.$set(Pt);const vp={};v&2&&(vp.$$scope={dirty:v,ctx:t}),zs.$set(vp);const Yt={};v&2&&(Yt.$$scope={dirty:v,ctx:t}),Qs.$set(Yt);const Xt={};v&2&&(Xt.$$scope={dirty:v,ctx:t}),Os.$set(Xt);const zt={};v&2&&(zt.$$scope={dirty:v,ctx:t}),er.$set(zt);const Qt={};v&2&&(Qt.$$scope={dirty:v,ctx:t}),tr.$set(Qt);const le={};v&2&&(le.$$scope={dirty:v,ctx:t}),nr.$set(le);const Ot={};v&2&&(Ot.$$scope={dirty:v,ctx:t}),or.$set(Ot);const Kt={};v&2&&(Kt.$$scope={dirty:v,ctx:t}),ar.$set(Kt);const Ro={};v&2&&(Ro.$$scope={dirty:v,ctx:t}),sr.$set(Ro);const Go={};v&2&&(Go.$$scope={dirty:v,ctx:t}),rr.$set(Go);const Zo={};v&2&&(Zo.$$scope={dirty:v,ctx:t}),ir.$set(Zo);const Fo={};v&2&&(Fo.$$scope={dirty:v,ctx:t}),cr.$set(Fo);const en={};v&2&&(en.$$scope={dirty:v,ctx:t}),lr.$set(en);const So={};v&2&&(So.$$scope={dirty:v,ctx:t}),pr.$set(So);const xp={};v&2&&(xp.$$scope={dirty:v,ctx:t}),dr.$set(xp);const Lo={};v&2&&(Lo.$$scope={dirty:v,ctx:t}),gr.$set(Lo);const Ee={};v&2&&(Ee.$$scope={dirty:v,ctx:t}),ur.$set(Ee);const De={};v&2&&(De.$$scope={dirty:v,ctx:t}),fr.$set(De);const pe={};v&2&&(pe.$$scope={dirty:v,ctx:t}),mr.$set(pe);const tn={};v&2&&(tn.$$scope={dirty:v,ctx:t}),_r.$set(tn);const nn={};v&2&&(nn.$$scope={dirty:v,ctx:t}),br.$set(nn);const Re={};v&2&&(Re.$$scope={dirty:v,ctx:t}),yr.$set(Re);const on={};v&2&&(on.$$scope={dirty:v,ctx:t}),vr.$set(on);const de={};v&2&&(de.$$scope={dirty:v,ctx:t}),xr.$set(de);const $p={};v&2&&($p.$$scope={dirty:v,ctx:t}),$r.$set($p);const Ge={};v&2&&(Ge.$$scope={dirty:v,ctx:t}),wr.$set(Ge);const Wo={};v&2&&(Wo.$$scope={dirty:v,ctx:t}),kr.$set(Wo)},i(t){Ym||(m(g.$$.fragment,t),m(Ir.$$.fragment,t),m(Jr.$$.fragment,t),m(Nr.$$.fragment,t),m(Ar.$$.fragment,t),m(Er.$$.fragment,t),m(Vo.$$.fragment,t),m(Dr.$$.fragment,t),m(Rr.$$.fragment,t),m(Gr.$$.fragment,t),m(Bo.$$.fragment,t),m(Zr.$$.fragment,t),m(Fr.$$.fragment,t),m(Sr.$$.fragment,t),m(Yo.$$.fragment,t),m(Xo.$$.fragment,t),m(Lr.$$.fragment,t),m(zo.$$.fragment,t),m(Qo.$$.fragment,t),m(Wr.$$.fragment,t),m(Vr.$$.fragment,t),m(Ko.$$.fragment,t),m(Br.$$.fragment,t),m(ea.$$.fragment,t),m(ta.$$.fragment,t),m(na.$$.fragment,t),m(Pr.$$.fragment,t),m(oa.$$.fragment,t),m(Yr.$$.fragment,t),m(aa.$$.fragment,t),m(sa.$$.fragment,t),m(ra.$$.fragment,t),m(Xr.$$.fragment,t),m(ia.$$.fragment,t),m(zr.$$.fragment,t),m(ca.$$.fragment,t),m(Qr.$$.fragment,t),m(Or.$$.fragment,t),m(pa.$$.fragment,t),m(da.$$.fragment,t),m(ga.$$.fragment,t),m(Kr.$$.fragment,t),m(ua.$$.fragment,t),m(ha.$$.fragment,t),m(fa.$$.fragment,t),m(ei.$$.fragment,t),m(ti.$$.fragment,t),m(_a.$$.fragment,t),m(ni.$$.fragment,t),m(ba.$$.fragment,t),m(oi.$$.fragment,t),m(ai.$$.fragment,t),m(va.$$.fragment,t),m(xa.$$.fragment,t),m(si.$$.fragment,t),m($a.$$.fragment,t),m(ri.$$.fragment,t),m(wa.$$.fragment,t),m(ii.$$.fragment,t),m(ci.$$.fragment,t),m(li.$$.fragment,t),m(pi.$$.fragment,t),m(di.$$.fragment,t),m(gi.$$.fragment,t),m(ui.$$.fragment,t),m(hi.$$.fragment,t),m(fi.$$.fragment,t),m(mi.$$.fragment,t),m(qa.$$.fragment,t),m(_i.$$.fragment,t),m(Ha.$$.fragment,t),m(bi.$$.fragment,t),m(Ua.$$.fragment,t),m(yi.$$.fragment,t),m(Ca.$$.fragment,t),m(vi.$$.fragment,t),m(Ia.$$.fragment,t),m(xi.$$.fragment,t),m(Ja.$$.fragment,t),m($i.$$.fragment,t),m(Na.$$.fragment,t),m(wi.$$.fragment,t),m(Aa.$$.fragment,t),m(ki.$$.fragment,t),m(Ti.$$.fragment,t),m(Da.$$.fragment,t),m(ji.$$.fragment,t),m(Mi.$$.fragment,t),m(qi.$$.fragment,t),m(Za.$$.fragment,t),m(Hi.$$.fragment,t),m(Ui.$$.fragment,t),m(Sa.$$.fragment,t),m(Ci.$$.fragment,t),m(La.$$.fragment,t),m(Wa.$$.fragment,t),m(Ii.$$.fragment,t),m(Va.$$.fragment,t),m(Ji.$$.fragment,t),m(Ni.$$.fragment,t),m(Ai.$$.fragment,t),m(Pa.$$.fragment,t),m(Ei.$$.fragment,t),m(Di.$$.fragment,t),m(Xa.$$.fragment,t),m(Ri.$$.fragment,t),m(Gi.$$.fragment,t),m(za.$$.fragment,t),m(Zi.$$.fragment,t),m(Qa.$$.fragment,t),m(Oa.$$.fragment,t),m(Fi.$$.fragment,t),m(Ka.$$.fragment,t),m(Si.$$.fragment,t),m(es.$$.fragment,t),m(Li.$$.fragment,t),m(ts.$$.fragment,t),m(Wi.$$.fragment,t),m(ns.$$.fragment,t),m(Vi.$$.fragment,t),m(os.$$.fragment,t),m(as.$$.fragment,t),m(Bi.$$.fragment,t),m(ss.$$.fragment,t),m(Pi.$$.fragment,t),m(rs.$$.fragment,t),m(Yi.$$.fragment,t),m(Xi.$$.fragment,t),m(cs.$$.fragment,t),m(zi.$$.fragment,t),m(ls.$$.fragment,t),m(Qi.$$.fragment,t),m(ps.$$.fragment,t),m(Oi.$$.fragment,t),m(Ki.$$.fragment,t),m(gs.$$.fragment,t),m(ec.$$.fragment,t),m(us.$$.fragment,t),m(tc.$$.fragment,t),m(hs.$$.fragment,t),m(nc.$$.fragment,t),m(fs.$$.fragment,t),m(oc.$$.fragment,t),m(ac.$$.fragment,t),m(sc.$$.fragment,t),m(_s.$$.fragment,t),m(rc.$$.fragment,t),m(bs.$$.fragment,t),m(ys.$$.fragment,t),m(ic.$$.fragment,t),m(cc.$$.fragment,t),m(lc.$$.fragment,t),m(pc.$$.fragment,t),m(dc.$$.fragment,t),m(ks.$$.fragment,t),m(gc.$$.fragment,t),m(Ts.$$.fragment,t),m(uc.$$.fragment,t),m(js.$$.fragment,t),m(hc.$$.fragment,t),m(Ms.$$.fragment,t),m(fc.$$.fragment,t),m(mc.$$.fragment,t),m(_c.$$.fragment,t),m(bc.$$.fragment,t),m(yc.$$.fragment,t),m(Hs.$$.fragment,t),m(Us.$$.fragment,t),m(vc.$$.fragment,t),m(Cs.$$.fragment,t),m(Is.$$.fragment,t),m(Js.$$.fragment,t),m(xc.$$.fragment,t),m($c.$$.fragment,t),m(Ns.$$.fragment,t),m(As.$$.fragment,t),m(wc.$$.fragment,t),m(Es.$$.fragment,t),m(kc.$$.fragment,t),m(Ds.$$.fragment,t),m(Tc.$$.fragment,t),m(Rs.$$.fragment,t),m(jc.$$.fragment,t),m(Gs.$$.fragment,t),m(Mc.$$.fragment,t),m(qc.$$.fragment,t),m(Hc.$$.fragment,t),m(Uc.$$.fragment,t),m(Fs.$$.fragment,t),m(Cc.$$.fragment,t),m(Ss.$$.fragment,t),m(Ic.$$.fragment,t),m(Ls.$$.fragment,t),m(Ws.$$.fragment,t),m(Jc.$$.fragment,t),m(Vs.$$.fragment,t),m(Bs.$$.fragment,t),m(Ps.$$.fragment,t),m(Nc.$$.fragment,t),m(Ac.$$.fragment,t),m(Ys.$$.fragment,t),m(Ec.$$.fragment,t),m(Dc.$$.fragment,t),m(Xs.$$.fragment,t),m(Rc.$$.fragment,t),m(zs.$$.fragment,t),m(Qs.$$.fragment,t),m(Os.$$.fragment,t),m(Gc.$$.fragment,t),m(Zc.$$.fragment,t),m(er.$$.fragment,t),m(Fc.$$.fragment,t),m(tr.$$.fragment,t),m(Sc.$$.fragment,t),m(nr.$$.fragment,t),m(Lc.$$.fragment,t),m(Wc.$$.fragment,t),m(Vc.$$.fragment,t),m(or.$$.fragment,t),m(Bc.$$.fragment,t),m(ar.$$.fragment,t),m(Pc.$$.fragment,t),m(sr.$$.fragment,t),m(rr.$$.fragment,t),m(ir.$$.fragment,t),m(Yc.$$.fragment,t),m(cr.$$.fragment,t),m(lr.$$.fragment,t),m(pr.$$.fragment,t),m(dr.$$.fragment,t),m(Xc.$$.fragment,t),m(gr.$$.fragment,t),m(ur.$$.fragment,t),m(zc.$$.fragment,t),m(Qc.$$.fragment,t),m(Oc.$$.fragment,t),m(Kc.$$.fragment,t),m(el.$$.fragment,t),m(tl.$$.fragment,t),m(nl.$$.fragment,t),m(ol.$$.fragment,t),m(fr.$$.fragment,t),m(al.$$.fragment,t),m(sl.$$.fragment,t),m(rl.$$.fragment,t),m(il.$$.fragment,t),m(cl.$$.fragment,t),m(ll.$$.fragment,t),m(pl.$$.fragment,t),m(gl.$$.fragment,t),m(ul.$$.fragment,t),m(hl.$$.fragment,t),m(mr.$$.fragment,t),m(fl.$$.fragment,t),m(ml.$$.fragment,t),m(_r.$$.fragment,t),m(_l.$$.fragment,t),m(bl.$$.fragment,t),m(br.$$.fragment,t),m(yl.$$.fragment,t),m(vl.$$.fragment,t),m(xl.$$.fragment,t),m($l.$$.fragment,t),m(yr.$$.fragment,t),m(wl.$$.fragment,t),m(kl.$$.fragment,t),m(Tl.$$.fragment,t),m(jl.$$.fragment,t),m(Ml.$$.fragment,t),m(ql.$$.fragment,t),m(vr.$$.fragment,t),m(Hl.$$.fragment,t),m(Ul.$$.fragment,t),m(Cl.$$.fragment,t),m(Il.$$.fragment,t),m(Jl.$$.fragment,t),m(Nl.$$.fragment,t),m(Al.$$.fragment,t),m(El.$$.fragment,t),m(Dl.$$.fragment,t),m(Rl.$$.fragment,t),m(Gl.$$.fragment,t),m(Fl.$$.fragment,t),m(Sl.$$.fragment,t),m(xr.$$.fragment,t),m(Ll.$$.fragment,t),m(Wl.$$.fragment,t),m(Vl.$$.fragment,t),m(Bl.$$.fragment,t),m(Pl.$$.fragment,t),m($r.$$.fragment,t),m(wr.$$.fragment,t),m(Yl.$$.fragment,t),m(kr.$$.fragment,t),m(Xl.$$.fragment,t),m(zl.$$.fragment,t),m(Ql.$$.fragment,t),Ym=!0)},o(t){_(g.$$.fragment,t),_(Ir.$$.fragment,t),_(Jr.$$.fragment,t),_(Nr.$$.fragment,t),_(Ar.$$.fragment,t),_(Er.$$.fragment,t),_(Vo.$$.fragment,t),_(Dr.$$.fragment,t),_(Rr.$$.fragment,t),_(Gr.$$.fragment,t),_(Bo.$$.fragment,t),_(Zr.$$.fragment,t),_(Fr.$$.fragment,t),_(Sr.$$.fragment,t),_(Yo.$$.fragment,t),_(Xo.$$.fragment,t),_(Lr.$$.fragment,t),_(zo.$$.fragment,t),_(Qo.$$.fragment,t),_(Wr.$$.fragment,t),_(Vr.$$.fragment,t),_(Ko.$$.fragment,t),_(Br.$$.fragment,t),_(ea.$$.fragment,t),_(ta.$$.fragment,t),_(na.$$.fragment,t),_(Pr.$$.fragment,t),_(oa.$$.fragment,t),_(Yr.$$.fragment,t),_(aa.$$.fragment,t),_(sa.$$.fragment,t),_(ra.$$.fragment,t),_(Xr.$$.fragment,t),_(ia.$$.fragment,t),_(zr.$$.fragment,t),_(ca.$$.fragment,t),_(Qr.$$.fragment,t),_(Or.$$.fragment,t),_(pa.$$.fragment,t),_(da.$$.fragment,t),_(ga.$$.fragment,t),_(Kr.$$.fragment,t),_(ua.$$.fragment,t),_(ha.$$.fragment,t),_(fa.$$.fragment,t),_(ei.$$.fragment,t),_(ti.$$.fragment,t),_(_a.$$.fragment,t),_(ni.$$.fragment,t),_(ba.$$.fragment,t),_(oi.$$.fragment,t),_(ai.$$.fragment,t),_(va.$$.fragment,t),_(xa.$$.fragment,t),_(si.$$.fragment,t),_($a.$$.fragment,t),_(ri.$$.fragment,t),_(wa.$$.fragment,t),_(ii.$$.fragment,t),_(ci.$$.fragment,t),_(li.$$.fragment,t),_(pi.$$.fragment,t),_(di.$$.fragment,t),_(gi.$$.fragment,t),_(ui.$$.fragment,t),_(hi.$$.fragment,t),_(fi.$$.fragment,t),_(mi.$$.fragment,t),_(qa.$$.fragment,t),_(_i.$$.fragment,t),_(Ha.$$.fragment,t),_(bi.$$.fragment,t),_(Ua.$$.fragment,t),_(yi.$$.fragment,t),_(Ca.$$.fragment,t),_(vi.$$.fragment,t),_(Ia.$$.fragment,t),_(xi.$$.fragment,t),_(Ja.$$.fragment,t),_($i.$$.fragment,t),_(Na.$$.fragment,t),_(wi.$$.fragment,t),_(Aa.$$.fragment,t),_(ki.$$.fragment,t),_(Ti.$$.fragment,t),_(Da.$$.fragment,t),_(ji.$$.fragment,t),_(Mi.$$.fragment,t),_(qi.$$.fragment,t),_(Za.$$.fragment,t),_(Hi.$$.fragment,t),_(Ui.$$.fragment,t),_(Sa.$$.fragment,t),_(Ci.$$.fragment,t),_(La.$$.fragment,t),_(Wa.$$.fragment,t),_(Ii.$$.fragment,t),_(Va.$$.fragment,t),_(Ji.$$.fragment,t),_(Ni.$$.fragment,t),_(Ai.$$.fragment,t),_(Pa.$$.fragment,t),_(Ei.$$.fragment,t),_(Di.$$.fragment,t),_(Xa.$$.fragment,t),_(Ri.$$.fragment,t),_(Gi.$$.fragment,t),_(za.$$.fragment,t),_(Zi.$$.fragment,t),_(Qa.$$.fragment,t),_(Oa.$$.fragment,t),_(Fi.$$.fragment,t),_(Ka.$$.fragment,t),_(Si.$$.fragment,t),_(es.$$.fragment,t),_(Li.$$.fragment,t),_(ts.$$.fragment,t),_(Wi.$$.fragment,t),_(ns.$$.fragment,t),_(Vi.$$.fragment,t),_(os.$$.fragment,t),_(as.$$.fragment,t),_(Bi.$$.fragment,t),_(ss.$$.fragment,t),_(Pi.$$.fragment,t),_(rs.$$.fragment,t),_(Yi.$$.fragment,t),_(Xi.$$.fragment,t),_(cs.$$.fragment,t),_(zi.$$.fragment,t),_(ls.$$.fragment,t),_(Qi.$$.fragment,t),_(ps.$$.fragment,t),_(Oi.$$.fragment,t),_(Ki.$$.fragment,t),_(gs.$$.fragment,t),_(ec.$$.fragment,t),_(us.$$.fragment,t),_(tc.$$.fragment,t),_(hs.$$.fragment,t),_(nc.$$.fragment,t),_(fs.$$.fragment,t),_(oc.$$.fragment,t),_(ac.$$.fragment,t),_(sc.$$.fragment,t),_(_s.$$.fragment,t),_(rc.$$.fragment,t),_(bs.$$.fragment,t),_(ys.$$.fragment,t),_(ic.$$.fragment,t),_(cc.$$.fragment,t),_(lc.$$.fragment,t),_(pc.$$.fragment,t),_(dc.$$.fragment,t),_(ks.$$.fragment,t),_(gc.$$.fragment,t),_(Ts.$$.fragment,t),_(uc.$$.fragment,t),_(js.$$.fragment,t),_(hc.$$.fragment,t),_(Ms.$$.fragment,t),_(fc.$$.fragment,t),_(mc.$$.fragment,t),_(_c.$$.fragment,t),_(bc.$$.fragment,t),_(yc.$$.fragment,t),_(Hs.$$.fragment,t),_(Us.$$.fragment,t),_(vc.$$.fragment,t),_(Cs.$$.fragment,t),_(Is.$$.fragment,t),_(Js.$$.fragment,t),_(xc.$$.fragment,t),_($c.$$.fragment,t),_(Ns.$$.fragment,t),_(As.$$.fragment,t),_(wc.$$.fragment,t),_(Es.$$.fragment,t),_(kc.$$.fragment,t),_(Ds.$$.fragment,t),_(Tc.$$.fragment,t),_(Rs.$$.fragment,t),_(jc.$$.fragment,t),_(Gs.$$.fragment,t),_(Mc.$$.fragment,t),_(qc.$$.fragment,t),_(Hc.$$.fragment,t),_(Uc.$$.fragment,t),_(Fs.$$.fragment,t),_(Cc.$$.fragment,t),_(Ss.$$.fragment,t),_(Ic.$$.fragment,t),_(Ls.$$.fragment,t),_(Ws.$$.fragment,t),_(Jc.$$.fragment,t),_(Vs.$$.fragment,t),_(Bs.$$.fragment,t),_(Ps.$$.fragment,t),_(Nc.$$.fragment,t),_(Ac.$$.fragment,t),_(Ys.$$.fragment,t),_(Ec.$$.fragment,t),_(Dc.$$.fragment,t),_(Xs.$$.fragment,t),_(Rc.$$.fragment,t),_(zs.$$.fragment,t),_(Qs.$$.fragment,t),_(Os.$$.fragment,t),_(Gc.$$.fragment,t),_(Zc.$$.fragment,t),_(er.$$.fragment,t),_(Fc.$$.fragment,t),_(tr.$$.fragment,t),_(Sc.$$.fragment,t),_(nr.$$.fragment,t),_(Lc.$$.fragment,t),_(Wc.$$.fragment,t),_(Vc.$$.fragment,t),_(or.$$.fragment,t),_(Bc.$$.fragment,t),_(ar.$$.fragment,t),_(Pc.$$.fragment,t),_(sr.$$.fragment,t),_(rr.$$.fragment,t),_(ir.$$.fragment,t),_(Yc.$$.fragment,t),_(cr.$$.fragment,t),_(lr.$$.fragment,t),_(pr.$$.fragment,t),_(dr.$$.fragment,t),_(Xc.$$.fragment,t),_(gr.$$.fragment,t),_(ur.$$.fragment,t),_(zc.$$.fragment,t),_(Qc.$$.fragment,t),_(Oc.$$.fragment,t),_(Kc.$$.fragment,t),_(el.$$.fragment,t),_(tl.$$.fragment,t),_(nl.$$.fragment,t),_(ol.$$.fragment,t),_(fr.$$.fragment,t),_(al.$$.fragment,t),_(sl.$$.fragment,t),_(rl.$$.fragment,t),_(il.$$.fragment,t),_(cl.$$.fragment,t),_(ll.$$.fragment,t),_(pl.$$.fragment,t),_(gl.$$.fragment,t),_(ul.$$.fragment,t),_(hl.$$.fragment,t),_(mr.$$.fragment,t),_(fl.$$.fragment,t),_(ml.$$.fragment,t),_(_r.$$.fragment,t),_(_l.$$.fragment,t),_(bl.$$.fragment,t),_(br.$$.fragment,t),_(yl.$$.fragment,t),_(vl.$$.fragment,t),_(xl.$$.fragment,t),_($l.$$.fragment,t),_(yr.$$.fragment,t),_(wl.$$.fragment,t),_(kl.$$.fragment,t),_(Tl.$$.fragment,t),_(jl.$$.fragment,t),_(Ml.$$.fragment,t),_(ql.$$.fragment,t),_(vr.$$.fragment,t),_(Hl.$$.fragment,t),_(Ul.$$.fragment,t),_(Cl.$$.fragment,t),_(Il.$$.fragment,t),_(Jl.$$.fragment,t),_(Nl.$$.fragment,t),_(Al.$$.fragment,t),_(El.$$.fragment,t),_(Dl.$$.fragment,t),_(Rl.$$.fragment,t),_(Gl.$$.fragment,t),_(Fl.$$.fragment,t),_(Sl.$$.fragment,t),_(xr.$$.fragment,t),_(Ll.$$.fragment,t),_(Wl.$$.fragment,t),_(Vl.$$.fragment,t),_(Bl.$$.fragment,t),_(Pl.$$.fragment,t),_($r.$$.fragment,t),_(wr.$$.fragment,t),_(Yl.$$.fragment,t),_(kr.$$.fragment,t),_(Xl.$$.fragment,t),_(zl.$$.fragment,t),_(Ql.$$.fragment,t),Ym=!1},d(t){t&&(p(y),p(i),p(a),p(e),p(x),p(Pf),p(Ur),p(Yf),p(Cr),p(Xf),p(zf),p(Qf),p(w),p(Of),p(Kf),p(em),p(Kn),p(tm),p(nm),p(vt),p(om),p(am),p(xt),p(sm),p(rm),p(eo),p(im),p(cm),p(to),p(lm),p(pm),p($t),p(dm),p(gm),p(dl),p(um),p(hm),p(K),p(fm),p(mm),p(wt),p(_m),p(bm),p(kt),p(ym),p(vm),p(no),p(xm),p($m),p(ee),p(wm),p(km),p(te),p(Tm),p(jm),p(je),p(Mm),p(qm),p(Tt),p(Hm),p(Um),p(jt),p(Cm),p(Im),p(oo),p(Jm),p(Nm),p(ao),p(Am),p(Em),p(so),p(Dm),p(Rm),p(ro),p(Gm),p(Zm),p(Zl),p(Fm),p(Me),p(Sm),p(io),p(Lm),p(ne),p(Wm),p(Vm),p(R),p(Bm),p(Pm),p(Bf)),p(n),b(g,t),b(Ir,t),b(Jr,t),b(Nr),b(Ar),b(Er),b(Vo),b(Dr),b(Rr),b(Gr),b(Bo),b(Zr),b(Fr),b(Sr),b(Yo),b(Xo),b(Lr),b(zo),b(Qo),b(Wr),b(Vr),b(Ko),b(Br),b(ea),b(ta),b(na),b(Pr),b(oa),b(Yr),b(aa),b(sa),b(ra),b(Xr),b(ia),b(zr),b(ca),b(Qr),b(Or),b(pa),b(da),b(ga),b(Kr),b(ua),b(ha),b(fa),b(ei),b(ti),b(_a),b(ni),b(ba),b(oi),b(ai),b(va),b(xa),b(si),b($a),b(ri),b(wa),b(ii),b(ci),b(li),b(pi),b(di),b(gi),b(ui),b(hi),b(fi),b(mi),b(qa),b(_i),b(Ha),b(bi),b(Ua),b(yi),b(Ca),b(vi),b(Ia),b(xi),b(Ja),b($i),b(Na),b(wi),b(Aa),b(ki),b(Ti),b(Da),b(ji),b(Mi),b(qi),b(Za),b(Hi),b(Ui),b(Sa),b(Ci),b(La),b(Wa),b(Ii),b(Va),b(Ji),b(Ni),b(Ai),b(Pa),b(Ei),b(Di),b(Xa),b(Ri),b(Gi),b(za),b(Zi),b(Qa),b(Oa),b(Fi),b(Ka),b(Si),b(es),b(Li),b(ts),b(Wi),b(ns),b(Vi),b(os),b(as),b(Bi),b(ss),b(Pi),b(rs),b(Yi),b(Xi),b(cs),b(zi),b(ls),b(Qi),b(ps),b(Oi),b(Ki),b(gs),b(ec),b(us),b(tc),b(hs),b(nc),b(fs),b(oc),b(ac),b(sc),b(_s),b(rc),b(bs),b(ys),b(ic),b(cc),b(lc),b(pc),b(dc),b(ks),b(gc),b(Ts),b(uc),b(js),b(hc),b(Ms),b(fc),b(mc),b(_c),b(bc),b(yc),b(Hs),b(Us),b(vc),b(Cs),b(Is),b(Js),b(xc),b($c),b(Ns),b(As),b(wc),b(Es),b(kc),b(Ds),b(Tc),b(Rs),b(jc),b(Gs),b(Mc),b(qc),b(Hc),b(Uc),b(Fs),b(Cc),b(Ss),b(Ic),b(Ls),b(Ws),b(Jc),b(Vs),b(Bs),b(Ps),b(Nc),b(Ac),b(Ys),b(Ec),b(Dc),b(Xs),b(Rc),b(zs),b(Qs),b(Os),b(Gc),b(Zc),b(er),b(Fc),b(tr),b(Sc),b(nr),b(Lc),b(Wc),b(Vc),b(or),b(Bc),b(ar),b(Pc),b(sr),b(rr),b(ir),b(Yc),b(cr),b(lr),b(pr),b(dr),b(Xc),b(gr),b(ur),b(zc),b(Qc,t),b(Oc,t),b(Kc),b(el,t),b(tl),b(nl,t),b(ol),b(fr),b(al,t),b(sl),b(rl,t),b(il),b(cl,t),b(ll),b(pl,t),b(gl),b(ul,t),b(hl),b(mr),b(fl,t),b(ml),b(_r),b(_l,t),b(bl),b(br),b(yl,t),b(vl),b(xl,t),b($l),b(yr),b(wl,t),b(kl),b(Tl,t),b(jl),b(Ml,t),b(ql),b(vr),b(Hl,t),b(Ul),b(Cl,t),b(Il),b(Jl,t),b(Nl),b(Al,t),b(El),b(Dl,t),b(Rl),b(Gl,t),b(Fl),b(Sl),b(xr),b(Ll),b(Wl),b(Vl),b(Bl,t),b(Pl),b($r),b(wr),b(Yl),b(kr),b(Xl),b(zl),b(Ql,t)}}}const v4='{"title":"HfApi Client","local":"hfapi-client","sections":[{"title":"HfApi","local":"huggingface_hub.HfApi","sections":[],"depth":2},{"title":"API Dataclasses","local":"api-dataclasses","sections":[{"title":"AccessRequest","local":"huggingface_hub.hf_api.AccessRequest","sections":[],"depth":3},{"title":"CommitInfo","local":"huggingface_hub.CommitInfo","sections":[],"depth":3},{"title":"DatasetInfo","local":"huggingface_hub.DatasetInfo","sections":[],"depth":3},{"title":"GitRefInfo","local":"huggingface_hub.GitRefInfo","sections":[],"depth":3},{"title":"GitCommitInfo","local":"huggingface_hub.GitCommitInfo","sections":[],"depth":3},{"title":"GitRefs","local":"huggingface_hub.GitRefs","sections":[],"depth":3},{"title":"InferenceProviderMapping","local":"huggingface_hub.hf_api.InferenceProviderMapping","sections":[],"depth":3},{"title":"LFSFileInfo","local":"huggingface_hub.hf_api.LFSFileInfo","sections":[],"depth":3},{"title":"ModelInfo","local":"huggingface_hub.ModelInfo","sections":[],"depth":3},{"title":"RepoSibling","local":"huggingface_hub.hf_api.RepoSibling","sections":[],"depth":3},{"title":"RepoFile","local":"huggingface_hub.hf_api.RepoFile","sections":[],"depth":3},{"title":"RepoUrl","local":"huggingface_hub.RepoUrl","sections":[],"depth":3},{"title":"SafetensorsRepoMetadata","local":"huggingface_hub.utils.SafetensorsRepoMetadata","sections":[],"depth":3},{"title":"SafetensorsFileMetadata","local":"huggingface_hub.utils.SafetensorsFileMetadata","sections":[],"depth":3},{"title":"SpaceInfo","local":"huggingface_hub.SpaceInfo","sections":[],"depth":3},{"title":"TensorInfo","local":"huggingface_hub.utils.TensorInfo","sections":[],"depth":3},{"title":"User","local":"huggingface_hub.User","sections":[],"depth":3},{"title":"UserLikes","local":"huggingface_hub.UserLikes","sections":[],"depth":3},{"title":"WebhookInfo","local":"huggingface_hub.WebhookInfo","sections":[],"depth":3},{"title":"WebhookWatchedItem","local":"huggingface_hub.WebhookWatchedItem","sections":[],"depth":3}],"depth":2},{"title":"CommitOperation","local":"huggingface_hub.CommitOperationAdd","sections":[],"depth":2},{"title":"CommitScheduler","local":"huggingface_hub.CommitScheduler","sections":[],"depth":2}],"depth":1}';function x4(T){return aH(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class H4 extends sH{constructor(n){super(),rH(this,n,x4,y4,oH,{})}}export{H4 as component};
