import{s as ni,o as Ti,n as pM}from"../chunks/scheduler.6062bdaf.js";import{S as ci,i as oi,g as i,s as M,r as c,A as Ji,h as n,f as t,c as s,j as ii,u as o,x as T,k as fM,y as Ui,a,v as J,d as U,t as d,w as y}from"../chunks/index.4bca734e.js";import{T as rM}from"../chunks/Tip.b9ac1f03.js";import{C as j}from"../chunks/CodeBlock.cbbddafc.js";import{H as I,E as di}from"../chunks/getInferenceSnippets.8c4585c8.js";function yi(r){let h,m=`<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.cached_assets_path">cached_assets_path()</a> is the recommended way to store assets but is not mandatory. If
your library already uses its own cache, feel free to use it!`;return{c(){h=i("p"),h.innerHTML=m},l(w){h=n(w,"P",{"data-svelte-h":!0}),T(h)!=="svelte-1d1cydk"&&(h.innerHTML=m)},m(w,f){a(w,h,f)},p:pM,d(w){w&&t(h)}}}function hi(r){let h,m=`Revision hashes are unique across all repositories. This means you don’t need to
provide any <code>repo_id</code> or <code>repo_type</code> when removing revisions.`;return{c(){h=i("p"),h.innerHTML=m},l(w){h=n(w,"P",{"data-svelte-h":!0}),T(h)!=="svelte-pge9b4"&&(h.innerHTML=m)},m(w,f){a(w,h,f)},p:pM,d(w){w&&t(h)}}}function wi(r){let h,m=`If a revision is not found in the cache, it will be silently ignored. Besides, if a file
or folder cannot be found while trying to delete it, a warning will be logged but no
error is thrown. The deletion continues for other paths contained in the
<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> object.`;return{c(){h=i("p"),h.innerHTML=m},l(w){h=n(w,"P",{"data-svelte-h":!0}),T(h)!=="svelte-y56bqo"&&(h.innerHTML=m)},m(w,f){a(w,h,f)},p:pM,d(w){w&&t(h)}}}function ji(r){let h,m,w,f,A,zl,g,CM="<code>huggingface_hub</code> utilizes the local disk as two caches, which avoid re-downloading items again. The first cache is a file-based cache, which caches individual files downloaded from the Hub and ensures that the same file is not downloaded again when a repo gets updated. The second cache is a chunk cache, where each chunk represents a byte range from a file and ensures that chunks that are shared across files are only downloaded once.",Hl,k,Xl,Z,uM=`The Hugging Face Hub cache-system is designed to be the central cache shared across libraries
that depend on the Hub. It has been updated in v0.8.0 to prevent re-downloading same files
between revisions.`,Pl,N,bM="The caching system is designed as follows:",ql,Y,Kl,G,AM="The default <code>&lt;CACHE_DIR&gt;</code> is <code>~/.cache/huggingface/hub</code>. However, it is customizable with the <code>cache_dir</code> argument on all methods, or by specifying either <code>HF_HOME</code> or <code>HF_HUB_CACHE</code> environment variable.",et,W,gM=`Models, datasets and spaces share a common root. Each of these repositories contains the
repository type, the namespace (organization or username) if it exists and the
repository name:`,lt,S,tt,v,kM=`It is within these folders that all files will now be downloaded from the Hub. Caching ensures that
a file isn’t downloaded twice if it already exists and wasn’t updated; but if it was updated,
and you’re asking for the latest file, then it will download the latest file (while keeping
the previous file intact in case you need it again).`,at,L,ZM="In order to achieve this, all folders contain the same skeleton:",Mt,R,st,x,NM="Each folder is designed to contain the following:",it,F,nt,Q,YM=`The <code>refs</code> folder contains files which indicates the latest revision of the given reference. For example,
if we have previously fetched a file from the <code>main</code> branch of a repository, the <code>refs</code>
folder will contain a file named <code>main</code>, which will itself contain the commit identifier of the current head.`,Tt,D,GM="If the latest commit of <code>main</code> has <code>aaaaaa</code> as identifier, then it will contain <code>aaaaaa</code>.",ct,B,WM=`If that same branch gets updated with a new commit, that has <code>bbbbbb</code> as an identifier, then
re-downloading a file from that reference will update the <code>refs/main</code> file to contain <code>bbbbbb</code>.`,ot,V,Jt,O,SM="The <code>blobs</code> folder contains the actual files that we have downloaded. The name of each file is their hash.",Ut,$,dt,_,vM=`The <code>snapshots</code> folder contains symlinks to the blobs mentioned above. It is itself made up of several folders:
one per known revision!`,yt,E,LM=`In the explanation above, we had initially fetched a file from the <code>aaaaaa</code> revision, before fetching a file from
the <code>bbbbbb</code> revision. In this situation, we would now have two folders in the <code>snapshots</code> folder: <code>aaaaaa</code>
and <code>bbbbbb</code>.`,ht,z,RM=`In each of these folders, live symlinks that have the names of the files that we have downloaded. For example,
if we had downloaded the <code>README.md</code> file at revision <code>aaaaaa</code>, we would have the following path:`,wt,H,jt,X,xM="That <code>README.md</code> file is actually a symlink linking to the blob that has the hash of the file.",It,P,FM=`By creating the skeleton this way we open the mechanism to file sharing: if the same file was fetched in
revision <code>bbbbbb</code>, it would have the same hash and the file would not need to be re-downloaded.`,mt,q,ft,K,QM=`In addition to the <code>blobs</code>, <code>refs</code> and <code>snapshots</code> folders, you might also find a <code>.no_exist</code> folder
in your cache. This folder keeps track of files that you’ve tried to download once but don’t exist
on the Hub. Its structure is the same as the <code>snapshots</code> folder with 1 subfolder per known revision:`,rt,ee,pt,le,DM=`Unlike the <code>snapshots</code> folder, files are simple empty files (no symlinks). In this example,
the file <code>&quot;config_that_does_not_exist.json&quot;</code> does not exist on the Hub for the revision <code>&quot;aaaaaa&quot;</code>.
As it only stores empty files, this folder is neglectable in term of disk usage.`,Ct,te,BM=`So now you might wonder, why is this information even relevant?
In some cases, a framework tries to load optional files for a model. Saving the non-existence
of optional files makes it faster to load a model as it saves 1 HTTP call per possible optional file.
This is for example the case in <code>transformers</code> where each tokenizer can support additional files.
The first time you load the tokenizer on your machine, it will cache which optional files exist (and
which doesn’t) to make the loading time faster for the next initializations.`,ut,ae,VM=`To test if a file is cached locally (without making any HTTP request), you can use the <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.try_to_load_from_cache">try_to_load_from_cache()</a>
helper. It will either return the filepath (if exists and cached), the object <code>_CACHED_NO_EXIST</code> (if non-existence
is cached) or <code>None</code> (if we don’t know).`,bt,Me,At,se,gt,ie,OM="In practice, your cache should look like the following tree:",kt,ne,Zt,Te,Nt,ce,$M=`In order to have an efficient cache-system, <code>huggingface-hub</code> uses symlinks. However,
symlinks are not supported on all machines. This is a known limitation especially on
Windows. When this is the case, <code>huggingface_hub</code> do not use the <code>blobs/</code> directory but
directly stores the files in the <code>snapshots/</code> directory instead. This workaround allows
users to download and cache files from the Hub exactly the same way. Tools to inspect
and delete the cache (see below) are also supported. However, the cache-system is less
efficient as a single file might be downloaded several times if multiple revisions of
the same repo is downloaded.`,Yt,oe,_M=`If you want to benefit from the symlink-based cache-system on a Windows machine, you
either need to <a href="https://docs.microsoft.com/en-us/windows/apps/get-started/enable-your-device-for-development" rel="nofollow">activate Developer Mode</a>
or to run Python as an administrator.`,Gt,Je,EM=`When symlinks are not supported, a warning message is displayed to the user to alert
them they are using a degraded version of the cache-system. This warning can be disabled
by setting the <code>HF_HUB_DISABLE_SYMLINKS_WARNING</code> environment variable to true.`,Wt,Ue,St,de,zM='To provide more efficient file transfers, <code>hf_xet</code> adds a <code>xet</code> directory to the existing <code>huggingface_hub</code> cache, creating additional caching layer to enable chunk-based deduplication. This cache holds chunks (immutable byte ranges of files ~64KB in size) and shards (a data structure that maps files to chunks). For more information on the Xet Storage system, see this <a href="https://huggingface.co/docs/hub/storage-backends" rel="nofollow">section</a>.',vt,ye,HM="The <code>xet</code> directory, located at <code>~/.cache/huggingface/xet</code> by default, contains two caches, utilized for uploads and downloads. It has the following structure:",Lt,he,Rt,we,XM='The <code>environment_identifier</code> directory is an encoded string (it may appear on your machine as <code>https___cas_serv-tGqkUaZf_CBPHQ6h</code>). This is used during development allowing for local and production versions of the cache to exist alongside each other simultaneously. It is also used when downloading from repositories that reside in different <a href="https://huggingface.co/docs/hub/storage-regions" rel="nofollow">storage regions</a>. You may see multiple such entries in the <code>xet</code> directory, each corresponding to a different environment, but their internal structure is the same.',xt,je,PM="The internal directories serve the following purposes:",Ft,Ie,qM="<li><code>chunk-cache</code> contains cached data chunks that are used to speed up downloads.</li> <li><code>shard-cache</code> contains cached shards that are utilized on the upload path.</li> <li><code>staging</code> is a workspace designed to support resumable uploads.</li>",Qt,me,KM="These are documented below.",Dt,fe,es="Note that the <code>xet</code> caching system, like the rest of <code>hf_xet</code> is fully integrated with <code>huggingface_hub</code>.  If you use the existing APIs for interacting with cached assets, there is no need to update your workflow. The <code>xet</code> caches are built as an optimization layer on top of the existing <code>hf_xet</code> chunk-based deduplication and <code>huggingface_hub</code> cache system.",Bt,re,Vt,pe,ls="This cache is used on the download path. The cache directory structure is based on a base-64 encoded hash from the content-addressed store (CAS) that backs each Xet-enabled repository. A CAS hash serves as the key to lookup the offsets of where the data is stored.",Ot,Ce,ts="At the topmost level, the first two letters of the base 64 encoded CAS hash are used to create a subdirectory in the <code>chunk_cache</code> (keys that share these first two letters are grouped here).  The inner levels are comprised of subdirectories with the full key as the directory name. At the base are the cache items which are ranges of blocks that contain the cached chunks.",$t,ue,_t,be,as="When requesting a file, the first thing <code>hf_xet</code> does is communicate with Xet storage’s content addressed store (CAS) for reconstruction information. The reconstruction information contains information about the CAS keys required to download the file in its entirety.",Et,Ae,Ms="Before executing the requests for the CAS keys, the <code>chunk_cache</code> is consulted. If a key in the cache matches a CAS key, then there is no reason to issue a request for that content. <code>hf_xet</code> uses the chunks stored in the directory instead.",zt,ge,ss="As the <code>chunk_cache</code> is purely an optimization, not a guarantee, <code>hf_xet</code> utilizes a computationally efficient eviction policy. When the <code>chunk_cache</code> is full (see <code>Limits and Limitations</code> below), <code>hf_xet</code> implements a random eviction policy when selecting an eviction candidate. This significantly reduces the overhead of managing a robust caching system (e.g., LRU) while still providing most of the benefits of caching chunks.",Ht,ke,Xt,Ze,is="This cache is used when uploading content to the Hub. The directory is flat, comprising only of shard files, each using an ID for the shard name.",Pt,Ne,qt,Ye,ns="The <code>shard_cache</code> contains shards that are:",Kt,Ge,Ts="<li>Locally generated and successfully uploaded to the CAS</li> <li>Downloaded from CAS as part of the global deduplication algorithm</li>",ea,We,cs="Shards provide a mapping between files and chunks. During uploads, each file is chunked and the hash of the chunk is saved. Every shard in the cache is then consulted. If a shard contains a chunk hash that is present in the local file being uploaded, then that chunk can be discarded as it is already stored in CAS.",la,Se,os="All shards have an expiration date of 3-4 weeks from when they are downloaded. Shards that are expired are not loaded during upload and are deleted one week after expiration.",ta,ve,aa,Le,Js="When an upload terminates before the new content has been committed to the repository, you will need to resume the file transfer. However, it is possible that some chunks were successfully uploaded prior to the interruption.",Ma,Re,Us="So that you do not have to restart from the beginning, the <code>staging</code> directory acts as a workspace during uploads, storing metadata for successfully uploaded chunks. The <code>staging</code> directory has the following shape:",sa,xe,ds=`<CACHE_DIR>
├─ xet
│  ├─ staging
│  │  ├─ shard-session
│  │  │  ├─ 906ee184dc1cd0615164a89ed64e8147b3fdccd1163d80d794c66814b3b09992.mdb
│  │  │  ├─ xorb-metadata
│  │  │  │  ├─ 1fe4ffd5cf0c3375f1ef9aec5016cf773ccc5ca294293d3f92d92771dacfc15d.mdb`,ia,Fe,ys="As files are processed and chunks successfully uploaded, their metadata is stored in <code>xorb-metadata</code> as a shard. Upon resuming an upload session, each file is processed again and the shards in this directory are consulted. Any content that was successfully uploaded is skipped, and any new content is uploaded (and its metadata saved).",na,Qe,hs="Meanwhile, <code>shard-session</code> stores file and chunk information for processed files. On successful completion of an upload, the content from these shards is moved to the more persistent <code>shard-cache</code>.",Ta,De,ca,Be,ws="The <code>chunk_cache</code> is limited to 10GB in size while the <code>shard_cache</code> has a soft limit of 4GB.  By design, both caches are without high-level APIs, although their size is configurable through the <code>HF_XET_CHUNK_CACHE_SIZE_BYTES</code> and <code>HF_XET_SHARD_CACHE_SIZE_LIMIT</code> environment variables.",oa,Ve,js='These caches are used primarily to facilitate the reconstruction (download) or upload of a file. To interact with the assets themselves, it’s recommended that you use the <a href="https://huggingface.co/docs/huggingface_hub/guides/manage-cache" rel="nofollow"><code>huggingface_hub</code> cache system APIs</a>.',Ja,Oe,Is="If you need to reclaim the space utilized by either cache or need to debug any potential cache-related issues, simply remove the <code>xet</code> cache entirely by running <code>rm -rf ~/&lt;cache_dir&gt;/xet</code> where <code>&lt;cache_dir&gt;</code> is the location of your Hugging Face cache, typically <code>~/.cache/huggingface</code>",Ua,$e,ms="Example full <code>xet</code>cache directory tree:",da,_e,ya,Ee,fs='To learn more about Xet Storage, see this <a href="https://huggingface.co/docs/hub/storage-backends" rel="nofollow">section</a>.',ha,ze,wa,He,rs=`In addition to caching files from the Hub, downstream libraries often requires to cache
other files related to HF but not handled directly by <code>huggingface_hub</code> (example: file
downloaded from GitHub, preprocessed data, logs,…). In order to cache those files,
called <code>assets</code>, one can use <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.cached_assets_path">cached_assets_path()</a>. This small helper generates paths
in the HF cache in a unified way based on the name of the library requesting it and
optionally on a namespace and a subfolder name. The goal is to let every downstream
libraries manage its assets its own way (e.g. no rule on the structure) as long as it
stays in the right assets folder. Those libraries can then leverage tools from
<code>huggingface_hub</code> to manage the cache, in particular scanning and deleting parts of the
assets from a CLI command.`,ja,Xe,Ia,p,ma,Pe,fa,qe,ps="In practice, your assets cache should look like the following tree:",ra,Ke,pa,el,Ca,ll,ua,tl,Cs=`At the moment, cached files are never deleted from your local directory: when you download
a new revision of a branch, previous files are kept in case you need them again.
Therefore it can be useful to scan your cache directory in order to know which repos
and revisions are taking the most disk space. <code>huggingface_hub</code> provides an helper to
do so that can be used via <code>hf</code> CLI or in a python script.`,ba,al,us="<strong>Scan cache from the terminal</strong>",Aa,Ml,bs="The easiest way to scan your HF cache-system is to use the <code>hf cache scan</code> command line. This command scans the cache and prints a report with information like repo id, repo type, disk usage, refs and full local path.",ga,sl,As="The snippet below shows a scan report in a folder in which 4 models and 2 datasets are cached.",ka,il,Za,nl,gs=`To get a more detailed report, use the <code>--verbose</code> option. For each repo, you get a
list of all revisions that have been downloaded. As explained above, the files that don’t
change between 2 revisions are shared thanks to the symlinks. This means that the size of
the repo on disk is expected to be less than the sum of the size of each of its revisions.
For example, here <code>bert-base-cased</code> has 2 revisions of 1.4G and 1.5G but the total disk
usage is only 1.9G.`,Na,Tl,Ya,cl,ks="<strong>Grep example</strong>",Ga,ol,Zs=`Since the output is in tabular format, you can combine it with any <code>grep</code>-like tools to
filter the entries. Here is an example to filter only revisions from the “t5-small”
model on a Unix-based machine.`,Wa,Jl,Sa,Ul,Ns="<strong>Scan cache from Python</strong>",va,dl,Ys=`For a more advanced usage, use <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.scan_cache_dir">scan_cache_dir()</a> which is the python utility called by
the CLI tool.`,La,yl,Gs="You can use it to get a detailed report structured around 4 dataclasses:",Ra,hl,Ws='<li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo">HFCacheInfo</a>: complete report returned by <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.scan_cache_dir">scan_cache_dir()</a></li> <li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.CachedRepoInfo">CachedRepoInfo</a>: information about a cached repo</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.CachedRevisionInfo">CachedRevisionInfo</a>: information about a cached revision (e.g. “snapshot”) inside a repo</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.CachedFileInfo">CachedFileInfo</a>: information about a cached file in a snapshot</li>',xa,wl,Ss="Here is a simple usage example. See reference for details.",Fa,jl,Qa,Il,Da,ml,vs=`Scanning your cache is interesting but what you really want to do next is usually to
delete some portions to free up some space on your drive. This is possible using the
<code>cache delete</code> CLI command. One can also programmatically use the
<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo.delete_revisions">delete_revisions()</a> helper from <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo">HFCacheInfo</a> object returned when
scanning the cache.`,Ba,fl,Ls="<strong>Delete strategy</strong>",Va,rl,Rs=`To delete some cache, you need to pass a list of revisions to delete. The tool will
define a strategy to free up the space based on this list. It returns a
<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> object that describes which files and folders will be deleted.
The <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> allows give you how much space is expected to be freed.
Once you agree with the deletion, you must execute it to make the deletion effective. In
order to avoid discrepancies, you cannot edit a strategy object manually.`,Oa,pl,xs="The strategy to delete revisions is the following:",$a,Cl,Fs="<li>the <code>snapshot</code> folder containing the revision symlinks is deleted.</li> <li>blobs files that are targeted only by revisions to be deleted are deleted as well.</li> <li>if a revision is linked to 1 or more <code>refs</code>, references are deleted.</li> <li>if all revisions from a repo are deleted, the entire cached repository is deleted.</li>",_a,C,Ea,u,za,ul,Qs="<strong>Clean cache from the terminal</strong>",Ha,bl,Ds=`The easiest way to delete some revisions from your HF cache-system is to use the
<code>hf cache delete</code> CLI tool. The command has two modes. By
default, a TUI (Terminal User Interface) is displayed to the user to select which
revisions to delete. This TUI is currently in beta as it has not been tested on all
platforms. If the TUI doesn’t work on your machine, you can disable it using the
<code>--disable-tui</code> flag.`,Xa,Al,Bs="<strong>Using the TUI</strong>",Pa,gl,Vs=`This is the default mode. To use it, you first need to install extra dependencies by
running the following command:`,qa,kl,Ka,Zl,Os="Then run the command:",eM,Nl,lM,Yl,$s="You should now see a list of revisions that you can select/deselect:",tM,b,_s='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/delete-cache-tui.png"/>',aM,Gl,Es="Instructions:",MM,Wl,zs=`<li>Press keyboard arrow keys <code>&lt;up&gt;</code> and <code>&lt;down&gt;</code> to move the cursor.</li> <li>Press <code>&lt;space&gt;</code> to toggle (select/unselect) an item.</li> <li>When a revision is selected, the first line is updated to show you how much space
will be freed.</li> <li>Press <code>&lt;enter&gt;</code> to confirm your selection.</li> <li>If you want to cancel the operation and quit, you can select the first item
(“None of the following”). If this item is selected, the delete process will be
cancelled, no matter what other items are selected. Otherwise you can also press
<code>&lt;ctrl+c&gt;</code> to quit the TUI.</li>`,sM,Sl,Hs=`Once you’ve selected the revisions you want to delete and pressed <code>&lt;enter&gt;</code>, a last
confirmation message will be prompted. Press <code>&lt;enter&gt;</code> again and the deletion will be
effective. If you want to cancel, enter <code>n</code>.`,iM,vl,nM,Ll,Xs="<strong>Without TUI</strong>",TM,Rl,Ps=`As mentioned above, the TUI mode is currently in beta and is optional. It may be the
case that it doesn’t work on your machine or that you don’t find it convenient.`,cM,xl,qs=`Another approach is to use the <code>--disable-tui</code> flag. The process is very similar as you
will be asked to manually review the list of revisions to delete. However, this manual
step will not take place in the terminal directly but in a temporary file generated on
the fly and that you can manually edit.`,oM,Fl,Ks=`This file has all the instructions you need in the header. Open it in your favorite text
editor. To select/deselect a revision, simply comment/uncomment it with a <code>#</code>. Once the
manual review is done and the file is edited, you can save it. Go back to your terminal
and press <code>&lt;enter&gt;</code>. By default it will compute how much space would be freed with the
updated list of revisions. You can continue to edit the file or confirm with <code>&quot;y&quot;</code>.`,JM,Ql,UM,Dl,ei="Example of command file:",dM,Bl,yM,Vl,li="<strong>Clean cache from Python</strong>",hM,Ol,ti=`For more flexibility, you can also use the <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo.delete_revisions">delete_revisions()</a> method
programmatically. Here is a simple example. See reference for details.`,wM,$l,jM,_l,IM,El,mM;return A=new I({props:{title:"Understand caching",local:"understand-caching",headingTag:"h1"}}),k=new I({props:{title:"File-based caching",local:"file-based-caching",headingTag:"h2"}}),Y=new j({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwJTNDTU9ERUxTJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwJTNDREFUQVNFVFMlM0UlMEElRTIlOTQlOUMlRTIlOTQlODAlMjAlM0NTUEFDRVMlM0U=",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">CACHE_DIR</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">MODELS</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">DATASETS</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">SPACES</span>&gt;</span>`,wrap:!1}}),S=new j({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwbW9kZWxzLS1qdWxpZW4tYy0tRXNwZXJCRVJUby1zbWFsbCUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMG1vZGVscy0tbHlzYW5kcmVqaWstLWFyeGl2LW5scCUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMG1vZGVscy0tYmVydC1iYXNlLWNhc2VkJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwZGF0YXNldHMtLWdsdWUlMEElRTIlOTQlOUMlRTIlOTQlODAlMjBkYXRhc2V0cy0taHVnZ2luZ2ZhY2UtLURhdGFNZWFzdXJlbWVudHNGaWxlcyUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMHNwYWNlcy0tZGFsbGUtbWluaS0tZGFsbGUtbWluaQ==",highlighted:`&lt;<span class="hljs-comment">CACHE_DIR</span>&gt;
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">julien</span><span class="hljs-literal">-</span><span class="hljs-comment">c</span><span class="hljs-literal">--</span><span class="hljs-comment">EsperBERTo</span><span class="hljs-literal">-</span><span class="hljs-comment">small</span>
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">lysandrejik</span><span class="hljs-literal">--</span><span class="hljs-comment">arxiv</span><span class="hljs-literal">-</span><span class="hljs-comment">nlp</span>
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">bert</span><span class="hljs-literal">-</span><span class="hljs-comment">base</span><span class="hljs-literal">-</span><span class="hljs-comment">cased</span>
<span class="hljs-comment">├─ datasets</span><span class="hljs-literal">--</span><span class="hljs-comment">glue</span>
<span class="hljs-comment">├─ datasets</span><span class="hljs-literal">--</span><span class="hljs-comment">huggingface</span><span class="hljs-literal">--</span><span class="hljs-comment">DataMeasurementsFiles</span>
<span class="hljs-comment">├─ spaces</span><span class="hljs-literal">--</span><span class="hljs-comment">dalle</span><span class="hljs-literal">-</span><span class="hljs-comment">mini</span><span class="hljs-literal">--</span><span class="hljs-comment">dalle</span><span class="hljs-literal">-</span><span class="hljs-comment">mini</span>`,wrap:!1}}),R=new j({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwZGF0YXNldHMtLWdsdWUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjByZWZzJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwYmxvYnMlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBzbmFwc2hvdHMlMEEuLi4=",highlighted:`&lt;CACHE_DIR&gt;
├─ datasets<span class="hljs-params">--glue</span>
│  ├─ refs
│  ├─ blobs
│  ├─ snapshots
<span class="hljs-string">...</span>`,wrap:!1}}),F=new I({props:{title:"Refs",local:"refs",headingTag:"h3"}}),V=new I({props:{title:"Blobs",local:"blobs",headingTag:"h3"}}),$=new I({props:{title:"Snapshots",local:"snapshots",headingTag:"h3"}}),H=new j({props:{code:"JTNDQ0FDSEVfRElSJTNFJTJGJTNDUkVQT19OQU1FJTNFJTJGc25hcHNob3RzJTJGYWFhYWFhJTJGUkVBRE1FLm1k",highlighted:'&lt;CACHE_DIR&gt;<span class="hljs-regexp">/&lt;REPO_NAME&gt;/</span>snapshots<span class="hljs-regexp">/aaaaaa/</span>README.md',wrap:!1}}),q=new I({props:{title:".no_exist (advanced)",local:"noexist-advanced",headingTag:"h3"}}),ee=new j({props:{code:"JTNDQ0FDSEVfRElSJTNFJTJGJTNDUkVQT19OQU1FJTNFJTJGLm5vX2V4aXN0JTJGYWFhYWFhJTJGY29uZmlnX3RoYXRfZG9lc19ub3RfZXhpc3QuanNvbg==",highlighted:'&lt;CACHE_DIR&gt;<span class="hljs-regexp">/&lt;REPO_NAME&gt;/</span>.no_exist<span class="hljs-regexp">/aaaaaa/</span>config_that_does_not_exist.json',wrap:!1}}),Me=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHRyeV90b19sb2FkX2Zyb21fY2FjaGUlMkMlMjBfQ0FDSEVEX05PX0VYSVNUJTBBJTBBZmlsZXBhdGglMjAlM0QlMjB0cnlfdG9fbG9hZF9mcm9tX2NhY2hlKCklMEFpZiUyMGlzaW5zdGFuY2UoZmlsZXBhdGglMkMlMjBzdHIpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwZmlsZSUyMGV4aXN0cyUyMGFuZCUyMGlzJTIwY2FjaGVkJTBBJTIwJTIwJTIwJTIwLi4uJTBBZWxpZiUyMGZpbGVwYXRoJTIwaXMlMjBfQ0FDSEVEX05PX0VYSVNUJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwbm9uLWV4aXN0ZW5jZSUyMG9mJTIwZmlsZSUyMGlzJTIwY2FjaGVkJTBBJTIwJTIwJTIwJTIwLi4uJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGZpbGUlMjBpcyUyMG5vdCUyMGNhY2hlZCUwQSUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> try_to_load_from_cache, _CACHED_NO_EXIST

filepath = try_to_load_from_cache()
<span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(filepath, <span class="hljs-built_in">str</span>):
    <span class="hljs-comment"># file exists and is cached</span>
    ...
<span class="hljs-keyword">elif</span> filepath <span class="hljs-keyword">is</span> _CACHED_NO_EXIST:
    <span class="hljs-comment"># non-existence of file is cached</span>
    ...
<span class="hljs-keyword">else</span>:
    <span class="hljs-comment"># file is not cached</span>
    ...`,wrap:!1}}),se=new I({props:{title:"In practice",local:"in-practice",headingTag:"h3"}}),ne=new j({props:{code:"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",highlighted:`    [  96]  .
    └── [ 160]  models--julien-c--EsperBERTo-small
        ├── [ 160]  blobs
        │   ├── [321M]  403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
        │   ├── [ 398]  7cb18dc9bafbfcf74629a4b760af1b160957a83e
        │   └── [1.4K]  d7edf6bd2a681fb0175f7735299831ee1b22b812
        ├── [  96]  refs
        │   └── [  40]  main
        └── [ 128]  snapshots
            ├── [ 128]  2439f60ef33a0d46d85da5001d52aeda5b00ce9f
            │   ├── [  52]  README.md -&gt; ../../blobs/d7edf6bd2a681fb0175f7735299831ee1b22b812
            │   └── [  76]  pytorch_model.bin -&gt; ../../blobs/403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
            └── [ 128]  bbc77c8132af1cc5cf678da3f1ddf2de43606d48
                ├── [  52]  README.md -&gt; ../../blobs/7cb18dc9bafbfcf74629a4b760af1b160957a83e
                └── [  76]  pytorch_model.bin -&gt; ../../blobs/403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd`,wrap:!1}}),Te=new I({props:{title:"Limitations",local:"limitations",headingTag:"h3"}}),Ue=new I({props:{title:"Chunk-based caching (Xet)",local:"chunk-based-caching-xet",headingTag:"h2"}}),he=new j({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwZW52aXJvbm1lbnRfaWRlbnRpZmllciUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMGNodW5rX2NhY2hlJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwc2hhcmRfY2FjaGUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBzdGFnaW5n",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ environment_identifier
│  │  ├─ chunk_cache
│  │  ├─ shard_cache
│  │  ├─ staging`,wrap:!1}}),re=new I({props:{title:"chunk_cache",local:"chunkcache",headingTag:"h3"}}),ue=new j({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwY2h1bmtfY2FjaGUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBBMSUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMEExR2VyVVJMVWNJU1ZpdmRzZWVvWTFQbllpZllrT2FDQ0o3VjVROWZqZ3hrWldaaGRXeDAlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBBQUFBQUFFQUFBQTVEUUFBQUFBQUFJaFJMakRJM1NTNWpZczR5c05LWmlKeTlYRkk4Q043V3cwVXlFQTlLUEQ5JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwQVFBQUFBSUFBQUJ6bmdBQUFBQUFBUE5xUGpkNVpieTVhQnZhYkY3WjFpdEN4MHJ5TXdvQ251UWNEd3E3OWpsQiUwQQ==",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ chunk_cache
│  │  ├─ A1
│  │  │  ├─ A1GerURLUcISVivdseeoY1PnYifYkOaCCJ7V5Q9fjgxkZWZhdWx0
│  │  │  │  ├─ AAAAAAEAAAA5DQAAAAAAAIhRLjDI3SS5jYs4ysNKZiJy9XFI8CN7Ww0UyEA9KPD9
│  │  │  │  ├─ AQAAAAIAAABzngAAAAAAAPNqPjd5Zby5aBvabF7Z1itCx0ryMwoCnuQcDwq79jlB
`,wrap:!1}}),ke=new I({props:{title:"shard_cache",local:"shardcache",headingTag:"h3"}}),Ne=new j({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwc2hhcmRfY2FjaGUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjAxZmU0ZmZkNWNmMGMzMzc1ZjFlZjlhZWM1MDE2Y2Y3NzNjY2M1Y2EyOTQyOTNkM2Y5MmQ5Mjc3MWRhY2ZjMTVkLm1kYiUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMDkwNmVlMTg0ZGMxY2QwNjE1MTY0YTg5ZWQ2NGU4MTQ3YjNmZGNjZDExNjNkODBkNzk0YzY2ODE0YjNiMDk5OTIubWRiJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwY2VlZWI3ZWE0Y2Y2YzBhOGQzOTVhMmNmOWMwODg3MTIxMWZiYmQxN2I5YjVkYzEwMDU4MTE4NDUzMDdlNmI4Zi5tZGIlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBlODUzNTE1NWIxYjExZWJkODk0YzkwOGU5MWExZTE0ZTM0NjFkZGRkMTM5MjY5NWRkYzkwYWU1NGE1NDhkOGIyLm1kYg==",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ shard_cache
│  │  ├─ 1fe4ffd5cf0c3375f1ef9aec5016cf773ccc5ca294293d3f92d92771dacfc15d.mdb
│  │  ├─ 906ee184dc1cd0615164a89ed64e8147b3fdccd1163d80d794c66814b3b09992.mdb
│  │  ├─ ceeeb7ea4cf6c0a8d395a2cf9c08871211fbbd17b9b5dc1005811845307e6b8f.mdb
│  │  ├─ e8535155b1b11ebd894c908e91a1e14e3461dddd1392695ddc90ae54a548d8b2.mdb`,wrap:!1}}),ve=new I({props:{title:"staging",local:"staging",headingTag:"h3"}}),De=new I({props:{title:"Limits and Limitations",local:"limits-and-limitations",headingTag:"h3"}}),_e=new j({props:{code:"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",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ chunk_cache
│  │  ├─ L1
│  │  │  ├─ L1GerURLUcISVivdseeoY1PnYifYkOaCCJ7V5Q9fjgxkZWZhdWx0
│  │  │  │  ├─ AAAAAAEAAAA5DQAAAAAAAIhRLjDI3SS5jYs4ysNKZiJy9XFI8CN7Ww0UyEA9KPD9
│  │  │  │  ├─ AQAAAAIAAABzngAAAAAAAPNqPjd5Zby5aBvabF7Z1itCx0ryMwoCnuQcDwq79jlB
│  ├─ shard_cache
│  │  ├─ 1fe4ffd5cf0c3375f1ef9aec5016cf773ccc5ca294293d3f92d92771dacfc15d.mdb
│  │  ├─ 906ee184dc1cd0615164a89ed64e8147b3fdccd1163d80d794c66814b3b09992.mdb
│  │  ├─ ceeeb7ea4cf6c0a8d395a2cf9c08871211fbbd17b9b5dc1005811845307e6b8f.mdb
│  │  ├─ e8535155b1b11ebd894c908e91a1e14e3461dddd1392695ddc90ae54a548d8b2.mdb
│  ├─ staging
│  │  ├─ shard-session
│  │  │  ├─ 906ee184dc1cd0615164a89ed64e8147b3fdccd1163d80d794c66814b3b09992.mdb
│  │  │  ├─ xorb-metadata
│  │  │  │  ├─ 1fe4ffd5cf0c3375f1ef9aec5016cf773ccc5ca294293d3f92d92771dacfc15d.mdb`,wrap:!1}}),ze=new I({props:{title:"Caching assets",local:"caching-assets",headingTag:"h2"}}),Xe=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNhY2hlZF9hc3NldHNfcGF0aCUwQSUwQWFzc2V0c19wYXRoJTIwJTNEJTIwY2FjaGVkX2Fzc2V0c19wYXRoKGxpYnJhcnlfbmFtZSUzRCUyMmRhdGFzZXRzJTIyJTJDJTIwbmFtZXNwYWNlJTNEJTIyU1F1QUQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJkb3dubG9hZCUyMiklMEFzb21ldGhpbmdfcGF0aCUyMCUzRCUyMGFzc2V0c19wYXRoJTIwJTJGJTIwJTIyc29tZXRoaW5nLmpzb24lMjIlMjAlMjMlMjBEbyUyMGFueXRoaW5nJTIweW91JTIwbGlrZSUyMGluJTIweW91ciUyMGFzc2V0cyUyMGZvbGRlciUyMCE=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> cached_assets_path

assets_path = cached_assets_path(library_name=<span class="hljs-string">&quot;datasets&quot;</span>, namespace=<span class="hljs-string">&quot;SQuAD&quot;</span>, subfolder=<span class="hljs-string">&quot;download&quot;</span>)
something_path = assets_path / <span class="hljs-string">&quot;something.json&quot;</span> <span class="hljs-comment"># Do anything you like in your assets folder !</span>`,wrap:!1}}),p=new rM({props:{$$slots:{default:[yi]},$$scope:{ctx:r}}}),Pe=new I({props:{title:"Assets in practice",local:"assets-in-practice",headingTag:"h3"}}),Ke=new j({props:{code:"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",highlighted:`    assets/
    └── datasets/
    │   ├── SQuAD/
    │   │   ├── downloaded/
    │   │   ├── extracted/
    │   │   └── processed/
    │   ├── Helsinki-NLP--tatoeba_mt/
    │       ├── downloaded/
    │       ├── extracted/
    │       └── processed/
    └── transformers/
        ├── default/
        │   ├── something/
        ├── bert-base-cased/
        │   ├── default/
        │   └── training/
    hub/
    └── models--julien-c--EsperBERTo-small/
        ├── blobs/
        │   ├── (...)
        │   ├── (...)
        ├── refs/
        │   └── (...)
        └── [ 128]  snapshots/
            ├── 2439f60ef33a0d46d85da5001d52aeda5b00ce9f/
            │   ├── (...)
            └── bbc77c8132af1cc5cf678da3f1ddf2de43606d48/
                └── (...)`,wrap:!1}}),el=new I({props:{title:"Manage your file-based cache",local:"manage-your-file-based-cache",headingTag:"h2"}}),ll=new I({props:{title:"Scan your cache",local:"scan-your-cache",headingTag:"h3"}}),il=new j({props:{code:"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",highlighted:`➜ hf cache scan
REPO ID                     REPO TYPE SIZE ON DISK NB FILES LAST_ACCESSED LAST_MODIFIED REFS                LOCAL PATH
--------------------------- --------- ------------ -------- ------------- ------------- ------------------- -------------------------------------------------------------------------
glue                        dataset         116.3K       15 4 days ago    4 days ago    2.4.0, main, 1.17.0 /home/wauplin/.cache/huggingface/hub/datasets--glue
google/fleurs               dataset          64.9M        6 1 week ago    1 week ago    refs/pr/1, main     /home/wauplin/.cache/huggingface/hub/datasets--google--fleurs
Jean-Baptiste/camembert-ner model           441.0M        7 2 weeks ago   16 hours ago  main                /home/wauplin/.cache/huggingface/hub/models--Jean-Baptiste--camembert-ner
bert-base-cased             model             1.9G       13 1 week ago    2 years ago                       /home/wauplin/.cache/huggingface/hub/models--bert-base-cased
t5-base                     model            10.1K        3 3 months ago  3 months ago  main                /home/wauplin/.cache/huggingface/hub/models--t5-base
t5-small                    model           970.7M       11 3 days ago    3 days ago    refs/pr/1, main     /home/wauplin/.cache/huggingface/hub/models--t5-small

Done in 0.0s. Scanned 6 repo(s) for a total of 3.4G.
Got 1 warning(s) while scanning. Use -vvv to print details.`,wrap:!1}}),Tl=new j({props:{code:"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",highlighted:`➜ hf cache scan -v
REPO ID                     REPO TYPE REVISION                                 SIZE ON DISK NB FILES LAST_MODIFIED REFS        LOCAL PATH
--------------------------- --------- ---------------------------------------- ------------ -------- ------------- ----------- ----------------------------------------------------------------------------------------------------------------------------
glue                        dataset   9338f7b671827df886678df2bdd7cc7b4f36dffd        97.7K       14 4 days ago    main, 2.4.0 /home/wauplin/.cache/huggingface/hub/datasets--glue/snapshots/9338f7b671827df886678df2bdd7cc7b4f36dffd
glue                        dataset   f021ae41c879fcabcf823648ec685e3fead91fe7        97.8K       14 1 week ago    1.17.0      /home/wauplin/.cache/huggingface/hub/datasets--glue/snapshots/f021ae41c879fcabcf823648ec685e3fead91fe7
google/fleurs               dataset   129b6e96cf1967cd5d2b9b6aec75ce6cce7c89e8        25.4K        3 2 weeks ago   refs/pr/1   /home/wauplin/.cache/huggingface/hub/datasets--google--fleurs/snapshots/129b6e96cf1967cd5d2b9b6aec75ce6cce7c89e8
google/fleurs               dataset   24f85a01eb955224ca3946e70050869c56446805        64.9M        4 1 week ago    main        /home/wauplin/.cache/huggingface/hub/datasets--google--fleurs/snapshots/24f85a01eb955224ca3946e70050869c56446805
Jean-Baptiste/camembert-ner model     dbec8489a1c44ecad9da8a9185115bccabd799fe       441.0M        7 16 hours ago  main        /home/wauplin/.cache/huggingface/hub/models--Jean-Baptiste--camembert-ner/snapshots/dbec8489a1c44ecad9da8a9185115bccabd799fe
bert-base-cased             model     378aa1bda6387fd00e824948ebe3488630ad8565         1.5G        9 2 years ago               /home/wauplin/.cache/huggingface/hub/models--bert-base-cased/snapshots/378aa1bda6387fd00e824948ebe3488630ad8565
bert-base-cased             model     a8d257ba9925ef39f3036bfc338acf5283c512d9         1.4G        9 3 days ago    main        /home/wauplin/.cache/huggingface/hub/models--bert-base-cased/snapshots/a8d257ba9925ef39f3036bfc338acf5283c512d9
t5-base                     model     23aa4f41cb7c08d4b05c8f327b22bfa0eb8c7ad9        10.1K        3 1 week ago    main        /home/wauplin/.cache/huggingface/hub/models--t5-base/snapshots/23aa4f41cb7c08d4b05c8f327b22bfa0eb8c7ad9
t5-small                    model     98ffebbb27340ec1b1abd7c45da12c253ee1882a       726.2M        6 1 week ago    refs/pr/1   /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/98ffebbb27340ec1b1abd7c45da12c253ee1882a
t5-small                    model     d0a119eedb3718e34c648e594394474cf95e0617       485.8M        6 4 weeks ago               /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d0a119eedb3718e34c648e594394474cf95e0617
t5-small                    model     d78aea13fa7ecd06c29e3e46195d6341255065d5       970.7M        9 1 week ago    main        /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d78aea13fa7ecd06c29e3e46195d6341255065d5

Done in 0.0s. Scanned 6 repo(s) for a total of 3.4G.
Got 1 warning(s) while scanning. Use -vvv to print details.`,wrap:!1}}),Jl=new j({props:{code:"JUUyJTlFJTlDJTIwZXZhbCUyMCUyMmhmJTIwY2FjaGUlMjBzY2FuJTIwLXYlMjIlMjAlN0MlMjBncmVwJTIwJTIydDUtc21hbGwlMjIlMEF0NS1zbWFsbCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTIwJTIwJTIwJTIwJTIwOThmZmViYmIyNzM0MGVjMWIxYWJkN2M0NWRhMTJjMjUzZWUxODgyYSUyMCUyMCUyMCUyMCUyMCUyMCUyMDcyNi4yTSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDYlMjAxJTIwd2VlayUyMGFnbyUyMCUyMCUyMCUyMHJlZnMlMkZwciUyRjElMjAlMjAlMjAlMkZob21lJTJGd2F1cGxpbiUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGaHViJTJGbW9kZWxzLS10NS1zbWFsbCUyRnNuYXBzaG90cyUyRjk4ZmZlYmJiMjczNDBlYzFiMWFiZDdjNDVkYTEyYzI1M2VlMTg4MmElMEF0NS1zbWFsbCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTIwJTIwJTIwJTIwJTIwZDBhMTE5ZWVkYjM3MThlMzRjNjQ4ZTU5NDM5NDQ3NGNmOTVlMDYxNyUyMCUyMCUyMCUyMCUyMCUyMCUyMDQ4NS44TSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDYlMjA0JTIwd2Vla3MlMjBhZ28lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMkZob21lJTJGd2F1cGxpbiUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGaHViJTJGbW9kZWxzLS10NS1zbWFsbCUyRnNuYXBzaG90cyUyRmQwYTExOWVlZGIzNzE4ZTM0YzY0OGU1OTQzOTQ0NzRjZjk1ZTA2MTclMEF0NS1zbWFsbCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTIwJTIwJTIwJTIwJTIwZDc4YWVhMTNmYTdlY2QwNmMyOWUzZTQ2MTk1ZDYzNDEyNTUwNjVkNSUyMCUyMCUyMCUyMCUyMCUyMCUyMDk3MC43TSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDklMjAxJTIwd2VlayUyMGFnbyUyMCUyMCUyMCUyMG1haW4lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMkZob21lJTJGd2F1cGxpbiUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGaHViJTJGbW9kZWxzLS10NS1zbWFsbCUyRnNuYXBzaG90cyUyRmQ3OGFlYTEzZmE3ZWNkMDZjMjllM2U0NjE5NWQ2MzQxMjU1MDY1ZDU=",highlighted:`➜ eval &quot;hf cache scan -v&quot; | grep &quot;t5-small&quot;
t5-small                    model     98ffebbb27340ec1b1abd7c45da12c253ee1882a       726.2M        6 1 week ago    refs/pr/1   /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/98ffebbb27340ec1b1abd7c45da12c253ee1882a
t5-small                    model     d0a119eedb3718e34c648e594394474cf95e0617       485.8M        6 4 weeks ago               /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d0a119eedb3718e34c648e594394474cf95e0617
t5-small                    model     d78aea13fa7ecd06c29e3e46195d6341255065d5       970.7M        9 1 week ago    main        /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d78aea13fa7ecd06c29e3e46195d6341255065d5`,wrap:!1}}),jl=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNjYW5fY2FjaGVfZGlyJTBBJTBBaGZfY2FjaGVfaW5mbyUyMCUzRCUyMHNjYW5fY2FjaGVfZGlyKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> scan_cache_dir

<span class="hljs-meta">&gt;&gt;&gt; </span>hf_cache_info = scan_cache_dir()
HFCacheInfo(
    size_on_disk=<span class="hljs-number">3398085269</span>,
    repos=<span class="hljs-built_in">frozenset</span>({
        CachedRepoInfo(
            repo_id=<span class="hljs-string">&#x27;t5-small&#x27;</span>,
            repo_type=<span class="hljs-string">&#x27;model&#x27;</span>,
            repo_path=PosixPath(...),
            size_on_disk=<span class="hljs-number">970726914</span>,
            nb_files=<span class="hljs-number">11</span>,
            last_accessed=<span class="hljs-number">1662971707.3567169</span>,
            last_modified=<span class="hljs-number">1662971107.3567169</span>,
            revisions=<span class="hljs-built_in">frozenset</span>({
                CachedRevisionInfo(
                    commit_hash=<span class="hljs-string">&#x27;d78aea13fa7ecd06c29e3e46195d6341255065d5&#x27;</span>,
                    size_on_disk=<span class="hljs-number">970726339</span>,
                    snapshot_path=PosixPath(...),
                    <span class="hljs-comment"># No \`last_accessed\` as blobs are shared among revisions</span>
                    last_modified=<span class="hljs-number">1662971107.3567169</span>,
                    files=<span class="hljs-built_in">frozenset</span>({
                        CachedFileInfo(
                            file_name=<span class="hljs-string">&#x27;config.json&#x27;</span>,
                            size_on_disk=<span class="hljs-number">1197</span>
                            file_path=PosixPath(...),
                            blob_path=PosixPath(...),
                            blob_last_accessed=<span class="hljs-number">1662971707.3567169</span>,
                            blob_last_modified=<span class="hljs-number">1662971107.3567169</span>,
                        ),
                        CachedFileInfo(...),
                        ...
                    }),
                ),
                CachedRevisionInfo(...),
                ...
            }),
        ),
        CachedRepoInfo(...),
        ...
    }),
    warnings=[
        CorruptedCacheException(<span class="hljs-string">&quot;Snapshots dir doesn&#x27;t exist in cached repo: ...&quot;</span>),
        CorruptedCacheException(...),
        ...
    ],
)`,wrap:!1}}),Il=new I({props:{title:"Clean your cache",local:"clean-your-cache",headingTag:"h3"}}),C=new rM({props:{$$slots:{default:[hi]},$$scope:{ctx:r}}}),u=new rM({props:{warning:!0,$$slots:{default:[wi]},$$scope:{ctx:r}}}),kl=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1YiU1QiUyMmNsaSUyMiU1RA==",highlighted:'pip <span class="hljs-keyword">install</span> huggingface_hub[<span class="hljs-string">&quot;cli&quot;</span>]',wrap:!1}}),Nl=new j({props:{code:"aGYlMjBjYWNoZSUyMGRlbGV0ZQ==",highlighted:'hf cache <span class="hljs-keyword">delete</span>',wrap:!1}}),vl=new j({props:{code:"JUUyJTlDJTk3JTIwaGYlMjBjYWNoZSUyMGRlbGV0ZSUyMC0tZGlyJTIwfiUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGaHViJTBBJTNGJTIwU2VsZWN0JTIwcmV2aXNpb25zJTIwdG8lMjBkZWxldGUlM0ElMjAyJTIwcmV2aXNpb24ocyklMjBzZWxlY3RlZC4lMEElM0YlMjAyJTIwcmV2aXNpb25zJTIwc2VsZWN0ZWQlMjBjb3VudGluZyUyMGZvciUyMDMuMUcuJTIwQ29uZmlybSUyMGRlbGV0aW9uJTIwJTNGJTIwWWVzJTBBU3RhcnQlMjBkZWxldGlvbi4lMEFEb25lLiUyMERlbGV0ZWQlMjAxJTIwcmVwbyhzKSUyMGFuZCUyMDAlMjByZXZpc2lvbihzKSUyMGZvciUyMGElMjB0b3RhbCUyMG9mJTIwMy4xRy4=",highlighted:`✗ hf cache delete --dir ~/.cache/huggingface/hub
? Select revisions to delete: 2 revision(s) selected.
? 2 revisions selected counting for 3.1G. Confirm deletion ? Yes
Start deletion.
Done. Deleted 1 repo(s) and 0 revision(s) for a total of 3.1G.`,wrap:!1}}),Ql=new j({props:{code:"aGYlMjBjYWNoZSUyMGRlbGV0ZSUyMC0tZGlzYWJsZS10dWk=",highlighted:"hf cache delete --disable-tui",wrap:!1}}),Bl=new j({props:{code:"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",highlighted:`# INSTRUCTIONS
# ------------
# This is a temporary file created by running \`hf cache delete\` with the
# \`--disable-tui\` option. It contains a set of revisions that can be deleted from your
# local cache directory.
#
# Please manually review the revisions you want to delete:
#   - Revision hashes can be commented out with &#x27;#&#x27;.
#   - Only non-commented revisions in this file will be deleted.
#   - Revision hashes that are removed from this file are ignored as well.
#   - If \`CANCEL_DELETION\` line is uncommented, the all cache deletion is cancelled and
#     no changes will be applied.
#
# Once you&#x27;ve manually reviewed this file, please confirm deletion in the terminal. This
# file will be automatically removed once done.
# ------------

# KILL SWITCH
# ------------
# Un-comment following line to completely cancel the deletion process
# CANCEL_DELETION
# ------------

# REVISIONS
# ------------
# Dataset chrisjay/crowd-speech-africa (761.7M, used 5 days ago)
    ebedcd8c55c90d39fd27126d29d8484566cd27ca # Refs: main # modified 5 days ago

# Dataset oscar (3.3M, used 4 days ago)
#    916f956518279c5e60c63902ebdf3ddf9fa9d629 # Refs: main # modified 4 days ago

# Dataset wikiann (804.1K, used 2 weeks ago)
    89d089624b6323d69dcd9e5eb2def0551887a73a # Refs: main # modified 2 weeks ago

# Dataset z-uo/male-LJSpeech-italian (5.5G, used 5 days ago)
#    9cfa5647b32c0a30d0adfca06bf198d82192a0d1 # Refs: main # modified 5 days ago`,wrap:!1}}),$l=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNjYW5fY2FjaGVfZGlyJTBBJTBBZGVsZXRlX3N0cmF0ZWd5JTIwJTNEJTIwc2Nhbl9jYWNoZV9kaXIoKS5kZWxldGVfcmV2aXNpb25zKCUwQSUyMCUyMCUyMCUyMCUyMjgxZmQxZDZlNzg0N2M5OWY1ODYyYzlmYjgxMzg3OTU2ZDk5ZWM3YWElMjIlMEElMjAlMjAlMjAlMjAlMjJlMjk4M2IyMzdkY2NmM2FiNDkzN2M5N2ZhNzE3MzE5YTljYTFhOTZkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyNmMwZTYwODA5NTNkYjU2Mzc1NzYwYzA0NzFhOGM1ZjI5MjliYWYxMSUyMiUyQyUwQSklMEFwcmludCglMjJXaWxsJTIwZnJlZSUyMCUyMiUyMCUyQiUyMGRlbGV0ZV9zdHJhdGVneS5leHBlY3RlZF9mcmVlZF9zaXplX3N0ciklMEElMEFkZWxldGVfc3RyYXRlZ3kuZXhlY3V0ZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> scan_cache_dir

<span class="hljs-meta">&gt;&gt;&gt; </span>delete_strategy = scan_cache_dir().delete_revisions(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;81fd1d6e7847c99f5862c9fb81387956d99ec7aa&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;e2983b237dccf3ab4937c97fa717319a9ca1a96d&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Will free &quot;</span> + delete_strategy.expected_freed_size_str)
Will free <span class="hljs-number">8.6</span>G

<span class="hljs-meta">&gt;&gt;&gt; </span>delete_strategy.execute()
Cache deletion done. Saved <span class="hljs-number">8.6</span>G.`,wrap:!1}}),_l=new di({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/manage-cache.md"}}),{c(){h=i("meta"),m=M(),w=i("p"),f=M(),c(A.$$.fragment),zl=M(),g=i("p"),g.innerHTML=CM,Hl=M(),c(k.$$.fragment),Xl=M(),Z=i("p"),Z.textContent=uM,Pl=M(),N=i("p"),N.textContent=bM,ql=M(),c(Y.$$.fragment),Kl=M(),G=i("p"),G.innerHTML=AM,et=M(),W=i("p"),W.textContent=gM,lt=M(),c(S.$$.fragment),tt=M(),v=i("p"),v.textContent=kM,at=M(),L=i("p"),L.textContent=ZM,Mt=M(),c(R.$$.fragment),st=M(),x=i("p"),x.textContent=NM,it=M(),c(F.$$.fragment),nt=M(),Q=i("p"),Q.innerHTML=YM,Tt=M(),D=i("p"),D.innerHTML=GM,ct=M(),B=i("p"),B.innerHTML=WM,ot=M(),c(V.$$.fragment),Jt=M(),O=i("p"),O.innerHTML=SM,Ut=M(),c($.$$.fragment),dt=M(),_=i("p"),_.innerHTML=vM,yt=M(),E=i("p"),E.innerHTML=LM,ht=M(),z=i("p"),z.innerHTML=RM,wt=M(),c(H.$$.fragment),jt=M(),X=i("p"),X.innerHTML=xM,It=M(),P=i("p"),P.innerHTML=FM,mt=M(),c(q.$$.fragment),ft=M(),K=i("p"),K.innerHTML=QM,rt=M(),c(ee.$$.fragment),pt=M(),le=i("p"),le.innerHTML=DM,Ct=M(),te=i("p"),te.innerHTML=BM,ut=M(),ae=i("p"),ae.innerHTML=VM,bt=M(),c(Me.$$.fragment),At=M(),c(se.$$.fragment),gt=M(),ie=i("p"),ie.textContent=OM,kt=M(),c(ne.$$.fragment),Zt=M(),c(Te.$$.fragment),Nt=M(),ce=i("p"),ce.innerHTML=$M,Yt=M(),oe=i("p"),oe.innerHTML=_M,Gt=M(),Je=i("p"),Je.innerHTML=EM,Wt=M(),c(Ue.$$.fragment),St=M(),de=i("p"),de.innerHTML=zM,vt=M(),ye=i("p"),ye.innerHTML=HM,Lt=M(),c(he.$$.fragment),Rt=M(),we=i("p"),we.innerHTML=XM,xt=M(),je=i("p"),je.textContent=PM,Ft=M(),Ie=i("ul"),Ie.innerHTML=qM,Qt=M(),me=i("p"),me.textContent=KM,Dt=M(),fe=i("p"),fe.innerHTML=es,Bt=M(),c(re.$$.fragment),Vt=M(),pe=i("p"),pe.textContent=ls,Ot=M(),Ce=i("p"),Ce.innerHTML=ts,$t=M(),c(ue.$$.fragment),_t=M(),be=i("p"),be.innerHTML=as,Et=M(),Ae=i("p"),Ae.innerHTML=Ms,zt=M(),ge=i("p"),ge.innerHTML=ss,Ht=M(),c(ke.$$.fragment),Xt=M(),Ze=i("p"),Ze.textContent=is,Pt=M(),c(Ne.$$.fragment),qt=M(),Ye=i("p"),Ye.innerHTML=ns,Kt=M(),Ge=i("ul"),Ge.innerHTML=Ts,ea=M(),We=i("p"),We.textContent=cs,la=M(),Se=i("p"),Se.textContent=os,ta=M(),c(ve.$$.fragment),aa=M(),Le=i("p"),Le.textContent=Js,Ma=M(),Re=i("p"),Re.innerHTML=Us,sa=M(),xe=i("p"),xe.textContent=ds,ia=M(),Fe=i("p"),Fe.innerHTML=ys,na=M(),Qe=i("p"),Qe.innerHTML=hs,Ta=M(),c(De.$$.fragment),ca=M(),Be=i("p"),Be.innerHTML=ws,oa=M(),Ve=i("p"),Ve.innerHTML=js,Ja=M(),Oe=i("p"),Oe.innerHTML=Is,Ua=M(),$e=i("p"),$e.innerHTML=ms,da=M(),c(_e.$$.fragment),ya=M(),Ee=i("p"),Ee.innerHTML=fs,ha=M(),c(ze.$$.fragment),wa=M(),He=i("p"),He.innerHTML=rs,ja=M(),c(Xe.$$.fragment),Ia=M(),c(p.$$.fragment),ma=M(),c(Pe.$$.fragment),fa=M(),qe=i("p"),qe.textContent=ps,ra=M(),c(Ke.$$.fragment),pa=M(),c(el.$$.fragment),Ca=M(),c(ll.$$.fragment),ua=M(),tl=i("p"),tl.innerHTML=Cs,ba=M(),al=i("p"),al.innerHTML=us,Aa=M(),Ml=i("p"),Ml.innerHTML=bs,ga=M(),sl=i("p"),sl.textContent=As,ka=M(),c(il.$$.fragment),Za=M(),nl=i("p"),nl.innerHTML=gs,Na=M(),c(Tl.$$.fragment),Ya=M(),cl=i("p"),cl.innerHTML=ks,Ga=M(),ol=i("p"),ol.innerHTML=Zs,Wa=M(),c(Jl.$$.fragment),Sa=M(),Ul=i("p"),Ul.innerHTML=Ns,va=M(),dl=i("p"),dl.innerHTML=Ys,La=M(),yl=i("p"),yl.textContent=Gs,Ra=M(),hl=i("ul"),hl.innerHTML=Ws,xa=M(),wl=i("p"),wl.textContent=Ss,Fa=M(),c(jl.$$.fragment),Qa=M(),c(Il.$$.fragment),Da=M(),ml=i("p"),ml.innerHTML=vs,Ba=M(),fl=i("p"),fl.innerHTML=Ls,Va=M(),rl=i("p"),rl.innerHTML=Rs,Oa=M(),pl=i("p"),pl.textContent=xs,$a=M(),Cl=i("ul"),Cl.innerHTML=Fs,_a=M(),c(C.$$.fragment),Ea=M(),c(u.$$.fragment),za=M(),ul=i("p"),ul.innerHTML=Qs,Ha=M(),bl=i("p"),bl.innerHTML=Ds,Xa=M(),Al=i("p"),Al.innerHTML=Bs,Pa=M(),gl=i("p"),gl.textContent=Vs,qa=M(),c(kl.$$.fragment),Ka=M(),Zl=i("p"),Zl.textContent=Os,eM=M(),c(Nl.$$.fragment),lM=M(),Yl=i("p"),Yl.textContent=$s,tM=M(),b=i("div"),b.innerHTML=_s,aM=M(),Gl=i("p"),Gl.textContent=Es,MM=M(),Wl=i("ul"),Wl.innerHTML=zs,sM=M(),Sl=i("p"),Sl.innerHTML=Hs,iM=M(),c(vl.$$.fragment),nM=M(),Ll=i("p"),Ll.innerHTML=Xs,TM=M(),Rl=i("p"),Rl.textContent=Ps,cM=M(),xl=i("p"),xl.innerHTML=qs,oM=M(),Fl=i("p"),Fl.innerHTML=Ks,JM=M(),c(Ql.$$.fragment),UM=M(),Dl=i("p"),Dl.textContent=ei,dM=M(),c(Bl.$$.fragment),yM=M(),Vl=i("p"),Vl.innerHTML=li,hM=M(),Ol=i("p"),Ol.innerHTML=ti,wM=M(),c($l.$$.fragment),jM=M(),c(_l.$$.fragment),IM=M(),El=i("p"),this.h()},l(e){const l=Ji("svelte-u9bgzb",document.head);h=n(l,"META",{name:!0,content:!0}),l.forEach(t),m=s(e),w=n(e,"P",{}),ii(w).forEach(t),f=s(e),o(A.$$.fragment,e),zl=s(e),g=n(e,"P",{"data-svelte-h":!0}),T(g)!=="svelte-1s3yler"&&(g.innerHTML=CM),Hl=s(e),o(k.$$.fragment,e),Xl=s(e),Z=n(e,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-7434pt"&&(Z.textContent=uM),Pl=s(e),N=n(e,"P",{"data-svelte-h":!0}),T(N)!=="svelte-bm5pxs"&&(N.textContent=bM),ql=s(e),o(Y.$$.fragment,e),Kl=s(e),G=n(e,"P",{"data-svelte-h":!0}),T(G)!=="svelte-lw0yzm"&&(G.innerHTML=AM),et=s(e),W=n(e,"P",{"data-svelte-h":!0}),T(W)!=="svelte-1xsylbb"&&(W.textContent=gM),lt=s(e),o(S.$$.fragment,e),tt=s(e),v=n(e,"P",{"data-svelte-h":!0}),T(v)!=="svelte-smirw4"&&(v.textContent=kM),at=s(e),L=n(e,"P",{"data-svelte-h":!0}),T(L)!=="svelte-hxzvg9"&&(L.textContent=ZM),Mt=s(e),o(R.$$.fragment,e),st=s(e),x=n(e,"P",{"data-svelte-h":!0}),T(x)!=="svelte-1o80jr1"&&(x.textContent=NM),it=s(e),o(F.$$.fragment,e),nt=s(e),Q=n(e,"P",{"data-svelte-h":!0}),T(Q)!=="svelte-z6cr2z"&&(Q.innerHTML=YM),Tt=s(e),D=n(e,"P",{"data-svelte-h":!0}),T(D)!=="svelte-15cx8ge"&&(D.innerHTML=GM),ct=s(e),B=n(e,"P",{"data-svelte-h":!0}),T(B)!=="svelte-1u7b6sn"&&(B.innerHTML=WM),ot=s(e),o(V.$$.fragment,e),Jt=s(e),O=n(e,"P",{"data-svelte-h":!0}),T(O)!=="svelte-9jec47"&&(O.innerHTML=SM),Ut=s(e),o($.$$.fragment,e),dt=s(e),_=n(e,"P",{"data-svelte-h":!0}),T(_)!=="svelte-1mswky"&&(_.innerHTML=vM),yt=s(e),E=n(e,"P",{"data-svelte-h":!0}),T(E)!=="svelte-1f9g1u2"&&(E.innerHTML=LM),ht=s(e),z=n(e,"P",{"data-svelte-h":!0}),T(z)!=="svelte-1ezxfdw"&&(z.innerHTML=RM),wt=s(e),o(H.$$.fragment,e),jt=s(e),X=n(e,"P",{"data-svelte-h":!0}),T(X)!=="svelte-7nae39"&&(X.innerHTML=xM),It=s(e),P=n(e,"P",{"data-svelte-h":!0}),T(P)!=="svelte-sjd8l1"&&(P.innerHTML=FM),mt=s(e),o(q.$$.fragment,e),ft=s(e),K=n(e,"P",{"data-svelte-h":!0}),T(K)!=="svelte-dxew1x"&&(K.innerHTML=QM),rt=s(e),o(ee.$$.fragment,e),pt=s(e),le=n(e,"P",{"data-svelte-h":!0}),T(le)!=="svelte-f64xkc"&&(le.innerHTML=DM),Ct=s(e),te=n(e,"P",{"data-svelte-h":!0}),T(te)!=="svelte-178rlr8"&&(te.innerHTML=BM),ut=s(e),ae=n(e,"P",{"data-svelte-h":!0}),T(ae)!=="svelte-lua08t"&&(ae.innerHTML=VM),bt=s(e),o(Me.$$.fragment,e),At=s(e),o(se.$$.fragment,e),gt=s(e),ie=n(e,"P",{"data-svelte-h":!0}),T(ie)!=="svelte-1cw24ss"&&(ie.textContent=OM),kt=s(e),o(ne.$$.fragment,e),Zt=s(e),o(Te.$$.fragment,e),Nt=s(e),ce=n(e,"P",{"data-svelte-h":!0}),T(ce)!=="svelte-1foktgq"&&(ce.innerHTML=$M),Yt=s(e),oe=n(e,"P",{"data-svelte-h":!0}),T(oe)!=="svelte-x8ev9q"&&(oe.innerHTML=_M),Gt=s(e),Je=n(e,"P",{"data-svelte-h":!0}),T(Je)!=="svelte-1ue61z6"&&(Je.innerHTML=EM),Wt=s(e),o(Ue.$$.fragment,e),St=s(e),de=n(e,"P",{"data-svelte-h":!0}),T(de)!=="svelte-1pw0cpj"&&(de.innerHTML=zM),vt=s(e),ye=n(e,"P",{"data-svelte-h":!0}),T(ye)!=="svelte-o7am1f"&&(ye.innerHTML=HM),Lt=s(e),o(he.$$.fragment,e),Rt=s(e),we=n(e,"P",{"data-svelte-h":!0}),T(we)!=="svelte-15i0o7a"&&(we.innerHTML=XM),xt=s(e),je=n(e,"P",{"data-svelte-h":!0}),T(je)!=="svelte-nj5twx"&&(je.textContent=PM),Ft=s(e),Ie=n(e,"UL",{"data-svelte-h":!0}),T(Ie)!=="svelte-15a5775"&&(Ie.innerHTML=qM),Qt=s(e),me=n(e,"P",{"data-svelte-h":!0}),T(me)!=="svelte-68d6zk"&&(me.textContent=KM),Dt=s(e),fe=n(e,"P",{"data-svelte-h":!0}),T(fe)!=="svelte-1fqunt1"&&(fe.innerHTML=es),Bt=s(e),o(re.$$.fragment,e),Vt=s(e),pe=n(e,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-jcytje"&&(pe.textContent=ls),Ot=s(e),Ce=n(e,"P",{"data-svelte-h":!0}),T(Ce)!=="svelte-im7pgk"&&(Ce.innerHTML=ts),$t=s(e),o(ue.$$.fragment,e),_t=s(e),be=n(e,"P",{"data-svelte-h":!0}),T(be)!=="svelte-gkyc1z"&&(be.innerHTML=as),Et=s(e),Ae=n(e,"P",{"data-svelte-h":!0}),T(Ae)!=="svelte-16gi99u"&&(Ae.innerHTML=Ms),zt=s(e),ge=n(e,"P",{"data-svelte-h":!0}),T(ge)!=="svelte-1nna80w"&&(ge.innerHTML=ss),Ht=s(e),o(ke.$$.fragment,e),Xt=s(e),Ze=n(e,"P",{"data-svelte-h":!0}),T(Ze)!=="svelte-1shtud2"&&(Ze.textContent=is),Pt=s(e),o(Ne.$$.fragment,e),qt=s(e),Ye=n(e,"P",{"data-svelte-h":!0}),T(Ye)!=="svelte-h63bo"&&(Ye.innerHTML=ns),Kt=s(e),Ge=n(e,"UL",{"data-svelte-h":!0}),T(Ge)!=="svelte-1sf7fpu"&&(Ge.innerHTML=Ts),ea=s(e),We=n(e,"P",{"data-svelte-h":!0}),T(We)!=="svelte-5htz2c"&&(We.textContent=cs),la=s(e),Se=n(e,"P",{"data-svelte-h":!0}),T(Se)!=="svelte-imyi1b"&&(Se.textContent=os),ta=s(e),o(ve.$$.fragment,e),aa=s(e),Le=n(e,"P",{"data-svelte-h":!0}),T(Le)!=="svelte-1gjzgfe"&&(Le.textContent=Js),Ma=s(e),Re=n(e,"P",{"data-svelte-h":!0}),T(Re)!=="svelte-1ced4p2"&&(Re.innerHTML=Us),sa=s(e),xe=n(e,"P",{"data-svelte-h":!0}),T(xe)!=="svelte-4sdu17"&&(xe.textContent=ds),ia=s(e),Fe=n(e,"P",{"data-svelte-h":!0}),T(Fe)!=="svelte-wvh9oo"&&(Fe.innerHTML=ys),na=s(e),Qe=n(e,"P",{"data-svelte-h":!0}),T(Qe)!=="svelte-o4afuj"&&(Qe.innerHTML=hs),Ta=s(e),o(De.$$.fragment,e),ca=s(e),Be=n(e,"P",{"data-svelte-h":!0}),T(Be)!=="svelte-1ki79zi"&&(Be.innerHTML=ws),oa=s(e),Ve=n(e,"P",{"data-svelte-h":!0}),T(Ve)!=="svelte-1qzo8xt"&&(Ve.innerHTML=js),Ja=s(e),Oe=n(e,"P",{"data-svelte-h":!0}),T(Oe)!=="svelte-yngdyh"&&(Oe.innerHTML=Is),Ua=s(e),$e=n(e,"P",{"data-svelte-h":!0}),T($e)!=="svelte-er0a1o"&&($e.innerHTML=ms),da=s(e),o(_e.$$.fragment,e),ya=s(e),Ee=n(e,"P",{"data-svelte-h":!0}),T(Ee)!=="svelte-7cx0vv"&&(Ee.innerHTML=fs),ha=s(e),o(ze.$$.fragment,e),wa=s(e),He=n(e,"P",{"data-svelte-h":!0}),T(He)!=="svelte-1r0ndhn"&&(He.innerHTML=rs),ja=s(e),o(Xe.$$.fragment,e),Ia=s(e),o(p.$$.fragment,e),ma=s(e),o(Pe.$$.fragment,e),fa=s(e),qe=n(e,"P",{"data-svelte-h":!0}),T(qe)!=="svelte-1lsljsl"&&(qe.textContent=ps),ra=s(e),o(Ke.$$.fragment,e),pa=s(e),o(el.$$.fragment,e),Ca=s(e),o(ll.$$.fragment,e),ua=s(e),tl=n(e,"P",{"data-svelte-h":!0}),T(tl)!=="svelte-vou1gt"&&(tl.innerHTML=Cs),ba=s(e),al=n(e,"P",{"data-svelte-h":!0}),T(al)!=="svelte-1ycn1eb"&&(al.innerHTML=us),Aa=s(e),Ml=n(e,"P",{"data-svelte-h":!0}),T(Ml)!=="svelte-17hhor3"&&(Ml.innerHTML=bs),ga=s(e),sl=n(e,"P",{"data-svelte-h":!0}),T(sl)!=="svelte-ikv8d5"&&(sl.textContent=As),ka=s(e),o(il.$$.fragment,e),Za=s(e),nl=n(e,"P",{"data-svelte-h":!0}),T(nl)!=="svelte-2cqqt0"&&(nl.innerHTML=gs),Na=s(e),o(Tl.$$.fragment,e),Ya=s(e),cl=n(e,"P",{"data-svelte-h":!0}),T(cl)!=="svelte-4zvnaj"&&(cl.innerHTML=ks),Ga=s(e),ol=n(e,"P",{"data-svelte-h":!0}),T(ol)!=="svelte-1h7dpll"&&(ol.innerHTML=Zs),Wa=s(e),o(Jl.$$.fragment,e),Sa=s(e),Ul=n(e,"P",{"data-svelte-h":!0}),T(Ul)!=="svelte-b9d1g2"&&(Ul.innerHTML=Ns),va=s(e),dl=n(e,"P",{"data-svelte-h":!0}),T(dl)!=="svelte-1bx4n8u"&&(dl.innerHTML=Ys),La=s(e),yl=n(e,"P",{"data-svelte-h":!0}),T(yl)!=="svelte-83019z"&&(yl.textContent=Gs),Ra=s(e),hl=n(e,"UL",{"data-svelte-h":!0}),T(hl)!=="svelte-qwuhrl"&&(hl.innerHTML=Ws),xa=s(e),wl=n(e,"P",{"data-svelte-h":!0}),T(wl)!=="svelte-xp69b3"&&(wl.textContent=Ss),Fa=s(e),o(jl.$$.fragment,e),Qa=s(e),o(Il.$$.fragment,e),Da=s(e),ml=n(e,"P",{"data-svelte-h":!0}),T(ml)!=="svelte-2u13fo"&&(ml.innerHTML=vs),Ba=s(e),fl=n(e,"P",{"data-svelte-h":!0}),T(fl)!=="svelte-s9tc9t"&&(fl.innerHTML=Ls),Va=s(e),rl=n(e,"P",{"data-svelte-h":!0}),T(rl)!=="svelte-1wode1b"&&(rl.innerHTML=Rs),Oa=s(e),pl=n(e,"P",{"data-svelte-h":!0}),T(pl)!=="svelte-19y0r7c"&&(pl.textContent=xs),$a=s(e),Cl=n(e,"UL",{"data-svelte-h":!0}),T(Cl)!=="svelte-o7nsmh"&&(Cl.innerHTML=Fs),_a=s(e),o(C.$$.fragment,e),Ea=s(e),o(u.$$.fragment,e),za=s(e),ul=n(e,"P",{"data-svelte-h":!0}),T(ul)!=="svelte-13xgrrb"&&(ul.innerHTML=Qs),Ha=s(e),bl=n(e,"P",{"data-svelte-h":!0}),T(bl)!=="svelte-1jaqj97"&&(bl.innerHTML=Ds),Xa=s(e),Al=n(e,"P",{"data-svelte-h":!0}),T(Al)!=="svelte-vbosxs"&&(Al.innerHTML=Bs),Pa=s(e),gl=n(e,"P",{"data-svelte-h":!0}),T(gl)!=="svelte-yr0mit"&&(gl.textContent=Vs),qa=s(e),o(kl.$$.fragment,e),Ka=s(e),Zl=n(e,"P",{"data-svelte-h":!0}),T(Zl)!=="svelte-gq4pgy"&&(Zl.textContent=Os),eM=s(e),o(Nl.$$.fragment,e),lM=s(e),Yl=n(e,"P",{"data-svelte-h":!0}),T(Yl)!=="svelte-20gxv"&&(Yl.textContent=$s),tM=s(e),b=n(e,"DIV",{class:!0,"data-svelte-h":!0}),T(b)!=="svelte-17iq48i"&&(b.innerHTML=_s),aM=s(e),Gl=n(e,"P",{"data-svelte-h":!0}),T(Gl)!=="svelte-7awvfp"&&(Gl.textContent=Es),MM=s(e),Wl=n(e,"UL",{"data-svelte-h":!0}),T(Wl)!=="svelte-76obk"&&(Wl.innerHTML=zs),sM=s(e),Sl=n(e,"P",{"data-svelte-h":!0}),T(Sl)!=="svelte-aoo47g"&&(Sl.innerHTML=Hs),iM=s(e),o(vl.$$.fragment,e),nM=s(e),Ll=n(e,"P",{"data-svelte-h":!0}),T(Ll)!=="svelte-ewwg27"&&(Ll.innerHTML=Xs),TM=s(e),Rl=n(e,"P",{"data-svelte-h":!0}),T(Rl)!=="svelte-ymcz12"&&(Rl.textContent=Ps),cM=s(e),xl=n(e,"P",{"data-svelte-h":!0}),T(xl)!=="svelte-u5k7vk"&&(xl.innerHTML=qs),oM=s(e),Fl=n(e,"P",{"data-svelte-h":!0}),T(Fl)!=="svelte-1baaith"&&(Fl.innerHTML=Ks),JM=s(e),o(Ql.$$.fragment,e),UM=s(e),Dl=n(e,"P",{"data-svelte-h":!0}),T(Dl)!=="svelte-15nmp2q"&&(Dl.textContent=ei),dM=s(e),o(Bl.$$.fragment,e),yM=s(e),Vl=n(e,"P",{"data-svelte-h":!0}),T(Vl)!=="svelte-1ayyols"&&(Vl.innerHTML=li),hM=s(e),Ol=n(e,"P",{"data-svelte-h":!0}),T(Ol)!=="svelte-qm6d3g"&&(Ol.innerHTML=ti),wM=s(e),o($l.$$.fragment,e),jM=s(e),o(_l.$$.fragment,e),IM=s(e),El=n(e,"P",{}),ii(El).forEach(t),this.h()},h(){fM(h,"name","hf:doc:metadata"),fM(h,"content",Ii),fM(b,"class","flex justify-center")},m(e,l){Ui(document.head,h),a(e,m,l),a(e,w,l),a(e,f,l),J(A,e,l),a(e,zl,l),a(e,g,l),a(e,Hl,l),J(k,e,l),a(e,Xl,l),a(e,Z,l),a(e,Pl,l),a(e,N,l),a(e,ql,l),J(Y,e,l),a(e,Kl,l),a(e,G,l),a(e,et,l),a(e,W,l),a(e,lt,l),J(S,e,l),a(e,tt,l),a(e,v,l),a(e,at,l),a(e,L,l),a(e,Mt,l),J(R,e,l),a(e,st,l),a(e,x,l),a(e,it,l),J(F,e,l),a(e,nt,l),a(e,Q,l),a(e,Tt,l),a(e,D,l),a(e,ct,l),a(e,B,l),a(e,ot,l),J(V,e,l),a(e,Jt,l),a(e,O,l),a(e,Ut,l),J($,e,l),a(e,dt,l),a(e,_,l),a(e,yt,l),a(e,E,l),a(e,ht,l),a(e,z,l),a(e,wt,l),J(H,e,l),a(e,jt,l),a(e,X,l),a(e,It,l),a(e,P,l),a(e,mt,l),J(q,e,l),a(e,ft,l),a(e,K,l),a(e,rt,l),J(ee,e,l),a(e,pt,l),a(e,le,l),a(e,Ct,l),a(e,te,l),a(e,ut,l),a(e,ae,l),a(e,bt,l),J(Me,e,l),a(e,At,l),J(se,e,l),a(e,gt,l),a(e,ie,l),a(e,kt,l),J(ne,e,l),a(e,Zt,l),J(Te,e,l),a(e,Nt,l),a(e,ce,l),a(e,Yt,l),a(e,oe,l),a(e,Gt,l),a(e,Je,l),a(e,Wt,l),J(Ue,e,l),a(e,St,l),a(e,de,l),a(e,vt,l),a(e,ye,l),a(e,Lt,l),J(he,e,l),a(e,Rt,l),a(e,we,l),a(e,xt,l),a(e,je,l),a(e,Ft,l),a(e,Ie,l),a(e,Qt,l),a(e,me,l),a(e,Dt,l),a(e,fe,l),a(e,Bt,l),J(re,e,l),a(e,Vt,l),a(e,pe,l),a(e,Ot,l),a(e,Ce,l),a(e,$t,l),J(ue,e,l),a(e,_t,l),a(e,be,l),a(e,Et,l),a(e,Ae,l),a(e,zt,l),a(e,ge,l),a(e,Ht,l),J(ke,e,l),a(e,Xt,l),a(e,Ze,l),a(e,Pt,l),J(Ne,e,l),a(e,qt,l),a(e,Ye,l),a(e,Kt,l),a(e,Ge,l),a(e,ea,l),a(e,We,l),a(e,la,l),a(e,Se,l),a(e,ta,l),J(ve,e,l),a(e,aa,l),a(e,Le,l),a(e,Ma,l),a(e,Re,l),a(e,sa,l),a(e,xe,l),a(e,ia,l),a(e,Fe,l),a(e,na,l),a(e,Qe,l),a(e,Ta,l),J(De,e,l),a(e,ca,l),a(e,Be,l),a(e,oa,l),a(e,Ve,l),a(e,Ja,l),a(e,Oe,l),a(e,Ua,l),a(e,$e,l),a(e,da,l),J(_e,e,l),a(e,ya,l),a(e,Ee,l),a(e,ha,l),J(ze,e,l),a(e,wa,l),a(e,He,l),a(e,ja,l),J(Xe,e,l),a(e,Ia,l),J(p,e,l),a(e,ma,l),J(Pe,e,l),a(e,fa,l),a(e,qe,l),a(e,ra,l),J(Ke,e,l),a(e,pa,l),J(el,e,l),a(e,Ca,l),J(ll,e,l),a(e,ua,l),a(e,tl,l),a(e,ba,l),a(e,al,l),a(e,Aa,l),a(e,Ml,l),a(e,ga,l),a(e,sl,l),a(e,ka,l),J(il,e,l),a(e,Za,l),a(e,nl,l),a(e,Na,l),J(Tl,e,l),a(e,Ya,l),a(e,cl,l),a(e,Ga,l),a(e,ol,l),a(e,Wa,l),J(Jl,e,l),a(e,Sa,l),a(e,Ul,l),a(e,va,l),a(e,dl,l),a(e,La,l),a(e,yl,l),a(e,Ra,l),a(e,hl,l),a(e,xa,l),a(e,wl,l),a(e,Fa,l),J(jl,e,l),a(e,Qa,l),J(Il,e,l),a(e,Da,l),a(e,ml,l),a(e,Ba,l),a(e,fl,l),a(e,Va,l),a(e,rl,l),a(e,Oa,l),a(e,pl,l),a(e,$a,l),a(e,Cl,l),a(e,_a,l),J(C,e,l),a(e,Ea,l),J(u,e,l),a(e,za,l),a(e,ul,l),a(e,Ha,l),a(e,bl,l),a(e,Xa,l),a(e,Al,l),a(e,Pa,l),a(e,gl,l),a(e,qa,l),J(kl,e,l),a(e,Ka,l),a(e,Zl,l),a(e,eM,l),J(Nl,e,l),a(e,lM,l),a(e,Yl,l),a(e,tM,l),a(e,b,l),a(e,aM,l),a(e,Gl,l),a(e,MM,l),a(e,Wl,l),a(e,sM,l),a(e,Sl,l),a(e,iM,l),J(vl,e,l),a(e,nM,l),a(e,Ll,l),a(e,TM,l),a(e,Rl,l),a(e,cM,l),a(e,xl,l),a(e,oM,l),a(e,Fl,l),a(e,JM,l),J(Ql,e,l),a(e,UM,l),a(e,Dl,l),a(e,dM,l),J(Bl,e,l),a(e,yM,l),a(e,Vl,l),a(e,hM,l),a(e,Ol,l),a(e,wM,l),J($l,e,l),a(e,jM,l),J(_l,e,l),a(e,IM,l),a(e,El,l),mM=!0},p(e,[l]){const ai={};l&2&&(ai.$$scope={dirty:l,ctx:e}),p.$set(ai);const Mi={};l&2&&(Mi.$$scope={dirty:l,ctx:e}),C.$set(Mi);const si={};l&2&&(si.$$scope={dirty:l,ctx:e}),u.$set(si)},i(e){mM||(U(A.$$.fragment,e),U(k.$$.fragment,e),U(Y.$$.fragment,e),U(S.$$.fragment,e),U(R.$$.fragment,e),U(F.$$.fragment,e),U(V.$$.fragment,e),U($.$$.fragment,e),U(H.$$.fragment,e),U(q.$$.fragment,e),U(ee.$$.fragment,e),U(Me.$$.fragment,e),U(se.$$.fragment,e),U(ne.$$.fragment,e),U(Te.$$.fragment,e),U(Ue.$$.fragment,e),U(he.$$.fragment,e),U(re.$$.fragment,e),U(ue.$$.fragment,e),U(ke.$$.fragment,e),U(Ne.$$.fragment,e),U(ve.$$.fragment,e),U(De.$$.fragment,e),U(_e.$$.fragment,e),U(ze.$$.fragment,e),U(Xe.$$.fragment,e),U(p.$$.fragment,e),U(Pe.$$.fragment,e),U(Ke.$$.fragment,e),U(el.$$.fragment,e),U(ll.$$.fragment,e),U(il.$$.fragment,e),U(Tl.$$.fragment,e),U(Jl.$$.fragment,e),U(jl.$$.fragment,e),U(Il.$$.fragment,e),U(C.$$.fragment,e),U(u.$$.fragment,e),U(kl.$$.fragment,e),U(Nl.$$.fragment,e),U(vl.$$.fragment,e),U(Ql.$$.fragment,e),U(Bl.$$.fragment,e),U($l.$$.fragment,e),U(_l.$$.fragment,e),mM=!0)},o(e){d(A.$$.fragment,e),d(k.$$.fragment,e),d(Y.$$.fragment,e),d(S.$$.fragment,e),d(R.$$.fragment,e),d(F.$$.fragment,e),d(V.$$.fragment,e),d($.$$.fragment,e),d(H.$$.fragment,e),d(q.$$.fragment,e),d(ee.$$.fragment,e),d(Me.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(Te.$$.fragment,e),d(Ue.$$.fragment,e),d(he.$$.fragment,e),d(re.$$.fragment,e),d(ue.$$.fragment,e),d(ke.$$.fragment,e),d(Ne.$$.fragment,e),d(ve.$$.fragment,e),d(De.$$.fragment,e),d(_e.$$.fragment,e),d(ze.$$.fragment,e),d(Xe.$$.fragment,e),d(p.$$.fragment,e),d(Pe.$$.fragment,e),d(Ke.$$.fragment,e),d(el.$$.fragment,e),d(ll.$$.fragment,e),d(il.$$.fragment,e),d(Tl.$$.fragment,e),d(Jl.$$.fragment,e),d(jl.$$.fragment,e),d(Il.$$.fragment,e),d(C.$$.fragment,e),d(u.$$.fragment,e),d(kl.$$.fragment,e),d(Nl.$$.fragment,e),d(vl.$$.fragment,e),d(Ql.$$.fragment,e),d(Bl.$$.fragment,e),d($l.$$.fragment,e),d(_l.$$.fragment,e),mM=!1},d(e){e&&(t(m),t(w),t(f),t(zl),t(g),t(Hl),t(Xl),t(Z),t(Pl),t(N),t(ql),t(Kl),t(G),t(et),t(W),t(lt),t(tt),t(v),t(at),t(L),t(Mt),t(st),t(x),t(it),t(nt),t(Q),t(Tt),t(D),t(ct),t(B),t(ot),t(Jt),t(O),t(Ut),t(dt),t(_),t(yt),t(E),t(ht),t(z),t(wt),t(jt),t(X),t(It),t(P),t(mt),t(ft),t(K),t(rt),t(pt),t(le),t(Ct),t(te),t(ut),t(ae),t(bt),t(At),t(gt),t(ie),t(kt),t(Zt),t(Nt),t(ce),t(Yt),t(oe),t(Gt),t(Je),t(Wt),t(St),t(de),t(vt),t(ye),t(Lt),t(Rt),t(we),t(xt),t(je),t(Ft),t(Ie),t(Qt),t(me),t(Dt),t(fe),t(Bt),t(Vt),t(pe),t(Ot),t(Ce),t($t),t(_t),t(be),t(Et),t(Ae),t(zt),t(ge),t(Ht),t(Xt),t(Ze),t(Pt),t(qt),t(Ye),t(Kt),t(Ge),t(ea),t(We),t(la),t(Se),t(ta),t(aa),t(Le),t(Ma),t(Re),t(sa),t(xe),t(ia),t(Fe),t(na),t(Qe),t(Ta),t(ca),t(Be),t(oa),t(Ve),t(Ja),t(Oe),t(Ua),t($e),t(da),t(ya),t(Ee),t(ha),t(wa),t(He),t(ja),t(Ia),t(ma),t(fa),t(qe),t(ra),t(pa),t(Ca),t(ua),t(tl),t(ba),t(al),t(Aa),t(Ml),t(ga),t(sl),t(ka),t(Za),t(nl),t(Na),t(Ya),t(cl),t(Ga),t(ol),t(Wa),t(Sa),t(Ul),t(va),t(dl),t(La),t(yl),t(Ra),t(hl),t(xa),t(wl),t(Fa),t(Qa),t(Da),t(ml),t(Ba),t(fl),t(Va),t(rl),t(Oa),t(pl),t($a),t(Cl),t(_a),t(Ea),t(za),t(ul),t(Ha),t(bl),t(Xa),t(Al),t(Pa),t(gl),t(qa),t(Ka),t(Zl),t(eM),t(lM),t(Yl),t(tM),t(b),t(aM),t(Gl),t(MM),t(Wl),t(sM),t(Sl),t(iM),t(nM),t(Ll),t(TM),t(Rl),t(cM),t(xl),t(oM),t(Fl),t(JM),t(UM),t(Dl),t(dM),t(yM),t(Vl),t(hM),t(Ol),t(wM),t(jM),t(IM),t(El)),t(h),y(A,e),y(k,e),y(Y,e),y(S,e),y(R,e),y(F,e),y(V,e),y($,e),y(H,e),y(q,e),y(ee,e),y(Me,e),y(se,e),y(ne,e),y(Te,e),y(Ue,e),y(he,e),y(re,e),y(ue,e),y(ke,e),y(Ne,e),y(ve,e),y(De,e),y(_e,e),y(ze,e),y(Xe,e),y(p,e),y(Pe,e),y(Ke,e),y(el,e),y(ll,e),y(il,e),y(Tl,e),y(Jl,e),y(jl,e),y(Il,e),y(C,e),y(u,e),y(kl,e),y(Nl,e),y(vl,e),y(Ql,e),y(Bl,e),y($l,e),y(_l,e)}}}const Ii='{"title":"Understand caching","local":"understand-caching","sections":[{"title":"File-based caching","local":"file-based-caching","sections":[{"title":"Refs","local":"refs","sections":[],"depth":3},{"title":"Blobs","local":"blobs","sections":[],"depth":3},{"title":"Snapshots","local":"snapshots","sections":[],"depth":3},{"title":".no_exist (advanced)","local":"noexist-advanced","sections":[],"depth":3},{"title":"In practice","local":"in-practice","sections":[],"depth":3},{"title":"Limitations","local":"limitations","sections":[],"depth":3}],"depth":2},{"title":"Chunk-based caching (Xet)","local":"chunk-based-caching-xet","sections":[{"title":"chunk_cache","local":"chunkcache","sections":[],"depth":3},{"title":"shard_cache","local":"shardcache","sections":[],"depth":3},{"title":"staging","local":"staging","sections":[],"depth":3},{"title":"Limits and Limitations","local":"limits-and-limitations","sections":[],"depth":3}],"depth":2},{"title":"Caching assets","local":"caching-assets","sections":[{"title":"Assets in practice","local":"assets-in-practice","sections":[],"depth":3}],"depth":2},{"title":"Manage your file-based cache","local":"manage-your-file-based-cache","sections":[{"title":"Scan your cache","local":"scan-your-cache","sections":[],"depth":3},{"title":"Clean your cache","local":"clean-your-cache","sections":[],"depth":3}],"depth":2}],"depth":1}';function mi(r){return Ti(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bi extends ci{constructor(h){super(),oi(this,h,mi,ji,ni,{})}}export{bi as component};
