import{s as Re,n as Se,o as Ne}from"../chunks/scheduler.8c3d61f6.js";import{S as Ve,i as Ye,g as n,s as a,r as p,A as Ce,h as o,f as t,c as i,j as z,u as r,x as m,k as qe,y as M,a as s,v as c,d as u,t as d,w as f}from"../chunks/index.da70eac4.js";import{C as F}from"../chunks/CodeBlock.a9c4becf.js";import{D as De}from"../chunks/DocNotebookDropdown.48852948.js";import{H as P,E as Qe}from"../chunks/getInferenceSnippets.7d4354d6.js";function ze(Be){let b,L,D,A,y,K,w,O,g,Ge='Diffusion is a random process that is computationally demanding. You may need to run the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> several times before getting a desired output. That’s why it’s important to carefully balance generation speed and memory usage in order to iterate faster,',ee,T,We='This guide recommends some basic performance tips for using the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Refer to the Inference Optimization section docs such as <a href="./optimization/fp16">Accelerate inference</a> or <a href="./optimization/memory">Reduce memory usage</a> for more detailed performance guides.',le,j,te,Z,Ie="Reducing the amount of memory used indirectly speeds up generation and can help a model fit on device.",se,B,Ue='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> method moves a model to the CPU when it is not in use to save GPU memory.',ae,G,ie,W,ne,I,ve="Denoising is the most computationally demanding process during diffusion. Methods that optimizes this process accelerates inference speed. Try the following methods for a speed up.",oe,U,Ee="<li>Add <code>device_map=&quot;cuda&quot;</code> to place the pipeline on a GPU. Placing a model on an accelerator, like a GPU, increases speed because it performs computations in parallel.</li> <li>Set <code>torch_dtype=torch.bfloat16</code> to execute the pipeline in half-precision. Reducing the data type precision increases speed because it takes less time to perform computations in a lower precision.</li>",pe,v,re,E,$e='<li>Use a faster scheduler, such as <a href="/docs/diffusers/main/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a>, which only requires ~20-25 steps.</li> <li>Set <code>num_inference_steps</code> to a lower value. Reducing the number of inference steps reduces the overall number of computations. However, this can result in lower generation quality.</li>',me,$,ce,_,ue,k,_e="Many modern diffusion models deliver high-quality images out-of-the-box. However, you can still improve generation quality by trying the following.",de,J,h,N,ke="Try a more detailed and descriptive prompt. Include details such as the image medium, subject, style, and aesthetic. A negative prompt may also help by guiding a model away from undesirable features by using words like low quality or blurry.",ge,x,Te,V,xe='For more details about creating better prompts, take a look at the <a href="./using-diffusers/weighted_prompts">Prompt techniques</a> doc.',je,X,Y,Xe='Try a different scheduler, like <a href="/docs/diffusers/main/en/api/schedulers/heun#diffusers.HeunDiscreteScheduler">HeunDiscreteScheduler</a> or <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, that gives up generation speed for quality.',Ze,H,fe,q,Me,R,He='Diffusers offers more advanced and powerful optimizations such as <a href="./optimization/memory#group-offloading">group-offloading</a> and <a href="./optimization/fp16#regional-compilation">regional compilation</a>. To learn more about how to maximize performance, take a look at the Inference Optimization section.',be,S,he,Q,Je;return y=new De({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/stable_diffusion.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/stable_diffusion.ipynb"}]}}),w=new P({props:{title:"Basic performance",local:"basic-performance",headingTag:"h1"}}),j=new P({props:{title:"Memory usage",local:"memory-usage",headingTag:"h2"}}),G=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjIlMEFjaW5lbWF0aWMlMjBmaWxtJTIwc3RpbGwlMjBvZiUyMGElMjBjYXQlMjBzaXBwaW5nJTIwYSUyMG1hcmdhcml0YSUyMGluJTIwYSUyMHBvb2wlMjBpbiUyMFBhbG0lMjBTcHJpbmdzJTJDJTIwQ2FsaWZvcm5pYSUwQWhpZ2hseSUyMGRldGFpbGVkJTJDJTIwaGlnaCUyMGJ1ZGdldCUyMGhvbGx5d29vZCUyMG1vdmllJTJDJTIwY2luZW1hc2NvcGUlMkMlMjBtb29keSUyQyUyMGVwaWMlMkMlMjBnb3JnZW91cyUyQyUyMGZpbG0lMjBncmFpbiUwQSUyMiUyMiUyMiUwQXBpcGVsaW5lKHByb21wdCkuaW1hZ2VzJTVCMCU1RCUwQXByaW50KGYlMjJNYXglMjBtZW1vcnklMjByZXNlcnZlZCUzQSUyMCU3QnRvcmNoLmN1ZGEubWF4X21lbW9yeV9hbGxvY2F0ZWQoKSUyMCUyRiUyMDEwMjQqKjMlM0EuMmYlN0QlMjBHQiUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  torch_dtype=torch.bfloat16,
  device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>
pipeline(prompt).images[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)`,wrap:!1}}),W=new P({props:{title:"Inference speed",local:"inference-speed",headingTag:"h2"}}),v=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1lJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler

pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  torch_dtype=torch.bfloat16,
  device_map=<span class="hljs-string">&quot;cuda
)</span>`,wrap:!1}}),$=new F({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTBBY2luZW1hdGljJTIwZmlsbSUyMHN0aWxsJTIwb2YlMjBhJTIwY2F0JTIwc2lwcGluZyUyMGElMjBtYXJnYXJpdGElMjBpbiUyMGElMjBwb29sJTIwaW4lMjBQYWxtJTIwU3ByaW5ncyUyQyUyMENhbGlmb3JuaWElMEFoaWdobHklMjBkZXRhaWxlZCUyQyUyMGhpZ2glMjBidWRnZXQlMjBob2xseXdvb2QlMjBtb3ZpZSUyQyUyMGNpbmVtYXNjb3BlJTJDJTIwbW9vZHklMkMlMjBlcGljJTJDJTIwZ29yZ2VvdXMlMkMlMjBmaWxtJTIwZ3JhaW4lMEElMjIlMjIlMjIlMEElMEFzdGFydF90aW1lJTIwJTNEJTIwdGltZS5wZXJmX2NvdW50ZXIoKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBZW5kX3RpbWUlMjAlM0QlMjB0aW1lLnBlcmZfY291bnRlcigpJTBBJTBBcHJpbnQoZiUyMkltYWdlJTIwZ2VuZXJhdGlvbiUyMHRvb2slMjAlN0JlbmRfdGltZSUyMC0lMjBzdGFydF90aW1lJTNBLjNmJTdEJTIwc2Vjb25kcyUyMik=",highlighted:`pipeline.scheduler = DPMSolverMultistepScheduler.from_config(pipeline.scheduler.config)

prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>

start_time = time.perf_counter()
image = pipeline(prompt).images[<span class="hljs-number">0</span>]
end_time = time.perf_counter()

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Image generation took <span class="hljs-subst">{end_time - start_time:<span class="hljs-number">.3</span>f}</span> seconds&quot;</span>)`,wrap:!1}}),_=new P({props:{title:"Generation quality",local:"generation-quality",headingTag:"h2"}}),x=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTBBY2luZW1hdGljJTIwZmlsbSUyMHN0aWxsJTIwb2YlMjBhJTIwY2F0JTIwc2lwcGluZyUyMGElMjBtYXJnYXJpdGElMjBpbiUyMGElMjBwb29sJTIwaW4lMjBQYWxtJTIwU3ByaW5ncyUyQyUyMENhbGlmb3JuaWElMEFoaWdobHklMjBkZXRhaWxlZCUyQyUyMGhpZ2glMjBidWRnZXQlMjBob2xseXdvb2QlMjBtb3ZpZSUyQyUyMGNpbmVtYXNjb3BlJTJDJTIwbW9vZHklMkMlMjBlcGljJTJDJTIwZ29yZ2VvdXMlMkMlMjBmaWxtJTIwZ3JhaW4lMEElMjIlMjIlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJsb3clMjBxdWFsaXR5JTJDJTIwYmx1cnJ5JTJDJTIwdWdseSUyQyUyMHBvb3IlMjBkZXRhaWxzJTIyJTBBcGlwZWxpbmUocHJvbXB0JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)

prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, blurry, ugly, poor details&quot;</span>
pipeline(prompt, negative_prompt=negative_prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),H=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBIZXVuRGlzY3JldGVTY2hlZHVsZXIlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwSGV1bkRpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTBBY2luZW1hdGljJTIwZmlsbSUyMHN0aWxsJTIwb2YlMjBhJTIwY2F0JTIwc2lwcGluZyUyMGElMjBtYXJnYXJpdGElMjBpbiUyMGElMjBwb29sJTIwaW4lMjBQYWxtJTIwU3ByaW5ncyUyQyUyMENhbGlmb3JuaWElMEFoaWdobHklMjBkZXRhaWxlZCUyQyUyMGhpZ2glMjBidWRnZXQlMjBob2xseXdvb2QlMjBtb3ZpZSUyQyUyMGNpbmVtYXNjb3BlJTJDJTIwbW9vZHklMkMlMjBlcGljJTJDJTIwZ29yZ2VvdXMlMkMlMjBmaWxtJTIwZ3JhaW4lMEElMjIlMjIlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJsb3clMjBxdWFsaXR5JTJDJTIwYmx1cnJ5JTJDJTIwdWdseSUyQyUyMHBvb3IlMjBkZXRhaWxzJTIyJTBBcGlwZWxpbmUocHJvbXB0JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, HeunDiscreteScheduler

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.scheduler = HeunDiscreteScheduler.from_config(pipeline.scheduler.config)

prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, blurry, ugly, poor details&quot;</span>
pipeline(prompt, negative_prompt=negative_prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),q=new P({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),S=new Qe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/stable_diffusion.md"}}),{c(){b=n("meta"),L=a(),D=n("p"),A=a(),p(y.$$.fragment),K=a(),p(w.$$.fragment),O=a(),g=n("p"),g.innerHTML=Ge,ee=a(),T=n("p"),T.innerHTML=We,le=a(),p(j.$$.fragment),te=a(),Z=n("p"),Z.textContent=Ie,se=a(),B=n("p"),B.innerHTML=Ue,ae=a(),p(G.$$.fragment),ie=a(),p(W.$$.fragment),ne=a(),I=n("p"),I.textContent=ve,oe=a(),U=n("ul"),U.innerHTML=Ee,pe=a(),p(v.$$.fragment),re=a(),E=n("ul"),E.innerHTML=$e,me=a(),p($.$$.fragment),ce=a(),p(_.$$.fragment),ue=a(),k=n("p"),k.textContent=_e,de=a(),J=n("ul"),h=n("li"),N=n("p"),N.textContent=ke,ge=a(),p(x.$$.fragment),Te=a(),V=n("p"),V.innerHTML=xe,je=a(),X=n("li"),Y=n("p"),Y.innerHTML=Xe,Ze=a(),p(H.$$.fragment),fe=a(),p(q.$$.fragment),Me=a(),R=n("p"),R.innerHTML=He,be=a(),p(S.$$.fragment),he=a(),Q=n("p"),this.h()},l(e){const l=Ce("svelte-u9bgzb",document.head);b=o(l,"META",{name:!0,content:!0}),l.forEach(t),L=i(e),D=o(e,"P",{}),z(D).forEach(t),A=i(e),r(y.$$.fragment,e),K=i(e),r(w.$$.fragment,e),O=i(e),g=o(e,"P",{"data-svelte-h":!0}),m(g)!=="svelte-6ma4qg"&&(g.innerHTML=Ge),ee=i(e),T=o(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-8olqr2"&&(T.innerHTML=We),le=i(e),r(j.$$.fragment,e),te=i(e),Z=o(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-fyzqn3"&&(Z.textContent=Ie),se=i(e),B=o(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-d80wi9"&&(B.innerHTML=Ue),ae=i(e),r(G.$$.fragment,e),ie=i(e),r(W.$$.fragment,e),ne=i(e),I=o(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-sd5qgg"&&(I.textContent=ve),oe=i(e),U=o(e,"UL",{"data-svelte-h":!0}),m(U)!=="svelte-qgt4qu"&&(U.innerHTML=Ee),pe=i(e),r(v.$$.fragment,e),re=i(e),E=o(e,"UL",{"data-svelte-h":!0}),m(E)!=="svelte-12ganj0"&&(E.innerHTML=$e),me=i(e),r($.$$.fragment,e),ce=i(e),r(_.$$.fragment,e),ue=i(e),k=o(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1j9t3hy"&&(k.textContent=_e),de=i(e),J=o(e,"UL",{});var ye=z(J);h=o(ye,"LI",{});var C=z(h);N=o(C,"P",{"data-svelte-h":!0}),m(N)!=="svelte-nfntwz"&&(N.textContent=ke),ge=i(C),r(x.$$.fragment,C),Te=i(C),V=o(C,"P",{"data-svelte-h":!0}),m(V)!=="svelte-4kgw7d"&&(V.innerHTML=xe),C.forEach(t),je=i(ye),X=o(ye,"LI",{});var we=z(X);Y=o(we,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-50vh6d"&&(Y.innerHTML=Xe),Ze=i(we),r(H.$$.fragment,we),we.forEach(t),ye.forEach(t),fe=i(e),r(q.$$.fragment,e),Me=i(e),R=o(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1nwdflp"&&(R.innerHTML=He),be=i(e),r(S.$$.fragment,e),he=i(e),Q=o(e,"P",{}),z(Q).forEach(t),this.h()},h(){qe(b,"name","hf:doc:metadata"),qe(b,"content",Fe)},m(e,l){M(document.head,b),s(e,L,l),s(e,D,l),s(e,A,l),c(y,e,l),s(e,K,l),c(w,e,l),s(e,O,l),s(e,g,l),s(e,ee,l),s(e,T,l),s(e,le,l),c(j,e,l),s(e,te,l),s(e,Z,l),s(e,se,l),s(e,B,l),s(e,ae,l),c(G,e,l),s(e,ie,l),c(W,e,l),s(e,ne,l),s(e,I,l),s(e,oe,l),s(e,U,l),s(e,pe,l),c(v,e,l),s(e,re,l),s(e,E,l),s(e,me,l),c($,e,l),s(e,ce,l),c(_,e,l),s(e,ue,l),s(e,k,l),s(e,de,l),s(e,J,l),M(J,h),M(h,N),M(h,ge),c(x,h,null),M(h,Te),M(h,V),M(J,je),M(J,X),M(X,Y),M(X,Ze),c(H,X,null),s(e,fe,l),c(q,e,l),s(e,Me,l),s(e,R,l),s(e,be,l),c(S,e,l),s(e,he,l),s(e,Q,l),Je=!0},p:Se,i(e){Je||(u(y.$$.fragment,e),u(w.$$.fragment,e),u(j.$$.fragment,e),u(G.$$.fragment,e),u(W.$$.fragment,e),u(v.$$.fragment,e),u($.$$.fragment,e),u(_.$$.fragment,e),u(x.$$.fragment,e),u(H.$$.fragment,e),u(q.$$.fragment,e),u(S.$$.fragment,e),Je=!0)},o(e){d(y.$$.fragment,e),d(w.$$.fragment,e),d(j.$$.fragment,e),d(G.$$.fragment,e),d(W.$$.fragment,e),d(v.$$.fragment,e),d($.$$.fragment,e),d(_.$$.fragment,e),d(x.$$.fragment,e),d(H.$$.fragment,e),d(q.$$.fragment,e),d(S.$$.fragment,e),Je=!1},d(e){e&&(t(L),t(D),t(A),t(K),t(O),t(g),t(ee),t(T),t(le),t(te),t(Z),t(se),t(B),t(ae),t(ie),t(ne),t(I),t(oe),t(U),t(pe),t(re),t(E),t(me),t(ce),t(ue),t(k),t(de),t(J),t(fe),t(Me),t(R),t(be),t(he),t(Q)),t(b),f(y,e),f(w,e),f(j,e),f(G,e),f(W,e),f(v,e),f($,e),f(_,e),f(x),f(H),f(q,e),f(S,e)}}}const Fe='{"title":"Basic performance","local":"basic-performance","sections":[{"title":"Memory usage","local":"memory-usage","sections":[],"depth":2},{"title":"Inference speed","local":"inference-speed","sections":[],"depth":2},{"title":"Generation quality","local":"generation-quality","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Pe(Be){return Ne(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ll extends Ve{constructor(b){super(),Ye(this,b,Pe,ze,Re,{})}}export{ll as component};
