import{s as cs,o as ps,n as G}from"../chunks/scheduler.8c3d61f6.js";import{S as us,i as ms,g as a,s as i,r as m,A as hs,h as r,f as l,c as s,j as T,u as h,x as p,k as C,y as t,a as u,v as g,d as b,t as _,w as v}from"../chunks/index.da70eac4.js";import{T as _n}from"../chunks/Tip.1d9b8c37.js";import{D as k}from"../chunks/Docstring.81aa96ab.js";import{C as ht}from"../chunks/CodeBlock.a9c4becf.js";import{E as mt}from"../chunks/ExampleCodeBlock.a775434f.js";import{H as Rn,E as gs}from"../chunks/getInferenceSnippets.7d4354d6.js";function bs(P){let o,w='You shouldn’t use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class for training. Individual components (for example, <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> and <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) of diffusion pipelines are usually trained individually, so we suggest directly working with them instead.',d,f,$,n,M='Pipelines do not offer any training functionality. You’ll notice PyTorch’s autograd is disabled by decorating the <code>__call__()</code> method with a <a href="https://pytorch.org/docs/stable/generated/torch.no_grad.html" rel="nofollow"><code>torch.no_grad</code></a> decorator because pipelines should not be used for training. If you’re interested in training, please take a look at the <a href="../../training/overview">Training</a> guides instead!';return{c(){o=a("p"),o.innerHTML=w,d=i(),f=a("br"),$=i(),n=a("p"),n.innerHTML=M},l(D){o=r(D,"P",{"data-svelte-h":!0}),p(o)!=="svelte-17t0bk9"&&(o.innerHTML=w),d=s(D),f=r(D,"BR",{}),$=s(D),n=r(D,"P",{"data-svelte-h":!0}),p(n)!=="svelte-1a94ctl"&&(n.innerHTML=M)},m(D,A){u(D,o,A),u(D,d,A),u(D,f,A),u(D,$,A),u(D,n,A)},p:G,d(D){D&&(l(o),l(d),l(f),l($),l(n))}}}function _s(P){let o,w=`If the pipeline already has the correct torch.dtype and torch.device, then it is returned as is. Otherwise,
the returned pipeline is a copy of self with the desired torch.dtype and torch.device.`;return{c(){o=a("p"),o.textContent=w},l(d){o=r(d,"P",{"data-svelte-h":!0}),p(o)!=="svelte-18gkv0g"&&(o.textContent=w)},m(d,f){u(d,o,f)},p:G,d(d){d&&l(o)}}}function vs(P){let o,w="Examples:",d,f,$;return f=new ht({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUyQyUwQSklMEElMEF0ZXh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBaW1nMmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSgqKnRleHQyaW1nLmNvbXBvbmVudHMpJTBBaW5wYWludCUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSgqKnRleHQyaW1nLmNvbXBvbmVudHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    StableDiffusionPipeline,
<span class="hljs-meta">... </span>    StableDiffusionImg2ImgPipeline,
<span class="hljs-meta">... </span>    StableDiffusionInpaintPipeline,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text2img = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img2img = StableDiffusionImg2ImgPipeline(**text2img.components)
<span class="hljs-meta">&gt;&gt;&gt; </span>inpaint = StableDiffusionInpaintPipeline(**text2img.components)`,wrap:!1}}),{c(){o=a("p"),o.textContent=w,d=i(),m(f.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=w),d=s(n),h(f.$$.fragment,n)},m(n,M){u(n,o,M),u(n,d,M),g(f,n,M),$=!0},p:G,i(n){$||(b(f.$$.fragment,n),$=!0)},o(n){_(f.$$.fragment,n),$=!1},d(n){n&&(l(o),l(d)),v(f,n)}}}function ys(P){let o,w='To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with `hf\nauth login';return{c(){o=a("p"),o.innerHTML=w},l(d){o=r(d,"P",{"data-svelte-h":!0}),p(o)!=="svelte-167kq00"&&(o.innerHTML=w)},m(d,f){u(d,o,f)},p:G,d(d){d&&l(o)}}}function xs(P){let o,w=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=a("p"),o.innerHTML=w},l(d){o=r(d,"P",{"data-svelte-h":!0}),p(o)!=="svelte-ackzsn"&&(o.innerHTML=w)},m(d,f){u(d,o,f)},p:G,d(d){d&&l(o)}}}function $s(P){let o,w="Examples:",d,f,$;return f=new ht({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=a("p"),o.textContent=w,d=i(),m(f.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=w),d=s(n),h(f.$$.fragment,n)},m(n,M){u(n,o,M),u(n,d,M),g(f,n,M),$=!0},p:G,i(n){$||(b(f.$$.fragment,n),$=!0)},o(n){_(f.$$.fragment,n),$=!1},d(n){n&&(l(o),l(d)),v(f,n)}}}function ws(P){let o,w=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=a("p"),o.textContent=w},l(d){o=r(d,"P",{"data-svelte-h":!0}),p(o)!=="svelte-17p1lpg"&&(o.textContent=w)},m(d,f){u(d,o,f)},p:G,d(d){d&&l(o)}}}function Ms(P){let o,w="Examples:",d,f,$;return f=new ht({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){o=a("p"),o.textContent=w,d=i(),m(f.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=w),d=s(n),h(f.$$.fragment,n)},m(n,M){u(n,o,M),u(n,d,M),g(f,n,M),$=!0},p:G,i(n){$||(b(f.$$.fragment,n),$=!0)},o(n){_(f.$$.fragment,n),$=!1},d(n){n&&(l(o),l(d)),v(f,n)}}}function Ts(P){let o,w="Examples:",d,f,$;return f=new ht({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uU0FHUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEFuZXdfcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblNBR1BpcGVsaW5lLmZyb21fcGlwZShwaXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionSAGPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>new_pipe = StableDiffusionSAGPipeline.from_pipe(pipe)`,wrap:!1}}),{c(){o=a("p"),o.textContent=w,d=i(),m(f.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=w),d=s(n),h(f.$$.fragment,n)},m(n,M){u(n,o,M),u(n,d,M),g(f,n,M),$=!0},p:G,i(n){$||(b(f.$$.fragment,n),$=!0)},o(n){_(f.$$.fragment,n),$=!1},d(n){n&&(l(o),l(d)),v(f,n)}}}function Cs(P){let o,w="If you get the error message below, you need to finetune the weights for your downstream task:",d,f,$;return f=new ht({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwYW5kJTIwYXJlJTIwbmV3bHklMjBpbml0aWFsaXplZCUyMGJlY2F1c2UlMjB0aGUlMjBzaGFwZXMlMjBkaWQlMjBub3QlMjBtYXRjaCUzQSUwQS0lMjBjb252X2luLndlaWdodCUzQSUyMGZvdW5kJTIwc2hhcGUlMjB0b3JjaC5TaXplKCU1QjMyMCUyQyUyMDQlMkMlMjAzJTJDJTIwMyU1RCklMjBpbiUyMHRoZSUyMGNoZWNrcG9pbnQlMjBhbmQlMjB0b3JjaC5TaXplKCU1QjMyMCUyQyUyMDklMkMlMjAzJTJDJTIwMyU1RCklMjBpbiUyMHRoZSUyMG1vZGVsJTIwaW5zdGFudGlhdGVkJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`Some weights of UNet2DConditionModel were not initialized from the model checkpoint <span class="hljs-built_in">at</span> stable-<span class="hljs-keyword">diffusion-v1-5/stable-diffusion-v1-5 </span><span class="hljs-keyword">and </span>are newly initialized <span class="hljs-keyword">because </span>the <span class="hljs-keyword">shapes </span><span class="hljs-keyword">did </span>not match:
- conv_in.weight: found <span class="hljs-keyword">shape </span>torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) in the checkpoint <span class="hljs-keyword">and </span>torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">9</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) in the model <span class="hljs-keyword">instantiated
</span>You <span class="hljs-keyword">should </span>probably TRAIN this model on a down-stream task to <span class="hljs-keyword">be </span>able to use it for predictions <span class="hljs-keyword">and </span>inference.`,wrap:!1}}),{c(){o=a("p"),o.textContent=w,d=i(),m(f.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-xueb0m"&&(o.textContent=w),d=s(n),h(f.$$.fragment,n)},m(n,M){u(n,o,M),u(n,d,M),g(f,n,M),$=!0},p:G,i(n){$||(b(f.$$.fragment,n),$=!0)},o(n){_(f.$$.fragment,n),$=!1},d(n){n&&(l(o),l(d)),v(f,n)}}}function ks(P){let o,w='To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated</a> models, log-in with <code>hf auth login</code>.';return{c(){o=a("p"),o.innerHTML=w},l(d){o=r(d,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1qg11oj"&&(o.innerHTML=w)},m(d,f){u(d,o,f)},p:G,d(d){d&&l(o)}}}function Ps(P){let o,w="Examples:",d,f,$;return f=new ht({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZsZG0tdGV4dDJpbS1sYXJnZS0yNTYlMjIpJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMHRoYXQlMjByZXF1aXJlcyUyMGFuJTIwYXV0aG9yaXphdGlvbiUyMHRva2VuJTBBJTIzJTIwRm9yJTIwbW9yZSUyMGluZm9ybWF0aW9uJTIwb24lMjBhY2Nlc3MlMjB0b2tlbnMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwdGhpcyUyMHNlY3Rpb24lMEElMjMlMjBvZiUyMHRoZSUyMGRvY3VtZW50YXRpb24lNUQoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZzZWN1cml0eS10b2tlbnMpJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQSUwQSUyMyUyMFVzZSUyMGElMjBkaWZmZXJlbnQlMjBzY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTE1TRGlzY3JldGVTY2hlZHVsZXIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMHNjaGVkdWxlcg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;CompVis/ldm-text2im-large-256&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline that requires an authorization token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For more information on access tokens, please refer to this section</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># of the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = LMSDiscreteScheduler.from_config(pipeline.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = scheduler`,wrap:!1}}),{c(){o=a("p"),o.textContent=w,d=i(),m(f.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=w),d=s(n),h(f.$$.fragment,n)},m(n,M){u(n,o,M),u(n,d,M),g(f,n,M),$=!0},p:G,i(n){$||(b(f.$$.fragment,n),$=!0)},o(n){_(f.$$.fragment,n),$=!1},d(n){n&&(l(o),l(d)),v(f,n)}}}function Ds(P){let o,w="Examples:",d,f,$;return f=new ht({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMHlvdXIlMjBuYW1lc3BhY2UlMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC11bmV0JTIyLiUwQXVuZXQucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLXVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtdW5ldCUyMi4lMEF1bmV0LnB1c2hfdG9faHViKCUyMnlvdXItb3JnJTJGbXktZmluZXR1bmVkLXVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to your namespace with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;my-finetuned-unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to an organization with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;your-org/my-finetuned-unet&quot;</span>)`,wrap:!1}}),{c(){o=a("p"),o.textContent=w,d=i(),m(f.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=w),d=s(n),h(f.$$.fragment,n)},m(n,M){u(n,o,M),u(n,d,M),g(f,n,M),$=!0},p:G,i(n){$||(b(f.$$.fragment,n),$=!0)},o(n){_(f.$$.fragment,n),$=!1},d(n){n&&(l(o),l(d)),v(f,n)}}}function Us(P){let o,w,d,f,$,n,M,D="Pipelines provide a simple way to run state-of-the-art diffusion models in inference by bundling all of the necessary components (multiple independently-trained models, schedulers, and processors) into a single end-to-end class. Pipelines are flexible and they can be adapted to use different schedulers or even model components.",A,ke,gi='All pipelines are built from the base <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class which provides basic functionality for loading, downloading, and saving all the components. Specific pipeline types (for example <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>) loaded with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> are automatically detected and the pipeline components are loaded and passed to the <code>__init__</code> function of the pipeline.',xn,oe,$n,Pe,bi="The table below lists all the pipelines currently available in 🤗 Diffusers and the tasks they support. Click on a pipeline to view its abstract and published paper.",wn,De,_i='<thead><tr><th>Pipeline</th> <th>Tasks</th></tr></thead> <tbody><tr><td><a href="amused">aMUSEd</a></td> <td>text2image</td></tr> <tr><td><a href="animatediff">AnimateDiff</a></td> <td>text2video</td></tr> <tr><td><a href="attend_and_excite">Attend-and-Excite</a></td> <td>text2image</td></tr> <tr><td><a href="audioldm">AudioLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="audioldm2">AudioLDM2</a></td> <td>text2audio</td></tr> <tr><td><a href="auraflow">AuraFlow</a></td> <td>text2image</td></tr> <tr><td><a href="blip_diffusion">BLIP Diffusion</a></td> <td>text2image</td></tr> <tr><td><a href="bria_3_2">Bria 3.2</a></td> <td>text2image</td></tr> <tr><td><a href="cogvideox">CogVideoX</a></td> <td>text2video</td></tr> <tr><td><a href="consistency_models">Consistency Models</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="controlnet">ControlNet</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="controlnet_flux">ControlNet with Flux.1</a></td> <td>text2image</td></tr> <tr><td><a href="controlnet_hunyuandit">ControlNet with Hunyuan-DiT</a></td> <td>text2image</td></tr> <tr><td><a href="controlnet_sd3">ControlNet with Stable Diffusion 3</a></td> <td>text2image</td></tr> <tr><td><a href="controlnet_sdxl">ControlNet with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs">ControlNet-XS</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs_sdxl">ControlNet-XS with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="dance_diffusion">Dance Diffusion</a></td> <td>unconditional audio generation</td></tr> <tr><td><a href="ddim">DDIM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="ddpm">DDPM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="deepfloyd_if">DeepFloyd IF</a></td> <td>text2image, image2image, inpainting, super-resolution</td></tr> <tr><td><a href="diffedit">DiffEdit</a></td> <td>inpainting</td></tr> <tr><td><a href="dit">DiT</a></td> <td>text2image</td></tr> <tr><td><a href="flux">Flux</a></td> <td>text2image</td></tr> <tr><td><a href="hunyuandit">Hunyuan-DiT</a></td> <td>text2image</td></tr> <tr><td><a href="i2vgenxl">I2VGen-XL</a></td> <td>image2video</td></tr> <tr><td><a href="pix2pix">InstructPix2Pix</a></td> <td>image editing</td></tr> <tr><td><a href="kandinsky">Kandinsky 2.1</a></td> <td>text2image, image2image, inpainting, interpolation</td></tr> <tr><td><a href="kandinsky_v22">Kandinsky 2.2</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="kandinsky3">Kandinsky 3</a></td> <td>text2image, image2image</td></tr> <tr><td><a href="kolors">Kolors</a></td> <td>text2image</td></tr> <tr><td><a href="latent_consistency_models">Latent Consistency Models</a></td> <td>text2image</td></tr> <tr><td><a href="latent_diffusion">Latent Diffusion</a></td> <td>text2image, super-resolution</td></tr> <tr><td><a href="latte">Latte</a></td> <td>text2image</td></tr> <tr><td><a href="ledits_pp">LEDITS++</a></td> <td>image editing</td></tr> <tr><td><a href="lumina">Lumina-T2X</a></td> <td>text2image</td></tr> <tr><td><a href="marigold">Marigold</a></td> <td>depth-estimation, normals-estimation, intrinsic-decomposition</td></tr> <tr><td><a href="panorama">MultiDiffusion</a></td> <td>text2image</td></tr> <tr><td><a href="musicldm">MusicLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="pag">PAG</a></td> <td>text2image</td></tr> <tr><td><a href="paint_by_example">Paint by Example</a></td> <td>inpainting</td></tr> <tr><td><a href="pia">PIA</a></td> <td>image2video</td></tr> <tr><td><a href="pixart">PixArt-α</a></td> <td>text2image</td></tr> <tr><td><a href="pixart_sigma">PixArt-Σ</a></td> <td>text2image</td></tr> <tr><td><a href="self_attention_guidance">Self-Attention Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="semantic_stable_diffusion">Semantic Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="shap_e">Shap-E</a></td> <td>text-to-3D, image-to-3D</td></tr> <tr><td><a href="stable_audio">Stable Audio</a></td> <td>text2audio</td></tr> <tr><td><a href="stable_cascade">Stable Cascade</a></td> <td>text2image</td></tr> <tr><td><a href="stable_diffusion/overview">Stable Diffusion</a></td> <td>text2image, image2image, depth2image, inpainting, image variation, latent upscaler, super-resolution</td></tr> <tr><td><a href="stable_diffusion/stable_diffusion_xl">Stable Diffusion XL</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_diffusion/sdxl_turbo">Stable Diffusion XL Turbo</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_unclip">Stable unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="stable_diffusion/adapter">T2I-Adapter</a></td> <td>text2image</td></tr> <tr><td><a href="text_to_video">Text2Video</a></td> <td>text2video, video2video</td></tr> <tr><td><a href="text_to_video_zero">Text2Video-Zero</a></td> <td>text2video</td></tr> <tr><td><a href="unclip">unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="unidiffuser">UniDiffuser</a></td> <td>text2image, image2text, image variation, text variation, unconditional image generation, unconditional audio generation</td></tr> <tr><td><a href="value_guided_sampling">Value-guided planning</a></td> <td>value guided sampling</td></tr> <tr><td><a href="wuerstchen">Wuerstchen</a></td> <td>text2image</td></tr> <tr><td><a href="visualcloze">VisualCloze</a></td> <td>text2image, image2image, subject driven generation, inpainting, style transfer, image restoration, image editing, [depth,normal,edge,pose]2image, [depth,normal,edge,pose]-estimation, virtual try-on, image relighting</td></tr></tbody>',Mn,Ue,Tn,y,Ze,En,gt,vi="Base class for all pipelines.",zn,bt,yi=`<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,Yn,_t,xi="<li>move all PyTorch modules to the device of your choice</li> <li>enable/disable the progress bar for the denoising iteration</li>",qn,vt,$i="Class attributes:",An,yt,wi=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li> <li><strong>_optional_components</strong> (<code>List[str]</code>) — List of all optional components that don’t have to be passed to the
pipeline to function (should be overridden by subclasses).</li>`,Qn,ie,je,On,xt,Mi="Call self as a function.",Kn,$t,Ie,eo,Z,Ge,to,wt,Ti=`Performs Pipeline dtype and/or device conversion. A torch.dtype and torch.device are inferred from the
arguments of <code>self.to(*args, **kwargs).</code>`,no,se,oo,Mt,Ci="Here are the ways to call <code>to</code>:",io,Tt,ki=`<li><code>to(dtype, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li> <li><code>to(device, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a></li> <li><code>to(device=None, dtype=None, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the
specified <a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a> and
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li>`,so,H,He,ao,Ct,Pi=`The <code>self.components</code> property can be useful to run different pipelines with the same weights and
configurations without reallocating additional memory.`,ro,kt,Di=`Returns (<code>dict</code>):
A dictionary containing all the modules needed to initialize the pipeline.`,lo,ae,fo,re,Je,co,Pt,Ui=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,po,le,Le,uo,Dt,Zi='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',mo,Q,We,ho,Ut,ji="Download and cache a PyTorch diffusion pipeline from pretrained pipeline weights.",go,de,bo,J,Se,_o,Zt,Ii=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,vo,fe,yo,ce,xo,pe,Ne,$o,jt,Gi=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the accelerator when its
<code>forward</code> method is called, and the model remains in accelerator until the next model runs. Memory savings are
lower than with <code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution
of the <code>unet</code>.`,wo,ue,Ve,Mo,It,Hi=`Offloads all models to CPU using 🤗 Accelerate, significantly reducing memory usage. When called, the state
dicts of all <code>torch.nn.Module</code> components (except those in <code>self._exclude_from_cpu_offload</code>) are saved to CPU
and then moved to <code>torch.device(&#39;meta&#39;)</code> and loaded to accelerator only when their specific submodule has its
<code>forward</code> method called. Offloading happens on a submodule basis. Memory savings are higher than with
<code>enable_model_cpu_offload</code>, but performance is lower.`,To,L,Fe,Co,Gt,Ji=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,ko,me,Po,he,Do,O,Xe,Uo,Ht,Li=`Create a new pipeline from a given pipeline. This method is useful to create a new pipeline from the existing
pipeline components without reallocating additional memory.`,Zo,ge,jo,U,Be,Io,Jt,Wi="Instantiate a PyTorch diffusion pipeline from pretrained pipeline weights.",Go,Lt,Si="The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.",Ho,be,Jo,_e,Lo,ve,Wo,W,Re,So,Wt,Ni="Method that performs the following:",No,St,Vi=`<li>Offloads all components.</li> <li>Removes all model hooks that were added when using <code>enable_model_cpu_offload</code>, and then applies them again.
In case the model has not been offloaded, this function is a no-op.</li> <li>Resets stateful diffusers hooks of denoiser components if they were added with
<code>register_hook()</code>.</li>`,Vo,Nt,Fi=`Make sure to add this function to the end of the <code>__call__</code> function of your pipeline so that it functions
correctly when applying <code>enable_model_cpu_offload</code>.`,Fo,ye,Ee,Xo,Vt,Xi="Convert a NumPy image or a batch of images to a PIL image.",Bo,xe,ze,Ro,Ft,Bi="Removes all hooks that were added when using <code>enable_sequential_cpu_offload</code> or <code>enable_model_cpu_offload</code>.",Eo,$e,Ye,zo,Xt,Ri="Resets the device maps (if any) to None.",Yo,we,qe,qo,Bt,Ei=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,Cn,j,Ae,Ao,Rt,zi='Enables the FreeU mechanism as in <a href="https://huggingface.co/papers/2309.11497" rel="nofollow">https://huggingface.co/papers/2309.11497</a>.',Qo,Et,Yi="The suffixes after the scaling factors represent the stages where they are being applied.",Oo,zt,qi=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,kn,ee,Qe,Ko,Yt,Ai="Disables the FreeU mechanism if enabled.",Pn,Oe,Dn,N,Ke,ei,qt,Qi="A Mixin to push a model, scheduler, or pipeline to the Hugging Face Hub.",ti,K,et,ni,At,Oi="Upload model, scheduler, or pipeline files to the 🤗 Hugging Face Hub.",oi,Me,Un,tt,Zn,V,nt,ii,Qt,Ki=`Base class for all the official callbacks used in a pipeline. This class provides a structure for implementing
custom callbacks and ensures that all callbacks have a consistent interface.`,si,Ot,es=`Please implement the following:
<code>tensor_inputs</code>: This should return a list of tensor inputs specific to your callback. You will only be able to
include
variables listed in the <code>._callback_tensor_inputs</code> attribute of your pipeline class.
<code>callback_fn</code>: This method defines the core functionality of your callback.`,jn,F,ot,ai,Kt,ts=`Callback function for Stable Diffusion Pipelines. After certain number of steps (set by <code>cutoff_step_ratio</code> or
<code>cutoff_step_index</code>), this callback will disable the CFG.`,ri,en,ns="Note: This callback mutates the pipeline by changing the <code>_guidance_scale</code> attribute to 0.0 after the cutoff step.",In,X,it,li,tn,os=`Callback function for the base Stable Diffusion XL Pipelines. After certain number of steps (set by
<code>cutoff_step_ratio</code> or <code>cutoff_step_index</code>), this callback will disable the CFG.`,di,nn,is="Note: This callback mutates the pipeline by changing the <code>_guidance_scale</code> attribute to 0.0 after the cutoff step.",Gn,B,st,fi,on,ss=`Callback function for the Controlnet Stable Diffusion XL Pipelines. After certain number of steps (set by
<code>cutoff_step_ratio</code> or <code>cutoff_step_index</code>), this callback will disable the CFG.`,ci,sn,as="Note: This callback mutates the pipeline by changing the <code>_guidance_scale</code> attribute to 0.0 after the cutoff step.",Hn,R,at,pi,an,rs=`Callback function for any pipeline that inherits <code>IPAdapterMixin</code>. After certain number of steps (set by
<code>cutoff_step_ratio</code> or <code>cutoff_step_index</code>), this callback will set the IP Adapter scale to <code>0.0</code>.`,ui,rn,ls="Note: This callback mutates the IP Adapter attention processors by setting the scale to 0.0 after the cutoff step.",Jn,E,rt,mi,ln,ds=`Callback function for Stable Diffusion 3 Pipelines. After certain number of steps (set by <code>cutoff_step_ratio</code> or
<code>cutoff_step_index</code>), this callback will disable the CFG.`,hi,dn,fs="Note: This callback mutates the pipeline by changing the <code>_guidance_scale</code> attribute to 0.0 after the cutoff step.",Ln,lt,Wn,vn,Sn;return $=new Rn({props:{title:"Pipelines",local:"pipelines",headingTag:"h1"}}),oe=new _n({props:{warning:!0,$$slots:{default:[bs]},$$scope:{ctx:P}}}),Ue=new Rn({props:{title:"DiffusionPipeline",local:"diffusers.DiffusionPipeline",headingTag:"h2"}}),Ze=new k({props:{name:"class diffusers.DiffusionPipeline",anchor:"diffusers.DiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L180"}}),je=new k({props:{name:"__call__",anchor:"diffusers.DiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Ie=new k({props:{name:"device",anchor:"diffusers.DiffusionPipeline.device",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L558",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The torch device on which the pipeline is located.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.device</code></p>
`}}),Ge=new k({props:{name:"to",anchor:"diffusers.DiffusionPipeline.to",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.to.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a>`,name:"dtype"},{anchor:"diffusers.DiffusionPipeline.to.device",description:`<strong>device</strong> (<code>torch.Device</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a>`,name:"device"},{anchor:"diffusers.DiffusionPipeline.to.silence_dtype_warnings",description:`<strong>silence_dtype_warnings</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to omit warnings if the target <code>dtype</code> is not compatible with the target <code>device</code>.`,name:"silence_dtype_warnings"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L369",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The pipeline converted to specified <code>dtype</code> and/or <code>dtype</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline"
>DiffusionPipeline</a></p>
`}}),se=new _n({props:{$$slots:{default:[_s]},$$scope:{ctx:P}}}),He=new k({props:{name:"components",anchor:"diffusers.DiffusionPipeline.components",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1742"}}),ae=new mt({props:{anchor:"diffusers.DiffusionPipeline.components.example",$$slots:{default:[vs]},$$scope:{ctx:P}}}),Je=new k({props:{name:"disable_attention_slicing",anchor:"diffusers.DiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1907"}}),Le=new k({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1841"}}),We=new k({props:{name:"download",anchor:"diffusers.DiffusionPipeline.download",parameters:[{name:"pretrained_model_name",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.download.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.`,name:"pretrained_model_name"},{anchor:"diffusers.DiffusionPipeline.download.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>
<p>A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained
pipeline hosted on the Hub. The repository must contain a file called <code>pipeline.py</code> that defines
the custom pipeline.</p>
</li>
<li>
<p>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current <code>main</code> branch of GitHub.</p>
</li>
<li>
<p>A path to a <em>directory</em> (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</p>
</li>
</ul>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>For more information on how to load and create custom pipelines, take a look at <a href="https://huggingface.co/docs/diffusers/main/en/using-diffusers/contribute_pipeline" rel="nofollow">How to contribute a
community pipeline</a>.`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.download.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.download.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.download.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.download.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. It can be a &#x1F917; Diffusers version when loading a
custom pipeline from GitHub, otherwise it defaults to <code>&quot;main&quot;</code> when loading from the Hub.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.download.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.download.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.download.dduf_file(str,",description:`<strong>dduf_file(<code>str</code>,</strong> <em>optional</em>) &#x2014;
Load weights from the specified DDUF file.`,name:"dduf_file(str,"},{anchor:"diffusers.DiffusionPipeline.download.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.download.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.download.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom pipelines and components defined on the Hub in their own files. This
option should only be set to <code>True</code> for repositories you trust and in which you have read the code, as
it will execute code present on the Hub on your local machine.`,name:"trust_remote_code"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1350",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A path to the downloaded pipeline.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>os.PathLike</code></p>
`}}),de=new _n({props:{$$slots:{default:[ys]},$$scope:{ctx:P}}}),Se=new k({props:{name:"enable_attention_slicing",anchor:"diffusers.DiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[int, str, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1867"}}),fe=new _n({props:{warning:!0,$$slots:{default:[xs]},$$scope:{ctx:P}}}),ce=new mt({props:{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[$s]},$$scope:{ctx:P}}}),Ne=new k({props:{name:"enable_model_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to None) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
automatically detect the available accelerator and use.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1154"}}),Ve=new k({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to None) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
automatically detect the available accelerator and use.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1270"}}),Fe=new k({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1806"}}),me=new _n({props:{warning:!0,$$slots:{default:[ws]},$$scope:{ctx:P}}}),he=new mt({props:{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Ms]},$$scope:{ctx:P}}}),Xe=new k({props:{name:"from_pipe",anchor:"diffusers.DiffusionPipeline.from_pipe",parameters:[{name:"pipeline",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pipe.pipeline",description:`<strong>pipeline</strong> (<code>DiffusionPipeline</code>) &#x2014;
The pipeline from which to create a new pipeline.`,name:"pipeline"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1923",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A new pipeline with the same weights and configurations as <code>pipeline</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>DiffusionPipeline</code></p>
`}}),ge=new mt({props:{anchor:"diffusers.DiffusionPipeline.from_pipe.example",$$slots:{default:[Ts]},$$scope:{ctx:P}}}),Be=new k({props:{name:"from_pretrained",anchor:"diffusers.DiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike, NoneType]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing pipeline weights
saved using
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing a dduf file</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.torch_dtype",description:`<strong>torch_dtype</strong> (<code>torch.dtype</code> or <code>dict[str, Union[str, torch.dtype]]</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. To load submodels with
different dtype pass a <code>dict</code> (for example <code>{&apos;transformer&apos;: torch.bfloat16, &apos;vae&apos;: torch.float16}</code>).
Set the default dtype for unspecified components with <code>default</code> (for example <code>{&apos;transformer&apos;: torch.bfloat16, &apos;default&apos;: torch.float16}</code>). If a component is not specified and no default is set,
<code>torch.float32</code> is used.`,name:"torch_dtype"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>hf-internal-testing/diffusers-dummy-pipeline</code>) of a custom
pipeline hosted on the Hub. The repository must contain a file called pipeline.py that defines
the custom pipeline.</li>
<li>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current main branch of GitHub.</li>
<li>A path to a directory (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</li>
</ul>
<p>For more information on how to load and create custom pipelines, please have a look at <a href="https://huggingface.co/docs/diffusers/using-diffusers/custom_pipeline_overview" rel="nofollow">Loading and
Adding Custom
Pipelines</a>`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. Defaults to the latest stable &#x1F917; Diffusers
version.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.device_map",description:`<strong>device_map</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Strategy that dictates how the different components of a pipeline should be placed on available
devices. Currently, only &#x201C;balanced&#x201D; <code>device_map</code> is supported. Check out
<a href="https://huggingface.co/docs/diffusers/main/en/tutorials/inference_with_big_models#device-placement" rel="nofollow">this</a>
to know more.`,name:"device_map"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier for the maximum memory. Will default to the maximum memory available for
each GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
The path to offload weights if device_map contains the value <code>&quot;disk&quot;</code>.`,name:"offload_folder"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, temporarily offloads the CPU state dict to the hard drive to avoid running out of CPU RAM if
the weight of the CPU state dict + the biggest shard of the checkpoint does not fit. Defaults to <code>True</code>
when there is some disk offload.`,name:"offload_state_dict"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components of the specific pipeline
class). The overwritten components are passed directly to the pipelines <code>__init__</code> method. See example
below for more information.`,name:"kwargs"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.dduf_file(str,",description:`<strong>dduf_file(<code>str</code>,</strong> <em>optional</em>) &#x2014;
Load weights from the specified dduf file.`,name:"dduf_file(str,"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L588"}}),be=new mt({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example",$$slots:{default:[Cs]},$$scope:{ctx:P}}}),_e=new _n({props:{$$slots:{default:[ks]},$$scope:{ctx:P}}}),ve=new mt({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example-2",$$slots:{default:[Ps]},$$scope:{ctx:P}}}),Re=new k({props:{name:"maybe_free_model_hooks",anchor:"diffusers.DiffusionPipeline.maybe_free_model_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1247"}}),Ee=new k({props:{name:"numpy_to_pil",anchor:"diffusers.DiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1780"}}),ze=new k({props:{name:"remove_all_hooks",anchor:"diffusers.DiffusionPipeline.remove_all_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1145"}}),Ye=new k({props:{name:"reset_device_map",anchor:"diffusers.DiffusionPipeline.reset_device_map",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1337"}}),qe=new k({props:{name:"save_pretrained",anchor:"diffusers.DiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"},{name:"max_shard_size",val:": typing.Union[int, str, NoneType] = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a pipeline to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, defaults to <code>None</code>) &#x2014;
The maximum size for a checkpoint before being sharded. Checkpoints shard will then be each of size
lower than this size. If expressed as a string, needs to be digits followed by a unit (like <code>&quot;5GB&quot;</code>).
If expressed as an integer, the unit is bytes. Note that this limit will be decreased after a certain
period of time (starting from Oct 2024) to allow users to upgrade to the latest version of <code>diffusers</code>.
This is to establish a common default size for this argument across different libraries in the Hugging
Face ecosystem (<code>transformers</code>, and <code>accelerate</code>, for example).`,name:"max_shard_size"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L236"}}),Ae=new k({props:{name:"diffusers.StableDiffusionMixin.enable_freeu",anchor:"diffusers.StableDiffusionMixin.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionMixin.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2101"}}),Qe=new k({props:{name:"diffusers.StableDiffusionMixin.disable_freeu",anchor:"diffusers.StableDiffusionMixin.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2123"}}),Oe=new Rn({props:{title:"PushToHubMixin",local:"diffusers.utils.PushToHubMixin",headingTag:"h2"}}),Ke=new k({props:{name:"class diffusers.utils.PushToHubMixin",anchor:"diffusers.utils.PushToHubMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L464"}}),et=new k({props:{name:"push_to_hub",anchor:"diffusers.utils.PushToHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"},{name:"subfolder",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your model, scheduler, or pipeline files to. It should
contain your organization name when pushing to an organization. <code>repo_id</code> can also be a path to a local
directory.`,name:"repo_id"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Default to <code>&quot;Upload {object}&quot;</code>.`,name:"commit_message"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to make the repo private. If <code>None</code> (default), the repo will be public unless the
organization&#x2019;s default is private. This value is ignored if the repo already exists.`,name:"private"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. The token generated when running <code>hf auth login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights to the <code>safetensors</code> format.`,name:"safe_serialization"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L499"}}),Me=new mt({props:{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.example",$$slots:{default:[Ds]},$$scope:{ctx:P}}}),tt=new Rn({props:{title:"Callbacks",local:"diffusers.callbacks.PipelineCallback",headingTag:"h2"}}),nt=new k({props:{name:"class diffusers.callbacks.PipelineCallback",anchor:"diffusers.callbacks.PipelineCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L7"}}),ot=new k({props:{name:"class diffusers.callbacks.SDCFGCutoffCallback",anchor:"diffusers.callbacks.SDCFGCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L69"}}),it=new k({props:{name:"class diffusers.callbacks.SDXLCFGCutoffCallback",anchor:"diffusers.callbacks.SDXLCFGCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L98"}}),st=new k({props:{name:"class diffusers.callbacks.SDXLControlnetCFGCutoffCallback",anchor:"diffusers.callbacks.SDXLControlnetCFGCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L140"}}),at=new k({props:{name:"class diffusers.callbacks.IPAdapterScaleCutoffCallback",anchor:"diffusers.callbacks.IPAdapterScaleCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L188"}}),rt=new k({props:{name:"class diffusers.callbacks.SD3CFGCutoffCallback",anchor:"diffusers.callbacks.SD3CFGCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L212"}}),lt=new gs({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/overview.md"}}),{c(){o=a("meta"),w=i(),d=a("p"),f=i(),m($.$$.fragment),n=i(),M=a("p"),M.textContent=D,A=i(),ke=a("p"),ke.innerHTML=gi,xn=i(),m(oe.$$.fragment),$n=i(),Pe=a("p"),Pe.textContent=bi,wn=i(),De=a("table"),De.innerHTML=_i,Mn=i(),m(Ue.$$.fragment),Tn=i(),y=a("div"),m(Ze.$$.fragment),En=i(),gt=a("p"),gt.textContent=vi,zn=i(),bt=a("p"),bt.innerHTML=yi,Yn=i(),_t=a("ul"),_t.innerHTML=xi,qn=i(),vt=a("p"),vt.textContent=$i,An=i(),yt=a("ul"),yt.innerHTML=wi,Qn=i(),ie=a("div"),m(je.$$.fragment),On=i(),xt=a("p"),xt.textContent=Mi,Kn=i(),$t=a("div"),m(Ie.$$.fragment),eo=i(),Z=a("div"),m(Ge.$$.fragment),to=i(),wt=a("p"),wt.innerHTML=Ti,no=i(),m(se.$$.fragment),oo=i(),Mt=a("p"),Mt.innerHTML=Ci,io=i(),Tt=a("ul"),Tt.innerHTML=ki,so=i(),H=a("div"),m(He.$$.fragment),ao=i(),Ct=a("p"),Ct.innerHTML=Pi,ro=i(),kt=a("p"),kt.innerHTML=Di,lo=i(),m(ae.$$.fragment),fo=i(),re=a("div"),m(Je.$$.fragment),co=i(),Pt=a("p"),Pt.innerHTML=Ui,po=i(),le=a("div"),m(Le.$$.fragment),uo=i(),Dt=a("p"),Dt.innerHTML=Zi,mo=i(),Q=a("div"),m(We.$$.fragment),ho=i(),Ut=a("p"),Ut.textContent=ji,go=i(),m(de.$$.fragment),bo=i(),J=a("div"),m(Se.$$.fragment),_o=i(),Zt=a("p"),Zt.textContent=Ii,vo=i(),m(fe.$$.fragment),yo=i(),m(ce.$$.fragment),xo=i(),pe=a("div"),m(Ne.$$.fragment),$o=i(),jt=a("p"),jt.innerHTML=Gi,wo=i(),ue=a("div"),m(Ve.$$.fragment),Mo=i(),It=a("p"),It.innerHTML=Hi,To=i(),L=a("div"),m(Fe.$$.fragment),Co=i(),Gt=a("p"),Gt.innerHTML=Ji,ko=i(),m(me.$$.fragment),Po=i(),m(he.$$.fragment),Do=i(),O=a("div"),m(Xe.$$.fragment),Uo=i(),Ht=a("p"),Ht.textContent=Li,Zo=i(),m(ge.$$.fragment),jo=i(),U=a("div"),m(Be.$$.fragment),Io=i(),Jt=a("p"),Jt.textContent=Wi,Go=i(),Lt=a("p"),Lt.innerHTML=Si,Ho=i(),m(be.$$.fragment),Jo=i(),m(_e.$$.fragment),Lo=i(),m(ve.$$.fragment),Wo=i(),W=a("div"),m(Re.$$.fragment),So=i(),Wt=a("p"),Wt.textContent=Ni,No=i(),St=a("ul"),St.innerHTML=Vi,Vo=i(),Nt=a("p"),Nt.innerHTML=Fi,Fo=i(),ye=a("div"),m(Ee.$$.fragment),Xo=i(),Vt=a("p"),Vt.textContent=Xi,Bo=i(),xe=a("div"),m(ze.$$.fragment),Ro=i(),Ft=a("p"),Ft.innerHTML=Bi,Eo=i(),$e=a("div"),m(Ye.$$.fragment),zo=i(),Xt=a("p"),Xt.textContent=Ri,Yo=i(),we=a("div"),m(qe.$$.fragment),qo=i(),Bt=a("p"),Bt.innerHTML=Ei,Cn=i(),j=a("div"),m(Ae.$$.fragment),Ao=i(),Rt=a("p"),Rt.innerHTML=zi,Qo=i(),Et=a("p"),Et.textContent=Yi,Oo=i(),zt=a("p"),zt.innerHTML=qi,kn=i(),ee=a("div"),m(Qe.$$.fragment),Ko=i(),Yt=a("p"),Yt.textContent=Ai,Pn=i(),m(Oe.$$.fragment),Dn=i(),N=a("div"),m(Ke.$$.fragment),ei=i(),qt=a("p"),qt.textContent=Qi,ti=i(),K=a("div"),m(et.$$.fragment),ni=i(),At=a("p"),At.textContent=Oi,oi=i(),m(Me.$$.fragment),Un=i(),m(tt.$$.fragment),Zn=i(),V=a("div"),m(nt.$$.fragment),ii=i(),Qt=a("p"),Qt.textContent=Ki,si=i(),Ot=a("p"),Ot.innerHTML=es,jn=i(),F=a("div"),m(ot.$$.fragment),ai=i(),Kt=a("p"),Kt.innerHTML=ts,ri=i(),en=a("p"),en.innerHTML=ns,In=i(),X=a("div"),m(it.$$.fragment),li=i(),tn=a("p"),tn.innerHTML=os,di=i(),nn=a("p"),nn.innerHTML=is,Gn=i(),B=a("div"),m(st.$$.fragment),fi=i(),on=a("p"),on.innerHTML=ss,ci=i(),sn=a("p"),sn.innerHTML=as,Hn=i(),R=a("div"),m(at.$$.fragment),pi=i(),an=a("p"),an.innerHTML=rs,ui=i(),rn=a("p"),rn.textContent=ls,Jn=i(),E=a("div"),m(rt.$$.fragment),mi=i(),ln=a("p"),ln.innerHTML=ds,hi=i(),dn=a("p"),dn.innerHTML=fs,Ln=i(),m(lt.$$.fragment),Wn=i(),vn=a("p"),this.h()},l(e){const c=hs("svelte-u9bgzb",document.head);o=r(c,"META",{name:!0,content:!0}),c.forEach(l),w=s(e),d=r(e,"P",{}),T(d).forEach(l),f=s(e),h($.$$.fragment,e),n=s(e),M=r(e,"P",{"data-svelte-h":!0}),p(M)!=="svelte-eejdx6"&&(M.textContent=D),A=s(e),ke=r(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1d3b6kb"&&(ke.innerHTML=gi),xn=s(e),h(oe.$$.fragment,e),$n=s(e),Pe=r(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-2xd39c"&&(Pe.textContent=bi),wn=s(e),De=r(e,"TABLE",{"data-svelte-h":!0}),p(De)!=="svelte-16ga3pv"&&(De.innerHTML=_i),Mn=s(e),h(Ue.$$.fragment,e),Tn=s(e),y=r(e,"DIV",{class:!0});var x=T(y);h(Ze.$$.fragment,x),En=s(x),gt=r(x,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-1neg3rw"&&(gt.textContent=vi),zn=s(x),bt=r(x,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-1kbb8l4"&&(bt.innerHTML=yi),Yn=s(x),_t=r(x,"UL",{"data-svelte-h":!0}),p(_t)!=="svelte-2a5chx"&&(_t.innerHTML=xi),qn=s(x),vt=r(x,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-wz8va1"&&(vt.textContent=$i),An=s(x),yt=r(x,"UL",{"data-svelte-h":!0}),p(yt)!=="svelte-1ilr6sx"&&(yt.innerHTML=wi),Qn=s(x),ie=r(x,"DIV",{class:!0});var dt=T(ie);h(je.$$.fragment,dt),On=s(dt),xt=r(dt,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-1eed40t"&&(xt.textContent=Mi),dt.forEach(l),Kn=s(x),$t=r(x,"DIV",{class:!0});var yn=T($t);h(Ie.$$.fragment,yn),yn.forEach(l),eo=s(x),Z=r(x,"DIV",{class:!0});var I=T(Z);h(Ge.$$.fragment,I),to=s(I),wt=r(I,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-1vbhnip"&&(wt.innerHTML=Ti),no=s(I),h(se.$$.fragment,I),oo=s(I),Mt=r(I,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-5ul9n2"&&(Mt.innerHTML=Ci),io=s(I),Tt=r(I,"UL",{"data-svelte-h":!0}),p(Tt)!=="svelte-1icy6l9"&&(Tt.innerHTML=ki),I.forEach(l),so=s(x),H=r(x,"DIV",{class:!0});var z=T(H);h(He.$$.fragment,z),ao=s(z),Ct=r(z,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-had4mb"&&(Ct.innerHTML=Pi),ro=s(z),kt=r(z,"P",{"data-svelte-h":!0}),p(kt)!=="svelte-19k67ce"&&(kt.innerHTML=Di),lo=s(z),h(ae.$$.fragment,z),z.forEach(l),fo=s(x),re=r(x,"DIV",{class:!0});var ft=T(re);h(Je.$$.fragment,ft),co=s(ft),Pt=r(ft,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-1lh0nh5"&&(Pt.innerHTML=Ui),ft.forEach(l),po=s(x),le=r(x,"DIV",{class:!0});var ct=T(le);h(Le.$$.fragment,ct),uo=s(ct),Dt=r(ct,"P",{"data-svelte-h":!0}),p(Dt)!=="svelte-1vfte1e"&&(Dt.innerHTML=Zi),ct.forEach(l),mo=s(x),Q=r(x,"DIV",{class:!0});var te=T(Q);h(We.$$.fragment,te),ho=s(te),Ut=r(te,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-1mfctah"&&(Ut.textContent=ji),go=s(te),h(de.$$.fragment,te),te.forEach(l),bo=s(x),J=r(x,"DIV",{class:!0});var Y=T(J);h(Se.$$.fragment,Y),_o=s(Y),Zt=r(Y,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-10jaql7"&&(Zt.textContent=Ii),vo=s(Y),h(fe.$$.fragment,Y),yo=s(Y),h(ce.$$.fragment,Y),Y.forEach(l),xo=s(x),pe=r(x,"DIV",{class:!0});var pt=T(pe);h(Ne.$$.fragment,pt),$o=s(pt),jt=r(pt,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-9hgqai"&&(jt.innerHTML=Gi),pt.forEach(l),wo=s(x),ue=r(x,"DIV",{class:!0});var ut=T(ue);h(Ve.$$.fragment,ut),Mo=s(ut),It=r(ut,"P",{"data-svelte-h":!0}),p(It)!=="svelte-1bs0ixe"&&(It.innerHTML=Hi),ut.forEach(l),To=s(x),L=r(x,"DIV",{class:!0});var q=T(L);h(Fe.$$.fragment,q),Co=s(q),Gt=r(q,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-e03q3e"&&(Gt.innerHTML=Ji),ko=s(q),h(me.$$.fragment,q),Po=s(q),h(he.$$.fragment,q),q.forEach(l),Do=s(x),O=r(x,"DIV",{class:!0});var ne=T(O);h(Xe.$$.fragment,ne),Uo=s(ne),Ht=r(ne,"P",{"data-svelte-h":!0}),p(Ht)!=="svelte-1jx3icn"&&(Ht.textContent=Li),Zo=s(ne),h(ge.$$.fragment,ne),ne.forEach(l),jo=s(x),U=r(x,"DIV",{class:!0});var S=T(U);h(Be.$$.fragment,S),Io=s(S),Jt=r(S,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-ccbjek"&&(Jt.textContent=Wi),Go=s(S),Lt=r(S,"P",{"data-svelte-h":!0}),p(Lt)!=="svelte-1p5vgmd"&&(Lt.innerHTML=Si),Ho=s(S),h(be.$$.fragment,S),Jo=s(S),h(_e.$$.fragment,S),Lo=s(S),h(ve.$$.fragment,S),S.forEach(l),Wo=s(x),W=r(x,"DIV",{class:!0});var Te=T(W);h(Re.$$.fragment,Te),So=s(Te),Wt=r(Te,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-z79kjq"&&(Wt.textContent=Ni),No=s(Te),St=r(Te,"UL",{"data-svelte-h":!0}),p(St)!=="svelte-1ju7puc"&&(St.innerHTML=Vi),Vo=s(Te),Nt=r(Te,"P",{"data-svelte-h":!0}),p(Nt)!=="svelte-1pqppti"&&(Nt.innerHTML=Fi),Te.forEach(l),Fo=s(x),ye=r(x,"DIV",{class:!0});var Nn=T(ye);h(Ee.$$.fragment,Nn),Xo=s(Nn),Vt=r(Nn,"P",{"data-svelte-h":!0}),p(Vt)!=="svelte-1gut907"&&(Vt.textContent=Xi),Nn.forEach(l),Bo=s(x),xe=r(x,"DIV",{class:!0});var Vn=T(xe);h(ze.$$.fragment,Vn),Ro=s(Vn),Ft=r(Vn,"P",{"data-svelte-h":!0}),p(Ft)!=="svelte-8kophh"&&(Ft.innerHTML=Bi),Vn.forEach(l),Eo=s(x),$e=r(x,"DIV",{class:!0});var Fn=T($e);h(Ye.$$.fragment,Fn),zo=s(Fn),Xt=r(Fn,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-6tjysh"&&(Xt.textContent=Ri),Fn.forEach(l),Yo=s(x),we=r(x,"DIV",{class:!0});var Xn=T(we);h(qe.$$.fragment,Xn),qo=s(Xn),Bt=r(Xn,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-1jcmq84"&&(Bt.innerHTML=Ei),Xn.forEach(l),x.forEach(l),Cn=s(e),j=r(e,"DIV",{class:!0});var Ce=T(j);h(Ae.$$.fragment,Ce),Ao=s(Ce),Rt=r(Ce,"P",{"data-svelte-h":!0}),p(Rt)!=="svelte-192jnkh"&&(Rt.innerHTML=zi),Qo=s(Ce),Et=r(Ce,"P",{"data-svelte-h":!0}),p(Et)!=="svelte-xjijlp"&&(Et.textContent=Yi),Oo=s(Ce),zt=r(Ce,"P",{"data-svelte-h":!0}),p(zt)!=="svelte-hy0nzs"&&(zt.innerHTML=qi),Ce.forEach(l),kn=s(e),ee=r(e,"DIV",{class:!0});var Bn=T(ee);h(Qe.$$.fragment,Bn),Ko=s(Bn),Yt=r(Bn,"P",{"data-svelte-h":!0}),p(Yt)!=="svelte-psupw6"&&(Yt.textContent=Ai),Bn.forEach(l),Pn=s(e),h(Oe.$$.fragment,e),Dn=s(e),N=r(e,"DIV",{class:!0});var fn=T(N);h(Ke.$$.fragment,fn),ei=s(fn),qt=r(fn,"P",{"data-svelte-h":!0}),p(qt)!=="svelte-7y8zei"&&(qt.textContent=Qi),ti=s(fn),K=r(fn,"DIV",{class:!0});var cn=T(K);h(et.$$.fragment,cn),ni=s(cn),At=r(cn,"P",{"data-svelte-h":!0}),p(At)!=="svelte-5nfhmh"&&(At.textContent=Oi),oi=s(cn),h(Me.$$.fragment,cn),cn.forEach(l),fn.forEach(l),Un=s(e),h(tt.$$.fragment,e),Zn=s(e),V=r(e,"DIV",{class:!0});var pn=T(V);h(nt.$$.fragment,pn),ii=s(pn),Qt=r(pn,"P",{"data-svelte-h":!0}),p(Qt)!=="svelte-2ua579"&&(Qt.textContent=Ki),si=s(pn),Ot=r(pn,"P",{"data-svelte-h":!0}),p(Ot)!=="svelte-qrped9"&&(Ot.innerHTML=es),pn.forEach(l),jn=s(e),F=r(e,"DIV",{class:!0});var un=T(F);h(ot.$$.fragment,un),ai=s(un),Kt=r(un,"P",{"data-svelte-h":!0}),p(Kt)!=="svelte-1lxhnsk"&&(Kt.innerHTML=ts),ri=s(un),en=r(un,"P",{"data-svelte-h":!0}),p(en)!=="svelte-twxvjk"&&(en.innerHTML=ns),un.forEach(l),In=s(e),X=r(e,"DIV",{class:!0});var mn=T(X);h(it.$$.fragment,mn),li=s(mn),tn=r(mn,"P",{"data-svelte-h":!0}),p(tn)!=="svelte-1pnjwf0"&&(tn.innerHTML=os),di=s(mn),nn=r(mn,"P",{"data-svelte-h":!0}),p(nn)!=="svelte-twxvjk"&&(nn.innerHTML=is),mn.forEach(l),Gn=s(e),B=r(e,"DIV",{class:!0});var hn=T(B);h(st.$$.fragment,hn),fi=s(hn),on=r(hn,"P",{"data-svelte-h":!0}),p(on)!=="svelte-wsvz4z"&&(on.innerHTML=ss),ci=s(hn),sn=r(hn,"P",{"data-svelte-h":!0}),p(sn)!=="svelte-twxvjk"&&(sn.innerHTML=as),hn.forEach(l),Hn=s(e),R=r(e,"DIV",{class:!0});var gn=T(R);h(at.$$.fragment,gn),pi=s(gn),an=r(gn,"P",{"data-svelte-h":!0}),p(an)!=="svelte-1pf8icy"&&(an.innerHTML=rs),ui=s(gn),rn=r(gn,"P",{"data-svelte-h":!0}),p(rn)!=="svelte-1kg1eq5"&&(rn.textContent=ls),gn.forEach(l),Jn=s(e),E=r(e,"DIV",{class:!0});var bn=T(E);h(rt.$$.fragment,bn),mi=s(bn),ln=r(bn,"P",{"data-svelte-h":!0}),p(ln)!=="svelte-461fyb"&&(ln.innerHTML=ds),hi=s(bn),dn=r(bn,"P",{"data-svelte-h":!0}),p(dn)!=="svelte-twxvjk"&&(dn.innerHTML=fs),bn.forEach(l),Ln=s(e),h(lt.$$.fragment,e),Wn=s(e),vn=r(e,"P",{}),T(vn).forEach(l),this.h()},h(){C(o,"name","hf:doc:metadata"),C(o,"content",Zs),C(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C($t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,o),u(e,w,c),u(e,d,c),u(e,f,c),g($,e,c),u(e,n,c),u(e,M,c),u(e,A,c),u(e,ke,c),u(e,xn,c),g(oe,e,c),u(e,$n,c),u(e,Pe,c),u(e,wn,c),u(e,De,c),u(e,Mn,c),g(Ue,e,c),u(e,Tn,c),u(e,y,c),g(Ze,y,null),t(y,En),t(y,gt),t(y,zn),t(y,bt),t(y,Yn),t(y,_t),t(y,qn),t(y,vt),t(y,An),t(y,yt),t(y,Qn),t(y,ie),g(je,ie,null),t(ie,On),t(ie,xt),t(y,Kn),t(y,$t),g(Ie,$t,null),t(y,eo),t(y,Z),g(Ge,Z,null),t(Z,to),t(Z,wt),t(Z,no),g(se,Z,null),t(Z,oo),t(Z,Mt),t(Z,io),t(Z,Tt),t(y,so),t(y,H),g(He,H,null),t(H,ao),t(H,Ct),t(H,ro),t(H,kt),t(H,lo),g(ae,H,null),t(y,fo),t(y,re),g(Je,re,null),t(re,co),t(re,Pt),t(y,po),t(y,le),g(Le,le,null),t(le,uo),t(le,Dt),t(y,mo),t(y,Q),g(We,Q,null),t(Q,ho),t(Q,Ut),t(Q,go),g(de,Q,null),t(y,bo),t(y,J),g(Se,J,null),t(J,_o),t(J,Zt),t(J,vo),g(fe,J,null),t(J,yo),g(ce,J,null),t(y,xo),t(y,pe),g(Ne,pe,null),t(pe,$o),t(pe,jt),t(y,wo),t(y,ue),g(Ve,ue,null),t(ue,Mo),t(ue,It),t(y,To),t(y,L),g(Fe,L,null),t(L,Co),t(L,Gt),t(L,ko),g(me,L,null),t(L,Po),g(he,L,null),t(y,Do),t(y,O),g(Xe,O,null),t(O,Uo),t(O,Ht),t(O,Zo),g(ge,O,null),t(y,jo),t(y,U),g(Be,U,null),t(U,Io),t(U,Jt),t(U,Go),t(U,Lt),t(U,Ho),g(be,U,null),t(U,Jo),g(_e,U,null),t(U,Lo),g(ve,U,null),t(y,Wo),t(y,W),g(Re,W,null),t(W,So),t(W,Wt),t(W,No),t(W,St),t(W,Vo),t(W,Nt),t(y,Fo),t(y,ye),g(Ee,ye,null),t(ye,Xo),t(ye,Vt),t(y,Bo),t(y,xe),g(ze,xe,null),t(xe,Ro),t(xe,Ft),t(y,Eo),t(y,$e),g(Ye,$e,null),t($e,zo),t($e,Xt),t(y,Yo),t(y,we),g(qe,we,null),t(we,qo),t(we,Bt),u(e,Cn,c),u(e,j,c),g(Ae,j,null),t(j,Ao),t(j,Rt),t(j,Qo),t(j,Et),t(j,Oo),t(j,zt),u(e,kn,c),u(e,ee,c),g(Qe,ee,null),t(ee,Ko),t(ee,Yt),u(e,Pn,c),g(Oe,e,c),u(e,Dn,c),u(e,N,c),g(Ke,N,null),t(N,ei),t(N,qt),t(N,ti),t(N,K),g(et,K,null),t(K,ni),t(K,At),t(K,oi),g(Me,K,null),u(e,Un,c),g(tt,e,c),u(e,Zn,c),u(e,V,c),g(nt,V,null),t(V,ii),t(V,Qt),t(V,si),t(V,Ot),u(e,jn,c),u(e,F,c),g(ot,F,null),t(F,ai),t(F,Kt),t(F,ri),t(F,en),u(e,In,c),u(e,X,c),g(it,X,null),t(X,li),t(X,tn),t(X,di),t(X,nn),u(e,Gn,c),u(e,B,c),g(st,B,null),t(B,fi),t(B,on),t(B,ci),t(B,sn),u(e,Hn,c),u(e,R,c),g(at,R,null),t(R,pi),t(R,an),t(R,ui),t(R,rn),u(e,Jn,c),u(e,E,c),g(rt,E,null),t(E,mi),t(E,ln),t(E,hi),t(E,dn),u(e,Ln,c),g(lt,e,c),u(e,Wn,c),u(e,vn,c),Sn=!0},p(e,[c]){const x={};c&2&&(x.$$scope={dirty:c,ctx:e}),oe.$set(x);const dt={};c&2&&(dt.$$scope={dirty:c,ctx:e}),se.$set(dt);const yn={};c&2&&(yn.$$scope={dirty:c,ctx:e}),ae.$set(yn);const I={};c&2&&(I.$$scope={dirty:c,ctx:e}),de.$set(I);const z={};c&2&&(z.$$scope={dirty:c,ctx:e}),fe.$set(z);const ft={};c&2&&(ft.$$scope={dirty:c,ctx:e}),ce.$set(ft);const ct={};c&2&&(ct.$$scope={dirty:c,ctx:e}),me.$set(ct);const te={};c&2&&(te.$$scope={dirty:c,ctx:e}),he.$set(te);const Y={};c&2&&(Y.$$scope={dirty:c,ctx:e}),ge.$set(Y);const pt={};c&2&&(pt.$$scope={dirty:c,ctx:e}),be.$set(pt);const ut={};c&2&&(ut.$$scope={dirty:c,ctx:e}),_e.$set(ut);const q={};c&2&&(q.$$scope={dirty:c,ctx:e}),ve.$set(q);const ne={};c&2&&(ne.$$scope={dirty:c,ctx:e}),Me.$set(ne)},i(e){Sn||(b($.$$.fragment,e),b(oe.$$.fragment,e),b(Ue.$$.fragment,e),b(Ze.$$.fragment,e),b(je.$$.fragment,e),b(Ie.$$.fragment,e),b(Ge.$$.fragment,e),b(se.$$.fragment,e),b(He.$$.fragment,e),b(ae.$$.fragment,e),b(Je.$$.fragment,e),b(Le.$$.fragment,e),b(We.$$.fragment,e),b(de.$$.fragment,e),b(Se.$$.fragment,e),b(fe.$$.fragment,e),b(ce.$$.fragment,e),b(Ne.$$.fragment,e),b(Ve.$$.fragment,e),b(Fe.$$.fragment,e),b(me.$$.fragment,e),b(he.$$.fragment,e),b(Xe.$$.fragment,e),b(ge.$$.fragment,e),b(Be.$$.fragment,e),b(be.$$.fragment,e),b(_e.$$.fragment,e),b(ve.$$.fragment,e),b(Re.$$.fragment,e),b(Ee.$$.fragment,e),b(ze.$$.fragment,e),b(Ye.$$.fragment,e),b(qe.$$.fragment,e),b(Ae.$$.fragment,e),b(Qe.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),b(et.$$.fragment,e),b(Me.$$.fragment,e),b(tt.$$.fragment,e),b(nt.$$.fragment,e),b(ot.$$.fragment,e),b(it.$$.fragment,e),b(st.$$.fragment,e),b(at.$$.fragment,e),b(rt.$$.fragment,e),b(lt.$$.fragment,e),Sn=!0)},o(e){_($.$$.fragment,e),_(oe.$$.fragment,e),_(Ue.$$.fragment,e),_(Ze.$$.fragment,e),_(je.$$.fragment,e),_(Ie.$$.fragment,e),_(Ge.$$.fragment,e),_(se.$$.fragment,e),_(He.$$.fragment,e),_(ae.$$.fragment,e),_(Je.$$.fragment,e),_(Le.$$.fragment,e),_(We.$$.fragment,e),_(de.$$.fragment,e),_(Se.$$.fragment,e),_(fe.$$.fragment,e),_(ce.$$.fragment,e),_(Ne.$$.fragment,e),_(Ve.$$.fragment,e),_(Fe.$$.fragment,e),_(me.$$.fragment,e),_(he.$$.fragment,e),_(Xe.$$.fragment,e),_(ge.$$.fragment,e),_(Be.$$.fragment,e),_(be.$$.fragment,e),_(_e.$$.fragment,e),_(ve.$$.fragment,e),_(Re.$$.fragment,e),_(Ee.$$.fragment,e),_(ze.$$.fragment,e),_(Ye.$$.fragment,e),_(qe.$$.fragment,e),_(Ae.$$.fragment,e),_(Qe.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(Me.$$.fragment,e),_(tt.$$.fragment,e),_(nt.$$.fragment,e),_(ot.$$.fragment,e),_(it.$$.fragment,e),_(st.$$.fragment,e),_(at.$$.fragment,e),_(rt.$$.fragment,e),_(lt.$$.fragment,e),Sn=!1},d(e){e&&(l(w),l(d),l(f),l(n),l(M),l(A),l(ke),l(xn),l($n),l(Pe),l(wn),l(De),l(Mn),l(Tn),l(y),l(Cn),l(j),l(kn),l(ee),l(Pn),l(Dn),l(N),l(Un),l(Zn),l(V),l(jn),l(F),l(In),l(X),l(Gn),l(B),l(Hn),l(R),l(Jn),l(E),l(Ln),l(Wn),l(vn)),l(o),v($,e),v(oe,e),v(Ue,e),v(Ze),v(je),v(Ie),v(Ge),v(se),v(He),v(ae),v(Je),v(Le),v(We),v(de),v(Se),v(fe),v(ce),v(Ne),v(Ve),v(Fe),v(me),v(he),v(Xe),v(ge),v(Be),v(be),v(_e),v(ve),v(Re),v(Ee),v(ze),v(Ye),v(qe),v(Ae),v(Qe),v(Oe,e),v(Ke),v(et),v(Me),v(tt,e),v(nt),v(ot),v(it),v(st),v(at),v(rt),v(lt,e)}}}const Zs='{"title":"Pipelines","local":"pipelines","sections":[{"title":"DiffusionPipeline","local":"diffusers.DiffusionPipeline","sections":[],"depth":2},{"title":"PushToHubMixin","local":"diffusers.utils.PushToHubMixin","sections":[],"depth":2},{"title":"Callbacks","local":"diffusers.callbacks.PipelineCallback","sections":[],"depth":2}],"depth":1}';function js(P){return ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ns extends us{constructor(o){super(),ms(this,o,js,Us,cs,{})}}export{Ns as component};
